import{s as Ha,o as Na,n as Ge}from"../chunks/scheduler.9bc65507.js";import{S as Xa,i as za,g as n,s as i,u as m,A as ja,h as l,f as t,c as r,j as c,v,y as d,k as u,o as p,a,w as g,d as y,t as w,x as b}from"../chunks/index.78c82d43.js";import{T as Fe}from"../chunks/Tip.87d55b76.js";import{I as x}from"../chunks/IconCopyLink.bedaa44d.js";import{C as bo}from"../chunks/CodeBlock.73e038be.js";function Ea(T){let s,f='If you don’t need long explanations and just want TPU code samples to get started with, check out <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">our TPU example notebook!</a>';return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-tduf4j"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Sa(T){let s,f="If you can fit all your data in memory as <code>np.ndarray</code> or <code>tf.Tensor</code>, then you can <code>fit()</code> on that data even when using Colab or a TPU Node, without needing to upload it to Google Cloud Storage.";return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1d1yaza"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Wa(T){let s,f="<strong>🤗Specific Hugging Face Tip🤗:</strong> The methods <code>Dataset.to_tf_dataset()</code> and its higher-level wrapper <code>model.prepare_tf_dataset()</code> , which you will see throughout our TF code examples, will both fail on a TPU Node. The reason for this is that even though they create a <code>tf.data.Dataset</code> it is not a “pure” <code>tf.data</code> pipeline and uses <code>tf.numpy_function</code> or <code>Dataset.from_generator()</code> to stream data from the underlying HuggingFace <code>Dataset</code>. This HuggingFace <code>Dataset</code> is backed by data that is on a local disc and which the remote TPU Node will not be able to read.";return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1bprqrc"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Ja(T){let s,f="XLA compiled code is usually faster - so even if you’re not planning to run on TPU, adding <code>jit_compile=True</code> can improve your performance. Be sure to note the caveats below about XLA compatibility, though!";return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-kloc09"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Ia(T){let s,f="<strong>Tip born of painful experience:</strong> Although using <code>jit_compile=True</code> is a good way to get a speed boost and test if your CPU/GPU code is XLA-compatible, it can actually cause a lot of problems if you leave it in when actually training on TPU. XLA compilation will happen implicitly on TPU, so remember to remove that line before actually running your code on a TPU!";return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1br5bpw"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Fa(T){let s,f="<strong>🤗Specific HuggingFace Tip🤗:</strong> We’ve put a lot of effort into rewriting our TensorFlow models and loss functions to be XLA-compatible. Our models and loss functions generally obey rule #1 and #2 by default, so you can skip over them if you’re using <code>transformers</code> models. Don’t forget about these rules when writing your own models and loss functions, though!";return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1nwr8e5"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Ga(T){let s,f="<strong>🤗Specific HuggingFace Tip🤗:</strong> Our tokenizers and data collators have methods that can help you here. You can use <code>padding=&quot;max_length&quot;</code> or <code>padding=&quot;longest&quot;</code> when calling tokenizers to get them to output padded data. Our tokenizers and data collators also have a <code>pad_to_multiple_of</code> argument that you can use to reduce the number of unique input shapes you see!";return{c(){s=n("p"),s.innerHTML=f},l(h){s=l(h,"P",{"data-svelte-h":!0}),d(s)!=="svelte-1sygm4v"&&(s.innerHTML=f)},m(h,$){a(h,s,$)},p:Ge,d(h){h&&t(s)}}}function Va(T){let s,f,h,$,_,z,tt,O,$o,Ve,Ho="Training on TPU with TensorFlow",gt,j,yt,k,E,ot,ee,To,Re,No="What is a TPU?",wt,te,Xo="A TPU is a <strong>Tensor Processing Unit.</strong> They are hardware designed by Google, which are used to greatly speed up the tensor computations within neural networks, much like GPUs. They can be used for both network training and inference. They are generally accessed through Google’s cloud services, but small TPUs can also be accessed directly for free through Google Colab and Kaggle Kernels.",bt,oe,zo='Because <a href="https://huggingface.co/blog/tensorflow-philosophy" rel="nofollow">all TensorFlow models in 🤗 Transformers are Keras models</a>, most of the methods in this document are generally applicable to TPU training for any Keras model! However, there are a few points that are specific to the HuggingFace ecosystem (hug-o-system?) of Transformers and Datasets, and we’ll make sure to flag them up when we get to them.',$t,P,S,at,ae,xo,Ye,jo="What kinds of TPU are available?",Tt,ne,Eo="New users are often very confused by the range of TPUs, and the different ways to access them. The first key distinction to understand is the difference between <strong>TPU Nodes</strong> and <strong>TPU VMs.</strong>",xt,le,So="When you use a <strong>TPU Node</strong>, you are effectively indirectly accessing a remote TPU. You will need a separate VM, which will initialize your network and data pipeline and then forward them to the remote node. When you use a TPU on Google Colab, you are accessing it in the <strong>TPU Node</strong> style.",_t,se,Wo="Using TPU Nodes can have some quite unexpected behaviour for people who aren’t used to them! In particular, because the TPU is located on a physically different system to the machine you’re running your Python code on, your data cannot be local to your machine - any data pipeline that loads from your machine’s internal storage will totally fail! Instead, data must be stored in Google Cloud Storage where your data pipeline can still access it, even when the pipeline is running on the remote TPU node.",kt,W,Pt,J,Mt,ie,Jo="The second way to access a TPU is via a <strong>TPU VM.</strong> When using a TPU VM, you connect directly to the machine that the TPU is attached to, much like training on a GPU VM. TPU VMs are generally easier to work with, particularly when it comes to your data pipeline. All of the above warnings do not apply to TPU VMs!",Ut,re,Io='This is an opinionated document, so here’s our opinion: <strong>Avoid using TPU Node if possible.</strong> It is more confusing and more difficult to debug than TPU VMs. It is also likely to be unsupported in future - Google’s latest TPU, TPUv4, can only be accessed as a TPU VM, which suggests that TPU Nodes are increasingly going to become a “legacy” access method. However, we understand that the only free TPU access is on Colab and Kaggle Kernels, which uses TPU Node - so we’ll try to explain how to handle it if you have to! Check the <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">TPU example notebook</a> for code samples that explain this in more detail.',Ct,M,I,nt,he,_o,Ze,Fo="What sizes of TPU are available?",At,ue,Go="A single TPU (a v2-8/v3-8/v4-8) runs 8 replicas. TPUs exist in <strong>pods</strong> that can run hundreds or thousands of replicas simultaneously. When you use more than a single TPU but less than a whole pod (for example, a v3-32), your TPU fleet is referred to as a <strong>pod slice.</strong>",Lt,pe,Vo="When you access a free TPU via Colab, you generally get a single v2-8 TPU.",Ht,U,F,lt,de,ko,qe,Ro="I keep hearing about this XLA thing. What’s XLA, and how does it relate to TPUs?",Nt,ce,Yo="XLA is an optimizing compiler, used by both TensorFlow and JAX. In JAX it is the only compiler, whereas in TensorFlow it is optional (but mandatory on TPU!). The easiest way to enable it when training a Keras model is to pass the argument <code>jit_compile=True</code> to <code>model.compile()</code>. If you don’t get any errors and performance is good, that’s a great sign that you’re ready to move to TPU!",Xt,fe,Zo="Debugging on TPU is generally a bit harder than on CPU/GPU, so we recommend getting your code running on CPU/GPU with XLA first before trying it on TPU. You don’t have to train for long, of course - just for a few steps to make sure that your model and data pipeline are working like you expect them to.",zt,G,jt,V,Et,C,R,st,me,Po,Be,qo="How do I make my model XLA compatible?",St,ve,Bo="In many cases, your code is probably XLA-compatible already! However, there are a few things that work in normal TensorFlow that don’t work in XLA. We’ve distilled them into three core rules below:",Wt,Y,Jt,A,Z,it,ge,Mo,De,Do="XLA Rule #1: Your code cannot have “data-dependent conditionals”",It,ye,Ko="What that means is that any <code>if</code> statement cannot depend on values inside a <code>tf.Tensor</code>. For example, this code block cannot be compiled with XLA!",Ft,we,Gt,be,Qo='This might seem very restrictive at first, but most neural net code doesn’t need to do this. You can often get around this restriction by using <code>tf.cond</code> (see the documentation <a href="https://www.tensorflow.org/api_docs/python/tf/cond" rel="nofollow">here</a>) or by removing the conditional and finding a clever math trick with indicator variables instead, like so:',Vt,$e,Rt,Te,Oo="This code has exactly the same effect as the code above, but by avoiding a conditional, we ensure it will compile with XLA without problems!",Yt,L,q,rt,xe,Uo,Ke,ea="XLA Rule #2: Your code cannot have “data-dependent shapes”",Zt,_e,ta="What this means is that the shape of all of the <code>tf.Tensor</code> objects in your code cannot depend on their values. For example, the function <code>tf.unique</code> cannot be compiled with XLA, because it returns a <code>tensor</code> containing one instance of each unique value in the input. The shape of this output will obviously be different depending on how repetitive the input <code>Tensor</code> was, and so XLA refuses to handle it!",qt,ke,oa='In general, most neural network code obeys rule #2 by default. However, there are a few common cases where it becomes a problem. One very common one is when you use <strong>label masking</strong>, setting your labels to a negative value to indicate that those positions should be ignored when computing the loss. If you look at NumPy or PyTorch loss functions that support label masking, you will often see code like this that uses <a href="https://numpy.org/doc/stable/user/basics.indexing.html#boolean-array-indexing" rel="nofollow">boolean indexing</a>:',Bt,Pe,Dt,Me,aa="This code is totally fine in NumPy or PyTorch, but it breaks in XLA! Why? Because the shape of <code>masked_outputs</code> and <code>masked_labels</code> depends on how many positions are masked - that makes it a <strong>data-dependent shape.</strong> However, just like for rule #1, we can often rewrite this code to yield exactly the same output without any data-dependent shapes.",Kt,Ue,Qt,Ce,na="Here, we avoid data-dependent shapes by computing the loss for every position, but zeroing out the masked positions in both the numerator and denominator when we calculate the mean, which yields exactly the same result as the first block while maintaining XLA compatibility. Note that we use the same trick as in rule #1 - converting a <code>tf.bool</code> to <code>tf.float32</code> and using it as an indicator variable. This is a really useful trick, so remember it if you need to convert your own code to XLA!",Ot,H,B,ht,Ae,Co,Qe,la="XLA Rule #3: XLA will need to recompile your model for every different input shape it sees",eo,Le,sa="This is the big one. What this means is that if your input shapes are very variable, XLA will have to recompile your model over and over, which will create huge performance problems. This commonly arises in NLP models, where input texts have variable lengths after tokenization. In other modalities, static shapes are more common and this rule is much less of a problem.",to,He,ia="How can you get around rule #3? The key is <strong>padding</strong> - if you pad all your inputs to the same length, and then use an <code>attention_mask</code>, you can get the same results as you’d get from variable shapes, but without any XLA issues. However, excessive padding can cause severe slowdown too - if you pad all your samples to the maximum length in the whole dataset, you might end up with batches consisting endless padding tokens, which will waste a lot of compute and memory!",oo,Ne,ra="There isn’t a perfect solution to this problem. However, you can try some tricks. One very useful trick is to <strong>pad batches of samples up to a multiple of a number like 32 or 64 tokens.</strong> This often only increases the number of tokens by a small amount, but it hugely reduces the number of unique input shapes, because every input shape now has to be a multiple of 32 or 64. Fewer unique input shapes means fewer XLA compilations!",ao,D,no,N,K,ut,Xe,Ao,Oe,ha="How do I actually train my model on TPU?",lo,ze,ua='Once your training is XLA-compatible and (if you’re using TPU Node / Colab) your dataset has been prepared appropriately, running on TPU is surprisingly easy! All you really need to change in your code is to add a few lines to initialize your TPU, and to ensure that your model and dataset are created inside a <code>TPUStrategy</code> scope. Take a look at <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">our TPU example notebook</a> to see this in action!',so,X,Q,pt,je,Lo,et,pa="Summary",io,Ee,da="There was a lot in here, so let’s summarize with a quick checklist you can follow when you want to get your model ready for TPU training:",ro,Se,ca='<li>Make sure your code follows the three rules of XLA</li> <li>Compile your model with <code>jit_compile=True</code> on CPU/GPU and confirm that you can train it with XLA</li> <li>Either load your dataset into memory or use a TPU-compatible dataset loading approach (see <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">notebook</a>)</li> <li>Migrate your code either to Colab (with accelerator set to “TPU”) or a TPU VM on Google Cloud</li> <li>Add TPU initializer code (see <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">notebook</a>)</li> <li>Create your <code>TPUStrategy</code> and make sure dataset loading and model creation are inside the <code>strategy.scope()</code> (see <a href="https://colab.research.google.com/github/huggingface/notebooks/blob/main/examples/tpu_training-tf.ipynb" rel="nofollow">notebook</a>)</li> <li>Don’t forget to take <code>jit_compile=True</code> out again when you move to TPU!</li> <li>🙏🙏🙏🥺🥺🥺</li> <li>Call model.fit()</li> <li>You did it!</li>',ho,dt,uo;return O=new x({}),j=new Fe({props:{$$slots:{default:[Ea]},$$scope:{ctx:T}}}),ee=new x({}),ae=new x({}),W=new Fe({props:{$$slots:{default:[Sa]},$$scope:{ctx:T}}}),J=new Fe({props:{$$slots:{default:[Wa]},$$scope:{ctx:T}}}),he=new x({}),de=new x({}),G=new Fe({props:{$$slots:{default:[Ja]},$$scope:{ctx:T}}}),V=new Fe({props:{warning:!0,$$slots:{default:[Ia]},$$scope:{ctx:T}}}),me=new x({}),Y=new Fe({props:{$$slots:{default:[Fa]},$$scope:{ctx:T}}}),ge=new x({}),we=new bo({props:{code:"aWYlMjB0Zi5yZWR1Y2Vfc3VtKHRlbnNvciklMjAlM0UlMjAxMCUzQSUwQSUyMCUyMCUyMCUyMHRlbnNvciUyMCUzRCUyMHRlbnNvciUyMCUyRiUyMDIuMA==",highlighted:`<span class="hljs-keyword">if</span> tf.reduce_sum(tensor) &gt; <span class="hljs-number">10</span>:
    tensor = tensor / <span class="hljs-number">2.0</span>`,wrap:!1}}),$e=new bo({props:{code:"c3VtX292ZXJfMTAlMjAlM0QlMjB0Zi5jYXN0KHRmLnJlZHVjZV9zdW0odGVuc29yKSUyMCUzRSUyMDEwJTJDJTIwdGYuZmxvYXQzMiklMEF0ZW5zb3IlMjAlM0QlMjB0ZW5zb3IlMjAlMkYlMjAoMS4wJTIwJTJCJTIwc3VtX292ZXJfMTAp",highlighted:`sum_over_10 = tf.cast(tf.reduce_sum(tensor) &gt; <span class="hljs-number">10</span>, tf.float32)
tensor = tensor / (<span class="hljs-number">1.0</span> + sum_over_10)`,wrap:!1}}),xe=new x({}),Pe=new bo({props:{code:"bGFiZWxfbWFzayUyMCUzRCUyMGxhYmVscyUyMCUzRSUzRCUyMDAlMEFtYXNrZWRfb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMlNUJsYWJlbF9tYXNrJTVEJTBBbWFza2VkX2xhYmVscyUyMCUzRCUyMGxhYmVscyU1QmxhYmVsX21hc2slNUQlMEFsb3NzJTIwJTNEJTIwY29tcHV0ZV9sb3NzKG1hc2tlZF9vdXRwdXRzJTJDJTIwbWFza2VkX2xhYmVscyklMEFtZWFuX2xvc3MlMjAlM0QlMjB0b3JjaC5tZWFuKGxvc3Mp",highlighted:`label_mask = labels &gt;= <span class="hljs-number">0</span>
masked_outputs = outputs[label_mask]
masked_labels = labels[label_mask]
loss = compute_loss(masked_outputs, masked_labels)
mean_loss = torch.mean(loss)`,wrap:!1}}),Ue=new bo({props:{code:"bGFiZWxfbWFzayUyMCUzRCUyMHRmLmNhc3QobGFiZWxzJTIwJTNFJTNEJTIwMCUyQyUyMHRmLmZsb2F0MzIpJTBBbG9zcyUyMCUzRCUyMGNvbXB1dGVfbG9zcyhvdXRwdXRzJTJDJTIwbGFiZWxzKSUwQWxvc3MlMjAlM0QlMjBsb3NzJTIwKiUyMGxhYmVsX21hc2slMjAlMjAlMjMlMjBTZXQlMjBuZWdhdGl2ZSUyMGxhYmVsJTIwcG9zaXRpb25zJTIwdG8lMjAwJTBBbWVhbl9sb3NzJTIwJTNEJTIwdGYucmVkdWNlX3N1bShsb3NzKSUyMCUyRiUyMHRmLnJlZHVjZV9zdW0obGFiZWxfbWFzayk=",highlighted:`label_mask = tf.cast(labels &gt;= <span class="hljs-number">0</span>, tf.float32)
loss = compute_loss(outputs, labels)
loss = loss * label_mask  <span class="hljs-comment"># Set negative label positions to 0</span>
mean_loss = tf.reduce_sum(loss) / tf.reduce_sum(label_mask)`,wrap:!1}}),Ae=new x({}),D=new Fe({props:{$$slots:{default:[Ga]},$$scope:{ctx:T}}}),Xe=new x({}),je=new x({}),{c(){s=n("meta"),f=i(),h=n("p"),$=i(),_=n("h1"),z=n("a"),tt=n("span"),m(O.$$.fragment),$o=i(),Ve=n("span"),Ve.textContent=Ho,gt=i(),m(j.$$.fragment),yt=i(),k=n("h3"),E=n("a"),ot=n("span"),m(ee.$$.fragment),To=i(),Re=n("span"),Re.textContent=No,wt=i(),te=n("p"),te.innerHTML=Xo,bt=i(),oe=n("p"),oe.innerHTML=zo,$t=i(),P=n("h3"),S=n("a"),at=n("span"),m(ae.$$.fragment),xo=i(),Ye=n("span"),Ye.textContent=jo,Tt=i(),ne=n("p"),ne.innerHTML=Eo,xt=i(),le=n("p"),le.innerHTML=So,_t=i(),se=n("p"),se.textContent=Wo,kt=i(),m(W.$$.fragment),Pt=i(),m(J.$$.fragment),Mt=i(),ie=n("p"),ie.innerHTML=Jo,Ut=i(),re=n("p"),re.innerHTML=Io,Ct=i(),M=n("h3"),I=n("a"),nt=n("span"),m(he.$$.fragment),_o=i(),Ze=n("span"),Ze.textContent=Fo,At=i(),ue=n("p"),ue.innerHTML=Go,Lt=i(),pe=n("p"),pe.textContent=Vo,Ht=i(),U=n("h3"),F=n("a"),lt=n("span"),m(de.$$.fragment),ko=i(),qe=n("span"),qe.textContent=Ro,Nt=i(),ce=n("p"),ce.innerHTML=Yo,Xt=i(),fe=n("p"),fe.textContent=Zo,zt=i(),m(G.$$.fragment),jt=i(),m(V.$$.fragment),Et=i(),C=n("h3"),R=n("a"),st=n("span"),m(me.$$.fragment),Po=i(),Be=n("span"),Be.textContent=qo,St=i(),ve=n("p"),ve.textContent=Bo,Wt=i(),m(Y.$$.fragment),Jt=i(),A=n("h4"),Z=n("a"),it=n("span"),m(ge.$$.fragment),Mo=i(),De=n("span"),De.textContent=Do,It=i(),ye=n("p"),ye.innerHTML=Ko,Ft=i(),m(we.$$.fragment),Gt=i(),be=n("p"),be.innerHTML=Qo,Vt=i(),m($e.$$.fragment),Rt=i(),Te=n("p"),Te.textContent=Oo,Yt=i(),L=n("h4"),q=n("a"),rt=n("span"),m(xe.$$.fragment),Uo=i(),Ke=n("span"),Ke.textContent=ea,Zt=i(),_e=n("p"),_e.innerHTML=ta,qt=i(),ke=n("p"),ke.innerHTML=oa,Bt=i(),m(Pe.$$.fragment),Dt=i(),Me=n("p"),Me.innerHTML=aa,Kt=i(),m(Ue.$$.fragment),Qt=i(),Ce=n("p"),Ce.innerHTML=na,Ot=i(),H=n("h4"),B=n("a"),ht=n("span"),m(Ae.$$.fragment),Co=i(),Qe=n("span"),Qe.textContent=la,eo=i(),Le=n("p"),Le.textContent=sa,to=i(),He=n("p"),He.innerHTML=ia,oo=i(),Ne=n("p"),Ne.innerHTML=ra,ao=i(),m(D.$$.fragment),no=i(),N=n("h3"),K=n("a"),ut=n("span"),m(Xe.$$.fragment),Ao=i(),Oe=n("span"),Oe.textContent=ha,lo=i(),ze=n("p"),ze.innerHTML=ua,so=i(),X=n("h3"),Q=n("a"),pt=n("span"),m(je.$$.fragment),Lo=i(),et=n("span"),et.textContent=pa,io=i(),Ee=n("p"),Ee.textContent=da,ro=i(),Se=n("ul"),Se.innerHTML=ca,ho=i(),dt=n("p"),this.h()},l(e){const o=ja("svelte-1phssyn",document.head);s=l(o,"META",{name:!0,content:!0}),o.forEach(t),f=r(e),h=l(e,"P",{}),c(h).forEach(t),$=r(e),_=l(e,"H1",{class:!0});var We=c(_);z=l(We,"A",{id:!0,class:!0,href:!0});var ct=c(z);tt=l(ct,"SPAN",{});var ft=c(tt);v(O.$$.fragment,ft),ft.forEach(t),ct.forEach(t),$o=r(We),Ve=l(We,"SPAN",{"data-svelte-h":!0}),d(Ve)!=="svelte-19i9ofa"&&(Ve.textContent=Ho),We.forEach(t),gt=r(e),v(j.$$.fragment,e),yt=r(e),k=l(e,"H3",{class:!0});var Je=c(k);E=l(Je,"A",{id:!0,class:!0,href:!0});var mt=c(E);ot=l(mt,"SPAN",{});var vt=c(ot);v(ee.$$.fragment,vt),vt.forEach(t),mt.forEach(t),To=r(Je),Re=l(Je,"SPAN",{"data-svelte-h":!0}),d(Re)!=="svelte-aqsm9c"&&(Re.textContent=No),Je.forEach(t),wt=r(e),te=l(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-djnvv2"&&(te.innerHTML=Xo),bt=r(e),oe=l(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1unj2fz"&&(oe.innerHTML=zo),$t=r(e),P=l(e,"H3",{class:!0});var Ie=c(P);S=l(Ie,"A",{id:!0,class:!0,href:!0});var fa=c(S);at=l(fa,"SPAN",{});var ma=c(at);v(ae.$$.fragment,ma),ma.forEach(t),fa.forEach(t),xo=r(Ie),Ye=l(Ie,"SPAN",{"data-svelte-h":!0}),d(Ye)!=="svelte-1wcz2pq"&&(Ye.textContent=jo),Ie.forEach(t),Tt=r(e),ne=l(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-6p7mr8"&&(ne.innerHTML=Eo),xt=r(e),le=l(e,"P",{"data-svelte-h":!0}),d(le)!=="svelte-1phfib"&&(le.innerHTML=So),_t=r(e),se=l(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-soktmv"&&(se.textContent=Wo),kt=r(e),v(W.$$.fragment,e),Pt=r(e),v(J.$$.fragment,e),Mt=r(e),ie=l(e,"P",{"data-svelte-h":!0}),d(ie)!=="svelte-1phs7bc"&&(ie.innerHTML=Jo),Ut=r(e),re=l(e,"P",{"data-svelte-h":!0}),d(re)!=="svelte-1pt1vxc"&&(re.innerHTML=Io),Ct=r(e),M=l(e,"H3",{class:!0});var po=c(M);I=l(po,"A",{id:!0,class:!0,href:!0});var va=c(I);nt=l(va,"SPAN",{});var ga=c(nt);v(he.$$.fragment,ga),ga.forEach(t),va.forEach(t),_o=r(po),Ze=l(po,"SPAN",{"data-svelte-h":!0}),d(Ze)!=="svelte-1o90lah"&&(Ze.textContent=Fo),po.forEach(t),At=r(e),ue=l(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-16dbnw4"&&(ue.innerHTML=Go),Lt=r(e),pe=l(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-f2jblb"&&(pe.textContent=Vo),Ht=r(e),U=l(e,"H3",{class:!0});var co=c(U);F=l(co,"A",{id:!0,class:!0,href:!0});var ya=c(F);lt=l(ya,"SPAN",{});var wa=c(lt);v(de.$$.fragment,wa),wa.forEach(t),ya.forEach(t),ko=r(co),qe=l(co,"SPAN",{"data-svelte-h":!0}),d(qe)!=="svelte-k6j9a0"&&(qe.textContent=Ro),co.forEach(t),Nt=r(e),ce=l(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1q4pey4"&&(ce.innerHTML=Yo),Xt=r(e),fe=l(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-h81hqx"&&(fe.textContent=Zo),zt=r(e),v(G.$$.fragment,e),jt=r(e),v(V.$$.fragment,e),Et=r(e),C=l(e,"H3",{class:!0});var fo=c(C);R=l(fo,"A",{id:!0,class:!0,href:!0});var ba=c(R);st=l(ba,"SPAN",{});var $a=c(st);v(me.$$.fragment,$a),$a.forEach(t),ba.forEach(t),Po=r(fo),Be=l(fo,"SPAN",{"data-svelte-h":!0}),d(Be)!=="svelte-az1ni"&&(Be.textContent=qo),fo.forEach(t),St=r(e),ve=l(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-rvk8af"&&(ve.textContent=Bo),Wt=r(e),v(Y.$$.fragment,e),Jt=r(e),A=l(e,"H4",{class:!0});var mo=c(A);Z=l(mo,"A",{id:!0,class:!0,href:!0});var Ta=c(Z);it=l(Ta,"SPAN",{});var xa=c(it);v(ge.$$.fragment,xa),xa.forEach(t),Ta.forEach(t),Mo=r(mo),De=l(mo,"SPAN",{"data-svelte-h":!0}),d(De)!=="svelte-1amqgn9"&&(De.textContent=Do),mo.forEach(t),It=r(e),ye=l(e,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-xcqbse"&&(ye.innerHTML=Ko),Ft=r(e),v(we.$$.fragment,e),Gt=r(e),be=l(e,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1t3ikym"&&(be.innerHTML=Qo),Vt=r(e),v($e.$$.fragment,e),Rt=r(e),Te=l(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1iv8hko"&&(Te.textContent=Oo),Yt=r(e),L=l(e,"H4",{class:!0});var vo=c(L);q=l(vo,"A",{id:!0,class:!0,href:!0});var _a=c(q);rt=l(_a,"SPAN",{});var ka=c(rt);v(xe.$$.fragment,ka),ka.forEach(t),_a.forEach(t),Uo=r(vo),Ke=l(vo,"SPAN",{"data-svelte-h":!0}),d(Ke)!=="svelte-1tpf5fb"&&(Ke.textContent=ea),vo.forEach(t),Zt=r(e),_e=l(e,"P",{"data-svelte-h":!0}),d(_e)!=="svelte-630pck"&&(_e.innerHTML=ta),qt=r(e),ke=l(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-johghx"&&(ke.innerHTML=oa),Bt=r(e),v(Pe.$$.fragment,e),Dt=r(e),Me=l(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-pihfmb"&&(Me.innerHTML=aa),Kt=r(e),v(Ue.$$.fragment,e),Qt=r(e),Ce=l(e,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-p1xarp"&&(Ce.innerHTML=na),Ot=r(e),H=l(e,"H4",{class:!0});var go=c(H);B=l(go,"A",{id:!0,class:!0,href:!0});var Pa=c(B);ht=l(Pa,"SPAN",{});var Ma=c(ht);v(Ae.$$.fragment,Ma),Ma.forEach(t),Pa.forEach(t),Co=r(go),Qe=l(go,"SPAN",{"data-svelte-h":!0}),d(Qe)!=="svelte-18f7oyd"&&(Qe.textContent=la),go.forEach(t),eo=r(e),Le=l(e,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-feimws"&&(Le.textContent=sa),to=r(e),He=l(e,"P",{"data-svelte-h":!0}),d(He)!=="svelte-1lvuw7u"&&(He.innerHTML=ia),oo=r(e),Ne=l(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-11hm17e"&&(Ne.innerHTML=ra),ao=r(e),v(D.$$.fragment,e),no=r(e),N=l(e,"H3",{class:!0});var yo=c(N);K=l(yo,"A",{id:!0,class:!0,href:!0});var Ua=c(K);ut=l(Ua,"SPAN",{});var Ca=c(ut);v(Xe.$$.fragment,Ca),Ca.forEach(t),Ua.forEach(t),Ao=r(yo),Oe=l(yo,"SPAN",{"data-svelte-h":!0}),d(Oe)!=="svelte-wdxlr2"&&(Oe.textContent=ha),yo.forEach(t),lo=r(e),ze=l(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-1snadym"&&(ze.innerHTML=ua),so=r(e),X=l(e,"H3",{class:!0});var wo=c(X);Q=l(wo,"A",{id:!0,class:!0,href:!0});var Aa=c(Q);pt=l(Aa,"SPAN",{});var La=c(pt);v(je.$$.fragment,La),La.forEach(t),Aa.forEach(t),Lo=r(wo),et=l(wo,"SPAN",{"data-svelte-h":!0}),d(et)!=="svelte-lnd84v"&&(et.textContent=pa),wo.forEach(t),io=r(e),Ee=l(e,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-d1lrdp"&&(Ee.textContent=da),ro=r(e),Se=l(e,"UL",{"data-svelte-h":!0}),d(Se)!=="svelte-1qs7tfb"&&(Se.innerHTML=ca),ho=r(e),dt=l(e,"P",{}),c(dt).forEach(t),this.h()},h(){u(s,"name","hf:doc:metadata"),u(s,"content",JSON.stringify(Ra)),u(z,"id","training-on-tpu-with-tensorflow"),u(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(z,"href","#training-on-tpu-with-tensorflow"),u(_,"class","relative group"),u(E,"id","what-is-a-tpu"),u(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(E,"href","#what-is-a-tpu"),u(k,"class","relative group"),u(S,"id","what-kinds-of-tpu-are-available"),u(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(S,"href","#what-kinds-of-tpu-are-available"),u(P,"class","relative group"),u(I,"id","what-sizes-of-tpu-are-available"),u(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(I,"href","#what-sizes-of-tpu-are-available"),u(M,"class","relative group"),u(F,"id","i-keep-hearing-about-this-xla-thing-whats-xla-and-how-does-it-relate-to-tpus"),u(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(F,"href","#i-keep-hearing-about-this-xla-thing-whats-xla-and-how-does-it-relate-to-tpus"),u(U,"class","relative group"),u(R,"id","how-do-i-make-my-model-xla-compatible"),u(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(R,"href","#how-do-i-make-my-model-xla-compatible"),u(C,"class","relative group"),u(Z,"id","xla-rule-1-your-code-cannot-have-datadependent-conditionals"),u(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Z,"href","#xla-rule-1-your-code-cannot-have-datadependent-conditionals"),u(A,"class","relative group"),u(q,"id","xla-rule-2-your-code-cannot-have-datadependent-shapes"),u(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(q,"href","#xla-rule-2-your-code-cannot-have-datadependent-shapes"),u(L,"class","relative group"),u(B,"id","xla-rule-3-xla-will-need-to-recompile-your-model-for-every-different-input-shape-it-sees"),u(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(B,"href","#xla-rule-3-xla-will-need-to-recompile-your-model-for-every-different-input-shape-it-sees"),u(H,"class","relative group"),u(K,"id","how-do-i-actually-train-my-model-on-tpu"),u(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(K,"href","#how-do-i-actually-train-my-model-on-tpu"),u(N,"class","relative group"),u(Q,"id","summary"),u(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),u(Q,"href","#summary"),u(X,"class","relative group")},m(e,o){p(document.head,s),a(e,f,o),a(e,h,o),a(e,$,o),a(e,_,o),p(_,z),p(z,tt),g(O,tt,null),p(_,$o),p(_,Ve),a(e,gt,o),g(j,e,o),a(e,yt,o),a(e,k,o),p(k,E),p(E,ot),g(ee,ot,null),p(k,To),p(k,Re),a(e,wt,o),a(e,te,o),a(e,bt,o),a(e,oe,o),a(e,$t,o),a(e,P,o),p(P,S),p(S,at),g(ae,at,null),p(P,xo),p(P,Ye),a(e,Tt,o),a(e,ne,o),a(e,xt,o),a(e,le,o),a(e,_t,o),a(e,se,o),a(e,kt,o),g(W,e,o),a(e,Pt,o),g(J,e,o),a(e,Mt,o),a(e,ie,o),a(e,Ut,o),a(e,re,o),a(e,Ct,o),a(e,M,o),p(M,I),p(I,nt),g(he,nt,null),p(M,_o),p(M,Ze),a(e,At,o),a(e,ue,o),a(e,Lt,o),a(e,pe,o),a(e,Ht,o),a(e,U,o),p(U,F),p(F,lt),g(de,lt,null),p(U,ko),p(U,qe),a(e,Nt,o),a(e,ce,o),a(e,Xt,o),a(e,fe,o),a(e,zt,o),g(G,e,o),a(e,jt,o),g(V,e,o),a(e,Et,o),a(e,C,o),p(C,R),p(R,st),g(me,st,null),p(C,Po),p(C,Be),a(e,St,o),a(e,ve,o),a(e,Wt,o),g(Y,e,o),a(e,Jt,o),a(e,A,o),p(A,Z),p(Z,it),g(ge,it,null),p(A,Mo),p(A,De),a(e,It,o),a(e,ye,o),a(e,Ft,o),g(we,e,o),a(e,Gt,o),a(e,be,o),a(e,Vt,o),g($e,e,o),a(e,Rt,o),a(e,Te,o),a(e,Yt,o),a(e,L,o),p(L,q),p(q,rt),g(xe,rt,null),p(L,Uo),p(L,Ke),a(e,Zt,o),a(e,_e,o),a(e,qt,o),a(e,ke,o),a(e,Bt,o),g(Pe,e,o),a(e,Dt,o),a(e,Me,o),a(e,Kt,o),g(Ue,e,o),a(e,Qt,o),a(e,Ce,o),a(e,Ot,o),a(e,H,o),p(H,B),p(B,ht),g(Ae,ht,null),p(H,Co),p(H,Qe),a(e,eo,o),a(e,Le,o),a(e,to,o),a(e,He,o),a(e,oo,o),a(e,Ne,o),a(e,ao,o),g(D,e,o),a(e,no,o),a(e,N,o),p(N,K),p(K,ut),g(Xe,ut,null),p(N,Ao),p(N,Oe),a(e,lo,o),a(e,ze,o),a(e,so,o),a(e,X,o),p(X,Q),p(Q,pt),g(je,pt,null),p(X,Lo),p(X,et),a(e,io,o),a(e,Ee,o),a(e,ro,o),a(e,Se,o),a(e,ho,o),a(e,dt,o),uo=!0},p(e,[o]){const We={};o&2&&(We.$$scope={dirty:o,ctx:e}),j.$set(We);const ct={};o&2&&(ct.$$scope={dirty:o,ctx:e}),W.$set(ct);const ft={};o&2&&(ft.$$scope={dirty:o,ctx:e}),J.$set(ft);const Je={};o&2&&(Je.$$scope={dirty:o,ctx:e}),G.$set(Je);const mt={};o&2&&(mt.$$scope={dirty:o,ctx:e}),V.$set(mt);const vt={};o&2&&(vt.$$scope={dirty:o,ctx:e}),Y.$set(vt);const Ie={};o&2&&(Ie.$$scope={dirty:o,ctx:e}),D.$set(Ie)},i(e){uo||(y(O.$$.fragment,e),y(j.$$.fragment,e),y(ee.$$.fragment,e),y(ae.$$.fragment,e),y(W.$$.fragment,e),y(J.$$.fragment,e),y(he.$$.fragment,e),y(de.$$.fragment,e),y(G.$$.fragment,e),y(V.$$.fragment,e),y(me.$$.fragment,e),y(Y.$$.fragment,e),y(ge.$$.fragment,e),y(we.$$.fragment,e),y($e.$$.fragment,e),y(xe.$$.fragment,e),y(Pe.$$.fragment,e),y(Ue.$$.fragment,e),y(Ae.$$.fragment,e),y(D.$$.fragment,e),y(Xe.$$.fragment,e),y(je.$$.fragment,e),uo=!0)},o(e){w(O.$$.fragment,e),w(j.$$.fragment,e),w(ee.$$.fragment,e),w(ae.$$.fragment,e),w(W.$$.fragment,e),w(J.$$.fragment,e),w(he.$$.fragment,e),w(de.$$.fragment,e),w(G.$$.fragment,e),w(V.$$.fragment,e),w(me.$$.fragment,e),w(Y.$$.fragment,e),w(ge.$$.fragment,e),w(we.$$.fragment,e),w($e.$$.fragment,e),w(xe.$$.fragment,e),w(Pe.$$.fragment,e),w(Ue.$$.fragment,e),w(Ae.$$.fragment,e),w(D.$$.fragment,e),w(Xe.$$.fragment,e),w(je.$$.fragment,e),uo=!1},d(e){e&&(t(f),t(h),t($),t(_),t(gt),t(yt),t(k),t(wt),t(te),t(bt),t(oe),t($t),t(P),t(Tt),t(ne),t(xt),t(le),t(_t),t(se),t(kt),t(Pt),t(Mt),t(ie),t(Ut),t(re),t(Ct),t(M),t(At),t(ue),t(Lt),t(pe),t(Ht),t(U),t(Nt),t(ce),t(Xt),t(fe),t(zt),t(jt),t(Et),t(C),t(St),t(ve),t(Wt),t(Jt),t(A),t(It),t(ye),t(Ft),t(Gt),t(be),t(Vt),t(Rt),t(Te),t(Yt),t(L),t(Zt),t(_e),t(qt),t(ke),t(Bt),t(Dt),t(Me),t(Kt),t(Qt),t(Ce),t(Ot),t(H),t(eo),t(Le),t(to),t(He),t(oo),t(Ne),t(ao),t(no),t(N),t(lo),t(ze),t(so),t(X),t(io),t(Ee),t(ro),t(Se),t(ho),t(dt)),t(s),b(O),b(j,e),b(ee),b(ae),b(W,e),b(J,e),b(he),b(de),b(G,e),b(V,e),b(me),b(Y,e),b(ge),b(we,e),b($e,e),b(xe),b(Pe,e),b(Ue,e),b(Ae),b(D,e),b(Xe),b(je)}}}const Ra={local:"training-on-tpu-with-tensorflow",sections:[{local:"what-is-a-tpu",title:"What is a TPU?"},{local:"what-kinds-of-tpu-are-available",title:"What kinds of TPU are available?"},{local:"what-sizes-of-tpu-are-available",title:"What sizes of TPU are available?"},{local:"i-keep-hearing-about-this-xla-thing-whats-xla-and-how-does-it-relate-to-tpus",title:"I keep hearing about this XLA thing. What’s XLA, and how does it relate to TPUs?"},{local:"how-do-i-make-my-model-xla-compatible",sections:[{local:"xla-rule-1-your-code-cannot-have-datadependent-conditionals",title:"XLA Rule #1: Your code cannot have “data-dependent conditionals”"},{local:"xla-rule-2-your-code-cannot-have-datadependent-shapes",title:"XLA Rule #2: Your code cannot have “data-dependent shapes”"},{local:"xla-rule-3-xla-will-need-to-recompile-your-model-for-every-different-input-shape-it-sees",title:"XLA Rule #3: XLA will need to recompile your model for every different input shape it sees"}],title:"How do I make my model XLA compatible?"},{local:"how-do-i-actually-train-my-model-on-tpu",title:"How do I actually train my model on TPU?"},{local:"summary",title:"Summary"}],title:"Training on TPU with TensorFlow"};function Ya(T){return Na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends Xa{constructor(s){super(),za(this,s,Ya,Va,Ha,{})}}export{Qa as component};
