import{s as nt,f as va,n as lt,o as it}from"../chunks/scheduler.9bc65507.js";import{S as pt,i as mt,g as n,s as i,u as K,m as h,H as f,A as ot,h as l,f as a,c as p,j as r,v as D,y as c,n as d,B as v,k as o,o as m,a as e,w as O,d as ss,t as as,x as ts}from"../chunks/index.78c82d43.js";import{I as ba}from"../chunks/IconCopyLink.bedaa44d.js";import{C as xa}from"../chunks/CodeBlock.73e038be.js";import{D as rt}from"../chunks/DocNotebookDropdown.31840a23.js";function ct(Ma){let b,gs,os,us,x,_,rs,G,ca,es,ka="Perplexity of fixed-length models",ys,Z,ws,B,_a=`Perplexity (PPL) is one of the most common metrics for evaluating language models. Before diving in, we should note
that the metric applies specifically to classical language models (sometimes called autoregressive or causal language
models) and is not well defined for masked language models like BERT (see <a href="model_summary">summary of the models</a>).`,fs,y,ha,vs,Qa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi>x</mi><mn>0</mn></msub><mo separator="true">,</mo><msub><mi>x</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">X = (x_0, x_1, \\dots, x_t)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',bs,xs,Ya='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex">X</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',Ms,ks,ns,_s,Fa='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>PPL</mtext><mo stretchy="false">(</mo><mi>X</mi><mo stretchy="false">)</mo><mo>=</mo><mi>exp</mi><mo>⁡</mo><mrow><mo fence="true">{</mo><mrow><mo>−</mo><mfrac><mn>1</mn><mi>t</mi></mfrac><munderover><mo>∑</mo><mi>i</mi><mi>t</mi></munderover><mi>log</mi><mo>⁡</mo><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub><mo stretchy="false">)</mo></mrow><mo fence="true">}</mo></mrow></mrow><annotation encoding="application/x-tex">\\text{PPL}(X) = \\exp \\left\\{ {-\\frac{1}{t}\\sum_i^t \\log p_\\theta (x_i|x_{&lt;i}) } \\right\\}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">PPL</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.0582em;vertical-align:-1.2777em;"></span><span class="mop">exp</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">{</span></span><span class="mord"><span class="mord">−</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal">t</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7806em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size4">}</span></span></span></span></span></span></span>',Ts,w,da,Js,Ka='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>log</mi><mo>⁡</mo><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\log p_\\theta (x_i|x_{&lt;i})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Us,js,Da='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub></mrow><annotation encoding="application/x-tex">x_{&lt;i}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6079em;vertical-align:-0.1774em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span></span></span></span>',Cs,zs,P,Ta=`This is also equivalent to the exponentiation of the cross-entropy between the data and model predictions. For more
intuition about perplexity and its relationship to Bits Per Character (BPC) and data compression, check out this
<a href="https://thegradient.pub/understanding-evaluation-metrics-for-language-models/" rel="nofollow">fantastic blog post on The Gradient</a>.`,Is,M,T,cs,E,ga,ls,Ja="Calculating PPL with fixed-length models",Gs,W,Ua=`If we weren’t limited by a model’s context size, we would evaluate the model’s perplexity by autoregressively
factorizing a sequence and conditioning on the entire preceding subsequence at each step, as shown below.`,Zs,J,ja,Bs,g,ua,$,Ca="GPT-2",ya,Ps,Oa='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>t</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>t</mi></mrow></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_\\theta(x_t|x_{&lt;t})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Es,Ws,st='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi></mrow><annotation encoding="application/x-tex">t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6151em;"></span><span class="mord mathnormal">t</span></span></span></span>',$s,Xs,u,wa,qs,at='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi></mrow><annotation encoding="application/x-tex">k</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span></span></span></span>',Ns,As,tt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>t</mi></msub></mrow><annotation encoding="application/x-tex">x_t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Hs,Ls,et='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi><mo>−</mo><mn>1</mn></mrow><annotation encoding="application/x-tex">k-1</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.0833em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Rs,Vs,U,za,Ss,X,Ia=`This is quick to compute since the perplexity of each segment can be computed in one forward pass, but serves as a poor
approximation of the fully-factorized perplexity and will typically yield a higher (worse) PPL because the model will
have less context at most of the prediction steps.`,Qs,q,Ga=`Instead, the PPL of fixed-length models should be evaluated with a sliding-window strategy. This involves repeatedly
sliding the context window so that the model has more context when making each prediction.`,Ys,j,Za,Fs,N,Ba=`This is a closer approximation to the true decomposition of the sequence probability and will typically yield a more
favorable score. The downside is that it requires a separate forward pass for each token in the corpus. A good
practical compromise is to employ a strided sliding window, moving the context by larger strides rather than sliding by
1 token a time. This allows computation to proceed much faster while still giving the model a large context to make
predictions at each step.`,Ks,k,C,hs,A,fa,is,Pa="Example: Calculating perplexity with GPT-2 in 🤗 Transformers",Ds,H,Ea="Let’s demonstrate this process with GPT-2.",Os,L,sa,R,Wa=`We’ll load in the WikiText-2 dataset and evaluate the perplexity using a few different sliding-window strategies. Since
this dataset is small and we’re just doing one forward pass over the set, we can just load and encode the entire
dataset in memory.`,aa,V,ta,S,$a=`With 🤗 Transformers, we can simply pass the <code>input_ids</code> as the <code>labels</code> to our model, and the average negative
log-likelihood for each token is returned as the loss. With our sliding window approach, however, there is overlap in
the tokens we pass to the model at each iteration. We don’t want the log-likelihood for the tokens we’re just treating
as context to be included in our loss, so we can set these targets to <code>-100</code> so that they are ignored. The following
is an example of how we could do this with a stride of <code>512</code>. This means that the model will have at least 512 tokens
for context when calculating the conditional likelihood of any one token (provided there are 512 preceding tokens
available to condition on).`,ea,Q,na,Y,Xa=`Running this with the stride length equal to the max input length is equivalent to the suboptimal, non-sliding-window
strategy we discussed above. The smaller the stride, the more context the model will have in making each prediction,
and the better the reported perplexity will typically be.`,la,F,qa=`When we run the above with <code>stride = 1024</code>, i.e. no overlap, the resulting PPL is <code>19.44</code>, which is about the same
as the <code>19.93</code> reported in the GPT-2 paper. By using <code>stride = 512</code> and thereby employing our striding window
strategy, this jumps down to <code>16.45</code>. This is not only a more favorable score, but is calculated in a way that is
closer to the true autoregressive decomposition of a sequence likelihood.`,ia,ds,pa;return G=new ba({}),Z=new rt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/perplexity.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/perplexity.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/perplexity.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/perplexity.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/perplexity.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/perplexity.ipynb"}]}}),E=new ba({}),A=new ba({}),L=new xa({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJMTUhlYWRNb2RlbCUyQyUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ3B0Mi1sYXJnZSUyMiUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCkudG8oZGV2aWNlKSUwQXRva2VuaXplciUyMCUzRCUyMEdQVDJUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2LMHeadModel, GPT2TokenizerFast

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id = <span class="hljs-string">&quot;gpt2-large&quot;</span>
model = GPT2LMHeadModel.from_pretrained(model_id).to(device)
tokenizer = GPT2TokenizerFast.from_pretrained(model_id)`,wrap:!1}}),V=new xa({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdGVzdCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMCUyMndpa2l0ZXh0LTItcmF3LXYxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKSUwQWVuY29kaW5ncyUyMCUzRCUyMHRva2VuaXplciglMjIlNUNuJTVDbiUyMi5qb2luKHRlc3QlNUIlMjJ0ZXh0JTIyJTVEKSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

test = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
encodings = tokenizer(<span class="hljs-string">&quot;\\n\\n&quot;</span>.join(test[<span class="hljs-string">&quot;text&quot;</span>]), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Q=new xa({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHFkbSUyMGltcG9ydCUyMHRxZG0lMEElMEFtYXhfbGVuZ3RoJTIwJTNEJTIwbW9kZWwuY29uZmlnLm5fcG9zaXRpb25zJTBBc3RyaWRlJTIwJTNEJTIwNTEyJTBBc2VxX2xlbiUyMCUzRCUyMGVuY29kaW5ncy5pbnB1dF9pZHMuc2l6ZSgxKSUwQSUwQW5sbHMlMjAlM0QlMjAlNUIlNUQlMEFwcmV2X2VuZF9sb2MlMjAlM0QlMjAwJTBBZm9yJTIwYmVnaW5fbG9jJTIwaW4lMjB0cWRtKHJhbmdlKDAlMkMlMjBzZXFfbGVuJTJDJTIwc3RyaWRlKSklM0ElMEElMjAlMjAlMjAlMjBlbmRfbG9jJTIwJTNEJTIwbWluKGJlZ2luX2xvYyUyMCUyQiUyMG1heF9sZW5ndGglMkMlMjBzZXFfbGVuKSUwQSUyMCUyMCUyMCUyMHRyZ19sZW4lMjAlM0QlMjBlbmRfbG9jJTIwLSUyMHByZXZfZW5kX2xvYyUyMCUyMCUyMyUyMG1heSUyMGJlJTIwZGlmZmVyZW50JTIwZnJvbSUyMHN0cmlkZSUyMG9uJTIwbGFzdCUyMGxvb3AlMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjBlbmNvZGluZ3MuaW5wdXRfaWRzJTVCJTNBJTJDJTIwYmVnaW5fbG9jJTNBZW5kX2xvYyU1RC50byhkZXZpY2UpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X2lkcyUyMCUzRCUyMGlucHV0X2lkcy5jbG9uZSgpJTBBJTIwJTIwJTIwJTIwdGFyZ2V0X2lkcyU1QiUzQSUyQyUyMCUzQS10cmdfbGVuJTVEJTIwJTNEJTIwLTEwMCUwQSUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzJTJDJTIwbGFiZWxzJTNEdGFyZ2V0X2lkcyklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBsb3NzJTIwaXMlMjBjYWxjdWxhdGVkJTIwdXNpbmclMjBDcm9zc0VudHJvcHlMb3NzJTIwd2hpY2glMjBhdmVyYWdlcyUyMG92ZXIlMjB2YWxpZCUyMGxhYmVscyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME4uQi4lMjB0aGUlMjBtb2RlbCUyMG9ubHklMjBjYWxjdWxhdGVzJTIwbG9zcyUyMG92ZXIlMjB0cmdfbGVuJTIwLSUyMDElMjBsYWJlbHMlMkMlMjBiZWNhdXNlJTIwaXQlMjBpbnRlcm5hbGx5JTIwc2hpZnRzJTIwdGhlJTIwbGFiZWxzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwdG8lMjB0aGUlMjBsZWZ0JTIwYnklMjAxLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5lZ19sb2dfbGlrZWxpaG9vZCUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUwQSUyMCUyMCUyMCUyMG5sbHMuYXBwZW5kKG5lZ19sb2dfbGlrZWxpaG9vZCklMEElMEElMjAlMjAlMjAlMjBwcmV2X2VuZF9sb2MlMjAlM0QlMjBlbmRfbG9jJTBBJTIwJTIwJTIwJTIwaWYlMjBlbmRfbG9jJTIwJTNEJTNEJTIwc2VxX2xlbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJyZWFrJTBBJTBBcHBsJTIwJTNEJTIwdG9yY2guZXhwKHRvcmNoLnN0YWNrKG5sbHMpLm1lYW4oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

max_length = model.config.n_positions
stride = <span class="hljs-number">512</span>
seq_len = encodings.input_ids.size(<span class="hljs-number">1</span>)

nlls = []
prev_end_loc = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> begin_loc <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, seq_len, stride)):
    end_loc = <span class="hljs-built_in">min</span>(begin_loc + max_length, seq_len)
    trg_len = end_loc - prev_end_loc  <span class="hljs-comment"># may be different from stride on last loop</span>
    input_ids = encodings.input_ids[:, begin_loc:end_loc].to(device)
    target_ids = input_ids.clone()
    target_ids[:, :-trg_len] = -<span class="hljs-number">100</span>

    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(input_ids, labels=target_ids)

        <span class="hljs-comment"># loss is calculated using CrossEntropyLoss which averages over valid labels</span>
        <span class="hljs-comment"># N.B. the model only calculates loss over trg_len - 1 labels, because it internally shifts the labels</span>
        <span class="hljs-comment"># to the left by 1.</span>
        neg_log_likelihood = outputs.loss

    nlls.append(neg_log_likelihood)

    prev_end_loc = end_loc
    <span class="hljs-keyword">if</span> end_loc == seq_len:
        <span class="hljs-keyword">break</span>

ppl = torch.exp(torch.stack(nlls).mean())`,wrap:!1}}),{c(){b=n("meta"),gs=i(),os=n("p"),us=i(),x=n("h1"),_=n("a"),rs=n("span"),K(G.$$.fragment),ca=i(),es=n("span"),es.textContent=ka,ys=i(),K(Z.$$.fragment),ws=i(),B=n("p"),B.innerHTML=_a,fs=i(),y=n("p"),ha=h(`Perplexity is defined as the exponentiated average negative log-likelihood of a sequence. If we have a tokenized
sequence `),vs=new f(!1),bs=h(", then the perplexity of "),xs=new f(!1),Ms=h(" is,"),ks=i(),ns=n("p"),_s=new f(!1),Ts=i(),w=n("p"),da=h("where "),Js=new f(!1),Us=h(" is the log-likelihood of the ith token conditioned on the preceding tokens "),js=new f(!1),Cs=h(" according to our model. Intuitively, it can be thought of as an evaluation of the model’s ability to predict uniformly among the set of specified tokens in a corpus. Importantly, this means that the tokenization procedure has a direct impact on a model’s perplexity which should always be taken into consideration when comparing different models."),zs=i(),P=n("p"),P.innerHTML=Ta,Is=i(),M=n("h2"),T=n("a"),cs=n("span"),K(E.$$.fragment),ga=i(),ls=n("span"),ls.textContent=Ja,Gs=i(),W=n("p"),W.textContent=Ua,Zs=i(),J=n("img"),Bs=i(),g=n("p"),ua=h(`When working with approximate models, however, we typically have a constraint on the number of tokens the model can
process. The largest version of `),$=n("a"),$.textContent=Ca,ya=h(`, for example, has a fixed length of 1024 tokens, so we
cannot calculate `),Ps=new f(!1),Es=h(" directly when "),Ws=new f(!1),$s=h(" is greater than 1024."),Xs=i(),u=n("p"),wa=h(`Instead, the sequence is typically broken into subsequences equal to the model’s maximum input size. If a model’s max
input size is `),qs=new f(!1),Ns=h(", we then approximate the likelihood of a token "),As=new f(!1),Hs=h(` by conditioning only on the
`),Ls=new f(!1),Rs=h(` tokens that precede it rather than the entire context. When evaluating the model’s perplexity of a
sequence, a tempting but suboptimal approach is to break the sequence into disjoint chunks and add up the decomposed
log-likelihoods of each segment independently.`),Vs=i(),U=n("img"),Ss=i(),X=n("p"),X.textContent=Ia,Qs=i(),q=n("p"),q.textContent=Ga,Ys=i(),j=n("img"),Fs=i(),N=n("p"),N.textContent=Ba,Ks=i(),k=n("h2"),C=n("a"),hs=n("span"),K(A.$$.fragment),fa=i(),is=n("span"),is.textContent=Pa,Ds=i(),H=n("p"),H.textContent=Ea,Os=i(),K(L.$$.fragment),sa=i(),R=n("p"),R.textContent=Wa,aa=i(),K(V.$$.fragment),ta=i(),S=n("p"),S.innerHTML=$a,ea=i(),K(Q.$$.fragment),na=i(),Y=n("p"),Y.textContent=Xa,la=i(),F=n("p"),F.innerHTML=qa,ia=i(),ds=n("p"),this.h()},l(s){const t=ot("svelte-1phssyn",document.head);b=l(t,"META",{name:!0,content:!0}),t.forEach(a),gs=p(s),os=l(s,"P",{}),r(os).forEach(a),us=p(s),x=l(s,"H1",{class:!0});var ma=r(x);_=l(ma,"A",{id:!0,class:!0,href:!0});var Na=r(_);rs=l(Na,"SPAN",{});var Aa=r(rs);D(G.$$.fragment,Aa),Aa.forEach(a),Na.forEach(a),ca=p(ma),es=l(ma,"SPAN",{"data-svelte-h":!0}),c(es)!=="svelte-11mcch1"&&(es.textContent=ka),ma.forEach(a),ys=p(s),D(Z.$$.fragment,s),ws=p(s),B=l(s,"P",{"data-svelte-h":!0}),c(B)!=="svelte-syn4xn"&&(B.innerHTML=_a),fs=p(s),y=l(s,"P",{});var ps=r(y);ha=d(ps,`Perplexity is defined as the exponentiated average negative log-likelihood of a sequence. If we have a tokenized
sequence `),vs=v(ps,!1),bs=d(ps,", then the perplexity of "),xs=v(ps,!1),Ms=d(ps," is,"),ps.forEach(a),ks=p(s),ns=l(s,"P",{});var Ha=r(ns);_s=v(Ha,!1),Ha.forEach(a),Ts=p(s),w=l(s,"P",{});var ms=r(w);da=d(ms,"where "),Js=v(ms,!1),Us=d(ms," is the log-likelihood of the ith token conditioned on the preceding tokens "),js=v(ms,!1),Cs=d(ms," according to our model. Intuitively, it can be thought of as an evaluation of the model’s ability to predict uniformly among the set of specified tokens in a corpus. Importantly, this means that the tokenization procedure has a direct impact on a model’s perplexity which should always be taken into consideration when comparing different models."),ms.forEach(a),zs=p(s),P=l(s,"P",{"data-svelte-h":!0}),c(P)!=="svelte-10yo7ds"&&(P.innerHTML=Ta),Is=p(s),M=l(s,"H2",{class:!0});var oa=r(M);T=l(oa,"A",{id:!0,class:!0,href:!0});var La=r(T);cs=l(La,"SPAN",{});var Ra=r(cs);D(E.$$.fragment,Ra),Ra.forEach(a),La.forEach(a),ga=p(oa),ls=l(oa,"SPAN",{"data-svelte-h":!0}),c(ls)!=="svelte-1a3jub9"&&(ls.textContent=Ja),oa.forEach(a),Gs=p(s),W=l(s,"P",{"data-svelte-h":!0}),c(W)!=="svelte-nt0thp"&&(W.textContent=Ua),Zs=p(s),J=l(s,"IMG",{width:!0,alt:!0,src:!0}),Bs=p(s),g=l(s,"P",{});var z=r(g);ua=d(z,`When working with approximate models, however, we typically have a constraint on the number of tokens the model can
process. The largest version of `),$=l(z,"A",{href:!0,"data-svelte-h":!0}),c($)!=="svelte-1kdeo4m"&&($.textContent=Ca),ya=d(z,`, for example, has a fixed length of 1024 tokens, so we
cannot calculate `),Ps=v(z,!1),Es=d(z," directly when "),Ws=v(z,!1),$s=d(z," is greater than 1024."),z.forEach(a),Xs=p(s),u=l(s,"P",{});var I=r(u);wa=d(I,`Instead, the sequence is typically broken into subsequences equal to the model’s maximum input size. If a model’s max
input size is `),qs=v(I,!1),Ns=d(I,", we then approximate the likelihood of a token "),As=v(I,!1),Hs=d(I,` by conditioning only on the
`),Ls=v(I,!1),Rs=d(I,` tokens that precede it rather than the entire context. When evaluating the model’s perplexity of a
sequence, a tempting but suboptimal approach is to break the sequence into disjoint chunks and add up the decomposed
log-likelihoods of each segment independently.`),I.forEach(a),Vs=p(s),U=l(s,"IMG",{width:!0,alt:!0,src:!0}),Ss=p(s),X=l(s,"P",{"data-svelte-h":!0}),c(X)!=="svelte-19oj8tf"&&(X.textContent=Ia),Qs=p(s),q=l(s,"P",{"data-svelte-h":!0}),c(q)!=="svelte-w5z9wi"&&(q.textContent=Ga),Ys=p(s),j=l(s,"IMG",{width:!0,alt:!0,src:!0}),Fs=p(s),N=l(s,"P",{"data-svelte-h":!0}),c(N)!=="svelte-zqbk5w"&&(N.textContent=Ba),Ks=p(s),k=l(s,"H2",{class:!0});var ra=r(k);C=l(ra,"A",{id:!0,class:!0,href:!0});var Va=r(C);hs=l(Va,"SPAN",{});var Sa=r(hs);D(A.$$.fragment,Sa),Sa.forEach(a),Va.forEach(a),fa=p(ra),is=l(ra,"SPAN",{"data-svelte-h":!0}),c(is)!=="svelte-13x259g"&&(is.textContent=Pa),ra.forEach(a),Ds=p(s),H=l(s,"P",{"data-svelte-h":!0}),c(H)!=="svelte-atwk84"&&(H.textContent=Ea),Os=p(s),D(L.$$.fragment,s),sa=p(s),R=l(s,"P",{"data-svelte-h":!0}),c(R)!=="svelte-1jth08f"&&(R.textContent=Wa),aa=p(s),D(V.$$.fragment,s),ta=p(s),S=l(s,"P",{"data-svelte-h":!0}),c(S)!=="svelte-1jepp38"&&(S.innerHTML=$a),ea=p(s),D(Q.$$.fragment,s),na=p(s),Y=l(s,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-6e6tqv"&&(Y.textContent=Xa),la=p(s),F=l(s,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1um3qvs"&&(F.innerHTML=qa),ia=p(s),ds=l(s,"P",{}),r(ds).forEach(a),this.h()},h(){o(b,"name","hf:doc:metadata"),o(b,"content",JSON.stringify(ht)),o(_,"id","perplexity-of-fixedlength-models"),o(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(_,"href","#perplexity-of-fixedlength-models"),o(x,"class","relative group"),vs.a=bs,xs.a=Ms,_s.a=null,Js.a=Us,js.a=Cs,o(T,"id","calculating-ppl-with-fixedlength-models"),o(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(T,"href","#calculating-ppl-with-fixedlength-models"),o(M,"class","relative group"),o(J,"width","600"),o(J,"alt","Full decomposition of a sequence with unlimited context length"),va(J.src,ja="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_full.gif")||o(J,"src",ja),o($,"href","model_doc/gpt2"),Ps.a=Es,Ws.a=$s,qs.a=Ns,As.a=Hs,Ls.a=Rs,o(U,"width","600"),o(U,"alt","Suboptimal PPL not taking advantage of full available context"),va(U.src,za="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_chunked.gif")||o(U,"src",za),o(j,"width","600"),o(j,"alt","Sliding window PPL taking advantage of all available context"),va(j.src,Za="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_sliding.gif")||o(j,"src",Za),o(C,"id","example-calculating-perplexity-with-gpt2-in-transformers"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#example-calculating-perplexity-with-gpt2-in-transformers"),o(k,"class","relative group")},m(s,t){m(document.head,b),e(s,gs,t),e(s,os,t),e(s,us,t),e(s,x,t),m(x,_),m(_,rs),O(G,rs,null),m(x,ca),m(x,es),e(s,ys,t),O(Z,s,t),e(s,ws,t),e(s,B,t),e(s,fs,t),e(s,y,t),m(y,ha),vs.m(Qa,y),m(y,bs),xs.m(Ya,y),m(y,Ms),e(s,ks,t),e(s,ns,t),_s.m(Fa,ns),e(s,Ts,t),e(s,w,t),m(w,da),Js.m(Ka,w),m(w,Us),js.m(Da,w),m(w,Cs),e(s,zs,t),e(s,P,t),e(s,Is,t),e(s,M,t),m(M,T),m(T,cs),O(E,cs,null),m(M,ga),m(M,ls),e(s,Gs,t),e(s,W,t),e(s,Zs,t),e(s,J,t),e(s,Bs,t),e(s,g,t),m(g,ua),m(g,$),m(g,ya),Ps.m(Oa,g),m(g,Es),Ws.m(st,g),m(g,$s),e(s,Xs,t),e(s,u,t),m(u,wa),qs.m(at,u),m(u,Ns),As.m(tt,u),m(u,Hs),Ls.m(et,u),m(u,Rs),e(s,Vs,t),e(s,U,t),e(s,Ss,t),e(s,X,t),e(s,Qs,t),e(s,q,t),e(s,Ys,t),e(s,j,t),e(s,Fs,t),e(s,N,t),e(s,Ks,t),e(s,k,t),m(k,C),m(C,hs),O(A,hs,null),m(k,fa),m(k,is),e(s,Ds,t),e(s,H,t),e(s,Os,t),O(L,s,t),e(s,sa,t),e(s,R,t),e(s,aa,t),O(V,s,t),e(s,ta,t),e(s,S,t),e(s,ea,t),O(Q,s,t),e(s,na,t),e(s,Y,t),e(s,la,t),e(s,F,t),e(s,ia,t),e(s,ds,t),pa=!0},p:lt,i(s){pa||(ss(G.$$.fragment,s),ss(Z.$$.fragment,s),ss(E.$$.fragment,s),ss(A.$$.fragment,s),ss(L.$$.fragment,s),ss(V.$$.fragment,s),ss(Q.$$.fragment,s),pa=!0)},o(s){as(G.$$.fragment,s),as(Z.$$.fragment,s),as(E.$$.fragment,s),as(A.$$.fragment,s),as(L.$$.fragment,s),as(V.$$.fragment,s),as(Q.$$.fragment,s),pa=!1},d(s){s&&(a(gs),a(os),a(us),a(x),a(ys),a(ws),a(B),a(fs),a(y),a(ks),a(ns),a(Ts),a(w),a(zs),a(P),a(Is),a(M),a(Gs),a(W),a(Zs),a(J),a(Bs),a(g),a(Xs),a(u),a(Vs),a(U),a(Ss),a(X),a(Qs),a(q),a(Ys),a(j),a(Fs),a(N),a(Ks),a(k),a(Ds),a(H),a(Os),a(sa),a(R),a(aa),a(ta),a(S),a(ea),a(na),a(Y),a(la),a(F),a(ia),a(ds)),a(b),ts(G),ts(Z,s),ts(E),ts(A),ts(L,s),ts(V,s),ts(Q,s)}}}const ht={local:"perplexity-of-fixedlength-models",sections:[{local:"calculating-ppl-with-fixedlength-models",title:"Calculating PPL with fixed-length models"},{local:"example-calculating-perplexity-with-gpt2-in-transformers",title:"Example: Calculating perplexity with GPT-2 in 🤗 Transformers"}],title:"Perplexity of fixed-length models"};function dt(Ma){return it(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vt extends pt{constructor(b){super(),mt(this,b,dt,ct,nt,{})}}export{vt as component};
