import{s as sn,o as an,n as tn}from"../chunks/scheduler.9bc65507.js";import{S as ln,i as nn,g as l,s as i,u as m,A as pn,h as n,f as t,c as p,j as c,v as u,y as r,k as o,o as h,a,w as f,d,t as y,x as w,m as rn,n as on}from"../chunks/index.78c82d43.js";import{T as Ca}from"../chunks/Tip.87d55b76.js";import{I as $}from"../chunks/IconCopyLink.bedaa44d.js";import{C as v}from"../chunks/CodeBlock.73e038be.js";function hn(R){let g,j='Take a look at the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> documentation for a complete list of supported tasks and available parameters.';return{c(){g=l("p"),g.innerHTML=j},l(b){g=n(b,"P",{"data-svelte-h":!0}),r(g)!=="svelte-7400km"&&(g.innerHTML=j)},m(b,T){a(b,g,T)},p:tn,d(b){b&&t(g)}}}function cn(R){let g;return{c(){g=rn(`Creating an inference engine is a complex topic which deserves it's own
page.`)},l(j){g=on(j,`Creating an inference engine is a complex topic which deserves it's own
page.`)},m(j,b){a(j,g,b)},d(j){j&&t(g)}}}function mn(R){let g,j='To run the example above you need to have <a href="https://pypi.org/project/pytesseract/" rel="nofollow"><code>pytesseract</code></a> installed in addition to 🤗 Transformers:',b,T,J;return T=new v({props:{code:"c3VkbyUyMGFwdCUyMGluc3RhbGwlMjAteSUyMHRlc3NlcmFjdC1vY3IlMEFwaXAlMjBpbnN0YWxsJTIwcHl0ZXNzZXJhY3Q=",highlighted:`sudo apt install -y tesseract-ocr
pip install pytesseract`,wrap:!1}}),{c(){g=l("p"),g.innerHTML=j,b=i(),m(T.$$.fragment)},l(M){g=n(M,"P",{"data-svelte-h":!0}),r(g)!=="svelte-z3k1tk"&&(g.innerHTML=j),b=p(M),u(T.$$.fragment,M)},m(M,U){a(M,g,U),a(M,b,U),f(T,M,U),J=!0},p:tn,i(M){J||(d(T.$$.fragment,M),J=!0)},o(M){y(T.$$.fragment,M),J=!1},d(M){M&&(t(g),t(b)),w(T,M)}}}function un(R){let g,j,b,T,J,M,U,ee,ba,wt,Ba="Pipelines for inference",qt,te,Wa='The <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> makes it simple to use any model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a> for inference on any language, computer vision, speech, and multimodal tasks. Even if you don’t have experience with a specific modality or aren’t familiar with the underlying code behind the models, you can still use them for inference with the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>! This tutorial will teach you to:',Et,se,Xa='<li>Use a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for inference.</li> <li>Use a specific tokenizer or model.</li> <li>Use a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for audio, vision, and multimodal tasks.</li>',zt,N,Ft,x,V,Zt,ae,ja,gt,Ha="Pipeline usage",Lt,le,Ra=`While each task has an associated <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>, it is simpler to use the general <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> abstraction which contains
all the task-specific pipelines. The <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> automatically loads a default model and a preprocessing class capable
of inference for your task. Let’s take the example of using the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for automatic speech recognition (ASR), or
speech-to-text.`,At,ne,Na='<li>Start by creating a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> and specify the inference task:</li>',Pt,ie,Qt,S,Va='<li>Pass your input to the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>. In the case of speech recognition, this is an audio input file:</li>',Dt,pe,Kt,re,Sa=`Not the result you had in mind? Check out some of the <a href="https://huggingface.co/models?pipeline_tag=automatic-speech-recognition&amp;sort=trending" rel="nofollow">most downloaded automatic speech recognition models</a>
on the Hub to see if you can get a better transcription.`,Ot,oe,Ya=`Let’s try the <a href="https://huggingface.co/openai/whisper-large" rel="nofollow">Whisper large-v2</a> model from OpenAI. Whisper was released
2 years later than Wav2Vec2, and was trained on close to 10x more data. As such, it beats Wav2Vec2 on most downstream
benchmarks. It also has the added benefit of predicting punctuation and casing, neither of which are possible with<br/>
Wav2Vec2.`,es,he,qa="Let’s give it a try here to see how it performs:",ts,ce,ss,me,Ea=`Now this result looks more accurate! For a deep-dive comparison on Wav2Vec2 vs Whisper, refer to the <a href="https://huggingface.co/learn/audio-course/chapter5/asr_models" rel="nofollow">Audio Transformers Course</a>.
We really encourage you to check out the Hub for models in different languages, models specialized in your field, and more.
You can check out and compare model results directly from your browser on the Hub to see if it fits or
handles corner cases better than other ones.
And if you don’t find a model for your use case, you can always start <a href="training">training</a> your own!`,as,ue,za="If you have several inputs, you can pass your input as a list:",ls,fe,ns,de,Fa=`Pipelines are great for experimentation as switching from one model to another is trivial; however, there are some ways to optimize them for larger workloads than experimentation. See the following guides that dive into iterating over whole datasets or using pipelines in a webserver:
of the docs:`,is,ye,La='<li><a href="#using-pipelines-on-a-dataset">Using pipelines on a dataset</a></li> <li><a href="./pipeline_webserver">Using pipelines for a webserver</a></li>',ps,k,Y,It,we,Ta,Mt,Aa="Parameters",rs,ge,Pa=`<a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports many parameters; some are task specific, and some are general to all pipelines.
In general, you can specify parameters anywhere you want:`,os,Me,hs,ve,Qa="Let’s check out 3 important ones:",cs,Z,q,Gt,be,Ja,vt,Da="Device",ms,je,Ka=`If you use <code>device=n</code>, the pipeline automatically puts the model on the specified device.
This will work regardless of whether you are using PyTorch or Tensorflow.`,us,Te,fs,Je,Oa=`If the model is too large for a single GPU and you are using PyTorch, you can set <code>device_map=&quot;auto&quot;</code> to automatically
determine how to load and store the model weights. Using the <code>device_map</code> argument requires the 🤗 <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate</a>
package:`,ds,$e,ys,Ue,el="The following code automatically loads and stores model weights across devices:",ws,xe,gs,ke,tl="Note that if  <code>device_map=&quot;auto&quot;</code> is passed, there is no need to add the argument <code>device=device</code> when instantiating your <code>pipeline</code> as you may encounter some unexpected behavior!",Ms,I,E,_t,Ze,$a,bt,sl="Batch size",vs,Ie,al='By default, pipelines will not batch inference for reasons explained in detail <a href="https://huggingface.co/docs/transformers/main_classes/pipelines#pipeline-batching" rel="nofollow">here</a>. The reason is that batching is not necessarily faster, and can actually be quite slower in some cases.',bs,Ge,ll="But if it works in your use case, you can use:",js,_e,Ts,Ce,nl=`This runs the pipeline on the 4 provided audio files, but it will pass them in batches of 2
to the model (which is on a GPU, where batching is more likely to help) without requiring any further code from you.
The output should always match what you would have received without batching. It is only meant as a way to help you get more speed out of a pipeline.`,Js,Be,il='Pipelines can also alleviate some of the complexities of batching because, for some pipelines, a single item (like a long audio file) needs to be chunked into multiple parts to be processed by a model. The pipeline performs this <a href="./main_classes/pipelines#pipeline-chunk-batching"><em>chunk batching</em></a> for you.',$s,G,z,Ct,We,Ua,jt,pl="Task specific parameters",Us,Xe,rl=`All tasks provide task specific parameters which allow for additional flexibility and options to help you get your job done.
For instance, the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline.__call__">transformers.AutomaticSpeechRecognitionPipeline.<strong>call</strong>()</a> method has a <code>return_timestamps</code> parameter which sounds promising for subtitling videos:`,xs,He,ks,Re,ol="As you can see, the model inferred the text and also outputted <strong>when</strong> the various sentences were pronounced.",Zs,Ne,hl=`There are many parameters available for each task, so check out each task’s API reference to see what you can tinker with!
For instance, the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.AutomaticSpeechRecognitionPipeline">AutomaticSpeechRecognitionPipeline</a> has a <code>chunk_length_s</code> parameter which is helpful
for working on really long audio files (for example, subtitling entire movies or hour-long videos) that a model typically
cannot handle on its own:`,Is,Ve,Gs,Se,cl='If you can’t find a parameter that would really help you out, feel free to <a href="https://github.com/huggingface/transformers/issues/new?assignees=&amp;labels=feature&amp;template=feature-request.yml" rel="nofollow">request it</a>!',_s,_,F,Bt,Ye,xa,Tt,ml="Using pipelines on a dataset",Cs,qe,ul="The pipeline can also run inference on a large dataset. The easiest way we recommend doing this is by using an iterator:",Bs,Ee,Ws,ze,fl=`The iterator <code>data()</code> yields each result, and the pipeline automatically
recognizes the input is iterable and will start fetching the data while
it continues to process it on the GPU (this uses <a href="https://pytorch.org/docs/stable/data.html#torch.utils.data.DataLoader" rel="nofollow">DataLoader</a> under the hood).
This is important because you don’t have to allocate memory for the whole dataset
and you can feed the GPU as fast as possible.`,Xs,Fe,dl="Since batching could speed things up, it may be useful to try tuning the <code>batch_size</code> parameter here.",Hs,Le,yl='The simplest way to iterate over a dataset is to just load one from 🤗 <a href="https://github.com/huggingface/datasets/" rel="nofollow">Datasets</a>:',Rs,Ae,Ns,C,L,Wt,Pe,ka,Jt,wl="Using pipelines for a webserver",Vs,A,Ss,Qe,gl='<a href="./pipeline_webserver">Link</a>',Ys,B,P,Xt,De,Za,$t,Ml="Vision pipeline",qs,Ke,vl='Using a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for vision tasks is practically identical.',Es,Oe,bl="Specify your task and pass your image to the classifier. The image can be a link, a local path or a base64-encoded image. For example, what species of cat is shown below?",zs,et,jl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',Fs,tt,Ls,W,Q,Ht,st,Ia,Ut,Tl="Text pipeline",As,at,Jl='Using a <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> for NLP tasks is practically identical.',Ps,lt,Qs,X,D,Rt,nt,Ga,xt,$l="Multimodal pipeline",Ds,it,Ul='The <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a> supports more than one modality. For example, a visual question answering (VQA) task combines text and image. Feel free to use any image link you like and a question you want to ask about the image. The image can be a URL or a local path to the image.',Ks,pt,xl='For example, if you use this <a href="https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png" rel="nofollow">invoice image</a>:',Os,rt,ea,K,ta,H,O,Nt,ot,_a,kt,kl="Using <code>pipeline</code> on large models with 🤗 <code>accelerate</code>:",sa,ht,Zl="You can easily run <code>pipeline</code> on large models using 🤗 <code>accelerate</code>! First make sure you have installed <code>accelerate</code> with <code>pip install accelerate</code>.",aa,ct,Il="First load your model using <code>device_map=&quot;auto&quot;</code>! We will use <code>facebook/opt-1.3b</code> for our example.",la,mt,na,ut,Gl="You can also pass 8-bit loaded models if you install <code>bitsandbytes</code> and add the argument <code>load_in_8bit=True</code>",ia,ft,pa,dt,_l="Note that you can replace the checkpoint with any of the Hugging Face model that supports large model loading such as BLOOM!",ra,Vt,oa;return ee=new $({}),N=new Ca({props:{$$slots:{default:[hn]},$$scope:{ctx:R}}}),ae=new $({}),ie=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>)`,wrap:!1}}),pe=new v({props:{code:"dHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;I HAVE A DREAM BUT ONE DAY THIS NATION WILL RISE UP LIVE UP THE TRUE MEANING OF ITS TREES&#x27;</span>}`,wrap:!1}}),ce=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),fe=new v({props:{code:"dHJhbnNjcmliZXIoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGMS5mbGFjJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKQ==",highlighted:`transcriber(
    [
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>,
        <span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/1.flac&quot;</span>,
    ]
)`,wrap:!1}}),we=new $({}),Me=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBteV9wYXJhbWV0ZXIlM0QxKSUwQSUwQW91dCUyMCUzRCUyMHRyYW5zY3JpYmVyKC4uLiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMHVzZSUyMCU2MG15X3BhcmFtZXRlciUzRDElNjAuJTBBb3V0JTIwJTNEJTIwdHJhbnNjcmliZXIoLi4uJTJDJTIwbXlfcGFyYW1ldGVyJTNEMiklMjAlMjAlMjMlMjBUaGlzJTIwd2lsbCUyMG92ZXJyaWRlJTIwYW5kJTIwdXNlJTIwJTYwbXlfcGFyYW1ldGVyJTNEMiU2MC4lMEFvdXQlMjAlM0QlMjB0cmFuc2NyaWJlciguLi4pJTIwJTIwJTIzJTIwVGhpcyUyMHdpbGwlMjBnbyUyMGJhY2slMjB0byUyMHVzaW5nJTIwJTYwbXlfcGFyYW1ldGVyJTNEMSU2MC4=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, my_parameter=<span class="hljs-number">1</span>)\n\nout = transcriber(...)  <span class="hljs-comment"># This will use `my_parameter=1`.</span>\nout = transcriber(..., my_parameter=<span class="hljs-number">2</span>)  <span class="hljs-comment"># This will override and use `my_parameter=2`.</span>\nout = transcriber(...)  <span class="hljs-comment"># This will go back to using `my_parameter=1`.</span>',wrap:!1}}),be=new $({}),Te=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwKQ==",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>)',wrap:!1}}),$e=new v({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGFjY2VsZXJhdGU=",highlighted:"pip install --upgrade accelerate",wrap:!1}}),xe=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:'transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)',wrap:!1}}),Ze=new $({}),_e=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBkZXZpY2UlM0QwJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBYXVkaW9fZmlsZW5hbWVzJTIwJTNEJTIwJTVCZiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRk5hcnNpbCUyRmFzcl9kdW1teSUyRnJlc29sdmUlMkZtYWluJTJGJTdCaSU3RC5mbGFjJTIyJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMSUyQyUyMDUpJTVEJTBBdGV4dHMlMjAlM0QlMjB0cmFuc2NyaWJlcihhdWRpb19maWxlbmFtZXMp",highlighted:`transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, device=<span class="hljs-number">0</span>, batch_size=<span class="hljs-number">2</span>)
audio_filenames = [<span class="hljs-string">f&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/<span class="hljs-subst">{i}</span>.flac&quot;</span> <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1</span>, <span class="hljs-number">5</span>)]
texts = transcriber(audio_filenames)`,wrap:!1}}),We=new $({}),He=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjByZXR1cm5fdGltZXN0YW1wcyUzRFRydWUpJTBBdHJhbnNjcmliZXIoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGTmFyc2lsJTJGYXNyX2R1bW15JTJGcmVzb2x2ZSUyRm1haW4lMkZtbGsuZmxhYyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>, <span class="hljs-string">&#x27;chunks&#x27;</span>: [{<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">0.0</span>, <span class="hljs-number">11.88</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its&#x27;</span>}, {<span class="hljs-string">&#x27;timestamp&#x27;</span>: (<span class="hljs-number">11.88</span>, <span class="hljs-number">12.38</span>), <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; creed.&#x27;</span>}]}`,wrap:!1}}),Ve=new v({props:{code:"dHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMm9wZW5haSUyRndoaXNwZXItbGFyZ2UtdjIlMjIlMkMlMjBjaHVua19sZW5ndGhfcyUzRDMwJTJDJTIwcmV0dXJuX3RpbWVzdGFtcHMlM0RUcnVlKSUwQXRyYW5zY3JpYmVyKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRnNhbmNoaXQtZ2FuZGhpJTJGbGlicmlzcGVlY2hfbG9uZyUyRnJlc29sdmUlMkZtYWluJTJGYXVkaW8ud2F2JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(model=<span class="hljs-string">&quot;openai/whisper-large-v2&quot;</span>, chunk_length_s=<span class="hljs-number">30</span>, return_timestamps=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/sanchit-gandhi/librispeech_long/resolve/main/audio.wav&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&quot; Chapter 16. I might have told you of the beginning of this liaison in a few lines, but I wanted you to see every step by which we came.  I, too, agree to whatever Marguerite wished, Marguerite to be unable to live apart from me. It was the day after the evening...</span>`,wrap:!1}}),Ye=new $({}),Ee=new v({props:{code:"ZGVmJTIwZGF0YSgpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UoMTAwMCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB5aWVsZCUyMGYlMjJNeSUyMGV4YW1wbGUlMjAlN0JpJTdEJTIyJTBBJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyZ3B0MiUyMiUyQyUyMGRldmljZSUzRDApJTBBZ2VuZXJhdGVkX2NoYXJhY3RlcnMlMjAlM0QlMjAwJTBBZm9yJTIwb3V0JTIwaW4lMjBwaXBlKGRhdGEoKSklM0ElMEElMjAlMjAlMjAlMjBnZW5lcmF0ZWRfY2hhcmFjdGVycyUyMCUyQiUzRCUyMGxlbihvdXQlNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">data</span>():
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>):
        <span class="hljs-keyword">yield</span> <span class="hljs-string">f&quot;My example <span class="hljs-subst">{i}</span>&quot;</span>


pipe = pipeline(model=<span class="hljs-string">&quot;gpt2&quot;</span>, device=<span class="hljs-number">0</span>)
generated_characters = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(data()):
    generated_characters += <span class="hljs-built_in">len</span>(out[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>])`,wrap:!1}}),Ae=new v({props:{code:"JTIzJTIwS2V5RGF0YXNldCUyMGlzJTIwYSUyMHV0aWwlMjB0aGF0JTIwd2lsbCUyMGp1c3QlMjBvdXRwdXQlMjB0aGUlMjBpdGVtJTIwd2UncmUlMjBpbnRlcmVzdGVkJTIwaW4uJTBBZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMucHRfdXRpbHMlMjBpbXBvcnQlMjBLZXlEYXRhc2V0JTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRnRpbnktcmFuZG9tLXdhdjJ2ZWMyJTIyJTJDJTIwZGV2aWNlJTNEMCklMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZHVtbXklMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiU1QiUzQTEwJTVEJTIyKSUwQSUwQWZvciUyMG91dCUyMGluJTIwcGlwZShLZXlEYXRhc2V0KGRhdGFzZXQlMkMlMjAlMjJhdWRpbyUyMikpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQob3V0KQ==",highlighted:`<span class="hljs-comment"># KeyDataset is a util that will just output the item we&#x27;re interested in.</span>
<span class="hljs-keyword">from</span> transformers.pipelines.pt_utils <span class="hljs-keyword">import</span> KeyDataset
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

pipe = pipeline(model=<span class="hljs-string">&quot;hf-internal-testing/tiny-random-wav2vec2&quot;</span>, device=<span class="hljs-number">0</span>)
dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation[:10]&quot;</span>)

<span class="hljs-keyword">for</span> out <span class="hljs-keyword">in</span> pipe(KeyDataset(dataset, <span class="hljs-string">&quot;audio&quot;</span>)):
    <span class="hljs-built_in">print</span>(out)`,wrap:!1}}),Pe=new $({}),A=new Ca({props:{$$slots:{default:[cn]},$$scope:{ctx:R}}}),De=new $({}),tt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQXByZWRzJTIwJTNEJTIwdmlzaW9uX2NsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwaW1hZ2VzJTNEJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(model=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),st=new $({}),lt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBJTIzJTIwVGhpcyUyMG1vZGVsJTIwaXMlMjBhJTIwJTYwemVyby1zaG90LWNsYXNzaWZpY2F0aW9uJTYwJTIwbW9kZWwuJTBBJTIzJTIwSXQlMjB3aWxsJTIwY2xhc3NpZnklMjB0ZXh0JTJDJTIwZXhjZXB0JTIweW91JTIwYXJlJTIwZnJlZSUyMHRvJTIwY2hvb3NlJTIwYW55JTIwbGFiZWwlMjB5b3UlMjBtaWdodCUyMGltYWdpbmUlMEFjbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJmYWNlYm9vayUyRmJhcnQtbGFyZ2UtbW5saSUyMiklMEFjbGFzc2lmaWVyKCUwQSUyMCUyMCUyMCUyMCUyMkklMjBoYXZlJTIwYSUyMHByb2JsZW0lMjB3aXRoJTIwbXklMjBpcGhvbmUlMjB0aGF0JTIwbmVlZHMlMjB0byUyMGJlJTIwcmVzb2x2ZWQlMjBhc2FwISElMjIlMkMlMEElMjAlMjAlMjAlMjBjYW5kaWRhdGVfbGFiZWxzJTNEJTVCJTIydXJnZW50JTIyJTJDJTIwJTIybm90JTIwdXJnZW50JTIyJTJDJTIwJTIycGhvbmUlMjIlMkMlMjAlMjJ0YWJsZXQlMjIlMkMlMjAlMjJjb21wdXRlciUyMiU1RCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># This model is a \`zero-shot-classification\` model.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># It will classify text, except you are free to choose any label you might imagine</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(model=<span class="hljs-string">&quot;facebook/bart-large-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;I have a problem with my iphone that needs to be resolved asap!!&quot;</span>,
<span class="hljs-meta">... </span>    candidate_labels=[<span class="hljs-string">&quot;urgent&quot;</span>, <span class="hljs-string">&quot;not urgent&quot;</span>, <span class="hljs-string">&quot;phone&quot;</span>, <span class="hljs-string">&quot;tablet&quot;</span>, <span class="hljs-string">&quot;computer&quot;</span>],
<span class="hljs-meta">... </span>)
{<span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;I have a problem with my iphone that needs to be resolved asap!!&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>: [<span class="hljs-string">&#x27;urgent&#x27;</span>, <span class="hljs-string">&#x27;phone&#x27;</span>, <span class="hljs-string">&#x27;computer&#x27;</span>, <span class="hljs-string">&#x27;not urgent&#x27;</span>, <span class="hljs-string">&#x27;tablet&#x27;</span>], <span class="hljs-string">&#x27;scores&#x27;</span>: [<span class="hljs-number">0.504</span>, <span class="hljs-number">0.479</span>, <span class="hljs-number">0.013</span>, <span class="hljs-number">0.003</span>, <span class="hljs-number">0.002</span>]}`,wrap:!1}}),nt=new $({}),rt=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdnFhJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJpbXBpcmElMkZsYXlvdXRsbS1kb2N1bWVudC1xYSUyMiklMEF2cWEoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3BhY2VzJTJGaW1waXJhJTJGZG9jcXVlcnklMkZyZXNvbHZlJTJGMjM1OTIyM2MxODM3YTc1ODc0MDJiZGEwZjI2NDMzODJhNmVlZmVhYiUyRmludm9pY2UucG5nJTIyJTJDJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBpbnZvaWNlJTIwbnVtYmVyJTNGJTIyJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vqa = pipeline(model=<span class="hljs-string">&quot;impira/layoutlm-document-qa&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>vqa(
<span class="hljs-meta">... </span>    image=<span class="hljs-string">&quot;https://huggingface.co/spaces/impira/docquery/resolve/2359223c1837a7587402bda0f2643382a6eefeab/invoice.png&quot;</span>,
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the invoice number?&quot;</span>,
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.42515</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;us-001&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">16</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">16</span>}]`,wrap:!1}}),K=new Ca({props:{$$slots:{default:[mn]},$$scope:{ctx:R}}}),ot=new $({}),mt=new v({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),ft=new v({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBwaXBlbGluZSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZShtb2RlbCUzRCUyMmZhY2Vib29rJTJGb3B0LTEuM2IlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMG1vZGVsX2t3YXJncyUzRCU3QiUyMmxvYWRfaW5fOGJpdCUyMiUzQSUyMFRydWUlN0QpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwY29vbCUyMGV4YW1wbGUhJTIyJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMHRvcF9wJTNEMC45NSk=",highlighted:`<span class="hljs-comment"># pip install accelerate bitsandbytes</span>
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(model=<span class="hljs-string">&quot;facebook/opt-1.3b&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, model_kwargs={<span class="hljs-string">&quot;load_in_8bit&quot;</span>: <span class="hljs-literal">True</span>})
output = pipe(<span class="hljs-string">&quot;This is a cool example!&quot;</span>, do_sample=<span class="hljs-literal">True</span>, top_p=<span class="hljs-number">0.95</span>)`,wrap:!1}}),{c(){g=l("meta"),j=i(),b=l("p"),T=i(),J=l("h1"),M=l("a"),U=l("span"),m(ee.$$.fragment),ba=i(),wt=l("span"),wt.textContent=Ba,qt=i(),te=l("p"),te.innerHTML=Wa,Et=i(),se=l("ul"),se.innerHTML=Xa,zt=i(),m(N.$$.fragment),Ft=i(),x=l("h2"),V=l("a"),Zt=l("span"),m(ae.$$.fragment),ja=i(),gt=l("span"),gt.textContent=Ha,Lt=i(),le=l("p"),le.innerHTML=Ra,At=i(),ne=l("ol"),ne.innerHTML=Na,Pt=i(),m(ie.$$.fragment),Qt=i(),S=l("ol"),S.innerHTML=Va,Dt=i(),m(pe.$$.fragment),Kt=i(),re=l("p"),re.innerHTML=Sa,Ot=i(),oe=l("p"),oe.innerHTML=Ya,es=i(),he=l("p"),he.textContent=qa,ts=i(),m(ce.$$.fragment),ss=i(),me=l("p"),me.innerHTML=Ea,as=i(),ue=l("p"),ue.textContent=za,ls=i(),m(fe.$$.fragment),ns=i(),de=l("p"),de.textContent=Fa,is=i(),ye=l("ul"),ye.innerHTML=La,ps=i(),k=l("h2"),Y=l("a"),It=l("span"),m(we.$$.fragment),Ta=i(),Mt=l("span"),Mt.textContent=Aa,rs=i(),ge=l("p"),ge.innerHTML=Pa,os=i(),m(Me.$$.fragment),hs=i(),ve=l("p"),ve.textContent=Qa,cs=i(),Z=l("h3"),q=l("a"),Gt=l("span"),m(be.$$.fragment),Ja=i(),vt=l("span"),vt.textContent=Da,ms=i(),je=l("p"),je.innerHTML=Ka,us=i(),m(Te.$$.fragment),fs=i(),Je=l("p"),Je.innerHTML=Oa,ds=i(),m($e.$$.fragment),ys=i(),Ue=l("p"),Ue.textContent=el,ws=i(),m(xe.$$.fragment),gs=i(),ke=l("p"),ke.innerHTML=tl,Ms=i(),I=l("h3"),E=l("a"),_t=l("span"),m(Ze.$$.fragment),$a=i(),bt=l("span"),bt.textContent=sl,vs=i(),Ie=l("p"),Ie.innerHTML=al,bs=i(),Ge=l("p"),Ge.textContent=ll,js=i(),m(_e.$$.fragment),Ts=i(),Ce=l("p"),Ce.textContent=nl,Js=i(),Be=l("p"),Be.innerHTML=il,$s=i(),G=l("h3"),z=l("a"),Ct=l("span"),m(We.$$.fragment),Ua=i(),jt=l("span"),jt.textContent=pl,Us=i(),Xe=l("p"),Xe.innerHTML=rl,xs=i(),m(He.$$.fragment),ks=i(),Re=l("p"),Re.innerHTML=ol,Zs=i(),Ne=l("p"),Ne.innerHTML=hl,Is=i(),m(Ve.$$.fragment),Gs=i(),Se=l("p"),Se.innerHTML=cl,_s=i(),_=l("h2"),F=l("a"),Bt=l("span"),m(Ye.$$.fragment),xa=i(),Tt=l("span"),Tt.textContent=ml,Cs=i(),qe=l("p"),qe.textContent=ul,Bs=i(),m(Ee.$$.fragment),Ws=i(),ze=l("p"),ze.innerHTML=fl,Xs=i(),Fe=l("p"),Fe.innerHTML=dl,Hs=i(),Le=l("p"),Le.innerHTML=yl,Rs=i(),m(Ae.$$.fragment),Ns=i(),C=l("h2"),L=l("a"),Wt=l("span"),m(Pe.$$.fragment),ka=i(),Jt=l("span"),Jt.textContent=wl,Vs=i(),m(A.$$.fragment),Ss=i(),Qe=l("p"),Qe.innerHTML=gl,Ys=i(),B=l("h2"),P=l("a"),Xt=l("span"),m(De.$$.fragment),Za=i(),$t=l("span"),$t.textContent=Ml,qs=i(),Ke=l("p"),Ke.innerHTML=vl,Es=i(),Oe=l("p"),Oe.textContent=bl,zs=i(),et=l("p"),et.innerHTML=jl,Fs=i(),m(tt.$$.fragment),Ls=i(),W=l("h2"),Q=l("a"),Ht=l("span"),m(st.$$.fragment),Ia=i(),Ut=l("span"),Ut.textContent=Tl,As=i(),at=l("p"),at.innerHTML=Jl,Ps=i(),m(lt.$$.fragment),Qs=i(),X=l("h2"),D=l("a"),Rt=l("span"),m(nt.$$.fragment),Ga=i(),xt=l("span"),xt.textContent=$l,Ds=i(),it=l("p"),it.innerHTML=Ul,Ks=i(),pt=l("p"),pt.innerHTML=xl,Os=i(),m(rt.$$.fragment),ea=i(),m(K.$$.fragment),ta=i(),H=l("h2"),O=l("a"),Nt=l("span"),m(ot.$$.fragment),_a=i(),kt=l("span"),kt.innerHTML=kl,sa=i(),ht=l("p"),ht.innerHTML=Zl,aa=i(),ct=l("p"),ct.innerHTML=Il,la=i(),m(mt.$$.fragment),na=i(),ut=l("p"),ut.innerHTML=Gl,ia=i(),m(ft.$$.fragment),pa=i(),dt=l("p"),dt.textContent=_l,ra=i(),Vt=l("p"),this.h()},l(e){const s=pn("svelte-1phssyn",document.head);g=n(s,"META",{name:!0,content:!0}),s.forEach(t),j=p(e),b=n(e,"P",{}),c(b).forEach(t),T=p(e),J=n(e,"H1",{class:!0});var yt=c(J);M=n(yt,"A",{id:!0,class:!0,href:!0});var St=c(M);U=n(St,"SPAN",{});var Yt=c(U);u(ee.$$.fragment,Yt),Yt.forEach(t),St.forEach(t),ba=p(yt),wt=n(yt,"SPAN",{"data-svelte-h":!0}),r(wt)!=="svelte-121yjmk"&&(wt.textContent=Ba),yt.forEach(t),qt=p(e),te=n(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-pw8kls"&&(te.innerHTML=Wa),Et=p(e),se=n(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-1q24wwc"&&(se.innerHTML=Xa),zt=p(e),u(N.$$.fragment,e),Ft=p(e),x=n(e,"H2",{class:!0});var ha=c(x);V=n(ha,"A",{id:!0,class:!0,href:!0});var Cl=c(V);Zt=n(Cl,"SPAN",{});var Bl=c(Zt);u(ae.$$.fragment,Bl),Bl.forEach(t),Cl.forEach(t),ja=p(ha),gt=n(ha,"SPAN",{"data-svelte-h":!0}),r(gt)!=="svelte-1hfx7v2"&&(gt.textContent=Ha),ha.forEach(t),Lt=p(e),le=n(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-g32nkc"&&(le.innerHTML=Ra),At=p(e),ne=n(e,"OL",{"data-svelte-h":!0}),r(ne)!=="svelte-wpkblw"&&(ne.innerHTML=Na),Pt=p(e),u(ie.$$.fragment,e),Qt=p(e),S=n(e,"OL",{start:!0,"data-svelte-h":!0}),r(S)!=="svelte-1n1vug4"&&(S.innerHTML=Va),Dt=p(e),u(pe.$$.fragment,e),Kt=p(e),re=n(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-jt3v05"&&(re.innerHTML=Sa),Ot=p(e),oe=n(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1sbs9t3"&&(oe.innerHTML=Ya),es=p(e),he=n(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-5gg07s"&&(he.textContent=qa),ts=p(e),u(ce.$$.fragment,e),ss=p(e),me=n(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1yjypga"&&(me.innerHTML=Ea),as=p(e),ue=n(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1udq0dv"&&(ue.textContent=za),ls=p(e),u(fe.$$.fragment,e),ns=p(e),de=n(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1y2bxsh"&&(de.textContent=Fa),is=p(e),ye=n(e,"UL",{"data-svelte-h":!0}),r(ye)!=="svelte-boqb6q"&&(ye.innerHTML=La),ps=p(e),k=n(e,"H2",{class:!0});var ca=c(k);Y=n(ca,"A",{id:!0,class:!0,href:!0});var Wl=c(Y);It=n(Wl,"SPAN",{});var Xl=c(It);u(we.$$.fragment,Xl),Xl.forEach(t),Wl.forEach(t),Ta=p(ca),Mt=n(ca,"SPAN",{"data-svelte-h":!0}),r(Mt)!=="svelte-1wk3i6h"&&(Mt.textContent=Aa),ca.forEach(t),rs=p(e),ge=n(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-120j2nl"&&(ge.innerHTML=Pa),os=p(e),u(Me.$$.fragment,e),hs=p(e),ve=n(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-e9485z"&&(ve.textContent=Qa),cs=p(e),Z=n(e,"H3",{class:!0});var ma=c(Z);q=n(ma,"A",{id:!0,class:!0,href:!0});var Hl=c(q);Gt=n(Hl,"SPAN",{});var Rl=c(Gt);u(be.$$.fragment,Rl),Rl.forEach(t),Hl.forEach(t),Ja=p(ma),vt=n(ma,"SPAN",{"data-svelte-h":!0}),r(vt)!=="svelte-1m3z64j"&&(vt.textContent=Da),ma.forEach(t),ms=p(e),je=n(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-sob7ne"&&(je.innerHTML=Ka),us=p(e),u(Te.$$.fragment,e),fs=p(e),Je=n(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1tfx7co"&&(Je.innerHTML=Oa),ds=p(e),u($e.$$.fragment,e),ys=p(e),Ue=n(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-6riuku"&&(Ue.textContent=el),ws=p(e),u(xe.$$.fragment,e),gs=p(e),ke=n(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1otna9r"&&(ke.innerHTML=tl),Ms=p(e),I=n(e,"H3",{class:!0});var ua=c(I);E=n(ua,"A",{id:!0,class:!0,href:!0});var Nl=c(E);_t=n(Nl,"SPAN",{});var Vl=c(_t);u(Ze.$$.fragment,Vl),Vl.forEach(t),Nl.forEach(t),$a=p(ua),bt=n(ua,"SPAN",{"data-svelte-h":!0}),r(bt)!=="svelte-tl3n1q"&&(bt.textContent=sl),ua.forEach(t),vs=p(e),Ie=n(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-v1mumi"&&(Ie.innerHTML=al),bs=p(e),Ge=n(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1jutax8"&&(Ge.textContent=ll),js=p(e),u(_e.$$.fragment,e),Ts=p(e),Ce=n(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-n3ouik"&&(Ce.textContent=nl),Js=p(e),Be=n(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-sq1wry"&&(Be.innerHTML=il),$s=p(e),G=n(e,"H3",{class:!0});var fa=c(G);z=n(fa,"A",{id:!0,class:!0,href:!0});var Sl=c(z);Ct=n(Sl,"SPAN",{});var Yl=c(Ct);u(We.$$.fragment,Yl),Yl.forEach(t),Sl.forEach(t),Ua=p(fa),jt=n(fa,"SPAN",{"data-svelte-h":!0}),r(jt)!=="svelte-1w6n8om"&&(jt.textContent=pl),fa.forEach(t),Us=p(e),Xe=n(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1xyrnv4"&&(Xe.innerHTML=rl),xs=p(e),u(He.$$.fragment,e),ks=p(e),Re=n(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1ad1wem"&&(Re.innerHTML=ol),Zs=p(e),Ne=n(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1xb3kcm"&&(Ne.innerHTML=hl),Is=p(e),u(Ve.$$.fragment,e),Gs=p(e),Se=n(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-1nowgzq"&&(Se.innerHTML=cl),_s=p(e),_=n(e,"H2",{class:!0});var da=c(_);F=n(da,"A",{id:!0,class:!0,href:!0});var ql=c(F);Bt=n(ql,"SPAN",{});var El=c(Bt);u(Ye.$$.fragment,El),El.forEach(t),ql.forEach(t),xa=p(da),Tt=n(da,"SPAN",{"data-svelte-h":!0}),r(Tt)!=="svelte-qun44c"&&(Tt.textContent=ml),da.forEach(t),Cs=p(e),qe=n(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-1sh6mg6"&&(qe.textContent=ul),Bs=p(e),u(Ee.$$.fragment,e),Ws=p(e),ze=n(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-1rrzg9"&&(ze.innerHTML=fl),Xs=p(e),Fe=n(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-1litpj1"&&(Fe.innerHTML=dl),Hs=p(e),Le=n(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1pgxdbs"&&(Le.innerHTML=yl),Rs=p(e),u(Ae.$$.fragment,e),Ns=p(e),C=n(e,"H2",{class:!0});var ya=c(C);L=n(ya,"A",{id:!0,class:!0,href:!0});var zl=c(L);Wt=n(zl,"SPAN",{});var Fl=c(Wt);u(Pe.$$.fragment,Fl),Fl.forEach(t),zl.forEach(t),ka=p(ya),Jt=n(ya,"SPAN",{"data-svelte-h":!0}),r(Jt)!=="svelte-b1sisp"&&(Jt.textContent=wl),ya.forEach(t),Vs=p(e),u(A.$$.fragment,e),Ss=p(e),Qe=n(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-52dmam"&&(Qe.innerHTML=gl),Ys=p(e),B=n(e,"H2",{class:!0});var wa=c(B);P=n(wa,"A",{id:!0,class:!0,href:!0});var Ll=c(P);Xt=n(Ll,"SPAN",{});var Al=c(Xt);u(De.$$.fragment,Al),Al.forEach(t),Ll.forEach(t),Za=p(wa),$t=n(wa,"SPAN",{"data-svelte-h":!0}),r($t)!=="svelte-gs2plx"&&($t.textContent=Ml),wa.forEach(t),qs=p(e),Ke=n(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-l80kni"&&(Ke.innerHTML=vl),Es=p(e),Oe=n(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-ip2z2f"&&(Oe.textContent=bl),zs=p(e),et=n(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1bks2jw"&&(et.innerHTML=jl),Fs=p(e),u(tt.$$.fragment,e),Ls=p(e),W=n(e,"H2",{class:!0});var ga=c(W);Q=n(ga,"A",{id:!0,class:!0,href:!0});var Pl=c(Q);Ht=n(Pl,"SPAN",{});var Ql=c(Ht);u(st.$$.fragment,Ql),Ql.forEach(t),Pl.forEach(t),Ia=p(ga),Ut=n(ga,"SPAN",{"data-svelte-h":!0}),r(Ut)!=="svelte-umgmbk"&&(Ut.textContent=Tl),ga.forEach(t),As=p(e),at=n(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1vs36va"&&(at.innerHTML=Jl),Ps=p(e),u(lt.$$.fragment,e),Qs=p(e),X=n(e,"H2",{class:!0});var Ma=c(X);D=n(Ma,"A",{id:!0,class:!0,href:!0});var Dl=c(D);Rt=n(Dl,"SPAN",{});var Kl=c(Rt);u(nt.$$.fragment,Kl),Kl.forEach(t),Dl.forEach(t),Ga=p(Ma),xt=n(Ma,"SPAN",{"data-svelte-h":!0}),r(xt)!=="svelte-ag1idn"&&(xt.textContent=$l),Ma.forEach(t),Ds=p(e),it=n(e,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1s97n77"&&(it.innerHTML=Ul),Ks=p(e),pt=n(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-4s0csr"&&(pt.innerHTML=xl),Os=p(e),u(rt.$$.fragment,e),ea=p(e),u(K.$$.fragment,e),ta=p(e),H=n(e,"H2",{class:!0});var va=c(H);O=n(va,"A",{id:!0,class:!0,href:!0});var Ol=c(O);Nt=n(Ol,"SPAN",{});var en=c(Nt);u(ot.$$.fragment,en),en.forEach(t),Ol.forEach(t),_a=p(va),kt=n(va,"SPAN",{"data-svelte-h":!0}),r(kt)!=="svelte-1w79szp"&&(kt.innerHTML=kl),va.forEach(t),sa=p(e),ht=n(e,"P",{"data-svelte-h":!0}),r(ht)!=="svelte-32c7q2"&&(ht.innerHTML=Zl),aa=p(e),ct=n(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-1yg483v"&&(ct.innerHTML=Il),la=p(e),u(mt.$$.fragment,e),na=p(e),ut=n(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-1c9ycn6"&&(ut.innerHTML=Gl),ia=p(e),u(ft.$$.fragment,e),pa=p(e),dt=n(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1f2oxpa"&&(dt.textContent=_l),ra=p(e),Vt=n(e,"P",{}),c(Vt).forEach(t),this.h()},h(){o(g,"name","hf:doc:metadata"),o(g,"content",JSON.stringify(fn)),o(M,"id","pipelines-for-inference"),o(M,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(M,"href","#pipelines-for-inference"),o(J,"class","relative group"),o(V,"id","pipeline-usage"),o(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(V,"href","#pipeline-usage"),o(x,"class","relative group"),o(S,"start","2"),o(Y,"id","parameters"),o(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Y,"href","#parameters"),o(k,"class","relative group"),o(q,"id","device"),o(q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(q,"href","#device"),o(Z,"class","relative group"),o(E,"id","batch-size"),o(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(E,"href","#batch-size"),o(I,"class","relative group"),o(z,"id","task-specific-parameters"),o(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(z,"href","#task-specific-parameters"),o(G,"class","relative group"),o(F,"id","using-pipelines-on-a-dataset"),o(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(F,"href","#using-pipelines-on-a-dataset"),o(_,"class","relative group"),o(L,"id","using-pipelines-for-a-webserver"),o(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(L,"href","#using-pipelines-for-a-webserver"),o(C,"class","relative group"),o(P,"id","vision-pipeline"),o(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(P,"href","#vision-pipeline"),o(B,"class","relative group"),o(Q,"id","text-pipeline"),o(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Q,"href","#text-pipeline"),o(W,"class","relative group"),o(D,"id","multimodal-pipeline"),o(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(D,"href","#multimodal-pipeline"),o(X,"class","relative group"),o(O,"id","using-pipeline-on-large-models-with-accelerate"),o(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(O,"href","#using-pipeline-on-large-models-with-accelerate"),o(H,"class","relative group")},m(e,s){h(document.head,g),a(e,j,s),a(e,b,s),a(e,T,s),a(e,J,s),h(J,M),h(M,U),f(ee,U,null),h(J,ba),h(J,wt),a(e,qt,s),a(e,te,s),a(e,Et,s),a(e,se,s),a(e,zt,s),f(N,e,s),a(e,Ft,s),a(e,x,s),h(x,V),h(V,Zt),f(ae,Zt,null),h(x,ja),h(x,gt),a(e,Lt,s),a(e,le,s),a(e,At,s),a(e,ne,s),a(e,Pt,s),f(ie,e,s),a(e,Qt,s),a(e,S,s),a(e,Dt,s),f(pe,e,s),a(e,Kt,s),a(e,re,s),a(e,Ot,s),a(e,oe,s),a(e,es,s),a(e,he,s),a(e,ts,s),f(ce,e,s),a(e,ss,s),a(e,me,s),a(e,as,s),a(e,ue,s),a(e,ls,s),f(fe,e,s),a(e,ns,s),a(e,de,s),a(e,is,s),a(e,ye,s),a(e,ps,s),a(e,k,s),h(k,Y),h(Y,It),f(we,It,null),h(k,Ta),h(k,Mt),a(e,rs,s),a(e,ge,s),a(e,os,s),f(Me,e,s),a(e,hs,s),a(e,ve,s),a(e,cs,s),a(e,Z,s),h(Z,q),h(q,Gt),f(be,Gt,null),h(Z,Ja),h(Z,vt),a(e,ms,s),a(e,je,s),a(e,us,s),f(Te,e,s),a(e,fs,s),a(e,Je,s),a(e,ds,s),f($e,e,s),a(e,ys,s),a(e,Ue,s),a(e,ws,s),f(xe,e,s),a(e,gs,s),a(e,ke,s),a(e,Ms,s),a(e,I,s),h(I,E),h(E,_t),f(Ze,_t,null),h(I,$a),h(I,bt),a(e,vs,s),a(e,Ie,s),a(e,bs,s),a(e,Ge,s),a(e,js,s),f(_e,e,s),a(e,Ts,s),a(e,Ce,s),a(e,Js,s),a(e,Be,s),a(e,$s,s),a(e,G,s),h(G,z),h(z,Ct),f(We,Ct,null),h(G,Ua),h(G,jt),a(e,Us,s),a(e,Xe,s),a(e,xs,s),f(He,e,s),a(e,ks,s),a(e,Re,s),a(e,Zs,s),a(e,Ne,s),a(e,Is,s),f(Ve,e,s),a(e,Gs,s),a(e,Se,s),a(e,_s,s),a(e,_,s),h(_,F),h(F,Bt),f(Ye,Bt,null),h(_,xa),h(_,Tt),a(e,Cs,s),a(e,qe,s),a(e,Bs,s),f(Ee,e,s),a(e,Ws,s),a(e,ze,s),a(e,Xs,s),a(e,Fe,s),a(e,Hs,s),a(e,Le,s),a(e,Rs,s),f(Ae,e,s),a(e,Ns,s),a(e,C,s),h(C,L),h(L,Wt),f(Pe,Wt,null),h(C,ka),h(C,Jt),a(e,Vs,s),f(A,e,s),a(e,Ss,s),a(e,Qe,s),a(e,Ys,s),a(e,B,s),h(B,P),h(P,Xt),f(De,Xt,null),h(B,Za),h(B,$t),a(e,qs,s),a(e,Ke,s),a(e,Es,s),a(e,Oe,s),a(e,zs,s),a(e,et,s),a(e,Fs,s),f(tt,e,s),a(e,Ls,s),a(e,W,s),h(W,Q),h(Q,Ht),f(st,Ht,null),h(W,Ia),h(W,Ut),a(e,As,s),a(e,at,s),a(e,Ps,s),f(lt,e,s),a(e,Qs,s),a(e,X,s),h(X,D),h(D,Rt),f(nt,Rt,null),h(X,Ga),h(X,xt),a(e,Ds,s),a(e,it,s),a(e,Ks,s),a(e,pt,s),a(e,Os,s),f(rt,e,s),a(e,ea,s),f(K,e,s),a(e,ta,s),a(e,H,s),h(H,O),h(O,Nt),f(ot,Nt,null),h(H,_a),h(H,kt),a(e,sa,s),a(e,ht,s),a(e,aa,s),a(e,ct,s),a(e,la,s),f(mt,e,s),a(e,na,s),a(e,ut,s),a(e,ia,s),f(ft,e,s),a(e,pa,s),a(e,dt,s),a(e,ra,s),a(e,Vt,s),oa=!0},p(e,[s]){const yt={};s&2&&(yt.$$scope={dirty:s,ctx:e}),N.$set(yt);const St={};s&2&&(St.$$scope={dirty:s,ctx:e}),A.$set(St);const Yt={};s&2&&(Yt.$$scope={dirty:s,ctx:e}),K.$set(Yt)},i(e){oa||(d(ee.$$.fragment,e),d(N.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(we.$$.fragment,e),d(Me.$$.fragment,e),d(be.$$.fragment,e),d(Te.$$.fragment,e),d($e.$$.fragment,e),d(xe.$$.fragment,e),d(Ze.$$.fragment,e),d(_e.$$.fragment,e),d(We.$$.fragment,e),d(He.$$.fragment,e),d(Ve.$$.fragment,e),d(Ye.$$.fragment,e),d(Ee.$$.fragment,e),d(Ae.$$.fragment,e),d(Pe.$$.fragment,e),d(A.$$.fragment,e),d(De.$$.fragment,e),d(tt.$$.fragment,e),d(st.$$.fragment,e),d(lt.$$.fragment,e),d(nt.$$.fragment,e),d(rt.$$.fragment,e),d(K.$$.fragment,e),d(ot.$$.fragment,e),d(mt.$$.fragment,e),d(ft.$$.fragment,e),oa=!0)},o(e){y(ee.$$.fragment,e),y(N.$$.fragment,e),y(ae.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(fe.$$.fragment,e),y(we.$$.fragment,e),y(Me.$$.fragment,e),y(be.$$.fragment,e),y(Te.$$.fragment,e),y($e.$$.fragment,e),y(xe.$$.fragment,e),y(Ze.$$.fragment,e),y(_e.$$.fragment,e),y(We.$$.fragment,e),y(He.$$.fragment,e),y(Ve.$$.fragment,e),y(Ye.$$.fragment,e),y(Ee.$$.fragment,e),y(Ae.$$.fragment,e),y(Pe.$$.fragment,e),y(A.$$.fragment,e),y(De.$$.fragment,e),y(tt.$$.fragment,e),y(st.$$.fragment,e),y(lt.$$.fragment,e),y(nt.$$.fragment,e),y(rt.$$.fragment,e),y(K.$$.fragment,e),y(ot.$$.fragment,e),y(mt.$$.fragment,e),y(ft.$$.fragment,e),oa=!1},d(e){e&&(t(j),t(b),t(T),t(J),t(qt),t(te),t(Et),t(se),t(zt),t(Ft),t(x),t(Lt),t(le),t(At),t(ne),t(Pt),t(Qt),t(S),t(Dt),t(Kt),t(re),t(Ot),t(oe),t(es),t(he),t(ts),t(ss),t(me),t(as),t(ue),t(ls),t(ns),t(de),t(is),t(ye),t(ps),t(k),t(rs),t(ge),t(os),t(hs),t(ve),t(cs),t(Z),t(ms),t(je),t(us),t(fs),t(Je),t(ds),t(ys),t(Ue),t(ws),t(gs),t(ke),t(Ms),t(I),t(vs),t(Ie),t(bs),t(Ge),t(js),t(Ts),t(Ce),t(Js),t(Be),t($s),t(G),t(Us),t(Xe),t(xs),t(ks),t(Re),t(Zs),t(Ne),t(Is),t(Gs),t(Se),t(_s),t(_),t(Cs),t(qe),t(Bs),t(Ws),t(ze),t(Xs),t(Fe),t(Hs),t(Le),t(Rs),t(Ns),t(C),t(Vs),t(Ss),t(Qe),t(Ys),t(B),t(qs),t(Ke),t(Es),t(Oe),t(zs),t(et),t(Fs),t(Ls),t(W),t(As),t(at),t(Ps),t(Qs),t(X),t(Ds),t(it),t(Ks),t(pt),t(Os),t(ea),t(ta),t(H),t(sa),t(ht),t(aa),t(ct),t(la),t(na),t(ut),t(ia),t(pa),t(dt),t(ra),t(Vt)),t(g),w(ee),w(N,e),w(ae),w(ie,e),w(pe,e),w(ce,e),w(fe,e),w(we),w(Me,e),w(be),w(Te,e),w($e,e),w(xe,e),w(Ze),w(_e,e),w(We),w(He,e),w(Ve,e),w(Ye),w(Ee,e),w(Ae,e),w(Pe),w(A,e),w(De),w(tt,e),w(st),w(lt,e),w(nt),w(rt,e),w(K,e),w(ot),w(mt,e),w(ft,e)}}}const fn={local:"pipelines-for-inference",sections:[{local:"pipeline-usage",title:"Pipeline usage"},{local:"parameters",sections:[{local:"device",title:"Device"},{local:"batch-size",title:"Batch size"},{local:"task-specific-parameters",title:"Task specific parameters"}],title:"Parameters"},{local:"using-pipelines-on-a-dataset",title:"Using pipelines on a dataset"},{local:"using-pipelines-for-a-webserver",title:"Using pipelines for a webserver"},{local:"vision-pipeline",title:"Vision pipeline"},{local:"text-pipeline",title:"Text pipeline"},{local:"multimodal-pipeline",title:"Multimodal pipeline"},{local:"using-pipeline-on-large-models-with-accelerate",title:"Using `pipeline` on large models with 🤗 `accelerate`:"}],title:"Pipelines for inference"};function dn(R){return an(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bn extends ln{constructor(g){super(),nn(this,g,dn,un,sn,{})}}export{bn as component};
