import{s as hi,n as mi,o as ui}from"../chunks/scheduler.9bc65507.js";import{S as gi,i as di,g as n,s as i,u as m,A as yi,h as l,f as t,c as r,j as h,v as u,y as c,k as p,o,a,w as g,d,t as y,x as j}from"../chunks/index.78c82d43.js";import{I as f}from"../chunks/IconCopyLink.bedaa44d.js";import{C as M}from"../chunks/CodeBlock.73e038be.js";function ji(xn){let w,he,Qt,me,x,_,Yt,ns,Oa,Ut,bn="What 🤗 Transformers can do",ue,ls,Jn="🤗 Transformers is a library of pretrained state-of-the-art models for natural language processing (NLP), computer vision, and audio and speech processing tasks. Not only does the library contain Transformer models, but it also has non-Transformer models like modern convolutional networks for computer vision tasks. If you look at some of the most popular consumer products today, like smartphones, apps, and televisions, odds are that some kind of deep learning technology is behind it. Want to remove a background object from a picture taken by your smartphone? This is an example of a panoptic segmentation task (don’t worry if you don’t know what this means yet, we’ll describe it in the following sections!).",ge,is,vn="This page provides an overview of the different speech and audio, computer vision, and NLP tasks that can be solved with the 🤗 Transformers library in just three lines of code!",de,b,R,Xt,rs,sn,Tt,Un="Audio",ye,os,Tn="Audio and speech processing tasks are a little different from the other modalities mainly because audio as an input is a continuous signal. Unlike text, a raw audio waveform can’t be neatly split into discrete chunks the way a sentence can be divided into words. To get around this, the raw audio signal is typically sampled at regular intervals. If you take more samples within an interval, the sampling rate is higher, and the audio more closely resembles the original audio source.",je,ps,kn="Previous approaches preprocessed the audio to extract useful features from it. It is now more common to start audio and speech processing tasks by directly feeding the raw audio waveform to a feature encoder to extract an audio representation. This simplifies the preprocessing step and allows the model to learn the most essential features.",fe,J,E,Ft,cs,tn,kt,Cn="Audio classification",Me,hs,In="Audio classification is a task that labels audio data from a predefined set of classes. It is a broad category with many specific applications, some of which include:",we,ms,Zn="<li>acoustic scene classification: label audio with a scene label (“office”, “beach”, “stadium”)</li> <li>acoustic event detection: label audio with a sound event label (“car horn”, “whale calling”, “glass breaking”)</li> <li>tagging: label audio containing multiple sounds (birdsongs, speaker identification in a meeting)</li> <li>music classification: label music with a genre label (“metal”, “hip-hop”, “country”)</li>",xe,us,be,v,z,Lt,gs,en,Ct,Bn="Automatic speech recognition",Je,ds,Wn="Automatic speech recognition (ASR) transcribes speech into text. It is one of the most common audio tasks due partly to speech being such a natural form of human communication. Today, ASR systems are embedded in “smart” technology products like speakers, phones, and cars. We can ask our virtual assistants to play music, set reminders, and tell us the weather.",ve,ys,$n="But one of the key challenges Transformer architectures have helped with is in low-resource languages. By pretraining on large amounts of speech data, finetuning the model on only one hour of labeled speech data in a low-resource language can still produce high-quality results compared to previous ASR systems trained on 100x more labeled data.",Ue,js,Te,U,A,Pt,fs,an,It,qn="Computer vision",ke,Ms,Gn='One of the first and earliest successful computer vision tasks was recognizing images of zip code numbers using a <a href="glossary#convolution">convolutional neural network (CNN)</a>. An image is composed of pixels, and each pixel has a numerical value. This makes it easy to represent an image as a matrix of pixel values. Each particular combination of pixel values describes the colors of an image.',Ce,ws,Nn="Two general ways computer vision tasks can be solved are:",Ie,xs,Hn="<li>Use convolutions to learn the hierarchical features of an image from low-level features to high-level abstract things.</li> <li>Split an image into patches and use a Transformer to gradually learn how each image patch is related to each other to form an image. Unlike the bottom-up approach favored by a CNN, this is kind of like starting out with a blurry image and then gradually bringing it into focus.</li>",Ze,T,S,Kt,bs,nn,Zt,Vn="Image classification",Be,Js,_n="Image classification labels an entire image from a predefined set of classes. Like most classification tasks, there are many practical use cases for image classification, some of which include:",We,vs,Rn="<li>healthcare: label medical images to detect disease or monitor patient health</li> <li>environment: label satellite images to monitor deforestation, inform wildland management or detect wildfires</li> <li>agriculture: label images of crops to monitor plant health or satellite images for land use monitoring</li> <li>ecology: label images of animal or plant species to monitor wildlife populations or track endangered species</li>",$e,Us,qe,k,Q,Dt,Ts,ln,Bt,En="Object detection",Ge,ks,zn="Unlike image classification, object detection identifies multiple objects within an image and the objects’ positions in an image (defined by the bounding box). Some example applications of object detection include:",Ne,Cs,An="<li>self-driving vehicles: detect everyday traffic objects such as other vehicles, pedestrians, and traffic lights</li> <li>remote sensing: disaster monitoring, urban planning, and weather forecasting</li> <li>defect detection: detect cracks or structural damage in buildings, and manufacturing defects</li>",He,Is,Ve,C,Y,Ot,Zs,rn,Wt,Sn="Image segmentation",_e,Bs,Qn="Image segmentation is a pixel-level task that assigns every pixel in an image to a class. It differs from object detection, which uses bounding boxes to label and predict objects in an image because segmentation is more granular. Segmentation can detect objects at a pixel-level. There are several types of image segmentation:",Re,Ws,Yn="<li>instance segmentation: in addition to labeling the class of an object, it also labels each distinct instance of an object (“dog-1”, “dog-2”)</li> <li>panoptic segmentation: a combination of semantic and instance segmentation; it labels each pixel with a semantic class <strong>and</strong> each distinct instance of an object</li>",Ee,$s,Xn="Segmentation tasks are helpful in self-driving vehicles to create a pixel-level map of the world around them so they can navigate safely around pedestrians and other vehicles. It is also useful for medical imaging, where the task’s finer granularity can help identify abnormal cells or organ features. Image segmentation can also be used in ecommerce to virtually try on clothes or create augmented reality experiences by overlaying objects in the real world through your camera.",ze,qs,Ae,I,X,se,Gs,on,$t,Fn="Depth estimation",Se,Ns,Ln="Depth estimation predicts the distance of each pixel in an image from the camera. This computer vision task is especially important for scene understanding and reconstruction. For example, in self-driving cars, vehicles need to understand how far objects like pedestrians, traffic signs, and other vehicles are to avoid obstacles and collisions. Depth information is also helpful for constructing 3D representations from 2D images and can be used to create high-quality 3D representations of biological structures or buildings.",Qe,Hs,Pn="There are two approaches to depth estimation:",Ye,Vs,Kn="<li>stereo: depths are estimated by comparing two images of the same image from slightly different angles</li> <li>monocular: depths are estimated from a single image</li>",Xe,_s,Fe,Z,F,te,Rs,pn,qt,Dn="Natural language processing",Le,Es,On="NLP tasks are among the most common types of tasks because text is such a natural way for us to communicate. To get text into a format recognized by a model, it needs to be tokenized. This means dividing a sequence of text into separate words or subwords (tokens) and then converting these tokens into numbers. As a result, you can represent a sequence of text as a sequence of numbers, and once you have a sequence of numbers, it can be input into a model to solve all sorts of NLP tasks!",Pe,B,L,ee,zs,cn,Gt,sl="Text classification",Ke,As,tl="Like classification tasks in any modality, text classification labels a sequence of text (it can be sentence-level, a paragraph, or a document) from a predefined set of classes. There are many practical applications for text classification, some of which include:",De,Ss,el="<li>sentiment analysis: label text according to some polarity like <code>positive</code> or <code>negative</code> which can inform and support decision-making in fields like politics, finance, and marketing</li> <li>content classification: label text according to some topic to help organize and filter information in news and social media feeds (<code>weather</code>, <code>sports</code>, <code>finance</code>, etc.)</li>",Oe,Qs,sa,W,P,ae,Ys,hn,Nt,al="Token classification",ta,Xs,nl='In any NLP task, text is preprocessed by separating the sequence of text into individual words or subwords. These are known as <a href="/glossary#token">tokens</a>. Token classification assigns each token a label from a predefined set of classes.',ea,Fs,ll="Two common types of token classification are:",aa,Ls,il="<li>named entity recognition (NER): label a token according to an entity category like organization, person, location or date. NER is especially popular in biomedical settings, where it can label genes, proteins, and drug names.</li> <li>part-of-speech tagging (POS): label a token according to its part-of-speech like noun, verb, or adjective. POS is useful for helping translation systems understand how two identical words are grammatically different (bank as a noun versus bank as a verb).</li>",na,Ps,la,$,K,ne,Ks,mn,Ht,rl="Question answering",ia,Ds,ol="Question answering is another token-level task that returns an answer to a question, sometimes with context (open-domain) and other times without context (closed-domain). This task happens whenever we ask a virtual assistant something like whether a restaurant is open. It can also provide customer or technical support and help search engines retrieve the relevant information you’re asking for.",ra,Os,pl="There are two common types of question answering:",oa,st,cl='<li>extractive: given a question and some context, the answer is a span of text from the context the model must extract</li> <li>abstractive: given a question and some context, the answer is generated from the context; this approach is handled by the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.Text2TextGenerationPipeline">Text2TextGenerationPipeline</a> instead of the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.QuestionAnsweringPipeline">QuestionAnsweringPipeline</a> shown below</li>',pa,tt,ca,q,D,le,et,un,Vt,hl="Summarization",ha,at,ml="Summarization creates a shorter version of a text from a longer one while trying to preserve most of the meaning of the original document. Summarization is a sequence-to-sequence task; it outputs a shorter text sequence than the input. There are a lot of long-form documents that can be summarized to help readers quickly understand the main points. Legislative bills, legal and financial documents, patents, and scientific papers are a few examples of documents that could be summarized to save readers time and serve as a reading aid.",ma,nt,ul="Like question answering, there are two types of summarization:",ua,lt,gl='<li>extractive: identify and extract the most important sentences from the original text</li> <li>abstractive: generate the target summary (which may include new words not in the input document) from the original text; the <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.SummarizationPipeline">SummarizationPipeline</a> uses the abstractive approach</li>',ga,it,da,G,O,ie,rt,gn,_t,dl="Translation",ya,ot,yl="Translation converts a sequence of text in one language to another. It is important in helping people from different backgrounds communicate with each other, help translate content to reach wider audiences, and even be a learning tool to help people learn a new language. Along with summarization, translation is a sequence-to-sequence task, meaning the model receives an input sequence and returns a target output sequence.",ja,pt,jl="In the early days, translation models were mostly monolingual, but recently, there has been increasing interest in multilingual models that can translate between many pairs of languages.",fa,ct,Ma,N,ss,re,ht,dn,Rt,fl="Language modeling",wa,mt,Ml="Language modeling is a task that predicts a word in a sequence of text. It has become a very popular NLP task because a pretrained language model can be finetuned for many other downstream tasks. Lately, there has been a lot of interest in large language models (LLMs) which demonstrate zero- or few-shot learning. This means the model can solve tasks it wasn’t explicitly trained to do! Language models can be used to generate fluent and convincing text, though you need to be careful since the text may not always be accurate.",xa,ut,wl="There are two types of language modeling:",ba,ts,gt,Et,xl="causal: the model’s objective is to predict the next token in a sequence, and future tokens are masked",yn,dt,jn,yt,zt,bl="masked: the model’s objective is to predict a masked token in a sequence with full access to the tokens in the sequence",fn,jt,Ja,H,es,oe,ft,Mn,At,Jl="Multimodal",va,Mt,vl="Multimodal tasks require a model to process multiple data modalities (text, image, audio, video) to solve a particular problem. Image captioning is an example of a multimodal task where the model takes an image as input and outputs a sequence of text describing the image or some properties of the image.",Ua,wt,Ul="Although multimodal models work with different data types or modalities, internally, the preprocessing steps help the model convert all the data types into embeddings (vectors or list of numbers that holds meaningful information about the data). For a task like image captioning, the model learns relationships between image embeddings and text embeddings.",Ta,V,as,pe,xt,wn,St,Tl="Document question answering",ka,bt,kl="Document question answering is a task that answers natural language questions from a document. Unlike a token-level question answering task which takes text as input, document question answering takes an image of a document as input along with a question about the document and returns an answer. Document question answering can be used to parse structured documents and extract key information from it. In the example below, the total amount and change due can be extracted from a receipt.",Ca,Jt,Ia,vt,Cl='Hopefully, this page has given you some more background information about all the types of tasks in each modality and the practical importance of each one. In the next <a href="tasks_explained">section</a>, you’ll learn <strong>how</strong> 🤗 Transformers work to solve these tasks.',Za,ce,Ba;return ns=new f({}),rs=new f({}),cs=new f({}),us=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyc3VwZXJiJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWVyJTIyKSUwQXByZWRzJTIwJTNEJTIwY2xhc3NpZmllciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTdEJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlNUQlMEFwcmVkcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;superb/hubert-base-superb-er&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4532</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;hap&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.3622</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0943</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neu&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0903</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;ang&#x27;</span>}]`,wrap:!1}}),gs=new f({}),js=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdHJhbnNjcmliZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyYXV0b21hdGljLXNwZWVjaC1yZWNvZ25pdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyb3BlbmFpJTJGd2hpc3Blci1zbWFsbCUyMiklMEF0cmFuc2NyaWJlciglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber = pipeline(task=<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=<span class="hljs-string">&quot;openai/whisper-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transcriber(<span class="hljs-string">&quot;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&quot;</span>)
{<span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27; I have a dream that one day this nation will rise up and live out the true meaning of its creed.&#x27;</span>}`,wrap:!1}}),fs=new f({}),bs=new f({}),Us=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1jbGFzc2lmaWNhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGNsYXNzaWZpZXIoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByaW50KCpwcmVkcyUyQyUyMHNlcCUzRCUyMiU1Q24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}`,wrap:!1}}),Ts=new f({}),Is=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGV0ZWN0b3IlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyb2JqZWN0LWRldGVjdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMGRldGVjdG9yKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnBpcGVsaW5lLWNhdC1jaG9uay5qcGVnJTIyJTBBKSUwQXByZWRzJTIwJTNEJTIwJTVCJTdCJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwcHJlZCU1QiUyMmxhYmVsJTIyJTVEJTJDJTIwJTIyYm94JTIyJTNBJTIwcHJlZCU1QiUyMmJveCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>detector = pipeline(task=<span class="hljs-string">&quot;object-detection&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = detector(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>], <span class="hljs-string">&quot;box&quot;</span>: pred[<span class="hljs-string">&quot;box&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9865</span>,
  <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>,
  <span class="hljs-string">&#x27;box&#x27;</span>: {<span class="hljs-string">&#x27;xmin&#x27;</span>: <span class="hljs-number">178</span>, <span class="hljs-string">&#x27;ymin&#x27;</span>: <span class="hljs-number">154</span>, <span class="hljs-string">&#x27;xmax&#x27;</span>: <span class="hljs-number">882</span>, <span class="hljs-string">&#x27;ymax&#x27;</span>: <span class="hljs-number">598</span>}}]`,wrap:!1}}),Zs=new f({}),qs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmltYWdlLXNlZ21lbnRhdGlvbiUyMiklMEFwcmVkcyUyMCUzRCUyMHNlZ21lbnRlciglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJpbnQoKnByZWRzJTJDJTIwc2VwJTNEJTIyJTVDbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>segmenter = pipeline(task=<span class="hljs-string">&quot;image-segmentation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = segmenter(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9879</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;LABEL_184&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9973</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow&#x27;</span>}
{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9972</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cat&#x27;</span>}`,wrap:!1}}),Gs=new f({}),_s=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMmRlcHRoLWVzdGltYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGcGlwZWxpbmUtY2F0LWNob25rLmpwZWclMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(task=<span class="hljs-string">&quot;depth-estimation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = depth_estimator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),Rs=new f({}),zs=new f({}),Qs=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzZW50aW1lbnQtYW5hbHlzaXMlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjB0aGUlMjBiZXN0JTIwdGhpbmclMjBzaW5jZSUyMHNsaWNlZCUyMGJyZWFkISUyMiklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;sentiment-analysis&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is the best thing since sliced bread!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9991</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;POSITIVE&#x27;</span>}]`,wrap:!1}}),Ys=new f({}),Ps=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJuZXIlMjIpJTBBcHJlZHMlMjAlM0QlMjBjbGFzc2lmaWVyKCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwRnJlbmNoJTIwY29tcGFueSUyMGJhc2VkJTIwaW4lMjBOZXclMjBZb3JrJTIwQ2l0eS4lMjIpJTBBcHJlZHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbnRpdHklMjIlM0ElMjBwcmVkJTVCJTIyZW50aXR5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc2NvcmUlMjIlM0ElMjByb3VuZChwcmVkJTVCJTIyc2NvcmUlMjIlNUQlMkMlMjA0KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmluZGV4JTIyJTNBJTIwcHJlZCU1QiUyMmluZGV4JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyd29yZCUyMiUzQSUyMHByZWQlNUIlMjJ3b3JkJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyc3RhcnQlMjIlM0ElMjBwcmVkJTVCJTIyc3RhcnQlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJlbmQlMjIlM0ElMjBwcmVkJTVCJTIyZW5kJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwZm9yJTIwcHJlZCUyMGluJTIwcHJlZHMlMEElNUQlMEFwcmludCgqcHJlZHMlMkMlMjBzZXAlM0QlMjIlNUNuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>classifier = pipeline(task=<span class="hljs-string">&quot;ner&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = classifier(<span class="hljs-string">&quot;Hugging Face is a French company based in New York City.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;entity&quot;</span>: pred[<span class="hljs-string">&quot;entity&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;index&quot;</span>: pred[<span class="hljs-string">&quot;index&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;word&quot;</span>: pred[<span class="hljs-string">&quot;word&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;start&quot;</span>: pred[<span class="hljs-string">&quot;start&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;end&quot;</span>: pred[<span class="hljs-string">&quot;end&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(*preds, sep=<span class="hljs-string">&quot;\\n&quot;</span>)
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9968</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Hu&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">2</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9293</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;##gging&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">7</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-ORG&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9763</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;Face&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">8</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">12</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-MISC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9983</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">6</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;French&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">18</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">24</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.999</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">10</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;New&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">42</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">45</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9987</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">11</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;York&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">46</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">50</span>}
{<span class="hljs-string">&#x27;entity&#x27;</span>: <span class="hljs-string">&#x27;I-LOC&#x27;</span>, <span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9992</span>, <span class="hljs-string">&#x27;index&#x27;</span>: <span class="hljs-number">12</span>, <span class="hljs-string">&#x27;word&#x27;</span>: <span class="hljs-string">&#x27;City&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">51</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">55</span>}`,wrap:!1}}),Ks=new f({}),tt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcXVlc3Rpb25fYW5zd2VyZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIycXVlc3Rpb24tYW5zd2VyaW5nJTIyKSUwQXByZWRzJTIwJTNEJTIwcXVlc3Rpb25fYW5zd2VyZXIoJTBBJTIwJTIwJTIwJTIwcXVlc3Rpb24lM0QlMjJXaGF0JTIwaXMlMjB0aGUlMjBuYW1lJTIwb2YlMjB0aGUlMjByZXBvc2l0b3J5JTNGJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29udGV4dCUzRCUyMlRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMHJlcG9zaXRvcnklMjBpcyUyMGh1Z2dpbmdmYWNlJTJGdHJhbnNmb3JtZXJzJTIyJTJDJTBBKSUwQXByaW50KCUwQSUyMCUyMCUyMCUyMGYlMjJzY29yZSUzQSUyMCU3QnJvdW5kKHByZWRzJTVCJ3Njb3JlJyU1RCUyQyUyMDQpJTdEJTJDJTIwc3RhcnQlM0ElMjAlN0JwcmVkcyU1QidzdGFydCclNUQlN0QlMkMlMjBlbmQlM0ElMjAlN0JwcmVkcyU1QidlbmQnJTVEJTdEJTJDJTIwYW5zd2VyJTNBJTIwJTdCcHJlZHMlNUInYW5zd2VyJyU1RCU3RCUyMiUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>question_answerer = pipeline(task=<span class="hljs-string">&quot;question-answering&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the name of the repository?&quot;</span>,
<span class="hljs-meta">... </span>    context=<span class="hljs-string">&quot;The name of the repository is huggingface/transformers&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>    <span class="hljs-string">f&quot;score: <span class="hljs-subst">{<span class="hljs-built_in">round</span>(preds[<span class="hljs-string">&#x27;score&#x27;</span>], <span class="hljs-number">4</span>)}</span>, start: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;start&#x27;</span>]}</span>, end: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;end&#x27;</span>]}</span>, answer: <span class="hljs-subst">{preds[<span class="hljs-string">&#x27;answer&#x27;</span>]}</span>&quot;</span>
<span class="hljs-meta">... </span>)
score: <span class="hljs-number">0.9327</span>, start: <span class="hljs-number">30</span>, end: <span class="hljs-number">54</span>, answer: huggingface/transformers`,wrap:!1}}),et=new f({}),it=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBc3VtbWFyaXplciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJzdW1tYXJpemF0aW9uJTIyKSUwQXN1bW1hcml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySW4lMjB0aGlzJTIwd29yayUyQyUyMHdlJTIwcHJlc2VudGVkJTIwdGhlJTIwVHJhbnNmb3JtZXIlMkMlMjB0aGUlMjBmaXJzdCUyMHNlcXVlbmNlJTIwdHJhbnNkdWN0aW9uJTIwbW9kZWwlMjBiYXNlZCUyMGVudGlyZWx5JTIwb24lMjBhdHRlbnRpb24lMkMlMjByZXBsYWNpbmclMjB0aGUlMjByZWN1cnJlbnQlMjBsYXllcnMlMjBtb3N0JTIwY29tbW9ubHklMjB1c2VkJTIwaW4lMjBlbmNvZGVyLWRlY29kZXIlMjBhcmNoaXRlY3R1cmVzJTIwd2l0aCUyMG11bHRpLWhlYWRlZCUyMHNlbGYtYXR0ZW50aW9uLiUyMEZvciUyMHRyYW5zbGF0aW9uJTIwdGFza3MlMkMlMjB0aGUlMjBUcmFuc2Zvcm1lciUyMGNhbiUyMGJlJTIwdHJhaW5lZCUyMHNpZ25pZmljYW50bHklMjBmYXN0ZXIlMjB0aGFuJTIwYXJjaGl0ZWN0dXJlcyUyMGJhc2VkJTIwb24lMjByZWN1cnJlbnQlMjBvciUyMGNvbnZvbHV0aW9uYWwlMjBsYXllcnMuJTIwT24lMjBib3RoJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tR2VybWFuJTIwYW5kJTIwV01UJTIwMjAxNCUyMEVuZ2xpc2gtdG8tRnJlbmNoJTIwdHJhbnNsYXRpb24lMjB0YXNrcyUyQyUyMHdlJTIwYWNoaWV2ZSUyMGElMjBuZXclMjBzdGF0ZSUyMG9mJTIwdGhlJTIwYXJ0LiUyMEluJTIwdGhlJTIwZm9ybWVyJTIwdGFzayUyMG91ciUyMGJlc3QlMjBtb2RlbCUyMG91dHBlcmZvcm1zJTIwZXZlbiUyMGFsbCUyMHByZXZpb3VzbHklMjByZXBvcnRlZCUyMGVuc2VtYmxlcy4lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer = pipeline(task=<span class="hljs-string">&quot;summarization&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>summarizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;In this work, we presented the Transformer, the first sequence transduction model based entirely on attention, replacing the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention. For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers. On both WMT 2014 English-to-German and WMT 2014 English-to-French translation tasks, we achieve a new state of the art. In the former task our best model outperforms even all previously reported ensembles.&quot;</span>
<span class="hljs-meta">... </span>)
[{<span class="hljs-string">&#x27;summary_text&#x27;</span>: <span class="hljs-string">&#x27; The Transformer is the first sequence transduction model based entirely on attention . It replaces the recurrent layers most commonly used in encoder-decoder architectures with multi-headed self-attention . For translation tasks, the Transformer can be trained significantly faster than architectures based on recurrent or convolutional layers .&#x27;</span>}]`,wrap:!1}}),rt=new f({}),ct=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdGV4dCUyMCUzRCUyMCUyMnRyYW5zbGF0ZSUyMEVuZ2xpc2glMjB0byUyMEZyZW5jaCUzQSUyMEh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjBwbGF0Zm9ybSUyMGZvciUyMG1hY2hpbmUlMjBsZWFybmluZy4lMjIlMEF0cmFuc2xhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRyYW5zbGF0aW9uJTIyJTJDJTIwbW9kZWwlM0QlMjJ0NS1zbWFsbCUyMiklMEF0cmFuc2xhdG9yKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;translate English to French: Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>translator = pipeline(task=<span class="hljs-string">&quot;translation&quot;</span>, model=<span class="hljs-string">&quot;t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>translator(text)
[{<span class="hljs-string">&#x27;translation_text&#x27;</span>: <span class="hljs-string">&quot;Hugging Face est une tribune communautaire de l&#x27;apprentissage des machines.&quot;</span>}]`,wrap:!1}}),ht=new f({}),dt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIySHVnZ2luZyUyMEZhY2UlMjBpcyUyMGElMjBjb21tdW5pdHktYmFzZWQlMjBvcGVuLXNvdXJjZSUyMHBsYXRmb3JtJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWdlbmVyYXRvciUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJ0ZXh0LWdlbmVyYXRpb24lMjIpJTBBZ2VuZXJhdG9yKHByb21wdCklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Hugging Face is a community-based open-source platform for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generator(prompt)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),jt=new M({props:{code:"dGV4dCUyMCUzRCUyMCUyMkh1Z2dpbmclMjBGYWNlJTIwaXMlMjBhJTIwY29tbXVuaXR5LWJhc2VkJTIwb3Blbi1zb3VyY2UlMjAlM0NtYXNrJTNFJTIwZm9yJTIwbWFjaGluZSUyMGxlYXJuaW5nLiUyMiUwQWZpbGxfbWFzayUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJmaWxsLW1hc2slMjIpJTBBcHJlZHMlMjAlM0QlMjBmaWxsX21hc2sodGV4dCUyQyUyMHRvcF9rJTNEMSklMEFwcmVkcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0b2tlbiUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbiUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRva2VuX3N0ciUyMiUzQSUyMHByZWQlNUIlMjJ0b2tlbl9zdHIlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJzZXF1ZW5jZSUyMiUzQSUyMHByZWQlNUIlMjJzZXF1ZW5jZSUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUyMCUyMCUyMCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTBBJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hugging Face is a community-based open-source &lt;mask&gt; for machine learning.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_mask = pipeline(task=<span class="hljs-string">&quot;fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = fill_mask(text, top_k=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token&quot;</span>: pred[<span class="hljs-string">&quot;token&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;token_str&quot;</span>: pred[<span class="hljs-string">&quot;token_str&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;sequence&quot;</span>: pred[<span class="hljs-string">&quot;sequence&quot;</span>],
<span class="hljs-meta">... </span>    }
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.2236</span>,
  <span class="hljs-string">&#x27;token&#x27;</span>: <span class="hljs-number">1761</span>,
  <span class="hljs-string">&#x27;token_str&#x27;</span>: <span class="hljs-string">&#x27; platform&#x27;</span>,
  <span class="hljs-string">&#x27;sequence&#x27;</span>: <span class="hljs-string">&#x27;Hugging Face is a community-based open-source platform for machine learning.&#x27;</span>}]`,wrap:!1}}),ft=new f({}),xt=new f({}),Jt=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmRhdGFzZXRzLXNlcnZlci5odWdnaW5nZmFjZS5jbyUyRmFzc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZleGFtcGxlLWRvY3VtZW50cyUyRi0tJTJGaGYtaW50ZXJuYWwtdGVzdGluZy0tZXhhbXBsZS1kb2N1bWVudHMlMkZ0ZXN0JTJGMiUyRmltYWdlJTJGaW1hZ2UuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBZG9jX3F1ZXN0aW9uX2Fuc3dlcmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyZG9jdW1lbnQtcXVlc3Rpb24tYW5zd2VyaW5nJTIyJTJDJTIwbW9kZWwlM0QlMjJtYWdvcnNodW5vdiUyRmxheW91dGxtLWludm9pY2VzJTIyKSUwQXByZWRzJTIwJTNEJTIwZG9jX3F1ZXN0aW9uX2Fuc3dlcmVyKCUwQSUyMCUyMCUyMCUyMHF1ZXN0aW9uJTNEJTIyV2hhdCUyMGlzJTIwdGhlJTIwdG90YWwlMjBhbW91bnQlM0YlMjIlMkMlMEElMjAlMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBKSUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://datasets-server.huggingface.co/assets/hf-internal-testing/example-documents/--/hf-internal-testing--example-documents/test/2/image/image.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>doc_question_answerer = pipeline(<span class="hljs-string">&quot;document-question-answering&quot;</span>, model=<span class="hljs-string">&quot;magorshunov/layoutlm-invoices&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = doc_question_answerer(
<span class="hljs-meta">... </span>    question=<span class="hljs-string">&quot;What is the total amount?&quot;</span>,
<span class="hljs-meta">... </span>    image=image,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.8531</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;17,000&#x27;</span>, <span class="hljs-string">&#x27;start&#x27;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&#x27;end&#x27;</span>: <span class="hljs-number">4</span>}]`,wrap:!1}}),{c(){w=n("meta"),he=i(),Qt=n("p"),me=i(),x=n("h1"),_=n("a"),Yt=n("span"),m(ns.$$.fragment),Oa=i(),Ut=n("span"),Ut.textContent=bn,ue=i(),ls=n("p"),ls.textContent=Jn,ge=i(),is=n("p"),is.textContent=vn,de=i(),b=n("h2"),R=n("a"),Xt=n("span"),m(rs.$$.fragment),sn=i(),Tt=n("span"),Tt.textContent=Un,ye=i(),os=n("p"),os.textContent=Tn,je=i(),ps=n("p"),ps.textContent=kn,fe=i(),J=n("h3"),E=n("a"),Ft=n("span"),m(cs.$$.fragment),tn=i(),kt=n("span"),kt.textContent=Cn,Me=i(),hs=n("p"),hs.textContent=In,we=i(),ms=n("ul"),ms.innerHTML=Zn,xe=i(),m(us.$$.fragment),be=i(),v=n("h3"),z=n("a"),Lt=n("span"),m(gs.$$.fragment),en=i(),Ct=n("span"),Ct.textContent=Bn,Je=i(),ds=n("p"),ds.textContent=Wn,ve=i(),ys=n("p"),ys.textContent=$n,Ue=i(),m(js.$$.fragment),Te=i(),U=n("h2"),A=n("a"),Pt=n("span"),m(fs.$$.fragment),an=i(),It=n("span"),It.textContent=qn,ke=i(),Ms=n("p"),Ms.innerHTML=Gn,Ce=i(),ws=n("p"),ws.textContent=Nn,Ie=i(),xs=n("ol"),xs.innerHTML=Hn,Ze=i(),T=n("h3"),S=n("a"),Kt=n("span"),m(bs.$$.fragment),nn=i(),Zt=n("span"),Zt.textContent=Vn,Be=i(),Js=n("p"),Js.textContent=_n,We=i(),vs=n("ul"),vs.innerHTML=Rn,$e=i(),m(Us.$$.fragment),qe=i(),k=n("h3"),Q=n("a"),Dt=n("span"),m(Ts.$$.fragment),ln=i(),Bt=n("span"),Bt.textContent=En,Ge=i(),ks=n("p"),ks.textContent=zn,Ne=i(),Cs=n("ul"),Cs.innerHTML=An,He=i(),m(Is.$$.fragment),Ve=i(),C=n("h3"),Y=n("a"),Ot=n("span"),m(Zs.$$.fragment),rn=i(),Wt=n("span"),Wt.textContent=Sn,_e=i(),Bs=n("p"),Bs.textContent=Qn,Re=i(),Ws=n("ul"),Ws.innerHTML=Yn,Ee=i(),$s=n("p"),$s.textContent=Xn,ze=i(),m(qs.$$.fragment),Ae=i(),I=n("h3"),X=n("a"),se=n("span"),m(Gs.$$.fragment),on=i(),$t=n("span"),$t.textContent=Fn,Se=i(),Ns=n("p"),Ns.textContent=Ln,Qe=i(),Hs=n("p"),Hs.textContent=Pn,Ye=i(),Vs=n("ul"),Vs.innerHTML=Kn,Xe=i(),m(_s.$$.fragment),Fe=i(),Z=n("h2"),F=n("a"),te=n("span"),m(Rs.$$.fragment),pn=i(),qt=n("span"),qt.textContent=Dn,Le=i(),Es=n("p"),Es.textContent=On,Pe=i(),B=n("h3"),L=n("a"),ee=n("span"),m(zs.$$.fragment),cn=i(),Gt=n("span"),Gt.textContent=sl,Ke=i(),As=n("p"),As.textContent=tl,De=i(),Ss=n("ul"),Ss.innerHTML=el,Oe=i(),m(Qs.$$.fragment),sa=i(),W=n("h3"),P=n("a"),ae=n("span"),m(Ys.$$.fragment),hn=i(),Nt=n("span"),Nt.textContent=al,ta=i(),Xs=n("p"),Xs.innerHTML=nl,ea=i(),Fs=n("p"),Fs.textContent=ll,aa=i(),Ls=n("ul"),Ls.innerHTML=il,na=i(),m(Ps.$$.fragment),la=i(),$=n("h3"),K=n("a"),ne=n("span"),m(Ks.$$.fragment),mn=i(),Ht=n("span"),Ht.textContent=rl,ia=i(),Ds=n("p"),Ds.textContent=ol,ra=i(),Os=n("p"),Os.textContent=pl,oa=i(),st=n("ul"),st.innerHTML=cl,pa=i(),m(tt.$$.fragment),ca=i(),q=n("h3"),D=n("a"),le=n("span"),m(et.$$.fragment),un=i(),Vt=n("span"),Vt.textContent=hl,ha=i(),at=n("p"),at.textContent=ml,ma=i(),nt=n("p"),nt.textContent=ul,ua=i(),lt=n("ul"),lt.innerHTML=gl,ga=i(),m(it.$$.fragment),da=i(),G=n("h3"),O=n("a"),ie=n("span"),m(rt.$$.fragment),gn=i(),_t=n("span"),_t.textContent=dl,ya=i(),ot=n("p"),ot.textContent=yl,ja=i(),pt=n("p"),pt.textContent=jl,fa=i(),m(ct.$$.fragment),Ma=i(),N=n("h3"),ss=n("a"),re=n("span"),m(ht.$$.fragment),dn=i(),Rt=n("span"),Rt.textContent=fl,wa=i(),mt=n("p"),mt.textContent=Ml,xa=i(),ut=n("p"),ut.textContent=wl,ba=i(),ts=n("ul"),gt=n("li"),Et=n("p"),Et.textContent=xl,yn=i(),m(dt.$$.fragment),jn=i(),yt=n("li"),zt=n("p"),zt.textContent=bl,fn=i(),m(jt.$$.fragment),Ja=i(),H=n("h2"),es=n("a"),oe=n("span"),m(ft.$$.fragment),Mn=i(),At=n("span"),At.textContent=Jl,va=i(),Mt=n("p"),Mt.textContent=vl,Ua=i(),wt=n("p"),wt.textContent=Ul,Ta=i(),V=n("h3"),as=n("a"),pe=n("span"),m(xt.$$.fragment),wn=i(),St=n("span"),St.textContent=Tl,ka=i(),bt=n("p"),bt.textContent=kl,Ca=i(),m(Jt.$$.fragment),Ia=i(),vt=n("p"),vt.innerHTML=Cl,Za=i(),ce=n("p"),this.h()},l(s){const e=yi("svelte-1phssyn",document.head);w=l(e,"META",{name:!0,content:!0}),e.forEach(t),he=r(s),Qt=l(s,"P",{}),h(Qt).forEach(t),me=r(s),x=l(s,"H1",{class:!0});var Wa=h(x);_=l(Wa,"A",{id:!0,class:!0,href:!0});var Il=h(_);Yt=l(Il,"SPAN",{});var Zl=h(Yt);u(ns.$$.fragment,Zl),Zl.forEach(t),Il.forEach(t),Oa=r(Wa),Ut=l(Wa,"SPAN",{"data-svelte-h":!0}),c(Ut)!=="svelte-nl380d"&&(Ut.textContent=bn),Wa.forEach(t),ue=r(s),ls=l(s,"P",{"data-svelte-h":!0}),c(ls)!=="svelte-16honzi"&&(ls.textContent=Jn),ge=r(s),is=l(s,"P",{"data-svelte-h":!0}),c(is)!=="svelte-co1bd8"&&(is.textContent=vn),de=r(s),b=l(s,"H2",{class:!0});var $a=h(b);R=l($a,"A",{id:!0,class:!0,href:!0});var Bl=h(R);Xt=l(Bl,"SPAN",{});var Wl=h(Xt);u(rs.$$.fragment,Wl),Wl.forEach(t),Bl.forEach(t),sn=r($a),Tt=l($a,"SPAN",{"data-svelte-h":!0}),c(Tt)!=="svelte-ivwwlt"&&(Tt.textContent=Un),$a.forEach(t),ye=r(s),os=l(s,"P",{"data-svelte-h":!0}),c(os)!=="svelte-y5bzkk"&&(os.textContent=Tn),je=r(s),ps=l(s,"P",{"data-svelte-h":!0}),c(ps)!=="svelte-1buqhp9"&&(ps.textContent=kn),fe=r(s),J=l(s,"H3",{class:!0});var qa=h(J);E=l(qa,"A",{id:!0,class:!0,href:!0});var $l=h(E);Ft=l($l,"SPAN",{});var ql=h(Ft);u(cs.$$.fragment,ql),ql.forEach(t),$l.forEach(t),tn=r(qa),kt=l(qa,"SPAN",{"data-svelte-h":!0}),c(kt)!=="svelte-v57evn"&&(kt.textContent=Cn),qa.forEach(t),Me=r(s),hs=l(s,"P",{"data-svelte-h":!0}),c(hs)!=="svelte-wenpsc"&&(hs.textContent=In),we=r(s),ms=l(s,"UL",{"data-svelte-h":!0}),c(ms)!=="svelte-ii0fya"&&(ms.innerHTML=Zn),xe=r(s),u(us.$$.fragment,s),be=r(s),v=l(s,"H3",{class:!0});var Ga=h(v);z=l(Ga,"A",{id:!0,class:!0,href:!0});var Gl=h(z);Lt=l(Gl,"SPAN",{});var Nl=h(Lt);u(gs.$$.fragment,Nl),Nl.forEach(t),Gl.forEach(t),en=r(Ga),Ct=l(Ga,"SPAN",{"data-svelte-h":!0}),c(Ct)!=="svelte-4lpwt"&&(Ct.textContent=Bn),Ga.forEach(t),Je=r(s),ds=l(s,"P",{"data-svelte-h":!0}),c(ds)!=="svelte-1uioxjn"&&(ds.textContent=Wn),ve=r(s),ys=l(s,"P",{"data-svelte-h":!0}),c(ys)!=="svelte-13nabhb"&&(ys.textContent=$n),Ue=r(s),u(js.$$.fragment,s),Te=r(s),U=l(s,"H2",{class:!0});var Na=h(U);A=l(Na,"A",{id:!0,class:!0,href:!0});var Hl=h(A);Pt=l(Hl,"SPAN",{});var Vl=h(Pt);u(fs.$$.fragment,Vl),Vl.forEach(t),Hl.forEach(t),an=r(Na),It=l(Na,"SPAN",{"data-svelte-h":!0}),c(It)!=="svelte-1pyp6as"&&(It.textContent=qn),Na.forEach(t),ke=r(s),Ms=l(s,"P",{"data-svelte-h":!0}),c(Ms)!=="svelte-1iprewp"&&(Ms.innerHTML=Gn),Ce=r(s),ws=l(s,"P",{"data-svelte-h":!0}),c(ws)!=="svelte-9en3oh"&&(ws.textContent=Nn),Ie=r(s),xs=l(s,"OL",{"data-svelte-h":!0}),c(xs)!=="svelte-1n2rw1y"&&(xs.innerHTML=Hn),Ze=r(s),T=l(s,"H3",{class:!0});var Ha=h(T);S=l(Ha,"A",{id:!0,class:!0,href:!0});var _l=h(S);Kt=l(_l,"SPAN",{});var Rl=h(Kt);u(bs.$$.fragment,Rl),Rl.forEach(t),_l.forEach(t),nn=r(Ha),Zt=l(Ha,"SPAN",{"data-svelte-h":!0}),c(Zt)!=="svelte-1cn7k7s"&&(Zt.textContent=Vn),Ha.forEach(t),Be=r(s),Js=l(s,"P",{"data-svelte-h":!0}),c(Js)!=="svelte-1xnawqn"&&(Js.textContent=_n),We=r(s),vs=l(s,"UL",{"data-svelte-h":!0}),c(vs)!=="svelte-hzwblv"&&(vs.innerHTML=Rn),$e=r(s),u(Us.$$.fragment,s),qe=r(s),k=l(s,"H3",{class:!0});var Va=h(k);Q=l(Va,"A",{id:!0,class:!0,href:!0});var El=h(Q);Dt=l(El,"SPAN",{});var zl=h(Dt);u(Ts.$$.fragment,zl),zl.forEach(t),El.forEach(t),ln=r(Va),Bt=l(Va,"SPAN",{"data-svelte-h":!0}),c(Bt)!=="svelte-sdfyw1"&&(Bt.textContent=En),Va.forEach(t),Ge=r(s),ks=l(s,"P",{"data-svelte-h":!0}),c(ks)!=="svelte-rzixgf"&&(ks.textContent=zn),Ne=r(s),Cs=l(s,"UL",{"data-svelte-h":!0}),c(Cs)!=="svelte-11ca9ev"&&(Cs.innerHTML=An),He=r(s),u(Is.$$.fragment,s),Ve=r(s),C=l(s,"H3",{class:!0});var _a=h(C);Y=l(_a,"A",{id:!0,class:!0,href:!0});var Al=h(Y);Ot=l(Al,"SPAN",{});var Sl=h(Ot);u(Zs.$$.fragment,Sl),Sl.forEach(t),Al.forEach(t),rn=r(_a),Wt=l(_a,"SPAN",{"data-svelte-h":!0}),c(Wt)!=="svelte-fjzjpu"&&(Wt.textContent=Sn),_a.forEach(t),_e=r(s),Bs=l(s,"P",{"data-svelte-h":!0}),c(Bs)!=="svelte-z5ffax"&&(Bs.textContent=Qn),Re=r(s),Ws=l(s,"UL",{"data-svelte-h":!0}),c(Ws)!=="svelte-1uq2lxo"&&(Ws.innerHTML=Yn),Ee=r(s),$s=l(s,"P",{"data-svelte-h":!0}),c($s)!=="svelte-fhukdm"&&($s.textContent=Xn),ze=r(s),u(qs.$$.fragment,s),Ae=r(s),I=l(s,"H3",{class:!0});var Ra=h(I);X=l(Ra,"A",{id:!0,class:!0,href:!0});var Ql=h(X);se=l(Ql,"SPAN",{});var Yl=h(se);u(Gs.$$.fragment,Yl),Yl.forEach(t),Ql.forEach(t),on=r(Ra),$t=l(Ra,"SPAN",{"data-svelte-h":!0}),c($t)!=="svelte-168lm6d"&&($t.textContent=Fn),Ra.forEach(t),Se=r(s),Ns=l(s,"P",{"data-svelte-h":!0}),c(Ns)!=="svelte-ee4yo2"&&(Ns.textContent=Ln),Qe=r(s),Hs=l(s,"P",{"data-svelte-h":!0}),c(Hs)!=="svelte-1tcdxbt"&&(Hs.textContent=Pn),Ye=r(s),Vs=l(s,"UL",{"data-svelte-h":!0}),c(Vs)!=="svelte-1h9rsal"&&(Vs.innerHTML=Kn),Xe=r(s),u(_s.$$.fragment,s),Fe=r(s),Z=l(s,"H2",{class:!0});var Ea=h(Z);F=l(Ea,"A",{id:!0,class:!0,href:!0});var Xl=h(F);te=l(Xl,"SPAN",{});var Fl=h(te);u(Rs.$$.fragment,Fl),Fl.forEach(t),Xl.forEach(t),pn=r(Ea),qt=l(Ea,"SPAN",{"data-svelte-h":!0}),c(qt)!=="svelte-pzpgin"&&(qt.textContent=Dn),Ea.forEach(t),Le=r(s),Es=l(s,"P",{"data-svelte-h":!0}),c(Es)!=="svelte-p86gd4"&&(Es.textContent=On),Pe=r(s),B=l(s,"H3",{class:!0});var za=h(B);L=l(za,"A",{id:!0,class:!0,href:!0});var Ll=h(L);ee=l(Ll,"SPAN",{});var Pl=h(ee);u(zs.$$.fragment,Pl),Pl.forEach(t),Ll.forEach(t),cn=r(za),Gt=l(za,"SPAN",{"data-svelte-h":!0}),c(Gt)!=="svelte-1olarbu"&&(Gt.textContent=sl),za.forEach(t),Ke=r(s),As=l(s,"P",{"data-svelte-h":!0}),c(As)!=="svelte-xkrisb"&&(As.textContent=tl),De=r(s),Ss=l(s,"UL",{"data-svelte-h":!0}),c(Ss)!=="svelte-1785q2k"&&(Ss.innerHTML=el),Oe=r(s),u(Qs.$$.fragment,s),sa=r(s),W=l(s,"H3",{class:!0});var Aa=h(W);P=l(Aa,"A",{id:!0,class:!0,href:!0});var Kl=h(P);ae=l(Kl,"SPAN",{});var Dl=h(ae);u(Ys.$$.fragment,Dl),Dl.forEach(t),Kl.forEach(t),hn=r(Aa),Nt=l(Aa,"SPAN",{"data-svelte-h":!0}),c(Nt)!=="svelte-18ca1ds"&&(Nt.textContent=al),Aa.forEach(t),ta=r(s),Xs=l(s,"P",{"data-svelte-h":!0}),c(Xs)!=="svelte-1k598k5"&&(Xs.innerHTML=nl),ea=r(s),Fs=l(s,"P",{"data-svelte-h":!0}),c(Fs)!=="svelte-1tgdzja"&&(Fs.textContent=ll),aa=r(s),Ls=l(s,"UL",{"data-svelte-h":!0}),c(Ls)!=="svelte-3b1070"&&(Ls.innerHTML=il),na=r(s),u(Ps.$$.fragment,s),la=r(s),$=l(s,"H3",{class:!0});var Sa=h($);K=l(Sa,"A",{id:!0,class:!0,href:!0});var Ol=h(K);ne=l(Ol,"SPAN",{});var si=h(ne);u(Ks.$$.fragment,si),si.forEach(t),Ol.forEach(t),mn=r(Sa),Ht=l(Sa,"SPAN",{"data-svelte-h":!0}),c(Ht)!=="svelte-1i2el67"&&(Ht.textContent=rl),Sa.forEach(t),ia=r(s),Ds=l(s,"P",{"data-svelte-h":!0}),c(Ds)!=="svelte-jggqzr"&&(Ds.textContent=ol),ra=r(s),Os=l(s,"P",{"data-svelte-h":!0}),c(Os)!=="svelte-16zyksn"&&(Os.textContent=pl),oa=r(s),st=l(s,"UL",{"data-svelte-h":!0}),c(st)!=="svelte-1oi6m54"&&(st.innerHTML=cl),pa=r(s),u(tt.$$.fragment,s),ca=r(s),q=l(s,"H3",{class:!0});var Qa=h(q);D=l(Qa,"A",{id:!0,class:!0,href:!0});var ti=h(D);le=l(ti,"SPAN",{});var ei=h(le);u(et.$$.fragment,ei),ei.forEach(t),ti.forEach(t),un=r(Qa),Vt=l(Qa,"SPAN",{"data-svelte-h":!0}),c(Vt)!=="svelte-3xc59g"&&(Vt.textContent=hl),Qa.forEach(t),ha=r(s),at=l(s,"P",{"data-svelte-h":!0}),c(at)!=="svelte-4carp"&&(at.textContent=ml),ma=r(s),nt=l(s,"P",{"data-svelte-h":!0}),c(nt)!=="svelte-1s0vpsm"&&(nt.textContent=ul),ua=r(s),lt=l(s,"UL",{"data-svelte-h":!0}),c(lt)!=="svelte-ka9r13"&&(lt.innerHTML=gl),ga=r(s),u(it.$$.fragment,s),da=r(s),G=l(s,"H3",{class:!0});var Ya=h(G);O=l(Ya,"A",{id:!0,class:!0,href:!0});var ai=h(O);ie=l(ai,"SPAN",{});var ni=h(ie);u(rt.$$.fragment,ni),ni.forEach(t),ai.forEach(t),gn=r(Ya),_t=l(Ya,"SPAN",{"data-svelte-h":!0}),c(_t)!=="svelte-qg4vk8"&&(_t.textContent=dl),Ya.forEach(t),ya=r(s),ot=l(s,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-1oa82bc"&&(ot.textContent=yl),ja=r(s),pt=l(s,"P",{"data-svelte-h":!0}),c(pt)!=="svelte-l2a5jq"&&(pt.textContent=jl),fa=r(s),u(ct.$$.fragment,s),Ma=r(s),N=l(s,"H3",{class:!0});var Xa=h(N);ss=l(Xa,"A",{id:!0,class:!0,href:!0});var li=h(ss);re=l(li,"SPAN",{});var ii=h(re);u(ht.$$.fragment,ii),ii.forEach(t),li.forEach(t),dn=r(Xa),Rt=l(Xa,"SPAN",{"data-svelte-h":!0}),c(Rt)!=="svelte-1kgn64a"&&(Rt.textContent=fl),Xa.forEach(t),wa=r(s),mt=l(s,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-1hrjdjs"&&(mt.textContent=Ml),xa=r(s),ut=l(s,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-128qp3h"&&(ut.textContent=wl),ba=r(s),ts=l(s,"UL",{});var Fa=h(ts);gt=l(Fa,"LI",{});var La=h(gt);Et=l(La,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-cojn0n"&&(Et.textContent=xl),yn=r(La),u(dt.$$.fragment,La),La.forEach(t),jn=r(Fa),yt=l(Fa,"LI",{});var Pa=h(yt);zt=l(Pa,"P",{"data-svelte-h":!0}),c(zt)!=="svelte-b2em4k"&&(zt.textContent=bl),fn=r(Pa),u(jt.$$.fragment,Pa),Pa.forEach(t),Fa.forEach(t),Ja=r(s),H=l(s,"H2",{class:!0});var Ka=h(H);es=l(Ka,"A",{id:!0,class:!0,href:!0});var ri=h(es);oe=l(ri,"SPAN",{});var oi=h(oe);u(ft.$$.fragment,oi),oi.forEach(t),ri.forEach(t),Mn=r(Ka),At=l(Ka,"SPAN",{"data-svelte-h":!0}),c(At)!=="svelte-atom6z"&&(At.textContent=Jl),Ka.forEach(t),va=r(s),Mt=l(s,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1wn2c65"&&(Mt.textContent=vl),Ua=r(s),wt=l(s,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-1ax7w6c"&&(wt.textContent=Ul),Ta=r(s),V=l(s,"H3",{class:!0});var Da=h(V);as=l(Da,"A",{id:!0,class:!0,href:!0});var pi=h(as);pe=l(pi,"SPAN",{});var ci=h(pe);u(xt.$$.fragment,ci),ci.forEach(t),pi.forEach(t),wn=r(Da),St=l(Da,"SPAN",{"data-svelte-h":!0}),c(St)!=="svelte-11jb5ke"&&(St.textContent=Tl),Da.forEach(t),ka=r(s),bt=l(s,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-1sl6ve4"&&(bt.textContent=kl),Ca=r(s),u(Jt.$$.fragment,s),Ia=r(s),vt=l(s,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-14177uf"&&(vt.innerHTML=Cl),Za=r(s),ce=l(s,"P",{}),h(ce).forEach(t),this.h()},h(){p(w,"name","hf:doc:metadata"),p(w,"content",JSON.stringify(fi)),p(_,"id","what-transformers-can-do"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#what-transformers-can-do"),p(x,"class","relative group"),p(R,"id","audio"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#audio"),p(b,"class","relative group"),p(E,"id","audio-classification"),p(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(E,"href","#audio-classification"),p(J,"class","relative group"),p(z,"id","automatic-speech-recognition"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#automatic-speech-recognition"),p(v,"class","relative group"),p(A,"id","computer-vision"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#computer-vision"),p(U,"class","relative group"),p(S,"id","image-classification"),p(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(S,"href","#image-classification"),p(T,"class","relative group"),p(Q,"id","object-detection"),p(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Q,"href","#object-detection"),p(k,"class","relative group"),p(Y,"id","image-segmentation"),p(Y,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Y,"href","#image-segmentation"),p(C,"class","relative group"),p(X,"id","depth-estimation"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#depth-estimation"),p(I,"class","relative group"),p(F,"id","natural-language-processing"),p(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(F,"href","#natural-language-processing"),p(Z,"class","relative group"),p(L,"id","text-classification"),p(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(L,"href","#text-classification"),p(B,"class","relative group"),p(P,"id","token-classification"),p(P,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(P,"href","#token-classification"),p(W,"class","relative group"),p(K,"id","question-answering"),p(K,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(K,"href","#question-answering"),p($,"class","relative group"),p(D,"id","summarization"),p(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(D,"href","#summarization"),p(q,"class","relative group"),p(O,"id","translation"),p(O,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(O,"href","#translation"),p(G,"class","relative group"),p(ss,"id","language-modeling"),p(ss,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(ss,"href","#language-modeling"),p(N,"class","relative group"),p(es,"id","multimodal"),p(es,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(es,"href","#multimodal"),p(H,"class","relative group"),p(as,"id","document-question-answering"),p(as,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(as,"href","#document-question-answering"),p(V,"class","relative group")},m(s,e){o(document.head,w),a(s,he,e),a(s,Qt,e),a(s,me,e),a(s,x,e),o(x,_),o(_,Yt),g(ns,Yt,null),o(x,Oa),o(x,Ut),a(s,ue,e),a(s,ls,e),a(s,ge,e),a(s,is,e),a(s,de,e),a(s,b,e),o(b,R),o(R,Xt),g(rs,Xt,null),o(b,sn),o(b,Tt),a(s,ye,e),a(s,os,e),a(s,je,e),a(s,ps,e),a(s,fe,e),a(s,J,e),o(J,E),o(E,Ft),g(cs,Ft,null),o(J,tn),o(J,kt),a(s,Me,e),a(s,hs,e),a(s,we,e),a(s,ms,e),a(s,xe,e),g(us,s,e),a(s,be,e),a(s,v,e),o(v,z),o(z,Lt),g(gs,Lt,null),o(v,en),o(v,Ct),a(s,Je,e),a(s,ds,e),a(s,ve,e),a(s,ys,e),a(s,Ue,e),g(js,s,e),a(s,Te,e),a(s,U,e),o(U,A),o(A,Pt),g(fs,Pt,null),o(U,an),o(U,It),a(s,ke,e),a(s,Ms,e),a(s,Ce,e),a(s,ws,e),a(s,Ie,e),a(s,xs,e),a(s,Ze,e),a(s,T,e),o(T,S),o(S,Kt),g(bs,Kt,null),o(T,nn),o(T,Zt),a(s,Be,e),a(s,Js,e),a(s,We,e),a(s,vs,e),a(s,$e,e),g(Us,s,e),a(s,qe,e),a(s,k,e),o(k,Q),o(Q,Dt),g(Ts,Dt,null),o(k,ln),o(k,Bt),a(s,Ge,e),a(s,ks,e),a(s,Ne,e),a(s,Cs,e),a(s,He,e),g(Is,s,e),a(s,Ve,e),a(s,C,e),o(C,Y),o(Y,Ot),g(Zs,Ot,null),o(C,rn),o(C,Wt),a(s,_e,e),a(s,Bs,e),a(s,Re,e),a(s,Ws,e),a(s,Ee,e),a(s,$s,e),a(s,ze,e),g(qs,s,e),a(s,Ae,e),a(s,I,e),o(I,X),o(X,se),g(Gs,se,null),o(I,on),o(I,$t),a(s,Se,e),a(s,Ns,e),a(s,Qe,e),a(s,Hs,e),a(s,Ye,e),a(s,Vs,e),a(s,Xe,e),g(_s,s,e),a(s,Fe,e),a(s,Z,e),o(Z,F),o(F,te),g(Rs,te,null),o(Z,pn),o(Z,qt),a(s,Le,e),a(s,Es,e),a(s,Pe,e),a(s,B,e),o(B,L),o(L,ee),g(zs,ee,null),o(B,cn),o(B,Gt),a(s,Ke,e),a(s,As,e),a(s,De,e),a(s,Ss,e),a(s,Oe,e),g(Qs,s,e),a(s,sa,e),a(s,W,e),o(W,P),o(P,ae),g(Ys,ae,null),o(W,hn),o(W,Nt),a(s,ta,e),a(s,Xs,e),a(s,ea,e),a(s,Fs,e),a(s,aa,e),a(s,Ls,e),a(s,na,e),g(Ps,s,e),a(s,la,e),a(s,$,e),o($,K),o(K,ne),g(Ks,ne,null),o($,mn),o($,Ht),a(s,ia,e),a(s,Ds,e),a(s,ra,e),a(s,Os,e),a(s,oa,e),a(s,st,e),a(s,pa,e),g(tt,s,e),a(s,ca,e),a(s,q,e),o(q,D),o(D,le),g(et,le,null),o(q,un),o(q,Vt),a(s,ha,e),a(s,at,e),a(s,ma,e),a(s,nt,e),a(s,ua,e),a(s,lt,e),a(s,ga,e),g(it,s,e),a(s,da,e),a(s,G,e),o(G,O),o(O,ie),g(rt,ie,null),o(G,gn),o(G,_t),a(s,ya,e),a(s,ot,e),a(s,ja,e),a(s,pt,e),a(s,fa,e),g(ct,s,e),a(s,Ma,e),a(s,N,e),o(N,ss),o(ss,re),g(ht,re,null),o(N,dn),o(N,Rt),a(s,wa,e),a(s,mt,e),a(s,xa,e),a(s,ut,e),a(s,ba,e),a(s,ts,e),o(ts,gt),o(gt,Et),o(gt,yn),g(dt,gt,null),o(ts,jn),o(ts,yt),o(yt,zt),o(yt,fn),g(jt,yt,null),a(s,Ja,e),a(s,H,e),o(H,es),o(es,oe),g(ft,oe,null),o(H,Mn),o(H,At),a(s,va,e),a(s,Mt,e),a(s,Ua,e),a(s,wt,e),a(s,Ta,e),a(s,V,e),o(V,as),o(as,pe),g(xt,pe,null),o(V,wn),o(V,St),a(s,ka,e),a(s,bt,e),a(s,Ca,e),g(Jt,s,e),a(s,Ia,e),a(s,vt,e),a(s,Za,e),a(s,ce,e),Ba=!0},p:mi,i(s){Ba||(d(ns.$$.fragment,s),d(rs.$$.fragment,s),d(cs.$$.fragment,s),d(us.$$.fragment,s),d(gs.$$.fragment,s),d(js.$$.fragment,s),d(fs.$$.fragment,s),d(bs.$$.fragment,s),d(Us.$$.fragment,s),d(Ts.$$.fragment,s),d(Is.$$.fragment,s),d(Zs.$$.fragment,s),d(qs.$$.fragment,s),d(Gs.$$.fragment,s),d(_s.$$.fragment,s),d(Rs.$$.fragment,s),d(zs.$$.fragment,s),d(Qs.$$.fragment,s),d(Ys.$$.fragment,s),d(Ps.$$.fragment,s),d(Ks.$$.fragment,s),d(tt.$$.fragment,s),d(et.$$.fragment,s),d(it.$$.fragment,s),d(rt.$$.fragment,s),d(ct.$$.fragment,s),d(ht.$$.fragment,s),d(dt.$$.fragment,s),d(jt.$$.fragment,s),d(ft.$$.fragment,s),d(xt.$$.fragment,s),d(Jt.$$.fragment,s),Ba=!0)},o(s){y(ns.$$.fragment,s),y(rs.$$.fragment,s),y(cs.$$.fragment,s),y(us.$$.fragment,s),y(gs.$$.fragment,s),y(js.$$.fragment,s),y(fs.$$.fragment,s),y(bs.$$.fragment,s),y(Us.$$.fragment,s),y(Ts.$$.fragment,s),y(Is.$$.fragment,s),y(Zs.$$.fragment,s),y(qs.$$.fragment,s),y(Gs.$$.fragment,s),y(_s.$$.fragment,s),y(Rs.$$.fragment,s),y(zs.$$.fragment,s),y(Qs.$$.fragment,s),y(Ys.$$.fragment,s),y(Ps.$$.fragment,s),y(Ks.$$.fragment,s),y(tt.$$.fragment,s),y(et.$$.fragment,s),y(it.$$.fragment,s),y(rt.$$.fragment,s),y(ct.$$.fragment,s),y(ht.$$.fragment,s),y(dt.$$.fragment,s),y(jt.$$.fragment,s),y(ft.$$.fragment,s),y(xt.$$.fragment,s),y(Jt.$$.fragment,s),Ba=!1},d(s){s&&(t(he),t(Qt),t(me),t(x),t(ue),t(ls),t(ge),t(is),t(de),t(b),t(ye),t(os),t(je),t(ps),t(fe),t(J),t(Me),t(hs),t(we),t(ms),t(xe),t(be),t(v),t(Je),t(ds),t(ve),t(ys),t(Ue),t(Te),t(U),t(ke),t(Ms),t(Ce),t(ws),t(Ie),t(xs),t(Ze),t(T),t(Be),t(Js),t(We),t(vs),t($e),t(qe),t(k),t(Ge),t(ks),t(Ne),t(Cs),t(He),t(Ve),t(C),t(_e),t(Bs),t(Re),t(Ws),t(Ee),t($s),t(ze),t(Ae),t(I),t(Se),t(Ns),t(Qe),t(Hs),t(Ye),t(Vs),t(Xe),t(Fe),t(Z),t(Le),t(Es),t(Pe),t(B),t(Ke),t(As),t(De),t(Ss),t(Oe),t(sa),t(W),t(ta),t(Xs),t(ea),t(Fs),t(aa),t(Ls),t(na),t(la),t($),t(ia),t(Ds),t(ra),t(Os),t(oa),t(st),t(pa),t(ca),t(q),t(ha),t(at),t(ma),t(nt),t(ua),t(lt),t(ga),t(da),t(G),t(ya),t(ot),t(ja),t(pt),t(fa),t(Ma),t(N),t(wa),t(mt),t(xa),t(ut),t(ba),t(ts),t(Ja),t(H),t(va),t(Mt),t(Ua),t(wt),t(Ta),t(V),t(ka),t(bt),t(Ca),t(Ia),t(vt),t(Za),t(ce)),t(w),j(ns),j(rs),j(cs),j(us,s),j(gs),j(js,s),j(fs),j(bs),j(Us,s),j(Ts),j(Is,s),j(Zs),j(qs,s),j(Gs),j(_s,s),j(Rs),j(zs),j(Qs,s),j(Ys),j(Ps,s),j(Ks),j(tt,s),j(et),j(it,s),j(rt),j(ct,s),j(ht),j(dt),j(jt),j(ft),j(xt),j(Jt,s)}}}const fi={local:"what-transformers-can-do",sections:[{local:"audio",sections:[{local:"audio-classification",title:"Audio classification"},{local:"automatic-speech-recognition",title:"Automatic speech recognition"}],title:"Audio"},{local:"computer-vision",sections:[{local:"image-classification",title:"Image classification"},{local:"object-detection",title:"Object detection"},{local:"image-segmentation",title:"Image segmentation"},{local:"depth-estimation",title:"Depth estimation"}],title:"Computer vision"},{local:"natural-language-processing",sections:[{local:"text-classification",title:"Text classification"},{local:"token-classification",title:"Token classification"},{local:"question-answering",title:"Question answering"},{local:"summarization",title:"Summarization"},{local:"translation",title:"Translation"},{local:"language-modeling",title:"Language modeling"}],title:"Natural language processing"},{local:"multimodal",sections:[{local:"document-question-answering",title:"Document question answering"}],title:"Multimodal"}],title:"What 🤗 Transformers can do"};function Mi(xn){return ui(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vi extends gi{constructor(w){super(),di(this,w,Mi,ji,hi,{})}}export{vi as component};
