import{s as ol,o as cl,n as hl}from"../chunks/scheduler.9bc65507.js";import{S as ml,i as Ml,g as i,s as a,u as h,m as dl,A as yl,h as r,f as s,c as n,j as f,v as m,y as p,n as ul,k as o,o as c,a as l,w as M,d,t as y,x as u}from"../chunks/index.78c82d43.js";import{T as fl}from"../chunks/Tip.87d55b76.js";import{I as Ee}from"../chunks/IconCopyLink.bedaa44d.js";import{C as w}from"../chunks/CodeBlock.73e038be.js";import{D as wl}from"../chunks/DocNotebookDropdown.31840a23.js";function bl(et){let b,H="Many image captioning datasets contain multiple captions per image. In those cases, a common strategy is to randomly sample a caption amongst the available ones during training.";return{c(){b=i("p"),b.textContent=H},l(g){b=r(g,"P",{"data-svelte-h":!0}),p(b)!=="svelte-n6sigx"&&(b.textContent=H)},m(g,He){l(g,b,He)},p:hl,d(g){g&&s(b)}}}function gl(et){let b,H,g,He,J,$,Ae,X,ps,Xe,ys="Image captioning",tt,V,st,Y,us=`Image captioning is the task of predicting a caption for a given image. Common real world applications of it include
aiding visually impaired people that can help them navigate through different situations. Therefore, image captioning
helps to improve content accessibility for people by describing images to them.`,lt,N,fs="This guide will show you how to:",at,z,ws="<li>Fine-tune an image captioning model.</li> <li>Use the fine-tuned model for inference.</li>",nt,Q,bs="Before you begin, make sure you have all the necessary libraries installed:",it,F,rt,A,gs="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",pt,S,ot,T,k,Se,q,os,Ve,Js="Load the Pokémon BLIP captions dataset",ct,L,Ts=`Use the 🤗 Dataset library to load a dataset that consists of {image-caption} pairs. To create your own image captioning dataset
in PyTorch, you can follow <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/GIT/Fine_tune_GIT_on_an_image_captioning_dataset.ipynb" rel="nofollow">this notebook</a>.`,ht,P,mt,K,Mt,D,Us="The dataset has two features, <code>image</code> and <code>text</code>.",dt,I,yt,O,js="Split the dataset’s train split into a train and test set with the [~datasets.Dataset.train_test_split] method:",ut,ee,ft,te,vs="Let’s visualize a couple of samples from the training set.",wt,se,bt,B,Cs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_training_images_image_cap.png" alt="Sample training images"/>',gt,U,x,qe,le,cs,Ye,_s="Preprocess the dataset",Jt,ae,$s="Since the dataset has two modalities (image and text), the pre-processing pipeline will preprocess images and the captions.",Tt,ne,ks="To do so, load the processor class associated with the model you are about to fine-tune.",Ut,ie,jt,re,Is="The processor will internally pre-process the image (which includes resizing, and pixel scaling) and tokenize the caption.",vt,pe,Ct,oe,Bs="With the dataset ready, you can now set up the model for fine-tuning.",_t,j,W,Le,ce,hs,Ne,xs="Load a base model",$t,he,Ws='Load the <a href="https://huggingface.co/microsoft/git-base" rel="nofollow">“microsoft/git-base”</a> into a <a href="https://huggingface.co/docs/transformers/model_doc/auto#transformers.AutoModelForCausalLM" rel="nofollow"><code>AutoModelForCausalLM</code></a> object.',kt,me,It,v,Z,Pe,Me,ms,ze,Zs="Evaluate",Bt,de,Gs='Image captioning models are typically evaluated with the <a href="https://huggingface.co/spaces/evaluate-metric/rouge" rel="nofollow">Rouge Score</a> or <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">Word Error Rate</a>. For this guide, you will use the Word Error Rate (WER).',xt,ye,Rs='We use the 🤗 Evaluate library to do so. For potential limitations and other gotchas of the WER, refer to <a href="https://huggingface.co/spaces/evaluate-metric/wer" rel="nofollow">this guide</a>.',Wt,ue,Zt,C,G,Ke,fe,Ms,Qe,Es="Train!",Gt,we,Hs='Now, you are ready to start fine-tuning the model. You will use the 🤗 <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> for this.',Rt,be,Xs='First, define the training arguments using <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.TrainingArguments">TrainingArguments</a>.',Et,ge,Ht,Je,Vs="Then pass them along with the datasets and the model to 🤗 Trainer.",Xt,Te,Vt,Ue,Ys='To start training, simply call <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer.train">train()</a> on the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer">Trainer</a> object.',Yt,je,Nt,ve,Ns="You should see the training loss drop smoothly as training progresses.",zt,Ce,zs='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',Qt,_e,Ft,_,R,De,$e,ds,Fe,Qs="Inference",At,ke,Fs="Take a sample image from <code>test_ds</code> to test the model.",St,Ie,qt,E,As='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/test_image_image_cap.png" alt="Test image"/>',Lt,Be,Pt,xe,Ss="Call <code>generate</code> and decode the predictions.",Kt,We,Dt,Ze,Ot,Ge,qs="Looks like the fine-tuned model generated a pretty good caption!",es,Oe,ts;return X=new Ee({}),V=new wl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_captioning.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_captioning.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_captioning.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_captioning.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_captioning.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_captioning.ipynb"}]}}),F=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwZXZhbHVhdGUlMjAtcSUwQXBpcCUyMGluc3RhbGwlMjBqaXdlciUyMC1x",highlighted:`pip install transformers datasets evaluate -q
pip install jiwer -q`,wrap:!1}}),S=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),q=new Ee({}),P=new w({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIybGFtYmRhbGFicyUyRnBva2Vtb24tYmxpcC1jYXB0aW9ucyUyMiklMEFkcw==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

ds = load_dataset(<span class="hljs-string">&quot;lambdalabs/pokemon-blip-captions&quot;</span>)
ds`,wrap:!1}}),K=new w({props:{code:"RGF0YXNldERpY3QoJTdCJTBBJTIwJTIwJTIwJTIwdHJhaW4lM0ElMjBEYXRhc2V0KCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmVzJTNBJTIwJTVCJ2ltYWdlJyUyQyUyMCd0ZXh0JyU1RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV9yb3dzJTNBJTIwODMzJTBBJTIwJTIwJTIwJTIwJTdEKSUwQSU3RCk=",highlighted:`DatasetDict({
    train: Dataset({
        features: [<span class="hljs-string">&#x27;image&#x27;</span>, <span class="hljs-string">&#x27;text&#x27;</span>],
        num_rows: 833
    })
})`,wrap:!1}}),I=new fl({props:{$$slots:{default:[bl]},$$scope:{ctx:et}}}),ee=new w({props:{code:"ZHMlMjAlM0QlMjBkcyU1QiUyMnRyYWluJTIyJTVELnRyYWluX3Rlc3Rfc3BsaXQodGVzdF9zaXplJTNEMC4xKSUwQXRyYWluX2RzJTIwJTNEJTIwZHMlNUIlMjJ0cmFpbiUyMiU1RCUwQXRlc3RfZHMlMjAlM0QlMjBkcyU1QiUyMnRlc3QlMjIlNUQ=",highlighted:`ds = ds[<span class="hljs-string">&quot;train&quot;</span>].train_test_split(test_size=<span class="hljs-number">0.1</span>)
train_ds = ds[<span class="hljs-string">&quot;train&quot;</span>]
test_ds = ds[<span class="hljs-string">&quot;test&quot;</span>]`,wrap:!1}}),se=new w({props:{code:"ZnJvbSUyMHRleHR3cmFwJTIwaW1wb3J0JTIwd3JhcCUwQWltcG9ydCUyMG1hdHBsb3RsaWIucHlwbG90JTIwYXMlMjBwbHQlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEElMEFkZWYlMjBwbG90X2ltYWdlcyhpbWFnZXMlMkMlMjBjYXB0aW9ucyklM0ElMEElMjAlMjAlMjAlMjBwbHQuZmlndXJlKGZpZ3NpemUlM0QoMjAlMkMlMjAyMCkpJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyMGluJTIwcmFuZ2UobGVuKGltYWdlcykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXglMjAlM0QlMjBwbHQuc3VicGxvdCgxJTJDJTIwbGVuKGltYWdlcyklMkMlMjBpJTIwJTJCJTIwMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYXB0aW9uJTIwJTNEJTIwY2FwdGlvbnMlNUJpJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FwdGlvbiUyMCUzRCUyMCUyMiU1Q24lMjIuam9pbih3cmFwKGNhcHRpb24lMkMlMjAxMikpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0LnRpdGxlKGNhcHRpb24pJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGx0Lmltc2hvdyhpbWFnZXMlNUJpJTVEKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBsdC5heGlzKCUyMm9mZiUyMiklMEElMEElMEFzYW1wbGVfaW1hZ2VzX3RvX3Zpc3VhbGl6ZSUyMCUzRCUyMCU1Qm5wLmFycmF5KHRyYWluX2RzJTVCaSU1RCU1QiUyMmltYWdlJTIyJTVEKSUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBc2FtcGxlX2NhcHRpb25zJTIwJTNEJTIwJTVCdHJhaW5fZHMlNUJpJTVEJTVCJTIydGV4dCUyMiU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDUpJTVEJTBBcGxvdF9pbWFnZXMoc2FtcGxlX2ltYWdlc190b192aXN1YWxpemUlMkMlMjBzYW1wbGVfY2FwdGlvbnMp",highlighted:`<span class="hljs-keyword">from</span> textwrap <span class="hljs-keyword">import</span> wrap
<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np


<span class="hljs-keyword">def</span> <span class="hljs-title function_">plot_images</span>(<span class="hljs-params">images, captions</span>):
    plt.figure(figsize=(<span class="hljs-number">20</span>, <span class="hljs-number">20</span>))
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-built_in">len</span>(images)):
        ax = plt.subplot(<span class="hljs-number">1</span>, <span class="hljs-built_in">len</span>(images), i + <span class="hljs-number">1</span>)
        caption = captions[i]
        caption = <span class="hljs-string">&quot;\\n&quot;</span>.join(wrap(caption, <span class="hljs-number">12</span>))
        plt.title(caption)
        plt.imshow(images[i])
        plt.axis(<span class="hljs-string">&quot;off&quot;</span>)


sample_images_to_visualize = [np.array(train_ds[i][<span class="hljs-string">&quot;image&quot;</span>]) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>)]
sample_captions = [train_ds[i][<span class="hljs-string">&quot;text&quot;</span>] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>)]
plot_images(sample_images_to_visualize, sample_captions)`,wrap:!1}}),le=new Ee({}),ie=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFjaGVja3BvaW50JTIwJTNEJTIwJTIybWljcm9zb2Z0JTJGZ2l0LWJhc2UlMjIlMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

checkpoint = <span class="hljs-string">&quot;microsoft/git-base&quot;</span>
processor = AutoProcessor.from_pretrained(checkpoint)`,wrap:!1}}),pe=new w({props:{code:"ZGVmJTIwdHJhbnNmb3JtcyhleGFtcGxlX2JhdGNoKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlcyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlNUQlMEElMjAlMjAlMjAlMjBjYXB0aW9ucyUyMCUzRCUyMCU1QnglMjBmb3IlMjB4JTIwaW4lMjBleGFtcGxlX2JhdGNoJTVCJTIydGV4dCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZXMlMkMlMjB0ZXh0JTNEY2FwdGlvbnMlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiklMEElMjAlMjAlMjAlMjBpbnB1dHMudXBkYXRlKCU3QiUyMmxhYmVscyUyMiUzQSUyMGlucHV0cyU1QiUyMmlucHV0X2lkcyUyMiU1RCU3RCklMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEF0cmFpbl9kcy5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMpJTBBdGVzdF9kcy5zZXRfdHJhbnNmb3JtKHRyYW5zZm9ybXMp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transforms</span>(<span class="hljs-params">example_batch</span>):
    images = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;image&quot;</span>]]
    captions = [x <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> example_batch[<span class="hljs-string">&quot;text&quot;</span>]]
    inputs = processor(images=images, text=captions, padding=<span class="hljs-string">&quot;max_length&quot;</span>)
    inputs.update({<span class="hljs-string">&quot;labels&quot;</span>: inputs[<span class="hljs-string">&quot;input_ids&quot;</span>]})
    <span class="hljs-keyword">return</span> inputs


train_ds.set_transform(transforms)
test_ds.set_transform(transforms)`,wrap:!1}}),ce=new Ee({}),me=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(checkpoint)`,wrap:!1}}),Me=new Ee({}),ue=new w({props:{code:"ZnJvbSUyMGV2YWx1YXRlJTIwaW1wb3J0JTIwbG9hZCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBd2VyJTIwJTNEJTIwbG9hZCglMjJ3ZXIlMjIpJTBBJTBBJTBBZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWQlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUyMCUyMCUyMCUyMGRlY29kZWRfbGFiZWxzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShsYWJlbHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjBkZWNvZGVkX3ByZWRpY3Rpb25zJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEElMjAlMjAlMjAlMjB3ZXJfc2NvcmUlMjAlM0QlMjB3ZXIuY29tcHV0ZShwcmVkaWN0aW9ucyUzRGRlY29kZWRfcHJlZGljdGlvbnMlMkMlMjByZWZlcmVuY2VzJTNEZGVjb2RlZF9sYWJlbHMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyd2VyX3Njb3JlJTIyJTNBJTIwd2VyX3Njb3JlJTdE",highlighted:`<span class="hljs-keyword">from</span> evaluate <span class="hljs-keyword">import</span> load
<span class="hljs-keyword">import</span> torch

wer = load(<span class="hljs-string">&quot;wer&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    logits, labels = eval_pred
    predicted = logits.argmax(-<span class="hljs-number">1</span>)
    decoded_labels = processor.batch_decode(labels, skip_special_tokens=<span class="hljs-literal">True</span>)
    decoded_predictions = processor.batch_decode(predicted, skip_special_tokens=<span class="hljs-literal">True</span>)
    wer_score = wer.compute(predictions=decoded_predictions, references=decoded_labels)
    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;wer_score&quot;</span>: wer_score}`,wrap:!1}}),fe=new Ee({}),ge=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBjaGVja3BvaW50LnNwbGl0KCUyMiUyRiUyMiklNUIxJTVEJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0RmJTIyJTdCbW9kZWxfbmFtZSU3RC1wb2tlbW9uJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNENTAlMkMlMEElMjAlMjAlMjAlMjBmcDE2JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDIlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMyUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGV2YWxfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGxvZ2dpbmdfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwbGFiZWxfbmFtZXMlM0QlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsb2FkX2Jlc3RfbW9kZWxfYXRfZW5kJTNEVHJ1ZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

model_name = checkpoint.split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]

training_args = TrainingArguments(
    output_dir=<span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-pokemon&quot;</span>,
    learning_rate=<span class="hljs-number">5e-5</span>,
    num_train_epochs=<span class="hljs-number">50</span>,
    fp16=<span class="hljs-literal">True</span>,
    per_device_train_batch_size=<span class="hljs-number">32</span>,
    per_device_eval_batch_size=<span class="hljs-number">32</span>,
    gradient_accumulation_steps=<span class="hljs-number">2</span>,
    save_total_limit=<span class="hljs-number">3</span>,
    evaluation_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    eval_steps=<span class="hljs-number">50</span>,
    save_strategy=<span class="hljs-string">&quot;steps&quot;</span>,
    save_steps=<span class="hljs-number">50</span>,
    logging_steps=<span class="hljs-number">50</span>,
    remove_unused_columns=<span class="hljs-literal">False</span>,
    push_to_hub=<span class="hljs-literal">True</span>,
    label_names=[<span class="hljs-string">&quot;labels&quot;</span>],
    load_best_model_at_end=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Te=new w({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RzJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdGVzdF9kcyUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSk=",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=train_ds,
    eval_dataset=test_ds,
    compute_metrics=compute_metrics,
)`,wrap:!1}}),je=new w({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:"trainer.train()",wrap:!1}}),_e=new w({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:"trainer.push_to_hub()",wrap:!1}}),$e=new Ee({}),Ie=new w({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnBva2Vtb24ucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/pokemon.png&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
image`,wrap:!1}}),Be=new w({props:{code:"ZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byhkZXZpY2UpJTBBcGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW5wdXRzLnBpeGVsX3ZhbHVlcw==",highlighted:`device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

inputs = processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
pixel_values = inputs.pixel_values`,wrap:!1}}),We=new w({props:{code:"Z2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHBpeGVsX3ZhbHVlcyUzRHBpeGVsX3ZhbHVlcyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFnZW5lcmF0ZWRfY2FwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQlMEFwcmludChnZW5lcmF0ZWRfY2FwdGlvbik=",highlighted:`generated_ids = model.generate(pixel_values=pixel_values, max_length=<span class="hljs-number">50</span>)
generated_caption = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(generated_caption)`,wrap:!1}}),Ze=new w({props:{code:"YSUyMGRyYXdpbmclMjBvZiUyMGElMjBwaW5rJTIwYW5kJTIwYmx1ZSUyMHBva2Vtb24=",highlighted:"a drawing of a pink and blue pokemon",wrap:!1}}),{c(){b=i("meta"),H=a(),g=i("p"),He=a(),J=i("h1"),$=i("a"),Ae=i("span"),h(X.$$.fragment),ps=a(),Xe=i("span"),Xe.textContent=ys,tt=a(),h(V.$$.fragment),st=a(),Y=i("p"),Y.textContent=us,lt=a(),N=i("p"),N.textContent=fs,at=a(),z=i("ul"),z.innerHTML=ws,nt=a(),Q=i("p"),Q.textContent=bs,it=a(),h(F.$$.fragment),rt=a(),A=i("p"),A.textContent=gs,pt=a(),h(S.$$.fragment),ot=a(),T=i("h2"),k=i("a"),Se=i("span"),h(q.$$.fragment),os=a(),Ve=i("span"),Ve.textContent=Js,ct=a(),L=i("p"),L.innerHTML=Ts,ht=a(),h(P.$$.fragment),mt=a(),h(K.$$.fragment),Mt=a(),D=i("p"),D.innerHTML=Us,dt=a(),h(I.$$.fragment),yt=a(),O=i("p"),O.textContent=js,ut=a(),h(ee.$$.fragment),ft=a(),te=i("p"),te.textContent=vs,wt=a(),h(se.$$.fragment),bt=a(),B=i("div"),B.innerHTML=Cs,gt=a(),U=i("h2"),x=i("a"),qe=i("span"),h(le.$$.fragment),cs=a(),Ye=i("span"),Ye.textContent=_s,Jt=a(),ae=i("p"),ae.textContent=$s,Tt=a(),ne=i("p"),ne.textContent=ks,Ut=a(),h(ie.$$.fragment),jt=a(),re=i("p"),re.textContent=Is,vt=a(),h(pe.$$.fragment),Ct=a(),oe=i("p"),oe.textContent=Bs,_t=a(),j=i("h2"),W=i("a"),Le=i("span"),h(ce.$$.fragment),hs=a(),Ne=i("span"),Ne.textContent=xs,$t=a(),he=i("p"),he.innerHTML=Ws,kt=a(),h(me.$$.fragment),It=a(),v=i("h2"),Z=i("a"),Pe=i("span"),h(Me.$$.fragment),ms=a(),ze=i("span"),ze.textContent=Zs,Bt=a(),de=i("p"),de.innerHTML=Gs,xt=a(),ye=i("p"),ye.innerHTML=Rs,Wt=a(),h(ue.$$.fragment),Zt=a(),C=i("h2"),G=i("a"),Ke=i("span"),h(fe.$$.fragment),Ms=a(),Qe=i("span"),Qe.textContent=Es,Gt=a(),we=i("p"),we.innerHTML=Hs,Rt=a(),be=i("p"),be.innerHTML=Xs,Et=a(),h(ge.$$.fragment),Ht=a(),Je=i("p"),Je.textContent=Vs,Xt=a(),h(Te.$$.fragment),Vt=a(),Ue=i("p"),Ue.innerHTML=Ys,Yt=a(),h(je.$$.fragment),Nt=a(),ve=i("p"),ve.textContent=Ns,zt=a(),Ce=i("p"),Ce.innerHTML=zs,Qt=a(),h(_e.$$.fragment),Ft=a(),_=i("h2"),R=i("a"),De=i("span"),h($e.$$.fragment),ds=a(),Fe=i("span"),Fe.textContent=Qs,At=a(),ke=i("p"),ke.innerHTML=Fs,St=a(),h(Ie.$$.fragment),qt=a(),E=i("div"),E.innerHTML=As,Lt=dl(`
    
Prepare image for the model.

	`),h(Be.$$.fragment),Pt=a(),xe=i("p"),xe.innerHTML=Ss,Kt=a(),h(We.$$.fragment),Dt=a(),h(Ze.$$.fragment),Ot=a(),Ge=i("p"),Ge.textContent=qs,es=a(),Oe=i("p"),this.h()},l(e){const t=yl("svelte-1phssyn",document.head);b=r(t,"META",{name:!0,content:!0}),t.forEach(s),H=n(e),g=r(e,"P",{}),f(g).forEach(s),He=n(e),J=r(e,"H1",{class:!0});var Re=f(J);$=r(Re,"A",{id:!0,class:!0,href:!0});var Ls=f($);Ae=r(Ls,"SPAN",{});var Ps=f(Ae);m(X.$$.fragment,Ps),Ps.forEach(s),Ls.forEach(s),ps=n(Re),Xe=r(Re,"SPAN",{"data-svelte-h":!0}),p(Xe)!=="svelte-1uwawv2"&&(Xe.textContent=ys),Re.forEach(s),tt=n(e),m(V.$$.fragment,e),st=n(e),Y=r(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-ws486a"&&(Y.textContent=us),lt=n(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1aff4p7"&&(N.textContent=fs),at=n(e),z=r(e,"UL",{"data-svelte-h":!0}),p(z)!=="svelte-l0kgiy"&&(z.innerHTML=ws),nt=n(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1c9nexd"&&(Q.textContent=bs),it=n(e),m(F.$$.fragment,e),rt=n(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-27hn0u"&&(A.textContent=gs),pt=n(e),m(S.$$.fragment,e),ot=n(e),T=r(e,"H2",{class:!0});var ss=f(T);k=r(ss,"A",{id:!0,class:!0,href:!0});var Ks=f(k);Se=r(Ks,"SPAN",{});var Ds=f(Se);m(q.$$.fragment,Ds),Ds.forEach(s),Ks.forEach(s),os=n(ss),Ve=r(ss,"SPAN",{"data-svelte-h":!0}),p(Ve)!=="svelte-1s20unx"&&(Ve.textContent=Js),ss.forEach(s),ct=n(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-1ijrbcw"&&(L.innerHTML=Ts),ht=n(e),m(P.$$.fragment,e),mt=n(e),m(K.$$.fragment,e),Mt=n(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-14ukxt"&&(D.innerHTML=Us),dt=n(e),m(I.$$.fragment,e),yt=n(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-11iqabw"&&(O.textContent=js),ut=n(e),m(ee.$$.fragment,e),ft=n(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1fsrtvj"&&(te.textContent=vs),wt=n(e),m(se.$$.fragment,e),bt=n(e),B=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1qemygy"&&(B.innerHTML=Cs),gt=n(e),U=r(e,"H2",{class:!0});var ls=f(U);x=r(ls,"A",{id:!0,class:!0,href:!0});var Os=f(x);qe=r(Os,"SPAN",{});var el=f(qe);m(le.$$.fragment,el),el.forEach(s),Os.forEach(s),cs=n(ls),Ye=r(ls,"SPAN",{"data-svelte-h":!0}),p(Ye)!=="svelte-1utb06q"&&(Ye.textContent=_s),ls.forEach(s),Jt=n(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-1ogvs11"&&(ae.textContent=$s),Tt=n(e),ne=r(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1shh6cf"&&(ne.textContent=ks),Ut=n(e),m(ie.$$.fragment,e),jt=n(e),re=r(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-l3qjuh"&&(re.textContent=Is),vt=n(e),m(pe.$$.fragment,e),Ct=n(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-1bhogex"&&(oe.textContent=Bs),_t=n(e),j=r(e,"H2",{class:!0});var as=f(j);W=r(as,"A",{id:!0,class:!0,href:!0});var tl=f(W);Le=r(tl,"SPAN",{});var sl=f(Le);m(ce.$$.fragment,sl),sl.forEach(s),tl.forEach(s),hs=n(as),Ne=r(as,"SPAN",{"data-svelte-h":!0}),p(Ne)!=="svelte-1ic7mki"&&(Ne.textContent=xs),as.forEach(s),$t=n(e),he=r(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-n2g9rz"&&(he.innerHTML=Ws),kt=n(e),m(me.$$.fragment,e),It=n(e),v=r(e,"H2",{class:!0});var ns=f(v);Z=r(ns,"A",{id:!0,class:!0,href:!0});var ll=f(Z);Pe=r(ll,"SPAN",{});var al=f(Pe);m(Me.$$.fragment,al),al.forEach(s),ll.forEach(s),ms=n(ns),ze=r(ns,"SPAN",{"data-svelte-h":!0}),p(ze)!=="svelte-sh8s6s"&&(ze.textContent=Zs),ns.forEach(s),Bt=n(e),de=r(e,"P",{"data-svelte-h":!0}),p(de)!=="svelte-1tzk2iw"&&(de.innerHTML=Gs),xt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-e8lgr2"&&(ye.innerHTML=Rs),Wt=n(e),m(ue.$$.fragment,e),Zt=n(e),C=r(e,"H2",{class:!0});var is=f(C);G=r(is,"A",{id:!0,class:!0,href:!0});var nl=f(G);Ke=r(nl,"SPAN",{});var il=f(Ke);m(fe.$$.fragment,il),il.forEach(s),nl.forEach(s),Ms=n(is),Qe=r(is,"SPAN",{"data-svelte-h":!0}),p(Qe)!=="svelte-1v5xwf2"&&(Qe.textContent=Es),is.forEach(s),Gt=n(e),we=r(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1dj3y2"&&(we.innerHTML=Hs),Rt=n(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-452p4s"&&(be.innerHTML=Xs),Et=n(e),m(ge.$$.fragment,e),Ht=n(e),Je=r(e,"P",{"data-svelte-h":!0}),p(Je)!=="svelte-y5ywt5"&&(Je.textContent=Vs),Xt=n(e),m(Te.$$.fragment,e),Vt=n(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-y9rw5m"&&(Ue.innerHTML=Ys),Yt=n(e),m(je.$$.fragment,e),Nt=n(e),ve=r(e,"P",{"data-svelte-h":!0}),p(ve)!=="svelte-acs4yg"&&(ve.textContent=Ns),zt=n(e),Ce=r(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-cv8z08"&&(Ce.innerHTML=zs),Qt=n(e),m(_e.$$.fragment,e),Ft=n(e),_=r(e,"H2",{class:!0});var rs=f(_);R=r(rs,"A",{id:!0,class:!0,href:!0});var rl=f(R);De=r(rl,"SPAN",{});var pl=f(De);m($e.$$.fragment,pl),pl.forEach(s),rl.forEach(s),ds=n(rs),Fe=r(rs,"SPAN",{"data-svelte-h":!0}),p(Fe)!=="svelte-199uz7g"&&(Fe.textContent=Qs),rs.forEach(s),At=n(e),ke=r(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-16tgs9z"&&(ke.innerHTML=Fs),St=n(e),m(Ie.$$.fragment,e),qt=n(e),E=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(E)!=="svelte-yvzmn4"&&(E.innerHTML=As),Lt=ul(e,`
    
Prepare image for the model.

	`),m(Be.$$.fragment,e),Pt=n(e),xe=r(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-1rbuk2y"&&(xe.innerHTML=Ss),Kt=n(e),m(We.$$.fragment,e),Dt=n(e),m(Ze.$$.fragment,e),Ot=n(e),Ge=r(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-vibkpa"&&(Ge.textContent=qs),es=n(e),Oe=r(e,"P",{}),f(Oe).forEach(s),this.h()},h(){o(b,"name","hf:doc:metadata"),o(b,"content",JSON.stringify(Jl)),o($,"id","image-captioning"),o($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o($,"href","#image-captioning"),o(J,"class","relative group"),o(k,"id","load-the-pokmon-blip-captions-dataset"),o(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(k,"href","#load-the-pokmon-blip-captions-dataset"),o(T,"class","relative group"),o(B,"class","flex justify-center"),o(x,"id","preprocess-the-dataset"),o(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(x,"href","#preprocess-the-dataset"),o(U,"class","relative group"),o(W,"id","load-a-base-model"),o(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(W,"href","#load-a-base-model"),o(j,"class","relative group"),o(Z,"id","evaluate"),o(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Z,"href","#evaluate"),o(v,"class","relative group"),o(G,"id","train"),o(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(G,"href","#train"),o(C,"class","relative group"),o(R,"id","inference"),o(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(R,"href","#inference"),o(_,"class","relative group"),o(E,"class","flex justify-center")},m(e,t){c(document.head,b),l(e,H,t),l(e,g,t),l(e,He,t),l(e,J,t),c(J,$),c($,Ae),M(X,Ae,null),c(J,ps),c(J,Xe),l(e,tt,t),M(V,e,t),l(e,st,t),l(e,Y,t),l(e,lt,t),l(e,N,t),l(e,at,t),l(e,z,t),l(e,nt,t),l(e,Q,t),l(e,it,t),M(F,e,t),l(e,rt,t),l(e,A,t),l(e,pt,t),M(S,e,t),l(e,ot,t),l(e,T,t),c(T,k),c(k,Se),M(q,Se,null),c(T,os),c(T,Ve),l(e,ct,t),l(e,L,t),l(e,ht,t),M(P,e,t),l(e,mt,t),M(K,e,t),l(e,Mt,t),l(e,D,t),l(e,dt,t),M(I,e,t),l(e,yt,t),l(e,O,t),l(e,ut,t),M(ee,e,t),l(e,ft,t),l(e,te,t),l(e,wt,t),M(se,e,t),l(e,bt,t),l(e,B,t),l(e,gt,t),l(e,U,t),c(U,x),c(x,qe),M(le,qe,null),c(U,cs),c(U,Ye),l(e,Jt,t),l(e,ae,t),l(e,Tt,t),l(e,ne,t),l(e,Ut,t),M(ie,e,t),l(e,jt,t),l(e,re,t),l(e,vt,t),M(pe,e,t),l(e,Ct,t),l(e,oe,t),l(e,_t,t),l(e,j,t),c(j,W),c(W,Le),M(ce,Le,null),c(j,hs),c(j,Ne),l(e,$t,t),l(e,he,t),l(e,kt,t),M(me,e,t),l(e,It,t),l(e,v,t),c(v,Z),c(Z,Pe),M(Me,Pe,null),c(v,ms),c(v,ze),l(e,Bt,t),l(e,de,t),l(e,xt,t),l(e,ye,t),l(e,Wt,t),M(ue,e,t),l(e,Zt,t),l(e,C,t),c(C,G),c(G,Ke),M(fe,Ke,null),c(C,Ms),c(C,Qe),l(e,Gt,t),l(e,we,t),l(e,Rt,t),l(e,be,t),l(e,Et,t),M(ge,e,t),l(e,Ht,t),l(e,Je,t),l(e,Xt,t),M(Te,e,t),l(e,Vt,t),l(e,Ue,t),l(e,Yt,t),M(je,e,t),l(e,Nt,t),l(e,ve,t),l(e,zt,t),l(e,Ce,t),l(e,Qt,t),M(_e,e,t),l(e,Ft,t),l(e,_,t),c(_,R),c(R,De),M($e,De,null),c(_,ds),c(_,Fe),l(e,At,t),l(e,ke,t),l(e,St,t),M(Ie,e,t),l(e,qt,t),l(e,E,t),l(e,Lt,t),M(Be,e,t),l(e,Pt,t),l(e,xe,t),l(e,Kt,t),M(We,e,t),l(e,Dt,t),M(Ze,e,t),l(e,Ot,t),l(e,Ge,t),l(e,es,t),l(e,Oe,t),ts=!0},p(e,[t]){const Re={};t&2&&(Re.$$scope={dirty:t,ctx:e}),I.$set(Re)},i(e){ts||(d(X.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(S.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(I.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(ce.$$.fragment,e),d(me.$$.fragment,e),d(Me.$$.fragment,e),d(ue.$$.fragment,e),d(fe.$$.fragment,e),d(ge.$$.fragment,e),d(Te.$$.fragment,e),d(je.$$.fragment,e),d(_e.$$.fragment,e),d($e.$$.fragment,e),d(Ie.$$.fragment,e),d(Be.$$.fragment,e),d(We.$$.fragment,e),d(Ze.$$.fragment,e),ts=!0)},o(e){y(X.$$.fragment,e),y(V.$$.fragment,e),y(F.$$.fragment,e),y(S.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(I.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(ie.$$.fragment,e),y(pe.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(Me.$$.fragment,e),y(ue.$$.fragment,e),y(fe.$$.fragment,e),y(ge.$$.fragment,e),y(Te.$$.fragment,e),y(je.$$.fragment,e),y(_e.$$.fragment,e),y($e.$$.fragment,e),y(Ie.$$.fragment,e),y(Be.$$.fragment,e),y(We.$$.fragment,e),y(Ze.$$.fragment,e),ts=!1},d(e){e&&(s(H),s(g),s(He),s(J),s(tt),s(st),s(Y),s(lt),s(N),s(at),s(z),s(nt),s(Q),s(it),s(rt),s(A),s(pt),s(ot),s(T),s(ct),s(L),s(ht),s(mt),s(Mt),s(D),s(dt),s(yt),s(O),s(ut),s(ft),s(te),s(wt),s(bt),s(B),s(gt),s(U),s(Jt),s(ae),s(Tt),s(ne),s(Ut),s(jt),s(re),s(vt),s(Ct),s(oe),s(_t),s(j),s($t),s(he),s(kt),s(It),s(v),s(Bt),s(de),s(xt),s(ye),s(Wt),s(Zt),s(C),s(Gt),s(we),s(Rt),s(be),s(Et),s(Ht),s(Je),s(Xt),s(Vt),s(Ue),s(Yt),s(Nt),s(ve),s(zt),s(Ce),s(Qt),s(Ft),s(_),s(At),s(ke),s(St),s(qt),s(E),s(Lt),s(Pt),s(xe),s(Kt),s(Dt),s(Ot),s(Ge),s(es),s(Oe)),s(b),u(X),u(V,e),u(F,e),u(S,e),u(q),u(P,e),u(K,e),u(I,e),u(ee,e),u(se,e),u(le),u(ie,e),u(pe,e),u(ce),u(me,e),u(Me),u(ue,e),u(fe),u(ge,e),u(Te,e),u(je,e),u(_e,e),u($e),u(Ie,e),u(Be,e),u(We,e),u(Ze,e)}}}const Jl={local:"image-captioning",sections:[{local:"load-the-pokmon-blip-captions-dataset",title:"Load the Pokémon BLIP captions dataset"},{local:"preprocess-the-dataset",title:"Preprocess the dataset"},{local:"load-a-base-model",title:"Load a base model"},{local:"evaluate",title:"Evaluate"},{local:"train",title:"Train!"},{local:"inference",title:"Inference"}],title:"Image captioning"};function Tl(et){return cl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kl extends ml{constructor(b){super(),Ml(this,b,Tl,gl,ol,{})}}export{kl as component};
