import{s as Te,o as Ue,n as xe}from"../chunks/scheduler.9bc65507.js";import{S as ke,i as Ze,g as i,s as a,u as m,A as _e,h as p,f as s,c as n,j as b,v as c,y as o,k as r,o as d,a as l,w as u,d as f,t as g,x as y,m as We,n as Re}from"../chunks/index.78c82d43.js";import{T as Ge}from"../chunks/Tip.87d55b76.js";import{I as Kt}from"../chunks/IconCopyLink.bedaa44d.js";import{C as J}from"../chunks/CodeBlock.73e038be.js";function Be(ut){let h,w,C='<a href="../model_doc/dpt">DPT</a>, <a href="../model_doc/glpn">GLPN</a>';return{c(){h=We(`The task illustrated in this tutorial is supported by the following model architectures:

`),w=i("p"),w.innerHTML=C},l(M){h=Re(M,`The task illustrated in this tutorial is supported by the following model architectures:

`),w=p(M,"P",{"data-svelte-h":!0}),o(w)!=="svelte-940txo"&&(w.innerHTML=C)},m(M,v){l(M,h,v),l(M,w,v)},p:xe,d(M){M&&(s(h),s(w))}}}function Ie(ut){let h,w,C,M,v,T,ht,R,Lt,pt,Ot="Monocular depth estimation",ft,G,te=`Monocular depth estimation is a computer vision task that involves predicting the depth information of a scene from a
single image. In other words, it is the process of estimating the distance of objects in a scene from
a single camera viewpoint.`,gt,B,ee=`Monocular depth estimation has various applications, including 3D reconstruction, augmented reality, autonomous driving,
and robotics. It is a challenging task as it requires the model to understand the complex relationships between objects
in the scene and the corresponding depth information, which can be affected by factors such as lighting conditions,
occlusion, and texture.`,yt,U,wt,I,se="In this guide you’ll learn how to:",Mt,E,le="<li>create a depth estimation pipeline</li> <li>run depth estimation inference by hand</li>",vt,H,ae="Before you begin, make sure you have all the necessary libraries installed:",bt,z,$t,$,x,mt,N,qt,ot,ne="Depth estimation pipeline",jt,V,ie=`The simplest way to try out inference with a model supporting depth estimation is to use the corresponding <a href="/docs/transformers/v4.34.0/en/main_classes/pipelines#transformers.pipeline">pipeline()</a>.
Instantiate a pipeline from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>:`,Jt,S,Ct,P,pe="Next, choose an image to analyze:",Tt,X,Ut,k,oe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-estimation-example.jpg" alt="Photo of a busy street"/>',xt,A,re="Pass the image to the pipeline.",kt,Q,Zt,F,he=`The pipeline returns a dictionary with two entries. The first one, called <code>predicted_depth</code>, is a tensor with the values
being the depth expressed in meters for each pixel.
The second one, <code>depth</code>, is a PIL image that visualizes the depth estimation result.`,_t,Y,me="Let’s take a look at the visualized result:",Wt,L,Rt,Z,ce='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',Gt,j,_,ct,q,Dt,rt,de="Depth estimation inference by hand",Bt,D,ue="Now that you’ve seen how to use the depth estimation pipeline, let’s see how we can replicate the same result by hand.",It,K,fe=`Start by loading the model and associated processor from a <a href="https://huggingface.co/models?pipeline_tag=depth-estimation&amp;sort=downloads" rel="nofollow">checkpoint on the Hugging Face Hub</a>.
Here we’ll use the same checkpoint as before:`,Et,O,Ht,tt,ge=`Prepare the image input for the model using the <code>image_processor</code> that will take care of the necessary image transformations
such as resizing and normalization:`,zt,et,Nt,st,ye="Pass the prepared inputs through the model:",Vt,lt,St,at,we="Visualize the results:",Pt,nt,Xt,W,Me='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/depth-visualization.png" alt="Depth estimation visualization"/>',At,dt,Qt;return R=new Kt({}),U=new Ge({props:{$$slots:{default:[Be]},$$scope:{ctx:ut}}}),z=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJz",highlighted:"pip install -q transformers",wrap:!1}}),N=new Kt({}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2hlY2twb2ludCUyMCUzRCUyMCUyMnZpbnZpbm8wMiUyRmdscG4tbnl1JTIyJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiUyQyUyMG1vZGVsJTNEY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>, model=checkpoint)`,wrap:!1}}),X=new J({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnVuc3BsYXNoLmNvbSUyRnBob3RvcyUyRkh3QkFzU2JQQkRVJTJGZG93bmxvYWQlM0ZpeGlkJTNETW53eE1qQTNmREI4TVh4elpXRnlZMmg4TXpSOGZHTmhjaVV5TUdsdUpUSXdkR2hsSlRJd2MzUnlaV1YwZkdWdWZEQjhNSHg4ZkRFMk56ZzVNREV3T0RnJTI2Zm9yY2UlM0R0cnVlJTI2dyUzRDY0MCUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQWltYWdl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://unsplash.com/photos/HwBAsSbPBDU/download?ixid=MnwxMjA3fDB8MXxzZWFyY2h8MzR8fGNhciUyMGluJTIwdGhlJTIwc3RyZWV0fGVufDB8MHx8fDE2Nzg5MDEwODg&amp;force=true&amp;w=640&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Q=new J({props:{code:"cHJlZGljdGlvbnMlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2Up",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions = depth_estimator(image)',wrap:!1}}),L=new J({props:{code:"cHJlZGljdGlvbnMlNUIlMjJkZXB0aCUyMiU1RA==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>predictions[<span class="hljs-string">&quot;depth&quot;</span>]',wrap:!1}}),q=new Kt({}),O=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbiUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJ2aW52aW5vMDIlMkZnbHBuLW55dSUyMiUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckRlcHRoRXN0aW1hdGlvbi5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForDepthEstimation

<span class="hljs-meta">&gt;&gt;&gt; </span>checkpoint = <span class="hljs-string">&quot;vinvino02/glpn-nyu&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(checkpoint)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForDepthEstimation.from_pretrained(checkpoint)`,wrap:!1}}),et=new J({props:{code:"cGl4ZWxfdmFsdWVzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikucGl4ZWxfdmFsdWVz",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>pixel_values = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values',wrap:!1}}),lt=new J({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKHBpeGVsX3ZhbHVlcyklMEElMjAlMjAlMjAlMjBwcmVkaWN0ZWRfZGVwdGglMjAlM0QlMjBvdXRwdXRzLnByZWRpY3RlZF9kZXB0aA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(pixel_values)
<span class="hljs-meta">... </span>    predicted_depth = outputs.predicted_depth`,wrap:!1}}),nt=new J({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBJTIzJTIwaW50ZXJwb2xhdGUlMjB0byUyMG9yaWdpbmFsJTIwc2l6ZSUwQXByZWRpY3Rpb24lMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmludGVycG9sYXRlKCUwQSUyMCUyMCUyMCUyMHByZWRpY3RlZF9kZXB0aC51bnNxdWVlemUoMSklMkMlMEElMjAlMjAlMjAlMjBzaXplJTNEaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTJDJTBBJTIwJTIwJTIwJTIwbW9kZSUzRCUyMmJpY3ViaWMlMjIlMkMlMEElMjAlMjAlMjAlMjBhbGlnbl9jb3JuZXJzJTNERmFsc2UlMkMlMEEpLnNxdWVlemUoKSUwQW91dHB1dCUyMCUzRCUyMHByZWRpY3Rpb24ubnVtcHkoKSUwQSUwQWZvcm1hdHRlZCUyMCUzRCUyMChvdXRwdXQlMjAqJTIwMjU1JTIwJTJGJTIwbnAubWF4KG91dHB1dCkpLmFzdHlwZSglMjJ1aW50OCUyMiklMEFkZXB0aCUyMCUzRCUyMEltYWdlLmZyb21hcnJheShmb3JtYXR0ZWQpJTBBZGVwdGg=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># interpolate to original size</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prediction = torch.nn.functional.interpolate(
<span class="hljs-meta">... </span>    predicted_depth.unsqueeze(<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    size=image.size[::-<span class="hljs-number">1</span>],
<span class="hljs-meta">... </span>    mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
<span class="hljs-meta">... </span>    align_corners=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>).squeeze()
<span class="hljs-meta">&gt;&gt;&gt; </span>output = prediction.numpy()

<span class="hljs-meta">&gt;&gt;&gt; </span>formatted = (output * <span class="hljs-number">255</span> / np.<span class="hljs-built_in">max</span>(output)).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth = Image.fromarray(formatted)
<span class="hljs-meta">&gt;&gt;&gt; </span>depth`,wrap:!1}}),{c(){h=i("meta"),w=a(),C=i("p"),M=a(),v=i("h1"),T=i("a"),ht=i("span"),m(R.$$.fragment),Lt=a(),pt=i("span"),pt.textContent=Ot,ft=a(),G=i("p"),G.textContent=te,gt=a(),B=i("p"),B.textContent=ee,yt=a(),m(U.$$.fragment),wt=a(),I=i("p"),I.textContent=se,Mt=a(),E=i("ul"),E.innerHTML=le,vt=a(),H=i("p"),H.textContent=ae,bt=a(),m(z.$$.fragment),$t=a(),$=i("h2"),x=i("a"),mt=i("span"),m(N.$$.fragment),qt=a(),ot=i("span"),ot.textContent=ne,jt=a(),V=i("p"),V.innerHTML=ie,Jt=a(),m(S.$$.fragment),Ct=a(),P=i("p"),P.textContent=pe,Tt=a(),m(X.$$.fragment),Ut=a(),k=i("div"),k.innerHTML=oe,xt=a(),A=i("p"),A.textContent=re,kt=a(),m(Q.$$.fragment),Zt=a(),F=i("p"),F.innerHTML=he,_t=a(),Y=i("p"),Y.textContent=me,Wt=a(),m(L.$$.fragment),Rt=a(),Z=i("div"),Z.innerHTML=ce,Gt=a(),j=i("h2"),_=i("a"),ct=i("span"),m(q.$$.fragment),Dt=a(),rt=i("span"),rt.textContent=de,Bt=a(),D=i("p"),D.textContent=ue,It=a(),K=i("p"),K.innerHTML=fe,Et=a(),m(O.$$.fragment),Ht=a(),tt=i("p"),tt.innerHTML=ge,zt=a(),m(et.$$.fragment),Nt=a(),st=i("p"),st.textContent=ye,Vt=a(),m(lt.$$.fragment),St=a(),at=i("p"),at.textContent=we,Pt=a(),m(nt.$$.fragment),Xt=a(),W=i("div"),W.innerHTML=Me,At=a(),dt=i("p"),this.h()},l(t){const e=_e("svelte-1phssyn",document.head);h=p(e,"META",{name:!0,content:!0}),e.forEach(s),w=n(t),C=p(t,"P",{}),b(C).forEach(s),M=n(t),v=p(t,"H1",{class:!0});var it=b(v);T=p(it,"A",{id:!0,class:!0,href:!0});var ve=b(T);ht=p(ve,"SPAN",{});var be=b(ht);c(R.$$.fragment,be),be.forEach(s),ve.forEach(s),Lt=n(it),pt=p(it,"SPAN",{"data-svelte-h":!0}),o(pt)!=="svelte-o9kwwn"&&(pt.textContent=Ot),it.forEach(s),ft=n(t),G=p(t,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1elgt0a"&&(G.textContent=te),gt=n(t),B=p(t,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1bkqs5v"&&(B.textContent=ee),yt=n(t),c(U.$$.fragment,t),wt=n(t),I=p(t,"P",{"data-svelte-h":!0}),o(I)!=="svelte-jr2b5g"&&(I.textContent=se),Mt=n(t),E=p(t,"UL",{"data-svelte-h":!0}),o(E)!=="svelte-tj6led"&&(E.innerHTML=le),vt=n(t),H=p(t,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1c9nexd"&&(H.textContent=ae),bt=n(t),c(z.$$.fragment,t),$t=n(t),$=p(t,"H2",{class:!0});var Ft=b($);x=p(Ft,"A",{id:!0,class:!0,href:!0});var $e=b(x);mt=p($e,"SPAN",{});var je=b(mt);c(N.$$.fragment,je),je.forEach(s),$e.forEach(s),qt=n(Ft),ot=p(Ft,"SPAN",{"data-svelte-h":!0}),o(ot)!=="svelte-1fdist1"&&(ot.textContent=ne),Ft.forEach(s),jt=n(t),V=p(t,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1i3q232"&&(V.innerHTML=ie),Jt=n(t),c(S.$$.fragment,t),Ct=n(t),P=p(t,"P",{"data-svelte-h":!0}),o(P)!=="svelte-wuz5lr"&&(P.textContent=pe),Tt=n(t),c(X.$$.fragment,t),Ut=n(t),k=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(k)!=="svelte-10bakl"&&(k.innerHTML=oe),xt=n(t),A=p(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-mcr1tn"&&(A.textContent=re),kt=n(t),c(Q.$$.fragment,t),Zt=n(t),F=p(t,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1jckqfu"&&(F.innerHTML=he),_t=n(t),Y=p(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1dzpyfr"&&(Y.textContent=me),Wt=n(t),c(L.$$.fragment,t),Rt=n(t),Z=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(Z)!=="svelte-43wxxb"&&(Z.innerHTML=ce),Gt=n(t),j=p(t,"H2",{class:!0});var Yt=b(j);_=p(Yt,"A",{id:!0,class:!0,href:!0});var Je=b(_);ct=p(Je,"SPAN",{});var Ce=b(ct);c(q.$$.fragment,Ce),Ce.forEach(s),Je.forEach(s),Dt=n(Yt),rt=p(Yt,"SPAN",{"data-svelte-h":!0}),o(rt)!=="svelte-i1ezn2"&&(rt.textContent=de),Yt.forEach(s),Bt=n(t),D=p(t,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1u79cc9"&&(D.textContent=ue),It=n(t),K=p(t,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1r8mctn"&&(K.innerHTML=fe),Et=n(t),c(O.$$.fragment,t),Ht=n(t),tt=p(t,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-hhrw3"&&(tt.innerHTML=ge),zt=n(t),c(et.$$.fragment,t),Nt=n(t),st=p(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-1yk8q0z"&&(st.textContent=ye),Vt=n(t),c(lt.$$.fragment,t),St=n(t),at=p(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-6ebm65"&&(at.textContent=we),Pt=n(t),c(nt.$$.fragment,t),Xt=n(t),W=p(t,"DIV",{class:!0,"data-svelte-h":!0}),o(W)!=="svelte-43wxxb"&&(W.innerHTML=Me),At=n(t),dt=p(t,"P",{}),b(dt).forEach(s),this.h()},h(){r(h,"name","hf:doc:metadata"),r(h,"content",JSON.stringify(Ee)),r(T,"id","monocular-depth-estimation"),r(T,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(T,"href","#monocular-depth-estimation"),r(v,"class","relative group"),r(x,"id","depth-estimation-pipeline"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#depth-estimation-pipeline"),r($,"class","relative group"),r(k,"class","flex justify-center"),r(Z,"class","flex justify-center"),r(_,"id","depth-estimation-inference-by-hand"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#depth-estimation-inference-by-hand"),r(j,"class","relative group"),r(W,"class","flex justify-center")},m(t,e){d(document.head,h),l(t,w,e),l(t,C,e),l(t,M,e),l(t,v,e),d(v,T),d(T,ht),u(R,ht,null),d(v,Lt),d(v,pt),l(t,ft,e),l(t,G,e),l(t,gt,e),l(t,B,e),l(t,yt,e),u(U,t,e),l(t,wt,e),l(t,I,e),l(t,Mt,e),l(t,E,e),l(t,vt,e),l(t,H,e),l(t,bt,e),u(z,t,e),l(t,$t,e),l(t,$,e),d($,x),d(x,mt),u(N,mt,null),d($,qt),d($,ot),l(t,jt,e),l(t,V,e),l(t,Jt,e),u(S,t,e),l(t,Ct,e),l(t,P,e),l(t,Tt,e),u(X,t,e),l(t,Ut,e),l(t,k,e),l(t,xt,e),l(t,A,e),l(t,kt,e),u(Q,t,e),l(t,Zt,e),l(t,F,e),l(t,_t,e),l(t,Y,e),l(t,Wt,e),u(L,t,e),l(t,Rt,e),l(t,Z,e),l(t,Gt,e),l(t,j,e),d(j,_),d(_,ct),u(q,ct,null),d(j,Dt),d(j,rt),l(t,Bt,e),l(t,D,e),l(t,It,e),l(t,K,e),l(t,Et,e),u(O,t,e),l(t,Ht,e),l(t,tt,e),l(t,zt,e),u(et,t,e),l(t,Nt,e),l(t,st,e),l(t,Vt,e),u(lt,t,e),l(t,St,e),l(t,at,e),l(t,Pt,e),u(nt,t,e),l(t,Xt,e),l(t,W,e),l(t,At,e),l(t,dt,e),Qt=!0},p(t,[e]){const it={};e&2&&(it.$$scope={dirty:e,ctx:t}),U.$set(it)},i(t){Qt||(f(R.$$.fragment,t),f(U.$$.fragment,t),f(z.$$.fragment,t),f(N.$$.fragment,t),f(S.$$.fragment,t),f(X.$$.fragment,t),f(Q.$$.fragment,t),f(L.$$.fragment,t),f(q.$$.fragment,t),f(O.$$.fragment,t),f(et.$$.fragment,t),f(lt.$$.fragment,t),f(nt.$$.fragment,t),Qt=!0)},o(t){g(R.$$.fragment,t),g(U.$$.fragment,t),g(z.$$.fragment,t),g(N.$$.fragment,t),g(S.$$.fragment,t),g(X.$$.fragment,t),g(Q.$$.fragment,t),g(L.$$.fragment,t),g(q.$$.fragment,t),g(O.$$.fragment,t),g(et.$$.fragment,t),g(lt.$$.fragment,t),g(nt.$$.fragment,t),Qt=!1},d(t){t&&(s(w),s(C),s(M),s(v),s(ft),s(G),s(gt),s(B),s(yt),s(wt),s(I),s(Mt),s(E),s(vt),s(H),s(bt),s($t),s($),s(jt),s(V),s(Jt),s(Ct),s(P),s(Tt),s(Ut),s(k),s(xt),s(A),s(kt),s(Zt),s(F),s(_t),s(Y),s(Wt),s(Rt),s(Z),s(Gt),s(j),s(Bt),s(D),s(It),s(K),s(Et),s(Ht),s(tt),s(zt),s(Nt),s(st),s(Vt),s(St),s(at),s(Pt),s(Xt),s(W),s(At),s(dt)),s(h),y(R),y(U,t),y(z,t),y(N),y(S,t),y(X,t),y(Q,t),y(L,t),y(q),y(O,t),y(et,t),y(lt,t),y(nt,t)}}}const Ee={local:"monocular-depth-estimation",sections:[{local:"depth-estimation-pipeline",title:"Depth estimation pipeline"},{local:"depth-estimation-inference-by-hand",title:"Depth estimation inference by hand"}],title:"Monocular depth estimation"};function He(ut){return Ue(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xe extends ke{constructor(h){super(),Ze(this,h,He,Ie,Te,{})}}export{Xe as component};
