import{s as At,o as Wt,n as kt}from"../chunks/scheduler.9bc65507.js";import{S as Bt,i as xt,g as p,s as t,u as M,A as Vt,h as i,f as l,c as n,j,v as r,y as o,k as d,o as w,a,w as c,d as h,t as m,x as y,m as Rt,n as Xt}from"../chunks/index.78c82d43.js";import{T as $t}from"../chunks/Tip.87d55b76.js";import{I as he}from"../chunks/IconCopyLink.bedaa44d.js";import{C as J}from"../chunks/CodeBlock.73e038be.js";import{D as Et}from"../chunks/DocNotebookDropdown.31840a23.js";function St(Ze){let U,T,_='<a href="../model_doc/timesformer">TimeSformer</a>, <a href="../model_doc/videomae">VideoMAE</a>, <a href="../model_doc/vivit">ViViT</a>';return{c(){U=Rt(`The task illustrated in this tutorial is supported by the following model architectures:

`),T=p("p"),T.innerHTML=_},l(u){U=Xt(u,`The task illustrated in this tutorial is supported by the following model architectures:

`),T=i(u,"P",{"data-svelte-h":!0}),o(T)!=="svelte-jaqk6f"&&(T.innerHTML=_)},m(u,f){a(u,U,f),a(u,T,f)},p:kt,d(u){u&&(l(U),l(T))}}}function Ft(Ze){let U,T,_,u,f,G,Te,E,ra,me,Ja="Video classification",_e,S,Ge,F,ja="Video classification is the task of assigning a label or class to an entire video. Videos are expected to have only one class for each video. Video classification models take a video as input and return a prediction about which class the video belongs to. These models can be used to categorize what a video is all about. A real-world application of video classification is action / activity recognition, which is useful for fitness applications. It is also helpful for vision-impaired individuals, especially when they are commuting.",Ae,z,Ua="This guide will show you how to:",We,Y,Ta='<li>Fine-tune <a href="https://huggingface.co/docs/transformers/main/en/model_doc/videomae" rel="nofollow">VideoMAE</a> on a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF101</a> dataset.</li> <li>Use your fine-tuned model for inference.</li>',ke,A,Be,N,ua="Before you begin, make sure you have all the necessary libraries installed:",xe,Q,Ve,H,fa='You will use <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo</a> (dubbed <code>pytorchvideo</code>) to process and prepare the videos.',Re,L,ba="We encourage you to log in to your Hugging Face account so you can upload and share your model with the community. When prompted, enter your token to log in:",Xe,q,$e,b,W,ue,D,ca,ye,Ia="Load UCF101 dataset",Ee,P,Ca='Start by loading a subset of the <a href="https://www.crcv.ucf.edu/data/UCF101.php" rel="nofollow">UCF-101 dataset</a>. This will give you a chance to experiment and make sure everything works before spending more time training on the full dataset.',Se,K,Fe,O,ga="After the subset has been downloaded, you need to extract the compressed archive:",ze,ss,Ye,es,va="At a high level, the dataset is organized like so:",Ne,ls,Qe,as,Za="The (<code>sorted</code>) video paths appear like so:",He,ts,Le,ns,_a="You will notice that there are video clips belonging to the same group / scene where group is denoted by <code>g</code> in the video file paths. <code>v_ApplyEyeMakeup_g07_c04.avi</code> and <code>v_ApplyEyeMakeup_g07_c06.avi</code>, for example.",qe,ps,Ga='For the validation and evaluation splits, you wouldn’t want to have video clips from the same group / scene to prevent <a href="https://www.kaggle.com/code/alexisbcook/data-leakage" rel="nofollow">data leakage</a>. The subset that you are using in this tutorial takes this information into account.',De,is,Aa="Next up, you will derive the set of labels present in the dataset. Also, create two dictionaries that’ll be helpful when initializing the model:",Pe,os,Wa="<li><code>label2id</code>: maps the class names to integers.</li> <li><code>id2label</code>: maps the integers to class names.</li>",Ke,Ms,Oe,rs,ka="There are 10 unique classes. For each class, there are 30 videos in the training set.",sl,I,k,fe,cs,ha,de,Ba="Load a model to fine-tune",el,hs,xa="Instantiate a video classification model from a pretrained checkpoint and its associated image processor. The model’s encoder comes with pre-trained parameters, and the classification head is randomly initialized. The image processor will come in handy when writing the preprocessing pipeline for our dataset.",ll,ms,al,ys,Va="While the model is loading, you might notice the following warning:",tl,ds,nl,ws,Ra="The warning is telling us we are throwing away some weights (e.g. the weights and bias of the <code>classifier</code> layer) and randomly initializing some others (the weights and bias of a new <code>classifier</code> layer). This is expected in this case, because we are adding a new head for which we don’t have pretrained weights, so the library warns us we should fine-tune this model before using it for inference, which is exactly what we are going to do.",pl,Js,Xa='<strong>Note</strong> that <a href="https://huggingface.co/MCG-NJU/videomae-base-finetuned-kinetics" rel="nofollow">this checkpoint</a> leads to better performance on this task as the checkpoint was obtained fine-tuning on a similar downstream task having considerable domain overlap. You can check out <a href="https://huggingface.co/sayakpaul/videomae-base-finetuned-kinetics-finetuned-ucf101-subset" rel="nofollow">this checkpoint</a> which was obtained by fine-tuning <code>MCG-NJU/videomae-base-finetuned-kinetics</code>.',il,C,B,be,js,ma,we,$a="Prepare the datasets for training",ol,Us,Ea='For preprocessing the videos, you will leverage the <a href="https://pytorchvideo.org/" rel="nofollow">PyTorchVideo library</a>. Start by importing the dependencies we need.',Ml,Ts,rl,us,Sa='For the training dataset transformations, use a combination of uniform temporal subsampling, pixel normalization, random cropping, and random horizontal flipping. For the validation and evaluation dataset transformations, keep the same transformation chain except for random cropping and horizontal flipping. To learn more about the details of these transformations check out the <a href="https://pytorchvideo.org" rel="nofollow">official documentation of PyTorchVideo</a>.',cl,fs,Fa="Use the <code>image_processor</code> associated with the pre-trained model to obtain the following information:",hl,bs,za="<li>Image mean and standard deviation with which the video frame pixels will be normalized.</li> <li>Spatial resolution to which the video frames will be resized.</li>",ml,Is,Ya="Start by defining some constants.",yl,Cs,dl,gs,Na="Now, define the dataset-specific transformations and the datasets respectively. Starting with the training set:",wl,vs,Jl,Zs,Qa="The same sequence of workflow can be applied to the validation and evaluation sets:",jl,_s,Ul,Gs,Ha='<strong>Note</strong>: The above dataset pipelines are taken from the <a href="https://pytorchvideo.org/docs/tutorial_classification#dataset" rel="nofollow">official PyTorchVideo example</a>. We’re using the <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.Ucf101" rel="nofollow"><code>pytorchvideo.data.Ucf101()</code></a> function because it’s tailored for the UCF-101 dataset. Under the hood, it returns a <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html#pytorchvideo.data.LabeledVideoDataset" rel="nofollow"><code>pytorchvideo.data.labeled_video_dataset.LabeledVideoDataset</code></a> object. <code>LabeledVideoDataset</code> class is the base class for all things video in the PyTorchVideo dataset. So, if you want to use a custom dataset not supported off-the-shelf by PyTorchVideo, you can extend the <code>LabeledVideoDataset</code> class accordingly. Refer to the <code>data</code> API <a href="https://pytorchvideo.readthedocs.io/en/latest/api/data/data.html" rel="nofollow">documentation to</a> learn more. Also, if your dataset follows a similar structure (as shown above), then using the <code>pytorchvideo.data.Ucf101()</code> should work just fine.',Tl,As,La="You can access the <code>num_videos</code> argument to know the number of videos in the dataset.",ul,Ws,fl,g,x,Ie,ks,ya,Je,qa="Visualize the preprocessed video for better debugging",bl,Bs,Il,V,Da='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif.gif" alt="Person playing basketball"/>',Cl,v,R,Ce,xs,da,je,Pa="Train the model",gl,Vs,Ka='Leverage <a href="https://huggingface.co/docs/transformers/main_classes/trainer" rel="nofollow"><code>Trainer</code></a> from  🤗 Transformers for training the model. To instantiate a <code>Trainer</code>, you need to define the training configuration and an evaluation metric. The most important is the <a href="https://huggingface.co/transformers/main_classes/trainer.html#transformers.TrainingArguments" rel="nofollow"><code>TrainingArguments</code></a>, which is a class that contains all the attributes to configure the training. It requires an output folder name, which will be used to save the checkpoints of the model. It also helps sync all the information in the model repository on 🤗 Hub.',vl,Rs,Oa="Most of the training arguments are self-explanatory, but one that is quite important here is <code>remove_unused_columns=False</code>. This one will drop any features not used by the model’s call function. By default it’s <code>True</code> because usually it’s ideal to drop unused feature columns, making it easier to unpack inputs into the model’s call function. But, in this case, you need the unused features (‘video’ in particular) in order to create <code>pixel_values</code> (which is a mandatory key our model expects in its inputs).",Zl,Xs,_l,$s,st="The dataset returned by <code>pytorchvideo.data.Ucf101()</code> doesn’t implement the <code>__len__</code> method. As such, we must define <code>max_steps</code> when instantiating <code>TrainingArguments</code>.",Gl,Es,et="Next, you need to define a function to compute the metrics from the predictions, which will use the <code>metric</code> you’ll load now. The only preprocessing you have to do is to take the argmax of our predicted logits:",Al,Ss,Wl,Fs,lt="<strong>A note on evaluation</strong>:",kl,zs,at='In the <a href="https://arxiv.org/abs/2203.12602" rel="nofollow">VideoMAE paper</a>, the authors use the following evaluation strategy. They evaluate the model on several clips from test videos and apply different crops to those clips and report the aggregate score. However, in the interest of simplicity and brevity, we don’t consider that in this tutorial.',Bl,Ys,tt="Also, define a <code>collate_fn</code>, which will be used to batch examples together. Each batch consists of 2 keys, namely <code>pixel_values</code> and <code>labels</code>.",xl,Ns,Vl,Qs,nt="Then you just pass all of this along with the datasets to <code>Trainer</code>:",Rl,Hs,Xl,Ls,pt="You might wonder why you passed along the <code>image_processor</code> as a tokenizer when you preprocessed the data already. This is only to make sure the image processor configuration file (stored as JSON) will also be uploaded to the repo on the Hub.",$l,qs,it="Now fine-tune our model by calling the <code>train</code> method:",El,Ds,Sl,Ps,ot='Once training is completed, share your model to the Hub with the <a href="/docs/transformers/v4.34.0/en/main_classes/trainer#transformers.Trainer.push_to_hub">push_to_hub()</a> method so everyone can use your model:',Fl,Ks,zl,Z,X,ge,Os,wa,Ue,Mt="Inference",Yl,se,rt="Great, now that you have fine-tuned a model, you can use it for inference!",Nl,ee,ct="Load a video for inference:",Ql,le,Hl,$,ht='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/sample_gif_two.gif" alt="Teams playing basketball"/>',Ll,ae,mt='The simplest way to try out your fine-tuned model for inference is to use it in a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/pipelines#transformers.VideoClassificationPipeline" rel="nofollow"><code>pipeline</code></a>. Instantiate a <code>pipeline</code> for video classification with your model, and pass your video to it:',ql,te,Dl,ne,yt="You can also manually replicate the results of the <code>pipeline</code> if you’d like.",Pl,pe,Kl,ie,dt="Now, pass your input to the model and return the <code>logits</code>:",Ol,oe,sa,Me,wt="Decoding the <code>logits</code>, we get:",ea,re,la,ve,aa;return E=new he({}),S=new Et({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/video_classification.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/video_classification.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/video_classification.ipynb"}]}}),A=new $t({props:{$$slots:{default:[St]},$$scope:{ctx:Ze}}}),Q=new J({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwcHl0b3JjaHZpZGVvJTIwdHJhbnNmb3JtZXJzJTIwZXZhbHVhdGU=",highlighted:"pip install -q pytorchvideo transformers evaluate",wrap:!1}}),q=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),D=new he({}),K=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQSUwQWhmX2RhdGFzZXRfaWRlbnRpZmllciUyMCUzRCUyMCUyMnNheWFrcGF1bCUyRnVjZjEwMS1zdWJzZXQlMjIlMEFmaWxlbmFtZSUyMCUzRCUyMCUyMlVDRjEwMV9zdWJzZXQudGFyLmd6JTIyJTBBZmlsZV9wYXRoJTIwJTNEJTIwaGZfaHViX2Rvd25sb2FkKHJlcG9faWQlM0RoZl9kYXRhc2V0X2lkZW50aWZpZXIlMkMlMjBmaWxlbmFtZSUzRGZpbGVuYW1lJTJDJTIwcmVwb190eXBlJTNEJTIyZGF0YXNldCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_dataset_identifier = <span class="hljs-string">&quot;sayakpaul/ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>filename = <span class="hljs-string">&quot;UCF101_subset.tar.gz&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(repo_id=hf_dataset_identifier, filename=filename, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)`,wrap:!1}}),ss=new J({props:{code:"aW1wb3J0JTIwdGFyZmlsZSUwQSUwQXdpdGglMjB0YXJmaWxlLm9wZW4oZmlsZV9wYXRoKSUyMGFzJTIwdCUzQSUwQSUyMCUyMCUyMCUyMCUyMHQuZXh0cmFjdGFsbCglMjIuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tarfile

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> tarfile.<span class="hljs-built_in">open</span>(file_path) <span class="hljs-keyword">as</span> t:
<span class="hljs-meta">... </span>     t.extractall(<span class="hljs-string">&quot;.&quot;</span>)`,wrap:!1}}),ls=new J({props:{code:"VUNGMTAxX3N1YnNldCUyRiUwQSUyMCUyMCUyMCUyMHRyYWluJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdmFsJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmFuZE1hcmNoaW5nJTJGJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEFyY2hlcnklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18xLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzIubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLi4uJTBBJTIwJTIwJTIwJTIwdGVzdCUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEJhbmRNYXJjaGluZyUyRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHZpZGVvXzEubXA0JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMi5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcmNoZXJ5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmlkZW9fMS5tcDQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB2aWRlb18yLm1wNCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMC4uLg==",highlighted:`UCF101_subset/
    train/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    val/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...
    <span class="hljs-built_in">test</span>/
        BandMarching/
            video_1.mp4
            video_2.mp4
            ...
        Archery
            video_1.mp4
            video_2.mp4
            ...
        ...`,wrap:!1}}),ts=new J({props:{code:"",highlighted:`...
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c04.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g07_c06.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g08_c01.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c02.avi&#x27;</span>,
<span class="hljs-string">&#x27;UCF101_subset/train/ApplyEyeMakeup/v_ApplyEyeMakeup_g09_c06.avi&#x27;</span>
...`,wrap:!1}}),Ms=new J({props:{code:"Y2xhc3NfbGFiZWxzJTIwJTNEJTIwc29ydGVkKCU3QnN0cihwYXRoKS5zcGxpdCglMjIlMkYlMjIpJTVCMiU1RCUyMGZvciUyMHBhdGglMjBpbiUyMGFsbF92aWRlb19maWxlX3BhdGhzJTdEKSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxhYmVsJTIwaW4lMjBlbnVtZXJhdGUoY2xhc3NfbGFiZWxzKSU3RCUwQWlkMmxhYmVsJTIwJTNEJTIwJTdCaSUzQSUyMGxhYmVsJTIwZm9yJTIwbGFiZWwlMkMlMjBpJTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTBBJTBBcHJpbnQoZiUyMlVuaXF1ZSUyMGNsYXNzZXMlM0ElMjAlN0JsaXN0KGxhYmVsMmlkLmtleXMoKSklN0QuJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>class_labels = <span class="hljs-built_in">sorted</span>({<span class="hljs-built_in">str</span>(path).split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">2</span>] <span class="hljs-keyword">for</span> path <span class="hljs-keyword">in</span> all_video_file_paths})
<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: i <span class="hljs-keyword">for</span> i, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(class_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {i: label <span class="hljs-keyword">for</span> label, i <span class="hljs-keyword">in</span> label2id.items()}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Unique classes: <span class="hljs-subst">{<span class="hljs-built_in">list</span>(label2id.keys())}</span>.&quot;</span>)

<span class="hljs-comment"># Unique classes: [&#x27;ApplyEyeMakeup&#x27;, &#x27;ApplyLipstick&#x27;, &#x27;Archery&#x27;, &#x27;BabyCrawling&#x27;, &#x27;BalanceBeam&#x27;, &#x27;BandMarching&#x27;, &#x27;BaseballPitch&#x27;, &#x27;Basketball&#x27;, &#x27;BasketballDunk&#x27;, &#x27;BenchPress&#x27;].</span>`,wrap:!1}}),cs=new he({}),ms=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTUFFSW1hZ2VQcm9jZXNzb3IlMkMlMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbF9ja3B0JTIwJTNEJTIwJTIyTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjIlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBWaWRlb01BRUltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9ja3B0KSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9ja3B0JTJDJTBBJTIwJTIwJTIwJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCUyQyUwQSUyMCUyMCUyMCUyMGlkMmxhYmVsJTNEaWQybGFiZWwlMkMlMEElMjAlMjAlMjAlMjBpZ25vcmVfbWlzbWF0Y2hlZF9zaXplcyUzRFRydWUlMkMlMjAlMjAlMjMlMjBwcm92aWRlJTIwdGhpcyUyMGluJTIwY2FzZSUyMHlvdSdyZSUyMHBsYW5uaW5nJTIwdG8lMjBmaW5lLXR1bmUlMjBhbiUyMGFscmVhZHklMjBmaW5lLXR1bmVkJTIwY2hlY2twb2ludCUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoMAEImageProcessor, VideoMAEForVideoClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model_ckpt = <span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = VideoMAEImageProcessor.from_pretrained(model_ckpt)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoMAEForVideoClassification.from_pretrained(
<span class="hljs-meta">... </span>    model_ckpt,
<span class="hljs-meta">... </span>    label2id=label2id,
<span class="hljs-meta">... </span>    id2label=id2label,
<span class="hljs-meta">... </span>    ignore_mismatched_sizes=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># provide this in case you&#x27;re planning to fine-tune an already fine-tuned checkpoint</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ds=new J({props:{code:"U29tZSUyMHdlaWdodHMlMjBvZiUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjB3ZXJlJTIwbm90JTIwdXNlZCUyMHdoZW4lMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lM0ElMjAlNUIuLi4lMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4xLmF0dGVudGlvbi5vdXRwdXQuZGVuc2UuYmlhcyclMkMlMjAnZGVjb2Rlci5kZWNvZGVyX2xheWVycy4yLmF0dGVudGlvbi5hdHRlbnRpb24ua2V5LndlaWdodCclNUQlMEEtJTIwVGhpcyUyMElTJTIwZXhwZWN0ZWQlMjBpZiUyMHlvdSUyMGFyZSUyMGluaXRpYWxpemluZyUyMFZpZGVvTUFFRm9yVmlkZW9DbGFzc2lmaWNhdGlvbiUyMGZyb20lMjB0aGUlMjBjaGVja3BvaW50JTIwb2YlMjBhJTIwbW9kZWwlMjB0cmFpbmVkJTIwb24lMjBhbm90aGVyJTIwdGFzayUyMG9yJTIwd2l0aCUyMGFub3RoZXIlMjBhcmNoaXRlY3R1cmUlMjAoZS5nLiUyMGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yUHJlVHJhaW5pbmclMjBtb2RlbCkuJTBBLSUyMFRoaXMlMjBJUyUyME5PVCUyMGV4cGVjdGVkJTIwaWYlMjB5b3UlMjBhcmUlMjBpbml0aWFsaXppbmclMjBWaWRlb01BRUZvclZpZGVvQ2xhc3NpZmljYXRpb24lMjBmcm9tJTIwdGhlJTIwY2hlY2twb2ludCUyMG9mJTIwYSUyMG1vZGVsJTIwdGhhdCUyMHlvdSUyMGV4cGVjdCUyMHRvJTIwYmUlMjBleGFjdGx5JTIwaWRlbnRpY2FsJTIwKGluaXRpYWxpemluZyUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsJTIwZnJvbSUyMGElMjBCZXJ0Rm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyMG1vZGVsKS4lMEFTb21lJTIwd2VpZ2h0cyUyMG9mJTIwVmlkZW9NQUVGb3JWaWRlb0NsYXNzaWZpY2F0aW9uJTIwd2VyZSUyMG5vdCUyMGluaXRpYWxpemVkJTIwZnJvbSUyMHRoZSUyMG1vZGVsJTIwY2hlY2twb2ludCUyMGF0JTIwTUNHLU5KVSUyRnZpZGVvbWFlLWJhc2UlMjBhbmQlMjBhcmUlMjBuZXdseSUyMGluaXRpYWxpemVkJTNBJTIwJTVCJ2NsYXNzaWZpZXIuYmlhcyclMkMlMjAnY2xhc3NpZmllci53ZWlnaHQnJTVEJTBBWW91JTIwc2hvdWxkJTIwcHJvYmFibHklMjBUUkFJTiUyMHRoaXMlMjBtb2RlbCUyMG9uJTIwYSUyMGRvd24tc3RyZWFtJTIwdGFzayUyMHRvJTIwYmUlMjBhYmxlJTIwdG8lMjB1c2UlMjBpdCUyMGZvciUyMHByZWRpY3Rpb25zJTIwYW5kJTIwaW5mZXJlbmNlLg==",highlighted:`Some weights of the model checkpoint at MCG-NJU/videomae-base were not used when initializing VideoMAEForVideoClassification: [..., <span class="hljs-string">&#x27;decoder.decoder_layers.1.attention.output.dense.bias&#x27;</span>, <span class="hljs-string">&#x27;decoder.decoder_layers.2.attention.attention.key.weight&#x27;</span>]
- This IS expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model trained on another task or with another architecture (e.g. initializing a BertForSequenceClassification model from a BertForPreTraining model).
- This IS NOT expected <span class="hljs-keyword">if</span> you are initializing VideoMAEForVideoClassification from the checkpoint of a model that you expect to be exactly identical (initializing a BertForSequenceClassification model from a BertForSequenceClassification model).
Some weights of VideoMAEForVideoClassification were not initialized from the model checkpoint at MCG-NJU/videomae-base and are newly initialized: [<span class="hljs-string">&#x27;classifier.bias&#x27;</span>, <span class="hljs-string">&#x27;classifier.weight&#x27;</span>]
You should probably TRAIN this model on a down-stream task to be able to use it <span class="hljs-keyword">for</span> predictions and inference.`,wrap:!1}}),js=new he({}),Ts=new J({props:{code:"aW1wb3J0JTIwcHl0b3JjaHZpZGVvLmRhdGElMEElMEFmcm9tJTIwcHl0b3JjaHZpZGVvLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSUyQyUwQSUyMCUyMCUyMCUyME5vcm1hbGl6ZSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbVNob3J0U2lkZVNjYWxlJTJDJTBBJTIwJTIwJTIwJTIwUmVtb3ZlS2V5JTJDJTBBJTIwJTIwJTIwJTIwU2hvcnRTaWRlU2NhbGUlMkMlMEElMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUlMkMlMEEpJTBBJTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwQ29tcG9zZSUyQyUwQSUyMCUyMCUyMCUyMExhbWJkYSUyQyUwQSUyMCUyMCUyMCUyMFJhbmRvbUNyb3AlMkMlMEElMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcCUyQyUwQSUyMCUyMCUyMCUyMFJlc2l6ZSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pytorchvideo.data

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pytorchvideo.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    ApplyTransformToKey,
<span class="hljs-meta">... </span>    Normalize,
<span class="hljs-meta">... </span>    RandomShortSideScale,
<span class="hljs-meta">... </span>    RemoveKey,
<span class="hljs-meta">... </span>    ShortSideScale,
<span class="hljs-meta">... </span>    UniformTemporalSubsample,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    Compose,
<span class="hljs-meta">... </span>    Lambda,
<span class="hljs-meta">... </span>    RandomCrop,
<span class="hljs-meta">... </span>    RandomHorizontalFlip,
<span class="hljs-meta">... </span>    Resize,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Cs=new J({props:{code:"bWVhbiUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5pbWFnZV9tZWFuJTBBc3RkJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLmltYWdlX3N0ZCUwQWlmJTIwJTIyc2hvcnRlc3RfZWRnZSUyMiUyMGluJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjB3aWR0aCUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5zaXplJTVCJTIyc2hvcnRlc3RfZWRnZSUyMiU1RCUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBoZWlnaHQlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3Iuc2l6ZSU1QiUyMmhlaWdodCUyMiU1RCUwQSUyMCUyMCUyMCUyMHdpZHRoJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnNpemUlNUIlMjJ3aWR0aCUyMiU1RCUwQXJlc2l6ZV90byUyMCUzRCUyMChoZWlnaHQlMkMlMjB3aWR0aCklMEElMEFudW1fZnJhbWVzX3RvX3NhbXBsZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5udW1fZnJhbWVzJTBBc2FtcGxlX3JhdGUlMjAlM0QlMjA0JTBBZnBzJTIwJTNEJTIwMzAlMEFjbGlwX2R1cmF0aW9uJTIwJTNEJTIwbnVtX2ZyYW1lc190b19zYW1wbGUlMjAqJTIwc2FtcGxlX3JhdGUlMjAlMkYlMjBmcHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>mean = image_processor.image_mean
<span class="hljs-meta">&gt;&gt;&gt; </span>std = image_processor.image_std
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-string">&quot;shortest_edge&quot;</span> <span class="hljs-keyword">in</span> image_processor.size:
<span class="hljs-meta">... </span>    height = width = image_processor.size[<span class="hljs-string">&quot;shortest_edge&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    height = image_processor.size[<span class="hljs-string">&quot;height&quot;</span>]
<span class="hljs-meta">... </span>    width = image_processor.size[<span class="hljs-string">&quot;width&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>resize_to = (height, width)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_frames_to_sample = model.config.num_frames
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_rate = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fps = <span class="hljs-number">30</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>clip_duration = num_frames_to_sample * sample_rate / fps`,wrap:!1}}),vs=new J({props:{code:"dHJhaW5fdHJhbnNmb3JtJTIwJTNEJTIwQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBBcHBseVRyYW5zZm9ybVRvS2V5KCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGtleSUzRCUyMnZpZGVvJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEQ29tcG9zZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbmlmb3JtVGVtcG9yYWxTdWJzYW1wbGUobnVtX2ZyYW1lc190b19zYW1wbGUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTGFtYmRhKGxhbWJkYSUyMHglM0ElMjB4JTIwJTJGJTIwMjU1LjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTm9ybWFsaXplKG1lYW4lMkMlMjBzdGQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwUmFuZG9tU2hvcnRTaWRlU2NhbGUobWluX3NpemUlM0QyNTYlMkMlMjBtYXhfc2l6ZSUzRDMyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Dcm9wKHJlc2l6ZV90byklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSYW5kb21Ib3Jpem9udGFsRmxpcChwJTNEMC41KSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQXRyYWluX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydHJhaW4lMjIpJTJDJTBBJTIwJTIwJTIwJTIwY2xpcF9zYW1wbGVyJTNEcHl0b3JjaHZpZGVvLmRhdGEubWFrZV9jbGlwX3NhbXBsZXIoJTIycmFuZG9tJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHRyYWluX3RyYW5zZm9ybSUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>train_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    RandomShortSideScale(min_size=<span class="hljs-number">256</span>, max_size=<span class="hljs-number">320</span>),
<span class="hljs-meta">... </span>                    RandomCrop(resize_to),
<span class="hljs-meta">... </span>                    RandomHorizontalFlip(p=<span class="hljs-number">0.5</span>),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;train&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;random&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=train_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),_s=new J({props:{code:"dmFsX3RyYW5zZm9ybSUyMCUzRCUyMENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQXBwbHlUcmFuc2Zvcm1Ub0tleSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXklM0QlMjJ2aWRlbyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRENvbXBvc2UoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVW5pZm9ybVRlbXBvcmFsU3Vic2FtcGxlKG51bV9mcmFtZXNfdG9fc2FtcGxlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMExhbWJkYShsYW1iZGElMjB4JTNBJTIweCUyMCUyRiUyMDI1NS4wKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME5vcm1hbGl6ZShtZWFuJTJDJTIwc3RkKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlc2l6ZShyZXNpemVfdG8pJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlNUQlMEEpJTBBJTBBdmFsX2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydmFsJTIyKSUyQyUwQSUyMCUyMCUyMCUyMGNsaXBfc2FtcGxlciUzRHB5dG9yY2h2aWRlby5kYXRhLm1ha2VfY2xpcF9zYW1wbGVyKCUyMnVuaWZvcm0lMjIlMkMlMjBjbGlwX2R1cmF0aW9uKSUyQyUwQSUyMCUyMCUyMCUyMGRlY29kZV9hdWRpbyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtJTNEdmFsX3RyYW5zZm9ybSUyQyUwQSklMEElMEF0ZXN0X2RhdGFzZXQlMjAlM0QlMjBweXRvcmNodmlkZW8uZGF0YS5VY2YxMDEoJTBBJTIwJTIwJTIwJTIwZGF0YV9wYXRoJTNEb3MucGF0aC5qb2luKGRhdGFzZXRfcm9vdF9wYXRoJTJDJTIwJTIydGVzdCUyMiklMkMlMEElMjAlMjAlMjAlMjBjbGlwX3NhbXBsZXIlM0RweXRvcmNodmlkZW8uZGF0YS5tYWtlX2NsaXBfc2FtcGxlciglMjJ1bmlmb3JtJTIyJTJDJTIwY2xpcF9kdXJhdGlvbiklMkMlMEElMjAlMjAlMjAlMjBkZWNvZGVfYXVkaW8lM0RGYWxzZSUyQyUwQSUyMCUyMCUyMCUyMHRyYW5zZm9ybSUzRHZhbF90cmFuc2Zvcm0lMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>val_transform = Compose(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        ApplyTransformToKey(
<span class="hljs-meta">... </span>            key=<span class="hljs-string">&quot;video&quot;</span>,
<span class="hljs-meta">... </span>            transform=Compose(
<span class="hljs-meta">... </span>                [
<span class="hljs-meta">... </span>                    UniformTemporalSubsample(num_frames_to_sample),
<span class="hljs-meta">... </span>                    Lambda(<span class="hljs-keyword">lambda</span> x: x / <span class="hljs-number">255.0</span>),
<span class="hljs-meta">... </span>                    Normalize(mean, std),
<span class="hljs-meta">... </span>                    Resize(resize_to),
<span class="hljs-meta">... </span>                ]
<span class="hljs-meta">... </span>            ),
<span class="hljs-meta">... </span>        ),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>val_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;val&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>test_dataset = pytorchvideo.data.Ucf101(
<span class="hljs-meta">... </span>    data_path=os.path.join(dataset_root_path, <span class="hljs-string">&quot;test&quot;</span>),
<span class="hljs-meta">... </span>    clip_sampler=pytorchvideo.data.make_clip_sampler(<span class="hljs-string">&quot;uniform&quot;</span>, clip_duration),
<span class="hljs-meta">... </span>    decode_audio=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    transform=val_transform,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ws=new J({props:{code:"cHJpbnQodHJhaW5fZGF0YXNldC5udW1fdmlkZW9zJTJDJTIwdmFsX2RhdGFzZXQubnVtX3ZpZGVvcyUyQyUyMHRlc3RfZGF0YXNldC5udW1fdmlkZW9zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(train_dataset.num_videos, val_dataset.num_videos, test_dataset.num_videos)
<span class="hljs-comment"># (300, 30, 75)</span>`,wrap:!1}}),ks=new he({}),Bs=new J({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> imageio
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">unnormalize_img</span>(<span class="hljs-params">img</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Un-normalizes the image pixels.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    img = (img * std) + mean
<span class="hljs-meta">... </span>    img = (img * <span class="hljs-number">255</span>).astype(<span class="hljs-string">&quot;uint8&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> img.clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">create_gif</span>(<span class="hljs-params">video_tensor, filename=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares a GIF from a video tensor.
<span class="hljs-meta">... </span>    
<span class="hljs-meta">... </span>    The video tensor is expected to have the following shape:
<span class="hljs-meta">... </span>    (num_frames, num_channels, height, width).
<span class="hljs-meta">... </span>    &quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> video_frame <span class="hljs-keyword">in</span> video_tensor:
<span class="hljs-meta">... </span>        frame_unnormalized = unnormalize_img(video_frame.permute(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">0</span>).numpy())
<span class="hljs-meta">... </span>        frames.append(frame_unnormalized)
<span class="hljs-meta">... </span>    kargs = {<span class="hljs-string">&quot;duration&quot;</span>: <span class="hljs-number">0.25</span>}
<span class="hljs-meta">... </span>    imageio.mimsave(filename, frames, <span class="hljs-string">&quot;GIF&quot;</span>, **kargs)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> filename

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">display_gif</span>(<span class="hljs-params">video_tensor, gif_name=<span class="hljs-string">&quot;sample.gif&quot;</span></span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;&quot;&quot;Prepares and displays a GIF from a video tensor.&quot;&quot;&quot;</span>
<span class="hljs-meta">... </span>    video_tensor = video_tensor.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    gif_filename = create_gif(video_tensor, gif_name)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> Image(filename=gif_filename)

<span class="hljs-meta">&gt;&gt;&gt; </span>sample_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(train_dataset))
<span class="hljs-meta">&gt;&gt;&gt; </span>video_tensor = sample_video[<span class="hljs-string">&quot;video&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>display_gif(video_tensor)`,wrap:!1}}),xs=new he({}),Xs=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUwQSUwQW1vZGVsX25hbWUlMjAlM0QlMjBtb2RlbF9ja3B0LnNwbGl0KCUyMiUyRiUyMiklNUItMSU1RCUwQW5ld19tb2RlbF9uYW1lJTIwJTNEJTIwZiUyMiU3Qm1vZGVsX25hbWUlN0QtZmluZXR1bmVkLXVjZjEwMS1zdWJzZXQlMjIlMEFudW1fZXBvY2hzJTIwJTNEJTIwNCUwQSUwQWFyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBuZXdfbW9kZWxfbmFtZSUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwZXZhbHVhdGlvbl9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9zdHJhdGVneSUzRCUyMmVwb2NoJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0RiYXRjaF9zaXplJTJDJTBBJTIwJTIwJTIwJTIwd2FybXVwX3JhdGlvJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDEwJTJDJTBBJTIwJTIwJTIwJTIwbG9hZF9iZXN0X21vZGVsX2F0X2VuZCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBtZXRyaWNfZm9yX2Jlc3RfbW9kZWwlM0QlMjJhY2N1cmFjeSUyMiUyQyUwQSUyMCUyMCUyMCUyMHB1c2hfdG9faHViJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9zdGVwcyUzRCh0cmFpbl9kYXRhc2V0Lm51bV92aWRlb3MlMjAlMkYlMkYlMjBiYXRjaF9zaXplKSUyMColMjBudW1fZXBvY2hzJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>model_name = model_ckpt.split(<span class="hljs-string">&quot;/&quot;</span>)[-<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>new_model_name = <span class="hljs-string">f&quot;<span class="hljs-subst">{model_name}</span>-finetuned-ucf101-subset&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">4</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>args = TrainingArguments(
<span class="hljs-meta">... </span>    new_model_name,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    per_device_train_batch_size=batch_size,
<span class="hljs-meta">... </span>    per_device_eval_batch_size=batch_size,
<span class="hljs-meta">... </span>    warmup_ratio=<span class="hljs-number">0.1</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">10</span>,
<span class="hljs-meta">... </span>    load_best_model_at_end=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    metric_for_best_model=<span class="hljs-string">&quot;accuracy&quot;</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    max_steps=(train_dataset.num_videos // batch_size) * num_epochs,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ss=new J({props:{code:"aW1wb3J0JTIwZXZhbHVhdGUlMEElMEFtZXRyaWMlMjAlM0QlMjBldmFsdWF0ZS5sb2FkKCUyMmFjY3VyYWN5JTIyKSUwQSUwQSUwQWRlZiUyMGNvbXB1dGVfbWV0cmljcyhldmFsX3ByZWQpJTNBJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBucC5hcmdtYXgoZXZhbF9wcmVkLnByZWRpY3Rpb25zJTJDJTIwYXhpcyUzRDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RldmFsX3ByZWQubGFiZWxfaWRzKQ==",highlighted:`<span class="hljs-keyword">import</span> evaluate

metric = evaluate.load(<span class="hljs-string">&quot;accuracy&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
    predictions = np.argmax(eval_pred.predictions, axis=<span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=eval_pred.label_ids)`,wrap:!1}}),Ns=new J({props:{code:"ZGVmJTIwY29sbGF0ZV9mbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBwZXJtdXRlJTIwdG8lMjAobnVtX2ZyYW1lcyUyQyUyMG51bV9jaGFubmVscyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSUwQSUyMCUyMCUyMCUyMHBpeGVsX3ZhbHVlcyUyMCUzRCUyMHRvcmNoLnN0YWNrKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1QmV4YW1wbGUlNUIlMjJ2aWRlbyUyMiU1RC5wZXJtdXRlKDElMkMlMjAwJTJDJTIwMiUyQyUyMDMpJTIwZm9yJTIwZXhhbXBsZSUyMGluJTIwZXhhbXBsZXMlNUQlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwbGFiZWxzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmV4YW1wbGUlNUIlMjJsYWJlbCUyMiU1RCUyMGZvciUyMGV4YW1wbGUlMjBpbiUyMGV4YW1wbGVzJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBpeGVsX3ZhbHVlcyUyQyUyMCUyMmxhYmVscyUyMiUzQSUyMGxhYmVscyU3RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">collate_fn</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># permute to (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    pixel_values = torch.stack(
<span class="hljs-meta">... </span>        [example[<span class="hljs-string">&quot;video&quot;</span>].permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples]
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>    labels = torch.tensor([example[<span class="hljs-string">&quot;label&quot;</span>] <span class="hljs-keyword">for</span> example <span class="hljs-keyword">in</span> examples])
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;pixel_values&quot;</span>: pixel_values, <span class="hljs-string">&quot;labels&quot;</span>: labels}`,wrap:!1}}),Hs=new J({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0R2YWxfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRGltYWdlX3Byb2Nlc3NvciUyQyUwQSUyMCUyMCUyMCUyMGNvbXB1dGVfbWV0cmljcyUzRGNvbXB1dGVfbWV0cmljcyUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0Rjb2xsYXRlX2ZuJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model,
<span class="hljs-meta">... </span>    args,
<span class="hljs-meta">... </span>    train_dataset=train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=val_dataset,
<span class="hljs-meta">... </span>    tokenizer=image_processor,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>    data_collator=collate_fn,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Ds=new J({props:{code:"dHJhaW5fcmVzdWx0cyUyMCUzRCUyMHRyYWluZXIudHJhaW4oKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>train_results = trainer.train()',wrap:!1}}),Ks=new J({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Os=new he({}),le=new J({props:{code:"c2FtcGxlX3Rlc3RfdmlkZW8lMjAlM0QlMjBuZXh0KGl0ZXIodGVzdF9kYXRhc2V0KSk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>sample_test_video = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(test_dataset))',wrap:!1}}),te=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlkZW9fY2xzJTIwJTNEJTIwcGlwZWxpbmUobW9kZWwlM0QlMjJteV9hd2Vzb21lX3ZpZGVvX2Nsc19tb2RlbCUyMiklMEF2aWRlb19jbHMoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGc2F5YWtwYXVsJTJGdWNmMTAxLXN1YnNldCUyRnJlc29sdmUlMkZtYWluJTJGdl9CYXNrZXRiYWxsRHVua19nMTRfYzA2LmF2aSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls = pipeline(model=<span class="hljs-string">&quot;my_awesome_video_cls_model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>video_cls(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/ucf101-subset/resolve/main/v_BasketballDunk_g14_c06.avi&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9272987842559814</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BasketballDunk&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.017777055501937866</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BabyCrawling&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.01663011871278286</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BalanceBeam&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.009560945443809032</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BandMarching&#x27;</span>},
 {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0068979403004050255</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;BaseballPitch&#x27;</span>}]`,wrap:!1}}),pe=new J({props:{code:"ZGVmJTIwcnVuX2luZmVyZW5jZShtb2RlbCUyQyUyMHZpZGVvKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMChudW1fZnJhbWVzJTJDJTIwbnVtX2NoYW5uZWxzJTJDJTIwaGVpZ2h0JTJDJTIwd2lkdGgpJTBBJTIwJTIwJTIwJTIwcGVydW11dGVkX3NhbXBsZV90ZXN0X3ZpZGVvJTIwJTNEJTIwdmlkZW8ucGVybXV0ZSgxJTJDJTIwMCUyQyUyMDIlMkMlMjAzKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnBpeGVsX3ZhbHVlcyUyMiUzQSUyMHBlcnVtdXRlZF9zYW1wbGVfdGVzdF92aWRlby51bnNxdWVlemUoMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJsYWJlbHMlMjIlM0ElMjB0b3JjaC50ZW5zb3IoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTVCc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJsYWJlbCUyMiU1RCU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMjAlMjAlMjMlMjB0aGlzJTIwY2FuJTIwYmUlMjBza2lwcGVkJTIwaWYlMjB5b3UlMjBkb24ndCUyMGhhdmUlMjBsYWJlbHMlMjBhdmFpbGFibGUuJTBBJTIwJTIwJTIwJTIwJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCUyMmN1ZGElMjIlMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwJTIyY3B1JTIyKSUwQSUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMCU3QmslM0ElMjB2LnRvKGRldmljZSklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMG1vZGVsLnRvKGRldmljZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBsb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">run_inference</span>(<span class="hljs-params">model, video</span>):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># (num_frames, num_channels, height, width)</span>
<span class="hljs-meta">... </span>    perumuted_sample_test_video = video.permute(<span class="hljs-number">1</span>, <span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>)
<span class="hljs-meta">... </span>    inputs = {
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;pixel_values&quot;</span>: perumuted_sample_test_video.unsqueeze(<span class="hljs-number">0</span>),
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;labels&quot;</span>: torch.tensor(
<span class="hljs-meta">... </span>            [sample_test_video[<span class="hljs-string">&quot;label&quot;</span>]]
<span class="hljs-meta">... </span>        ),  <span class="hljs-comment"># this can be skipped if you don&#x27;t have labels available.</span>
<span class="hljs-meta">... </span>    }

<span class="hljs-meta">... </span>    device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">... </span>    inputs = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}
<span class="hljs-meta">... </span>    model = model.to(device)

<span class="hljs-meta">... </span>    <span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**inputs)
<span class="hljs-meta">... </span>        logits = outputs.logits

<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> logits`,wrap:!1}}),oe=new J({props:{code:"bG9naXRzJTIwJTNEJTIwcnVuX2luZmVyZW5jZSh0cmFpbmVkX21vZGVsJTJDJTIwc2FtcGxlX3Rlc3RfdmlkZW8lNUIlMjJ2aWRlbyUyMiU1RCk=",highlighted:'&gt;&gt;&gt; logits = run<span class="hljs-constructor">_inference(<span class="hljs-params">trained_model</span>, <span class="hljs-params">sample_test_video</span>[<span class="hljs-string">&quot;video&quot;</span>])</span>',wrap:!1}}),re=new J({props:{code:"cHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
<span class="hljs-comment"># Predicted class: BasketballDunk</span>`,wrap:!1}}),{c(){U=p("meta"),T=t(),_=p("p"),u=t(),f=p("h1"),G=p("a"),Te=p("span"),M(E.$$.fragment),ra=t(),me=p("span"),me.textContent=Ja,_e=t(),M(S.$$.fragment),Ge=t(),F=p("p"),F.textContent=ja,Ae=t(),z=p("p"),z.textContent=Ua,We=t(),Y=p("ol"),Y.innerHTML=Ta,ke=t(),M(A.$$.fragment),Be=t(),N=p("p"),N.textContent=ua,xe=t(),M(Q.$$.fragment),Ve=t(),H=p("p"),H.innerHTML=fa,Re=t(),L=p("p"),L.textContent=ba,Xe=t(),M(q.$$.fragment),$e=t(),b=p("h2"),W=p("a"),ue=p("span"),M(D.$$.fragment),ca=t(),ye=p("span"),ye.textContent=Ia,Ee=t(),P=p("p"),P.innerHTML=Ca,Se=t(),M(K.$$.fragment),Fe=t(),O=p("p"),O.textContent=ga,ze=t(),M(ss.$$.fragment),Ye=t(),es=p("p"),es.textContent=va,Ne=t(),M(ls.$$.fragment),Qe=t(),as=p("p"),as.innerHTML=Za,He=t(),M(ts.$$.fragment),Le=t(),ns=p("p"),ns.innerHTML=_a,qe=t(),ps=p("p"),ps.innerHTML=Ga,De=t(),is=p("p"),is.textContent=Aa,Pe=t(),os=p("ul"),os.innerHTML=Wa,Ke=t(),M(Ms.$$.fragment),Oe=t(),rs=p("p"),rs.textContent=ka,sl=t(),I=p("h2"),k=p("a"),fe=p("span"),M(cs.$$.fragment),ha=t(),de=p("span"),de.textContent=Ba,el=t(),hs=p("p"),hs.textContent=xa,ll=t(),M(ms.$$.fragment),al=t(),ys=p("p"),ys.textContent=Va,tl=t(),M(ds.$$.fragment),nl=t(),ws=p("p"),ws.innerHTML=Ra,pl=t(),Js=p("p"),Js.innerHTML=Xa,il=t(),C=p("h2"),B=p("a"),be=p("span"),M(js.$$.fragment),ma=t(),we=p("span"),we.textContent=$a,ol=t(),Us=p("p"),Us.innerHTML=Ea,Ml=t(),M(Ts.$$.fragment),rl=t(),us=p("p"),us.innerHTML=Sa,cl=t(),fs=p("p"),fs.innerHTML=Fa,hl=t(),bs=p("ul"),bs.innerHTML=za,ml=t(),Is=p("p"),Is.textContent=Ya,yl=t(),M(Cs.$$.fragment),dl=t(),gs=p("p"),gs.textContent=Na,wl=t(),M(vs.$$.fragment),Jl=t(),Zs=p("p"),Zs.textContent=Qa,jl=t(),M(_s.$$.fragment),Ul=t(),Gs=p("p"),Gs.innerHTML=Ha,Tl=t(),As=p("p"),As.innerHTML=La,ul=t(),M(Ws.$$.fragment),fl=t(),g=p("h2"),x=p("a"),Ie=p("span"),M(ks.$$.fragment),ya=t(),Je=p("span"),Je.textContent=qa,bl=t(),M(Bs.$$.fragment),Il=t(),V=p("div"),V.innerHTML=Da,Cl=t(),v=p("h2"),R=p("a"),Ce=p("span"),M(xs.$$.fragment),da=t(),je=p("span"),je.textContent=Pa,gl=t(),Vs=p("p"),Vs.innerHTML=Ka,vl=t(),Rs=p("p"),Rs.innerHTML=Oa,Zl=t(),M(Xs.$$.fragment),_l=t(),$s=p("p"),$s.innerHTML=st,Gl=t(),Es=p("p"),Es.innerHTML=et,Al=t(),M(Ss.$$.fragment),Wl=t(),Fs=p("p"),Fs.innerHTML=lt,kl=t(),zs=p("p"),zs.innerHTML=at,Bl=t(),Ys=p("p"),Ys.innerHTML=tt,xl=t(),M(Ns.$$.fragment),Vl=t(),Qs=p("p"),Qs.innerHTML=nt,Rl=t(),M(Hs.$$.fragment),Xl=t(),Ls=p("p"),Ls.innerHTML=pt,$l=t(),qs=p("p"),qs.innerHTML=it,El=t(),M(Ds.$$.fragment),Sl=t(),Ps=p("p"),Ps.innerHTML=ot,Fl=t(),M(Ks.$$.fragment),zl=t(),Z=p("h2"),X=p("a"),ge=p("span"),M(Os.$$.fragment),wa=t(),Ue=p("span"),Ue.textContent=Mt,Yl=t(),se=p("p"),se.textContent=rt,Nl=t(),ee=p("p"),ee.textContent=ct,Ql=t(),M(le.$$.fragment),Hl=t(),$=p("div"),$.innerHTML=ht,Ll=t(),ae=p("p"),ae.innerHTML=mt,ql=t(),M(te.$$.fragment),Dl=t(),ne=p("p"),ne.innerHTML=yt,Pl=t(),M(pe.$$.fragment),Kl=t(),ie=p("p"),ie.innerHTML=dt,Ol=t(),M(oe.$$.fragment),sa=t(),Me=p("p"),Me.innerHTML=wt,ea=t(),M(re.$$.fragment),la=t(),ve=p("p"),this.h()},l(s){const e=Vt("svelte-1phssyn",document.head);U=i(e,"META",{name:!0,content:!0}),e.forEach(l),T=n(s),_=i(s,"P",{}),j(_).forEach(l),u=n(s),f=i(s,"H1",{class:!0});var ce=j(f);G=i(ce,"A",{id:!0,class:!0,href:!0});var Jt=j(G);Te=i(Jt,"SPAN",{});var jt=j(Te);r(E.$$.fragment,jt),jt.forEach(l),Jt.forEach(l),ra=n(ce),me=i(ce,"SPAN",{"data-svelte-h":!0}),o(me)!=="svelte-1vwwdb2"&&(me.textContent=Ja),ce.forEach(l),_e=n(s),r(S.$$.fragment,s),Ge=n(s),F=i(s,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1uw5n59"&&(F.textContent=ja),Ae=n(s),z=i(s,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1aff4p7"&&(z.textContent=Ua),We=n(s),Y=i(s,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-1qfvs25"&&(Y.innerHTML=Ta),ke=n(s),r(A.$$.fragment,s),Be=n(s),N=i(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1c9nexd"&&(N.textContent=ua),xe=n(s),r(Q.$$.fragment,s),Ve=n(s),H=i(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-cnicg0"&&(H.innerHTML=fa),Re=n(s),L=i(s,"P",{"data-svelte-h":!0}),o(L)!=="svelte-27hn0u"&&(L.textContent=ba),Xe=n(s),r(q.$$.fragment,s),$e=n(s),b=i(s,"H2",{class:!0});var ta=j(b);W=i(ta,"A",{id:!0,class:!0,href:!0});var Ut=j(W);ue=i(Ut,"SPAN",{});var Tt=j(ue);r(D.$$.fragment,Tt),Tt.forEach(l),Ut.forEach(l),ca=n(ta),ye=i(ta,"SPAN",{"data-svelte-h":!0}),o(ye)!=="svelte-z7egtd"&&(ye.textContent=Ia),ta.forEach(l),Ee=n(s),P=i(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-zo4tpc"&&(P.innerHTML=Ca),Se=n(s),r(K.$$.fragment,s),Fe=n(s),O=i(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-yyrc6l"&&(O.textContent=ga),ze=n(s),r(ss.$$.fragment,s),Ye=n(s),es=i(s,"P",{"data-svelte-h":!0}),o(es)!=="svelte-vxwx6z"&&(es.textContent=va),Ne=n(s),r(ls.$$.fragment,s),Qe=n(s),as=i(s,"P",{"data-svelte-h":!0}),o(as)!=="svelte-xl39ap"&&(as.innerHTML=Za),He=n(s),r(ts.$$.fragment,s),Le=n(s),ns=i(s,"P",{"data-svelte-h":!0}),o(ns)!=="svelte-1t7u230"&&(ns.innerHTML=_a),qe=n(s),ps=i(s,"P",{"data-svelte-h":!0}),o(ps)!=="svelte-igo46q"&&(ps.innerHTML=Ga),De=n(s),is=i(s,"P",{"data-svelte-h":!0}),o(is)!=="svelte-4ll1ff"&&(is.textContent=Aa),Pe=n(s),os=i(s,"UL",{"data-svelte-h":!0}),o(os)!=="svelte-1y0n38a"&&(os.innerHTML=Wa),Ke=n(s),r(Ms.$$.fragment,s),Oe=n(s),rs=i(s,"P",{"data-svelte-h":!0}),o(rs)!=="svelte-1z0r2k5"&&(rs.textContent=ka),sl=n(s),I=i(s,"H2",{class:!0});var na=j(I);k=i(na,"A",{id:!0,class:!0,href:!0});var ut=j(k);fe=i(ut,"SPAN",{});var ft=j(fe);r(cs.$$.fragment,ft),ft.forEach(l),ut.forEach(l),ha=n(na),de=i(na,"SPAN",{"data-svelte-h":!0}),o(de)!=="svelte-m33fft"&&(de.textContent=Ba),na.forEach(l),el=n(s),hs=i(s,"P",{"data-svelte-h":!0}),o(hs)!=="svelte-14088fx"&&(hs.textContent=xa),ll=n(s),r(ms.$$.fragment,s),al=n(s),ys=i(s,"P",{"data-svelte-h":!0}),o(ys)!=="svelte-1rauzal"&&(ys.textContent=Va),tl=n(s),r(ds.$$.fragment,s),nl=n(s),ws=i(s,"P",{"data-svelte-h":!0}),o(ws)!=="svelte-19dkvgp"&&(ws.innerHTML=Ra),pl=n(s),Js=i(s,"P",{"data-svelte-h":!0}),o(Js)!=="svelte-nk737h"&&(Js.innerHTML=Xa),il=n(s),C=i(s,"H2",{class:!0});var pa=j(C);B=i(pa,"A",{id:!0,class:!0,href:!0});var bt=j(B);be=i(bt,"SPAN",{});var It=j(be);r(js.$$.fragment,It),It.forEach(l),bt.forEach(l),ma=n(pa),we=i(pa,"SPAN",{"data-svelte-h":!0}),o(we)!=="svelte-g9w9z7"&&(we.textContent=$a),pa.forEach(l),ol=n(s),Us=i(s,"P",{"data-svelte-h":!0}),o(Us)!=="svelte-islfqt"&&(Us.innerHTML=Ea),Ml=n(s),r(Ts.$$.fragment,s),rl=n(s),us=i(s,"P",{"data-svelte-h":!0}),o(us)!=="svelte-5m4gle"&&(us.innerHTML=Sa),cl=n(s),fs=i(s,"P",{"data-svelte-h":!0}),o(fs)!=="svelte-8w7a7w"&&(fs.innerHTML=Fa),hl=n(s),bs=i(s,"UL",{"data-svelte-h":!0}),o(bs)!=="svelte-u2neln"&&(bs.innerHTML=za),ml=n(s),Is=i(s,"P",{"data-svelte-h":!0}),o(Is)!=="svelte-llv4fi"&&(Is.textContent=Ya),yl=n(s),r(Cs.$$.fragment,s),dl=n(s),gs=i(s,"P",{"data-svelte-h":!0}),o(gs)!=="svelte-1lr33l4"&&(gs.textContent=Na),wl=n(s),r(vs.$$.fragment,s),Jl=n(s),Zs=i(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-92qkhv"&&(Zs.textContent=Qa),jl=n(s),r(_s.$$.fragment,s),Ul=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),o(Gs)!=="svelte-lyltai"&&(Gs.innerHTML=Ha),Tl=n(s),As=i(s,"P",{"data-svelte-h":!0}),o(As)!=="svelte-1vli4t8"&&(As.innerHTML=La),ul=n(s),r(Ws.$$.fragment,s),fl=n(s),g=i(s,"H2",{class:!0});var ia=j(g);x=i(ia,"A",{id:!0,class:!0,href:!0});var Ct=j(x);Ie=i(Ct,"SPAN",{});var gt=j(Ie);r(ks.$$.fragment,gt),gt.forEach(l),Ct.forEach(l),ya=n(ia),Je=i(ia,"SPAN",{"data-svelte-h":!0}),o(Je)!=="svelte-16bcby7"&&(Je.textContent=qa),ia.forEach(l),bl=n(s),r(Bs.$$.fragment,s),Il=n(s),V=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o(V)!=="svelte-1mxsghh"&&(V.innerHTML=Da),Cl=n(s),v=i(s,"H2",{class:!0});var oa=j(v);R=i(oa,"A",{id:!0,class:!0,href:!0});var vt=j(R);Ce=i(vt,"SPAN",{});var Zt=j(Ce);r(xs.$$.fragment,Zt),Zt.forEach(l),vt.forEach(l),da=n(oa),je=i(oa,"SPAN",{"data-svelte-h":!0}),o(je)!=="svelte-9ydwd"&&(je.textContent=Pa),oa.forEach(l),gl=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-rirkpj"&&(Vs.innerHTML=Ka),vl=n(s),Rs=i(s,"P",{"data-svelte-h":!0}),o(Rs)!=="svelte-ixq0kp"&&(Rs.innerHTML=Oa),Zl=n(s),r(Xs.$$.fragment,s),_l=n(s),$s=i(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-1v50sum"&&($s.innerHTML=st),Gl=n(s),Es=i(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-1kbaooa"&&(Es.innerHTML=et),Al=n(s),r(Ss.$$.fragment,s),Wl=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-1yc7v5f"&&(Fs.innerHTML=lt),kl=n(s),zs=i(s,"P",{"data-svelte-h":!0}),o(zs)!=="svelte-9bk5j6"&&(zs.innerHTML=at),Bl=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-1csqroh"&&(Ys.innerHTML=tt),xl=n(s),r(Ns.$$.fragment,s),Vl=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-16wl6hd"&&(Qs.innerHTML=nt),Rl=n(s),r(Hs.$$.fragment,s),Xl=n(s),Ls=i(s,"P",{"data-svelte-h":!0}),o(Ls)!=="svelte-g6wg27"&&(Ls.innerHTML=pt),$l=n(s),qs=i(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-umxz0w"&&(qs.innerHTML=it),El=n(s),r(Ds.$$.fragment,s),Sl=n(s),Ps=i(s,"P",{"data-svelte-h":!0}),o(Ps)!=="svelte-cv8z08"&&(Ps.innerHTML=ot),Fl=n(s),r(Ks.$$.fragment,s),zl=n(s),Z=i(s,"H2",{class:!0});var Ma=j(Z);X=i(Ma,"A",{id:!0,class:!0,href:!0});var _t=j(X);ge=i(_t,"SPAN",{});var Gt=j(ge);r(Os.$$.fragment,Gt),Gt.forEach(l),_t.forEach(l),wa=n(Ma),Ue=i(Ma,"SPAN",{"data-svelte-h":!0}),o(Ue)!=="svelte-199uz7g"&&(Ue.textContent=Mt),Ma.forEach(l),Yl=n(s),se=i(s,"P",{"data-svelte-h":!0}),o(se)!=="svelte-riodtu"&&(se.textContent=rt),Nl=n(s),ee=i(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-w1spga"&&(ee.textContent=ct),Ql=n(s),r(le.$$.fragment,s),Hl=n(s),$=i(s,"DIV",{class:!0,"data-svelte-h":!0}),o($)!=="svelte-556htt"&&($.innerHTML=ht),Ll=n(s),ae=i(s,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-e8z0ag"&&(ae.innerHTML=mt),ql=n(s),r(te.$$.fragment,s),Dl=n(s),ne=i(s,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-1j33lbi"&&(ne.innerHTML=yt),Pl=n(s),r(pe.$$.fragment,s),Kl=n(s),ie=i(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-12olihs"&&(ie.innerHTML=dt),Ol=n(s),r(oe.$$.fragment,s),sa=n(s),Me=i(s,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1v8qszj"&&(Me.innerHTML=wt),ea=n(s),r(re.$$.fragment,s),la=n(s),ve=i(s,"P",{}),j(ve).forEach(l),this.h()},h(){d(U,"name","hf:doc:metadata"),d(U,"content",JSON.stringify(zt)),d(G,"id","video-classification"),d(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(G,"href","#video-classification"),d(f,"class","relative group"),d(W,"id","load-ucf101-dataset"),d(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(W,"href","#load-ucf101-dataset"),d(b,"class","relative group"),d(k,"id","load-a-model-to-finetune"),d(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(k,"href","#load-a-model-to-finetune"),d(I,"class","relative group"),d(B,"id","prepare-the-datasets-for-training"),d(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(B,"href","#prepare-the-datasets-for-training"),d(C,"class","relative group"),d(x,"id","visualize-the-preprocessed-video-for-better-debugging"),d(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(x,"href","#visualize-the-preprocessed-video-for-better-debugging"),d(g,"class","relative group"),d(V,"class","flex justify-center"),d(R,"id","train-the-model"),d(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(R,"href","#train-the-model"),d(v,"class","relative group"),d(X,"id","inference"),d(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(X,"href","#inference"),d(Z,"class","relative group"),d($,"class","flex justify-center")},m(s,e){w(document.head,U),a(s,T,e),a(s,_,e),a(s,u,e),a(s,f,e),w(f,G),w(G,Te),c(E,Te,null),w(f,ra),w(f,me),a(s,_e,e),c(S,s,e),a(s,Ge,e),a(s,F,e),a(s,Ae,e),a(s,z,e),a(s,We,e),a(s,Y,e),a(s,ke,e),c(A,s,e),a(s,Be,e),a(s,N,e),a(s,xe,e),c(Q,s,e),a(s,Ve,e),a(s,H,e),a(s,Re,e),a(s,L,e),a(s,Xe,e),c(q,s,e),a(s,$e,e),a(s,b,e),w(b,W),w(W,ue),c(D,ue,null),w(b,ca),w(b,ye),a(s,Ee,e),a(s,P,e),a(s,Se,e),c(K,s,e),a(s,Fe,e),a(s,O,e),a(s,ze,e),c(ss,s,e),a(s,Ye,e),a(s,es,e),a(s,Ne,e),c(ls,s,e),a(s,Qe,e),a(s,as,e),a(s,He,e),c(ts,s,e),a(s,Le,e),a(s,ns,e),a(s,qe,e),a(s,ps,e),a(s,De,e),a(s,is,e),a(s,Pe,e),a(s,os,e),a(s,Ke,e),c(Ms,s,e),a(s,Oe,e),a(s,rs,e),a(s,sl,e),a(s,I,e),w(I,k),w(k,fe),c(cs,fe,null),w(I,ha),w(I,de),a(s,el,e),a(s,hs,e),a(s,ll,e),c(ms,s,e),a(s,al,e),a(s,ys,e),a(s,tl,e),c(ds,s,e),a(s,nl,e),a(s,ws,e),a(s,pl,e),a(s,Js,e),a(s,il,e),a(s,C,e),w(C,B),w(B,be),c(js,be,null),w(C,ma),w(C,we),a(s,ol,e),a(s,Us,e),a(s,Ml,e),c(Ts,s,e),a(s,rl,e),a(s,us,e),a(s,cl,e),a(s,fs,e),a(s,hl,e),a(s,bs,e),a(s,ml,e),a(s,Is,e),a(s,yl,e),c(Cs,s,e),a(s,dl,e),a(s,gs,e),a(s,wl,e),c(vs,s,e),a(s,Jl,e),a(s,Zs,e),a(s,jl,e),c(_s,s,e),a(s,Ul,e),a(s,Gs,e),a(s,Tl,e),a(s,As,e),a(s,ul,e),c(Ws,s,e),a(s,fl,e),a(s,g,e),w(g,x),w(x,Ie),c(ks,Ie,null),w(g,ya),w(g,Je),a(s,bl,e),c(Bs,s,e),a(s,Il,e),a(s,V,e),a(s,Cl,e),a(s,v,e),w(v,R),w(R,Ce),c(xs,Ce,null),w(v,da),w(v,je),a(s,gl,e),a(s,Vs,e),a(s,vl,e),a(s,Rs,e),a(s,Zl,e),c(Xs,s,e),a(s,_l,e),a(s,$s,e),a(s,Gl,e),a(s,Es,e),a(s,Al,e),c(Ss,s,e),a(s,Wl,e),a(s,Fs,e),a(s,kl,e),a(s,zs,e),a(s,Bl,e),a(s,Ys,e),a(s,xl,e),c(Ns,s,e),a(s,Vl,e),a(s,Qs,e),a(s,Rl,e),c(Hs,s,e),a(s,Xl,e),a(s,Ls,e),a(s,$l,e),a(s,qs,e),a(s,El,e),c(Ds,s,e),a(s,Sl,e),a(s,Ps,e),a(s,Fl,e),c(Ks,s,e),a(s,zl,e),a(s,Z,e),w(Z,X),w(X,ge),c(Os,ge,null),w(Z,wa),w(Z,Ue),a(s,Yl,e),a(s,se,e),a(s,Nl,e),a(s,ee,e),a(s,Ql,e),c(le,s,e),a(s,Hl,e),a(s,$,e),a(s,Ll,e),a(s,ae,e),a(s,ql,e),c(te,s,e),a(s,Dl,e),a(s,ne,e),a(s,Pl,e),c(pe,s,e),a(s,Kl,e),a(s,ie,e),a(s,Ol,e),c(oe,s,e),a(s,sa,e),a(s,Me,e),a(s,ea,e),c(re,s,e),a(s,la,e),a(s,ve,e),aa=!0},p(s,[e]){const ce={};e&2&&(ce.$$scope={dirty:e,ctx:s}),A.$set(ce)},i(s){aa||(h(E.$$.fragment,s),h(S.$$.fragment,s),h(A.$$.fragment,s),h(Q.$$.fragment,s),h(q.$$.fragment,s),h(D.$$.fragment,s),h(K.$$.fragment,s),h(ss.$$.fragment,s),h(ls.$$.fragment,s),h(ts.$$.fragment,s),h(Ms.$$.fragment,s),h(cs.$$.fragment,s),h(ms.$$.fragment,s),h(ds.$$.fragment,s),h(js.$$.fragment,s),h(Ts.$$.fragment,s),h(Cs.$$.fragment,s),h(vs.$$.fragment,s),h(_s.$$.fragment,s),h(Ws.$$.fragment,s),h(ks.$$.fragment,s),h(Bs.$$.fragment,s),h(xs.$$.fragment,s),h(Xs.$$.fragment,s),h(Ss.$$.fragment,s),h(Ns.$$.fragment,s),h(Hs.$$.fragment,s),h(Ds.$$.fragment,s),h(Ks.$$.fragment,s),h(Os.$$.fragment,s),h(le.$$.fragment,s),h(te.$$.fragment,s),h(pe.$$.fragment,s),h(oe.$$.fragment,s),h(re.$$.fragment,s),aa=!0)},o(s){m(E.$$.fragment,s),m(S.$$.fragment,s),m(A.$$.fragment,s),m(Q.$$.fragment,s),m(q.$$.fragment,s),m(D.$$.fragment,s),m(K.$$.fragment,s),m(ss.$$.fragment,s),m(ls.$$.fragment,s),m(ts.$$.fragment,s),m(Ms.$$.fragment,s),m(cs.$$.fragment,s),m(ms.$$.fragment,s),m(ds.$$.fragment,s),m(js.$$.fragment,s),m(Ts.$$.fragment,s),m(Cs.$$.fragment,s),m(vs.$$.fragment,s),m(_s.$$.fragment,s),m(Ws.$$.fragment,s),m(ks.$$.fragment,s),m(Bs.$$.fragment,s),m(xs.$$.fragment,s),m(Xs.$$.fragment,s),m(Ss.$$.fragment,s),m(Ns.$$.fragment,s),m(Hs.$$.fragment,s),m(Ds.$$.fragment,s),m(Ks.$$.fragment,s),m(Os.$$.fragment,s),m(le.$$.fragment,s),m(te.$$.fragment,s),m(pe.$$.fragment,s),m(oe.$$.fragment,s),m(re.$$.fragment,s),aa=!1},d(s){s&&(l(T),l(_),l(u),l(f),l(_e),l(Ge),l(F),l(Ae),l(z),l(We),l(Y),l(ke),l(Be),l(N),l(xe),l(Ve),l(H),l(Re),l(L),l(Xe),l($e),l(b),l(Ee),l(P),l(Se),l(Fe),l(O),l(ze),l(Ye),l(es),l(Ne),l(Qe),l(as),l(He),l(Le),l(ns),l(qe),l(ps),l(De),l(is),l(Pe),l(os),l(Ke),l(Oe),l(rs),l(sl),l(I),l(el),l(hs),l(ll),l(al),l(ys),l(tl),l(nl),l(ws),l(pl),l(Js),l(il),l(C),l(ol),l(Us),l(Ml),l(rl),l(us),l(cl),l(fs),l(hl),l(bs),l(ml),l(Is),l(yl),l(dl),l(gs),l(wl),l(Jl),l(Zs),l(jl),l(Ul),l(Gs),l(Tl),l(As),l(ul),l(fl),l(g),l(bl),l(Il),l(V),l(Cl),l(v),l(gl),l(Vs),l(vl),l(Rs),l(Zl),l(_l),l($s),l(Gl),l(Es),l(Al),l(Wl),l(Fs),l(kl),l(zs),l(Bl),l(Ys),l(xl),l(Vl),l(Qs),l(Rl),l(Xl),l(Ls),l($l),l(qs),l(El),l(Sl),l(Ps),l(Fl),l(zl),l(Z),l(Yl),l(se),l(Nl),l(ee),l(Ql),l(Hl),l($),l(Ll),l(ae),l(ql),l(Dl),l(ne),l(Pl),l(Kl),l(ie),l(Ol),l(sa),l(Me),l(ea),l(la),l(ve)),l(U),y(E),y(S,s),y(A,s),y(Q,s),y(q,s),y(D),y(K,s),y(ss,s),y(ls,s),y(ts,s),y(Ms,s),y(cs),y(ms,s),y(ds,s),y(js),y(Ts,s),y(Cs,s),y(vs,s),y(_s,s),y(Ws,s),y(ks),y(Bs,s),y(xs),y(Xs,s),y(Ss,s),y(Ns,s),y(Hs,s),y(Ds,s),y(Ks,s),y(Os),y(le,s),y(te,s),y(pe,s),y(oe,s),y(re,s)}}}const zt={local:"video-classification",sections:[{local:"load-ucf101-dataset",title:"Load UCF101 dataset"},{local:"load-a-model-to-finetune",title:"Load a model to fine-tune"},{local:"prepare-the-datasets-for-training",title:"Prepare the datasets for training"},{local:"visualize-the-preprocessed-video-for-better-debugging",title:"Visualize the preprocessed video for better debugging "},{local:"train-the-model",title:"Train the model "},{local:"inference",title:"Inference"}],title:"Video classification"};function Yt(Ze){return Wt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Pt extends Bt{constructor(U){super(),xt(this,U,Yt,Ft,At,{})}}export{Pt as component};
