import{s as ui,o as fi,n as D}from"../chunks/scheduler.9bc65507.js";import{S as gi,i as vi,g as r,s as a,u as f,A as _i,h as n,f as o,c as s,j as c,v as g,y as h,k as d,o as t,a as m,w as v,d as _,t as $,x as b}from"../chunks/index.78c82d43.js";import{T as Es}from"../chunks/Tip.87d55b76.js";import{D as T}from"../chunks/Docstring.4e7352e2.js";import{C as co}from"../chunks/CodeBlock.73e038be.js";import{I as H}from"../chunks/IconCopyLink.bedaa44d.js";import{E as po}from"../chunks/ExampleCodeBlock.872b014d.js";function $i(M){let p,x=`Transformers Agents is an experimental API which is subject to change at any time. Results returned by the agents
can vary as the APIs or underlying models are prone to change.`;return{c(){p=r("p"),p.textContent=x},l(y){p=n(y,"P",{"data-svelte-h":!0}),h(p)!=="svelte-1fgfei3"&&(p.textContent=x)},m(y,u){m(y,p,u)},p:D,d(y){y&&o(p)}}}function bi(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function yi(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwTG9jYWxBZ2VudCUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJiaWdjb2RlJTJGc3RhcmNvZGVyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoY2hlY2twb2ludCUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudChtb2RlbCUyQyUyMHRva2VuaXplciklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, LocalAgent

checkpoint = <span class="hljs-string">&quot;bigcode/starcoder&quot;</span>
model = AutoModelForCausalLM.from_pretrained(checkpoint, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
tokenizer = AutoTokenizer.from_pretrained(checkpoint)

agent = LocalAgent(model, tokenizer)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function wi(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwTG9jYWxBZ2VudCUwQSUwQWFnZW50JTIwJTNEJTIwTG9jYWxBZ2VudC5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRnN0YXJjb2RlciUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzLiUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LocalAgent

agent = LocalAgent.from_pretrained(<span class="hljs-string">&quot;bigcode/starcoder&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, torch_dtype=torch.bfloat16)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes.&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function xi(M){let p,x=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){p=r("p"),p.innerHTML=x},l(y){p=n(y,"P",{"data-svelte-h":!0}),h(p)!=="svelte-3idp4e"&&(p.innerHTML=x)},m(y,u){m(y,p,u)},p:D,d(y){y&&o(p)}}}function Ai(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME9wZW5BaUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBPcGVuQWlBZ2VudChtb2RlbCUzRCUyMnRleHQtZGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4KSUwQWFnZW50LnJ1biglMjJJcyUyMHRoZSUyMGZvbGxvd2luZyUyMCU2MHRleHQlNjAlMjAoaW4lMjBTcGFuaXNoKSUyMHBvc2l0aXZlJTIwb3IlMjBuZWdhdGl2ZSUzRiUyMiUyQyUyMHRleHQlM0QlMjIlQzIlQTFFc3RlJTIwZXMlMjB1biUyMEFQSSUyMG11eSUyMGFncmFkYWJsZSElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> OpenAiAgent

agent = OpenAiAgent(model=<span class="hljs-string">&quot;text-davinci-003&quot;</span>, api_key=xxx)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function Ti(M){let p,x=`The openAI models are used in generation mode, so even for the <code>chat()</code> API, it’s better to use models like
<code>&quot;text-davinci-003&quot;</code> over the chat-GPT variant. Proper support for chat-GPT models will come in a next version.`;return{c(){p=r("p"),p.innerHTML=x},l(y){p=n(y,"P",{"data-svelte-h":!0}),h(p)!=="svelte-3idp4e"&&(p.innerHTML=x)},m(y,u){m(y,p,u)},p:D,d(y){y&&o(p)}}}function ki(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF6dXJlT3BlbkFpQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEF6dXJlQWlBZ2VudChkZXBsb3ltZW50X2lkJTNEJTIyRGF2aW5jaS0wMDMlMjIlMkMlMjBhcGlfa2V5JTNEeHh4JTJDJTIwcmVzb3VyY2VfbmFtZSUzRHl5eSklMEFhZ2VudC5ydW4oJTIySXMlMjB0aGUlMjBmb2xsb3dpbmclMjAlNjB0ZXh0JTYwJTIwKGluJTIwU3BhbmlzaCklMjBwb3NpdGl2ZSUyMG9yJTIwbmVnYXRpdmUlM0YlMjIlMkMlMjB0ZXh0JTNEJTIyJUMyJUExRXN0ZSUyMGVzJTIwdW4lMjBBUEklMjBtdXklMjBhZ3JhZGFibGUhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AzureOpenAiAgent

agent = AzureAiAgent(deployment_id=<span class="hljs-string">&quot;Davinci-003&quot;</span>, api_key=xxx, resource_name=yyy)
agent.run(<span class="hljs-string">&quot;Is the following \`text\` (in Spanish) positive or negative?&quot;</span>, text=<span class="hljs-string">&quot;¡Este es un API muy agradable!&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function Mi(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5jaGF0KCUyMkRyYXclMjBtZSUyMGElMjBwaWN0dXJlJTIwb2YlMjByaXZlcnMlMjBhbmQlMjBsYWtlcyUyMiklMEElMEFhZ2VudC5jaGF0KCUyMlRyYW5zZm9ybSUyMHRoZSUyMHBpY3R1cmUlMjBzbyUyMHRoYXQlMjB0aGVyZSUyMGlzJTIwYSUyMHJvY2slMjBpbiUyMHRoZXJlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.chat(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)

agent.chat(<span class="hljs-string">&quot;Transform the picture so that there is a rock in there&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function Ci(M){let p,x="Example:",y,u,w;return u=new co({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEhmQWdlbnQlMEElMEFhZ2VudCUyMCUzRCUyMEhmQWdlbnQoJTIyaHR0cHMlM0ElMkYlMkZhcGktaW5mZXJlbmNlLmh1Z2dpbmdmYWNlLmNvJTJGbW9kZWxzJTJGYmlnY29kZSUyRnN0YXJjb2RlciUyMiklMEFhZ2VudC5ydW4oJTIyRHJhdyUyMG1lJTIwYSUyMHBpY3R1cmUlMjBvZiUyMHJpdmVycyUyMGFuZCUyMGxha2VzJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> HfAgent

agent = HfAgent(<span class="hljs-string">&quot;https://api-inference.huggingface.co/models/bigcode/starcoder&quot;</span>)
agent.run(<span class="hljs-string">&quot;Draw me a picture of rivers and lakes&quot;</span>)`,wrap:!1}}),{c(){p=r("p"),p.textContent=x,y=a(),f(u.$$.fragment)},l(l){p=n(l,"P",{"data-svelte-h":!0}),h(p)!=="svelte-11lpom8"&&(p.textContent=x),y=s(l),g(u.$$.fragment,l)},m(l,A){m(l,p,A),m(l,y,A),v(u,l,A),w=!0},p:D,i(l){w||(_(u.$$.fragment,l),w=!0)},o(l){$(u.$$.fragment,l),w=!1},d(l){l&&(o(p),o(y)),b(u,l)}}}function Ii(M){let p,x,y,u,w,l,A,st,ra,ho,js="Agents & Tools",Rr,he,Sr,lt,Ls=`To learn more about agents and tools make sure to read the <a href="../transformers_agents">introductory guide</a>. This page
contains the API docs for the underlying classes.`,zr,B,ue,_r,it,na,uo,Js="Agents",Gr,dt,Us='We provide three types of agents: <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.HfAgent">HfAgent</a> uses inference endpoints for opensource models, <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.LocalAgent">LocalAgent</a> uses a model of your choice locally and <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.OpenAiAgent">OpenAiAgent</a> uses OpenAI closed models.',Vr,Y,fe,$r,mt,aa,fo,qs="HfAgent",Dr,W,pt,sa,go,Ns="Agent that uses an inference endpoint to generate code.",la,ge,Br,F,ve,br,ct,ia,vo,Zs="LocalAgent",Yr,j,ht,da,_o,Ws="Agent that uses a local model and tokenizer to generate code.",ma,_e,pa,R,ut,ca,$o,Rs="Convenience method to build a <code>LocalAgent</code> from a pretrained checkpoint.",ha,$e,Fr,Q,be,yr,ft,ua,bo,Ss="OpenAiAgent",Qr,L,gt,fa,yo,zs="Agent that uses the openai API to generate code.",ga,ye,va,we,Xr,X,xe,wr,vt,_a,wo,Gs="AzureOpenAiAgent",Or,J,_t,$a,xo,Vs=`Agent that uses Azure OpenAI to generate code. See the <a href="https://learn.microsoft.com/en-us/azure/cognitive-services/openai/" rel="nofollow">official
documentation</a> to learn how to deploy an openAI
model on Azure`,ba,Ae,ya,Te,Kr,O,ke,xr,$t,wa,Ao,Ds="Agent",en,P,bt,xa,To,Bs="Base class for all agents which contains the main API methods.",Aa,S,yt,Ta,ko,Ys="Sends a new request to the agent in a chat. Will use the previous ones in its history.",ka,Me,Ma,z,wt,Ca,Mo,Fs="Sends a request to the agent.",Ia,Ce,Ha,Ie,xt,Pa,Co,Qs='Clears the history of prior calls to <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Agent.chat">chat()</a>.',tn,K,He,Ar,At,Ea,Io,Xs="Tools",on,ee,Pe,Tr,Tt,ja,Ho,Os="load_tool",rn,te,kt,La,Po,Ks="Main function to quickly load a tool, be it on the Hub or in the Transformers library.",nn,oe,Ee,kr,Mt,Ja,Eo,el="Tool",an,k,Ct,Ua,jo,tl=`A base class for the functions used by the agent. Subclass this and implement the <code>__call__</code> method as well as the
following class attributes:`,qa,Lo,ol=`<li><strong>description</strong> (<code>str</code>) — A short description of what your tool does, the inputs it expects and the output(s) it
will return. For instance ‘This is a tool that downloads a file from a <code>url</code>. It takes the <code>url</code> as input, and
returns the text contained in the file’.</li> <li><strong>name</strong> (<code>str</code>) — A performative name that will be used for your tool in the prompt to the agent. For instance
<code>&quot;text-classifier&quot;</code> or <code>&quot;image_generator&quot;</code>.</li> <li><strong>inputs</strong> (<code>List[str]</code>) — The list of modalities expected for the inputs (in the same order as in the call).
Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code> or to make a
nice space from your tool.</li> <li><strong>outputs</strong> (<code>List[str]</code>) — The list of modalities returned but the tool (in the same order as the return of the
call method). Modalitiies should be <code>&quot;text&quot;</code>, <code>&quot;image&quot;</code> or <code>&quot;audio&quot;</code>. This is only used by <code>launch_gradio_demo</code>
or to make a nice space from your tool.</li>`,Na,Jo,rl=`You can also override the method <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool.setup">setup()</a> if your tool as an expensive operation to perform before being
usable (such as loading a model). <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool.setup">setup()</a> will be called the first time you use your tool, but not at
instantiation.`,Za,je,It,Wa,Uo,nl='Creates a <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a> from a gradio tool.',Ra,Le,Ht,Sa,qo,al="Loads a tool defined on the Hub.",za,Je,Pt,Ga,No,sl="Upload the tool to the Hub.",Va,Z,Et,Da,Zo,ll=`Saves the relevant code files for your tool so it can be pushed to the Hub. This will copy the code of your
tool in <code>output_dir</code> as well as autogenerate:`,Ba,Wo,il=`<li>a config file named <code>tool_config.json</code></li> <li>an <code>app.py</code> file so that your tool can be converted to a space</li> <li>a <code>requirements.txt</code> containing the names of the module used by your tool (as detected when inspecting its
code)</li>`,Ya,Ro,dl="You should only use this method to save tools that are defined in a separate module (not <code>__main__</code>).",Fa,Ue,jt,Qa,So,ml=`Overwrite this method here for any operation that is expensive and needs to be executed before you start using
your tool. Such as loading a big model.`,sn,re,qe,Mr,Lt,Xa,zo,pl="PipelineTool",ln,C,Jt,Oa,Go,cl=`A <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a> tailored towards Transformer models. On top of the class attributes of the base class <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a>, you will
need to specify:`,Ka,Vo,hl=`<li><strong>model_class</strong> (<code>type</code>) — The class to use to load the model in this tool.</li> <li><strong>default_checkpoint</strong> (<code>str</code>) — The default checkpoint that should be used when the user doesn’t specify one.</li> <li><strong>pre_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
pre-processor</li> <li><strong>post_processor_class</strong> (<code>type</code>, <em>optional</em>, defaults to <a href="/docs/transformers/v4.34.0/en/model_doc/auto#transformers.AutoProcessor">AutoProcessor</a>) — The class to use to load the
post-processor (when different from the pre-processor).</li>`,es,Ne,Ut,ts,Do,ul="Uses the <code>post_processor</code> to decode the model output.",os,Ze,qt,rs,Bo,fl="Uses the <code>pre_processor</code> to prepare the inputs for the <code>model</code>.",ns,We,Nt,as,Yo,gl="Sends the inputs through the <code>model</code>.",ss,Re,Zt,ls,Fo,vl="Instantiates the <code>pre_processor</code>, <code>model</code> and <code>post_processor</code> if necessary.",dn,ne,Se,Cr,Wt,is,Qo,_l="RemoteTool",mn,U,Rt,ds,Xo,$l='A <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a> that will make requests to an inference endpoint.',ms,ze,St,ps,Oo,bl=`You can override this method in your custom class of <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.RemoteTool">RemoteTool</a> to apply some custom post-processing of the
outputs of the endpoint.`,cs,G,zt,hs,Ko,yl=`Prepare the inputs received for the HTTP client sending data to the endpoint. Positional arguments will be
matched with the signature of the <code>tool_class</code> if it was provided at instantation. Images will be encoded into
bytes.`,us,er,wl='You can override this method in your custom class of <a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.RemoteTool">RemoteTool</a>.',pn,ae,Ge,Ir,Gt,fs,tr,xl="launch_gradio_demo",cn,se,Vt,gs,or,Al=`Launches a gradio demo for a tool. The corresponding tool class needs to properly implement the class attributes
<code>inputs</code> and <code>outputs</code>.`,hn,le,Ve,Hr,Dt,vs,rr,Tl="Agent Types",un,Bt,kl=`Agents can handle any type of object in-between tools; tools, being completely multimodal, can accept and return
text, image, audio, video, among other types. In order to increase compatibility between tools, as well as to
correctly render these returns in ipython (jupyter, colab, ipython notebooks, …), we implement wrapper classes
around these types.`,fn,Yt,Ml=`The wrapped objects should continue behaving as initially; a text object should still behave as a string, an image
object should still behave as a <code>PIL.Image</code>.`,gn,Ft,Cl="These types have three specific purposes:",vn,Qt,Il=`<li>Calling <code>to_raw</code> on the type should return the underlying object</li> <li>Calling <code>to_string</code> on the type should return the object as a string: that can be the string in case of an <code>AgentText</code>
but will be the path of the serialized version of the object in other instances</li> <li>Displaying it in an ipython kernel should display the object correctly</li>`,_n,ie,De,Pr,Xt,_s,nr,Hl="AgentText",$n,de,Ot,$s,ar,Pl="Text type returned by the agent. Behaves as a string.",bn,me,Be,Er,Kt,bs,sr,El="AgentImage",yn,q,eo,ys,lr,jl="Image type returned by the agent. Behaves as a PIL.Image.",ws,Ye,to,xs,ir,Ll="Returns the “raw” version of that object. In the case of an AgentImage, it is a PIL.Image.",As,Fe,oo,Ts,dr,Jl=`Returns the stringified version of that object. In the case of an AgentImage, it is a path to the serialized
version of the image.`,wn,pe,Qe,jr,ro,ks,mr,Ul="AgentAudio",xn,N,no,Ms,pr,ql="Audio type returned by the agent.",Cs,Xe,ao,Is,cr,Nl="Returns the “raw” version of that object. It is a <code>torch.Tensor</code> object.",Hs,Oe,so,Ps,hr,Zl=`Returns the stringified version of that object. In the case of an AgentAudio, it is a path to the serialized
version of the audio.`,An,Lr,Tn;return st=new H({}),he=new Es({props:{warning:!0,$$slots:{default:[$i]},$$scope:{ctx:M}}}),it=new H({}),mt=new H({}),pt=new T({props:{name:"class transformers.HfAgent",anchor:"transformers.HfAgent",parameters:[{name:"url_endpoint",val:""},{name:"token",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.HfAgent.url_endpoint",description:`<strong>url_endpoint</strong> (<code>str</code>) &#x2014;
The name of the url endpoint to use.`,name:"url_endpoint"},{anchor:"transformers.HfAgent.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.HfAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.HfAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.HfAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L588"}}),ge=new po({props:{anchor:"transformers.HfAgent.example",$$slots:{default:[bi]},$$scope:{ctx:M}}}),ct=new H({}),ht=new T({props:{name:"class transformers.LocalAgent",anchor:"transformers.LocalAgent",parameters:[{name:"model",val:""},{name:"tokenizer",val:""},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.LocalAgent.model",description:`<strong>model</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>) &#x2014;
The model to use for the agent.`,name:"model"},{anchor:"transformers.LocalAgent.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a>) &#x2014;
The tokenizer to use for the agent.`,name:"tokenizer"},{anchor:"transformers.LocalAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.LocalAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.LocalAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L659"}}),_e=new po({props:{anchor:"transformers.LocalAgent.example",$$slots:{default:[yi]},$$scope:{ctx:M}}}),ut=new T({props:{name:"from_pretrained",anchor:"transformers.LocalAgent.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LocalAgent.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The name of a repo on the Hub or a local path to a folder containing both model and tokenizer.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.LocalAgent.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Keyword arguments passed along to <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L704"}}),$e=new po({props:{anchor:"transformers.LocalAgent.from_pretrained.example",$$slots:{default:[wi]},$$scope:{ctx:M}}}),ft=new H({}),gt=new T({props:{name:"class transformers.OpenAiAgent",anchor:"transformers.OpenAiAgent",parameters:[{name:"model",val:" = 'text-davinci-003'"},{name:"api_key",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.OpenAiAgent.model",description:`<strong>model</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;text-davinci-003&quot;</code>) &#x2014;
The name of the OpenAI model to use.`,name:"model"},{anchor:"transformers.OpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.OpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.OpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.OpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L364"}}),ye=new Es({props:{warning:!0,$$slots:{default:[xi]},$$scope:{ctx:M}}}),we=new po({props:{anchor:"transformers.OpenAiAgent.example",$$slots:{default:[Ai]},$$scope:{ctx:M}}}),vt=new H({}),_t=new T({props:{name:"class transformers.AzureOpenAiAgent",anchor:"transformers.AzureOpenAiAgent",parameters:[{name:"deployment_id",val:""},{name:"api_key",val:" = None"},{name:"resource_name",val:" = None"},{name:"api_version",val:" = '2022-12-01'"},{name:"is_chat_model",val:" = None"},{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.AzureOpenAiAgent.deployment_id",description:`<strong>deployment_id</strong> (<code>str</code>) &#x2014;
The name of the deployed Azure openAI model to use.`,name:"deployment_id"},{anchor:"transformers.AzureOpenAiAgent.api_key",description:`<strong>api_key</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The API key to use. If unset, will look for the environment variable <code>&quot;AZURE_OPENAI_API_KEY&quot;</code>.`,name:"api_key"},{anchor:"transformers.AzureOpenAiAgent.resource_name",description:`<strong>resource_name</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of your Azure OpenAI Resource. If unset, will look for the environment variable
<code>&quot;AZURE_OPENAI_RESOURCE_NAME&quot;</code>.`,name:"resource_name"},{anchor:"transformers.AzureOpenAiAgent.api_version",description:`<strong>api_version</strong> (<code>str</code>, <em>optional</em>, default to <code>&quot;2022-12-01&quot;</code>) &#x2014;
The API version to use for this agent.`,name:"api_version"},{anchor:"transformers.AzureOpenAiAgent.is_chat_mode",description:`<strong>is_chat_mode</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether you are using a completion model or a chat model (see note above, chat models won&#x2019;t be as
efficient). Will default to <code>gpt</code> being in the <code>deployment_id</code> or not.`,name:"is_chat_mode"},{anchor:"transformers.AzureOpenAiAgent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.AzureOpenAiAgent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L462"}}),Ae=new Es({props:{warning:!0,$$slots:{default:[Ti]},$$scope:{ctx:M}}}),Te=new po({props:{anchor:"transformers.AzureOpenAiAgent.example",$$slots:{default:[ki]},$$scope:{ctx:M}}}),$t=new H({}),bt=new T({props:{name:"class transformers.Agent",anchor:"transformers.Agent",parameters:[{name:"chat_prompt_template",val:" = None"},{name:"run_prompt_template",val:" = None"},{name:"additional_tools",val:" = None"}],parametersDescription:[{anchor:"transformers.Agent.chat_prompt_template",description:`<strong>chat_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>chat</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>chat_prompt_template.txt</code> in this repo in this case.`,name:"chat_prompt_template"},{anchor:"transformers.Agent.run_prompt_template",description:`<strong>run_prompt_template</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Pass along your own prompt if you want to override the default template for the <code>run</code> method. Can be the
actual prompt template or a repo ID (on the Hugging Face Hub). The prompt should be in a file named
<code>run_prompt_template.txt</code> in this repo in this case.`,name:"run_prompt_template"},{anchor:"transformers.Agent.additional_tools",description:`<strong>additional_tools</strong> (<a href="/docs/transformers/v4.34.0/en/main_classes/agent#transformers.Tool">Tool</a>, list of tools or dictionary with tool values, <em>optional</em>) &#x2014;
Any additional tools to include on top of the default ones. If you pass along a tool with the same name as
one of the default tools, that default tool will be overridden.`,name:"additional_tools"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L196"}}),yt=new T({props:{name:"chat",anchor:"transformers.Agent.chat",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.chat.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.chat.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.chat.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.chat.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L268"}}),Me=new po({props:{anchor:"transformers.Agent.chat.example",$$slots:{default:[Mi]},$$scope:{ctx:M}}}),wt=new T({props:{name:"run",anchor:"transformers.Agent.run",parameters:[{name:"task",val:""},{name:"return_code",val:" = False"},{name:"remote",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Agent.run.task",description:"<strong>task</strong> (<code>str</code>) &#x2014; The task to perform",name:"task"},{anchor:"transformers.Agent.run.return_code",description:`<strong>return_code</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to just return code and not evaluate it.`,name:"return_code"},{anchor:"transformers.Agent.run.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use remote tools (inference endpoints) instead of local ones.`,name:"remote"},{anchor:"transformers.Agent.run.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any keyword argument to send to the agent when evaluating the code.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L318"}}),Ce=new po({props:{anchor:"transformers.Agent.run.example",$$slots:{default:[Ci]},$$scope:{ctx:M}}}),xt=new T({props:{name:"prepare_for_new_chat",anchor:"transformers.Agent.prepare_for_new_chat",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agents.py#L310"}}),At=new H({}),Tt=new H({}),kt=new T({props:{name:"transformers.load_tool",anchor:"transformers.load_tool",parameters:[{name:"task_or_repo_id",val:""},{name:"model_repo_id",val:" = None"},{name:"remote",val:" = False"},{name:"token",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.load_tool.task_or_repo_id",description:`<strong>task_or_repo_id</strong> (<code>str</code>) &#x2014;
The task for which to load the tool or a repo ID of a tool on the Hub. Tasks implemented in Transformers
are:</p>
<ul>
<li><code>&quot;document-question-answering&quot;</code></li>
<li><code>&quot;image-captioning&quot;</code></li>
<li><code>&quot;image-question-answering&quot;</code></li>
<li><code>&quot;image-segmentation&quot;</code></li>
<li><code>&quot;speech-to-text&quot;</code></li>
<li><code>&quot;summarization&quot;</code></li>
<li><code>&quot;text-classification&quot;</code></li>
<li><code>&quot;text-question-answering&quot;</code></li>
<li><code>&quot;text-to-speech&quot;</code></li>
<li><code>&quot;translation&quot;</code></li>
</ul>`,name:"task_or_repo_id"},{anchor:"transformers.load_tool.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Use this argument to use a different model than the default one for the tool you selected.`,name:"model_repo_id"},{anchor:"transformers.load_tool.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.load_tool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.load_tool.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the others
will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L639"}}),Mt=new H({}),Ct=new T({props:{name:"class transformers.Tool",anchor:"transformers.Tool",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L81"}}),It=new T({props:{name:"from_gradio",anchor:"transformers.Tool.from_gradio",parameters:[{name:"gradio_tool",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L330"}}),Ht=new T({props:{name:"from_hub",anchor:"transformers.Tool.from_hub",parameters:[{name:"repo_id",val:": str"},{name:"model_repo_id",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"remote",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Tool.from_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repo on the Hub where your tool is defined.`,name:"repo_id"},{anchor:"transformers.Tool.from_hub.model_repo_id",description:`<strong>model_repo_id</strong> (<code>str</code>, <em>optional</em>) &#x2014;
If your tool uses a model and you want to use a different model than the default, you can pass a second
repo ID or an endpoint url to this argument.`,name:"model_repo_id"},{anchor:"transformers.Tool.from_hub.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to identify you on hf.co. If unset, will use the token generated when running
<code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.from_hub.remote",description:`<strong>remote</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use your tool by downloading the model or (if it is available) with an inference endpoint.`,name:"remote"},{anchor:"transformers.Tool.from_hub.kwargs",description:`<strong>kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Additional keyword arguments that will be split in two: all arguments relevant to the Hub (such as
<code>cache_dir</code>, <code>revision</code>, <code>subfolder</code>) will be used when downloading the files for your tool, and the
others will be passed along to its init.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L176"}}),Pt=new T({props:{name:"push_to_hub",anchor:"transformers.Tool.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"commit_message",val:": str = 'Upload tool'"},{name:"private",val:": typing.Optional[bool] = None"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"create_pr",val:": bool = False"}],parametersDescription:[{anchor:"transformers.Tool.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your tool to. It should contain your organization name when
pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.Tool.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;Upload tool&quot;</code>) &#x2014;
Message to commit while pushing.`,name:"commit_message"},{anchor:"transformers.Tool.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.Tool.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.Tool.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L286"}}),Et=new T({props:{name:"save",anchor:"transformers.Tool.save",parameters:[{name:"output_dir",val:""}],parametersDescription:[{anchor:"transformers.Tool.save.output_dir",description:"<strong>output_dir</strong> (<code>str</code>) &#x2014; The folder in which you want to save your tool.",name:"output_dir"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L122"}}),jt=new T({props:{name:"setup",anchor:"transformers.Tool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L115"}}),Lt=new H({}),Jt=new T({props:{name:"class transformers.PipelineTool",anchor:"transformers.PipelineTool",parameters:[{name:"model",val:" = None"},{name:"pre_processor",val:" = None"},{name:"post_processor",val:" = None"},{name:"device",val:" = None"},{name:"device_map",val:" = None"},{name:"model_kwargs",val:" = None"},{name:"token",val:" = None"},{name:"**hub_kwargs",val:""}],parametersDescription:[{anchor:"transformers.PipelineTool.model",description:`<strong>model</strong> (<code>str</code> or <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the model, or the instantiated model. If unset, will default to the
value of the class attribute <code>default_checkpoint</code>.`,name:"model"},{anchor:"transformers.PipelineTool.pre_processor",description:`<strong>pre_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the pre-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the value of <code>model</code> if
unset.`,name:"pre_processor"},{anchor:"transformers.PipelineTool.post_processor",description:`<strong>post_processor</strong> (<code>str</code> or <code>Any</code>, <em>optional</em>) &#x2014;
The name of the checkpoint to use for the post-processor, or the instantiated pre-processor (can be a
tokenizer, an image processor, a feature extractor or a processor). Will default to the <code>pre_processor</code> if
unset.`,name:"post_processor"},{anchor:"transformers.PipelineTool.device",description:`<strong>device</strong> (<code>int</code>, <code>str</code> or <code>torch.device</code>, <em>optional</em>) &#x2014;
The device on which to execute the model. Will default to any accelerator available (GPU, MPS etc&#x2026;), the
CPU otherwise.`,name:"device"},{anchor:"transformers.PipelineTool.device_map",description:`<strong>device_map</strong> (<code>str</code> or <code>dict</code>, <em>optional</em>) &#x2014;
If passed along, will be used to instantiate the model.`,name:"device_map"},{anchor:"transformers.PipelineTool.model_kwargs",description:`<strong>model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Any keyword argument to send to the model instantiation.`,name:"model_kwargs"},{anchor:"transformers.PipelineTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.PipelineTool.hub_kwargs",description:`<strong>hub_kwargs</strong> (additional keyword arguments, <em>optional</em>) &#x2014;
Any additional keyword argument to send to the methods that will load the data from the Hub.`,name:"hub_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L433"}}),Ut=new T({props:{name:"decode",anchor:"transformers.PipelineTool.decode",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L552"}}),qt=new T({props:{name:"encode",anchor:"transformers.PipelineTool.encode",parameters:[{name:"raw_inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L539"}}),Nt=new T({props:{name:"forward",anchor:"transformers.PipelineTool.forward",parameters:[{name:"inputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L545"}}),Zt=new T({props:{name:"setup",anchor:"transformers.PipelineTool.setup",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L513"}}),Wt=new H({}),Rt=new T({props:{name:"class transformers.RemoteTool",anchor:"transformers.RemoteTool",parameters:[{name:"endpoint_url",val:" = None"},{name:"token",val:" = None"},{name:"tool_class",val:" = None"}],parametersDescription:[{anchor:"transformers.RemoteTool.endpoint_url",description:`<strong>endpoint_url</strong> (<code>str</code>) &#x2014;
The url of the endpoint to use.`,name:"endpoint_url"},{anchor:"transformers.RemoteTool.token",description:`<strong>token</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If unset, will use the token generated when
running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.RemoteTool.tool_class",description:`<strong>tool_class</strong> (<code>type</code>, <em>optional</em>) &#x2014;
The corresponding <code>tool_class</code> if this is a remote version of an existing tool. Will help determine when
the output should be converted to another type (like images).`,name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L346"}}),St=new T({props:{name:"extract_outputs",anchor:"transformers.RemoteTool.extract_outputs",parameters:[{name:"outputs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L409"}}),zt=new T({props:{name:"prepare_inputs",anchor:"transformers.RemoteTool.prepare_inputs",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L366"}}),Gt=new H({}),Vt=new T({props:{name:"transformers.launch_gradio_demo",anchor:"transformers.launch_gradio_demo",parameters:[{name:"tool_class",val:": Tool"}],parametersDescription:[{anchor:"transformers.launch_gradio_demo.tool_class",description:"<strong>tool_class</strong> (<code>type</code>) &#x2014; The class of the tool for which to launch the demo.",name:"tool_class"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/base.py#L573"}}),Dt=new H({}),Xt=new H({}),Ot=new T({props:{name:"class transformers.tools.agent_types.AgentText",anchor:"transformers.tools.agent_types.AgentText",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L71"}}),Kt=new H({}),eo=new T({props:{name:"class transformers.tools.agent_types.AgentImage",anchor:"transformers.tools.agent_types.AgentImage",parameters:[{name:"value",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L83"}}),to=new T({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentImage.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L115"}}),oo=new T({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentImage.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L126"}}),ro=new H({}),no=new T({props:{name:"class transformers.tools.agent_types.AgentAudio",anchor:"transformers.tools.agent_types.AgentAudio",parameters:[{name:"value",val:""},{name:"samplerate",val:" = 16000"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L155"}}),ao=new T({props:{name:"to_raw",anchor:"transformers.tools.agent_types.AgentAudio.to_raw",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L186"}}),so=new T({props:{name:"to_string",anchor:"transformers.tools.agent_types.AgentAudio.to_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/tools/agent_types.py#L198"}}),{c(){p=r("meta"),x=a(),y=r("p"),u=a(),w=r("h1"),l=r("a"),A=r("span"),f(st.$$.fragment),ra=a(),ho=r("span"),ho.textContent=js,Rr=a(),f(he.$$.fragment),Sr=a(),lt=r("p"),lt.innerHTML=Ls,zr=a(),B=r("h2"),ue=r("a"),_r=r("span"),f(it.$$.fragment),na=a(),uo=r("span"),uo.textContent=Js,Gr=a(),dt=r("p"),dt.innerHTML=Us,Vr=a(),Y=r("h3"),fe=r("a"),$r=r("span"),f(mt.$$.fragment),aa=a(),fo=r("span"),fo.textContent=qs,Dr=a(),W=r("div"),f(pt.$$.fragment),sa=a(),go=r("p"),go.textContent=Ns,la=a(),f(ge.$$.fragment),Br=a(),F=r("h3"),ve=r("a"),br=r("span"),f(ct.$$.fragment),ia=a(),vo=r("span"),vo.textContent=Zs,Yr=a(),j=r("div"),f(ht.$$.fragment),da=a(),_o=r("p"),_o.textContent=Ws,ma=a(),f(_e.$$.fragment),pa=a(),R=r("div"),f(ut.$$.fragment),ca=a(),$o=r("p"),$o.innerHTML=Rs,ha=a(),f($e.$$.fragment),Fr=a(),Q=r("h3"),be=r("a"),yr=r("span"),f(ft.$$.fragment),ua=a(),bo=r("span"),bo.textContent=Ss,Qr=a(),L=r("div"),f(gt.$$.fragment),fa=a(),yo=r("p"),yo.textContent=zs,ga=a(),f(ye.$$.fragment),va=a(),f(we.$$.fragment),Xr=a(),X=r("h3"),xe=r("a"),wr=r("span"),f(vt.$$.fragment),_a=a(),wo=r("span"),wo.textContent=Gs,Or=a(),J=r("div"),f(_t.$$.fragment),$a=a(),xo=r("p"),xo.innerHTML=Vs,ba=a(),f(Ae.$$.fragment),ya=a(),f(Te.$$.fragment),Kr=a(),O=r("h3"),ke=r("a"),xr=r("span"),f($t.$$.fragment),wa=a(),Ao=r("span"),Ao.textContent=Ds,en=a(),P=r("div"),f(bt.$$.fragment),xa=a(),To=r("p"),To.textContent=Bs,Aa=a(),S=r("div"),f(yt.$$.fragment),Ta=a(),ko=r("p"),ko.textContent=Ys,ka=a(),f(Me.$$.fragment),Ma=a(),z=r("div"),f(wt.$$.fragment),Ca=a(),Mo=r("p"),Mo.textContent=Fs,Ia=a(),f(Ce.$$.fragment),Ha=a(),Ie=r("div"),f(xt.$$.fragment),Pa=a(),Co=r("p"),Co.innerHTML=Qs,tn=a(),K=r("h2"),He=r("a"),Ar=r("span"),f(At.$$.fragment),Ea=a(),Io=r("span"),Io.textContent=Xs,on=a(),ee=r("h3"),Pe=r("a"),Tr=r("span"),f(Tt.$$.fragment),ja=a(),Ho=r("span"),Ho.textContent=Os,rn=a(),te=r("div"),f(kt.$$.fragment),La=a(),Po=r("p"),Po.textContent=Ks,nn=a(),oe=r("h3"),Ee=r("a"),kr=r("span"),f(Mt.$$.fragment),Ja=a(),Eo=r("span"),Eo.textContent=el,an=a(),k=r("div"),f(Ct.$$.fragment),Ua=a(),jo=r("p"),jo.innerHTML=tl,qa=a(),Lo=r("ul"),Lo.innerHTML=ol,Na=a(),Jo=r("p"),Jo.innerHTML=rl,Za=a(),je=r("div"),f(It.$$.fragment),Wa=a(),Uo=r("p"),Uo.innerHTML=nl,Ra=a(),Le=r("div"),f(Ht.$$.fragment),Sa=a(),qo=r("p"),qo.textContent=al,za=a(),Je=r("div"),f(Pt.$$.fragment),Ga=a(),No=r("p"),No.textContent=sl,Va=a(),Z=r("div"),f(Et.$$.fragment),Da=a(),Zo=r("p"),Zo.innerHTML=ll,Ba=a(),Wo=r("ul"),Wo.innerHTML=il,Ya=a(),Ro=r("p"),Ro.innerHTML=dl,Fa=a(),Ue=r("div"),f(jt.$$.fragment),Qa=a(),So=r("p"),So.textContent=ml,sn=a(),re=r("h3"),qe=r("a"),Mr=r("span"),f(Lt.$$.fragment),Xa=a(),zo=r("span"),zo.textContent=pl,ln=a(),C=r("div"),f(Jt.$$.fragment),Oa=a(),Go=r("p"),Go.innerHTML=cl,Ka=a(),Vo=r("ul"),Vo.innerHTML=hl,es=a(),Ne=r("div"),f(Ut.$$.fragment),ts=a(),Do=r("p"),Do.innerHTML=ul,os=a(),Ze=r("div"),f(qt.$$.fragment),rs=a(),Bo=r("p"),Bo.innerHTML=fl,ns=a(),We=r("div"),f(Nt.$$.fragment),as=a(),Yo=r("p"),Yo.innerHTML=gl,ss=a(),Re=r("div"),f(Zt.$$.fragment),ls=a(),Fo=r("p"),Fo.innerHTML=vl,dn=a(),ne=r("h3"),Se=r("a"),Cr=r("span"),f(Wt.$$.fragment),is=a(),Qo=r("span"),Qo.textContent=_l,mn=a(),U=r("div"),f(Rt.$$.fragment),ds=a(),Xo=r("p"),Xo.innerHTML=$l,ms=a(),ze=r("div"),f(St.$$.fragment),ps=a(),Oo=r("p"),Oo.innerHTML=bl,cs=a(),G=r("div"),f(zt.$$.fragment),hs=a(),Ko=r("p"),Ko.innerHTML=yl,us=a(),er=r("p"),er.innerHTML=wl,pn=a(),ae=r("h3"),Ge=r("a"),Ir=r("span"),f(Gt.$$.fragment),fs=a(),tr=r("span"),tr.textContent=xl,cn=a(),se=r("div"),f(Vt.$$.fragment),gs=a(),or=r("p"),or.innerHTML=Al,hn=a(),le=r("h2"),Ve=r("a"),Hr=r("span"),f(Dt.$$.fragment),vs=a(),rr=r("span"),rr.textContent=Tl,un=a(),Bt=r("p"),Bt.textContent=kl,fn=a(),Yt=r("p"),Yt.innerHTML=Ml,gn=a(),Ft=r("p"),Ft.textContent=Cl,vn=a(),Qt=r("ul"),Qt.innerHTML=Il,_n=a(),ie=r("h3"),De=r("a"),Pr=r("span"),f(Xt.$$.fragment),_s=a(),nr=r("span"),nr.textContent=Hl,$n=a(),de=r("div"),f(Ot.$$.fragment),$s=a(),ar=r("p"),ar.textContent=Pl,bn=a(),me=r("h3"),Be=r("a"),Er=r("span"),f(Kt.$$.fragment),bs=a(),sr=r("span"),sr.textContent=El,yn=a(),q=r("div"),f(eo.$$.fragment),ys=a(),lr=r("p"),lr.textContent=jl,ws=a(),Ye=r("div"),f(to.$$.fragment),xs=a(),ir=r("p"),ir.textContent=Ll,As=a(),Fe=r("div"),f(oo.$$.fragment),Ts=a(),dr=r("p"),dr.textContent=Jl,wn=a(),pe=r("h3"),Qe=r("a"),jr=r("span"),f(ro.$$.fragment),ks=a(),mr=r("span"),mr.textContent=Ul,xn=a(),N=r("div"),f(no.$$.fragment),Ms=a(),pr=r("p"),pr.textContent=ql,Cs=a(),Xe=r("div"),f(ao.$$.fragment),Is=a(),cr=r("p"),cr.innerHTML=Nl,Hs=a(),Oe=r("div"),f(so.$$.fragment),Ps=a(),hr=r("p"),hr.textContent=Zl,An=a(),Lr=r("p"),this.h()},l(e){const i=_i("svelte-1phssyn",document.head);p=n(i,"META",{name:!0,content:!0}),i.forEach(o),x=s(e),y=n(e,"P",{}),c(y).forEach(o),u=s(e),w=n(e,"H1",{class:!0});var lo=c(w);l=n(lo,"A",{id:!0,class:!0,href:!0});var Jr=c(l);A=n(Jr,"SPAN",{});var Ur=c(A);g(st.$$.fragment,Ur),Ur.forEach(o),Jr.forEach(o),ra=s(lo),ho=n(lo,"SPAN",{"data-svelte-h":!0}),h(ho)!=="svelte-1e8jebp"&&(ho.textContent=js),lo.forEach(o),Rr=s(e),g(he.$$.fragment,e),Sr=s(e),lt=n(e,"P",{"data-svelte-h":!0}),h(lt)!=="svelte-7mj07q"&&(lt.innerHTML=Ls),zr=s(e),B=n(e,"H2",{class:!0});var io=c(B);ue=n(io,"A",{id:!0,class:!0,href:!0});var qr=c(ue);_r=n(qr,"SPAN",{});var Nr=c(_r);g(it.$$.fragment,Nr),Nr.forEach(o),qr.forEach(o),na=s(io),uo=n(io,"SPAN",{"data-svelte-h":!0}),h(uo)!=="svelte-mjfvi7"&&(uo.textContent=Js),io.forEach(o),Gr=s(e),dt=n(e,"P",{"data-svelte-h":!0}),h(dt)!=="svelte-1iyxwxq"&&(dt.innerHTML=Us),Vr=s(e),Y=n(e,"H3",{class:!0});var mo=c(Y);fe=n(mo,"A",{id:!0,class:!0,href:!0});var Zr=c(fe);$r=n(Zr,"SPAN",{});var Wr=c($r);g(mt.$$.fragment,Wr),Wr.forEach(o),Zr.forEach(o),aa=s(mo),fo=n(mo,"SPAN",{"data-svelte-h":!0}),h(fo)!=="svelte-d2ikws"&&(fo.textContent=qs),mo.forEach(o),Dr=s(e),W=n(e,"DIV",{class:!0});var ce=c(W);g(pt.$$.fragment,ce),sa=s(ce),go=n(ce,"P",{"data-svelte-h":!0}),h(go)!=="svelte-1uej11q"&&(go.textContent=Ns),la=s(ce),g(ge.$$.fragment,ce),ce.forEach(o),Br=s(e),F=n(e,"H3",{class:!0});var kn=c(F);ve=n(kn,"A",{id:!0,class:!0,href:!0});var Wl=c(ve);br=n(Wl,"SPAN",{});var Rl=c(br);g(ct.$$.fragment,Rl),Rl.forEach(o),Wl.forEach(o),ia=s(kn),vo=n(kn,"SPAN",{"data-svelte-h":!0}),h(vo)!=="svelte-ufnwr9"&&(vo.textContent=Zs),kn.forEach(o),Yr=s(e),j=n(e,"DIV",{class:!0});var Ke=c(j);g(ht.$$.fragment,Ke),da=s(Ke),_o=n(Ke,"P",{"data-svelte-h":!0}),h(_o)!=="svelte-1q3iegi"&&(_o.textContent=Ws),ma=s(Ke),g(_e.$$.fragment,Ke),pa=s(Ke),R=n(Ke,"DIV",{class:!0});var ur=c(R);g(ut.$$.fragment,ur),ca=s(ur),$o=n(ur,"P",{"data-svelte-h":!0}),h($o)!=="svelte-1qh3hl2"&&($o.innerHTML=Rs),ha=s(ur),g($e.$$.fragment,ur),ur.forEach(o),Ke.forEach(o),Fr=s(e),Q=n(e,"H3",{class:!0});var Mn=c(Q);be=n(Mn,"A",{id:!0,class:!0,href:!0});var Sl=c(be);yr=n(Sl,"SPAN",{});var zl=c(yr);g(ft.$$.fragment,zl),zl.forEach(o),Sl.forEach(o),ua=s(Mn),bo=n(Mn,"SPAN",{"data-svelte-h":!0}),h(bo)!=="svelte-vce5cw"&&(bo.textContent=Ss),Mn.forEach(o),Qr=s(e),L=n(e,"DIV",{class:!0});var et=c(L);g(gt.$$.fragment,et),fa=s(et),yo=n(et,"P",{"data-svelte-h":!0}),h(yo)!=="svelte-182hy5g"&&(yo.textContent=zs),ga=s(et),g(ye.$$.fragment,et),va=s(et),g(we.$$.fragment,et),et.forEach(o),Xr=s(e),X=n(e,"H3",{class:!0});var Cn=c(X);xe=n(Cn,"A",{id:!0,class:!0,href:!0});var Gl=c(xe);wr=n(Gl,"SPAN",{});var Vl=c(wr);g(vt.$$.fragment,Vl),Vl.forEach(o),Gl.forEach(o),_a=s(Cn),wo=n(Cn,"SPAN",{"data-svelte-h":!0}),h(wo)!=="svelte-i4mnpf"&&(wo.textContent=Gs),Cn.forEach(o),Or=s(e),J=n(e,"DIV",{class:!0});var tt=c(J);g(_t.$$.fragment,tt),$a=s(tt),xo=n(tt,"P",{"data-svelte-h":!0}),h(xo)!=="svelte-1eoncpw"&&(xo.innerHTML=Vs),ba=s(tt),g(Ae.$$.fragment,tt),ya=s(tt),g(Te.$$.fragment,tt),tt.forEach(o),Kr=s(e),O=n(e,"H3",{class:!0});var In=c(O);ke=n(In,"A",{id:!0,class:!0,href:!0});var Dl=c(ke);xr=n(Dl,"SPAN",{});var Bl=c(xr);g($t.$$.fragment,Bl),Bl.forEach(o),Dl.forEach(o),wa=s(In),Ao=n(In,"SPAN",{"data-svelte-h":!0}),h(Ao)!=="svelte-kc2r9i"&&(Ao.textContent=Ds),In.forEach(o),en=s(e),P=n(e,"DIV",{class:!0});var V=c(P);g(bt.$$.fragment,V),xa=s(V),To=n(V,"P",{"data-svelte-h":!0}),h(To)!=="svelte-1phtukb"&&(To.textContent=Bs),Aa=s(V),S=n(V,"DIV",{class:!0});var fr=c(S);g(yt.$$.fragment,fr),Ta=s(fr),ko=n(fr,"P",{"data-svelte-h":!0}),h(ko)!=="svelte-1s1qxmr"&&(ko.textContent=Ys),ka=s(fr),g(Me.$$.fragment,fr),fr.forEach(o),Ma=s(V),z=n(V,"DIV",{class:!0});var gr=c(z);g(wt.$$.fragment,gr),Ca=s(gr),Mo=n(gr,"P",{"data-svelte-h":!0}),h(Mo)!=="svelte-1685qxi"&&(Mo.textContent=Fs),Ia=s(gr),g(Ce.$$.fragment,gr),gr.forEach(o),Ha=s(V),Ie=n(V,"DIV",{class:!0});var Hn=c(Ie);g(xt.$$.fragment,Hn),Pa=s(Hn),Co=n(Hn,"P",{"data-svelte-h":!0}),h(Co)!=="svelte-92plik"&&(Co.innerHTML=Qs),Hn.forEach(o),V.forEach(o),tn=s(e),K=n(e,"H2",{class:!0});var Pn=c(K);He=n(Pn,"A",{id:!0,class:!0,href:!0});var Yl=c(He);Ar=n(Yl,"SPAN",{});var Fl=c(Ar);g(At.$$.fragment,Fl),Fl.forEach(o),Yl.forEach(o),Ea=s(Pn),Io=n(Pn,"SPAN",{"data-svelte-h":!0}),h(Io)!=="svelte-7l60uo"&&(Io.textContent=Xs),Pn.forEach(o),on=s(e),ee=n(e,"H3",{class:!0});var En=c(ee);Pe=n(En,"A",{id:!0,class:!0,href:!0});var Ql=c(Pe);Tr=n(Ql,"SPAN",{});var Xl=c(Tr);g(Tt.$$.fragment,Xl),Xl.forEach(o),Ql.forEach(o),ja=s(En),Ho=n(En,"SPAN",{"data-svelte-h":!0}),h(Ho)!=="svelte-1ja720g"&&(Ho.textContent=Os),En.forEach(o),rn=s(e),te=n(e,"DIV",{class:!0});var jn=c(te);g(kt.$$.fragment,jn),La=s(jn),Po=n(jn,"P",{"data-svelte-h":!0}),h(Po)!=="svelte-16uh3p8"&&(Po.textContent=Ks),jn.forEach(o),nn=s(e),oe=n(e,"H3",{class:!0});var Ln=c(oe);Ee=n(Ln,"A",{id:!0,class:!0,href:!0});var Ol=c(Ee);kr=n(Ol,"SPAN",{});var Kl=c(kr);g(Mt.$$.fragment,Kl),Kl.forEach(o),Ol.forEach(o),Ja=s(Ln),Eo=n(Ln,"SPAN",{"data-svelte-h":!0}),h(Eo)!=="svelte-k4u2xj"&&(Eo.textContent=el),Ln.forEach(o),an=s(e),k=n(e,"DIV",{class:!0});var I=c(k);g(Ct.$$.fragment,I),Ua=s(I),jo=n(I,"P",{"data-svelte-h":!0}),h(jo)!=="svelte-cca4c5"&&(jo.innerHTML=tl),qa=s(I),Lo=n(I,"UL",{"data-svelte-h":!0}),h(Lo)!=="svelte-1lb1si5"&&(Lo.innerHTML=ol),Na=s(I),Jo=n(I,"P",{"data-svelte-h":!0}),h(Jo)!=="svelte-87vm6y"&&(Jo.innerHTML=rl),Za=s(I),je=n(I,"DIV",{class:!0});var Jn=c(je);g(It.$$.fragment,Jn),Wa=s(Jn),Uo=n(Jn,"P",{"data-svelte-h":!0}),h(Uo)!=="svelte-1kesvmr"&&(Uo.innerHTML=nl),Jn.forEach(o),Ra=s(I),Le=n(I,"DIV",{class:!0});var Un=c(Le);g(Ht.$$.fragment,Un),Sa=s(Un),qo=n(Un,"P",{"data-svelte-h":!0}),h(qo)!=="svelte-yy7b2c"&&(qo.textContent=al),Un.forEach(o),za=s(I),Je=n(I,"DIV",{class:!0});var qn=c(Je);g(Pt.$$.fragment,qn),Ga=s(qn),No=n(qn,"P",{"data-svelte-h":!0}),h(No)!=="svelte-1u3gku9"&&(No.textContent=sl),qn.forEach(o),Va=s(I),Z=n(I,"DIV",{class:!0});var ot=c(Z);g(Et.$$.fragment,ot),Da=s(ot),Zo=n(ot,"P",{"data-svelte-h":!0}),h(Zo)!=="svelte-19evuwa"&&(Zo.innerHTML=ll),Ba=s(ot),Wo=n(ot,"UL",{"data-svelte-h":!0}),h(Wo)!=="svelte-15of9ze"&&(Wo.innerHTML=il),Ya=s(ot),Ro=n(ot,"P",{"data-svelte-h":!0}),h(Ro)!=="svelte-msa4ge"&&(Ro.innerHTML=dl),ot.forEach(o),Fa=s(I),Ue=n(I,"DIV",{class:!0});var Nn=c(Ue);g(jt.$$.fragment,Nn),Qa=s(Nn),So=n(Nn,"P",{"data-svelte-h":!0}),h(So)!=="svelte-63kthh"&&(So.textContent=ml),Nn.forEach(o),I.forEach(o),sn=s(e),re=n(e,"H3",{class:!0});var Zn=c(re);qe=n(Zn,"A",{id:!0,class:!0,href:!0});var ei=c(qe);Mr=n(ei,"SPAN",{});var ti=c(Mr);g(Lt.$$.fragment,ti),ti.forEach(o),ei.forEach(o),Xa=s(Zn),zo=n(Zn,"SPAN",{"data-svelte-h":!0}),h(zo)!=="svelte-176x831"&&(zo.textContent=pl),Zn.forEach(o),ln=s(e),C=n(e,"DIV",{class:!0});var E=c(C);g(Jt.$$.fragment,E),Oa=s(E),Go=n(E,"P",{"data-svelte-h":!0}),h(Go)!=="svelte-t45cfv"&&(Go.innerHTML=cl),Ka=s(E),Vo=n(E,"UL",{"data-svelte-h":!0}),h(Vo)!=="svelte-lg0op6"&&(Vo.innerHTML=hl),es=s(E),Ne=n(E,"DIV",{class:!0});var Wn=c(Ne);g(Ut.$$.fragment,Wn),ts=s(Wn),Do=n(Wn,"P",{"data-svelte-h":!0}),h(Do)!=="svelte-zkjq4t"&&(Do.innerHTML=ul),Wn.forEach(o),os=s(E),Ze=n(E,"DIV",{class:!0});var Rn=c(Ze);g(qt.$$.fragment,Rn),rs=s(Rn),Bo=n(Rn,"P",{"data-svelte-h":!0}),h(Bo)!=="svelte-1vxzk80"&&(Bo.innerHTML=fl),Rn.forEach(o),ns=s(E),We=n(E,"DIV",{class:!0});var Sn=c(We);g(Nt.$$.fragment,Sn),as=s(Sn),Yo=n(Sn,"P",{"data-svelte-h":!0}),h(Yo)!=="svelte-1qgsi13"&&(Yo.innerHTML=gl),Sn.forEach(o),ss=s(E),Re=n(E,"DIV",{class:!0});var zn=c(Re);g(Zt.$$.fragment,zn),ls=s(zn),Fo=n(zn,"P",{"data-svelte-h":!0}),h(Fo)!=="svelte-1ojxz66"&&(Fo.innerHTML=vl),zn.forEach(o),E.forEach(o),dn=s(e),ne=n(e,"H3",{class:!0});var Gn=c(ne);Se=n(Gn,"A",{id:!0,class:!0,href:!0});var oi=c(Se);Cr=n(oi,"SPAN",{});var ri=c(Cr);g(Wt.$$.fragment,ri),ri.forEach(o),oi.forEach(o),is=s(Gn),Qo=n(Gn,"SPAN",{"data-svelte-h":!0}),h(Qo)!=="svelte-1tsfs0h"&&(Qo.textContent=_l),Gn.forEach(o),mn=s(e),U=n(e,"DIV",{class:!0});var rt=c(U);g(Rt.$$.fragment,rt),ds=s(rt),Xo=n(rt,"P",{"data-svelte-h":!0}),h(Xo)!=="svelte-1fh5dze"&&(Xo.innerHTML=$l),ms=s(rt),ze=n(rt,"DIV",{class:!0});var Vn=c(ze);g(St.$$.fragment,Vn),ps=s(Vn),Oo=n(Vn,"P",{"data-svelte-h":!0}),h(Oo)!=="svelte-g3562d"&&(Oo.innerHTML=bl),Vn.forEach(o),cs=s(rt),G=n(rt,"DIV",{class:!0});var vr=c(G);g(zt.$$.fragment,vr),hs=s(vr),Ko=n(vr,"P",{"data-svelte-h":!0}),h(Ko)!=="svelte-14yhe1"&&(Ko.innerHTML=yl),us=s(vr),er=n(vr,"P",{"data-svelte-h":!0}),h(er)!=="svelte-18tzbrg"&&(er.innerHTML=wl),vr.forEach(o),rt.forEach(o),pn=s(e),ae=n(e,"H3",{class:!0});var Dn=c(ae);Ge=n(Dn,"A",{id:!0,class:!0,href:!0});var ni=c(Ge);Ir=n(ni,"SPAN",{});var ai=c(Ir);g(Gt.$$.fragment,ai),ai.forEach(o),ni.forEach(o),fs=s(Dn),tr=n(Dn,"SPAN",{"data-svelte-h":!0}),h(tr)!=="svelte-n9l13z"&&(tr.textContent=xl),Dn.forEach(o),cn=s(e),se=n(e,"DIV",{class:!0});var Bn=c(se);g(Vt.$$.fragment,Bn),gs=s(Bn),or=n(Bn,"P",{"data-svelte-h":!0}),h(or)!=="svelte-78dinl"&&(or.innerHTML=Al),Bn.forEach(o),hn=s(e),le=n(e,"H2",{class:!0});var Yn=c(le);Ve=n(Yn,"A",{id:!0,class:!0,href:!0});var si=c(Ve);Hr=n(si,"SPAN",{});var li=c(Hr);g(Dt.$$.fragment,li),li.forEach(o),si.forEach(o),vs=s(Yn),rr=n(Yn,"SPAN",{"data-svelte-h":!0}),h(rr)!=="svelte-ricbuv"&&(rr.textContent=Tl),Yn.forEach(o),un=s(e),Bt=n(e,"P",{"data-svelte-h":!0}),h(Bt)!=="svelte-jsq4jz"&&(Bt.textContent=kl),fn=s(e),Yt=n(e,"P",{"data-svelte-h":!0}),h(Yt)!=="svelte-1ixcu88"&&(Yt.innerHTML=Ml),gn=s(e),Ft=n(e,"P",{"data-svelte-h":!0}),h(Ft)!=="svelte-1nfvcwf"&&(Ft.textContent=Cl),vn=s(e),Qt=n(e,"UL",{"data-svelte-h":!0}),h(Qt)!=="svelte-ysem30"&&(Qt.innerHTML=Il),_n=s(e),ie=n(e,"H3",{class:!0});var Fn=c(ie);De=n(Fn,"A",{id:!0,class:!0,href:!0});var ii=c(De);Pr=n(ii,"SPAN",{});var di=c(Pr);g(Xt.$$.fragment,di),di.forEach(o),ii.forEach(o),_s=s(Fn),nr=n(Fn,"SPAN",{"data-svelte-h":!0}),h(nr)!=="svelte-15bcpzd"&&(nr.textContent=Hl),Fn.forEach(o),$n=s(e),de=n(e,"DIV",{class:!0});var Qn=c(de);g(Ot.$$.fragment,Qn),$s=s(Qn),ar=n(Qn,"P",{"data-svelte-h":!0}),h(ar)!=="svelte-57fhj7"&&(ar.textContent=Pl),Qn.forEach(o),bn=s(e),me=n(e,"H3",{class:!0});var Xn=c(me);Be=n(Xn,"A",{id:!0,class:!0,href:!0});var mi=c(Be);Er=n(mi,"SPAN",{});var pi=c(Er);g(Kt.$$.fragment,pi),pi.forEach(o),mi.forEach(o),bs=s(Xn),sr=n(Xn,"SPAN",{"data-svelte-h":!0}),h(sr)!=="svelte-1be9zyb"&&(sr.textContent=El),Xn.forEach(o),yn=s(e),q=n(e,"DIV",{class:!0});var nt=c(q);g(eo.$$.fragment,nt),ys=s(nt),lr=n(nt,"P",{"data-svelte-h":!0}),h(lr)!=="svelte-1hsb0qs"&&(lr.textContent=jl),ws=s(nt),Ye=n(nt,"DIV",{class:!0});var On=c(Ye);g(to.$$.fragment,On),xs=s(On),ir=n(On,"P",{"data-svelte-h":!0}),h(ir)!=="svelte-ybie7i"&&(ir.textContent=Ll),On.forEach(o),As=s(nt),Fe=n(nt,"DIV",{class:!0});var Kn=c(Fe);g(oo.$$.fragment,Kn),Ts=s(Kn),dr=n(Kn,"P",{"data-svelte-h":!0}),h(dr)!=="svelte-chc6sp"&&(dr.textContent=Jl),Kn.forEach(o),nt.forEach(o),wn=s(e),pe=n(e,"H3",{class:!0});var ea=c(pe);Qe=n(ea,"A",{id:!0,class:!0,href:!0});var ci=c(Qe);jr=n(ci,"SPAN",{});var hi=c(jr);g(ro.$$.fragment,hi),hi.forEach(o),ci.forEach(o),ks=s(ea),mr=n(ea,"SPAN",{"data-svelte-h":!0}),h(mr)!=="svelte-lwnvta"&&(mr.textContent=Ul),ea.forEach(o),xn=s(e),N=n(e,"DIV",{class:!0});var at=c(N);g(no.$$.fragment,at),Ms=s(at),pr=n(at,"P",{"data-svelte-h":!0}),h(pr)!=="svelte-ckiqb6"&&(pr.textContent=ql),Cs=s(at),Xe=n(at,"DIV",{class:!0});var ta=c(Xe);g(ao.$$.fragment,ta),Is=s(ta),cr=n(ta,"P",{"data-svelte-h":!0}),h(cr)!=="svelte-10rnn1x"&&(cr.innerHTML=Nl),ta.forEach(o),Hs=s(at),Oe=n(at,"DIV",{class:!0});var oa=c(Oe);g(so.$$.fragment,oa),Ps=s(oa),hr=n(oa,"P",{"data-svelte-h":!0}),h(hr)!=="svelte-1xu9o93"&&(hr.textContent=Zl),oa.forEach(o),at.forEach(o),An=s(e),Lr=n(e,"P",{}),c(Lr).forEach(o),this.h()},h(){d(p,"name","hf:doc:metadata"),d(p,"content",JSON.stringify(Hi)),d(l,"id","agents-tools"),d(l,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(l,"href","#agents-tools"),d(w,"class","relative group"),d(ue,"id","agents"),d(ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ue,"href","#agents"),d(B,"class","relative group"),d(fe,"id","transformers.HfAgent"),d(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(fe,"href","#transformers.HfAgent"),d(Y,"class","relative group"),d(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ve,"id","transformers.LocalAgent"),d(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ve,"href","#transformers.LocalAgent"),d(F,"class","relative group"),d(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(be,"id","transformers.OpenAiAgent"),d(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(be,"href","#transformers.OpenAiAgent"),d(Q,"class","relative group"),d(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(xe,"id","transformers.AzureOpenAiAgent"),d(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(xe,"href","#transformers.AzureOpenAiAgent"),d(X,"class","relative group"),d(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(ke,"id","transformers.Agent"),d(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ke,"href","#transformers.Agent"),d(O,"class","relative group"),d(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(He,"id","tools"),d(He,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(He,"href","#tools"),d(K,"class","relative group"),d(Pe,"id","transformers.load_tool"),d(Pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Pe,"href","#transformers.load_tool"),d(ee,"class","relative group"),d(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ee,"id","transformers.Tool"),d(Ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ee,"href","#transformers.Tool"),d(oe,"class","relative group"),d(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(qe,"id","transformers.PipelineTool"),d(qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(qe,"href","#transformers.PipelineTool"),d(re,"class","relative group"),d(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Se,"id","transformers.RemoteTool"),d(Se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Se,"href","#transformers.RemoteTool"),d(ne,"class","relative group"),d(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ge,"id","transformers.launch_gradio_demo"),d(Ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ge,"href","#transformers.launch_gradio_demo"),d(ae,"class","relative group"),d(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ve,"id","agent-types"),d(Ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ve,"href","#agent-types"),d(le,"class","relative group"),d(De,"id","transformers.tools.agent_types.AgentText"),d(De,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(De,"href","#transformers.tools.agent_types.AgentText"),d(ie,"class","relative group"),d(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Be,"id","transformers.tools.agent_types.AgentImage"),d(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Be,"href","#transformers.tools.agent_types.AgentImage"),d(me,"class","relative group"),d(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Qe,"id","transformers.tools.agent_types.AgentAudio"),d(Qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Qe,"href","#transformers.tools.agent_types.AgentAudio"),d(pe,"class","relative group"),d(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){t(document.head,p),m(e,x,i),m(e,y,i),m(e,u,i),m(e,w,i),t(w,l),t(l,A),v(st,A,null),t(w,ra),t(w,ho),m(e,Rr,i),v(he,e,i),m(e,Sr,i),m(e,lt,i),m(e,zr,i),m(e,B,i),t(B,ue),t(ue,_r),v(it,_r,null),t(B,na),t(B,uo),m(e,Gr,i),m(e,dt,i),m(e,Vr,i),m(e,Y,i),t(Y,fe),t(fe,$r),v(mt,$r,null),t(Y,aa),t(Y,fo),m(e,Dr,i),m(e,W,i),v(pt,W,null),t(W,sa),t(W,go),t(W,la),v(ge,W,null),m(e,Br,i),m(e,F,i),t(F,ve),t(ve,br),v(ct,br,null),t(F,ia),t(F,vo),m(e,Yr,i),m(e,j,i),v(ht,j,null),t(j,da),t(j,_o),t(j,ma),v(_e,j,null),t(j,pa),t(j,R),v(ut,R,null),t(R,ca),t(R,$o),t(R,ha),v($e,R,null),m(e,Fr,i),m(e,Q,i),t(Q,be),t(be,yr),v(ft,yr,null),t(Q,ua),t(Q,bo),m(e,Qr,i),m(e,L,i),v(gt,L,null),t(L,fa),t(L,yo),t(L,ga),v(ye,L,null),t(L,va),v(we,L,null),m(e,Xr,i),m(e,X,i),t(X,xe),t(xe,wr),v(vt,wr,null),t(X,_a),t(X,wo),m(e,Or,i),m(e,J,i),v(_t,J,null),t(J,$a),t(J,xo),t(J,ba),v(Ae,J,null),t(J,ya),v(Te,J,null),m(e,Kr,i),m(e,O,i),t(O,ke),t(ke,xr),v($t,xr,null),t(O,wa),t(O,Ao),m(e,en,i),m(e,P,i),v(bt,P,null),t(P,xa),t(P,To),t(P,Aa),t(P,S),v(yt,S,null),t(S,Ta),t(S,ko),t(S,ka),v(Me,S,null),t(P,Ma),t(P,z),v(wt,z,null),t(z,Ca),t(z,Mo),t(z,Ia),v(Ce,z,null),t(P,Ha),t(P,Ie),v(xt,Ie,null),t(Ie,Pa),t(Ie,Co),m(e,tn,i),m(e,K,i),t(K,He),t(He,Ar),v(At,Ar,null),t(K,Ea),t(K,Io),m(e,on,i),m(e,ee,i),t(ee,Pe),t(Pe,Tr),v(Tt,Tr,null),t(ee,ja),t(ee,Ho),m(e,rn,i),m(e,te,i),v(kt,te,null),t(te,La),t(te,Po),m(e,nn,i),m(e,oe,i),t(oe,Ee),t(Ee,kr),v(Mt,kr,null),t(oe,Ja),t(oe,Eo),m(e,an,i),m(e,k,i),v(Ct,k,null),t(k,Ua),t(k,jo),t(k,qa),t(k,Lo),t(k,Na),t(k,Jo),t(k,Za),t(k,je),v(It,je,null),t(je,Wa),t(je,Uo),t(k,Ra),t(k,Le),v(Ht,Le,null),t(Le,Sa),t(Le,qo),t(k,za),t(k,Je),v(Pt,Je,null),t(Je,Ga),t(Je,No),t(k,Va),t(k,Z),v(Et,Z,null),t(Z,Da),t(Z,Zo),t(Z,Ba),t(Z,Wo),t(Z,Ya),t(Z,Ro),t(k,Fa),t(k,Ue),v(jt,Ue,null),t(Ue,Qa),t(Ue,So),m(e,sn,i),m(e,re,i),t(re,qe),t(qe,Mr),v(Lt,Mr,null),t(re,Xa),t(re,zo),m(e,ln,i),m(e,C,i),v(Jt,C,null),t(C,Oa),t(C,Go),t(C,Ka),t(C,Vo),t(C,es),t(C,Ne),v(Ut,Ne,null),t(Ne,ts),t(Ne,Do),t(C,os),t(C,Ze),v(qt,Ze,null),t(Ze,rs),t(Ze,Bo),t(C,ns),t(C,We),v(Nt,We,null),t(We,as),t(We,Yo),t(C,ss),t(C,Re),v(Zt,Re,null),t(Re,ls),t(Re,Fo),m(e,dn,i),m(e,ne,i),t(ne,Se),t(Se,Cr),v(Wt,Cr,null),t(ne,is),t(ne,Qo),m(e,mn,i),m(e,U,i),v(Rt,U,null),t(U,ds),t(U,Xo),t(U,ms),t(U,ze),v(St,ze,null),t(ze,ps),t(ze,Oo),t(U,cs),t(U,G),v(zt,G,null),t(G,hs),t(G,Ko),t(G,us),t(G,er),m(e,pn,i),m(e,ae,i),t(ae,Ge),t(Ge,Ir),v(Gt,Ir,null),t(ae,fs),t(ae,tr),m(e,cn,i),m(e,se,i),v(Vt,se,null),t(se,gs),t(se,or),m(e,hn,i),m(e,le,i),t(le,Ve),t(Ve,Hr),v(Dt,Hr,null),t(le,vs),t(le,rr),m(e,un,i),m(e,Bt,i),m(e,fn,i),m(e,Yt,i),m(e,gn,i),m(e,Ft,i),m(e,vn,i),m(e,Qt,i),m(e,_n,i),m(e,ie,i),t(ie,De),t(De,Pr),v(Xt,Pr,null),t(ie,_s),t(ie,nr),m(e,$n,i),m(e,de,i),v(Ot,de,null),t(de,$s),t(de,ar),m(e,bn,i),m(e,me,i),t(me,Be),t(Be,Er),v(Kt,Er,null),t(me,bs),t(me,sr),m(e,yn,i),m(e,q,i),v(eo,q,null),t(q,ys),t(q,lr),t(q,ws),t(q,Ye),v(to,Ye,null),t(Ye,xs),t(Ye,ir),t(q,As),t(q,Fe),v(oo,Fe,null),t(Fe,Ts),t(Fe,dr),m(e,wn,i),m(e,pe,i),t(pe,Qe),t(Qe,jr),v(ro,jr,null),t(pe,ks),t(pe,mr),m(e,xn,i),m(e,N,i),v(no,N,null),t(N,Ms),t(N,pr),t(N,Cs),t(N,Xe),v(ao,Xe,null),t(Xe,Is),t(Xe,cr),t(N,Hs),t(N,Oe),v(so,Oe,null),t(Oe,Ps),t(Oe,hr),m(e,An,i),m(e,Lr,i),Tn=!0},p(e,[i]){const lo={};i&2&&(lo.$$scope={dirty:i,ctx:e}),he.$set(lo);const Jr={};i&2&&(Jr.$$scope={dirty:i,ctx:e}),ge.$set(Jr);const Ur={};i&2&&(Ur.$$scope={dirty:i,ctx:e}),_e.$set(Ur);const io={};i&2&&(io.$$scope={dirty:i,ctx:e}),$e.$set(io);const qr={};i&2&&(qr.$$scope={dirty:i,ctx:e}),ye.$set(qr);const Nr={};i&2&&(Nr.$$scope={dirty:i,ctx:e}),we.$set(Nr);const mo={};i&2&&(mo.$$scope={dirty:i,ctx:e}),Ae.$set(mo);const Zr={};i&2&&(Zr.$$scope={dirty:i,ctx:e}),Te.$set(Zr);const Wr={};i&2&&(Wr.$$scope={dirty:i,ctx:e}),Me.$set(Wr);const ce={};i&2&&(ce.$$scope={dirty:i,ctx:e}),Ce.$set(ce)},i(e){Tn||(_(st.$$.fragment,e),_(he.$$.fragment,e),_(it.$$.fragment,e),_(mt.$$.fragment,e),_(pt.$$.fragment,e),_(ge.$$.fragment,e),_(ct.$$.fragment,e),_(ht.$$.fragment,e),_(_e.$$.fragment,e),_(ut.$$.fragment,e),_($e.$$.fragment,e),_(ft.$$.fragment,e),_(gt.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(vt.$$.fragment,e),_(_t.$$.fragment,e),_(Ae.$$.fragment,e),_(Te.$$.fragment,e),_($t.$$.fragment,e),_(bt.$$.fragment,e),_(yt.$$.fragment,e),_(Me.$$.fragment,e),_(wt.$$.fragment,e),_(Ce.$$.fragment,e),_(xt.$$.fragment,e),_(At.$$.fragment,e),_(Tt.$$.fragment,e),_(kt.$$.fragment,e),_(Mt.$$.fragment,e),_(Ct.$$.fragment,e),_(It.$$.fragment,e),_(Ht.$$.fragment,e),_(Pt.$$.fragment,e),_(Et.$$.fragment,e),_(jt.$$.fragment,e),_(Lt.$$.fragment,e),_(Jt.$$.fragment,e),_(Ut.$$.fragment,e),_(qt.$$.fragment,e),_(Nt.$$.fragment,e),_(Zt.$$.fragment,e),_(Wt.$$.fragment,e),_(Rt.$$.fragment,e),_(St.$$.fragment,e),_(zt.$$.fragment,e),_(Gt.$$.fragment,e),_(Vt.$$.fragment,e),_(Dt.$$.fragment,e),_(Xt.$$.fragment,e),_(Ot.$$.fragment,e),_(Kt.$$.fragment,e),_(eo.$$.fragment,e),_(to.$$.fragment,e),_(oo.$$.fragment,e),_(ro.$$.fragment,e),_(no.$$.fragment,e),_(ao.$$.fragment,e),_(so.$$.fragment,e),Tn=!0)},o(e){$(st.$$.fragment,e),$(he.$$.fragment,e),$(it.$$.fragment,e),$(mt.$$.fragment,e),$(pt.$$.fragment,e),$(ge.$$.fragment,e),$(ct.$$.fragment,e),$(ht.$$.fragment,e),$(_e.$$.fragment,e),$(ut.$$.fragment,e),$($e.$$.fragment,e),$(ft.$$.fragment,e),$(gt.$$.fragment,e),$(ye.$$.fragment,e),$(we.$$.fragment,e),$(vt.$$.fragment,e),$(_t.$$.fragment,e),$(Ae.$$.fragment,e),$(Te.$$.fragment,e),$($t.$$.fragment,e),$(bt.$$.fragment,e),$(yt.$$.fragment,e),$(Me.$$.fragment,e),$(wt.$$.fragment,e),$(Ce.$$.fragment,e),$(xt.$$.fragment,e),$(At.$$.fragment,e),$(Tt.$$.fragment,e),$(kt.$$.fragment,e),$(Mt.$$.fragment,e),$(Ct.$$.fragment,e),$(It.$$.fragment,e),$(Ht.$$.fragment,e),$(Pt.$$.fragment,e),$(Et.$$.fragment,e),$(jt.$$.fragment,e),$(Lt.$$.fragment,e),$(Jt.$$.fragment,e),$(Ut.$$.fragment,e),$(qt.$$.fragment,e),$(Nt.$$.fragment,e),$(Zt.$$.fragment,e),$(Wt.$$.fragment,e),$(Rt.$$.fragment,e),$(St.$$.fragment,e),$(zt.$$.fragment,e),$(Gt.$$.fragment,e),$(Vt.$$.fragment,e),$(Dt.$$.fragment,e),$(Xt.$$.fragment,e),$(Ot.$$.fragment,e),$(Kt.$$.fragment,e),$(eo.$$.fragment,e),$(to.$$.fragment,e),$(oo.$$.fragment,e),$(ro.$$.fragment,e),$(no.$$.fragment,e),$(ao.$$.fragment,e),$(so.$$.fragment,e),Tn=!1},d(e){e&&(o(x),o(y),o(u),o(w),o(Rr),o(Sr),o(lt),o(zr),o(B),o(Gr),o(dt),o(Vr),o(Y),o(Dr),o(W),o(Br),o(F),o(Yr),o(j),o(Fr),o(Q),o(Qr),o(L),o(Xr),o(X),o(Or),o(J),o(Kr),o(O),o(en),o(P),o(tn),o(K),o(on),o(ee),o(rn),o(te),o(nn),o(oe),o(an),o(k),o(sn),o(re),o(ln),o(C),o(dn),o(ne),o(mn),o(U),o(pn),o(ae),o(cn),o(se),o(hn),o(le),o(un),o(Bt),o(fn),o(Yt),o(gn),o(Ft),o(vn),o(Qt),o(_n),o(ie),o($n),o(de),o(bn),o(me),o(yn),o(q),o(wn),o(pe),o(xn),o(N),o(An),o(Lr)),o(p),b(st),b(he,e),b(it),b(mt),b(pt),b(ge),b(ct),b(ht),b(_e),b(ut),b($e),b(ft),b(gt),b(ye),b(we),b(vt),b(_t),b(Ae),b(Te),b($t),b(bt),b(yt),b(Me),b(wt),b(Ce),b(xt),b(At),b(Tt),b(kt),b(Mt),b(Ct),b(It),b(Ht),b(Pt),b(Et),b(jt),b(Lt),b(Jt),b(Ut),b(qt),b(Nt),b(Zt),b(Wt),b(Rt),b(St),b(zt),b(Gt),b(Vt),b(Dt),b(Xt),b(Ot),b(Kt),b(eo),b(to),b(oo),b(ro),b(no),b(ao),b(so)}}}const Hi={local:"agents-tools",sections:[{local:"agents",sections:[{local:"transformers.HfAgent",title:"HfAgent"},{local:"transformers.LocalAgent",title:"LocalAgent"},{local:"transformers.OpenAiAgent",title:"OpenAiAgent"},{local:"transformers.AzureOpenAiAgent",title:"AzureOpenAiAgent"},{local:"transformers.Agent",title:"Agent"}],title:"Agents"},{local:"tools",sections:[{local:"transformers.load_tool",title:"load_tool"},{local:"transformers.Tool",title:"Tool"},{local:"transformers.PipelineTool",title:"PipelineTool"},{local:"transformers.RemoteTool",title:"RemoteTool"},{local:"transformers.launch_gradio_demo",title:"launch_gradio_demo"}],title:"Tools"},{local:"agent-types",sections:[{local:"transformers.tools.agent_types.AgentText",title:"AgentText"},{local:"transformers.tools.agent_types.AgentImage",title:"AgentImage"},{local:"transformers.tools.agent_types.AgentAudio",title:"AgentAudio"}],title:"Agent Types"}],title:"Agents & Tools"};function Pi(M){return fi(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Zi extends gi{constructor(p){super(),vi(this,p,Pi,Ii,ui,{})}}export{Zi as component};
