import{s as jl,o as _l,n as Jl}from"../chunks/scheduler.9bc65507.js";import{S as xl,i as $l,g as s,s as a,u as d,A as kl,h as o,f as t,c as r,j as p,v as m,y as c,k as i,o as h,a as l,w as u,d as f,t as w,x as v}from"../chunks/index.78c82d43.js";import{T as Wl}from"../chunks/Tip.87d55b76.js";import{I as b}from"../chunks/IconCopyLink.bedaa44d.js";import{C as Le}from"../chunks/CodeBlock.73e038be.js";function Sl(at){let y,G=`This is the very beginning of our experiments with TorchScript and we are still
exploring its capabilities with variable-input-size models. It is a focus of interest to
us and we will deepen our analysis in upcoming releases, with more code examples, a more
flexible implementation, and benchmarks comparing Python-based codes with compiled
TorchScript.`;return{c(){y=s("p"),y.textContent=G},l(M){y=o(M,"P",{"data-svelte-h":!0}),c(y)!=="svelte-3gxwq2"&&(y.textContent=G)},m(M,Be){l(M,y,Be)},p:Jl,d(M){M&&t(y)}}}function Zl(at){let y,G,M,Be,g,S,Fe,P,hn,Ne,bn="Export to TorchScript",rt,Z,it,X,gn='According to the <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript documentation</a>:',ht,L,Tn="<p>TorchScript is a way to create serializable and optimizable models from PyTorch code.</p>",ct,F,Cn=`There are two PyTorch modules, <a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT and
TRACE</a>, that allow developers to export their
models to be reused in other programs like efficiency-oriented C++ programs.`,pt,Y,Un=`We provide an interface that allows you to export 🤗 Transformers models to TorchScript
so they can be reused in a different environment than PyTorch-based Python programs.
Here, we explain how to export and use our models using TorchScript.`,dt,q,jn="Exporting a model requires two things:",mt,D,_n="<li>model instantiation with the <code>torchscript</code> flag</li> <li>a forward pass with dummy inputs</li>",ut,K,Jn=`These necessities imply several things developers should be careful about as detailed
below.`,ft,T,E,Ye,O,cn,He,xn="TorchScript flag and tied weights",wt,ee,$n=`The <code>torchscript</code> flag is necessary because most of the 🤗 Transformers language models
have tied weights between their <code>Embedding</code> layer and their <code>Decoding</code> layer.
TorchScript does not allow you to export models that have tied weights, so it is
necessary to untie and clone the weights beforehand.`,vt,te,kn=`Models instantiated with the <code>torchscript</code> flag have their <code>Embedding</code> layer and
<code>Decoding</code> layer separated, which means that they should not be trained down the line.
Training would desynchronize the two layers, leading to unexpected results.`,yt,ne,Wn=`This is not the case for models that do not have a language model head, as those do not
have tied weights. These models can be safely exported without the <code>torchscript</code> flag.`,Mt,C,B,qe,le,pn,Ie,Sn="Dummy inputs and standard lengths",bt,se,Zn=`The dummy inputs are used for a models forward pass. While the inputs’ values are
propagated through the layers, PyTorch keeps track of the different operations executed
on each tensor. These recorded operations are then used to create the <em>trace</em> of the
model.`,gt,oe,En=`The trace is created relative to the inputs’ dimensions. It is therefore constrained by
the dimensions of the dummy input, and will not work for any other sequence length or
batch size. When trying with a different size, the following error is raised:`,Tt,ae,Ct,re,Bn=`We recommended you trace the model with a dummy input size at least as large as the
largest input that will be fed to the model during inference. Padding can help fill the
missing values. However, since the model is traced with a larger input size, the
dimensions of the matrix will also be large, resulting in more calculations.`,Ut,ie,Nn=`Be careful of the total number of operations done on each input and follow the
performance closely when exporting varying sequence-length models.`,jt,U,N,De,he,dn,Ae,Hn="Using TorchScript in Python",_t,ce,In=`This section demonstrates how to save and load models as well as how to use the trace
for inference.`,Jt,j,H,Ke,pe,mn,ze,An="Saving a model",xt,de,zn=`To export a <code>BertModel</code> with TorchScript, instantiate <code>BertModel</code> from the <code>BertConfig</code>
class and then save it to disk under the filename <code>traced_bert.pt</code>:`,$t,me,kt,_,I,Oe,ue,un,Re,Rn="Loading a model",Wt,fe,Qn=`Now you can load the previously saved <code>BertModel</code>, <code>traced_bert.pt</code>, from disk and use
it on the previously initialised <code>dummy_input</code>:`,St,we,Zt,J,A,et,ve,fn,Qe,Vn="Using a traced model for inference",Et,ye,Gn="Use the traced model for inference by using its <code>__call__</code> dunder method:",Bt,Me,Nt,x,z,tt,be,wn,Ve,Pn="Deploy Hugging Face TorchScript models to AWS with the Neuron SDK",Ht,ge,Xn=`AWS introduced the <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a>
instance family for low cost, high performance machine learning inference in the cloud.
The Inf1 instances are powered by the AWS Inferentia chip, a custom-built hardware
accelerator, specializing in deep learning inferencing workloads. <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS
Neuron</a> is the SDK for
Inferentia that supports tracing and optimizing transformers models for deployment on
Inf1. The Neuron SDK provides:`,It,Te,Ln=`<li>Easy-to-use API with one line of code change to trace and optimize a TorchScript
model for inference in the cloud.</li> <li>Out of the box performance optimizations for <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/%3E" rel="nofollow">improved
cost-performance</a>.</li> <li>Support for Hugging Face transformers models built with either
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a>
or
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>.</li>`,At,$,R,nt,Ce,vn,Ge,Fn="Implications",zt,Ue,Yn=`Transformers models based on the <a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT (Bidirectional Encoder Representations from
Transformers)</a>
architecture, or its variants such as
<a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a> and
<a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a> run best on
Inf1 for non-generative tasks such as extractive question answering, sequence
classification, and token classification. However, text generation tasks can still be
adapted to run on Inf1 according to this <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT
tutorial</a>.
More information about models that can be converted out of the box on Inferentia can be
found in the <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">Model Architecture
Fit</a>
section of the Neuron documentation.`,Rt,k,Q,lt,je,yn,Pe,qn="Dependencies",Qt,_e,Dn=`Using AWS Neuron to convert models requires a <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK
environment</a>
which comes preconfigured on <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS Deep Learning
AMI</a>.`,Vt,W,V,st,Je,Mn,Xe,Kn="Converting a model for AWS Neuron",Gt,xe,On=`Convert a model for AWS NEURON using the same code from <a href="torchscript#using-torchscript-in-python">Using TorchScript in
Python</a> to trace a <code>BertModel</code>. Import the
<code>torch.neuron</code> framework extension to access the components of the Neuron SDK through a
Python API:`,Pt,$e,Xt,ke,el="You only need to modify the following line:",Lt,We,Ft,Se,tl="This enables the Neuron SDK to trace the model and optimize it for Inf1 instances.",Yt,Ze,nl=`To learn more about AWS Neuron SDK features, tools, example tutorials and latest
updates, please see the <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK
documentation</a>.`,qt,ot,Dt;return P=new b({}),Z=new Wl({props:{$$slots:{default:[Sl]},$$scope:{ctx:at}}}),O=new b({}),le=new b({}),ae=new Le({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:'`The expanded <span class="hljs-built_in">size</span> of the tensor (<span class="hljs-number">3</span>) must match the existing <span class="hljs-built_in">size</span> (<span class="hljs-number">7</span>) at non-singleton <span class="hljs-keyword">dimension</span> <span class="hljs-number">2</span>`',wrap:!1}}),he=new b({}),pe=new b({}),me=new Le({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># Tokenizing input text</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># Masking one of the input tokens</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># Creating a dummy input</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># Initializing the model with the torchscript flag</span>
<span class="hljs-comment"># Flag set to True even though it is not necessary as this model does not have an LM Head.</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># Instantiating the model</span>
model = BertModel(config)

<span class="hljs-comment"># The model needs to be in evaluation mode</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># If you are instantiating the model with *from_pretrained* you can also easily set the TorchScript flag</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Creating the trace</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`,wrap:!1}}),ue=new b({}),we=new Le({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`,wrap:!1}}),ve=new b({}),Me=new Le({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)",wrap:!1}}),be=new b({}),Ce=new b({}),je=new b({}),Je=new b({}),$e=new Le({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`,wrap:!1}}),We=new Le({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`,wrap:!1}}),{c(){y=s("meta"),G=a(),M=s("p"),Be=a(),g=s("h1"),S=s("a"),Fe=s("span"),d(P.$$.fragment),hn=a(),Ne=s("span"),Ne.textContent=bn,rt=a(),d(Z.$$.fragment),it=a(),X=s("p"),X.innerHTML=gn,ht=a(),L=s("blockquote"),L.innerHTML=Tn,ct=a(),F=s("p"),F.innerHTML=Cn,pt=a(),Y=s("p"),Y.textContent=Un,dt=a(),q=s("p"),q.textContent=jn,mt=a(),D=s("ul"),D.innerHTML=_n,ut=a(),K=s("p"),K.textContent=Jn,ft=a(),T=s("h2"),E=s("a"),Ye=s("span"),d(O.$$.fragment),cn=a(),He=s("span"),He.textContent=xn,wt=a(),ee=s("p"),ee.innerHTML=$n,vt=a(),te=s("p"),te.innerHTML=kn,yt=a(),ne=s("p"),ne.innerHTML=Wn,Mt=a(),C=s("h2"),B=s("a"),qe=s("span"),d(le.$$.fragment),pn=a(),Ie=s("span"),Ie.textContent=Sn,bt=a(),se=s("p"),se.innerHTML=Zn,gt=a(),oe=s("p"),oe.textContent=En,Tt=a(),d(ae.$$.fragment),Ct=a(),re=s("p"),re.textContent=Bn,Ut=a(),ie=s("p"),ie.textContent=Nn,jt=a(),U=s("h2"),N=s("a"),De=s("span"),d(he.$$.fragment),dn=a(),Ae=s("span"),Ae.textContent=Hn,_t=a(),ce=s("p"),ce.textContent=In,Jt=a(),j=s("h3"),H=s("a"),Ke=s("span"),d(pe.$$.fragment),mn=a(),ze=s("span"),ze.textContent=An,xt=a(),de=s("p"),de.innerHTML=zn,$t=a(),d(me.$$.fragment),kt=a(),_=s("h3"),I=s("a"),Oe=s("span"),d(ue.$$.fragment),un=a(),Re=s("span"),Re.textContent=Rn,Wt=a(),fe=s("p"),fe.innerHTML=Qn,St=a(),d(we.$$.fragment),Zt=a(),J=s("h3"),A=s("a"),et=s("span"),d(ve.$$.fragment),fn=a(),Qe=s("span"),Qe.textContent=Vn,Et=a(),ye=s("p"),ye.innerHTML=Gn,Bt=a(),d(Me.$$.fragment),Nt=a(),x=s("h2"),z=s("a"),tt=s("span"),d(be.$$.fragment),wn=a(),Ve=s("span"),Ve.textContent=Pn,Ht=a(),ge=s("p"),ge.innerHTML=Xn,It=a(),Te=s("ol"),Te.innerHTML=Ln,At=a(),$=s("h3"),R=s("a"),nt=s("span"),d(Ce.$$.fragment),vn=a(),Ge=s("span"),Ge.textContent=Fn,zt=a(),Ue=s("p"),Ue.innerHTML=Yn,Rt=a(),k=s("h3"),Q=s("a"),lt=s("span"),d(je.$$.fragment),yn=a(),Pe=s("span"),Pe.textContent=qn,Qt=a(),_e=s("p"),_e.innerHTML=Dn,Vt=a(),W=s("h3"),V=s("a"),st=s("span"),d(Je.$$.fragment),Mn=a(),Xe=s("span"),Xe.textContent=Kn,Gt=a(),xe=s("p"),xe.innerHTML=On,Pt=a(),d($e.$$.fragment),Xt=a(),ke=s("p"),ke.textContent=el,Lt=a(),d(We.$$.fragment),Ft=a(),Se=s("p"),Se.textContent=tl,Yt=a(),Ze=s("p"),Ze.innerHTML=nl,qt=a(),ot=s("p"),this.h()},l(e){const n=kl("svelte-1phssyn",document.head);y=o(n,"META",{name:!0,content:!0}),n.forEach(t),G=r(e),M=o(e,"P",{}),p(M).forEach(t),Be=r(e),g=o(e,"H1",{class:!0});var Ee=p(g);S=o(Ee,"A",{id:!0,class:!0,href:!0});var ll=p(S);Fe=o(ll,"SPAN",{});var sl=p(Fe);m(P.$$.fragment,sl),sl.forEach(t),ll.forEach(t),hn=r(Ee),Ne=o(Ee,"SPAN",{"data-svelte-h":!0}),c(Ne)!=="svelte-hiig1"&&(Ne.textContent=bn),Ee.forEach(t),rt=r(e),m(Z.$$.fragment,e),it=r(e),X=o(e,"P",{"data-svelte-h":!0}),c(X)!=="svelte-16vv52d"&&(X.innerHTML=gn),ht=r(e),L=o(e,"BLOCKQUOTE",{"data-svelte-h":!0}),c(L)!=="svelte-143rw8d"&&(L.innerHTML=Tn),ct=r(e),F=o(e,"P",{"data-svelte-h":!0}),c(F)!=="svelte-1ntf3wg"&&(F.innerHTML=Cn),pt=r(e),Y=o(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-3e4o7k"&&(Y.textContent=Un),dt=r(e),q=o(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1mmf9kh"&&(q.textContent=jn),mt=r(e),D=o(e,"UL",{"data-svelte-h":!0}),c(D)!=="svelte-1yusujd"&&(D.innerHTML=_n),ut=r(e),K=o(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-9awfof"&&(K.textContent=Jn),ft=r(e),T=o(e,"H2",{class:!0});var Kt=p(T);E=o(Kt,"A",{id:!0,class:!0,href:!0});var ol=p(E);Ye=o(ol,"SPAN",{});var al=p(Ye);m(O.$$.fragment,al),al.forEach(t),ol.forEach(t),cn=r(Kt),He=o(Kt,"SPAN",{"data-svelte-h":!0}),c(He)!=="svelte-18haoy0"&&(He.textContent=xn),Kt.forEach(t),wt=r(e),ee=o(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-qq8y9a"&&(ee.innerHTML=$n),vt=r(e),te=o(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-rijh7h"&&(te.innerHTML=kn),yt=r(e),ne=o(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1cg0vrq"&&(ne.innerHTML=Wn),Mt=r(e),C=o(e,"H2",{class:!0});var Ot=p(C);B=o(Ot,"A",{id:!0,class:!0,href:!0});var rl=p(B);qe=o(rl,"SPAN",{});var il=p(qe);m(le.$$.fragment,il),il.forEach(t),rl.forEach(t),pn=r(Ot),Ie=o(Ot,"SPAN",{"data-svelte-h":!0}),c(Ie)!=="svelte-m7jzl7"&&(Ie.textContent=Sn),Ot.forEach(t),bt=r(e),se=o(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1an8gt1"&&(se.innerHTML=Zn),gt=r(e),oe=o(e,"P",{"data-svelte-h":!0}),c(oe)!=="svelte-1pagcqs"&&(oe.textContent=En),Tt=r(e),m(ae.$$.fragment,e),Ct=r(e),re=o(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-e7h40q"&&(re.textContent=Bn),Ut=r(e),ie=o(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-k3vdvp"&&(ie.textContent=Nn),jt=r(e),U=o(e,"H2",{class:!0});var en=p(U);N=o(en,"A",{id:!0,class:!0,href:!0});var hl=p(N);De=o(hl,"SPAN",{});var cl=p(De);m(he.$$.fragment,cl),cl.forEach(t),hl.forEach(t),dn=r(en),Ae=o(en,"SPAN",{"data-svelte-h":!0}),c(Ae)!=="svelte-12vv4ph"&&(Ae.textContent=Hn),en.forEach(t),_t=r(e),ce=o(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-3ddxtn"&&(ce.textContent=In),Jt=r(e),j=o(e,"H3",{class:!0});var tn=p(j);H=o(tn,"A",{id:!0,class:!0,href:!0});var pl=p(H);Ke=o(pl,"SPAN",{});var dl=p(Ke);m(pe.$$.fragment,dl),dl.forEach(t),pl.forEach(t),mn=r(tn),ze=o(tn,"SPAN",{"data-svelte-h":!0}),c(ze)!=="svelte-7xntcd"&&(ze.textContent=An),tn.forEach(t),xt=r(e),de=o(e,"P",{"data-svelte-h":!0}),c(de)!=="svelte-1y405n0"&&(de.innerHTML=zn),$t=r(e),m(me.$$.fragment,e),kt=r(e),_=o(e,"H3",{class:!0});var nn=p(_);I=o(nn,"A",{id:!0,class:!0,href:!0});var ml=p(I);Oe=o(ml,"SPAN",{});var ul=p(Oe);m(ue.$$.fragment,ul),ul.forEach(t),ml.forEach(t),un=r(nn),Re=o(nn,"SPAN",{"data-svelte-h":!0}),c(Re)!=="svelte-19dtfgd"&&(Re.textContent=Rn),nn.forEach(t),Wt=r(e),fe=o(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-uqg1ob"&&(fe.innerHTML=Qn),St=r(e),m(we.$$.fragment,e),Zt=r(e),J=o(e,"H3",{class:!0});var ln=p(J);A=o(ln,"A",{id:!0,class:!0,href:!0});var fl=p(A);et=o(fl,"SPAN",{});var wl=p(et);m(ve.$$.fragment,wl),wl.forEach(t),fl.forEach(t),fn=r(ln),Qe=o(ln,"SPAN",{"data-svelte-h":!0}),c(Qe)!=="svelte-j5uvaw"&&(Qe.textContent=Vn),ln.forEach(t),Et=r(e),ye=o(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-1prvnq1"&&(ye.innerHTML=Gn),Bt=r(e),m(Me.$$.fragment,e),Nt=r(e),x=o(e,"H2",{class:!0});var sn=p(x);z=o(sn,"A",{id:!0,class:!0,href:!0});var vl=p(z);tt=o(vl,"SPAN",{});var yl=p(tt);m(be.$$.fragment,yl),yl.forEach(t),vl.forEach(t),wn=r(sn),Ve=o(sn,"SPAN",{"data-svelte-h":!0}),c(Ve)!=="svelte-7k7lsv"&&(Ve.textContent=Pn),sn.forEach(t),Ht=r(e),ge=o(e,"P",{"data-svelte-h":!0}),c(ge)!=="svelte-1kac3or"&&(ge.innerHTML=Xn),It=r(e),Te=o(e,"OL",{"data-svelte-h":!0}),c(Te)!=="svelte-1h435mi"&&(Te.innerHTML=Ln),At=r(e),$=o(e,"H3",{class:!0});var on=p($);R=o(on,"A",{id:!0,class:!0,href:!0});var Ml=p(R);nt=o(Ml,"SPAN",{});var bl=p(nt);m(Ce.$$.fragment,bl),bl.forEach(t),Ml.forEach(t),vn=r(on),Ge=o(on,"SPAN",{"data-svelte-h":!0}),c(Ge)!=="svelte-1u703xx"&&(Ge.textContent=Fn),on.forEach(t),zt=r(e),Ue=o(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-1kv7oct"&&(Ue.innerHTML=Yn),Rt=r(e),k=o(e,"H3",{class:!0});var an=p(k);Q=o(an,"A",{id:!0,class:!0,href:!0});var gl=p(Q);lt=o(gl,"SPAN",{});var Tl=p(lt);m(je.$$.fragment,Tl),Tl.forEach(t),gl.forEach(t),yn=r(an),Pe=o(an,"SPAN",{"data-svelte-h":!0}),c(Pe)!=="svelte-nqbpje"&&(Pe.textContent=qn),an.forEach(t),Qt=r(e),_e=o(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-f2qubg"&&(_e.innerHTML=Dn),Vt=r(e),W=o(e,"H3",{class:!0});var rn=p(W);V=o(rn,"A",{id:!0,class:!0,href:!0});var Cl=p(V);st=o(Cl,"SPAN",{});var Ul=p(st);m(Je.$$.fragment,Ul),Ul.forEach(t),Cl.forEach(t),Mn=r(rn),Xe=o(rn,"SPAN",{"data-svelte-h":!0}),c(Xe)!=="svelte-yczb1v"&&(Xe.textContent=Kn),rn.forEach(t),Gt=r(e),xe=o(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1flzoza"&&(xe.innerHTML=On),Pt=r(e),m($e.$$.fragment,e),Xt=r(e),ke=o(e,"P",{"data-svelte-h":!0}),c(ke)!=="svelte-uv51ic"&&(ke.textContent=el),Lt=r(e),m(We.$$.fragment,e),Ft=r(e),Se=o(e,"P",{"data-svelte-h":!0}),c(Se)!=="svelte-1dylit2"&&(Se.textContent=tl),Yt=r(e),Ze=o(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-u8nslf"&&(Ze.innerHTML=nl),qt=r(e),ot=o(e,"P",{}),p(ot).forEach(t),this.h()},h(){i(y,"name","hf:doc:metadata"),i(y,"content",JSON.stringify(El)),i(S,"id","export-to-torchscript"),i(S,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(S,"href","#export-to-torchscript"),i(g,"class","relative group"),i(E,"id","torchscript-flag-and-tied-weights"),i(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(E,"href","#torchscript-flag-and-tied-weights"),i(T,"class","relative group"),i(B,"id","dummy-inputs-and-standard-lengths"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#dummy-inputs-and-standard-lengths"),i(C,"class","relative group"),i(N,"id","using-torchscript-in-python"),i(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(N,"href","#using-torchscript-in-python"),i(U,"class","relative group"),i(H,"id","saving-a-model"),i(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(H,"href","#saving-a-model"),i(j,"class","relative group"),i(I,"id","loading-a-model"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#loading-a-model"),i(_,"class","relative group"),i(A,"id","using-a-traced-model-for-inference"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#using-a-traced-model-for-inference"),i(J,"class","relative group"),i(z,"id","deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk"),i(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(z,"href","#deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk"),i(x,"class","relative group"),i(R,"id","implications"),i(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(R,"href","#implications"),i($,"class","relative group"),i(Q,"id","dependencies"),i(Q,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(Q,"href","#dependencies"),i(k,"class","relative group"),i(V,"id","converting-a-model-for-aws-neuron"),i(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(V,"href","#converting-a-model-for-aws-neuron"),i(W,"class","relative group")},m(e,n){h(document.head,y),l(e,G,n),l(e,M,n),l(e,Be,n),l(e,g,n),h(g,S),h(S,Fe),u(P,Fe,null),h(g,hn),h(g,Ne),l(e,rt,n),u(Z,e,n),l(e,it,n),l(e,X,n),l(e,ht,n),l(e,L,n),l(e,ct,n),l(e,F,n),l(e,pt,n),l(e,Y,n),l(e,dt,n),l(e,q,n),l(e,mt,n),l(e,D,n),l(e,ut,n),l(e,K,n),l(e,ft,n),l(e,T,n),h(T,E),h(E,Ye),u(O,Ye,null),h(T,cn),h(T,He),l(e,wt,n),l(e,ee,n),l(e,vt,n),l(e,te,n),l(e,yt,n),l(e,ne,n),l(e,Mt,n),l(e,C,n),h(C,B),h(B,qe),u(le,qe,null),h(C,pn),h(C,Ie),l(e,bt,n),l(e,se,n),l(e,gt,n),l(e,oe,n),l(e,Tt,n),u(ae,e,n),l(e,Ct,n),l(e,re,n),l(e,Ut,n),l(e,ie,n),l(e,jt,n),l(e,U,n),h(U,N),h(N,De),u(he,De,null),h(U,dn),h(U,Ae),l(e,_t,n),l(e,ce,n),l(e,Jt,n),l(e,j,n),h(j,H),h(H,Ke),u(pe,Ke,null),h(j,mn),h(j,ze),l(e,xt,n),l(e,de,n),l(e,$t,n),u(me,e,n),l(e,kt,n),l(e,_,n),h(_,I),h(I,Oe),u(ue,Oe,null),h(_,un),h(_,Re),l(e,Wt,n),l(e,fe,n),l(e,St,n),u(we,e,n),l(e,Zt,n),l(e,J,n),h(J,A),h(A,et),u(ve,et,null),h(J,fn),h(J,Qe),l(e,Et,n),l(e,ye,n),l(e,Bt,n),u(Me,e,n),l(e,Nt,n),l(e,x,n),h(x,z),h(z,tt),u(be,tt,null),h(x,wn),h(x,Ve),l(e,Ht,n),l(e,ge,n),l(e,It,n),l(e,Te,n),l(e,At,n),l(e,$,n),h($,R),h(R,nt),u(Ce,nt,null),h($,vn),h($,Ge),l(e,zt,n),l(e,Ue,n),l(e,Rt,n),l(e,k,n),h(k,Q),h(Q,lt),u(je,lt,null),h(k,yn),h(k,Pe),l(e,Qt,n),l(e,_e,n),l(e,Vt,n),l(e,W,n),h(W,V),h(V,st),u(Je,st,null),h(W,Mn),h(W,Xe),l(e,Gt,n),l(e,xe,n),l(e,Pt,n),u($e,e,n),l(e,Xt,n),l(e,ke,n),l(e,Lt,n),u(We,e,n),l(e,Ft,n),l(e,Se,n),l(e,Yt,n),l(e,Ze,n),l(e,qt,n),l(e,ot,n),Dt=!0},p(e,[n]){const Ee={};n&2&&(Ee.$$scope={dirty:n,ctx:e}),Z.$set(Ee)},i(e){Dt||(f(P.$$.fragment,e),f(Z.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),f(ae.$$.fragment,e),f(he.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(we.$$.fragment,e),f(ve.$$.fragment,e),f(Me.$$.fragment,e),f(be.$$.fragment,e),f(Ce.$$.fragment,e),f(je.$$.fragment,e),f(Je.$$.fragment,e),f($e.$$.fragment,e),f(We.$$.fragment,e),Dt=!0)},o(e){w(P.$$.fragment,e),w(Z.$$.fragment,e),w(O.$$.fragment,e),w(le.$$.fragment,e),w(ae.$$.fragment,e),w(he.$$.fragment,e),w(pe.$$.fragment,e),w(me.$$.fragment,e),w(ue.$$.fragment,e),w(we.$$.fragment,e),w(ve.$$.fragment,e),w(Me.$$.fragment,e),w(be.$$.fragment,e),w(Ce.$$.fragment,e),w(je.$$.fragment,e),w(Je.$$.fragment,e),w($e.$$.fragment,e),w(We.$$.fragment,e),Dt=!1},d(e){e&&(t(G),t(M),t(Be),t(g),t(rt),t(it),t(X),t(ht),t(L),t(ct),t(F),t(pt),t(Y),t(dt),t(q),t(mt),t(D),t(ut),t(K),t(ft),t(T),t(wt),t(ee),t(vt),t(te),t(yt),t(ne),t(Mt),t(C),t(bt),t(se),t(gt),t(oe),t(Tt),t(Ct),t(re),t(Ut),t(ie),t(jt),t(U),t(_t),t(ce),t(Jt),t(j),t(xt),t(de),t($t),t(kt),t(_),t(Wt),t(fe),t(St),t(Zt),t(J),t(Et),t(ye),t(Bt),t(Nt),t(x),t(Ht),t(ge),t(It),t(Te),t(At),t($),t(zt),t(Ue),t(Rt),t(k),t(Qt),t(_e),t(Vt),t(W),t(Gt),t(xe),t(Pt),t(Xt),t(ke),t(Lt),t(Ft),t(Se),t(Yt),t(Ze),t(qt),t(ot)),t(y),v(P),v(Z,e),v(O),v(le),v(ae,e),v(he),v(pe),v(me,e),v(ue),v(we,e),v(ve),v(Me,e),v(be),v(Ce),v(je),v(Je),v($e,e),v(We,e)}}}const El={local:"export-to-torchscript",sections:[{local:"torchscript-flag-and-tied-weights",title:"TorchScript flag and tied weights"},{local:"dummy-inputs-and-standard-lengths",title:"Dummy inputs and standard lengths"},{local:"using-torchscript-in-python",sections:[{local:"saving-a-model",title:"Saving a model"},{local:"loading-a-model",title:"Loading a model"},{local:"using-a-traced-model-for-inference",title:"Using a traced model for inference"}],title:"Using TorchScript in Python"},{local:"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk",sections:[{local:"implications",title:"Implications"},{local:"dependencies",title:"Dependencies"},{local:"converting-a-model-for-aws-neuron",title:"Converting a model for AWS Neuron"}],title:"Deploy Hugging Face TorchScript models to AWS with the Neuron SDK"}],title:"Export to TorchScript"};function Bl(at){return _l(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rl extends xl{constructor(y){super(),$l(this,y,Bl,Zl,jl,{})}}export{Rl as component};
