import{s as vp,o as gp,n as yr}from"../chunks/scheduler.9bc65507.js";import{S as yp,i as wp,g as o,s,u,A as _p,h as l,f as t,c as i,j as h,v as m,y as p,k as d,o as r,a,w as c,d as f,t as b,x as v,m as $p,n as Mp}from"../chunks/index.78c82d43.js";import{T as ki}from"../chunks/Tip.87d55b76.js";import{D as ra}from"../chunks/Docstring.4e7352e2.js";import{C as _}from"../chunks/CodeBlock.73e038be.js";import{I as y}from"../chunks/IconCopyLink.bedaa44d.js";function Tp(k){let g;return{c(){g=$p("GPTQ quantization only works for text model for now. Futhermore, the quantization process can a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the hub if there is not a GPTQ quantized version of the model. If not, you can submit a demand on github.")},l(M){g=Mp(M,"GPTQ quantization only works for text model for now. Futhermore, the quantization process can a lot of time depending on one's hardware (175B model = 4 gpu hours using NVIDIA A100). Please check on the hub if there is not a GPTQ quantized version of the model. If not, you can submit a demand on github.")},m(M,w){a(M,g,w)},d(M){M&&t(g)}}}function Cp(k){let g,M="Note that once a model has been loaded in 4-bit it is currently not possible to push the quantized weights on the Hub. Note also that you cannot train 4-bit weights as this is not supported yet. However you can use 4-bit models to train extra parameters, this will be covered in the next section.";return{c(){g=o("p"),g.textContent=M},l(w){g=l(w,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1173kmw"&&(g.textContent=M)},m(w,x){a(w,g,x)},p:yr,d(w){w&&t(g)}}}function kp(k){let g,M=`Note that once a model has been loaded in 8-bit it is currently not possible to push the quantized weights on the Hub except if you use the latest <code>transformers</code> and <code>bitsandbytes</code>. Note also that you cannot train 8-bit weights as this is not supported yet. However you can use 8-bit models to train extra parameters, this will be covered in the next section.
Note also that <code>device_map</code> is optional but setting <code>device_map = &#39;auto&#39;</code> is prefered for inference as it will dispatch efficiently the model on the available ressources.`;return{c(){g=o("p"),g.innerHTML=M},l(w){g=l(w,"P",{"data-svelte-h":!0}),p(g)!=="svelte-17mr1dr"&&(g.innerHTML=M)},m(w,x){a(w,g,x)},p:yr,d(w){w&&t(g)}}}function xp(k){let g,M="Pushing 8bit models on the Hub is strongely encouraged for large models. This will allow the community to benefit from the memory footprint reduction and loading for example large models on a Google Colab.";return{c(){g=o("p"),g.textContent=M},l(w){g=l(w,"P",{"data-svelte-h":!0}),p(g)!=="svelte-1bu8wqo"&&(g.textContent=M)},m(w,x){a(w,g,x)},p:yr,d(w){w&&t(g)}}}function Jp(k){let g,M,w,x,J,se,Da,Re,xi,da,wr="Quantize 🤗 Transformers models",Uo,q,ie,Ka,Ie,Ji,ha,_r="<code>AutoGPTQ</code> Integration",jo,Ye,$r="🤗 Transformers has integrated <code>optimum</code> API to perform GPTQ quantization on language models. You can load and quantize your model in 8, 4, 3 or even 2 bits without a big drop of performance and faster inference speed! This is supported by most GPU hardwares.",No,Se,Mr="To learn more about the the quantization model, check out:",Ao,De,Tr='<li>the <a href="https://arxiv.org/pdf/2210.17323.pdf" rel="nofollow">GPTQ</a> paper</li> <li>the <code>optimum</code> <a href="https://huggingface.co/docs/optimum/llm_quantization/usage_guides/quantization" rel="nofollow">guide</a> on GPTQ quantization</li> <li>the <a href="https://github.com/PanQiWei/AutoGPTQ" rel="nofollow"><code>AutoGPTQ</code></a> library used as the backend</li>',Eo,z,re,Oa,Ke,qi,pa,Cr="Requirements",Go,Oe,kr="You need to have the following requirements installed to run the code below:",Ho,et,xr=`<li><p>Install latest <code>AutoGPTQ</code> library
<code>pip install auto-gptq</code></p></li> <li><p>Install latest <code>optimum</code> from source
<code>pip install git+https://github.com/huggingface/optimum.git</code></p></li> <li><p>Install latest <code>transformers</code> from source
<code>pip install git+https://github.com/huggingface/transformers.git</code></p></li> <li><p>Install latest <code>accelerate</code> library
<code>pip install --upgrade accelerate</code></p></li>`,Bo,tt,Jr="Note that GPTQ integration supports for now only text models and you may encounter unexpected behaviour for vision, speech or multi-modal models.",Po,W,de,eo,nt,zi,ua,qr="Load and quantize a model",Qo,at,zr="GPTQ is a quantization method that requires weights calibration before using the quantized models. If you want to quantize transformers model from scratch, it might take some time before producing the quantized model (~5 min on a Google colab for <code>facebook/opt-350m</code> model).",Xo,ot,Wr="Hence, there are two different scenarios where you want to use GPTQ-quantized models. The first use case would be to load models that has been already quantized by other users that are available on the Hub, the second use case would be to quantize your model from scratch and save it or push it on the Hub so that other users can also use it.",Lo,Z,he,to,lt,Wi,ma,Zr="GPTQ Configuration",Vo,st,Ur='In order to load and quantize a model, you need to create a <a href="/docs/transformers/v4.34.0/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a>. You need to pass the number of <code>bits</code>, a <code>dataset</code> in order to calibrate the quantization and the <code>tokenizer</code> of the model in order prepare the dataset.',Fo,it,Ro,rt,jr="Note that you can pass your own dataset as a list of string. However, it is highly recommended to use the dataset from the GPTQ paper.",Io,dt,Yo,U,pe,no,ht,Zi,ca,Nr="Quantization",So,pt,Ar="You can quantize a model by using <code>from_pretrained</code> and setting the <code>quantization_config</code>.",Do,ut,Ko,mt,Er="Note that you will need a GPU to quantize a model. We will put the model in the cpu and move the modules back and forth to the gpu in order to quantize them.",Oo,ct,Gr="If you want to maximize your gpus usage while using cpu offload, you can set <code>device_map = &quot;auto&quot;</code>.",el,ft,tl,bt,Hr='Note that disk offload is not supported. Furthermore, if you are out of memory because of the dataset, you may have to pass <code>max_memory</code> in <code>from_pretained</code>. Checkout this <a href="https://huggingface.co/docs/accelerate/usage_guides/big_modeling#designing-a-device-map" rel="nofollow">guide</a> to learn more about <code>device_map</code> and <code>max_memory</code>.',nl,ue,al,j,me,ao,vt,Ui,fa,Br="Push quantized model to 🤗 Hub",ol,gt,Pr="You can push the quantized model like any 🤗 model to Hub with <code>push_to_hub</code>. The quantization config will be saved and pushed along the model.",ll,yt,sl,wt,Qr="If you want to save your quantized model on your local machine, you can also do it with <code>save_pretrained</code>:",il,_t,rl,$t,Xr="Note that if you have quantized your model with a <code>device_map</code>, make sure to move the entire model to one of your gpus or the <code>cpu</code> before saving it.",dl,Mt,hl,N,ce,oo,Tt,ji,ba,Lr="Load a quantized model from the 🤗 Hub",pl,Ct,Vr=`You can load a quantized model from the Hub by using <code>from_pretrained</code>.
Make sure that the pushed weights are quantized, by checking that the attribute <code>quantization_config</code> is present in the model configuration object.`,ul,kt,ml,xt,Fr="If you want to load a model faster and without allocating more memory than needed, the <code>device_map</code> argument also works with quantized model. Make sure that you have <code>accelerate</code> library installed.",cl,Jt,fl,A,fe,lo,qt,Ni,va,Rr="Exllama kernels for faster inference",bl,zt,Ir='For 4-bit model, you can use the exllama kernels in order to a faster inference speed. It is activated by default. You can change that behavior by passing <code>disable_exllama</code> in <a href="/docs/transformers/v4.34.0/en/main_classes/quantization#transformers.GPTQConfig">GPTQConfig</a>. This will overwrite the quantization config stored in the config. Note that you will only be able to overwrite the attributes related to the kernels. Furthermore, you need to have the entire model on gpus if you want to use exllama kernels.',vl,Wt,gl,Zt,Yr="Note that only 4-bit models are supported for now. Furthermore, it is recommended to deactivate the exllama kernels if you are finetuning a quantized model with peft.",yl,E,be,so,Ut,Ai,ga,Sr="Fine-tune a quantized model",wl,jt,Dr=`With the official support of adapters in the Hugging Face ecosystem, you can fine-tune models that have been quantized with GPTQ.
Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library for more details.`,_l,G,ve,io,Nt,Ei,ya,Kr="Example demo",$l,At,Or='Check out the Google Colab <a href="https://colab.research.google.com/drive/1_TIrmuKOFhuRRiTWN94iLKUFu6ZX4ceb?usp=sharing" rel="nofollow">notebook</a> to learn how to quantize your model with GPTQ and how finetune the quantized model with peft.',Ml,H,ge,ro,Et,Gi,wa,ed="GPTQConfig",Tl,C,Gt,Hi,_a,td=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>optimum</code> api for gptq quantization relying on auto_gptq backend.`,Bi,ye,Ht,Pi,$a,nd="Safety checker that arguments are correct",Cl,B,we,ho,Bt,Qi,Ma,ad="<code>bitsandbytes</code> Integration",kl,Pt,od=`🤗 Transformers is closely integrated with most used modules on <code>bitsandbytes</code>. You can load your model in 8-bit precision with few lines of code.
This is supported by most of the GPU hardwares since the <code>0.37.0</code> release of <code>bitsandbytes</code>.`,xl,Qt,ld='Learn more about the quantization method in the <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">LLM.int8()</a> paper, or the <a href="https://huggingface.co/blog/hf-bitsandbytes-integration" rel="nofollow">blogpost</a> about the collaboration.',Jl,Xt,sd="Since its <code>0.39.0</code> release, you can load any model that supports <code>device_map</code> using 4-bit quantization, leveraging FP4 data type.",ql,Lt,id='If you want to quantize your own pytorch model, check out this <a href="https://huggingface.co/docs/accelerate/main/en/usage_guides/quantization" rel="nofollow">documentation</a> from 🤗 Accelerate library.',zl,Vt,rd="Here are the things you can do using <code>bitsandbytes</code> integration",Wl,P,_e,po,Ft,Xi,Ta,dd="General usage",Zl,Rt,hd='You can quantize a model by using the <code>load_in_8bit</code> or <code>load_in_4bit</code> argument when calling the <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method as long as your model supports loading with 🤗 Accelerate and contains <code>torch.nn.Linear</code> layers. This should work for any modality as well.',Ul,It,jl,Yt,pd="By default all other modules (e.g. <code>torch.nn.LayerNorm</code>) will be converted in <code>torch.float16</code>, but if you want to change their <code>dtype</code> you can overwrite the <code>torch_dtype</code> argument:",Nl,St,Al,Q,$e,uo,Dt,Li,Ca,ud="FP4 quantization",El,X,Me,mo,Kt,Vi,ka,md="Requirements",Gl,Ot,cd="Make sure that you have installed the requirements below before running any of the code snippets below.",Hl,en,fd=`<li><p>Latest <code>bitsandbytes</code> library
<code>pip install bitsandbytes&gt;=0.39.0</code></p></li> <li><p>Install latest <code>accelerate</code> <code>pip install --upgrade accelerate</code></p></li> <li><p>Install latest <code>transformers</code> <code>pip install --upgrade transformers</code></p></li>`,Bl,L,Te,co,tn,Fi,xa,bd="Tips and best practices",Pl,nn,vd='<li><p><strong>Advanced usage:</strong> Refer to <a href="https://colab.research.google.com/drive/1ge2F1QSK8Q7h0hn3YKuBCOAS0bK8E0wf" rel="nofollow">this Google Colab notebook</a> for advanced usage of 4-bit quantization with all the possible options.</p></li> <li><p><strong>Faster inference with <code>batch_size=1</code> :</strong> Since the <code>0.40.0</code> release of bitsandbytes, for <code>batch_size=1</code> you can benefit from fast inference. Check out <a href="https://github.com/TimDettmers/bitsandbytes/releases/tag/0.40.0" rel="nofollow">these release notes</a> and make sure to have a version that is greater than <code>0.40.0</code> to benefit from this feature out of the box.</p></li> <li><p><strong>Training:</strong> According to <a href="https://arxiv.org/abs/2305.14314" rel="nofollow">QLoRA paper</a>, for training 4-bit base models (e.g. using LoRA adapters) one should use <code>bnb_4bit_quant_type=&#39;nf4&#39;</code>.</p></li> <li><p><strong>Inference:</strong> For inference, <code>bnb_4bit_quant_type</code> does not have a huge impact on the performance. However for consistency with the model’s weights, make sure you use the same <code>bnb_4bit_compute_dtype</code> and <code>torch_dtype</code> arguments.</p></li>',Ql,V,Ce,fo,an,Ri,Ja,gd="Load a large model in 4bit",Xl,on,yd="By using <code>load_in_4bit=True</code> when calling the <code>.from_pretrained</code> method, you can divide your memory use by 4 (roughly).",Ll,ln,Vl,ke,Fl,F,xe,bo,sn,Ii,qa,wd="Load a large model in 8bit",Rl,rn,_d="You can load a model by roughly halving the memory requirements by using <code>load_in_8bit=True</code> argument when calling <code>.from_pretrained</code> method",Il,dn,Yl,hn,$d='Then, use your model as you would usually use a <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',Sl,pn,Md="You can check the memory footprint of your model with <code>get_memory_footprint</code> method.",Dl,un,Kl,mn,Td="With this integration we were able to load large models on smaller devices and run them without any issue.",Ol,Je,es,R,qe,vo,cn,Yi,za,Cd="Advanced use cases",ts,fn,kd="Here we will cover some advanced use cases you can perform with FP4 quantization",ns,I,ze,go,bn,Si,Wa,xd="Change the compute dtype",as,vn,Jd="The compute dtype is used to change the dtype that will be used during computation. For example, hidden states could be in <code>float32</code> but computation can be set to bf16 for speedups. By default, the compute dtype is set to <code>float32</code>.",os,gn,ls,Y,We,yo,yn,Di,Za,qd="Using NF4 (Normal Float 4) data type",ss,wn,zd="You can also use the NF4 data type, which is a new 4bit datatype adapted for weights that have been initialized using a normal distribution. For that run:",is,_n,rs,S,Ze,wo,$n,Ki,Ua,Wd="Use nested quantization for more memory efficient inference",ds,Mn,Zd="We also advise users to use the nested quantization technique. This saves more memory at no additional performance - from our empirical observations, this enables fine-tuning llama-13b model on an NVIDIA-T4 16GB with a sequence length of 1024, batch size of 1 and gradient accumulation steps of 4.",hs,Tn,ps,D,Ue,_o,Cn,Oi,ja,Ud="Push quantized models on the 🤗 Hub",us,kn,jd=`You can push a quantized model on the Hub by naively using <code>push_to_hub</code> method. This will first push the quantization configuration file, then push the quantized model weights.
Make sure to use <code>bitsandbytes&gt;0.37.2</code> (at this time of writing, we tested it on <code>bitsandbytes==0.38.0.post1</code>) to be able to use this feature.`,ms,xn,cs,je,fs,K,Ne,$o,Jn,er,Na,Nd="Load a quantized model from the 🤗 Hub",bs,qn,Ad="You can load a quantized model from the Hub by using <code>from_pretrained</code> method. Make sure that the pushed weights are quantized, by checking that the attribute <code>quantization_config</code> is present in the model configuration object.",vs,zn,gs,Wn,Ed=`Note that in this case, you don’t need to specify the arguments <code>load_in_8bit=True</code>, but you need to make sure that <code>bitsandbytes</code> and <code>accelerate</code> are installed.
Note also that <code>device_map</code> is optional but setting <code>device_map = &#39;auto&#39;</code> is prefered for inference as it will dispatch efficiently the model on the available ressources.`,ys,O,Ae,Mo,Zn,tr,Aa,Gd="Advanced use cases",ws,Un,Hd="This section is intended to advanced users, that want to explore what it is possible to do beyond loading and running 8-bit models.",_s,ee,Ee,To,jn,nr,Ea,Bd="Offload between <code>cpu</code> and <code>gpu</code>",$s,Nn,Pd="One of the advanced use case of this is being able to load a model and dispatch the weights between <code>CPU</code> and <code>GPU</code>. Note that the weights that will be dispatched on CPU <strong>will not</strong> be converted in 8-bit, thus kept in <code>float32</code>. This feature is intended for users that want to fit a very large model and dispatch the model between GPU and CPU.",Ms,An,Qd='First, load a <a href="/docs/transformers/v4.34.0/en/main_classes/quantization#transformers.BitsAndBytesConfig">BitsAndBytesConfig</a> from <code>transformers</code> and set the attribute <code>llm_int8_enable_fp32_cpu_offload</code> to <code>True</code>:',Ts,En,Cs,Gn,Xd="Let’s say you want to load <code>bigscience/bloom-1b7</code> model, and you have just enough GPU RAM to fit the entire model except the <code>lm_head</code>. Therefore write a custom device_map as follows:",ks,Hn,xs,Bn,Ld="And load your model as follows:",Js,Pn,qs,Qn,Vd="And that’s it! Enjoy your model!",zs,te,Ge,Co,Xn,ar,Ga,Fd="Play with <code>llm_int8_threshold</code>",Ws,Ln,Rd=`You can play with the <code>llm_int8_threshold</code> argument to change the threshold of the outliers. An “outlier” is a hidden state value that is greater than a certain threshold.
This corresponds to the outlier threshold for outlier detection as described in <code>LLM.int8()</code> paper. Any hidden states value that is above this threshold will be considered an outlier and the operation on those values will be done in fp16. Values are usually normally distributed, that is, most values are in the range [-3.5, 3.5], but there are some exceptional systematic outliers that are very differently distributed for large models. These outliers are often in the interval [-60, -6] or [6, 60]. Int8 quantization works well for values of magnitude ~5, but beyond that, there is a significant performance penalty. A good default threshold is 6, but a lower threshold might be needed for more unstable models (small models, fine-tuning).
This argument can impact the inference speed of the model. We suggest to play with this parameter to find which one is the best for your use case.`,Zs,Vn,Us,ne,He,ko,Fn,or,Ha,Id="Skip the conversion of some modules",js,Rn,Yd="Some models has several modules that needs to be not converted in 8-bit to ensure stability. For example Jukebox model has several <code>lm_head</code> modules that should be skipped. Play with <code>llm_int8_skip_modules</code>",Ns,In,As,ae,Be,xo,Yn,lr,Ba,Sd="Fine-tune a model that has been loaded in 8-bit",Es,Sn,Dd=`With the official support of adapters in the Hugging Face ecosystem, you can fine-tune models that have been loaded in 8-bit.
This enables fine-tuning large models such as <code>flan-t5-large</code> or <code>facebook/opt-6.7b</code> in a single google Colab. Please have a look at <a href="https://github.com/huggingface/peft" rel="nofollow"><code>peft</code></a> library for more details.`,Gs,Dn,Kd="Note that you don’t need to pass <code>device_map</code> when loading the model for training. It will automatically load your model on your GPU. You can also set the device map to a specific device if needed (e.g. <code>cuda:0</code>, <code>0</code>, <code>torch.device(&#39;cuda:0&#39;)</code>). Please note that <code>device_map=auto</code> should be used for inference only.",Hs,oe,Pe,Jo,Kn,sr,Pa,Od="BitsAndBytesConfig",Bs,$,On,ir,Qa,eh=`This is a wrapper class about all possible attributes and features that you can play with a model that has been
loaded using <code>bitsandbytes</code>.`,rr,Xa,th="This replaces <code>load_in_8bit</code> or <code>load_in_4bit</code>therefore both options are mutually exclusive.",dr,La,nh=`Currently only supports <code>LLM.int8()</code>, <code>FP4</code>, and <code>NF4</code> quantization. If more methods are added to <code>bitsandbytes</code>,
then more arguments will be added to this class.`,hr,Qe,ea,pr,Va,ah="Returns <code>True</code> if the model is quantizable, <code>False</code> otherwise.",ur,Xe,ta,mr,Fa,oh="Safety checker that arguments are correct - also replaces some NoneType arguments with their default values.",cr,Le,na,fr,Ra,lh=`This method returns the quantization method used for the model. If the model is not quantizable, it returns
<code>None</code>.`,br,Ve,aa,vr,Ia,sh=`Removes all attributes from config which correspond to the default config attributes for better readability and
serializes to a Python dictionary.`,Ps,le,Fe,qo,oa,gr,Ya,ih="Quantization with 🤗 <code>optimum</code>",Qs,la,rh='Please have a look at <a href="https://huggingface.co/docs/optimum/index" rel="nofollow">Optimum documentation</a> to learn more about quantization methods that are supported by <code>optimum</code> and see if these are applicable for your use case.',Xs,zo,Ls;return Re=new y({}),Ie=new y({}),Ke=new y({}),nt=new y({}),lt=new y({}),it=new _({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJmYWNlYm9vayUyRm9wdC0xMjVtJTIyJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBZ3B0cV9jb25maWclMjAlM0QlMjBHUFRRQ29uZmlnKGJpdHMlM0Q0JTJDJTIwZGF0YXNldCUyMCUzRCUyMCUyMmM0JTIyJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`model_id = <span class="hljs-string">&quot;facebook/opt-125m&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset = <span class="hljs-string">&quot;c4&quot;</span>, tokenizer=tokenizer)`,wrap:!1}}),dt=new _({props:{code:"ZGF0YXNldCUyMCUzRCUyMCU1QiUyMmF1dG8tZ3B0cSUyMGlzJTIwYW4lMjBlYXN5LXRvLXVzZSUyMG1vZGVsJTIwcXVhbnRpemF0aW9uJTIwbGlicmFyeSUyMHdpdGglMjB1c2VyLWZyaWVuZGx5JTIwYXBpcyUyQyUyMGJhc2VkJTIwb24lMjBHUFRRJTIwYWxnb3JpdGhtLiUyMiU1RCUwQXF1YW50aXphdGlvbiUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBkYXRhc2V0JTIwJTNEJTIwZGF0YXNldCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplcik=",highlighted:`dataset = [<span class="hljs-string">&quot;auto-gptq is an easy-to-use model quantization library with user-friendly apis, based on GPTQ algorithm.&quot;</span>]
quantization = GPTQConfig(bits=<span class="hljs-number">4</span>, dataset = dataset, tokenizer=tokenizer)`,wrap:!1}}),ht=new y({}),ut=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEZ3B0cV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=gptq_config)`,wrap:!1}}),ft=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RncHRxX2NvbmZpZyk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config=gptq_config)`,wrap:!1}}),ue=new ki({props:{warning:!0,$$slots:{default:[Tp]},$$scope:{ctx:k}}}),vt=new y({}),yt=new _({props:{code:"cXVhbnRpemVkX21vZGVsLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIpJTBBdG9rZW5pemVyLnB1c2hfdG9faHViKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.push_to_hub(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),_t=new _({props:{code:"cXVhbnRpemVkX21vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJvcHQtMTI1bS1ncHRxJTIyKSUwQXRva2VuaXplci5zYXZlX3ByZXRyYWluZWQoJTIyb3B0LTEyNW0tZ3B0cSUyMik=",highlighted:`quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)
tokenizer.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),Mt=new _({props:{code:"cXVhbnRpemVkX21vZGVsLnRvKCUyMmNwdSUyMiklMEFxdWFudGl6ZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm9wdC0xMjVtLWdwdHElMjIp",highlighted:`quantized_model.to(<span class="hljs-string">&quot;cpu&quot;</span>)
quantized_model.save_pretrained(<span class="hljs-string">&quot;opt-125m-gptq&quot;</span>)`,wrap:!1}}),Tt=new y({}),kt=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRm9wdC0xMjVtLWdwdHElMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>)`,wrap:!1}}),Jt=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRm9wdC0xMjVtLWdwdHElMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),qt=new y({}),Wt=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFncHRxX2NvbmZpZyUyMCUzRCUyMEdQVFFDb25maWcoYml0cyUzRDQlMkMlMjBkaXNhYmxlX2V4bGxhbWElM0RGYWxzZSklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjIlN0J5b3VyX3VzZXJuYW1lJTdEJTJGb3B0LTEyNW0tZ3B0cSUyMiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMGdwdHFfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
gptq_config = GPTQConfig(bits=<span class="hljs-number">4</span>, disable_exllama=<span class="hljs-literal">False</span>)
model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/opt-125m-gptq&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, quantization_config = gptq_config)`,wrap:!1}}),Ut=new y({}),Nt=new y({}),Et=new y({}),Gt=new ra({props:{name:"class transformers.GPTQConfig",anchor:"transformers.GPTQConfig",parameters:[{name:"bits",val:": int"},{name:"tokenizer",val:": typing.Any = None"},{name:"dataset",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"group_size",val:": int = 128"},{name:"damp_percent",val:": float = 0.1"},{name:"desc_act",val:": bool = False"},{name:"sym",val:": bool = True"},{name:"true_sequential",val:": bool = True"},{name:"use_cuda_fp16",val:": bool = False"},{name:"model_seqlen",val:": typing.Optional[int] = None"},{name:"block_name_to_quantize",val:": typing.Optional[str] = None"},{name:"module_name_preceding_first_block",val:": typing.Optional[typing.List[str]] = None"},{name:"batch_size",val:": int = 1"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"disable_exllama",val:": bool = False"},{name:"max_input_length",val:": typing.Optional[int] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GPTQConfig.bits",description:`<strong>bits</strong> (<code>int</code>) &#x2014;
The number of bits to quantize to, supported numbers are (2, 3, 4, 8).`,name:"bits"},{anchor:"transformers.GPTQConfig.tokenizer",description:`<strong>tokenizer</strong> (<code>str</code> or <code>PreTrainedTokenizerBase</code>, <em>optional</em>) &#x2014;
The tokenizer used to process the dataset. You can pass either:<ul>
<li>A custom tokenizer object.</li>
<li>A string, the <em>model id</em> of a predefined tokenizer hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing vocabulary files required by the tokenizer, for instance saved
using the <a href="/docs/transformers/v4.34.0/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"tokenizer"},{anchor:"transformers.GPTQConfig.dataset",description:`<strong>dataset</strong> (<code>Union[List[str]]</code>, <em>optional</em>) &#x2014;
The dataset used for quantization. You can provide your own dataset in a list of string or just use the
original datasets used in GPTQ paper [&#x2018;wikitext2&#x2019;,&#x2018;c4&#x2019;,&#x2018;c4-new&#x2019;,&#x2018;ptb&#x2019;,&#x2018;ptb-new&#x2019;]`,name:"dataset"},{anchor:"transformers.GPTQConfig.group_size",description:`<strong>group_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The group size to use for quantization. Recommended value is 128 and -1 uses per-column quantization.`,name:"group_size"},{anchor:"transformers.GPTQConfig.damp_percent",description:`<strong>damp_percent</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The percent of the average Hessian diagonal to use for dampening. Recommended value is 0.1.`,name:"damp_percent"},{anchor:"transformers.GPTQConfig.desc_act",description:`<strong>desc_act</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to quantize columns in order of decreasing activation size. Setting it to False can significantly
speed up inference but the perplexity may become slightly worse. Also known as act-order.`,name:"desc_act"},{anchor:"transformers.GPTQConfig.sym",description:`<strong>sym</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use symetric quantization.`,name:"sym"},{anchor:"transformers.GPTQConfig.true_sequential",description:`<strong>true_sequential</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to perform sequential quantization even within a single Transformer block. Instead of quantizing
the entire block at once, we perform layer-wise quantization. As a result, each layer undergoes
quantization using inputs that have passed through the previously quantized layers.`,name:"true_sequential"},{anchor:"transformers.GPTQConfig.use_cuda_fp16",description:`<strong>use_cuda_fp16</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use optimized cuda kernel for fp16 model. Need to have model in fp16.`,name:"use_cuda_fp16"},{anchor:"transformers.GPTQConfig.model_seqlen",description:`<strong>model_seqlen</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum sequence length that the model can take.`,name:"model_seqlen"},{anchor:"transformers.GPTQConfig.block_name_to_quantize",description:`<strong>block_name_to_quantize</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The transformers block name to quantize.`,name:"block_name_to_quantize"},{anchor:"transformers.GPTQConfig.module_name_preceding_first_block",description:`<strong>module_name_preceding_first_block</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
The layers that are preceding the first Transformer block.`,name:"module_name_preceding_first_block"},{anchor:"transformers.GPTQConfig.batch_size",description:`<strong>batch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The batch size used when processing the dataset`,name:"batch_size"},{anchor:"transformers.GPTQConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The pad token id. Needed to prepare the dataset when <code>batch_size</code> &gt; 1.`,name:"pad_token_id"},{anchor:"transformers.GPTQConfig.disable_exllama",description:`<strong>disable_exllama</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use exllama backend. Only works with <code>bits</code> = 4.`,name:"disable_exllama"},{anchor:"transformers.GPTQConfig.max_input_length",description:`<strong>max_input_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum input length. This is needed to initialize a buffer that depends on the maximum expected input
length. It is specific to the exllama backend with act-order.`,name:"max_input_length"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L303"}}),Ht=new ra({props:{name:"post_init",anchor:"transformers.GPTQConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L399"}}),Bt=new y({}),Ft=new y({}),It=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyJTJDJTIwbG9hZF9pbl84Yml0JTNEVHJ1ZSklMEFtb2RlbF80Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzRiaXQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
model_4bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),St=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTM1MG0lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDMyKSUwQW1vZGVsXzhiaXQubW9kZWwuZGVjb2Rlci5sYXllcnMlNUItMSU1RC5maW5hbF9sYXllcl9ub3JtLndlaWdodC5kdHlwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model_8bit = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, torch_dtype=torch.float32)
<span class="hljs-meta">&gt;&gt;&gt; </span>model_8bit.model.decoder.layers[-<span class="hljs-number">1</span>].final_layer_norm.weight.dtype
torch.float32`,wrap:!1}}),Dt=new y({}),Kt=new y({}),tn=new y({}),an=new y({}),ln=new _({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUp",highlighted:`<span class="hljs-comment"># pip install transformers accelerate bitsandbytes</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),ke=new ki({props:{warning:!0,$$slots:{default:[Cp]},$$scope:{ctx:k}}}),sn=new y({}),dn=new _({props:{code:"JTIzJTIwcGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGFjY2VsZXJhdGUlMjBiaXRzYW5kYnl0ZXMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUp",highlighted:`<span class="hljs-comment"># pip install transformers accelerate bitsandbytes</span>
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)`,wrap:!1}}),un=new _({props:{code:"cHJpbnQobW9kZWwuZ2V0X21lbW9yeV9mb290cHJpbnQoKSk=",highlighted:'<span class="hljs-built_in">print</span>(model.get_memory_footprint())',wrap:!1}}),Je=new ki({props:{warning:!0,$$slots:{default:[kp]},$$scope:{ctx:k}}}),cn=new y({}),bn=new y({}),gn=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyhsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2KQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, bnb_4bit_compute_dtype=torch.bfloat16)`,wrap:!1}}),yn=new y({}),_n=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW5mNF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEEpJTBBJTBBbW9kZWxfbmY0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRG5mNF9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

nf4_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
)

model_nf4 = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=nf4_config)`,wrap:!1}}),$n=new y({}),Tn=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQWRvdWJsZV9xdWFudF9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3VzZV9kb3VibGVfcXVhbnQlM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsX2RvdWJsZV9xdWFudCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0Rkb3VibGVfcXVhbnRfY29uZmlnKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

double_quant_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_use_double_quant=<span class="hljs-literal">True</span>,
)

model_double_quant = AutoModelForCausalLM.from_pretrained(model_id, quantization_config=double_quant_config)`,wrap:!1}}),Cn=new y({}),xn=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBsb2FkX2luXzhiaXQlM0RUcnVlKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmJpZ3NjaWVuY2UlMkZibG9vbS01NjBtJTIyKSUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmJsb29tLTU2MG0tOGJpdCUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom-560m&quot;</span>)

model.push_to_hub(<span class="hljs-string">&quot;bloom-560m-8bit&quot;</span>)`,wrap:!1}}),je=new ki({props:{warning:!0,$$slots:{default:[xp]},$$scope:{ctx:k}}}),Jn=new y({}),zn=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMiU3QnlvdXJfdXNlcm5hbWUlN0QlMkZibG9vbS01NjBtLThiaXQlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;{your_username}/bloom-560m-8bit&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Zn=new y({}),jn=new y({}),En=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcobGxtX2ludDhfZW5hYmxlX2ZwMzJfY3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

quantization_config = BitsAndBytesConfig(llm_int8_enable_fp32_cpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),Hn=new _({props:{code:"ZGV2aWNlX21hcCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLndvcmRfZW1iZWRkaW5ncyUyMiUzQSUyMDAlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci53b3JkX2VtYmVkZGluZ3NfbGF5ZXJub3JtJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMmxtX2hlYWQlMjIlM0ElMjAlMjJjcHUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lci5oJTIyJTNBJTIwMCUyQyUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVyLmxuX2YlMjIlM0ElMjAwJTJDJTBBJTdE",highlighted:`device_map = {
    <span class="hljs-string">&quot;transformer.word_embeddings&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.word_embeddings_layernorm&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;lm_head&quot;</span>: <span class="hljs-string">&quot;cpu&quot;</span>,
    <span class="hljs-string">&quot;transformer.h&quot;</span>: <span class="hljs-number">0</span>,
    <span class="hljs-string">&quot;transformer.ln_f&quot;</span>: <span class="hljs-number">0</span>,
}`,wrap:!1}}),Pn=new _({props:{code:"bW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJiaWdzY2llbmNlJTJGYmxvb20tMWI3JTIyJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSk=",highlighted:`model_8bit = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>,
    device_map=device_map,
    quantization_config=quantization_config,
)`,wrap:!1}}),Xn=new y({}),Vn=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfdGhyZXNob2xkJTNEMTAlMkMlMEEpJTBBJTBBbW9kZWxfOGJpdCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMGRldmljZV9tYXAlM0RkZXZpY2VfbWFwJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEEpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_threshold=<span class="hljs-number">10</span>,
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=device_map,
    quantization_config=quantization_config,
)
tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),Fn=new y({}),In=new _({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyYmlnc2NpZW5jZSUyRmJsb29tLTFiNyUyMiUwQSUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbGxtX2ludDhfc2tpcF9tb2R1bGVzJTNEJTVCJTIybG1faGVhZCUyMiU1RCUyQyUwQSklMEElMEFtb2RlbF84Yml0JTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRGRldmljZV9tYXAlMkMlMEElMjAlMjAlMjAlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUwQSklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;bigscience/bloom-1b7&quot;</span>

quantization_config = BitsAndBytesConfig(
    llm_int8_skip_modules=[<span class="hljs-string">&quot;lm_head&quot;</span>],
)

model_8bit = AutoModelForCausalLM.from_pretrained(
    model_id,
    device_map=device_map,
    quantization_config=quantization_config,
)
tokenizer = AutoTokenizer.from_pretrained(model_id)`,wrap:!1}}),Yn=new y({}),Kn=new y({}),On=new ra({props:{name:"class transformers.BitsAndBytesConfig",anchor:"transformers.BitsAndBytesConfig",parameters:[{name:"load_in_8bit",val:" = False"},{name:"load_in_4bit",val:" = False"},{name:"llm_int8_threshold",val:" = 6.0"},{name:"llm_int8_skip_modules",val:" = None"},{name:"llm_int8_enable_fp32_cpu_offload",val:" = False"},{name:"llm_int8_has_fp16_weight",val:" = False"},{name:"bnb_4bit_compute_dtype",val:" = None"},{name:"bnb_4bit_quant_type",val:" = 'fp4'"},{name:"bnb_4bit_use_double_quant",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitsAndBytesConfig.load_in_8bit",description:`<strong>load_in_8bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used to enable 8-bit quantization with LLM.int8().`,name:"load_in_8bit"},{anchor:"transformers.BitsAndBytesConfig.load_in_4bit",description:`<strong>load_in_4bit</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used to enable 4-bit quantization by replacing the Linear layers with FP4/NF4 layers from
<code>bitsandbytes</code>.`,name:"load_in_4bit"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_threshold",description:`<strong>llm_int8_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 6) &#x2014;
This corresponds to the outlier threshold for outlier detection as described in <code>LLM.int8() : 8-bit Matrix Multiplication for Transformers at Scale</code> paper: <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">https://arxiv.org/abs/2208.07339</a> Any hidden states value
that is above this threshold will be considered an outlier and the operation on those values will be done
in fp16. Values are usually normally distributed, that is, most values are in the range [-3.5, 3.5], but
there are some exceptional systematic outliers that are very differently distributed for large models.
These outliers are often in the interval [-60, -6] or [6, 60]. Int8 quantization works well for values of
magnitude ~5, but beyond that, there is a significant performance penalty. A good default threshold is 6,
but a lower threshold might be needed for more unstable models (small models, fine-tuning).`,name:"llm_int8_threshold"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_skip_modules",description:`<strong>llm_int8_skip_modules</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
An explicit list of the modules that we do not want to convert in 8-bit. This is useful for models such as
Jukebox that has several heads in different places and not necessarily at the last position. For example
for <code>CausalLM</code> models, the last <code>lm_head</code> is kept in its original <code>dtype</code>.`,name:"llm_int8_skip_modules"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_enable_fp32_cpu_offload",description:`<strong>llm_int8_enable_fp32_cpu_offload</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used for advanced use cases and users that are aware of this feature. If you want to split
your model in different parts and run some parts in int8 on GPU and some parts in fp32 on CPU, you can use
this flag. This is useful for offloading large models such as <code>google/flan-t5-xxl</code>. Note that the int8
operations will not be run on CPU.`,name:"llm_int8_enable_fp32_cpu_offload"},{anchor:"transformers.BitsAndBytesConfig.llm_int8_has_fp16_weight",description:`<strong>llm_int8_has_fp16_weight</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag runs LLM.int8() with 16-bit main weights. This is useful for fine-tuning as the weights do not
have to be converted back and forth for the backward pass.`,name:"llm_int8_has_fp16_weight"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_compute_dtype",description:`<strong>bnb_4bit_compute_dtype</strong> (<code>torch.dtype</code> or str, <em>optional</em>, defaults to <code>torch.float32</code>) &#x2014;
This sets the computational type which might be different than the input time. For example, inputs might be
fp32, but computation can be set to bf16 for speedups.`,name:"bnb_4bit_compute_dtype"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_quant_type",description:`<strong>bnb_4bit_quant_type</strong> (<code>str</code>, {fp4, nf4}, defaults to <code>fp4</code>) &#x2014;
This sets the quantization data type in the bnb.nn.Linear4Bit layers. Options are FP4 and NF4 data types
which are specified by <code>fp4</code> or <code>nf4</code>.`,name:"bnb_4bit_quant_type"},{anchor:"transformers.BitsAndBytesConfig.bnb_4bit_use_double_quant",description:`<strong>bnb_4bit_use_double_quant</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
This flag is used for nested quantization where the quantization constants from the first quantization are
quantized again.`,name:"bnb_4bit_use_double_quant"},{anchor:"transformers.BitsAndBytesConfig.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional parameters from which to initialize the configuration object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L130"}}),ea=new ra({props:{name:"is_quantizable",anchor:"transformers.BitsAndBytesConfig.is_quantizable",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L245"}}),ta=new ra({props:{name:"post_init",anchor:"transformers.BitsAndBytesConfig.post_init",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L214"}}),na=new ra({props:{name:"quantization_method",anchor:"transformers.BitsAndBytesConfig.quantization_method",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L251"}}),aa=new ra({props:{name:"to_diff_dict",anchor:"transformers.BitsAndBytesConfig.to_diff_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/utils/quantization_config.py#L279",returnDescription:`
<p>Dictionary of all the attributes that make up this configuration instance,</p>
`,returnType:`
<p><code>Dict[str, Any]</code></p>
`}}),oa=new y({}),{c(){g=o("meta"),M=s(),w=o("p"),x=s(),J=o("h1"),se=o("a"),Da=o("span"),u(Re.$$.fragment),xi=s(),da=o("span"),da.textContent=wr,Uo=s(),q=o("h2"),ie=o("a"),Ka=o("span"),u(Ie.$$.fragment),Ji=s(),ha=o("span"),ha.innerHTML=_r,jo=s(),Ye=o("p"),Ye.innerHTML=$r,No=s(),Se=o("p"),Se.textContent=Mr,Ao=s(),De=o("ul"),De.innerHTML=Tr,Eo=s(),z=o("h3"),re=o("a"),Oa=o("span"),u(Ke.$$.fragment),qi=s(),pa=o("span"),pa.textContent=Cr,Go=s(),Oe=o("p"),Oe.textContent=kr,Ho=s(),et=o("ul"),et.innerHTML=xr,Bo=s(),tt=o("p"),tt.textContent=Jr,Po=s(),W=o("h3"),de=o("a"),eo=o("span"),u(nt.$$.fragment),zi=s(),ua=o("span"),ua.textContent=qr,Qo=s(),at=o("p"),at.innerHTML=zr,Xo=s(),ot=o("p"),ot.textContent=Wr,Lo=s(),Z=o("h4"),he=o("a"),to=o("span"),u(lt.$$.fragment),Wi=s(),ma=o("span"),ma.textContent=Zr,Vo=s(),st=o("p"),st.innerHTML=Ur,Fo=s(),u(it.$$.fragment),Ro=s(),rt=o("p"),rt.textContent=jr,Io=s(),u(dt.$$.fragment),Yo=s(),U=o("h4"),pe=o("a"),no=o("span"),u(ht.$$.fragment),Zi=s(),ca=o("span"),ca.textContent=Nr,So=s(),pt=o("p"),pt.innerHTML=Ar,Do=s(),u(ut.$$.fragment),Ko=s(),mt=o("p"),mt.textContent=Er,Oo=s(),ct=o("p"),ct.innerHTML=Gr,el=s(),u(ft.$$.fragment),tl=s(),bt=o("p"),bt.innerHTML=Hr,nl=s(),u(ue.$$.fragment),al=s(),j=o("h3"),me=o("a"),ao=o("span"),u(vt.$$.fragment),Ui=s(),fa=o("span"),fa.textContent=Br,ol=s(),gt=o("p"),gt.innerHTML=Pr,ll=s(),u(yt.$$.fragment),sl=s(),wt=o("p"),wt.innerHTML=Qr,il=s(),u(_t.$$.fragment),rl=s(),$t=o("p"),$t.innerHTML=Xr,dl=s(),u(Mt.$$.fragment),hl=s(),N=o("h3"),ce=o("a"),oo=o("span"),u(Tt.$$.fragment),ji=s(),ba=o("span"),ba.textContent=Lr,pl=s(),Ct=o("p"),Ct.innerHTML=Vr,ul=s(),u(kt.$$.fragment),ml=s(),xt=o("p"),xt.innerHTML=Fr,cl=s(),u(Jt.$$.fragment),fl=s(),A=o("h3"),fe=o("a"),lo=o("span"),u(qt.$$.fragment),Ni=s(),va=o("span"),va.textContent=Rr,bl=s(),zt=o("p"),zt.innerHTML=Ir,vl=s(),u(Wt.$$.fragment),gl=s(),Zt=o("p"),Zt.textContent=Yr,yl=s(),E=o("h4"),be=o("a"),so=o("span"),u(Ut.$$.fragment),Ai=s(),ga=o("span"),ga.textContent=Sr,wl=s(),jt=o("p"),jt.innerHTML=Dr,_l=s(),G=o("h3"),ve=o("a"),io=o("span"),u(Nt.$$.fragment),Ei=s(),ya=o("span"),ya.textContent=Kr,$l=s(),At=o("p"),At.innerHTML=Or,Ml=s(),H=o("h3"),ge=o("a"),ro=o("span"),u(Et.$$.fragment),Gi=s(),wa=o("span"),wa.textContent=ed,Tl=s(),C=o("div"),u(Gt.$$.fragment),Hi=s(),_a=o("p"),_a.innerHTML=td,Bi=s(),ye=o("div"),u(Ht.$$.fragment),Pi=s(),$a=o("p"),$a.textContent=nd,Cl=s(),B=o("h2"),we=o("a"),ho=o("span"),u(Bt.$$.fragment),Qi=s(),Ma=o("span"),Ma.innerHTML=ad,kl=s(),Pt=o("p"),Pt.innerHTML=od,xl=s(),Qt=o("p"),Qt.innerHTML=ld,Jl=s(),Xt=o("p"),Xt.innerHTML=sd,ql=s(),Lt=o("p"),Lt.innerHTML=id,zl=s(),Vt=o("p"),Vt.innerHTML=rd,Wl=s(),P=o("h3"),_e=o("a"),po=o("span"),u(Ft.$$.fragment),Xi=s(),Ta=o("span"),Ta.textContent=dd,Zl=s(),Rt=o("p"),Rt.innerHTML=hd,Ul=s(),u(It.$$.fragment),jl=s(),Yt=o("p"),Yt.innerHTML=pd,Nl=s(),u(St.$$.fragment),Al=s(),Q=o("h3"),$e=o("a"),uo=o("span"),u(Dt.$$.fragment),Li=s(),Ca=o("span"),Ca.textContent=ud,El=s(),X=o("h4"),Me=o("a"),mo=o("span"),u(Kt.$$.fragment),Vi=s(),ka=o("span"),ka.textContent=md,Gl=s(),Ot=o("p"),Ot.textContent=cd,Hl=s(),en=o("ul"),en.innerHTML=fd,Bl=s(),L=o("h4"),Te=o("a"),co=o("span"),u(tn.$$.fragment),Fi=s(),xa=o("span"),xa.textContent=bd,Pl=s(),nn=o("ul"),nn.innerHTML=vd,Ql=s(),V=o("h4"),Ce=o("a"),fo=o("span"),u(an.$$.fragment),Ri=s(),Ja=o("span"),Ja.textContent=gd,Xl=s(),on=o("p"),on.innerHTML=yd,Ll=s(),u(ln.$$.fragment),Vl=s(),u(ke.$$.fragment),Fl=s(),F=o("h3"),xe=o("a"),bo=o("span"),u(sn.$$.fragment),Ii=s(),qa=o("span"),qa.textContent=wd,Rl=s(),rn=o("p"),rn.innerHTML=_d,Il=s(),u(dn.$$.fragment),Yl=s(),hn=o("p"),hn.innerHTML=$d,Sl=s(),pn=o("p"),pn.innerHTML=Md,Dl=s(),u(un.$$.fragment),Kl=s(),mn=o("p"),mn.textContent=Td,Ol=s(),u(Je.$$.fragment),es=s(),R=o("h4"),qe=o("a"),vo=o("span"),u(cn.$$.fragment),Yi=s(),za=o("span"),za.textContent=Cd,ts=s(),fn=o("p"),fn.textContent=kd,ns=s(),I=o("h5"),ze=o("a"),go=o("span"),u(bn.$$.fragment),Si=s(),Wa=o("span"),Wa.textContent=xd,as=s(),vn=o("p"),vn.innerHTML=Jd,os=s(),u(gn.$$.fragment),ls=s(),Y=o("h5"),We=o("a"),yo=o("span"),u(yn.$$.fragment),Di=s(),Za=o("span"),Za.textContent=qd,ss=s(),wn=o("p"),wn.textContent=zd,is=s(),u(_n.$$.fragment),rs=s(),S=o("h5"),Ze=o("a"),wo=o("span"),u($n.$$.fragment),Ki=s(),Ua=o("span"),Ua.textContent=Wd,ds=s(),Mn=o("p"),Mn.textContent=Zd,hs=s(),u(Tn.$$.fragment),ps=s(),D=o("h3"),Ue=o("a"),_o=o("span"),u(Cn.$$.fragment),Oi=s(),ja=o("span"),ja.textContent=Ud,us=s(),kn=o("p"),kn.innerHTML=jd,ms=s(),u(xn.$$.fragment),cs=s(),u(je.$$.fragment),fs=s(),K=o("h3"),Ne=o("a"),$o=o("span"),u(Jn.$$.fragment),er=s(),Na=o("span"),Na.textContent=Nd,bs=s(),qn=o("p"),qn.innerHTML=Ad,vs=s(),u(zn.$$.fragment),gs=s(),Wn=o("p"),Wn.innerHTML=Ed,ys=s(),O=o("h3"),Ae=o("a"),Mo=o("span"),u(Zn.$$.fragment),tr=s(),Aa=o("span"),Aa.textContent=Gd,ws=s(),Un=o("p"),Un.textContent=Hd,_s=s(),ee=o("h4"),Ee=o("a"),To=o("span"),u(jn.$$.fragment),nr=s(),Ea=o("span"),Ea.innerHTML=Bd,$s=s(),Nn=o("p"),Nn.innerHTML=Pd,Ms=s(),An=o("p"),An.innerHTML=Qd,Ts=s(),u(En.$$.fragment),Cs=s(),Gn=o("p"),Gn.innerHTML=Xd,ks=s(),u(Hn.$$.fragment),xs=s(),Bn=o("p"),Bn.textContent=Ld,Js=s(),u(Pn.$$.fragment),qs=s(),Qn=o("p"),Qn.textContent=Vd,zs=s(),te=o("h4"),Ge=o("a"),Co=o("span"),u(Xn.$$.fragment),ar=s(),Ga=o("span"),Ga.innerHTML=Fd,Ws=s(),Ln=o("p"),Ln.innerHTML=Rd,Zs=s(),u(Vn.$$.fragment),Us=s(),ne=o("h4"),He=o("a"),ko=o("span"),u(Fn.$$.fragment),or=s(),Ha=o("span"),Ha.textContent=Id,js=s(),Rn=o("p"),Rn.innerHTML=Yd,Ns=s(),u(In.$$.fragment),As=s(),ae=o("h4"),Be=o("a"),xo=o("span"),u(Yn.$$.fragment),lr=s(),Ba=o("span"),Ba.textContent=Sd,Es=s(),Sn=o("p"),Sn.innerHTML=Dd,Gs=s(),Dn=o("p"),Dn.innerHTML=Kd,Hs=s(),oe=o("h3"),Pe=o("a"),Jo=o("span"),u(Kn.$$.fragment),sr=s(),Pa=o("span"),Pa.textContent=Od,Bs=s(),$=o("div"),u(On.$$.fragment),ir=s(),Qa=o("p"),Qa.innerHTML=eh,rr=s(),Xa=o("p"),Xa.innerHTML=th,dr=s(),La=o("p"),La.innerHTML=nh,hr=s(),Qe=o("div"),u(ea.$$.fragment),pr=s(),Va=o("p"),Va.innerHTML=ah,ur=s(),Xe=o("div"),u(ta.$$.fragment),mr=s(),Fa=o("p"),Fa.textContent=oh,cr=s(),Le=o("div"),u(na.$$.fragment),fr=s(),Ra=o("p"),Ra.innerHTML=lh,br=s(),Ve=o("div"),u(aa.$$.fragment),vr=s(),Ia=o("p"),Ia.textContent=sh,Ps=s(),le=o("h2"),Fe=o("a"),qo=o("span"),u(oa.$$.fragment),gr=s(),Ya=o("span"),Ya.innerHTML=ih,Qs=s(),la=o("p"),la.innerHTML=rh,Xs=s(),zo=o("p"),this.h()},l(e){const n=_p("svelte-1phssyn",document.head);g=l(n,"META",{name:!0,content:!0}),n.forEach(t),M=i(e),w=l(e,"P",{}),h(w).forEach(t),x=i(e),J=l(e,"H1",{class:!0});var sa=h(J);se=l(sa,"A",{id:!0,class:!0,href:!0});var Wo=h(se);Da=l(Wo,"SPAN",{});var Zo=h(Da);m(Re.$$.fragment,Zo),Zo.forEach(t),Wo.forEach(t),xi=i(sa),da=l(sa,"SPAN",{"data-svelte-h":!0}),p(da)!=="svelte-1ah0d8n"&&(da.textContent=wr),sa.forEach(t),Uo=i(e),q=l(e,"H2",{class:!0});var ia=h(q);ie=l(ia,"A",{id:!0,class:!0,href:!0});var dh=h(ie);Ka=l(dh,"SPAN",{});var hh=h(Ka);m(Ie.$$.fragment,hh),hh.forEach(t),dh.forEach(t),Ji=i(ia),ha=l(ia,"SPAN",{"data-svelte-h":!0}),p(ha)!=="svelte-1fmuneh"&&(ha.innerHTML=_r),ia.forEach(t),jo=i(e),Ye=l(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-wivdz5"&&(Ye.innerHTML=$r),No=i(e),Se=l(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-v9vpl3"&&(Se.textContent=Mr),Ao=i(e),De=l(e,"UL",{"data-svelte-h":!0}),p(De)!=="svelte-1hsfxwl"&&(De.innerHTML=Tr),Eo=i(e),z=l(e,"H3",{class:!0});var Vs=h(z);re=l(Vs,"A",{id:!0,class:!0,href:!0});var ph=h(re);Oa=l(ph,"SPAN",{});var uh=h(Oa);m(Ke.$$.fragment,uh),uh.forEach(t),ph.forEach(t),qi=i(Vs),pa=l(Vs,"SPAN",{"data-svelte-h":!0}),p(pa)!=="svelte-ypjn7h"&&(pa.textContent=Cr),Vs.forEach(t),Go=i(e),Oe=l(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1nlfwux"&&(Oe.textContent=kr),Ho=i(e),et=l(e,"UL",{"data-svelte-h":!0}),p(et)!=="svelte-1q0tak7"&&(et.innerHTML=xr),Bo=i(e),tt=l(e,"P",{"data-svelte-h":!0}),p(tt)!=="svelte-i9jsug"&&(tt.textContent=Jr),Po=i(e),W=l(e,"H3",{class:!0});var Fs=h(W);de=l(Fs,"A",{id:!0,class:!0,href:!0});var mh=h(de);eo=l(mh,"SPAN",{});var ch=h(eo);m(nt.$$.fragment,ch),ch.forEach(t),mh.forEach(t),zi=i(Fs),ua=l(Fs,"SPAN",{"data-svelte-h":!0}),p(ua)!=="svelte-o2a4fl"&&(ua.textContent=qr),Fs.forEach(t),Qo=i(e),at=l(e,"P",{"data-svelte-h":!0}),p(at)!=="svelte-19mmsrx"&&(at.innerHTML=zr),Xo=i(e),ot=l(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-1l3vx9e"&&(ot.textContent=Wr),Lo=i(e),Z=l(e,"H4",{class:!0});var Rs=h(Z);he=l(Rs,"A",{id:!0,class:!0,href:!0});var fh=h(he);to=l(fh,"SPAN",{});var bh=h(to);m(lt.$$.fragment,bh),bh.forEach(t),fh.forEach(t),Wi=i(Rs),ma=l(Rs,"SPAN",{"data-svelte-h":!0}),p(ma)!=="svelte-1rmq0vv"&&(ma.textContent=Zr),Rs.forEach(t),Vo=i(e),st=l(e,"P",{"data-svelte-h":!0}),p(st)!=="svelte-kadae5"&&(st.innerHTML=Ur),Fo=i(e),m(it.$$.fragment,e),Ro=i(e),rt=l(e,"P",{"data-svelte-h":!0}),p(rt)!=="svelte-qilh1w"&&(rt.textContent=jr),Io=i(e),m(dt.$$.fragment,e),Yo=i(e),U=l(e,"H4",{class:!0});var Is=h(U);pe=l(Is,"A",{id:!0,class:!0,href:!0});var vh=h(pe);no=l(vh,"SPAN",{});var gh=h(no);m(ht.$$.fragment,gh),gh.forEach(t),vh.forEach(t),Zi=i(Is),ca=l(Is,"SPAN",{"data-svelte-h":!0}),p(ca)!=="svelte-9x6jxy"&&(ca.textContent=Nr),Is.forEach(t),So=i(e),pt=l(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-kas648"&&(pt.innerHTML=Ar),Do=i(e),m(ut.$$.fragment,e),Ko=i(e),mt=l(e,"P",{"data-svelte-h":!0}),p(mt)!=="svelte-h9bd62"&&(mt.textContent=Er),Oo=i(e),ct=l(e,"P",{"data-svelte-h":!0}),p(ct)!=="svelte-1kt63mp"&&(ct.innerHTML=Gr),el=i(e),m(ft.$$.fragment,e),tl=i(e),bt=l(e,"P",{"data-svelte-h":!0}),p(bt)!=="svelte-p700d6"&&(bt.innerHTML=Hr),nl=i(e),m(ue.$$.fragment,e),al=i(e),j=l(e,"H3",{class:!0});var Ys=h(j);me=l(Ys,"A",{id:!0,class:!0,href:!0});var yh=h(me);ao=l(yh,"SPAN",{});var wh=h(ao);m(vt.$$.fragment,wh),wh.forEach(t),yh.forEach(t),Ui=i(Ys),fa=l(Ys,"SPAN",{"data-svelte-h":!0}),p(fa)!=="svelte-hvmxb4"&&(fa.textContent=Br),Ys.forEach(t),ol=i(e),gt=l(e,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-l0e993"&&(gt.innerHTML=Pr),ll=i(e),m(yt.$$.fragment,e),sl=i(e),wt=l(e,"P",{"data-svelte-h":!0}),p(wt)!=="svelte-1cc82wc"&&(wt.innerHTML=Qr),il=i(e),m(_t.$$.fragment,e),rl=i(e),$t=l(e,"P",{"data-svelte-h":!0}),p($t)!=="svelte-14meqc0"&&($t.innerHTML=Xr),dl=i(e),m(Mt.$$.fragment,e),hl=i(e),N=l(e,"H3",{class:!0});var Ss=h(N);ce=l(Ss,"A",{id:!0,class:!0,href:!0});var _h=h(ce);oo=l(_h,"SPAN",{});var $h=h(oo);m(Tt.$$.fragment,$h),$h.forEach(t),_h.forEach(t),ji=i(Ss),ba=l(Ss,"SPAN",{"data-svelte-h":!0}),p(ba)!=="svelte-126t2v3"&&(ba.textContent=Lr),Ss.forEach(t),pl=i(e),Ct=l(e,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-gsus0a"&&(Ct.innerHTML=Vr),ul=i(e),m(kt.$$.fragment,e),ml=i(e),xt=l(e,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-1xfcpge"&&(xt.innerHTML=Fr),cl=i(e),m(Jt.$$.fragment,e),fl=i(e),A=l(e,"H3",{class:!0});var Ds=h(A);fe=l(Ds,"A",{id:!0,class:!0,href:!0});var Mh=h(fe);lo=l(Mh,"SPAN",{});var Th=h(lo);m(qt.$$.fragment,Th),Th.forEach(t),Mh.forEach(t),Ni=i(Ds),va=l(Ds,"SPAN",{"data-svelte-h":!0}),p(va)!=="svelte-1c7obi4"&&(va.textContent=Rr),Ds.forEach(t),bl=i(e),zt=l(e,"P",{"data-svelte-h":!0}),p(zt)!=="svelte-13vcaec"&&(zt.innerHTML=Ir),vl=i(e),m(Wt.$$.fragment,e),gl=i(e),Zt=l(e,"P",{"data-svelte-h":!0}),p(Zt)!=="svelte-15fps22"&&(Zt.textContent=Yr),yl=i(e),E=l(e,"H4",{class:!0});var Ks=h(E);be=l(Ks,"A",{id:!0,class:!0,href:!0});var Ch=h(be);so=l(Ch,"SPAN",{});var kh=h(so);m(Ut.$$.fragment,kh),kh.forEach(t),Ch.forEach(t),Ai=i(Ks),ga=l(Ks,"SPAN",{"data-svelte-h":!0}),p(ga)!=="svelte-119debz"&&(ga.textContent=Sr),Ks.forEach(t),wl=i(e),jt=l(e,"P",{"data-svelte-h":!0}),p(jt)!=="svelte-1rghhrt"&&(jt.innerHTML=Dr),_l=i(e),G=l(e,"H3",{class:!0});var Os=h(G);ve=l(Os,"A",{id:!0,class:!0,href:!0});var xh=h(ve);io=l(xh,"SPAN",{});var Jh=h(io);m(Nt.$$.fragment,Jh),Jh.forEach(t),xh.forEach(t),Ei=i(Os),ya=l(Os,"SPAN",{"data-svelte-h":!0}),p(ya)!=="svelte-r41rji"&&(ya.textContent=Kr),Os.forEach(t),$l=i(e),At=l(e,"P",{"data-svelte-h":!0}),p(At)!=="svelte-178d21p"&&(At.innerHTML=Or),Ml=i(e),H=l(e,"H3",{class:!0});var ei=h(H);ge=l(ei,"A",{id:!0,class:!0,href:!0});var qh=h(ge);ro=l(qh,"SPAN",{});var zh=h(ro);m(Et.$$.fragment,zh),zh.forEach(t),qh.forEach(t),Gi=i(ei),wa=l(ei,"SPAN",{"data-svelte-h":!0}),p(wa)!=="svelte-1twn1jv"&&(wa.textContent=ed),ei.forEach(t),Tl=i(e),C=l(e,"DIV",{class:!0});var Sa=h(C);m(Gt.$$.fragment,Sa),Hi=i(Sa),_a=l(Sa,"P",{"data-svelte-h":!0}),p(_a)!=="svelte-i3efvr"&&(_a.innerHTML=td),Bi=i(Sa),ye=l(Sa,"DIV",{class:!0});var ti=h(ye);m(Ht.$$.fragment,ti),Pi=i(ti),$a=l(ti,"P",{"data-svelte-h":!0}),p($a)!=="svelte-1ozftb6"&&($a.textContent=nd),ti.forEach(t),Sa.forEach(t),Cl=i(e),B=l(e,"H2",{class:!0});var ni=h(B);we=l(ni,"A",{id:!0,class:!0,href:!0});var Wh=h(we);ho=l(Wh,"SPAN",{});var Zh=h(ho);m(Bt.$$.fragment,Zh),Zh.forEach(t),Wh.forEach(t),Qi=i(ni),Ma=l(ni,"SPAN",{"data-svelte-h":!0}),p(Ma)!=="svelte-36ow3c"&&(Ma.innerHTML=ad),ni.forEach(t),kl=i(e),Pt=l(e,"P",{"data-svelte-h":!0}),p(Pt)!=="svelte-1w3k2k7"&&(Pt.innerHTML=od),xl=i(e),Qt=l(e,"P",{"data-svelte-h":!0}),p(Qt)!=="svelte-18yxc3j"&&(Qt.innerHTML=ld),Jl=i(e),Xt=l(e,"P",{"data-svelte-h":!0}),p(Xt)!=="svelte-7usn7e"&&(Xt.innerHTML=sd),ql=i(e),Lt=l(e,"P",{"data-svelte-h":!0}),p(Lt)!=="svelte-181g9sa"&&(Lt.innerHTML=id),zl=i(e),Vt=l(e,"P",{"data-svelte-h":!0}),p(Vt)!=="svelte-1mf5lu3"&&(Vt.innerHTML=rd),Wl=i(e),P=l(e,"H3",{class:!0});var ai=h(P);_e=l(ai,"A",{id:!0,class:!0,href:!0});var Uh=h(_e);po=l(Uh,"SPAN",{});var jh=h(po);m(Ft.$$.fragment,jh),jh.forEach(t),Uh.forEach(t),Xi=i(ai),Ta=l(ai,"SPAN",{"data-svelte-h":!0}),p(Ta)!=="svelte-d8us6k"&&(Ta.textContent=dd),ai.forEach(t),Zl=i(e),Rt=l(e,"P",{"data-svelte-h":!0}),p(Rt)!=="svelte-1j22nc4"&&(Rt.innerHTML=hd),Ul=i(e),m(It.$$.fragment,e),jl=i(e),Yt=l(e,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-bhhave"&&(Yt.innerHTML=pd),Nl=i(e),m(St.$$.fragment,e),Al=i(e),Q=l(e,"H3",{class:!0});var oi=h(Q);$e=l(oi,"A",{id:!0,class:!0,href:!0});var Nh=h($e);uo=l(Nh,"SPAN",{});var Ah=h(uo);m(Dt.$$.fragment,Ah),Ah.forEach(t),Nh.forEach(t),Li=i(oi),Ca=l(oi,"SPAN",{"data-svelte-h":!0}),p(Ca)!=="svelte-1nm95jm"&&(Ca.textContent=ud),oi.forEach(t),El=i(e),X=l(e,"H4",{class:!0});var li=h(X);Me=l(li,"A",{id:!0,class:!0,href:!0});var Eh=h(Me);mo=l(Eh,"SPAN",{});var Gh=h(mo);m(Kt.$$.fragment,Gh),Gh.forEach(t),Eh.forEach(t),Vi=i(li),ka=l(li,"SPAN",{"data-svelte-h":!0}),p(ka)!=="svelte-ypjn7h"&&(ka.textContent=md),li.forEach(t),Gl=i(e),Ot=l(e,"P",{"data-svelte-h":!0}),p(Ot)!=="svelte-1opqihr"&&(Ot.textContent=cd),Hl=i(e),en=l(e,"UL",{"data-svelte-h":!0}),p(en)!=="svelte-18dpv7h"&&(en.innerHTML=fd),Bl=i(e),L=l(e,"H4",{class:!0});var si=h(L);Te=l(si,"A",{id:!0,class:!0,href:!0});var Hh=h(Te);co=l(Hh,"SPAN",{});var Bh=h(co);m(tn.$$.fragment,Bh),Bh.forEach(t),Hh.forEach(t),Fi=i(si),xa=l(si,"SPAN",{"data-svelte-h":!0}),p(xa)!=="svelte-1rcm4pq"&&(xa.textContent=bd),si.forEach(t),Pl=i(e),nn=l(e,"UL",{"data-svelte-h":!0}),p(nn)!=="svelte-un6hvz"&&(nn.innerHTML=vd),Ql=i(e),V=l(e,"H4",{class:!0});var ii=h(V);Ce=l(ii,"A",{id:!0,class:!0,href:!0});var Ph=h(Ce);fo=l(Ph,"SPAN",{});var Qh=h(fo);m(an.$$.fragment,Qh),Qh.forEach(t),Ph.forEach(t),Ri=i(ii),Ja=l(ii,"SPAN",{"data-svelte-h":!0}),p(Ja)!=="svelte-qkd7jc"&&(Ja.textContent=gd),ii.forEach(t),Xl=i(e),on=l(e,"P",{"data-svelte-h":!0}),p(on)!=="svelte-raw4uk"&&(on.innerHTML=yd),Ll=i(e),m(ln.$$.fragment,e),Vl=i(e),m(ke.$$.fragment,e),Fl=i(e),F=l(e,"H3",{class:!0});var ri=h(F);xe=l(ri,"A",{id:!0,class:!0,href:!0});var Xh=h(xe);bo=l(Xh,"SPAN",{});var Lh=h(bo);m(sn.$$.fragment,Lh),Lh.forEach(t),Xh.forEach(t),Ii=i(ri),qa=l(ri,"SPAN",{"data-svelte-h":!0}),p(qa)!=="svelte-6rdz9o"&&(qa.textContent=wd),ri.forEach(t),Rl=i(e),rn=l(e,"P",{"data-svelte-h":!0}),p(rn)!=="svelte-z16dbi"&&(rn.innerHTML=_d),Il=i(e),m(dn.$$.fragment,e),Yl=i(e),hn=l(e,"P",{"data-svelte-h":!0}),p(hn)!=="svelte-14x4n3j"&&(hn.innerHTML=$d),Sl=i(e),pn=l(e,"P",{"data-svelte-h":!0}),p(pn)!=="svelte-1mgfmur"&&(pn.innerHTML=Md),Dl=i(e),m(un.$$.fragment,e),Kl=i(e),mn=l(e,"P",{"data-svelte-h":!0}),p(mn)!=="svelte-1h0pju"&&(mn.textContent=Td),Ol=i(e),m(Je.$$.fragment,e),es=i(e),R=l(e,"H4",{class:!0});var di=h(R);qe=l(di,"A",{id:!0,class:!0,href:!0});var Vh=h(qe);vo=l(Vh,"SPAN",{});var Fh=h(vo);m(cn.$$.fragment,Fh),Fh.forEach(t),Vh.forEach(t),Yi=i(di),za=l(di,"SPAN",{"data-svelte-h":!0}),p(za)!=="svelte-yjwkmt"&&(za.textContent=Cd),di.forEach(t),ts=i(e),fn=l(e,"P",{"data-svelte-h":!0}),p(fn)!=="svelte-11st5ue"&&(fn.textContent=kd),ns=i(e),I=l(e,"H5",{class:!0});var hi=h(I);ze=l(hi,"A",{id:!0,class:!0,href:!0});var Rh=h(ze);go=l(Rh,"SPAN",{});var Ih=h(go);m(bn.$$.fragment,Ih),Ih.forEach(t),Rh.forEach(t),Si=i(hi),Wa=l(hi,"SPAN",{"data-svelte-h":!0}),p(Wa)!=="svelte-10ttfyf"&&(Wa.textContent=xd),hi.forEach(t),as=i(e),vn=l(e,"P",{"data-svelte-h":!0}),p(vn)!=="svelte-1qt7jnk"&&(vn.innerHTML=Jd),os=i(e),m(gn.$$.fragment,e),ls=i(e),Y=l(e,"H5",{class:!0});var pi=h(Y);We=l(pi,"A",{id:!0,class:!0,href:!0});var Yh=h(We);yo=l(Yh,"SPAN",{});var Sh=h(yo);m(yn.$$.fragment,Sh),Sh.forEach(t),Yh.forEach(t),Di=i(pi),Za=l(pi,"SPAN",{"data-svelte-h":!0}),p(Za)!=="svelte-1lkwlvb"&&(Za.textContent=qd),pi.forEach(t),ss=i(e),wn=l(e,"P",{"data-svelte-h":!0}),p(wn)!=="svelte-ctju2y"&&(wn.textContent=zd),is=i(e),m(_n.$$.fragment,e),rs=i(e),S=l(e,"H5",{class:!0});var ui=h(S);Ze=l(ui,"A",{id:!0,class:!0,href:!0});var Dh=h(Ze);wo=l(Dh,"SPAN",{});var Kh=h(wo);m($n.$$.fragment,Kh),Kh.forEach(t),Dh.forEach(t),Ki=i(ui),Ua=l(ui,"SPAN",{"data-svelte-h":!0}),p(Ua)!=="svelte-mrih1r"&&(Ua.textContent=Wd),ui.forEach(t),ds=i(e),Mn=l(e,"P",{"data-svelte-h":!0}),p(Mn)!=="svelte-8sil41"&&(Mn.textContent=Zd),hs=i(e),m(Tn.$$.fragment,e),ps=i(e),D=l(e,"H3",{class:!0});var mi=h(D);Ue=l(mi,"A",{id:!0,class:!0,href:!0});var Oh=h(Ue);_o=l(Oh,"SPAN",{});var ep=h(_o);m(Cn.$$.fragment,ep),ep.forEach(t),Oh.forEach(t),Oi=i(mi),ja=l(mi,"SPAN",{"data-svelte-h":!0}),p(ja)!=="svelte-1unku24"&&(ja.textContent=Ud),mi.forEach(t),us=i(e),kn=l(e,"P",{"data-svelte-h":!0}),p(kn)!=="svelte-12ibgkx"&&(kn.innerHTML=jd),ms=i(e),m(xn.$$.fragment,e),cs=i(e),m(je.$$.fragment,e),fs=i(e),K=l(e,"H3",{class:!0});var ci=h(K);Ne=l(ci,"A",{id:!0,class:!0,href:!0});var tp=h(Ne);$o=l(tp,"SPAN",{});var np=h($o);m(Jn.$$.fragment,np),np.forEach(t),tp.forEach(t),er=i(ci),Na=l(ci,"SPAN",{"data-svelte-h":!0}),p(Na)!=="svelte-126t2v3"&&(Na.textContent=Nd),ci.forEach(t),bs=i(e),qn=l(e,"P",{"data-svelte-h":!0}),p(qn)!=="svelte-11o118p"&&(qn.innerHTML=Ad),vs=i(e),m(zn.$$.fragment,e),gs=i(e),Wn=l(e,"P",{"data-svelte-h":!0}),p(Wn)!=="svelte-1a6lfeb"&&(Wn.innerHTML=Ed),ys=i(e),O=l(e,"H3",{class:!0});var fi=h(O);Ae=l(fi,"A",{id:!0,class:!0,href:!0});var ap=h(Ae);Mo=l(ap,"SPAN",{});var op=h(Mo);m(Zn.$$.fragment,op),op.forEach(t),ap.forEach(t),tr=i(fi),Aa=l(fi,"SPAN",{"data-svelte-h":!0}),p(Aa)!=="svelte-yjwkmt"&&(Aa.textContent=Gd),fi.forEach(t),ws=i(e),Un=l(e,"P",{"data-svelte-h":!0}),p(Un)!=="svelte-bf8u41"&&(Un.textContent=Hd),_s=i(e),ee=l(e,"H4",{class:!0});var bi=h(ee);Ee=l(bi,"A",{id:!0,class:!0,href:!0});var lp=h(Ee);To=l(lp,"SPAN",{});var sp=h(To);m(jn.$$.fragment,sp),sp.forEach(t),lp.forEach(t),nr=i(bi),Ea=l(bi,"SPAN",{"data-svelte-h":!0}),p(Ea)!=="svelte-18mfrxb"&&(Ea.innerHTML=Bd),bi.forEach(t),$s=i(e),Nn=l(e,"P",{"data-svelte-h":!0}),p(Nn)!=="svelte-9xq6i6"&&(Nn.innerHTML=Pd),Ms=i(e),An=l(e,"P",{"data-svelte-h":!0}),p(An)!=="svelte-11i6qe3"&&(An.innerHTML=Qd),Ts=i(e),m(En.$$.fragment,e),Cs=i(e),Gn=l(e,"P",{"data-svelte-h":!0}),p(Gn)!=="svelte-fbn7z"&&(Gn.innerHTML=Xd),ks=i(e),m(Hn.$$.fragment,e),xs=i(e),Bn=l(e,"P",{"data-svelte-h":!0}),p(Bn)!=="svelte-1pv013b"&&(Bn.textContent=Ld),Js=i(e),m(Pn.$$.fragment,e),qs=i(e),Qn=l(e,"P",{"data-svelte-h":!0}),p(Qn)!=="svelte-nsev1w"&&(Qn.textContent=Vd),zs=i(e),te=l(e,"H4",{class:!0});var vi=h(te);Ge=l(vi,"A",{id:!0,class:!0,href:!0});var ip=h(Ge);Co=l(ip,"SPAN",{});var rp=h(Co);m(Xn.$$.fragment,rp),rp.forEach(t),ip.forEach(t),ar=i(vi),Ga=l(vi,"SPAN",{"data-svelte-h":!0}),p(Ga)!=="svelte-1ij3psd"&&(Ga.innerHTML=Fd),vi.forEach(t),Ws=i(e),Ln=l(e,"P",{"data-svelte-h":!0}),p(Ln)!=="svelte-2188jb"&&(Ln.innerHTML=Rd),Zs=i(e),m(Vn.$$.fragment,e),Us=i(e),ne=l(e,"H4",{class:!0});var gi=h(ne);He=l(gi,"A",{id:!0,class:!0,href:!0});var dp=h(He);ko=l(dp,"SPAN",{});var hp=h(ko);m(Fn.$$.fragment,hp),hp.forEach(t),dp.forEach(t),or=i(gi),Ha=l(gi,"SPAN",{"data-svelte-h":!0}),p(Ha)!=="svelte-ak9605"&&(Ha.textContent=Id),gi.forEach(t),js=i(e),Rn=l(e,"P",{"data-svelte-h":!0}),p(Rn)!=="svelte-1k96tv8"&&(Rn.innerHTML=Yd),Ns=i(e),m(In.$$.fragment,e),As=i(e),ae=l(e,"H4",{class:!0});var yi=h(ae);Be=l(yi,"A",{id:!0,class:!0,href:!0});var pp=h(Be);xo=l(pp,"SPAN",{});var up=h(xo);m(Yn.$$.fragment,up),up.forEach(t),pp.forEach(t),lr=i(yi),Ba=l(yi,"SPAN",{"data-svelte-h":!0}),p(Ba)!=="svelte-1b0ivcj"&&(Ba.textContent=Sd),yi.forEach(t),Es=i(e),Sn=l(e,"P",{"data-svelte-h":!0}),p(Sn)!=="svelte-11ahrdq"&&(Sn.innerHTML=Dd),Gs=i(e),Dn=l(e,"P",{"data-svelte-h":!0}),p(Dn)!=="svelte-1acgju7"&&(Dn.innerHTML=Kd),Hs=i(e),oe=l(e,"H3",{class:!0});var wi=h(oe);Pe=l(wi,"A",{id:!0,class:!0,href:!0});var mp=h(Pe);Jo=l(mp,"SPAN",{});var cp=h(Jo);m(Kn.$$.fragment,cp),cp.forEach(t),mp.forEach(t),sr=i(wi),Pa=l(wi,"SPAN",{"data-svelte-h":!0}),p(Pa)!=="svelte-43l4qz"&&(Pa.textContent=Od),wi.forEach(t),Bs=i(e),$=l(e,"DIV",{class:!0});var T=h($);m(On.$$.fragment,T),ir=i(T),Qa=l(T,"P",{"data-svelte-h":!0}),p(Qa)!=="svelte-woamwr"&&(Qa.innerHTML=eh),rr=i(T),Xa=l(T,"P",{"data-svelte-h":!0}),p(Xa)!=="svelte-ki5gis"&&(Xa.innerHTML=th),dr=i(T),La=l(T,"P",{"data-svelte-h":!0}),p(La)!=="svelte-8qsk2q"&&(La.innerHTML=nh),hr=i(T),Qe=l(T,"DIV",{class:!0});var _i=h(Qe);m(ea.$$.fragment,_i),pr=i(_i),Va=l(_i,"P",{"data-svelte-h":!0}),p(Va)!=="svelte-10tvzyv"&&(Va.innerHTML=ah),_i.forEach(t),ur=i(T),Xe=l(T,"DIV",{class:!0});var $i=h(Xe);m(ta.$$.fragment,$i),mr=i($i),Fa=l($i,"P",{"data-svelte-h":!0}),p(Fa)!=="svelte-gy26u4"&&(Fa.textContent=oh),$i.forEach(t),cr=i(T),Le=l(T,"DIV",{class:!0});var Mi=h(Le);m(na.$$.fragment,Mi),fr=i(Mi),Ra=l(Mi,"P",{"data-svelte-h":!0}),p(Ra)!=="svelte-19bn0da"&&(Ra.innerHTML=lh),Mi.forEach(t),br=i(T),Ve=l(T,"DIV",{class:!0});var Ti=h(Ve);m(aa.$$.fragment,Ti),vr=i(Ti),Ia=l(Ti,"P",{"data-svelte-h":!0}),p(Ia)!=="svelte-1p6bdas"&&(Ia.textContent=sh),Ti.forEach(t),T.forEach(t),Ps=i(e),le=l(e,"H2",{class:!0});var Ci=h(le);Fe=l(Ci,"A",{id:!0,class:!0,href:!0});var fp=h(Fe);qo=l(fp,"SPAN",{});var bp=h(qo);m(oa.$$.fragment,bp),bp.forEach(t),fp.forEach(t),gr=i(Ci),Ya=l(Ci,"SPAN",{"data-svelte-h":!0}),p(Ya)!=="svelte-1ly08ln"&&(Ya.innerHTML=ih),Ci.forEach(t),Qs=i(e),la=l(e,"P",{"data-svelte-h":!0}),p(la)!=="svelte-pdn3hl"&&(la.innerHTML=rh),Xs=i(e),zo=l(e,"P",{}),h(zo).forEach(t),this.h()},h(){d(g,"name","hf:doc:metadata"),d(g,"content",JSON.stringify(qp)),d(se,"id","quantize-transformers-models"),d(se,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(se,"href","#quantize-transformers-models"),d(J,"class","relative group"),d(ie,"id","autogptq-integration"),d(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ie,"href","#autogptq-integration"),d(q,"class","relative group"),d(re,"id","requirements"),d(re,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(re,"href","#requirements"),d(z,"class","relative group"),d(de,"id","load-and-quantize-a-model"),d(de,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(de,"href","#load-and-quantize-a-model"),d(W,"class","relative group"),d(he,"id","gptq-configuration"),d(he,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(he,"href","#gptq-configuration"),d(Z,"class","relative group"),d(pe,"id","quantization"),d(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(pe,"href","#quantization"),d(U,"class","relative group"),d(me,"id","push-quantized-model-to-hub"),d(me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(me,"href","#push-quantized-model-to-hub"),d(j,"class","relative group"),d(ce,"id","load-a-quantized-model-from-the-hub"),d(ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ce,"href","#load-a-quantized-model-from-the-hub"),d(N,"class","relative group"),d(fe,"id","exllama-kernels-for-faster-inference"),d(fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(fe,"href","#exllama-kernels-for-faster-inference"),d(A,"class","relative group"),d(be,"id","finetune-a-quantized-model"),d(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(be,"href","#finetune-a-quantized-model"),d(E,"class","relative group"),d(ve,"id","example-demo"),d(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ve,"href","#example-demo"),d(G,"class","relative group"),d(ge,"id","transformers.GPTQConfig"),d(ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ge,"href","#transformers.GPTQConfig"),d(H,"class","relative group"),d(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(we,"id","bitsandbytes-integration"),d(we,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(we,"href","#bitsandbytes-integration"),d(B,"class","relative group"),d(_e,"id","general-usage"),d(_e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(_e,"href","#general-usage"),d(P,"class","relative group"),d($e,"id","fp4-quantization"),d($e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d($e,"href","#fp4-quantization"),d(Q,"class","relative group"),d(Me,"id","requirements"),d(Me,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Me,"href","#requirements"),d(X,"class","relative group"),d(Te,"id","tips-and-best-practices"),d(Te,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Te,"href","#tips-and-best-practices"),d(L,"class","relative group"),d(Ce,"id","load-a-large-model-in-4bit"),d(Ce,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ce,"href","#load-a-large-model-in-4bit"),d(V,"class","relative group"),d(xe,"id","load-a-large-model-in-8bit"),d(xe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(xe,"href","#load-a-large-model-in-8bit"),d(F,"class","relative group"),d(qe,"id","advanced-use-cases"),d(qe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(qe,"href","#advanced-use-cases"),d(R,"class","relative group"),d(ze,"id","change-the-compute-dtype"),d(ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(ze,"href","#change-the-compute-dtype"),d(I,"class","relative group"),d(We,"id","using-nf4-normal-float-4-data-type"),d(We,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(We,"href","#using-nf4-normal-float-4-data-type"),d(Y,"class","relative group"),d(Ze,"id","use-nested-quantization-for-more-memory-efficient-inference"),d(Ze,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ze,"href","#use-nested-quantization-for-more-memory-efficient-inference"),d(S,"class","relative group"),d(Ue,"id","push-quantized-models-on-the-hub"),d(Ue,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ue,"href","#push-quantized-models-on-the-hub"),d(D,"class","relative group"),d(Ne,"id","load-a-quantized-model-from-the-hub"),d(Ne,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ne,"href","#load-a-quantized-model-from-the-hub"),d(K,"class","relative group"),d(Ae,"id","advanced-use-cases"),d(Ae,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ae,"href","#advanced-use-cases"),d(O,"class","relative group"),d(Ee,"id","offload-between-cpu-and-gpu"),d(Ee,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ee,"href","#offload-between-cpu-and-gpu"),d(ee,"class","relative group"),d(Ge,"id","play-with-llmint8threshold"),d(Ge,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Ge,"href","#play-with-llmint8threshold"),d(te,"class","relative group"),d(He,"id","skip-the-conversion-of-some-modules"),d(He,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(He,"href","#skip-the-conversion-of-some-modules"),d(ne,"class","relative group"),d(Be,"id","finetune-a-model-that-has-been-loaded-in-8bit"),d(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Be,"href","#finetune-a-model-that-has-been-loaded-in-8bit"),d(ae,"class","relative group"),d(Pe,"id","transformers.BitsAndBytesConfig"),d(Pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Pe,"href","#transformers.BitsAndBytesConfig"),d(oe,"class","relative group"),d(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),d(Fe,"id","quantization-with-optimum"),d(Fe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),d(Fe,"href","#quantization-with-optimum"),d(le,"class","relative group")},m(e,n){r(document.head,g),a(e,M,n),a(e,w,n),a(e,x,n),a(e,J,n),r(J,se),r(se,Da),c(Re,Da,null),r(J,xi),r(J,da),a(e,Uo,n),a(e,q,n),r(q,ie),r(ie,Ka),c(Ie,Ka,null),r(q,Ji),r(q,ha),a(e,jo,n),a(e,Ye,n),a(e,No,n),a(e,Se,n),a(e,Ao,n),a(e,De,n),a(e,Eo,n),a(e,z,n),r(z,re),r(re,Oa),c(Ke,Oa,null),r(z,qi),r(z,pa),a(e,Go,n),a(e,Oe,n),a(e,Ho,n),a(e,et,n),a(e,Bo,n),a(e,tt,n),a(e,Po,n),a(e,W,n),r(W,de),r(de,eo),c(nt,eo,null),r(W,zi),r(W,ua),a(e,Qo,n),a(e,at,n),a(e,Xo,n),a(e,ot,n),a(e,Lo,n),a(e,Z,n),r(Z,he),r(he,to),c(lt,to,null),r(Z,Wi),r(Z,ma),a(e,Vo,n),a(e,st,n),a(e,Fo,n),c(it,e,n),a(e,Ro,n),a(e,rt,n),a(e,Io,n),c(dt,e,n),a(e,Yo,n),a(e,U,n),r(U,pe),r(pe,no),c(ht,no,null),r(U,Zi),r(U,ca),a(e,So,n),a(e,pt,n),a(e,Do,n),c(ut,e,n),a(e,Ko,n),a(e,mt,n),a(e,Oo,n),a(e,ct,n),a(e,el,n),c(ft,e,n),a(e,tl,n),a(e,bt,n),a(e,nl,n),c(ue,e,n),a(e,al,n),a(e,j,n),r(j,me),r(me,ao),c(vt,ao,null),r(j,Ui),r(j,fa),a(e,ol,n),a(e,gt,n),a(e,ll,n),c(yt,e,n),a(e,sl,n),a(e,wt,n),a(e,il,n),c(_t,e,n),a(e,rl,n),a(e,$t,n),a(e,dl,n),c(Mt,e,n),a(e,hl,n),a(e,N,n),r(N,ce),r(ce,oo),c(Tt,oo,null),r(N,ji),r(N,ba),a(e,pl,n),a(e,Ct,n),a(e,ul,n),c(kt,e,n),a(e,ml,n),a(e,xt,n),a(e,cl,n),c(Jt,e,n),a(e,fl,n),a(e,A,n),r(A,fe),r(fe,lo),c(qt,lo,null),r(A,Ni),r(A,va),a(e,bl,n),a(e,zt,n),a(e,vl,n),c(Wt,e,n),a(e,gl,n),a(e,Zt,n),a(e,yl,n),a(e,E,n),r(E,be),r(be,so),c(Ut,so,null),r(E,Ai),r(E,ga),a(e,wl,n),a(e,jt,n),a(e,_l,n),a(e,G,n),r(G,ve),r(ve,io),c(Nt,io,null),r(G,Ei),r(G,ya),a(e,$l,n),a(e,At,n),a(e,Ml,n),a(e,H,n),r(H,ge),r(ge,ro),c(Et,ro,null),r(H,Gi),r(H,wa),a(e,Tl,n),a(e,C,n),c(Gt,C,null),r(C,Hi),r(C,_a),r(C,Bi),r(C,ye),c(Ht,ye,null),r(ye,Pi),r(ye,$a),a(e,Cl,n),a(e,B,n),r(B,we),r(we,ho),c(Bt,ho,null),r(B,Qi),r(B,Ma),a(e,kl,n),a(e,Pt,n),a(e,xl,n),a(e,Qt,n),a(e,Jl,n),a(e,Xt,n),a(e,ql,n),a(e,Lt,n),a(e,zl,n),a(e,Vt,n),a(e,Wl,n),a(e,P,n),r(P,_e),r(_e,po),c(Ft,po,null),r(P,Xi),r(P,Ta),a(e,Zl,n),a(e,Rt,n),a(e,Ul,n),c(It,e,n),a(e,jl,n),a(e,Yt,n),a(e,Nl,n),c(St,e,n),a(e,Al,n),a(e,Q,n),r(Q,$e),r($e,uo),c(Dt,uo,null),r(Q,Li),r(Q,Ca),a(e,El,n),a(e,X,n),r(X,Me),r(Me,mo),c(Kt,mo,null),r(X,Vi),r(X,ka),a(e,Gl,n),a(e,Ot,n),a(e,Hl,n),a(e,en,n),a(e,Bl,n),a(e,L,n),r(L,Te),r(Te,co),c(tn,co,null),r(L,Fi),r(L,xa),a(e,Pl,n),a(e,nn,n),a(e,Ql,n),a(e,V,n),r(V,Ce),r(Ce,fo),c(an,fo,null),r(V,Ri),r(V,Ja),a(e,Xl,n),a(e,on,n),a(e,Ll,n),c(ln,e,n),a(e,Vl,n),c(ke,e,n),a(e,Fl,n),a(e,F,n),r(F,xe),r(xe,bo),c(sn,bo,null),r(F,Ii),r(F,qa),a(e,Rl,n),a(e,rn,n),a(e,Il,n),c(dn,e,n),a(e,Yl,n),a(e,hn,n),a(e,Sl,n),a(e,pn,n),a(e,Dl,n),c(un,e,n),a(e,Kl,n),a(e,mn,n),a(e,Ol,n),c(Je,e,n),a(e,es,n),a(e,R,n),r(R,qe),r(qe,vo),c(cn,vo,null),r(R,Yi),r(R,za),a(e,ts,n),a(e,fn,n),a(e,ns,n),a(e,I,n),r(I,ze),r(ze,go),c(bn,go,null),r(I,Si),r(I,Wa),a(e,as,n),a(e,vn,n),a(e,os,n),c(gn,e,n),a(e,ls,n),a(e,Y,n),r(Y,We),r(We,yo),c(yn,yo,null),r(Y,Di),r(Y,Za),a(e,ss,n),a(e,wn,n),a(e,is,n),c(_n,e,n),a(e,rs,n),a(e,S,n),r(S,Ze),r(Ze,wo),c($n,wo,null),r(S,Ki),r(S,Ua),a(e,ds,n),a(e,Mn,n),a(e,hs,n),c(Tn,e,n),a(e,ps,n),a(e,D,n),r(D,Ue),r(Ue,_o),c(Cn,_o,null),r(D,Oi),r(D,ja),a(e,us,n),a(e,kn,n),a(e,ms,n),c(xn,e,n),a(e,cs,n),c(je,e,n),a(e,fs,n),a(e,K,n),r(K,Ne),r(Ne,$o),c(Jn,$o,null),r(K,er),r(K,Na),a(e,bs,n),a(e,qn,n),a(e,vs,n),c(zn,e,n),a(e,gs,n),a(e,Wn,n),a(e,ys,n),a(e,O,n),r(O,Ae),r(Ae,Mo),c(Zn,Mo,null),r(O,tr),r(O,Aa),a(e,ws,n),a(e,Un,n),a(e,_s,n),a(e,ee,n),r(ee,Ee),r(Ee,To),c(jn,To,null),r(ee,nr),r(ee,Ea),a(e,$s,n),a(e,Nn,n),a(e,Ms,n),a(e,An,n),a(e,Ts,n),c(En,e,n),a(e,Cs,n),a(e,Gn,n),a(e,ks,n),c(Hn,e,n),a(e,xs,n),a(e,Bn,n),a(e,Js,n),c(Pn,e,n),a(e,qs,n),a(e,Qn,n),a(e,zs,n),a(e,te,n),r(te,Ge),r(Ge,Co),c(Xn,Co,null),r(te,ar),r(te,Ga),a(e,Ws,n),a(e,Ln,n),a(e,Zs,n),c(Vn,e,n),a(e,Us,n),a(e,ne,n),r(ne,He),r(He,ko),c(Fn,ko,null),r(ne,or),r(ne,Ha),a(e,js,n),a(e,Rn,n),a(e,Ns,n),c(In,e,n),a(e,As,n),a(e,ae,n),r(ae,Be),r(Be,xo),c(Yn,xo,null),r(ae,lr),r(ae,Ba),a(e,Es,n),a(e,Sn,n),a(e,Gs,n),a(e,Dn,n),a(e,Hs,n),a(e,oe,n),r(oe,Pe),r(Pe,Jo),c(Kn,Jo,null),r(oe,sr),r(oe,Pa),a(e,Bs,n),a(e,$,n),c(On,$,null),r($,ir),r($,Qa),r($,rr),r($,Xa),r($,dr),r($,La),r($,hr),r($,Qe),c(ea,Qe,null),r(Qe,pr),r(Qe,Va),r($,ur),r($,Xe),c(ta,Xe,null),r(Xe,mr),r(Xe,Fa),r($,cr),r($,Le),c(na,Le,null),r(Le,fr),r(Le,Ra),r($,br),r($,Ve),c(aa,Ve,null),r(Ve,vr),r(Ve,Ia),a(e,Ps,n),a(e,le,n),r(le,Fe),r(Fe,qo),c(oa,qo,null),r(le,gr),r(le,Ya),a(e,Qs,n),a(e,la,n),a(e,Xs,n),a(e,zo,n),Ls=!0},p(e,[n]){const sa={};n&2&&(sa.$$scope={dirty:n,ctx:e}),ue.$set(sa);const Wo={};n&2&&(Wo.$$scope={dirty:n,ctx:e}),ke.$set(Wo);const Zo={};n&2&&(Zo.$$scope={dirty:n,ctx:e}),Je.$set(Zo);const ia={};n&2&&(ia.$$scope={dirty:n,ctx:e}),je.$set(ia)},i(e){Ls||(f(Re.$$.fragment,e),f(Ie.$$.fragment,e),f(Ke.$$.fragment,e),f(nt.$$.fragment,e),f(lt.$$.fragment,e),f(it.$$.fragment,e),f(dt.$$.fragment,e),f(ht.$$.fragment,e),f(ut.$$.fragment,e),f(ft.$$.fragment,e),f(ue.$$.fragment,e),f(vt.$$.fragment,e),f(yt.$$.fragment,e),f(_t.$$.fragment,e),f(Mt.$$.fragment,e),f(Tt.$$.fragment,e),f(kt.$$.fragment,e),f(Jt.$$.fragment,e),f(qt.$$.fragment,e),f(Wt.$$.fragment,e),f(Ut.$$.fragment,e),f(Nt.$$.fragment,e),f(Et.$$.fragment,e),f(Gt.$$.fragment,e),f(Ht.$$.fragment,e),f(Bt.$$.fragment,e),f(Ft.$$.fragment,e),f(It.$$.fragment,e),f(St.$$.fragment,e),f(Dt.$$.fragment,e),f(Kt.$$.fragment,e),f(tn.$$.fragment,e),f(an.$$.fragment,e),f(ln.$$.fragment,e),f(ke.$$.fragment,e),f(sn.$$.fragment,e),f(dn.$$.fragment,e),f(un.$$.fragment,e),f(Je.$$.fragment,e),f(cn.$$.fragment,e),f(bn.$$.fragment,e),f(gn.$$.fragment,e),f(yn.$$.fragment,e),f(_n.$$.fragment,e),f($n.$$.fragment,e),f(Tn.$$.fragment,e),f(Cn.$$.fragment,e),f(xn.$$.fragment,e),f(je.$$.fragment,e),f(Jn.$$.fragment,e),f(zn.$$.fragment,e),f(Zn.$$.fragment,e),f(jn.$$.fragment,e),f(En.$$.fragment,e),f(Hn.$$.fragment,e),f(Pn.$$.fragment,e),f(Xn.$$.fragment,e),f(Vn.$$.fragment,e),f(Fn.$$.fragment,e),f(In.$$.fragment,e),f(Yn.$$.fragment,e),f(Kn.$$.fragment,e),f(On.$$.fragment,e),f(ea.$$.fragment,e),f(ta.$$.fragment,e),f(na.$$.fragment,e),f(aa.$$.fragment,e),f(oa.$$.fragment,e),Ls=!0)},o(e){b(Re.$$.fragment,e),b(Ie.$$.fragment,e),b(Ke.$$.fragment,e),b(nt.$$.fragment,e),b(lt.$$.fragment,e),b(it.$$.fragment,e),b(dt.$$.fragment,e),b(ht.$$.fragment,e),b(ut.$$.fragment,e),b(ft.$$.fragment,e),b(ue.$$.fragment,e),b(vt.$$.fragment,e),b(yt.$$.fragment,e),b(_t.$$.fragment,e),b(Mt.$$.fragment,e),b(Tt.$$.fragment,e),b(kt.$$.fragment,e),b(Jt.$$.fragment,e),b(qt.$$.fragment,e),b(Wt.$$.fragment,e),b(Ut.$$.fragment,e),b(Nt.$$.fragment,e),b(Et.$$.fragment,e),b(Gt.$$.fragment,e),b(Ht.$$.fragment,e),b(Bt.$$.fragment,e),b(Ft.$$.fragment,e),b(It.$$.fragment,e),b(St.$$.fragment,e),b(Dt.$$.fragment,e),b(Kt.$$.fragment,e),b(tn.$$.fragment,e),b(an.$$.fragment,e),b(ln.$$.fragment,e),b(ke.$$.fragment,e),b(sn.$$.fragment,e),b(dn.$$.fragment,e),b(un.$$.fragment,e),b(Je.$$.fragment,e),b(cn.$$.fragment,e),b(bn.$$.fragment,e),b(gn.$$.fragment,e),b(yn.$$.fragment,e),b(_n.$$.fragment,e),b($n.$$.fragment,e),b(Tn.$$.fragment,e),b(Cn.$$.fragment,e),b(xn.$$.fragment,e),b(je.$$.fragment,e),b(Jn.$$.fragment,e),b(zn.$$.fragment,e),b(Zn.$$.fragment,e),b(jn.$$.fragment,e),b(En.$$.fragment,e),b(Hn.$$.fragment,e),b(Pn.$$.fragment,e),b(Xn.$$.fragment,e),b(Vn.$$.fragment,e),b(Fn.$$.fragment,e),b(In.$$.fragment,e),b(Yn.$$.fragment,e),b(Kn.$$.fragment,e),b(On.$$.fragment,e),b(ea.$$.fragment,e),b(ta.$$.fragment,e),b(na.$$.fragment,e),b(aa.$$.fragment,e),b(oa.$$.fragment,e),Ls=!1},d(e){e&&(t(M),t(w),t(x),t(J),t(Uo),t(q),t(jo),t(Ye),t(No),t(Se),t(Ao),t(De),t(Eo),t(z),t(Go),t(Oe),t(Ho),t(et),t(Bo),t(tt),t(Po),t(W),t(Qo),t(at),t(Xo),t(ot),t(Lo),t(Z),t(Vo),t(st),t(Fo),t(Ro),t(rt),t(Io),t(Yo),t(U),t(So),t(pt),t(Do),t(Ko),t(mt),t(Oo),t(ct),t(el),t(tl),t(bt),t(nl),t(al),t(j),t(ol),t(gt),t(ll),t(sl),t(wt),t(il),t(rl),t($t),t(dl),t(hl),t(N),t(pl),t(Ct),t(ul),t(ml),t(xt),t(cl),t(fl),t(A),t(bl),t(zt),t(vl),t(gl),t(Zt),t(yl),t(E),t(wl),t(jt),t(_l),t(G),t($l),t(At),t(Ml),t(H),t(Tl),t(C),t(Cl),t(B),t(kl),t(Pt),t(xl),t(Qt),t(Jl),t(Xt),t(ql),t(Lt),t(zl),t(Vt),t(Wl),t(P),t(Zl),t(Rt),t(Ul),t(jl),t(Yt),t(Nl),t(Al),t(Q),t(El),t(X),t(Gl),t(Ot),t(Hl),t(en),t(Bl),t(L),t(Pl),t(nn),t(Ql),t(V),t(Xl),t(on),t(Ll),t(Vl),t(Fl),t(F),t(Rl),t(rn),t(Il),t(Yl),t(hn),t(Sl),t(pn),t(Dl),t(Kl),t(mn),t(Ol),t(es),t(R),t(ts),t(fn),t(ns),t(I),t(as),t(vn),t(os),t(ls),t(Y),t(ss),t(wn),t(is),t(rs),t(S),t(ds),t(Mn),t(hs),t(ps),t(D),t(us),t(kn),t(ms),t(cs),t(fs),t(K),t(bs),t(qn),t(vs),t(gs),t(Wn),t(ys),t(O),t(ws),t(Un),t(_s),t(ee),t($s),t(Nn),t(Ms),t(An),t(Ts),t(Cs),t(Gn),t(ks),t(xs),t(Bn),t(Js),t(qs),t(Qn),t(zs),t(te),t(Ws),t(Ln),t(Zs),t(Us),t(ne),t(js),t(Rn),t(Ns),t(As),t(ae),t(Es),t(Sn),t(Gs),t(Dn),t(Hs),t(oe),t(Bs),t($),t(Ps),t(le),t(Qs),t(la),t(Xs),t(zo)),t(g),v(Re),v(Ie),v(Ke),v(nt),v(lt),v(it,e),v(dt,e),v(ht),v(ut,e),v(ft,e),v(ue,e),v(vt),v(yt,e),v(_t,e),v(Mt,e),v(Tt),v(kt,e),v(Jt,e),v(qt),v(Wt,e),v(Ut),v(Nt),v(Et),v(Gt),v(Ht),v(Bt),v(Ft),v(It,e),v(St,e),v(Dt),v(Kt),v(tn),v(an),v(ln,e),v(ke,e),v(sn),v(dn,e),v(un,e),v(Je,e),v(cn),v(bn),v(gn,e),v(yn),v(_n,e),v($n),v(Tn,e),v(Cn),v(xn,e),v(je,e),v(Jn),v(zn,e),v(Zn),v(jn),v(En,e),v(Hn,e),v(Pn,e),v(Xn),v(Vn,e),v(Fn),v(In,e),v(Yn),v(Kn),v(On),v(ea),v(ta),v(na),v(aa),v(oa)}}}const qp={local:"quantize-transformers-models",sections:[{local:"autogptq-integration",sections:[{local:"requirements",title:"Requirements"},{local:"load-and-quantize-a-model",sections:[{local:"gptq-configuration",title:"GPTQ Configuration"},{local:"quantization",title:"Quantization"}],title:"Load and quantize a model"},{local:"push-quantized-model-to-hub",title:"Push quantized model to 🤗 Hub"},{local:"load-a-quantized-model-from-the-hub",title:"Load a quantized model from the 🤗 Hub"},{local:"exllama-kernels-for-faster-inference",sections:[{local:"finetune-a-quantized-model",title:"Fine-tune a quantized model "}],title:"Exllama kernels for faster inference"},{local:"example-demo",title:"Example demo"},{local:"transformers.GPTQConfig",title:"GPTQConfig"}],title:"`AutoGPTQ` Integration"},{local:"bitsandbytes-integration",sections:[{local:"general-usage",title:"General usage"},{local:"fp4-quantization",sections:[{local:"requirements",title:"Requirements"},{local:"tips-and-best-practices",title:"Tips and best practices"},{local:"load-a-large-model-in-4bit",title:"Load a large model in 4bit"}],title:"FP4 quantization "},{local:"load-a-large-model-in-8bit",sections:[{local:"advanced-use-cases",sections:[{local:"change-the-compute-dtype",title:"Change the compute dtype"},{local:"using-nf4-normal-float-4-data-type",title:"Using NF4 (Normal Float 4) data type "},{local:"use-nested-quantization-for-more-memory-efficient-inference",title:"Use nested quantization for more memory efficient inference"}],title:"Advanced use cases"}],title:"Load a large model in 8bit"},{local:"push-quantized-models-on-the-hub",title:"Push quantized models on the 🤗 Hub"},{local:"load-a-quantized-model-from-the-hub",title:"Load a quantized model from the 🤗 Hub"},{local:"advanced-use-cases",sections:[{local:"offload-between-cpu-and-gpu",title:"Offload between `cpu` and `gpu`"},{local:"play-with-llmint8threshold",title:"Play with `llm_int8_threshold`"},{local:"skip-the-conversion-of-some-modules",title:"Skip the conversion of some modules"},{local:"finetune-a-model-that-has-been-loaded-in-8bit",title:"Fine-tune a model that has been loaded in 8-bit"}],title:"Advanced use cases"},{local:"transformers.BitsAndBytesConfig",title:"BitsAndBytesConfig"}],title:"`bitsandbytes` Integration"},{local:"quantization-with-optimum",title:"Quantization with 🤗 `optimum` "}],title:"Quantize 🤗 Transformers models"};function zp(k){return gp(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ep extends yp{constructor(g){super(),wp(this,g,zp,Jp,vp,{})}}export{Ep as component};
