import{s as Wo,o as Xo,n as B}from"../chunks/scheduler.9bc65507.js";import{S as No,i as Vo,g as i,s as c,u as _,A as Ro,h as l,f as r,c as d,j as J,v as M,y as h,k as j,o as s,a as g,w as y,d as b,t as T,x as w}from"../chunks/index.78c82d43.js";import{T as re}from"../chunks/Tip.87d55b76.js";import{D as Z}from"../chunks/Docstring.4e7352e2.js";import{C as P}from"../chunks/CodeBlock.73e038be.js";import{I as pt}from"../chunks/IconCopyLink.bedaa44d.js";import{E as q}from"../chunks/ExampleCodeBlock.872b014d.js";function $o(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdlbmVyYXRpb25Db25maWclMEElMEElMjMlMjBEb3dubG9hZCUyMGNvbmZpZ3VyYXRpb24lMjBmcm9tJTIwaHVnZ2luZ2ZhY2UuY28lMjBhbmQlMjBjYWNoZS4lMEFnZW5lcmF0aW9uX2NvbmZpZyUyMCUzRCUyMEdlbmVyYXRpb25Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTBBJTIzJTIwRS5nLiUyMGNvbmZpZyUyMHdhcyUyMHNhdmVkJTIwdXNpbmclMjAqc2F2ZV9wcmV0cmFpbmVkKCcuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJykqJTBBZ2VuZXJhdGlvbl9jb25maWcuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIpJTBBZ2VuZXJhdGlvbl9jb25maWclMjAlM0QlMjBHZW5lcmF0aW9uQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjIuJTJGdGVzdCUyRnNhdmVkX21vZGVsJTJGJTIyKSUwQSUwQSUyMyUyMFlvdSUyMGNhbiUyMGFsc28lMjBzcGVjaWZ5JTIwY29uZmlndXJhdGlvbiUyMG5hbWVzJTIwdG8lMjB5b3VyJTIwZ2VuZXJhdGlvbiUyMGNvbmZpZ3VyYXRpb24lMjBmaWxlJTBBZ2VuZXJhdGlvbl9jb25maWcuc2F2ZV9wcmV0cmFpbmVkKCUyMi4lMkZ0ZXN0JTJGc2F2ZWRfbW9kZWwlMkYlMjIlMkMlMjBjb25maWdfZmlsZV9uYW1lJTNEJTIybXlfY29uZmlndXJhdGlvbi5qc29uJTIyKSUwQWdlbmVyYXRpb25fY29uZmlnJTIwJTNEJTIwR2VuZXJhdGlvbkNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyLiUyRnRlc3QlMkZzYXZlZF9tb2RlbCUyRiUyMiUyQyUyMCUyMm15X2NvbmZpZ3VyYXRpb24uanNvbiUyMiklMEElMEElMjMlMjBJZiUyMHlvdSdkJTIwbGlrZSUyMHRvJTIwdHJ5JTIwYSUyMG1pbm9yJTIwdmFyaWF0aW9uJTIwdG8lMjBhbiUyMGV4aXN0aW5nJTIwY29uZmlndXJhdGlvbiUyQyUyMHlvdSUyMGNhbiUyMGFsc28lMjBwYXNzJTIwZ2VuZXJhdGlvbiUwQSUyMyUyMGFyZ3VtZW50cyUyMHRvJTIwJTYwLmZyb21fcHJldHJhaW5lZCgpJTYwLiUyMEJlJTIwbWluZGZ1bCUyMHRoYXQlMjB0eXBvcyUyMGFuZCUyMHVudXNlZCUyMGFyZ3VtZW50cyUyMHdpbGwlMjBiZSUyMGlnbm9yZWQlMEFnZW5lcmF0aW9uX2NvbmZpZyUyQyUyMHVudXNlZF9rd2FyZ3MlMjAlM0QlMjBHZW5lcmF0aW9uQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJncHQyJTIyJTJDJTIwdG9wX2slM0QxJTJDJTIwZm9vJTNERmFsc2UlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwcmV0dXJuX3VudXNlZF9rd2FyZ3MlM0RUcnVlJTBBKSUwQWdlbmVyYXRpb25fY29uZmlnLnRvcF9rJTBBJTBBdW51c2VkX2t3YXJncw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GenerationConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Download configuration from huggingface.co and cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># E.g. config was saved using *save_pretrained(&#x27;./test/saved_model/&#x27;)*</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># You can also specify configuration names to your generation configuration file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.save_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, config_file_name=<span class="hljs-string">&quot;my_configuration.json&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config = GenerationConfig.from_pretrained(<span class="hljs-string">&quot;./test/saved_model/&quot;</span>, <span class="hljs-string">&quot;my_configuration.json&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you&#x27;d like to try a minor variation to an existing configuration, you can also pass generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># arguments to \`.from_pretrained()\`. Be mindful that typos and unused arguments will be ignored</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config, unused_kwargs = GenerationConfig.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;gpt2&quot;</span>, top_k=<span class="hljs-number">1</span>, foo=<span class="hljs-literal">False</span>, do_sample=<span class="hljs-literal">True</span>, return_unused_kwargs=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_config.top_k
<span class="hljs-number">1</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>unused_kwargs
{<span class="hljs-string">&#x27;foo&#x27;</span>: <span class="hljs-literal">False</span>}`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function So(v){let t,u=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,a,o,m=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u,a=c(),o=i("p"),o.innerHTML=m},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1c5u34l"&&(t.innerHTML=u),a=d(e),o=l(e,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fvlq1g"&&(o.innerHTML=m)},m(e,f){g(e,t,f),g(e,a,f),g(e,o,f)},p:B,d(e){e&&(r(t),r(a),r(o))}}}function Lo(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, AutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.414</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.010</span> | <span class="hljs-number">13.40</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = transition_scores.<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function Eo(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a> directly. Use generate()
instead. For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-19r4b8v"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function zo(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMEElMjAlMjAlMjAlMjBMb2dpdHNQcm9jZXNzb3JMaXN0JTJDJTBBJTIwJTIwJTIwJTIwTWluTGVuZ3RoTG9naXRzUHJvY2Vzc29yJTJDJTBBJTIwJTIwJTIwJTIwU3RvcHBpbmdDcml0ZXJpYUxpc3QlMkMlMEElMjAlMjAlMjAlMjBNYXhMZW5ndGhDcml0ZXJpYSUyQyUwQSklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBJTBBJTIzJTIwc2V0JTIwcGFkX3Rva2VuX2lkJTIwdG8lMjBlb3NfdG9rZW5faWQlMjBiZWNhdXNlJTIwR1BUMiUyMGRvZXMlMjBub3QlMjBoYXZlJTIwYSUyMFBBRCUyMHRva2VuJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcucGFkX3Rva2VuX2lkJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZW9zX3Rva2VuX2lkJTBBJTBBaW5wdXRfcHJvbXB0JTIwJTNEJTIwJTIySXQlMjBtaWdodCUyMGJlJTIwcG9zc2libGUlMjB0byUyMiUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplcihpbnB1dF9wcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEElMjMlMjBpbnN0YW50aWF0ZSUyMGxvZ2l0cyUyMHByb2Nlc3NvcnMlMEFsb2dpdHNfcHJvY2Vzc29yJTIwJTNEJTIwTG9naXRzUHJvY2Vzc29yTGlzdCglMEElMjAlMjAlMjAlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNaW5MZW5ndGhMb2dpdHNQcm9jZXNzb3IoMTAlMkMlMjBlb3NfdG9rZW5faWQlM0Rtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZy5lb3NfdG9rZW5faWQpJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQXN0b3BwaW5nX2NyaXRlcmlhJTIwJTNEJTIwU3RvcHBpbmdDcml0ZXJpYUxpc3QoJTVCTWF4TGVuZ3RoQ3JpdGVyaWEobWF4X2xlbmd0aCUzRDIwKSU1RCklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ3JlZWR5X3NlYXJjaCglMEElMjAlMjAlMjAlMjBpbnB1dF9pZHMlMkMlMjBsb2dpdHNfcHJvY2Vzc29yJTNEbG9naXRzX3Byb2Nlc3NvciUyQyUyMHN0b3BwaW5nX2NyaXRlcmlhJTNEc3RvcHBpbmdfY3JpdGVyaWElMEEpJTBBJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.generation_config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;It might be possible to&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">10</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.greedy_search(
<span class="hljs-meta">... </span>    input_ids, logits_processor=logits_processor, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;It might be possible to get a better understanding of the nature of the problem, but it&#x27;s not&quot;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function Fo(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a> directly. Use generate() instead.
For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-gpv3bb"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function Ho(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because GPT2 does not have a EOS token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.pad_token_id = model.config.eos_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;Today is a beautiful day, and&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">15</span>, eos_token_id=model.generation_config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">20</span>)])

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.sample(
<span class="hljs-meta">... </span>    input_ids,
<span class="hljs-meta">... </span>    logits_processor=logits_processor,
<span class="hljs-meta">... </span>    logits_warper=logits_warper,
<span class="hljs-meta">... </span>    stopping_criteria=stopping_criteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Today is a beautiful day, and we must do everything possible to make it a day of celebration.&#x27;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function Qo(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> directly. Use generate()
instead. For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-13hc8o3"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function Yo(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_search(input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function Ao(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a> directly. Use generate()
instead. For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-ks407b"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function Do(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    TopKLogitsWarper,
<span class="hljs-meta">... </span>    TemperatureLogitsWarper,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_warper = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        TopKLogitsWarper(<span class="hljs-number">50</span>),
<span class="hljs-meta">... </span>        TemperatureLogitsWarper(<span class="hljs-number">0.7</span>),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.beam_sample(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, logits_warper=logits_warper, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function Oo(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a> directly. Use
generate() instead. For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1ejoj1d"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function qo(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBBdXRvVG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMEElMjAlMjAlMjAlMjBTdG9wcGluZ0NyaXRlcmlhTGlzdCUyQyUwQSUyMCUyMCUyMCUyME1heExlbmd0aENyaXRlcmlhJTJDJTBBKSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGb3B0LTEyNW0lMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZvcHQtMTI1bSUyMiklMEElMjMlMjBzZXQlMjBwYWRfdG9rZW5faWQlMjB0byUyMGVvc190b2tlbl9pZCUyMGJlY2F1c2UlMjBPUFQlMjBkb2VzJTIwbm90JTIwaGF2ZSUyMGElMjBQQUQlMjB0b2tlbiUwQW1vZGVsLmNvbmZpZy5wYWRfdG9rZW5faWQlMjAlM0QlMjBtb2RlbC5jb25maWcuZW9zX3Rva2VuX2lkJTBBaW5wdXRfcHJvbXB0JTIwJTNEJTIwJTIyRGVlcE1pbmQlMjBDb21wYW55JTIwaXMlMjIlMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFzdG9wcGluZ19jcml0ZXJpYSUyMCUzRCUyMFN0b3BwaW5nQ3JpdGVyaWFMaXN0KCU1Qk1heExlbmd0aENyaXRlcmlhKG1heF9sZW5ndGglM0Q2NCklNUQpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmNvbnRyYXN0aXZlX3NlYXJjaCglMEElMjAlMjAlMjAlMjAqKmlucHV0X2lkcyUyQyUyMHBlbmFsdHlfYWxwaGElM0QwLjYlMkMlMjB0b3BfayUzRDQlMkMlMjBzdG9wcGluZ19jcml0ZXJpYSUzRHN0b3BwaW5nX2NyaXRlcmlhJTBBKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForCausalLM,
<span class="hljs-meta">... </span>    StoppingCriteriaList,
<span class="hljs-meta">... </span>    MaxLengthCriteria,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/opt-125m&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set pad_token_id to eos_token_id because OPT does not have a PAD token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.config.pad_token_id = model.config.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>input_prompt = <span class="hljs-string">&quot;DeepMind Company is&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(input_prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>stopping_criteria = StoppingCriteriaList([MaxLengthCriteria(max_length=<span class="hljs-number">64</span>)])
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.contrastive_search(
<span class="hljs-meta">... </span>    **input_ids, penalty_alpha=<span class="hljs-number">0.6</span>, top_k=<span class="hljs-number">4</span>, stopping_criteria=stopping_criteria
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;DeepMind Company is a company that focuses on the development and commercialization of artificial intelligence (AI). DeepMind’s mission is to help people understand and solve problems that are difficult to solve in the world today.\\n\\nIn this post, we talk about the benefits of deep learning in business and how it&#x27;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function Po(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a> directly. Use
generate() instead. For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1olo4rv"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function Ko(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    HammingDiversityLogitsProcessor,
<span class="hljs-meta">... </span>    BeamSearchScorer,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run diverse beam search using 6 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">6</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = BeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    max_length=model.config.max_length,
<span class="hljs-meta">... </span>    num_beams=num_beams,
<span class="hljs-meta">... </span>    device=model.device,
<span class="hljs-meta">... </span>    num_beam_groups=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        HammingDiversityLogitsProcessor(<span class="hljs-number">5.5</span>, num_beams=<span class="hljs-number">6</span>, num_beam_groups=<span class="hljs-number">3</span>),
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.group_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt bist du?&#x27;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function ea(v){let t,u=`In most cases, you do not need to call <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a> directly. Use
generate() instead. For an overview of generation strategies and code examples, check the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u},l(a){t=l(a,"P",{"data-svelte-h":!0}),h(t)!=="svelte-gbpyrz"&&(t.innerHTML=u)},m(a,o){g(a,t,o)},p:B,d(a){a&&r(t)}}}function na(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    AutoTokenizer,
<span class="hljs-meta">... </span>    AutoModelForSeq2SeqLM,
<span class="hljs-meta">... </span>    LogitsProcessorList,
<span class="hljs-meta">... </span>    MinLengthLogitsProcessor,
<span class="hljs-meta">... </span>    ConstrainedBeamSearchScorer,
<span class="hljs-meta">... </span>    PhrasalConstraint,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_str = <span class="hljs-string">&quot;translate English to German: How old are you?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoder_input_ids = tokenizer(encoder_input_str, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># lets run beam search using 3 beams</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_beams = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define decoder start token ids</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.ones((num_beams, <span class="hljs-number">1</span>), device=model.device, dtype=torch.long)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = input_ids * model.config.decoder_start_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># add encoder_outputs to model keyword arguments</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_kwargs = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;encoder_outputs&quot;</span>: model.get_encoder()(
<span class="hljs-meta">... </span>        encoder_input_ids.repeat_interleave(num_beams, dim=<span class="hljs-number">0</span>), return_dict=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>    )
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_str = <span class="hljs-string">&quot;Sie&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraint_token_ids = tokenizer.encode(constraint_str)[:-<span class="hljs-number">1</span>]  <span class="hljs-comment"># slice to remove eos token</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>constraints = [PhrasalConstraint(token_ids=constraint_token_ids)]


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate beam scorer</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>beam_scorer = ConstrainedBeamSearchScorer(
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">1</span>, num_beams=num_beams, device=model.device, constraints=constraints
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># instantiate logits processors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>logits_processor = LogitsProcessorList(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        MinLengthLogitsProcessor(<span class="hljs-number">5</span>, eos_token_id=model.config.eos_token_id),
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.constrained_beam_search(
<span class="hljs-meta">... </span>    input_ids, beam_scorer, constraints=constraints, logits_processor=logits_processor, **model_kwargs
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;Wie alt sind Sie?&#x27;</span>]`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function ta(v){let t,u=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate, e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,a,o,m=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=i("p"),t.innerHTML=u,a=c(),o=i("p"),o.innerHTML=m},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-1pahvb2"&&(t.innerHTML=u),a=d(e),o=l(e,"P",{"data-svelte-h":!0}),h(o)!=="svelte-fvlq1g"&&(o.innerHTML=m)},m(e,f){g(e,t,f),g(e,a,f),g(e,o,f)},p:B,d(e){e&&(r(t),r(a),r(o))}}}function sa(v){let t,u="Examples:",a,o,m;return o=new P({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2Tokenizer, TFAutoModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = GPT2Tokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.pad_token_id = tokenizer.eos_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer([<span class="hljs-string">&quot;Today is&quot;</span>], return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 1: Print the scores for each token generated with Greedy Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_new_tokens=<span class="hljs-number">5</span>, return_dict_in_generate=<span class="hljs-literal">True</span>, output_scores=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, normalize_logits=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># input_length is the length of the input prompt for decoder-only models, like the GPT family, and 1 for</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># encoder-decoder models, like BART or T5.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_length = <span class="hljs-number">1</span> <span class="hljs-keyword">if</span> model.config.is_encoder_decoder <span class="hljs-keyword">else</span> inputs.input_ids.shape[<span class="hljs-number">1</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = outputs.sequences[:, input_length:]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> tok, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(generated_tokens[<span class="hljs-number">0</span>], transition_scores[<span class="hljs-number">0</span>]):
<span class="hljs-meta">... </span>    <span class="hljs-comment"># | token | token string | logits | probability</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;| <span class="hljs-subst">{tok:5d}</span> | <span class="hljs-subst">{tokenizer.decode(tok):8s}</span> | <span class="hljs-subst">{score.numpy():<span class="hljs-number">.3</span>f}</span> | <span class="hljs-subst">{np.exp(score.numpy()):<span class="hljs-number">.2</span>%}</span>&quot;</span>)
|   <span class="hljs-number">262</span> |  the     | -<span class="hljs-number">1.413</span> | <span class="hljs-number">24.33</span>%
|  <span class="hljs-number">1110</span> |  day     | -<span class="hljs-number">2.609</span> | <span class="hljs-number">7.36</span>%
|   <span class="hljs-number">618</span> |  when    | -<span class="hljs-number">2.009</span> | <span class="hljs-number">13.41</span>%
|   <span class="hljs-number">356</span> |  we      | -<span class="hljs-number">1.859</span> | <span class="hljs-number">15.58</span>%
|   <span class="hljs-number">460</span> |  can     | -<span class="hljs-number">2.508</span> | <span class="hljs-number">8.14</span>%

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Example 2: Reconstruct the sequence scores from Beam Search</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(
<span class="hljs-meta">... </span>    **inputs,
<span class="hljs-meta">... </span>    max_new_tokens=<span class="hljs-number">5</span>,
<span class="hljs-meta">... </span>    num_beams=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    return_dict_in_generate=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    output_scores=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>transition_scores = model.compute_transition_scores(
<span class="hljs-meta">... </span>    outputs.sequences, outputs.scores, outputs.beam_indices, normalize_logits=<span class="hljs-literal">False</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># If you sum the generated tokens&#x27; scores and apply the length penalty, you&#x27;ll get the sequence scores.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Tip: recomputing the scores is only guaranteed to match with \`normalize_logits=False\`. Depending on the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use case, you might want to recompute it with \`normalize_logits=True\`.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_length = input_length + np.<span class="hljs-built_in">sum</span>(transition_scores.numpy() &lt; <span class="hljs-number">0</span>, axis=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>length_penalty = model.generation_config.length_penalty
<span class="hljs-meta">&gt;&gt;&gt; </span>reconstructed_scores = np.<span class="hljs-built_in">sum</span>(transition_scores, axis=<span class="hljs-number">1</span>) / (output_length**length_penalty)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(np.allclose(outputs.sequences_scores, reconstructed_scores))
<span class="hljs-literal">True</span>`,wrap:!1}}),{c(){t=i("p"),t.textContent=u,a=c(),_(o.$$.fragment)},l(e){t=l(e,"P",{"data-svelte-h":!0}),h(t)!=="svelte-kvfsh7"&&(t.textContent=u),a=d(e),M(o.$$.fragment,e)},m(e,f){g(e,t,f),g(e,a,f),y(o,e,f),m=!0},p:B,i(e){m||(b(o.$$.fragment,e),m=!0)},o(e){T(o.$$.fragment,e),m=!1},d(e){e&&(r(t),r(a)),w(o,e)}}}function oa(v){let t,u,a,o,m,e,f,Ve,Gt,_n,Fs="Generation",mt,Re,Hs="Each framework has a generate method for text generation implemented in their respective <code>GenerationMixin</code> class:",gt,$e,Qs='<li>PyTorch <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin">GenerationMixin</a>.</li> <li>TensorFlow <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.TFGenerationMixin">TFGenerationMixin</a>.</li> <li>Flax/JAX <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a> is implemented in <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.FlaxGenerationMixin">FlaxGenerationMixin</a>.</li>',ut,Se,Ys=`Regardless of your framework of choice, you can parameterize the generate method with a <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>
class instance. Please refer to this class for the complete list of generation parameters, which control the behavior
of the generation method.`,ht,Le,As=`To learn how to inspect a model’s generation configuration, what are the defaults, how to change the parameters ad hoc,
and how to create and save a customized generation configuration, refer to the
<a href="../generation_strategies">text generation strategies guide</a>. The guide also explains how to use related features,
like token streaming.`,ft,K,ie,et,Ee,Zt,Mn,Ds="GenerationConfig",_t,k,ze,Bt,yn,Os=`Class that holds a configuration for a generation task. A <code>generate</code> call supports the following generation methods
for text-decoder, text-to-text, speech-to-text, and vision-to-text models:`,Ct,bn,qs=`<li><em>greedy decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a> if <code>penalty_alpha&gt;0.</code>
and <code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a> if
<code>num_beams&gt;1</code> and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, if
<code>num_beams&gt;1</code> and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>, if
<code>constraints!=None</code> or <code>force_words_ids!=None</code></li> <li><em>assisted decoding</em> by calling <code>assisted_decoding()</code>, if
<code>assistant_model</code> is passed to <code>.generate()</code></li>`,It,Tn,Ps=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘.generate()‘. To learn
more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Wt,Q,Fe,Xt,wn,Ks='Instantiate a <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a generation configuration file.',Nt,le,Vt,ce,He,Rt,jn,eo=`Instantiates a <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a> from a <a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>. This function is useful to convert legacy
<a href="/docs/transformers/v4.34.0/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> objects, which may contain generation parameters, into a stand-alone <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>.`,$t,de,Qe,St,vn,no=`Save a generation configuration object to the directory <code>save_directory</code>, so that it can be re-loaded using the
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig.from_pretrained">from_pretrained()</a> class method.`,Mt,ee,pe,nt,Ye,Lt,Jn,to="GenerationMixin",yt,U,Ae,Et,Un,so='A class containing all functions for auto-regressive text generation, to be used as a mixin in <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>.',zt,xn,oo='The class exposes <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.generate">generate()</a>, which can be used for:',Ft,kn,ao=`<li><em>greedy decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.greedy_search">greedy_search()</a> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.contrastive_search">contrastive_search()</a> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.sample">sample()</a> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_search">beam_search()</a> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li> <li><em>beam-search multinomial sampling</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.beam_sample">beam_sample()</a> if <code>num_beams&gt;1</code>
and <code>do_sample=True</code></li> <li><em>diverse beam-search decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.group_beam_search">group_beam_search()</a>, if <code>num_beams&gt;1</code>
and <code>num_beam_groups&gt;1</code></li> <li><em>constrained beam-search decoding</em> by calling <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationMixin.constrained_beam_search">constrained_beam_search()</a>, if
<code>constraints!=None</code> or <code>force_words_ids!=None</code></li>`,Ht,Gn,ro=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Qt,Y,De,Yt,Zn,io="Generates sequences of token ids for models with a language modeling head.",At,me,Dt,A,Oe,Ot,Bn,lo=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,qt,ge,Pt,X,qe,Kt,Cn,co=`Generates sequences of token ids for models with a language modeling head using <strong>greedy decoding</strong> and can be
used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,es,ue,ns,he,ts,N,Pe,ss,In,po=`Generates sequences of token ids for models with a language modeling head using <strong>multinomial sampling</strong> and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,os,fe,as,_e,rs,V,Ke,is,Wn,mo=`Generates sequences of token ids for models with a language modeling head using <strong>beam search decoding</strong> and
can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,ls,Me,cs,ye,ds,R,en,ps,Xn,go=`Generates sequences of token ids for models with a language modeling head using <strong>beam search multinomial
sampling</strong> and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,ms,be,gs,Te,us,$,nn,hs,Nn,uo=`Generates sequences of token ids for models with a language modeling head using <strong>contrastive search</strong> and can
be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,fs,we,_s,je,Ms,S,tn,ys,Vn,ho=`Generates sequences of token ids for models with a language modeling head using <strong>diverse beam search
decoding</strong> and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,bs,ve,Ts,Je,ws,L,sn,js,Rn,fo=`Generates sequences of token ids for models with a language modeling head using <strong>constrained beam search
decoding</strong> and can be used for text-decoder, text-to-text, speech-to-text, and vision-to-text models.`,vs,Ue,Js,xe,bt,ne,ke,tt,on,Us,$n,_o="TFGenerationMixin",Tt,G,an,xs,Sn,Mo='A class containing all of the functions supporting generation, to be used as a mixin in <a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.TFPreTrainedModel">TFPreTrainedModel</a>.',ks,Ln,yo='The class exposes <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.TFGenerationMixin.generate">generate()</a>, which can be used for:',Gs,En,bo=`<li><em>greedy decoding</em> by calling <code>greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>contrastive search</em> by calling <code>contrastive_search()</code> if <code>penalty_alpha&gt;0</code> and
<code>top_k&gt;1</code></li> <li><em>multinomial sampling</em> by calling <code>sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>beam_search()</code> if <code>num_beams&gt;1</code></li>`,Zs,zn,To=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Bs,D,rn,Cs,Fn,wo="Generates sequences of token ids for models with a language modeling head.",Is,Ge,Ws,O,ln,Xs,Hn,jo=`Computes the transition scores of sequences given the generation scores (and beam indices, if beam search was
used). This is a convenient method to quicky obtain the scores of the selected tokens at generation time.`,Ns,Ze,wt,te,Be,st,cn,Vs,Qn,vo="FlaxGenerationMixin",jt,C,dn,Rs,Yn,Jo=`A class containing all functions for auto-regressive text generation, to be used as a mixin in
<a href="/docs/transformers/v4.34.0/en/main_classes/model#transformers.FlaxPreTrainedModel">FlaxPreTrainedModel</a>.`,$s,An,Uo='The class exposes <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.FlaxGenerationMixin.generate">generate()</a>, which can be used for:',Ss,Dn,xo=`<li><em>greedy decoding</em> by calling <code>_greedy_search()</code> if <code>num_beams=1</code> and
<code>do_sample=False</code></li> <li><em>multinomial sampling</em> by calling <code>_sample()</code> if <code>num_beams=1</code> and
<code>do_sample=True</code></li> <li><em>beam-search decoding</em> by calling <code>_beam_search()</code> if <code>num_beams&gt;1</code> and
<code>do_sample=False</code></li>`,Ls,On,ko=`You do not need to call any of the above methods directly. Pass custom parameter values to ‘generate’ instead. To
learn more about decoding strategies refer to the <a href="../generation_strategies">text generation strategies guide</a>.`,Es,Ce,pn,zs,qn,Go="Generates sequences of token ids for models with a language modeling head.",vt,ot,Jt;return Ve=new pt({}),Ee=new pt({}),ze=new Z({props:{name:"class transformers.GenerationConfig",anchor:"transformers.GenerationConfig",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/configuration_utils.py#L40",parameterGroups:[{title:"Parameters that control the length of the output",parametersDescription:[{anchor:"transformers.GenerationConfig.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
The maximum length the generated tokens can have. Corresponds to the length of the input prompt +
<code>max_new_tokens</code>. Its effect is overridden by <code>max_new_tokens</code>, if also set.`,name:"max_length"},{anchor:"transformers.GenerationConfig.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"max_new_tokens"},{anchor:"transformers.GenerationConfig.min_length",description:`<strong>min_length</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The minimum length of the sequence to be generated. Corresponds to the length of the input prompt +
<code>min_new_tokens</code>. Its effect is overridden by <code>min_new_tokens</code>, if also set.`,name:"min_length"},{anchor:"transformers.GenerationConfig.min_new_tokens",description:`<strong>min_new_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum numbers of tokens to generate, ignoring the number of tokens in the prompt.`,name:"min_new_tokens"},{anchor:"transformers.GenerationConfig.early_stopping",description:`<strong>early_stopping</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Controls the stopping condition for beam-based methods, like beam-search. It accepts the following values:
<code>True</code>, where the generation stops as soon as there are <code>num_beams</code> complete candidates; <code>False</code>, where an
heuristic is applied and the generation stops when is it very unlikely to find better candidates;
<code>&quot;never&quot;</code>, where the beam search procedure only stops when there cannot be better candidates (canonical
beam search algorithm).`,name:"early_stopping"},{anchor:"transformers.GenerationConfig.max_time(float,",description:`<strong>max_time(<code>float</code>,</strong> <em>optional</em>) &#x2014;
The maximum amount of time you allow the computation to run for in seconds. generation will still finish
the current pass after allocated time has been passed.`,name:"max_time(float,"}]},{title:"Parameters that control the generation strategy used",parametersDescription:[{anchor:"transformers.GenerationConfig.do_sample",description:`<strong>do_sample</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to use sampling ; use greedy decoding otherwise.`,name:"do_sample"},{anchor:"transformers.GenerationConfig.num_beams",description:`<strong>num_beams</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of beams for beam search. 1 means no beam search.`,name:"num_beams"},{anchor:"transformers.GenerationConfig.num_beam_groups",description:`<strong>num_beam_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of groups to divide <code>num_beams</code> into in order to ensure diversity among different groups of beams.
<a href="https://arxiv.org/pdf/1610.02424.pdf" rel="nofollow">this paper</a> for more details.`,name:"num_beam_groups"},{anchor:"transformers.GenerationConfig.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The values balance the model confidence and the degeneration penalty in contrastive search decoding.`,name:"penalty_alpha"},{anchor:"transformers.GenerationConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should use the past last key/values attentions (if applicable to the model) to
speed up decoding.`,name:"use_cache"}]},{title:"Parameters for manipulation of the model output logits",parametersDescription:[{anchor:"transformers.GenerationConfig.temperature",description:`<strong>temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value used to modulate the next token probabilities.`,name:"temperature"},{anchor:"transformers.GenerationConfig.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of highest probability vocabulary tokens to keep for top-k-filtering.`,name:"top_k"},{anchor:"transformers.GenerationConfig.top_p",description:`<strong>top_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
If set to float &lt; 1, only the smallest set of most probable tokens with probabilities that add up to
<code>top_p</code> or higher are kept for generation.`,name:"top_p"},{anchor:"transformers.GenerationConfig.typical_p",description:`<strong>typical_p</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Local typicality measures how similar the conditional probability of predicting a target token next is to
the expected conditional probability of predicting a random token next, given the partial text already
generated. If set to float &lt; 1, the smallest set of the most locally typical tokens with probabilities that
add up to <code>typical_p</code> or higher are kept for generation. See <a href="https://arxiv.org/pdf/2202.00666.pdf" rel="nofollow">this
paper</a> for more details.`,name:"typical_p"},{anchor:"transformers.GenerationConfig.epsilon_cutoff",description:`<strong>epsilon_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
If set to float strictly between 0 and 1, only tokens with a conditional probability greater than
<code>epsilon_cutoff</code> will be sampled. In the paper, suggested values range from 3e-4 to 9e-4, depending on the
size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"epsilon_cutoff"},{anchor:"transformers.GenerationConfig.eta_cutoff",description:`<strong>eta_cutoff</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Eta sampling is a hybrid of locally typical sampling and epsilon sampling. If set to float strictly between
0 and 1, a token is only considered if it is greater than either <code>eta_cutoff</code> or <code>sqrt(eta_cutoff) * exp(-entropy(softmax(next_token_logits)))</code>. The latter term is intuitively the expected next token
probability, scaled by <code>sqrt(eta_cutoff)</code>. In the paper, suggested values range from 3e-4 to 2e-3,
depending on the size of the model. See <a href="https://arxiv.org/abs/2210.15191" rel="nofollow">Truncation Sampling as Language Model
Desmoothing</a> for more details.`,name:"eta_cutoff"},{anchor:"transformers.GenerationConfig.diversity_penalty",description:`<strong>diversity_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
This value is subtracted from a beam&#x2019;s score if it generates a token same as any beam from other group at a
particular time. Note that <code>diversity_penalty</code> is only effective if <code>group beam search</code> is enabled.`,name:"diversity_penalty"},{anchor:"transformers.GenerationConfig.repetition_penalty",description:`<strong>repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The parameter for repetition penalty. 1.0 means no penalty. See <a href="https://arxiv.org/pdf/1909.05858.pdf" rel="nofollow">this
paper</a> for more details.`,name:"repetition_penalty"},{anchor:"transformers.GenerationConfig.encoder_repetition_penalty",description:`<strong>encoder_repetition_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The paramater for encoder_repetition_penalty. An exponential penalty on sequences that are not in the
original input. 1.0 means no penalty.`,name:"encoder_repetition_penalty"},{anchor:"transformers.GenerationConfig.length_penalty",description:`<strong>length_penalty</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Exponential penalty to the length that is used with beam-based generation. It is applied as an exponent to
the sequence length, which in turn is used to divide the score of the sequence. Since the score is the log
likelihood of the sequence (i.e. negative), <code>length_penalty</code> &gt; 0.0 promotes longer sequences, while
<code>length_penalty</code> &lt; 0.0 encourages shorter sequences.`,name:"length_penalty"},{anchor:"transformers.GenerationConfig.no_repeat_ngram_size",description:`<strong>no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size can only occur once.`,name:"no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.bad_words_ids(List[List[int]],",description:`<strong>bad_words_ids(<code>List[List[int]]</code>,</strong> <em>optional</em>) &#x2014;
List of list of token ids that are not allowed to be generated. Check
<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.NoBadWordsLogitsProcessor">NoBadWordsLogitsProcessor</a> for further documentation and examples.`,name:"bad_words_ids(List[List[int]],"},{anchor:"transformers.GenerationConfig.force_words_ids(List[List[int]]",description:`<strong>force_words_ids(<code>List[List[int]]</code></strong> or <code>List[List[List[int]]]</code>, <em>optional</em>) &#x2014;
List of token ids that must be generated. If given a <code>List[List[int]]</code>, this is treated as a simple list of
words that must be included, the opposite to <code>bad_words_ids</code>. If given <code>List[List[List[int]]]</code>, this
triggers a <a href="https://github.com/huggingface/transformers/issues/14081" rel="nofollow">disjunctive constraint</a>, where one
can allow different forms of each word.`,name:"force_words_ids(List[List[int]]"},{anchor:"transformers.GenerationConfig.renormalize_logits",description:`<strong>renormalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to renormalize the logits after applying all the logits processors or warpers (including the custom
ones). It&#x2019;s highly recommended to set this flag to <code>True</code> as the search algorithms suppose the score logits
are normalized but some logit processors or warpers break the normalization.`,name:"renormalize_logits"},{anchor:"transformers.GenerationConfig.constraints",description:`<strong>constraints</strong> (<code>List[Constraint]</code>, <em>optional</em>) &#x2014;
Custom constraints that can be added to the generation to ensure that the output will contain the use of
certain tokens as defined by <code>Constraint</code> objects, in the most sensible way possible.`,name:"constraints"},{anchor:"transformers.GenerationConfig.forced_bos_token_id",description:`<strong>forced_bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to <code>model.config.forced_bos_token_id</code>) &#x2014;
The id of the token to force as the first generated token after the <code>decoder_start_token_id</code>. Useful for
multilingual models like <a href="../model_doc/mbart">mBART</a> where the first generated token needs to be the target
language token.`,name:"forced_bos_token_id"},{anchor:"transformers.GenerationConfig.forced_eos_token_id",description:`<strong>forced_eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to <code>model.config.forced_eos_token_id</code>) &#x2014;
The id of the token to force as the last generated token when <code>max_length</code> is reached. Optionally, use a
list to set multiple <em>end-of-sequence</em> tokens.`,name:"forced_eos_token_id"},{anchor:"transformers.GenerationConfig.remove_invalid_values",description:`<strong>remove_invalid_values</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>model.config.remove_invalid_values</code>) &#x2014;
Whether to remove possible <em>nan</em> and <em>inf</em> outputs of the model to prevent the generation method to crash.
Note that using <code>remove_invalid_values</code> can slow down generation.`,name:"remove_invalid_values"},{anchor:"transformers.GenerationConfig.exponential_decay_length_penalty",description:`<strong>exponential_decay_length_penalty</strong> (<code>tuple(int, float)</code>, <em>optional</em>) &#x2014;
This Tuple adds an exponentially increasing length penalty, after a certain amount of tokens have been
generated. The tuple shall consist of: <code>(start_index, decay_factor)</code> where <code>start_index</code> indicates where
penalty starts and <code>decay_factor</code> represents the factor of exponential decay`,name:"exponential_decay_length_penalty"},{anchor:"transformers.GenerationConfig.suppress_tokens",description:`<strong>suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at generation. The <code>SupressTokens</code> logit processor will set their
log probs to <code>-inf</code> so that they are not sampled.`,name:"suppress_tokens"},{anchor:"transformers.GenerationConfig.begin_suppress_tokens",description:`<strong>begin_suppress_tokens</strong>  (<code>List[int]</code>, <em>optional</em>) &#x2014;
A list of tokens that will be suppressed at the beginning of the generation. The <code>SupressBeginTokens</code> logit
processor will set their log probs to <code>-inf</code> so that they are not sampled.`,name:"begin_suppress_tokens"},{anchor:"transformers.GenerationConfig.forced_decoder_ids",description:`<strong>forced_decoder_ids</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of pairs of integers which indicates a mapping from generation indices to token indices that will be
forced before sampling. For example, <code>[[1, 123]]</code> means the second generated token will always be a token
of index 123.`,name:"forced_decoder_ids"},{anchor:"transformers.GenerationConfig.sequence_bias",description:`<strong>sequence_bias</strong> (<code>Dict[Tuple[int], float]</code>, <em>optional</em>)) &#x2014;
Dictionary that maps a sequence of tokens to its bias term. Positive biases increase the odds of the
sequence being selected, while negative biases do the opposite. Check
<a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.SequenceBiasLogitsProcessor">SequenceBiasLogitsProcessor</a> for further documentation and examples.`,name:"sequence_bias"},{anchor:"transformers.GenerationConfig.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
The guidance scale for classifier free guidance (CFG). CFG is enabled by setting <code>guidance_scale &gt; 1</code>.
Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer quality.`,name:"guidance_scale"},{anchor:"transformers.GenerationConfig.low_memory",description:`<strong>low_memory</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switch to sequential topk for contrastive search to reduce peak memory. Used with contrastive search.`,name:"low_memory"}]},{title:"Parameters that define the output variables of `generate`",parametersDescription:[{anchor:"transformers.GenerationConfig.num_return_sequences(int,",description:`<strong>num_return_sequences(<code>int</code>,</strong> <em>optional</em>, defaults to 1) &#x2014;
The number of independently computed returned sequences for each element in the batch.`,name:"num_return_sequences(int,"},{anchor:"transformers.GenerationConfig.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationConfig.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationConfig.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationConfig.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"}]},{title:"Special tokens that can be used at generation time",parametersDescription:[{anchor:"transformers.GenerationConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.GenerationConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"}]},{title:"Generation parameters exclusive to encoder-decoder models",parametersDescription:[{anchor:"transformers.GenerationConfig.encoder_no_repeat_ngram_size",description:`<strong>encoder_no_repeat_ngram_size</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to int &gt; 0, all ngrams of that size that occur in the <code>encoder_input_ids</code> cannot occur in the
<code>decoder_input_ids</code>.`,name:"encoder_no_repeat_ngram_size"},{anchor:"transformers.GenerationConfig.decoder_start_token_id",description:`<strong>decoder_start_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If an encoder-decoder model starts decoding with a different token than <em>bos</em>, the id of that token.`,name:"decoder_start_token_id"}]},{title:"Wild card",parametersDescription:[]}]}}),Fe=new Z({props:{name:"from_pretrained",anchor:"transformers.GenerationConfig.from_pretrained",parameters:[{name:"pretrained_model_name",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"cache_dir",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_pretrained.pretrained_model_name",description:`<strong>pretrained_model_name</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained model configuration hosted inside a model repo on
huggingface.co. Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or
namespaced under a user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>a path to a <em>directory</em> containing a configuration file saved using the
<a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"pretrained_model_name"},{anchor:"transformers.GenerationConfig.from_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be loaded from <code>pretrained_model_name</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"transformers.GenerationConfig.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to force to (re-)download the configuration files and override the cached versions if
they exist.`,name:"force_download"},{anchor:"transformers.GenerationConfig.from_pretrained.resume_download",description:`<strong>resume_download</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to delete incompletely received file. Attempts to resume the download if such a file
exists.`,name:"resume_download"},{anchor:"transformers.GenerationConfig.from_pretrained.proxies",description:`<strong>proxies</strong> (<code>Dict[str, str]</code>, <em>optional</em>) &#x2014;
A dictionary of proxy servers to use by protocol or endpoint, e.g., <code>{&apos;http&apos;: &apos;foo.bar:3128&apos;, &apos;http://hostname&apos;: &apos;foo.bar:4012&apos;}.</code> The proxies are used on each request.`,name:"proxies"},{anchor:"transformers.GenerationConfig.from_pretrained.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, or not specified, will use
the token generated when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>).`,name:"token"},{anchor:"transformers.GenerationConfig.from_pretrained.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;main&quot;</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>To test a pull request you made on the Hub, you can pass \`revision=&#x201C;refs/pr/<pr_number>&#x201C;.</pr_number></p>

					</div>`,name:"revision"},{anchor:"transformers.GenerationConfig.from_pretrained.return_unused_kwargs",description:`<strong>return_unused_kwargs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>False</code>, then this function returns just the final configuration object.</p>
<p>If <code>True</code>, then this functions returns a <code>Tuple(config, unused_kwargs)</code> where <em>unused_kwargs</em> is a
dictionary consisting of the key/value pairs whose keys are not configuration attributes: i.e., the
part of <code>kwargs</code> which has not been used to update <code>config</code> and is otherwise ignored.`,name:"return_unused_kwargs"},{anchor:"transformers.GenerationConfig.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"transformers.GenerationConfig.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
The values in kwargs of any keys which are configuration attributes will be used to override the loaded
values. Behavior concerning key/value pairs whose keys are <em>not</em> configuration attributes is controlled
by the <code>return_unused_kwargs</code> keyword parameter.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/configuration_utils.py#L555",returnDescription:`
<p>The configuration object instantiated from this pretrained model.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),le=new q({props:{anchor:"transformers.GenerationConfig.from_pretrained.example",$$slots:{default:[$o]},$$scope:{ctx:v}}}),He=new Z({props:{name:"from_model_config",anchor:"transformers.GenerationConfig.from_model_config",parameters:[{name:"model_config",val:": PretrainedConfig"}],parametersDescription:[{anchor:"transformers.GenerationConfig.from_model_config.model_config",description:`<strong>model_config</strong> (<code>PretrainedConfig</code>) &#x2014;
The model config that will be used to instantiate the generation config.`,name:"model_config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/configuration_utils.py#L871",returnDescription:`
<p>The configuration object instantiated from those parameters.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig"
>GenerationConfig</a></p>
`}}),Qe=new Z({props:{name:"save_pretrained",anchor:"transformers.GenerationConfig.save_pretrained",parameters:[{name:"save_directory",val:": typing.Union[str, os.PathLike]"},{name:"config_file_name",val:": typing.Union[str, os.PathLike, NoneType] = None"},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationConfig.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the configuration JSON file will be saved (will be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.GenerationConfig.save_pretrained.config_file_name",description:`<strong>config_file_name</strong> (<code>str</code> or <code>os.PathLike</code>, <em>optional</em>, defaults to <code>&quot;generation_config.json&quot;</code>) &#x2014;
Name of the generation configuration JSON file to be saved in <code>save_directory</code>.`,name:"config_file_name"},{anchor:"transformers.GenerationConfig.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.GenerationConfig.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.34.0/en/main_classes/processors#transformers.ProcessorMixin.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/configuration_utils.py#L477"}}),Ye=new pt({}),Ae=new Z({props:{name:"class transformers.GenerationMixin",anchor:"transformers.GenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L491"}}),De=new Z({props:{name:"generate",anchor:"transformers.GenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.GenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.GenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.GenerationMixin.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.GenerationMixin.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.GenerationMixin.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.GenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L1300",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),me=new re({props:{warning:!0,$$slots:{default:[So]},$$scope:{ctx:v}}}),Oe=new Z({props:{name:"compute_transition_scores",anchor:"transformers.GenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[torch.Tensor]"},{name:"beam_indices",val:": typing.Optional[torch.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.GenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>torch.LongTensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.GenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>torch.FloatTensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with
each tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.GenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>torch.LongTensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.GenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L1058",returnDescription:`
<p>A <code>torch.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>torch.Tensor</code></p>
`}}),ge=new q({props:{anchor:"transformers.GenerationMixin.compute_transition_scores.example",$$slots:{default:[Lo]},$$scope:{ctx:v}}}),qe=new Z({props:{name:"greedy_search",anchor:"transformers.GenerationMixin.greedy_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.greedy_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.greedy_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.greedy_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.greedy_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.greedy_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.greedy_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.greedy_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.greedy_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.greedy_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.greedy_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.greedy_search.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L2286",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ue=new re({props:{warning:!0,$$slots:{default:[Eo]},$$scope:{ctx:v}}}),he=new q({props:{anchor:"transformers.GenerationMixin.greedy_search.example",$$slots:{default:[zo]},$$scope:{ctx:v}}}),Pe=new Z({props:{name:"sample",anchor:"transformers.GenerationMixin.sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.sample.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"streamer"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L2545",returnDescription:`
<p>A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a> or <code>torch.LongTensor</code></p>
`}}),fe=new re({props:{warning:!0,$$slots:{default:[Fo]},$$scope:{ctx:v}}}),_e=new q({props:{anchor:"transformers.GenerationMixin.sample.example",$$slots:{default:[Ho]},$$scope:{ctx:v}}}),Ke=new Z({props:{name:"beam_search",anchor:"transformers.GenerationMixin.beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L2827",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Me=new re({props:{warning:!0,$$slots:{default:[Qo]},$$scope:{ctx:v}}}),ye=new q({props:{anchor:"transformers.GenerationMixin.beam_search.example",$$slots:{default:[Yo]},$$scope:{ctx:v}}}),en=new Z({props:{name:"beam_sample",anchor:"transformers.GenerationMixin.beam_sample",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.beam_sample.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.beam_sample.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.beam_sample.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.beam_sample.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.beam_sample.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.beam_sample.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.beam_sample.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.beam_sample.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.beam_sample.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.beam_sample.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.beam_sample.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.beam_sample.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L3150",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),be=new re({props:{warning:!0,$$slots:{default:[Ao]},$$scope:{ctx:v}}}),Te=new q({props:{anchor:"transformers.GenerationMixin.beam_sample.example",$$slots:{default:[Do]},$$scope:{ctx:v}}}),nn=new Z({props:{name:"contrastive_search",anchor:"transformers.GenerationMixin.contrastive_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"top_k",val:": typing.Optional[int] = 1"},{name:"penalty_alpha",val:": typing.Optional[float] = 0"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"logits_warper",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"sequential",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.contrastive_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.contrastive_search.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The size of the candidate set that is used to re-rank for contrastive search`,name:"top_k"},{anchor:"transformers.GenerationMixin.contrastive_search.penalty_alpha",description:`<strong>penalty_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The degeneration penalty for contrastive search; activate when it is larger than 0`,name:"penalty_alpha"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.contrastive_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.contrastive_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.contrastive_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.contrastive_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.contrastive_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.contrastive_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.contrastive_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.contrastive_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)`,name:"synced_gpus"},{anchor:"transformers.GenerationMixin.contrastive_search.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.GenerationMixin.contrastive_search.sequential",description:`<strong>sequential</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Switches topk hidden state computation from parallel to sequential to reduce memory if True.
model_kwargs &#x2014;
Additional model specific keyword arguments will be forwarded to the <code>forward</code> function of the model.
If model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"sequential"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L1842",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.ContrastiveSearchDecoderOnlyOutput"
>ContrastiveSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.ContrastiveSearchEncoderDecoderOutput"
>ContrastiveSearchEncoderDecoderOutput</a>
or <code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.ContrastiveSearchDecoderOnlyOutput"
>ContrastiveSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.ContrastiveSearchEncoderDecoderOutput"
>ContrastiveSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),we=new re({props:{warning:!0,$$slots:{default:[Oo]},$$scope:{ctx:v}}}),je=new q({props:{anchor:"transformers.GenerationMixin.contrastive_search.example",$$slots:{default:[qo]},$$scope:{ctx:v}}}),tn=new Z({props:{name:"group_beam_search",anchor:"transformers.GenerationMixin.group_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"beam_scorer",val:": BeamScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": bool = False"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.group_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.group_beam_search.beam_scorer",description:`<strong>beam_scorer</strong> (<code>BeamScorer</code>) &#x2014;
An derived instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation. For more information, the documentation of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> should be read.`,name:"beam_scorer"},{anchor:"transformers.GenerationMixin.group_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.group_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.group_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.group_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.group_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.group_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.group_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.group_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.group_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)</p>
<p>model_kwargs &#x2014;
Additional model specific kwargs that will be forwarded to the <code>forward</code> function of the model. If
model is an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L3482",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if
<code>model.config.is_encoder_decoder=False</code> and <code>return_dict_in_generate=True</code> or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if <code>model.config.is_encoder_decoder=True</code>.</p>
`}}),ve=new re({props:{warning:!0,$$slots:{default:[Po]},$$scope:{ctx:v}}}),Je=new q({props:{anchor:"transformers.GenerationMixin.group_beam_search.example",$$slots:{default:[Ko]},$$scope:{ctx:v}}}),sn=new Z({props:{name:"constrained_beam_search",anchor:"transformers.GenerationMixin.constrained_beam_search",parameters:[{name:"input_ids",val:": LongTensor"},{name:"constrained_beam_scorer",val:": ConstrainedBeamSearchScorer"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"pad_token_id",val:": typing.Optional[int] = None"},{name:"eos_token_id",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_scores",val:": typing.Optional[bool] = None"},{name:"return_dict_in_generate",val:": typing.Optional[bool] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"transformers.GenerationMixin.constrained_beam_search.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.GenerationMixin.constrained_beam_search.constrained_beam_scorer",description:`<strong>constrained_beam_scorer</strong> (<code>ConstrainedBeamSearchScorer</code>) &#x2014;
A derived instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.BeamScorer">BeamScorer</a> that defines how beam hypotheses are constructed, stored and
sorted during generation, while satisfying a list of positive constraints. For more information, the
documentation of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.ConstrainedBeamSearchScorer">ConstrainedBeamSearchScorer</a> should be read.`,name:"constrained_beam_scorer"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessor">LogitsProcessor</a>
used to modify the prediction scores of the language modeling head applied at each generation step.`,name:"logits_processor"},{anchor:"transformers.GenerationMixin.constrained_beam_search.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteriaList">StoppingCriteriaList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.StoppingCriteria">StoppingCriteria</a>
used to tell if the generation loop should stop.`,name:"stopping_criteria"},{anchor:"transformers.GenerationMixin.constrained_beam_search.logits_warper",description:`<strong>logits_warper</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
An instance of <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsProcessorList">LogitsProcessorList</a>. List of instances of class derived from <a href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.LogitsWarper">LogitsWarper</a> used
to warp the prediction score distribution of the language modeling head applied before multinomial
sampling at each generation step.`,name:"logits_warper"},{anchor:"transformers.GenerationMixin.constrained_beam_search.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
<strong>DEPRECATED</strong>. Use <code>logits_processor</code> or <code>stopping_criteria</code> directly to cap the number of generated
tokens. The maximum length of the sequence to be generated.`,name:"max_length"},{anchor:"transformers.GenerationMixin.constrained_beam_search.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under
returned tensors for more details.`,name:"output_attentions"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors
for more details.`,name:"output_hidden_states"},{anchor:"transformers.GenerationMixin.constrained_beam_search.output_scores",description:`<strong>output_scores</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the prediction scores. See <code>scores</code> under returned tensors for more details.`,name:"output_scores"},{anchor:"transformers.GenerationMixin.constrained_beam_search.return_dict_in_generate",description:`<strong>return_dict_in_generate</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict_in_generate"},{anchor:"transformers.GenerationMixin.constrained_beam_search.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to continue running the while loop until max_length (needed for ZeRO stage 3)
model_kwargs &#x2014;
Additional model specific kwargs will be forwarded to the <code>forward</code> function of the model. If model is
an encoder-decoder model the kwargs should include <code>encoder_outputs</code>.`,name:"synced_gpus"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/utils.py#L3861",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>generation.BeamSearchDecoderOnlyOutput</a>, <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> or
<code>torch.LongTensor</code>: A <code>torch.LongTensor</code> containing the generated tokens (default behaviour) or a
<a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a> if <code>model.config.is_encoder_decoder=False</code> and
<code>return_dict_in_generate=True</code> or a <a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a> if
<code>model.config.is_encoder_decoder=True</code>.</p>
`}}),Ue=new re({props:{warning:!0,$$slots:{default:[ea]},$$scope:{ctx:v}}}),xe=new q({props:{anchor:"transformers.GenerationMixin.constrained_beam_search.example",$$slots:{default:[na]},$$scope:{ctx:v}}}),on=new pt({}),an=new Z({props:{name:"class transformers.TFGenerationMixin",anchor:"transformers.TFGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L444"}}),rn=new Z({props:{name:"generate",anchor:"transformers.TFGenerationMixin.generate",parameters:[{name:"inputs",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.tf_logits_process.TFLogitsProcessorList] = None"},{name:"seed",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.generate.inputs",description:`<strong>inputs</strong> (<code>tf.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.TFGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.TFGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.TFGenerationMixin.generate.seed",description:`<strong>seed</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Random seed to control sampling, containing two integers, used when <code>do_sample</code> is <code>True</code>. See the
<code>seed</code> argument from stateless functions in <code>tf.random</code>.`,name:"seed"},{anchor:"transformers.TFGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L645",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code> or when
<code>config.return_dict_in_generate=True</code>) or a <code>tf.Tensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFGreedySearchDecoderOnlyOutput"
>TFGreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFSampleDecoderOnlyOutput"
>TFSampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFBeamSearchDecoderOnlyOutput"
>TFBeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFBeamSampleDecoderOnlyOutput"
>TFBeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFGreedySearchEncoderDecoderOutput"
>TFGreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFSampleEncoderDecoderOutput"
>TFSampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFBeamSearchEncoderDecoderOutput"
>TFBeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/v4.34.0/en/internal/generation_utils#transformers.generation.TFBeamSampleEncoderDecoderOutput"
>TFBeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>tf.Tensor</code></p>
`}}),Ge=new re({props:{warning:!0,$$slots:{default:[ta]},$$scope:{ctx:v}}}),ln=new Z({props:{name:"compute_transition_scores",anchor:"transformers.TFGenerationMixin.compute_transition_scores",parameters:[{name:"sequences",val:": Tensor"},{name:"scores",val:": typing.Tuple[tensorflow.python.framework.ops.Tensor]"},{name:"beam_indices",val:": typing.Optional[tensorflow.python.framework.ops.Tensor] = None"},{name:"normalize_logits",val:": bool = False"}],parametersDescription:[{anchor:"transformers.TFGenerationMixin.compute_transition_scores.sequences",description:`<strong>sequences</strong> (<code>tf.Tensor</code>) &#x2014;
The generated sequences. The second dimension (sequence_length) is either equal to <code>max_length</code> or
shorter if all batches finished early due to the <code>eos_token_id</code>.`,name:"sequences"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.scores",description:`<strong>scores</strong> (<code>tuple(tf.Tensor)</code>) &#x2014;
Transition scores for each vocabulary token at each generation step. Beam transition scores consisting
of log probabilities of tokens conditioned on log softmax of previously generated tokens Tuple of
<code>tf.Tensor</code> with up to <code>max_new_tokens</code> elements (one element for each generated token), with each
tensor of shape <code>(batch_size*num_beams, config.vocab_size)</code>.`,name:"scores"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.beam_indices",description:`<strong>beam_indices</strong> (<code>tf.Tensor</code>, <em>optional</em>) &#x2014;
Beam indices of generated token id at each generation step. <code>tf.Tensor</code> of shape
<code>(batch_size*num_return_sequences, sequence_length)</code>. Only required if a <code>num_beams&gt;1</code> at
generate-time.`,name:"beam_indices"},{anchor:"transformers.TFGenerationMixin.compute_transition_scores.normalize_logits",description:`<strong>normalize_logits</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to normalize the logits (which, for legacy reasons, may be unnormalized).`,name:"normalize_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/tf_utils.py#L477",returnDescription:`
<p>A <code>tf.Tensor</code> of shape <code>(batch_size*num_return_sequences, sequence_length)</code> containing
the transition scores (logits)</p>
`,returnType:`
<p><code>tf.Tensor</code></p>
`}}),Ze=new q({props:{anchor:"transformers.TFGenerationMixin.compute_transition_scores.example",$$slots:{default:[sa]},$$scope:{ctx:v}}}),cn=new pt({}),dn=new Z({props:{name:"class transformers.FlaxGenerationMixin",anchor:"transformers.FlaxGenerationMixin",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L129"}}),pn=new Z({props:{name:"generate",anchor:"transformers.FlaxGenerationMixin.generate",parameters:[{name:"input_ids",val:": Array"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"prng_key",val:": typing.Optional[jax.Array] = None"},{name:"trace",val:": bool = True"},{name:"params",val:": typing.Union[typing.Dict[str, jax.Array], NoneType] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.flax_logits_process.FlaxLogitsProcessorList] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FlaxGenerationMixin.generate.input_ids",description:`<strong>input_ids</strong> (<code>jnp.ndarray</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"input_ids"},{anchor:"transformers.FlaxGenerationMixin.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/v4.34.0/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.FlaxGenerationMixin.generate.trace",description:`<strong>trace</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to trace generation. Setting <code>trace=False</code> should only be used for debugging and will lead to a
considerably slower runtime.`,name:"trace"},{anchor:"transformers.FlaxGenerationMixin.generate.params",description:`<strong>params</strong> (<code>Dict[str, jnp.ndarray]</code>, <em>optional</em>) &#x2014;
Optionally the model parameters can be passed. Can be useful for parallelized generation.`,name:"params"},{anchor:"transformers.FlaxGenerationMixin.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>FlaxLogitsProcessorList </code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.FlaxGenerationMixin.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/generation/flax_utils.py#L267",returnDescription:`
<p><a
  href="/docs/transformers/v4.34.0/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a>.</p>
`}}),{c(){t=i("meta"),u=c(),a=i("p"),o=c(),m=i("h1"),e=i("a"),f=i("span"),_(Ve.$$.fragment),Gt=c(),_n=i("span"),_n.textContent=Fs,mt=c(),Re=i("p"),Re.innerHTML=Hs,gt=c(),$e=i("ul"),$e.innerHTML=Qs,ut=c(),Se=i("p"),Se.innerHTML=Ys,ht=c(),Le=i("p"),Le.innerHTML=As,ft=c(),K=i("h2"),ie=i("a"),et=i("span"),_(Ee.$$.fragment),Zt=c(),Mn=i("span"),Mn.textContent=Ds,_t=c(),k=i("div"),_(ze.$$.fragment),Bt=c(),yn=i("p"),yn.innerHTML=Os,Ct=c(),bn=i("ul"),bn.innerHTML=qs,It=c(),Tn=i("p"),Tn.innerHTML=Ps,Wt=c(),Q=i("div"),_(Fe.$$.fragment),Xt=c(),wn=i("p"),wn.innerHTML=Ks,Nt=c(),_(le.$$.fragment),Vt=c(),ce=i("div"),_(He.$$.fragment),Rt=c(),jn=i("p"),jn.innerHTML=eo,$t=c(),de=i("div"),_(Qe.$$.fragment),St=c(),vn=i("p"),vn.innerHTML=no,Mt=c(),ee=i("h2"),pe=i("a"),nt=i("span"),_(Ye.$$.fragment),Lt=c(),Jn=i("span"),Jn.textContent=to,yt=c(),U=i("div"),_(Ae.$$.fragment),Et=c(),Un=i("p"),Un.innerHTML=so,zt=c(),xn=i("p"),xn.innerHTML=oo,Ft=c(),kn=i("ul"),kn.innerHTML=ao,Ht=c(),Gn=i("p"),Gn.innerHTML=ro,Qt=c(),Y=i("div"),_(De.$$.fragment),Yt=c(),Zn=i("p"),Zn.textContent=io,At=c(),_(me.$$.fragment),Dt=c(),A=i("div"),_(Oe.$$.fragment),Ot=c(),Bn=i("p"),Bn.textContent=lo,qt=c(),_(ge.$$.fragment),Pt=c(),X=i("div"),_(qe.$$.fragment),Kt=c(),Cn=i("p"),Cn.innerHTML=co,es=c(),_(ue.$$.fragment),ns=c(),_(he.$$.fragment),ts=c(),N=i("div"),_(Pe.$$.fragment),ss=c(),In=i("p"),In.innerHTML=po,os=c(),_(fe.$$.fragment),as=c(),_(_e.$$.fragment),rs=c(),V=i("div"),_(Ke.$$.fragment),is=c(),Wn=i("p"),Wn.innerHTML=mo,ls=c(),_(Me.$$.fragment),cs=c(),_(ye.$$.fragment),ds=c(),R=i("div"),_(en.$$.fragment),ps=c(),Xn=i("p"),Xn.innerHTML=go,ms=c(),_(be.$$.fragment),gs=c(),_(Te.$$.fragment),us=c(),$=i("div"),_(nn.$$.fragment),hs=c(),Nn=i("p"),Nn.innerHTML=uo,fs=c(),_(we.$$.fragment),_s=c(),_(je.$$.fragment),Ms=c(),S=i("div"),_(tn.$$.fragment),ys=c(),Vn=i("p"),Vn.innerHTML=ho,bs=c(),_(ve.$$.fragment),Ts=c(),_(Je.$$.fragment),ws=c(),L=i("div"),_(sn.$$.fragment),js=c(),Rn=i("p"),Rn.innerHTML=fo,vs=c(),_(Ue.$$.fragment),Js=c(),_(xe.$$.fragment),bt=c(),ne=i("h2"),ke=i("a"),tt=i("span"),_(on.$$.fragment),Us=c(),$n=i("span"),$n.textContent=_o,Tt=c(),G=i("div"),_(an.$$.fragment),xs=c(),Sn=i("p"),Sn.innerHTML=Mo,ks=c(),Ln=i("p"),Ln.innerHTML=yo,Gs=c(),En=i("ul"),En.innerHTML=bo,Zs=c(),zn=i("p"),zn.innerHTML=To,Bs=c(),D=i("div"),_(rn.$$.fragment),Cs=c(),Fn=i("p"),Fn.textContent=wo,Is=c(),_(Ge.$$.fragment),Ws=c(),O=i("div"),_(ln.$$.fragment),Xs=c(),Hn=i("p"),Hn.textContent=jo,Ns=c(),_(Ze.$$.fragment),wt=c(),te=i("h2"),Be=i("a"),st=i("span"),_(cn.$$.fragment),Vs=c(),Qn=i("span"),Qn.textContent=vo,jt=c(),C=i("div"),_(dn.$$.fragment),Rs=c(),Yn=i("p"),Yn.innerHTML=Jo,$s=c(),An=i("p"),An.innerHTML=Uo,Ss=c(),Dn=i("ul"),Dn.innerHTML=xo,Ls=c(),On=i("p"),On.innerHTML=ko,Es=c(),Ce=i("div"),_(pn.$$.fragment),zs=c(),qn=i("p"),qn.textContent=Go,vt=c(),ot=i("p"),this.h()},l(n){const p=Ro("svelte-1phssyn",document.head);t=l(p,"META",{name:!0,content:!0}),p.forEach(r),u=d(n),a=l(n,"P",{}),J(a).forEach(r),o=d(n),m=l(n,"H1",{class:!0});var mn=J(m);e=l(mn,"A",{id:!0,class:!0,href:!0});var at=J(e);f=l(at,"SPAN",{});var rt=J(f);M(Ve.$$.fragment,rt),rt.forEach(r),at.forEach(r),Gt=d(mn),_n=l(mn,"SPAN",{"data-svelte-h":!0}),h(_n)!=="svelte-j76oon"&&(_n.textContent=Fs),mn.forEach(r),mt=d(n),Re=l(n,"P",{"data-svelte-h":!0}),h(Re)!=="svelte-1lm9ezt"&&(Re.innerHTML=Hs),gt=d(n),$e=l(n,"UL",{"data-svelte-h":!0}),h($e)!=="svelte-tzzp6s"&&($e.innerHTML=Qs),ut=d(n),Se=l(n,"P",{"data-svelte-h":!0}),h(Se)!=="svelte-gj9jsx"&&(Se.innerHTML=Ys),ht=d(n),Le=l(n,"P",{"data-svelte-h":!0}),h(Le)!=="svelte-1wifwwe"&&(Le.innerHTML=As),ft=d(n),K=l(n,"H2",{class:!0});var gn=J(K);ie=l(gn,"A",{id:!0,class:!0,href:!0});var it=J(ie);et=l(it,"SPAN",{});var lt=J(et);M(Ee.$$.fragment,lt),lt.forEach(r),it.forEach(r),Zt=d(gn),Mn=l(gn,"SPAN",{"data-svelte-h":!0}),h(Mn)!=="svelte-1x7zba9"&&(Mn.textContent=Ds),gn.forEach(r),_t=d(n),k=l(n,"DIV",{class:!0});var I=J(k);M(ze.$$.fragment,I),Bt=d(I),yn=l(I,"P",{"data-svelte-h":!0}),h(yn)!=="svelte-14531m7"&&(yn.innerHTML=Os),Ct=d(I),bn=l(I,"UL",{"data-svelte-h":!0}),h(bn)!=="svelte-x1544c"&&(bn.innerHTML=qs),It=d(I),Tn=l(I,"P",{"data-svelte-h":!0}),h(Tn)!=="svelte-2cak66"&&(Tn.innerHTML=Ps),Wt=d(I),Q=l(I,"DIV",{class:!0});var se=J(Q);M(Fe.$$.fragment,se),Xt=d(se),wn=l(se,"P",{"data-svelte-h":!0}),h(wn)!=="svelte-u0w36l"&&(wn.innerHTML=Ks),Nt=d(se),M(le.$$.fragment,se),se.forEach(r),Vt=d(I),ce=l(I,"DIV",{class:!0});var un=J(ce);M(He.$$.fragment,un),Rt=d(un),jn=l(un,"P",{"data-svelte-h":!0}),h(jn)!=="svelte-1i0mhdf"&&(jn.innerHTML=eo),un.forEach(r),$t=d(I),de=l(I,"DIV",{class:!0});var hn=J(de);M(Qe.$$.fragment,hn),St=d(hn),vn=l(hn,"P",{"data-svelte-h":!0}),h(vn)!=="svelte-cr5wmi"&&(vn.innerHTML=no),hn.forEach(r),I.forEach(r),Mt=d(n),ee=l(n,"H2",{class:!0});var fn=J(ee);pe=l(fn,"A",{id:!0,class:!0,href:!0});var ct=J(pe);nt=l(ct,"SPAN",{});var dt=J(nt);M(Ye.$$.fragment,dt),dt.forEach(r),ct.forEach(r),Lt=d(fn),Jn=l(fn,"SPAN",{"data-svelte-h":!0}),h(Jn)!=="svelte-o1pjh0"&&(Jn.textContent=to),fn.forEach(r),yt=d(n),U=l(n,"DIV",{class:!0});var x=J(U);M(Ae.$$.fragment,x),Et=d(x),Un=l(x,"P",{"data-svelte-h":!0}),h(Un)!=="svelte-kshs7y"&&(Un.innerHTML=so),zt=d(x),xn=l(x,"P",{"data-svelte-h":!0}),h(xn)!=="svelte-nwdexj"&&(xn.innerHTML=oo),Ft=d(x),kn=l(x,"UL",{"data-svelte-h":!0}),h(kn)!=="svelte-16carzi"&&(kn.innerHTML=ao),Ht=d(x),Gn=l(x,"P",{"data-svelte-h":!0}),h(Gn)!=="svelte-13kczdy"&&(Gn.innerHTML=ro),Qt=d(x),Y=l(x,"DIV",{class:!0});var oe=J(Y);M(De.$$.fragment,oe),Yt=d(oe),Zn=l(oe,"P",{"data-svelte-h":!0}),h(Zn)!=="svelte-s5ko3x"&&(Zn.textContent=io),At=d(oe),M(me.$$.fragment,oe),oe.forEach(r),Dt=d(x),A=l(x,"DIV",{class:!0});var ae=J(A);M(Oe.$$.fragment,ae),Ot=d(ae),Bn=l(ae,"P",{"data-svelte-h":!0}),h(Bn)!=="svelte-1om47tb"&&(Bn.textContent=lo),qt=d(ae),M(ge.$$.fragment,ae),ae.forEach(r),Pt=d(x),X=l(x,"DIV",{class:!0});var z=J(X);M(qe.$$.fragment,z),Kt=d(z),Cn=l(z,"P",{"data-svelte-h":!0}),h(Cn)!=="svelte-bizfd"&&(Cn.innerHTML=co),es=d(z),M(ue.$$.fragment,z),ns=d(z),M(he.$$.fragment,z),z.forEach(r),ts=d(x),N=l(x,"DIV",{class:!0});var F=J(N);M(Pe.$$.fragment,F),ss=d(F),In=l(F,"P",{"data-svelte-h":!0}),h(In)!=="svelte-iidyyu"&&(In.innerHTML=po),os=d(F),M(fe.$$.fragment,F),as=d(F),M(_e.$$.fragment,F),F.forEach(r),rs=d(x),V=l(x,"DIV",{class:!0});var H=J(V);M(Ke.$$.fragment,H),is=d(H),Wn=l(H,"P",{"data-svelte-h":!0}),h(Wn)!=="svelte-af29ky"&&(Wn.innerHTML=mo),ls=d(H),M(Me.$$.fragment,H),cs=d(H),M(ye.$$.fragment,H),H.forEach(r),ds=d(x),R=l(x,"DIV",{class:!0});var Ie=J(R);M(en.$$.fragment,Ie),ps=d(Ie),Xn=l(Ie,"P",{"data-svelte-h":!0}),h(Xn)!=="svelte-465m7j"&&(Xn.innerHTML=go),ms=d(Ie),M(be.$$.fragment,Ie),gs=d(Ie),M(Te.$$.fragment,Ie),Ie.forEach(r),us=d(x),$=l(x,"DIV",{class:!0});var We=J($);M(nn.$$.fragment,We),hs=d(We),Nn=l(We,"P",{"data-svelte-h":!0}),h(Nn)!=="svelte-na8o2s"&&(Nn.innerHTML=uo),fs=d(We),M(we.$$.fragment,We),_s=d(We),M(je.$$.fragment,We),We.forEach(r),Ms=d(x),S=l(x,"DIV",{class:!0});var Xe=J(S);M(tn.$$.fragment,Xe),ys=d(Xe),Vn=l(Xe,"P",{"data-svelte-h":!0}),h(Vn)!=="svelte-15ptx3u"&&(Vn.innerHTML=ho),bs=d(Xe),M(ve.$$.fragment,Xe),Ts=d(Xe),M(Je.$$.fragment,Xe),Xe.forEach(r),ws=d(x),L=l(x,"DIV",{class:!0});var Ne=J(L);M(sn.$$.fragment,Ne),js=d(Ne),Rn=l(Ne,"P",{"data-svelte-h":!0}),h(Rn)!=="svelte-1n3vb6m"&&(Rn.innerHTML=fo),vs=d(Ne),M(Ue.$$.fragment,Ne),Js=d(Ne),M(xe.$$.fragment,Ne),Ne.forEach(r),x.forEach(r),bt=d(n),ne=l(n,"H2",{class:!0});var Ut=J(ne);ke=l(Ut,"A",{id:!0,class:!0,href:!0});var Zo=J(ke);tt=l(Zo,"SPAN",{});var Bo=J(tt);M(on.$$.fragment,Bo),Bo.forEach(r),Zo.forEach(r),Us=d(Ut),$n=l(Ut,"SPAN",{"data-svelte-h":!0}),h($n)!=="svelte-1tfgm6y"&&($n.textContent=_o),Ut.forEach(r),Tt=d(n),G=l(n,"DIV",{class:!0});var W=J(G);M(an.$$.fragment,W),xs=d(W),Sn=l(W,"P",{"data-svelte-h":!0}),h(Sn)!=="svelte-11m42fi"&&(Sn.innerHTML=Mo),ks=d(W),Ln=l(W,"P",{"data-svelte-h":!0}),h(Ln)!=="svelte-1syzr4t"&&(Ln.innerHTML=yo),Gs=d(W),En=l(W,"UL",{"data-svelte-h":!0}),h(En)!=="svelte-fx738d"&&(En.innerHTML=bo),Zs=d(W),zn=l(W,"P",{"data-svelte-h":!0}),h(zn)!=="svelte-13kczdy"&&(zn.innerHTML=To),Bs=d(W),D=l(W,"DIV",{class:!0});var Pn=J(D);M(rn.$$.fragment,Pn),Cs=d(Pn),Fn=l(Pn,"P",{"data-svelte-h":!0}),h(Fn)!=="svelte-s5ko3x"&&(Fn.textContent=wo),Is=d(Pn),M(Ge.$$.fragment,Pn),Pn.forEach(r),Ws=d(W),O=l(W,"DIV",{class:!0});var Kn=J(O);M(ln.$$.fragment,Kn),Xs=d(Kn),Hn=l(Kn,"P",{"data-svelte-h":!0}),h(Hn)!=="svelte-1om47tb"&&(Hn.textContent=jo),Ns=d(Kn),M(Ze.$$.fragment,Kn),Kn.forEach(r),W.forEach(r),wt=d(n),te=l(n,"H2",{class:!0});var xt=J(te);Be=l(xt,"A",{id:!0,class:!0,href:!0});var Co=J(Be);st=l(Co,"SPAN",{});var Io=J(st);M(cn.$$.fragment,Io),Io.forEach(r),Co.forEach(r),Vs=d(xt),Qn=l(xt,"SPAN",{"data-svelte-h":!0}),h(Qn)!=="svelte-pvlvrt"&&(Qn.textContent=vo),xt.forEach(r),jt=d(n),C=l(n,"DIV",{class:!0});var E=J(C);M(dn.$$.fragment,E),Rs=d(E),Yn=l(E,"P",{"data-svelte-h":!0}),h(Yn)!=="svelte-1a4vnzs"&&(Yn.innerHTML=Jo),$s=d(E),An=l(E,"P",{"data-svelte-h":!0}),h(An)!=="svelte-1nxruz8"&&(An.innerHTML=Uo),Ss=d(E),Dn=l(E,"UL",{"data-svelte-h":!0}),h(Dn)!=="svelte-ffjx8e"&&(Dn.innerHTML=xo),Ls=d(E),On=l(E,"P",{"data-svelte-h":!0}),h(On)!=="svelte-13kczdy"&&(On.innerHTML=ko),Es=d(E),Ce=l(E,"DIV",{class:!0});var kt=J(Ce);M(pn.$$.fragment,kt),zs=d(kt),qn=l(kt,"P",{"data-svelte-h":!0}),h(qn)!=="svelte-s5ko3x"&&(qn.textContent=Go),kt.forEach(r),E.forEach(r),vt=d(n),ot=l(n,"P",{}),J(ot).forEach(r),this.h()},h(){j(t,"name","hf:doc:metadata"),j(t,"content",JSON.stringify(aa)),j(e,"id","generation"),j(e,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(e,"href","#generation"),j(m,"class","relative group"),j(ie,"id","transformers.GenerationConfig"),j(ie,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(ie,"href","#transformers.GenerationConfig"),j(K,"class","relative group"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"id","transformers.GenerationMixin"),j(pe,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(pe,"href","#transformers.GenerationMixin"),j(ee,"class","relative group"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ke,"id","transformers.TFGenerationMixin"),j(ke,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(ke,"href","#transformers.TFGenerationMixin"),j(ne,"class","relative group"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Be,"id","transformers.FlaxGenerationMixin"),j(Be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),j(Be,"href","#transformers.FlaxGenerationMixin"),j(te,"class","relative group"),j(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(n,p){s(document.head,t),g(n,u,p),g(n,a,p),g(n,o,p),g(n,m,p),s(m,e),s(e,f),y(Ve,f,null),s(m,Gt),s(m,_n),g(n,mt,p),g(n,Re,p),g(n,gt,p),g(n,$e,p),g(n,ut,p),g(n,Se,p),g(n,ht,p),g(n,Le,p),g(n,ft,p),g(n,K,p),s(K,ie),s(ie,et),y(Ee,et,null),s(K,Zt),s(K,Mn),g(n,_t,p),g(n,k,p),y(ze,k,null),s(k,Bt),s(k,yn),s(k,Ct),s(k,bn),s(k,It),s(k,Tn),s(k,Wt),s(k,Q),y(Fe,Q,null),s(Q,Xt),s(Q,wn),s(Q,Nt),y(le,Q,null),s(k,Vt),s(k,ce),y(He,ce,null),s(ce,Rt),s(ce,jn),s(k,$t),s(k,de),y(Qe,de,null),s(de,St),s(de,vn),g(n,Mt,p),g(n,ee,p),s(ee,pe),s(pe,nt),y(Ye,nt,null),s(ee,Lt),s(ee,Jn),g(n,yt,p),g(n,U,p),y(Ae,U,null),s(U,Et),s(U,Un),s(U,zt),s(U,xn),s(U,Ft),s(U,kn),s(U,Ht),s(U,Gn),s(U,Qt),s(U,Y),y(De,Y,null),s(Y,Yt),s(Y,Zn),s(Y,At),y(me,Y,null),s(U,Dt),s(U,A),y(Oe,A,null),s(A,Ot),s(A,Bn),s(A,qt),y(ge,A,null),s(U,Pt),s(U,X),y(qe,X,null),s(X,Kt),s(X,Cn),s(X,es),y(ue,X,null),s(X,ns),y(he,X,null),s(U,ts),s(U,N),y(Pe,N,null),s(N,ss),s(N,In),s(N,os),y(fe,N,null),s(N,as),y(_e,N,null),s(U,rs),s(U,V),y(Ke,V,null),s(V,is),s(V,Wn),s(V,ls),y(Me,V,null),s(V,cs),y(ye,V,null),s(U,ds),s(U,R),y(en,R,null),s(R,ps),s(R,Xn),s(R,ms),y(be,R,null),s(R,gs),y(Te,R,null),s(U,us),s(U,$),y(nn,$,null),s($,hs),s($,Nn),s($,fs),y(we,$,null),s($,_s),y(je,$,null),s(U,Ms),s(U,S),y(tn,S,null),s(S,ys),s(S,Vn),s(S,bs),y(ve,S,null),s(S,Ts),y(Je,S,null),s(U,ws),s(U,L),y(sn,L,null),s(L,js),s(L,Rn),s(L,vs),y(Ue,L,null),s(L,Js),y(xe,L,null),g(n,bt,p),g(n,ne,p),s(ne,ke),s(ke,tt),y(on,tt,null),s(ne,Us),s(ne,$n),g(n,Tt,p),g(n,G,p),y(an,G,null),s(G,xs),s(G,Sn),s(G,ks),s(G,Ln),s(G,Gs),s(G,En),s(G,Zs),s(G,zn),s(G,Bs),s(G,D),y(rn,D,null),s(D,Cs),s(D,Fn),s(D,Is),y(Ge,D,null),s(G,Ws),s(G,O),y(ln,O,null),s(O,Xs),s(O,Hn),s(O,Ns),y(Ze,O,null),g(n,wt,p),g(n,te,p),s(te,Be),s(Be,st),y(cn,st,null),s(te,Vs),s(te,Qn),g(n,jt,p),g(n,C,p),y(dn,C,null),s(C,Rs),s(C,Yn),s(C,$s),s(C,An),s(C,Ss),s(C,Dn),s(C,Ls),s(C,On),s(C,Es),s(C,Ce),y(pn,Ce,null),s(Ce,zs),s(Ce,qn),g(n,vt,p),g(n,ot,p),Jt=!0},p(n,[p]){const mn={};p&2&&(mn.$$scope={dirty:p,ctx:n}),le.$set(mn);const at={};p&2&&(at.$$scope={dirty:p,ctx:n}),me.$set(at);const rt={};p&2&&(rt.$$scope={dirty:p,ctx:n}),ge.$set(rt);const gn={};p&2&&(gn.$$scope={dirty:p,ctx:n}),ue.$set(gn);const it={};p&2&&(it.$$scope={dirty:p,ctx:n}),he.$set(it);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:n}),fe.$set(lt);const I={};p&2&&(I.$$scope={dirty:p,ctx:n}),_e.$set(I);const se={};p&2&&(se.$$scope={dirty:p,ctx:n}),Me.$set(se);const un={};p&2&&(un.$$scope={dirty:p,ctx:n}),ye.$set(un);const hn={};p&2&&(hn.$$scope={dirty:p,ctx:n}),be.$set(hn);const fn={};p&2&&(fn.$$scope={dirty:p,ctx:n}),Te.$set(fn);const ct={};p&2&&(ct.$$scope={dirty:p,ctx:n}),we.$set(ct);const dt={};p&2&&(dt.$$scope={dirty:p,ctx:n}),je.$set(dt);const x={};p&2&&(x.$$scope={dirty:p,ctx:n}),ve.$set(x);const oe={};p&2&&(oe.$$scope={dirty:p,ctx:n}),Je.$set(oe);const ae={};p&2&&(ae.$$scope={dirty:p,ctx:n}),Ue.$set(ae);const z={};p&2&&(z.$$scope={dirty:p,ctx:n}),xe.$set(z);const F={};p&2&&(F.$$scope={dirty:p,ctx:n}),Ge.$set(F);const H={};p&2&&(H.$$scope={dirty:p,ctx:n}),Ze.$set(H)},i(n){Jt||(b(Ve.$$.fragment,n),b(Ee.$$.fragment,n),b(ze.$$.fragment,n),b(Fe.$$.fragment,n),b(le.$$.fragment,n),b(He.$$.fragment,n),b(Qe.$$.fragment,n),b(Ye.$$.fragment,n),b(Ae.$$.fragment,n),b(De.$$.fragment,n),b(me.$$.fragment,n),b(Oe.$$.fragment,n),b(ge.$$.fragment,n),b(qe.$$.fragment,n),b(ue.$$.fragment,n),b(he.$$.fragment,n),b(Pe.$$.fragment,n),b(fe.$$.fragment,n),b(_e.$$.fragment,n),b(Ke.$$.fragment,n),b(Me.$$.fragment,n),b(ye.$$.fragment,n),b(en.$$.fragment,n),b(be.$$.fragment,n),b(Te.$$.fragment,n),b(nn.$$.fragment,n),b(we.$$.fragment,n),b(je.$$.fragment,n),b(tn.$$.fragment,n),b(ve.$$.fragment,n),b(Je.$$.fragment,n),b(sn.$$.fragment,n),b(Ue.$$.fragment,n),b(xe.$$.fragment,n),b(on.$$.fragment,n),b(an.$$.fragment,n),b(rn.$$.fragment,n),b(Ge.$$.fragment,n),b(ln.$$.fragment,n),b(Ze.$$.fragment,n),b(cn.$$.fragment,n),b(dn.$$.fragment,n),b(pn.$$.fragment,n),Jt=!0)},o(n){T(Ve.$$.fragment,n),T(Ee.$$.fragment,n),T(ze.$$.fragment,n),T(Fe.$$.fragment,n),T(le.$$.fragment,n),T(He.$$.fragment,n),T(Qe.$$.fragment,n),T(Ye.$$.fragment,n),T(Ae.$$.fragment,n),T(De.$$.fragment,n),T(me.$$.fragment,n),T(Oe.$$.fragment,n),T(ge.$$.fragment,n),T(qe.$$.fragment,n),T(ue.$$.fragment,n),T(he.$$.fragment,n),T(Pe.$$.fragment,n),T(fe.$$.fragment,n),T(_e.$$.fragment,n),T(Ke.$$.fragment,n),T(Me.$$.fragment,n),T(ye.$$.fragment,n),T(en.$$.fragment,n),T(be.$$.fragment,n),T(Te.$$.fragment,n),T(nn.$$.fragment,n),T(we.$$.fragment,n),T(je.$$.fragment,n),T(tn.$$.fragment,n),T(ve.$$.fragment,n),T(Je.$$.fragment,n),T(sn.$$.fragment,n),T(Ue.$$.fragment,n),T(xe.$$.fragment,n),T(on.$$.fragment,n),T(an.$$.fragment,n),T(rn.$$.fragment,n),T(Ge.$$.fragment,n),T(ln.$$.fragment,n),T(Ze.$$.fragment,n),T(cn.$$.fragment,n),T(dn.$$.fragment,n),T(pn.$$.fragment,n),Jt=!1},d(n){n&&(r(u),r(a),r(o),r(m),r(mt),r(Re),r(gt),r($e),r(ut),r(Se),r(ht),r(Le),r(ft),r(K),r(_t),r(k),r(Mt),r(ee),r(yt),r(U),r(bt),r(ne),r(Tt),r(G),r(wt),r(te),r(jt),r(C),r(vt),r(ot)),r(t),w(Ve),w(Ee),w(ze),w(Fe),w(le),w(He),w(Qe),w(Ye),w(Ae),w(De),w(me),w(Oe),w(ge),w(qe),w(ue),w(he),w(Pe),w(fe),w(_e),w(Ke),w(Me),w(ye),w(en),w(be),w(Te),w(nn),w(we),w(je),w(tn),w(ve),w(Je),w(sn),w(Ue),w(xe),w(on),w(an),w(rn),w(Ge),w(ln),w(Ze),w(cn),w(dn),w(pn)}}}const aa={local:"generation",sections:[{local:"transformers.GenerationConfig",title:"GenerationConfig"},{local:"transformers.GenerationMixin",title:"GenerationMixin"},{local:"transformers.TFGenerationMixin",title:"TFGenerationMixin"},{local:"transformers.FlaxGenerationMixin",title:"FlaxGenerationMixin"}],title:"Generation"};function ra(v){return Xo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ua extends No{constructor(t){super(),Vo(this,t,ra,oa,Wo,{})}}export{ua as component};
