import{s as Tt,n as wt,o as Mt}from"../chunks/scheduler.9bc65507.js";import{S as Bt,i as zt,g as s,s as r,u as g,A as Jt,h as o,f as t,c as i,j as h,v as f,y as d,k as c,o as a,a as l,w as _,d as k,t as b,x as v}from"../chunks/index.78c82d43.js";import{D as de}from"../chunks/Docstring.4e7352e2.js";import{C as yt}from"../chunks/CodeBlock.73e038be.js";import{I as Ge}from"../chunks/IconCopyLink.bedaa44d.js";function xt(De){let y,he,re,me,T,B,ie,U,Le,G,Ye="BARTpho",ue,w,z,le,q,Ae,D,Ke="Overview",ge,R,Oe='The BARTpho model was proposed in <a href="https://arxiv.org/abs/2109.09701" rel="nofollow">BARTpho: Pre-trained Sequence-to-Sequence Models for Vietnamese</a> by Nguyen Luong Tran, Duong Minh Le and Dat Quoc Nguyen.',fe,$,et="The abstract from the paper is the following:",_e,L,tt=`<em>We present BARTpho with two versions — BARTpho_word and BARTpho_syllable — the first public large-scale monolingual
sequence-to-sequence models pre-trained for Vietnamese. Our BARTpho uses the “large” architecture and pre-training
scheme of the sequence-to-sequence denoising model BART, thus especially suitable for generative NLP tasks. Experiments
on a downstream task of Vietnamese text summarization show that in both automatic and human evaluations, our BARTpho
outperforms the strong baseline mBART and improves the state-of-the-art. We release BARTpho to facilitate future
research and applications of generative Vietnamese NLP tasks.</em>`,ke,A,nt="Example of use:",be,I,ve,H,st="Tips:",ye,E,ot=`<li>Following mBART, BARTpho uses the “large” architecture of BART with an additional layer-normalization layer on top of
both the encoder and decoder. Thus, usage examples in the <a href="bart">documentation of BART</a>, when adapting to use
with BARTpho, should be adjusted by replacing the BART-specialized classes with the mBART-specialized counterparts.
For example:</li>`,Te,V,we,W,at=`<li>This implementation is only for tokenization: “monolingual_vocab_file” consists of Vietnamese-specialized types
extracted from the pre-trained SentencePiece model “vocab_file” that is available from the multilingual XLM-RoBERTa.
Other languages, if employing this pre-trained multilingual SentencePiece model “vocab_file” for subword
segmentation, can reuse BartphoTokenizer with their own language-specialized “monolingual_vocab_file”.</li>`,Me,Z,rt='This model was contributed by <a href="https://huggingface.co/dqnguyen" rel="nofollow">dqnguyen</a>. The original code can be found <a href="https://github.com/VinAIResearch/BARTpho" rel="nofollow">here</a>.',Be,M,J,pe,X,Ie,Y,it="BartphoTokenizer",ze,p,P,He,K,lt='Adapted from <a href="/docs/transformers/v4.34.0/en/model_doc/xlm-roberta#transformers.XLMRobertaTokenizer">XLMRobertaTokenizer</a>. Based on <a href="https://github.com/google/sentencepiece" rel="nofollow">SentencePiece</a>.',Ee,O,pt=`This tokenizer inherits from <a href="/docs/transformers/v4.34.0/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Ve,u,S,We,ee,ct=`Build model inputs from a sequence or a pair of sequence for sequence classification tasks by concatenating and
adding special tokens. An BARTPho sequence has the following format:`,Ze,te,dt="<li>single sequence: <code>&lt;s&gt; X &lt;/s&gt;</code></li> <li>pair of sequences: <code>&lt;s&gt; A &lt;/s&gt;&lt;/s&gt; B &lt;/s&gt;</code></li>",Xe,x,Q,Pe,ne,ht="Converts a sequence of tokens (strings for sub-words) in a single string.",Se,C,F,Qe,se,mt=`Create a mask from the two sequences passed to be used in a sequence-pair classification task. BARTPho does not
make use of token type ids, therefore a list of zeros is returned.`,Fe,j,N,Ne,oe,ut=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Je,ce,xe;return U=new Ge({}),q=new Ge({}),I=new yt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWJhcnRwaG8lMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGYmFydHBoby1zeWxsYWJsZSUyMiklMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ2aW5haSUyRmJhcnRwaG8tc3lsbGFibGUlMjIpJTBBJTBBbGluZSUyMCUzRCUyMCUyMkNoJUMzJUJBbmclMjB0JUMzJUI0aSUyMGwlQzMlQTAlMjBuaCVFMSVCQiVBRm5nJTIwbmdoaSVDMyVBQW4lMjBjJUUxJUJCJUE5dSUyMHZpJUMzJUFBbi4lMjIlMEElMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIobGluZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGZlYXR1cmVzJTIwJTNEJTIwYmFydHBobygqKmlucHV0X2lkcyklMjAlMjAlMjMlMjBNb2RlbHMlMjBvdXRwdXRzJTIwYXJlJTIwbm93JTIwdHVwbGVzJTBBJTBBJTIzJTIwV2l0aCUyMFRlbnNvckZsb3clMjAyLjAlMkIlM0ElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWwlMEElMEFiYXJ0cGhvJTIwJTNEJTIwVEZBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnZpbmFpJTJGYmFydHBoby1zeWxsYWJsZSUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjB0b2tlbml6ZXIobGluZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZmVhdHVyZXMlMjAlM0QlMjBiYXJ0cGhvKCoqaW5wdXRfaWRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>bartpho = AutoModel.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>line = <span class="hljs-string">&quot;Chúng tôi là những nghiên cứu viên.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(line, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    features = bartpho(**input_ids)  <span class="hljs-comment"># Models outputs are now tuples</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># With TensorFlow 2.0+:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModel

<span class="hljs-meta">&gt;&gt;&gt; </span>bartpho = TFAutoModel.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer(line, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>features = bartpho(**input_ids)`,wrap:!1}}),V=new yt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1CYXJ0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBYmFydHBobyUyMCUzRCUyME1CYXJ0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJ2aW5haSUyRmJhcnRwaG8tc3lsbGFibGUlMjIpJTBBVFhUJTIwJTNEJTIwJTIyQ2glQzMlQkFuZyUyMHQlQzMlQjRpJTIwbCVDMyVBMCUyMCUzQ21hc2slM0UlMjBuZ2hpJUMzJUFBbiUyMGMlRTElQkIlQTl1JTIwdmklQzMlQUFuLiUyMiUwQWlucHV0X2lkcyUyMCUzRCUyMHRva2VuaXplciglNUJUWFQlNUQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RCUwQWxvZ2l0cyUyMCUzRCUyMGJhcnRwaG8oaW5wdXRfaWRzKS5sb2dpdHMlMEFtYXNrZWRfaW5kZXglMjAlM0QlMjAoaW5wdXRfaWRzJTVCMCU1RCUyMCUzRCUzRCUyMHRva2VuaXplci5tYXNrX3Rva2VuX2lkKS5ub256ZXJvKCkuaXRlbSgpJTBBcHJvYnMlMjAlM0QlMjBsb2dpdHMlNUIwJTJDJTIwbWFza2VkX2luZGV4JTVELnNvZnRtYXgoZGltJTNEMCklMEF2YWx1ZXMlMkMlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMHByb2JzLnRvcGsoNSklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHByZWRpY3Rpb25zKS5zcGxpdCgpKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MBartForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>bartpho = MBartForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;vinai/bartpho-syllable&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>TXT = <span class="hljs-string">&quot;Chúng tôi là &lt;mask&gt; nghiên cứu viên.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = tokenizer([TXT], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = bartpho(input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masked_index = (input_ids[<span class="hljs-number">0</span>] == tokenizer.mask_token_id).nonzero().item()
<span class="hljs-meta">&gt;&gt;&gt; </span>probs = logits[<span class="hljs-number">0</span>, masked_index].softmax(dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>values, predictions = probs.topk(<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(predictions).split())`,wrap:!1}}),X=new Ge({}),P=new de({props:{name:"class transformers.BartphoTokenizer",anchor:"transformers.BartphoTokenizer",parameters:[{name:"vocab_file",val:""},{name:"monolingual_vocab_file",val:""},{name:"bos_token",val:" = '<s>'"},{name:"eos_token",val:" = '</s>'"},{name:"sep_token",val:" = '</s>'"},{name:"cls_token",val:" = '<s>'"},{name:"unk_token",val:" = '<unk>'"},{name:"pad_token",val:" = '<pad>'"},{name:"mask_token",val:" = '<mask>'"},{name:"sp_model_kwargs",val:": typing.Union[typing.Dict[str, typing.Any], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
Path to the vocabulary file. This vocabulary is the pre-trained SentencePiece model available from the
multilingual XLM-RoBERTa, also used in mBART, consisting of 250K types.`,name:"vocab_file"},{anchor:"transformers.BartphoTokenizer.monolingual_vocab_file",description:`<strong>monolingual_vocab_file</strong> (<code>str</code>) &#x2014;
Path to the monolingual vocabulary file. This monolingual vocabulary consists of Vietnamese-specialized
types extracted from the multilingual vocabulary vocab_file of 250K types.`,name:"monolingual_vocab_file"},{anchor:"transformers.BartphoTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The beginning of sequence token that was used during pretraining. Can be used a sequence classifier token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the beginning of
sequence. The token used is the <code>cls_token</code>.</p>

					</div>`,name:"bos_token"},{anchor:"transformers.BartphoTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The end of sequence token.</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.BartphoTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;/s&gt;&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.BartphoTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;s&gt;&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.BartphoTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;unk&gt;&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.BartphoTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;pad&gt;&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.BartphoTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;mask&gt;&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.BartphoTokenizer.additional_special_tokens",description:`<strong>additional_special_tokens</strong> (<code>List[str]</code>, <em>optional</em>, defaults to <code>[&quot;&lt;s&gt;NOTUSED&quot;, &quot;&lt;/s&gt;NOTUSED&quot;]</code>) &#x2014;
Additional special tokens used by the tokenizer.`,name:"additional_special_tokens"},{anchor:"transformers.BartphoTokenizer.sp_model_kwargs",description:`<strong>sp_model_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Will be passed to the <code>SentencePieceProcessor.__init__()</code> method. The <a href="https://github.com/google/sentencepiece/tree/master/python" rel="nofollow">Python wrapper for
SentencePiece</a> can be used, among other things,
to set:</p>
<ul>
<li>
<p><code>enable_sampling</code>: Enable subword regularization.</p>
</li>
<li>
<p><code>nbest_size</code>: Sampling parameters for unigram. Invalid for BPE-Dropout.</p>
<ul>
<li><code>nbest_size = {0,1}</code>: No sampling is performed.</li>
<li><code>nbest_size &gt; 1</code>: samples from the nbest_size results.</li>
<li><code>nbest_size &lt; 0</code>: assuming that nbest_size is infinite and samples from the all hypothesis (lattice)
using forward-filtering-and-backward-sampling algorithm.</li>
</ul>
</li>
<li>
<p><code>alpha</code>: Smoothing parameter for unigram sampling, and dropout probability of merge operations for
BPE-dropout.</p>
</li>
</ul>`,name:"sp_model_kwargs"},{anchor:"transformers.BartphoTokenizer.sp_model",description:`<strong>sp_model</strong> (<code>SentencePieceProcessor</code>) &#x2014;
The <em>SentencePiece</em> processor that is used for every conversion (string, tokens and IDs).`,name:"sp_model"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/bartpho/tokenization_bartpho.py#L46"}}),S=new de({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.BartphoTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs to which the special tokens will be added.`,name:"token_ids_0"},{anchor:"transformers.BartphoTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/bartpho/tokenization_bartpho.py#L193",returnDescription:`
<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),Q=new de({props:{name:"convert_tokens_to_string",anchor:"transformers.BartphoTokenizer.convert_tokens_to_string",parameters:[{name:"tokens",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/bartpho/tokenization_bartpho.py#L295"}}),F=new de({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.BartphoTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.BartphoTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/bartpho/tokenization_bartpho.py#L247",returnDescription:`
<p>List of zeros.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),N=new de({props:{name:"get_special_tokens_mask",anchor:"transformers.BartphoTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.BartphoTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.BartphoTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.BartphoTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/v4.34.0/src/transformers/models/bartpho/tokenization_bartpho.py#L219",returnDescription:`
<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`
<p><code>List[int]</code></p>
`}}),{c(){y=s("meta"),he=r(),re=s("p"),me=r(),T=s("h1"),B=s("a"),ie=s("span"),g(U.$$.fragment),Le=r(),G=s("span"),G.textContent=Ye,ue=r(),w=s("h2"),z=s("a"),le=s("span"),g(q.$$.fragment),Ae=r(),D=s("span"),D.textContent=Ke,ge=r(),R=s("p"),R.innerHTML=Oe,fe=r(),$=s("p"),$.textContent=et,_e=r(),L=s("p"),L.innerHTML=tt,ke=r(),A=s("p"),A.textContent=nt,be=r(),g(I.$$.fragment),ve=r(),H=s("p"),H.textContent=st,ye=r(),E=s("ul"),E.innerHTML=ot,Te=r(),g(V.$$.fragment),we=r(),W=s("ul"),W.innerHTML=at,Me=r(),Z=s("p"),Z.innerHTML=rt,Be=r(),M=s("h2"),J=s("a"),pe=s("span"),g(X.$$.fragment),Ie=r(),Y=s("span"),Y.textContent=it,ze=r(),p=s("div"),g(P.$$.fragment),He=r(),K=s("p"),K.innerHTML=lt,Ee=r(),O=s("p"),O.innerHTML=pt,Ve=r(),u=s("div"),g(S.$$.fragment),We=r(),ee=s("p"),ee.textContent=ct,Ze=r(),te=s("ul"),te.innerHTML=dt,Xe=r(),x=s("div"),g(Q.$$.fragment),Pe=r(),ne=s("p"),ne.textContent=ht,Se=r(),C=s("div"),g(F.$$.fragment),Qe=r(),se=s("p"),se.textContent=mt,Fe=r(),j=s("div"),g(N.$$.fragment),Ne=r(),oe=s("p"),oe.innerHTML=ut,Je=r(),ce=s("p"),this.h()},l(e){const n=Jt("svelte-1phssyn",document.head);y=o(n,"META",{name:!0,content:!0}),n.forEach(t),he=i(e),re=o(e,"P",{}),h(re).forEach(t),me=i(e),T=o(e,"H1",{class:!0});var Ce=h(T);B=o(Ce,"A",{id:!0,class:!0,href:!0});var gt=h(B);ie=o(gt,"SPAN",{});var ft=h(ie);f(U.$$.fragment,ft),ft.forEach(t),gt.forEach(t),Le=i(Ce),G=o(Ce,"SPAN",{"data-svelte-h":!0}),d(G)!=="svelte-unxmar"&&(G.textContent=Ye),Ce.forEach(t),ue=i(e),w=o(e,"H2",{class:!0});var je=h(w);z=o(je,"A",{id:!0,class:!0,href:!0});var _t=h(z);le=o(_t,"SPAN",{});var kt=h(le);f(q.$$.fragment,kt),kt.forEach(t),_t.forEach(t),Ae=i(je),D=o(je,"SPAN",{"data-svelte-h":!0}),d(D)!=="svelte-1jsw1pg"&&(D.textContent=Ke),je.forEach(t),ge=i(e),R=o(e,"P",{"data-svelte-h":!0}),d(R)!=="svelte-1nncmhi"&&(R.innerHTML=Oe),fe=i(e),$=o(e,"P",{"data-svelte-h":!0}),d($)!=="svelte-vfdo9a"&&($.textContent=et),_e=i(e),L=o(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1bdfxqp"&&(L.innerHTML=tt),ke=i(e),A=o(e,"P",{"data-svelte-h":!0}),d(A)!=="svelte-1euxn0a"&&(A.textContent=nt),be=i(e),f(I.$$.fragment,e),ve=i(e),H=o(e,"P",{"data-svelte-h":!0}),d(H)!=="svelte-axv494"&&(H.textContent=st),ye=i(e),E=o(e,"UL",{"data-svelte-h":!0}),d(E)!=="svelte-19b1na2"&&(E.innerHTML=ot),Te=i(e),f(V.$$.fragment,e),we=i(e),W=o(e,"UL",{"data-svelte-h":!0}),d(W)!=="svelte-kcbp2n"&&(W.innerHTML=at),Me=i(e),Z=o(e,"P",{"data-svelte-h":!0}),d(Z)!=="svelte-puazo9"&&(Z.innerHTML=rt),Be=i(e),M=o(e,"H2",{class:!0});var Ue=h(M);J=o(Ue,"A",{id:!0,class:!0,href:!0});var bt=h(J);pe=o(bt,"SPAN",{});var vt=h(pe);f(X.$$.fragment,vt),vt.forEach(t),bt.forEach(t),Ie=i(Ue),Y=o(Ue,"SPAN",{"data-svelte-h":!0}),d(Y)!=="svelte-av4ah2"&&(Y.textContent=it),Ue.forEach(t),ze=i(e),p=o(e,"DIV",{class:!0});var m=h(p);f(P.$$.fragment,m),He=i(m),K=o(m,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1bwlmrc"&&(K.innerHTML=lt),Ee=i(m),O=o(m,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1b0fouy"&&(O.innerHTML=pt),Ve=i(m),u=o(m,"DIV",{class:!0});var ae=h(u);f(S.$$.fragment,ae),We=i(ae),ee=o(ae,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-hazsjn"&&(ee.textContent=ct),Ze=i(ae),te=o(ae,"UL",{"data-svelte-h":!0}),d(te)!=="svelte-rq8uot"&&(te.innerHTML=dt),ae.forEach(t),Xe=i(m),x=o(m,"DIV",{class:!0});var qe=h(x);f(Q.$$.fragment,qe),Pe=i(qe),ne=o(qe,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-1ne8awa"&&(ne.textContent=ht),qe.forEach(t),Se=i(m),C=o(m,"DIV",{class:!0});var Re=h(C);f(F.$$.fragment,Re),Qe=i(Re),se=o(Re,"P",{"data-svelte-h":!0}),d(se)!=="svelte-1t18cnp"&&(se.textContent=mt),Re.forEach(t),Fe=i(m),j=o(m,"DIV",{class:!0});var $e=h(j);f(N.$$.fragment,$e),Ne=i($e),oe=o($e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-1f4f5kp"&&(oe.innerHTML=ut),$e.forEach(t),m.forEach(t),Je=i(e),ce=o(e,"P",{}),h(ce).forEach(t),this.h()},h(){c(y,"name","hf:doc:metadata"),c(y,"content",JSON.stringify(Ct)),c(B,"id","bartpho"),c(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(B,"href","#bartpho"),c(T,"class","relative group"),c(z,"id","overview"),c(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(z,"href","#overview"),c(w,"class","relative group"),c(J,"id","transformers.BartphoTokenizer"),c(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(J,"href","#transformers.BartphoTokenizer"),c(M,"class","relative group"),c(u,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,y),l(e,he,n),l(e,re,n),l(e,me,n),l(e,T,n),a(T,B),a(B,ie),_(U,ie,null),a(T,Le),a(T,G),l(e,ue,n),l(e,w,n),a(w,z),a(z,le),_(q,le,null),a(w,Ae),a(w,D),l(e,ge,n),l(e,R,n),l(e,fe,n),l(e,$,n),l(e,_e,n),l(e,L,n),l(e,ke,n),l(e,A,n),l(e,be,n),_(I,e,n),l(e,ve,n),l(e,H,n),l(e,ye,n),l(e,E,n),l(e,Te,n),_(V,e,n),l(e,we,n),l(e,W,n),l(e,Me,n),l(e,Z,n),l(e,Be,n),l(e,M,n),a(M,J),a(J,pe),_(X,pe,null),a(M,Ie),a(M,Y),l(e,ze,n),l(e,p,n),_(P,p,null),a(p,He),a(p,K),a(p,Ee),a(p,O),a(p,Ve),a(p,u),_(S,u,null),a(u,We),a(u,ee),a(u,Ze),a(u,te),a(p,Xe),a(p,x),_(Q,x,null),a(x,Pe),a(x,ne),a(p,Se),a(p,C),_(F,C,null),a(C,Qe),a(C,se),a(p,Fe),a(p,j),_(N,j,null),a(j,Ne),a(j,oe),l(e,Je,n),l(e,ce,n),xe=!0},p:wt,i(e){xe||(k(U.$$.fragment,e),k(q.$$.fragment,e),k(I.$$.fragment,e),k(V.$$.fragment,e),k(X.$$.fragment,e),k(P.$$.fragment,e),k(S.$$.fragment,e),k(Q.$$.fragment,e),k(F.$$.fragment,e),k(N.$$.fragment,e),xe=!0)},o(e){b(U.$$.fragment,e),b(q.$$.fragment,e),b(I.$$.fragment,e),b(V.$$.fragment,e),b(X.$$.fragment,e),b(P.$$.fragment,e),b(S.$$.fragment,e),b(Q.$$.fragment,e),b(F.$$.fragment,e),b(N.$$.fragment,e),xe=!1},d(e){e&&(t(he),t(re),t(me),t(T),t(ue),t(w),t(ge),t(R),t(fe),t($),t(_e),t(L),t(ke),t(A),t(be),t(ve),t(H),t(ye),t(E),t(Te),t(we),t(W),t(Me),t(Z),t(Be),t(M),t(ze),t(p),t(Je),t(ce)),t(y),v(U),v(q),v(I,e),v(V,e),v(X),v(P),v(S),v(Q),v(F),v(N)}}}const Ct={local:"bartpho",sections:[{local:"overview",title:"Overview"},{local:"transformers.BartphoTokenizer",title:"BartphoTokenizer"}],title:"BARTpho"};function jt(De){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Bt{constructor(y){super(),zt(this,y,jt,xt,Tt,{})}}export{At as component};
