import{s as fa,n as Ma,o as ba}from"../chunks/scheduler.36a0863c.js";import{S as ya,i as va,g as n,s as i,u,A as Ja,h as s,f as t,c as o,j as p,v as c,y as r,k as m,o as d,a,w as g,d as h,t as f,x as M}from"../chunks/index.d0f7a4c4.js";import{I}from"../chunks/IconCopyLink.bc5fad79.js";import{C as b}from"../chunks/CodeBlock.4236768d.js";import{D as Ta}from"../chunks/DocNotebookDropdown.95febfe3.js";function Ua(gl){let y,Ke,He,Oe,v,$,qe,L,il,Ge,hl="Modelos multilingües para inferencia",et,R,tt,W,fl='Existen varios modelos multilingües en 🤗 Transformers y su uso para inferencia difiere de los modelos monolingües. Sin embargo, no <em>todos</em> los usos de los modelos multilingües son diferentes. Algunos modelos, como <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>, pueden utilizarse igual que un modelo monolingüe. Esta guía te enseñará cómo utilizar modelos multilingües cuyo uso difiere en la inferencia.',lt,J,_,Ne,V,ol,ze,Ml="XLM",at,B,bl="XLM tiene diez checkpoints diferentes de los cuales solo uno es monolingüe. Los nueve checkpoints restantes del modelo pueden dividirse en dos categorías: los checkpoints que utilizan language embeddings y los que no.",nt,T,C,Fe,H,rl,Ie,yl="XLM con language embeddings",st,q,vl="Los siguientes modelos XLM usan language embeddings para especificar el lenguaje utilizado en la inferencia:",it,N,Jl="<li><code>xlm-mlm-ende-1024</code> (Masked language modeling, English-German)</li> <li><code>xlm-mlm-enfr-1024</code> (Masked language modeling, English-French)</li> <li><code>xlm-mlm-enro-1024</code> (Masked language modeling, English-Romanian)</li> <li><code>xlm-mlm-xnli15-1024</code> (Masked language modeling, XNLI languages)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Masked language modeling + translation, XNLI languages)</li> <li><code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French)</li> <li><code>xlm-clm-ende-1024</code> (Causal language modeling, English-German)</li>",ot,F,Tl="Los language embeddings son representados como un tensor de la mismas dimensiones que los <code>input_ids</code> pasados al modelo. Los valores de estos tensores dependen del idioma utilizado y se identifican mediante los atributos <code>lang2id</code> y <code>id2lang</code> del tokenizador.",rt,Q,Ul="En este ejemplo, carga el checkpoint <code>xlm-clm-enfr-1024</code> (Causal language modeling, English-French):",mt,P,dt,A,wl="El atributo <code>lang2id</code> del tokenizador muestra los idiomas de este modelo y sus ids:",pt,Y,ut,S,xl="A continuación, crea un input de ejemplo:",ct,D,gt,K,kl="Establece el id del idioma, por ejemplo <code>&quot;en&quot;</code>, y utilízalo para definir el language embedding. El language embedding es un tensor lleno de <code>0</code> ya que es el id del idioma para inglés. Este tensor debe ser del mismo tamaño que <code>input_ids</code>.",ht,O,ft,ee,jl="Ahora puedes pasar los <code>input_ids</code> y el language embedding al modelo:",Mt,te,bt,le,$l='El script <a href="https://github.com/huggingface/transformers/tree/master/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> puede generar texto con language embeddings utilizando los checkpoints <code>xlm-clm</code>.',yt,U,Z,Qe,ae,ml,Le,_l="XLM sin language embeddings",vt,ne,Cl="Los siguientes modelos XLM no requieren language embeddings durante la inferencia:",Jt,se,Zl="<li><code>xlm-mlm-17-1280</code> (modelado de lenguaje enmascarado, 17 idiomas)</li> <li><code>xlm-mlm-100-1280</code> (modelado de lenguaje enmascarado, 100 idiomas)</li>",Tt,ie,El="Estos modelos se utilizan para representaciones genéricas de frases a diferencia de los anteriores checkpoints XLM.",Ut,w,E,Pe,oe,dl,Re,Xl="BERT",wt,re,Gl="Los siguientes modelos de BERT pueden utilizarse para tareas multilingües:",xt,me,zl="<li><code>bert-base-multilingual-uncased</code> (modelado de lenguaje enmascarado + predicción de la siguiente oración, 102 idiomas)</li> <li><code>bert-base-multilingual-cased</code> (modelado de lenguaje enmascarado + predicción de la siguiente oración, 104 idiomas)</li>",kt,de,Il=`Estos modelos no requieren language embeddings durante la inferencia. Deben identificar la lengua a partir del
contexto e inferir en consecuencia.`,jt,x,X,Ae,pe,pl,We,Ll="XLM-RoBERTa",$t,ue,Rl="Los siguientes modelos de XLM-RoBERTa pueden utilizarse para tareas multilingües:",_t,ce,Wl="<li><code>xlm-roberta-base</code> (modelado de lenguaje enmascarado, 100 idiomas)</li> <li><code>xlm-roberta-large</code> (Modelado de lenguaje enmascarado, 100 idiomas)</li>",Ct,ge,Vl="XLM-RoBERTa se entrenó con 2,5 TB de datos CommonCrawl recién creados y depurados en 100 idiomas. Proporciona fuertes ventajas sobre los modelos multilingües publicados anteriormente como mBERT o XLM en tareas posteriores como la clasificación, el etiquetado de secuencias y la respuesta a preguntas.",Zt,k,G,Ye,he,ul,Ve,Bl="M2M100",Et,fe,Hl="Los siguientes modelos de M2M100 pueden utilizarse para traducción multilingüe:",Xt,Me,ql="<li><code>facebook/m2m100_418M</code> (traducción)</li> <li><code>facebook/m2m100_1.2B</code> (traducción)</li>",Gt,be,Nl="En este ejemplo, carga el checkpoint <code>facebook/m2m100_418M</code> para traducir del chino al inglés. Puedes establecer el idioma de origen en el tokenizador:",zt,ye,It,ve,Fl="Tokeniza el texto:",Lt,Je,Rt,Te,Ql="M2M100 fuerza el id del idioma de destino como el primer token generado para traducir al idioma de destino.. Establece el <code>forced_bos_token_id</code> a <code>en</code> en el método <code>generate</code> para traducir al inglés:",Wt,Ue,Vt,j,z,Se,we,cl,Be,Pl="MBart",Bt,xe,Al="Los siguientes modelos de MBart pueden utilizarse para traducción multilingüe:",Ht,ke,Yl="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (traducción automática multilingüe de uno a muchos, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (traducción automática multilingüe de muchos a muchos, 50 idiomas)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (traducción automática multilingüe muchos a uno, 50 idiomas)</li> <li><code>facebook/mbart-large-50</code> (traducción multilingüe, 50 idiomas)</li> <li><code>facebook/mbart-large-cc25</code></li>",qt,je,Sl="En este ejemplo, carga el checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> para traducir del finlandés al inglés. Puedes establecer el idioma de origen en el tokenizador:",Nt,$e,Ft,_e,Dl="Tokeniza el texto:",Qt,Ce,Pt,Ze,Kl="MBart fuerza el id del idioma de destino como el primer token generado para traducirlo. Establece el <code>forced_bos_token_id</code> a <code>en</code> en el método <code>generate</code> para traducir al inglés:",At,Ee,Yt,Xe,Ol="Si estás usando el checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code> no necesitas forzar el id del idioma de destino como el primer token generado, de lo contrario el uso es el mismo.",St,De,Dt;return L=new I({}),R=new Ta({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/es/tensorflow/multilingual.ipynb"}]}}),V=new I({}),H=new I({}),P=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),Y=new b({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),D=new b({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),O=new b({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),te=new b({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),ae=new I({}),oe=new I({}),pe=new I({}),he=new I({}),ye=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),Je=new b({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ue=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),we=new I({}),$e=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),Ce=new b({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ee=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){y=n("meta"),Ke=i(),He=n("p"),Oe=i(),v=n("h1"),$=n("a"),qe=n("span"),u(L.$$.fragment),il=i(),Ge=n("span"),Ge.textContent=hl,et=i(),u(R.$$.fragment),tt=i(),W=n("p"),W.innerHTML=fl,lt=i(),J=n("h2"),_=n("a"),Ne=n("span"),u(V.$$.fragment),ol=i(),ze=n("span"),ze.textContent=Ml,at=i(),B=n("p"),B.textContent=bl,nt=i(),T=n("h3"),C=n("a"),Fe=n("span"),u(H.$$.fragment),rl=i(),Ie=n("span"),Ie.textContent=yl,st=i(),q=n("p"),q.textContent=vl,it=i(),N=n("ul"),N.innerHTML=Jl,ot=i(),F=n("p"),F.innerHTML=Tl,rt=i(),Q=n("p"),Q.innerHTML=Ul,mt=i(),u(P.$$.fragment),dt=i(),A=n("p"),A.innerHTML=wl,pt=i(),u(Y.$$.fragment),ut=i(),S=n("p"),S.textContent=xl,ct=i(),u(D.$$.fragment),gt=i(),K=n("p"),K.innerHTML=kl,ht=i(),u(O.$$.fragment),ft=i(),ee=n("p"),ee.innerHTML=jl,Mt=i(),u(te.$$.fragment),bt=i(),le=n("p"),le.innerHTML=$l,yt=i(),U=n("h3"),Z=n("a"),Qe=n("span"),u(ae.$$.fragment),ml=i(),Le=n("span"),Le.textContent=_l,vt=i(),ne=n("p"),ne.textContent=Cl,Jt=i(),se=n("ul"),se.innerHTML=Zl,Tt=i(),ie=n("p"),ie.textContent=El,Ut=i(),w=n("h2"),E=n("a"),Pe=n("span"),u(oe.$$.fragment),dl=i(),Re=n("span"),Re.textContent=Xl,wt=i(),re=n("p"),re.textContent=Gl,xt=i(),me=n("ul"),me.innerHTML=zl,kt=i(),de=n("p"),de.textContent=Il,jt=i(),x=n("h2"),X=n("a"),Ae=n("span"),u(pe.$$.fragment),pl=i(),We=n("span"),We.textContent=Ll,$t=i(),ue=n("p"),ue.textContent=Rl,_t=i(),ce=n("ul"),ce.innerHTML=Wl,Ct=i(),ge=n("p"),ge.textContent=Vl,Zt=i(),k=n("h2"),G=n("a"),Ye=n("span"),u(he.$$.fragment),ul=i(),Ve=n("span"),Ve.textContent=Bl,Et=i(),fe=n("p"),fe.textContent=Hl,Xt=i(),Me=n("ul"),Me.innerHTML=ql,Gt=i(),be=n("p"),be.innerHTML=Nl,zt=i(),u(ye.$$.fragment),It=i(),ve=n("p"),ve.textContent=Fl,Lt=i(),u(Je.$$.fragment),Rt=i(),Te=n("p"),Te.innerHTML=Ql,Wt=i(),u(Ue.$$.fragment),Vt=i(),j=n("h2"),z=n("a"),Se=n("span"),u(we.$$.fragment),cl=i(),Be=n("span"),Be.textContent=Pl,Bt=i(),xe=n("p"),xe.textContent=Al,Ht=i(),ke=n("ul"),ke.innerHTML=Yl,qt=i(),je=n("p"),je.innerHTML=Sl,Nt=i(),u($e.$$.fragment),Ft=i(),_e=n("p"),_e.textContent=Dl,Qt=i(),u(Ce.$$.fragment),Pt=i(),Ze=n("p"),Ze.innerHTML=Kl,At=i(),u(Ee.$$.fragment),Yt=i(),Xe=n("p"),Xe.innerHTML=Ol,St=i(),De=n("p"),this.h()},l(e){const l=Ja("svelte-1phssyn",document.head);y=s(l,"META",{name:!0,content:!0}),l.forEach(t),Ke=o(e),He=s(e,"P",{}),p(He).forEach(t),Oe=o(e),v=s(e,"H1",{class:!0});var Kt=p(v);$=s(Kt,"A",{id:!0,class:!0,href:!0});var ea=p($);qe=s(ea,"SPAN",{});var ta=p(qe);c(L.$$.fragment,ta),ta.forEach(t),ea.forEach(t),il=o(Kt),Ge=s(Kt,"SPAN",{"data-svelte-h":!0}),r(Ge)!=="svelte-zlur1z"&&(Ge.textContent=hl),Kt.forEach(t),et=o(e),c(R.$$.fragment,e),tt=o(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-12fdply"&&(W.innerHTML=fl),lt=o(e),J=s(e,"H2",{class:!0});var Ot=p(J);_=s(Ot,"A",{id:!0,class:!0,href:!0});var la=p(_);Ne=s(la,"SPAN",{});var aa=p(Ne);c(V.$$.fragment,aa),aa.forEach(t),la.forEach(t),ol=o(Ot),ze=s(Ot,"SPAN",{"data-svelte-h":!0}),r(ze)!=="svelte-zmv7xk"&&(ze.textContent=Ml),Ot.forEach(t),at=o(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1tpv007"&&(B.textContent=bl),nt=o(e),T=s(e,"H3",{class:!0});var el=p(T);C=s(el,"A",{id:!0,class:!0,href:!0});var na=p(C);Fe=s(na,"SPAN",{});var sa=p(Fe);c(H.$$.fragment,sa),sa.forEach(t),na.forEach(t),rl=o(el),Ie=s(el,"SPAN",{"data-svelte-h":!0}),r(Ie)!=="svelte-1l36ee4"&&(Ie.textContent=yl),el.forEach(t),st=o(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-sf6rgo"&&(q.textContent=vl),it=o(e),N=s(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-1iu32ge"&&(N.innerHTML=Jl),ot=o(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1j3qusn"&&(F.innerHTML=Tl),rt=o(e),Q=s(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15tg1x6"&&(Q.innerHTML=Ul),mt=o(e),c(P.$$.fragment,e),dt=o(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-4lsbtx"&&(A.innerHTML=wl),pt=o(e),c(Y.$$.fragment,e),ut=o(e),S=s(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1tlykvk"&&(S.textContent=xl),ct=o(e),c(D.$$.fragment,e),gt=o(e),K=s(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-zrx9u1"&&(K.innerHTML=kl),ht=o(e),c(O.$$.fragment,e),ft=o(e),ee=s(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-2882ma"&&(ee.innerHTML=jl),Mt=o(e),c(te.$$.fragment,e),bt=o(e),le=s(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-14aj7e4"&&(le.innerHTML=$l),yt=o(e),U=s(e,"H3",{class:!0});var tl=p(U);Z=s(tl,"A",{id:!0,class:!0,href:!0});var ia=p(Z);Qe=s(ia,"SPAN",{});var oa=p(Qe);c(ae.$$.fragment,oa),oa.forEach(t),ia.forEach(t),ml=o(tl),Le=s(tl,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-hwuat2"&&(Le.textContent=_l),tl.forEach(t),vt=o(e),ne=s(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-akh8od"&&(ne.textContent=Cl),Jt=o(e),se=s(e,"UL",{"data-svelte-h":!0}),r(se)!=="svelte-1fb7h8u"&&(se.innerHTML=Zl),Tt=o(e),ie=s(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1yhdx4z"&&(ie.textContent=El),Ut=o(e),w=s(e,"H2",{class:!0});var ll=p(w);E=s(ll,"A",{id:!0,class:!0,href:!0});var ra=p(E);Pe=s(ra,"SPAN",{});var ma=p(Pe);c(oe.$$.fragment,ma),ma.forEach(t),ra.forEach(t),dl=o(ll),Re=s(ll,"SPAN",{"data-svelte-h":!0}),r(Re)!=="svelte-d1aweg"&&(Re.textContent=Xl),ll.forEach(t),wt=o(e),re=s(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-bc4ir5"&&(re.textContent=Gl),xt=o(e),me=s(e,"UL",{"data-svelte-h":!0}),r(me)!=="svelte-k7slx9"&&(me.innerHTML=zl),kt=o(e),de=s(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1seqp0w"&&(de.textContent=Il),jt=o(e),x=s(e,"H2",{class:!0});var al=p(x);X=s(al,"A",{id:!0,class:!0,href:!0});var da=p(X);Ae=s(da,"SPAN",{});var pa=p(Ae);c(pe.$$.fragment,pa),pa.forEach(t),da.forEach(t),pl=o(al),We=s(al,"SPAN",{"data-svelte-h":!0}),r(We)!=="svelte-on8il6"&&(We.textContent=Ll),al.forEach(t),$t=o(e),ue=s(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1kvozu1"&&(ue.textContent=Rl),_t=o(e),ce=s(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-1bin91k"&&(ce.innerHTML=Wl),Ct=o(e),ge=s(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1u5ajxn"&&(ge.textContent=Vl),Zt=o(e),k=s(e,"H2",{class:!0});var nl=p(k);G=s(nl,"A",{id:!0,class:!0,href:!0});var ua=p(G);Ye=s(ua,"SPAN",{});var ca=p(Ye);c(he.$$.fragment,ca),ca.forEach(t),ua.forEach(t),ul=o(nl),Ve=s(nl,"SPAN",{"data-svelte-h":!0}),r(Ve)!=="svelte-1qywztq"&&(Ve.textContent=Bl),nl.forEach(t),Et=o(e),fe=s(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-d5hmja"&&(fe.textContent=Hl),Xt=o(e),Me=s(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-1fs8mlx"&&(Me.innerHTML=ql),Gt=o(e),be=s(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-15hj0dt"&&(be.innerHTML=Nl),zt=o(e),c(ye.$$.fragment,e),It=o(e),ve=s(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-t0s1pc"&&(ve.textContent=Fl),Lt=o(e),c(Je.$$.fragment,e),Rt=o(e),Te=s(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1ujoh2i"&&(Te.innerHTML=Ql),Wt=o(e),c(Ue.$$.fragment,e),Vt=o(e),j=s(e,"H2",{class:!0});var sl=p(j);z=s(sl,"A",{id:!0,class:!0,href:!0});var ga=p(z);Se=s(ga,"SPAN",{});var ha=p(Se);c(we.$$.fragment,ha),ha.forEach(t),ga.forEach(t),cl=o(sl),Be=s(sl,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-1ncd2v"&&(Be.textContent=Pl),sl.forEach(t),Bt=o(e),xe=s(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-11kyy3j"&&(xe.textContent=Al),Ht=o(e),ke=s(e,"UL",{"data-svelte-h":!0}),r(ke)!=="svelte-1dl7zj1"&&(ke.innerHTML=Yl),qt=o(e),je=s(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-z8p06d"&&(je.innerHTML=Sl),Nt=o(e),c($e.$$.fragment,e),Ft=o(e),_e=s(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-t0s1pc"&&(_e.textContent=Dl),Qt=o(e),c(Ce.$$.fragment,e),Pt=o(e),Ze=s(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-qtehx9"&&(Ze.innerHTML=Kl),At=o(e),c(Ee.$$.fragment,e),Yt=o(e),Xe=s(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1xi9zr5"&&(Xe.innerHTML=Ol),St=o(e),De=s(e,"P",{}),p(De).forEach(t),this.h()},h(){m(y,"name","hf:doc:metadata"),m(y,"content",JSON.stringify(wa)),m($,"id","modelos-multilinges-para-inferencia"),m($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m($,"href","#modelos-multilinges-para-inferencia"),m(v,"class","relative group"),m(_,"id","xlm"),m(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(_,"href","#xlm"),m(J,"class","relative group"),m(C,"id","xlm-con-language-embeddings"),m(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(C,"href","#xlm-con-language-embeddings"),m(T,"class","relative group"),m(Z,"id","xlm-sin-language-embeddings"),m(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(Z,"href","#xlm-sin-language-embeddings"),m(U,"class","relative group"),m(E,"id","bert"),m(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(E,"href","#bert"),m(w,"class","relative group"),m(X,"id","xlmroberta"),m(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(X,"href","#xlmroberta"),m(x,"class","relative group"),m(G,"id","m2m100"),m(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(G,"href","#m2m100"),m(k,"class","relative group"),m(z,"id","mbart"),m(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),m(z,"href","#mbart"),m(j,"class","relative group")},m(e,l){d(document.head,y),a(e,Ke,l),a(e,He,l),a(e,Oe,l),a(e,v,l),d(v,$),d($,qe),g(L,qe,null),d(v,il),d(v,Ge),a(e,et,l),g(R,e,l),a(e,tt,l),a(e,W,l),a(e,lt,l),a(e,J,l),d(J,_),d(_,Ne),g(V,Ne,null),d(J,ol),d(J,ze),a(e,at,l),a(e,B,l),a(e,nt,l),a(e,T,l),d(T,C),d(C,Fe),g(H,Fe,null),d(T,rl),d(T,Ie),a(e,st,l),a(e,q,l),a(e,it,l),a(e,N,l),a(e,ot,l),a(e,F,l),a(e,rt,l),a(e,Q,l),a(e,mt,l),g(P,e,l),a(e,dt,l),a(e,A,l),a(e,pt,l),g(Y,e,l),a(e,ut,l),a(e,S,l),a(e,ct,l),g(D,e,l),a(e,gt,l),a(e,K,l),a(e,ht,l),g(O,e,l),a(e,ft,l),a(e,ee,l),a(e,Mt,l),g(te,e,l),a(e,bt,l),a(e,le,l),a(e,yt,l),a(e,U,l),d(U,Z),d(Z,Qe),g(ae,Qe,null),d(U,ml),d(U,Le),a(e,vt,l),a(e,ne,l),a(e,Jt,l),a(e,se,l),a(e,Tt,l),a(e,ie,l),a(e,Ut,l),a(e,w,l),d(w,E),d(E,Pe),g(oe,Pe,null),d(w,dl),d(w,Re),a(e,wt,l),a(e,re,l),a(e,xt,l),a(e,me,l),a(e,kt,l),a(e,de,l),a(e,jt,l),a(e,x,l),d(x,X),d(X,Ae),g(pe,Ae,null),d(x,pl),d(x,We),a(e,$t,l),a(e,ue,l),a(e,_t,l),a(e,ce,l),a(e,Ct,l),a(e,ge,l),a(e,Zt,l),a(e,k,l),d(k,G),d(G,Ye),g(he,Ye,null),d(k,ul),d(k,Ve),a(e,Et,l),a(e,fe,l),a(e,Xt,l),a(e,Me,l),a(e,Gt,l),a(e,be,l),a(e,zt,l),g(ye,e,l),a(e,It,l),a(e,ve,l),a(e,Lt,l),g(Je,e,l),a(e,Rt,l),a(e,Te,l),a(e,Wt,l),g(Ue,e,l),a(e,Vt,l),a(e,j,l),d(j,z),d(z,Se),g(we,Se,null),d(j,cl),d(j,Be),a(e,Bt,l),a(e,xe,l),a(e,Ht,l),a(e,ke,l),a(e,qt,l),a(e,je,l),a(e,Nt,l),g($e,e,l),a(e,Ft,l),a(e,_e,l),a(e,Qt,l),g(Ce,e,l),a(e,Pt,l),a(e,Ze,l),a(e,At,l),g(Ee,e,l),a(e,Yt,l),a(e,Xe,l),a(e,St,l),a(e,De,l),Dt=!0},p:Ma,i(e){Dt||(h(L.$$.fragment,e),h(R.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(he.$$.fragment,e),h(ye.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(we.$$.fragment,e),h($e.$$.fragment,e),h(Ce.$$.fragment,e),h(Ee.$$.fragment,e),Dt=!0)},o(e){f(L.$$.fragment,e),f(R.$$.fragment,e),f(V.$$.fragment,e),f(H.$$.fragment,e),f(P.$$.fragment,e),f(Y.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(ye.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(we.$$.fragment,e),f($e.$$.fragment,e),f(Ce.$$.fragment,e),f(Ee.$$.fragment,e),Dt=!1},d(e){e&&(t(Ke),t(He),t(Oe),t(v),t(et),t(tt),t(W),t(lt),t(J),t(at),t(B),t(nt),t(T),t(st),t(q),t(it),t(N),t(ot),t(F),t(rt),t(Q),t(mt),t(dt),t(A),t(pt),t(ut),t(S),t(ct),t(gt),t(K),t(ht),t(ft),t(ee),t(Mt),t(bt),t(le),t(yt),t(U),t(vt),t(ne),t(Jt),t(se),t(Tt),t(ie),t(Ut),t(w),t(wt),t(re),t(xt),t(me),t(kt),t(de),t(jt),t(x),t($t),t(ue),t(_t),t(ce),t(Ct),t(ge),t(Zt),t(k),t(Et),t(fe),t(Xt),t(Me),t(Gt),t(be),t(zt),t(It),t(ve),t(Lt),t(Rt),t(Te),t(Wt),t(Vt),t(j),t(Bt),t(xe),t(Ht),t(ke),t(qt),t(je),t(Nt),t(Ft),t(_e),t(Qt),t(Pt),t(Ze),t(At),t(Yt),t(Xe),t(St),t(De)),t(y),M(L),M(R,e),M(V),M(H),M(P,e),M(Y,e),M(D,e),M(O,e),M(te,e),M(ae),M(oe),M(pe),M(he),M(ye,e),M(Je,e),M(Ue,e),M(we),M($e,e),M(Ce,e),M(Ee,e)}}}const wa={local:"modelos-multilinges-para-inferencia",sections:[{local:"xlm",sections:[{local:"xlm-con-language-embeddings",title:"XLM con language embeddings"},{local:"xlm-sin-language-embeddings",title:"XLM sin language embeddings"}],title:"XLM"},{local:"bert",title:"BERT"},{local:"xlmroberta",title:"XLM-RoBERTa"},{local:"m2m100",title:"M2M100"},{local:"mbart",title:"MBart"}],title:"Modelos multilingües para inferencia"};function xa(gl){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Za extends ya{constructor(y){super(),va(this,y,xa,Ua,fa,{})}}export{Za as component};
