import{s as fa,n as Ma,o as ba}from"../chunks/scheduler.36a0863c.js";import{S as va,i as ya,g as n,s,u as d,A as Ja,h as i,f as t,c as o,j as u,v as c,y as r,k as p,o as m,a,w as g,d as h,t as f,x as M}from"../chunks/index.d0f7a4c4.js";import{I as E}from"../chunks/IconCopyLink.bc5fad79.js";import{C as b}from"../chunks/CodeBlock.4236768d.js";import{D as Ta}from"../chunks/DocNotebookDropdown.95febfe3.js";function Ua(gl){let v,Ke,He,Oe,y,_,qe,R,sl,Xe,hl="Modelli multilingue per l'inferenza",et,W,tt,L,fl='Ci sono diversi modelli multilingue in 🤗 Transformers, e il loro utilizzo per l’inferenza differisce da quello dei modelli monolingua. Non <em>tutti</em> gli utilizzi dei modelli multilingue sono però diversi. Alcuni modelli, come <a href="https://huggingface.co/bert-base-multilingual-uncased" rel="nofollow">bert-base-multilingual-uncased</a>, possono essere usati come un modello monolingua. Questa guida ti mostrerà come utilizzare modelli multilingue che utilizzano un modo diverso per fare l’inferenza.',lt,J,C,Ne,V,ol,Ge,Ml="XLM",at,B,bl="XLM ha dieci diversi checkpoint, di cui solo uno è monolingua. I nove checkpoint rimanenti possono essere suddivisi in due categorie: i checkpoint che utilizzano i language embeddings e quelli che non li utilizzano.",nt,T,j,Fe,H,rl,Ee,vl="XLM con language embeddings",it,q,yl="I seguenti modelli XLM utilizzano gli embeddings linguistici per specificare la lingua utilizzata per l’inferenza:",st,N,Jl="<li><code>xlm-mlm-ende-1024</code> (Modellazione mascherata del linguaggio (Masked language modeling, in inglese), Inglese-Tedesco)</li> <li><code>xlm-mlm-enfr-1024</code> (Modellazione mascherata del linguaggio, Inglese-Francese)</li> <li><code>xlm-mlm-enro-1024</code> (Modellazione mascherata del linguaggio, Inglese-Rumeno)</li> <li><code>xlm-mlm-xnli15-1024</code> (Modellazione mascherata del linguaggio, lingue XNLI)</li> <li><code>xlm-mlm-tlm-xnli15-1024</code> (Modellazione mascherata del linguaggio + traduzione, lingue XNLI)</li> <li><code>xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese)</li> <li><code>xlm-clm-ende-1024</code> (Modellazione causale del linguaggio, Inglese-Tedesco)</li>",ot,F,Tl="Gli embeddings linguistici sono rappresentati come un tensore delle stesse dimensioni dell’ <code>input_ids</code> passato al modello. I valori in questi tensori dipendono dal linguaggio usato e sono identificati dagli attributi <code>lang2id</code> e <code>id2lang</code> del tokenizer.",rt,Q,Ul="In questo esempio, carica il checkpoint <code>xlm-clm-enfr-1024</code> (Modellazione causale del linguaggio, Inglese-Francese):",pt,P,mt,A,wl="L’attributo <code>lang2id</code> del tokenizer mostra il linguaggio del modello e il suo ids:",ut,Y,dt,S,kl="Poi, crea un esempio di input:",ct,D,gt,K,xl="Imposta l’id del linguaggio a <code>&quot;en&quot;</code> e usalo per definire il language embedding. Il language embedding è un tensore riempito con <code>0</code> perché questo è il language id per l’inglese. Questo tensore dovrebbe avere la stessa dimensione di <code>input_ids</code>.",ht,O,ft,ee,$l="Adesso puoi inserire <code>input_ids</code> e language embedding nel modello:",Mt,te,bt,le,_l='Lo script <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-generation/run_generation.py" rel="nofollow">run_generation.py</a> può generare testo tramite i language embeddings usando i checkpoints <code>xlm-clm</code>.',vt,U,z,Qe,ae,pl,Re,Cl="XLM senza language embeddings",yt,ne,jl="I seguenti modelli XLM non richiedono l’utilizzo dei language embeddings per fare inferenza:",Jt,ie,zl="<li><code>xlm-mlm-17-1280</code> (Modellazione mascherata del linguaggio, 17 lingue)</li> <li><code>xlm-mlm-100-1280</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",Tt,se,Zl="Questi modelli sono utilizzati per rappresentazioni generiche di frasi, a differenza dei precedenti checkpoints XML.",Ut,w,Z,Pe,oe,ml,We,Il="BERT",wt,re,Xl="Il seguente modello BERT può essere usato per compiti multilingue:",kt,pe,Gl="<li><code>bert-base-multilingual-uncased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 102 lingue)</li> <li><code>bert-base-multilingual-cased</code> (Modellazione mascherata del linguaggio + Previsione della prossima frase, 104 lingue)</li>",xt,me,El="Questi modelli non richiedono language embeddings per fare inferenza. Riescono ad identificare il linguaggio dal contesto e inferire di conseguenza.",$t,k,I,Ae,ue,ul,Le,Rl="XLM-RoBERTa",_t,de,Wl="Il seguente modello XLM-RoBERTa può essere usato per compiti multilingue:",Ct,ce,Ll="<li><code>xlm-roberta-base</code> (Modellazione mascherata del linguaggio, 100 lingue)</li> <li><code>xlm-roberta-large</code> (Modellazione mascherata del linguaggio, 100 lingue)</li>",jt,ge,Vl="XLM-RoBERTa è stato addestrato su 2.5TB di dati CommonCrawl appena creati e puliti in 100 lingue. Offre notevoli vantaggi rispetto ai modelli multilingue rilasciati in precedenza, come mBERT o XLM, in compiti come la classificazione, l’etichettatura delle sequenze e la risposta alle domande.",zt,x,X,Ye,he,dl,Ve,Bl="M2M100",Zt,fe,Hl="Il seguente modello M2M100 può essere usato per compiti multilingue:",It,Me,ql="<li><code>facebook/m2m100_418M</code> (Traduzione)</li> <li><code>facebook/m2m100_1.2B</code> (Traduzione)</li>",Xt,be,Nl="In questo esempio, carica il checkpoint <code>facebook/m2m100_418M</code>  per tradurre dal cinese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",Gt,ve,Et,ye,Fl="Applica il tokenizer al testo:",Rt,Je,Wt,Te,Ql="M2M100 forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",Lt,Ue,Vt,$,G,Se,we,cl,Be,Pl="MBart",Bt,ke,Al="Il seguente modello MBart può essere usato per compiti multilingue:",Ht,xe,Yl="<li><code>facebook/mbart-large-50-one-to-many-mmt</code> (Traduzione automatica multilingue uno-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-many-mmt</code> (Traduzione automatica multilingue molti-a-molti, 50 lingue)</li> <li><code>facebook/mbart-large-50-many-to-one-mmt</code> (Traduzione automatica multilingue molti-a-uno, 50 lingue)</li> <li><code>facebook/mbart-large-50</code> (Traduzione multilingue, 50 lingue)</li> <li><code>facebook/mbart-large-cc25</code></li>",qt,$e,Sl="In questo esempio, carica il checkpoint <code>facebook/mbart-large-50-many-to-many-mmt</code> per tradurre dal finlandese all’inglese. Puoi impostare la lingua di partenza nel tokenizer:",Nt,_e,Ft,Ce,Dl="Applica il tokenizer sul testo:",Qt,je,Pt,ze,Kl="MBart forza l’id della lingua obiettivo come primo token generato per tradurre nella lingua obiettivo. Imposta il parametro <code>forced_bos_token_id</code> a <code>en</code> nel metodo <code>generate</code> per tradurre in inglese:",At,Ze,Yt,Ie,Ol="Se stai usando il checkpoint <code>facebook/mbart-large-50-many-to-one-mmt</code>, non hai bisogno di forzare l’id della lingua obiettivo come primo token generato altrimenti l’uso è lo stesso.",St,De,Dt;return R=new E({}),W=new Ta({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/multilingual.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/pytorch/multilingual.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/it/tensorflow/multilingual.ipynb"}]}}),V=new E({}),H=new E({}),P=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwWExNVG9rZW5pemVyJTJDJTIwWExNV2l0aExNSGVhZE1vZGVsJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExNVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ4bG0tY2xtLWVuZnItMTAyNCUyMiklMEFtb2RlbCUyMCUzRCUyMFhMTVdpdGhMTUhlYWRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeGxtLWNsbS1lbmZyLTEwMjQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLMTokenizer, XLMWithLMHeadModel

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLMTokenizer.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = XLMWithLMHeadModel.from_pretrained(<span class="hljs-string">&quot;xlm-clm-enfr-1024&quot;</span>)`,wrap:!1}}),Y=new b({props:{code:"cHJpbnQodG9rZW5pemVyLmxhbmcyaWQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.lang2id)
{<span class="hljs-string">&#x27;en&#x27;</span>: <span class="hljs-number">0</span>, <span class="hljs-string">&#x27;fr&#x27;</span>: <span class="hljs-number">1</span>}`,wrap:!1}}),D=new b({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QnRva2VuaXplci5lbmNvZGUoJTIyV2lraXBlZGlhJTIwd2FzJTIwdXNlZCUyMHRvJTIyKSU1RCklMjAlMjAlMjMlMjBiYXRjaCUyMHNpemUlMjBvZiUyMDE=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>input_ids = torch.tensor([tokenizer.encode(<span class="hljs-string">&quot;Wikipedia was used to&quot;</span>)])  <span class="hljs-comment"># batch size of 1</span>',wrap:!1}}),O=new b({props:{code:"bGFuZ3VhZ2VfaWQlMjAlM0QlMjB0b2tlbml6ZXIubGFuZzJpZCU1QiUyMmVuJTIyJTVEJTIwJTIwJTIzJTIwMCUwQWxhbmdzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1Qmxhbmd1YWdlX2lkJTVEJTIwKiUyMGlucHV0X2lkcy5zaGFwZSU1QjElNUQpJTIwJTIwJTIzJTIwdG9yY2gudGVuc29yKCU1QjAlMkMlMjAwJTJDJTIwMCUyQyUyMC4uLiUyQyUyMDAlNUQpJTBBJTBBJTIzJTIwV2UlMjByZXNoYXBlJTIwaXQlMjB0byUyMGJlJTIwb2YlMjBzaXplJTIwKGJhdGNoX3NpemUlMkMlMjBzZXF1ZW5jZV9sZW5ndGgpJTBBbGFuZ3MlMjAlM0QlMjBsYW5ncy52aWV3KDElMkMlMjAtMSklMjAlMjAlMjMlMjBpcyUyMG5vdyUyMG9mJTIwc2hhcGUlMjAlNUIxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTVEJTIwKHdlJTIwaGF2ZSUyMGElMjBiYXRjaCUyMHNpemUlMjBvZiUyMDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>language_id = tokenizer.lang2id[<span class="hljs-string">&quot;en&quot;</span>]  <span class="hljs-comment"># 0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = torch.tensor([language_id] * input_ids.shape[<span class="hljs-number">1</span>])  <span class="hljs-comment"># torch.tensor([0, 0, 0, ..., 0])</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># We reshape it to be of size (batch_size, sequence_length)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>langs = langs.view(<span class="hljs-number">1</span>, -<span class="hljs-number">1</span>)  <span class="hljs-comment"># is now of shape [1, sequence_length] (we have a batch size of 1)</span>`,wrap:!1}}),te=new b({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUyQyUyMGxhbmdzJTNEbGFuZ3Mp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_ids, langs=langs)',wrap:!1}}),ae=new E({}),oe=new E({}),ue=new E({}),he=new E({}),ve=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME0yTTEwMEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyME0yTTEwMFRva2VuaXplciUwQSUwQWVuX3RleHQlMjAlM0QlMjAlMjJEbyUyMG5vdCUyMG1lZGRsZSUyMGluJTIwdGhlJTIwYWZmYWlycyUyMG9mJTIwd2l6YXJkcyUyQyUyMGZvciUyMHRoZXklMjBhcmUlMjBzdWJ0bGUlMjBhbmQlMjBxdWljayUyMHRvJTIwYW5nZXIuJTIyJTBBY2hpbmVzZV90ZXh0JTIwJTNEJTIwJTIyJUU0JUI4JThEJUU4JUE2JTgxJUU2JThGJTkyJUU2JTg5JThCJUU1JUI3JUFCJUU1JUI4JUFCJUU3JTlBJTg0JUU0JUJBJThCJUU1JThCJTk5JTJDJTIwJUU1JTlCJUEwJUU3JTgyJUJBJUU0JUJCJTk2JUU1JTgwJTkxJUU2JTk4JUFGJUU1JUJFJUFFJUU1JUE2JTk5JUU3JTlBJTg0JTJDJTIwJUU1JUJFJTg4JUU1JUJGJUFCJUU1JUIwJUIxJUU2JTlDJTgzJUU3JTk5JUJDJUU2JTgwJTkyLiUyMiUwQSUwQXRva2VuaXplciUyMCUzRCUyME0yTTEwMFRva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtMm0xMDBfNDE4TSUyMiUyQyUyMHNyY19sYW5nJTNEJTIyemglMjIpJTBBbW9kZWwlMjAlM0QlMjBNMk0xMDBGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbTJtMTAwXzQxOE0lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> M2M100ForConditionalGeneration, M2M100Tokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chinese_text = <span class="hljs-string">&quot;不要插手巫師的事務, 因為他們是微妙的, 很快就會發怒.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = M2M100Tokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>, src_lang=<span class="hljs-string">&quot;zh&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = M2M100ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/m2m100_418M&quot;</span>)`,wrap:!1}}),Je=new b({props:{code:"ZW5jb2RlZF96aCUyMCUzRCUyMHRva2VuaXplcihjaGluZXNlX3RleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_zh = tokenizer(chinese_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ue=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF96aCUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIuZ2V0X2xhbmdfaWQoJTIyZW4lMjIpKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX3Rva2VucyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_zh, forced_bos_token_id=tokenizer.get_lang_id(<span class="hljs-string">&quot;en&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&#x27;Do not interfere with the matters of the witches, because they are delicate and will soon be angry.&#x27;</span>`,wrap:!1}}),we=new E({}),_e=new b({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JTZXEyU2VxTE0lMEElMEFlbl90ZXh0JTIwJTNEJTIwJTIyRG8lMjBub3QlMjBtZWRkbGUlMjBpbiUyMHRoZSUyMGFmZmFpcnMlMjBvZiUyMHdpemFyZHMlMkMlMjBmb3IlMjB0aGV5JTIwYXJlJTIwc3VidGxlJTIwYW5kJTIwcXVpY2slMjB0byUyMGFuZ2VyLiUyMiUwQWZpX3RleHQlMjAlM0QlMjAlMjIlQzMlODRsJUMzJUE0JTIwc2VrYWFubnUlMjB2ZWxob2plbiUyMGFzaW9paGluJTJDJTIwc2lsbCVDMyVBNCUyMG5lJTIwb3ZhdCUyMGhpZW5vdmFyYWlzaWElMjBqYSUyMG5vcGVhc3RpJTIwdmloYWlzaWEuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyJTJDJTIwc3JjX2xhbmclM0QlMjJmaV9GSSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYmFydC1sYXJnZS01MC1tYW55LXRvLW1hbnktbW10JTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>en_text = <span class="hljs-string">&quot;Do not meddle in the affairs of wizards, for they are subtle and quick to anger.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fi_text = <span class="hljs-string">&quot;Älä sekaannu velhojen asioihin, sillä ne ovat hienovaraisia ja nopeasti vihaisia.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>, src_lang=<span class="hljs-string">&quot;fi_FI&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;facebook/mbart-large-50-many-to-many-mmt&quot;</span>)`,wrap:!1}}),je=new b({props:{code:"ZW5jb2RlZF9lbiUyMCUzRCUyMHRva2VuaXplcihlbl90ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>encoded_en = tokenizer(en_text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)',wrap:!1}}),Ze=new b({props:{code:"Z2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqZW5jb2RlZF9lbiUyQyUyMGZvcmNlZF9ib3NfdG9rZW5faWQlM0R0b2tlbml6ZXIubGFuZ19jb2RlX3RvX2lkKCUyMmVuX1hYJTIyKSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlZF90b2tlbnMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generated_tokens = model.generate(**encoded_en, forced_bos_token_id=tokenizer.lang_code_to_id(<span class="hljs-string">&quot;en_XX&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;Don&#x27;t interfere with the wizard&#x27;s affairs, because they are subtle, will soon get angry.&quot;</span>`,wrap:!1}}),{c(){v=n("meta"),Ke=s(),He=n("p"),Oe=s(),y=n("h1"),_=n("a"),qe=n("span"),d(R.$$.fragment),sl=s(),Xe=n("span"),Xe.textContent=hl,et=s(),d(W.$$.fragment),tt=s(),L=n("p"),L.innerHTML=fl,lt=s(),J=n("h2"),C=n("a"),Ne=n("span"),d(V.$$.fragment),ol=s(),Ge=n("span"),Ge.textContent=Ml,at=s(),B=n("p"),B.textContent=bl,nt=s(),T=n("h3"),j=n("a"),Fe=n("span"),d(H.$$.fragment),rl=s(),Ee=n("span"),Ee.textContent=vl,it=s(),q=n("p"),q.textContent=yl,st=s(),N=n("ul"),N.innerHTML=Jl,ot=s(),F=n("p"),F.innerHTML=Tl,rt=s(),Q=n("p"),Q.innerHTML=Ul,pt=s(),d(P.$$.fragment),mt=s(),A=n("p"),A.innerHTML=wl,ut=s(),d(Y.$$.fragment),dt=s(),S=n("p"),S.textContent=kl,ct=s(),d(D.$$.fragment),gt=s(),K=n("p"),K.innerHTML=xl,ht=s(),d(O.$$.fragment),ft=s(),ee=n("p"),ee.innerHTML=$l,Mt=s(),d(te.$$.fragment),bt=s(),le=n("p"),le.innerHTML=_l,vt=s(),U=n("h3"),z=n("a"),Qe=n("span"),d(ae.$$.fragment),pl=s(),Re=n("span"),Re.textContent=Cl,yt=s(),ne=n("p"),ne.textContent=jl,Jt=s(),ie=n("ul"),ie.innerHTML=zl,Tt=s(),se=n("p"),se.textContent=Zl,Ut=s(),w=n("h2"),Z=n("a"),Pe=n("span"),d(oe.$$.fragment),ml=s(),We=n("span"),We.textContent=Il,wt=s(),re=n("p"),re.textContent=Xl,kt=s(),pe=n("ul"),pe.innerHTML=Gl,xt=s(),me=n("p"),me.textContent=El,$t=s(),k=n("h2"),I=n("a"),Ae=n("span"),d(ue.$$.fragment),ul=s(),Le=n("span"),Le.textContent=Rl,_t=s(),de=n("p"),de.textContent=Wl,Ct=s(),ce=n("ul"),ce.innerHTML=Ll,jt=s(),ge=n("p"),ge.textContent=Vl,zt=s(),x=n("h2"),X=n("a"),Ye=n("span"),d(he.$$.fragment),dl=s(),Ve=n("span"),Ve.textContent=Bl,Zt=s(),fe=n("p"),fe.textContent=Hl,It=s(),Me=n("ul"),Me.innerHTML=ql,Xt=s(),be=n("p"),be.innerHTML=Nl,Gt=s(),d(ve.$$.fragment),Et=s(),ye=n("p"),ye.textContent=Fl,Rt=s(),d(Je.$$.fragment),Wt=s(),Te=n("p"),Te.innerHTML=Ql,Lt=s(),d(Ue.$$.fragment),Vt=s(),$=n("h2"),G=n("a"),Se=n("span"),d(we.$$.fragment),cl=s(),Be=n("span"),Be.textContent=Pl,Bt=s(),ke=n("p"),ke.textContent=Al,Ht=s(),xe=n("ul"),xe.innerHTML=Yl,qt=s(),$e=n("p"),$e.innerHTML=Sl,Nt=s(),d(_e.$$.fragment),Ft=s(),Ce=n("p"),Ce.textContent=Dl,Qt=s(),d(je.$$.fragment),Pt=s(),ze=n("p"),ze.innerHTML=Kl,At=s(),d(Ze.$$.fragment),Yt=s(),Ie=n("p"),Ie.innerHTML=Ol,St=s(),De=n("p"),this.h()},l(e){const l=Ja("svelte-1phssyn",document.head);v=i(l,"META",{name:!0,content:!0}),l.forEach(t),Ke=o(e),He=i(e,"P",{}),u(He).forEach(t),Oe=o(e),y=i(e,"H1",{class:!0});var Kt=u(y);_=i(Kt,"A",{id:!0,class:!0,href:!0});var ea=u(_);qe=i(ea,"SPAN",{});var ta=u(qe);c(R.$$.fragment,ta),ta.forEach(t),ea.forEach(t),sl=o(Kt),Xe=i(Kt,"SPAN",{"data-svelte-h":!0}),r(Xe)!=="svelte-1boclus"&&(Xe.textContent=hl),Kt.forEach(t),et=o(e),c(W.$$.fragment,e),tt=o(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1t4n8rr"&&(L.innerHTML=fl),lt=o(e),J=i(e,"H2",{class:!0});var Ot=u(J);C=i(Ot,"A",{id:!0,class:!0,href:!0});var la=u(C);Ne=i(la,"SPAN",{});var aa=u(Ne);c(V.$$.fragment,aa),aa.forEach(t),la.forEach(t),ol=o(Ot),Ge=i(Ot,"SPAN",{"data-svelte-h":!0}),r(Ge)!=="svelte-zmv7xk"&&(Ge.textContent=Ml),Ot.forEach(t),at=o(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-b0zdcx"&&(B.textContent=bl),nt=o(e),T=i(e,"H3",{class:!0});var el=u(T);j=i(el,"A",{id:!0,class:!0,href:!0});var na=u(j);Fe=i(na,"SPAN",{});var ia=u(Fe);c(H.$$.fragment,ia),ia.forEach(t),na.forEach(t),rl=o(el),Ee=i(el,"SPAN",{"data-svelte-h":!0}),r(Ee)!=="svelte-1l36ee4"&&(Ee.textContent=vl),el.forEach(t),it=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-6flhpc"&&(q.textContent=yl),st=o(e),N=i(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-10q5i5g"&&(N.innerHTML=Jl),ot=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1o9s8ae"&&(F.innerHTML=Tl),rt=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-dkazcf"&&(Q.innerHTML=Ul),pt=o(e),c(P.$$.fragment,e),mt=o(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1lvsgdy"&&(A.innerHTML=wl),ut=o(e),c(Y.$$.fragment,e),dt=o(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1gs48v1"&&(S.textContent=kl),ct=o(e),c(D.$$.fragment,e),gt=o(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1lqmqx6"&&(K.innerHTML=xl),ht=o(e),c(O.$$.fragment,e),ft=o(e),ee=i(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1257czm"&&(ee.innerHTML=$l),Mt=o(e),c(te.$$.fragment,e),bt=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-docsh6"&&(le.innerHTML=_l),vt=o(e),U=i(e,"H3",{class:!0});var tl=u(U);z=i(tl,"A",{id:!0,class:!0,href:!0});var sa=u(z);Qe=i(sa,"SPAN",{});var oa=u(Qe);c(ae.$$.fragment,oa),oa.forEach(t),sa.forEach(t),pl=o(tl),Re=i(tl,"SPAN",{"data-svelte-h":!0}),r(Re)!=="svelte-dehfuv"&&(Re.textContent=Cl),tl.forEach(t),yt=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1fsmnuh"&&(ne.textContent=jl),Jt=o(e),ie=i(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1a8brqg"&&(ie.innerHTML=zl),Tt=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-18famm0"&&(se.textContent=Zl),Ut=o(e),w=i(e,"H2",{class:!0});var ll=u(w);Z=i(ll,"A",{id:!0,class:!0,href:!0});var ra=u(Z);Pe=i(ra,"SPAN",{});var pa=u(Pe);c(oe.$$.fragment,pa),pa.forEach(t),ra.forEach(t),ml=o(ll),We=i(ll,"SPAN",{"data-svelte-h":!0}),r(We)!=="svelte-d1aweg"&&(We.textContent=Il),ll.forEach(t),wt=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-16x26sb"&&(re.textContent=Xl),kt=o(e),pe=i(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-mn71at"&&(pe.innerHTML=Gl),xt=o(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-nozyay"&&(me.textContent=El),$t=o(e),k=i(e,"H2",{class:!0});var al=u(k);I=i(al,"A",{id:!0,class:!0,href:!0});var ma=u(I);Ae=i(ma,"SPAN",{});var ua=u(Ae);c(ue.$$.fragment,ua),ua.forEach(t),ma.forEach(t),ul=o(al),Le=i(al,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-on8il6"&&(Le.textContent=Rl),al.forEach(t),_t=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-6sllth"&&(de.textContent=Wl),Ct=o(e),ce=i(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-uwbm6k"&&(ce.innerHTML=Ll),jt=o(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-1t17k0a"&&(ge.textContent=Vl),zt=o(e),x=i(e,"H2",{class:!0});var nl=u(x);X=i(nl,"A",{id:!0,class:!0,href:!0});var da=u(X);Ye=i(da,"SPAN",{});var ca=u(Ye);c(he.$$.fragment,ca),ca.forEach(t),da.forEach(t),dl=o(nl),Ve=i(nl,"SPAN",{"data-svelte-h":!0}),r(Ve)!=="svelte-1qywztq"&&(Ve.textContent=Bl),nl.forEach(t),Zt=o(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-sftpup"&&(fe.textContent=Hl),It=o(e),Me=i(e,"UL",{"data-svelte-h":!0}),r(Me)!=="svelte-13d4mst"&&(Me.innerHTML=ql),Xt=o(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-13sr045"&&(be.innerHTML=Nl),Gt=o(e),c(ve.$$.fragment,e),Et=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1ysq4ea"&&(ye.textContent=Fl),Rt=o(e),c(Je.$$.fragment,e),Wt=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1hcjl5u"&&(Te.innerHTML=Ql),Lt=o(e),c(Ue.$$.fragment,e),Vt=o(e),$=i(e,"H2",{class:!0});var il=u($);G=i(il,"A",{id:!0,class:!0,href:!0});var ga=u(G);Se=i(ga,"SPAN",{});var ha=u(Se);c(we.$$.fragment,ha),ha.forEach(t),ga.forEach(t),cl=o(il),Be=i(il,"SPAN",{"data-svelte-h":!0}),r(Be)!=="svelte-1ncd2v"&&(Be.textContent=Pl),il.forEach(t),Bt=o(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-hqe28c"&&(ke.textContent=Al),Ht=o(e),xe=i(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-15l5ps7"&&(xe.innerHTML=Yl),qt=o(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-niv51s"&&($e.innerHTML=Sl),Nt=o(e),c(_e.$$.fragment,e),Ft=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-5lihjd"&&(Ce.textContent=Dl),Qt=o(e),c(je.$$.fragment,e),Pt=o(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-21vlhj"&&(ze.innerHTML=Kl),At=o(e),c(Ze.$$.fragment,e),Yt=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-m0bu83"&&(Ie.innerHTML=Ol),St=o(e),De=i(e,"P",{}),u(De).forEach(t),this.h()},h(){p(v,"name","hf:doc:metadata"),p(v,"content",JSON.stringify(wa)),p(_,"id","modelli-multilingue-per-linferenza"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#modelli-multilingue-per-linferenza"),p(y,"class","relative group"),p(C,"id","xlm"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#xlm"),p(J,"class","relative group"),p(j,"id","xlm-con-language-embeddings"),p(j,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(j,"href","#xlm-con-language-embeddings"),p(T,"class","relative group"),p(z,"id","xlm-senza-language-embeddings"),p(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(z,"href","#xlm-senza-language-embeddings"),p(U,"class","relative group"),p(Z,"id","bert"),p(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(Z,"href","#bert"),p(w,"class","relative group"),p(I,"id","xlmroberta"),p(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(I,"href","#xlmroberta"),p(k,"class","relative group"),p(X,"id","m2m100"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#m2m100"),p(x,"class","relative group"),p(G,"id","mbart"),p(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(G,"href","#mbart"),p($,"class","relative group")},m(e,l){m(document.head,v),a(e,Ke,l),a(e,He,l),a(e,Oe,l),a(e,y,l),m(y,_),m(_,qe),g(R,qe,null),m(y,sl),m(y,Xe),a(e,et,l),g(W,e,l),a(e,tt,l),a(e,L,l),a(e,lt,l),a(e,J,l),m(J,C),m(C,Ne),g(V,Ne,null),m(J,ol),m(J,Ge),a(e,at,l),a(e,B,l),a(e,nt,l),a(e,T,l),m(T,j),m(j,Fe),g(H,Fe,null),m(T,rl),m(T,Ee),a(e,it,l),a(e,q,l),a(e,st,l),a(e,N,l),a(e,ot,l),a(e,F,l),a(e,rt,l),a(e,Q,l),a(e,pt,l),g(P,e,l),a(e,mt,l),a(e,A,l),a(e,ut,l),g(Y,e,l),a(e,dt,l),a(e,S,l),a(e,ct,l),g(D,e,l),a(e,gt,l),a(e,K,l),a(e,ht,l),g(O,e,l),a(e,ft,l),a(e,ee,l),a(e,Mt,l),g(te,e,l),a(e,bt,l),a(e,le,l),a(e,vt,l),a(e,U,l),m(U,z),m(z,Qe),g(ae,Qe,null),m(U,pl),m(U,Re),a(e,yt,l),a(e,ne,l),a(e,Jt,l),a(e,ie,l),a(e,Tt,l),a(e,se,l),a(e,Ut,l),a(e,w,l),m(w,Z),m(Z,Pe),g(oe,Pe,null),m(w,ml),m(w,We),a(e,wt,l),a(e,re,l),a(e,kt,l),a(e,pe,l),a(e,xt,l),a(e,me,l),a(e,$t,l),a(e,k,l),m(k,I),m(I,Ae),g(ue,Ae,null),m(k,ul),m(k,Le),a(e,_t,l),a(e,de,l),a(e,Ct,l),a(e,ce,l),a(e,jt,l),a(e,ge,l),a(e,zt,l),a(e,x,l),m(x,X),m(X,Ye),g(he,Ye,null),m(x,dl),m(x,Ve),a(e,Zt,l),a(e,fe,l),a(e,It,l),a(e,Me,l),a(e,Xt,l),a(e,be,l),a(e,Gt,l),g(ve,e,l),a(e,Et,l),a(e,ye,l),a(e,Rt,l),g(Je,e,l),a(e,Wt,l),a(e,Te,l),a(e,Lt,l),g(Ue,e,l),a(e,Vt,l),a(e,$,l),m($,G),m(G,Se),g(we,Se,null),m($,cl),m($,Be),a(e,Bt,l),a(e,ke,l),a(e,Ht,l),a(e,xe,l),a(e,qt,l),a(e,$e,l),a(e,Nt,l),g(_e,e,l),a(e,Ft,l),a(e,Ce,l),a(e,Qt,l),g(je,e,l),a(e,Pt,l),a(e,ze,l),a(e,At,l),g(Ze,e,l),a(e,Yt,l),a(e,Ie,l),a(e,St,l),a(e,De,l),Dt=!0},p:Ma,i(e){Dt||(h(R.$$.fragment,e),h(W.$$.fragment,e),h(V.$$.fragment,e),h(H.$$.fragment,e),h(P.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(ue.$$.fragment,e),h(he.$$.fragment,e),h(ve.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(we.$$.fragment,e),h(_e.$$.fragment,e),h(je.$$.fragment,e),h(Ze.$$.fragment,e),Dt=!0)},o(e){f(R.$$.fragment,e),f(W.$$.fragment,e),f(V.$$.fragment,e),f(H.$$.fragment,e),f(P.$$.fragment,e),f(Y.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(oe.$$.fragment,e),f(ue.$$.fragment,e),f(he.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(Ue.$$.fragment,e),f(we.$$.fragment,e),f(_e.$$.fragment,e),f(je.$$.fragment,e),f(Ze.$$.fragment,e),Dt=!1},d(e){e&&(t(Ke),t(He),t(Oe),t(y),t(et),t(tt),t(L),t(lt),t(J),t(at),t(B),t(nt),t(T),t(it),t(q),t(st),t(N),t(ot),t(F),t(rt),t(Q),t(pt),t(mt),t(A),t(ut),t(dt),t(S),t(ct),t(gt),t(K),t(ht),t(ft),t(ee),t(Mt),t(bt),t(le),t(vt),t(U),t(yt),t(ne),t(Jt),t(ie),t(Tt),t(se),t(Ut),t(w),t(wt),t(re),t(kt),t(pe),t(xt),t(me),t($t),t(k),t(_t),t(de),t(Ct),t(ce),t(jt),t(ge),t(zt),t(x),t(Zt),t(fe),t(It),t(Me),t(Xt),t(be),t(Gt),t(Et),t(ye),t(Rt),t(Wt),t(Te),t(Lt),t(Vt),t($),t(Bt),t(ke),t(Ht),t(xe),t(qt),t($e),t(Nt),t(Ft),t(Ce),t(Qt),t(Pt),t(ze),t(At),t(Yt),t(Ie),t(St),t(De)),t(v),M(R),M(W,e),M(V),M(H),M(P,e),M(Y,e),M(D,e),M(O,e),M(te,e),M(ae),M(oe),M(ue),M(he),M(ve,e),M(Je,e),M(Ue,e),M(we),M(_e,e),M(je,e),M(Ze,e)}}}const wa={local:"modelli-multilingue-per-linferenza",sections:[{local:"xlm",sections:[{local:"xlm-con-language-embeddings",title:"XLM con language embeddings"},{local:"xlm-senza-language-embeddings",title:"XLM senza language embeddings"}],title:"XLM"},{local:"bert",title:"BERT"},{local:"xlmroberta",title:"XLM-RoBERTa"},{local:"m2m100",title:"M2M100"},{local:"mbart",title:"MBart"}],title:"Modelli multilingue per l'inferenza"};function ka(gl){return ba(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class za extends va{constructor(v){super(),ya(this,v,ka,Ua,fa,{})}}export{za as component};
