import{s as Ps,o as Fs,n as Ds}from"../chunks/scheduler.36a0863c.js";import{S as Ks,i as Os,g as i,s as a,u as m,A as el,h as p,f as s,c as n,j as u,v as d,y as r,k as o,o as c,a as t,w as M,d as g,t as f,x as y}from"../chunks/index.d0f7a4c4.js";import{T as sl}from"../chunks/Tip.4c7d7eb1.js";import{I as Te}from"../chunks/IconCopyLink.bc5fad79.js";import{C as U}from"../chunks/CodeBlock.4236768d.js";function ll($e){let h,z="Dai un’occhiata alla documentazione di <code>pipeline()</code> per una lista completa dei compiti supportati.";return{c(){h=i("p"),h.innerHTML=z},l(j){h=p(j,"P",{"data-svelte-h":!0}),r(h)!=="svelte-19razip"&&(h.innerHTML=z)},m(j,ue){t(j,h,ue)},p:Ds,d(j){j&&s(h)}}}function tl($e){let h,z,j,ue,w,$,je,B,ms,de,fs="Pipeline per l'inferenza",xe,W,ys='La <code>pipeline()</code> rende semplice usare qualsiasi modello dal <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a> per fare inferenza su diversi compiti come generazione del testo, segmentazione di immagini e classificazione di audio. Anche se non hai esperienza con una modalità specifica o non comprendi bene il codice che alimenta i modelli, è comunque possibile utilizzarli con l’opzione <code>pipeline()</code>! Questa esercitazione ti insegnerà a:',ke,H,js="<li>Usare una <code>pipeline()</code> per fare inferenza.</li> <li>Usare uno specifico tokenizer o modello.</li> <li>Usare una <code>pipeline()</code> per compiti che riguardano audio e video.</li>",Ce,x,Ze,v,k,Ue,_,us,Me,Us="Utilizzo della Pipeline",Ie,V,ws="Nonostante ogni compito abbia una <code>pipeline()</code> associata, è più semplice utilizzare l’astrazione generica della <code>pipeline()</code> che contiene tutte quelle specifiche per ogni mansione. La <code>pipeline()</code> carica automaticamente un modello predefinito e un tokenizer in grado di fare inferenza per il tuo compito.",Ge,q,vs="<li>Inizia creando una <code>pipeline()</code> e specificando il compito su cui fare inferenza:</li>",ze,R,Be,C,bs="<li>Inserisci il testo in input nella <code>pipeline()</code>:</li>",We,E,He,S,Js="Se hai più di un input, inseriscilo in una lista:",_e,A,Ve,N,Ts="Qualsiasi parametro addizionale per il tuo compito può essere incluso nella <code>pipeline()</code>. La mansione <code>text-generation</code> ha un metodo <code>generate()</code> con diversi parametri per controllare l’output. Ad esempio, se desideri generare più di un output, utilizza il parametro <code>num_return_sequences</code>:",qe,X,Re,b,Z,we,L,ds,ge,$s="Scegliere modello e tokenizer",Ee,Q,xs='La <code>pipeline()</code> accetta qualsiasi modello dal <a href="https://huggingface.co/models" rel="nofollow">Model Hub</a>. Ci sono tag nel Model Hub che consentono di filtrare i modelli per attività. Una volta che avrai scelto il modello appropriato, caricalo usando la corrispondente classe <code>AutoModelFor</code> e <code>AutoTokenizer</code>. Ad esempio, carica la classe <code>AutoModelForCausalLM</code> per un compito di causal language modeling:',Se,Y,Ae,P,ks="Crea una <code>pipeline()</code> per il tuo compito, specificando il modello e il tokenizer che hai caricato:",Ne,F,Xe,D,Cs="Inserisci il testo di input nella <code>pipeline()</code> per generare del testo:",Le,K,Qe,J,I,ve,O,Ms,fe,Zs="Audio pipeline",Ye,ee,Is="La flessibilità della <code>pipeline()</code> fa si che possa essere estesa ad attività sugli audio.",Pe,se,Gs="Per esempio, classifichiamo le emozioni in questo clip audio:",Fe,le,De,te,zs='Trova un modello per la <a href="https://huggingface.co/models?pipeline_tag=audio-classification" rel="nofollow">classificazione audio</a> sul Model Hub per eseguire un compito di riconoscimento automatico delle emozioni e caricalo nella <code>pipeline()</code>:',Ke,ae,Oe,ne,Bs="Inserisci il file audio nella <code>pipeline()</code>:",es,ie,ss,T,G,be,pe,gs,ye,Ws="Vision pipeline",ls,oe,Hs="Infine, usare la <code>pipeline()</code> per le attività sulle immagini è praticamente la stessa cosa.",ts,re,_s="Specifica la tua attività e inserisci l’immagine nel classificatore. L’immagine può essere sia un link che un percorso sul tuo pc in locale. Per esempio, quale specie di gatto è raffigurata qui sotto?",as,ce,Vs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg" alt="pipeline-cat-chonk"/>',ns,he,is,Je,ps;return B=new Te({}),x=new sl({props:{$$slots:{default:[ll]},$$scope:{ctx:$e}}}),_=new Te({}),R=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>)`,wrap:!1}}),E=new U({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Iron-priests at the door to the east, and thirteen for the Lord Kings at the end of the mountain&#x27;</span>}]`,wrap:!1}}),A=new U({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOaW5lJTIwZm9yJTIwTW9ydGFsJTIwTWVuJTJDJTIwZG9vbWVkJTIwdG8lMjBkaWUlMkMlMjBPbmUlMjBmb3IlMjB0aGUlMjBEYXJrJTIwTG9yZCUyMG9uJTIwaGlzJTIwZGFyayUyMHRocm9uZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU1RCUwQSklMjAlMjAlMjMlMjBkb2N0ZXN0JTNBJTIwJTJCU0tJUA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    [
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;Nine for Mortal Men, doomed to die, One for the Dark Lord on his dark throne&quot;</span>,
<span class="hljs-meta">... </span>    ]
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),X=new U({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDIlMkMlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>,
<span class="hljs-meta">... </span>    num_return_sequences=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>`,wrap:!1}}),L=new Te({}),Y=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmRpc3RpbGdwdDIlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGlzdGlsZ3B0MiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;distilgpt2&quot;</span>)`,wrap:!1}}),F=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwcGlwZWxpbmUodGFzayUzRCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>generator = pipeline(task=<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),K=new U({props:{code:"Z2VuZXJhdG9yKCUwQSUyMCUyMCUyMCUyMCUyMlRocmVlJTIwUmluZ3MlMjBmb3IlMjB0aGUlMjBFbHZlbi1raW5ncyUyMHVuZGVyJTIwdGhlJTIwc2t5JTJDJTIwU2V2ZW4lMjBmb3IlMjB0aGUlMjBEd2FyZi1sb3JkcyUyMGluJTIwdGhlaXIlMjBoYWxscyUyMG9mJTIwc3RvbmUlMjIlMEEpJTIwJTIwJTIzJTIwZG9jdGVzdCUzQSUyMCUyQlNLSVA=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>generator(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone&quot;</span>
<span class="hljs-meta">... </span>)  <span class="hljs-comment"># doctest: +SKIP</span>
[{<span class="hljs-string">&#x27;generated_text&#x27;</span>: <span class="hljs-string">&#x27;Three Rings for the Elven-kings under the sky, Seven for the Dwarf-lords in their halls of stone, Seven for the Dragon-lords (for them to rule in a world ruled by their rulers, and all who live within the realm&#x27;</span>}]`,wrap:!1}}),O=new Te({}),le=new U({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b3JjaC5tYW51YWxfc2VlZCg0MiklMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFhdWRpb19maWxlJTIwJTNEJTIwZHMlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJwYXRoJTIyJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>torch.manual_seed(<span class="hljs-number">42</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_file = ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;path&quot;</span>]`,wrap:!1}}),ae=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBYXVkaW9fY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEJTIyZWhjYWxhYnJlcyUyRndhdjJ2ZWMyLWxnLXhsc3ItZW4tc3BlZWNoLWVtb3Rpb24tcmVjb2duaXRpb24lMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_classifier = pipeline(
<span class="hljs-meta">... </span>    task=<span class="hljs-string">&quot;audio-classification&quot;</span>, model=<span class="hljs-string">&quot;ehcalabres/wav2vec2-lg-xlsr-en-speech-emotion-recognition&quot;</span>
<span class="hljs-meta">... </span>)`,wrap:!1}}),ie=new U({props:{code:"cHJlZHMlMjAlM0QlMjBhdWRpb19jbGFzc2lmaWVyKGF1ZGlvX2ZpbGUpJTBBcHJlZHMlMjAlM0QlMjAlNUIlN0IlMjJzY29yZSUyMiUzQSUyMHJvdW5kKHByZWQlNUIlMjJzY29yZSUyMiU1RCUyQyUyMDQpJTJDJTIwJTIybGFiZWwlMjIlM0ElMjBwcmVkJTVCJTIybGFiZWwlMjIlNUQlN0QlMjBmb3IlMjBwcmVkJTIwaW4lMjBwcmVkcyU1RCUwQXByZWRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>preds = audio_classifier(audio_file)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1315</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;calm&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1307</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;neutral&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1274</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;sad&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1261</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;fearful&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.1242</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;happy&#x27;</span>}]`,wrap:!1}}),pe=new Te({}),he=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBdmlzaW9uX2NsYXNzaWZpZXIlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtY2xhc3NpZmljYXRpb24lMjIpJTBBcHJlZHMlMjAlM0QlMjB2aXNpb25fY2xhc3NpZmllciglMEElMjAlMjAlMjAlMjBpbWFnZXMlM0QlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZwaXBlbGluZS1jYXQtY2hvbmsuanBlZyUyMiUwQSklMEFwcmVkcyUyMCUzRCUyMCU1QiU3QiUyMnNjb3JlJTIyJTNBJTIwcm91bmQocHJlZCU1QiUyMnNjb3JlJTIyJTVEJTJDJTIwNCklMkMlMjAlMjJsYWJlbCUyMiUzQSUyMHByZWQlNUIlMjJsYWJlbCUyMiU1RCU3RCUyMGZvciUyMHByZWQlMjBpbiUyMHByZWRzJTVEJTBBcHJlZHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>vision_classifier = pipeline(task=<span class="hljs-string">&quot;image-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = vision_classifier(
<span class="hljs-meta">... </span>    images=<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/pipeline-cat-chonk.jpeg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preds = [{<span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-built_in">round</span>(pred[<span class="hljs-string">&quot;score&quot;</span>], <span class="hljs-number">4</span>), <span class="hljs-string">&quot;label&quot;</span>: pred[<span class="hljs-string">&quot;label&quot;</span>]} <span class="hljs-keyword">for</span> pred <span class="hljs-keyword">in</span> preds]
<span class="hljs-meta">&gt;&gt;&gt; </span>preds
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.4335</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;lynx, catamount&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0348</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;cougar, puma, catamount, mountain lion, painter, panther, Felis concolor&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0324</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;snow leopard, ounce, Panthera uncia&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0239</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Egyptian cat&#x27;</span>}, {<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.0229</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;tiger cat&#x27;</span>}]`,wrap:!1}}),{c(){h=i("meta"),z=a(),j=i("p"),ue=a(),w=i("h1"),$=i("a"),je=i("span"),m(B.$$.fragment),ms=a(),de=i("span"),de.textContent=fs,xe=a(),W=i("p"),W.innerHTML=ys,ke=a(),H=i("ul"),H.innerHTML=js,Ce=a(),m(x.$$.fragment),Ze=a(),v=i("h2"),k=i("a"),Ue=i("span"),m(_.$$.fragment),us=a(),Me=i("span"),Me.textContent=Us,Ie=a(),V=i("p"),V.innerHTML=ws,Ge=a(),q=i("ol"),q.innerHTML=vs,ze=a(),m(R.$$.fragment),Be=a(),C=i("ol"),C.innerHTML=bs,We=a(),m(E.$$.fragment),He=a(),S=i("p"),S.textContent=Js,_e=a(),m(A.$$.fragment),Ve=a(),N=i("p"),N.innerHTML=Ts,qe=a(),m(X.$$.fragment),Re=a(),b=i("h3"),Z=i("a"),we=i("span"),m(L.$$.fragment),ds=a(),ge=i("span"),ge.textContent=$s,Ee=a(),Q=i("p"),Q.innerHTML=xs,Se=a(),m(Y.$$.fragment),Ae=a(),P=i("p"),P.innerHTML=ks,Ne=a(),m(F.$$.fragment),Xe=a(),D=i("p"),D.innerHTML=Cs,Le=a(),m(K.$$.fragment),Qe=a(),J=i("h2"),I=i("a"),ve=i("span"),m(O.$$.fragment),Ms=a(),fe=i("span"),fe.textContent=Zs,Ye=a(),ee=i("p"),ee.innerHTML=Is,Pe=a(),se=i("p"),se.textContent=Gs,Fe=a(),m(le.$$.fragment),De=a(),te=i("p"),te.innerHTML=zs,Ke=a(),m(ae.$$.fragment),Oe=a(),ne=i("p"),ne.innerHTML=Bs,es=a(),m(ie.$$.fragment),ss=a(),T=i("h2"),G=i("a"),be=i("span"),m(pe.$$.fragment),gs=a(),ye=i("span"),ye.textContent=Ws,ls=a(),oe=i("p"),oe.innerHTML=Hs,ts=a(),re=i("p"),re.textContent=_s,as=a(),ce=i("p"),ce.innerHTML=Vs,ns=a(),m(he.$$.fragment),is=a(),Je=i("p"),this.h()},l(e){const l=el("svelte-1phssyn",document.head);h=p(l,"META",{name:!0,content:!0}),l.forEach(s),z=n(e),j=p(e,"P",{}),u(j).forEach(s),ue=n(e),w=p(e,"H1",{class:!0});var me=u(w);$=p(me,"A",{id:!0,class:!0,href:!0});var qs=u($);je=p(qs,"SPAN",{});var Rs=u(je);d(B.$$.fragment,Rs),Rs.forEach(s),qs.forEach(s),ms=n(me),de=p(me,"SPAN",{"data-svelte-h":!0}),r(de)!=="svelte-4b8ml9"&&(de.textContent=fs),me.forEach(s),xe=n(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1rvqis7"&&(W.innerHTML=ys),ke=n(e),H=p(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-fik7a1"&&(H.innerHTML=js),Ce=n(e),d(x.$$.fragment,e),Ze=n(e),v=p(e,"H2",{class:!0});var os=u(v);k=p(os,"A",{id:!0,class:!0,href:!0});var Es=u(k);Ue=p(Es,"SPAN",{});var Ss=u(Ue);d(_.$$.fragment,Ss),Ss.forEach(s),Es.forEach(s),us=n(os),Me=p(os,"SPAN",{"data-svelte-h":!0}),r(Me)!=="svelte-j8gtwj"&&(Me.textContent=Us),os.forEach(s),Ie=n(e),V=p(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1nqd0ay"&&(V.innerHTML=ws),Ge=n(e),q=p(e,"OL",{"data-svelte-h":!0}),r(q)!=="svelte-a5h60b"&&(q.innerHTML=vs),ze=n(e),d(R.$$.fragment,e),Be=n(e),C=p(e,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-13e2sq6"&&(C.innerHTML=bs),We=n(e),d(E.$$.fragment,e),He=n(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-tdglgg"&&(S.textContent=Js),_e=n(e),d(A.$$.fragment,e),Ve=n(e),N=p(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-qa2wbk"&&(N.innerHTML=Ts),qe=n(e),d(X.$$.fragment,e),Re=n(e),b=p(e,"H3",{class:!0});var rs=u(b);Z=p(rs,"A",{id:!0,class:!0,href:!0});var As=u(Z);we=p(As,"SPAN",{});var Ns=u(we);d(L.$$.fragment,Ns),Ns.forEach(s),As.forEach(s),ds=n(rs),ge=p(rs,"SPAN",{"data-svelte-h":!0}),r(ge)!=="svelte-1ra7458"&&(ge.textContent=$s),rs.forEach(s),Ee=n(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1c68157"&&(Q.innerHTML=xs),Se=n(e),d(Y.$$.fragment,e),Ae=n(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-p862so"&&(P.innerHTML=ks),Ne=n(e),d(F.$$.fragment,e),Xe=n(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-g4zh60"&&(D.innerHTML=Cs),Le=n(e),d(K.$$.fragment,e),Qe=n(e),J=p(e,"H2",{class:!0});var cs=u(J);I=p(cs,"A",{id:!0,class:!0,href:!0});var Xs=u(I);ve=p(Xs,"SPAN",{});var Ls=u(ve);d(O.$$.fragment,Ls),Ls.forEach(s),Xs.forEach(s),Ms=n(cs),fe=p(cs,"SPAN",{"data-svelte-h":!0}),r(fe)!=="svelte-o92j29"&&(fe.textContent=Zs),cs.forEach(s),Ye=n(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-cjx6rg"&&(ee.innerHTML=Is),Pe=n(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-riddeh"&&(se.textContent=Gs),Fe=n(e),d(le.$$.fragment,e),De=n(e),te=p(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-15pg5pf"&&(te.innerHTML=zs),Ke=n(e),d(ae.$$.fragment,e),Oe=n(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-15lqrn8"&&(ne.innerHTML=Bs),es=n(e),d(ie.$$.fragment,e),ss=n(e),T=p(e,"H2",{class:!0});var hs=u(T);G=p(hs,"A",{id:!0,class:!0,href:!0});var Qs=u(G);be=p(Qs,"SPAN",{});var Ys=u(be);d(pe.$$.fragment,Ys),Ys.forEach(s),Qs.forEach(s),gs=n(hs),ye=p(hs,"SPAN",{"data-svelte-h":!0}),r(ye)!=="svelte-gs2plx"&&(ye.textContent=Ws),hs.forEach(s),ls=n(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-gkha5e"&&(oe.innerHTML=Hs),ts=n(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-5pw8zv"&&(re.textContent=_s),as=n(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-1bks2jw"&&(ce.innerHTML=Vs),ns=n(e),d(he.$$.fragment,e),is=n(e),Je=p(e,"P",{}),u(Je).forEach(s),this.h()},h(){o(h,"name","hf:doc:metadata"),o(h,"content",JSON.stringify(al)),o($,"id","pipeline-per-linferenza"),o($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o($,"href","#pipeline-per-linferenza"),o(w,"class","relative group"),o(k,"id","utilizzo-della-pipeline"),o(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(k,"href","#utilizzo-della-pipeline"),o(v,"class","relative group"),o(C,"start","2"),o(Z,"id","scegliere-modello-e-tokenizer"),o(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(Z,"href","#scegliere-modello-e-tokenizer"),o(b,"class","relative group"),o(I,"id","audio-pipeline"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#audio-pipeline"),o(J,"class","relative group"),o(G,"id","vision-pipeline"),o(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(G,"href","#vision-pipeline"),o(T,"class","relative group")},m(e,l){c(document.head,h),t(e,z,l),t(e,j,l),t(e,ue,l),t(e,w,l),c(w,$),c($,je),M(B,je,null),c(w,ms),c(w,de),t(e,xe,l),t(e,W,l),t(e,ke,l),t(e,H,l),t(e,Ce,l),M(x,e,l),t(e,Ze,l),t(e,v,l),c(v,k),c(k,Ue),M(_,Ue,null),c(v,us),c(v,Me),t(e,Ie,l),t(e,V,l),t(e,Ge,l),t(e,q,l),t(e,ze,l),M(R,e,l),t(e,Be,l),t(e,C,l),t(e,We,l),M(E,e,l),t(e,He,l),t(e,S,l),t(e,_e,l),M(A,e,l),t(e,Ve,l),t(e,N,l),t(e,qe,l),M(X,e,l),t(e,Re,l),t(e,b,l),c(b,Z),c(Z,we),M(L,we,null),c(b,ds),c(b,ge),t(e,Ee,l),t(e,Q,l),t(e,Se,l),M(Y,e,l),t(e,Ae,l),t(e,P,l),t(e,Ne,l),M(F,e,l),t(e,Xe,l),t(e,D,l),t(e,Le,l),M(K,e,l),t(e,Qe,l),t(e,J,l),c(J,I),c(I,ve),M(O,ve,null),c(J,Ms),c(J,fe),t(e,Ye,l),t(e,ee,l),t(e,Pe,l),t(e,se,l),t(e,Fe,l),M(le,e,l),t(e,De,l),t(e,te,l),t(e,Ke,l),M(ae,e,l),t(e,Oe,l),t(e,ne,l),t(e,es,l),M(ie,e,l),t(e,ss,l),t(e,T,l),c(T,G),c(G,be),M(pe,be,null),c(T,gs),c(T,ye),t(e,ls,l),t(e,oe,l),t(e,ts,l),t(e,re,l),t(e,as,l),t(e,ce,l),t(e,ns,l),M(he,e,l),t(e,is,l),t(e,Je,l),ps=!0},p(e,[l]){const me={};l&2&&(me.$$scope={dirty:l,ctx:e}),x.$set(me)},i(e){ps||(g(B.$$.fragment,e),g(x.$$.fragment,e),g(_.$$.fragment,e),g(R.$$.fragment,e),g(E.$$.fragment,e),g(A.$$.fragment,e),g(X.$$.fragment,e),g(L.$$.fragment,e),g(Y.$$.fragment,e),g(F.$$.fragment,e),g(K.$$.fragment,e),g(O.$$.fragment,e),g(le.$$.fragment,e),g(ae.$$.fragment,e),g(ie.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),ps=!0)},o(e){f(B.$$.fragment,e),f(x.$$.fragment,e),f(_.$$.fragment,e),f(R.$$.fragment,e),f(E.$$.fragment,e),f(A.$$.fragment,e),f(X.$$.fragment,e),f(L.$$.fragment,e),f(Y.$$.fragment,e),f(F.$$.fragment,e),f(K.$$.fragment,e),f(O.$$.fragment,e),f(le.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),ps=!1},d(e){e&&(s(z),s(j),s(ue),s(w),s(xe),s(W),s(ke),s(H),s(Ce),s(Ze),s(v),s(Ie),s(V),s(Ge),s(q),s(ze),s(Be),s(C),s(We),s(He),s(S),s(_e),s(Ve),s(N),s(qe),s(Re),s(b),s(Ee),s(Q),s(Se),s(Ae),s(P),s(Ne),s(Xe),s(D),s(Le),s(Qe),s(J),s(Ye),s(ee),s(Pe),s(se),s(Fe),s(De),s(te),s(Ke),s(Oe),s(ne),s(es),s(ss),s(T),s(ls),s(oe),s(ts),s(re),s(as),s(ce),s(ns),s(is),s(Je)),s(h),y(B),y(x,e),y(_),y(R,e),y(E,e),y(A,e),y(X,e),y(L),y(Y,e),y(F,e),y(K,e),y(O),y(le,e),y(ae,e),y(ie,e),y(pe),y(he,e)}}}const al={local:"pipeline-per-linferenza",sections:[{local:"utilizzo-della-pipeline",sections:[{local:"scegliere-modello-e-tokenizer",title:"Scegliere modello e tokenizer"}],title:"Utilizzo della Pipeline"},{local:"audio-pipeline",title:"Audio pipeline"},{local:"vision-pipeline",title:"Vision pipeline"}],title:"Pipeline per l'inferenza"};function nl($e){return Fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hl extends Ks{constructor(h){super(),Os(this,h,nl,tl,Ps,{})}}export{hl as component};
