import{s as rt,f as fa,n as ot,o as ct}from"../chunks/scheduler.56730f09.js";import{S as ht,i as yt,g as e,s as p,u as ss,m as g,H as w,A as gt,h as l,f as a,c as i,j as c,v as as,y as o,n as d,B as f,k as r,o as m,a as n,w as ts,d as ns,t as es,x as ls}from"../chunks/index.ba464511.js";import{I as xa}from"../chunks/IconCopyLink.89bde88e.js";import{C as ba}from"../chunks/CodeBlock.2302fd0d.js";import{D as dt}from"../chunks/DocNotebookDropdown.68fd8653.js";function ut(Ja){let M,us,cs,Ms,U,x,hs,F,ga,ps,Va="고정 길이 모델의 펄플렉서티(Perplexity)",Us,j,Cs,B,Ta=`펄플렉서티(Perplexity, PPL)는 가장 일반적인 언어 모델 평가지표 중 하나입니다.
자세히 알아보기 전에 이 평가지표는 고전적인 언어 모델(자기회귀 또는 인과적 언어 모델이라고도 함)에만 적용되며 BERT와 같은 마스킹된 언어 모델에는 잘 적용하지 않습니다 (BERT는 <a href="../en/model_summary">summary of the models</a> 문서를 참고하세요).`,vs,u,da,ws,st='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi>x</mi><mn>0</mn></msub><mo separator="true">,</mo><msub><mi>x</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>x</mi><mi>t</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">X = (x_0, x_1, \\dots, x_t)</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">0</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',fs,xs,at='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex">X</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',bs,Js,is,Vs,tt='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext>PPL</mtext><mo stretchy="false">(</mo><mi>X</mi><mo stretchy="false">)</mo><mo>=</mo><mi>exp</mi><mo>⁡</mo><mrow><mo fence="true">{</mo><mrow><mo>−</mo><mfrac><mn>1</mn><mi>t</mi></mfrac><munderover><mo>∑</mo><mi>i</mi><mi>t</mi></munderover><mi>log</mi><mo>⁡</mo><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub><mo stretchy="false">)</mo></mrow><mo fence="true">}</mo></mrow></mrow><annotation encoding="application/x-tex">\\text{PPL}(X) = \\exp \\left\\{ {-\\frac{1}{t}\\sum_i^t \\log p_\\theta (x_i|x_{&lt;i}) } \\right\\}</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">PPL</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.0582em;vertical-align:-1.2777em;"></span><span class="mop">exp</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size4">{</span></span><span class="mord"><span class="mord">−</span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3214em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal">t</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.7806em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size4">}</span></span></span></span></span></span></span>',Ts,z,_s,nt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>log</mi><mo>⁡</mo><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>i</mi></mrow></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">\\log p_\\theta (x_i|x_{&lt;i})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Qs,ks,R,_a=`직관적으로 말뭉치에서 지정된 토큰 집합을 균일하게 예측하는 모델의 능력에 대한 평가로 생각할 수 있습니다.
중요한 점은 토큰화 과정이 모델의 펄플렉서티에 직접적인 영향을 미치므로 서로 다른 모델을 비교할 때 항상 이를 고려해야 합니다.`,Fs,N,Qa=`이는 데이터와 모델 예측 간의 cross-entropy 값에 지수를 취한 것과 동일합니다.
펄플렉서티와 문자당 비트 수(BPC) 및 데이터 압축과의 관계에 대해 더 직관적인 이해를 원하신다면 다음 글
<a href="https://thegradient.pub/understanding-evaluation-metrics-for-language-models/" rel="nofollow">fantastic blog post on The Gradient</a>을 확인하세요.`,js,C,b,ys,E,ua,ms,ka="고정 길이 모델의 펄플렉서티(PPL) 계산하기",Bs,S,Fa=`모델의 컨텍스트 크기가 정해져있지 않다면,
아래와 같이 시퀀스를 자동 회귀적으로 분해하고 각 단계에서 선행 하는 전체 시퀀스를 조건부 확률에 넣어 모델의 펄플렉서티를 계산할 것입니다.`,zs,J,ja,Rs,h,Ma,I,Ba="GPT-2",Ua,Ns,et='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>t</mi></mrow><annotation encoding="application/x-tex">t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6151em;"></span><span class="mord mathnormal">t</span></span></span></span>',Es,Ss,lt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>p</mi><mi>θ</mi></msub><mo stretchy="false">(</mo><msub><mi>x</mi><mi>t</mi></msub><mi mathvariant="normal">∣</mi><msub><mi>x</mi><mrow><mo>&lt;</mo><mi>t</mi></mrow></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">p_\\theta(x_t|x_{&lt;t})</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord"><span class="mord mathnormal">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord">∣</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">t</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Is,Ps,y,Ca,Gs,pt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi></mrow><annotation encoding="application/x-tex">k</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span></span></span></span>',Zs,$s,it='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>t</mi></msub></mrow><annotation encoding="application/x-tex">x_t</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.2806em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">t</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Ls,Hs,mt='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>k</mi><mo>−</mo><mn>1</mn></mrow><annotation encoding="application/x-tex">k-1</annotation></semantics></math></span><span class="katex-html hidden" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.0833em;"></span><span class="mord mathnormal" style="margin-right:0.03148em;">k</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1</span></span></span></span>',Xs,Ws,P,za=`모델의 시퀀스에 대한 펄플렉서티를 계산할 때,
수월하지만 차선책은 시퀀스를 청크로 쪼개고 분해된 각 부분의 로그 우도 값을 독립적으로 합산하는 것입니다.`,As,V,Ra,Os,G,Na=`이 방법은 각 부분의 펄플렉서티를 한 번의 포워드 패스로 계산할 수 있어 빠르지만 일반적으로 더 높은(더 나쁜) PPL을 산출합니다.
왜냐하면 대부분의 예측 단계에서 모델의 컨텍스트가 적기 때문입니다.`,qs,Z,Ea=`대신, 고정 길이 모델의 PPL은 슬라이딩 윈도우 전략으로 평가해야 합니다.
이 전략에는 컨텍스트 윈도우을 반복적으로 슬라이딩해 모델이 각 예측을 수행할 때 더 많은 컨텍스트를 갖도록 하는 작업이 포함됩니다.`,Ys,T,Sa,Ds,$,Ia=`이는 시퀀스 확률의 실제 분해에 더 가까운 근사치이며 일반적으로 더 유리한 점수를 산출합니다.
단점은 말뭉치의 각 토큰에 대해 별도의 포워드 패스가 필요하다는 것입니다.
현실적으로 좋은 절충안은 한 번에 한 토큰씩 슬라이딩하는 것이 아니라 더 큰 간격으로 컨텍스트를 이동하는 스트라이드가 적용된 슬라이딩 윈도우을 사용하는 것입니다.
이렇게 하면 계산을 훨씬 더 빠르게 진행하면서도 모델에 각 단계에서 예측을 수행할 수 있는 긴 컨텍스트를 제공할 수 있습니다.`,Ks,v,_,gs,L,va,rs,Pa="예제: 🤗 Transformers에서 GPT-2로 펄플렉서티(perplexity) 계산하기",sa,H,Ga="이제 GPT-2로 위의 과정을 시연해 보겠습니다.",aa,X,ta,W,Za=`WikiText-2 데이터 세트를 가져오고 몇 가지 슬라이딩 윈도우 전략을 사용해 펄플렉서티를 계산해보겠습니다.
이 데이터 세트는 크기가 작고 포워드 패스 한 번만 수행하기 때문에 전체 데이터 세트를 메모리에 가져오고 인코딩할 수 있습니다.`,na,A,ea,O,$a=`🤗 Transformers를 사용하면 모델의 <code>labels</code>로 <code>input_ids</code>를 전달해 각 토큰에 대한 평균 음의 우도 값을 손실로 반환할 수 있습니다.
하지만 슬라이딩 윈도우 방식을 사용하면 각 반복마다 모델에 전달하는 토큰이 겹칩니다.
컨텍스트로 처리하는 토큰에 대한 로그 우도 값이 손실에 포함되는 것을 원하지 않기 때문에 이러한 토큰의 <code>input_ids</code>를 <code>-100</code>으로 설정하여 무시할 수 있습니다.`,la,q,La=`다음은 스트라이드(stride)를 <code>512</code>로 사용한 예시입니다.
즉, 모델이 한 토큰의 조건부 우도 값을 계산할 때 컨텍스트에 최소한 512개의 토큰이 포함되어있다는 의미입니다 (해당 토큰 앞에 512개의 토큰이 있는 경우).`,pa,Y,ia,D,Ha=`스트라이드를 최대 입력 길이와 동일하게 설정하면 위에서 설명한 차선책인 비슬라이딩 윈도우 전략과 동일합니다.
일반적으로 스트라이드가 작을수록 모델이 각 예측을 할 때 더 많은 컨텍스트를 볼 수 있게 되어 펄플렉서티 값이 좋아집니다.`,ma,K,Xa=`위의 계산을 토큰이 겹치지 않도록 <code>stride = 1024</code>로 설정하면 PPL은 <code>19.44</code>로 GPT-2 논문에서 보고된 <code>19.93</code>과 거의 동일합니다.
<code>stride = 512</code>로 슬라이딩 윈도우 전략을 사용하면 PPL은 <code>16.45</code>로 떨어집니다.
이는 더 좋은 점수일 뿐만 아니라 시퀀스 확률의 실제 자동 회귀 분해에 더 가까운 방식으로 계산됩니다.`,ra,ds,oa;return F=new xa({}),j=new dt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/perplexity.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/perplexity.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/perplexity.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/perplexity.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/perplexity.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/perplexity.ipynb"}]}}),E=new xa({}),L=new xa({}),X=new ba({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdQVDJMTUhlYWRNb2RlbCUyQyUyMEdQVDJUb2tlbml6ZXJGYXN0JTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ3B0Mi1sYXJnZSUyMiUwQW1vZGVsJTIwJTNEJTIwR1BUMkxNSGVhZE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCkudG8oZGV2aWNlKSUwQXRva2VuaXplciUyMCUzRCUyMEdQVDJUb2tlbml6ZXJGYXN0LmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GPT2LMHeadModel, GPT2TokenizerFast

device = <span class="hljs-string">&quot;cuda&quot;</span>
model_id = <span class="hljs-string">&quot;gpt2-large&quot;</span>
model = GPT2LMHeadModel.from_pretrained(model_id).to(device)
tokenizer = GPT2TokenizerFast.from_pretrained(model_id)`,wrap:!1}}),A=new ba({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBdGVzdCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ3aWtpdGV4dCUyMiUyQyUyMCUyMndpa2l0ZXh0LTItcmF3LXYxJTIyJTJDJTIwc3BsaXQlM0QlMjJ0ZXN0JTIyKSUwQWVuY29kaW5ncyUyMCUzRCUyMHRva2VuaXplciglMjIlNUNuJTVDbiUyMi5qb2luKHRlc3QlNUIlMjJ0ZXh0JTIyJTVEKSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

test = load_dataset(<span class="hljs-string">&quot;wikitext&quot;</span>, <span class="hljs-string">&quot;wikitext-2-raw-v1&quot;</span>, split=<span class="hljs-string">&quot;test&quot;</span>)
encodings = tokenizer(<span class="hljs-string">&quot;\\n\\n&quot;</span>.join(test[<span class="hljs-string">&quot;text&quot;</span>]), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),Y=new ba({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

max_length = model.config.n_positions
stride = <span class="hljs-number">512</span>
seq_len = encodings.input_ids.size(<span class="hljs-number">1</span>)

nlls = []
prev_end_loc = <span class="hljs-number">0</span>
<span class="hljs-keyword">for</span> begin_loc <span class="hljs-keyword">in</span> tqdm(<span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, seq_len, stride)):
    end_loc = <span class="hljs-built_in">min</span>(begin_loc + max_length, seq_len)
    trg_len = end_loc - prev_end_loc  <span class="hljs-comment"># 마지막 루프의 스트라이드 값과 다를 수 있음</span>
    input_ids = encodings.input_ids[:, begin_loc:end_loc].to(device)
    target_ids = input_ids.clone()
    target_ids[:, :-trg_len] = -<span class="hljs-number">100</span>

    <span class="hljs-keyword">with</span> torch.no_grad():
        outputs = model(input_ids, labels=target_ids)

        <span class="hljs-comment"># 손실은 모든 유효한 레이블에 대한 평균값을 구하는 교차 엔트로피(cross entropy)로 계산됩니다.</span>
        <span class="hljs-comment"># 나이브 베이지안 모델은 내부적으로 레이블을 왼쪽으로 1개씩 밀기 때문에, (타켓 - 1)개 만큼의 레이블에 대해 손실을 계산합니다.</span>
        neg_log_likelihood = outputs.loss

    nlls.append(neg_log_likelihood)

    prev_end_loc = end_loc
    <span class="hljs-keyword">if</span> end_loc == seq_len:
        <span class="hljs-keyword">break</span>

ppl = torch.exp(torch.stack(nlls).mean())`,wrap:!1}}),{c(){M=e("meta"),us=p(),cs=e("p"),Ms=p(),U=e("h1"),x=e("a"),hs=e("span"),ss(F.$$.fragment),ga=p(),ps=e("span"),ps.textContent=Va,Us=p(),ss(j.$$.fragment),Cs=p(),B=e("p"),B.innerHTML=Ta,vs=p(),u=e("p"),da=g(`펄플렉서티는 시퀀스의 음의 로그 우도(negative log-likelihood, NLL) 값의 평균에 지수(exponentiate)를 취한 값으로 정의됩니다.
토큰화된 시퀀스 `),ws=new w(!1),fs=g(" 가 있을 때, "),xs=new w(!1),bs=g(" 의 펄플렉서티는 아래 수식과 같이 구할 수 있습니다."),Js=p(),is=e("p"),Vs=new w(!1),Ts=p(),z=e("p"),_s=new w(!1),Qs=g(" 는 모델에 i번째 이전까지 토큰이 주어졌을 때 i번째 토큰의 로그 우도값입니다."),ks=p(),R=e("p"),R.textContent=_a,Fs=p(),N=e("p"),N.innerHTML=Qa,js=p(),C=e("h2"),b=e("a"),ys=e("span"),ss(E.$$.fragment),ua=p(),ms=e("span"),ms.textContent=ka,Bs=p(),S=e("p"),S.textContent=Fa,zs=p(),J=e("img"),Rs=p(),h=e("p"),Ma=g(`그러나 모델의 근사치를 구할 때는 일반적으로 모델이 처리할 수 있는 토큰 수에 제한이 있습니다.
예를 들어, 가장 큰 버전의 `),I=e("a"),I.textContent=Ba,Ua=g(`는 토큰의 길이가 1024로 고정되어 있습니다.
따라서 `),Ns=new w(!1),Es=g(" 가 1024보다 큰 경우에 "),Ss=new w(!1),Is=g(" 을 계산할 수 없습니다."),Ps=p(),y=e("p"),Ca=g(`대신 시퀀스는 일반적으로 모델의 최대 입력 크기와 동일한 길이는 가지는 부분 시퀀스로 쪼갭니다.
만약 모델의 최대 입력 길이가 `),Gs=new w(!1),Zs=g(` 라면,
토큰 `),$s=new w(!1),Ls=g(" 의 우도 값을 계산할 때 이전 토큰을 모두 사용하지 않고, "),Hs=new w(!1),Xs=g(" 토큰까지 사용해 대략적인 우도 값을 추정합니다."),Ws=p(),P=e("p"),P.textContent=za,As=p(),V=e("img"),Os=p(),G=e("p"),G.textContent=Na,qs=p(),Z=e("p"),Z.textContent=Ea,Ys=p(),T=e("img"),Ds=p(),$=e("p"),$.textContent=Ia,Ks=p(),v=e("h2"),_=e("a"),gs=e("span"),ss(L.$$.fragment),va=p(),rs=e("span"),rs.textContent=Pa,sa=p(),H=e("p"),H.textContent=Ga,aa=p(),ss(X.$$.fragment),ta=p(),W=e("p"),W.textContent=Za,na=p(),ss(A.$$.fragment),ea=p(),O=e("p"),O.innerHTML=$a,la=p(),q=e("p"),q.innerHTML=La,pa=p(),ss(Y.$$.fragment),ia=p(),D=e("p"),D.textContent=Ha,ma=p(),K=e("p"),K.innerHTML=Xa,ra=p(),ds=e("p"),this.h()},l(s){const t=gt("svelte-1phssyn",document.head);M=l(t,"META",{name:!0,content:!0}),t.forEach(a),us=i(s),cs=l(s,"P",{}),c(cs).forEach(a),Ms=i(s),U=l(s,"H1",{class:!0});var ca=c(U);x=l(ca,"A",{id:!0,class:!0,href:!0});var Wa=c(x);hs=l(Wa,"SPAN",{});var Aa=c(hs);as(F.$$.fragment,Aa),Aa.forEach(a),Wa.forEach(a),ga=i(ca),ps=l(ca,"SPAN",{"data-svelte-h":!0}),o(ps)!=="svelte-1ayenvs"&&(ps.textContent=Va),ca.forEach(a),Us=i(s),as(j.$$.fragment,s),Cs=i(s),B=l(s,"P",{"data-svelte-h":!0}),o(B)!=="svelte-11w5q0v"&&(B.innerHTML=Ta),vs=i(s),u=l(s,"P",{});var os=c(u);da=d(os,`펄플렉서티는 시퀀스의 음의 로그 우도(negative log-likelihood, NLL) 값의 평균에 지수(exponentiate)를 취한 값으로 정의됩니다.
토큰화된 시퀀스 `),ws=f(os,!1),fs=d(os," 가 있을 때, "),xs=f(os,!1),bs=d(os," 의 펄플렉서티는 아래 수식과 같이 구할 수 있습니다."),os.forEach(a),Js=i(s),is=l(s,"P",{});var Oa=c(is);Vs=f(Oa,!1),Oa.forEach(a),Ts=i(s),z=l(s,"P",{});var wa=c(z);_s=f(wa,!1),Qs=d(wa," 는 모델에 i번째 이전까지 토큰이 주어졌을 때 i번째 토큰의 로그 우도값입니다."),wa.forEach(a),ks=i(s),R=l(s,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1b4v3xq"&&(R.textContent=_a),Fs=i(s),N=l(s,"P",{"data-svelte-h":!0}),o(N)!=="svelte-33m9h2"&&(N.innerHTML=Qa),js=i(s),C=l(s,"H2",{class:!0});var ha=c(C);b=l(ha,"A",{id:!0,class:!0,href:!0});var qa=c(b);ys=l(qa,"SPAN",{});var Ya=c(ys);as(E.$$.fragment,Ya),Ya.forEach(a),qa.forEach(a),ua=i(ha),ms=l(ha,"SPAN",{"data-svelte-h":!0}),o(ms)!=="svelte-1dsq0ow"&&(ms.textContent=ka),ha.forEach(a),Bs=i(s),S=l(s,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1sg414w"&&(S.textContent=Fa),zs=i(s),J=l(s,"IMG",{width:!0,alt:!0,src:!0}),Rs=i(s),h=l(s,"P",{});var Q=c(h);Ma=d(Q,`그러나 모델의 근사치를 구할 때는 일반적으로 모델이 처리할 수 있는 토큰 수에 제한이 있습니다.
예를 들어, 가장 큰 버전의 `),I=l(Q,"A",{href:!0,"data-svelte-h":!0}),o(I)!=="svelte-1kdeo4m"&&(I.textContent=Ba),Ua=d(Q,`는 토큰의 길이가 1024로 고정되어 있습니다.
따라서 `),Ns=f(Q,!1),Es=d(Q," 가 1024보다 큰 경우에 "),Ss=f(Q,!1),Is=d(Q," 을 계산할 수 없습니다."),Q.forEach(a),Ps=i(s),y=l(s,"P",{});var k=c(y);Ca=d(k,`대신 시퀀스는 일반적으로 모델의 최대 입력 크기와 동일한 길이는 가지는 부분 시퀀스로 쪼갭니다.
만약 모델의 최대 입력 길이가 `),Gs=f(k,!1),Zs=d(k,` 라면,
토큰 `),$s=f(k,!1),Ls=d(k," 의 우도 값을 계산할 때 이전 토큰을 모두 사용하지 않고, "),Hs=f(k,!1),Xs=d(k," 토큰까지 사용해 대략적인 우도 값을 추정합니다."),k.forEach(a),Ws=i(s),P=l(s,"P",{"data-svelte-h":!0}),o(P)!=="svelte-p30g18"&&(P.textContent=za),As=i(s),V=l(s,"IMG",{width:!0,alt:!0,src:!0}),Os=i(s),G=l(s,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1b7o98p"&&(G.textContent=Na),qs=i(s),Z=l(s,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-10v5nla"&&(Z.textContent=Ea),Ys=i(s),T=l(s,"IMG",{width:!0,alt:!0,src:!0}),Ds=i(s),$=l(s,"P",{"data-svelte-h":!0}),o($)!=="svelte-1bx3afe"&&($.textContent=Ia),Ks=i(s),v=l(s,"H2",{class:!0});var ya=c(v);_=l(ya,"A",{id:!0,class:!0,href:!0});var Da=c(_);gs=l(Da,"SPAN",{});var Ka=c(gs);as(L.$$.fragment,Ka),Ka.forEach(a),Da.forEach(a),va=i(ya),rs=l(ya,"SPAN",{"data-svelte-h":!0}),o(rs)!=="svelte-1cpotnw"&&(rs.textContent=Pa),ya.forEach(a),sa=i(s),H=l(s,"P",{"data-svelte-h":!0}),o(H)!=="svelte-1scr742"&&(H.textContent=Ga),aa=i(s),as(X.$$.fragment,s),ta=i(s),W=l(s,"P",{"data-svelte-h":!0}),o(W)!=="svelte-g326s0"&&(W.textContent=Za),na=i(s),as(A.$$.fragment,s),ea=i(s),O=l(s,"P",{"data-svelte-h":!0}),o(O)!=="svelte-aa9p9w"&&(O.innerHTML=$a),la=i(s),q=l(s,"P",{"data-svelte-h":!0}),o(q)!=="svelte-bou0a7"&&(q.innerHTML=La),pa=i(s),as(Y.$$.fragment,s),ia=i(s),D=l(s,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1ro3gyl"&&(D.textContent=Ha),ma=i(s),K=l(s,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1cfqojp"&&(K.innerHTML=Xa),ra=i(s),ds=l(s,"P",{}),c(ds).forEach(a),this.h()},h(){r(M,"name","hf:doc:metadata"),r(M,"content",JSON.stringify(Mt)),r(x,"id","perplexity-of-fixedlength-models"),r(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(x,"href","#perplexity-of-fixedlength-models"),r(U,"class","relative group"),ws.a=fs,xs.a=bs,Vs.a=null,_s.a=Qs,r(b,"id","calculating-ppl-with-fixedlength-models"),r(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(b,"href","#calculating-ppl-with-fixedlength-models"),r(C,"class","relative group"),r(J,"width","600"),r(J,"alt","Full decomposition of a sequence with unlimited context length"),fa(J.src,ja="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_full.gif")||r(J,"src",ja),r(I,"href","model_doc/gpt2"),Ns.a=Es,Ss.a=Is,Gs.a=Zs,$s.a=Ls,Hs.a=Xs,r(V,"width","600"),r(V,"alt","Suboptimal PPL not taking advantage of full available context"),fa(V.src,Ra="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_chunked.gif")||r(V,"src",Ra),r(T,"width","600"),r(T,"alt","Sliding window PPL taking advantage of all available context"),fa(T.src,Sa="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/ppl_sliding.gif")||r(T,"src",Sa),r(_,"id","example-calculating-perplexity-with-gpt2-in-transformers"),r(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(_,"href","#example-calculating-perplexity-with-gpt2-in-transformers"),r(v,"class","relative group")},m(s,t){m(document.head,M),n(s,us,t),n(s,cs,t),n(s,Ms,t),n(s,U,t),m(U,x),m(x,hs),ts(F,hs,null),m(U,ga),m(U,ps),n(s,Us,t),ts(j,s,t),n(s,Cs,t),n(s,B,t),n(s,vs,t),n(s,u,t),m(u,da),ws.m(st,u),m(u,fs),xs.m(at,u),m(u,bs),n(s,Js,t),n(s,is,t),Vs.m(tt,is),n(s,Ts,t),n(s,z,t),_s.m(nt,z),m(z,Qs),n(s,ks,t),n(s,R,t),n(s,Fs,t),n(s,N,t),n(s,js,t),n(s,C,t),m(C,b),m(b,ys),ts(E,ys,null),m(C,ua),m(C,ms),n(s,Bs,t),n(s,S,t),n(s,zs,t),n(s,J,t),n(s,Rs,t),n(s,h,t),m(h,Ma),m(h,I),m(h,Ua),Ns.m(et,h),m(h,Es),Ss.m(lt,h),m(h,Is),n(s,Ps,t),n(s,y,t),m(y,Ca),Gs.m(pt,y),m(y,Zs),$s.m(it,y),m(y,Ls),Hs.m(mt,y),m(y,Xs),n(s,Ws,t),n(s,P,t),n(s,As,t),n(s,V,t),n(s,Os,t),n(s,G,t),n(s,qs,t),n(s,Z,t),n(s,Ys,t),n(s,T,t),n(s,Ds,t),n(s,$,t),n(s,Ks,t),n(s,v,t),m(v,_),m(_,gs),ts(L,gs,null),m(v,va),m(v,rs),n(s,sa,t),n(s,H,t),n(s,aa,t),ts(X,s,t),n(s,ta,t),n(s,W,t),n(s,na,t),ts(A,s,t),n(s,ea,t),n(s,O,t),n(s,la,t),n(s,q,t),n(s,pa,t),ts(Y,s,t),n(s,ia,t),n(s,D,t),n(s,ma,t),n(s,K,t),n(s,ra,t),n(s,ds,t),oa=!0},p:ot,i(s){oa||(ns(F.$$.fragment,s),ns(j.$$.fragment,s),ns(E.$$.fragment,s),ns(L.$$.fragment,s),ns(X.$$.fragment,s),ns(A.$$.fragment,s),ns(Y.$$.fragment,s),oa=!0)},o(s){es(F.$$.fragment,s),es(j.$$.fragment,s),es(E.$$.fragment,s),es(L.$$.fragment,s),es(X.$$.fragment,s),es(A.$$.fragment,s),es(Y.$$.fragment,s),oa=!1},d(s){s&&(a(us),a(cs),a(Ms),a(U),a(Us),a(Cs),a(B),a(vs),a(u),a(Js),a(is),a(Ts),a(z),a(ks),a(R),a(Fs),a(N),a(js),a(C),a(Bs),a(S),a(zs),a(J),a(Rs),a(h),a(Ps),a(y),a(Ws),a(P),a(As),a(V),a(Os),a(G),a(qs),a(Z),a(Ys),a(T),a(Ds),a($),a(Ks),a(v),a(sa),a(H),a(aa),a(ta),a(W),a(na),a(ea),a(O),a(la),a(q),a(pa),a(ia),a(D),a(ma),a(K),a(ra),a(ds)),a(M),ls(F),ls(j,s),ls(E),ls(L),ls(X,s),ls(A,s),ls(Y,s)}}}const Mt={local:"perplexity-of-fixedlength-models",sections:[{local:"calculating-ppl-with-fixedlength-models",title:"고정 길이 모델의 펄플렉서티(PPL) 계산하기"},{local:"example-calculating-perplexity-with-gpt2-in-transformers",title:"예제: 🤗 Transformers에서 GPT-2로 펄플렉서티(perplexity) 계산하기"}],title:"고정 길이 모델의 펄플렉서티(Perplexity)"};function Ut(Ja){return ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class bt extends ht{constructor(M){super(),yt(this,M,Ut,ut,rt,{})}}export{bt as component};
