import{s as Ca,n as $a,o as _a}from"../chunks/scheduler.56730f09.js";import{S as Za,i as Va,g as p,s as a,u as o,A as ka,h as i,f as l,c as n,j as y,v as c,y as r,k as h,o as M,a as e,w as m,d as g,t as d,x as u}from"../chunks/index.ba464511.js";import{I as pt}from"../chunks/IconCopyLink.89bde88e.js";import{C as j}from"../chunks/CodeBlock.2302fd0d.js";import{D as Ga}from"../chunks/DocNotebookDropdown.68fd8653.js";function Wa(me){let b,Tt,dt,xt,f,C,ut,X,ne,it,ge="시각적 질의응답 (Visual Question Answering)",vt,Q,Ut,R,de="시각적 질의응답(VQA)은 이미지를 기반으로 개방형 질문에 대응하는 작업입니다. 이 작업을 지원하는 모델의 입력은 대부분 이미지와 질문의 조합이며, 출력은 자연어로 된 답변입니다.",Ct,H,ue="VQA의 주요 사용 사례는 다음과 같습니다:",$t,N,Me="<li>시각 장애인을 위한 접근성 애플리케이션을 구축할 수 있습니다.</li> <li>교육: 강의나 교과서에 나온 시각 자료에 대한 질문에 답할 수 있습니다. 또한 체험형 전시와 유적 등에서도 VQA를 활용할 수 있습니다.</li> <li>고객 서비스 및 전자상거래: VQA는 사용자가 제품에 대해 질문할 수 있게 함으로써 사용자 경험을 향상시킬 수 있습니다.</li> <li>이미지 검색: VQA 모델을 사용하여 원하는 특성을 가진 이미지를 검색할 수 있습니다. 예를 들어 사용자는 “강아지가 있어?”라고 물어봐서 주어진 이미지 묶음에서 강아지가 있는 모든 이미지를 받아볼 수 있습니다.</li>",_t,E,je="이 가이드에서 학습할 내용은 다음과 같습니다:",Zt,F,ye='<li>VQA 모델 중 하나인 <a href="../../en/model_doc/vilt">ViLT</a>를 <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> 데이터셋</a> 에서 미세조정하는 방법</li> <li>미세조정된 ViLT 모델로 추론하는 방법</li> <li>BLIP-2 같은 생성 모델로 제로샷 VQA 추론을 실행하는 방법</li>',Vt,w,$,Mt,A,pe,rt,be="ViLT 미세 조정",kt,z,fe=`ViLT는 Vision Transformer (ViT) 내에 텍스트 임베딩을 포함하여 비전/자연어 사전훈련(VLP; Vision-and-Language Pretraining)을 위한 기본 디자인을 제공합니다.
ViLT 모델은 비전 트랜스포머(ViT)에 텍스트 임베딩을 넣어 비전/언어 사전훈련(VLP; Vision-and-Language Pre-training)을 위한 기본적인 디자인을 갖췄습니다. 이 모델은 여러 다운스트림 작업에 사용할 수 있습니다. VQA 태스크에서는 (<code>[CLS]</code> 토큰의 최종 은닉 상태 위에 선형 레이어인) 분류 헤더가 있으며 무작위로 초기화됩니다.
따라서 여기에서 시각적 질의응답은 <strong>분류 문제</strong>로 취급됩니다.`,Gt,Y,we="최근의 BLIP, BLIP-2, InstructBLIP와 같은 모델들은 VQA를 생성형 작업으로 간주합니다. 가이드의 후반부에서는 이런 모델들을 사용하여 제로샷 VQA 추론을 하는 방법에 대해 설명하겠습니다.",Wt,q,Je="시작하기 전 필요한 모든 라이브러리를 설치했는지 확인하세요.",It,L,Bt,S,Te=`커뮤니티에 모델을 공유하는 것을 권장 드립니다. Hugging Face 계정에 로그인하여 🤗 Hub에 업로드할 수 있습니다.
메시지가 나타나면 로그인할 토큰을 입력하세요:`,Xt,P,Qt,D,xe="모델 체크포인트를 전역 변수로 선언하세요.",Rt,K,Ht,J,_,jt,O,ie,ot,ve="데이터 가져오기",Nt,ss,Ue='이 가이드에서는 <code>Graphcore/vqa</code> 데이터세트의 작은 샘플을 사용합니다. 전체 데이터세트는 <a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow">🤗 Hub</a> 에서 확인할 수 있습니다.',Et,ts,Ce=`<a href="https://huggingface.co/datasets/Graphcore/vqa" rel="nofollow"><code>Graphcore/vqa</code> 데이터세트</a> 의 대안으로 공식 <a href="https://visualqa.org/download.html" rel="nofollow">VQA 데이터세트 페이지</a> 에서 동일한 데이터를 수동으로 다운로드할 수 있습니다. 직접 공수한 데이터로 튜토리얼을 따르고 싶다면 <a href="https://huggingface.co/docs/datasets/image_dataset#loading-script" rel="nofollow">이미지 데이터세트 만들기</a> 라는
🤗 Datasets 문서를 참조하세요.`,Ft,ls,$e="검증 데이터의 첫 200개 항목을 불러와 데이터세트의 특성을 확인해 보겠습니다:",At,es,zt,as,_e="예제를 하나 뽑아 데이터세트의 특성을 이해해 보겠습니다.",Yt,ns,qt,ps,Ze="데이터세트에는 다음과 같은 특성이 포함되어 있습니다:",Lt,is,Ve="<li><code>question</code>: 이미지에 대한 질문</li> <li><code>image_id</code>: 질문과 관련된 이미지의 경로</li> <li><code>label</code>: 데이터의 레이블 (annotations)</li>",St,rs,ke="나머지 특성들은 필요하지 않기 때문에 삭제해도 됩니다:",Pt,os,Dt,cs,Ge="보시다시피 <code>label</code> 특성은 같은 질문마다 답변이 여러 개 있을 수 있습니다. 모두 다른 데이터 라벨러들로부터 수집되었기 때문인데요. 질문의 답변은 주관적일 수 있습니다. 이 경우 질문은 “그는 어디를 보고 있나요?” 였지만, 어떤 사람들은 “아래”로 레이블을 달았고, 다른 사람들은 “테이블” 또는 “스케이트보드” 등으로 주석을 달았습니다.",Kt,hs,We="아래의 이미지를 보고 어떤 답변을 선택할 것인지 생각해 보세요:",Ot,ms,sl,Z,Ie='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/vqa-example.png" alt="VQA Image Example"/>',tl,gs,Be="질문과 답변의 모호성으로 인해 이러한 데이터세트는 여러 개의 답변이 가능하므로 다중 레이블 분류 문제로 처리됩니다. 게다가, 원핫(one-hot) 인코딩 벡터를 생성하기보다는 레이블에서 특정 답변이 나타나는 횟수를 기반으로 소프트 인코딩을 생성합니다.",ll,ds,Xe="위의 예시에서 “아래”라는 답변이 다른 답변보다 훨씬 더 자주 선택되었기 때문에 데이터세트에서 <code>weight</code>라고 불리는 점수로 1.0을 가지며, 나머지 답변들은 1.0 미만의 점수를 가집니다.",el,us,Qe="적절한 분류 헤더로 모델을 나중에 인스턴스화하기 위해 레이블을 정수로 매핑한 딕셔너리 하나, 반대로 정수를 레이블로 매핑한 딕셔너리 하나 총 2개의 딕셔너리를 생성하세요:",al,Ms,nl,js,Re="이제 매핑이 완료되었으므로 문자열 답변을 해당 id로 교체하고, 데이터세트의 더 편리한 후처리를 위해 편평화 할 수 있습니다.",pl,ys,il,T,V,yt,bs,re,ct,He="데이터 전처리",rl,fs,Ne=`다음 단계는 모델을 위해 이미지와 텍스트 데이터를 준비하기 위해 ViLT 프로세서를 가져오는 것입니다.
<code>ViltProcessor</code>는 BERT 토크나이저와 ViLT 이미지 프로세서를 편리하게 하나의 프로세서로 묶습니다:`,ol,ws,cl,Js,Ee=`데이터를 전처리하려면 이미지와 질문을 <code>ViltProcessor</code>로 인코딩해야 합니다. 프로세서는 <code>BertTokenizerFast</code>로 텍스트를 토크나이즈하고 텍스트 데이터를 위해 <code>input_ids</code>, <code>attention_mask</code> 및 <code>token_type_ids</code>를 생성합니다.
이미지는 <code>ViltImageProcessor</code>로 이미지를 크기 조정하고 정규화하며, <code>pixel_values</code>와 <code>pixel_mask</code>를 생성합니다.`,hl,Ts,Fe="이런 전처리 단계는 모두 내부에서 이루어지므로, <code>processor</code>를 호출하기만 하면 됩니다. 하지만 아직 타겟 레이블이 완성되지 않았습니다. 타겟의 표현에서 각 요소는 가능한 답변(레이블)에 해당합니다. 정확한 답변의 요소는 해당 점수(weight)를 유지시키고 나머지 요소는 0으로 설정해야 합니다.",ml,xs,Ae="아래 함수가 위에서 설명한대로 이미지와 질문에 <code>processor</code>를 적용하고 레이블을 형식에 맞춥니다:",gl,vs,dl,Us,ze="전체 데이터세트에 전처리 함수를 적용하려면 🤗 Datasets의 <code>map</code> 함수를 사용하십시오. <code>batched=True</code>를 설정하여 데이터세트의 여러 요소를 한 번에 처리함으로써 <code>map</code>을 더 빠르게 할 수 있습니다. 이 시점에서 필요하지 않은 열은 제거하세요.",ul,Cs,Ml,$s,Ye="마지막 단계로, <code>DefaultDataCollator</code>를 사용하여 예제로 쓸 배치를 생성하세요:",jl,_s,yl,x,k,bt,Zs,oe,ht,qe="모델 훈련",bl,Vs,Le="이제 모델을 훈련하기 위해 준비되었습니다! <code>ViltForQuestionAnswering</code>으로 ViLT를 가져올 차례입니다. 레이블의 수와 레이블 매핑을 지정하세요:",fl,ks,wl,Gs,Se="이 시점에서는 다음 세 단계만 남았습니다:",Jl,Ws,Pe="<li><code>TrainingArguments</code>에서 훈련 하이퍼파라미터를 정의하세요:</li>",Tl,Is,xl,G,De="<li>모델, 데이터세트, 프로세서, 데이터 콜레이터와 함께 훈련 인수를 <code>Trainer</code>에 전달하세요:</li>",vl,Bs,Ul,W,Ke="<li><code>train()</code>을 호출하여 모델을 미세 조정하세요:</li>",Cl,Xs,$l,Qs,Oe="훈련이 완료되면, <code>push_to_hub()</code> 메소드를 사용하여 🤗 Hub에 모델을 공유하세요:",_l,Rs,Zl,v,I,ft,Hs,ce,mt,sa="추론",Vl,Ns,ta="ViLT 모델을 미세 조정하고 🤗 Hub에 업로드했다면 추론에 사용할 수 있습니다. 미세 조정된 모델을 추론에 사용해보는 가장 간단한 방법은 <code>Pipeline</code>에서 사용하는 것입니다.",kl,Es,Gl,Fs,la="이 가이드의 모델은 200개의 예제에서만 훈련되었으므로 그다지 많은 것을 기대할 수는 없습니다. 데이터세트의 첫 번째 예제를 사용하여 추론 결과를 설명해보겠습니다:",Wl,As,Il,zs,ea="비록 확신은 별로 없지만, 모델은 실제로 무언가를 배웠습니다. 더 많은 예제와 더 긴 훈련 기간이 주어진다면 분명 더 나은 결과를 얻을 수 있을 것입니다!",Bl,Ys,aa="원한다면 파이프라인의 결과를 수동으로 복제할 수도 있습니다:",Xl,qs,na="<li>이미지와 질문을 가져와서 프로세서를 사용하여 모델에 준비합니다.</li> <li>전처리된 결과를 모델에 전달합니다.</li> <li>로짓에서 가장 가능성 있는 답변의 id를 가져와서 <code>id2label</code>에서 실제 답변을 찾습니다.</li>",Ql,Ls,Rl,U,B,wt,Ss,he,gt,pa="제로샷 VQA",Hl,Ps,ia=`이전 모델은 VQA를 분류 문제로 처리했습니다. BLIP, BLIP-2 및 InstructBLIP와 같은 최근의 모델은 VQA를 생성 작업으로 접근합니다. <a href="../../en/model_doc/blip-2">BLIP-2</a>를 예로 들어 보겠습니다. 이 모델은 사전훈련된 비전 인코더와 LLM의 모든 조합을 사용할 수 있는 새로운 비전-자연어 사전 학습 패러다임을 도입했습니다. (<a href="https://huggingface.co/blog/blip-2" rel="nofollow">BLIP-2 블로그 포스트</a>를 통해 더 자세히 알아볼 수 있어요)
이를 통해 시각적 질의응답을 포함한 여러 비전-자연어 작업에서 SOTA를 달성할 수 있었습니다.`,Nl,Ds,ra="이 모델을 어떻게 VQA에 사용할 수 있는지 설명해 보겠습니다. 먼저 모델을 가져와 보겠습니다. 여기서 GPU가 사용 가능한 경우 모델을 명시적으로 GPU로 전송할 것입니다. 이전에는 훈련할 때 쓰지 않은 이유는 <code>Trainer</code>가 이 부분을 자동으로 처리하기 때문입니다:",El,Ks,Fl,Os,oa="모델은 이미지와 텍스트를 입력으로 받으므로, VQA 데이터세트의 첫 번째 예제에서와 동일한 이미지/질문 쌍을 사용해 보겠습니다:",Al,st,zl,tt,ca="BLIP-2를 시각적 질의응답 작업에 사용하려면 텍스트 프롬프트가 <code>Question: {} Answer:</code> 형식을 따라야 합니다.",Yl,lt,ql,et,ha="이제 모델의 프로세서로 이미지/프롬프트를 전처리하고, 처리된 입력을 모델을 통해 전달하고, 출력을 디코드해야 합니다:",Ll,at,Sl,nt,ma="보시다시피 모델은 군중을 인식하고, 얼굴의 방향(아래쪽을 보고 있음)을 인식했지만, 군중이 스케이터 뒤에 있다는 사실을 놓쳤습니다. 그러나 사람이 직접 라벨링한 데이터셋을 얻을 수 없는 경우에, 이 접근법은 빠르게 유용한 결과를 생성할 수 있습니다.",Pl,Jt,Dl;return X=new pt({}),Q=new Ga({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/visual_question_answering.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/visual_question_answering.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/visual_question_answering.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/visual_question_answering.ipynb"}]}}),A=new pt({}),L=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1xJTIwdHJhbnNmb3JtZXJzJTIwZGF0YXNldHM=",highlighted:"pip install -q transformers datasets",wrap:!1}}),P=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),K=new j({props:{code:"bW9kZWxfY2hlY2twb2ludCUyMCUzRCUyMCUyMmRhbmRlbGluJTJGdmlsdC1iMzItbWxtJTIy",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model_checkpoint = <span class="hljs-string">&quot;dandelin/vilt-b32-mlm&quot;</span>',wrap:!1}}),O=new pt({}),es=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJHcmFwaGNvcmUlMkZ2cWElMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lNUIlM0EyMDAlNUQlMjIpJTBBZGF0YXNldA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;Graphcore/vqa&quot;</span>, split=<span class="hljs-string">&quot;validation[:200]&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset
Dataset({
    features: [<span class="hljs-string">&#x27;question&#x27;</span>, <span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),ns=new j({props:{code:"ZGF0YXNldCU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">0</span>]
{<span class="hljs-string">&#x27;question&#x27;</span>: <span class="hljs-string">&#x27;Where is he looking?&#x27;</span>,
 <span class="hljs-string">&#x27;question_type&#x27;</span>: <span class="hljs-string">&#x27;none of the above&#x27;</span>,
 <span class="hljs-string">&#x27;question_id&#x27;</span>: <span class="hljs-number">262148000</span>,
 <span class="hljs-string">&#x27;image_id&#x27;</span>: <span class="hljs-string">&#x27;/root/.cache/huggingface/datasets/downloads/extracted/ca733e0e000fb2d7a09fbcc94dbfe7b5a30750681d0e965f8e0a23b1c2f98c75/val2014/COCO_val2014_000000262148.jpg&#x27;</span>,
 <span class="hljs-string">&#x27;answer_type&#x27;</span>: <span class="hljs-string">&#x27;other&#x27;</span>,
 <span class="hljs-string">&#x27;label&#x27;</span>: {<span class="hljs-string">&#x27;ids&#x27;</span>: [<span class="hljs-string">&#x27;at table&#x27;</span>, <span class="hljs-string">&#x27;down&#x27;</span>, <span class="hljs-string">&#x27;skateboard&#x27;</span>, <span class="hljs-string">&#x27;table&#x27;</span>],
  <span class="hljs-string">&#x27;weights&#x27;</span>: [<span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">1.0</span>,
   <span class="hljs-number">0.30000001192092896</span>,
   <span class="hljs-number">0.30000001192092896</span>]}}`,wrap:!1}}),os=new j({props:{code:"ZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQucmVtb3ZlX2NvbHVtbnMoJTVCJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdhbnN3ZXJfdHlwZSclNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.remove_columns([<span class="hljs-string">&#x27;question_type&#x27;</span>, <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>])',wrap:!1}}),ms=new j({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGRhdGFzZXQlNUIwJTVEJTVCJ2ltYWdlX2lkJyU1RCklMEFpbWFnZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>image`,wrap:!1}}),Ms=new j({props:{code:"aW1wb3J0JTIwaXRlcnRvb2xzJTBBJTBBbGFiZWxzJTIwJTNEJTIwJTVCaXRlbSU1QidpZHMnJTVEJTIwZm9yJTIwaXRlbSUyMGluJTIwZGF0YXNldCU1QidsYWJlbCclNUQlNUQlMEFmbGF0dGVuZWRfbGFiZWxzJTIwJTNEJTIwbGlzdChpdGVydG9vbHMuY2hhaW4oKmxhYmVscykpJTBBdW5pcXVlX2xhYmVscyUyMCUzRCUyMGxpc3Qoc2V0KGZsYXR0ZW5lZF9sYWJlbHMpKSUwQSUwQWxhYmVsMmlkJTIwJTNEJTIwJTdCbGFiZWwlM0ElMjBpZHglMjBmb3IlMjBpZHglMkMlMjBsYWJlbCUyMGluJTIwZW51bWVyYXRlKHVuaXF1ZV9sYWJlbHMpJTdEJTBBaWQybGFiZWwlMjAlM0QlMjAlN0JpZHglM0ElMjBsYWJlbCUyMGZvciUyMGxhYmVsJTJDJTIwaWR4JTIwaW4lMjBsYWJlbDJpZC5pdGVtcygpJTdEJTIw",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> itertools

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = [item[<span class="hljs-string">&#x27;ids&#x27;</span>] <span class="hljs-keyword">for</span> item <span class="hljs-keyword">in</span> dataset[<span class="hljs-string">&#x27;label&#x27;</span>]]
<span class="hljs-meta">&gt;&gt;&gt; </span>flattened_labels = <span class="hljs-built_in">list</span>(itertools.chain(*labels))
<span class="hljs-meta">&gt;&gt;&gt; </span>unique_labels = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(flattened_labels))

<span class="hljs-meta">&gt;&gt;&gt; </span>label2id = {label: idx <span class="hljs-keyword">for</span> idx, label <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(unique_labels)}
<span class="hljs-meta">&gt;&gt;&gt; </span>id2label = {idx: label <span class="hljs-keyword">for</span> label, idx <span class="hljs-keyword">in</span> label2id.items()} `,wrap:!1}}),ys=new j({props:{code:"ZGVmJTIwcmVwbGFjZV9pZHMoaW5wdXRzKSUzQSUwQSUyMCUyMGlucHV0cyU1QiUyMmxhYmVsJTIyJTVEJTVCJTIyaWRzJTIyJTVEJTIwJTNEJTIwJTVCbGFiZWwyaWQlNUJ4JTVEJTIwZm9yJTIweCUyMGluJTIwaW5wdXRzJTVCJTIybGFiZWwlMjIlNUQlNUIlMjJpZHMlMjIlNUQlNUQlMEElMjAlMjByZXR1cm4lMjBpbnB1dHMlMEElMEElMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5tYXAocmVwbGFjZV9pZHMpJTBBZmxhdF9kYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5mbGF0dGVuKCklMEFmbGF0X2RhdGFzZXQuZmVhdHVyZXM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">replace_ids</span>(<span class="hljs-params">inputs</span>):
<span class="hljs-meta">... </span>  inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>] = [label2id[x] <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> inputs[<span class="hljs-string">&quot;label&quot;</span>][<span class="hljs-string">&quot;ids&quot;</span>]]
<span class="hljs-meta">... </span>  <span class="hljs-keyword">return</span> inputs


<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.<span class="hljs-built_in">map</span>(replace_ids)
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset = dataset.flatten()
<span class="hljs-meta">&gt;&gt;&gt; </span>flat_dataset.features
{<span class="hljs-string">&#x27;question&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;image_id&#x27;</span>: Value(dtype=<span class="hljs-string">&#x27;string&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.ids&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;int64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>),
 <span class="hljs-string">&#x27;label.weights&#x27;</span>: <span class="hljs-type">Sequence</span>(feature=Value(dtype=<span class="hljs-string">&#x27;float64&#x27;</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>), length=-<span class="hljs-number">1</span>, <span class="hljs-built_in">id</span>=<span class="hljs-literal">None</span>)}`,wrap:!1}}),bs=new pt({}),ws=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRQcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBWaWx0UHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(model_checkpoint)`,wrap:!1}}),vs=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBwcmVwcm9jZXNzX2RhdGEoZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfcGF0aHMlMjAlM0QlMjBleGFtcGxlcyU1QidpbWFnZV9pZCclNUQlMEElMjAlMjAlMjAlMjBpbWFnZXMlMjAlM0QlMjAlNUJJbWFnZS5vcGVuKGltYWdlX3BhdGgpJTIwZm9yJTIwaW1hZ2VfcGF0aCUyMGluJTIwaW1hZ2VfcGF0aHMlNUQlMEElMjAlMjAlMjAlMjB0ZXh0cyUyMCUzRCUyMGV4YW1wbGVzJTVCJ3F1ZXN0aW9uJyU1RCUyMCUyMCUyMCUyMCUwQSUwQSUyMCUyMCUyMCUyMGVuY29kaW5nJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUyQyUyMHRleHRzJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIwJTIwJTIwJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGVuY29kaW5nLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBlbmNvZGluZyU1QmslNUQlMjAlM0QlMjB2LnNxdWVlemUoKSUwQSUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjAlMjAlMjAlMjBmb3IlMjBsYWJlbHMlMkMlMjBzY29yZXMlMjBpbiUyMHppcChleGFtcGxlcyU1QidsYWJlbC5pZHMnJTVEJTJDJTIwZXhhbXBsZXMlNUInbGFiZWwud2VpZ2h0cyclNUQpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGFyZ2V0JTIwJTNEJTIwdG9yY2guemVyb3MobGVuKGlkMmxhYmVsKSklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBsYWJlbCUyQyUyMHNjb3JlJTIwaW4lMjB6aXAobGFiZWxzJTJDJTIwc2NvcmVzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldCU1QmxhYmVsJTVEJTIwJTNEJTIwc2NvcmUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0YXJnZXRzLmFwcGVuZCh0YXJnZXQpJTBBJTBBJTIwJTIwJTIwJTIwZW5jb2RpbmclNUIlMjJsYWJlbHMlMjIlNUQlMjAlM0QlMjB0YXJnZXRzJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZW5jb2Rpbmc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_data</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    image_paths = examples[<span class="hljs-string">&#x27;image_id&#x27;</span>]
<span class="hljs-meta">... </span>    images = [Image.<span class="hljs-built_in">open</span>(image_path) <span class="hljs-keyword">for</span> image_path <span class="hljs-keyword">in</span> image_paths]
<span class="hljs-meta">... </span>    texts = examples[<span class="hljs-string">&#x27;question&#x27;</span>]    

<span class="hljs-meta">... </span>    encoding = processor(images, texts, padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> encoding.items():
<span class="hljs-meta">... </span>          encoding[k] = v.squeeze()
    
<span class="hljs-meta">... </span>    targets = []

<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> labels, scores <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(examples[<span class="hljs-string">&#x27;label.ids&#x27;</span>], examples[<span class="hljs-string">&#x27;label.weights&#x27;</span>]):
<span class="hljs-meta">... </span>        target = torch.zeros(<span class="hljs-built_in">len</span>(id2label))

<span class="hljs-meta">... </span>        <span class="hljs-keyword">for</span> label, score <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(labels, scores):
<span class="hljs-meta">... </span>            target[label] = score
      
<span class="hljs-meta">... </span>        targets.append(target)

<span class="hljs-meta">... </span>    encoding[<span class="hljs-string">&quot;labels&quot;</span>] = targets
    
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> encoding`,wrap:!1}}),Cs=new j({props:{code:"cHJvY2Vzc2VkX2RhdGFzZXQlMjAlM0QlMjBmbGF0X2RhdGFzZXQubWFwKHByZXByb2Nlc3NfZGF0YSUyQyUyMGJhdGNoZWQlM0RUcnVlJTJDJTIwcmVtb3ZlX2NvbHVtbnMlM0QlNUIncXVlc3Rpb24nJTJDJ3F1ZXN0aW9uX3R5cGUnJTJDJTIwJTIwJ3F1ZXN0aW9uX2lkJyUyQyUyMCdpbWFnZV9pZCclMkMlMjAnYW5zd2VyX3R5cGUnJTJDJTIwJ2xhYmVsLmlkcyclMkMlMjAnbGFiZWwud2VpZ2h0cyclNUQpJTBBcHJvY2Vzc2VkX2RhdGFzZXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset = flat_dataset.<span class="hljs-built_in">map</span>(preprocess_data, batched=<span class="hljs-literal">True</span>, remove_columns=[<span class="hljs-string">&#x27;question&#x27;</span>,<span class="hljs-string">&#x27;question_type&#x27;</span>,  <span class="hljs-string">&#x27;question_id&#x27;</span>, <span class="hljs-string">&#x27;image_id&#x27;</span>, <span class="hljs-string">&#x27;answer_type&#x27;</span>, <span class="hljs-string">&#x27;label.ids&#x27;</span>, <span class="hljs-string">&#x27;label.weights&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>processed_dataset
Dataset({
    features: [<span class="hljs-string">&#x27;input_ids&#x27;</span>, <span class="hljs-string">&#x27;token_type_ids&#x27;</span>, <span class="hljs-string">&#x27;attention_mask&#x27;</span>, <span class="hljs-string">&#x27;pixel_values&#x27;</span>, <span class="hljs-string">&#x27;pixel_mask&#x27;</span>, <span class="hljs-string">&#x27;labels&#x27;</span>],
    num_rows: <span class="hljs-number">200</span>
})`,wrap:!1}}),_s=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator()`,wrap:!1}}),Zs=new pt({}),ks=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQW1vZGVsJTIwJTNEJTIwVmlsdEZvclF1ZXN0aW9uQW5zd2VyaW5nLmZyb21fcHJldHJhaW5lZChtb2RlbF9jaGVja3BvaW50JTJDJTIwbnVtX2xhYmVscyUzRGxlbihpZDJsYWJlbCklMkMlMjBpZDJsYWJlbCUzRGlkMmxhYmVsJTJDJTIwbGFiZWwyaWQlM0RsYWJlbDJpZCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ViltForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(model_checkpoint, num_labels=<span class="hljs-built_in">len</span>(id2label), id2label=id2label, label2id=label2id)`,wrap:!1}}),Is=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMiUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyglMEElMjAlMjAlMjAlMjBvdXRwdXRfZGlyJTNEcmVwb19pZCUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMkMlMEElMjAlMjAlMjAlMjBudW1fdHJhaW5fZXBvY2hzJTNEMjAlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwbG9nZ2luZ19zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwbGVhcm5pbmdfcmF0ZSUzRDVlLTUlMkMlMEElMjAlMjAlMjAlMjBzYXZlX3RvdGFsX2xpbWl0JTNEMiUyQyUwQSUyMCUyMCUyMCUyMHJlbW92ZV91bnVzZWRfY29sdW1ucyUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcHVzaF90b19odWIlM0RUcnVlJTJDJTBBKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(
<span class="hljs-meta">... </span>    output_dir=repo_id,
<span class="hljs-meta">... </span>    per_device_train_batch_size=<span class="hljs-number">4</span>,
<span class="hljs-meta">... </span>    num_train_epochs=<span class="hljs-number">20</span>,
<span class="hljs-meta">... </span>    save_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    logging_steps=<span class="hljs-number">50</span>,
<span class="hljs-meta">... </span>    learning_rate=<span class="hljs-number">5e-5</span>,
<span class="hljs-meta">... </span>    save_total_limit=<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    remove_unused_columns=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    push_to_hub=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Bs=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluZXIlMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUzRG1vZGVsJTJDJTBBJTIwJTIwJTIwJTIwYXJncyUzRHRyYWluaW5nX2FyZ3MlMkMlMEElMjAlMjAlMjAlMjBkYXRhX2NvbGxhdG9yJTNEZGF0YV9jb2xsYXRvciUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0Rwcm9jZXNzZWRfZGF0YXNldCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHByb2Nlc3NvciUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer

<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    data_collator=data_collator,
<span class="hljs-meta">... </span>    train_dataset=processed_dataset,
<span class="hljs-meta">... </span>    tokenizer=processor,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Xs=new j({props:{code:"dHJhaW5lci50cmFpbigpJTIw",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train() ',wrap:!1}}),Rs=new j({props:{code:"dHJhaW5lci5wdXNoX3RvX2h1Yigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.push_to_hub()',wrap:!1}}),Hs=new pt({}),Es=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnZpc3VhbC1xdWVzdGlvbi1hbnN3ZXJpbmclMjIlMkMlMjBtb2RlbCUzRCUyMk1hcmlhSyUyRnZpbHRfZmluZXR1bmVkXzIwMCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;visual-question-answering&quot;</span>, model=<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)`,wrap:!1}}),As=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQlMEFwcmludChxdWVzdGlvbiklMEFwaXBlKGltYWdlJTJDJTIwcXVlc3Rpb24lMkMlMjB0b3BfayUzRDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(question)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(image, question, top_k=<span class="hljs-number">1</span>)
<span class="hljs-string">&quot;Where is he looking?&quot;</span>
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.5498199462890625</span>, <span class="hljs-string">&#x27;answer&#x27;</span>: <span class="hljs-string">&#x27;down&#x27;</span>}]`,wrap:!1}}),Ls=new j({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwVmlsdFByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihleGFtcGxlJTVCJ2ltYWdlX2lkJyU1RCklMEFxdWVzdGlvbiUyMCUzRCUyMGV4YW1wbGUlNUIncXVlc3Rpb24nJTVEJTBBJTBBJTIzJTIwcHJlcGFyZSUyMGlucHV0cyUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZSUyQyUyMHF1ZXN0aW9uJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFtb2RlbCUyMCUzRCUyMFZpbHRGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyTWFyaWFLJTJGdmlsdF9maW5ldHVuZWRfMjAwJTIyKSUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWlkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGFuc3dlciUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QmlkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>processor = ViltProcessor.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ViltForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;MariaK/vilt_finetuned_200&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted answer:&quot;</span>, model.config.id2label[idx])
Predicted answer: down`,wrap:!1}}),Ss=new pt({}),Ks=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFkZXZpY2UlMjAlM0QlMjAlMjJjdWRhJTIyJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCUyMmNwdSUyMiUwQW1vZGVsLnRvKGRldmljZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, Blip2ForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Blip2ForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),st=new j({props:{code:"ZXhhbXBsZSUyMCUzRCUyMGRhdGFzZXQlNUIwJTVEJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKGV4YW1wbGUlNUInaW1hZ2VfaWQnJTVEKSUwQXF1ZXN0aW9uJTIwJTNEJTIwZXhhbXBsZSU1QidxdWVzdGlvbiclNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>example = dataset[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(example[<span class="hljs-string">&#x27;image_id&#x27;</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>question = example[<span class="hljs-string">&#x27;question&#x27;</span>]`,wrap:!1}}),lt=new j({props:{code:"cHJvbXB0JTIwJTNEJTIwZiUyMlF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb24lN0QlMjBBbnN3ZXIlM0ElMjIlMjA=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&quot;Question: <span class="hljs-subst">{question}</span> Answer:&quot;</span> ',wrap:!1}}),at=new j({props:{code:"aW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwdGV4dCUzRHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKGRldmljZSUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBZ2VuZXJhdGVkX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QxMCklMEFnZW5lcmF0ZWRfdGV4dCUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQuc3RyaXAoKSUwQXByaW50KGdlbmVyYXRlZF90ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">10</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_text = processor.batch_decode(generated_ids, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>].strip()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generated_text)
<span class="hljs-string">&quot;He is looking at the crowd&quot;</span> `,wrap:!1}}),{c(){b=p("meta"),Tt=a(),dt=p("p"),xt=a(),f=p("h1"),C=p("a"),ut=p("span"),o(X.$$.fragment),ne=a(),it=p("span"),it.textContent=ge,vt=a(),o(Q.$$.fragment),Ut=a(),R=p("p"),R.textContent=de,Ct=a(),H=p("p"),H.textContent=ue,$t=a(),N=p("ul"),N.innerHTML=Me,_t=a(),E=p("p"),E.textContent=je,Zt=a(),F=p("ul"),F.innerHTML=ye,Vt=a(),w=p("h2"),$=p("a"),Mt=p("span"),o(A.$$.fragment),pe=a(),rt=p("span"),rt.textContent=be,kt=a(),z=p("p"),z.innerHTML=fe,Gt=a(),Y=p("p"),Y.textContent=we,Wt=a(),q=p("p"),q.textContent=Je,It=a(),o(L.$$.fragment),Bt=a(),S=p("p"),S.textContent=Te,Xt=a(),o(P.$$.fragment),Qt=a(),D=p("p"),D.textContent=xe,Rt=a(),o(K.$$.fragment),Ht=a(),J=p("h2"),_=p("a"),jt=p("span"),o(O.$$.fragment),ie=a(),ot=p("span"),ot.textContent=ve,Nt=a(),ss=p("p"),ss.innerHTML=Ue,Et=a(),ts=p("p"),ts.innerHTML=Ce,Ft=a(),ls=p("p"),ls.textContent=$e,At=a(),o(es.$$.fragment),zt=a(),as=p("p"),as.textContent=_e,Yt=a(),o(ns.$$.fragment),qt=a(),ps=p("p"),ps.textContent=Ze,Lt=a(),is=p("ul"),is.innerHTML=Ve,St=a(),rs=p("p"),rs.textContent=ke,Pt=a(),o(os.$$.fragment),Dt=a(),cs=p("p"),cs.innerHTML=Ge,Kt=a(),hs=p("p"),hs.textContent=We,Ot=a(),o(ms.$$.fragment),sl=a(),Z=p("div"),Z.innerHTML=Ie,tl=a(),gs=p("p"),gs.textContent=Be,ll=a(),ds=p("p"),ds.innerHTML=Xe,el=a(),us=p("p"),us.textContent=Qe,al=a(),o(Ms.$$.fragment),nl=a(),js=p("p"),js.textContent=Re,pl=a(),o(ys.$$.fragment),il=a(),T=p("h2"),V=p("a"),yt=p("span"),o(bs.$$.fragment),re=a(),ct=p("span"),ct.textContent=He,rl=a(),fs=p("p"),fs.innerHTML=Ne,ol=a(),o(ws.$$.fragment),cl=a(),Js=p("p"),Js.innerHTML=Ee,hl=a(),Ts=p("p"),Ts.innerHTML=Fe,ml=a(),xs=p("p"),xs.innerHTML=Ae,gl=a(),o(vs.$$.fragment),dl=a(),Us=p("p"),Us.innerHTML=ze,ul=a(),o(Cs.$$.fragment),Ml=a(),$s=p("p"),$s.innerHTML=Ye,jl=a(),o(_s.$$.fragment),yl=a(),x=p("h2"),k=p("a"),bt=p("span"),o(Zs.$$.fragment),oe=a(),ht=p("span"),ht.textContent=qe,bl=a(),Vs=p("p"),Vs.innerHTML=Le,fl=a(),o(ks.$$.fragment),wl=a(),Gs=p("p"),Gs.textContent=Se,Jl=a(),Ws=p("ol"),Ws.innerHTML=Pe,Tl=a(),o(Is.$$.fragment),xl=a(),G=p("ol"),G.innerHTML=De,vl=a(),o(Bs.$$.fragment),Ul=a(),W=p("ol"),W.innerHTML=Ke,Cl=a(),o(Xs.$$.fragment),$l=a(),Qs=p("p"),Qs.innerHTML=Oe,_l=a(),o(Rs.$$.fragment),Zl=a(),v=p("h2"),I=p("a"),ft=p("span"),o(Hs.$$.fragment),ce=a(),mt=p("span"),mt.textContent=sa,Vl=a(),Ns=p("p"),Ns.innerHTML=ta,kl=a(),o(Es.$$.fragment),Gl=a(),Fs=p("p"),Fs.textContent=la,Wl=a(),o(As.$$.fragment),Il=a(),zs=p("p"),zs.textContent=ea,Bl=a(),Ys=p("p"),Ys.textContent=aa,Xl=a(),qs=p("ol"),qs.innerHTML=na,Ql=a(),o(Ls.$$.fragment),Rl=a(),U=p("h2"),B=p("a"),wt=p("span"),o(Ss.$$.fragment),he=a(),gt=p("span"),gt.textContent=pa,Hl=a(),Ps=p("p"),Ps.innerHTML=ia,Nl=a(),Ds=p("p"),Ds.innerHTML=ra,El=a(),o(Ks.$$.fragment),Fl=a(),Os=p("p"),Os.textContent=oa,Al=a(),o(st.$$.fragment),zl=a(),tt=p("p"),tt.innerHTML=ca,Yl=a(),o(lt.$$.fragment),ql=a(),et=p("p"),et.textContent=ha,Ll=a(),o(at.$$.fragment),Sl=a(),nt=p("p"),nt.textContent=ma,Pl=a(),Jt=p("p"),this.h()},l(s){const t=ka("svelte-1phssyn",document.head);b=i(t,"META",{name:!0,content:!0}),t.forEach(l),Tt=n(s),dt=i(s,"P",{}),y(dt).forEach(l),xt=n(s),f=i(s,"H1",{class:!0});var Kl=y(f);C=i(Kl,"A",{id:!0,class:!0,href:!0});var ga=y(C);ut=i(ga,"SPAN",{});var da=y(ut);c(X.$$.fragment,da),da.forEach(l),ga.forEach(l),ne=n(Kl),it=i(Kl,"SPAN",{"data-svelte-h":!0}),r(it)!=="svelte-1hfqqda"&&(it.textContent=ge),Kl.forEach(l),vt=n(s),c(Q.$$.fragment,s),Ut=n(s),R=i(s,"P",{"data-svelte-h":!0}),r(R)!=="svelte-lsf3d3"&&(R.textContent=de),Ct=n(s),H=i(s,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1m5x0xt"&&(H.textContent=ue),$t=n(s),N=i(s,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-19c3jz6"&&(N.innerHTML=Me),_t=n(s),E=i(s,"P",{"data-svelte-h":!0}),r(E)!=="svelte-27ww4z"&&(E.textContent=je),Zt=n(s),F=i(s,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-4zovkh"&&(F.innerHTML=ye),Vt=n(s),w=i(s,"H2",{class:!0});var Ol=y(w);$=i(Ol,"A",{id:!0,class:!0,href:!0});var ua=y($);Mt=i(ua,"SPAN",{});var Ma=y(Mt);c(A.$$.fragment,Ma),Ma.forEach(l),ua.forEach(l),pe=n(Ol),rt=i(Ol,"SPAN",{"data-svelte-h":!0}),r(rt)!=="svelte-te740d"&&(rt.textContent=be),Ol.forEach(l),kt=n(s),z=i(s,"P",{"data-svelte-h":!0}),r(z)!=="svelte-l5s5vs"&&(z.innerHTML=fe),Gt=n(s),Y=i(s,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1gnol8d"&&(Y.textContent=we),Wt=n(s),q=i(s,"P",{"data-svelte-h":!0}),r(q)!=="svelte-16n8ks6"&&(q.textContent=Je),It=n(s),c(L.$$.fragment,s),Bt=n(s),S=i(s,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1tfz9ll"&&(S.textContent=Te),Xt=n(s),c(P.$$.fragment,s),Qt=n(s),D=i(s,"P",{"data-svelte-h":!0}),r(D)!=="svelte-8hbytf"&&(D.textContent=xe),Rt=n(s),c(K.$$.fragment,s),Ht=n(s),J=i(s,"H2",{class:!0});var se=y(J);_=i(se,"A",{id:!0,class:!0,href:!0});var ja=y(_);jt=i(ja,"SPAN",{});var ya=y(jt);c(O.$$.fragment,ya),ya.forEach(l),ja.forEach(l),ie=n(se),ot=i(se,"SPAN",{"data-svelte-h":!0}),r(ot)!=="svelte-rnox83"&&(ot.textContent=ve),se.forEach(l),Nt=n(s),ss=i(s,"P",{"data-svelte-h":!0}),r(ss)!=="svelte-ogma3f"&&(ss.innerHTML=Ue),Et=n(s),ts=i(s,"P",{"data-svelte-h":!0}),r(ts)!=="svelte-1yqcape"&&(ts.innerHTML=Ce),Ft=n(s),ls=i(s,"P",{"data-svelte-h":!0}),r(ls)!=="svelte-1e6q69w"&&(ls.textContent=$e),At=n(s),c(es.$$.fragment,s),zt=n(s),as=i(s,"P",{"data-svelte-h":!0}),r(as)!=="svelte-k3mzt8"&&(as.textContent=_e),Yt=n(s),c(ns.$$.fragment,s),qt=n(s),ps=i(s,"P",{"data-svelte-h":!0}),r(ps)!=="svelte-1vwvj02"&&(ps.textContent=Ze),Lt=n(s),is=i(s,"UL",{"data-svelte-h":!0}),r(is)!=="svelte-1bz53k7"&&(is.innerHTML=Ve),St=n(s),rs=i(s,"P",{"data-svelte-h":!0}),r(rs)!=="svelte-1hynqfk"&&(rs.textContent=ke),Pt=n(s),c(os.$$.fragment,s),Dt=n(s),cs=i(s,"P",{"data-svelte-h":!0}),r(cs)!=="svelte-6vh6f7"&&(cs.innerHTML=Ge),Kt=n(s),hs=i(s,"P",{"data-svelte-h":!0}),r(hs)!=="svelte-1o0kwl9"&&(hs.textContent=We),Ot=n(s),c(ms.$$.fragment,s),sl=n(s),Z=i(s,"DIV",{class:!0,"data-svelte-h":!0}),r(Z)!=="svelte-1tjg4st"&&(Z.innerHTML=Ie),tl=n(s),gs=i(s,"P",{"data-svelte-h":!0}),r(gs)!=="svelte-bmlc3i"&&(gs.textContent=Be),ll=n(s),ds=i(s,"P",{"data-svelte-h":!0}),r(ds)!=="svelte-1isdfaj"&&(ds.innerHTML=Xe),el=n(s),us=i(s,"P",{"data-svelte-h":!0}),r(us)!=="svelte-1hwga8k"&&(us.textContent=Qe),al=n(s),c(Ms.$$.fragment,s),nl=n(s),js=i(s,"P",{"data-svelte-h":!0}),r(js)!=="svelte-1f1gsw8"&&(js.textContent=Re),pl=n(s),c(ys.$$.fragment,s),il=n(s),T=i(s,"H2",{class:!0});var te=y(T);V=i(te,"A",{id:!0,class:!0,href:!0});var ba=y(V);yt=i(ba,"SPAN",{});var fa=y(yt);c(bs.$$.fragment,fa),fa.forEach(l),ba.forEach(l),re=n(te),ct=i(te,"SPAN",{"data-svelte-h":!0}),r(ct)!=="svelte-5kizkd"&&(ct.textContent=He),te.forEach(l),rl=n(s),fs=i(s,"P",{"data-svelte-h":!0}),r(fs)!=="svelte-u0lfur"&&(fs.innerHTML=Ne),ol=n(s),c(ws.$$.fragment,s),cl=n(s),Js=i(s,"P",{"data-svelte-h":!0}),r(Js)!=="svelte-1ihxpp7"&&(Js.innerHTML=Ee),hl=n(s),Ts=i(s,"P",{"data-svelte-h":!0}),r(Ts)!=="svelte-8a14gg"&&(Ts.innerHTML=Fe),ml=n(s),xs=i(s,"P",{"data-svelte-h":!0}),r(xs)!=="svelte-x4dc7"&&(xs.innerHTML=Ae),gl=n(s),c(vs.$$.fragment,s),dl=n(s),Us=i(s,"P",{"data-svelte-h":!0}),r(Us)!=="svelte-y8sr6z"&&(Us.innerHTML=ze),ul=n(s),c(Cs.$$.fragment,s),Ml=n(s),$s=i(s,"P",{"data-svelte-h":!0}),r($s)!=="svelte-12etfja"&&($s.innerHTML=Ye),jl=n(s),c(_s.$$.fragment,s),yl=n(s),x=i(s,"H2",{class:!0});var le=y(x);k=i(le,"A",{id:!0,class:!0,href:!0});var wa=y(k);bt=i(wa,"SPAN",{});var Ja=y(bt);c(Zs.$$.fragment,Ja),Ja.forEach(l),wa.forEach(l),oe=n(le),ht=i(le,"SPAN",{"data-svelte-h":!0}),r(ht)!=="svelte-1gf3d89"&&(ht.textContent=qe),le.forEach(l),bl=n(s),Vs=i(s,"P",{"data-svelte-h":!0}),r(Vs)!=="svelte-117iw8t"&&(Vs.innerHTML=Le),fl=n(s),c(ks.$$.fragment,s),wl=n(s),Gs=i(s,"P",{"data-svelte-h":!0}),r(Gs)!=="svelte-ahfk2n"&&(Gs.textContent=Se),Jl=n(s),Ws=i(s,"OL",{"data-svelte-h":!0}),r(Ws)!=="svelte-9y82ex"&&(Ws.innerHTML=Pe),Tl=n(s),c(Is.$$.fragment,s),xl=n(s),G=i(s,"OL",{start:!0,"data-svelte-h":!0}),r(G)!=="svelte-18s4qm6"&&(G.innerHTML=De),vl=n(s),c(Bs.$$.fragment,s),Ul=n(s),W=i(s,"OL",{start:!0,"data-svelte-h":!0}),r(W)!=="svelte-1jabqg6"&&(W.innerHTML=Ke),Cl=n(s),c(Xs.$$.fragment,s),$l=n(s),Qs=i(s,"P",{"data-svelte-h":!0}),r(Qs)!=="svelte-njd4j0"&&(Qs.innerHTML=Oe),_l=n(s),c(Rs.$$.fragment,s),Zl=n(s),v=i(s,"H2",{class:!0});var ee=y(v);I=i(ee,"A",{id:!0,class:!0,href:!0});var Ta=y(I);ft=i(Ta,"SPAN",{});var xa=y(ft);c(Hs.$$.fragment,xa),xa.forEach(l),Ta.forEach(l),ce=n(ee),mt=i(ee,"SPAN",{"data-svelte-h":!0}),r(mt)!=="svelte-1dnn72f"&&(mt.textContent=sa),ee.forEach(l),Vl=n(s),Ns=i(s,"P",{"data-svelte-h":!0}),r(Ns)!=="svelte-1uxaimc"&&(Ns.innerHTML=ta),kl=n(s),c(Es.$$.fragment,s),Gl=n(s),Fs=i(s,"P",{"data-svelte-h":!0}),r(Fs)!=="svelte-2v1cek"&&(Fs.textContent=la),Wl=n(s),c(As.$$.fragment,s),Il=n(s),zs=i(s,"P",{"data-svelte-h":!0}),r(zs)!=="svelte-tjyuxs"&&(zs.textContent=ea),Bl=n(s),Ys=i(s,"P",{"data-svelte-h":!0}),r(Ys)!=="svelte-4epvs7"&&(Ys.textContent=aa),Xl=n(s),qs=i(s,"OL",{"data-svelte-h":!0}),r(qs)!=="svelte-gtxums"&&(qs.innerHTML=na),Ql=n(s),c(Ls.$$.fragment,s),Rl=n(s),U=i(s,"H2",{class:!0});var ae=y(U);B=i(ae,"A",{id:!0,class:!0,href:!0});var va=y(B);wt=i(va,"SPAN",{});var Ua=y(wt);c(Ss.$$.fragment,Ua),Ua.forEach(l),va.forEach(l),he=n(ae),gt=i(ae,"SPAN",{"data-svelte-h":!0}),r(gt)!=="svelte-1lnia00"&&(gt.textContent=pa),ae.forEach(l),Hl=n(s),Ps=i(s,"P",{"data-svelte-h":!0}),r(Ps)!=="svelte-y6okgx"&&(Ps.innerHTML=ia),Nl=n(s),Ds=i(s,"P",{"data-svelte-h":!0}),r(Ds)!=="svelte-17wlrgr"&&(Ds.innerHTML=ra),El=n(s),c(Ks.$$.fragment,s),Fl=n(s),Os=i(s,"P",{"data-svelte-h":!0}),r(Os)!=="svelte-bl55fy"&&(Os.textContent=oa),Al=n(s),c(st.$$.fragment,s),zl=n(s),tt=i(s,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-179kzpa"&&(tt.innerHTML=ca),Yl=n(s),c(lt.$$.fragment,s),ql=n(s),et=i(s,"P",{"data-svelte-h":!0}),r(et)!=="svelte-les5jw"&&(et.textContent=ha),Ll=n(s),c(at.$$.fragment,s),Sl=n(s),nt=i(s,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1wddc64"&&(nt.textContent=ma),Pl=n(s),Jt=i(s,"P",{}),y(Jt).forEach(l),this.h()},h(){h(b,"name","hf:doc:metadata"),h(b,"content",JSON.stringify(Ia)),h(C,"id","visual-question-answering"),h(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(C,"href","#visual-question-answering"),h(f,"class","relative group"),h($,"id","finetuning-vilt"),h($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h($,"href","#finetuning-vilt"),h(w,"class","relative group"),h(_,"id","load-the-data"),h(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(_,"href","#load-the-data"),h(J,"class","relative group"),h(Z,"class","flex justify-center"),h(V,"id","preprocessing-data"),h(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(V,"href","#preprocessing-data"),h(T,"class","relative group"),h(k,"id","train-the-model"),h(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(k,"href","#train-the-model"),h(x,"class","relative group"),h(G,"start","2"),h(W,"start","3"),h(I,"id","inference"),h(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(I,"href","#inference"),h(v,"class","relative group"),h(B,"id","zeroshot-vqa"),h(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),h(B,"href","#zeroshot-vqa"),h(U,"class","relative group")},m(s,t){M(document.head,b),e(s,Tt,t),e(s,dt,t),e(s,xt,t),e(s,f,t),M(f,C),M(C,ut),m(X,ut,null),M(f,ne),M(f,it),e(s,vt,t),m(Q,s,t),e(s,Ut,t),e(s,R,t),e(s,Ct,t),e(s,H,t),e(s,$t,t),e(s,N,t),e(s,_t,t),e(s,E,t),e(s,Zt,t),e(s,F,t),e(s,Vt,t),e(s,w,t),M(w,$),M($,Mt),m(A,Mt,null),M(w,pe),M(w,rt),e(s,kt,t),e(s,z,t),e(s,Gt,t),e(s,Y,t),e(s,Wt,t),e(s,q,t),e(s,It,t),m(L,s,t),e(s,Bt,t),e(s,S,t),e(s,Xt,t),m(P,s,t),e(s,Qt,t),e(s,D,t),e(s,Rt,t),m(K,s,t),e(s,Ht,t),e(s,J,t),M(J,_),M(_,jt),m(O,jt,null),M(J,ie),M(J,ot),e(s,Nt,t),e(s,ss,t),e(s,Et,t),e(s,ts,t),e(s,Ft,t),e(s,ls,t),e(s,At,t),m(es,s,t),e(s,zt,t),e(s,as,t),e(s,Yt,t),m(ns,s,t),e(s,qt,t),e(s,ps,t),e(s,Lt,t),e(s,is,t),e(s,St,t),e(s,rs,t),e(s,Pt,t),m(os,s,t),e(s,Dt,t),e(s,cs,t),e(s,Kt,t),e(s,hs,t),e(s,Ot,t),m(ms,s,t),e(s,sl,t),e(s,Z,t),e(s,tl,t),e(s,gs,t),e(s,ll,t),e(s,ds,t),e(s,el,t),e(s,us,t),e(s,al,t),m(Ms,s,t),e(s,nl,t),e(s,js,t),e(s,pl,t),m(ys,s,t),e(s,il,t),e(s,T,t),M(T,V),M(V,yt),m(bs,yt,null),M(T,re),M(T,ct),e(s,rl,t),e(s,fs,t),e(s,ol,t),m(ws,s,t),e(s,cl,t),e(s,Js,t),e(s,hl,t),e(s,Ts,t),e(s,ml,t),e(s,xs,t),e(s,gl,t),m(vs,s,t),e(s,dl,t),e(s,Us,t),e(s,ul,t),m(Cs,s,t),e(s,Ml,t),e(s,$s,t),e(s,jl,t),m(_s,s,t),e(s,yl,t),e(s,x,t),M(x,k),M(k,bt),m(Zs,bt,null),M(x,oe),M(x,ht),e(s,bl,t),e(s,Vs,t),e(s,fl,t),m(ks,s,t),e(s,wl,t),e(s,Gs,t),e(s,Jl,t),e(s,Ws,t),e(s,Tl,t),m(Is,s,t),e(s,xl,t),e(s,G,t),e(s,vl,t),m(Bs,s,t),e(s,Ul,t),e(s,W,t),e(s,Cl,t),m(Xs,s,t),e(s,$l,t),e(s,Qs,t),e(s,_l,t),m(Rs,s,t),e(s,Zl,t),e(s,v,t),M(v,I),M(I,ft),m(Hs,ft,null),M(v,ce),M(v,mt),e(s,Vl,t),e(s,Ns,t),e(s,kl,t),m(Es,s,t),e(s,Gl,t),e(s,Fs,t),e(s,Wl,t),m(As,s,t),e(s,Il,t),e(s,zs,t),e(s,Bl,t),e(s,Ys,t),e(s,Xl,t),e(s,qs,t),e(s,Ql,t),m(Ls,s,t),e(s,Rl,t),e(s,U,t),M(U,B),M(B,wt),m(Ss,wt,null),M(U,he),M(U,gt),e(s,Hl,t),e(s,Ps,t),e(s,Nl,t),e(s,Ds,t),e(s,El,t),m(Ks,s,t),e(s,Fl,t),e(s,Os,t),e(s,Al,t),m(st,s,t),e(s,zl,t),e(s,tt,t),e(s,Yl,t),m(lt,s,t),e(s,ql,t),e(s,et,t),e(s,Ll,t),m(at,s,t),e(s,Sl,t),e(s,nt,t),e(s,Pl,t),e(s,Jt,t),Dl=!0},p:$a,i(s){Dl||(g(X.$$.fragment,s),g(Q.$$.fragment,s),g(A.$$.fragment,s),g(L.$$.fragment,s),g(P.$$.fragment,s),g(K.$$.fragment,s),g(O.$$.fragment,s),g(es.$$.fragment,s),g(ns.$$.fragment,s),g(os.$$.fragment,s),g(ms.$$.fragment,s),g(Ms.$$.fragment,s),g(ys.$$.fragment,s),g(bs.$$.fragment,s),g(ws.$$.fragment,s),g(vs.$$.fragment,s),g(Cs.$$.fragment,s),g(_s.$$.fragment,s),g(Zs.$$.fragment,s),g(ks.$$.fragment,s),g(Is.$$.fragment,s),g(Bs.$$.fragment,s),g(Xs.$$.fragment,s),g(Rs.$$.fragment,s),g(Hs.$$.fragment,s),g(Es.$$.fragment,s),g(As.$$.fragment,s),g(Ls.$$.fragment,s),g(Ss.$$.fragment,s),g(Ks.$$.fragment,s),g(st.$$.fragment,s),g(lt.$$.fragment,s),g(at.$$.fragment,s),Dl=!0)},o(s){d(X.$$.fragment,s),d(Q.$$.fragment,s),d(A.$$.fragment,s),d(L.$$.fragment,s),d(P.$$.fragment,s),d(K.$$.fragment,s),d(O.$$.fragment,s),d(es.$$.fragment,s),d(ns.$$.fragment,s),d(os.$$.fragment,s),d(ms.$$.fragment,s),d(Ms.$$.fragment,s),d(ys.$$.fragment,s),d(bs.$$.fragment,s),d(ws.$$.fragment,s),d(vs.$$.fragment,s),d(Cs.$$.fragment,s),d(_s.$$.fragment,s),d(Zs.$$.fragment,s),d(ks.$$.fragment,s),d(Is.$$.fragment,s),d(Bs.$$.fragment,s),d(Xs.$$.fragment,s),d(Rs.$$.fragment,s),d(Hs.$$.fragment,s),d(Es.$$.fragment,s),d(As.$$.fragment,s),d(Ls.$$.fragment,s),d(Ss.$$.fragment,s),d(Ks.$$.fragment,s),d(st.$$.fragment,s),d(lt.$$.fragment,s),d(at.$$.fragment,s),Dl=!1},d(s){s&&(l(Tt),l(dt),l(xt),l(f),l(vt),l(Ut),l(R),l(Ct),l(H),l($t),l(N),l(_t),l(E),l(Zt),l(F),l(Vt),l(w),l(kt),l(z),l(Gt),l(Y),l(Wt),l(q),l(It),l(Bt),l(S),l(Xt),l(Qt),l(D),l(Rt),l(Ht),l(J),l(Nt),l(ss),l(Et),l(ts),l(Ft),l(ls),l(At),l(zt),l(as),l(Yt),l(qt),l(ps),l(Lt),l(is),l(St),l(rs),l(Pt),l(Dt),l(cs),l(Kt),l(hs),l(Ot),l(sl),l(Z),l(tl),l(gs),l(ll),l(ds),l(el),l(us),l(al),l(nl),l(js),l(pl),l(il),l(T),l(rl),l(fs),l(ol),l(cl),l(Js),l(hl),l(Ts),l(ml),l(xs),l(gl),l(dl),l(Us),l(ul),l(Ml),l($s),l(jl),l(yl),l(x),l(bl),l(Vs),l(fl),l(wl),l(Gs),l(Jl),l(Ws),l(Tl),l(xl),l(G),l(vl),l(Ul),l(W),l(Cl),l($l),l(Qs),l(_l),l(Zl),l(v),l(Vl),l(Ns),l(kl),l(Gl),l(Fs),l(Wl),l(Il),l(zs),l(Bl),l(Ys),l(Xl),l(qs),l(Ql),l(Rl),l(U),l(Hl),l(Ps),l(Nl),l(Ds),l(El),l(Fl),l(Os),l(Al),l(zl),l(tt),l(Yl),l(ql),l(et),l(Ll),l(Sl),l(nt),l(Pl),l(Jt)),l(b),u(X),u(Q,s),u(A),u(L,s),u(P,s),u(K,s),u(O),u(es,s),u(ns,s),u(os,s),u(ms,s),u(Ms,s),u(ys,s),u(bs),u(ws,s),u(vs,s),u(Cs,s),u(_s,s),u(Zs),u(ks,s),u(Is,s),u(Bs,s),u(Xs,s),u(Rs,s),u(Hs),u(Es,s),u(As,s),u(Ls,s),u(Ss),u(Ks,s),u(st,s),u(lt,s),u(at,s)}}}const Ia={local:"visual-question-answering",sections:[{local:"finetuning-vilt",title:"ViLT 미세 조정 "},{local:"load-the-data",title:"데이터 가져오기 "},{local:"preprocessing-data",title:"데이터 전처리 "},{local:"train-the-model",title:"모델 훈련 "},{local:"inference",title:"추론 "},{local:"zeroshot-vqa",title:"제로샷 VQA "}],title:"시각적 질의응답 (Visual Question Answering)"};function Ba(me){return _a(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ea extends Za{constructor(b){super(),Va(this,b,Ba,Wa,Ca,{})}}export{Ea as component};
