import{s as Wl,o as xl,n as Bt}from"../chunks/scheduler.d586627e.js";import{S as Xl,i as zl,g as n,s as a,u as m,A as El,h as i,f as t,c as o,j as T,v as c,y as r,k as p,o as w,a as l,w as u,d as M,t as y,x as f}from"../chunks/index.b757c891.js";import{T as Nt}from"../chunks/Tip.4380e997.js";import{I as es}from"../chunks/IconCopyLink.c074b82b.js";import{C as j}from"../chunks/CodeBlock.aa8a1a9b.js";function ql(Z){let d,U="Se o seu modelo for muito semelhante a um modelo dentro da biblioteca, você poderá reutilizar a mesma configuração desse modelo.";return{c(){d=n("p"),d.textContent=U},l(J){d=i(J,"P",{"data-svelte-h":!0}),r(d)!=="svelte-14dq0cm"&&(d.textContent=U)},m(J,b){l(J,d,b)},p:Bt,d(J){J&&t(d)}}}function Vl(Z){let d,U="Esta API é experimental e pode ter algumas pequenas alterações nas próximas versões.";return{c(){d=n("p"),d.textContent=U},l(J){d=i(J,"P",{"data-svelte-h":!0}),r(d)!=="svelte-1s1oyxv"&&(d.textContent=U)},m(J,b){l(J,d,b)},p:Bt,d(J){J&&t(d)}}}function Gl(Z){let d,U=`Se estiver copiando arquivos de modelagem da biblioteca, você precisará substituir todas as importações relativas na parte superior do arquivo
para importar do pacote <code>transformers</code>.`;return{c(){d=n("p"),d.innerHTML=U},l(J){d=i(J,"P",{"data-svelte-h":!0}),r(d)!=="svelte-jm95tu"&&(d.innerHTML=U)},m(J,b){l(J,d,b)},p:Bt,d(J){J&&t(d)}}}function Yl(Z){let d,U,J,b,C,A,ss,z,gt,Se,Rt="Compartilhando modelos customizados",ms,E,Wt=`A biblioteca 🤗 Transformers foi projetada para ser facilmente extensível. Cada modelo é totalmente codificado em uma determinada subpasta
do repositório sem abstração, para que você possa copiar facilmente um arquivo de modelagem e ajustá-lo às suas necessidades.`,cs,q,xt=`Se você estiver escrevendo um modelo totalmente novo, pode ser mais fácil começar do zero. Neste tutorial, mostraremos
como escrever um modelo customizado e sua configuração para que possa ser usado com Transformers, e como você pode compartilhá-lo
com a comunidade (com o código em que se baseia) para que qualquer pessoa possa usá-lo, mesmo se não estiver presente na biblioteca 🤗 Transformers.`,ps,V,Xt=`Ilustraremos tudo isso em um modelo ResNet, envolvendo a classe ResNet do
<a href="https://github.com/rwightman/pytorch-image-models" rel="nofollow">biblioteca timm</a> em um <code>PreTrainedModel</code>.`,us,h,$,ts,G,_t,Pe,zt="Escrevendo uma configuração customizada",Ms,Y,Et=`Antes de mergulharmos no modelo, vamos primeiro escrever sua configuração. A configuração de um modelo é um objeto que
terá todas as informações necessárias para construir o modelo. Como veremos na próxima seção, o modelo só pode
ter um <code>config</code> para ser inicializado, então realmente precisamos que esse objeto seja o mais completo possível.`,ys,Q,qt=`Em nosso exemplo, pegaremos alguns argumentos da classe ResNet que podemos querer ajustar. Diferentes
configurações nos dará os diferentes tipos de ResNets que são possíveis. Em seguida, apenas armazenamos esses argumentos,
após verificar a validade de alguns deles.`,fs,H,ws,F,Vt="As três coisas importantes a serem lembradas ao escrever sua própria configuração são:",Js,S,Gt="<li>você tem que herdar de <code>PretrainedConfig</code>,</li> <li>o <code>__init__</code> do seu <code>PretrainedConfig</code> deve aceitar quaisquer kwargs,</li> <li>esses <code>kwargs</code> precisam ser passados para a superclasse <code>__init__</code>.</li>",Ts,P,Yt=`A herança é para garantir que você obtenha todas as funcionalidades da biblioteca 🤗 Transformers, enquanto as outras duas
restrições vêm do fato de um <code>PretrainedConfig</code> ter mais campos do que os que você está configurando. Ao recarregar um
config com o método <code>from_pretrained</code>, esses campos precisam ser aceitos pelo seu config e então enviados para a
superclasse.`,js,L,Qt=`Definir um <code>model_type</code> para sua configuração (aqui <code>model_type=&quot;resnet&quot;</code>) não é obrigatório, a menos que você queira
registrar seu modelo com as classes automáticas (veja a última seção).`,Us,D,Ht=`Com isso feito, você pode facilmente criar e salvar sua configuração como faria com qualquer outra configuração de modelo da
biblioteca. Aqui está como podemos criar uma configuração resnet50d e salvá-la:`,bs,K,Cs,O,Ft=`Isso salvará um arquivo chamado <code>config.json</code> dentro da pasta <code>custom-resnet</code>. Você pode então recarregar sua configuração com o
método <code>from_pretrained</code>:`,hs,ee,vs,se,St=`Você também pode usar qualquer outro método da classe <code>PretrainedConfig</code>, como <code>push_to_hub()</code> para
carregar diretamente sua configuração para o Hub.`,Is,v,k,ls,te,Zt,Le,Pt="Escrevendo um modelo customizado",gs,le,Lt=`Agora que temos nossa configuração ResNet, podemos continuar escrevendo o modelo. Na verdade, escreveremos dois: um que
extrai os recursos ocultos de um lote de imagens (como <code>BertModel</code>) e um que é adequado para classificação de imagem
(como <code>BertForSequenceClassification</code>).`,_s,ae,Dt=`Como mencionamos antes, escreveremos apenas um wrapper solto do modelo para mantê-lo simples para este exemplo. A única
coisa que precisamos fazer antes de escrever esta classe é um mapa entre os tipos de bloco e as classes de bloco reais. Então o
modelo é definido a partir da configuração passando tudo para a classe <code>ResNet</code>:`,Zs,oe,As,ne,Kt="Para o modelo que irá classificar as imagens, vamos apenas alterar o método forward:",$s,ie,ks,re,Ot=`Em ambos os casos, observe como herdamos de <code>PreTrainedModel</code> e chamamos a inicialização da superclasse com o <code>config</code>
(um pouco parecido quando você escreve um <code>torch.nn.Module</code>). A linha que define o <code>config_class</code> não é obrigatória, a menos que
você deseje registrar seu modelo com as classes automáticas (consulte a última seção).`,Ns,N,Bs,de,el=`Você pode fazer com que seu modelo retorne o que você quiser,porém retornando um dicionário como fizemos para
<code>ResnetModelForImageClassification</code>, com a função de perda incluída quando os rótulos são passados, vai tornar seu modelo diretamente
utilizável dentro da classe <code>Trainer</code>. Você pode usar outro formato de saída, desde que esteja planejando usar seu próprio
laço de treinamento ou outra biblioteca para treinamento.`,Rs,me,sl="Agora que temos nossa classe do modelo, vamos criar uma:",Ws,ce,xs,pe,tl=`Novamente, você pode usar qualquer um dos métodos do <code>PreTrainedModel</code>, como <code>save_pretrained()</code> ou
<code>push_to_hub()</code>. Usaremos o segundo na próxima seção e veremos como enviar os pesos e
o código do nosso modelo. Mas primeiro, vamos carregar alguns pesos pré-treinados dentro do nosso modelo.`,Xs,ue,ll=`Em seu próprio caso de uso, você provavelmente estará treinando seu modelo customizado em seus próprios dados. Para este tutorial ser rápido,
usaremos a versão pré-treinada do resnet50d. Como nosso modelo é apenas um wrapper em torno dele, será
fácil de transferir esses pesos:`,zs,Me,Es,ye,al=`Agora vamos ver como ter certeza de que quando fazemos <code>save_pretrained()</code> ou <code>push_to_hub()</code>, o
código do modelo é salvo.`,qs,I,B,as,fe,At,De,ol="Enviando o código para o Hub",Vs,R,Gs,we,nl=`Primeiro, certifique-se de que seu modelo esteja totalmente definido em um arquivo <code>.py</code>. Ele pode contar com importações relativas para alguns outros arquivos
desde que todos os arquivos estejam no mesmo diretório (ainda não suportamos submódulos para este recurso). Para o nosso exemplo,
vamos definir um arquivo <code>modeling_resnet.py</code> e um arquivo <code>configuration_resnet.py</code> em uma pasta no
diretório de trabalho atual chamado <code>resnet_model</code>. O arquivo de configuração contém o código para <code>ResnetConfig</code> e o arquivo de modelagem
contém o código do <code>ResnetModel</code> e <code>ResnetModelForImageClassification</code>.`,Ys,Je,Qs,Te,il="O <code>__init__.py</code> pode estar vazio, apenas está lá para que o Python detecte que o <code>resnet_model</code> possa ser usado como um módulo.",Hs,W,Fs,je,rl="Observe que você pode reutilizar (ou subclasse) uma configuração/modelo existente.",Ss,Ue,dl=`Para compartilhar seu modelo com a comunidade, siga estas etapas: primeiro importe o modelo ResNet e a configuração do
arquivos criados:`,Ps,be,Ls,Ce,ml=`Então você tem que dizer à biblioteca que deseja copiar os arquivos de código desses objetos ao usar o <code>save_pretrained</code>
e registrá-los corretamente com uma determinada classe automáticas (especialmente para modelos), basta executar:`,Ds,he,Ks,ve,cl=`Observe que não há necessidade de especificar uma classe automática para a configuração (há apenas uma classe automática,
<code>AutoConfig</code>), mas é diferente para os modelos. Seu modelo customizado pode ser adequado para muitas tarefas diferentes, então você
tem que especificar qual das classes automáticas é a correta para o seu modelo.`,Os,Ie,pl="Em seguida, vamos criar a configuração e os modelos como fizemos antes:",et,ge,st,_e,ul="Agora para enviar o modelo para o Hub, certifique-se de estar logado. Ou execute no seu terminal:",tt,Ze,lt,Ae,Ml="ou a partir do notebook:",at,$e,ot,ke,yl="Você pode então enviar para seu próprio namespace (ou uma organização da qual você é membro) assim:",nt,Ne,it,Be,fl=`Além dos pesos do modelo e da configuração no formato json, isso também copiou o modelo e
configuração <code>.py</code> na pasta <code>custom-resnet50d</code> e carregou o resultado para o Hub. Você pode conferir o resultado
neste <a href="https://huggingface.co/sgugger/custom-resnet50d" rel="nofollow">repositório de modelos</a>.`,rt,Re,wl='Consulte o <a href="model_sharing">tutorial de compartilhamento</a> para obter mais informações sobre o método push_to_hub.',dt,g,x,os,We,$t,Ke,Jl="Usando um modelo com código customizado",mt,xe,Tl=`Você pode usar qualquer configuração, modelo ou tokenizador com arquivos de código customizados em seu repositório com as classes automáticas e
o método <code>from_pretrained</code>. Todos os arquivos e códigos carregados no Hub são verificados quanto a malware (consulte a documentação de <a href="https://huggingface.co/docs/hub/security#malware-scanning" rel="nofollow">Segurança do Hub</a> para obter mais informações), mas você ainda deve
revisar o código do modelo e o autor para evitar a execução de código malicioso em sua máquina. Defina <code>trust_remote_code=True</code> para usar
um modelo com código customizado:`,ct,Xe,pt,ze,jl=`Também é fortemente recomendado passar um hash de confirmação como uma <code>revisão</code> para garantir que o autor dos modelos não
atualize o código com novas linhas maliciosas (a menos que você confie totalmente nos autores dos modelos).`,ut,Ee,Mt,qe,Ul=`Observe que ao navegar no histórico de commits do repositório do modelo no Hub, há um botão para copiar facilmente o commit
hash de qualquer commit.`,yt,_,X,ns,Ve,kt,Oe,bl="Registrando um modelo com código customizado para as classes automáticas",ft,Ge,Cl=`Se você estiver escrevendo uma biblioteca que estende 🤗 Transformers, talvez queira estender as classes automáticas para incluir seus próprios
modelos. Isso é diferente de enviar o código para o Hub no sentido de que os usuários precisarão importar sua biblioteca para
obter os modelos customizados (ao contrário de baixar automaticamente o código do modelo do Hub).`,wt,Ye,hl=`Desde que sua configuração tenha um atributo <code>model_type</code> diferente dos tipos de modelo existentes e que as classes do seu modelo
tenha os atributos <code>config_class</code> corretos, você pode simplesmente adicioná-los às classes automáticas assim:`,Jt,Qe,Tt,He,vl=`Observe que o primeiro argumento usado ao registrar sua configuração customizada para <code>AutoConfig</code> precisa corresponder ao <code>model_type</code>
de sua configuração customizada. E o primeiro argumento usado ao registrar seus modelos customizados, para qualquer necessidade de classe de modelo automático
deve corresponder ao <code>config_class</code> desses modelos.`,jt,is,Ut;return z=new es({}),G=new es({}),H=new j({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PretrainedConfig
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetConfig</span>(<span class="hljs-title class_ inherited__">PretrainedConfig</span>):
    model_type = <span class="hljs-string">&quot;resnet&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">
        self,
        block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>,
        layers: <span class="hljs-type">List</span>[<span class="hljs-built_in">int</span>] = [<span class="hljs-number">3</span>, <span class="hljs-number">4</span>, <span class="hljs-number">6</span>, <span class="hljs-number">3</span>],
        num_classes: <span class="hljs-built_in">int</span> = <span class="hljs-number">1000</span>,
        input_channels: <span class="hljs-built_in">int</span> = <span class="hljs-number">3</span>,
        cardinality: <span class="hljs-built_in">int</span> = <span class="hljs-number">1</span>,
        base_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_width: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span>,
        stem_type: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;&quot;</span>,
        avg_down: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">False</span>,
        **kwargs,
    </span>):
        <span class="hljs-keyword">if</span> block_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;basic&quot;</span>, <span class="hljs-string">&quot;bottleneck&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`block_type\` must be &#x27;basic&#x27; or bottleneck&#x27;, got <span class="hljs-subst">{block_type}</span>.&quot;</span>)
        <span class="hljs-keyword">if</span> stem_type <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;&quot;</span>, <span class="hljs-string">&quot;deep&quot;</span>, <span class="hljs-string">&quot;deep-tiered&quot;</span>]:
            <span class="hljs-keyword">raise</span> ValueError(<span class="hljs-string">f&quot;\`stem_type\` must be &#x27;&#x27;, &#x27;deep&#x27; or &#x27;deep-tiered&#x27;, got <span class="hljs-subst">{stem_type}</span>.&quot;</span>)

        self.block_type = block_type
        self.layers = layers
        self.num_classes = num_classes
        self.input_channels = input_channels
        self.cardinality = cardinality
        self.base_width = base_width
        self.stem_width = stem_width
        self.stem_type = stem_type
        self.avg_down = avg_down
        <span class="hljs-built_in">super</span>().__init__(**kwargs)`,wrap:!1}}),K=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkX2NvbmZpZy5zYXZlX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d_config.save_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)`,wrap:!1}}),ee=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyY3VzdG9tLXJlc25ldCUyMik=",highlighted:'resnet50d_config = ResnetConfig.from_pretrained(<span class="hljs-string">&quot;custom-resnet&quot;</span>)',wrap:!1}}),te=new es({}),oe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFByZVRyYWluZWRNb2RlbCUwQWZyb20lMjB0aW1tLm1vZGVscy5yZXNuZXQlMjBpbXBvcnQlMjBCYXNpY0Jsb2NrJTJDJTIwQm90dGxlbmVjayUyQyUyMFJlc05ldCUwQWZyb20lMjAuY29uZmlndXJhdGlvbl9yZXNuZXQlMjBpbXBvcnQlMjBSZXNuZXRDb25maWclMEElMEElMEFCTE9DS19NQVBQSU5HJTIwJTNEJTIwJTdCJTIyYmFzaWMlMjIlM0ElMjBCYXNpY0Jsb2NrJTJDJTIwJTIyYm90dGxlbmVjayUyMiUzQSUyMEJvdHRsZW5lY2slN0QlMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsKFByZVRyYWluZWRNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBSZXNuZXRDb25maWclMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJsb2NrX2xheWVyJTIwJTNEJTIwQkxPQ0tfTUFQUElORyU1QmNvbmZpZy5ibG9ja190eXBlJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5tb2RlbCUyMCUzRCUyMFJlc05ldCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNvbmZpZy5sYXllcnMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fY2xhc3NlcyUzRGNvbmZpZy5udW1fY2xhc3NlcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5zJTNEY29uZmlnLmlucHV0X2NoYW5uZWxzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FyZGluYWxpdHklM0Rjb25maWcuY2FyZGluYWxpdHklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXNlX3dpZHRoJTNEY29uZmlnLmJhc2Vfd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3dpZHRoJTNEY29uZmlnLnN0ZW1fd2lkdGglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdGVtX3R5cGUlM0Rjb25maWcuc3RlbV90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXZnX2Rvd24lM0Rjb25maWcuYXZnX2Rvd24lMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZChzZWxmJTJDJTIwdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYubW9kZWwuZm9yd2FyZF9mZWF0dXJlcyh0ZW5zb3Ip",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PreTrainedModel
<span class="hljs-keyword">from</span> timm.models.resnet <span class="hljs-keyword">import</span> BasicBlock, Bottleneck, ResNet
<span class="hljs-keyword">from</span> .configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig


BLOCK_MAPPING = {<span class="hljs-string">&quot;basic&quot;</span>: BasicBlock, <span class="hljs-string">&quot;bottleneck&quot;</span>: Bottleneck}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModel</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor</span>):
        <span class="hljs-keyword">return</span> self.model.forward_features(tensor)`,wrap:!1}}),ie=new j({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEFjbGFzcyUyMFJlc25ldE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbihQcmVUcmFpbmVkTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwY29uZmlnX2NsYXNzJTIwJTNEJTIwUmVzbmV0Q29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19pbml0X18oc2VsZiUyQyUyMGNvbmZpZyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdXBlcigpLl9faW5pdF9fKGNvbmZpZyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBibG9ja19sYXllciUyMCUzRCUyMEJMT0NLX01BUFBJTkclNUJjb25maWcuYmxvY2tfdHlwZSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubW9kZWwlMjAlM0QlMjBSZXNOZXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfbGF5ZXIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjb25maWcubGF5ZXJzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2NsYXNzZXMlM0Rjb25maWcubnVtX2NsYXNzZXMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbl9jaGFucyUzRGNvbmZpZy5pbnB1dF9jaGFubmVscyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhcmRpbmFsaXR5JTNEY29uZmlnLmNhcmRpbmFsaXR5JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmFzZV93aWR0aCUzRGNvbmZpZy5iYXNlX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV93aWR0aCUzRGNvbmZpZy5zdGVtX3dpZHRoJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RlbV90eXBlJTNEY29uZmlnLnN0ZW1fdHlwZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2Z19kb3duJTNEY29uZmlnLmF2Z19kb3duJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGZvcndhcmQoc2VsZiUyQyUyMHRlbnNvciUyQyUyMGxhYmVscyUzRE5vbmUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwc2VsZi5tb2RlbCh0ZW5zb3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsYWJlbHMlMjBpcyUyMG5vdCUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwdG9yY2gubm4uY3Jvc3NfZW50cm9weShsb2dpdHMlMkMlMjBsYWJlbHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybG9zcyUyMiUzQSUyMGxvc3MlMkMlMjAlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAlN0IlMjJsb2dpdHMlMjIlM0ElMjBsb2dpdHMlN0Q=",highlighted:`<span class="hljs-keyword">import</span> torch


<span class="hljs-keyword">class</span> <span class="hljs-title class_">ResnetModelForImageClassification</span>(<span class="hljs-title class_ inherited__">PreTrainedModel</span>):
    config_class = ResnetConfig

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        block_layer = BLOCK_MAPPING[config.block_type]
        self.model = ResNet(
            block_layer,
            config.layers,
            num_classes=config.num_classes,
            in_chans=config.input_channels,
            cardinality=config.cardinality,
            base_width=config.base_width,
            stem_width=config.stem_width,
            stem_type=config.stem_type,
            avg_down=config.avg_down,
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, tensor, labels=<span class="hljs-literal">None</span></span>):
        logits = self.model(tensor)
        <span class="hljs-keyword">if</span> labels <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            loss = torch.nn.cross_entropy(logits, labels)
            <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;loss&quot;</span>: loss, <span class="hljs-string">&quot;logits&quot;</span>: logits}
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),N=new Nt({props:{$$slots:{default:[ql]},$$scope:{ctx:Z}}}),ce=new j({props:{code:"cmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcp",highlighted:"resnet50d = ResnetModelForImageClassification(resnet50d_config)",wrap:!1}}),Me=new j({props:{code:"aW1wb3J0JTIwdGltbSUwQSUwQXByZXRyYWluZWRfbW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFyZXNuZXQ1MGQubW9kZWwubG9hZF9zdGF0ZV9kaWN0KHByZXRyYWluZWRfbW9kZWwuc3RhdGVfZGljdCgpKQ==",highlighted:`<span class="hljs-keyword">import</span> timm

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),fe=new es({}),R=new Nt({props:{warning:!0,$$slots:{default:[Vl]},$$scope:{ctx:Z}}}),Je=new j({props:{code:"LiUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHJlc25ldF9tb2RlbCUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlndXJhdGlvbl9yZXNuZXQucHklMEElMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtb2RlbGluZ19yZXNuZXQucHk=",highlighted:`.
└── resnet_model
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── configuration_resnet.<span class="hljs-keyword">py</span>
    └── modeling_resnet.<span class="hljs-keyword">py</span>`,wrap:!1}}),W=new Nt({props:{warning:!0,$$slots:{default:[Gl]},$$scope:{ctx:Z}}}),be=new j({props:{code:"ZnJvbSUyMHJlc25ldF9tb2RlbC5jb25maWd1cmF0aW9uX3Jlc25ldCUyMGltcG9ydCUyMFJlc25ldENvbmZpZyUwQWZyb20lMjByZXNuZXRfbW9kZWwubW9kZWxpbmdfcmVzbmV0JTIwaW1wb3J0JTIwUmVzbmV0TW9kZWwlMkMlMjBSZXNuZXRNb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24=",highlighted:`<span class="hljs-keyword">from</span> resnet_model.configuration_resnet <span class="hljs-keyword">import</span> ResnetConfig
<span class="hljs-keyword">from</span> resnet_model.modeling_resnet <span class="hljs-keyword">import</span> ResnetModel, ResnetModelForImageClassification`,wrap:!1}}),he=new j({props:{code:"UmVzbmV0Q29uZmlnLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCklMEFSZXNuZXRNb2RlbC5yZWdpc3Rlcl9mb3JfYXV0b19jbGFzcyglMjJBdXRvTW9kZWwlMjIpJTBBUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLnJlZ2lzdGVyX2Zvcl9hdXRvX2NsYXNzKCUyMkF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMjIp",highlighted:`ResnetConfig.register_for_auto_class()
ResnetModel.register_for_auto_class(<span class="hljs-string">&quot;AutoModel&quot;</span>)
ResnetModelForImageClassification.register_for_auto_class(<span class="hljs-string">&quot;AutoModelForImageClassification&quot;</span>)`,wrap:!1}}),ge=new j({props:{code:"cmVzbmV0NTBkX2NvbmZpZyUyMCUzRCUyMFJlc25ldENvbmZpZyhibG9ja190eXBlJTNEJTIyYm90dGxlbmVjayUyMiUyQyUyMHN0ZW1fd2lkdGglM0QzMiUyQyUyMHN0ZW1fdHlwZSUzRCUyMmRlZXAlMjIlMkMlMjBhdmdfZG93biUzRFRydWUpJTBBcmVzbmV0NTBkJTIwJTNEJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKHJlc25ldDUwZF9jb25maWcpJTBBJTBBcHJldHJhaW5lZF9tb2RlbCUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXJlc25ldDUwZC5tb2RlbC5sb2FkX3N0YXRlX2RpY3QocHJldHJhaW5lZF9tb2RlbC5zdGF0ZV9kaWN0KCkp",highlighted:`resnet50d_config = ResnetConfig(block_type=<span class="hljs-string">&quot;bottleneck&quot;</span>, stem_width=<span class="hljs-number">32</span>, stem_type=<span class="hljs-string">&quot;deep&quot;</span>, avg_down=<span class="hljs-literal">True</span>)
resnet50d = ResnetModelForImageClassification(resnet50d_config)

pretrained_model = timm.create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>)
resnet50d.model.load_state_dict(pretrained_model.state_dict())`,wrap:!1}}),Ze=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),$e=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),Ne=new j({props:{code:"cmVzbmV0NTBkLnB1c2hfdG9faHViKCUyMmN1c3RvbS1yZXNuZXQ1MGQlMjIp",highlighted:'resnet50d.push_to_hub(<span class="hljs-string">&quot;custom-resnet50d&quot;</span>)',wrap:!1}}),We=new es({}),Xe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMnNndWdnZXIlMkZjdXN0b20tcmVzbmV0NTBkJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageClassification

model = AutoModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ee=new j({props:{code:"Y29tbWl0X2hhc2glMjAlM0QlMjAlMjJlZDk0YTdjNjI0N2Q4YWVkY2U0NjQ3ZjAwZjIwZGU2ODc1YjViMjkyJTIyJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzZ3VnZ2VyJTJGY3VzdG9tLXJlc25ldDUwZCUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSUyQyUyMHJldmlzaW9uJTNEY29tbWl0X2hhc2glMEEp",highlighted:`commit_hash = <span class="hljs-string">&quot;ed94a7c6247d8aedce4647f00f20de6875b5b292&quot;</span>
model = AutoModelForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;sgugger/custom-resnet50d&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>, revision=commit_hash
)`,wrap:!1}}),Ve=new es({}),Qe=new j({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBBdXRvTW9kZWwlMkMlMjBBdXRvTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBQXV0b0NvbmZpZy5yZWdpc3RlciglMjJyZXNuZXQlMjIlMkMlMjBSZXNuZXRDb25maWcpJTBBQXV0b01vZGVsLnJlZ2lzdGVyKFJlc25ldENvbmZpZyUyQyUyMFJlc25ldE1vZGVsKSUwQUF1dG9Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24ucmVnaXN0ZXIoUmVzbmV0Q29uZmlnJTJDJTIwUmVzbmV0TW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, AutoModel, AutoModelForImageClassification

AutoConfig.register(<span class="hljs-string">&quot;resnet&quot;</span>, ResnetConfig)
AutoModel.register(ResnetConfig, ResnetModel)
AutoModelForImageClassification.register(ResnetConfig, ResnetModelForImageClassification)`,wrap:!1}}),{c(){d=n("meta"),U=a(),J=n("p"),b=a(),C=n("h1"),A=n("a"),ss=n("span"),m(z.$$.fragment),gt=a(),Se=n("span"),Se.textContent=Rt,ms=a(),E=n("p"),E.textContent=Wt,cs=a(),q=n("p"),q.textContent=xt,ps=a(),V=n("p"),V.innerHTML=Xt,us=a(),h=n("h2"),$=n("a"),ts=n("span"),m(G.$$.fragment),_t=a(),Pe=n("span"),Pe.textContent=zt,Ms=a(),Y=n("p"),Y.innerHTML=Et,ys=a(),Q=n("p"),Q.textContent=qt,fs=a(),m(H.$$.fragment),ws=a(),F=n("p"),F.textContent=Vt,Js=a(),S=n("ul"),S.innerHTML=Gt,Ts=a(),P=n("p"),P.innerHTML=Yt,js=a(),L=n("p"),L.innerHTML=Qt,Us=a(),D=n("p"),D.textContent=Ht,bs=a(),m(K.$$.fragment),Cs=a(),O=n("p"),O.innerHTML=Ft,hs=a(),m(ee.$$.fragment),vs=a(),se=n("p"),se.innerHTML=St,Is=a(),v=n("h2"),k=n("a"),ls=n("span"),m(te.$$.fragment),Zt=a(),Le=n("span"),Le.textContent=Pt,gs=a(),le=n("p"),le.innerHTML=Lt,_s=a(),ae=n("p"),ae.innerHTML=Dt,Zs=a(),m(oe.$$.fragment),As=a(),ne=n("p"),ne.textContent=Kt,$s=a(),m(ie.$$.fragment),ks=a(),re=n("p"),re.innerHTML=Ot,Ns=a(),m(N.$$.fragment),Bs=a(),de=n("p"),de.innerHTML=el,Rs=a(),me=n("p"),me.textContent=sl,Ws=a(),m(ce.$$.fragment),xs=a(),pe=n("p"),pe.innerHTML=tl,Xs=a(),ue=n("p"),ue.textContent=ll,zs=a(),m(Me.$$.fragment),Es=a(),ye=n("p"),ye.innerHTML=al,qs=a(),I=n("h2"),B=n("a"),as=n("span"),m(fe.$$.fragment),At=a(),De=n("span"),De.textContent=ol,Vs=a(),m(R.$$.fragment),Gs=a(),we=n("p"),we.innerHTML=nl,Ys=a(),m(Je.$$.fragment),Qs=a(),Te=n("p"),Te.innerHTML=il,Hs=a(),m(W.$$.fragment),Fs=a(),je=n("p"),je.textContent=rl,Ss=a(),Ue=n("p"),Ue.textContent=dl,Ps=a(),m(be.$$.fragment),Ls=a(),Ce=n("p"),Ce.innerHTML=ml,Ds=a(),m(he.$$.fragment),Ks=a(),ve=n("p"),ve.innerHTML=cl,Os=a(),Ie=n("p"),Ie.textContent=pl,et=a(),m(ge.$$.fragment),st=a(),_e=n("p"),_e.textContent=ul,tt=a(),m(Ze.$$.fragment),lt=a(),Ae=n("p"),Ae.textContent=Ml,at=a(),m($e.$$.fragment),ot=a(),ke=n("p"),ke.textContent=yl,nt=a(),m(Ne.$$.fragment),it=a(),Be=n("p"),Be.innerHTML=fl,rt=a(),Re=n("p"),Re.innerHTML=wl,dt=a(),g=n("h2"),x=n("a"),os=n("span"),m(We.$$.fragment),$t=a(),Ke=n("span"),Ke.textContent=Jl,mt=a(),xe=n("p"),xe.innerHTML=Tl,ct=a(),m(Xe.$$.fragment),pt=a(),ze=n("p"),ze.innerHTML=jl,ut=a(),m(Ee.$$.fragment),Mt=a(),qe=n("p"),qe.textContent=Ul,yt=a(),_=n("h2"),X=n("a"),ns=n("span"),m(Ve.$$.fragment),kt=a(),Oe=n("span"),Oe.textContent=bl,ft=a(),Ge=n("p"),Ge.textContent=Cl,wt=a(),Ye=n("p"),Ye.innerHTML=hl,Jt=a(),m(Qe.$$.fragment),Tt=a(),He=n("p"),He.innerHTML=vl,jt=a(),is=n("p"),this.h()},l(e){const s=El("svelte-1phssyn",document.head);d=i(s,"META",{name:!0,content:!0}),s.forEach(t),U=o(e),J=i(e,"P",{}),T(J).forEach(t),b=o(e),C=i(e,"H1",{class:!0});var Fe=T(C);A=i(Fe,"A",{id:!0,class:!0,href:!0});var rs=T(A);ss=i(rs,"SPAN",{});var ds=T(ss);c(z.$$.fragment,ds),ds.forEach(t),rs.forEach(t),gt=o(Fe),Se=i(Fe,"SPAN",{"data-svelte-h":!0}),r(Se)!=="svelte-2acasm"&&(Se.textContent=Rt),Fe.forEach(t),ms=o(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-odiyj7"&&(E.textContent=Wt),cs=o(e),q=i(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1o4wy9k"&&(q.textContent=xt),ps=o(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tgk9jt"&&(V.innerHTML=Xt),us=o(e),h=i(e,"H2",{class:!0});var bt=T(h);$=i(bt,"A",{id:!0,class:!0,href:!0});var Il=T($);ts=i(Il,"SPAN",{});var gl=T(ts);c(G.$$.fragment,gl),gl.forEach(t),Il.forEach(t),_t=o(bt),Pe=i(bt,"SPAN",{"data-svelte-h":!0}),r(Pe)!=="svelte-1hdc0vv"&&(Pe.textContent=zt),bt.forEach(t),Ms=o(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-n7s4gj"&&(Y.innerHTML=Et),ys=o(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1u9z9q5"&&(Q.textContent=qt),fs=o(e),c(H.$$.fragment,e),ws=o(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-195qvkc"&&(F.textContent=Vt),Js=o(e),S=i(e,"UL",{"data-svelte-h":!0}),r(S)!=="svelte-150dyji"&&(S.innerHTML=Gt),Ts=o(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-n05z3r"&&(P.innerHTML=Yt),js=o(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n89pvb"&&(L.innerHTML=Qt),Us=o(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1kfbx3q"&&(D.textContent=Ht),bs=o(e),c(K.$$.fragment,e),Cs=o(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1fiw1ms"&&(O.innerHTML=Ft),hs=o(e),c(ee.$$.fragment,e),vs=o(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1xlg64w"&&(se.innerHTML=St),Is=o(e),v=i(e,"H2",{class:!0});var Ct=T(v);k=i(Ct,"A",{id:!0,class:!0,href:!0});var _l=T(k);ls=i(_l,"SPAN",{});var Zl=T(ls);c(te.$$.fragment,Zl),Zl.forEach(t),_l.forEach(t),Zt=o(Ct),Le=i(Ct,"SPAN",{"data-svelte-h":!0}),r(Le)!=="svelte-ni19d7"&&(Le.textContent=Pt),Ct.forEach(t),gs=o(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1y2nbkn"&&(le.innerHTML=Lt),_s=o(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-cr4a22"&&(ae.innerHTML=Dt),Zs=o(e),c(oe.$$.fragment,e),As=o(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-10i1rll"&&(ne.textContent=Kt),$s=o(e),c(ie.$$.fragment,e),ks=o(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1harvsn"&&(re.innerHTML=Ot),Ns=o(e),c(N.$$.fragment,e),Bs=o(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-z9klot"&&(de.innerHTML=el),Rs=o(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-9hgxrt"&&(me.textContent=sl),Ws=o(e),c(ce.$$.fragment,e),xs=o(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-1jg8tw5"&&(pe.innerHTML=tl),Xs=o(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-hmddx9"&&(ue.textContent=ll),zs=o(e),c(Me.$$.fragment,e),Es=o(e),ye=i(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1665ct6"&&(ye.innerHTML=al),qs=o(e),I=i(e,"H2",{class:!0});var ht=T(I);B=i(ht,"A",{id:!0,class:!0,href:!0});var Al=T(B);as=i(Al,"SPAN",{});var $l=T(as);c(fe.$$.fragment,$l),$l.forEach(t),Al.forEach(t),At=o(ht),De=i(ht,"SPAN",{"data-svelte-h":!0}),r(De)!=="svelte-xak6px"&&(De.textContent=ol),ht.forEach(t),Vs=o(e),c(R.$$.fragment,e),Gs=o(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-el90vp"&&(we.innerHTML=nl),Ys=o(e),c(Je.$$.fragment,e),Qs=o(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-zqclvb"&&(Te.innerHTML=il),Hs=o(e),c(W.$$.fragment,e),Fs=o(e),je=i(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-m6y568"&&(je.textContent=rl),Ss=o(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-qtwbi0"&&(Ue.textContent=dl),Ps=o(e),c(be.$$.fragment,e),Ls=o(e),Ce=i(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-ox5gse"&&(Ce.innerHTML=ml),Ds=o(e),c(he.$$.fragment,e),Ks=o(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-ymh6m7"&&(ve.innerHTML=cl),Os=o(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1383i6p"&&(Ie.textContent=pl),et=o(e),c(ge.$$.fragment,e),st=o(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-j2swg9"&&(_e.textContent=ul),tt=o(e),c(Ze.$$.fragment,e),lt=o(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-19mmy5v"&&(Ae.textContent=Ml),at=o(e),c($e.$$.fragment,e),ot=o(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-i7vys3"&&(ke.textContent=yl),nt=o(e),c(Ne.$$.fragment,e),it=o(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-o997h4"&&(Be.innerHTML=fl),rt=o(e),Re=i(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1z72sv"&&(Re.innerHTML=wl),dt=o(e),g=i(e,"H2",{class:!0});var vt=T(g);x=i(vt,"A",{id:!0,class:!0,href:!0});var kl=T(x);os=i(kl,"SPAN",{});var Nl=T(os);c(We.$$.fragment,Nl),Nl.forEach(t),kl.forEach(t),$t=o(vt),Ke=i(vt,"SPAN",{"data-svelte-h":!0}),r(Ke)!=="svelte-lyrzob"&&(Ke.textContent=Jl),vt.forEach(t),mt=o(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-qgau1t"&&(xe.innerHTML=Tl),ct=o(e),c(Xe.$$.fragment,e),pt=o(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-wb5hdk"&&(ze.innerHTML=jl),ut=o(e),c(Ee.$$.fragment,e),Mt=o(e),qe=i(e,"P",{"data-svelte-h":!0}),r(qe)!=="svelte-a3oim0"&&(qe.textContent=Ul),yt=o(e),_=i(e,"H2",{class:!0});var It=T(_);X=i(It,"A",{id:!0,class:!0,href:!0});var Bl=T(X);ns=i(Bl,"SPAN",{});var Rl=T(ns);c(Ve.$$.fragment,Rl),Rl.forEach(t),Bl.forEach(t),kt=o(It),Oe=i(It,"SPAN",{"data-svelte-h":!0}),r(Oe)!=="svelte-105r0q"&&(Oe.textContent=bl),It.forEach(t),ft=o(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1w5mftt"&&(Ge.textContent=Cl),wt=o(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-43b6sj"&&(Ye.innerHTML=hl),Jt=o(e),c(Qe.$$.fragment,e),Tt=o(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-quvwuu"&&(He.innerHTML=vl),jt=o(e),is=i(e,"P",{}),T(is).forEach(t),this.h()},h(){p(d,"name","hf:doc:metadata"),p(d,"content",JSON.stringify(Ql)),p(A,"id","compartilhando-modelos-customizados"),p(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(A,"href","#compartilhando-modelos-customizados"),p(C,"class","relative group"),p($,"id","escrevendo-uma-configurao-customizada"),p($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p($,"href","#escrevendo-uma-configurao-customizada"),p(h,"class","relative group"),p(k,"id","escrevendo-um-modelo-customizado"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#escrevendo-um-modelo-customizado"),p(v,"class","relative group"),p(B,"id","enviando-o-cdigo-para-o-hub"),p(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(B,"href","#enviando-o-cdigo-para-o-hub"),p(I,"class","relative group"),p(x,"id","usando-um-modelo-com-cdigo-customizado"),p(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(x,"href","#usando-um-modelo-com-cdigo-customizado"),p(g,"class","relative group"),p(X,"id","registrando-um-modelo-com-cdigo-customizado-para-as-classes-automticas"),p(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(X,"href","#registrando-um-modelo-com-cdigo-customizado-para-as-classes-automticas"),p(_,"class","relative group")},m(e,s){w(document.head,d),l(e,U,s),l(e,J,s),l(e,b,s),l(e,C,s),w(C,A),w(A,ss),u(z,ss,null),w(C,gt),w(C,Se),l(e,ms,s),l(e,E,s),l(e,cs,s),l(e,q,s),l(e,ps,s),l(e,V,s),l(e,us,s),l(e,h,s),w(h,$),w($,ts),u(G,ts,null),w(h,_t),w(h,Pe),l(e,Ms,s),l(e,Y,s),l(e,ys,s),l(e,Q,s),l(e,fs,s),u(H,e,s),l(e,ws,s),l(e,F,s),l(e,Js,s),l(e,S,s),l(e,Ts,s),l(e,P,s),l(e,js,s),l(e,L,s),l(e,Us,s),l(e,D,s),l(e,bs,s),u(K,e,s),l(e,Cs,s),l(e,O,s),l(e,hs,s),u(ee,e,s),l(e,vs,s),l(e,se,s),l(e,Is,s),l(e,v,s),w(v,k),w(k,ls),u(te,ls,null),w(v,Zt),w(v,Le),l(e,gs,s),l(e,le,s),l(e,_s,s),l(e,ae,s),l(e,Zs,s),u(oe,e,s),l(e,As,s),l(e,ne,s),l(e,$s,s),u(ie,e,s),l(e,ks,s),l(e,re,s),l(e,Ns,s),u(N,e,s),l(e,Bs,s),l(e,de,s),l(e,Rs,s),l(e,me,s),l(e,Ws,s),u(ce,e,s),l(e,xs,s),l(e,pe,s),l(e,Xs,s),l(e,ue,s),l(e,zs,s),u(Me,e,s),l(e,Es,s),l(e,ye,s),l(e,qs,s),l(e,I,s),w(I,B),w(B,as),u(fe,as,null),w(I,At),w(I,De),l(e,Vs,s),u(R,e,s),l(e,Gs,s),l(e,we,s),l(e,Ys,s),u(Je,e,s),l(e,Qs,s),l(e,Te,s),l(e,Hs,s),u(W,e,s),l(e,Fs,s),l(e,je,s),l(e,Ss,s),l(e,Ue,s),l(e,Ps,s),u(be,e,s),l(e,Ls,s),l(e,Ce,s),l(e,Ds,s),u(he,e,s),l(e,Ks,s),l(e,ve,s),l(e,Os,s),l(e,Ie,s),l(e,et,s),u(ge,e,s),l(e,st,s),l(e,_e,s),l(e,tt,s),u(Ze,e,s),l(e,lt,s),l(e,Ae,s),l(e,at,s),u($e,e,s),l(e,ot,s),l(e,ke,s),l(e,nt,s),u(Ne,e,s),l(e,it,s),l(e,Be,s),l(e,rt,s),l(e,Re,s),l(e,dt,s),l(e,g,s),w(g,x),w(x,os),u(We,os,null),w(g,$t),w(g,Ke),l(e,mt,s),l(e,xe,s),l(e,ct,s),u(Xe,e,s),l(e,pt,s),l(e,ze,s),l(e,ut,s),u(Ee,e,s),l(e,Mt,s),l(e,qe,s),l(e,yt,s),l(e,_,s),w(_,X),w(X,ns),u(Ve,ns,null),w(_,kt),w(_,Oe),l(e,ft,s),l(e,Ge,s),l(e,wt,s),l(e,Ye,s),l(e,Jt,s),u(Qe,e,s),l(e,Tt,s),l(e,He,s),l(e,jt,s),l(e,is,s),Ut=!0},p(e,[s]){const Fe={};s&2&&(Fe.$$scope={dirty:s,ctx:e}),N.$set(Fe);const rs={};s&2&&(rs.$$scope={dirty:s,ctx:e}),R.$set(rs);const ds={};s&2&&(ds.$$scope={dirty:s,ctx:e}),W.$set(ds)},i(e){Ut||(M(z.$$.fragment,e),M(G.$$.fragment,e),M(H.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(te.$$.fragment,e),M(oe.$$.fragment,e),M(ie.$$.fragment,e),M(N.$$.fragment,e),M(ce.$$.fragment,e),M(Me.$$.fragment,e),M(fe.$$.fragment,e),M(R.$$.fragment,e),M(Je.$$.fragment,e),M(W.$$.fragment,e),M(be.$$.fragment,e),M(he.$$.fragment,e),M(ge.$$.fragment,e),M(Ze.$$.fragment,e),M($e.$$.fragment,e),M(Ne.$$.fragment,e),M(We.$$.fragment,e),M(Xe.$$.fragment,e),M(Ee.$$.fragment,e),M(Ve.$$.fragment,e),M(Qe.$$.fragment,e),Ut=!0)},o(e){y(z.$$.fragment,e),y(G.$$.fragment,e),y(H.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(oe.$$.fragment,e),y(ie.$$.fragment,e),y(N.$$.fragment,e),y(ce.$$.fragment,e),y(Me.$$.fragment,e),y(fe.$$.fragment,e),y(R.$$.fragment,e),y(Je.$$.fragment,e),y(W.$$.fragment,e),y(be.$$.fragment,e),y(he.$$.fragment,e),y(ge.$$.fragment,e),y(Ze.$$.fragment,e),y($e.$$.fragment,e),y(Ne.$$.fragment,e),y(We.$$.fragment,e),y(Xe.$$.fragment,e),y(Ee.$$.fragment,e),y(Ve.$$.fragment,e),y(Qe.$$.fragment,e),Ut=!1},d(e){e&&(t(U),t(J),t(b),t(C),t(ms),t(E),t(cs),t(q),t(ps),t(V),t(us),t(h),t(Ms),t(Y),t(ys),t(Q),t(fs),t(ws),t(F),t(Js),t(S),t(Ts),t(P),t(js),t(L),t(Us),t(D),t(bs),t(Cs),t(O),t(hs),t(vs),t(se),t(Is),t(v),t(gs),t(le),t(_s),t(ae),t(Zs),t(As),t(ne),t($s),t(ks),t(re),t(Ns),t(Bs),t(de),t(Rs),t(me),t(Ws),t(xs),t(pe),t(Xs),t(ue),t(zs),t(Es),t(ye),t(qs),t(I),t(Vs),t(Gs),t(we),t(Ys),t(Qs),t(Te),t(Hs),t(Fs),t(je),t(Ss),t(Ue),t(Ps),t(Ls),t(Ce),t(Ds),t(Ks),t(ve),t(Os),t(Ie),t(et),t(st),t(_e),t(tt),t(lt),t(Ae),t(at),t(ot),t(ke),t(nt),t(it),t(Be),t(rt),t(Re),t(dt),t(g),t(mt),t(xe),t(ct),t(pt),t(ze),t(ut),t(Mt),t(qe),t(yt),t(_),t(ft),t(Ge),t(wt),t(Ye),t(Jt),t(Tt),t(He),t(jt),t(is)),t(d),f(z),f(G),f(H,e),f(K,e),f(ee,e),f(te),f(oe,e),f(ie,e),f(N,e),f(ce,e),f(Me,e),f(fe),f(R,e),f(Je,e),f(W,e),f(be,e),f(he,e),f(ge,e),f(Ze,e),f($e,e),f(Ne,e),f(We),f(Xe,e),f(Ee,e),f(Ve),f(Qe,e)}}}const Ql={local:"compartilhando-modelos-customizados",sections:[{local:"escrevendo-uma-configurao-customizada",title:"Escrevendo uma configuração customizada"},{local:"escrevendo-um-modelo-customizado",title:"Escrevendo um modelo customizado"},{local:"enviando-o-cdigo-para-o-hub",title:"Enviando o código para o Hub"},{local:"usando-um-modelo-com-cdigo-customizado",title:"Usando um modelo com código customizado"},{local:"registrando-um-modelo-com-cdigo-customizado-para-as-classes-automticas",title:"Registrando um modelo com código customizado para as classes automáticas"}],title:"Compartilhando modelos customizados"};function Hl(Z){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends Xl{constructor(d){super(),zl(this,d,Hl,Yl,Wl,{})}}export{Kl as component};
