import{s as Tt,o as kt,n as wt}from"../chunks/scheduler.6062bdaf.js";import{S as Ct,i as Ht,g as i,s as t,r as u,A as Lt,h as o,f as a,c as r,j as I,u as h,x as d,k as $,y as n,a as s,v as l,d as m,t as _,w as b}from"../chunks/index.4bca734e.js";import{T as Mt}from"../chunks/Tip.b9ac1f03.js";import{D as y}from"../chunks/Docstring.ed07512f.js";import{C as Pt}from"../chunks/CodeBlock.fa01571c.js";import{E as jt}from"../chunks/ExampleCodeBlock.823fb173.js";import{H as Fe}from"../chunks/Heading.723dceba.js";function At(_e){let f,M='Check out the <a href="../guides/inference_endpoints">related guide</a> to learn how to use <code>huggingface_hub</code> to manage your Inference Endpoints programmatically.';return{c(){f=i("p"),f.innerHTML=M},l(E){f=o(E,"P",{"data-svelte-h":!0}),d(f)!=="svelte-tmb85g"&&(f.innerHTML=M)},m(E,x){s(E,f,x)},p:wt,d(E){E&&a(f)}}}function qt(_e){let f,M="Example:",E,x,w;return x=new Pt({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQlMEFlbmRwb2ludCUyMCUzRCUyMGdldF9pbmZlcmVuY2VfZW5kcG9pbnQoJTIybXktdGV4dC10by1pbWFnZSUyMiklMEFlbmRwb2ludCUwQSUwQWVuZHBvaW50LnN0YXR1cyUwQWVuZHBvaW50LnVybCUwQSUwQWVuZHBvaW50LmNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiklMEElMEFlbmRwb2ludC5wYXVzZSgpJTBBJTBBZW5kcG9pbnQucmVzdW1lKCklMEFlbmRwb2ludC53YWl0KCklMEFlbmRwb2ludC5jbGllbnQudGV4dF90b19pbWFnZSguLi4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> get_inference_endpoint
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = get_inference_endpoint(<span class="hljs-string">&quot;my-text-to-image&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint
InferenceEndpoint(name=<span class="hljs-string">&#x27;my-text-to-image&#x27;</span>, ...)

<span class="hljs-comment"># Get status</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.status
<span class="hljs-string">&#x27;running&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.url
<span class="hljs-string">&#x27;https://my-text-to-image.region.vendor.endpoints.huggingface.cloud&#x27;</span>

<span class="hljs-comment"># Run inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)

<span class="hljs-comment"># Pause endpoint to save $$$</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.pause()

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># Resume and wait for deployment</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.resume()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.client.text_to_image(...)`,wrap:!1}}),{c(){f=i("p"),f.textContent=M,E=t(),u(x.$$.fragment)},l(v){f=o(v,"P",{"data-svelte-h":!0}),d(f)!=="svelte-11lpom8"&&(f.textContent=M),E=r(v),h(x.$$.fragment,v)},m(v,L){s(v,f,L),s(v,E,L),l(x,v,L),w=!0},p:wt,i(v){w||(m(x.$$.fragment,v),w=!0)},o(v){_(x.$$.fragment,v),w=!1},d(v){v&&(a(f),a(E)),b(x,v)}}}function Dt(_e){let f,M,E,x,w,v,L,Yn='Inference Endpoints provides a secure production solution to easily deploy models on a dedicated and autoscaling infrastructure managed by Hugging Face. An Inference Endpoint is built from a model from the <a href="https://huggingface.co/models" rel="nofollow">Hub</a>. This page is a reference for <code>huggingface_hub</code>’s integration with Inference Endpoints. For more information about the Inference Endpoints product, check out its <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">official documentation</a>.',Ge,V,Oe,O,Xn='Inference Endpoints can be fully managed via API. The endpoints are documented with <a href="https://api.endpoints.huggingface.cloud/" rel="nofollow">Swagger</a>. The <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> class is a simple wrapper built on top on this API.',Be,B,Qe,Q,Jn='A subset of the Inference Endpoint features are implemented in <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>:',Ye,Y,Kn='<li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.get_inference_endpoint">get_inference_endpoint()</a> and <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.list_inference_endpoints">list_inference_endpoints()</a> to get information about your Inference Endpoints</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.create_inference_endpoint">create_inference_endpoint()</a>, <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">update_inference_endpoint()</a> and <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">delete_inference_endpoint()</a> to deploy and manage Inference Endpoints</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">pause_inference_endpoint()</a> and <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">resume_inference_endpoint()</a> to pause and resume an Inference Endpoint</li> <li><a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">scale_to_zero_inference_endpoint()</a> to manually scale an Endpoint to 0 replicas</li>',Xe,X,Je,J,et='The main dataclass is <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a>. It contains information about a deployed <code>InferenceEndpoint</code>, including its configuration and current state. Once deployed, you can run inference on the Endpoint using the  <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.client">InferenceEndpoint.client</a> and <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.async_client">InferenceEndpoint.async_client</a> properties that respectively return an <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> and an <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> object.',Ke,p,K,ln,be,nt="Contains information about a deployed Inference Endpoint.",mn,z,_n,N,ee,bn,ve,tt="Initialize object from raw dictionary.",vn,S,ne,En,Ee,rt="Returns a client to make predictions on this Inference Endpoint.",In,U,te,$n,Ie,at="Returns a client to make predictions on this Inference Endpoint.",xn,T,re,yn,$e,it="Delete the Inference Endpoint.",wn,xe,ot=`This operation is not reversible. If you don’t want to be charged for an Inference Endpoint, it is preferable
to pause it with <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a> or scale it to zero with <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>.`,Tn,ye,ct='This is an alias for <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.delete_inference_endpoint">HfApi.delete_inference_endpoint()</a>.',kn,W,ae,Cn,we,st="Fetch latest information about the Inference Endpoint.",Hn,k,ie,Ln,Te,pt="Pause the Inference Endpoint.",Mn,ke,dt=`A paused Inference Endpoint will not be charged. It can be resumed at any time using <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.
This is different than scaling the Inference Endpoint to zero with <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.scale_to_zero">InferenceEndpoint.scale_to_zero()</a>, which
would be automatically restarted when a request is made to it.`,Pn,Ce,gt=`This is an alias for <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.pause_inference_endpoint">HfApi.pause_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,jn,P,oe,An,He,ft="Resume the Inference Endpoint.",qn,Le,ut=`This is an alias for <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.resume_inference_endpoint">HfApi.resume_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Dn,C,ce,Vn,Me,ht="Scale Inference Endpoint to zero.",zn,Pe,lt=`An Inference Endpoint scaled to zero will not be charged. It will be resume on the next request to it, with a
cold start delay. This is different than pausing the Inference Endpoint with <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.pause">InferenceEndpoint.pause()</a>, which
would require a manual resume with <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint.resume">InferenceEndpoint.resume()</a>.`,Nn,je,mt=`This is an alias for <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.scale_to_zero_inference_endpoint">HfApi.scale_to_zero_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Sn,H,se,Un,Ae,_t="Update the Inference Endpoint.",Wn,qe,bt=`This method allows the update of either the compute configuration, the deployed model, or both. All arguments are
optional but at least one must be provided.`,Rn,De,vt=`This is an alias for <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/hf_api#huggingface_hub.HfApi.update_inference_endpoint">HfApi.update_inference_endpoint()</a>. The current object is mutated in place with the
latest data from the server.`,Fn,j,pe,Zn,Ve,Et="Wait for the Inference Endpoint to be deployed.",Gn,ze,It=`Information from the server will be fetched every 1s. If the Inference Endpoint is not deployed after <code>timeout</code>
seconds, a <code>InferenceEndpointTimeoutError</code> will be raised. The <a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint">InferenceEndpoint</a> will be mutated in place with the latest
data.`,en,de,nn,A,ge,On,Ne,$t="An enumeration.",tn,fe,rn,q,ue,Bn,Se,xt="An enumeration.",an,he,on,D,le,Qn,Ue,yt="Generic exception when dealing with Inference Endpoints.",cn,Ze,sn;return w=new Fe({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),V=new Mt({props:{$$slots:{default:[At]},$$scope:{ctx:_e}}}),B=new Fe({props:{title:"Methods",local:"methods",headingTag:"h2"}}),X=new Fe({props:{title:"InferenceEndpoint",local:"huggingface_hub.InferenceEndpoint",headingTag:"h2"}}),K=new y({props:{name:"class huggingface_hub.InferenceEndpoint",anchor:"huggingface_hub.InferenceEndpoint",parameters:[{name:"namespace",val:": str"},{name:"raw",val:": Dict"},{name:"_token",val:": Union"},{name:"_api",val:": HfApi"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The unique name of the Inference Endpoint.`,name:"name"},{anchor:"huggingface_hub.InferenceEndpoint.namespace",description:`<strong>namespace</strong> (<code>str</code>) &#x2014;
The namespace where the Inference Endpoint is located.`,name:"namespace"},{anchor:"huggingface_hub.InferenceEndpoint.repository",description:`<strong>repository</strong> (<code>str</code>) &#x2014;
The name of the model repository deployed on this Inference Endpoint.`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.status",description:`<strong>status</strong> (<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointStatus">InferenceEndpointStatus</a>) &#x2014;
The current status of the Inference Endpoint.`,name:"status"},{anchor:"huggingface_hub.InferenceEndpoint.url",description:`<strong>url</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The URL of the Inference Endpoint, if available. Only a deployed Inference Endpoint will have a URL.`,name:"url"},{anchor:"huggingface_hub.InferenceEndpoint.framework",description:`<strong>framework</strong> (<code>str</code>) &#x2014;
The machine learning framework used for the model.`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The specific model revision deployed on the Inference Endpoint.`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.task",description:`<strong>task</strong> (<code>str</code>) &#x2014;
The task associated with the deployed model.`,name:"task"},{anchor:"huggingface_hub.InferenceEndpoint.created_at",description:`<strong>created_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp when the Inference Endpoint was created.`,name:"created_at"},{anchor:"huggingface_hub.InferenceEndpoint.updated_at",description:`<strong>updated_at</strong> (<code>datetime.datetime</code>) &#x2014;
The timestamp of the last update of the Inference Endpoint.`,name:"updated_at"},{anchor:"huggingface_hub.InferenceEndpoint.type",description:`<strong>type</strong> (<a href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointType">InferenceEndpointType</a>) &#x2014;
The type of the Inference Endpoint (public, protected, private).`,name:"type"},{anchor:"huggingface_hub.InferenceEndpoint.raw",description:`<strong>raw</strong> (<code>Dict</code>) &#x2014;
The raw dictionary data returned from the API.`,name:"raw"},{anchor:"huggingface_hub.InferenceEndpoint.token",description:`<strong>token</strong> (<code>str</code> or <code>bool</code>, <em>optional</em>) &#x2014;
Authentication token for the Inference Endpoint, if set when requesting the API. Will default to the
locally saved token if not provided. Pass <code>token=False</code> if you don&#x2019;t want to send your token to the server.`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L44"}}),z=new jt({props:{anchor:"huggingface_hub.InferenceEndpoint.example",$$slots:{default:[qt]},$$scope:{ctx:_e}}}),ee=new y({props:{name:"from_raw",anchor:"huggingface_hub.InferenceEndpoint.from_raw",parameters:[{name:"raw",val:": Dict"},{name:"namespace",val:": str"},{name:"token",val:": Union = None"},{name:"api",val:": Optional = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L127"}}),ne=new y({props:{name:"client",anchor:"huggingface_hub.InferenceEndpoint.client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L146",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an inference client pointing to the deployed endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.InferenceClient"
>InferenceClient</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),te=new y({props:{name:"async_client",anchor:"huggingface_hub.InferenceEndpoint.async_client",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L163",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>an asyncio-compatible inference client pointing to the deployed endpoint.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient"
>AsyncInferenceClient</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> — If the Inference Endpoint is not yet deployed.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a></p>
`}}),re=new y({props:{name:"delete",anchor:"huggingface_hub.InferenceEndpoint.delete",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L357"}}),ae=new y({props:{name:"fetch",anchor:"huggingface_hub.InferenceEndpoint.fetch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L228",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ie=new y({props:{name:"pause",anchor:"huggingface_hub.InferenceEndpoint.pause",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),oe=new y({props:{name:"resume",anchor:"huggingface_hub.InferenceEndpoint.resume",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L325",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),ce=new y({props:{name:"scale_to_zero",anchor:"huggingface_hub.InferenceEndpoint.scale_to_zero",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L339",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),se=new y({props:{name:"update",anchor:"huggingface_hub.InferenceEndpoint.update",parameters:[{name:"accelerator",val:": Optional = None"},{name:"instance_size",val:": Optional = None"},{name:"instance_type",val:": Optional = None"},{name:"min_replica",val:": Optional = None"},{name:"max_replica",val:": Optional = None"},{name:"repository",val:": Optional = None"},{name:"framework",val:": Optional = None"},{name:"revision",val:": Optional = None"},{name:"task",val:": Optional = None"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.update.accelerator",description:`<strong>accelerator</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The hardware accelerator to be used for inference (e.g. <code>&quot;cpu&quot;</code>).`,name:"accelerator"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_size",description:`<strong>instance_size</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The size or type of the instance to be used for hosting the model (e.g. <code>&quot;large&quot;</code>).`,name:"instance_size"},{anchor:"huggingface_hub.InferenceEndpoint.update.instance_type",description:`<strong>instance_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The cloud instance type where the Inference Endpoint will be deployed (e.g. <code>&quot;c6i&quot;</code>).`,name:"instance_type"},{anchor:"huggingface_hub.InferenceEndpoint.update.min_replica",description:`<strong>min_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The minimum number of replicas (instances) to keep running for the Inference Endpoint.`,name:"min_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.max_replica",description:`<strong>max_replica</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum number of replicas (instances) to scale to for the Inference Endpoint.`,name:"max_replica"},{anchor:"huggingface_hub.InferenceEndpoint.update.repository",description:`<strong>repository</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The name of the model repository associated with the Inference Endpoint (e.g. <code>&quot;gpt2&quot;</code>).`,name:"repository"},{anchor:"huggingface_hub.InferenceEndpoint.update.framework",description:`<strong>framework</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The machine learning framework used for the model (e.g. <code>&quot;custom&quot;</code>).`,name:"framework"},{anchor:"huggingface_hub.InferenceEndpoint.update.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The specific model revision to deploy on the Inference Endpoint (e.g. <code>&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</code>).`,name:"revision"},{anchor:"huggingface_hub.InferenceEndpoint.update.task",description:`<strong>task</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The task on which to deploy the model (e.g. <code>&quot;text-classification&quot;</code>).`,name:"task"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L239",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`}}),pe=new y({props:{name:"wait",anchor:"huggingface_hub.InferenceEndpoint.wait",parameters:[{name:"timeout",val:": Optional = None"},{name:"refresh_every",val:": int = 5"}],parametersDescription:[{anchor:"huggingface_hub.InferenceEndpoint.wait.timeout",description:`<strong>timeout</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The maximum time to wait for the Inference Endpoint to be deployed, in seconds. If <code>None</code>, will wait
indefinitely.`,name:"timeout"},{anchor:"huggingface_hub.InferenceEndpoint.wait.refresh_every",description:`<strong>refresh_every</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The time to wait between each fetch of the Inference Endpoint status, in seconds. Defaults to 5s.`,name:"refresh_every"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L180",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>the same Inference Endpoint, mutated in place with the latest data.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpoint"
>InferenceEndpoint</a></p>
`,raiseDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<ul>
<li><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> —
If the Inference Endpoint ended up in a failed state.</li>
<li><code>InferenceEndpointTimeoutError</code> —
If the Inference Endpoint is not deployed after <code>timeout</code> seconds.</li>
</ul>
`,raiseType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/huggingface_hub/v0.22.0.rc1/en/package_reference/inference_endpoints#huggingface_hub.InferenceEndpointError"
>InferenceEndpointError</a> or <code>InferenceEndpointTimeoutError</code></p>
`}}),de=new Fe({props:{title:"InferenceEndpointStatus",local:"huggingface_hub.InferenceEndpointStatus",headingTag:"h2"}}),ge=new y({props:{name:"class huggingface_hub.InferenceEndpointStatus",anchor:"huggingface_hub.InferenceEndpointStatus",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L27"}}),fe=new Fe({props:{title:"InferenceEndpointType",local:"huggingface_hub.InferenceEndpointType",headingTag:"h2"}}),ue=new y({props:{name:"class huggingface_hub.InferenceEndpointType",anchor:"huggingface_hub.InferenceEndpointType",parameters:[{name:"value",val:""},{name:"names",val:" = None"},{name:"module",val:" = None"},{name:"qualname",val:" = None"},{name:"type",val:" = None"},{name:"start",val:" = 1"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L38"}}),he=new Fe({props:{title:"InferenceEndpointError",local:"huggingface_hub.InferenceEndpointError",headingTag:"h2"}}),le=new y({props:{name:"class huggingface_hub.InferenceEndpointError",anchor:"huggingface_hub.InferenceEndpointError",parameters:"",source:"https://github.com/huggingface/huggingface_hub/blob/v0.22.0.rc1/src/huggingface_hub/_inference_endpoints.py#L19"}}),{c(){f=i("meta"),M=t(),E=i("p"),x=t(),u(w.$$.fragment),v=t(),L=i("p"),L.innerHTML=Yn,Ge=t(),u(V.$$.fragment),Oe=t(),O=i("p"),O.innerHTML=Xn,Be=t(),u(B.$$.fragment),Qe=t(),Q=i("p"),Q.innerHTML=Jn,Ye=t(),Y=i("ul"),Y.innerHTML=Kn,Xe=t(),u(X.$$.fragment),Je=t(),J=i("p"),J.innerHTML=et,Ke=t(),p=i("div"),u(K.$$.fragment),ln=t(),be=i("p"),be.textContent=nt,mn=t(),u(z.$$.fragment),_n=t(),N=i("div"),u(ee.$$.fragment),bn=t(),ve=i("p"),ve.textContent=tt,vn=t(),S=i("div"),u(ne.$$.fragment),En=t(),Ee=i("p"),Ee.textContent=rt,In=t(),U=i("div"),u(te.$$.fragment),$n=t(),Ie=i("p"),Ie.textContent=at,xn=t(),T=i("div"),u(re.$$.fragment),yn=t(),$e=i("p"),$e.textContent=it,wn=t(),xe=i("p"),xe.innerHTML=ot,Tn=t(),ye=i("p"),ye.innerHTML=ct,kn=t(),W=i("div"),u(ae.$$.fragment),Cn=t(),we=i("p"),we.textContent=st,Hn=t(),k=i("div"),u(ie.$$.fragment),Ln=t(),Te=i("p"),Te.textContent=pt,Mn=t(),ke=i("p"),ke.innerHTML=dt,Pn=t(),Ce=i("p"),Ce.innerHTML=gt,jn=t(),P=i("div"),u(oe.$$.fragment),An=t(),He=i("p"),He.textContent=ft,qn=t(),Le=i("p"),Le.innerHTML=ut,Dn=t(),C=i("div"),u(ce.$$.fragment),Vn=t(),Me=i("p"),Me.textContent=ht,zn=t(),Pe=i("p"),Pe.innerHTML=lt,Nn=t(),je=i("p"),je.innerHTML=mt,Sn=t(),H=i("div"),u(se.$$.fragment),Un=t(),Ae=i("p"),Ae.textContent=_t,Wn=t(),qe=i("p"),qe.textContent=bt,Rn=t(),De=i("p"),De.innerHTML=vt,Fn=t(),j=i("div"),u(pe.$$.fragment),Zn=t(),Ve=i("p"),Ve.textContent=Et,Gn=t(),ze=i("p"),ze.innerHTML=It,en=t(),u(de.$$.fragment),nn=t(),A=i("div"),u(ge.$$.fragment),On=t(),Ne=i("p"),Ne.textContent=$t,tn=t(),u(fe.$$.fragment),rn=t(),q=i("div"),u(ue.$$.fragment),Bn=t(),Se=i("p"),Se.textContent=xt,an=t(),u(he.$$.fragment),on=t(),D=i("div"),u(le.$$.fragment),Qn=t(),Ue=i("p"),Ue.textContent=yt,cn=t(),Ze=i("p"),this.h()},l(e){const c=Lt("svelte-u9bgzb",document.head);f=o(c,"META",{name:!0,content:!0}),c.forEach(a),M=r(e),E=o(e,"P",{}),I(E).forEach(a),x=r(e),h(w.$$.fragment,e),v=r(e),L=o(e,"P",{"data-svelte-h":!0}),d(L)!=="svelte-1bwc3b2"&&(L.innerHTML=Yn),Ge=r(e),h(V.$$.fragment,e),Oe=r(e),O=o(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1j27cv0"&&(O.innerHTML=Xn),Be=r(e),h(B.$$.fragment,e),Qe=r(e),Q=o(e,"P",{"data-svelte-h":!0}),d(Q)!=="svelte-1qzoolq"&&(Q.innerHTML=Jn),Ye=r(e),Y=o(e,"UL",{"data-svelte-h":!0}),d(Y)!=="svelte-1gs5uyc"&&(Y.innerHTML=Kn),Xe=r(e),h(X.$$.fragment,e),Je=r(e),J=o(e,"P",{"data-svelte-h":!0}),d(J)!=="svelte-h6ctjb"&&(J.innerHTML=et),Ke=r(e),p=o(e,"DIV",{class:!0});var g=I(p);h(K.$$.fragment,g),ln=r(g),be=o(g,"P",{"data-svelte-h":!0}),d(be)!=="svelte-1bmjqnv"&&(be.textContent=nt),mn=r(g),h(z.$$.fragment,g),_n=r(g),N=o(g,"DIV",{class:!0});var me=I(N);h(ee.$$.fragment,me),bn=r(me),ve=o(me,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-gljdbx"&&(ve.textContent=tt),me.forEach(a),vn=r(g),S=o(g,"DIV",{class:!0});var pn=I(S);h(ne.$$.fragment,pn),En=r(pn),Ee=o(pn,"P",{"data-svelte-h":!0}),d(Ee)!=="svelte-jw5rtn"&&(Ee.textContent=rt),pn.forEach(a),In=r(g),U=o(g,"DIV",{class:!0});var dn=I(U);h(te.$$.fragment,dn),$n=r(dn),Ie=o(dn,"P",{"data-svelte-h":!0}),d(Ie)!=="svelte-jw5rtn"&&(Ie.textContent=at),dn.forEach(a),xn=r(g),T=o(g,"DIV",{class:!0});var R=I(T);h(re.$$.fragment,R),yn=r(R),$e=o(R,"P",{"data-svelte-h":!0}),d($e)!=="svelte-1awp4uu"&&($e.textContent=it),wn=r(R),xe=o(R,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-1sy6v99"&&(xe.innerHTML=ot),Tn=r(R),ye=o(R,"P",{"data-svelte-h":!0}),d(ye)!=="svelte-1wdfdce"&&(ye.innerHTML=ct),R.forEach(a),kn=r(g),W=o(g,"DIV",{class:!0});var gn=I(W);h(ae.$$.fragment,gn),Cn=r(gn),we=o(gn,"P",{"data-svelte-h":!0}),d(we)!=="svelte-1dh96nb"&&(we.textContent=st),gn.forEach(a),Hn=r(g),k=o(g,"DIV",{class:!0});var F=I(k);h(ie.$$.fragment,F),Ln=r(F),Te=o(F,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1bfttgz"&&(Te.textContent=pt),Mn=r(F),ke=o(F,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-1ynnnsw"&&(ke.innerHTML=dt),Pn=r(F),Ce=o(F,"P",{"data-svelte-h":!0}),d(Ce)!=="svelte-dhds1"&&(Ce.innerHTML=gt),F.forEach(a),jn=r(g),P=o(g,"DIV",{class:!0});var We=I(P);h(oe.$$.fragment,We),An=r(We),He=o(We,"P",{"data-svelte-h":!0}),d(He)!=="svelte-akp3j2"&&(He.textContent=ft),qn=r(We),Le=o(We,"P",{"data-svelte-h":!0}),d(Le)!=="svelte-1qtiht5"&&(Le.innerHTML=ut),We.forEach(a),Dn=r(g),C=o(g,"DIV",{class:!0});var Z=I(C);h(ce.$$.fragment,Z),Vn=r(Z),Me=o(Z,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-6vx93v"&&(Me.textContent=ht),zn=r(Z),Pe=o(Z,"P",{"data-svelte-h":!0}),d(Pe)!=="svelte-qwhtdu"&&(Pe.innerHTML=lt),Nn=r(Z),je=o(Z,"P",{"data-svelte-h":!0}),d(je)!=="svelte-m2fnij"&&(je.innerHTML=mt),Z.forEach(a),Sn=r(g),H=o(g,"DIV",{class:!0});var G=I(H);h(se.$$.fragment,G),Un=r(G),Ae=o(G,"P",{"data-svelte-h":!0}),d(Ae)!=="svelte-16hllis"&&(Ae.textContent=_t),Wn=r(G),qe=o(G,"P",{"data-svelte-h":!0}),d(qe)!=="svelte-llxqqu"&&(qe.textContent=bt),Rn=r(G),De=o(G,"P",{"data-svelte-h":!0}),d(De)!=="svelte-1ogm9h"&&(De.innerHTML=vt),G.forEach(a),Fn=r(g),j=o(g,"DIV",{class:!0});var Re=I(j);h(pe.$$.fragment,Re),Zn=r(Re),Ve=o(Re,"P",{"data-svelte-h":!0}),d(Ve)!=="svelte-15saqtl"&&(Ve.textContent=Et),Gn=r(Re),ze=o(Re,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-q3emlj"&&(ze.innerHTML=It),Re.forEach(a),g.forEach(a),en=r(e),h(de.$$.fragment,e),nn=r(e),A=o(e,"DIV",{class:!0});var fn=I(A);h(ge.$$.fragment,fn),On=r(fn),Ne=o(fn,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-ofujqi"&&(Ne.textContent=$t),fn.forEach(a),tn=r(e),h(fe.$$.fragment,e),rn=r(e),q=o(e,"DIV",{class:!0});var un=I(q);h(ue.$$.fragment,un),Bn=r(un),Se=o(un,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-ofujqi"&&(Se.textContent=xt),un.forEach(a),an=r(e),h(he.$$.fragment,e),on=r(e),D=o(e,"DIV",{class:!0});var hn=I(D);h(le.$$.fragment,hn),Qn=r(hn),Ue=o(hn,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-dy4pdd"&&(Ue.textContent=yt),hn.forEach(a),cn=r(e),Ze=o(e,"P",{}),I(Ze).forEach(a),this.h()},h(){$(f,"name","hf:doc:metadata"),$(f,"content",Vt),$(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(p,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),$(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,c){n(document.head,f),s(e,M,c),s(e,E,c),s(e,x,c),l(w,e,c),s(e,v,c),s(e,L,c),s(e,Ge,c),l(V,e,c),s(e,Oe,c),s(e,O,c),s(e,Be,c),l(B,e,c),s(e,Qe,c),s(e,Q,c),s(e,Ye,c),s(e,Y,c),s(e,Xe,c),l(X,e,c),s(e,Je,c),s(e,J,c),s(e,Ke,c),s(e,p,c),l(K,p,null),n(p,ln),n(p,be),n(p,mn),l(z,p,null),n(p,_n),n(p,N),l(ee,N,null),n(N,bn),n(N,ve),n(p,vn),n(p,S),l(ne,S,null),n(S,En),n(S,Ee),n(p,In),n(p,U),l(te,U,null),n(U,$n),n(U,Ie),n(p,xn),n(p,T),l(re,T,null),n(T,yn),n(T,$e),n(T,wn),n(T,xe),n(T,Tn),n(T,ye),n(p,kn),n(p,W),l(ae,W,null),n(W,Cn),n(W,we),n(p,Hn),n(p,k),l(ie,k,null),n(k,Ln),n(k,Te),n(k,Mn),n(k,ke),n(k,Pn),n(k,Ce),n(p,jn),n(p,P),l(oe,P,null),n(P,An),n(P,He),n(P,qn),n(P,Le),n(p,Dn),n(p,C),l(ce,C,null),n(C,Vn),n(C,Me),n(C,zn),n(C,Pe),n(C,Nn),n(C,je),n(p,Sn),n(p,H),l(se,H,null),n(H,Un),n(H,Ae),n(H,Wn),n(H,qe),n(H,Rn),n(H,De),n(p,Fn),n(p,j),l(pe,j,null),n(j,Zn),n(j,Ve),n(j,Gn),n(j,ze),s(e,en,c),l(de,e,c),s(e,nn,c),s(e,A,c),l(ge,A,null),n(A,On),n(A,Ne),s(e,tn,c),l(fe,e,c),s(e,rn,c),s(e,q,c),l(ue,q,null),n(q,Bn),n(q,Se),s(e,an,c),l(he,e,c),s(e,on,c),s(e,D,c),l(le,D,null),n(D,Qn),n(D,Ue),s(e,cn,c),s(e,Ze,c),sn=!0},p(e,[c]){const g={};c&2&&(g.$$scope={dirty:c,ctx:e}),V.$set(g);const me={};c&2&&(me.$$scope={dirty:c,ctx:e}),z.$set(me)},i(e){sn||(m(w.$$.fragment,e),m(V.$$.fragment,e),m(B.$$.fragment,e),m(X.$$.fragment,e),m(K.$$.fragment,e),m(z.$$.fragment,e),m(ee.$$.fragment,e),m(ne.$$.fragment,e),m(te.$$.fragment,e),m(re.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),m(oe.$$.fragment,e),m(ce.$$.fragment,e),m(se.$$.fragment,e),m(pe.$$.fragment,e),m(de.$$.fragment,e),m(ge.$$.fragment,e),m(fe.$$.fragment,e),m(ue.$$.fragment,e),m(he.$$.fragment,e),m(le.$$.fragment,e),sn=!0)},o(e){_(w.$$.fragment,e),_(V.$$.fragment,e),_(B.$$.fragment,e),_(X.$$.fragment,e),_(K.$$.fragment,e),_(z.$$.fragment,e),_(ee.$$.fragment,e),_(ne.$$.fragment,e),_(te.$$.fragment,e),_(re.$$.fragment,e),_(ae.$$.fragment,e),_(ie.$$.fragment,e),_(oe.$$.fragment,e),_(ce.$$.fragment,e),_(se.$$.fragment,e),_(pe.$$.fragment,e),_(de.$$.fragment,e),_(ge.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(he.$$.fragment,e),_(le.$$.fragment,e),sn=!1},d(e){e&&(a(M),a(E),a(x),a(v),a(L),a(Ge),a(Oe),a(O),a(Be),a(Qe),a(Q),a(Ye),a(Y),a(Xe),a(Je),a(J),a(Ke),a(p),a(en),a(nn),a(A),a(tn),a(rn),a(q),a(an),a(on),a(D),a(cn),a(Ze)),a(f),b(w,e),b(V,e),b(B,e),b(X,e),b(K),b(z),b(ee),b(ne),b(te),b(re),b(ae),b(ie),b(oe),b(ce),b(se),b(pe),b(de,e),b(ge),b(fe,e),b(ue),b(he,e),b(le)}}}const Vt='{"title":"Inference Endpoints","local":"inference-endpoints","sections":[{"title":"Methods","local":"methods","sections":[],"depth":2},{"title":"InferenceEndpoint","local":"huggingface_hub.InferenceEndpoint","sections":[],"depth":2},{"title":"InferenceEndpointStatus","local":"huggingface_hub.InferenceEndpointStatus","sections":[],"depth":2},{"title":"InferenceEndpointType","local":"huggingface_hub.InferenceEndpointType","sections":[],"depth":2},{"title":"InferenceEndpointError","local":"huggingface_hub.InferenceEndpointError","sections":[],"depth":2}],"depth":1}';function zt(_e){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gt extends Ct{constructor(f){super(),Ht(this,f,zt,Dt,Tt,{})}}export{Gt as component};
