import{s as Ke,n as Oe,o as el}from"../chunks/scheduler.b108d059.js";import{S as ll,i as sl,g as i,s as a,r as m,A as tl,h as o,f as s,c as n,j as Pe,u as p,x as r,k as De,y as al,a as t,v as M,d as u,t as c,w as y}from"../chunks/index.008de539.js";import{C as Ae}from"../chunks/CodeBlock.3968c746.js";import{H as j,E as nl}from"../chunks/EditOnGithub.d1c48e3d.js";function il(ke){let h,P,H,D,U,K,b,xe="This page explains how scores are normalized on the Open LLM Leaderboard for the six presented benchmarks. We can categorize all tasks into those with subtasks, those without subtasks, and generative evaluation.",O,d,ee,f,Se="Normalization is the process of adjusting values measured on different scales to a common scale, making it possible to compare scores across different tasks. For the Open LLM Leaderboard, we normalize scores to:",le,w,Ie="<li>Account for the varying difficulty and random guess baselines of different tasks.</li> <li>Provide a consistent scale (0-100) for all tasks, enabling fair comparisons.</li> <li>Ensure that improvements over random guessing are appropriately reflected in the scores.</li>",se,J,te,C,Ne="The basic normalization process involves two steps:",ae,T,Qe="<li>Subtracting the random baseline score (lower bound).</li> <li>Scaling the result to a range of 0-100.</li>",ne,v,Ee="We use the following normalization function:",ie,z,oe,g,re,$,We="For tasks without subtasks (e.g., GPQA, MMLU-PRO), the normalization process is straightforward:",me,_,Ge="<li>Determine the lower bound (random guess baseline).</li> <li>Apply the normalization function.</li> <li>Scale to a percentage.</li>",pe,A,Me,k,Ze="GPQA has 4 <code>num_choices</code>, so the lower bound is 0.25 (1/<code>num_choices</code> = 1/4 = 0.25).",ue,x,ce,S,ye,I,Be="For tasks with subtasks (e.g., MUSR, BBH), we follow these steps:",he,N,Xe="<li>Calculate the lower bound for each subtask.</li> <li>Normalize each subtask score.</li> <li>Average the normalized subtask scores.</li>",je,Q,Ue,E,qe="MUSR has three subtasks with different numbers of choices:",be,W,Ye="<li>MUSR murder mysteries, num_choices = 2, lower_bound = 0.5</li> <li>MUSR object placement, num_choices = 5, lower_bound = 0.2</li> <li>MUSR team allocation, num_choices = 3, lower_bound = 0.33</li>",de,G,fe,Z,we,B,Ve="Generative evaluations like MATH and IFEval require a different approach:",Je,X,Le="<li><strong>MATH:</strong> Uses exact match accuracy. The lower bound is effectively 0, as random guessing is unlikely to produce a correct answer.</li> <li><strong>IFEval:</strong><ul><li>For instance-level evaluation (<code>ifeval_inst</code>), we use strict accuracy.</li> <li>For prompt-level evaluation (<code>ifeval_prompt</code>), we also use strict accuracy.</li> <li>The lower bound for both is 0, as random generation is unlikely to produce correct answers.</li></ul></li>",Ce,q,Fe="This approach ensures that even for generative tasks, we can provide normalized scores that are comparable across different evaluations.",Te,Y,ve,V,He='For more detailed information and examples, please refer to our <a href="https://huggingface.co/spaces/open-llm-leaderboard/blog" rel="nofollow">blog post</a> on scores normalization.',ze,L,Re='If you have any questions or need clarification, please start a new discussion on <a href="https://huggingface.co/spaces/open-llm-leaderboard/open_llm_leaderboard/discussions" rel="nofollow">the Leaderboard page</a>.',ge,F,$e,R,_e;return U=new j({props:{title:"Scores Normalization",local:"scores-normalization",headingTag:"h1"}}),d=new j({props:{title:"What is Normalization?",local:"what-is-normalization",headingTag:"h2"}}),J=new j({props:{title:"General Normalization Process",local:"general-normalization-process",headingTag:"h2"}}),z=new Ae({props:{code:"ZGVmJTIwbm9ybWFsaXplX3dpdGhpbl9yYW5nZSh2YWx1ZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCh2YWx1ZSUyMC0lMjBsb3dlcl9ib3VuZCklMjAlMkYlMjAoaGlnaGVyX2JvdW5kJTIwLSUyMGxvd2VyX2JvdW5kKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">normalize_within_range</span>(<span class="hljs-params">value, lower_bound, higher_bound</span>):
    <span class="hljs-keyword">return</span> (value - lower_bound) / (higher_bound - lower_bound)`,wrap:!1}}),g=new j({props:{title:"Normalizing Tasks without Subtasks",local:"normalizing-tasks-without-subtasks",headingTag:"h2"}}),A=new j({props:{title:"Example: Normalizing GPQA Scores",local:"example-normalizing-gpqa-scores",headingTag:"h3"}}),x=new Ae({props:{code:"cmF3X3Njb3JlJTIwJTNEJTIwMC42JTIwJTIwJTIzJTIwRXhhbXBsZSUyMHJhdyUyMHNjb3JlJTBBbG93ZXJfYm91bmQlMjAlM0QlMjAwLjI1JTBBaGlnaGVyX2JvdW5kJTIwJTNEJTIwMS4wJTBBJTBBaWYlMjByYXdfc2NvcmUlMjAlM0MlMjBsb3dlcl9ib3VuZCUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjAwJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMG5vcm1hbGl6ZWRfc2NvcmUlMjAlM0QlMjBub3JtYWxpemVfd2l0aGluX3JhbmdlKHJhd19zY29yZSUyQyUyMGxvd2VyX2JvdW5kJTJDJTIwaGlnaGVyX2JvdW5kKSUyMColMjAxMDAlMEElMEFwcmludChmJTIyTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMCU3Qm5vcm1hbGl6ZWRfc2NvcmUlM0EuMmYlN0QlMjIpJTBBJTIzJTIwT3V0cHV0JTNBJTIwTm9ybWFsaXplZCUyMEdQUUElMjBzY29yZSUzQSUyMDQ2LjY3",highlighted:`raw_score = <span class="hljs-number">0.6</span>  <span class="hljs-comment"># Example raw score</span>
lower_bound = <span class="hljs-number">0.25</span>
higher_bound = <span class="hljs-number">1.0</span>

<span class="hljs-keyword">if</span> raw_score &lt; lower_bound:
    normalized_score = <span class="hljs-number">0</span>
<span class="hljs-keyword">else</span>:
    normalized_score = normalize_within_range(raw_score, lower_bound, higher_bound) * <span class="hljs-number">100</span>

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Normalized GPQA score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-comment"># Output: Normalized GPQA score: 46.67</span>`,wrap:!1}}),S=new j({props:{title:"Normalizing Tasks with Subtasks",local:"normalizing-tasks-with-subtasks",headingTag:"h2"}}),Q=new j({props:{title:"Example: Normalizing MUSR Scores",local:"example-normalizing-musr-scores",headingTag:"h3"}}),G=new Ae({props:{code:"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",highlighted:`subtasks = [
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;murder_mysteries&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.7</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.5</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;object_placement&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.4</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.2</span>},
    {<span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;team_allocation&quot;</span>, <span class="hljs-string">&quot;raw_score&quot;</span>: <span class="hljs-number">0.6</span>, <span class="hljs-string">&quot;lower_bound&quot;</span>: <span class="hljs-number">0.333</span>}
]

normalized_scores = []

<span class="hljs-keyword">for</span> subtask <span class="hljs-keyword">in</span> subtasks:
    <span class="hljs-keyword">if</span> subtask[<span class="hljs-string">&quot;raw_score&quot;</span>] &lt; subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>]:
        normalized_score = <span class="hljs-number">0</span>
    <span class="hljs-keyword">else</span>:
        normalized_score = normalize_within_range(
            subtask[<span class="hljs-string">&quot;raw_score&quot;</span>], 
            subtask[<span class="hljs-string">&quot;lower_bound&quot;</span>], 
            <span class="hljs-number">1.0</span>
        ) * <span class="hljs-number">100</span>
    normalized_scores.append(normalized_score)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{subtask[<span class="hljs-string">&#x27;name&#x27;</span>]}</span> normalized score: <span class="hljs-subst">{normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

overall_normalized_score = <span class="hljs-built_in">sum</span>(normalized_scores) / <span class="hljs-built_in">len</span>(normalized_scores)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Overall normalized MUSR score: <span class="hljs-subst">{overall_normalized_score:<span class="hljs-number">.2</span>f}</span>&quot;</span>)

<span class="hljs-comment"># Output:</span>
<span class="hljs-comment"># murder_mysteries normalized score: 40.00</span>
<span class="hljs-comment"># object_placement normalized score: 25.00</span>
<span class="hljs-comment"># team_allocation normalized score: 40.00</span>
<span class="hljs-comment"># Overall normalized MUSR score: 35.00</span>`,wrap:!1}}),Z=new j({props:{title:"Generative Evaluations",local:"generative-evaluations",headingTag:"h2"}}),Y=new j({props:{title:"Further Information",local:"further-information",headingTag:"h2"}}),F=new nl({props:{source:"https://github.com/huggingface/leaderboards/blob/main/docs/source/en/open_llm_leaderboard/normalization.md"}}),{c(){h=i("meta"),P=a(),H=i("p"),D=a(),m(U.$$.fragment),K=a(),b=i("p"),b.textContent=xe,O=a(),m(d.$$.fragment),ee=a(),f=i("p"),f.textContent=Se,le=a(),w=i("ol"),w.innerHTML=Ie,se=a(),m(J.$$.fragment),te=a(),C=i("p"),C.textContent=Ne,ae=a(),T=i("ol"),T.innerHTML=Qe,ne=a(),v=i("p"),v.textContent=Ee,ie=a(),m(z.$$.fragment),oe=a(),m(g.$$.fragment),re=a(),$=i("p"),$.textContent=We,me=a(),_=i("ul"),_.innerHTML=Ge,pe=a(),m(A.$$.fragment),Me=a(),k=i("p"),k.innerHTML=Ze,ue=a(),m(x.$$.fragment),ce=a(),m(S.$$.fragment),ye=a(),I=i("p"),I.textContent=Be,he=a(),N=i("ul"),N.innerHTML=Xe,je=a(),m(Q.$$.fragment),Ue=a(),E=i("p"),E.textContent=qe,be=a(),W=i("ul"),W.innerHTML=Ye,de=a(),m(G.$$.fragment),fe=a(),m(Z.$$.fragment),we=a(),B=i("p"),B.textContent=Ve,Je=a(),X=i("ol"),X.innerHTML=Le,Ce=a(),q=i("p"),q.textContent=Fe,Te=a(),m(Y.$$.fragment),ve=a(),V=i("p"),V.innerHTML=He,ze=a(),L=i("p"),L.innerHTML=Re,ge=a(),m(F.$$.fragment),$e=a(),R=i("p"),this.h()},l(e){const l=tl("svelte-u9bgzb",document.head);h=o(l,"META",{name:!0,content:!0}),l.forEach(s),P=n(e),H=o(e,"P",{}),Pe(H).forEach(s),D=n(e),p(U.$$.fragment,e),K=n(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1o7378m"&&(b.textContent=xe),O=n(e),p(d.$$.fragment,e),ee=n(e),f=o(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1g21ee8"&&(f.textContent=Se),le=n(e),w=o(e,"OL",{"data-svelte-h":!0}),r(w)!=="svelte-zj6h40"&&(w.innerHTML=Ie),se=n(e),p(J.$$.fragment,e),te=n(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1homifm"&&(C.textContent=Ne),ae=n(e),T=o(e,"OL",{"data-svelte-h":!0}),r(T)!=="svelte-1noqtti"&&(T.innerHTML=Qe),ne=n(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-uv3qwg"&&(v.textContent=Ee),ie=n(e),p(z.$$.fragment,e),oe=n(e),p(g.$$.fragment,e),re=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-ukmwwm"&&($.textContent=We),me=n(e),_=o(e,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-199eldc"&&(_.innerHTML=Ge),pe=n(e),p(A.$$.fragment,e),Me=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1n8wkts"&&(k.innerHTML=Ze),ue=n(e),p(x.$$.fragment,e),ce=n(e),p(S.$$.fragment,e),ye=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-3f8l62"&&(I.textContent=Be),he=n(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-cnj190"&&(N.innerHTML=Xe),je=n(e),p(Q.$$.fragment,e),Ue=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-hgykxj"&&(E.textContent=qe),be=n(e),W=o(e,"UL",{"data-svelte-h":!0}),r(W)!=="svelte-2hbeeh"&&(W.innerHTML=Ye),de=n(e),p(G.$$.fragment,e),fe=n(e),p(Z.$$.fragment,e),we=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1yp6rl7"&&(B.textContent=Ve),Je=n(e),X=o(e,"OL",{"data-svelte-h":!0}),r(X)!=="svelte-1lwzczp"&&(X.innerHTML=Le),Ce=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1k8dio0"&&(q.textContent=Fe),Te=n(e),p(Y.$$.fragment,e),ve=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-12yyx1q"&&(V.innerHTML=He),ze=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-n94pcj"&&(L.innerHTML=Re),ge=n(e),p(F.$$.fragment,e),$e=n(e),R=o(e,"P",{}),Pe(R).forEach(s),this.h()},h(){De(h,"name","hf:doc:metadata"),De(h,"content",ol)},m(e,l){al(document.head,h),t(e,P,l),t(e,H,l),t(e,D,l),M(U,e,l),t(e,K,l),t(e,b,l),t(e,O,l),M(d,e,l),t(e,ee,l),t(e,f,l),t(e,le,l),t(e,w,l),t(e,se,l),M(J,e,l),t(e,te,l),t(e,C,l),t(e,ae,l),t(e,T,l),t(e,ne,l),t(e,v,l),t(e,ie,l),M(z,e,l),t(e,oe,l),M(g,e,l),t(e,re,l),t(e,$,l),t(e,me,l),t(e,_,l),t(e,pe,l),M(A,e,l),t(e,Me,l),t(e,k,l),t(e,ue,l),M(x,e,l),t(e,ce,l),M(S,e,l),t(e,ye,l),t(e,I,l),t(e,he,l),t(e,N,l),t(e,je,l),M(Q,e,l),t(e,Ue,l),t(e,E,l),t(e,be,l),t(e,W,l),t(e,de,l),M(G,e,l),t(e,fe,l),M(Z,e,l),t(e,we,l),t(e,B,l),t(e,Je,l),t(e,X,l),t(e,Ce,l),t(e,q,l),t(e,Te,l),M(Y,e,l),t(e,ve,l),t(e,V,l),t(e,ze,l),t(e,L,l),t(e,ge,l),M(F,e,l),t(e,$e,l),t(e,R,l),_e=!0},p:Oe,i(e){_e||(u(U.$$.fragment,e),u(d.$$.fragment,e),u(J.$$.fragment,e),u(z.$$.fragment,e),u(g.$$.fragment,e),u(A.$$.fragment,e),u(x.$$.fragment,e),u(S.$$.fragment,e),u(Q.$$.fragment,e),u(G.$$.fragment,e),u(Z.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),_e=!0)},o(e){c(U.$$.fragment,e),c(d.$$.fragment,e),c(J.$$.fragment,e),c(z.$$.fragment,e),c(g.$$.fragment,e),c(A.$$.fragment,e),c(x.$$.fragment,e),c(S.$$.fragment,e),c(Q.$$.fragment,e),c(G.$$.fragment,e),c(Z.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),_e=!1},d(e){e&&(s(P),s(H),s(D),s(K),s(b),s(O),s(ee),s(f),s(le),s(w),s(se),s(te),s(C),s(ae),s(T),s(ne),s(v),s(ie),s(oe),s(re),s($),s(me),s(_),s(pe),s(Me),s(k),s(ue),s(ce),s(ye),s(I),s(he),s(N),s(je),s(Ue),s(E),s(be),s(W),s(de),s(fe),s(we),s(B),s(Je),s(X),s(Ce),s(q),s(Te),s(ve),s(V),s(ze),s(L),s(ge),s($e),s(R)),s(h),y(U,e),y(d,e),y(J,e),y(z,e),y(g,e),y(A,e),y(x,e),y(S,e),y(Q,e),y(G,e),y(Z,e),y(Y,e),y(F,e)}}}const ol='{"title":"Scores Normalization","local":"scores-normalization","sections":[{"title":"What is Normalization?","local":"what-is-normalization","sections":[],"depth":2},{"title":"General Normalization Process","local":"general-normalization-process","sections":[],"depth":2},{"title":"Normalizing Tasks without Subtasks","local":"normalizing-tasks-without-subtasks","sections":[{"title":"Example: Normalizing GPQA Scores","local":"example-normalizing-gpqa-scores","sections":[],"depth":3}],"depth":2},{"title":"Normalizing Tasks with Subtasks","local":"normalizing-tasks-with-subtasks","sections":[{"title":"Example: Normalizing MUSR Scores","local":"example-normalizing-musr-scores","sections":[],"depth":3}],"depth":2},{"title":"Generative Evaluations","local":"generative-evaluations","sections":[],"depth":2},{"title":"Further Information","local":"further-information","sections":[],"depth":2}],"depth":1}';function rl(ke){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends ll{constructor(h){super(),sl(this,h,rl,il,Ke,{})}}export{cl as component};
