import{s as qo,f as Yo,o as Eo,n as Ce}from"../chunks/scheduler.9bc65507.js";import{S as Qo,i as Ao,g as m,s as n,r as h,A as Oo,h as d,f as o,c as a,j as J,u as f,x as g,k as F,y as i,a as l,v as u,d as _,t as b,w as M}from"../chunks/index.707bf1b6.js";import{T as Ho}from"../chunks/Tip.c2ecdbf4.js";import{D as I}from"../chunks/Docstring.17db21ae.js";import{C as nt}from"../chunks/CodeBlock.54a9f38d.js";import{E as st}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as te}from"../chunks/Heading.342b1fa6.js";function Do(U){let r,w="Examples:",p,c,y;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME1hc2syRm9ybWVyQ29uZmlnJTJDJTIwTWFzazJGb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNYXNrMkZvcm1lciUyMGZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNYXNrMkZvcm1lckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwKHdpdGglMjByYW5kb20lMjB3ZWlnaHRzKSUyMGZyb20lMjB0aGUlMjBmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Mask2FormerConfig, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Mask2Former facebook/mask2former-swin-small-coco-instance configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = Mask2FormerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the facebook/mask2former-swin-small-coco-instance style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(t),f(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),u(c,t,k),y=!0},p:Ce,i(t){y||(_(c.$$.fragment,t),y=!0)},o(t){b(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),M(c,t)}}}function Ko(U){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=m("p"),r.innerHTML=w},l(p){r=d(p,"P",{"data-svelte-h":!0}),g(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,c){l(p,r,c)},p:Ce,d(p){p&&o(r)}}}function es(U){let r,w="Examples:",p,c,y;return c=new nt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMkMlMjBNYXNrMkZvcm1lck1vZGVsJTBBJTBBJTIzJTIwbG9hZCUyMGltYWdlJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQSUyMyUyMGxvYWQlMjBpbWFnZSUyMHByZXByb2Nlc3NvciUyMGFuZCUyME1hc2syRm9ybWVyTW9kZWwlMjB0cmFpbmVkJTIwb24lMjBDT0NPJTIwaW5zdGFuY2UlMjBzZWdtZW50YXRpb24lMjBkYXRhc2V0JTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtY29jby1pbnN0YW5jZSUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwZm9yd2FyZCUyMHBhc3MlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMG1vZGVsJTIwb3V0cHV0cyUyMGxhc3QlMjBoaWRkZW4lMjBzdGF0ZXMlMjBvZiUyMHNoYXBlJTIwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhpZGRlbl9zaXplKSUwQXByaW50KG91dHB1dHMudHJhbnNmb3JtZXJfZGVjb2Rlcl9sYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># load image preprocessor and Mask2FormerModel trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerModel.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model outputs last hidden states of shape (batch_size, num_queries, hidden_size)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(outputs.transformer_decoder_last_hidden_state.shape)
torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">100</span>, <span class="hljs-number">256</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-kvfsh7"&&(r.textContent=w),p=a(t),f(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),u(c,t,k),y=!0},p:Ce,i(t){y||(_(c.$$.fragment,t),y=!0)},o(t){b(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),M(c,t)}}}function ts(U){let r,w=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=m("p"),r.innerHTML=w},l(p){r=d(p,"P",{"data-svelte-h":!0}),g(r)!=="svelte-fincs2"&&(r.innerHTML=w)},m(p,c){l(p,r,c)},p:Ce,d(p){p&&o(r)}}}function os(U){let r,w="Instance segmentation example:",p,c,y;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMENPQ08lMjBpbnN0YW5jZSUyMHNlZ21lbnRhdGlvbiUyMGRhdGFzZXQlMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwTWFzazJGb3JtZXJGb3JVbml2ZXJzYWxTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmZhY2Vib29rJTJGbWFzazJmb3JtZXItc3dpbi1zbWFsbC1jb2NvLWluc3RhbmNlJTIyJTBBKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMGluc3RhbmNlJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9pbnN0YW5jZV9tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEJTBBKSU1QjAlNUQlMEFwcmludChwcmVkX2luc3RhbmNlX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on COCO instance segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-coco-instance&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get instance segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_instance_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_instance_map.shape)
torch.Size([<span class="hljs-number">480</span>, <span class="hljs-number">640</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-1xhxiwz"&&(r.textContent=w),p=a(t),f(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),u(c,t,k),y=!0},p:Ce,i(t){y||(_(c.$$.fragment,t),y=!0)},o(t){b(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),M(c,t)}}}function ss(U){let r,w="Semantic segmentation example:",p,c,y;return c=new nt({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQSUyMyUyMExvYWQlMjBNYXNrMkZvcm1lciUyMHRyYWluZWQlMjBvbiUyMEFERTIwayUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwZGF0YXNldCUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtYXNrMmZvcm1lci1zd2luLXNtYWxsLWFkZS1zZW1hbnRpYyUyMiklMEFtb2RlbCUyMCUzRCUyME1hc2syRm9ybWVyRm9yVW5pdmVyc2FsU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm1hc2syZm9ybWVyLXN3aW4tc21hbGwtYWRlLXNlbWFudGljJTIyKSUwQSUwQXVybCUyMCUzRCUyMCglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXNfYWRlMjBrJTJGcmVzb2x2ZSUyRm1haW4lMkZBREVfdmFsXzAwMDAwMDAxLmpwZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBJTIzJTIwTW9kZWwlMjBwcmVkaWN0cyUyMGNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwb2YlMjBzaGFwZSUyMCU2MChiYXRjaF9zaXplJTJDJTIwbnVtX3F1ZXJpZXMpJTYwJTBBJTIzJTIwYW5kJTIwbWFza3NfcXVlcmllc19sb2dpdHMlMjBvZiUyMHNoYXBlJTIwJTYwKGJhdGNoX3NpemUlMkMlMjBudW1fcXVlcmllcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoKSU2MCUwQWNsYXNzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5jbGFzc19xdWVyaWVzX2xvZ2l0cyUwQW1hc2tzX3F1ZXJpZXNfbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5tYXNrc19xdWVyaWVzX2xvZ2l0cyUwQSUwQSUyMyUyMFBlcmZvcm0lMjBwb3N0LXByb2Nlc3NpbmclMjB0byUyMGdldCUyMHNlbWFudGljJTIwc2VnbWVudGF0aW9uJTIwbWFwJTBBcHJlZF9zZW1hbnRpY19tYXAlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IucG9zdF9wcm9jZXNzX3NlbWFudGljX3NlZ21lbnRhdGlvbiglMEElMjAlMjAlMjAlMjBvdXRwdXRzJTJDJTIwdGFyZ2V0X3NpemVzJTNEJTVCaW1hZ2Uuc2l6ZSU1QiUzQSUzQS0xJTVEJTVEJTBBKSU1QjAlNUQlMEFwcmludChwcmVkX3NlbWFudGljX21hcC5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on ADE20k semantic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-ade-semantic&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = (
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures_ade20k/resolve/main/ADE_val_00000001.jpg&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get semantic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_semantic_map = image_processor.post_process_semantic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_semantic_map.shape)
torch.Size([<span class="hljs-number">512</span>, <span class="hljs-number">683</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-ec2k7m"&&(r.textContent=w),p=a(t),f(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),u(c,t,k),y=!0},p:Ce,i(t){y||(_(c.$$.fragment,t),y=!0)},o(t){b(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),M(c,t)}}}function ns(U){let r,w="Panoptic segmentation example:",p,c,y;return c=new nt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, Mask2FormerForUniversalSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load Mask2Former trained on CityScapes panoptic segmentation dataset</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = Mask2FormerForUniversalSegmentation.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;facebook/mask2former-swin-small-cityscapes-panoptic&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://cdn-media.huggingface.co/Inference-API/Sample-results-on-the-Cityscapes-dataset-The-above-images-show-how-our-method-can-handle.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Model predicts class_queries_logits of shape \`(batch_size, num_queries)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># and masks_queries_logits of shape \`(batch_size, num_queries, height, width)\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>class_queries_logits = outputs.class_queries_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>masks_queries_logits = outputs.masks_queries_logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Perform post-processing to get panoptic segmentation map</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred_panoptic_map = image_processor.post_process_panoptic_segmentation(
<span class="hljs-meta">... </span>    outputs, target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;segmentation&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pred_panoptic_map.shape)
torch.Size([<span class="hljs-number">338</span>, <span class="hljs-number">676</span>])`,wrap:!1}}),{c(){r=m("p"),r.textContent=w,p=n(),h(c.$$.fragment)},l(t){r=d(t,"P",{"data-svelte-h":!0}),g(r)!=="svelte-1hqqxa2"&&(r.textContent=w),p=a(t),f(c.$$.fragment,t)},m(t,k){l(t,r,k),l(t,p,k),u(c,t,k),y=!0},p:Ce,i(t){y||(_(c.$$.fragment,t),y=!0)},o(t){b(c.$$.fragment,t),y=!1},d(t){t&&(o(r),o(p)),M(c,t)}}}function as(U){let r,w,p,c,y,t,k,at,oe,ho='The Mask2Former model was proposed in <a href="https://arxiv.org/abs/2112.01527" rel="nofollow">Masked-attention Mask Transformer for Universal Image Segmentation</a> by Bowen Cheng, Ishan Misra, Alexander G. Schwing, Alexander Kirillov, Rohit Girdhar. Mask2Former is a unified framework for panoptic, instance and semantic segmentation and features significant performance and efficiency improvements over <a href="maskformer">MaskFormer</a>.',rt,se,fo="The abstract from the paper is the following:",it,ne,uo=`<em>Image segmentation groups pixels with different semantics, e.g., category or instance membership. Each choice
of semantics defines a task. While only the semantics of each task differ, current research focuses on designing specialized architectures for each task. We present Masked-attention Mask Transformer (Mask2Former), a new architecture capable of addressing any image segmentation task (panoptic, instance or semantic). Its key components include masked attention, which extracts localized features by constraining cross-attention within predicted mask regions. In addition to reducing the research effort by at least three times, it outperforms the best specialized architectures by a significant margin on four popular datasets. Most notably, Mask2Former sets a new state-of-the-art for panoptic segmentation (57.8 PQ on COCO), instance segmentation (50.1 AP on COCO) and semantic segmentation (57.7 mIoU on ADE20K).</em>`,lt,ae,_o="Tips:",mt,re,bo='<li>Mask2Former uses the same preprocessing and postprocessing steps as <a href="maskformer">MaskFormer</a>. Use <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor">Mask2FormerImageProcessor</a> or <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a> to prepare images and optional targets for the model.</li> <li>To get the final segmentation, depending on the task, you can call <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a>. All three tasks can be solved using <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> output, panoptic segmentation accepts an optional <code>label_ids_to_fuse</code> argument to fuse instances of the target object/s (e.g. sky) together.</li>',dt,G,Mo,ct,ie,yo='Mask2Former architecture. Taken from the <a href="https://arxiv.org/abs/2112.01527">original paper.</a>',pt,le,ko='This model was contributed by <a href="https://huggingface.co/shivi" rel="nofollow">Shivalika Singh</a> and <a href="https://huggingface.co/adirik" rel="nofollow">Alara Dirik</a>. The original code can be found <a href="https://github.com/facebookresearch/Mask2Former" rel="nofollow">here</a>.',gt,me,ht,de,wo="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Mask2Former.",ft,ce,vo='<li>Demo notebooks regarding inference + fine-tuning Mask2Former on custom data can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Mask2Former" rel="nofollow">here</a>.</li>',ut,pe,Fo=`If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we will review it.
The resource should ideally demonstrate something new instead of duplicating an existing resource.`,_t,ge,bt,B,he,Wt,Ne,To='Class for outputs of <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. This class returns all the needed hidden states to compute the logits.',Mt,C,fe,Ct,Ze,xo="Class for outputs of <code>Mask2FormerForUniversalSegmentationOutput</code>.",Nt,Xe,Uo=`This output can be directly passed to <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation">post_process_semantic_segmentation()</a> or
<a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_instance_segmentation">post_process_instance_segmentation()</a> or
<a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation">post_process_panoptic_segmentation()</a> to compute final segmentation maps. Please, see
[\`~Mask2FormerImageProcessor] for details regarding usage.`,yt,ue,kt,x,_e,Zt,Ve,jo=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a>. It is used to instantiate a
Mask2Former model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Mask2Former
<a href="https://huggingface.co/facebook/mask2former-swin-small-coco-instance" rel="nofollow">facebook/mask2former-swin-small-coco-instance</a>
architecture.`,Xt,Be,Jo=`Configuration objects inherit from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Vt,Re,$o='Currently, Mask2Former only supports the <a href="swin">Swin Transformer</a> as backbone.',Bt,P,Rt,H,be,Lt,Le,zo='Instantiate a <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a> (or a derived class) from a pre-trained backbone model configuration.',wt,Me,vt,N,ye,St,Se,Io=`The bare Mask2Former Model outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Gt,W,ke,Pt,Ge,Wo='The <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerModel">Mask2FormerModel</a> forward method, overrides the <code>__call__</code> special method.',Ht,q,qt,Y,Ft,we,Tt,Z,ve,Yt,Pe,Co=`The Mask2Former Model with heads on top for instance/semantic/panoptic segmentation.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Et,T,Fe,Qt,He,No='The <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> forward method, overrides the <code>__call__</code> special method.',At,E,Ot,qe,Zo="Examples:",Dt,Q,Kt,A,eo,O,xt,Te,Ut,v,xe,to,Ye,Xo=`Constructs a Mask2Former image processor. The image processor can be used to prepare image(s) and optional targets
for the model.`,oo,Ee,Vo=`This image processor inherits from <code>BaseImageProcessor</code> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,so,Qe,Ue,no,V,je,ao,Ae,Bo="Pad images up to the largest image in a batch and create a corresponding <code>pixel_mask</code>.",ro,Oe,Ro=`Mask2Former addresses semantic segmentation with a mask classification paradigm, thus input segmentation maps
will be converted to lists of binary masks and their respective labels. Let’s see an example, assuming
<code>segmentation_maps = [[2,6,7,9]]</code>, the output will contain <code>mask_labels = [[1,0,0,0],[0,1,0,0],[0,0,1,0],[0,0,0,1]]</code> (four binary masks) and <code>class_labels = [2,6,7,9]</code>, the labels for
each mask.`,io,D,Je,lo,De,Lo=`Converts the output of <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a> into semantic segmentation maps. Only supports
PyTorch.`,mo,K,$e,co,Ke,So=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into instance segmentation predictions.
Only supports PyTorch.`,po,ee,ze,go,et,Go=`Converts the output of <code>Mask2FormerForUniversalSegmentationOutput</code> into image panoptic segmentation
predictions. Only supports PyTorch.`,jt,ot,Jt;return y=new te({props:{title:"Mask2Former",local:"mask2former",headingTag:"h1"}}),k=new te({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new te({props:{title:"Resources",local:"resources",headingTag:"h2"}}),ge=new te({props:{title:"MaskFormer specific outputs",local:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",headingTag:"h2"}}),he=new I({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput",parameters:[{name:"encoder_last_hidden_state",val:": FloatTensor = None"},{name:"pixel_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"transformer_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_intermediate_states",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"masks_queries_logits",val:": typing.Tuple[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.transformer_decoder_intermediate_states",description:`<strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) &#x2014;
Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.`,name:"transformer_decoder_intermediate_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>) &#x2014;
Mask Predictions from each layer in the transformer decoder.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/modeling_mask2former.py#L146"}}),fe=new I({props:{name:"class transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"class_queries_logits",val:": FloatTensor = None"},{name:"masks_queries_logits",val:": FloatTensor = None"},{name:"auxiliary_logits",val:": typing.Union[typing.List[typing.Dict[str, torch.FloatTensor]], NoneType] = None"},{name:"encoder_last_hidden_state",val:": FloatTensor = None"},{name:"pixel_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"transformer_decoder_last_hidden_state",val:": FloatTensor = None"},{name:"encoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"pixel_decoder_hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"transformer_decoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.loss",description:`<strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
The computed loss, returned when labels are present.`,name:"loss"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.class_queries_logits",description:`<strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.`,name:"class_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.masks_queries_logits",description:`<strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) &#x2014;
A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.`,name:"masks_queries_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.auxiliary_logits",description:`<strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) &#x2014;
List of class and mask predictions from each layer of the transformer decoder.`,name:"auxiliary_logits"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_last_hidden_state",description:`<strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the encoder model (backbone).`,name:"encoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.`,name:"encoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_last_hidden_state",description:`<strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Last hidden states (final feature map) of the last stage of the pixel decoder model.`,name:"pixel_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.pixel_decoder_hidden_states",description:`<strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.`,name:"pixel_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_last_hidden_state",description:`<strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) &#x2014;
Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.`,name:"transformer_decoder_last_hidden_state"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.transformer_decoder_hidden_states",description:`<strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.`,name:"transformer_decoder_hidden_states"},{anchor:"transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.`,name:"attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/modeling_mask2former.py#L192"}}),ue=new te({props:{title:"Mask2FormerConfig",local:"transformers.Mask2FormerConfig",headingTag:"h2"}}),_e=new I({props:{name:"class transformers.Mask2FormerConfig",anchor:"transformers.Mask2FormerConfig",parameters:[{name:"backbone_config",val:": typing.Optional[typing.Dict] = None"},{name:"feature_size",val:": int = 256"},{name:"mask_feature_size",val:": int = 256"},{name:"hidden_dim",val:": int = 256"},{name:"encoder_feedforward_dim",val:": int = 1024"},{name:"activation_function",val:": str = 'relu'"},{name:"encoder_layers",val:": int = 6"},{name:"decoder_layers",val:": int = 10"},{name:"num_attention_heads",val:": int = 8"},{name:"dropout",val:": float = 0.0"},{name:"dim_feedforward",val:": int = 2048"},{name:"pre_norm",val:": bool = False"},{name:"enforce_input_projection",val:": bool = False"},{name:"common_stride",val:": int = 4"},{name:"ignore_value",val:": int = 255"},{name:"num_queries",val:": int = 100"},{name:"no_object_weight",val:": float = 0.1"},{name:"class_weight",val:": float = 2.0"},{name:"mask_weight",val:": float = 5.0"},{name:"dice_weight",val:": float = 5.0"},{name:"train_num_points",val:": int = 12544"},{name:"oversample_ratio",val:": float = 3.0"},{name:"importance_sample_ratio",val:": float = 0.75"},{name:"init_std",val:": float = 0.02"},{name:"init_xavier_std",val:": float = 1.0"},{name:"use_auxiliary_loss",val:": bool = True"},{name:"feature_strides",val:": typing.List[int] = [4, 8, 16, 32]"},{name:"output_auxiliary_logits",val:": bool = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>SwinConfig()</code>) &#x2014;
The configuration of the backbone model. If unset, the configuration corresponding to
<code>swin-base-patch4-window12-384</code> will be used.`,name:"backbone_config"},{anchor:"transformers.Mask2FormerConfig.feature_size",description:`<strong>feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The features (channels) of the resulting feature maps.`,name:"feature_size"},{anchor:"transformers.Mask2FormerConfig.mask_feature_size",description:`<strong>mask_feature_size</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The masks&#x2019; features size, this value will also be used to specify the Feature Pyramid Network features&#x2019;
size.`,name:"mask_feature_size"},{anchor:"transformers.Mask2FormerConfig.hidden_dim",description:`<strong>hidden_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimensionality of the encoder layers.`,name:"hidden_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_feedforward_dim",description:`<strong>encoder_feedforward_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimension of feedforward network for deformable detr encoder used as part of pixel decoder.`,name:"encoder_feedforward_dim"},{anchor:"transformers.Mask2FormerConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of layers in the deformable detr encoder used as part of pixel decoder.`,name:"encoder_layers"},{anchor:"transformers.Mask2FormerConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 10) &#x2014;
Number of layers in the Transformer decoder.`,name:"decoder_layers"},{anchor:"transformers.Mask2FormerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer.`,name:"num_attention_heads"},{anchor:"transformers.Mask2FormerConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder.`,name:"dropout"},{anchor:"transformers.Mask2FormerConfig.dim_feedforward",description:`<strong>dim_feedforward</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Feature dimension in feedforward network for transformer decoder.`,name:"dim_feedforward"},{anchor:"transformers.Mask2FormerConfig.pre_norm",description:`<strong>pre_norm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pre-LayerNorm or not for transformer decoder.`,name:"pre_norm"},{anchor:"transformers.Mask2FormerConfig.enforce_input_projection",description:`<strong>enforce_input_projection</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to add an input projection 1x1 convolution even if the input channels and hidden dim are identical
in the Transformer decoder.`,name:"enforce_input_projection"},{anchor:"transformers.Mask2FormerConfig.common_stride",description:`<strong>common_stride</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Parameter used for determining number of FPN levels used as part of pixel decoder.`,name:"common_stride"},{anchor:"transformers.Mask2FormerConfig.ignore_value",description:`<strong>ignore_value</strong> (<code>int</code>, <em>optional</em>, defaults to 255) &#x2014;
Category id to be ignored during training.`,name:"ignore_value"},{anchor:"transformers.Mask2FormerConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Number of queries for the decoder.`,name:"num_queries"},{anchor:"transformers.Mask2FormerConfig.no_object_weight",description:`<strong>no_object_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The weight to apply to the null (no object) class.`,name:"no_object_weight"},{anchor:"transformers.Mask2FormerConfig.class_weight",description:`<strong>class_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 2.0) &#x2014;
The weight for the cross entropy loss.`,name:"class_weight"},{anchor:"transformers.Mask2FormerConfig.mask_weight",description:`<strong>mask_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the mask loss.`,name:"mask_weight"},{anchor:"transformers.Mask2FormerConfig.dice_weight",description:`<strong>dice_weight</strong> (<code>int</code>, <em>optional</em>, defaults to 5.0) &#x2014;
The weight for the dice loss.`,name:"dice_weight"},{anchor:"transformers.Mask2FormerConfig.train_num_points",description:`<strong>train_num_points</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to 12544) &#x2014;
Number of points used for sampling during loss calculation.`,name:"train_num_points"},{anchor:"transformers.Mask2FormerConfig.oversample_ratio",description:`<strong>oversample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 3.0) &#x2014;
Oversampling parameter used for calculating no. of sampled points`,name:"oversample_ratio"},{anchor:"transformers.Mask2FormerConfig.importance_sample_ratio",description:`<strong>importance_sample_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to 0.75) &#x2014;
Ratio of points that are sampled via importance sampling.`,name:"importance_sample_ratio"},{anchor:"transformers.Mask2FormerConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.Mask2FormerConfig.init_xavier_std",description:`<strong>init_xavier_std</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The scaling factor used for the Xavier initialization gain in the HM Attention map module.`,name:"init_xavier_std"},{anchor:"transformers.Mask2FormerConfig.use_auxiliary_loss",description:"<strong>use_auxiliary_loss</strong> (<code>boolean``, *optional*, defaults to </code>True<code>) -- If </code>True<code> </code>Mask2FormerForUniversalSegmentationOutput` will contain the auxiliary losses computed using\nthe logits from each decoder&#x2019;s stage.",name:"use_auxiliary_loss"},{anchor:"transformers.Mask2FormerConfig.feature_strides",description:`<strong>feature_strides</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[4, 8, 16, 32]</code>) &#x2014;
Feature strides corresponding to features generated from backbone network.`,name:"feature_strides"},{anchor:"transformers.Mask2FormerConfig.output_auxiliary_logits",description:`<strong>output_auxiliary_logits</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Should the model output its <code>auxiliary_logits</code> or not.`,name:"output_auxiliary_logits"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/configuration_mask2former.py#L33"}}),P=new st({props:{anchor:"transformers.Mask2FormerConfig.example",$$slots:{default:[Do]},$$scope:{ctx:U}}}),be=new I({props:{name:"from_backbone_config",anchor:"transformers.Mask2FormerConfig.from_backbone_config",parameters:[{name:"backbone_config",val:": PretrainedConfig"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerConfig.from_backbone_config.backbone_config",description:`<strong>backbone_config</strong> (<a href="/docs/transformers/v4.35.2/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>) &#x2014;
The backbone configuration.`,name:"backbone_config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/configuration_mask2former.py#L217",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a></p>
`}}),Me=new te({props:{title:"Mask2FormerModel",local:"transformers.Mask2FormerModel",headingTag:"h2"}}),ye=new I({props:{name:"class transformers.Mask2FormerModel",anchor:"transformers.Mask2FormerModel",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/modeling_mask2former.py#L2190"}}),ke=new I({props:{name:"forward",anchor:"transformers.Mask2FormerModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/modeling_mask2former.py#L2200",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone). Returned when
<code>output_hidden_states=True</code> is passed.</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>, <em>optional</em>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, , <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage. Returned when <code>output_hidden_states=True</code> is passed.</li>
<li><strong>transformer_decoder_intermediate_states</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(num_queries, 1, hidden_size)</code>) — Intermediate decoder activations, i.e. the output of each decoder layer, each of them gone through a
layernorm.</li>
<li><strong>masks_queries_logits</strong> (<code>tuple(torch.FloatTensor)</code> of shape <code>(batch_size, num_queries, height, width)</code>)
Mask Predictions from each layer in the transformer decoder.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerModelOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),q=new Ho({props:{$$slots:{default:[Ko]},$$scope:{ctx:U}}}),Y=new st({props:{anchor:"transformers.Mask2FormerModel.forward.example",$$slots:{default:[es]},$$scope:{ctx:U}}}),we=new te({props:{title:"Mask2FormerForUniversalSegmentation",local:"transformers.Mask2FormerForUniversalSegmentation",headingTag:"h2"}}),ve=new I({props:{name:"class transformers.Mask2FormerForUniversalSegmentation",anchor:"transformers.Mask2FormerForUniversalSegmentation",parameters:[{name:"config",val:": Mask2FormerConfig"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerConfig">Mask2FormerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.35.2/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/modeling_mask2former.py#L2294"}}),Fe=new I({props:{name:"forward",anchor:"transformers.Mask2FormerForUniversalSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"mask_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"class_labels",val:": typing.Optional[typing.List[torch.Tensor]] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"output_auxiliary_logits",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.35.2/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<code>AutoImageProcessor.preprocess</code> for details.`,name:"pixel_values"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of Detr&#x2019;s decoder attention layers.`,name:"output_attentions"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <code>~Mask2FormerModelOutput</code> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.mask_labels",description:`<strong>mask_labels</strong> (<code>List[torch.Tensor]</code>, <em>optional</em>) &#x2014;
List of mask labels of shape <code>(num_labels, height, width)</code> to be fed to a model`,name:"mask_labels"},{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.class_labels",description:`<strong>class_labels</strong> (<code>List[torch.LongTensor]</code>, <em>optional</em>) &#x2014;
list of target class labels of shape <code>(num_labels, height, width)</code> to be fed to a model. They identify the
labels of <code>mask_labels</code>, e.g. the label of <code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.`,name:"class_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/modeling_mask2former.py#L2347",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerConfig"
>Mask2FormerConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.Tensor</code>, <em>optional</em>) — The computed loss, returned when labels are present.</li>
<li><strong>class_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, num_labels + 1)</code> representing the proposed classes for each
query. Note the <code>+ 1</code> is needed because we incorporate the null class.</li>
<li><strong>masks_queries_logits</strong> (<code>torch.FloatTensor</code>) — A tensor of shape <code>(batch_size, num_queries, height, width)</code> representing the proposed masks for each
query.</li>
<li><strong>auxiliary_logits</strong> (<code>List[Dict(str, torch.FloatTensor)]</code>, <em>optional</em>) — List of class and mask predictions from each layer of the transformer decoder.</li>
<li><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the encoder model (backbone).</li>
<li><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the encoder
model at the output of each stage.</li>
<li><strong>pixel_decoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) — Last hidden states (final feature map) of the last stage of the pixel decoder model.</li>
<li><strong>pixel_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, num_channels, height, width)</code>. Hidden-states (also called feature maps) of the pixel
decoder model at the output of each stage.</li>
<li><strong>transformer_decoder_last_hidden_state</strong> (<code>tuple(torch.FloatTensor)</code>) — Final output of the transformer decoder <code>(batch_size, sequence_length, hidden_size)</code>.</li>
<li><strong>transformer_decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each stage) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states (also called feature maps) of the
transformer decoder at the output of each stage.</li>
<li><strong>attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Self and Cross Attentions weights from transformer decoder.</li>
</ul>
<p><code>Mask2FormerUniversalSegmentationOutput</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput"
>transformers.models.mask2former.modeling_mask2former.Mask2FormerForUniversalSegmentationOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),E=new Ho({props:{$$slots:{default:[ts]},$$scope:{ctx:U}}}),Q=new st({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example",$$slots:{default:[os]},$$scope:{ctx:U}}}),A=new st({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-2",$$slots:{default:[ss]},$$scope:{ctx:U}}}),O=new st({props:{anchor:"transformers.Mask2FormerForUniversalSegmentation.forward.example-3",$$slots:{default:[ns]},$$scope:{ctx:U}}}),Te=new te({props:{title:"Mask2FormerImageProcessor",local:"transformers.Mask2FormerImageProcessor",headingTag:"h2"}}),xe=new I({props:{name:"class transformers.Mask2FormerImageProcessor",anchor:"transformers.Mask2FormerImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"size_divisor",val:": int = 32"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the input to a certain <code>size</code>.`,name:"do_resize"},{anchor:"transformers.Mask2FormerImageProcessor.size",description:`<strong>size</strong> (<code>int</code>, <em>optional</em>, defaults to 800) &#x2014;
Resize the input to the given size. Only has an effect if <code>do_resize</code> is set to <code>True</code>. If size is a
sequence like <code>(width, height)</code>, output size will be matched to this. If size is an int, smaller edge of
the image will be matched to this number. i.e, if <code>height &gt; width</code>, then image will be rescaled to <code>(size * height / width, size)</code>.`,name:"size"},{anchor:"transformers.Mask2FormerImageProcessor.size_divisor",description:`<strong>size_divisor</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Some backbones need images divisible by a certain number. If not passed, it defaults to the value used in
Swin Transformer.`,name:"size_divisor"},{anchor:"transformers.Mask2FormerImageProcessor.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
An optional resampling filter. This can be one of <code>PIL.Image.Resampling.NEAREST</code>,
<code>PIL.Image.Resampling.BOX</code>, <code>PIL.Image.Resampling.BILINEAR</code>, <code>PIL.Image.Resampling.HAMMING</code>,
<code>PIL.Image.Resampling.BICUBIC</code> or <code>PIL.Image.Resampling.LANCZOS</code>. Only has an effect if <code>do_resize</code> is set
to <code>True</code>.`,name:"resample"},{anchor:"transformers.Mask2FormerImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the input to a certain <code>scale</code>.`,name:"do_rescale"},{anchor:"transformers.Mask2FormerImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1/ 255</code>) &#x2014;
Rescale the input by the given factor. Only has an effect if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.Mask2FormerImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the input with mean and standard deviation.`,name:"do_normalize"},{anchor:"transformers.Mask2FormerImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.485, 0.456, 0.406]</code>) &#x2014;
The sequence of means for each channel, to be used when normalizing images. Defaults to the ImageNet mean.`,name:"image_mean"},{anchor:"transformers.Mask2FormerImageProcessor.image_std",description:`<strong>image_std</strong> (<code>int</code>, <em>optional</em>, defaults to <code>[0.229, 0.224, 0.225]</code>) &#x2014;
The sequence of standard deviations for each channel, to be used when normalizing images. Defaults to the
ImageNet std.`,name:"image_std"},{anchor:"transformers.Mask2FormerImageProcessor.ignore_index",description:`<strong>ignore_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Label to be assigned to background pixels in segmentation maps. If provided, segmentation map pixels
denoted with 0 (background) will be replaced with <code>ignore_index</code>.`,name:"ignore_index"},{anchor:"transformers.Mask2FormerImageProcessor.reduce_labels",description:`<strong>reduce_labels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to decrement all label values of segmentation maps by 1. Usually used for datasets where 0
is used for background, and background itself is not included in all classes of a dataset (e.g. ADE20k).
The background label will be replaced by <code>ignore_index</code>.`,name:"reduce_labels"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/image_processing_mask2former.py#L345"}}),Ue=new I({props:{name:"preprocess",anchor:"transformers.Mask2FormerImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')], NoneType] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.Dict[int, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"size_divisor",val:": typing.Optional[int] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/image_processing_mask2former.py#L670"}}),je=new I({props:{name:"encode_inputs",anchor:"transformers.Mask2FormerImageProcessor.encode_inputs",parameters:[{name:"pixel_values_list",val:": typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]]"},{name:"segmentation_maps",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]] = None"},{name:"instance_id_to_semantic_id",val:": typing.Union[typing.List[typing.Dict[int, int]], typing.Dict[int, int], NoneType] = None"},{name:"ignore_index",val:": typing.Optional[int] = None"},{name:"reduce_labels",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.pixel_values_list",description:`<strong>pixel_values_list</strong> (<code>List[ImageInput]</code>) &#x2014;
List of images (pixel values) to be padded. Each image should be a tensor of shape <code>(channels, height, width)</code>.`,name:"pixel_values_list"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.segmentation_maps",description:`<strong>segmentation_maps</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
The corresponding semantic segmentation maps with the pixel-wise annotations.</p>
<p>(<code>bool</code>, <em>optional</em>, defaults to <code>True</code>):
Whether or not to pad images up to the largest image in a batch and create a pixel mask.</p>
<p>If left to the default, will return a pixel mask that is:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>`,name:"segmentation_maps"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.instance_id_to_semantic_id",description:`<strong>instance_id_to_semantic_id</strong> (<code>List[Dict[int, int]]</code> or <code>Dict[int, int]</code>, <em>optional</em>) &#x2014;
A mapping between object instance ids and class ids. If passed, <code>segmentation_maps</code> is treated as an
instance segmentation map where each pixel represents an instance id. Can be provided as a single
dictionary with a global/dataset-level mapping or as a list of dictionaries (one per image), to map
instance ids in each image separately.`,name:"instance_id_to_semantic_id"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.35.2/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of NumPy arrays. If set to <code>&apos;pt&apos;</code>, return PyTorch <code>torch.Tensor</code>
objects.`,name:"return_tensors"},{anchor:"transformers.Mask2FormerImageProcessor.encode_inputs.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/image_processing_mask2former.py#L858",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.35.2/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a> with the following fields:</p>
<ul>
<li><strong>pixel_values</strong> — Pixel values to be fed to a model.</li>
<li><strong>pixel_mask</strong> — Pixel mask to be fed to a model (when <code>=True</code> or if <code>pixel_mask</code> is in
<code>self.model_input_names</code>).</li>
<li><strong>mask_labels</strong> — Optional list of mask labels of shape <code>(labels, height, width)</code> to be fed to a model
(when <code>annotations</code> are provided).</li>
<li><strong>class_labels</strong> — Optional list of class labels of shape <code>(labels)</code> to be fed to a model (when
<code>annotations</code> are provided). They identify the labels of <code>mask_labels</code>, e.g. the label of
<code>mask_labels[i][j]</code> if <code>class_labels[i][j]</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.35.2/en/main_classes/image_processor#transformers.BatchFeature"
>BatchFeature</a></p>
`}}),Je=new I({props:{name:"post_process_semantic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation",parameters:[{name:"outputs",val:""},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_semantic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/image_processing_mask2former.py#L961",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of length <code>batch_size</code>, where each item is a semantic segmentation map of shape (height, width)
corresponding to the target_sizes entry (if <code>target_sizes</code> is specified). Each entry of each
<code>torch.Tensor</code> correspond to a semantic class id.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[torch.Tensor]</code></p>
`}}),$e=new I({props:{name:"post_process_instance_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"},{name:"return_coco_annotation",val:": typing.Optional[bool] = False"},{name:"return_binary_maps",val:": typing.Optional[bool] = False"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.outputs",description:`<strong>outputs</strong> (<a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_coco_annotation",description:`<strong>return_coco_annotation</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned in COCO run-length encoding (RLE) format.`,name:"return_coco_annotation"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_instance_segmentation.return_binary_maps",description:`<strong>return_binary_maps</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If set to <code>True</code>, segmentation maps are returned as a concatenated tensor of binary segmentation maps
(one per detected instance).`,name:"return_binary_maps"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/image_processing_mask2former.py#L1016",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — A tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code> or
<code>List[List]</code> run-length encoding (RLE) of the segmentation map if return_coco_annotation is set to
<code>True</code>. Set to <code>None</code> if no mask if found above <code>threshold</code>.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — An integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),ze=new I({props:{name:"post_process_panoptic_segmentation",anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"mask_threshold",val:": float = 0.5"},{name:"overlap_mask_area_threshold",val:": float = 0.8"},{name:"label_ids_to_fuse",val:": typing.Optional[typing.Set[int]] = None"},{name:"target_sizes",val:": typing.Union[typing.List[typing.Tuple[int, int]], NoneType] = None"}],parametersDescription:[{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.outputs",description:`<strong>outputs</strong> (<code>Mask2FormerForUniversalSegmentationOutput</code>) &#x2014;
The outputs from <a href="/docs/transformers/v4.35.2/en/model_doc/mask2former#transformers.Mask2FormerForUniversalSegmentation">Mask2FormerForUniversalSegmentation</a>.`,name:"outputs"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The probability score threshold to keep predicted instance masks.`,name:"threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.mask_threshold",description:`<strong>mask_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Threshold to use when turning the predicted masks into binary values.`,name:"mask_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.overlap_mask_area_threshold",description:`<strong>overlap_mask_area_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.8) &#x2014;
The overlap mask area threshold to merge or discard small disconnected parts within each binary
instance mask.`,name:"overlap_mask_area_threshold"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.label_ids_to_fuse",description:`<strong>label_ids_to_fuse</strong> (<code>Set[int]</code>, <em>optional</em>) &#x2014;
The labels in this state will have all their instances be fused together. For instance we could say
there can only be one sky in an image, but several persons, so the label ID for sky would be in that
set, but not the one for person.`,name:"label_ids_to_fuse"},{anchor:"transformers.Mask2FormerImageProcessor.post_process_panoptic_segmentation.target_sizes",description:`<strong>target_sizes</strong> (<code>List[Tuple]</code>, <em>optional</em>) &#x2014;
List of length (batch_size), where each list item (<code>Tuple[int, int]]</code>) corresponds to the requested
final size (height, width) of each prediction in batch. If left to None, predictions will not be
resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/v4.35.2/src/transformers/models/mask2former/image_processing_mask2former.py#L1135",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, one per image, each dictionary containing two keys:</p>
<ul>
<li><strong>segmentation</strong> — a tensor of shape <code>(height, width)</code> where each pixel represents a <code>segment_id</code>, set
to <code>None</code> if no mask if found above <code>threshold</code>. If <code>target_sizes</code> is specified, segmentation is resized
to the corresponding <code>target_sizes</code> entry.</li>
<li><strong>segments_info</strong> — A dictionary that contains additional information on each segment.<ul>
<li><strong>id</strong> — an integer representing the <code>segment_id</code>.</li>
<li><strong>label_id</strong> — An integer representing the label / semantic class id corresponding to <code>segment_id</code>.</li>
<li><strong>was_fused</strong> — a boolean, <code>True</code> if <code>label_id</code> was in <code>label_ids_to_fuse</code>, <code>False</code> otherwise.
Multiple instances of the same class / label were fused and assigned a single <code>segment_id</code>.</li>
<li><strong>score</strong> — Prediction score of segment with <code>segment_id</code>.</li>
</ul></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),{c(){r=m("meta"),w=n(),p=m("p"),c=n(),h(y.$$.fragment),t=n(),h(k.$$.fragment),at=n(),oe=m("p"),oe.innerHTML=ho,rt=n(),se=m("p"),se.textContent=fo,it=n(),ne=m("p"),ne.innerHTML=uo,lt=n(),ae=m("p"),ae.textContent=_o,mt=n(),re=m("ul"),re.innerHTML=bo,dt=n(),G=m("img"),ct=n(),ie=m("small"),ie.innerHTML=yo,pt=n(),le=m("p"),le.innerHTML=ko,gt=n(),h(me.$$.fragment),ht=n(),de=m("p"),de.textContent=wo,ft=n(),ce=m("ul"),ce.innerHTML=vo,ut=n(),pe=m("p"),pe.textContent=Fo,_t=n(),h(ge.$$.fragment),bt=n(),B=m("div"),h(he.$$.fragment),Wt=n(),Ne=m("p"),Ne.innerHTML=To,Mt=n(),C=m("div"),h(fe.$$.fragment),Ct=n(),Ze=m("p"),Ze.innerHTML=xo,Nt=n(),Xe=m("p"),Xe.innerHTML=Uo,yt=n(),h(ue.$$.fragment),kt=n(),x=m("div"),h(_e.$$.fragment),Zt=n(),Ve=m("p"),Ve.innerHTML=jo,Xt=n(),Be=m("p"),Be.innerHTML=Jo,Vt=n(),Re=m("p"),Re.innerHTML=$o,Bt=n(),h(P.$$.fragment),Rt=n(),H=m("div"),h(be.$$.fragment),Lt=n(),Le=m("p"),Le.innerHTML=zo,wt=n(),h(Me.$$.fragment),vt=n(),N=m("div"),h(ye.$$.fragment),St=n(),Se=m("p"),Se.innerHTML=Io,Gt=n(),W=m("div"),h(ke.$$.fragment),Pt=n(),Ge=m("p"),Ge.innerHTML=Wo,Ht=n(),h(q.$$.fragment),qt=n(),h(Y.$$.fragment),Ft=n(),h(we.$$.fragment),Tt=n(),Z=m("div"),h(ve.$$.fragment),Yt=n(),Pe=m("p"),Pe.innerHTML=Co,Et=n(),T=m("div"),h(Fe.$$.fragment),Qt=n(),He=m("p"),He.innerHTML=No,At=n(),h(E.$$.fragment),Ot=n(),qe=m("p"),qe.textContent=Zo,Dt=n(),h(Q.$$.fragment),Kt=n(),h(A.$$.fragment),eo=n(),h(O.$$.fragment),xt=n(),h(Te.$$.fragment),Ut=n(),v=m("div"),h(xe.$$.fragment),to=n(),Ye=m("p"),Ye.textContent=Xo,oo=n(),Ee=m("p"),Ee.innerHTML=Vo,so=n(),Qe=m("div"),h(Ue.$$.fragment),no=n(),V=m("div"),h(je.$$.fragment),ao=n(),Ae=m("p"),Ae.innerHTML=Bo,ro=n(),Oe=m("p"),Oe.innerHTML=Ro,io=n(),D=m("div"),h(Je.$$.fragment),lo=n(),De=m("p"),De.innerHTML=Lo,mo=n(),K=m("div"),h($e.$$.fragment),co=n(),Ke=m("p"),Ke.innerHTML=So,po=n(),ee=m("div"),h(ze.$$.fragment),go=n(),et=m("p"),et.innerHTML=Go,jt=n(),ot=m("p"),this.h()},l(e){const s=Oo("svelte-u9bgzb",document.head);r=d(s,"META",{name:!0,content:!0}),s.forEach(o),w=a(e),p=d(e,"P",{}),J(p).forEach(o),c=a(e),f(y.$$.fragment,e),t=a(e),f(k.$$.fragment,e),at=a(e),oe=d(e,"P",{"data-svelte-h":!0}),g(oe)!=="svelte-vv3e67"&&(oe.innerHTML=ho),rt=a(e),se=d(e,"P",{"data-svelte-h":!0}),g(se)!=="svelte-vfdo9a"&&(se.textContent=fo),it=a(e),ne=d(e,"P",{"data-svelte-h":!0}),g(ne)!=="svelte-12dpxkq"&&(ne.innerHTML=uo),lt=a(e),ae=d(e,"P",{"data-svelte-h":!0}),g(ae)!=="svelte-axv494"&&(ae.textContent=_o),mt=a(e),re=d(e,"UL",{"data-svelte-h":!0}),g(re)!=="svelte-1vamw8q"&&(re.innerHTML=bo),dt=a(e),G=d(e,"IMG",{src:!0,alt:!0,width:!0}),ct=a(e),ie=d(e,"SMALL",{"data-svelte-h":!0}),g(ie)!=="svelte-1qlm9ke"&&(ie.innerHTML=yo),pt=a(e),le=d(e,"P",{"data-svelte-h":!0}),g(le)!=="svelte-12ct8xd"&&(le.innerHTML=ko),gt=a(e),f(me.$$.fragment,e),ht=a(e),de=d(e,"P",{"data-svelte-h":!0}),g(de)!=="svelte-m0sdby"&&(de.textContent=wo),ft=a(e),ce=d(e,"UL",{"data-svelte-h":!0}),g(ce)!=="svelte-783z7i"&&(ce.innerHTML=vo),ut=a(e),pe=d(e,"P",{"data-svelte-h":!0}),g(pe)!=="svelte-1rggs50"&&(pe.textContent=Fo),_t=a(e),f(ge.$$.fragment,e),bt=a(e),B=d(e,"DIV",{class:!0});var Ie=J(B);f(he.$$.fragment,Ie),Wt=a(Ie),Ne=d(Ie,"P",{"data-svelte-h":!0}),g(Ne)!=="svelte-1eqvf92"&&(Ne.innerHTML=To),Ie.forEach(o),Mt=a(e),C=d(e,"DIV",{class:!0});var R=J(C);f(fe.$$.fragment,R),Ct=a(R),Ze=d(R,"P",{"data-svelte-h":!0}),g(Ze)!=="svelte-1cgna0v"&&(Ze.innerHTML=xo),Nt=a(R),Xe=d(R,"P",{"data-svelte-h":!0}),g(Xe)!=="svelte-1phtgas"&&(Xe.innerHTML=Uo),R.forEach(o),yt=a(e),f(ue.$$.fragment,e),kt=a(e),x=d(e,"DIV",{class:!0});var $=J(x);f(_e.$$.fragment,$),Zt=a($),Ve=d($,"P",{"data-svelte-h":!0}),g(Ve)!=="svelte-130hcsx"&&(Ve.innerHTML=jo),Xt=a($),Be=d($,"P",{"data-svelte-h":!0}),g(Be)!=="svelte-1g275hz"&&(Be.innerHTML=Jo),Vt=a($),Re=d($,"P",{"data-svelte-h":!0}),g(Re)!=="svelte-938vl7"&&(Re.innerHTML=$o),Bt=a($),f(P.$$.fragment,$),Rt=a($),H=d($,"DIV",{class:!0});var We=J(H);f(be.$$.fragment,We),Lt=a(We),Le=d(We,"P",{"data-svelte-h":!0}),g(Le)!=="svelte-e6wk84"&&(Le.innerHTML=zo),We.forEach(o),$.forEach(o),wt=a(e),f(Me.$$.fragment,e),vt=a(e),N=d(e,"DIV",{class:!0});var L=J(N);f(ye.$$.fragment,L),St=a(L),Se=d(L,"P",{"data-svelte-h":!0}),g(Se)!=="svelte-14icbh2"&&(Se.innerHTML=Io),Gt=a(L),W=d(L,"DIV",{class:!0});var X=J(W);f(ke.$$.fragment,X),Pt=a(X),Ge=d(X,"P",{"data-svelte-h":!0}),g(Ge)!=="svelte-1svtn4t"&&(Ge.innerHTML=Wo),Ht=a(X),f(q.$$.fragment,X),qt=a(X),f(Y.$$.fragment,X),X.forEach(o),L.forEach(o),Ft=a(e),f(we.$$.fragment,e),Tt=a(e),Z=d(e,"DIV",{class:!0});var S=J(Z);f(ve.$$.fragment,S),Yt=a(S),Pe=d(S,"P",{"data-svelte-h":!0}),g(Pe)!=="svelte-dh9ww1"&&(Pe.innerHTML=Co),Et=a(S),T=d(S,"DIV",{class:!0});var z=J(T);f(Fe.$$.fragment,z),Qt=a(z),He=d(z,"P",{"data-svelte-h":!0}),g(He)!=="svelte-sypzo9"&&(He.innerHTML=No),At=a(z),f(E.$$.fragment,z),Ot=a(z),qe=d(z,"P",{"data-svelte-h":!0}),g(qe)!=="svelte-kvfsh7"&&(qe.textContent=Zo),Dt=a(z),f(Q.$$.fragment,z),Kt=a(z),f(A.$$.fragment,z),eo=a(z),f(O.$$.fragment,z),z.forEach(o),S.forEach(o),xt=a(e),f(Te.$$.fragment,e),Ut=a(e),v=d(e,"DIV",{class:!0});var j=J(v);f(xe.$$.fragment,j),to=a(j),Ye=d(j,"P",{"data-svelte-h":!0}),g(Ye)!=="svelte-1te0494"&&(Ye.textContent=Xo),oo=a(j),Ee=d(j,"P",{"data-svelte-h":!0}),g(Ee)!=="svelte-1wh3jgn"&&(Ee.innerHTML=Vo),so=a(j),Qe=d(j,"DIV",{class:!0});var Po=J(Qe);f(Ue.$$.fragment,Po),Po.forEach(o),no=a(j),V=d(j,"DIV",{class:!0});var tt=J(V);f(je.$$.fragment,tt),ao=a(tt),Ae=d(tt,"P",{"data-svelte-h":!0}),g(Ae)!=="svelte-1tetyua"&&(Ae.innerHTML=Bo),ro=a(tt),Oe=d(tt,"P",{"data-svelte-h":!0}),g(Oe)!=="svelte-1gqhxe4"&&(Oe.innerHTML=Ro),tt.forEach(o),io=a(j),D=d(j,"DIV",{class:!0});var $t=J(D);f(Je.$$.fragment,$t),lo=a($t),De=d($t,"P",{"data-svelte-h":!0}),g(De)!=="svelte-jr6dlu"&&(De.innerHTML=Lo),$t.forEach(o),mo=a(j),K=d(j,"DIV",{class:!0});var zt=J(K);f($e.$$.fragment,zt),co=a(zt),Ke=d(zt,"P",{"data-svelte-h":!0}),g(Ke)!=="svelte-31bvgi"&&(Ke.innerHTML=So),zt.forEach(o),po=a(j),ee=d(j,"DIV",{class:!0});var It=J(ee);f(ze.$$.fragment,It),go=a(It),et=d(It,"P",{"data-svelte-h":!0}),g(et)!=="svelte-ay0y3u"&&(et.innerHTML=Go),It.forEach(o),j.forEach(o),jt=a(e),ot=d(e,"P",{}),J(ot).forEach(o),this.h()},h(){F(r,"name","hf:doc:metadata"),F(r,"content",rs),Yo(G.src,Mo="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/mask2former_architecture.jpg")||F(G,"src",Mo),F(G,"alt","drawing"),F(G,"width","600"),F(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),F(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){i(document.head,r),l(e,w,s),l(e,p,s),l(e,c,s),u(y,e,s),l(e,t,s),u(k,e,s),l(e,at,s),l(e,oe,s),l(e,rt,s),l(e,se,s),l(e,it,s),l(e,ne,s),l(e,lt,s),l(e,ae,s),l(e,mt,s),l(e,re,s),l(e,dt,s),l(e,G,s),l(e,ct,s),l(e,ie,s),l(e,pt,s),l(e,le,s),l(e,gt,s),u(me,e,s),l(e,ht,s),l(e,de,s),l(e,ft,s),l(e,ce,s),l(e,ut,s),l(e,pe,s),l(e,_t,s),u(ge,e,s),l(e,bt,s),l(e,B,s),u(he,B,null),i(B,Wt),i(B,Ne),l(e,Mt,s),l(e,C,s),u(fe,C,null),i(C,Ct),i(C,Ze),i(C,Nt),i(C,Xe),l(e,yt,s),u(ue,e,s),l(e,kt,s),l(e,x,s),u(_e,x,null),i(x,Zt),i(x,Ve),i(x,Xt),i(x,Be),i(x,Vt),i(x,Re),i(x,Bt),u(P,x,null),i(x,Rt),i(x,H),u(be,H,null),i(H,Lt),i(H,Le),l(e,wt,s),u(Me,e,s),l(e,vt,s),l(e,N,s),u(ye,N,null),i(N,St),i(N,Se),i(N,Gt),i(N,W),u(ke,W,null),i(W,Pt),i(W,Ge),i(W,Ht),u(q,W,null),i(W,qt),u(Y,W,null),l(e,Ft,s),u(we,e,s),l(e,Tt,s),l(e,Z,s),u(ve,Z,null),i(Z,Yt),i(Z,Pe),i(Z,Et),i(Z,T),u(Fe,T,null),i(T,Qt),i(T,He),i(T,At),u(E,T,null),i(T,Ot),i(T,qe),i(T,Dt),u(Q,T,null),i(T,Kt),u(A,T,null),i(T,eo),u(O,T,null),l(e,xt,s),u(Te,e,s),l(e,Ut,s),l(e,v,s),u(xe,v,null),i(v,to),i(v,Ye),i(v,oo),i(v,Ee),i(v,so),i(v,Qe),u(Ue,Qe,null),i(v,no),i(v,V),u(je,V,null),i(V,ao),i(V,Ae),i(V,ro),i(V,Oe),i(v,io),i(v,D),u(Je,D,null),i(D,lo),i(D,De),i(v,mo),i(v,K),u($e,K,null),i(K,co),i(K,Ke),i(v,po),i(v,ee),u(ze,ee,null),i(ee,go),i(ee,et),l(e,jt,s),l(e,ot,s),Jt=!0},p(e,[s]){const Ie={};s&2&&(Ie.$$scope={dirty:s,ctx:e}),P.$set(Ie);const R={};s&2&&(R.$$scope={dirty:s,ctx:e}),q.$set(R);const $={};s&2&&($.$$scope={dirty:s,ctx:e}),Y.$set($);const We={};s&2&&(We.$$scope={dirty:s,ctx:e}),E.$set(We);const L={};s&2&&(L.$$scope={dirty:s,ctx:e}),Q.$set(L);const X={};s&2&&(X.$$scope={dirty:s,ctx:e}),A.$set(X);const S={};s&2&&(S.$$scope={dirty:s,ctx:e}),O.$set(S)},i(e){Jt||(_(y.$$.fragment,e),_(k.$$.fragment,e),_(me.$$.fragment,e),_(ge.$$.fragment,e),_(he.$$.fragment,e),_(fe.$$.fragment,e),_(ue.$$.fragment,e),_(_e.$$.fragment,e),_(P.$$.fragment,e),_(be.$$.fragment,e),_(Me.$$.fragment,e),_(ye.$$.fragment,e),_(ke.$$.fragment,e),_(q.$$.fragment,e),_(Y.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_(Fe.$$.fragment,e),_(E.$$.fragment,e),_(Q.$$.fragment,e),_(A.$$.fragment,e),_(O.$$.fragment,e),_(Te.$$.fragment,e),_(xe.$$.fragment,e),_(Ue.$$.fragment,e),_(je.$$.fragment,e),_(Je.$$.fragment,e),_($e.$$.fragment,e),_(ze.$$.fragment,e),Jt=!0)},o(e){b(y.$$.fragment,e),b(k.$$.fragment,e),b(me.$$.fragment,e),b(ge.$$.fragment,e),b(he.$$.fragment,e),b(fe.$$.fragment,e),b(ue.$$.fragment,e),b(_e.$$.fragment,e),b(P.$$.fragment,e),b(be.$$.fragment,e),b(Me.$$.fragment,e),b(ye.$$.fragment,e),b(ke.$$.fragment,e),b(q.$$.fragment,e),b(Y.$$.fragment,e),b(we.$$.fragment,e),b(ve.$$.fragment,e),b(Fe.$$.fragment,e),b(E.$$.fragment,e),b(Q.$$.fragment,e),b(A.$$.fragment,e),b(O.$$.fragment,e),b(Te.$$.fragment,e),b(xe.$$.fragment,e),b(Ue.$$.fragment,e),b(je.$$.fragment,e),b(Je.$$.fragment,e),b($e.$$.fragment,e),b(ze.$$.fragment,e),Jt=!1},d(e){e&&(o(w),o(p),o(c),o(t),o(at),o(oe),o(rt),o(se),o(it),o(ne),o(lt),o(ae),o(mt),o(re),o(dt),o(G),o(ct),o(ie),o(pt),o(le),o(gt),o(ht),o(de),o(ft),o(ce),o(ut),o(pe),o(_t),o(bt),o(B),o(Mt),o(C),o(yt),o(kt),o(x),o(wt),o(vt),o(N),o(Ft),o(Tt),o(Z),o(xt),o(Ut),o(v),o(jt),o(ot)),o(r),M(y,e),M(k,e),M(me,e),M(ge,e),M(he),M(fe),M(ue,e),M(_e),M(P),M(be),M(Me,e),M(ye),M(ke),M(q),M(Y),M(we,e),M(ve),M(Fe),M(E),M(Q),M(A),M(O),M(Te,e),M(xe),M(Ue),M(je),M(Je),M($e),M(ze)}}}const rs='{"title":"Mask2Former","local":"mask2former","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"MaskFormer specific outputs","local":"transformers.models.mask2former.modeling_mask2former.Mask2FormerModelOutput","sections":[],"depth":2},{"title":"Mask2FormerConfig","local":"transformers.Mask2FormerConfig","sections":[],"depth":2},{"title":"Mask2FormerModel","local":"transformers.Mask2FormerModel","sections":[],"depth":2},{"title":"Mask2FormerForUniversalSegmentation","local":"transformers.Mask2FormerForUniversalSegmentation","sections":[],"depth":2},{"title":"Mask2FormerImageProcessor","local":"transformers.Mask2FormerImageProcessor","sections":[],"depth":2}],"depth":1}';function is(U){return Eo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends Qo{constructor(r){super(),Ao(this,r,is,as,qo,{})}}export{fs as component};
