import{s as ol,o as rl,n as cl}from"../chunks/scheduler.00bde567.js";import{S as pl,i as dl,g as i,s,r as c,A as ul,h as o,f as l,c as a,j as al,u as p,x as r,k as il,y as ml,a as n,v as d,d as u,t as m,w as h}from"../chunks/index.752e2ff6.js";import{T as hl}from"../chunks/Tip.6fda87e9.js";import{C as w}from"../chunks/CodeBlock.e62cd1dc.js";import{H as f}from"../chunks/Heading.476d3364.js";function Ml(Je){let M,b="The inner function <em>must</em> take in the batch size as the first parameter, but we do not pass one to it when called. The wrapper handles this for us.";return{c(){M=i("p"),M.innerHTML=b},l(y){M=o(y,"P",{"data-svelte-h":!0}),r(M)!=="svelte-19ctrqw"&&(M.innerHTML=b)},m(y,Te){n(y,M,Te)},p:cl,d(y){y&&l(M)}}}function fl(Je){let M,b,y,Te,T,je,U,vt=`This guide aims to provide you the tools and knowledge required to navigate some common issues. However,
as 🤗 Accelerate continuously evolves and the use cases and setups are diverse, you might encounter an issue not covered in this
guide. If the suggestions listed in this guide do not cover your such situation, please refer to the final section of
the guide, <a href="#ask-for-help">Asking for Help</a>, to learn where to find help with your specific issue.`,$e,J,ve,j,Ct=`When facing an error, logging can help narrow down where it is coming from. In a distributed setup with multiple processes,
logging can be a challenge, but 🤗 Accelerate provides a utility that streamlines the logging process and ensures that
logs are synchronized and managed effectively across the distributed setup.`,Ce,$,It="To troubleshoot an issue, use <code>accelerate.logging</code> instead of the standard Python <code>logging</code> module:",Ie,v,_e,C,_t=`To set the log level (<code>INFO</code>, <code>DEBUG</code>, <code>WARNING</code>, <code>ERROR</code>, <code>CRITICAL</code>), export it as the <code>ACCELERATE_LOG_LEVEL</code> environment,
or pass as <code>log_level</code> to <code>get_logger</code>:`,Ge,I,xe,_,Gt=`By default, the log is called on main processes only. To call it on all processes, pass <code>main_process_only=False</code>.
If a log should be called on all processes and in order, also pass <code>in_order=True</code>.`,ke,G,Ze,x,Ae,k,xt=`If your code seems to be hanging for a significant amount time on a distributed setup, a common cause is mismatched shapes of tensors on different
devices.`,We,Z,kt=`When running scripts in a distributed fashion, functions such as <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.gather">Accelerator.gather()</a> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.reduce">Accelerator.reduce()</a> are
necessary to grab tensors across devices to perform operations on them collectively. These (and other) functions rely on
<code>torch.distributed</code> performing a <code>gather</code> operation, which requires that tensors have the <strong>exact same shape</strong> across all processes.
When the tensor shapes don’t match, you will experience handing code, and eventually hit a timeout exception.`,Be,A,Zt="If you suspect this to be the case, use Accelerate’s operational debug mode to immediately catch the issue.",Ve,W,At=`The recommended way to enable Accelerate’s operational debug mode is during <code>accelerate config</code> setup.
Alternative ways to enable debug mode are:`,Fe,B,Wt="<li>From the CLI:</li>",He,V,Xe,F,Bt="<li>As an environmental variable (which avoids the need for <code>accelerate launch</code>):</li>",Ye,H,ze,X,Vt="<li>Manually changing the <code>config.yaml</code> file:</li>",Ee,Y,Le,z,Ft="Once you enable the debug mode, you should get a similar traceback that points to the tensor shape mismatch issue:",Ne,E,Re,L,Qe,N,Ht=`When doing early stopping in distributed training, if each process has a specific stopping condition (e.g. validation loss),
it may not be synchronized across all of them. As a result, a break can happen on process 0 but not on process 1.
This will cause the code to hang indefinitely until a timeout occurs.`,Pe,R,Xt=`If you have early stopping conditionals, use <code>set_breakpoint</code> and <code>check_breakpoint</code> methods to make sure all the processes
are ended correctly:`,Se,Q,qe,P,De,S,Yt=`This is a known issue. On Linux with kernel version < 5.5, hanging processes have been reported. To avoid
encountering this problem, we recommend upgrading your system to a later kernel version.`,Oe,q,Ke,D,zt=`One of the most frustrating errors when it comes to running training scripts is hitting “CUDA Out-of-Memory”,
as the entire script needs to be restarted, progress is lost, and typically a developer would want to simply
start their script and let it run.`,et,O,Et=`To address this problem, <code>Accelerate</code> offers a utility <code>find_executable_batch_size</code> that is heavily based on <a href="https://github.com/BlackHC/toma" rel="nofollow">toma</a>.
The utility retries code that fails due to OOM (out-of-memory) conditions and lowers batch sizes automatically.`,tt,K,lt,ee,Lt=`This algorithm operates with exponential decay, decreasing the batch size in half after each failed run on some
training script. To use it, restructure your training function to include an inner function that includes this wrapper,
and build your dataloaders inside it. At a minimum, this could look like 4 new lines of code.`,nt,g,st,te,Nt=`It should also be noted that anything which will consume CUDA memory and passed to the <code>accelerator</code> <strong>must</strong> be declared inside the inner function,
such as models and optimizers.`,at,le,it,ne,Rt='To find out more, check the documentation <a href="../package_reference/utilities#accelerate.find_executable_batch_size">here</a>.',ot,se,rt,ae,Qt=`If you have changed the device setup and are observing different model performance, this is likely due to the fact that
you have not updated your script when moving from one setup to another. The same script with the same batch size across TPU,
multi-GPU, and single-GPU with Accelerate will have different results.`,ct,ie,Pt=`For example, if you were previously training on a single GPU with a batch size of 16, when moving to two GPU setup,
you need to change the batch size to 8 to have the same effective batch size. This is because when training with Accelerate,
the batch size passed to the dataloader is the <strong>batch size per GPU</strong>.`,pt,oe,St=`To make sure you can reproduce the results between the setups, make sure to use the same seed, adjust the batch size
accordingly, consider scaling the learning rate.`,dt,re,qt='For more details and a quick reference for batch sizes, check out the <a href="../concept_guides/performance">Comparing performance between different device setups</a> guide.',ut,ce,mt,pe,Dt="If your multi-GPU setup consists of different GPUs, you may hit some limitations:",ht,de,Ot="<li>There may be an imbalance in GPU memory between the GPUs. In this case, the GPU with smaller memory will limit the batch size or the size of the model that can be loaded onto the GPUs.</li> <li>If you are using GPUs with different performance profiles, the performance will be driven by the slowest GPU that you are using as the other GPUs will have to wait for it to complete its workload.</li>",Mt,ue,Kt="Vastly different GPUs within the same setup can lead to performance bottlenecks.",ft,me,yt,he,el=`If the above troubleshooting tools and advice did not help you resolve your issue, reach out for help to the community
and the team.`,gt,Me,wt,fe,tl=`Ask for help on the Hugging Face forums - post your question in the <a href="https://discuss.huggingface.co/c/accelerate/18" rel="nofollow">🤗Accelerate category</a>
Make sure to write a descriptive post with relevant context about your setup and reproducible code to maximize the likelihood that your problem is solved!`,bt,ye,Tt,ge,ll='Post a question on <a href="http://hf.co/join/discord" rel="nofollow">Discord</a>, and let the team and the community help you.',Ut,we,Jt,be,nl=`Create an Issue on the 🤗 Accelerate <a href="https://github.com/huggingface/accelerate/issues" rel="nofollow">GitHub repository</a> if you suspect
to have found a bug related to the library. Include context regarding the bug and details about your distributed setup
to help us better figure out what’s wrong and how we can fix it.`,jt,Ue,$t;return T=new f({props:{title:"Troubleshooting guide",local:"troubleshooting-guide",headingTag:"h1"}}),J=new f({props:{title:"Logging",local:"logging",headingTag:"h2"}}),v=new w({props:{code:"LSUyMGltcG9ydCUyMGxvZ2dpbmclMEElMkIlMjBmcm9tJTIwYWNjZWxlcmF0ZS5sb2dnaW5nJTIwaW1wb3J0JTIwZ2V0X2xvZ2dlciUwQS0lMjBsb2dnZXIlMjAlM0QlMjBsb2dnaW5nLmdldExvZ2dlcihfX25hbWVfXyklMEElMkIlMjBsb2dnZXIlMjAlM0QlMjBnZXRfbG9nZ2VyKF9fbmFtZV9fKQ==",highlighted:`<span class="hljs-deletion">- import logging</span>
<span class="hljs-addition">+ from accelerate.logging import get_logger</span>
<span class="hljs-deletion">- logger = logging.getLogger(__name__)</span>
<span class="hljs-addition">+ logger = get_logger(__name__)</span>`,wrap:!1}}),I=new w({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUubG9nZ2luZyUyMGltcG9ydCUyMGdldF9sb2dnZXIlMEElMEFsb2dnZXIlMjAlM0QlMjBnZXRfbG9nZ2VyKF9fbmFtZV9fJTJDJTIwbG9nX2xldmVsJTNEJTIySU5GTyUyMik=",highlighted:`<span class="hljs-keyword">from</span> accelerate.logging <span class="hljs-keyword">import</span> get_logger

logger = get_logger(__name__, log_level=<span class="hljs-string">&quot;INFO&quot;</span>)`,wrap:!1}}),G=new f({props:{title:"Hanging code and timeout errors",local:"hanging-code-and-timeout-errors",headingTag:"h2"}}),x=new f({props:{title:"Mismatched tensor shapes",local:"mismatched-tensor-shapes",headingTag:"h3"}}),V=new w({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZGVidWclMjAlN0JteV9zY3JpcHQucHklN0QlMjAtLWFyZzElMjAtLWFyZzI=",highlighted:"accelerate launch --debug {my_script.py} --arg1 --arg2",wrap:!1}}),H=new w({props:{code:"QUNDRUxFUkFURV9ERUJVR19NT0RFJTNEJTIyMSUyMiUyMHRvcmNocnVuJTIwJTdCbXlfc2NyaXB0LnB5JTdEJTIwLS1hcmcxJTIwLS1hcmcy",highlighted:'ACCELERATE_DEBUG_MODE=<span class="hljs-string">&quot;1&quot;</span> torchrun {my_script.py} --arg1 --arg2',wrap:!1}}),Y=new w({props:{code:"JTIwY29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEElMkJkZWJ1ZyUzQSUyMHRydWU=",highlighted:` compute_environment: LOCAL_MACHINE
<span class="hljs-addition">+debug: true</span>`,wrap:!1}}),E=new w({props:{code:"VHJhY2ViYWNrJTIwKG1vc3QlMjByZWNlbnQlMjBjYWxsJTIwbGFzdCklM0ElMEElMjAlMjBGaWxlJTIwJTIyJTJGaG9tZSUyRnphY2hfbXVlbGxlcl9odWdnaW5nZmFjZV9jbyUyRnRlc3QucHklMjIlMkMlMjBsaW5lJTIwMTglMkMlMjBpbiUyMCUzQ21vZHVsZSUzRSUwQSUyMCUyMCUyMCUyMG1haW4oKSUwQSUyMCUyMEZpbGUlMjAlMjIlMkZob21lJTJGemFjaF9tdWVsbGVyX2h1Z2dpbmdmYWNlX2NvJTJGdGVzdC5weSUyMiUyQyUyMGxpbmUlMjAxNSUyQyUyMGluJTIwbWFpbiUwQSUyMCUyMCUyMCUyMGJyb2FkY2FzdF90ZW5zb3IlMjAlM0QlMjBicm9hZGNhc3QodGVuc29yKSUwQSUyMCUyMEZpbGUlMjAlMjIlMkZob21lJTJGemFjaF9tdWVsbGVyX2h1Z2dpbmdmYWNlX2NvJTJGYWNjZWxlcmF0ZSUyRnNyYyUyRmFjY2VsZXJhdGUlMkZ1dGlscyUyRm9wZXJhdGlvbnMucHklMjIlMkMlMjBsaW5lJTIwMzAzJTJDJTIwaW4lMjB3cmFwcGVyJTBBYWNjZWxlcmF0ZS51dGlscy5vcGVyYXRpb25zLkRpc3RyaWJ1dGVkT3BlcmF0aW9uRXhjZXB0aW9uJTNBJTBBJTBBQ2Fubm90JTIwYXBwbHklMjBkZXNpcmVkJTIwb3BlcmF0aW9uJTIwZHVlJTIwdG8lMjBzaGFwZSUyMG1pc21hdGNoZXMuJTIwQWxsJTIwc2hhcGVzJTIwYWNyb3NzJTIwZGV2aWNlcyUyMG11c3QlMjBiZSUyMHZhbGlkLiUwQSUwQU9wZXJhdGlvbiUzQSUyMCU2MGFjY2VsZXJhdGUudXRpbHMub3BlcmF0aW9ucy5icm9hZGNhc3QlNjAlMEFJbnB1dCUyMHNoYXBlcyUzQSUwQSUyMCUyMC0lMjBQcm9jZXNzJTIwMCUzQSUyMCU1QjElMkMlMjA1JTVEJTBBJTIwJTIwLSUyMFByb2Nlc3MlMjAxJTNBJTIwJTVCMSUyQyUyMDIlMkMlMjA1JTVE",highlighted:`Traceback (most recent call last):
  File <span class="hljs-string">&quot;/home/zach_mueller_huggingface_co/test.py&quot;</span>, line <span class="hljs-number">18</span>, <span class="hljs-keyword">in</span> &lt;module&gt;
    main()
  File <span class="hljs-string">&quot;/home/zach_mueller_huggingface_co/test.py&quot;</span>, line <span class="hljs-number">15</span>, <span class="hljs-keyword">in</span> main
    broadcast_tensor = broadcast(tensor)
  File <span class="hljs-string">&quot;/home/zach_mueller_huggingface_co/accelerate/src/accelerate/utils/operations.py&quot;</span>, line <span class="hljs-number">303</span>, <span class="hljs-keyword">in</span> wrapper
accelerate.utils.operations.DistributedOperationException:

Cannot apply desired operation due to shape mismatches. All shapes across devices must be valid.

Operation: \`accelerate.utils.operations.broadcast\`
Input shapes:
  - Process <span class="hljs-number">0</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">5</span>]
  - Process <span class="hljs-number">1</span>: [<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">5</span>]`,wrap:!1}}),L=new f({props:{title:"Early stopping leads to hanging",local:"early-stopping-leads-to-hanging",headingTag:"h3"}}),Q=new w({props:{code:"JTIzJTIwQXNzdW1lJTIwJTYwc2hvdWxkX2RvX2JyZWFrcG9pbnQlNjAlMjBpcyUyMGElMjBjdXN0b20lMjBkZWZpbmVkJTIwZnVuY3Rpb24lMjB0aGF0JTIwcmV0dXJucyUyMGElMjBjb25kaXRpb25hbCUyQyUyMCUwQSUyMyUyMGFuZCUyMHRoYXQlMjBjb25kaXRpb25hbCUyMG1pZ2h0JTIwYmUlMjB0cnVlJTIwb25seSUyMG9uJTIwcHJvY2VzcyUyMDElMEFpZiUyMHNob3VsZF9kb19icmVha3BvaW50KGxvc3MpJTNBJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc2V0X2JyZWFrcG9pbnQoKSUwQSUwQSUyMyUyMExhdGVyJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMHNjcmlwdCUyMHdoZW4lMjB3ZSUyMG5lZWQlMjB0byUyMGNoZWNrJTIwZm9yJTIwdGhlJTIwYnJlYWtwb2ludCUwQWlmJTIwYWNjZWxlcmF0b3IuY2hlY2tfYnJlYWtwb2ludCgpJTNBJTBBJTIwJTIwJTIwJTIwYnJlYWs=",highlighted:`<span class="hljs-comment"># Assume \`should_do_breakpoint\` is a custom defined function that returns a conditional, </span>
<span class="hljs-comment"># and that conditional might be true only on process 1</span>
<span class="hljs-keyword">if</span> should_do_breakpoint(loss):
    accelerator.set_breakpoint()

<span class="hljs-comment"># Later in the training script when we need to check for the breakpoint</span>
<span class="hljs-keyword">if</span> accelerator.check_breakpoint():
    <span class="hljs-keyword">break</span>`,wrap:!1}}),P=new f({props:{title:"Hanging on low kernel versions on Linux",local:"hanging-on-low-kernel-versions-on-linux",headingTag:"h3"}}),q=new f({props:{title:"CUDA out of memory",local:"cuda-out-of-memory",headingTag:"h2"}}),K=new f({props:{title:"find_executable_batch_size",local:"findexecutablebatchsize",headingTag:"h3"}}),g=new hl({props:{warning:!0,$$slots:{default:[Ml]},$$scope:{ctx:Je}}}),le=new w({props:{code:"ZGVmJTIwdHJhaW5pbmdfZnVuY3Rpb24oYXJncyklM0ElMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMEElMkIlMjAlMjAlMjAlNDBmaW5kX2V4ZWN1dGFibGVfYmF0Y2hfc2l6ZShzdGFydGluZ19iYXRjaF9zaXplJTNEYXJncy5iYXRjaF9zaXplKSUwQSUyQiUyMCUyMCUyMGRlZiUyMGlubmVyX3RyYWluaW5nX2xvb3AoYmF0Y2hfc2l6ZSklM0ElMEElMkIlMjAlMjAlMjAlMjAlMjAlMjAlMjBub25sb2NhbCUyMGFjY2VsZXJhdG9yJTIwJTIzJTIwRW5zdXJlJTIwdGhleSUyMGNhbiUyMGJlJTIwdXNlZCUyMGluJTIwb3VyJTIwY29udGV4dCUwQSUyQiUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmZyZWVfbWVtb3J5KCklMjAlMjMlMjBGcmVlJTIwYWxsJTIwbGluZ2VyaW5nJTIwcmVmZXJlbmNlcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwZ2V0X21vZGVsKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbC50byhhY2NlbGVyYXRvci5kZXZpY2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwZ2V0X29wdGltaXplcigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhhY2NlbGVyYXRvciUyQyUyMGJhdGNoX3NpemUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RsZW4odHJhaW5fZGF0YWxvYWRlcikqbnVtX2Vwb2NocyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0cmFpbihtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmFsaWRhdGUobW9kZWwlMkMlMjBldmFsX2RhdGFsb2FkZXIpJTBBJTJCJTIwJTIwJTIwaW5uZXJfdHJhaW5pbmdfbG9vcCgp",highlighted:`def training_function(args):
    accelerator = Accelerator()

<span class="hljs-addition">+   @find_executable_batch_size(starting_batch_size=args.batch_size)</span>
<span class="hljs-addition">+   def inner_training_loop(batch_size):</span>
<span class="hljs-addition">+       nonlocal accelerator # Ensure they can be used in our context</span>
<span class="hljs-addition">+       accelerator.free_memory() # Free all lingering references</span>
        model = get_model()
        model.to(accelerator.device)
        optimizer = get_optimizer()
        train_dataloader, eval_dataloader = get_dataloaders(accelerator, batch_size)
        lr_scheduler = get_scheduler(
            optimizer, 
            num_training_steps=len(train_dataloader)*num_epochs
        )
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
            model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
        )
        train(model, optimizer, train_dataloader, lr_scheduler)
        validate(model, eval_dataloader)
<span class="hljs-addition">+   inner_training_loop()</span>`,wrap:!1}}),se=new f({props:{title:"Non-reproducible results between device setups",local:"non-reproducible-results-between-device-setups",headingTag:"h2"}}),ce=new f({props:{title:"Performance issues on different GPUs",local:"performance-issues-on-different-gpus",headingTag:"h2"}}),me=new f({props:{title:"Ask for help",local:"ask-for-help",headingTag:"h2"}}),Me=new f({props:{title:"Forums",local:"forums",headingTag:"h3"}}),ye=new f({props:{title:"Discord",local:"discord",headingTag:"h3"}}),we=new f({props:{title:"GitHub Issues",local:"github-issues",headingTag:"h3"}}),{c(){M=i("meta"),b=s(),y=i("p"),Te=s(),c(T.$$.fragment),je=s(),U=i("p"),U.innerHTML=vt,$e=s(),c(J.$$.fragment),ve=s(),j=i("p"),j.textContent=Ct,Ce=s(),$=i("p"),$.innerHTML=It,Ie=s(),c(v.$$.fragment),_e=s(),C=i("p"),C.innerHTML=_t,Ge=s(),c(I.$$.fragment),xe=s(),_=i("p"),_.innerHTML=Gt,ke=s(),c(G.$$.fragment),Ze=s(),c(x.$$.fragment),Ae=s(),k=i("p"),k.textContent=xt,We=s(),Z=i("p"),Z.innerHTML=kt,Be=s(),A=i("p"),A.textContent=Zt,Ve=s(),W=i("p"),W.innerHTML=At,Fe=s(),B=i("ul"),B.innerHTML=Wt,He=s(),c(V.$$.fragment),Xe=s(),F=i("ul"),F.innerHTML=Bt,Ye=s(),c(H.$$.fragment),ze=s(),X=i("ul"),X.innerHTML=Vt,Ee=s(),c(Y.$$.fragment),Le=s(),z=i("p"),z.textContent=Ft,Ne=s(),c(E.$$.fragment),Re=s(),c(L.$$.fragment),Qe=s(),N=i("p"),N.textContent=Ht,Pe=s(),R=i("p"),R.innerHTML=Xt,Se=s(),c(Q.$$.fragment),qe=s(),c(P.$$.fragment),De=s(),S=i("p"),S.textContent=Yt,Oe=s(),c(q.$$.fragment),Ke=s(),D=i("p"),D.textContent=zt,et=s(),O=i("p"),O.innerHTML=Et,tt=s(),c(K.$$.fragment),lt=s(),ee=i("p"),ee.textContent=Lt,nt=s(),c(g.$$.fragment),st=s(),te=i("p"),te.innerHTML=Nt,at=s(),c(le.$$.fragment),it=s(),ne=i("p"),ne.innerHTML=Rt,ot=s(),c(se.$$.fragment),rt=s(),ae=i("p"),ae.textContent=Qt,ct=s(),ie=i("p"),ie.innerHTML=Pt,pt=s(),oe=i("p"),oe.textContent=St,dt=s(),re=i("p"),re.innerHTML=qt,ut=s(),c(ce.$$.fragment),mt=s(),pe=i("p"),pe.textContent=Dt,ht=s(),de=i("ul"),de.innerHTML=Ot,Mt=s(),ue=i("p"),ue.textContent=Kt,ft=s(),c(me.$$.fragment),yt=s(),he=i("p"),he.textContent=el,gt=s(),c(Me.$$.fragment),wt=s(),fe=i("p"),fe.innerHTML=tl,bt=s(),c(ye.$$.fragment),Tt=s(),ge=i("p"),ge.innerHTML=ll,Ut=s(),c(we.$$.fragment),Jt=s(),be=i("p"),be.innerHTML=nl,jt=s(),Ue=i("p"),this.h()},l(e){const t=ul("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(l),b=a(e),y=o(e,"P",{}),al(y).forEach(l),Te=a(e),p(T.$$.fragment,e),je=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1mwxb2w"&&(U.innerHTML=vt),$e=a(e),p(J.$$.fragment,e),ve=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-1eekw9h"&&(j.textContent=Ct),Ce=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1kz8w00"&&($.innerHTML=It),Ie=a(e),p(v.$$.fragment,e),_e=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-ggx62w"&&(C.innerHTML=_t),Ge=a(e),p(I.$$.fragment,e),xe=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ir4wom"&&(_.innerHTML=Gt),ke=a(e),p(G.$$.fragment,e),Ze=a(e),p(x.$$.fragment,e),Ae=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-7n9u6c"&&(k.textContent=xt),We=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-181xuy8"&&(Z.innerHTML=kt),Be=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1yrrcom"&&(A.textContent=Zt),Ve=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1j9x3vd"&&(W.innerHTML=At),Fe=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-1bdvdaq"&&(B.innerHTML=Wt),He=a(e),p(V.$$.fragment,e),Xe=a(e),F=o(e,"UL",{"data-svelte-h":!0}),r(F)!=="svelte-ng3yx5"&&(F.innerHTML=Bt),Ye=a(e),p(H.$$.fragment,e),ze=a(e),X=o(e,"UL",{"data-svelte-h":!0}),r(X)!=="svelte-cdevdy"&&(X.innerHTML=Vt),Ee=a(e),p(Y.$$.fragment,e),Le=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1t0zm5l"&&(z.textContent=Ft),Ne=a(e),p(E.$$.fragment,e),Re=a(e),p(L.$$.fragment,e),Qe=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-nztggh"&&(N.textContent=Ht),Pe=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-68k5j0"&&(R.innerHTML=Xt),Se=a(e),p(Q.$$.fragment,e),qe=a(e),p(P.$$.fragment,e),De=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-hn6zkz"&&(S.textContent=Yt),Oe=a(e),p(q.$$.fragment,e),Ke=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1a38a5f"&&(D.textContent=zt),et=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-137yewe"&&(O.innerHTML=Et),tt=a(e),p(K.$$.fragment,e),lt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-h7jpn3"&&(ee.textContent=Lt),nt=a(e),p(g.$$.fragment,e),st=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-12qvnq9"&&(te.innerHTML=Nt),at=a(e),p(le.$$.fragment,e),it=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-8y5n2"&&(ne.innerHTML=Rt),ot=a(e),p(se.$$.fragment,e),rt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-1i06b33"&&(ae.textContent=Qt),ct=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1nzle7x"&&(ie.innerHTML=Pt),pt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1qdpl8u"&&(oe.textContent=St),dt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-uhwue4"&&(re.innerHTML=qt),ut=a(e),p(ce.$$.fragment,e),mt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-o85buu"&&(pe.textContent=Dt),ht=a(e),de=o(e,"UL",{"data-svelte-h":!0}),r(de)!=="svelte-1gisw00"&&(de.innerHTML=Ot),Mt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-bc1071"&&(ue.textContent=Kt),ft=a(e),p(me.$$.fragment,e),yt=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-12sn8rq"&&(he.textContent=el),gt=a(e),p(Me.$$.fragment,e),wt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-c1ecgn"&&(fe.innerHTML=tl),bt=a(e),p(ye.$$.fragment,e),Tt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-qmbfjm"&&(ge.innerHTML=ll),Ut=a(e),p(we.$$.fragment,e),Jt=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1xk4ckc"&&(be.innerHTML=nl),jt=a(e),Ue=o(e,"P",{}),al(Ue).forEach(l),this.h()},h(){il(M,"name","hf:doc:metadata"),il(M,"content",yl)},m(e,t){ml(document.head,M),n(e,b,t),n(e,y,t),n(e,Te,t),d(T,e,t),n(e,je,t),n(e,U,t),n(e,$e,t),d(J,e,t),n(e,ve,t),n(e,j,t),n(e,Ce,t),n(e,$,t),n(e,Ie,t),d(v,e,t),n(e,_e,t),n(e,C,t),n(e,Ge,t),d(I,e,t),n(e,xe,t),n(e,_,t),n(e,ke,t),d(G,e,t),n(e,Ze,t),d(x,e,t),n(e,Ae,t),n(e,k,t),n(e,We,t),n(e,Z,t),n(e,Be,t),n(e,A,t),n(e,Ve,t),n(e,W,t),n(e,Fe,t),n(e,B,t),n(e,He,t),d(V,e,t),n(e,Xe,t),n(e,F,t),n(e,Ye,t),d(H,e,t),n(e,ze,t),n(e,X,t),n(e,Ee,t),d(Y,e,t),n(e,Le,t),n(e,z,t),n(e,Ne,t),d(E,e,t),n(e,Re,t),d(L,e,t),n(e,Qe,t),n(e,N,t),n(e,Pe,t),n(e,R,t),n(e,Se,t),d(Q,e,t),n(e,qe,t),d(P,e,t),n(e,De,t),n(e,S,t),n(e,Oe,t),d(q,e,t),n(e,Ke,t),n(e,D,t),n(e,et,t),n(e,O,t),n(e,tt,t),d(K,e,t),n(e,lt,t),n(e,ee,t),n(e,nt,t),d(g,e,t),n(e,st,t),n(e,te,t),n(e,at,t),d(le,e,t),n(e,it,t),n(e,ne,t),n(e,ot,t),d(se,e,t),n(e,rt,t),n(e,ae,t),n(e,ct,t),n(e,ie,t),n(e,pt,t),n(e,oe,t),n(e,dt,t),n(e,re,t),n(e,ut,t),d(ce,e,t),n(e,mt,t),n(e,pe,t),n(e,ht,t),n(e,de,t),n(e,Mt,t),n(e,ue,t),n(e,ft,t),d(me,e,t),n(e,yt,t),n(e,he,t),n(e,gt,t),d(Me,e,t),n(e,wt,t),n(e,fe,t),n(e,bt,t),d(ye,e,t),n(e,Tt,t),n(e,ge,t),n(e,Ut,t),d(we,e,t),n(e,Jt,t),n(e,be,t),n(e,jt,t),n(e,Ue,t),$t=!0},p(e,[t]){const sl={};t&2&&(sl.$$scope={dirty:t,ctx:e}),g.$set(sl)},i(e){$t||(u(T.$$.fragment,e),u(J.$$.fragment,e),u(v.$$.fragment,e),u(I.$$.fragment,e),u(G.$$.fragment,e),u(x.$$.fragment,e),u(V.$$.fragment,e),u(H.$$.fragment,e),u(Y.$$.fragment,e),u(E.$$.fragment,e),u(L.$$.fragment,e),u(Q.$$.fragment,e),u(P.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(g.$$.fragment,e),u(le.$$.fragment,e),u(se.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Me.$$.fragment,e),u(ye.$$.fragment,e),u(we.$$.fragment,e),$t=!0)},o(e){m(T.$$.fragment,e),m(J.$$.fragment,e),m(v.$$.fragment,e),m(I.$$.fragment,e),m(G.$$.fragment,e),m(x.$$.fragment,e),m(V.$$.fragment,e),m(H.$$.fragment,e),m(Y.$$.fragment,e),m(E.$$.fragment,e),m(L.$$.fragment,e),m(Q.$$.fragment,e),m(P.$$.fragment,e),m(q.$$.fragment,e),m(K.$$.fragment,e),m(g.$$.fragment,e),m(le.$$.fragment,e),m(se.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(Me.$$.fragment,e),m(ye.$$.fragment,e),m(we.$$.fragment,e),$t=!1},d(e){e&&(l(b),l(y),l(Te),l(je),l(U),l($e),l(ve),l(j),l(Ce),l($),l(Ie),l(_e),l(C),l(Ge),l(xe),l(_),l(ke),l(Ze),l(Ae),l(k),l(We),l(Z),l(Be),l(A),l(Ve),l(W),l(Fe),l(B),l(He),l(Xe),l(F),l(Ye),l(ze),l(X),l(Ee),l(Le),l(z),l(Ne),l(Re),l(Qe),l(N),l(Pe),l(R),l(Se),l(qe),l(De),l(S),l(Oe),l(Ke),l(D),l(et),l(O),l(tt),l(lt),l(ee),l(nt),l(st),l(te),l(at),l(it),l(ne),l(ot),l(rt),l(ae),l(ct),l(ie),l(pt),l(oe),l(dt),l(re),l(ut),l(mt),l(pe),l(ht),l(de),l(Mt),l(ue),l(ft),l(yt),l(he),l(gt),l(wt),l(fe),l(bt),l(Tt),l(ge),l(Ut),l(Jt),l(be),l(jt),l(Ue)),l(M),h(T,e),h(J,e),h(v,e),h(I,e),h(G,e),h(x,e),h(V,e),h(H,e),h(Y,e),h(E,e),h(L,e),h(Q,e),h(P,e),h(q,e),h(K,e),h(g,e),h(le,e),h(se,e),h(ce,e),h(me,e),h(Me,e),h(ye,e),h(we,e)}}}const yl='{"title":"Troubleshooting guide","local":"troubleshooting-guide","sections":[{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"Hanging code and timeout errors","local":"hanging-code-and-timeout-errors","sections":[{"title":"Mismatched tensor shapes","local":"mismatched-tensor-shapes","sections":[],"depth":3},{"title":"Early stopping leads to hanging","local":"early-stopping-leads-to-hanging","sections":[],"depth":3},{"title":"Hanging on low kernel versions on Linux","local":"hanging-on-low-kernel-versions-on-linux","sections":[],"depth":3}],"depth":2},{"title":"CUDA out of memory","local":"cuda-out-of-memory","sections":[{"title":"find_executable_batch_size","local":"findexecutablebatchsize","sections":[],"depth":3}],"depth":2},{"title":"Non-reproducible results between device setups","local":"non-reproducible-results-between-device-setups","sections":[],"depth":2},{"title":"Performance issues on different GPUs","local":"performance-issues-on-different-gpus","sections":[],"depth":2},{"title":"Ask for help","local":"ask-for-help","sections":[{"title":"Forums","local":"forums","sections":[],"depth":3},{"title":"Discord","local":"discord","sections":[],"depth":3},{"title":"GitHub Issues","local":"github-issues","sections":[],"depth":3}],"depth":2}],"depth":1}';function gl(Je){return rl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends pl{constructor(M){super(),dl(this,M,gl,fl,ol,{})}}export{jl as component};
