import{s as Te,n as fe,o as be}from"../chunks/scheduler.85c25b89.js";import{S as Ce,i as ve,g as a,s as p,u as c,A as Ie,h as n,f as e,c as i,j as m,v as M,y as h,k as o,o as r,a as l,w as y,d,t as u,x as g}from"../chunks/index.9633332f.js";import{I as ht}from"../chunks/IconCopyLink.a4acffac.js";import{C as lt}from"../chunks/CodeBlock.00597c71.js";function xe(Pt){let j,ct,at,Mt,J,b,nt,k,Xt,K,Lt="SWSL ResNet",yt,N,Dt='<strong>Residual Networks</strong>, or <strong>ResNets</strong>, learn residual functions with reference to the layer inputs, instead of learning unreferenced functions. Instead of hoping each few stacked layers directly fit a desired underlying mapping, residual nets let these layers fit a residual mapping. They stack <a href="https://paperswithcode.com/method/residual-block" rel="nofollow">residual blocks</a> ontop of each other to form network: e.g. a ResNet-50 has fifty layers using these blocks.',dt,A,qt="The models in this collection utilise semi-weakly supervised learning to improve the performance of the model. The approach brings important gains to standard architectures for image, video and fine-grained classification.",ut,Z,Kt="Please note the CC-BY-NC 4.0 license on theses weights, non-commercial use only.",gt,w,C,pt,B,Vt,O,Ot="How do I use this model on an image?",jt,$,te="To load a pretrained model:",Jt,W,wt,E,ee="To load and preprocess the image:",Ut,G,Tt,_,se="To get the model predictions:",ft,R,bt,Q,le="To get the top-5 predictions class names:",Ct,S,vt,Y,ae="Replace the model name with the variant you want to use, e.g. <code>swsl_resnet18</code>. You can find the IDs in the model summaries at the top of this page.",It,X,ne='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',xt,U,v,it,V,zt,tt,pe="How do I finetune this model?",kt,z,ie="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",Nt,H,At,F,oe=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,Zt,T,I,ot,P,Ht,et,re="How do I train this model?",Bt,L,me='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',$t,f,x,rt,D,Ft,st,he="Citation",Wt,q,Et,mt,Gt;return k=new ht({}),B=new ht({}),W=new lt({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ3N3c2xfcmVzbmV0MTgnJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbW9kZWwuZXZhbCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`}}),G=new lt({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`}}),R=new lt({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`}}),S=new lt({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`}}),V=new ht({}),H=new lt({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnc3dzbF9yZXNuZXQxOCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNETlVNX0ZJTkVUVU5FX0NMQVNTRVMp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;swsl_resnet18&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)'}}),P=new ht({}),D=new ht({}),q=new lt({props:{code:"JTQwYXJ0aWNsZSU3QkRCTFAlM0Fqb3VybmFscyUyRmNvcnIlMkZhYnMtMTkwNS0wMDU0NiUyQyUwQSUyMCUyMGF1dGhvciUyMCUyMCUyMCUyMCUzRCUyMCU3QkkuJTIwWmVraSUyMFlhbG5peiUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEhlcnYlN0IlNUMnJTdCZSU3RCU3RCUyMEolN0IlNUMnJTdCZSU3RCU3RGdvdSUyMGFuZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEthbiUyMENoZW4lMjBhbmQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBNYW5vaGFyJTIwUGFsdXJpJTIwYW5kJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGhydXYlMjBNYWhhamFuJTdEJTJDJTBBJTIwJTIwdGl0bGUlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JCaWxsaW9uLXNjYWxlJTIwc2VtaS1zdXBlcnZpc2VkJTIwbGVhcm5pbmclMjBmb3IlMjBpbWFnZSUyMGNsYXNzaWZpY2F0aW9uJTdEJTJDJTBBJTIwJTIwam91cm5hbCUyMCUyMCUyMCUzRCUyMCU3QkNvUlIlN0QlMkMlMEElMjAlMjB2b2x1bWUlMjAlMjAlMjAlMjAlM0QlMjAlN0JhYnMlMkYxOTA1LjAwNTQ2JTdEJTJDJTBBJTIwJTIweWVhciUyMCUyMCUyMCUyMCUyMCUyMCUzRCUyMCU3QjIwMTklN0QlMkMlMEElMjAlMjB1cmwlMjAlMjAlMjAlMjAlMjAlMjAlMjAlM0QlMjAlN0JodHRwJTNBJTJGJTJGYXJ4aXYub3JnJTJGYWJzJTJGMTkwNS4wMDU0NiU3RCUyQyUwQSUyMCUyMGFyY2hpdmVQcmVmaXglMjAlM0QlMjAlN0JhclhpdiU3RCUyQyUwQSUyMCUyMGVwcmludCUyMCUyMCUyMCUyMCUzRCUyMCU3QjE5MDUuMDA1NDYlN0QlMkMlMEElMjAlMjB0aW1lc3RhbXAlMjAlM0QlMjAlN0JNb24lMkMlMjAyOCUyMFNlcCUyMDIwMjAlMjAwOCUzQTE5JTNBMzclMjAlMkIwMjAwJTdEJTJDJTBBJTIwJTIwYmlidXJsJTIwJTIwJTIwJTIwJTNEJTIwJTdCaHR0cHMlM0ElMkYlMkZkYmxwLm9yZyUyRnJlYyUyRmpvdXJuYWxzJTJGY29yciUyRmFicy0xOTA1LTAwNTQ2LmJpYiU3RCUyQyUwQSUyMCUyMGJpYnNvdXJjZSUyMCUzRCUyMCU3QmRibHAlMjBjb21wdXRlciUyMHNjaWVuY2UlMjBiaWJsaW9ncmFwaHklMkMlMjBodHRwcyUzQSUyRiUyRmRibHAub3JnJTdEJTBBJTdE",highlighted:`<span class="language-xml">@article</span><span class="hljs-template-variable">{DBLP:journals/corr/abs-1905-00546,
  author    = {I. Zeki Yalniz and
               Herv{\\&#x27;{e}</span><span class="language-xml">} J</span><span class="hljs-template-variable">{\\&#x27;{e}</span><span class="language-xml">}gou and
               Kan Chen and
               Manohar Paluri and
               Dhruv Mahajan},
  title     = </span><span class="hljs-template-variable">{Billion-scale semi-supervised learning for image classification}</span><span class="language-xml">,
  journal   = </span><span class="hljs-template-variable">{CoRR}</span><span class="language-xml">,
  volume    = </span><span class="hljs-template-variable">{abs/1905.00546}</span><span class="language-xml">,
  year      = </span><span class="hljs-template-variable">{2019}</span><span class="language-xml">,
  url       = </span><span class="hljs-template-variable">{http://arxiv.org/abs/1905.00546}</span><span class="language-xml">,
  archivePrefix = </span><span class="hljs-template-variable">{arXiv}</span><span class="language-xml">,
  eprint    = </span><span class="hljs-template-variable">{1905.00546}</span><span class="language-xml">,
  timestamp = </span><span class="hljs-template-variable">{Mon, 28 <span class="hljs-keyword">Sep</span> 2020 08:19:37 +0200}</span><span class="language-xml">,
  biburl    = </span><span class="hljs-template-variable">{https://dblp.org/rec/journals/corr/abs-1905-00546.bib}</span><span class="language-xml">,
  bibsource = </span><span class="hljs-template-variable">{dblp computer science bibliography, https://dblp.org}</span><span class="language-xml">
}</span>`}}),{c(){j=a("meta"),ct=p(),at=a("p"),Mt=p(),J=a("h1"),b=a("a"),nt=a("span"),c(k.$$.fragment),Xt=p(),K=a("span"),K.textContent=Lt,yt=p(),N=a("p"),N.innerHTML=Dt,dt=p(),A=a("p"),A.textContent=qt,ut=p(),Z=a("p"),Z.textContent=Kt,gt=p(),w=a("h2"),C=a("a"),pt=a("span"),c(B.$$.fragment),Vt=p(),O=a("span"),O.textContent=Ot,jt=p(),$=a("p"),$.textContent=te,Jt=p(),c(W.$$.fragment),wt=p(),E=a("p"),E.textContent=ee,Ut=p(),c(G.$$.fragment),Tt=p(),_=a("p"),_.textContent=se,ft=p(),c(R.$$.fragment),bt=p(),Q=a("p"),Q.textContent=le,Ct=p(),c(S.$$.fragment),vt=p(),Y=a("p"),Y.innerHTML=ae,It=p(),X=a("p"),X.innerHTML=ne,xt=p(),U=a("h2"),v=a("a"),it=a("span"),c(V.$$.fragment),zt=p(),tt=a("span"),tt.textContent=pe,kt=p(),z=a("p"),z.textContent=ie,Nt=p(),c(H.$$.fragment),At=p(),F=a("p"),F.innerHTML=oe,Zt=p(),T=a("h2"),I=a("a"),ot=a("span"),c(P.$$.fragment),Ht=p(),et=a("span"),et.textContent=re,Bt=p(),L=a("p"),L.innerHTML=me,$t=p(),f=a("h2"),x=a("a"),rt=a("span"),c(D.$$.fragment),Ft=p(),st=a("span"),st.textContent=he,Wt=p(),c(q.$$.fragment),Et=p(),mt=a("p"),this.h()},l(t){const s=Ie("svelte-1phssyn",document.head);j=n(s,"META",{name:!0,content:!0}),s.forEach(e),ct=i(t),at=n(t,"P",{}),m(at).forEach(e),Mt=i(t),J=n(t,"H1",{class:!0});var _t=m(J);b=n(_t,"A",{id:!0,class:!0,href:!0});var ce=m(b);nt=n(ce,"SPAN",{});var Me=m(nt);M(k.$$.fragment,Me),Me.forEach(e),ce.forEach(e),Xt=i(_t),K=n(_t,"SPAN",{"data-svelte-h":!0}),h(K)!=="svelte-my4jdx"&&(K.textContent=Lt),_t.forEach(e),yt=i(t),N=n(t,"P",{"data-svelte-h":!0}),h(N)!=="svelte-p6ybkz"&&(N.innerHTML=Dt),dt=i(t),A=n(t,"P",{"data-svelte-h":!0}),h(A)!=="svelte-ya6jib"&&(A.textContent=qt),ut=i(t),Z=n(t,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-ye38bd"&&(Z.textContent=Kt),gt=i(t),w=n(t,"H2",{class:!0});var Rt=m(w);C=n(Rt,"A",{id:!0,class:!0,href:!0});var ye=m(C);pt=n(ye,"SPAN",{});var de=m(pt);M(B.$$.fragment,de),de.forEach(e),ye.forEach(e),Vt=i(Rt),O=n(Rt,"SPAN",{"data-svelte-h":!0}),h(O)!=="svelte-1c1hspn"&&(O.textContent=Ot),Rt.forEach(e),jt=i(t),$=n(t,"P",{"data-svelte-h":!0}),h($)!=="svelte-18ywhxh"&&($.textContent=te),Jt=i(t),M(W.$$.fragment,t),wt=i(t),E=n(t,"P",{"data-svelte-h":!0}),h(E)!=="svelte-1c2ipa8"&&(E.textContent=ee),Ut=i(t),M(G.$$.fragment,t),Tt=i(t),_=n(t,"P",{"data-svelte-h":!0}),h(_)!=="svelte-1n9qsq1"&&(_.textContent=se),ft=i(t),M(R.$$.fragment,t),bt=i(t),Q=n(t,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-19cnvx1"&&(Q.textContent=le),Ct=i(t),M(S.$$.fragment,t),vt=i(t),Y=n(t,"P",{"data-svelte-h":!0}),h(Y)!=="svelte-6if2n8"&&(Y.innerHTML=ae),It=i(t),X=n(t,"P",{"data-svelte-h":!0}),h(X)!=="svelte-1wmi3ea"&&(X.innerHTML=ne),xt=i(t),U=n(t,"H2",{class:!0});var Qt=m(U);v=n(Qt,"A",{id:!0,class:!0,href:!0});var ue=m(v);it=n(ue,"SPAN",{});var ge=m(it);M(V.$$.fragment,ge),ge.forEach(e),ue.forEach(e),zt=i(Qt),tt=n(Qt,"SPAN",{"data-svelte-h":!0}),h(tt)!=="svelte-1viv4qv"&&(tt.textContent=pe),Qt.forEach(e),kt=i(t),z=n(t,"P",{"data-svelte-h":!0}),h(z)!=="svelte-9sr7nh"&&(z.textContent=ie),Nt=i(t),M(H.$$.fragment,t),At=i(t),F=n(t,"P",{"data-svelte-h":!0}),h(F)!=="svelte-1kguc51"&&(F.innerHTML=oe),Zt=i(t),T=n(t,"H2",{class:!0});var St=m(T);I=n(St,"A",{id:!0,class:!0,href:!0});var je=m(I);ot=n(je,"SPAN",{});var Je=m(ot);M(P.$$.fragment,Je),Je.forEach(e),je.forEach(e),Ht=i(St),et=n(St,"SPAN",{"data-svelte-h":!0}),h(et)!=="svelte-1ce591d"&&(et.textContent=re),St.forEach(e),Bt=i(t),L=n(t,"P",{"data-svelte-h":!0}),h(L)!=="svelte-1n0coha"&&(L.innerHTML=me),$t=i(t),f=n(t,"H2",{class:!0});var Yt=m(f);x=n(Yt,"A",{id:!0,class:!0,href:!0});var we=m(x);rt=n(we,"SPAN",{});var Ue=m(rt);M(D.$$.fragment,Ue),Ue.forEach(e),we.forEach(e),Ft=i(Yt),st=n(Yt,"SPAN",{"data-svelte-h":!0}),h(st)!=="svelte-15mb3gy"&&(st.textContent=he),Yt.forEach(e),Wt=i(t),M(q.$$.fragment,t),Et=i(t),mt=n(t,"P",{}),m(mt).forEach(e),this.h()},h(){o(j,"name","hf:doc:metadata"),o(j,"content",JSON.stringify(ke)),o(b,"id","swsl-resnet"),o(b,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(b,"href","#swsl-resnet"),o(J,"class","relative group"),o(C,"id","how-do-i-use-this-model-on-an-image"),o(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(C,"href","#how-do-i-use-this-model-on-an-image"),o(w,"class","relative group"),o(v,"id","how-do-i-finetune-this-model"),o(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(v,"href","#how-do-i-finetune-this-model"),o(U,"class","relative group"),o(I,"id","how-do-i-train-this-model"),o(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(I,"href","#how-do-i-train-this-model"),o(T,"class","relative group"),o(x,"id","citation"),o(x,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),o(x,"href","#citation"),o(f,"class","relative group")},m(t,s){r(document.head,j),l(t,ct,s),l(t,at,s),l(t,Mt,s),l(t,J,s),r(J,b),r(b,nt),y(k,nt,null),r(J,Xt),r(J,K),l(t,yt,s),l(t,N,s),l(t,dt,s),l(t,A,s),l(t,ut,s),l(t,Z,s),l(t,gt,s),l(t,w,s),r(w,C),r(C,pt),y(B,pt,null),r(w,Vt),r(w,O),l(t,jt,s),l(t,$,s),l(t,Jt,s),y(W,t,s),l(t,wt,s),l(t,E,s),l(t,Ut,s),y(G,t,s),l(t,Tt,s),l(t,_,s),l(t,ft,s),y(R,t,s),l(t,bt,s),l(t,Q,s),l(t,Ct,s),y(S,t,s),l(t,vt,s),l(t,Y,s),l(t,It,s),l(t,X,s),l(t,xt,s),l(t,U,s),r(U,v),r(v,it),y(V,it,null),r(U,zt),r(U,tt),l(t,kt,s),l(t,z,s),l(t,Nt,s),y(H,t,s),l(t,At,s),l(t,F,s),l(t,Zt,s),l(t,T,s),r(T,I),r(I,ot),y(P,ot,null),r(T,Ht),r(T,et),l(t,Bt,s),l(t,L,s),l(t,$t,s),l(t,f,s),r(f,x),r(x,rt),y(D,rt,null),r(f,Ft),r(f,st),l(t,Wt,s),y(q,t,s),l(t,Et,s),l(t,mt,s),Gt=!0},p:fe,i(t){Gt||(d(k.$$.fragment,t),d(B.$$.fragment,t),d(W.$$.fragment,t),d(G.$$.fragment,t),d(R.$$.fragment,t),d(S.$$.fragment,t),d(V.$$.fragment,t),d(H.$$.fragment,t),d(P.$$.fragment,t),d(D.$$.fragment,t),d(q.$$.fragment,t),Gt=!0)},o(t){u(k.$$.fragment,t),u(B.$$.fragment,t),u(W.$$.fragment,t),u(G.$$.fragment,t),u(R.$$.fragment,t),u(S.$$.fragment,t),u(V.$$.fragment,t),u(H.$$.fragment,t),u(P.$$.fragment,t),u(D.$$.fragment,t),u(q.$$.fragment,t),Gt=!1},d(t){t&&(e(ct),e(at),e(Mt),e(J),e(yt),e(N),e(dt),e(A),e(ut),e(Z),e(gt),e(w),e(jt),e($),e(Jt),e(wt),e(E),e(Ut),e(Tt),e(_),e(ft),e(bt),e(Q),e(Ct),e(vt),e(Y),e(It),e(X),e(xt),e(U),e(kt),e(z),e(Nt),e(At),e(F),e(Zt),e(T),e(Bt),e(L),e($t),e(f),e(Wt),e(Et),e(mt)),e(j),g(k),g(B),g(W,t),g(G,t),g(R,t),g(S,t),g(V),g(H,t),g(P),g(D),g(q,t)}}}const ke={local:"swsl-resnet",sections:[{local:"how-do-i-use-this-model-on-an-image",title:"How do I use this model on an image?"},{local:"how-do-i-finetune-this-model",title:"How do I finetune this model?"},{local:"how-do-i-train-this-model",title:"How do I train this model?"},{local:"citation",title:"Citation"}],title:"SWSL ResNet"};function Ne(Pt){return be(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class We extends Ce{constructor(j){super(),ve(this,j,Ne,xe,Te,{})}}export{We as component};
