import{s as Ds,o as qs,n as il}from"../chunks/scheduler.defa9a21.js";import{S as Ps,i as Ks,g as M,s as a,r as o,A as Os,h as i,f as t,c as n,j as Hs,u as c,x as r,k as Ls,y as ea,a as s,v as m,d as y,t as w,w as J}from"../chunks/index.fe795e71.js";import{T as pl}from"../chunks/Tip.179eb360.js";import{C as h}from"../chunks/CodeBlock.42404125.js";import{H as Ml,E as la}from"../chunks/EditOnGithub.0f575778.js";function ta(d){let p,U='This tutorial is also available as a Jupyter Notebook <a href="https://github.com/huggingface/notebooks/blob/main/examples/accelerate_examples/simple_cv_example.ipynb" rel="nofollow">here</a>';return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1tjynav"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function sa(d){let p,U="CUDA can’t be initialized more than once on a multi-GPU system. It’s fine to debug in the notebook and have calls to CUDA, but in order to finally train a full cleanup and restart will need to be performed.";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1cflfr7"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function aa(d){let p,U="The code has been split up to allow for explanations on each section. A full version that can be copy and pasted will be available at the end";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1eykicx"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function na(d){let p,U=`If training on the TPU, your training loop should take in the model as a parameter and it should be instantiated
outside of the training loop function. See the <a href="../concept_guides/training_tpu">TPU best practices</a>
to learn why`;return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1aol2se"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function pa(d){let p,U="You build the model here so that the seed also controls the new weight initialization";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-j432sg"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function Ma(d){let p,U="There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the prepare method.";return{c(){p=M("p"),p.textContent=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1y658j6"&&(p.textContent=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function ia(d){let p,U="Notice how the <code>node_rank</code> has changed";return{c(){p=M("p"),p.innerHTML=U},l(T){p=i(T,"P",{"data-svelte-h":!0}),r(p)!=="svelte-1dj1i7x"&&(p.innerHTML=U)},m(T,j){s(T,p,j)},p:il,d(T){T&&t(p)}}}function ra(d){let p,U,T,j,G,ol,_,qt=`This tutorial teaches you how to fine tune a computer vision model with 🤗 Accelerate from a Jupyter Notebook on a distributed system.
You will also learn how to setup a few requirements needed for ensuring your environment is configured properly, your data has been prepared properly, and finally how to launch training.`,cl,u,ml,g,yl,k,Pt="Before any training can be performed, a Accelerate config file must exist in the system. Usually this can be done by running the following in a terminal and answering the prompts:",wl,W,Jl,B,Kt='However, if general defaults are fine and you are <em>not</em> running on a TPU, Accelerate has a utility to quickly write your GPU configuration into a config file via <a href="/docs/accelerate/v1.5.2/en/package_reference/utilities#accelerate.commands.config.default.write_basic_config">utils.write_basic_config()</a>.',Tl,v,Ot="The following code will restart Jupyter after writing the configuration, as CUDA code was called to perform this.",hl,b,Ul,Y,jl,A,dl,N,es="Next you should prepare your dataset. As mentioned at earlier, great care should be taken when preparing the <code>DataLoaders</code> and model to make sure that <strong>nothing</strong> is put on <em>any</em> GPU.",ul,X,ls="If you do, it is recommended to put that specific code into a function and call that from within the notebook launcher interface, which will be shown later.",bl,R,ts='Make sure the dataset is downloaded based on the directions <a href="https://github.com/huggingface/accelerate/tree/main/examples#simple-vision-example" rel="nofollow">here</a>',Il,V,fl,x,ss="First you need to create a function to extract the class name based on a filename:",Cl,F,$l,Q,Zl,z,as="In the case here, the label is <code>beagle</code>. Using regex you can extract the label from the filename:",Gl,E,_l,S,gl,H,ns="And you can see it properly returned the right name for our file:",kl,L,Wl,D,ps="Next a <code>Dataset</code> class should be made to handle grabbing the image and the label:",Bl,q,vl,P,Ms=`Now to build the dataset. Outside the training function you can find and declare all the filenames and labels and use them as references inside the
launched function:`,Yl,K,Al,O,is="Next gather all the labels:",Nl,ee,Xl,le,rs=`Next, you should make a <code>get_dataloaders</code> function that will return your built dataloaders for you. As mentioned earlier, if data is automatically
sent to the GPU or a TPU device when building your <code>DataLoaders</code>, they must be built using this method.`,Rl,te,Vl,se,os="Finally, you should import the scheduler to be used later:",xl,ae,Fl,ne,Ql,pe,cs='Now you can build the training loop. <a href="/docs/accelerate/v1.5.2/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> works by passing in a function to call that will be ran across the distributed system.',zl,Me,ms="Here is a basic training loop for the animal classification problem:",El,I,Sl,ie,Hl,re,ys='First you should set the seed and create an <a href="/docs/accelerate/v1.5.2/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object as early in the training loop as possible.',Ll,f,Dl,oe,ws="Next you should build your dataloaders and create your model:",ql,ce,Pl,C,Kl,me,Js=`As you are performing transfer learning in this example, the encoder of the model starts out frozen so the head of the model can be
trained only initially:`,Ol,ye,et,we,Ts="Normalizing the batches of images will make training a little faster:",lt,Je,tt,Te,hs="To make these constants available on the active device, you should set it to the Accelerator’s device:",st,he,at,Ue,Us="Next instantiate the rest of the PyTorch classes used for training:",nt,je,pt,de,js='Before passing everything to <a href="/docs/accelerate/v1.5.2/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>.',Mt,$,it,ue,rt,be,ds="Now train the model:",ot,Ie,ct,fe,us=`The evaluation loop will look slightly different compared to the training loop. The number of elements passed as well as the overall
total accuracy of each batch will be added to two constants:`,mt,Ce,yt,$e,bs="Next you have the rest of your standard PyTorch loop:",wt,Ze,Jt,Ge,Is="Before finally the last major difference.",Tt,_e,fs=`When performing distributed evaluation, the predictions and labels need to be passed through
<a href="/docs/accelerate/v1.5.2/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a> so that all of the data is available on the current device and a properly calculated metric can be achieved:`,ht,ge,Ut,ke,Cs='Now you just need to calculate the actual metric for this problem, and you can print it on the main process using <a href="/docs/accelerate/v1.5.2/en/package_reference/accelerator#accelerate.Accelerator.print">print()</a>:',jt,We,dt,Be,$s="A full version of this training loop is available below:",ut,ve,bt,Ye,It,Ae,Zs='All that’s left is to use the <a href="/docs/accelerate/v1.5.2/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a>.',ft,Ne,Gs='You pass in the function, the arguments (as a tuple), and the number of processes to train on. (See the <a href="../package_reference/launchers">documentation</a> for more information)',Ct,Xe,$t,Re,Zt,Ve,_s="In the case of running on multiple nodes, you need to set up a Jupyter session at each node and run the launching cell at the same time.",Gt,xe,gs="For an environment containing 2 nodes (computers) with 8 GPUs each and the main computer with an IP address of “172.31.43.8”, it would look like so:",_t,Fe,gt,Qe,ks="And in the second Jupyter session on the other machine:",kt,Z,Wt,ze,Bt,Ee,Ws="In the case of running on the TPU, it would look like so:",vt,Se,Yt,He,Bs="To launch the training process with elasticity, enabling fault tolerance, you can use the <code>elastic_launch</code> feature provided by PyTorch. This requires setting additional parameters such as <code>rdzv_backend</code> and <code>max_restarts</code>. Here is an example of how to use <code>notebook_launcher</code> with elastic capabilities:",At,Le,Nt,De,vs="As it’s running it will print the progress as well as state how many devices you ran on. This tutorial was ran with two GPUs:",Xt,qe,Rt,Pe,Ys="And that’s it!",Vt,Ke,As='Please note that <a href="/docs/accelerate/v1.5.2/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a> ignores the Accelerate config file, to launch based on the config use:',xt,Oe,Ft,el,Qt,ll,Ns=`A common issue when running the <code>notebook_launcher</code> is receiving a CUDA has already been initialized issue. This usually stems
from an import or prior code in the notebook that makes a call to the PyTorch <code>torch.cuda</code> sublibrary. To help narrow down what went wrong,
you can launch the <code>notebook_launcher</code> with <code>ACCELERATE_DEBUG_MODE=yes</code> in your environment and an additional check
will be made when spawning that a regular process can be created and utilize CUDA without issue. (Your CUDA code can still be ran afterwards).`,zt,tl,Et,sl,Xs="This notebook showed how to perform distributed training from inside of a Jupyter Notebook. Some key notes to remember:",St,al,Rs='<li>Make sure to save any code that use CUDA (or CUDA imports) for the function passed to <a href="/docs/accelerate/v1.5.2/en/package_reference/launchers#accelerate.notebook_launcher">notebook_launcher()</a></li> <li>Set the <code>num_processes</code> to be the number of devices used for training (such as number of GPUs, CPUs, TPUs, etc)</li> <li>If using the TPU, declare your model outside the training loop function</li>',Ht,nl,Lt,rl,Dt;return G=new Ml({props:{title:"Launching distributed training from Jupyter Notebooks",local:"launching-distributed-training-from-jupyter-notebooks",headingTag:"h1"}}),u=new pl({props:{$$slots:{default:[ta]},$$scope:{ctx:d}}}),g=new Ml({props:{title:"Configuring the Environment",local:"configuring-the-environment",headingTag:"h2"}}),W=new h({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),b=new pl({props:{warning:!0,$$slots:{default:[sa]},$$scope:{ctx:d}}}),Y=new h({props:{code:"aW1wb3J0JTIwb3MlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHdyaXRlX2Jhc2ljX2NvbmZpZyUwQSUwQXdyaXRlX2Jhc2ljX2NvbmZpZygpJTIwJTIwJTIzJTIwV3JpdGUlMjBhJTIwY29uZmlnJTIwZmlsZSUwQW9zLl9leGl0KDAwKSUyMCUyMCUyMyUyMFJlc3RhcnQlMjB0aGUlMjBub3RlYm9vaw==",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()  <span class="hljs-comment"># Write a config file</span>
os._exit(<span class="hljs-number">00</span>)  <span class="hljs-comment"># Restart the notebook</span>`,wrap:!1}}),A=new Ml({props:{title:"Preparing the Dataset and Model",local:"preparing-the-dataset-and-model",headingTag:"h2"}}),V=new h({props:{code:"aW1wb3J0JTIwb3MlMkMlMjByZSUyQyUyMHRvcmNoJTJDJTIwUElMJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyME9uZUN5Y2xlTFIlMEFmcm9tJTIwdG9yY2gudXRpbHMuZGF0YSUyMGltcG9ydCUyMERhdGFMb2FkZXIlMkMlMjBEYXRhc2V0JTBBZnJvbSUyMHRvcmNodmlzaW9uLnRyYW5zZm9ybXMlMjBpbXBvcnQlMjBDb21wb3NlJTJDJTIwUmFuZG9tUmVzaXplZENyb3AlMkMlMjBSZXNpemUlMkMlMjBUb1RlbnNvciUwQSUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMHNldF9zZWVkJTBBZnJvbSUyMHRpbW0lMjBpbXBvcnQlMjBjcmVhdGVfbW9kZWw=",highlighted:`<span class="hljs-keyword">import</span> os, re, torch, PIL
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> OneCycleLR
<span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader, Dataset
<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> Compose, RandomResizedCrop, Resize, ToTensor

<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> set_seed
<span class="hljs-keyword">from</span> timm <span class="hljs-keyword">import</span> create_model`,wrap:!1}}),F=new h({props:{code:"aW1wb3J0JTIwb3MlMEElMEFkYXRhX2RpciUyMCUzRCUyMCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMEFmbmFtZXMlMjAlM0QlMjBvcy5saXN0ZGlyKGRhdGFfZGlyKSUwQWZuYW1lJTIwJTNEJTIwZm5hbWVzJTVCMCU1RCUwQXByaW50KGZuYW1lKQ==",highlighted:`<span class="hljs-keyword">import</span> os

data_dir = <span class="hljs-string">&quot;../../images&quot;</span>
fnames = os.listdir(data_dir)
fname = fnames[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(fname)`,wrap:!1}}),Q=new h({props:{code:"YmVhZ2xlXzMyLmpwZw==",highlighted:"beagle_32.jpg",wrap:!1}}),E=new h({props:{code:"aW1wb3J0JTIwcmUlMEElMEElMEFkZWYlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUzQSUwQSUyMCUyMCUyMCUyMHN0ZW0lMjAlM0QlMjBmbmFtZS5zcGxpdChvcy5wYXRoLnNlcCklNUItMSU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlLnNlYXJjaChyJTIyJTVFKC4qKV8lNUNkJTJCJTVDLmpwZyUyNCUyMiUyQyUyMHN0ZW0pLmdyb3VwcygpJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">import</span> re


<span class="hljs-keyword">def</span> <span class="hljs-title function_">extract_label</span>(<span class="hljs-params">fname</span>):
    stem = fname.split(os.path.sep)[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">return</span> re.search(<span class="hljs-string">r&quot;^(.*)_\\d+\\.jpg$&quot;</span>, stem).groups()[<span class="hljs-number">0</span>]`,wrap:!1}}),S=new h({props:{code:"ZXh0cmFjdF9sYWJlbChmbmFtZSk=",highlighted:"extract_label(fname)",wrap:!1}}),L=new h({props:{code:"JTIyYmVhZ2xlJTIy",highlighted:'<span class="hljs-string">&quot;beagle&quot;</span>',wrap:!1}}),q=new h({props:{code:"Y2xhc3MlMjBQZXRzRGF0YXNldChEYXRhc2V0KSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBmaWxlX25hbWVzJTJDJTIwaW1hZ2VfdHJhbnNmb3JtJTNETm9uZSUyQyUyMGxhYmVsX3RvX2lkJTNETm9uZSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmZpbGVfbmFtZXMlMjAlM0QlMjBmaWxlX25hbWVzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0lMjAlM0QlMjBpbWFnZV90cmFuc2Zvcm0lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmxhYmVsX3RvX2lkJTIwJTNEJTIwbGFiZWxfdG9faWQlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2xlbl9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbGVuKHNlbGYuZmlsZV9uYW1lcyklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2dldGl0ZW1fXyhzZWxmJTJDJTIwaWR4KSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZuYW1lJTIwJTNEJTIwc2VsZi5maWxlX25hbWVzJTVCaWR4JTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X2ltYWdlJTIwJTNEJTIwUElMLkltYWdlLm9wZW4oZm5hbWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjByYXdfaW1hZ2UuY29udmVydCglMjJSR0IlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBzZWxmLmltYWdlX3RyYW5zZm9ybSUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwc2VsZi5pbWFnZV90cmFuc2Zvcm0oaW1hZ2UpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbGFiZWwlMjAlM0QlMjBleHRyYWN0X2xhYmVsKGZuYW1lKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc2VsZi5sYWJlbF90b19pZCUyMGlzJTIwbm90JTIwTm9uZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVsJTIwJTNEJTIwc2VsZi5sYWJlbF90b19pZCU1QmxhYmVsJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIyaW1hZ2UlMjIlM0ElMjBpbWFnZSUyQyUyMCUyMmxhYmVsJTIyJTNBJTIwbGFiZWwlN0Q=",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">PetsDataset</span>(<span class="hljs-title class_ inherited__">Dataset</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, file_names, image_transform=<span class="hljs-literal">None</span>, label_to_id=<span class="hljs-literal">None</span></span>):
        self.file_names = file_names
        self.image_transform = image_transform
        self.label_to_id = label_to_id

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__len__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">return</span> <span class="hljs-built_in">len</span>(self.file_names)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__getitem__</span>(<span class="hljs-params">self, idx</span>):
        fname = self.file_names[idx]
        raw_image = PIL.Image.<span class="hljs-built_in">open</span>(fname)
        image = raw_image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)
        <span class="hljs-keyword">if</span> self.image_transform <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            image = self.image_transform(image)
        label = extract_label(fname)
        <span class="hljs-keyword">if</span> self.label_to_id <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
            label = self.label_to_id[label]
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;image&quot;</span>: image, <span class="hljs-string">&quot;label&quot;</span>: label}`,wrap:!1}}),K=new h({props:{code:"Zm5hbWVzJTIwJTNEJTIwJTVCb3MucGF0aC5qb2luKCUyMi4uJTJGLi4lMkZpbWFnZXMlMjIlMkMlMjBmbmFtZSklMjBmb3IlMjBmbmFtZSUyMGluJTIwZm5hbWVzJTIwaWYlMjBmbmFtZS5lbmRzd2l0aCglMjIuanBnJTIyKSU1RA==",highlighted:'fnames = [os.path.join(<span class="hljs-string">&quot;../../images&quot;</span>, fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames <span class="hljs-keyword">if</span> fname.endswith(<span class="hljs-string">&quot;.jpg&quot;</span>)]',wrap:!1}}),ee=new h({props:{code:"YWxsX2xhYmVscyUyMCUzRCUyMCU1QmV4dHJhY3RfbGFiZWwoZm5hbWUpJTIwZm9yJTIwZm5hbWUlMjBpbiUyMGZuYW1lcyU1RCUwQWlkX3RvX2xhYmVsJTIwJTNEJTIwbGlzdChzZXQoYWxsX2xhYmVscykpJTBBaWRfdG9fbGFiZWwuc29ydCgpJTBBbGFiZWxfdG9faWQlMjAlM0QlMjAlN0JsYmwlM0ElMjBpJTIwZm9yJTIwaSUyQyUyMGxibCUyMGluJTIwZW51bWVyYXRlKGlkX3RvX2xhYmVsKSU3RA==",highlighted:`all_labels = [extract_label(fname) <span class="hljs-keyword">for</span> fname <span class="hljs-keyword">in</span> fnames]
id_to_label = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>(all_labels))
id_to_label.sort()
label_to_id = {lbl: i <span class="hljs-keyword">for</span> i, lbl <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(id_to_label)}`,wrap:!1}}),te=new h({props:{code:"ZGVmJTIwZ2V0X2RhdGFsb2FkZXJzKGJhdGNoX3NpemUlM0ElMjBpbnQlMjAlM0QlMjA2NCklM0ElMEElMjAlMjAlMjAlMjAlMjJCdWlsZHMlMjBhJTIwc2V0JTIwb2YlMjBkYXRhbG9hZGVycyUyMHdpdGglMjBhJTIwYmF0Y2hfc2l6ZSUyMiUwQSUyMCUyMCUyMCUyMHJhbmRvbV9wZXJtJTIwJTNEJTIwbnAucmFuZG9tLnBlcm11dGF0aW9uKGxlbihmbmFtZXMpKSUwQSUyMCUyMCUyMCUyMGN1dCUyMCUzRCUyMGludCgwLjglMjAqJTIwbGVuKGZuYW1lcykpJTBBJTIwJTIwJTIwJTIwdHJhaW5fc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QiUzQWN1dCU1RCUwQSUyMCUyMCUyMCUyMGV2YWxfc3BsaXQlMjAlM0QlMjByYW5kb21fcGVybSU1QmN1dCUzQSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEZvciUyMHRyYWluaW5nJTIwYSUyMHNpbXBsZSUyMFJhbmRvbVJlc2l6ZWRDcm9wJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMHRyYWluX3RmbSUyMCUzRCUyMENvbXBvc2UoJTVCUmFuZG9tUmVzaXplZENyb3AoKDIyNCUyQyUyMDIyNCklMkMlMjBzY2FsZSUzRCgwLjUlMkMlMjAxLjApKSUyQyUyMFRvVGVuc29yKCklNUQpJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUyMCUzRCUyMFBldHNEYXRhc2V0KCU1QmZuYW1lcyU1QmklNUQlMjBmb3IlMjBpJTIwaW4lMjB0cmFpbl9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRHRyYWluX3RmbSUyQyUyMGxhYmVsX3RvX2lkJTNEbGFiZWxfdG9faWQpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRm9yJTIwZXZhbHVhdGlvbiUyMGElMjBkZXRlcm1pbmlzdGljJTIwUmVzaXplJTIwd2lsbCUyMGJlJTIwdXNlZCUwQSUyMCUyMCUyMCUyMGV2YWxfdGZtJTIwJTNEJTIwQ29tcG9zZSglNUJSZXNpemUoKDIyNCUyQyUyMDIyNCkpJTJDJTIwVG9UZW5zb3IoKSU1RCklMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlMjAlM0QlMjBQZXRzRGF0YXNldCglNUJmbmFtZXMlNUJpJTVEJTIwZm9yJTIwaSUyMGluJTIwZXZhbF9zcGxpdCU1RCUyQyUyMGltYWdlX3RyYW5zZm9ybSUzRGV2YWxfdGZtJTJDJTIwbGFiZWxfdG9faWQlM0RsYWJlbF90b19pZCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMGRhdGFsb2FkZXJzJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIodHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUlMkMlMjBudW1fd29ya2VycyUzRDQpJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihldmFsX2RhdGFzZXQlMkMlMjBzaHVmZmxlJTNERmFsc2UlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyMColMjAyJTJDJTIwbnVtX3dvcmtlcnMlM0Q0KSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_dataloaders</span>(<span class="hljs-params">batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    <span class="hljs-string">&quot;Builds a set of dataloaders with a batch_size&quot;</span>
    random_perm = np.random.permutation(<span class="hljs-built_in">len</span>(fnames))
    cut = <span class="hljs-built_in">int</span>(<span class="hljs-number">0.8</span> * <span class="hljs-built_in">len</span>(fnames))
    train_split = random_perm[:cut]
    eval_split = random_perm[cut:]

    <span class="hljs-comment"># For training a simple RandomResizedCrop will be used</span>
    train_tfm = Compose([RandomResizedCrop((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>), scale=(<span class="hljs-number">0.5</span>, <span class="hljs-number">1.0</span>)), ToTensor()])
    train_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> train_split], image_transform=train_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># For evaluation a deterministic Resize will be used</span>
    eval_tfm = Compose([Resize((<span class="hljs-number">224</span>, <span class="hljs-number">224</span>)), ToTensor()])
    eval_dataset = PetsDataset([fnames[i] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> eval_split], image_transform=eval_tfm, label_to_id=label_to_id)

    <span class="hljs-comment"># Instantiate dataloaders</span>
    train_dataloader = DataLoader(train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=batch_size, num_workers=<span class="hljs-number">4</span>)
    eval_dataloader = DataLoader(eval_dataset, shuffle=<span class="hljs-literal">False</span>, batch_size=batch_size * <span class="hljs-number">2</span>, num_workers=<span class="hljs-number">4</span>)
    <span class="hljs-keyword">return</span> train_dataloader, eval_dataloader`,wrap:!1}}),ae=new h({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltLmxyX3NjaGVkdWxlciUyMGltcG9ydCUyMENvc2luZUFubmVhbGluZ0xS",highlighted:'<span class="hljs-keyword">from</span> torch.optim.lr_scheduler <span class="hljs-keyword">import</span> CosineAnnealingLR',wrap:!1}}),ne=new Ml({props:{title:"Writing the Training Function",local:"writing-the-training-function",headingTag:"h2"}}),I=new pl({props:{$$slots:{default:[aa]},$$scope:{ctx:d}}}),ie=new h({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24p",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    accelerator = Accelerator(mixed_precision=mixed_precision)`,wrap:!1}}),f=new pl({props:{warning:!0,$$slots:{default:[na]},$$scope:{ctx:d}}}),ce=new h({props:{code:"JTIwJTIwJTIwJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyMCUzRCUyMGdldF9kYXRhbG9hZGVycyhiYXRjaF9zaXplKSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwY3JlYXRlX21vZGVsKCUyMnJlc25ldDUwZCUyMiUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0RsZW4obGFiZWxfdG9faWQpKQ==",highlighted:`    train_dataloader, eval_dataloader = get_dataloaders(batch_size)
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))`,wrap:!1}}),C=new pl({props:{$$slots:{default:[pa]},$$scope:{ctx:d}}}),ye=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMHBhcmFtJTIwaW4lMjBtb2RlbC5nZXRfY2xhc3NpZmllcigpLnBhcmFtZXRlcnMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBhcmFtLnJlcXVpcmVzX2dyYWQlMjAlM0QlMjBUcnVl",highlighted:`    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>`,wrap:!1}}),Je=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMm1lYW4lMjIlNUQpJTVCTm9uZSUyQyUyMCUzQSUyQyUyME5vbmUlMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwc3RkJTIwJTNEJTIwdG9yY2gudGVuc29yKG1vZGVsLmRlZmF1bHRfY2ZnJTVCJTIyc3RkJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RA==",highlighted:`    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]`,wrap:!1}}),he=new h({props:{code:"JTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2Up",highlighted:`    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)`,wrap:!1}}),je=new h({props:{code:"JTIwJTIwJTIwJTIwb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbShwYXJhbXMlM0Rtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDNlLTIlMjAlMkYlMjAyNSklMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBPbmVDeWNsZUxSKG9wdGltaXplciUzRG9wdGltaXplciUyQyUyMG1heF9sciUzRDNlLTIlMkMlMjBlcG9jaHMlM0Q1JTJDJTIwc3RlcHNfcGVyX2Vwb2NoJTNEbGVuKHRyYWluX2RhdGFsb2FkZXIpKQ==",highlighted:`    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))`,wrap:!1}}),$=new pl({props:{$$slots:{default:[Ma]},$$scope:{ctx:d}}}),ue=new h({props:{code:"JTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMkMlMjBscl9zY2hlZHVsZXIlMEElMjAlMjAlMjAlMjAp",highlighted:`    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )`,wrap:!1}}),Ie=new h({props:{code:"JTIwJTIwJTIwJTIwZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwudHJhaW4oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwKGJhdGNoJTVCJTIyaW1hZ2UlMjIlNUQlMjAtJTIwbWVhbiklMjAlMkYlMjBzdGQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLmNyb3NzX2VudHJvcHkob3V0cHV0cyUyQyUyMGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()`,wrap:!1}}),Ce=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTNEJTIwMA==",highlighted:`        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>`,wrap:!1}}),Ze=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlucHV0cyUyMCUzRCUyMChiYXRjaCU1QiUyMmltYWdlJTIyJTVEJTIwLSUyMG1lYW4pJTIwJTJGJTIwc3RkJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjBvdXRwdXRzLmFyZ21heChkaW0lM0QtMSk=",highlighted:`        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)`,wrap:!1}}),ge=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGVfcHJlZHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJlZGljdGlvbnMpJTIwJTNEJTNEJTIwYWNjZWxlcmF0b3IuZ2F0aGVyKGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTJCJTNEJTIwYWNjdXJhdGVfcHJlZHMuc2hhcGUlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5sb25nKCkuc3VtKCk=",highlighted:`            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()`,wrap:!1}}),We=new h({props:{code:"JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXZhbF9tZXRyaWMlMjAlM0QlMjBhY2N1cmF0ZS5pdGVtKCklMjAlMkYlMjBudW1fZWxlbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5wcmludChmJTIyZXBvY2glMjAlN0JlcG9jaCU3RCUzQSUyMCU3QjEwMCUyMColMjBldmFsX21ldHJpYyUzQS4yZiU3RCUyMik=",highlighted:`        eval_metric = accurate.item() / num_elems
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),ve=new h({props:{code:"ZGVmJTIwdHJhaW5pbmdfbG9vcChtaXhlZF9wcmVjaXNpb24lM0QlMjJmcDE2JTIyJTJDJTIwc2VlZCUzQSUyMGludCUyMCUzRCUyMDQyJTJDJTIwYmF0Y2hfc2l6ZSUzQSUyMGludCUyMCUzRCUyMDY0KSUzQSUwQSUyMCUyMCUyMCUyMHNldF9zZWVkKHNlZWQpJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW5pdGlhbGl6ZSUyMGFjY2VsZXJhdG9yJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihtaXhlZF9wcmVjaXNpb24lM0RtaXhlZF9wcmVjaXNpb24pJTBBJTIwJTIwJTIwJTIwJTIzJTIwQnVpbGQlMjBkYXRhbG9hZGVycyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFsb2FkZXIlMkMlMjBldmFsX2RhdGFsb2FkZXIlMjAlM0QlMjBnZXRfZGF0YWxvYWRlcnMoYmF0Y2hfc2l6ZSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnN0YW50aWF0ZSUyMHRoZSUyMG1vZGVsJTIwKHlvdSUyMGJ1aWxkJTIwdGhlJTIwbW9kZWwlMjBoZXJlJTIwc28lMjB0aGF0JTIwdGhlJTIwc2VlZCUyMGFsc28lMjBjb250cm9scyUyMG5ldyUyMHdlaWdodCUyMGluaXRpYWxpemF0aW9ucyklMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMGNyZWF0ZV9tb2RlbCglMjJyZXNuZXQ1MGQlMjIlMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEbGVuKGxhYmVsX3RvX2lkKSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBGcmVlemUlMjB0aGUlMjBiYXNlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBmb3IlMjBwYXJhbSUyMGluJTIwbW9kZWwucGFyYW1ldGVycygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUyMCUzRCUyMEZhbHNlJTBBJTIwJTIwJTIwJTIwZm9yJTIwcGFyYW0lMjBpbiUyMG1vZGVsLmdldF9jbGFzc2lmaWVyKCkucGFyYW1ldGVycygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGFyYW0ucmVxdWlyZXNfZ3JhZCUyMCUzRCUyMFRydWUlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBZb3UlMjBjYW4lMjBub3JtYWxpemUlMjB0aGUlMjBiYXRjaGVzJTIwb2YlMjBpbWFnZXMlMjB0byUyMGJlJTIwYSUyMGJpdCUyMGZhc3RlciUwQSUyMCUyMCUyMCUyMG1lYW4lMjAlM0QlMjB0b3JjaC50ZW5zb3IobW9kZWwuZGVmYXVsdF9jZmclNUIlMjJtZWFuJTIyJTVEKSU1Qk5vbmUlMkMlMjAlM0ElMkMlMjBOb25lJTJDJTIwTm9uZSU1RCUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHRvcmNoLnRlbnNvcihtb2RlbC5kZWZhdWx0X2NmZyU1QiUyMnN0ZCUyMiU1RCklNUJOb25lJTJDJTIwJTNBJTJDJTIwTm9uZSUyQyUyME5vbmUlNUQlMEElMEElMjAlMjAlMjAlMjAlMjMlMjBUbyUyMG1ha2UlMjB0aGVzZSUyMGNvbnN0YW50cyUyMGF2YWlsYWJsZSUyMG9uJTIwdGhlJTIwYWN0aXZlJTIwZGV2aWNlJTJDJTIwc2V0JTIwaXQlMjB0byUyMHRoZSUyMGFjY2VsZXJhdG9yJTIwZGV2aWNlJTBBJTIwJTIwJTIwJTIwbWVhbiUyMCUzRCUyMG1lYW4udG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQSUyMCUyMCUyMCUyMHN0ZCUyMCUzRCUyMHN0ZC50byhhY2NlbGVyYXRvci5kZXZpY2UpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwSW5zdGFudGlhdGUlMjB0aGUlMjBvcHRpbWl6ZXIlMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlMjAlM0QlMjB0b3JjaC5vcHRpbS5BZGFtKHBhcmFtcyUzRG1vZGVsLnBhcmFtZXRlcnMoKSUyQyUyMGxyJTNEM2UtMiUyMCUyRiUyMDI1KSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEluc3RhbnRpYXRlJTIwdGhlJTIwbGVhcm5pbmclMjByYXRlJTIwc2NoZWR1bGVyJTBBJTIwJTIwJTIwJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwT25lQ3ljbGVMUihvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIlMkMlMjBtYXhfbHIlM0QzZS0yJTJDJTIwZXBvY2hzJTNENSUyQyUyMHN0ZXBzX3Blcl9lcG9jaCUzRGxlbih0cmFpbl9kYXRhbG9hZGVyKSklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBQcmVwYXJlJTIwZXZlcnl0aGluZyUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoZXJlJTIwaXMlMjBubyUyMHNwZWNpZmljJTIwb3JkZXIlMjB0byUyMHJlbWVtYmVyJTJDJTIweW91JTIwanVzdCUyMG5lZWQlMjB0byUyMHVucGFjayUyMHRoZSUyMG9iamVjdHMlMjBpbiUyMHRoZSUyMHNhbWUlMjBvcmRlciUyMHlvdSUyMGdhdmUlMjB0aGVtJTIwdG8lMjB0aGUlMEElMjAlMjAlMjAlMjAlMjMlMjBwcmVwYXJlJTIwbWV0aG9kLiUwQSUyMCUyMCUyMCUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwdHJhaW5fZGF0YWxvYWRlciUyQyUyMGV2YWxfZGF0YWxvYWRlciUyQyUyMGxyX3NjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwbHJfc2NoZWR1bGVyJTBBJTIwJTIwJTIwJTIwKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyME5vdyUyMHlvdSUyMHRyYWluJTIwdGhlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBmb3IlMjBlcG9jaCUyMGluJTIwcmFuZ2UoNSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbC50cmFpbigpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAoYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCUyMC0lMjBtZWFuKSUyMCUyRiUyMHN0ZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwuY3Jvc3NfZW50cm9weShvdXRwdXRzJTJDJTIwYmF0Y2glNUIlMjJsYWJlbCUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIuc3RlcCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnplcm9fZ3JhZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwuZXZhbCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlM0QlMjAwJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTNEJTIwMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjBldmFsX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAoYmF0Y2glNUIlMjJpbWFnZSUyMiU1RCUyMC0lMjBtZWFuKSUyMCUyRiUyMHN0ZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZWRpY3Rpb25zJTIwJTNEJTIwb3V0cHV0cy5hcmdtYXgoZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGVfcHJlZHMlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJlZGljdGlvbnMpJTIwJTNEJTNEJTIwYWNjZWxlcmF0b3IuZ2F0aGVyKGJhdGNoJTVCJTIybGFiZWwlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX2VsZW1zJTIwJTJCJTNEJTIwYWNjdXJhdGVfcHJlZHMuc2hhcGUlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYWNjdXJhdGUlMjAlMkIlM0QlMjBhY2N1cmF0ZV9wcmVkcy5sb25nKCkuc3VtKCklMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBldmFsX21ldHJpYyUyMCUzRCUyMGFjY3VyYXRlLml0ZW0oKSUyMCUyRiUyMG51bV9lbGVtcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFVzZSUyMGFjY2VsZXJhdG9yLnByaW50JTIwdG8lMjBwcmludCUyMG9ubHklMjBvbiUyMHRoZSUyMG1haW4lMjBwcm9jZXNzLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnByaW50KGYlMjJlcG9jaCUyMCU3QmVwb2NoJTdEJTNBJTIwJTdCMTAwJTIwKiUyMGV2YWxfbWV0cmljJTNBLjJmJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">training_loop</span>(<span class="hljs-params">mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>, seed: <span class="hljs-built_in">int</span> = <span class="hljs-number">42</span>, batch_size: <span class="hljs-built_in">int</span> = <span class="hljs-number">64</span></span>):
    set_seed(seed)
    <span class="hljs-comment"># Initialize accelerator</span>
    accelerator = Accelerator(mixed_precision=mixed_precision)
    <span class="hljs-comment"># Build dataloaders</span>
    train_dataloader, eval_dataloader = get_dataloaders(batch_size)

    <span class="hljs-comment"># Instantiate the model (you build the model here so that the seed also controls new weight initializations)</span>
    model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

    <span class="hljs-comment"># Freeze the base model</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.parameters():
        param.requires_grad = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> param <span class="hljs-keyword">in</span> model.get_classifier().parameters():
        param.requires_grad = <span class="hljs-literal">True</span>

    <span class="hljs-comment"># You can normalize the batches of images to be a bit faster</span>
    mean = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;mean&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]
    std = torch.tensor(model.default_cfg[<span class="hljs-string">&quot;std&quot;</span>])[<span class="hljs-literal">None</span>, :, <span class="hljs-literal">None</span>, <span class="hljs-literal">None</span>]

    <span class="hljs-comment"># To make these constants available on the active device, set it to the accelerator device</span>
    mean = mean.to(accelerator.device)
    std = std.to(accelerator.device)

    <span class="hljs-comment"># Instantiate the optimizer</span>
    optimizer = torch.optim.Adam(params=model.parameters(), lr=<span class="hljs-number">3e-2</span> / <span class="hljs-number">25</span>)

    <span class="hljs-comment"># Instantiate the learning rate scheduler</span>
    lr_scheduler = OneCycleLR(optimizer=optimizer, max_lr=<span class="hljs-number">3e-2</span>, epochs=<span class="hljs-number">5</span>, steps_per_epoch=<span class="hljs-built_in">len</span>(train_dataloader))

    <span class="hljs-comment"># Prepare everything</span>
    <span class="hljs-comment"># There is no specific order to remember, you just need to unpack the objects in the same order you gave them to the</span>
    <span class="hljs-comment"># prepare method.</span>
    model, optimizer, train_dataloader, eval_dataloader, lr_scheduler = accelerator.prepare(
        model, optimizer, train_dataloader, eval_dataloader, lr_scheduler
    )

    <span class="hljs-comment"># Now you train the model</span>
    <span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
        model.train()
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            outputs = model(inputs)
            loss = torch.nn.functional.cross_entropy(outputs, batch[<span class="hljs-string">&quot;label&quot;</span>])
            accelerator.backward(loss)
            optimizer.step()
            lr_scheduler.step()
            optimizer.zero_grad()

        model.<span class="hljs-built_in">eval</span>()
        accurate = <span class="hljs-number">0</span>
        num_elems = <span class="hljs-number">0</span>
        <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
            inputs = (batch[<span class="hljs-string">&quot;image&quot;</span>] - mean) / std
            <span class="hljs-keyword">with</span> torch.no_grad():
                outputs = model(inputs)
            predictions = outputs.argmax(dim=-<span class="hljs-number">1</span>)
            accurate_preds = accelerator.gather(predictions) == accelerator.gather(batch[<span class="hljs-string">&quot;label&quot;</span>])
            num_elems += accurate_preds.shape[<span class="hljs-number">0</span>]
            accurate += accurate_preds.long().<span class="hljs-built_in">sum</span>()

        eval_metric = accurate.item() / num_elems
        <span class="hljs-comment"># Use accelerator.print to print only on the main process.</span>
        accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;epoch <span class="hljs-subst">{epoch}</span>: <span class="hljs-subst">{<span class="hljs-number">100</span> * eval_metric:<span class="hljs-number">.2</span>f}</span>&quot;</span>)`,wrap:!1}}),Ye=new Ml({props:{title:"Using the notebook_launcher",local:"using-the-notebooklauncher",headingTag:"h2"}}),Xe=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBub3RlYm9va19sYXVuY2hlcg==",highlighted:'<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> notebook_launcher',wrap:!1}}),Re=new h({props:{code:"YXJncyUyMCUzRCUyMCglMjJmcDE2JTIyJTJDJTIwNDIlMkMlMjA2NCklMEFub3RlYm9va19sYXVuY2hlcih0cmFpbmluZ19sb29wJTJDJTIwYXJncyUyQyUyMG51bV9wcm9jZXNzZXMlM0QyKQ==",highlighted:`args = (<span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">2</span>)`,wrap:!1}}),Fe=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMCUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">0</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),Z=new pl({props:{$$slots:{default:[ia]},$$scope:{ctx:d}}}),ze=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIodHJhaW5pbmdfbG9vcCUyQyUyMGFyZ3MlMkMlMjBtYXN0ZXJfYWRkciUzRCUyMjE3Mi4zMS40My44JTIyJTJDJTIwbm9kZV9yYW5rJTNEMSUyQyUyMG51bV9ub2RlcyUzRDIlMkMlMjBudW1fcHJvY2Vzc2VzJTNEOCk=",highlighted:'notebook_launcher(training_loop, args, master_addr=<span class="hljs-string">&quot;172.31.43.8&quot;</span>, node_rank=<span class="hljs-number">1</span>, num_nodes=<span class="hljs-number">2</span>, num_processes=<span class="hljs-number">8</span>)',wrap:!1}}),Se=new h({props:{code:"bW9kZWwlMjAlM0QlMjBjcmVhdGVfbW9kZWwoJTIycmVzbmV0NTBkJTIyJTJDJTIwcHJldHJhaW5lZCUzRFRydWUlMkMlMjBudW1fY2xhc3NlcyUzRGxlbihsYWJlbF90b19pZCkpJTBBJTBBYXJncyUyMCUzRCUyMChtb2RlbCUyQyUyMCUyMmZwMTYlMjIlMkMlMjA0MiUyQyUyMDY0KSUwQW5vdGVib29rX2xhdW5jaGVyKHRyYWluaW5nX2xvb3AlMkMlMjBhcmdzJTJDJTIwbnVtX3Byb2Nlc3NlcyUzRDgp",highlighted:`model = create_model(<span class="hljs-string">&quot;resnet50d&quot;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-built_in">len</span>(label_to_id))

args = (model, <span class="hljs-string">&quot;fp16&quot;</span>, <span class="hljs-number">42</span>, <span class="hljs-number">64</span>)
notebook_launcher(training_loop, args, num_processes=<span class="hljs-number">8</span>)`,wrap:!1}}),Le=new h({props:{code:"bm90ZWJvb2tfbGF1bmNoZXIoJTBBJTIwJTIwJTIwJTIwdHJhaW5pbmdfbG9vcCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlMkMlMEElMjAlMjAlMjAlMjBudW1fcHJvY2Vzc2VzJTNEMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9yZXN0YXJ0cyUzRDMlMEEp",highlighted:`notebook_launcher(
    training_loop,
    args,
    num_processes=<span class="hljs-number">2</span>,
    max_restarts=<span class="hljs-number">3</span>
)`,wrap:!1}}),qe=new h({props:{code:"TGF1bmNoaW5nJTIwdHJhaW5pbmclMjBvbiUyMDIlMjBHUFVzLiUwQWVwb2NoJTIwMCUzQSUyMDg4LjEyJTBBZXBvY2glMjAxJTNBJTIwOTEuNzMlMEFlcG9jaCUyMDIlM0ElMjA5Mi41OCUwQWVwb2NoJTIwMyUzQSUyMDkzLjkwJTBBZXBvY2glMjA0JTNBJTIwOTQuNzE=",highlighted:`Launching training on <span class="hljs-number">2</span> GPUs.
epoch <span class="hljs-number">0</span>: <span class="hljs-number">88.12</span>
epoch <span class="hljs-number">1</span>: <span class="hljs-number">91.73</span>
epoch <span class="hljs-number">2</span>: <span class="hljs-number">92.58</span>
epoch <span class="hljs-number">3</span>: <span class="hljs-number">93.90</span>
epoch <span class="hljs-number">4</span>: <span class="hljs-number">94.71</span>`,wrap:!1}}),Oe=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaA==",highlighted:"accelerate launch",wrap:!1}}),el=new Ml({props:{title:"Debugging",local:"debugging",headingTag:"h2"}}),tl=new Ml({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),nl=new la({props:{source:"https://github.com/huggingface/accelerate/blob/main/docs/source/basic_tutorials/notebook.md"}}),{c(){p=M("meta"),U=a(),T=M("p"),j=a(),o(G.$$.fragment),ol=a(),_=M("p"),_.textContent=qt,cl=a(),o(u.$$.fragment),ml=a(),o(g.$$.fragment),yl=a(),k=M("p"),k.textContent=Pt,wl=a(),o(W.$$.fragment),Jl=a(),B=M("p"),B.innerHTML=Kt,Tl=a(),v=M("p"),v.textContent=Ot,hl=a(),o(b.$$.fragment),Ul=a(),o(Y.$$.fragment),jl=a(),o(A.$$.fragment),dl=a(),N=M("p"),N.innerHTML=es,ul=a(),X=M("p"),X.textContent=ls,bl=a(),R=M("p"),R.innerHTML=ts,Il=a(),o(V.$$.fragment),fl=a(),x=M("p"),x.textContent=ss,Cl=a(),o(F.$$.fragment),$l=a(),o(Q.$$.fragment),Zl=a(),z=M("p"),z.innerHTML=as,Gl=a(),o(E.$$.fragment),_l=a(),o(S.$$.fragment),gl=a(),H=M("p"),H.textContent=ns,kl=a(),o(L.$$.fragment),Wl=a(),D=M("p"),D.innerHTML=ps,Bl=a(),o(q.$$.fragment),vl=a(),P=M("p"),P.textContent=Ms,Yl=a(),o(K.$$.fragment),Al=a(),O=M("p"),O.textContent=is,Nl=a(),o(ee.$$.fragment),Xl=a(),le=M("p"),le.innerHTML=rs,Rl=a(),o(te.$$.fragment),Vl=a(),se=M("p"),se.textContent=os,xl=a(),o(ae.$$.fragment),Fl=a(),o(ne.$$.fragment),Ql=a(),pe=M("p"),pe.innerHTML=cs,zl=a(),Me=M("p"),Me.textContent=ms,El=a(),o(I.$$.fragment),Sl=a(),o(ie.$$.fragment),Hl=a(),re=M("p"),re.innerHTML=ys,Ll=a(),o(f.$$.fragment),Dl=a(),oe=M("p"),oe.textContent=ws,ql=a(),o(ce.$$.fragment),Pl=a(),o(C.$$.fragment),Kl=a(),me=M("p"),me.textContent=Js,Ol=a(),o(ye.$$.fragment),et=a(),we=M("p"),we.textContent=Ts,lt=a(),o(Je.$$.fragment),tt=a(),Te=M("p"),Te.textContent=hs,st=a(),o(he.$$.fragment),at=a(),Ue=M("p"),Ue.textContent=Us,nt=a(),o(je.$$.fragment),pt=a(),de=M("p"),de.innerHTML=js,Mt=a(),o($.$$.fragment),it=a(),o(ue.$$.fragment),rt=a(),be=M("p"),be.textContent=ds,ot=a(),o(Ie.$$.fragment),ct=a(),fe=M("p"),fe.textContent=us,mt=a(),o(Ce.$$.fragment),yt=a(),$e=M("p"),$e.textContent=bs,wt=a(),o(Ze.$$.fragment),Jt=a(),Ge=M("p"),Ge.textContent=Is,Tt=a(),_e=M("p"),_e.innerHTML=fs,ht=a(),o(ge.$$.fragment),Ut=a(),ke=M("p"),ke.innerHTML=Cs,jt=a(),o(We.$$.fragment),dt=a(),Be=M("p"),Be.textContent=$s,ut=a(),o(ve.$$.fragment),bt=a(),o(Ye.$$.fragment),It=a(),Ae=M("p"),Ae.innerHTML=Zs,ft=a(),Ne=M("p"),Ne.innerHTML=Gs,Ct=a(),o(Xe.$$.fragment),$t=a(),o(Re.$$.fragment),Zt=a(),Ve=M("p"),Ve.textContent=_s,Gt=a(),xe=M("p"),xe.textContent=gs,_t=a(),o(Fe.$$.fragment),gt=a(),Qe=M("p"),Qe.textContent=ks,kt=a(),o(Z.$$.fragment),Wt=a(),o(ze.$$.fragment),Bt=a(),Ee=M("p"),Ee.textContent=Ws,vt=a(),o(Se.$$.fragment),Yt=a(),He=M("p"),He.innerHTML=Bs,At=a(),o(Le.$$.fragment),Nt=a(),De=M("p"),De.textContent=vs,Xt=a(),o(qe.$$.fragment),Rt=a(),Pe=M("p"),Pe.textContent=Ys,Vt=a(),Ke=M("p"),Ke.innerHTML=As,xt=a(),o(Oe.$$.fragment),Ft=a(),o(el.$$.fragment),Qt=a(),ll=M("p"),ll.innerHTML=Ns,zt=a(),o(tl.$$.fragment),Et=a(),sl=M("p"),sl.textContent=Xs,St=a(),al=M("ul"),al.innerHTML=Rs,Ht=a(),o(nl.$$.fragment),Lt=a(),rl=M("p"),this.h()},l(e){const l=Os("svelte-u9bgzb",document.head);p=i(l,"META",{name:!0,content:!0}),l.forEach(t),U=n(e),T=i(e,"P",{}),Hs(T).forEach(t),j=n(e),c(G.$$.fragment,e),ol=n(e),_=i(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6spvy7"&&(_.textContent=qt),cl=n(e),c(u.$$.fragment,e),ml=n(e),c(g.$$.fragment,e),yl=n(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-i0i66y"&&(k.textContent=Pt),wl=n(e),c(W.$$.fragment,e),Jl=n(e),B=i(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1p9trxm"&&(B.innerHTML=Kt),Tl=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-3qwb6i"&&(v.textContent=Ot),hl=n(e),c(b.$$.fragment,e),Ul=n(e),c(Y.$$.fragment,e),jl=n(e),c(A.$$.fragment,e),dl=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-maqpj6"&&(N.innerHTML=es),ul=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1gkh70d"&&(X.textContent=ls),bl=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-myu7hv"&&(R.innerHTML=ts),Il=n(e),c(V.$$.fragment,e),fl=n(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-h07c4l"&&(x.textContent=ss),Cl=n(e),c(F.$$.fragment,e),$l=n(e),c(Q.$$.fragment,e),Zl=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-60ulbw"&&(z.innerHTML=as),Gl=n(e),c(E.$$.fragment,e),_l=n(e),c(S.$$.fragment,e),gl=n(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1kzkru5"&&(H.textContent=ns),kl=n(e),c(L.$$.fragment,e),Wl=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-eeriqt"&&(D.innerHTML=ps),Bl=n(e),c(q.$$.fragment,e),vl=n(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1erq0yi"&&(P.textContent=Ms),Yl=n(e),c(K.$$.fragment,e),Al=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-17fsfbj"&&(O.textContent=is),Nl=n(e),c(ee.$$.fragment,e),Xl=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1wyd1v3"&&(le.innerHTML=rs),Rl=n(e),c(te.$$.fragment,e),Vl=n(e),se=i(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-s9102n"&&(se.textContent=os),xl=n(e),c(ae.$$.fragment,e),Fl=n(e),c(ne.$$.fragment,e),Ql=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-gvecrk"&&(pe.innerHTML=cs),zl=n(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-oa85ci"&&(Me.textContent=ms),El=n(e),c(I.$$.fragment,e),Sl=n(e),c(ie.$$.fragment,e),Hl=n(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-18iotds"&&(re.innerHTML=ys),Ll=n(e),c(f.$$.fragment,e),Dl=n(e),oe=i(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1ojop43"&&(oe.textContent=ws),ql=n(e),c(ce.$$.fragment,e),Pl=n(e),c(C.$$.fragment,e),Kl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-2qfnag"&&(me.textContent=Js),Ol=n(e),c(ye.$$.fragment,e),et=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-16kq69y"&&(we.textContent=Ts),lt=n(e),c(Je.$$.fragment,e),tt=n(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1x7hf7y"&&(Te.textContent=hs),st=n(e),c(he.$$.fragment,e),at=n(e),Ue=i(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1drdkyl"&&(Ue.textContent=Us),nt=n(e),c(je.$$.fragment,e),pt=n(e),de=i(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-mdvtax"&&(de.innerHTML=js),Mt=n(e),c($.$$.fragment,e),it=n(e),c(ue.$$.fragment,e),rt=n(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-8iqamy"&&(be.textContent=ds),ot=n(e),c(Ie.$$.fragment,e),ct=n(e),fe=i(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-uq3liu"&&(fe.textContent=us),mt=n(e),c(Ce.$$.fragment,e),yt=n(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-1vssgg7"&&($e.textContent=bs),wt=n(e),c(Ze.$$.fragment,e),Jt=n(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-o67l3v"&&(Ge.textContent=Is),Tt=n(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-11u0vbq"&&(_e.innerHTML=fs),ht=n(e),c(ge.$$.fragment,e),Ut=n(e),ke=i(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-sw8iaw"&&(ke.innerHTML=Cs),jt=n(e),c(We.$$.fragment,e),dt=n(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-1kobhd"&&(Be.textContent=$s),ut=n(e),c(ve.$$.fragment,e),bt=n(e),c(Ye.$$.fragment,e),It=n(e),Ae=i(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-xq2hb8"&&(Ae.innerHTML=Zs),ft=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-7o5jv1"&&(Ne.innerHTML=Gs),Ct=n(e),c(Xe.$$.fragment,e),$t=n(e),c(Re.$$.fragment,e),Zt=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-rkokvk"&&(Ve.textContent=_s),Gt=n(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-192rw96"&&(xe.textContent=gs),_t=n(e),c(Fe.$$.fragment,e),gt=n(e),Qe=i(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-3ig3ul"&&(Qe.textContent=ks),kt=n(e),c(Z.$$.fragment,e),Wt=n(e),c(ze.$$.fragment,e),Bt=n(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-10flsnd"&&(Ee.textContent=Ws),vt=n(e),c(Se.$$.fragment,e),Yt=n(e),He=i(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-lkd19f"&&(He.innerHTML=Bs),At=n(e),c(Le.$$.fragment,e),Nt=n(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-svq1hp"&&(De.textContent=vs),Xt=n(e),c(qe.$$.fragment,e),Rt=n(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-9wooxy"&&(Pe.textContent=Ys),Vt=n(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-1u7g08e"&&(Ke.innerHTML=As),xt=n(e),c(Oe.$$.fragment,e),Ft=n(e),c(el.$$.fragment,e),Qt=n(e),ll=i(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-1p7dsaj"&&(ll.innerHTML=Ns),zt=n(e),c(tl.$$.fragment,e),Et=n(e),sl=i(e,"P",{"data-svelte-h":!0}),r(sl)!=="svelte-ixf1ne"&&(sl.textContent=Xs),St=n(e),al=i(e,"UL",{"data-svelte-h":!0}),r(al)!=="svelte-1apq45z"&&(al.innerHTML=Rs),Ht=n(e),c(nl.$$.fragment,e),Lt=n(e),rl=i(e,"P",{}),Hs(rl).forEach(t),this.h()},h(){Ls(p,"name","hf:doc:metadata"),Ls(p,"content",oa)},m(e,l){ea(document.head,p),s(e,U,l),s(e,T,l),s(e,j,l),m(G,e,l),s(e,ol,l),s(e,_,l),s(e,cl,l),m(u,e,l),s(e,ml,l),m(g,e,l),s(e,yl,l),s(e,k,l),s(e,wl,l),m(W,e,l),s(e,Jl,l),s(e,B,l),s(e,Tl,l),s(e,v,l),s(e,hl,l),m(b,e,l),s(e,Ul,l),m(Y,e,l),s(e,jl,l),m(A,e,l),s(e,dl,l),s(e,N,l),s(e,ul,l),s(e,X,l),s(e,bl,l),s(e,R,l),s(e,Il,l),m(V,e,l),s(e,fl,l),s(e,x,l),s(e,Cl,l),m(F,e,l),s(e,$l,l),m(Q,e,l),s(e,Zl,l),s(e,z,l),s(e,Gl,l),m(E,e,l),s(e,_l,l),m(S,e,l),s(e,gl,l),s(e,H,l),s(e,kl,l),m(L,e,l),s(e,Wl,l),s(e,D,l),s(e,Bl,l),m(q,e,l),s(e,vl,l),s(e,P,l),s(e,Yl,l),m(K,e,l),s(e,Al,l),s(e,O,l),s(e,Nl,l),m(ee,e,l),s(e,Xl,l),s(e,le,l),s(e,Rl,l),m(te,e,l),s(e,Vl,l),s(e,se,l),s(e,xl,l),m(ae,e,l),s(e,Fl,l),m(ne,e,l),s(e,Ql,l),s(e,pe,l),s(e,zl,l),s(e,Me,l),s(e,El,l),m(I,e,l),s(e,Sl,l),m(ie,e,l),s(e,Hl,l),s(e,re,l),s(e,Ll,l),m(f,e,l),s(e,Dl,l),s(e,oe,l),s(e,ql,l),m(ce,e,l),s(e,Pl,l),m(C,e,l),s(e,Kl,l),s(e,me,l),s(e,Ol,l),m(ye,e,l),s(e,et,l),s(e,we,l),s(e,lt,l),m(Je,e,l),s(e,tt,l),s(e,Te,l),s(e,st,l),m(he,e,l),s(e,at,l),s(e,Ue,l),s(e,nt,l),m(je,e,l),s(e,pt,l),s(e,de,l),s(e,Mt,l),m($,e,l),s(e,it,l),m(ue,e,l),s(e,rt,l),s(e,be,l),s(e,ot,l),m(Ie,e,l),s(e,ct,l),s(e,fe,l),s(e,mt,l),m(Ce,e,l),s(e,yt,l),s(e,$e,l),s(e,wt,l),m(Ze,e,l),s(e,Jt,l),s(e,Ge,l),s(e,Tt,l),s(e,_e,l),s(e,ht,l),m(ge,e,l),s(e,Ut,l),s(e,ke,l),s(e,jt,l),m(We,e,l),s(e,dt,l),s(e,Be,l),s(e,ut,l),m(ve,e,l),s(e,bt,l),m(Ye,e,l),s(e,It,l),s(e,Ae,l),s(e,ft,l),s(e,Ne,l),s(e,Ct,l),m(Xe,e,l),s(e,$t,l),m(Re,e,l),s(e,Zt,l),s(e,Ve,l),s(e,Gt,l),s(e,xe,l),s(e,_t,l),m(Fe,e,l),s(e,gt,l),s(e,Qe,l),s(e,kt,l),m(Z,e,l),s(e,Wt,l),m(ze,e,l),s(e,Bt,l),s(e,Ee,l),s(e,vt,l),m(Se,e,l),s(e,Yt,l),s(e,He,l),s(e,At,l),m(Le,e,l),s(e,Nt,l),s(e,De,l),s(e,Xt,l),m(qe,e,l),s(e,Rt,l),s(e,Pe,l),s(e,Vt,l),s(e,Ke,l),s(e,xt,l),m(Oe,e,l),s(e,Ft,l),m(el,e,l),s(e,Qt,l),s(e,ll,l),s(e,zt,l),m(tl,e,l),s(e,Et,l),s(e,sl,l),s(e,St,l),s(e,al,l),s(e,Ht,l),m(nl,e,l),s(e,Lt,l),s(e,rl,l),Dt=!0},p(e,[l]){const Vs={};l&2&&(Vs.$$scope={dirty:l,ctx:e}),u.$set(Vs);const xs={};l&2&&(xs.$$scope={dirty:l,ctx:e}),b.$set(xs);const Fs={};l&2&&(Fs.$$scope={dirty:l,ctx:e}),I.$set(Fs);const Qs={};l&2&&(Qs.$$scope={dirty:l,ctx:e}),f.$set(Qs);const zs={};l&2&&(zs.$$scope={dirty:l,ctx:e}),C.$set(zs);const Es={};l&2&&(Es.$$scope={dirty:l,ctx:e}),$.$set(Es);const Ss={};l&2&&(Ss.$$scope={dirty:l,ctx:e}),Z.$set(Ss)},i(e){Dt||(y(G.$$.fragment,e),y(u.$$.fragment,e),y(g.$$.fragment,e),y(W.$$.fragment,e),y(b.$$.fragment,e),y(Y.$$.fragment,e),y(A.$$.fragment,e),y(V.$$.fragment,e),y(F.$$.fragment,e),y(Q.$$.fragment,e),y(E.$$.fragment,e),y(S.$$.fragment,e),y(L.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(ne.$$.fragment,e),y(I.$$.fragment,e),y(ie.$$.fragment,e),y(f.$$.fragment,e),y(ce.$$.fragment,e),y(C.$$.fragment,e),y(ye.$$.fragment,e),y(Je.$$.fragment,e),y(he.$$.fragment,e),y(je.$$.fragment,e),y($.$$.fragment,e),y(ue.$$.fragment,e),y(Ie.$$.fragment,e),y(Ce.$$.fragment,e),y(Ze.$$.fragment,e),y(ge.$$.fragment,e),y(We.$$.fragment,e),y(ve.$$.fragment,e),y(Ye.$$.fragment,e),y(Xe.$$.fragment,e),y(Re.$$.fragment,e),y(Fe.$$.fragment,e),y(Z.$$.fragment,e),y(ze.$$.fragment,e),y(Se.$$.fragment,e),y(Le.$$.fragment,e),y(qe.$$.fragment,e),y(Oe.$$.fragment,e),y(el.$$.fragment,e),y(tl.$$.fragment,e),y(nl.$$.fragment,e),Dt=!0)},o(e){w(G.$$.fragment,e),w(u.$$.fragment,e),w(g.$$.fragment,e),w(W.$$.fragment,e),w(b.$$.fragment,e),w(Y.$$.fragment,e),w(A.$$.fragment,e),w(V.$$.fragment,e),w(F.$$.fragment,e),w(Q.$$.fragment,e),w(E.$$.fragment,e),w(S.$$.fragment,e),w(L.$$.fragment,e),w(q.$$.fragment,e),w(K.$$.fragment,e),w(ee.$$.fragment,e),w(te.$$.fragment,e),w(ae.$$.fragment,e),w(ne.$$.fragment,e),w(I.$$.fragment,e),w(ie.$$.fragment,e),w(f.$$.fragment,e),w(ce.$$.fragment,e),w(C.$$.fragment,e),w(ye.$$.fragment,e),w(Je.$$.fragment,e),w(he.$$.fragment,e),w(je.$$.fragment,e),w($.$$.fragment,e),w(ue.$$.fragment,e),w(Ie.$$.fragment,e),w(Ce.$$.fragment,e),w(Ze.$$.fragment,e),w(ge.$$.fragment,e),w(We.$$.fragment,e),w(ve.$$.fragment,e),w(Ye.$$.fragment,e),w(Xe.$$.fragment,e),w(Re.$$.fragment,e),w(Fe.$$.fragment,e),w(Z.$$.fragment,e),w(ze.$$.fragment,e),w(Se.$$.fragment,e),w(Le.$$.fragment,e),w(qe.$$.fragment,e),w(Oe.$$.fragment,e),w(el.$$.fragment,e),w(tl.$$.fragment,e),w(nl.$$.fragment,e),Dt=!1},d(e){e&&(t(U),t(T),t(j),t(ol),t(_),t(cl),t(ml),t(yl),t(k),t(wl),t(Jl),t(B),t(Tl),t(v),t(hl),t(Ul),t(jl),t(dl),t(N),t(ul),t(X),t(bl),t(R),t(Il),t(fl),t(x),t(Cl),t($l),t(Zl),t(z),t(Gl),t(_l),t(gl),t(H),t(kl),t(Wl),t(D),t(Bl),t(vl),t(P),t(Yl),t(Al),t(O),t(Nl),t(Xl),t(le),t(Rl),t(Vl),t(se),t(xl),t(Fl),t(Ql),t(pe),t(zl),t(Me),t(El),t(Sl),t(Hl),t(re),t(Ll),t(Dl),t(oe),t(ql),t(Pl),t(Kl),t(me),t(Ol),t(et),t(we),t(lt),t(tt),t(Te),t(st),t(at),t(Ue),t(nt),t(pt),t(de),t(Mt),t(it),t(rt),t(be),t(ot),t(ct),t(fe),t(mt),t(yt),t($e),t(wt),t(Jt),t(Ge),t(Tt),t(_e),t(ht),t(Ut),t(ke),t(jt),t(dt),t(Be),t(ut),t(bt),t(It),t(Ae),t(ft),t(Ne),t(Ct),t($t),t(Zt),t(Ve),t(Gt),t(xe),t(_t),t(gt),t(Qe),t(kt),t(Wt),t(Bt),t(Ee),t(vt),t(Yt),t(He),t(At),t(Nt),t(De),t(Xt),t(Rt),t(Pe),t(Vt),t(Ke),t(xt),t(Ft),t(Qt),t(ll),t(zt),t(Et),t(sl),t(St),t(al),t(Ht),t(Lt),t(rl)),t(p),J(G,e),J(u,e),J(g,e),J(W,e),J(b,e),J(Y,e),J(A,e),J(V,e),J(F,e),J(Q,e),J(E,e),J(S,e),J(L,e),J(q,e),J(K,e),J(ee,e),J(te,e),J(ae,e),J(ne,e),J(I,e),J(ie,e),J(f,e),J(ce,e),J(C,e),J(ye,e),J(Je,e),J(he,e),J(je,e),J($,e),J(ue,e),J(Ie,e),J(Ce,e),J(Ze,e),J(ge,e),J(We,e),J(ve,e),J(Ye,e),J(Xe,e),J(Re,e),J(Fe,e),J(Z,e),J(ze,e),J(Se,e),J(Le,e),J(qe,e),J(Oe,e),J(el,e),J(tl,e),J(nl,e)}}}const oa='{"title":"Launching distributed training from Jupyter Notebooks","local":"launching-distributed-training-from-jupyter-notebooks","sections":[{"title":"Configuring the Environment","local":"configuring-the-environment","sections":[],"depth":2},{"title":"Preparing the Dataset and Model","local":"preparing-the-dataset-and-model","sections":[],"depth":2},{"title":"Writing the Training Function","local":"writing-the-training-function","sections":[],"depth":2},{"title":"Using the notebook_launcher","local":"using-the-notebooklauncher","sections":[],"depth":2},{"title":"Debugging","local":"debugging","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function ca(d){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ha extends Ps{constructor(p){super(),Ks(this,p,ca,ra,Ds,{})}}export{ha as component};
