import{s as Sd,o as zd,n as k}from"../chunks/scheduler.6062bdaf.js";import{S as Bd,i as qd,g as m,s as l,r as u,A as Od,h as d,f as p,c as r,j as v,u as g,x as _,k as j,y as o,a as c,v as h,d as f,t as b,w as M}from"../chunks/index.4bca734e.js";import{T as W}from"../chunks/Tip.b9ac1f03.js";import{D as J}from"../chunks/Docstring.85ff1b1b.js";import{C as R}from"../chunks/CodeBlock.cbbddafc.js";import{E as U}from"../chunks/ExampleCodeBlock.558660fa.js";import{H as x,E as Ed}from"../chunks/getInferenceSnippets.855730f4.js";function Hd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Ld(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ2F1c2FsTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwQXJ0aHVyJTIwYW5kJTIwSSUyMGxpdmUlMjBpbiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBZ2VuX3Rva2VucyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDZG9fc2FtcGxlJTNEVHJ1ZSUyQ3RlbXBlcmF0dXJlJTNEMC45JTJDJTIwbWluX2xlbmd0aCUzRDIwJTJDbWF4X2xlbmd0aCUzRDIwKSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuX3Rva2Vucyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs,do_sample=<span class="hljs-literal">True</span>,temperature=<span class="hljs-number">0.9</span>, min_length=<span class="hljs-number">20</span>,max_length=<span class="hljs-number">20</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Qd(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZncHQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmdwdDIlMjIpJTBBb25ueF9nZW4lMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMEFydGh1ciUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjIlMEFnZW4lMjAlM0QlMjBvbm54X2dlbih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;optimum/gpt2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_gen = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Arthur and I live in&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>gen = onnx_gen(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Yd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Pd(w){let n,T="Example of feature extraction:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTWFza2VkTE0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMlRoZSUyMGNhcGl0YWwlMjBvZiUyMEZyYW5jZSUyMGlzJTIwJTVCTUFTSyU1RC4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">8</span>, <span class="hljs-number">28996</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Ad(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JNYXNrZWRMTSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZC1mb3ItZmlsbC1tYXNrJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkLWZvci1maWxsLW1hc2slMjIpJTBBZmlsbF9tYXNrZXIlMjAlM0QlMjBwaXBlbGluZSglMjJmaWxsLW1hc2slMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJUaGUlMjBjYXBpdGFsJTIwb2YlMjBGcmFuY2UlMjBpcyUyMCU1Qk1BU0slNUQuJTIyJTBBcHJlZCUyMCUzRCUyMGZpbGxfbWFza2VyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased-for-fill-mask&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>fill_masker = pipeline(<span class="hljs-string">&quot;fill-mask&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;The capital of France is [MASK].&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = fill_masker(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Dd(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Kd(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxMlNlcUxNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ0NS1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyTXklMjBuYW1lJTIwaXMlMjBFdXN0YWNoZSUyMGFuZCUyMEklMjBsaWtlJTIwdG8lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Eustache and I like to&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function ec(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXEyU2VxTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdDUtc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnQ1LXNtYWxsJTIyKSUwQW9ubnhfdHJhbnNsYXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJ0cmFuc2xhdGlvbl9lbl90b19kZSUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMk15JTIwbmFtZSUyMGlzJTIwRXVzdGFjaGUuJTIyJTBBcHJlZCUyMCUzRCUyMG9ubnhfdHJhbnNsYXRpb24odGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSeq2SeqLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;optimum/t5-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_translation = pipeline(<span class="hljs-string">&quot;translation_en_to_de&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Eustache.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_translation(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function tc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function nc(w){let n,T="Example of single-label classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-ykxpe4"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function sc(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2glMjIpJTBBb25ueF9jbGFzc2lmaWVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBdGV4dCUyMCUzRCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9jbGFzc2lmaWVyKHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_classifier = pipeline(<span class="hljs-string">&quot;text-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_classifier(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function oc(w){let n,T="Example using zero-shot-classification <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLW1ubGklMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkaXN0aWxiZXJ0LWJhc2UtdW5jYXNlZC1tbmxpJTIyKSUwQW9ubnhfejAlMjAlM0QlMjBwaXBlbGluZSglMjJ6ZXJvLXNob3QtY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXNlcXVlbmNlX3RvX2NsYXNzaWZ5JTIwJTNEJTIwJTIyV2hvJTIwYXJlJTIweW91JTIwdm90aW5nJTIwZm9yJTIwaW4lMjAyMDIwJTNGJTIyJTBBY2FuZGlkYXRlX2xhYmVscyUyMCUzRCUyMCU1QiUyMkV1cm9wZSUyMiUyQyUyMCUyMnB1YmxpYyUyMGhlYWx0aCUyMiUyQyUyMCUyMnBvbGl0aWNzJTIyJTJDJTIwJTIyZWxlY3Rpb25zJTIyJTVEJTBBcHJlZCUyMCUzRCUyMG9ubnhfejAoc2VxdWVuY2VfdG9fY2xhc3NpZnklMkMlMjBjYW5kaWRhdGVfbGFiZWxzJTJDJTIwbXVsdGlfbGFiZWwlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-mnli&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_z0 = pipeline(<span class="hljs-string">&quot;zero-shot-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>sequence_to_classify = <span class="hljs-string">&quot;Who are you voting for in 2020?&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>candidate_labels = [<span class="hljs-string">&quot;Europe&quot;</span>, <span class="hljs-string">&quot;public health&quot;</span>, <span class="hljs-string">&quot;politics&quot;</span>, <span class="hljs-string">&quot;elections&quot;</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_z0(sequence_to_classify, candidate_labels, multi_label=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1vtj8d2"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function ac(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function lc(w){let n,T="Example of token classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVG9rZW5DbGFzc2lmaWNhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMm5wJTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-rtgw80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function rc(w){let n,T="Example using <code>transformers.pipelines</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS1ORVIlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtTkVSJTIyKSUwQW9ubnhfbmVyJTIwJTNEJTIwcGlwZWxpbmUoJTIydG9rZW4tY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9uZXIodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ner = pipeline(<span class="hljs-string">&quot;token-classification&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ner(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1da1qsq"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function ic(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function pc(w){let n,T="Example of mutliple choice:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJlaGR3bnMxNTE2JTJGYmVydC1iYXNlLXVuY2FzZWRfU1dBRyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMmVoZHduczE1MTYlMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEFudW1fY2hvaWNlcyUyMCUzRCUyMDQlMEFmaXJzdF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUyMk1lbWJlcnMlMjBvZiUyMHRoZSUyMHByb2Nlc3Npb24lMjB3YWxrJTIwZG93biUyMHRoZSUyMHN0cmVldCUyMGhvbGRpbmclMjBzbWFsbCUyMGhvcm4lMjBicmFzcyUyMGluc3RydW1lbnRzLiUyMiU1RCUyMColMjBudW1fY2hvaWNlcyUwQXNlY29uZF9zZW50ZW5jZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHBhc3NlcyUyMGJ5JTIwd2Fsa2luZyUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBwbGF5aW5nJTIwdGhlaXIlMjBpbnN0cnVtZW50cy4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBoYXMlMjBoZWFyZCUyMGFwcHJvYWNoaW5nJTIwdGhlbS4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBhcnJpdmVzJTIwYW5kJTIwdGhleSdyZSUyMG91dHNpZGUlMjBkYW5jaW5nJTIwYW5kJTIwYXNsZWVwLiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkElMjBkcnVtJTIwbGluZSUyMHR1cm5zJTIwdGhlJTIwbGVhZCUyMHNpbmdlciUyMHdhdGNoZXMlMjB0aGUlMjBwZXJmb3JtYW5jZS4lMjIlMEElNUQlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoZmlyc3Rfc2VudGVuY2UlMkMlMjBzZWNvbmRfc2VudGVuY2UlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSUyQyUyMHBhZGRpbmclM0RUcnVlKSUwQSUwQWZvciUyMGslMkMlMjB2JTIwaW4lMjBpbnB1dHMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMGlucHV0cyU1QmslNUQlMjAlM0QlMjAlNUJ2JTVCaSUzQSUyMGklMjAlMkIlMjBudW1fY2hvaWNlcyU1RCUyMGZvciUyMGklMjBpbiUyMHJhbmdlKDAlMkMlMjBsZW4odiklMkMlMjBudW1fY2hvaWNlcyklNUQlMEFpbnB1dHMlMjAlM0QlMjBkaWN0KGlucHV0cy5jb252ZXJ0X3RvX3RlbnNvcnModGVuc29yX3R5cGUlM0QlMjJwdCUyMikpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;ehdwns1516/bert-base-uncased_SWAG&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-lfckvi"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function mc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function dc(w){let n,T="Example of question answering:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjMlNUQpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzJTJDJTIwc3RhcnRfcG9zaXRpb25zJTNEc3RhcnRfcG9zaXRpb25zJTJDJTIwZW5kX3Bvc2l0aW9ucyUzRGVuZF9wb3NpdGlvbnMpJTBBc3RhcnRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMlMEFlbmRfc2NvcmVzJTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">3</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1ml1brl"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function cc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZyb2JlcnRhLWJhc2Utc3F1YWQyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDIlMjIpJTBBb25ueF9xYSUyMCUzRCUyMHBpcGVsaW5lKCUyMnF1ZXN0aW9uLWFuc3dlcmluZyUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcXVlc3Rpb24lMkMlMjB0ZXh0JTIwJTNEJTIwJTIyV2hvJTIwd2FzJTIwSmltJTIwSGVuc29uJTNGJTIyJTJDJTIwJTIySmltJTIwSGVuc29uJTIwd2FzJTIwYSUyMG5pY2UlMjBwdXBwZXQlMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9xYShxdWVzdGlvbiUyQyUyMHRleHQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_qa = pipeline(<span class="hljs-string">&quot;question-answering&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_qa(question, text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function uc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function gc(w){let n,T="Example of image classification:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvRmVhdHVyZUV4dHJhY3RvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvRmVhdHVyZUV4dHJhY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1nh3zco"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function hc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JJbWFnZUNsYXNzaWZpY2F0aW9uJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKSUwQW9ubnhfaW1hZ2VfY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMmltYWdlLWNsYXNzaWZpY2F0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9jbGFzc2lmaWVyKHVybCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForImageClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_classifier = pipeline(<span class="hljs-string">&quot;image-classification&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_classifier(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function fc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function bc(w){let n,T="Example of semantic segmentation:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNlZ2Zvcm1lci1iMC1maW5ldHVuZWQtYWRlLTUxMi01MTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJucCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHM=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1wzzaup"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Mc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTZW1hbnRpY1NlZ21lbnRhdGlvbiUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2VnZm9ybWVyLWIwLWZpbmV0dW5lZC1hZGUtNTEyLTUxMiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU2VtYW50aWNTZWdtZW50YXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzZWdmb3JtZXItYjAtZmluZXR1bmVkLWFkZS01MTItNTEyJTIyKSUwQW9ubnhfaW1hZ2Vfc2VnbWVudGVyJTIwJTNEJTIwcGlwZWxpbmUoJTIyaW1hZ2Utc2VnbWVudGF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJlcHJvY2Vzc29yKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9pbWFnZV9zZWdtZW50ZXIodXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSemanticSegmentation

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/segformer-b0-finetuned-ade-512-512&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_image_segmenter = pipeline(<span class="hljs-string">&quot;image-segmentation&quot;</span>, model=model, feature_extractor=preprocessor)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_image_segmenter(url)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function yc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Tc(w){let n,T="Example of audio classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJlZGljdGVkX2NsYXNzX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSkuaXRlbSgpJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkcyU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1mp8f15"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function _c(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTJDJTIwcGlwZWxpbmUlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQXVkaW9DbGFzc2lmaWNhdGlvbiUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZodWJlcnQtYmFzZS1zdXBlcmIta3MlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JBdWRpb0NsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWJhc2Utc3VwZXJiLWtzJTIyKSUwQW9ubnhfYWMlMjAlM0QlMjBwaXBlbGluZSglMjJhdWRpby1jbGFzc2lmaWNhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRGZlYXR1cmVfZXh0cmFjdG9yKSUwQSUwQXByZWQlMjAlM0QlMjBvbm54X2FjKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-base-superb-ks&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_ac = pipeline(<span class="hljs-string">&quot;audio-classification&quot;</span>, model=model, feature_extractor=feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_ac(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function $c(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function wc(w){let n,T="Example of audio frame classification:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME9SVE1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoZGF0YXNldCU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  ORTModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sd&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12boqdm"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function vc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function jc(w){let n,T="Example of CTC:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBIdWJlcnRGb3JDVEMlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ1RDJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBaW1wb3J0JTIwdG9yY2glMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMmhmLWludGVybmFsLXRlc3RpbmclMkZsaWJyaXNwZWVjaF9hc3JfZGVtbyUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWRhdGFzZXQlMjAlM0QlMjBkYXRhc2V0LnNvcnQoJTIyaWQlMjIpJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGRhdGFzZXQuZmVhdHVyZXMlNUIlMjJhdWRpbyUyMiU1RC5zYW1wbGluZ19yYXRlJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmh1YmVydC1sYXJnZS1sczk2MC1mdCUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ1RDLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGaHViZXJ0LWxhcmdlLWxzOTYwLWZ0JTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTBBdHJhbnNjcmlwdGlvbiUyMCUzRCUyMHByb2Nlc3Nvci5iYXRjaF9kZWNvZGUocHJlZGljdGVkX2lkcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, HubertForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCTC.from_pretrained(<span class="hljs-string">&quot;optimum/hubert-large-ls960-ft&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-mdyxnj"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Jc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function kc(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcSUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNwZWVjaFNlcTJTZXEuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3aGlzcGVyLXRpbnkuZW4lMjIpJTBBJTBBZHMlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kdW1teSUyMiUyQyUyMCUyMmNsZWFuJTIyJTJDJTIwc3BsaXQlM0QlMjJ2YWxpZGF0aW9uJTIyKSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvcihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFnZW5fdG9rZW5zJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzJTNEaW5wdXRzLmlucHV0X2ZlYXR1cmVzKSUwQW91dHB1dHMlMjAlM0QlMjBwcm9jZXNzb3IudG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor.feature_extractor(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(inputs=inputs.input_features)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.tokenizer.batch_decode(gen_tokens)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function xc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JTcGVlY2hTZXEyU2VxJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yU3BlZWNoU2VxMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRndoaXNwZXItdGlueS5lbiUyMiklMEFzcGVlY2hfcmVjb2duaXRpb24lMjAlM0QlMjBwaXBlbGluZSglMjJhdXRvbWF0aWMtc3BlZWNoLXJlY29nbml0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHByb2Nlc3Nvci50b2tlbml6ZXIlMkMlMjBmZWF0dXJlX2V4dHJhY3RvciUzRHByb2Nlc3Nvci5mZWF0dXJlX2V4dHJhY3RvciklMEElMEFkcyUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2R1bW15JTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBcHJlZCUyMCUzRCUyMHNwZWVjaF9yZWNvZ25pdGlvbihkcyU1QjAlNUQlNUIlMjJhdWRpbyUyMiU1RCU1QiUyMmFycmF5JTIyJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSpeechSeq2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSpeechSeq2Seq.from_pretrained(<span class="hljs-string">&quot;optimum/whisper-tiny.en&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>speech_recognition = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, tokenizer=processor.tokenizer, feature_extractor=processor.feature_extractor)

<span class="hljs-meta">&gt;&gt;&gt; </span>ds = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_dummy&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = speech_recognition(ds[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>])`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Uc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Rc(w){let n,T="Example of Audio XVector:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9GZWF0dXJlRXh0cmFjdG9yJTBBZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvckF1ZGlvWFZlY3RvciUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b0ZlYXR1cmVFeHRyYWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zdiUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQXVkaW9YVmVjdG9yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc3YlMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvciglMEElMjAlMjAlMjAlMjAlNUJkJTVCJTIyYXJyYXklMjIlNUQlMjBmb3IlMjBkJTIwaW4lMjBkYXRhc2V0JTVCJTNBMiU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVEJTJDJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsaW5nX3JhdGUlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTIwcGFkZGluZyUzRFRydWUlMEEpJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpLmNwdSgpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoFeatureExtractor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForAudioXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoFeatureExtractor.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForAudioXVector.from_pretrained(<span class="hljs-string">&quot;optimum/wav2vec2-base-superb-sv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>).cpu()

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1kzdm5c"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Zc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Wc(w){let n,T="Example of text generation:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcSUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yVmlzaW9uMlNlcS5mcm9tX3ByZXRyYWluZWQoJTIybmxwY29ubmVjdCUyRnZpdC1ncHQyLWltYWdlLWNhcHRpb25pbmclMjIlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = tokenizer.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)
`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1bvu0cy"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Cc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm5scGNvbm5lY3QlMkZ2aXQtZ3B0Mi1pbWFnZS1jYXB0aW9uaW5nJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JWaXNpb24yU2VxLmZyb21fcHJldHJhaW5lZCglMjJubHBjb25uZWN0JTJGdml0LWdwdDItaW1hZ2UtY2FwdGlvbmluZyUyMiUyQyUyMGV4cG9ydCUzRFRydWUpJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3RvX3RleHQlMjAlM0QlMjBwaXBlbGluZSglMjJpbWFnZS10by10ZXh0JTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUyMGZlYXR1cmVfZXh0cmFjdG9yJTNEcHJvY2Vzc29yJTJDJTIwaW1hZ2VfcHJvY2Vzc29yJTNEcHJvY2Vzc29yKSUwQXByZWQlMjAlM0QlMjBpbWFnZV90b190ZXh0KGltYWdlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForVision2Seq
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests


<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForVision2Seq.from_pretrained(<span class="hljs-string">&quot;nlpconnect/vit-gpt2-image-captioning&quot;</span>, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_to_text = pipeline(<span class="hljs-string">&quot;image-to-text&quot;</span>, model=model, tokenizer=tokenizer, feature_extractor=processor, image_processor=processor)
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = image_to_text(image)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Fc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Ic(w){let n,T="Example of pix2struct:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUGl4MlN0cnVjdCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGcGl4MnN0cnVjdC1haTJkLWJhc2UlMjIpJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclBpeDJTdHJ1Y3QuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnBpeDJzdHJ1Y3QtYWkyZC1iYXNlJTIyJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHVzZV9pb19iaW5kaW5nJTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZ0cmFuc2Zvcm1lcnMlMkZ0YXNrcyUyRmFpMmQtZGVtby5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFxdWVzdGlvbiUyMCUzRCUyMCUyMldoYXQlMjBkb2VzJTIwdGhlJTIwbGFiZWwlMjAxNSUyMHJlcHJlc2VudCUzRiUyMCgxKSUyMGxhdmElMjAoMiklMjBjb3JlJTIwKDMpJTIwdHVubmVsJTIwKDQpJTIwYXNoJTIwY2xvdWQlMjIlMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcXVlc3Rpb24lMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQWdlbl90b2tlbnMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEFvdXRwdXRzJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5fdG9rZW5zJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForPix2Struct
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForPix2Struct.from_pretrained(<span class="hljs-string">&quot;google/pix2struct-ai2d-base&quot;</span>, export=<span class="hljs-literal">True</span>, use_io_binding=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/tasks/ai2d-demo.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>question = <span class="hljs-string">&quot;What does the label 15 represent? (1) lava (2) core (3) tunnel (4) ash cloud&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=question, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>gen_tokens = model.generate(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = processor.batch_decode(gen_tokens, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-11ikyn3"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Gc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Vc(w){let n,T="Example of custom tasks(e.g. a sentence transformers taking <code>pooler_output</code> as output):",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGc2JlcnQtYWxsLU1pbmlMTS1MNi13aXRoLXBvb2xlciUyMiklMEFtb2RlbCUyMCUzRCUyME9SVE1vZGVsRm9yQ3VzdG9tVGFza3MuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQXBvb2xlcl9vdXRwdXQlMjAlM0QlMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;I love burritos!&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span>pooler_output = outputs.pooler_output`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-6kynse"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Xc(w){let n,T="Example using <code>transformers.pipelines</code>(only if the task is supported):",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcyUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZzYmVydC1hbGwtTWluaUxNLUw2LXdpdGgtcG9vbGVyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JDdXN0b21UYXNrcy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnNiZXJ0LWFsbC1NaW5pTE0tTDYtd2l0aC1wb29sZXIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJJJTIwbG92ZSUyMGJ1cnJpdG9zISUyMiUwQXByZWQlMjAlM0QlMjBvbm54X2V4dHJhY3Rvcih0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForCustomTasks

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForCustomTasks.from_pretrained(<span class="hljs-string">&quot;optimum/sbert-all-MiniLM-L6-with-pooler&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;I love burritos!&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-xxeb0k"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Nc(w){let n,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){n=m("p"),n.innerHTML=T},l(a){n=d(a,"P",{"data-svelte-h":!0}),_(n)!=="svelte-fincs2"&&(n.innerHTML=T)},m(a,s){c(a,n,s)},p:k,d(a){a&&p(n)}}}function Sc(w){let n,T="Example of feature extraction:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMk15JTIwbmFtZSUyMGlzJTIwUGhpbGlwcCUyMGFuZCUyMEklMjBsaXZlJTIwaW4lMjBHZXJtYW55LiUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIybnAlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxhc3RfaGlkZGVuX3N0YXRlJTIwJTNEJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZSUwQWxpc3QobGFzdF9oaWRkZW5fc3RhdGUuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>, return_tensors=<span class="hljs-string">&quot;np&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">12</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){n=m("p"),n.textContent=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-12vwt80"&&(n.textContent=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function zc(w){let n,T="Example using <code>transformers.pipeline</code>:",a,s,y;return s=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQWZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbiUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyJTIyKSUwQW1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JGZWF0dXJlRXh0cmFjdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjIlMjIpJTBBb25ueF9leHRyYWN0b3IlMjAlM0QlMjBwaXBlbGluZSglMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXRleHQlMjAlM0QlMjAlMjJNeSUyMG5hbWUlMjBpcyUyMFBoaWxpcHAlMjBhbmQlMjBJJTIwbGl2ZSUyMGluJTIwR2VybWFueS4lMjIlMEFwcmVkJTIwJTNEJTIwb25ueF9leHRyYWN0b3IodGV4dCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, pipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>onnx_extractor = pipeline(<span class="hljs-string">&quot;feature-extraction&quot;</span>, model=model, tokenizer=tokenizer)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;My name is Philipp and I live in Germany.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pred = onnx_extractor(text)`,wrap:!1}}),{c(){n=m("p"),n.innerHTML=T,a=l(),u(s.$$.fragment)},l(t){n=d(t,"P",{"data-svelte-h":!0}),_(n)!=="svelte-1u1xsxh"&&(n.innerHTML=T),a=r(t),g(s.$$.fragment,t)},m(t,$){c(t,n,$),c(t,a,$),h(s,t,$),y=!0},p:k,i(t){y||(f(s.$$.fragment,t),y=!0)},o(t){b(s.$$.fragment,t),y=!1},d(t){t&&(p(n),p(a)),M(s,t)}}}function Bc(w){let n,T,a,s,y,t,$,za,dn,sm="The following ORT classes are available for instantiating a base model class without a specific head.",Ba,cn,qa,Z,un,sr,io,om="Base class for implementing models using ONNX Runtime.",or,po,am=`The ORTModel implements generic methods for interacting with the Hugging Face Hub as well as exporting vanilla
transformers models to ONNX using <code>optimum.exporters.onnx</code> toolchain.`,ar,mo,lm="Class attributes:",lr,co,rm=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;onnx_model&quot;</code>) — The name of the model type to use when
registering the ORTModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The “AutoModel” class to represented by the
current ORTModel class.</li>`,rr,at,gn,ir,uo,im="Returns whether this model can generate sequences with <code>.generate()</code>.",pr,lt,hn,mr,go,pm="Instantiate a pretrained model from a pre-trained model configuration.",Oa,fn,Ea,bn,mm="The following ORT classes are available for the following natural language processing tasks.",Ha,Mn,La,I,yn,dr,ho,dm="ONNX model with a causal language modeling head for ONNX Runtime inference. This class officially supports bloom, codegen, falcon, gpt2, gpt-bigcode, gpt_neo, gpt_neox, gptj, llama.",cr,fo,cm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ur,bo,um='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',gr,ee,Tn,hr,Mo,gm="The <code>ORTModelForCausalLM</code> forward method, overrides the <code>__call__</code> special method.",fr,rt,br,it,Mr,pt,Qa,_n,Ya,G,$n,yr,yo,hm="ONNX Model with a MaskedLMOutput for masked language modeling tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.",Tr,To,fm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,_r,_o,bm='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',$r,te,wn,wr,$o,Mm="The <code>ORTModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method.",vr,mt,jr,dt,Jr,ct,Pa,vn,Aa,V,jn,kr,wo,ym="Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports bart, blenderbot, blenderbot-small, longt5, m2m_100, marian, mbart, mt5, pegasus, t5.",xr,vo,Tm=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ur,jo,_m="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",Rr,ne,Jn,Zr,Jo,$m="The <code>ORTModelForSeq2SeqLM</code> forward method, overrides the <code>__call__</code> special method.",Wr,ut,Cr,gt,Fr,ht,Da,kn,Ka,X,xn,Ir,ko,wm=`ONNX Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Gr,xo,vm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vr,Uo,jm='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Xr,F,Un,Nr,Ro,Jm="The <code>ORTModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method.",Sr,ft,zr,bt,Br,Mt,qr,yt,el,Rn,tl,N,Zn,Or,Zo,km=`ONNX Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks. This class officially supports albert, bert, bloom, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gpt2, ibert, mobilebert, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Er,Wo,xm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Hr,Co,Um='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Lr,se,Wn,Qr,Fo,Rm="The <code>ORTModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method.",Yr,Tt,Pr,_t,Ar,$t,nl,Cn,sl,S,Fn,Dr,Io,Zm=`ONNX Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks. This class officially supports albert, bert, camembert, convbert, data2vec-text, deberta_v2, distilbert, electra, flaubert, ibert, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.`,Kr,Go,Wm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ei,Vo,Cm='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ti,Be,In,ni,Xo,Fm="The <code>ORTModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method.",si,wt,oi,vt,ol,Gn,al,z,Vn,ai,No,Im="ONNX Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD. This class officially supports albert, bart, bert, camembert, convbert, data2vec-text, deberta, deberta_v2, distilbert, electra, flaubert, gptj, ibert, mbart, mobilebert, nystromformer, roberta, roformer, squeezebert, xlm, xlm_roberta.",li,So,Gm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,ri,zo,Vm='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ii,oe,Xn,pi,Bo,Xm="The <code>ORTModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method.",mi,jt,di,Jt,ci,kt,ll,Nn,rl,Sn,Nm="The following ORT classes are available for the following computer vision tasks.",il,zn,pl,B,Bn,ui,qo,Sm="ONNX Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, data2vec-vision, deit, dinov2, levit, mobilenet_v1, mobilenet_v2, mobilevit, poolformer, resnet, segformer, swin, swinv2, vit.",gi,Oo,zm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,hi,Eo,Bm='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',fi,ae,qn,bi,Ho,qm="The <code>ORTModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method.",Mi,xt,yi,Ut,Ti,Rt,ml,On,dl,q,En,_i,Lo,Om="ONNX Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports maskformer, segformer.",$i,Qo,Em=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,wi,Yo,Hm='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',vi,le,Hn,ji,Po,Lm="The <code>ORTModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method.",Ji,Zt,ki,Wt,xi,Ct,cl,Ln,ul,Qn,Qm="The following ORT classes are available for the following audio tasks.",gl,Yn,hl,O,Pn,Ui,Ao,Ym=`ONNX Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting. This class officially supports audio_spectrogram_transformer, data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.`,Ri,Do,Pm=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Zi,Ko,Am='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Wi,re,An,Ci,ea,Dm="The <code>ORTModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method.",Fi,Ft,Ii,It,Gi,Gt,fl,Dn,bl,E,Kn,Vi,ta,Km="ONNX Model with a frame classification head on top for tasks like Speaker Diarization. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Xi,na,ed=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ni,sa,td='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Si,qe,es,zi,oa,nd="The <code>ORTModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method.",Bi,Vt,qi,Xt,Ml,ts,yl,H,ns,Oi,aa,sd="ONNX Model with a language modeling head on top for Connectionist Temporal Classification (CTC). This class officially supports data2vec-audio, hubert, sew, sew-d, unispeech, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",Ei,la,od=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Hi,ra,ad='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Li,Oe,ss,Qi,ia,ld="The <code>ORTModelForCTC</code> forward method, overrides the <code>__call__</code> special method.",Yi,Nt,Pi,St,Tl,os,_l,L,as,Ai,pa,rd="Speech Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports whisper, speech_to_text.",Di,ma,id=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Ki,da,pd="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",ep,ie,ls,tp,ca,md="The <code>ORTModelForSpeechSeq2Seq</code> forward method, overrides the <code>__call__</code> special method.",np,zt,sp,Bt,op,qt,$l,rs,wl,Q,is,ap,ua,dd="ONNX Model with an XVector feature extraction head on top for tasks like Speaker Verification. This class officially supports data2vec-audio, unispeech_sat, wavlm, wav2vec2, wav2vec2-conformer.",lp,ga,cd=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,rp,ha,ud='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',ip,Ee,ps,pp,fa,gd="The <code>ORTModelForAudioXVector</code> forward method, overrides the <code>__call__</code> special method.",mp,Ot,dp,Et,vl,ms,jl,ds,hd="The following ORT classes are available for the following multimodal tasks.",Jl,cs,kl,Y,us,cp,ba,fd="VisionEncoderDecoder Sequence-to-sequence model with a language modeling head for ONNX Runtime inference. This class officially supports trocr and vision-encoder-decoder.",up,Ma,bd=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,gp,ya,Md="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",hp,pe,gs,fp,Ta,yd="The <code>ORTModelForVision2Seq</code> forward method, overrides the <code>__call__</code> special method.",bp,Ht,Mp,Lt,yp,Qt,xl,hs,Ul,P,fs,Tp,_a,Td="Pix2struct model with a language modeling head for ONNX Runtime inference. This class officially supports pix2struct.",_p,$a,_d=`This model inherits from <code>~onnxruntime.modeling_ort.ORTModelForConditionalGeneration</code>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,$p,wa,$d="This class should be initialized using the <code>onnxruntime.modeling_ort.ORTModelForConditionalGeneration.from_pretrained</code> method.",wp,He,bs,vp,va,wd="The <code>ORTModelForPix2Struct</code> forward method, overrides the <code>__call__</code> special method.",jp,Yt,Jp,Pt,Rl,Ms,Zl,ys,vd="The following ORT classes are available for the following custom tasks.",Wl,Ts,Cl,A,_s,kp,ja,jd="ONNX Model for any custom tasks. It can be used to leverage the inference acceleration for any single-file ONNX model, that may use custom inputs and outputs.",xp,Ja,Jd=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Up,ka,kd='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Rp,me,$s,Zp,xa,xd="The <code>ORTModelForCustomTasks</code> forward method, overrides the <code>__call__</code> special method.",Wp,At,Cp,Dt,Fp,Kt,Fl,ws,Il,D,vs,Ip,Ua,Ud="ONNX Model for feature-extraction task.",Gp,Ra,Rd=`This model inherits from <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a>, check its documentation for the generic methods the
library implements for all its model (such as downloading or saving).`,Vp,Za,Zd='This class should be initialized using the <a href="/docs/optimum/v1.27.0/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">onnxruntime.modeling_ort.ORTModel.from_pretrained()</a> method.',Xp,de,js,Np,Wa,Wd="The <code>ORTModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method.",Sp,en,zp,tn,Bp,nn,Gl,Js,Vl,ks,Xl,De,xs,qp,sn,Us,Op,Ca,Cd="Call self as a function.",Nl,Rs,Sl,Ke,Zs,Ep,on,Ws,Hp,Fa,Fd="Call self as a function.",zl,Cs,Bl,et,Fs,Lp,an,Is,Qp,Ia,Id="Call self as a function.",ql,Gs,Ol,tt,Vs,Yp,ln,Xs,Pp,Ga,Gd="Call self as a function.",El,Ns,Hl,nt,Ss,Ap,rn,zs,Dp,Va,Vd="Call self as a function.",Ll,Bs,Ql,st,qs,Kp,pn,Os,em,Xa,Xd="Call self as a function.",Yl,Es,Pl,ot,Hs,tm,mn,Ls,nm,Na,Nd="Call self as a function.",Al,Qs,Dl,Sa,Kl;return y=new x({props:{title:"Models",local:"models",headingTag:"h1"}}),$=new x({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),cn=new x({props:{title:"ORTModel",local:"optimum.onnxruntime.ORTModel",headingTag:"h3"}}),un=new J({props:{name:"class optimum.onnxruntime.ORTModel",anchor:"optimum.onnxruntime.ORTModel",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> config (<code>PretrainedConfig</code> &#x2014; The configuration of the model. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> session (<code>~onnxruntime.InferenceSession</code>) &#x2014; The ONNX Runtime InferenceSession that is running the model. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> use_io_binding (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014; Whether to use I/O bindings with **ONNX Runtime &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.with",description:"<strong>with</strong> the CUDAExecutionProvider**, this can significantly speedup inference depending on the task. &#x2014;",name:"with"},{anchor:"optimum.onnxruntime.ORTModel.-",description:"<strong>-</strong> model_save_dir (<code>Path</code>) &#x2014; The directory where the model exported to ONNX is saved. &#x2014;",name:"-"},{anchor:"optimum.onnxruntime.ORTModel.By",description:"<strong>By</strong> defaults, if the loaded model is local, the directory where the original model will be used. Otherwise, the &#x2014;",name:"By"},{anchor:"optimum.onnxruntime.ORTModel.cache",description:"<strong>cache</strong> directory is used. &#x2014;",name:"cache"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L126"}}),gn=new J({props:{name:"can_generate",anchor:"optimum.onnxruntime.ORTModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L571"}}),hn=new J({props:{name:"from_pretrained",anchor:"optimum.onnxruntime.ORTModel.from_pretrained",parameters:[{name:"model_id",val:": typing.Union[str, pathlib.Path]"},{name:"config",val:": typing.Optional[ForwardRef('PretrainedConfig')] = None"},{name:"export",val:": bool = False"},{name:"subfolder",val:": str = ''"},{name:"revision",val:": str = 'main'"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"trust_remote_code",val:": bool = False"},{name:"cache_dir",val:": str = '/root/.cache/huggingface/hub'"},{name:"token",val:": typing.Union[str, bool, NoneType] = None"},{name:"provider",val:": str = 'CPUExecutionProvider'"},{name:"providers",val:": typing.Optional[typing.Sequence[str]] = None"},{name:"provider_options",val:": typing.Union[typing.Sequence[typing.Dict[str, typing.Any]], typing.Dict[str, typing.Any], NoneType] = None"},{name:"session_options",val:": typing.Optional[onnxruntime.capi.onnxruntime_pybind11_state.SessionOptions] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.model_id",description:`<strong>model_id</strong> (<code>Union[str, Path]</code>) &#x2014;
Can be either:</p>
<ul>
<li>A string, the <em>model id</em> of a pretrained model hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li>
<li>A path to a <em>directory</em> containing a model saved using <code>~OptimizedModel.save_pretrained</code>,
e.g., <code>./my_model_directory/</code>.</li>
</ul>`,name:"model_id"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.export",description:`<strong>export</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Defines whether the provided <code>model_id</code> needs to be exported to the targeted format.`,name:"export"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.force_download",description:`<strong>force_download</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to force the (re-)download of the model weights and configuration files, overriding the
cached versions if they exist.`,name:"force_download"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_auth_token",description:`<strong>use_auth_token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
Deprecated. Please use the <code>token</code> argument instead.`,name:"use_auth_token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.token",description:`<strong>token</strong> (<code>Optional[Union[bool,str]]</code>, defaults to <code>None</code>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>huggingface_hub.constants.HF_TOKEN_PATH</code>).`,name:"token"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.cache_dir",description:`<strong>cache_dir</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
Path to a directory in which a downloaded pretrained model configuration should be cached if the
standard cache should not be used.`,name:"cache_dir"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo either locally or on huggingface.co, you can
specify the folder name here.`,name:"subfolder"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.config",description:`<strong>config</strong> (<code>Optional[transformers.PretrainedConfig]</code>, defaults to <code>None</code>) &#x2014;
The model configuration.`,name:"config"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.local_files_only",description:`<strong>local_files_only</strong> (<code>Optional[bool]</code>, defaults to <code>False</code>) &#x2014;
Whether or not to only look at local files (i.e., do not try to download the model).`,name:"local_files_only"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.trust_remote_code",description:`<strong>trust_remote_code</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether or not to allow for custom code defined on the Hub in their own modeling. This option should only be set
to <code>True</code> for repositories you trust and in which you have read the code, as it will execute code present on
the Hub on your local machine.`,name:"trust_remote_code"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.revision",description:`<strong>revision</strong> (<code>Optional[str]</code>, defaults to <code>None</code>) &#x2014;
The specific model version to use. It can be a branch name, a tag name, or a commit id, since we use a
git-based system for storing models and other artifacts on huggingface.co, so <code>revision</code> can be any
identifier allowed by git.`,name:"revision"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider",description:`<strong>provider</strong> (<code>str</code>, defaults to <code>&quot;CPUExecutionProvider&quot;</code>) &#x2014;
ONNX Runtime provider to use for loading the model.
See <a href="https://onnxruntime.ai/docs/execution-providers/" rel="nofollow">https://onnxruntime.ai/docs/execution-providers/</a> for possible providers.`,name:"provider"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.providers",description:`<strong>providers</strong> (<code>Optional[Sequence[str]]</code>, defaults to <code>None</code>) &#x2014;
List of execution providers to use for loading the model.
This argument takes precedence over the <code>provider</code> argument.`,name:"providers"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.provider_options",description:`<strong>provider_options</strong> (<code>Optional[Dict[str, Any]]</code>, defaults to <code>None</code>) &#x2014;
Provider option dictionaries corresponding to the provider used. See available options
for each provider: <a href="https://onnxruntime.ai/docs/api/c/group___global.html" rel="nofollow">https://onnxruntime.ai/docs/api/c/group___global.html</a> .`,name:"provider_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.session_options",description:`<strong>session_options</strong> (<code>Optional[onnxruntime.SessionOptions]</code>, defaults to <code>None</code>), &#x2014;
ONNX Runtime session options to use for loading the model.`,name:"session_options"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_io_binding",description:`<strong>use_io_binding</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
Whether to use IOBinding during inference to avoid memory copy between the host and device, or between numpy/torch tensors and ONNX Runtime ORTValue. Defaults to
<code>True</code> if the execution provider is CUDAExecutionProvider. For [~onnxruntime.ORTModelForCausalLM], defaults to <code>True</code> on CPUExecutionProvider,
in all other cases defaults to <code>False</code>.`,name:"use_io_binding"},{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Will be passed to the underlying model loading methods.`,name:"kwargs"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L441",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The loaded ORTModel model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>ORTModel</code></p>
`,parameterGroups:[{title:"Parameters for decoder models (ORTModelForCausalLM, ORTModelForSeq2SeqLM, ORTModelForSeq2SeqLM, ORTModelForSpeechSeq2Seq, ORTModelForVision2Seq)",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_cache",description:`<strong>use_cache</strong> (<code>Optional[bool]</code>, defaults to <code>True</code>) &#x2014;
Whether or not past key/values cache should be used. Defaults to <code>True</code>.`,name:"use_cache"}]},{title:"Parameters for ORTModelForCausalLM",parametersDescription:[{anchor:"optimum.onnxruntime.ORTModel.from_pretrained.use_merged",description:`<strong>use_merged</strong> (<code>Optional[bool]</code>, defaults to <code>None</code>) &#x2014;
whether or not to use a single ONNX that handles both the decoding without and with past key values reuse. This option defaults
to <code>True</code> if loading from a local repository and a merged decoder is found. When exporting with <code>export=True</code>,
defaults to <code>False</code>. This option should be set to <code>True</code> to minimize memory usage.`,name:"use_merged"}]}]}}),fn=new x({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),Mn=new x({props:{title:"ORTModelForCausalLM",local:"optimum.onnxruntime.ORTModelForCausalLM",headingTag:"h3"}}),yn=new J({props:{name:"class optimum.onnxruntime.ORTModelForCausalLM",anchor:"optimum.onnxruntime.ORTModelForCausalLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_decoder.py#L122"}}),Tn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_decoder.py#L257"}}),rt=new W({props:{$$slots:{default:[Hd]},$$scope:{ctx:w}}}),it=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example",$$slots:{default:[Ld]},$$scope:{ctx:w}}}),pt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCausalLM.forward.example-2",$$slots:{default:[Qd]},$$scope:{ctx:w}}}),_n=new x({props:{title:"ORTModelForMaskedLM",local:"optimum.onnxruntime.ORTModelForMaskedLM",headingTag:"h3"}}),$n=new J({props:{name:"class optimum.onnxruntime.ORTModelForMaskedLM",anchor:"optimum.onnxruntime.ORTModelForMaskedLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L752"}}),wn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L761"}}),mt=new W({props:{$$slots:{default:[Yd]},$$scope:{ctx:w}}}),dt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example",$$slots:{default:[Pd]},$$scope:{ctx:w}}}),ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMaskedLM.forward.example-2",$$slots:{default:[Ad]},$$scope:{ctx:w}}}),vn=new x({props:{title:"ORTModelForSeq2SeqLM",local:"optimum.onnxruntime.ORTModelForSeq2SeqLM",headingTag:"h3"}}),jn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSeq2SeqLM",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1297"}}),Jn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of input sequence tokens in the vocabulary of shape <code>(batch_size, encoder_sequence_length)</code>.`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>) &#x2014;
Mask to avoid performing attention on padding token indices, of shape
<code>(batch_size, encoder_sequence_length)</code>. Mask values selected in <code>[0, 1]</code>.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1306"}}),ut=new W({props:{$$slots:{default:[Dd]},$$scope:{ctx:w}}}),gt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example",$$slots:{default:[Kd]},$$scope:{ctx:w}}}),ht=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSeq2SeqLM.forward.example-2",$$slots:{default:[ec]},$$scope:{ctx:w}}}),kn=new x({props:{title:"ORTModelForSequenceClassification",local:"optimum.onnxruntime.ORTModelForSequenceClassification",headingTag:"h3"}}),xn=new J({props:{name:"class optimum.onnxruntime.ORTModelForSequenceClassification",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L974"}}),Un=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L984"}}),ft=new W({props:{$$slots:{default:[tc]},$$scope:{ctx:w}}}),bt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example",$$slots:{default:[nc]},$$scope:{ctx:w}}}),Mt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-2",$$slots:{default:[sc]},$$scope:{ctx:w}}}),yt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSequenceClassification.forward.example-3",$$slots:{default:[oc]},$$scope:{ctx:w}}}),Rn=new x({props:{title:"ORTModelForTokenClassification",local:"optimum.onnxruntime.ORTModelForTokenClassification",headingTag:"h3"}}),Zn=new J({props:{name:"class optimum.onnxruntime.ORTModelForTokenClassification",anchor:"optimum.onnxruntime.ORTModelForTokenClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1077"}}),Wn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1088"}}),Tt=new W({props:{$$slots:{default:[ac]},$$scope:{ctx:w}}}),_t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example",$$slots:{default:[lc]},$$scope:{ctx:w}}}),$t=new U({props:{anchor:"optimum.onnxruntime.ORTModelForTokenClassification.forward.example-2",$$slots:{default:[rc]},$$scope:{ctx:w}}}),Cn=new x({props:{title:"ORTModelForMultipleChoice",local:"optimum.onnxruntime.ORTModelForMultipleChoice",headingTag:"h3"}}),Fn=new J({props:{name:"class optimum.onnxruntime.ORTModelForMultipleChoice",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1175"}}),In=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1185"}}),wt=new W({props:{$$slots:{default:[ic]},$$scope:{ctx:w}}}),vt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForMultipleChoice.forward.example",$$slots:{default:[pc]},$$scope:{ctx:w}}}),Gn=new x({props:{title:"ORTModelForQuestionAnswering",local:"optimum.onnxruntime.ORTModelForQuestionAnswering",headingTag:"h3"}}),Vn=new J({props:{name:"class optimum.onnxruntime.ORTModelForQuestionAnswering",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L855"}}),Xn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L864"}}),jt=new W({props:{$$slots:{default:[mc]},$$scope:{ctx:w}}}),Jt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example",$$slots:{default:[dc]},$$scope:{ctx:w}}}),kt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForQuestionAnswering.forward.example-2",$$slots:{default:[cc]},$$scope:{ctx:w}}}),Nn=new x({props:{title:"Computer vision",local:"computer-vision",headingTag:"h2"}}),zn=new x({props:{title:"ORTModelForImageClassification",local:"optimum.onnxruntime.ORTModelForImageClassification",headingTag:"h3"}}),Bn=new J({props:{name:"class optimum.onnxruntime.ORTModelForImageClassification",anchor:"optimum.onnxruntime.ORTModelForImageClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1282"}}),qn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1290"}}),xt=new W({props:{$$slots:{default:[uc]},$$scope:{ctx:w}}}),Ut=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example",$$slots:{default:[gc]},$$scope:{ctx:w}}}),Rt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForImageClassification.forward.example-2",$$slots:{default:[hc]},$$scope:{ctx:w}}}),On=new x({props:{title:"ORTModelForSemanticSegmentation",local:"optimum.onnxruntime.ORTModelForSemanticSegmentation",headingTag:"h3"}}),En=new J({props:{name:"class optimum.onnxruntime.ORTModelForSemanticSegmentation",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1380"}}),Hn=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray]"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1389"}}),Zt=new W({props:{$$slots:{default:[fc]},$$scope:{ctx:w}}}),Wt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example",$$slots:{default:[bc]},$$scope:{ctx:w}}}),Ct=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSemanticSegmentation.forward.example-2",$$slots:{default:[Mc]},$$scope:{ctx:w}}}),Ln=new x({props:{title:"Audio",local:"audio",headingTag:"h2"}}),Yn=new x({props:{title:"ORTModelForAudioClassification",local:"optimum.onnxruntime.ORTModelForAudioClassification",headingTag:"h3"}}),Pn=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioClassification",anchor:"optimum.onnxruntime.ORTModelForAudioClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1483"}}),An=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1493"}}),Ft=new W({props:{$$slots:{default:[yc]},$$scope:{ctx:w}}}),It=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example",$$slots:{default:[Tc]},$$scope:{ctx:w}}}),Gt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioClassification.forward.example-2",$$slots:{default:[_c]},$$scope:{ctx:w}}}),Dn=new x({props:{title:"ORTModelForAudioFrameClassification",local:"optimum.onnxruntime.ORTModelForAudioFrameClassification",headingTag:"h3"}}),Kn=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioFrameClassification",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1778"}}),es=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1787"}}),Vt=new W({props:{$$slots:{default:[$c]},$$scope:{ctx:w}}}),Xt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioFrameClassification.forward.example",$$slots:{default:[wc]},$$scope:{ctx:w}}}),ts=new x({props:{title:"ORTModelForCTC",local:"optimum.onnxruntime.ORTModelForCTC",headingTag:"h3"}}),ns=new J({props:{name:"class optimum.onnxruntime.ORTModelForCTC",anchor:"optimum.onnxruntime.ORTModelForCTC",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1583"}}),ss=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCTC.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1592"}}),Nt=new W({props:{$$slots:{default:[vc]},$$scope:{ctx:w}}}),St=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCTC.forward.example",$$slots:{default:[jc]},$$scope:{ctx:w}}}),os=new x({props:{title:"ORTModelForSpeechSeq2Seq",local:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",headingTag:"h3"}}),as=new J({props:{name:"class optimum.onnxruntime.ORTModelForSpeechSeq2Seq",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1394"}}),ls=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward",parameters:[{name:"input_features",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"cache_position",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.input_features",description:`<strong>input_features</strong> (<code>torch.FloatTensor</code>) &#x2014;
Mel features extracted from the raw speech waveform.
<code>(batch_size, feature_size, encoder_sequence_length)</code>.`,name:"input_features"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1417"}}),zt=new W({props:{$$slots:{default:[Jc]},$$scope:{ctx:w}}}),Bt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example",$$slots:{default:[kc]},$$scope:{ctx:w}}}),qt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForSpeechSeq2Seq.forward.example-2",$$slots:{default:[xc]},$$scope:{ctx:w}}}),rs=new x({props:{title:"ORTModelForAudioXVector",local:"optimum.onnxruntime.ORTModelForAudioXVector",headingTag:"h3"}}),is=new J({props:{name:"class optimum.onnxruntime.ORTModelForAudioXVector",anchor:"optimum.onnxruntime.ORTModelForAudioXVector",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1688"}}),ps=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward",parameters:[{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autofeatureextractor" rel="nofollow"><code>AutoFeatureExtractor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1697"}}),Ot=new W({props:{$$slots:{default:[Uc]},$$scope:{ctx:w}}}),Et=new U({props:{anchor:"optimum.onnxruntime.ORTModelForAudioXVector.forward.example",$$slots:{default:[Rc]},$$scope:{ctx:w}}}),ms=new x({props:{title:"Multimodal",local:"multimodal",headingTag:"h2"}}),cs=new x({props:{title:"ORTModelForVision2Seq",local:"optimum.onnxruntime.ORTModelForVision2Seq",headingTag:"h3"}}),us=new J({props:{name:"class optimum.onnxruntime.ORTModelForVision2Seq",anchor:"optimum.onnxruntime.ORTModelForVision2Seq",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1530"}}),gs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code>) &#x2014;
Features extracted from an Image. This tensor should be of shape
<code>(batch_size, num_channels, height, width)</code>.`,name:"pixel_values"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary of shape <code>(batch_size, decoder_sequence_length)</code>.`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
The encoder <code>last_hidden_state</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1541"}}),Ht=new W({props:{$$slots:{default:[Zc]},$$scope:{ctx:w}}}),Lt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example",$$slots:{default:[Wc]},$$scope:{ctx:w}}}),Qt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForVision2Seq.forward.example-2",$$slots:{default:[Cc]},$$scope:{ctx:w}}}),hs=new x({props:{title:"ORTModelForPix2Struct",local:"optimum.onnxruntime.ORTModelForPix2Struct",headingTag:"h3"}}),fs=new J({props:{name:"class optimum.onnxruntime.ORTModelForPix2Struct",anchor:"optimum.onnxruntime.ORTModelForPix2Struct",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"encoder_session",val:": InferenceSession = None"},{name:"decoder_session",val:": InferenceSession = None"},{name:"decoder_with_past_session",val:": typing.Optional[ForwardRef('InferenceSession')] = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"generation_config",val:": typing.Optional[ForwardRef('GenerationConfig')] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1626"}}),bs=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward",parameters:[{name:"flattened_patches",val:": typing.Optional[torch.FloatTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.Tensor]]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.flattened_patches",description:`<strong>flattened_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, seq_length, hidden_size)</code>) &#x2014;
Flattened pixel patches. the <code>hidden_size</code> is obtained by the following formula: <code>hidden_size</code> =
<code>num_channels</code> <em> <code>patch_size</code> </em> <code>patch_size</code>
The process of flattening the pixel patches is done by <code>Pix2StructProcessor</code>.`,name:"flattened_patches"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices.`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary.
Pix2StructText uses the <code>pad_token_id</code> as the starting token for <code>decoder_input_ids</code> generation. If
<code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).`,name:"decoder_input_ids"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.BoolTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <code>optional</code>: <em>hidden_states</em>, <code>optional</code>: <em>attentions</em>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code> is a sequence of hidden states at
the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor), *optional*, defaults to </code>None<code>)</code> &#x2014;
Contains the precomputed key and value hidden states of the attention blocks used to speed up decoding.
The tuple is of length <code>config.n_layers</code> with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, decoder_sequence_length, embed_size_per_head)</code> and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.`,name:"past_key_values"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_seq2seq.py#L1638"}}),Yt=new W({props:{$$slots:{default:[Fc]},$$scope:{ctx:w}}}),Pt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForPix2Struct.forward.example",$$slots:{default:[Ic]},$$scope:{ctx:w}}}),Ms=new x({props:{title:"Custom Tasks",local:"custom-tasks",headingTag:"h2"}}),Ts=new x({props:{title:"ORTModelForCustomTasks",local:"optimum.onnxruntime.ORTModelForCustomTasks",headingTag:"h4"}}),_s=new J({props:{name:"class optimum.onnxruntime.ORTModelForCustomTasks",anchor:"optimum.onnxruntime.ORTModelForCustomTasks",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1963"}}),$s=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward",parameters:[{name:"**model_inputs",val:": typing.Union[torch.Tensor, numpy.ndarray]"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L1969"}}),At=new W({props:{$$slots:{default:[Gc]},$$scope:{ctx:w}}}),Dt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example",$$slots:{default:[Vc]},$$scope:{ctx:w}}}),Kt=new U({props:{anchor:"optimum.onnxruntime.ORTModelForCustomTasks.forward.example-2",$$slots:{default:[Xc]},$$scope:{ctx:w}}}),ws=new x({props:{title:"ORTModelForFeatureExtraction",local:"optimum.onnxruntime.ORTModelForFeatureExtraction",headingTag:"h4"}}),vs=new J({props:{name:"class optimum.onnxruntime.ORTModelForFeatureExtraction",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction",parameters:[{name:"*args",val:""},{name:"config",val:": PretrainedConfig = None"},{name:"session",val:": InferenceSession = None"},{name:"use_io_binding",val:": typing.Optional[bool] = None"},{name:"model_save_dir",val:": typing.Union[str, pathlib.Path, tempfile.TemporaryDirectory, NoneType] = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L626"}}),js=new J({props:{name:"forward",anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"attention_mask",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"token_type_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"position_ids",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"pixel_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_features",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"input_values",val:": typing.Union[torch.Tensor, numpy.ndarray, NoneType] = None"},{name:"return_dict",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>Union[torch.Tensor, np.ndarray, None]</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/onnxruntime/modeling_ort.py#L635"}}),en=new W({props:{$$slots:{default:[Nc]},$$scope:{ctx:w}}}),tn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example",$$slots:{default:[Sc]},$$scope:{ctx:w}}}),nn=new U({props:{anchor:"optimum.onnxruntime.ORTModelForFeatureExtraction.forward.example-2",$$slots:{default:[zc]},$$scope:{ctx:w}}}),Js=new x({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),ks=new x({props:{title:"ORTDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",headingTag:"h4"}}),xs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L18"}}),Us=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Rs=new x({props:{title:"ORTStableDiffusionPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",headingTag:"h4"}}),Zs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L62"}}),Ws=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Cs=new x({props:{title:"ORTStableDiffusionImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",headingTag:"h4"}}),Fs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L73"}}),Is=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Gs=new x({props:{title:"ORTStableDiffusionInpaintPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",headingTag:"h4"}}),Vs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L84"}}),Xs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Ns=new x({props:{title:"ORTStableDiffusionXLPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",headingTag:"h4"}}),Ss=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L95"}}),zs=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Bs=new x({props:{title:"ORTStableDiffusionXLImg2ImgPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",headingTag:"h4"}}),qs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L106"}}),Os=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Es=new x({props:{title:"ORTLatentConsistencyModelPipeline",local:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",headingTag:"h4"}}),Hs=new J({props:{name:"class optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum/blob/v1.27.0/optimum/utils/dummy_diffusers_objects.py#L128"}}),Ls=new J({props:{name:"__call__",anchor:"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}]}}),Qs=new Ed({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/package_reference/modeling_ort.mdx"}}),{c(){n=m("meta"),T=l(),a=m("p"),s=l(),u(y.$$.fragment),t=l(),u($.$$.fragment),za=l(),dn=m("p"),dn.textContent=sm,Ba=l(),u(cn.$$.fragment),qa=l(),Z=m("div"),u(un.$$.fragment),sr=l(),io=m("p"),io.textContent=om,or=l(),po=m("p"),po.innerHTML=am,ar=l(),mo=m("p"),mo.textContent=lm,lr=l(),co=m("ul"),co.innerHTML=rm,rr=l(),at=m("div"),u(gn.$$.fragment),ir=l(),uo=m("p"),uo.innerHTML=im,pr=l(),lt=m("div"),u(hn.$$.fragment),mr=l(),go=m("p"),go.textContent=pm,Oa=l(),u(fn.$$.fragment),Ea=l(),bn=m("p"),bn.textContent=mm,Ha=l(),u(Mn.$$.fragment),La=l(),I=m("div"),u(yn.$$.fragment),dr=l(),ho=m("p"),ho.textContent=dm,cr=l(),fo=m("p"),fo.innerHTML=cm,ur=l(),bo=m("p"),bo.innerHTML=um,gr=l(),ee=m("div"),u(Tn.$$.fragment),hr=l(),Mo=m("p"),Mo.innerHTML=gm,fr=l(),u(rt.$$.fragment),br=l(),u(it.$$.fragment),Mr=l(),u(pt.$$.fragment),Qa=l(),u(_n.$$.fragment),Ya=l(),G=m("div"),u($n.$$.fragment),yr=l(),yo=m("p"),yo.textContent=hm,Tr=l(),To=m("p"),To.innerHTML=fm,_r=l(),_o=m("p"),_o.innerHTML=bm,$r=l(),te=m("div"),u(wn.$$.fragment),wr=l(),$o=m("p"),$o.innerHTML=Mm,vr=l(),u(mt.$$.fragment),jr=l(),u(dt.$$.fragment),Jr=l(),u(ct.$$.fragment),Pa=l(),u(vn.$$.fragment),Aa=l(),V=m("div"),u(jn.$$.fragment),kr=l(),wo=m("p"),wo.textContent=ym,xr=l(),vo=m("p"),vo.innerHTML=Tm,Ur=l(),jo=m("p"),jo.innerHTML=_m,Rr=l(),ne=m("div"),u(Jn.$$.fragment),Zr=l(),Jo=m("p"),Jo.innerHTML=$m,Wr=l(),u(ut.$$.fragment),Cr=l(),u(gt.$$.fragment),Fr=l(),u(ht.$$.fragment),Da=l(),u(kn.$$.fragment),Ka=l(),X=m("div"),u(xn.$$.fragment),Ir=l(),ko=m("p"),ko.textContent=wm,Gr=l(),xo=m("p"),xo.innerHTML=vm,Vr=l(),Uo=m("p"),Uo.innerHTML=jm,Xr=l(),F=m("div"),u(Un.$$.fragment),Nr=l(),Ro=m("p"),Ro.innerHTML=Jm,Sr=l(),u(ft.$$.fragment),zr=l(),u(bt.$$.fragment),Br=l(),u(Mt.$$.fragment),qr=l(),u(yt.$$.fragment),el=l(),u(Rn.$$.fragment),tl=l(),N=m("div"),u(Zn.$$.fragment),Or=l(),Zo=m("p"),Zo.textContent=km,Er=l(),Wo=m("p"),Wo.innerHTML=xm,Hr=l(),Co=m("p"),Co.innerHTML=Um,Lr=l(),se=m("div"),u(Wn.$$.fragment),Qr=l(),Fo=m("p"),Fo.innerHTML=Rm,Yr=l(),u(Tt.$$.fragment),Pr=l(),u(_t.$$.fragment),Ar=l(),u($t.$$.fragment),nl=l(),u(Cn.$$.fragment),sl=l(),S=m("div"),u(Fn.$$.fragment),Dr=l(),Io=m("p"),Io.textContent=Zm,Kr=l(),Go=m("p"),Go.innerHTML=Wm,ei=l(),Vo=m("p"),Vo.innerHTML=Cm,ti=l(),Be=m("div"),u(In.$$.fragment),ni=l(),Xo=m("p"),Xo.innerHTML=Fm,si=l(),u(wt.$$.fragment),oi=l(),u(vt.$$.fragment),ol=l(),u(Gn.$$.fragment),al=l(),z=m("div"),u(Vn.$$.fragment),ai=l(),No=m("p"),No.textContent=Im,li=l(),So=m("p"),So.innerHTML=Gm,ri=l(),zo=m("p"),zo.innerHTML=Vm,ii=l(),oe=m("div"),u(Xn.$$.fragment),pi=l(),Bo=m("p"),Bo.innerHTML=Xm,mi=l(),u(jt.$$.fragment),di=l(),u(Jt.$$.fragment),ci=l(),u(kt.$$.fragment),ll=l(),u(Nn.$$.fragment),rl=l(),Sn=m("p"),Sn.textContent=Nm,il=l(),u(zn.$$.fragment),pl=l(),B=m("div"),u(Bn.$$.fragment),ui=l(),qo=m("p"),qo.textContent=Sm,gi=l(),Oo=m("p"),Oo.innerHTML=zm,hi=l(),Eo=m("p"),Eo.innerHTML=Bm,fi=l(),ae=m("div"),u(qn.$$.fragment),bi=l(),Ho=m("p"),Ho.innerHTML=qm,Mi=l(),u(xt.$$.fragment),yi=l(),u(Ut.$$.fragment),Ti=l(),u(Rt.$$.fragment),ml=l(),u(On.$$.fragment),dl=l(),q=m("div"),u(En.$$.fragment),_i=l(),Lo=m("p"),Lo.textContent=Om,$i=l(),Qo=m("p"),Qo.innerHTML=Em,wi=l(),Yo=m("p"),Yo.innerHTML=Hm,vi=l(),le=m("div"),u(Hn.$$.fragment),ji=l(),Po=m("p"),Po.innerHTML=Lm,Ji=l(),u(Zt.$$.fragment),ki=l(),u(Wt.$$.fragment),xi=l(),u(Ct.$$.fragment),cl=l(),u(Ln.$$.fragment),ul=l(),Qn=m("p"),Qn.textContent=Qm,gl=l(),u(Yn.$$.fragment),hl=l(),O=m("div"),u(Pn.$$.fragment),Ui=l(),Ao=m("p"),Ao.textContent=Ym,Ri=l(),Do=m("p"),Do.innerHTML=Pm,Zi=l(),Ko=m("p"),Ko.innerHTML=Am,Wi=l(),re=m("div"),u(An.$$.fragment),Ci=l(),ea=m("p"),ea.innerHTML=Dm,Fi=l(),u(Ft.$$.fragment),Ii=l(),u(It.$$.fragment),Gi=l(),u(Gt.$$.fragment),fl=l(),u(Dn.$$.fragment),bl=l(),E=m("div"),u(Kn.$$.fragment),Vi=l(),ta=m("p"),ta.textContent=Km,Xi=l(),na=m("p"),na.innerHTML=ed,Ni=l(),sa=m("p"),sa.innerHTML=td,Si=l(),qe=m("div"),u(es.$$.fragment),zi=l(),oa=m("p"),oa.innerHTML=nd,Bi=l(),u(Vt.$$.fragment),qi=l(),u(Xt.$$.fragment),Ml=l(),u(ts.$$.fragment),yl=l(),H=m("div"),u(ns.$$.fragment),Oi=l(),aa=m("p"),aa.textContent=sd,Ei=l(),la=m("p"),la.innerHTML=od,Hi=l(),ra=m("p"),ra.innerHTML=ad,Li=l(),Oe=m("div"),u(ss.$$.fragment),Qi=l(),ia=m("p"),ia.innerHTML=ld,Yi=l(),u(Nt.$$.fragment),Pi=l(),u(St.$$.fragment),Tl=l(),u(os.$$.fragment),_l=l(),L=m("div"),u(as.$$.fragment),Ai=l(),pa=m("p"),pa.textContent=rd,Di=l(),ma=m("p"),ma.innerHTML=id,Ki=l(),da=m("p"),da.innerHTML=pd,ep=l(),ie=m("div"),u(ls.$$.fragment),tp=l(),ca=m("p"),ca.innerHTML=md,np=l(),u(zt.$$.fragment),sp=l(),u(Bt.$$.fragment),op=l(),u(qt.$$.fragment),$l=l(),u(rs.$$.fragment),wl=l(),Q=m("div"),u(is.$$.fragment),ap=l(),ua=m("p"),ua.textContent=dd,lp=l(),ga=m("p"),ga.innerHTML=cd,rp=l(),ha=m("p"),ha.innerHTML=ud,ip=l(),Ee=m("div"),u(ps.$$.fragment),pp=l(),fa=m("p"),fa.innerHTML=gd,mp=l(),u(Ot.$$.fragment),dp=l(),u(Et.$$.fragment),vl=l(),u(ms.$$.fragment),jl=l(),ds=m("p"),ds.textContent=hd,Jl=l(),u(cs.$$.fragment),kl=l(),Y=m("div"),u(us.$$.fragment),cp=l(),ba=m("p"),ba.textContent=fd,up=l(),Ma=m("p"),Ma.innerHTML=bd,gp=l(),ya=m("p"),ya.innerHTML=Md,hp=l(),pe=m("div"),u(gs.$$.fragment),fp=l(),Ta=m("p"),Ta.innerHTML=yd,bp=l(),u(Ht.$$.fragment),Mp=l(),u(Lt.$$.fragment),yp=l(),u(Qt.$$.fragment),xl=l(),u(hs.$$.fragment),Ul=l(),P=m("div"),u(fs.$$.fragment),Tp=l(),_a=m("p"),_a.textContent=Td,_p=l(),$a=m("p"),$a.innerHTML=_d,$p=l(),wa=m("p"),wa.innerHTML=$d,wp=l(),He=m("div"),u(bs.$$.fragment),vp=l(),va=m("p"),va.innerHTML=wd,jp=l(),u(Yt.$$.fragment),Jp=l(),u(Pt.$$.fragment),Rl=l(),u(Ms.$$.fragment),Zl=l(),ys=m("p"),ys.textContent=vd,Wl=l(),u(Ts.$$.fragment),Cl=l(),A=m("div"),u(_s.$$.fragment),kp=l(),ja=m("p"),ja.textContent=jd,xp=l(),Ja=m("p"),Ja.innerHTML=Jd,Up=l(),ka=m("p"),ka.innerHTML=kd,Rp=l(),me=m("div"),u($s.$$.fragment),Zp=l(),xa=m("p"),xa.innerHTML=xd,Wp=l(),u(At.$$.fragment),Cp=l(),u(Dt.$$.fragment),Fp=l(),u(Kt.$$.fragment),Fl=l(),u(ws.$$.fragment),Il=l(),D=m("div"),u(vs.$$.fragment),Ip=l(),Ua=m("p"),Ua.textContent=Ud,Gp=l(),Ra=m("p"),Ra.innerHTML=Rd,Vp=l(),Za=m("p"),Za.innerHTML=Zd,Xp=l(),de=m("div"),u(js.$$.fragment),Np=l(),Wa=m("p"),Wa.innerHTML=Wd,Sp=l(),u(en.$$.fragment),zp=l(),u(tn.$$.fragment),Bp=l(),u(nn.$$.fragment),Gl=l(),u(Js.$$.fragment),Vl=l(),u(ks.$$.fragment),Xl=l(),De=m("div"),u(xs.$$.fragment),qp=l(),sn=m("div"),u(Us.$$.fragment),Op=l(),Ca=m("p"),Ca.textContent=Cd,Nl=l(),u(Rs.$$.fragment),Sl=l(),Ke=m("div"),u(Zs.$$.fragment),Ep=l(),on=m("div"),u(Ws.$$.fragment),Hp=l(),Fa=m("p"),Fa.textContent=Fd,zl=l(),u(Cs.$$.fragment),Bl=l(),et=m("div"),u(Fs.$$.fragment),Lp=l(),an=m("div"),u(Is.$$.fragment),Qp=l(),Ia=m("p"),Ia.textContent=Id,ql=l(),u(Gs.$$.fragment),Ol=l(),tt=m("div"),u(Vs.$$.fragment),Yp=l(),ln=m("div"),u(Xs.$$.fragment),Pp=l(),Ga=m("p"),Ga.textContent=Gd,El=l(),u(Ns.$$.fragment),Hl=l(),nt=m("div"),u(Ss.$$.fragment),Ap=l(),rn=m("div"),u(zs.$$.fragment),Dp=l(),Va=m("p"),Va.textContent=Vd,Ll=l(),u(Bs.$$.fragment),Ql=l(),st=m("div"),u(qs.$$.fragment),Kp=l(),pn=m("div"),u(Os.$$.fragment),em=l(),Xa=m("p"),Xa.textContent=Xd,Yl=l(),u(Es.$$.fragment),Pl=l(),ot=m("div"),u(Hs.$$.fragment),tm=l(),mn=m("div"),u(Ls.$$.fragment),nm=l(),Na=m("p"),Na.textContent=Nd,Al=l(),u(Qs.$$.fragment),Dl=l(),Sa=m("p"),this.h()},l(e){const i=Od("svelte-u9bgzb",document.head);n=d(i,"META",{name:!0,content:!0}),i.forEach(p),T=r(e),a=d(e,"P",{}),v(a).forEach(p),s=r(e),g(y.$$.fragment,e),t=r(e),g($.$$.fragment,e),za=r(e),dn=d(e,"P",{"data-svelte-h":!0}),_(dn)!=="svelte-uyecg"&&(dn.textContent=sm),Ba=r(e),g(cn.$$.fragment,e),qa=r(e),Z=d(e,"DIV",{class:!0});var C=v(Z);g(un.$$.fragment,C),sr=r(C),io=d(C,"P",{"data-svelte-h":!0}),_(io)!=="svelte-12yueui"&&(io.textContent=om),or=r(C),po=d(C,"P",{"data-svelte-h":!0}),_(po)!=="svelte-zarm0s"&&(po.innerHTML=am),ar=r(C),mo=d(C,"P",{"data-svelte-h":!0}),_(mo)!=="svelte-wz8va1"&&(mo.textContent=lm),lr=r(C),co=d(C,"UL",{"data-svelte-h":!0}),_(co)!=="svelte-qpxha0"&&(co.innerHTML=rm),rr=r(C),at=d(C,"DIV",{class:!0});var Ys=v(at);g(gn.$$.fragment,Ys),ir=r(Ys),uo=d(Ys,"P",{"data-svelte-h":!0}),_(uo)!=="svelte-1r2xt0l"&&(uo.innerHTML=im),Ys.forEach(p),pr=r(C),lt=d(C,"DIV",{class:!0});var Ps=v(lt);g(hn.$$.fragment,Ps),mr=r(Ps),go=d(Ps,"P",{"data-svelte-h":!0}),_(go)!=="svelte-18vxhwp"&&(go.textContent=pm),Ps.forEach(p),C.forEach(p),Oa=r(e),g(fn.$$.fragment,e),Ea=r(e),bn=d(e,"P",{"data-svelte-h":!0}),_(bn)!=="svelte-1tlroh"&&(bn.textContent=mm),Ha=r(e),g(Mn.$$.fragment,e),La=r(e),I=d(e,"DIV",{class:!0});var ce=v(I);g(yn.$$.fragment,ce),dr=r(ce),ho=d(ce,"P",{"data-svelte-h":!0}),_(ho)!=="svelte-xjbh35"&&(ho.textContent=dm),cr=r(ce),fo=d(ce,"P",{"data-svelte-h":!0}),_(fo)!=="svelte-8d175e"&&(fo.innerHTML=cm),ur=r(ce),bo=d(ce,"P",{"data-svelte-h":!0}),_(bo)!=="svelte-20gaxb"&&(bo.innerHTML=um),gr=r(ce),ee=d(ce,"DIV",{class:!0});var ue=v(ee);g(Tn.$$.fragment,ue),hr=r(ue),Mo=d(ue,"P",{"data-svelte-h":!0}),_(Mo)!=="svelte-1ox9av6"&&(Mo.innerHTML=gm),fr=r(ue),g(rt.$$.fragment,ue),br=r(ue),g(it.$$.fragment,ue),Mr=r(ue),g(pt.$$.fragment,ue),ue.forEach(p),ce.forEach(p),Qa=r(e),g(_n.$$.fragment,e),Ya=r(e),G=d(e,"DIV",{class:!0});var ge=v(G);g($n.$$.fragment,ge),yr=r(ge),yo=d(ge,"P",{"data-svelte-h":!0}),_(yo)!=="svelte-cu5s5g"&&(yo.textContent=hm),Tr=r(ge),To=d(ge,"P",{"data-svelte-h":!0}),_(To)!=="svelte-8d175e"&&(To.innerHTML=fm),_r=r(ge),_o=d(ge,"P",{"data-svelte-h":!0}),_(_o)!=="svelte-20gaxb"&&(_o.innerHTML=bm),$r=r(ge),te=d(ge,"DIV",{class:!0});var he=v(te);g(wn.$$.fragment,he),wr=r(he),$o=d(he,"P",{"data-svelte-h":!0}),_($o)!=="svelte-1xqof9m"&&($o.innerHTML=Mm),vr=r(he),g(mt.$$.fragment,he),jr=r(he),g(dt.$$.fragment,he),Jr=r(he),g(ct.$$.fragment,he),he.forEach(p),ge.forEach(p),Pa=r(e),g(vn.$$.fragment,e),Aa=r(e),V=d(e,"DIV",{class:!0});var fe=v(V);g(jn.$$.fragment,fe),kr=r(fe),wo=d(fe,"P",{"data-svelte-h":!0}),_(wo)!=="svelte-voqu2o"&&(wo.textContent=ym),xr=r(fe),vo=d(fe,"P",{"data-svelte-h":!0}),_(vo)!=="svelte-z8qqoo"&&(vo.innerHTML=Tm),Ur=r(fe),jo=d(fe,"P",{"data-svelte-h":!0}),_(jo)!=="svelte-10uuk2l"&&(jo.innerHTML=_m),Rr=r(fe),ne=d(fe,"DIV",{class:!0});var be=v(ne);g(Jn.$$.fragment,be),Zr=r(be),Jo=d(be,"P",{"data-svelte-h":!0}),_(Jo)!=="svelte-n65k7h"&&(Jo.innerHTML=$m),Wr=r(be),g(ut.$$.fragment,be),Cr=r(be),g(gt.$$.fragment,be),Fr=r(be),g(ht.$$.fragment,be),be.forEach(p),fe.forEach(p),Da=r(e),g(kn.$$.fragment,e),Ka=r(e),X=d(e,"DIV",{class:!0});var Me=v(X);g(xn.$$.fragment,Me),Ir=r(Me),ko=d(Me,"P",{"data-svelte-h":!0}),_(ko)!=="svelte-1fcejq5"&&(ko.textContent=wm),Gr=r(Me),xo=d(Me,"P",{"data-svelte-h":!0}),_(xo)!=="svelte-8d175e"&&(xo.innerHTML=vm),Vr=r(Me),Uo=d(Me,"P",{"data-svelte-h":!0}),_(Uo)!=="svelte-20gaxb"&&(Uo.innerHTML=jm),Xr=r(Me),F=d(Me,"DIV",{class:!0});var K=v(F);g(Un.$$.fragment,K),Nr=r(K),Ro=d(K,"P",{"data-svelte-h":!0}),_(Ro)!=="svelte-1plx9t"&&(Ro.innerHTML=Jm),Sr=r(K),g(ft.$$.fragment,K),zr=r(K),g(bt.$$.fragment,K),Br=r(K),g(Mt.$$.fragment,K),qr=r(K),g(yt.$$.fragment,K),K.forEach(p),Me.forEach(p),el=r(e),g(Rn.$$.fragment,e),tl=r(e),N=d(e,"DIV",{class:!0});var ye=v(N);g(Zn.$$.fragment,ye),Or=r(ye),Zo=d(ye,"P",{"data-svelte-h":!0}),_(Zo)!=="svelte-1uwjkkt"&&(Zo.textContent=km),Er=r(ye),Wo=d(ye,"P",{"data-svelte-h":!0}),_(Wo)!=="svelte-8d175e"&&(Wo.innerHTML=xm),Hr=r(ye),Co=d(ye,"P",{"data-svelte-h":!0}),_(Co)!=="svelte-20gaxb"&&(Co.innerHTML=Um),Lr=r(ye),se=d(ye,"DIV",{class:!0});var Te=v(se);g(Wn.$$.fragment,Te),Qr=r(Te),Fo=d(Te,"P",{"data-svelte-h":!0}),_(Fo)!=="svelte-xk2xch"&&(Fo.innerHTML=Rm),Yr=r(Te),g(Tt.$$.fragment,Te),Pr=r(Te),g(_t.$$.fragment,Te),Ar=r(Te),g($t.$$.fragment,Te),Te.forEach(p),ye.forEach(p),nl=r(e),g(Cn.$$.fragment,e),sl=r(e),S=d(e,"DIV",{class:!0});var _e=v(S);g(Fn.$$.fragment,_e),Dr=r(_e),Io=d(_e,"P",{"data-svelte-h":!0}),_(Io)!=="svelte-dcahwi"&&(Io.textContent=Zm),Kr=r(_e),Go=d(_e,"P",{"data-svelte-h":!0}),_(Go)!=="svelte-8d175e"&&(Go.innerHTML=Wm),ei=r(_e),Vo=d(_e,"P",{"data-svelte-h":!0}),_(Vo)!=="svelte-20gaxb"&&(Vo.innerHTML=Cm),ti=r(_e),Be=d(_e,"DIV",{class:!0});var Le=v(Be);g(In.$$.fragment,Le),ni=r(Le),Xo=d(Le,"P",{"data-svelte-h":!0}),_(Xo)!=="svelte-qesv8n"&&(Xo.innerHTML=Fm),si=r(Le),g(wt.$$.fragment,Le),oi=r(Le),g(vt.$$.fragment,Le),Le.forEach(p),_e.forEach(p),ol=r(e),g(Gn.$$.fragment,e),al=r(e),z=d(e,"DIV",{class:!0});var $e=v(z);g(Vn.$$.fragment,$e),ai=r($e),No=d($e,"P",{"data-svelte-h":!0}),_(No)!=="svelte-70aqiz"&&(No.textContent=Im),li=r($e),So=d($e,"P",{"data-svelte-h":!0}),_(So)!=="svelte-8d175e"&&(So.innerHTML=Gm),ri=r($e),zo=d($e,"P",{"data-svelte-h":!0}),_(zo)!=="svelte-20gaxb"&&(zo.innerHTML=Vm),ii=r($e),oe=d($e,"DIV",{class:!0});var we=v(oe);g(Xn.$$.fragment,we),pi=r(we),Bo=d(we,"P",{"data-svelte-h":!0}),_(Bo)!=="svelte-1dng7rw"&&(Bo.innerHTML=Xm),mi=r(we),g(jt.$$.fragment,we),di=r(we),g(Jt.$$.fragment,we),ci=r(we),g(kt.$$.fragment,we),we.forEach(p),$e.forEach(p),ll=r(e),g(Nn.$$.fragment,e),rl=r(e),Sn=d(e,"P",{"data-svelte-h":!0}),_(Sn)!=="svelte-1h2y3wu"&&(Sn.textContent=Nm),il=r(e),g(zn.$$.fragment,e),pl=r(e),B=d(e,"DIV",{class:!0});var ve=v(B);g(Bn.$$.fragment,ve),ui=r(ve),qo=d(ve,"P",{"data-svelte-h":!0}),_(qo)!=="svelte-1726o2j"&&(qo.textContent=Sm),gi=r(ve),Oo=d(ve,"P",{"data-svelte-h":!0}),_(Oo)!=="svelte-8d175e"&&(Oo.innerHTML=zm),hi=r(ve),Eo=d(ve,"P",{"data-svelte-h":!0}),_(Eo)!=="svelte-20gaxb"&&(Eo.innerHTML=Bm),fi=r(ve),ae=d(ve,"DIV",{class:!0});var je=v(ae);g(qn.$$.fragment,je),bi=r(je),Ho=d(je,"P",{"data-svelte-h":!0}),_(Ho)!=="svelte-1azuqx"&&(Ho.innerHTML=qm),Mi=r(je),g(xt.$$.fragment,je),yi=r(je),g(Ut.$$.fragment,je),Ti=r(je),g(Rt.$$.fragment,je),je.forEach(p),ve.forEach(p),ml=r(e),g(On.$$.fragment,e),dl=r(e),q=d(e,"DIV",{class:!0});var Je=v(q);g(En.$$.fragment,Je),_i=r(Je),Lo=d(Je,"P",{"data-svelte-h":!0}),_(Lo)!=="svelte-wbsrrf"&&(Lo.textContent=Om),$i=r(Je),Qo=d(Je,"P",{"data-svelte-h":!0}),_(Qo)!=="svelte-8d175e"&&(Qo.innerHTML=Em),wi=r(Je),Yo=d(Je,"P",{"data-svelte-h":!0}),_(Yo)!=="svelte-20gaxb"&&(Yo.innerHTML=Hm),vi=r(Je),le=d(Je,"DIV",{class:!0});var ke=v(le);g(Hn.$$.fragment,ke),ji=r(ke),Po=d(ke,"P",{"data-svelte-h":!0}),_(Po)!=="svelte-1s27jle"&&(Po.innerHTML=Lm),Ji=r(ke),g(Zt.$$.fragment,ke),ki=r(ke),g(Wt.$$.fragment,ke),xi=r(ke),g(Ct.$$.fragment,ke),ke.forEach(p),Je.forEach(p),cl=r(e),g(Ln.$$.fragment,e),ul=r(e),Qn=d(e,"P",{"data-svelte-h":!0}),_(Qn)!=="svelte-liyjdz"&&(Qn.textContent=Qm),gl=r(e),g(Yn.$$.fragment,e),hl=r(e),O=d(e,"DIV",{class:!0});var xe=v(O);g(Pn.$$.fragment,xe),Ui=r(xe),Ao=d(xe,"P",{"data-svelte-h":!0}),_(Ao)!=="svelte-1uwrr47"&&(Ao.textContent=Ym),Ri=r(xe),Do=d(xe,"P",{"data-svelte-h":!0}),_(Do)!=="svelte-8d175e"&&(Do.innerHTML=Pm),Zi=r(xe),Ko=d(xe,"P",{"data-svelte-h":!0}),_(Ko)!=="svelte-20gaxb"&&(Ko.innerHTML=Am),Wi=r(xe),re=d(xe,"DIV",{class:!0});var Ue=v(re);g(An.$$.fragment,Ue),Ci=r(Ue),ea=d(Ue,"P",{"data-svelte-h":!0}),_(ea)!=="svelte-p67kxo"&&(ea.innerHTML=Dm),Fi=r(Ue),g(Ft.$$.fragment,Ue),Ii=r(Ue),g(It.$$.fragment,Ue),Gi=r(Ue),g(Gt.$$.fragment,Ue),Ue.forEach(p),xe.forEach(p),fl=r(e),g(Dn.$$.fragment,e),bl=r(e),E=d(e,"DIV",{class:!0});var Re=v(E);g(Kn.$$.fragment,Re),Vi=r(Re),ta=d(Re,"P",{"data-svelte-h":!0}),_(ta)!=="svelte-ujzpza"&&(ta.textContent=Km),Xi=r(Re),na=d(Re,"P",{"data-svelte-h":!0}),_(na)!=="svelte-8d175e"&&(na.innerHTML=ed),Ni=r(Re),sa=d(Re,"P",{"data-svelte-h":!0}),_(sa)!=="svelte-20gaxb"&&(sa.innerHTML=td),Si=r(Re),qe=d(Re,"DIV",{class:!0});var Qe=v(qe);g(es.$$.fragment,Qe),zi=r(Qe),oa=d(Qe,"P",{"data-svelte-h":!0}),_(oa)!=="svelte-18aced7"&&(oa.innerHTML=nd),Bi=r(Qe),g(Vt.$$.fragment,Qe),qi=r(Qe),g(Xt.$$.fragment,Qe),Qe.forEach(p),Re.forEach(p),Ml=r(e),g(ts.$$.fragment,e),yl=r(e),H=d(e,"DIV",{class:!0});var Ze=v(H);g(ns.$$.fragment,Ze),Oi=r(Ze),aa=d(Ze,"P",{"data-svelte-h":!0}),_(aa)!=="svelte-12uzrpk"&&(aa.textContent=sd),Ei=r(Ze),la=d(Ze,"P",{"data-svelte-h":!0}),_(la)!=="svelte-8d175e"&&(la.innerHTML=od),Hi=r(Ze),ra=d(Ze,"P",{"data-svelte-h":!0}),_(ra)!=="svelte-20gaxb"&&(ra.innerHTML=ad),Li=r(Ze),Oe=d(Ze,"DIV",{class:!0});var Ye=v(Oe);g(ss.$$.fragment,Ye),Qi=r(Ye),ia=d(Ye,"P",{"data-svelte-h":!0}),_(ia)!=="svelte-1szjv6u"&&(ia.innerHTML=ld),Yi=r(Ye),g(Nt.$$.fragment,Ye),Pi=r(Ye),g(St.$$.fragment,Ye),Ye.forEach(p),Ze.forEach(p),Tl=r(e),g(os.$$.fragment,e),_l=r(e),L=d(e,"DIV",{class:!0});var We=v(L);g(as.$$.fragment,We),Ai=r(We),pa=d(We,"P",{"data-svelte-h":!0}),_(pa)!=="svelte-135bhh9"&&(pa.textContent=rd),Di=r(We),ma=d(We,"P",{"data-svelte-h":!0}),_(ma)!=="svelte-z8qqoo"&&(ma.innerHTML=id),Ki=r(We),da=d(We,"P",{"data-svelte-h":!0}),_(da)!=="svelte-10uuk2l"&&(da.innerHTML=pd),ep=r(We),ie=d(We,"DIV",{class:!0});var Ce=v(ie);g(ls.$$.fragment,Ce),tp=r(Ce),ca=d(Ce,"P",{"data-svelte-h":!0}),_(ca)!=="svelte-1e3zkhy"&&(ca.innerHTML=md),np=r(Ce),g(zt.$$.fragment,Ce),sp=r(Ce),g(Bt.$$.fragment,Ce),op=r(Ce),g(qt.$$.fragment,Ce),Ce.forEach(p),We.forEach(p),$l=r(e),g(rs.$$.fragment,e),wl=r(e),Q=d(e,"DIV",{class:!0});var Fe=v(Q);g(is.$$.fragment,Fe),ap=r(Fe),ua=d(Fe,"P",{"data-svelte-h":!0}),_(ua)!=="svelte-1yhwrsm"&&(ua.textContent=dd),lp=r(Fe),ga=d(Fe,"P",{"data-svelte-h":!0}),_(ga)!=="svelte-8d175e"&&(ga.innerHTML=cd),rp=r(Fe),ha=d(Fe,"P",{"data-svelte-h":!0}),_(ha)!=="svelte-20gaxb"&&(ha.innerHTML=ud),ip=r(Fe),Ee=d(Fe,"DIV",{class:!0});var Pe=v(Ee);g(ps.$$.fragment,Pe),pp=r(Pe),fa=d(Pe,"P",{"data-svelte-h":!0}),_(fa)!=="svelte-1fuxgrl"&&(fa.innerHTML=gd),mp=r(Pe),g(Ot.$$.fragment,Pe),dp=r(Pe),g(Et.$$.fragment,Pe),Pe.forEach(p),Fe.forEach(p),vl=r(e),g(ms.$$.fragment,e),jl=r(e),ds=d(e,"P",{"data-svelte-h":!0}),_(ds)!=="svelte-1gk58z"&&(ds.textContent=hd),Jl=r(e),g(cs.$$.fragment,e),kl=r(e),Y=d(e,"DIV",{class:!0});var Ie=v(Y);g(us.$$.fragment,Ie),cp=r(Ie),ba=d(Ie,"P",{"data-svelte-h":!0}),_(ba)!=="svelte-1yhfevg"&&(ba.textContent=fd),up=r(Ie),Ma=d(Ie,"P",{"data-svelte-h":!0}),_(Ma)!=="svelte-z8qqoo"&&(Ma.innerHTML=bd),gp=r(Ie),ya=d(Ie,"P",{"data-svelte-h":!0}),_(ya)!=="svelte-10uuk2l"&&(ya.innerHTML=Md),hp=r(Ie),pe=d(Ie,"DIV",{class:!0});var Ge=v(pe);g(gs.$$.fragment,Ge),fp=r(Ge),Ta=d(Ge,"P",{"data-svelte-h":!0}),_(Ta)!=="svelte-11xalzp"&&(Ta.innerHTML=yd),bp=r(Ge),g(Ht.$$.fragment,Ge),Mp=r(Ge),g(Lt.$$.fragment,Ge),yp=r(Ge),g(Qt.$$.fragment,Ge),Ge.forEach(p),Ie.forEach(p),xl=r(e),g(hs.$$.fragment,e),Ul=r(e),P=d(e,"DIV",{class:!0});var Ve=v(P);g(fs.$$.fragment,Ve),Tp=r(Ve),_a=d(Ve,"P",{"data-svelte-h":!0}),_(_a)!=="svelte-80a148"&&(_a.textContent=Td),_p=r(Ve),$a=d(Ve,"P",{"data-svelte-h":!0}),_($a)!=="svelte-z8qqoo"&&($a.innerHTML=_d),$p=r(Ve),wa=d(Ve,"P",{"data-svelte-h":!0}),_(wa)!=="svelte-10uuk2l"&&(wa.innerHTML=$d),wp=r(Ve),He=d(Ve,"DIV",{class:!0});var Ae=v(He);g(bs.$$.fragment,Ae),vp=r(Ae),va=d(Ae,"P",{"data-svelte-h":!0}),_(va)!=="svelte-eywb10"&&(va.innerHTML=wd),jp=r(Ae),g(Yt.$$.fragment,Ae),Jp=r(Ae),g(Pt.$$.fragment,Ae),Ae.forEach(p),Ve.forEach(p),Rl=r(e),g(Ms.$$.fragment,e),Zl=r(e),ys=d(e,"P",{"data-svelte-h":!0}),_(ys)!=="svelte-1n8n3ms"&&(ys.textContent=vd),Wl=r(e),g(Ts.$$.fragment,e),Cl=r(e),A=d(e,"DIV",{class:!0});var Xe=v(A);g(_s.$$.fragment,Xe),kp=r(Xe),ja=d(Xe,"P",{"data-svelte-h":!0}),_(ja)!=="svelte-5pmyjn"&&(ja.textContent=jd),xp=r(Xe),Ja=d(Xe,"P",{"data-svelte-h":!0}),_(Ja)!=="svelte-8d175e"&&(Ja.innerHTML=Jd),Up=r(Xe),ka=d(Xe,"P",{"data-svelte-h":!0}),_(ka)!=="svelte-20gaxb"&&(ka.innerHTML=kd),Rp=r(Xe),me=d(Xe,"DIV",{class:!0});var Ne=v(me);g($s.$$.fragment,Ne),Zp=r(Ne),xa=d(Ne,"P",{"data-svelte-h":!0}),_(xa)!=="svelte-1usnw5b"&&(xa.innerHTML=xd),Wp=r(Ne),g(At.$$.fragment,Ne),Cp=r(Ne),g(Dt.$$.fragment,Ne),Fp=r(Ne),g(Kt.$$.fragment,Ne),Ne.forEach(p),Xe.forEach(p),Fl=r(e),g(ws.$$.fragment,e),Il=r(e),D=d(e,"DIV",{class:!0});var Se=v(D);g(vs.$$.fragment,Se),Ip=r(Se),Ua=d(Se,"P",{"data-svelte-h":!0}),_(Ua)!=="svelte-1rhquq6"&&(Ua.textContent=Ud),Gp=r(Se),Ra=d(Se,"P",{"data-svelte-h":!0}),_(Ra)!=="svelte-8d175e"&&(Ra.innerHTML=Rd),Vp=r(Se),Za=d(Se,"P",{"data-svelte-h":!0}),_(Za)!=="svelte-20gaxb"&&(Za.innerHTML=Zd),Xp=r(Se),de=d(Se,"DIV",{class:!0});var ze=v(de);g(js.$$.fragment,ze),Np=r(ze),Wa=d(ze,"P",{"data-svelte-h":!0}),_(Wa)!=="svelte-iqwqsz"&&(Wa.innerHTML=Wd),Sp=r(ze),g(en.$$.fragment,ze),zp=r(ze),g(tn.$$.fragment,ze),Bp=r(ze),g(nn.$$.fragment,ze),ze.forEach(p),Se.forEach(p),Gl=r(e),g(Js.$$.fragment,e),Vl=r(e),g(ks.$$.fragment,e),Xl=r(e),De=d(e,"DIV",{class:!0});var As=v(De);g(xs.$$.fragment,As),qp=r(As),sn=d(As,"DIV",{class:!0});var Ds=v(sn);g(Us.$$.fragment,Ds),Op=r(Ds),Ca=d(Ds,"P",{"data-svelte-h":!0}),_(Ca)!=="svelte-1eed40t"&&(Ca.textContent=Cd),Ds.forEach(p),As.forEach(p),Nl=r(e),g(Rs.$$.fragment,e),Sl=r(e),Ke=d(e,"DIV",{class:!0});var Ks=v(Ke);g(Zs.$$.fragment,Ks),Ep=r(Ks),on=d(Ks,"DIV",{class:!0});var eo=v(on);g(Ws.$$.fragment,eo),Hp=r(eo),Fa=d(eo,"P",{"data-svelte-h":!0}),_(Fa)!=="svelte-1eed40t"&&(Fa.textContent=Fd),eo.forEach(p),Ks.forEach(p),zl=r(e),g(Cs.$$.fragment,e),Bl=r(e),et=d(e,"DIV",{class:!0});var to=v(et);g(Fs.$$.fragment,to),Lp=r(to),an=d(to,"DIV",{class:!0});var no=v(an);g(Is.$$.fragment,no),Qp=r(no),Ia=d(no,"P",{"data-svelte-h":!0}),_(Ia)!=="svelte-1eed40t"&&(Ia.textContent=Id),no.forEach(p),to.forEach(p),ql=r(e),g(Gs.$$.fragment,e),Ol=r(e),tt=d(e,"DIV",{class:!0});var so=v(tt);g(Vs.$$.fragment,so),Yp=r(so),ln=d(so,"DIV",{class:!0});var oo=v(ln);g(Xs.$$.fragment,oo),Pp=r(oo),Ga=d(oo,"P",{"data-svelte-h":!0}),_(Ga)!=="svelte-1eed40t"&&(Ga.textContent=Gd),oo.forEach(p),so.forEach(p),El=r(e),g(Ns.$$.fragment,e),Hl=r(e),nt=d(e,"DIV",{class:!0});var ao=v(nt);g(Ss.$$.fragment,ao),Ap=r(ao),rn=d(ao,"DIV",{class:!0});var lo=v(rn);g(zs.$$.fragment,lo),Dp=r(lo),Va=d(lo,"P",{"data-svelte-h":!0}),_(Va)!=="svelte-1eed40t"&&(Va.textContent=Vd),lo.forEach(p),ao.forEach(p),Ll=r(e),g(Bs.$$.fragment,e),Ql=r(e),st=d(e,"DIV",{class:!0});var ro=v(st);g(qs.$$.fragment,ro),Kp=r(ro),pn=d(ro,"DIV",{class:!0});var er=v(pn);g(Os.$$.fragment,er),em=r(er),Xa=d(er,"P",{"data-svelte-h":!0}),_(Xa)!=="svelte-1eed40t"&&(Xa.textContent=Xd),er.forEach(p),ro.forEach(p),Yl=r(e),g(Es.$$.fragment,e),Pl=r(e),ot=d(e,"DIV",{class:!0});var tr=v(ot);g(Hs.$$.fragment,tr),tm=r(tr),mn=d(tr,"DIV",{class:!0});var nr=v(mn);g(Ls.$$.fragment,nr),nm=r(nr),Na=d(nr,"P",{"data-svelte-h":!0}),_(Na)!=="svelte-1eed40t"&&(Na.textContent=Nd),nr.forEach(p),tr.forEach(p),Al=r(e),g(Qs.$$.fragment,e),Dl=r(e),Sa=d(e,"P",{}),v(Sa).forEach(p),this.h()},h(){j(n,"name","hf:doc:metadata"),j(n,"content",qc),j(at,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(lt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(sn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(De,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(on,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(Ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(an,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(et,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ln,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(tt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(rn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(nt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(pn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(st,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(mn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),j(ot,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,i){o(document.head,n),c(e,T,i),c(e,a,i),c(e,s,i),h(y,e,i),c(e,t,i),h($,e,i),c(e,za,i),c(e,dn,i),c(e,Ba,i),h(cn,e,i),c(e,qa,i),c(e,Z,i),h(un,Z,null),o(Z,sr),o(Z,io),o(Z,or),o(Z,po),o(Z,ar),o(Z,mo),o(Z,lr),o(Z,co),o(Z,rr),o(Z,at),h(gn,at,null),o(at,ir),o(at,uo),o(Z,pr),o(Z,lt),h(hn,lt,null),o(lt,mr),o(lt,go),c(e,Oa,i),h(fn,e,i),c(e,Ea,i),c(e,bn,i),c(e,Ha,i),h(Mn,e,i),c(e,La,i),c(e,I,i),h(yn,I,null),o(I,dr),o(I,ho),o(I,cr),o(I,fo),o(I,ur),o(I,bo),o(I,gr),o(I,ee),h(Tn,ee,null),o(ee,hr),o(ee,Mo),o(ee,fr),h(rt,ee,null),o(ee,br),h(it,ee,null),o(ee,Mr),h(pt,ee,null),c(e,Qa,i),h(_n,e,i),c(e,Ya,i),c(e,G,i),h($n,G,null),o(G,yr),o(G,yo),o(G,Tr),o(G,To),o(G,_r),o(G,_o),o(G,$r),o(G,te),h(wn,te,null),o(te,wr),o(te,$o),o(te,vr),h(mt,te,null),o(te,jr),h(dt,te,null),o(te,Jr),h(ct,te,null),c(e,Pa,i),h(vn,e,i),c(e,Aa,i),c(e,V,i),h(jn,V,null),o(V,kr),o(V,wo),o(V,xr),o(V,vo),o(V,Ur),o(V,jo),o(V,Rr),o(V,ne),h(Jn,ne,null),o(ne,Zr),o(ne,Jo),o(ne,Wr),h(ut,ne,null),o(ne,Cr),h(gt,ne,null),o(ne,Fr),h(ht,ne,null),c(e,Da,i),h(kn,e,i),c(e,Ka,i),c(e,X,i),h(xn,X,null),o(X,Ir),o(X,ko),o(X,Gr),o(X,xo),o(X,Vr),o(X,Uo),o(X,Xr),o(X,F),h(Un,F,null),o(F,Nr),o(F,Ro),o(F,Sr),h(ft,F,null),o(F,zr),h(bt,F,null),o(F,Br),h(Mt,F,null),o(F,qr),h(yt,F,null),c(e,el,i),h(Rn,e,i),c(e,tl,i),c(e,N,i),h(Zn,N,null),o(N,Or),o(N,Zo),o(N,Er),o(N,Wo),o(N,Hr),o(N,Co),o(N,Lr),o(N,se),h(Wn,se,null),o(se,Qr),o(se,Fo),o(se,Yr),h(Tt,se,null),o(se,Pr),h(_t,se,null),o(se,Ar),h($t,se,null),c(e,nl,i),h(Cn,e,i),c(e,sl,i),c(e,S,i),h(Fn,S,null),o(S,Dr),o(S,Io),o(S,Kr),o(S,Go),o(S,ei),o(S,Vo),o(S,ti),o(S,Be),h(In,Be,null),o(Be,ni),o(Be,Xo),o(Be,si),h(wt,Be,null),o(Be,oi),h(vt,Be,null),c(e,ol,i),h(Gn,e,i),c(e,al,i),c(e,z,i),h(Vn,z,null),o(z,ai),o(z,No),o(z,li),o(z,So),o(z,ri),o(z,zo),o(z,ii),o(z,oe),h(Xn,oe,null),o(oe,pi),o(oe,Bo),o(oe,mi),h(jt,oe,null),o(oe,di),h(Jt,oe,null),o(oe,ci),h(kt,oe,null),c(e,ll,i),h(Nn,e,i),c(e,rl,i),c(e,Sn,i),c(e,il,i),h(zn,e,i),c(e,pl,i),c(e,B,i),h(Bn,B,null),o(B,ui),o(B,qo),o(B,gi),o(B,Oo),o(B,hi),o(B,Eo),o(B,fi),o(B,ae),h(qn,ae,null),o(ae,bi),o(ae,Ho),o(ae,Mi),h(xt,ae,null),o(ae,yi),h(Ut,ae,null),o(ae,Ti),h(Rt,ae,null),c(e,ml,i),h(On,e,i),c(e,dl,i),c(e,q,i),h(En,q,null),o(q,_i),o(q,Lo),o(q,$i),o(q,Qo),o(q,wi),o(q,Yo),o(q,vi),o(q,le),h(Hn,le,null),o(le,ji),o(le,Po),o(le,Ji),h(Zt,le,null),o(le,ki),h(Wt,le,null),o(le,xi),h(Ct,le,null),c(e,cl,i),h(Ln,e,i),c(e,ul,i),c(e,Qn,i),c(e,gl,i),h(Yn,e,i),c(e,hl,i),c(e,O,i),h(Pn,O,null),o(O,Ui),o(O,Ao),o(O,Ri),o(O,Do),o(O,Zi),o(O,Ko),o(O,Wi),o(O,re),h(An,re,null),o(re,Ci),o(re,ea),o(re,Fi),h(Ft,re,null),o(re,Ii),h(It,re,null),o(re,Gi),h(Gt,re,null),c(e,fl,i),h(Dn,e,i),c(e,bl,i),c(e,E,i),h(Kn,E,null),o(E,Vi),o(E,ta),o(E,Xi),o(E,na),o(E,Ni),o(E,sa),o(E,Si),o(E,qe),h(es,qe,null),o(qe,zi),o(qe,oa),o(qe,Bi),h(Vt,qe,null),o(qe,qi),h(Xt,qe,null),c(e,Ml,i),h(ts,e,i),c(e,yl,i),c(e,H,i),h(ns,H,null),o(H,Oi),o(H,aa),o(H,Ei),o(H,la),o(H,Hi),o(H,ra),o(H,Li),o(H,Oe),h(ss,Oe,null),o(Oe,Qi),o(Oe,ia),o(Oe,Yi),h(Nt,Oe,null),o(Oe,Pi),h(St,Oe,null),c(e,Tl,i),h(os,e,i),c(e,_l,i),c(e,L,i),h(as,L,null),o(L,Ai),o(L,pa),o(L,Di),o(L,ma),o(L,Ki),o(L,da),o(L,ep),o(L,ie),h(ls,ie,null),o(ie,tp),o(ie,ca),o(ie,np),h(zt,ie,null),o(ie,sp),h(Bt,ie,null),o(ie,op),h(qt,ie,null),c(e,$l,i),h(rs,e,i),c(e,wl,i),c(e,Q,i),h(is,Q,null),o(Q,ap),o(Q,ua),o(Q,lp),o(Q,ga),o(Q,rp),o(Q,ha),o(Q,ip),o(Q,Ee),h(ps,Ee,null),o(Ee,pp),o(Ee,fa),o(Ee,mp),h(Ot,Ee,null),o(Ee,dp),h(Et,Ee,null),c(e,vl,i),h(ms,e,i),c(e,jl,i),c(e,ds,i),c(e,Jl,i),h(cs,e,i),c(e,kl,i),c(e,Y,i),h(us,Y,null),o(Y,cp),o(Y,ba),o(Y,up),o(Y,Ma),o(Y,gp),o(Y,ya),o(Y,hp),o(Y,pe),h(gs,pe,null),o(pe,fp),o(pe,Ta),o(pe,bp),h(Ht,pe,null),o(pe,Mp),h(Lt,pe,null),o(pe,yp),h(Qt,pe,null),c(e,xl,i),h(hs,e,i),c(e,Ul,i),c(e,P,i),h(fs,P,null),o(P,Tp),o(P,_a),o(P,_p),o(P,$a),o(P,$p),o(P,wa),o(P,wp),o(P,He),h(bs,He,null),o(He,vp),o(He,va),o(He,jp),h(Yt,He,null),o(He,Jp),h(Pt,He,null),c(e,Rl,i),h(Ms,e,i),c(e,Zl,i),c(e,ys,i),c(e,Wl,i),h(Ts,e,i),c(e,Cl,i),c(e,A,i),h(_s,A,null),o(A,kp),o(A,ja),o(A,xp),o(A,Ja),o(A,Up),o(A,ka),o(A,Rp),o(A,me),h($s,me,null),o(me,Zp),o(me,xa),o(me,Wp),h(At,me,null),o(me,Cp),h(Dt,me,null),o(me,Fp),h(Kt,me,null),c(e,Fl,i),h(ws,e,i),c(e,Il,i),c(e,D,i),h(vs,D,null),o(D,Ip),o(D,Ua),o(D,Gp),o(D,Ra),o(D,Vp),o(D,Za),o(D,Xp),o(D,de),h(js,de,null),o(de,Np),o(de,Wa),o(de,Sp),h(en,de,null),o(de,zp),h(tn,de,null),o(de,Bp),h(nn,de,null),c(e,Gl,i),h(Js,e,i),c(e,Vl,i),h(ks,e,i),c(e,Xl,i),c(e,De,i),h(xs,De,null),o(De,qp),o(De,sn),h(Us,sn,null),o(sn,Op),o(sn,Ca),c(e,Nl,i),h(Rs,e,i),c(e,Sl,i),c(e,Ke,i),h(Zs,Ke,null),o(Ke,Ep),o(Ke,on),h(Ws,on,null),o(on,Hp),o(on,Fa),c(e,zl,i),h(Cs,e,i),c(e,Bl,i),c(e,et,i),h(Fs,et,null),o(et,Lp),o(et,an),h(Is,an,null),o(an,Qp),o(an,Ia),c(e,ql,i),h(Gs,e,i),c(e,Ol,i),c(e,tt,i),h(Vs,tt,null),o(tt,Yp),o(tt,ln),h(Xs,ln,null),o(ln,Pp),o(ln,Ga),c(e,El,i),h(Ns,e,i),c(e,Hl,i),c(e,nt,i),h(Ss,nt,null),o(nt,Ap),o(nt,rn),h(zs,rn,null),o(rn,Dp),o(rn,Va),c(e,Ll,i),h(Bs,e,i),c(e,Ql,i),c(e,st,i),h(qs,st,null),o(st,Kp),o(st,pn),h(Os,pn,null),o(pn,em),o(pn,Xa),c(e,Yl,i),h(Es,e,i),c(e,Pl,i),c(e,ot,i),h(Hs,ot,null),o(ot,tm),o(ot,mn),h(Ls,mn,null),o(mn,nm),o(mn,Na),c(e,Al,i),h(Qs,e,i),c(e,Dl,i),c(e,Sa,i),Kl=!0},p(e,[i]){const C={};i&2&&(C.$$scope={dirty:i,ctx:e}),rt.$set(C);const Ys={};i&2&&(Ys.$$scope={dirty:i,ctx:e}),it.$set(Ys);const Ps={};i&2&&(Ps.$$scope={dirty:i,ctx:e}),pt.$set(Ps);const ce={};i&2&&(ce.$$scope={dirty:i,ctx:e}),mt.$set(ce);const ue={};i&2&&(ue.$$scope={dirty:i,ctx:e}),dt.$set(ue);const ge={};i&2&&(ge.$$scope={dirty:i,ctx:e}),ct.$set(ge);const he={};i&2&&(he.$$scope={dirty:i,ctx:e}),ut.$set(he);const fe={};i&2&&(fe.$$scope={dirty:i,ctx:e}),gt.$set(fe);const be={};i&2&&(be.$$scope={dirty:i,ctx:e}),ht.$set(be);const Me={};i&2&&(Me.$$scope={dirty:i,ctx:e}),ft.$set(Me);const K={};i&2&&(K.$$scope={dirty:i,ctx:e}),bt.$set(K);const ye={};i&2&&(ye.$$scope={dirty:i,ctx:e}),Mt.$set(ye);const Te={};i&2&&(Te.$$scope={dirty:i,ctx:e}),yt.$set(Te);const _e={};i&2&&(_e.$$scope={dirty:i,ctx:e}),Tt.$set(_e);const Le={};i&2&&(Le.$$scope={dirty:i,ctx:e}),_t.$set(Le);const $e={};i&2&&($e.$$scope={dirty:i,ctx:e}),$t.$set($e);const we={};i&2&&(we.$$scope={dirty:i,ctx:e}),wt.$set(we);const ve={};i&2&&(ve.$$scope={dirty:i,ctx:e}),vt.$set(ve);const je={};i&2&&(je.$$scope={dirty:i,ctx:e}),jt.$set(je);const Je={};i&2&&(Je.$$scope={dirty:i,ctx:e}),Jt.$set(Je);const ke={};i&2&&(ke.$$scope={dirty:i,ctx:e}),kt.$set(ke);const xe={};i&2&&(xe.$$scope={dirty:i,ctx:e}),xt.$set(xe);const Ue={};i&2&&(Ue.$$scope={dirty:i,ctx:e}),Ut.$set(Ue);const Re={};i&2&&(Re.$$scope={dirty:i,ctx:e}),Rt.$set(Re);const Qe={};i&2&&(Qe.$$scope={dirty:i,ctx:e}),Zt.$set(Qe);const Ze={};i&2&&(Ze.$$scope={dirty:i,ctx:e}),Wt.$set(Ze);const Ye={};i&2&&(Ye.$$scope={dirty:i,ctx:e}),Ct.$set(Ye);const We={};i&2&&(We.$$scope={dirty:i,ctx:e}),Ft.$set(We);const Ce={};i&2&&(Ce.$$scope={dirty:i,ctx:e}),It.$set(Ce);const Fe={};i&2&&(Fe.$$scope={dirty:i,ctx:e}),Gt.$set(Fe);const Pe={};i&2&&(Pe.$$scope={dirty:i,ctx:e}),Vt.$set(Pe);const Ie={};i&2&&(Ie.$$scope={dirty:i,ctx:e}),Xt.$set(Ie);const Ge={};i&2&&(Ge.$$scope={dirty:i,ctx:e}),Nt.$set(Ge);const Ve={};i&2&&(Ve.$$scope={dirty:i,ctx:e}),St.$set(Ve);const Ae={};i&2&&(Ae.$$scope={dirty:i,ctx:e}),zt.$set(Ae);const Xe={};i&2&&(Xe.$$scope={dirty:i,ctx:e}),Bt.$set(Xe);const Ne={};i&2&&(Ne.$$scope={dirty:i,ctx:e}),qt.$set(Ne);const Se={};i&2&&(Se.$$scope={dirty:i,ctx:e}),Ot.$set(Se);const ze={};i&2&&(ze.$$scope={dirty:i,ctx:e}),Et.$set(ze);const As={};i&2&&(As.$$scope={dirty:i,ctx:e}),Ht.$set(As);const Ds={};i&2&&(Ds.$$scope={dirty:i,ctx:e}),Lt.$set(Ds);const Ks={};i&2&&(Ks.$$scope={dirty:i,ctx:e}),Qt.$set(Ks);const eo={};i&2&&(eo.$$scope={dirty:i,ctx:e}),Yt.$set(eo);const to={};i&2&&(to.$$scope={dirty:i,ctx:e}),Pt.$set(to);const no={};i&2&&(no.$$scope={dirty:i,ctx:e}),At.$set(no);const so={};i&2&&(so.$$scope={dirty:i,ctx:e}),Dt.$set(so);const oo={};i&2&&(oo.$$scope={dirty:i,ctx:e}),Kt.$set(oo);const ao={};i&2&&(ao.$$scope={dirty:i,ctx:e}),en.$set(ao);const lo={};i&2&&(lo.$$scope={dirty:i,ctx:e}),tn.$set(lo);const ro={};i&2&&(ro.$$scope={dirty:i,ctx:e}),nn.$set(ro)},i(e){Kl||(f(y.$$.fragment,e),f($.$$.fragment,e),f(cn.$$.fragment,e),f(un.$$.fragment,e),f(gn.$$.fragment,e),f(hn.$$.fragment,e),f(fn.$$.fragment,e),f(Mn.$$.fragment,e),f(yn.$$.fragment,e),f(Tn.$$.fragment,e),f(rt.$$.fragment,e),f(it.$$.fragment,e),f(pt.$$.fragment,e),f(_n.$$.fragment,e),f($n.$$.fragment,e),f(wn.$$.fragment,e),f(mt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(vn.$$.fragment,e),f(jn.$$.fragment,e),f(Jn.$$.fragment,e),f(ut.$$.fragment,e),f(gt.$$.fragment,e),f(ht.$$.fragment,e),f(kn.$$.fragment,e),f(xn.$$.fragment,e),f(Un.$$.fragment,e),f(ft.$$.fragment,e),f(bt.$$.fragment,e),f(Mt.$$.fragment,e),f(yt.$$.fragment,e),f(Rn.$$.fragment,e),f(Zn.$$.fragment,e),f(Wn.$$.fragment,e),f(Tt.$$.fragment,e),f(_t.$$.fragment,e),f($t.$$.fragment,e),f(Cn.$$.fragment,e),f(Fn.$$.fragment,e),f(In.$$.fragment,e),f(wt.$$.fragment,e),f(vt.$$.fragment,e),f(Gn.$$.fragment,e),f(Vn.$$.fragment,e),f(Xn.$$.fragment,e),f(jt.$$.fragment,e),f(Jt.$$.fragment,e),f(kt.$$.fragment,e),f(Nn.$$.fragment,e),f(zn.$$.fragment,e),f(Bn.$$.fragment,e),f(qn.$$.fragment,e),f(xt.$$.fragment,e),f(Ut.$$.fragment,e),f(Rt.$$.fragment,e),f(On.$$.fragment,e),f(En.$$.fragment,e),f(Hn.$$.fragment,e),f(Zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Ct.$$.fragment,e),f(Ln.$$.fragment,e),f(Yn.$$.fragment,e),f(Pn.$$.fragment,e),f(An.$$.fragment,e),f(Ft.$$.fragment,e),f(It.$$.fragment,e),f(Gt.$$.fragment,e),f(Dn.$$.fragment,e),f(Kn.$$.fragment,e),f(es.$$.fragment,e),f(Vt.$$.fragment,e),f(Xt.$$.fragment,e),f(ts.$$.fragment,e),f(ns.$$.fragment,e),f(ss.$$.fragment,e),f(Nt.$$.fragment,e),f(St.$$.fragment,e),f(os.$$.fragment,e),f(as.$$.fragment,e),f(ls.$$.fragment,e),f(zt.$$.fragment,e),f(Bt.$$.fragment,e),f(qt.$$.fragment,e),f(rs.$$.fragment,e),f(is.$$.fragment,e),f(ps.$$.fragment,e),f(Ot.$$.fragment,e),f(Et.$$.fragment,e),f(ms.$$.fragment,e),f(cs.$$.fragment,e),f(us.$$.fragment,e),f(gs.$$.fragment,e),f(Ht.$$.fragment,e),f(Lt.$$.fragment,e),f(Qt.$$.fragment,e),f(hs.$$.fragment,e),f(fs.$$.fragment,e),f(bs.$$.fragment,e),f(Yt.$$.fragment,e),f(Pt.$$.fragment,e),f(Ms.$$.fragment,e),f(Ts.$$.fragment,e),f(_s.$$.fragment,e),f($s.$$.fragment,e),f(At.$$.fragment,e),f(Dt.$$.fragment,e),f(Kt.$$.fragment,e),f(ws.$$.fragment,e),f(vs.$$.fragment,e),f(js.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(nn.$$.fragment,e),f(Js.$$.fragment,e),f(ks.$$.fragment,e),f(xs.$$.fragment,e),f(Us.$$.fragment,e),f(Rs.$$.fragment,e),f(Zs.$$.fragment,e),f(Ws.$$.fragment,e),f(Cs.$$.fragment,e),f(Fs.$$.fragment,e),f(Is.$$.fragment,e),f(Gs.$$.fragment,e),f(Vs.$$.fragment,e),f(Xs.$$.fragment,e),f(Ns.$$.fragment,e),f(Ss.$$.fragment,e),f(zs.$$.fragment,e),f(Bs.$$.fragment,e),f(qs.$$.fragment,e),f(Os.$$.fragment,e),f(Es.$$.fragment,e),f(Hs.$$.fragment,e),f(Ls.$$.fragment,e),f(Qs.$$.fragment,e),Kl=!0)},o(e){b(y.$$.fragment,e),b($.$$.fragment,e),b(cn.$$.fragment,e),b(un.$$.fragment,e),b(gn.$$.fragment,e),b(hn.$$.fragment,e),b(fn.$$.fragment,e),b(Mn.$$.fragment,e),b(yn.$$.fragment,e),b(Tn.$$.fragment,e),b(rt.$$.fragment,e),b(it.$$.fragment,e),b(pt.$$.fragment,e),b(_n.$$.fragment,e),b($n.$$.fragment,e),b(wn.$$.fragment,e),b(mt.$$.fragment,e),b(dt.$$.fragment,e),b(ct.$$.fragment,e),b(vn.$$.fragment,e),b(jn.$$.fragment,e),b(Jn.$$.fragment,e),b(ut.$$.fragment,e),b(gt.$$.fragment,e),b(ht.$$.fragment,e),b(kn.$$.fragment,e),b(xn.$$.fragment,e),b(Un.$$.fragment,e),b(ft.$$.fragment,e),b(bt.$$.fragment,e),b(Mt.$$.fragment,e),b(yt.$$.fragment,e),b(Rn.$$.fragment,e),b(Zn.$$.fragment,e),b(Wn.$$.fragment,e),b(Tt.$$.fragment,e),b(_t.$$.fragment,e),b($t.$$.fragment,e),b(Cn.$$.fragment,e),b(Fn.$$.fragment,e),b(In.$$.fragment,e),b(wt.$$.fragment,e),b(vt.$$.fragment,e),b(Gn.$$.fragment,e),b(Vn.$$.fragment,e),b(Xn.$$.fragment,e),b(jt.$$.fragment,e),b(Jt.$$.fragment,e),b(kt.$$.fragment,e),b(Nn.$$.fragment,e),b(zn.$$.fragment,e),b(Bn.$$.fragment,e),b(qn.$$.fragment,e),b(xt.$$.fragment,e),b(Ut.$$.fragment,e),b(Rt.$$.fragment,e),b(On.$$.fragment,e),b(En.$$.fragment,e),b(Hn.$$.fragment,e),b(Zt.$$.fragment,e),b(Wt.$$.fragment,e),b(Ct.$$.fragment,e),b(Ln.$$.fragment,e),b(Yn.$$.fragment,e),b(Pn.$$.fragment,e),b(An.$$.fragment,e),b(Ft.$$.fragment,e),b(It.$$.fragment,e),b(Gt.$$.fragment,e),b(Dn.$$.fragment,e),b(Kn.$$.fragment,e),b(es.$$.fragment,e),b(Vt.$$.fragment,e),b(Xt.$$.fragment,e),b(ts.$$.fragment,e),b(ns.$$.fragment,e),b(ss.$$.fragment,e),b(Nt.$$.fragment,e),b(St.$$.fragment,e),b(os.$$.fragment,e),b(as.$$.fragment,e),b(ls.$$.fragment,e),b(zt.$$.fragment,e),b(Bt.$$.fragment,e),b(qt.$$.fragment,e),b(rs.$$.fragment,e),b(is.$$.fragment,e),b(ps.$$.fragment,e),b(Ot.$$.fragment,e),b(Et.$$.fragment,e),b(ms.$$.fragment,e),b(cs.$$.fragment,e),b(us.$$.fragment,e),b(gs.$$.fragment,e),b(Ht.$$.fragment,e),b(Lt.$$.fragment,e),b(Qt.$$.fragment,e),b(hs.$$.fragment,e),b(fs.$$.fragment,e),b(bs.$$.fragment,e),b(Yt.$$.fragment,e),b(Pt.$$.fragment,e),b(Ms.$$.fragment,e),b(Ts.$$.fragment,e),b(_s.$$.fragment,e),b($s.$$.fragment,e),b(At.$$.fragment,e),b(Dt.$$.fragment,e),b(Kt.$$.fragment,e),b(ws.$$.fragment,e),b(vs.$$.fragment,e),b(js.$$.fragment,e),b(en.$$.fragment,e),b(tn.$$.fragment,e),b(nn.$$.fragment,e),b(Js.$$.fragment,e),b(ks.$$.fragment,e),b(xs.$$.fragment,e),b(Us.$$.fragment,e),b(Rs.$$.fragment,e),b(Zs.$$.fragment,e),b(Ws.$$.fragment,e),b(Cs.$$.fragment,e),b(Fs.$$.fragment,e),b(Is.$$.fragment,e),b(Gs.$$.fragment,e),b(Vs.$$.fragment,e),b(Xs.$$.fragment,e),b(Ns.$$.fragment,e),b(Ss.$$.fragment,e),b(zs.$$.fragment,e),b(Bs.$$.fragment,e),b(qs.$$.fragment,e),b(Os.$$.fragment,e),b(Es.$$.fragment,e),b(Hs.$$.fragment,e),b(Ls.$$.fragment,e),b(Qs.$$.fragment,e),Kl=!1},d(e){e&&(p(T),p(a),p(s),p(t),p(za),p(dn),p(Ba),p(qa),p(Z),p(Oa),p(Ea),p(bn),p(Ha),p(La),p(I),p(Qa),p(Ya),p(G),p(Pa),p(Aa),p(V),p(Da),p(Ka),p(X),p(el),p(tl),p(N),p(nl),p(sl),p(S),p(ol),p(al),p(z),p(ll),p(rl),p(Sn),p(il),p(pl),p(B),p(ml),p(dl),p(q),p(cl),p(ul),p(Qn),p(gl),p(hl),p(O),p(fl),p(bl),p(E),p(Ml),p(yl),p(H),p(Tl),p(_l),p(L),p($l),p(wl),p(Q),p(vl),p(jl),p(ds),p(Jl),p(kl),p(Y),p(xl),p(Ul),p(P),p(Rl),p(Zl),p(ys),p(Wl),p(Cl),p(A),p(Fl),p(Il),p(D),p(Gl),p(Vl),p(Xl),p(De),p(Nl),p(Sl),p(Ke),p(zl),p(Bl),p(et),p(ql),p(Ol),p(tt),p(El),p(Hl),p(nt),p(Ll),p(Ql),p(st),p(Yl),p(Pl),p(ot),p(Al),p(Dl),p(Sa)),p(n),M(y,e),M($,e),M(cn,e),M(un),M(gn),M(hn),M(fn,e),M(Mn,e),M(yn),M(Tn),M(rt),M(it),M(pt),M(_n,e),M($n),M(wn),M(mt),M(dt),M(ct),M(vn,e),M(jn),M(Jn),M(ut),M(gt),M(ht),M(kn,e),M(xn),M(Un),M(ft),M(bt),M(Mt),M(yt),M(Rn,e),M(Zn),M(Wn),M(Tt),M(_t),M($t),M(Cn,e),M(Fn),M(In),M(wt),M(vt),M(Gn,e),M(Vn),M(Xn),M(jt),M(Jt),M(kt),M(Nn,e),M(zn,e),M(Bn),M(qn),M(xt),M(Ut),M(Rt),M(On,e),M(En),M(Hn),M(Zt),M(Wt),M(Ct),M(Ln,e),M(Yn,e),M(Pn),M(An),M(Ft),M(It),M(Gt),M(Dn,e),M(Kn),M(es),M(Vt),M(Xt),M(ts,e),M(ns),M(ss),M(Nt),M(St),M(os,e),M(as),M(ls),M(zt),M(Bt),M(qt),M(rs,e),M(is),M(ps),M(Ot),M(Et),M(ms,e),M(cs,e),M(us),M(gs),M(Ht),M(Lt),M(Qt),M(hs,e),M(fs),M(bs),M(Yt),M(Pt),M(Ms,e),M(Ts,e),M(_s),M($s),M(At),M(Dt),M(Kt),M(ws,e),M(vs),M(js),M(en),M(tn),M(nn),M(Js,e),M(ks,e),M(xs),M(Us),M(Rs,e),M(Zs),M(Ws),M(Cs,e),M(Fs),M(Is),M(Gs,e),M(Vs),M(Xs),M(Ns,e),M(Ss),M(zs),M(Bs,e),M(qs),M(Os),M(Es,e),M(Hs),M(Ls),M(Qs,e)}}}const qc='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"ORTModel","local":"optimum.onnxruntime.ORTModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"ORTModelForCausalLM","local":"optimum.onnxruntime.ORTModelForCausalLM","sections":[],"depth":3},{"title":"ORTModelForMaskedLM","local":"optimum.onnxruntime.ORTModelForMaskedLM","sections":[],"depth":3},{"title":"ORTModelForSeq2SeqLM","local":"optimum.onnxruntime.ORTModelForSeq2SeqLM","sections":[],"depth":3},{"title":"ORTModelForSequenceClassification","local":"optimum.onnxruntime.ORTModelForSequenceClassification","sections":[],"depth":3},{"title":"ORTModelForTokenClassification","local":"optimum.onnxruntime.ORTModelForTokenClassification","sections":[],"depth":3},{"title":"ORTModelForMultipleChoice","local":"optimum.onnxruntime.ORTModelForMultipleChoice","sections":[],"depth":3},{"title":"ORTModelForQuestionAnswering","local":"optimum.onnxruntime.ORTModelForQuestionAnswering","sections":[],"depth":3}],"depth":2},{"title":"Computer vision","local":"computer-vision","sections":[{"title":"ORTModelForImageClassification","local":"optimum.onnxruntime.ORTModelForImageClassification","sections":[],"depth":3},{"title":"ORTModelForSemanticSegmentation","local":"optimum.onnxruntime.ORTModelForSemanticSegmentation","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"ORTModelForAudioClassification","local":"optimum.onnxruntime.ORTModelForAudioClassification","sections":[],"depth":3},{"title":"ORTModelForAudioFrameClassification","local":"optimum.onnxruntime.ORTModelForAudioFrameClassification","sections":[],"depth":3},{"title":"ORTModelForCTC","local":"optimum.onnxruntime.ORTModelForCTC","sections":[],"depth":3},{"title":"ORTModelForSpeechSeq2Seq","local":"optimum.onnxruntime.ORTModelForSpeechSeq2Seq","sections":[],"depth":3},{"title":"ORTModelForAudioXVector","local":"optimum.onnxruntime.ORTModelForAudioXVector","sections":[],"depth":3}],"depth":2},{"title":"Multimodal","local":"multimodal","sections":[{"title":"ORTModelForVision2Seq","local":"optimum.onnxruntime.ORTModelForVision2Seq","sections":[],"depth":3},{"title":"ORTModelForPix2Struct","local":"optimum.onnxruntime.ORTModelForPix2Struct","sections":[],"depth":3}],"depth":2},{"title":"Custom Tasks","local":"custom-tasks","sections":[{"title":"ORTModelForCustomTasks","local":"optimum.onnxruntime.ORTModelForCustomTasks","sections":[],"depth":4},{"title":"ORTModelForFeatureExtraction","local":"optimum.onnxruntime.ORTModelForFeatureExtraction","sections":[],"depth":4}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"ORTDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionInpaintPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionInpaintPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLPipeline","sections":[],"depth":4},{"title":"ORTStableDiffusionXLImg2ImgPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTStableDiffusionXLImg2ImgPipeline","sections":[],"depth":4},{"title":"ORTLatentConsistencyModelPipeline","local":"optimum.utils.dummy_diffusers_objects.ORTLatentConsistencyModelPipeline","sections":[],"depth":4}],"depth":2}],"depth":1}';function Oc(w){return zd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dc extends Bd{constructor(n){super(),qd(this,n,Oc,Bc,Sd,{})}}export{Dc as component};
