import{s as ns,o as ls,n as de}from"../chunks/scheduler.9bc65507.js";import{S as os,i as rs,g as c,s as o,r as u,A as is,h as p,f as n,c as r,j as se,u as g,x as b,k as te,y as f,a as l,v as y,d as j,t as T,w}from"../chunks/index.707bf1b6.js";import{T as as}from"../chunks/Tip.c2ecdbf4.js";import{D as pe}from"../chunks/Docstring.17db21ae.js";import{C as Ne}from"../chunks/CodeBlock.54a9f38d.js";import{E as Ee}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as me}from"../chunks/Heading.342b1fa6.js";function ms(U){let t,h="Example:",i,m,d;return m=new Ne({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRpbWVzZm9ybWVyQ29uZmlnJTJDJTIwVGltZXNmb3JtZXJNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBUaW1lU2Zvcm1lciUyMHRpbWVzZm9ybWVyLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwVGltZXNmb3JtZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBUaW1lc2Zvcm1lck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TimesformerConfig, TimesformerModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a TimeSformer timesformer-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = TimesformerConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesformerModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,i=o(),u(m.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),b(t)!=="svelte-11lpom8"&&(t.textContent=h),i=r(a),g(m.$$.fragment,a)},m(a,M){l(a,t,M),l(a,i,M),y(m,a,M),d=!0},p:de,i(a){d||(j(m.$$.fragment,a),d=!0)},o(a){T(m.$$.fragment,a),d=!1},d(a){a&&(n(t),n(i)),w(m,a)}}}function cs(U){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(i){t=p(i,"P",{"data-svelte-h":!0}),b(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(i,m){l(i,t,m)},p:de,d(i){i&&n(t)}}}function ps(U){let t,h="Examples:",i,m,d;return m=new Ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TimesformerModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 8 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">8</span>, frame_sample_rate=<span class="hljs-number">4</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesformerModel.from_pretrained(<span class="hljs-string">&quot;facebook/timesformer-base-finetuned-k400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prepare video for the model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1569</span>, <span class="hljs-number">768</span>]`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,i=o(),u(m.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),b(t)!=="svelte-kvfsh7"&&(t.textContent=h),i=r(a),g(m.$$.fragment,a)},m(a,M){l(a,t,M),l(a,i,M),y(m,a,M),d=!0},p:de,i(a){d||(j(m.$$.fragment,a),d=!0)},o(a){T(m.$$.fragment,a),d=!1},d(a){a&&(n(t),n(i)),w(m,a)}}}function ds(U){let t,h=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=c("p"),t.innerHTML=h},l(i){t=p(i,"P",{"data-svelte-h":!0}),b(t)!=="svelte-fincs2"&&(t.innerHTML=h)},m(i,m){l(i,t,m)},p:de,d(i){i&&n(t)}}}function fs(U){let t,h="Examples:",i,m,d;return m=new Ne({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, TimesformerForVideoClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download

<span class="hljs-meta">&gt;&gt;&gt; </span>np.random.seed(<span class="hljs-number">0</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">sample_frame_indices</span>(<span class="hljs-params">clip_len, frame_sample_rate, seg_len</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Sample a given number of frame indices from the video.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        clip_len (\`int\`): Total number of frames to sample.
<span class="hljs-meta">... </span>        frame_sample_rate (\`int\`): Sample every n-th frame.
<span class="hljs-meta">... </span>        seg_len (\`int\`): Maximum allowed index of sample&#x27;s last frame.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of sampled frame indices
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    converted_len = <span class="hljs-built_in">int</span>(clip_len * frame_sample_rate)
<span class="hljs-meta">... </span>    end_idx = np.random.randint(converted_len, seg_len)
<span class="hljs-meta">... </span>    start_idx = end_idx - converted_len
<span class="hljs-meta">... </span>    indices = np.linspace(start_idx, end_idx, num=clip_len)
<span class="hljs-meta">... </span>    indices = np.clip(indices, start_idx, end_idx - <span class="hljs-number">1</span>).astype(np.int64)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> indices


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># video clip consists of 300 frames (10 seconds at 30 FPS)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>file_path = hf_hub_download(
<span class="hljs-meta">... </span>    repo_id=<span class="hljs-string">&quot;nielsr/video-demo&quot;</span>, filename=<span class="hljs-string">&quot;eating_spaghetti.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(file_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample 8 frames</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = sample_frame_indices(clip_len=<span class="hljs-number">8</span>, frame_sample_rate=<span class="hljs-number">1</span>, seg_len=container.streams.video[<span class="hljs-number">0</span>].frames)
<span class="hljs-meta">&gt;&gt;&gt; </span>video = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;MCG-NJU/videomae-base-finetuned-kinetics&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = TimesformerForVideoClassification.from_pretrained(<span class="hljs-string">&quot;facebook/timesformer-base-finetuned-k400&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(<span class="hljs-built_in">list</span>(video), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)
<span class="hljs-meta">... </span>    logits = outputs.logits

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 400 Kinetics-400 classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.config.id2label[predicted_label])
eating spaghetti`,wrap:!1}}),{c(){t=c("p"),t.textContent=h,i=o(),u(m.$$.fragment)},l(a){t=p(a,"P",{"data-svelte-h":!0}),b(t)!=="svelte-kvfsh7"&&(t.textContent=h),i=r(a),g(m.$$.fragment,a)},m(a,M){l(a,t,M),l(a,i,M),y(m,a,M),d=!0},p:de,i(a){d||(j(m.$$.fragment,a),d=!0)},o(a){T(m.$$.fragment,a),d=!1},d(a){a&&(n(t),n(i)),w(m,a)}}}function hs(U){let t,h,i,m,d,a,M,fe,X,Qe=`The TimeSformer model was proposed in <a href="https://arxiv.org/abs/2102.05095" rel="nofollow">TimeSformer: Is Space-Time Attention All You Need for Video Understanding?</a> by Facebook Research.
This work is a milestone in action-recognition field being the first video transformer. It inspired many transformer based video understanding and classification papers.`,he,S,Ye="The abstract from the paper is the following:",Me,z,Re='<em>We present a convolution-free approach to video classification built exclusively on self-attention over space and time. Our method, named “TimeSformer,” adapts the standard Transformer architecture to video by enabling spatiotemporal feature learning directly from a sequence of frame-level patches. Our experimental study compares different self-attention schemes and suggests that “divided attention,” where temporal attention and spatial attention are separately applied within each block, leads to the best video classification accuracy among the design choices considered. Despite the radically new design, TimeSformer achieves state-of-the-art results on several action recognition benchmarks, including the best reported accuracy on Kinetics-400 and Kinetics-600. Finally, compared to 3D convolutional networks, our model is faster to train, it can achieve dramatically higher test efficiency (at a small drop in accuracy), and it can also be applied to much longer video clips (over one minute long). Code and models are available at: <a href="https://github.com/facebookresearch/TimeSformer" rel="nofollow">this https URL</a>.</em>',ue,E,He="Tips:",ge,N,Le="There are many pretrained variants. Select your pretrained model based on the dataset it is trained on. Moreover, the number of input frames per clip changes based on the model size so you should consider this parameter while selecting your pretrained model.",ye,Q,qe=`This model was contributed by <a href="https://huggingface.co/fcakyon" rel="nofollow">fcakyon</a>.
The original code can be found <a href="https://github.com/facebookresearch/TimeSformer" rel="nofollow">here</a>.`,je,Y,Te,R,Ke='<li><a href="../tasks/video_classification">Video classification task guide</a></li>',we,H,be,J,L,ve,ae,Pe=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a>. It is used to instantiate a
TimeSformer model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the TimeSformer
<a href="https://huggingface.co/facebook/timesformer-base-finetuned-k600" rel="nofollow">facebook/timesformer-base-finetuned-k600</a>
architecture.`,Be,ne,De=`Configuration objects inherit from <a href="/docs/transformers/v4.34.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.34.1/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,We,k,Je,q,Ue,C,K,Ge,le,Oe=`The bare TimeSformer Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ve,_,P,ke,oe,es='The <a href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerModel">TimesformerModel</a> forward method, overrides the <code>__call__</code> special method.',xe,x,$e,$,_e,D,Ze,I,O,Ae,re,ss=`TimeSformer Model transformer with a video classification head on top (a linear layer on top of the final hidden state
of the [CLS] token) e.g. for ImageNet.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Fe,Z,ee,Xe,ie,ts='The <a href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerForVideoClassification">TimesformerForVideoClassification</a> forward method, overrides the <code>__call__</code> special method.',Se,A,ze,F,Ce,ce,Ie;return d=new me({props:{title:"TimeSformer",local:"timesformer",headingTag:"h1"}}),M=new me({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Y=new me({props:{title:"Documentation resources",local:"documentation-resources",headingTag:"h2"}}),H=new me({props:{title:"TimesformerConfig",local:"transformers.TimesformerConfig",headingTag:"h2"}}),L=new pe({props:{name:"class transformers.TimesformerConfig",anchor:"transformers.TimesformerConfig",parameters:[{name:"image_size",val:" = 224"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"num_frames",val:" = 8"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-06"},{name:"qkv_bias",val:" = True"},{name:"attention_type",val:" = 'divided_space_time'"},{name:"drop_path_rate",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.TimesformerConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 224) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.TimesformerConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.TimesformerConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.TimesformerConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
The number of frames in each video.`,name:"num_frames"},{anchor:"transformers.TimesformerConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.TimesformerConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.TimesformerConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.TimesformerConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.TimesformerConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.TimesformerConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probabilitiy for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.TimesformerConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.TimesformerConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.TimesformerConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-6) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.TimesformerConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.TimesformerConfig.attention_type",description:`<strong>attention_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;divided_space_time&quot;</code>) &#x2014;
The attention type to use. Must be one of <code>&quot;divided_space_time&quot;</code>, <code>&quot;space_only&quot;</code>, <code>&quot;joint_space_time&quot;</code>.`,name:"attention_type"},{anchor:"transformers.TimesformerConfig.drop_path_rate",description:`<strong>drop_path_rate</strong> (<code>float</code>, <em>optional</em>, defaults to 0) &#x2014;
The dropout ratio for stochastic depth.`,name:"drop_path_rate"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/timesformer/configuration_timesformer.py#L28"}}),k=new Ee({props:{anchor:"transformers.TimesformerConfig.example",$$slots:{default:[ms]},$$scope:{ctx:U}}}),q=new me({props:{title:"TimesformerModel",local:"transformers.TimesformerModel",headingTag:"h2"}}),K=new pe({props:{name:"class transformers.TimesformerModel",anchor:"transformers.TimesformerModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TimesformerModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/timesformer/modeling_timesformer.py#L534"}}),P=new pe({props:{name:"forward",anchor:"transformers.TimesformerModel.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TimesformerModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.1/en/model_doc/videomae#transformers.VideoMAEImageProcessor.preprocess">VideoMAEImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TimesformerModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TimesformerModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TimesformerModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/timesformer/modeling_timesformer.py#L558",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerConfig"
>TimesformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.BaseModelOutput"
>transformers.modeling_outputs.BaseModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),x=new as({props:{$$slots:{default:[cs]},$$scope:{ctx:U}}}),$=new Ee({props:{anchor:"transformers.TimesformerModel.forward.example",$$slots:{default:[ps]},$$scope:{ctx:U}}}),D=new me({props:{title:"TimesformerForVideoClassification",local:"transformers.TimesformerForVideoClassification",headingTag:"h2"}}),O=new pe({props:{name:"class transformers.TimesformerForVideoClassification",anchor:"transformers.TimesformerForVideoClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.TimesformerForVideoClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerConfig">TimesformerConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.34.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/timesformer/modeling_timesformer.py#L676"}}),ee=new pe({props:{name:"forward",anchor:"transformers.TimesformerForVideoClassification.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.TimesformerForVideoClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/v4.34.1/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/v4.34.1/en/model_doc/videomae#transformers.VideoMAEImageProcessor.preprocess">VideoMAEImageProcessor.preprocess()</a> for details.`,name:"pixel_values"},{anchor:"transformers.TimesformerForVideoClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.TimesformerForVideoClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.TimesformerForVideoClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.TimesformerForVideoClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.34.1/src/transformers/models/timesformer/modeling_timesformer.py#L689",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.34.1/en/model_doc/timesformer#transformers.TimesformerConfig"
>TimesformerConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each stage) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states
(also called feature maps) of the model at the output of each stage.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, patch_size, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.34.1/en/main_classes/output#transformers.modeling_outputs.ImageClassifierOutput"
>transformers.modeling_outputs.ImageClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new as({props:{$$slots:{default:[ds]},$$scope:{ctx:U}}}),F=new Ee({props:{anchor:"transformers.TimesformerForVideoClassification.forward.example",$$slots:{default:[fs]},$$scope:{ctx:U}}}),{c(){t=c("meta"),h=o(),i=c("p"),m=o(),u(d.$$.fragment),a=o(),u(M.$$.fragment),fe=o(),X=c("p"),X.innerHTML=Qe,he=o(),S=c("p"),S.textContent=Ye,Me=o(),z=c("p"),z.innerHTML=Re,ue=o(),E=c("p"),E.textContent=He,ge=o(),N=c("p"),N.textContent=Le,ye=o(),Q=c("p"),Q.innerHTML=qe,je=o(),u(Y.$$.fragment),Te=o(),R=c("ul"),R.innerHTML=Ke,we=o(),u(H.$$.fragment),be=o(),J=c("div"),u(L.$$.fragment),ve=o(),ae=c("p"),ae.innerHTML=Pe,Be=o(),ne=c("p"),ne.innerHTML=De,We=o(),u(k.$$.fragment),Je=o(),u(q.$$.fragment),Ue=o(),C=c("div"),u(K.$$.fragment),Ge=o(),le=c("p"),le.innerHTML=Oe,Ve=o(),_=c("div"),u(P.$$.fragment),ke=o(),oe=c("p"),oe.innerHTML=es,xe=o(),u(x.$$.fragment),$e=o(),u($.$$.fragment),_e=o(),u(D.$$.fragment),Ze=o(),I=c("div"),u(O.$$.fragment),Ae=o(),re=c("p"),re.innerHTML=ss,Fe=o(),Z=c("div"),u(ee.$$.fragment),Xe=o(),ie=c("p"),ie.innerHTML=ts,Se=o(),u(A.$$.fragment),ze=o(),u(F.$$.fragment),Ce=o(),ce=c("p"),this.h()},l(e){const s=is("svelte-u9bgzb",document.head);t=p(s,"META",{name:!0,content:!0}),s.forEach(n),h=r(e),i=p(e,"P",{}),se(i).forEach(n),m=r(e),g(d.$$.fragment,e),a=r(e),g(M.$$.fragment,e),fe=r(e),X=p(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-i6ab1x"&&(X.innerHTML=Qe),he=r(e),S=p(e,"P",{"data-svelte-h":!0}),b(S)!=="svelte-vfdo9a"&&(S.textContent=Ye),Me=r(e),z=p(e,"P",{"data-svelte-h":!0}),b(z)!=="svelte-j68dli"&&(z.innerHTML=Re),ue=r(e),E=p(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-axv494"&&(E.textContent=He),ge=r(e),N=p(e,"P",{"data-svelte-h":!0}),b(N)!=="svelte-7832el"&&(N.textContent=Le),ye=r(e),Q=p(e,"P",{"data-svelte-h":!0}),b(Q)!=="svelte-1wsudhb"&&(Q.innerHTML=qe),je=r(e),g(Y.$$.fragment,e),Te=r(e),R=p(e,"UL",{"data-svelte-h":!0}),b(R)!=="svelte-gz9vpw"&&(R.innerHTML=Ke),we=r(e),g(H.$$.fragment,e),be=r(e),J=p(e,"DIV",{class:!0});var v=se(J);g(L.$$.fragment,v),ve=r(v),ae=p(v,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-1xcel6x"&&(ae.innerHTML=Pe),Be=r(v),ne=p(v,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-1onjy9f"&&(ne.innerHTML=De),We=r(v),g(k.$$.fragment,v),v.forEach(n),Je=r(e),g(q.$$.fragment,e),Ue=r(e),C=p(e,"DIV",{class:!0});var G=se(C);g(K.$$.fragment,G),Ge=r(G),le=p(G,"P",{"data-svelte-h":!0}),b(le)!=="svelte-gln3qs"&&(le.innerHTML=Oe),Ve=r(G),_=p(G,"DIV",{class:!0});var B=se(_);g(P.$$.fragment,B),ke=r(B),oe=p(B,"P",{"data-svelte-h":!0}),b(oe)!=="svelte-1tvzn8n"&&(oe.innerHTML=es),xe=r(B),g(x.$$.fragment,B),$e=r(B),g($.$$.fragment,B),B.forEach(n),G.forEach(n),_e=r(e),g(D.$$.fragment,e),Ze=r(e),I=p(e,"DIV",{class:!0});var V=se(I);g(O.$$.fragment,V),Ae=r(V),re=p(V,"P",{"data-svelte-h":!0}),b(re)!=="svelte-1ancuo0"&&(re.innerHTML=ss),Fe=r(V),Z=p(V,"DIV",{class:!0});var W=se(Z);g(ee.$$.fragment,W),Xe=r(W),ie=p(W,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-19z8m8z"&&(ie.innerHTML=ts),Se=r(W),g(A.$$.fragment,W),ze=r(W),g(F.$$.fragment,W),W.forEach(n),V.forEach(n),Ce=r(e),ce=p(e,"P",{}),se(ce).forEach(n),this.h()},h(){te(t,"name","hf:doc:metadata"),te(t,"content",Ms),te(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(_,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),te(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){f(document.head,t),l(e,h,s),l(e,i,s),l(e,m,s),y(d,e,s),l(e,a,s),y(M,e,s),l(e,fe,s),l(e,X,s),l(e,he,s),l(e,S,s),l(e,Me,s),l(e,z,s),l(e,ue,s),l(e,E,s),l(e,ge,s),l(e,N,s),l(e,ye,s),l(e,Q,s),l(e,je,s),y(Y,e,s),l(e,Te,s),l(e,R,s),l(e,we,s),y(H,e,s),l(e,be,s),l(e,J,s),y(L,J,null),f(J,ve),f(J,ae),f(J,Be),f(J,ne),f(J,We),y(k,J,null),l(e,Je,s),y(q,e,s),l(e,Ue,s),l(e,C,s),y(K,C,null),f(C,Ge),f(C,le),f(C,Ve),f(C,_),y(P,_,null),f(_,ke),f(_,oe),f(_,xe),y(x,_,null),f(_,$e),y($,_,null),l(e,_e,s),y(D,e,s),l(e,Ze,s),l(e,I,s),y(O,I,null),f(I,Ae),f(I,re),f(I,Fe),f(I,Z),y(ee,Z,null),f(Z,Xe),f(Z,ie),f(Z,Se),y(A,Z,null),f(Z,ze),y(F,Z,null),l(e,Ce,s),l(e,ce,s),Ie=!0},p(e,[s]){const v={};s&2&&(v.$$scope={dirty:s,ctx:e}),k.$set(v);const G={};s&2&&(G.$$scope={dirty:s,ctx:e}),x.$set(G);const B={};s&2&&(B.$$scope={dirty:s,ctx:e}),$.$set(B);const V={};s&2&&(V.$$scope={dirty:s,ctx:e}),A.$set(V);const W={};s&2&&(W.$$scope={dirty:s,ctx:e}),F.$set(W)},i(e){Ie||(j(d.$$.fragment,e),j(M.$$.fragment,e),j(Y.$$.fragment,e),j(H.$$.fragment,e),j(L.$$.fragment,e),j(k.$$.fragment,e),j(q.$$.fragment,e),j(K.$$.fragment,e),j(P.$$.fragment,e),j(x.$$.fragment,e),j($.$$.fragment,e),j(D.$$.fragment,e),j(O.$$.fragment,e),j(ee.$$.fragment,e),j(A.$$.fragment,e),j(F.$$.fragment,e),Ie=!0)},o(e){T(d.$$.fragment,e),T(M.$$.fragment,e),T(Y.$$.fragment,e),T(H.$$.fragment,e),T(L.$$.fragment,e),T(k.$$.fragment,e),T(q.$$.fragment,e),T(K.$$.fragment,e),T(P.$$.fragment,e),T(x.$$.fragment,e),T($.$$.fragment,e),T(D.$$.fragment,e),T(O.$$.fragment,e),T(ee.$$.fragment,e),T(A.$$.fragment,e),T(F.$$.fragment,e),Ie=!1},d(e){e&&(n(h),n(i),n(m),n(a),n(fe),n(X),n(he),n(S),n(Me),n(z),n(ue),n(E),n(ge),n(N),n(ye),n(Q),n(je),n(Te),n(R),n(we),n(be),n(J),n(Je),n(Ue),n(C),n(_e),n(Ze),n(I),n(Ce),n(ce)),n(t),w(d,e),w(M,e),w(Y,e),w(H,e),w(L),w(k),w(q,e),w(K),w(P),w(x),w($),w(D,e),w(O),w(ee),w(A),w(F)}}}const Ms='{"title":"TimeSformer","local":"timesformer","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Documentation resources","local":"documentation-resources","sections":[],"depth":2},{"title":"TimesformerConfig","local":"transformers.TimesformerConfig","sections":[],"depth":2},{"title":"TimesformerModel","local":"transformers.TimesformerModel","sections":[],"depth":2},{"title":"TimesformerForVideoClassification","local":"transformers.TimesformerForVideoClassification","sections":[],"depth":2}],"depth":1}';function us(U){return ls(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Us extends os{constructor(t){super(),rs(this,t,us,hs,ns,{})}}export{Us as component};
