import{s as no,o as lo,n as er}from"../chunks/scheduler.9bc65507.js";import{S as io,i as co,g as n,s as a,r as p,A as mo,h as l,f as t,c as o,j as $,u as f,x as d,k as b,y as s,a as i,v as u,d as h,t as g,w as _}from"../chunks/index.707bf1b6.js";import{T as oa}from"../chunks/Tip.c2ecdbf4.js";import{D as M}from"../chunks/Docstring.17db21ae.js";import{C as rr}from"../chunks/CodeBlock.54a9f38d.js";import{E as na}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as pe}from"../chunks/Heading.342b1fa6.js";function po(k){let c,T=`This class method is simply calling the feature extractor
<a href="/docs/transformers/v4.39.2/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a>, image processor
<a href="/docs/transformers/v4.39.2/ja/internal/image_processing_utils#transformers.ImageProcessingMixin">ImageProcessingMixin</a> and the tokenizer
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code> methods. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-ks5ma3"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function fo(k){let c,T="Examples:",v,x,C;return x=new rr({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS1jYXNlZCUyMiklMEElMEElMjMlMjBQdXNoJTIwdGhlJTIwcHJvY2Vzc29yJTIwdG8lMjB5b3VyJTIwbmFtZXNwYWNlJTIwd2l0aCUyMHRoZSUyMG5hbWUlMjAlMjJteS1maW5ldHVuZWQtYmVydCUyMi4lMEFwcm9jZXNzb3IucHVzaF90b19odWIoJTIybXktZmluZXR1bmVkLWJlcnQlMjIpJTBBJTBBJTIzJTIwUHVzaCUyMHRoZSUyMHByb2Nlc3NvciUyMHRvJTIwYW4lMjBvcmdhbml6YXRpb24lMjB3aXRoJTIwdGhlJTIwbmFtZSUyMCUyMm15LWZpbmV0dW5lZC1iZXJ0JTIyLiUwQXByb2Nlc3Nvci5wdXNoX3RvX2h1YiglMjJodWdnaW5nZmFjZSUyRm15LWZpbmV0dW5lZC1iZXJ0JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-cased&quot;</span>)

<span class="hljs-comment"># Push the processor to your namespace with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;my-finetuned-bert&quot;</span>)

<span class="hljs-comment"># Push the processor to an organization with the name &quot;my-finetuned-bert&quot;.</span>
processor.push_to_hub(<span class="hljs-string">&quot;huggingface/my-finetuned-bert&quot;</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=a(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,j){i(m,c,j),i(m,v,j),u(x,m,j),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function uo(k){let c,T="This API is experimental and may have some slight breaking changes in the next releases.";return{c(){c=n("p"),c.textContent=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-15rpg4"&&(c.textContent=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function ho(k){let c,T=`This class method is simply calling <a href="/docs/transformers/v4.39.2/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> and
<a href="/docs/transformers/v4.39.2/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.save_pretrained">save_pretrained()</a>. Please refer to the docstrings of the
methods above for more information.`;return{c(){c=n("p"),c.innerHTML=T},l(v){c=l(v,"P",{"data-svelte-h":!0}),d(c)!=="svelte-8w4zea"&&(c.innerHTML=T)},m(v,x){i(v,c,x)},p:er,d(v){v&&t(c)}}}function go(k){let c,T="Examples:",v,x,C;return x=new rr({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMGFzJTIwdGZkcyUwQSUwQWRhdGFzZXQlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBJTBBdHJhaW5pbmdfZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzREZhbHNlKSUwQWV2YWx1YXRpb25fZXhhbXBsZXMlMjAlM0QlMjBnZXRfZXhhbXBsZXNfZnJvbV9kYXRhc2V0KGRhdGFzZXQlMkMlMjBldmFsdWF0ZSUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow_datasets <span class="hljs-keyword">as</span> tfds

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>training_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>evaluation_examples = get_examples_from_dataset(dataset, evaluate=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=a(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,j){i(m,c,j),i(m,v,j),u(x,m,j),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function _o(k){let c,T="Example:",v,x,C;return x=new rr({props:{code:"cHJvY2Vzc29yJTIwJTNEJTIwU3F1YWRWMlByb2Nlc3NvcigpJTBBZXhhbXBsZXMlMjAlM0QlMjBwcm9jZXNzb3IuZ2V0X2Rldl9leGFtcGxlcyhkYXRhX2RpciklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEYXJncy5tYXhfc2VxX2xlbmd0aCUyQyUwQSUyMCUyMCUyMCUyMGRvY19zdHJpZGUlM0RhcmdzLmRvY19zdHJpZGUlMkMlMEElMjAlMjAlMjAlMjBtYXhfcXVlcnlfbGVuZ3RoJTNEYXJncy5tYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`processor = SquadV2Processor()
examples = processor.get_dev_examples(data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=args.max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=args.max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("p"),c.textContent=T,v=a(),p(x.$$.fragment)},l(m){c=l(m,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=T),v=o(m),f(x.$$.fragment,m)},m(m,j){i(m,c,j),i(m,v,j),u(x,m,j),C=!0},p:er,i(m){C||(h(x.$$.fragment,m),C=!0)},o(m){g(x.$$.fragment,m),C=!1},d(m){m&&(t(c),t(v)),_(x,m)}}}function vo(k){let c,T,v,x,C,m,j,la="Transformers ライブラリでは、プロセッサは 2 つの異なる意味を持ちます。",sr,fe,ia=`<li><a href="../model_doc/wav2vec2">Wav2Vec2</a> などのマルチモーダル モデルの入力を前処理するオブジェクト (音声とテキスト)
または <a href="../model_doc/clip">CLIP</a> (テキストとビジョン)</li> <li>古いバージョンのライブラリで GLUE または SQUAD のデータを前処理するために使用されていたオブジェクトは非推奨になりました。</li>`,ar,ue,or,he,da=`マルチモーダル モデルでは、オブジェクトが複数のモダリティ (テキスト、
視覚と音声）。これは、2 つ以上の処理オブジェクトをグループ化するプロセッサーと呼ばれるオブジェクトによって処理されます。
トークナイザー (テキスト モダリティ用)、画像プロセッサー (視覚用)、特徴抽出器 (オーディオ用) など。`,nr,ge,ca="これらのプロセッサは、保存およびロード機能を実装する次の基本クラスを継承します。",lr,y,_e,ns,yt,ma="This is a mixin used to provide saving/loading functionality for all processor classes.",ls,F,ve,is,Mt,pa="Instantiates a type of <code>~processing_utils.ProcessingMixin</code> from a Python dictionary of parameters.",ds,Z,xe,cs,wt,fa="Instantiate a processor associated with a pretrained model.",ms,R,ps,G,$e,fs,Tt,ua=`From a <code>pretrained_model_name_or_path</code>, resolve to a dictionary of parameters, to be used for instantiating a
processor of type <code>~processing_utils.ProcessingMixin</code> using <code>from_args_and_dict</code>.`,us,q,be,hs,Ct,ha="Upload the processor files to the 🤗 Model Hub.",gs,W,_s,V,ye,vs,Pt,ga=`Register this class with a given auto class. This should only be used for custom feature extractors as the ones
in the library are already mapped with <code>AutoProcessor</code>.`,xs,Q,$s,z,Me,bs,jt,_a=`Saves the attributes of this processor (feature extractor, tokenizer…) in the specified directory so that it
can be reloaded using the <a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.ProcessorMixin.from_pretrained">from_pretrained()</a> method.`,ys,Y,Ms,A,we,ws,It,va="Serializes this instance to a Python dictionary.",Ts,O,Te,Cs,Xt,xa="Save this instance to a JSON file.",Ps,K,Ce,js,kt,$a="Serializes this instance to a JSON string.",ir,Pe,dr,je,ba=`すべてのプロセッサは、同じアーキテクチャに従っています。
<a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.DataProcessor">DataProcessor</a>。プロセッサは次のリストを返します。
<a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.InputExample">InputExample</a>。これら
<a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.InputExample">InputExample</a> は次のように変換できます。
<code>~data.processors.utils.Input features</code> をモデルにフィードします。`,cr,P,Ie,Is,Jt,ya="Base class for data converters for sequence classification data sets.",Xs,ee,Xe,ks,Ut,Ma='Gets a collection of <a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the dev set.',Js,te,ke,Us,Lt,wa="Gets an example from a dict with tensorflow tensors.",Ls,re,Je,Zs,Zt,Ta="Gets the list of labels for this data set.",qs,se,Ue,Vs,qt,Ca='Gets a collection of <a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the test set.',zs,ae,Le,Es,Vt,Pa='Gets a collection of <a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.InputExample">InputExample</a> for the train set.',Hs,oe,Ze,Ns,zt,ja=`Some tensorflow_datasets datasets are not formatted the same way the GLUE datasets are. This method converts
examples to the correct format.`,mr,J,qe,Bs,Et,Ia="A single training/test example for simple sequence classification.",Ss,ne,Ve,Ds,Ht,Xa="Serializes this instance to a JSON string.",pr,U,ze,Fs,Nt,ka="A single set of features of data. Property names are the same names as the corresponding inputs to a model.",Rs,le,Ee,Gs,Bt,Ja="Serializes this instance to a JSON string.",fr,He,ur,Ne,Ua=`<a href="https://gluebenchmark.com/" rel="nofollow">一般言語理解評価 (GLUE)</a> は、
既存の NLU タスクの多様なセットにわたるモデルのパフォーマンス。紙と同時発売された <a href="https://openreview.net/pdf?id=rJ4km2R5t7" rel="nofollow">GLUE: A
自然言語理解のためのマルチタスクベンチマークおよび分析プラットフォーム</a>`,hr,Be,La=`このライブラリは、MRPC、MNLI、MNLI (不一致)、CoLA、SST2、STSB、
QQP、QNLI、RTE、WNLI。`,gr,Se,Za="それらのプロセッサは次のとおりです。",_r,De,qa="<li><code>~data.processors.utils.MrpcProcessor</code></li> <li><code>~data.processors.utils.MnliProcessor</code></li> <li><code>~data.processors.utils.MnliMismatchedProcessor</code></li> <li><code>~data.processors.utils.Sst2Processor</code></li> <li><code>~data.processors.utils.StsbProcessor</code></li> <li><code>~data.processors.utils.QqpProcessor</code></li> <li><code>~data.processors.utils.QnliProcessor</code></li> <li><code>~data.processors.utils.RteProcessor</code></li> <li><code>~data.processors.utils.WnliProcessor</code></li>",vr,Fe,Va=`さらに、次のメソッドを使用して、データ ファイルから値をロードし、それらをリストに変換することができます。
<a href="/docs/transformers/v4.39.2/ja/main_classes/processors#transformers.InputExample">InputExample</a>。`,xr,N,Re,Ws,St,za="Loads a data file into a list of <code>InputFeatures</code>",$r,Ge,br,We,Ea=`<a href="https://www.nyu.edu/projects/bowman/xnli/" rel="nofollow">クロスリンガル NLI コーパス (XNLI)</a> は、
言語を超えたテキスト表現の品質。 XNLI は、<a href="http://www.nyu.edu/projects/bowman/multinli/" rel="nofollow"><em>MultiNLI</em></a> に基づくクラウドソースのデータセットです。テキストのペアには、15 個のテキスト含意アノテーションがラベル付けされています。
さまざまな言語 (英語などの高リソース言語とスワヒリ語などの低リソース言語の両方を含む)。`,yr,Qe,Ha='論文 <a href="https://arxiv.org/abs/1809.05053" rel="nofollow">XNLI: Evaluating Cross-lingual Sentence Representations</a> と同時にリリースされました。',Mr,Ye,Na="このライブラリは、XNLI データをロードするプロセッサをホストします。",wr,Ae,Ba="<li><code>~data.processors.utils.XnliProcessor</code></li>",Tr,Oe,Sa="テストセットにはゴールドラベルが付いているため、評価はテストセットで行われますのでご了承ください。",Cr,Ke,Da='これらのプロセッサを使用する例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/text-classification/run_xnli.py" rel="nofollow">run_xnli.py</a> スクリプトに示されています。',Pr,et,jr,tt,Fa=`<a href="https://rajpurkar.github.io/SQuAD-explorer//" rel="nofollow">The Stanford Question Answering Dataset (SQuAD)</a> は、次のベンチマークです。
質問応答に関するモデルのパフォーマンスを評価します。 v1.1 と v2.0 の 2 つのバージョンが利用可能です。最初のバージョン
(v1.1) は、論文 <a href="https://arxiv.org/abs/1606.05250" rel="nofollow">SQuAD: 100,000+ question for Machine Comprehension of Text</a> とともにリリースされました。 2 番目のバージョン (v2.0) は、論文 <a href="https://arxiv.org/abs/1806.03822" rel="nofollow">Know What You Don’t と同時にリリースされました。
知っておくべき: SQuAD の答えられない質問</a>。`,Ir,rt,Ra="このライブラリは、次の 2 つのバージョンのそれぞれのプロセッサをホストします。",Xr,st,kr,at,Ga="それらのプロセッサは次のとおりです。",Jr,ot,Wa="<li><code>~data.processors.utils.SquadV1Processor</code></li> <li><code>~data.processors.utils.SquadV2Processor</code></li>",Ur,nt,Qa="どちらも抽象クラス <code>~data.processors.utils.SquadProcessor</code> を継承しています。",Lr,X,lt,Qs,Dt,Ya=`Processor for the SQuAD data set. overridden by SquadV1Processor and SquadV2Processor, used by the version 1.1 and
version 2.0 of SQuAD, respectively.`,Ys,ie,it,As,Ft,Aa="Returns the evaluation example from the data directory.",Os,E,dt,Ks,Rt,Oa="Creates a list of <code>SquadExample</code> using a TFDS dataset.",ea,de,ta,ce,ct,ra,Gt,Ka="Returns the training examples from the data directory.",Zr,mt,eo=`さらに、次のメソッドを使用して、SQuAD の例を次の形式に変換できます。
モデルの入力として使用できる <code>~data.processors.utils.SquadFeatures</code>。`,qr,L,pt,sa,Wt,to=`Converts a list of examples into a list of features that can be directly given as input to a model. It is
model-dependant and takes advantage of many of the tokenizer’s features to create the model’s inputs.`,aa,me,Vr,ft,ro=`これらのプロセッサと前述の方法は、データを含むファイルだけでなく、
<em>tensorflow_datasets</em> パッケージ。以下に例を示します。`,zr,ut,Er,ht,so="以下にプロセッサを使用した例と、データ ファイルを使用した変換方法を示します。",Hr,gt,Nr,_t,ao="<em>tensorflow_datasets</em> の使用は、データ ファイルを使用するのと同じくらい簡単です。",Br,vt,Sr,xt,oo='これらのプロセッサを使用する別の例は、<a href="https://github.com/huggingface/transformers/tree/main/examples/legacy/question-answering/run_squad.py" rel="nofollow">run_squad.py</a> スクリプトに示されています。',Dr,tr,Fr;return C=new pe({props:{title:"Processors",local:"processors",headingTag:"h1"}}),ue=new pe({props:{title:"Multi-modal processors",local:"transformers.ProcessorMixin",headingTag:"h2"}}),_e=new M({props:{name:"class transformers.ProcessorMixin",anchor:"transformers.ProcessorMixin",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L56"}}),ve=new M({props:{name:"from_args_and_dict",anchor:"transformers.ProcessorMixin.from_args_and_dict",parameters:[{name:"args",val:""},{name:"processor_dict",val:": Dict"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_args_and_dict.processor_dict",description:`<strong>processor_dict</strong> (<code>Dict[str, Any]</code>) &#x2014;
Dictionary that will be used to instantiate the processor object. Such a dictionary can be
retrieved from a pretrained checkpoint by leveraging the
<code>~processing_utils.ProcessingMixin.to_dict</code> method.`,name:"processor_dict"},{anchor:"transformers.ProcessorMixin.from_args_and_dict.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>) &#x2014;
Additional parameters from which to initialize the processor object.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L365",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The processor object instantiated from those
parameters.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~processing_utils.ProcessingMixin</code></p>
`}}),xe=new M({props:{name:"from_pretrained",anchor:"transformers.ProcessorMixin.from_pretrained",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"cache_dir",val:": Union = None"},{name:"force_download",val:": bool = False"},{name:"local_files_only",val:": bool = False"},{name:"token",val:": Union = None"},{name:"revision",val:": str = 'main'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.from_pretrained.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
This can be either:</p>
<ul>
<li>a string, the <em>model id</em> of a pretrained feature_extractor hosted inside a model repo on
huggingface.co.</li>
<li>a path to a <em>directory</em> containing a feature extractor file saved using the
<a href="/docs/transformers/v4.39.2/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.save_pretrained">save_pretrained()</a> method, e.g., <code>./my_model_directory/</code>.</li>
<li>a path or url to a saved feature extractor JSON <em>file</em>, e.g.,
<code>./my_model_directory/preprocessor_config.json</code>.
**kwargs &#x2014;
Additional keyword arguments passed along to both
<a href="/docs/transformers/v4.39.2/ja/main_classes/feature_extractor#transformers.FeatureExtractionMixin.from_pretrained">from_pretrained()</a> and
<code>~tokenization_utils_base.PreTrainedTokenizer.from_pretrained</code>.</li>
</ul>`,name:"pretrained_model_name_or_path"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L406"}}),R=new oa({props:{$$slots:{default:[po]},$$scope:{ctx:k}}}),$e=new M({props:{name:"get_processor_dict",anchor:"transformers.ProcessorMixin.get_processor_dict",parameters:[{name:"pretrained_model_name_or_path",val:": Union"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.get_processor_dict.pretrained_model_name_or_path",description:`<strong>pretrained_model_name_or_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The identifier of the pre-trained checkpoint from which we want the dictionary of parameters.`,name:"pretrained_model_name_or_path"},{anchor:"transformers.ProcessorMixin.get_processor_dict.subfolder",description:`<strong>subfolder</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&quot;</code>) &#x2014;
In case the relevant files are located inside a subfolder of the model repo on huggingface.co, you can
specify the folder name here.`,name:"subfolder"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L256",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The dictionary(ies) that will be used to instantiate the processor object.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Tuple[Dict, Dict]</code></p>
`}}),be=new M({props:{name:"push_to_hub",anchor:"transformers.ProcessorMixin.push_to_hub",parameters:[{name:"repo_id",val:": str"},{name:"use_temp_dir",val:": Optional = None"},{name:"commit_message",val:": Optional = None"},{name:"private",val:": Optional = None"},{name:"token",val:": Union = None"},{name:"max_shard_size",val:": Union = '5GB'"},{name:"create_pr",val:": bool = False"},{name:"safe_serialization",val:": bool = True"},{name:"revision",val:": str = None"},{name:"commit_description",val:": str = None"},{name:"tags",val:": Optional = None"},{name:"**deprecated_kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.push_to_hub.repo_id",description:`<strong>repo_id</strong> (<code>str</code>) &#x2014;
The name of the repository you want to push your processor to. It should contain your organization name
when pushing to a given organization.`,name:"repo_id"},{anchor:"transformers.ProcessorMixin.push_to_hub.use_temp_dir",description:`<strong>use_temp_dir</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to use a temporary directory to store the files saved before they are pushed to the Hub.
Will default to <code>True</code> if there is no directory named like <code>repo_id</code>, <code>False</code> otherwise.`,name:"use_temp_dir"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Message to commit while pushing. Will default to <code>&quot;Upload processor&quot;</code>.`,name:"commit_message"},{anchor:"transformers.ProcessorMixin.push_to_hub.private",description:`<strong>private</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not the repository created should be private.`,name:"private"},{anchor:"transformers.ProcessorMixin.push_to_hub.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
The token to use as HTTP bearer authorization for remote files. If <code>True</code>, will use the token generated
when running <code>huggingface-cli login</code> (stored in <code>~/.huggingface</code>). Will default to <code>True</code> if <code>repo_url</code>
is not specified.`,name:"token"},{anchor:"transformers.ProcessorMixin.push_to_hub.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;5GB&quot;</code>) &#x2014;
Only applicable for models. The maximum size for a checkpoint before being sharded. Checkpoints shard
will then be each of size lower than this size. If expressed as a string, needs to be digits followed
by a unit (like <code>&quot;5MB&quot;</code>). We default it to <code>&quot;5GB&quot;</code> so that users can easily load models on free-tier
Google Colab instances without any CPU OOM issues.`,name:"max_shard_size"},{anchor:"transformers.ProcessorMixin.push_to_hub.create_pr",description:`<strong>create_pr</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to create a PR with the uploaded files or directly commit.`,name:"create_pr"},{anchor:"transformers.ProcessorMixin.push_to_hub.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to convert the model weights in safetensors format for safer serialization.`,name:"safe_serialization"},{anchor:"transformers.ProcessorMixin.push_to_hub.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Branch to push the uploaded files to.`,name:"revision"},{anchor:"transformers.ProcessorMixin.push_to_hub.commit_description",description:`<strong>commit_description</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The description of the commit that will be created`,name:"commit_description"},{anchor:"transformers.ProcessorMixin.push_to_hub.tags",description:`<strong>tags</strong> (<code>List[str]</code>, <em>optional</em>) &#x2014;
List of tags to push on the Hub.`,name:"tags"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/utils/hub.py#L768"}}),W=new na({props:{anchor:"transformers.ProcessorMixin.push_to_hub.example",$$slots:{default:[fo]},$$scope:{ctx:k}}}),ye=new M({props:{name:"register_for_auto_class",anchor:"transformers.ProcessorMixin.register_for_auto_class",parameters:[{name:"auto_class",val:" = 'AutoProcessor'"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.register_for_auto_class.auto_class",description:`<strong>auto_class</strong> (<code>str</code> or <code>type</code>, <em>optional</em>, defaults to <code>&quot;AutoProcessor&quot;</code>) &#x2014;
The auto class to register this new feature extractor with.`,name:"auto_class"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L470"}}),Q=new oa({props:{warning:!0,$$slots:{default:[uo]},$$scope:{ctx:k}}}),Me=new M({props:{name:"save_pretrained",anchor:"transformers.ProcessorMixin.save_pretrained",parameters:[{name:"save_directory",val:""},{name:"push_to_hub",val:": bool = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.ProcessorMixin.save_pretrained.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory where the feature extractor JSON file and the tokenizer files will be saved (directory will
be created if it does not exist).`,name:"save_directory"},{anchor:"transformers.ProcessorMixin.save_pretrained.push_to_hub",description:`<strong>push_to_hub</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to push your model to the Hugging Face model hub after saving it. You can specify the
repository you want to push to with <code>repo_id</code> (will default to the name of <code>save_directory</code> in your
namespace).`,name:"push_to_hub"},{anchor:"transformers.ProcessorMixin.save_pretrained.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Additional key word arguments passed along to the <a href="/docs/transformers/v4.39.2/ja/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.push_to_hub">push_to_hub()</a> method.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L167"}}),Y=new oa({props:{$$slots:{default:[ho]},$$scope:{ctx:k}}}),we=new M({props:{name:"to_dict",anchor:"transformers.ProcessorMixin.to_dict",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L102",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Dictionary of all the attributes that make up this processor instance.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>Dict[str, Any]</code></p>
`}}),Te=new M({props:{name:"to_json_file",anchor:"transformers.ProcessorMixin.to_json_file",parameters:[{name:"json_file_path",val:": Union"}],parametersDescription:[{anchor:"transformers.ProcessorMixin.to_json_file.json_file_path",description:`<strong>json_file_path</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Path to the JSON file in which this processor instance&#x2019;s parameters will be saved.`,name:"json_file_path"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L151"}}),Ce=new M({props:{name:"to_json_string",anchor:"transformers.ProcessorMixin.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/processing_utils.py#L140",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>String containing all the attributes that make up this feature_extractor instance in JSON format.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>str</code></p>
`}}),Pe=new pe({props:{title:"Deprecated processors",local:"transformers.DataProcessor",headingTag:"h2"}}),Ie=new M({props:{name:"class transformers.DataProcessor",anchor:"transformers.DataProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L80"}}),Xe=new M({props:{name:"get_dev_examples",anchor:"transformers.DataProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L97"}}),ke=new M({props:{name:"get_example_from_tensor_dict",anchor:"transformers.DataProcessor.get_example_from_tensor_dict",parameters:[{name:"tensor_dict",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L83"}}),Je=new M({props:{name:"get_labels",anchor:"transformers.DataProcessor.get_labels",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L105"}}),Ue=new M({props:{name:"get_test_examples",anchor:"transformers.DataProcessor.get_test_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L101"}}),Le=new M({props:{name:"get_train_examples",anchor:"transformers.DataProcessor.get_train_examples",parameters:[{name:"data_dir",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L93"}}),Ze=new M({props:{name:"tfds_map",anchor:"transformers.DataProcessor.tfds_map",parameters:[{name:"example",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L109"}}),qe=new M({props:{name:"class transformers.InputExample",anchor:"transformers.InputExample",parameters:[{name:"guid",val:": str"},{name:"text_a",val:": str"},{name:"text_b",val:": Optional = None"},{name:"label",val:": Optional = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L29"}}),Ve=new M({props:{name:"to_json_string",anchor:"transformers.InputExample.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L49"}}),ze=new M({props:{name:"class transformers.InputFeatures",anchor:"transformers.InputFeatures",parameters:[{name:"input_ids",val:": List"},{name:"attention_mask",val:": Optional = None"},{name:"token_type_ids",val:": Optional = None"},{name:"label",val:": Union = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L54"}}),Ee=new M({props:{name:"to_json_string",anchor:"transformers.InputFeatures.to_json_string",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/utils.py#L75"}}),He=new pe({props:{title:"GLUE",local:"transformers.glue_convert_examples_to_features",headingTag:"h2"}}),Re=new M({props:{name:"transformers.glue_convert_examples_to_features",anchor:"transformers.glue_convert_examples_to_features",parameters:[{name:"examples",val:": Union"},{name:"tokenizer",val:": PreTrainedTokenizer"},{name:"max_length",val:": Optional = None"},{name:"task",val:" = None"},{name:"label_list",val:" = None"},{name:"output_mode",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/glue.py#L41",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If the <code>examples</code> input is a <code>tf.data.Dataset</code>, will return a <code>tf.data.Dataset</code> containing the task-specific
features. If the input is a list of <code>InputExamples</code>, will return a list of task-specific <code>InputFeatures</code> which
can be fed to the model.</p>
`}}),Ge=new pe({props:{title:"XNLI",local:"xnli",headingTag:"h2"}}),et=new pe({props:{title:"SQuAD",local:"squad",headingTag:"h2"}}),st=new pe({props:{title:"Processors",local:"transformers.data.processors.squad.SquadProcessor",headingTag:"h3"}}),lt=new M({props:{name:"class transformers.data.processors.squad.SquadProcessor",anchor:"transformers.data.processors.squad.SquadProcessor",parameters:[],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/squad.py#L541"}}),it=new M({props:{name:"get_dev_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_dev_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/squad.py#L629"}}),dt=new M({props:{name:"get_examples_from_dataset",anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset",parameters:[{name:"dataset",val:""},{name:"evaluate",val:" = False"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/squad.py#L574",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of SquadExample</p>
`}}),de=new na({props:{anchor:"transformers.data.processors.squad.SquadProcessor.get_examples_from_dataset.example",$$slots:{default:[go]},$$scope:{ctx:k}}}),ct=new M({props:{name:"get_train_examples",anchor:"transformers.data.processors.squad.SquadProcessor.get_train_examples",parameters:[{name:"data_dir",val:""},{name:"filename",val:" = None"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/squad.py#L607"}}),pt=new M({props:{name:"transformers.squad_convert_examples_to_features",anchor:"transformers.squad_convert_examples_to_features",parameters:[{name:"examples",val:""},{name:"tokenizer",val:""},{name:"max_seq_length",val:""},{name:"doc_stride",val:""},{name:"max_query_length",val:""},{name:"is_training",val:""},{name:"padding_strategy",val:" = 'max_length'"},{name:"return_dataset",val:" = False"},{name:"threads",val:" = 1"},{name:"tqdm_enabled",val:" = True"}],source:"https://github.com/huggingface/transformers/blob/v4.39.2/src/transformers/data/processors/squad.py#L316",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>list of <code>SquadFeatures</code></p>
`}}),me=new na({props:{anchor:"transformers.squad_convert_examples_to_features.example",$$slots:{default:[_o]},$$scope:{ctx:k}}}),ut=new pe({props:{title:"Example usage",local:"example-usage",headingTag:"h3"}}),gt=new rr({props:{code:"JTIzJTIwTG9hZGluZyUyMGElMjBWMiUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjJQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjJfZGF0YV9kaXIpJTBBJTBBJTIzJTIwTG9hZGluZyUyMGElMjBWMSUyMHByb2Nlc3NvciUwQXByb2Nlc3NvciUyMCUzRCUyMFNxdWFkVjFQcm9jZXNzb3IoKSUwQWV4YW1wbGVzJTIwJTNEJTIwcHJvY2Vzc29yLmdldF9kZXZfZXhhbXBsZXMoc3F1YWRfdjFfZGF0YV9kaXIpJTBBJTBBZmVhdHVyZXMlMjAlM0QlMjBzcXVhZF9jb252ZXJ0X2V4YW1wbGVzX3RvX2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEZXhhbXBsZXMlMkMlMEElMjAlMjAlMjAlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIlMkMlMEElMjAlMjAlMjAlMjBtYXhfc2VxX2xlbmd0aCUzRG1heF9zZXFfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwZG9jX3N0cmlkZSUzRGFyZ3MuZG9jX3N0cmlkZSUyQyUwQSUyMCUyMCUyMCUyMG1heF9xdWVyeV9sZW5ndGglM0RtYXhfcXVlcnlfbGVuZ3RoJTJDJTBBJTIwJTIwJTIwJTIwaXNfdHJhaW5pbmclM0Rub3QlMjBldmFsdWF0ZSUyQyUwQSk=",highlighted:`<span class="hljs-comment"># Loading a V2 processor</span>
processor = SquadV2Processor()
examples = processor.get_dev_examples(squad_v2_data_dir)

<span class="hljs-comment"># Loading a V1 processor</span>
processor = SquadV1Processor()
examples = processor.get_dev_examples(squad_v1_data_dir)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),vt=new rr({props:{code:"JTIzJTIwdGVuc29yZmxvd19kYXRhc2V0cyUyMG9ubHklMjBoYW5kbGUlMjBTcXVhZCUyMFYxLiUwQXRmZHNfZXhhbXBsZXMlMjAlM0QlMjB0ZmRzLmxvYWQoJTIyc3F1YWQlMjIpJTBBZXhhbXBsZXMlMjAlM0QlMjBTcXVhZFYxUHJvY2Vzc29yKCkuZ2V0X2V4YW1wbGVzX2Zyb21fZGF0YXNldCh0ZmRzX2V4YW1wbGVzJTJDJTIwZXZhbHVhdGUlM0RldmFsdWF0ZSklMEElMEFmZWF0dXJlcyUyMCUzRCUyMHNxdWFkX2NvbnZlcnRfZXhhbXBsZXNfdG9fZmVhdHVyZXMoJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlM0RleGFtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMG1heF9zZXFfbGVuZ3RoJTNEbWF4X3NlcV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBkb2Nfc3RyaWRlJTNEYXJncy5kb2Nfc3RyaWRlJTJDJTBBJTIwJTIwJTIwJTIwbWF4X3F1ZXJ5X2xlbmd0aCUzRG1heF9xdWVyeV9sZW5ndGglMkMlMEElMjAlMjAlMjAlMjBpc190cmFpbmluZyUzRG5vdCUyMGV2YWx1YXRlJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># tensorflow_datasets only handle Squad V1.</span>
tfds_examples = tfds.load(<span class="hljs-string">&quot;squad&quot;</span>)
examples = SquadV1Processor().get_examples_from_dataset(tfds_examples, evaluate=evaluate)

features = squad_convert_examples_to_features(
    examples=examples,
    tokenizer=tokenizer,
    max_seq_length=max_seq_length,
    doc_stride=args.doc_stride,
    max_query_length=max_query_length,
    is_training=<span class="hljs-keyword">not</span> evaluate,
)`,wrap:!1}}),{c(){c=n("meta"),T=a(),v=n("p"),x=a(),p(C.$$.fragment),m=a(),j=n("p"),j.textContent=la,sr=a(),fe=n("ul"),fe.innerHTML=ia,ar=a(),p(ue.$$.fragment),or=a(),he=n("p"),he.textContent=da,nr=a(),ge=n("p"),ge.textContent=ca,lr=a(),y=n("div"),p(_e.$$.fragment),ns=a(),yt=n("p"),yt.textContent=ma,ls=a(),F=n("div"),p(ve.$$.fragment),is=a(),Mt=n("p"),Mt.innerHTML=pa,ds=a(),Z=n("div"),p(xe.$$.fragment),cs=a(),wt=n("p"),wt.textContent=fa,ms=a(),p(R.$$.fragment),ps=a(),G=n("div"),p($e.$$.fragment),fs=a(),Tt=n("p"),Tt.innerHTML=ua,us=a(),q=n("div"),p(be.$$.fragment),hs=a(),Ct=n("p"),Ct.textContent=ha,gs=a(),p(W.$$.fragment),_s=a(),V=n("div"),p(ye.$$.fragment),vs=a(),Pt=n("p"),Pt.innerHTML=ga,xs=a(),p(Q.$$.fragment),$s=a(),z=n("div"),p(Me.$$.fragment),bs=a(),jt=n("p"),jt.innerHTML=_a,ys=a(),p(Y.$$.fragment),Ms=a(),A=n("div"),p(we.$$.fragment),ws=a(),It=n("p"),It.textContent=va,Ts=a(),O=n("div"),p(Te.$$.fragment),Cs=a(),Xt=n("p"),Xt.textContent=xa,Ps=a(),K=n("div"),p(Ce.$$.fragment),js=a(),kt=n("p"),kt.textContent=$a,ir=a(),p(Pe.$$.fragment),dr=a(),je=n("p"),je.innerHTML=ba,cr=a(),P=n("div"),p(Ie.$$.fragment),Is=a(),Jt=n("p"),Jt.textContent=ya,Xs=a(),ee=n("div"),p(Xe.$$.fragment),ks=a(),Ut=n("p"),Ut.innerHTML=Ma,Js=a(),te=n("div"),p(ke.$$.fragment),Us=a(),Lt=n("p"),Lt.textContent=wa,Ls=a(),re=n("div"),p(Je.$$.fragment),Zs=a(),Zt=n("p"),Zt.textContent=Ta,qs=a(),se=n("div"),p(Ue.$$.fragment),Vs=a(),qt=n("p"),qt.innerHTML=Ca,zs=a(),ae=n("div"),p(Le.$$.fragment),Es=a(),Vt=n("p"),Vt.innerHTML=Pa,Hs=a(),oe=n("div"),p(Ze.$$.fragment),Ns=a(),zt=n("p"),zt.textContent=ja,mr=a(),J=n("div"),p(qe.$$.fragment),Bs=a(),Et=n("p"),Et.textContent=Ia,Ss=a(),ne=n("div"),p(Ve.$$.fragment),Ds=a(),Ht=n("p"),Ht.textContent=Xa,pr=a(),U=n("div"),p(ze.$$.fragment),Fs=a(),Nt=n("p"),Nt.textContent=ka,Rs=a(),le=n("div"),p(Ee.$$.fragment),Gs=a(),Bt=n("p"),Bt.textContent=Ja,fr=a(),p(He.$$.fragment),ur=a(),Ne=n("p"),Ne.innerHTML=Ua,hr=a(),Be=n("p"),Be.textContent=La,gr=a(),Se=n("p"),Se.textContent=Za,_r=a(),De=n("ul"),De.innerHTML=qa,vr=a(),Fe=n("p"),Fe.innerHTML=Va,xr=a(),N=n("div"),p(Re.$$.fragment),Ws=a(),St=n("p"),St.innerHTML=za,$r=a(),p(Ge.$$.fragment),br=a(),We=n("p"),We.innerHTML=Ea,yr=a(),Qe=n("p"),Qe.innerHTML=Ha,Mr=a(),Ye=n("p"),Ye.textContent=Na,wr=a(),Ae=n("ul"),Ae.innerHTML=Ba,Tr=a(),Oe=n("p"),Oe.textContent=Sa,Cr=a(),Ke=n("p"),Ke.innerHTML=Da,Pr=a(),p(et.$$.fragment),jr=a(),tt=n("p"),tt.innerHTML=Fa,Ir=a(),rt=n("p"),rt.textContent=Ra,Xr=a(),p(st.$$.fragment),kr=a(),at=n("p"),at.textContent=Ga,Jr=a(),ot=n("ul"),ot.innerHTML=Wa,Ur=a(),nt=n("p"),nt.innerHTML=Qa,Lr=a(),X=n("div"),p(lt.$$.fragment),Qs=a(),Dt=n("p"),Dt.textContent=Ya,Ys=a(),ie=n("div"),p(it.$$.fragment),As=a(),Ft=n("p"),Ft.textContent=Aa,Os=a(),E=n("div"),p(dt.$$.fragment),Ks=a(),Rt=n("p"),Rt.innerHTML=Oa,ea=a(),p(de.$$.fragment),ta=a(),ce=n("div"),p(ct.$$.fragment),ra=a(),Gt=n("p"),Gt.textContent=Ka,Zr=a(),mt=n("p"),mt.innerHTML=eo,qr=a(),L=n("div"),p(pt.$$.fragment),sa=a(),Wt=n("p"),Wt.textContent=to,aa=a(),p(me.$$.fragment),Vr=a(),ft=n("p"),ft.innerHTML=ro,zr=a(),p(ut.$$.fragment),Er=a(),ht=n("p"),ht.textContent=so,Hr=a(),p(gt.$$.fragment),Nr=a(),_t=n("p"),_t.innerHTML=ao,Br=a(),p(vt.$$.fragment),Sr=a(),xt=n("p"),xt.innerHTML=oo,Dr=a(),tr=n("p"),this.h()},l(e){const r=mo("svelte-u9bgzb",document.head);c=l(r,"META",{name:!0,content:!0}),r.forEach(t),T=o(e),v=l(e,"P",{}),$(v).forEach(t),x=o(e),f(C.$$.fragment,e),m=o(e),j=l(e,"P",{"data-svelte-h":!0}),d(j)!=="svelte-4gs895"&&(j.textContent=la),sr=o(e),fe=l(e,"UL",{"data-svelte-h":!0}),d(fe)!=="svelte-1h23xz2"&&(fe.innerHTML=ia),ar=o(e),f(ue.$$.fragment,e),or=o(e),he=l(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-hbbv64"&&(he.textContent=da),nr=o(e),ge=l(e,"P",{"data-svelte-h":!0}),d(ge)!=="svelte-t565jj"&&(ge.textContent=ca),lr=o(e),y=l(e,"DIV",{class:!0});var w=$(y);f(_e.$$.fragment,w),ns=o(w),yt=l(w,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-1s4wckx"&&(yt.textContent=ma),ls=o(w),F=l(w,"DIV",{class:!0});var $t=$(F);f(ve.$$.fragment,$t),is=o($t),Mt=l($t,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-1i2d3vx"&&(Mt.innerHTML=pa),$t.forEach(t),ds=o(w),Z=l(w,"DIV",{class:!0});var B=$(Z);f(xe.$$.fragment,B),cs=o(B),wt=l(B,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1cj8dcb"&&(wt.textContent=fa),ms=o(B),f(R.$$.fragment,B),B.forEach(t),ps=o(w),G=l(w,"DIV",{class:!0});var bt=$(G);f($e.$$.fragment,bt),fs=o(bt),Tt=l(bt,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-hsvutq"&&(Tt.innerHTML=ua),bt.forEach(t),us=o(w),q=l(w,"DIV",{class:!0});var S=$(q);f(be.$$.fragment,S),hs=o(S),Ct=l(S,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-1cwsjho"&&(Ct.textContent=ha),gs=o(S),f(W.$$.fragment,S),S.forEach(t),_s=o(w),V=l(w,"DIV",{class:!0});var D=$(V);f(ye.$$.fragment,D),vs=o(D),Pt=l(D,"P",{"data-svelte-h":!0}),d(Pt)!=="svelte-hhsvto"&&(Pt.innerHTML=ga),xs=o(D),f(Q.$$.fragment,D),D.forEach(t),$s=o(w),z=l(w,"DIV",{class:!0});var Qt=$(z);f(Me.$$.fragment,Qt),bs=o(Qt),jt=l(Qt,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-11v7ovq"&&(jt.innerHTML=_a),ys=o(Qt),f(Y.$$.fragment,Qt),Qt.forEach(t),Ms=o(w),A=l(w,"DIV",{class:!0});var Rr=$(A);f(we.$$.fragment,Rr),ws=o(Rr),It=l(Rr,"P",{"data-svelte-h":!0}),d(It)!=="svelte-1ww3wqq"&&(It.textContent=va),Rr.forEach(t),Ts=o(w),O=l(w,"DIV",{class:!0});var Gr=$(O);f(Te.$$.fragment,Gr),Cs=o(Gr),Xt=l(Gr,"P",{"data-svelte-h":!0}),d(Xt)!=="svelte-1g70y32"&&(Xt.textContent=xa),Gr.forEach(t),Ps=o(w),K=l(w,"DIV",{class:!0});var Wr=$(K);f(Ce.$$.fragment,Wr),js=o(Wr),kt=l(Wr,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-5ayq1f"&&(kt.textContent=$a),Wr.forEach(t),w.forEach(t),ir=o(e),f(Pe.$$.fragment,e),dr=o(e),je=l(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-iyi124"&&(je.innerHTML=ba),cr=o(e),P=l(e,"DIV",{class:!0});var I=$(P);f(Ie.$$.fragment,I),Is=o(I),Jt=l(I,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-1bsw04k"&&(Jt.textContent=ya),Xs=o(I),ee=l(I,"DIV",{class:!0});var Qr=$(ee);f(Xe.$$.fragment,Qr),ks=o(Qr),Ut=l(Qr,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-1d5iijt"&&(Ut.innerHTML=Ma),Qr.forEach(t),Js=o(I),te=l(I,"DIV",{class:!0});var Yr=$(te);f(ke.$$.fragment,Yr),Us=o(Yr),Lt=l(Yr,"P",{"data-svelte-h":!0}),d(Lt)!=="svelte-pplryq"&&(Lt.textContent=wa),Yr.forEach(t),Ls=o(I),re=l(I,"DIV",{class:!0});var Ar=$(re);f(Je.$$.fragment,Ar),Zs=o(Ar),Zt=l(Ar,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-3oqyjr"&&(Zt.textContent=Ta),Ar.forEach(t),qs=o(I),se=l(I,"DIV",{class:!0});var Or=$(se);f(Ue.$$.fragment,Or),Vs=o(Or),qt=l(Or,"P",{"data-svelte-h":!0}),d(qt)!=="svelte-okjgeo"&&(qt.innerHTML=Ca),Or.forEach(t),zs=o(I),ae=l(I,"DIV",{class:!0});var Kr=$(ae);f(Le.$$.fragment,Kr),Es=o(Kr),Vt=l(Kr,"P",{"data-svelte-h":!0}),d(Vt)!=="svelte-nggtpu"&&(Vt.innerHTML=Pa),Kr.forEach(t),Hs=o(I),oe=l(I,"DIV",{class:!0});var es=$(oe);f(Ze.$$.fragment,es),Ns=o(es),zt=l(es,"P",{"data-svelte-h":!0}),d(zt)!=="svelte-1jevh15"&&(zt.textContent=ja),es.forEach(t),I.forEach(t),mr=o(e),J=l(e,"DIV",{class:!0});var Yt=$(J);f(qe.$$.fragment,Yt),Bs=o(Yt),Et=l(Yt,"P",{"data-svelte-h":!0}),d(Et)!=="svelte-vkt0pi"&&(Et.textContent=Ia),Ss=o(Yt),ne=l(Yt,"DIV",{class:!0});var ts=$(ne);f(Ve.$$.fragment,ts),Ds=o(ts),Ht=l(ts,"P",{"data-svelte-h":!0}),d(Ht)!=="svelte-5ayq1f"&&(Ht.textContent=Xa),ts.forEach(t),Yt.forEach(t),pr=o(e),U=l(e,"DIV",{class:!0});var At=$(U);f(ze.$$.fragment,At),Fs=o(At),Nt=l(At,"P",{"data-svelte-h":!0}),d(Nt)!=="svelte-168wf64"&&(Nt.textContent=ka),Rs=o(At),le=l(At,"DIV",{class:!0});var rs=$(le);f(Ee.$$.fragment,rs),Gs=o(rs),Bt=l(rs,"P",{"data-svelte-h":!0}),d(Bt)!=="svelte-5ayq1f"&&(Bt.textContent=Ja),rs.forEach(t),At.forEach(t),fr=o(e),f(He.$$.fragment,e),ur=o(e),Ne=l(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-dz9ydi"&&(Ne.innerHTML=Ua),hr=o(e),Be=l(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-1lukeag"&&(Be.textContent=La),gr=o(e),Se=l(e,"P",{"data-svelte-h":!0}),d(Se)!=="svelte-w2nqkz"&&(Se.textContent=Za),_r=o(e),De=l(e,"UL",{"data-svelte-h":!0}),d(De)!=="svelte-my8qym"&&(De.innerHTML=qa),vr=o(e),Fe=l(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-1vuhg2e"&&(Fe.innerHTML=Va),xr=o(e),N=l(e,"DIV",{class:!0});var ss=$(N);f(Re.$$.fragment,ss),Ws=o(ss),St=l(ss,"P",{"data-svelte-h":!0}),d(St)!=="svelte-5lvrve"&&(St.innerHTML=za),ss.forEach(t),$r=o(e),f(Ge.$$.fragment,e),br=o(e),We=l(e,"P",{"data-svelte-h":!0}),d(We)!=="svelte-1cfncyx"&&(We.innerHTML=Ea),yr=o(e),Qe=l(e,"P",{"data-svelte-h":!0}),d(Qe)!=="svelte-10048a6"&&(Qe.innerHTML=Ha),Mr=o(e),Ye=l(e,"P",{"data-svelte-h":!0}),d(Ye)!=="svelte-1z0bn35"&&(Ye.textContent=Na),wr=o(e),Ae=l(e,"UL",{"data-svelte-h":!0}),d(Ae)!=="svelte-1e2xq99"&&(Ae.innerHTML=Ba),Tr=o(e),Oe=l(e,"P",{"data-svelte-h":!0}),d(Oe)!=="svelte-1d3nf11"&&(Oe.textContent=Sa),Cr=o(e),Ke=l(e,"P",{"data-svelte-h":!0}),d(Ke)!=="svelte-7zvs7i"&&(Ke.innerHTML=Da),Pr=o(e),f(et.$$.fragment,e),jr=o(e),tt=l(e,"P",{"data-svelte-h":!0}),d(tt)!=="svelte-5cjvlv"&&(tt.innerHTML=Fa),Ir=o(e),rt=l(e,"P",{"data-svelte-h":!0}),d(rt)!=="svelte-10uynke"&&(rt.textContent=Ra),Xr=o(e),f(st.$$.fragment,e),kr=o(e),at=l(e,"P",{"data-svelte-h":!0}),d(at)!=="svelte-w2nqkz"&&(at.textContent=Ga),Jr=o(e),ot=l(e,"UL",{"data-svelte-h":!0}),d(ot)!=="svelte-1qiv3qf"&&(ot.innerHTML=Wa),Ur=o(e),nt=l(e,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-ii491f"&&(nt.innerHTML=Qa),Lr=o(e),X=l(e,"DIV",{class:!0});var H=$(X);f(lt.$$.fragment,H),Qs=o(H),Dt=l(H,"P",{"data-svelte-h":!0}),d(Dt)!=="svelte-173gxyd"&&(Dt.textContent=Ya),Ys=o(H),ie=l(H,"DIV",{class:!0});var as=$(ie);f(it.$$.fragment,as),As=o(as),Ft=l(as,"P",{"data-svelte-h":!0}),d(Ft)!=="svelte-wmaktk"&&(Ft.textContent=Aa),as.forEach(t),Os=o(H),E=l(H,"DIV",{class:!0});var Ot=$(E);f(dt.$$.fragment,Ot),Ks=o(Ot),Rt=l(Ot,"P",{"data-svelte-h":!0}),d(Rt)!=="svelte-11nqnea"&&(Rt.innerHTML=Oa),ea=o(Ot),f(de.$$.fragment,Ot),Ot.forEach(t),ta=o(H),ce=l(H,"DIV",{class:!0});var os=$(ce);f(ct.$$.fragment,os),ra=o(os),Gt=l(os,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-d5zv1x"&&(Gt.textContent=Ka),os.forEach(t),H.forEach(t),Zr=o(e),mt=l(e,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-18mz77q"&&(mt.innerHTML=eo),qr=o(e),L=l(e,"DIV",{class:!0});var Kt=$(L);f(pt.$$.fragment,Kt),sa=o(Kt),Wt=l(Kt,"P",{"data-svelte-h":!0}),d(Wt)!=="svelte-169nh0g"&&(Wt.textContent=to),aa=o(Kt),f(me.$$.fragment,Kt),Kt.forEach(t),Vr=o(e),ft=l(e,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1esudax"&&(ft.innerHTML=ro),zr=o(e),f(ut.$$.fragment,e),Er=o(e),ht=l(e,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-3glna9"&&(ht.textContent=so),Hr=o(e),f(gt.$$.fragment,e),Nr=o(e),_t=l(e,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-jzuhjq"&&(_t.innerHTML=ao),Br=o(e),f(vt.$$.fragment,e),Sr=o(e),xt=l(e,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-fac3c8"&&(xt.innerHTML=oo),Dr=o(e),tr=l(e,"P",{}),$(tr).forEach(t),this.h()},h(){b(c,"name","hf:doc:metadata"),b(c,"content",xo),b(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),b(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,r){s(document.head,c),i(e,T,r),i(e,v,r),i(e,x,r),u(C,e,r),i(e,m,r),i(e,j,r),i(e,sr,r),i(e,fe,r),i(e,ar,r),u(ue,e,r),i(e,or,r),i(e,he,r),i(e,nr,r),i(e,ge,r),i(e,lr,r),i(e,y,r),u(_e,y,null),s(y,ns),s(y,yt),s(y,ls),s(y,F),u(ve,F,null),s(F,is),s(F,Mt),s(y,ds),s(y,Z),u(xe,Z,null),s(Z,cs),s(Z,wt),s(Z,ms),u(R,Z,null),s(y,ps),s(y,G),u($e,G,null),s(G,fs),s(G,Tt),s(y,us),s(y,q),u(be,q,null),s(q,hs),s(q,Ct),s(q,gs),u(W,q,null),s(y,_s),s(y,V),u(ye,V,null),s(V,vs),s(V,Pt),s(V,xs),u(Q,V,null),s(y,$s),s(y,z),u(Me,z,null),s(z,bs),s(z,jt),s(z,ys),u(Y,z,null),s(y,Ms),s(y,A),u(we,A,null),s(A,ws),s(A,It),s(y,Ts),s(y,O),u(Te,O,null),s(O,Cs),s(O,Xt),s(y,Ps),s(y,K),u(Ce,K,null),s(K,js),s(K,kt),i(e,ir,r),u(Pe,e,r),i(e,dr,r),i(e,je,r),i(e,cr,r),i(e,P,r),u(Ie,P,null),s(P,Is),s(P,Jt),s(P,Xs),s(P,ee),u(Xe,ee,null),s(ee,ks),s(ee,Ut),s(P,Js),s(P,te),u(ke,te,null),s(te,Us),s(te,Lt),s(P,Ls),s(P,re),u(Je,re,null),s(re,Zs),s(re,Zt),s(P,qs),s(P,se),u(Ue,se,null),s(se,Vs),s(se,qt),s(P,zs),s(P,ae),u(Le,ae,null),s(ae,Es),s(ae,Vt),s(P,Hs),s(P,oe),u(Ze,oe,null),s(oe,Ns),s(oe,zt),i(e,mr,r),i(e,J,r),u(qe,J,null),s(J,Bs),s(J,Et),s(J,Ss),s(J,ne),u(Ve,ne,null),s(ne,Ds),s(ne,Ht),i(e,pr,r),i(e,U,r),u(ze,U,null),s(U,Fs),s(U,Nt),s(U,Rs),s(U,le),u(Ee,le,null),s(le,Gs),s(le,Bt),i(e,fr,r),u(He,e,r),i(e,ur,r),i(e,Ne,r),i(e,hr,r),i(e,Be,r),i(e,gr,r),i(e,Se,r),i(e,_r,r),i(e,De,r),i(e,vr,r),i(e,Fe,r),i(e,xr,r),i(e,N,r),u(Re,N,null),s(N,Ws),s(N,St),i(e,$r,r),u(Ge,e,r),i(e,br,r),i(e,We,r),i(e,yr,r),i(e,Qe,r),i(e,Mr,r),i(e,Ye,r),i(e,wr,r),i(e,Ae,r),i(e,Tr,r),i(e,Oe,r),i(e,Cr,r),i(e,Ke,r),i(e,Pr,r),u(et,e,r),i(e,jr,r),i(e,tt,r),i(e,Ir,r),i(e,rt,r),i(e,Xr,r),u(st,e,r),i(e,kr,r),i(e,at,r),i(e,Jr,r),i(e,ot,r),i(e,Ur,r),i(e,nt,r),i(e,Lr,r),i(e,X,r),u(lt,X,null),s(X,Qs),s(X,Dt),s(X,Ys),s(X,ie),u(it,ie,null),s(ie,As),s(ie,Ft),s(X,Os),s(X,E),u(dt,E,null),s(E,Ks),s(E,Rt),s(E,ea),u(de,E,null),s(X,ta),s(X,ce),u(ct,ce,null),s(ce,ra),s(ce,Gt),i(e,Zr,r),i(e,mt,r),i(e,qr,r),i(e,L,r),u(pt,L,null),s(L,sa),s(L,Wt),s(L,aa),u(me,L,null),i(e,Vr,r),i(e,ft,r),i(e,zr,r),u(ut,e,r),i(e,Er,r),i(e,ht,r),i(e,Hr,r),u(gt,e,r),i(e,Nr,r),i(e,_t,r),i(e,Br,r),u(vt,e,r),i(e,Sr,r),i(e,xt,r),i(e,Dr,r),i(e,tr,r),Fr=!0},p(e,[r]){const w={};r&2&&(w.$$scope={dirty:r,ctx:e}),R.$set(w);const $t={};r&2&&($t.$$scope={dirty:r,ctx:e}),W.$set($t);const B={};r&2&&(B.$$scope={dirty:r,ctx:e}),Q.$set(B);const bt={};r&2&&(bt.$$scope={dirty:r,ctx:e}),Y.$set(bt);const S={};r&2&&(S.$$scope={dirty:r,ctx:e}),de.$set(S);const D={};r&2&&(D.$$scope={dirty:r,ctx:e}),me.$set(D)},i(e){Fr||(h(C.$$.fragment,e),h(ue.$$.fragment,e),h(_e.$$.fragment,e),h(ve.$$.fragment,e),h(xe.$$.fragment,e),h(R.$$.fragment,e),h($e.$$.fragment,e),h(be.$$.fragment,e),h(W.$$.fragment,e),h(ye.$$.fragment,e),h(Q.$$.fragment,e),h(Me.$$.fragment,e),h(Y.$$.fragment,e),h(we.$$.fragment,e),h(Te.$$.fragment,e),h(Ce.$$.fragment,e),h(Pe.$$.fragment,e),h(Ie.$$.fragment,e),h(Xe.$$.fragment,e),h(ke.$$.fragment,e),h(Je.$$.fragment,e),h(Ue.$$.fragment,e),h(Le.$$.fragment,e),h(Ze.$$.fragment,e),h(qe.$$.fragment,e),h(Ve.$$.fragment,e),h(ze.$$.fragment,e),h(Ee.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(Ge.$$.fragment,e),h(et.$$.fragment,e),h(st.$$.fragment,e),h(lt.$$.fragment,e),h(it.$$.fragment,e),h(dt.$$.fragment,e),h(de.$$.fragment,e),h(ct.$$.fragment,e),h(pt.$$.fragment,e),h(me.$$.fragment,e),h(ut.$$.fragment,e),h(gt.$$.fragment,e),h(vt.$$.fragment,e),Fr=!0)},o(e){g(C.$$.fragment,e),g(ue.$$.fragment,e),g(_e.$$.fragment,e),g(ve.$$.fragment,e),g(xe.$$.fragment,e),g(R.$$.fragment,e),g($e.$$.fragment,e),g(be.$$.fragment,e),g(W.$$.fragment,e),g(ye.$$.fragment,e),g(Q.$$.fragment,e),g(Me.$$.fragment,e),g(Y.$$.fragment,e),g(we.$$.fragment,e),g(Te.$$.fragment,e),g(Ce.$$.fragment,e),g(Pe.$$.fragment,e),g(Ie.$$.fragment,e),g(Xe.$$.fragment,e),g(ke.$$.fragment,e),g(Je.$$.fragment,e),g(Ue.$$.fragment,e),g(Le.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ve.$$.fragment,e),g(ze.$$.fragment,e),g(Ee.$$.fragment,e),g(He.$$.fragment,e),g(Re.$$.fragment,e),g(Ge.$$.fragment,e),g(et.$$.fragment,e),g(st.$$.fragment,e),g(lt.$$.fragment,e),g(it.$$.fragment,e),g(dt.$$.fragment,e),g(de.$$.fragment,e),g(ct.$$.fragment,e),g(pt.$$.fragment,e),g(me.$$.fragment,e),g(ut.$$.fragment,e),g(gt.$$.fragment,e),g(vt.$$.fragment,e),Fr=!1},d(e){e&&(t(T),t(v),t(x),t(m),t(j),t(sr),t(fe),t(ar),t(or),t(he),t(nr),t(ge),t(lr),t(y),t(ir),t(dr),t(je),t(cr),t(P),t(mr),t(J),t(pr),t(U),t(fr),t(ur),t(Ne),t(hr),t(Be),t(gr),t(Se),t(_r),t(De),t(vr),t(Fe),t(xr),t(N),t($r),t(br),t(We),t(yr),t(Qe),t(Mr),t(Ye),t(wr),t(Ae),t(Tr),t(Oe),t(Cr),t(Ke),t(Pr),t(jr),t(tt),t(Ir),t(rt),t(Xr),t(kr),t(at),t(Jr),t(ot),t(Ur),t(nt),t(Lr),t(X),t(Zr),t(mt),t(qr),t(L),t(Vr),t(ft),t(zr),t(Er),t(ht),t(Hr),t(Nr),t(_t),t(Br),t(Sr),t(xt),t(Dr),t(tr)),t(c),_(C,e),_(ue,e),_(_e),_(ve),_(xe),_(R),_($e),_(be),_(W),_(ye),_(Q),_(Me),_(Y),_(we),_(Te),_(Ce),_(Pe,e),_(Ie),_(Xe),_(ke),_(Je),_(Ue),_(Le),_(Ze),_(qe),_(Ve),_(ze),_(Ee),_(He,e),_(Re),_(Ge,e),_(et,e),_(st,e),_(lt),_(it),_(dt),_(de),_(ct),_(pt),_(me),_(ut,e),_(gt,e),_(vt,e)}}}const xo='{"title":"Processors","local":"processors","sections":[{"title":"Multi-modal processors","local":"transformers.ProcessorMixin","sections":[],"depth":2},{"title":"Deprecated processors","local":"transformers.DataProcessor","sections":[],"depth":2},{"title":"GLUE","local":"transformers.glue_convert_examples_to_features","sections":[],"depth":2},{"title":"XNLI","local":"xnli","sections":[],"depth":2},{"title":"SQuAD","local":"squad","sections":[{"title":"Processors","local":"transformers.data.processors.squad.SquadProcessor","sections":[],"depth":3},{"title":"Example usage","local":"example-usage","sections":[],"depth":3}],"depth":2}],"depth":1}';function $o(k){return lo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jo extends io{constructor(c){super(),co(this,c,$o,vo,no,{})}}export{jo as component};
