import{s as Rs,o as As,n as Es}from"../chunks/scheduler.36a0863c.js";import{S as _s,i as Xs,g as o,s as t,r,A as Fs,h as p,f as l,c as n,j as Ws,u as c,x as i,k as Vs,y as Hs,a as s,v as d,d as m,t as M,w as u}from"../chunks/index.f891bdb2.js";import{T as Ys}from"../chunks/Tip.a8272f7f.js";import{C as y}from"../chunks/CodeBlock.3ec784ea.js";import{H as j}from"../chunks/Heading.3fb90772.js";function Ls(na){let J,h="Si estás ajustando finamente un modelo para chat, además de establecer una plantilla de chat, probablemente deberías agregar cualquier nuevo token de control de chat como los tokens especiales en el tokenizador. Los tokens especiales nunca se dividen, asegurando que tus tokens de control siempre se manejen como tokens únicos en lugar de ser tokenizados en piezas. También deberías establecer el atributo <code>eos_token</code> del tokenizador con el token que marca el final de las generaciones del asistente en tu plantilla. Esto asegurará que las herramientas de generación de texto puedan determinar correctamente cuándo detener la generación de texto.";return{c(){J=o("p"),J.innerHTML=h},l(T){J=p(T,"P",{"data-svelte-h":!0}),i(J)!=="svelte-jr3rxt"&&(J.innerHTML=h)},m(T,sa){s(T,J,sa)},p:Es,d(T){T&&l(J)}}}function Ds(na){let J,h,T,sa,g,oa,b,pa,I,_l=`Un caso de uso cada vez más común para LLMs es <strong>el chat</strong>. En un contexto de chat, en lugar de continuar una única cadena de texto (como es el caso con un modelo de lenguaje estándar), el modelo continúa una conversación que consta de uno o más <strong>mensajes</strong>, cada uno de los cuales incluye un <strong>rol</strong>, como “usuario” o “asistente”, así como el texto del mensaje.
Al igual que con la tokenización, diferentes modelos esperan formatos de entrada muy diferentes para el chat. Esta es la razón por la que agregamos las plantillas de chat como una característica. Las plantillas de chat son parte del tokenizador. Especifican cómo convertir conversaciones, representadas como listas de mensajes, en una única cadena tokenizable en el formato que el modelo espera.
Vamos a hacer esto con un ejemplo concreto utilizando el modelo <code>BlenderBot</code>. BlenderBot tiene una plantilla predeterminada extremadamente simple, que principalmente solo agrega espacios en blanco entre rondas de diálogo:`,ia,w,ra,f,Xl="Observa cómo todo el chat se condensa en una sola cadena. Si usamos <code>tokenize=True</code>, que es la configuración predeterminada, esa cadena también será tokenizada para nosotros. Sin embargo, para ver una plantilla más compleja en acción, usemos el modelo <code>mistralai/Mistral-7B-Instruct-v0.1</code>",ca,C,da,x,Fl="Ten en cuenta que esta vez, el tokenizador ha añadido los tokens de control [INST] y [/INST] para indicar el inicio y el final de los mensajes de usuario (¡pero no de los mensajes del asistente!). Mistral-instruct fue entrenado con estos tokens, pero BlenderBot no lo fue.",ma,N,Ma,Z,Hl='Como puedes ver en el ejemplo anterior, las plantillas de chat son fáciles de usar. Simplemente construye una lista de mensajes, con claves de <code>rol</code> y <code>contenido</code>, y luego pásala al método <code>apply_chat_template()</code>. Una vez que hagas eso, ¡obtendrás una salida lista para usar! Al utilizar plantillas de chat como entrada para la generación de modelos, también es una buena idea usar <code>add_generation_prompt=True</code> para agregar una <a href="#%C2%BFQu%C3%A9-son-los-%22generation-prompts%22?">indicación de generación</a>.',ua,G,Yl="Aquí tienes un ejemplo de cómo preparar la entrada para <code>model.generate()</code> utilizando el modelo de asistente <code>Zephyr</code>:",ya,$,Ja,v,Ll="Esto generará una cadena en el formato de entrada que Zephyr espera.",ja,Q,Ta,B,Dl="Ahora que nuestra entrada está formateada correctamente para Zephyr, podemos usar el modelo para generar una respuesta a la pregunta del usuario:",Ua,q,ha,z,Pl="Esto producirá:",ga,k,ba,S,Kl="¡Arr, al final resultó ser fácil!",Ia,W,wa,V,Ol="Sí, lo hay! Nuestros canales de generación de texto admiten entradas de chat, cual facilita más facíl utilizar los modelos de chat. En el pasado, solíamos utilizar una clase dedicada “ConversationalPipeline”, pero ahora ha quedado obsoleta y su funcionalidad se ha fusionado en <code>TextGenerationPipeline</code>. Este pipeline está diseñado para facilitar el uso de modelos de chat. Intentemos el ejemplo de <code>Zephyr</code> de nuevo, pero esta vez utilizando el pipeline:",fa,R,Ca,A,xa,E,es="La canalización se encargará de todos los detalles de la tokenización y de llamar a <code>apply_chat_template</code> por ti. Una vez que el modelo tenga una plantilla de chat, ¡todo lo que necesitas hacer es inicializar el pipeline y pasarle la lista de mensajes!",Na,_,Za,X,as="Puede que hayas notado que el método <code>apply_chat_template</code> tiene un argumento <code>add_generation_prompt</code>. Este argumento indica a la plantilla que agregue tokens que indiquen el inicio de una respuesta del bot. Por ejemplo, considera el siguiente chat:",Ga,F,$a,H,ls="Así es cómo se verá esto sin un “generation prompt”, usando la plantilla ChatML que vimos en el ejemplo de Zephyr:",va,Y,Qa,L,ss="Y así es como se ve <strong>con</strong> un “generation prompt”:",Ba,D,qa,P,ts="Ten en cuenta que esta vez, hemos agregado los tokens que indican el inicio de una respuesta del bot. Esto asegura que cuando el modelo genere texto, escribirá una respuesta del bot en lugar de hacer algo inesperado, como continuar el mensaje del usuario. Recuerda, los modelos de chat siguen siendo solo modelos de lenguaje: están entrenados para continuar texto, ¡y el chat es solo un tipo especial de texto para ellos! Necesitas guiarlos con los tokens de control apropiados para que sepan lo que se supone que deben estar haciendo.",za,K,ns="No todos los modelos requieren “generation prompts”. Algunos modelos, como BlenderBot y LLaMA, no tienen ningún token especial antes de las respuestas del bot. En estos casos, el argumento <code>add_generation_prompt</code> no tendrá ningún efecto. El efecto exacto que tiene <code>add_generation_prompt</code> dependerá de la plantilla que se esté utilizando.",ka,O,Sa,ee,os="¡Sí! Recomendamos que apliques la plantilla de chat como un paso de preprocesamiento para tu conjunto de datos. Después de esto, simplemente puedes continuar como cualquier otra tarea de entrenamiento de modelos de lenguaje. Durante el entrenamiento, generalmente deberías establecer <code>add_generation_prompt=False</code>, porque los tokens añadidos para solicitar una respuesta del asistente no serán útiles durante el entrenamiento. Veamos un ejemplo:",Wa,ae,Va,le,ps="Y obtenemos:",Ra,se,Aa,te,is="Desde aquí, simplemente continúa el entrenamiento como lo harías con una tarea estándar de modelado de lenguaje, utilizando la columna <code>formatted_chat</code>.",Ea,ne,_a,oe,rs="La plantilla de chat para un modelo se almacena en el atributo <code>tokenizer.chat_template</code>. Si no se establece ninguna plantilla de chat, se utiliza en su lugar la plantilla predeterminada para esa clase de modelo. Echemos un vistazo a la plantilla para <code>BlenderBot</code>:",Xa,pe,Fa,ie,cs="¡Es un poco intimidante! Vamos a agregar algunas líneas nuevas y sangria para que sea más legible. Ten en cuenta que la primera línea nueva después de cada bloque, así como cualquier espacio en blanco anterior a un bloque, se ignoran de forma predeterminada, utilizando las banderas <code>trim_blocks</code> y <code>lstrip_blocks</code> de Jinja. Sin embargo, ¡ten cuidado! Aunque el espacio en blanco inicial en cada línea se elimina, los espacios entre bloques en la misma línea no. ¡Te recomendamos encarecidamente que verifiques que tu plantilla no esté imprimiendo espacios adicionales donde no debería estarlo!",Ha,re,Ya,ce,ds='Si nunca has visto uno de estos antes, esto es una <a href="https://jinja.palletsprojects.com/en/3.1.x/templates/" rel="nofollow">plantilla de Jinja</a>. Jinja es un lenguaje de plantillas que te permite escribir código simple que genera texto. En muchos aspectos, el código y la sintaxis se asemejan a Python. En Python puro, esta plantilla se vería algo así:',La,de,Da,me,ms="Efectivamente, la plantilla hace tres cosas:",Pa,Me,Ms="<li>Para cada mensaje, si el mensaje es un mensaje de usuario, añade un espacio en blanco antes de él, de lo contrario no imprime nada.</li> <li>Añade el contenido del mensaje.</li> <li>Si el mensaje no es el último mensaje, añade dos espacios después de él. Después del último mensaje, imprime el token EOS.</li>",Ka,ue,us="Esta es una plantilla bastante simple: no añade ningún token de control y no admite mensajes “del sistema”, que son una forma común de dar al modelo directivas sobre cómo debe comportarse en la conversación posterior. ¡Pero Jinja te brinda mucha flexibilidad para hacer esas cosas! Veamos una plantilla de Jinja que pueda formatear las entradas de manera similar a la forma en que LLaMA las formatea (nota que la plantilla real de LLaMA incluye el manejo de mensajes del sistema predeterminados y el manejo de mensajes del sistema ligeramente diferentes en general; ¡no uses esta en tu código real!)",Oa,ye,el,Je,ys="Si observas esto por un momento, puedas ver lo que esta plantilla está haciendo: añade tokens específicos basados en el “rol” de cada mensaje, que representa quién lo envió. Los mensajes de usuario, asistente y sistema son claramente distinguibles para el modelo debido a los tokens en los que están envueltos.",al,je,ll,Te,sl,Ue,Js="Simple, solo escribe una plantilla de Jinja y establece <code>tokenizer.chat_template</code>. ¡Puede resultarte más fácil comenzar con una plantilla existente de otro modelo y simplemente editarla según tus necesidades! Por ejemplo, podríamos tomar la plantilla de LLaMA de arriba y añadir ”[ASST]” y ”[/ASST]” a los mensajes del asistente:",tl,he,nl,ge,js="Ahora, simplemente establece el atributo <code>tokenizer.chat_template</code>. ¡La próxima vez que uses <code>apply_chat_template()</code>, se utilizará tu nueva plantilla! Este atributo se guardará en el archivo tokenizer_config.json, por lo que puedes usar <code>push_to_hub()</code> para cargar tu nueva plantilla en el Hub y asegurarte de que todos estén utilizando la plantilla correcta para tu modelo.",ol,be,pl,Ie,Ts="El método <code>apply_chat_template()</code>, que utiliza tu plantilla de chat, es llamado por la clase <code>TextGenerationPipeline</code>, así que una vez que configures la plantilla de chat correcta, tu modelo se volverá automáticamente compatible con <code>TextGenerationPipeline</code>.",il,U,rl,we,cl,fe,Us="Antes de la introducción de las plantillas de chat, el manejo del chat estaba codificado en el nivel de la clase del modelo. Por razones de compatibilidad con versiones anteriores, hemos conservado este manejo específico de la clase como plantillas predeterminadas, también establecidas a nivel de clase. Si un modelo no tiene una plantilla de chat establecida, pero hay una plantilla predeterminada para su clase de modelo, la clase <code>TextGenerationPipeline</code> y métodos como <code>apply_chat_template</code> usarán la plantilla de clase en su lugar. Puedes averiguar cuál es la plantilla predeterminada para tu tokenizador comprobando el atributo <code>tokenizer.default_chat_template</code>.",dl,Ce,hs="Esto es algo que hacemos puramente por razones de compatibilidad con versiones anteriores, para evitar romper cualquier flujo de trabajo existente. Incluso cuando la plantilla de clase es apropiada para tu modelo, recomendamos encarecidamente anular la plantilla predeterminada estableciendo explícitamente el atributo <code>chat_template</code> para dejar claro a los usuarios que tu modelo ha sido configurado correctamente para el chat, y para estar preparados para el futuro en caso de que las plantillas predeterminadas alguna vez se alteren o se eliminen.",ml,xe,Ml,Ne,gs="Cuando establezcas la plantilla para un modelo que ya ha sido entrenado para chat, debes asegurarte de que la plantilla coincida exactamente con el formato de mensajes que el modelo vio durante el entrenamiento, o de lo contrario es probable que experimentes degradación del rendimiento. Esto es cierto incluso si estás entrenando aún más el modelo; probablemente obtendrás el mejor rendimiento si mantienes constantes los tokens de chat. Esto es muy análogo a la tokenización: generalmente obtienes el mejor rendimiento para la inferencia o el ajuste fino cuando coincides precisamente con la tokenización utilizada durante el entrenamiento.",ul,Ze,bs="Si estás entrenando un modelo desde cero o ajustando finamente un modelo de lenguaje base para chat, por otro lado, ¡tienes mucha libertad para elegir una plantilla apropiada! Los LLM son lo suficientemente inteligentes como para aprender a manejar muchos formatos de entrada diferentes. Nuestra plantilla predeterminada para modelos que no tienen una plantilla específica de clase sigue el formato ChatML, y esta es una buena elección flexible para muchos casos de uso. Se ve así:",yl,Ge,Jl,$e,Is='Si te gusta esta plantilla, aquí está en forma de una sola línea, lista para copiar en tu código. La versión de una sola línea también incluye un práctico soporte para <a href="#%C2%BFQu%C3%A9-son-los-%22generation-prompts%22?">prompts de generación</a>, ¡pero ten en cuenta que no añade tokens de BOS o EOS! Si tu modelo espera esos tokens, no se agregarán automáticamente por <code>apply_chat_template</code>, en otras palabras, el texto será tokenizado con <code>add_special_tokens=False</code>. Esto es para evitar posibles conflictos entre la plantilla y la lógica de <code>add_special_tokens</code>. ¡Si tu modelo espera tokens especiales, asegúrate de añadirlos a la plantilla!',jl,ve,Tl,Qe,ws="Esta plantilla envuelve cada mensaje en tokens <code>&lt;|im_start|&gt;</code> y <code>&lt;|im_end|&gt;</code>, y simplemente escribe el rol como una cadena, lo que permite flexibilidad en los roles con los que entrenas. La salida se ve así:",Ul,Be,hl,qe,fs="Los roles “usuario”, “sistema” y “asistente” son los estándar para chat, y recomendamos usarlos cuando tenga sentido, particularmente si deseas que tu modelo funcione bien con <code>TextGenerationPipeline</code>. Sin embargo, no estás limitado a estos roles: la plantilla es extremadamente flexible y cualquier cadena puede ser un rol.",gl,ze,bl,ke,Cs='Si tienes algún modelo de chat, debes establecer su atributo <code>tokenizer.chat_template</code> y probarlo usando <code>apply_chat_template()</code>, luego subir el tokenizador actualizado al Hub. Esto se aplica incluso si no eres el propietario del modelo: si estás usando un modelo con una plantilla de chat vacía o que todavía está utilizando la plantilla predeterminada de clase, por favor abre una solicitud de extracción <a href="https://huggingface.co/docs/hub/repositories-pull-requests-discussions" rel="nofollow">pull request</a> al repositorio del modelo para que este atributo se pueda establecer correctamente.',Il,Se,xs="Una vez que se establece el atributo, ¡eso es todo, has terminado! <code>tokenizer.apply_chat_template</code> ahora funcionará correctamente para ese modelo, ¡lo que significa que también es compatible automáticamente en lugares como <code>TextGenerationPipeline</code>!",wl,We,Ns="Al asegurarnos de que los modelos tengan este atributo, podemos garantizar que toda la comunidad pueda utilizar todo el poder de los modelos de código abierto. Los desajustes de formato han estado acechando el campo y dañando silenciosamente el rendimiento durante demasiado tiempo: ¡es hora de ponerles fin!",fl,Ve,Cl,Re,Zs="Si no estás familiarizado con Jinja, generalmente encontramos que la forma más fácil de escribir una plantilla de chat es primero escribir un script de Python corto que formatee los mensajes como desees, y luego convertir ese script en una plantilla.",xl,Ae,Gs="Recuerda que el manejador de plantillas recibirá el historial de conversación como una variable llamada mensajes. Cada mensaje es un diccionario con dos claves, <code>role</code> y <code>content</code>. Podrás acceder a los <code>mensajes</code> en tu plantilla tal como lo harías en Python, lo que significa que puedes recorrerlo con <code>{% for message in messages %}</code> o acceder a mensajes individuales con, por ejemplo, <code>{{ messages[0] }}</code>.",Nl,Ee,$s="También puedes usar los siguientes consejos para convertir tu código a Jinja:",Zl,_e,Gl,Xe,vs="Los bucles For en Jinja se ven así:",$l,Fe,vl,He,Qs="Ten en cuenta que todo lo que esté dentro del {{bloque de expresión}} se imprimirá en la salida. Puedes usar operadores como <code>+</code> para combinar cadenas dentro de bloques de expresión.",Ql,Ye,Bl,Le,Bs="Las declaraciones if en Jinja se ven así:",ql,De,zl,Pe,qs="Observa cómo donde Python utiliza espacios en blanco para marcar el inicio y el final de los bloques <code>for</code> e <code>if</code>, Jinja requiere que los termines explícitamente con <code>{% endfor %}</code> y <code>{% endif %}</code>.",kl,Ke,Sl,Oe,zs="Dentro de tu plantilla, tendrás acceso a la lista de <code>mensajes</code>, pero también puedes acceder a varias otras variables especiales. Estas incluyen tokens especiales como <code>bos_token</code> y <code>eos_token</code>, así como la variable <code>add_generation_prompt</code> que discutimos anteriormente. También puedes usar la variable <code>loop</code> para acceder a información sobre la iteración actual del bucle, por ejemplo, usando <code>{% if loop.last %}</code> para verificar si el mensaje actual es el último mensaje en la conversación. Aquí tienes un ejemplo que combina estas ideas para agregar un prompt de generación al final de la conversación si add_generation_prompt es <code>True</code>:",Wl,ea,Vl,aa,Rl,la,ks="Hemos intentado que Jinja ignore los espacios en blanco fuera de las {{expresiones}} tanto como sea posible. Sin embargo, ten en cuenta que Jinja es un motor de plantillas de propósito general y puede tratar el espacio en blanco entre bloques en la misma línea como significativo e imprimirlo en la salida. ¡Te recomendamos <strong>encarecidamente</strong> que verifiques que tu plantilla no esté imprimiendo espacios adicionales donde no debería antes de subirla!",Al,ta,El;return g=new j({props:{title:"Plantillas para Modelos de Chat",local:"plantillas-para-modelos-de-chat",headingTag:"h1"}}),b=new j({props:{title:"Introducción",local:"introducción",headingTag:"h2"}}),w=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQWNoYXQlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIZWxsbyUyQyUyMGhvdyUyMGFyZSUyMHlvdSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdtJTIwZG9pbmclMjBncmVhdC4lMjBIb3clMjBjYW4lMjBJJTIwaGVscCUyMHlvdSUyMHRvZGF5JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySSdkJTIwbGlrZSUyMHRvJTIwc2hvdyUyMG9mZiUyMGhvdyUyMGNoYXQlMjB0ZW1wbGF0aW5nJTIwd29ya3MhJTIyJTdEJTJDJTBBJTVEJTBBJTBBdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUoY2hhdCUyQyUyMHRva2VuaXplJTNERmFsc2UpJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>   {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot; Hello, how are you?  I&#x27;m doing great. How can I help you today?   I&#x27;d like to show off how chat templating works!&lt;/s&gt;&quot;</span>
`,wrap:!1}}),C=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaXN0cmFsYWklMkZNaXN0cmFsLTdCLUluc3RydWN0LXYwLjElMjIpJTBBJTBBY2hhdCUyMCUzRCUyMCU1QiUwQSUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhlbGxvJTJDJTIwaG93JTIwYXJlJTIweW91JTNGJTIyJTdEJTJDJTBBJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ20lMjBkb2luZyUyMGdyZWF0LiUyMEhvdyUyMGNhbiUyMEklMjBoZWxwJTIweW91JTIwdG9kYXklM0YlMjIlN0QlMkMlMEElMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJ2QlMjBsaWtlJTIwdG8lMjBzaG93JTIwb2ZmJTIwaG93JTIwY2hhdCUyMHRlbXBsYXRpbmclMjB3b3JrcyElMjIlN0QlMkMlMEElNUQlMEElMEF0b2tlbml6ZXIuYXBwbHlfY2hhdF90ZW1wbGF0ZShjaGF0JTJDJTIwdG9rZW5pemUlM0RGYWxzZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-Instruct-v0.1&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>chat = [
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hello, how are you?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;m doing great. How can I help you today?&quot;</span>},
<span class="hljs-meta">... </span>  {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;I&#x27;d like to show off how chat templating works!&quot;</span>},
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.apply_chat_template(chat, tokenize=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&lt;s&gt;[INST] Hello, how are you? [/INST]I&#x27;m doing great. How can I help you today?&lt;/s&gt; [INST] I&#x27;d like to show off how chat templating works! [/INST]&quot;</span>`,wrap:!1}}),N=new j({props:{title:"¿Cómo uso las plantillas de chat?",local:"cómo-uso-las-plantillas-de-chat",headingTag:"h2"}}),$=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQWNoZWNrcG9pbnQlMjAlM0QlMjAlMjJIdWdnaW5nRmFjZUg0JTJGemVwaHlyLTdiLWJldGElMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChjaGVja3BvaW50KSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKGNoZWNrcG9pbnQpJTIwJTIwJTIzJTIwWW91JTIwbWF5JTIwd2FudCUyMHRvJTIwdXNlJTIwYmZsb2F0MTYlMjBhbmQlMkZvciUyMG1vdmUlMjB0byUyMEdQVSUyMGhlcmUlMEElMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUyMiUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTIwJTIyY29udGVudCUyMiUzQSUyMCUyMkhvdyUyMG1hbnklMjBoZWxpY29wdGVycyUyMGNhbiUyMGElMjBodW1hbiUyMGVhdCUyMGluJTIwb25lJTIwc2l0dGluZyUzRiUyMiU3RCUyQyUwQSUyMCU1RCUwQXRva2VuaXplZF9jaGF0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFwcmludCh0b2tlbml6ZXIuZGVjb2RlKHRva2VuaXplZF9jaGF0JTVCMCU1RCkp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

checkpoint = <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(checkpoint)
model = AutoModelForCausalLM.from_pretrained(checkpoint)  <span class="hljs-comment"># You may want to use bfloat16 and/or move to GPU here</span>

messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
 ]
tokenized_chat = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-built_in">print</span>(tokenizer.decode(tokenized_chat[<span class="hljs-number">0</span>]))`,wrap:!1}}),Q=new y({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRQ==",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;`,wrap:!1}}),q=new y({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKHRva2VuaXplZF9jaGF0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxMjgpJTIwJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkpJTBB",highlighted:`outputs = model.generate(tokenized_chat, max_new_tokens=<span class="hljs-number">128</span>) 
<span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))
`,wrap:!1}}),k=new y({props:{code:"JTNDJTdDc3lzdGVtJTdDJTNFJTBBWW91JTIwYXJlJTIwYSUyMGZyaWVuZGx5JTIwY2hhdGJvdCUyMHdobyUyMGFsd2F5cyUyMHJlc3BvbmRzJTIwaW4lMjB0aGUlMjBzdHlsZSUyMG9mJTIwYSUyMHBpcmF0ZSUzQyUyRnMlM0UlMjAlMEElM0MlN0N1c2VyJTdDJTNFJTBBSG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTNDJTJGcyUzRSUyMCUwQSUzQyU3Q2Fzc2lzdGFudCU3QyUzRSUwQU1hdGV5JTJDJTIwSSdtJTIwYWZyYWlkJTIwSSUyMG11c3QlMjBpbmZvcm0lMjB5ZSUyMHRoYXQlMjBodW1hbnMlMjBjYW5ub3QlMjBlYXQlMjBoZWxpY29wdGVycy4lMjBIZWxpY29wdGVycyUyMGFyZSUyMG5vdCUyMGZvb2QlMkMlMjB0aGV5JTIwYXJlJTIwZmx5aW5nJTIwbWFjaGluZXMuJTIwRm9vZCUyMGlzJTIwbWVhbnQlMjB0byUyMGJlJTIwZWF0ZW4lMkMlMjBsaWtlJTIwYSUyMGhlYXJ0eSUyMHBsYXRlJTIwbyclMjBncm9nJTJDJTIwYSUyMHNhdm9yeSUyMGJvd2wlMjBvJyUyMHN0ZXclMkMlMjBvciUyMGElMjBkZWxpY2lvdXMlMjBsb2FmJTIwbyclMjBicmVhZC4lMjBCdXQlMjBoZWxpY29wdGVycyUyQyUyMHRoZXklMjBiZSUyMGZvciUyMHRyYW5zcG9ydGluJyUyMGFuZCUyMG1vdmluJyUyMGFyb3VuZCUyQyUyMG5vdCUyMGZvciUyMGVhdGluJy4lMjBTbyUyQyUyMEknZCUyMHNheSUyMG5vbmUlMkMlMjBtZSUyMGhlYXJ0aWVzLiUyME5vbmUlMjBhdCUyMGFsbC4=",highlighted:`&lt;|system|&gt;
You are a friendly chatbot who always responds in the style of a pirate&lt;/s&gt; 
&lt;|user|&gt;
How many helicopters can a human eat in one sitting?&lt;/s&gt; 
&lt;|assistant|&gt;
Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.`,wrap:!1}}),W=new j({props:{title:"¿Existe un pipeline automatizado para chats?",local:"existe-un-pipeline-automatizado-para-chats",headingTag:"h2"}}),R=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBcGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMmNvbnZlcnNhdGlvbmFsJTIyJTJDJTIwJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnN5c3RlbSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJZb3UlMjBhcmUlMjBhJTIwZnJpZW5kbHklMjBjaGF0Ym90JTIwd2hvJTIwYWx3YXlzJTIwcmVzcG9uZHMlMjBpbiUyMHRoZSUyMHN0eWxlJTIwb2YlMjBhJTIwcGlyYXRlJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIySG93JTIwbWFueSUyMGhlbGljb3B0ZXJzJTIwY2FuJTIwYSUyMGh1bWFuJTIwZWF0JTIwaW4lMjBvbmUlMjBzaXR0aW5nJTNGJTIyJTdEJTJDJTBBJTVEJTBBcHJpbnQocGlwZShtZXNzYWdlcyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTI4KSU1QjAlNUQlNUInZ2VuZXJhdGVkX3RleHQnJTVEJTVCLTElNUQpJTIwJTIwJTIzJTIwUHJpbnQlMjB0aGUlMjBhc3Npc3RhbnQncyUyMHJlc3BvbnNl",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

pipe = pipeline(<span class="hljs-string">&quot;conversational&quot;</span>, <span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)
messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a friendly chatbot who always responds in the style of a pirate&quot;</span>,
    },
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How many helicopters can a human eat in one sitting?&quot;</span>},
]
<span class="hljs-built_in">print</span>(pipe(messages, max_new_tokens=<span class="hljs-number">128</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&#x27;generated_text&#x27;</span>][-<span class="hljs-number">1</span>])  <span class="hljs-comment"># Print the assistant&#x27;s response</span>`,wrap:!1}}),A=new y({props:{code:"JTdCJ3JvbGUnJTNBJTIwJ2Fzc2lzdGFudCclMkMlMjAnY29udGVudCclM0ElMjAlMjJNYXRleSUyQyUyMEknbSUyMGFmcmFpZCUyMEklMjBtdXN0JTIwaW5mb3JtJTIweWUlMjB0aGF0JTIwaHVtYW5zJTIwY2Fubm90JTIwZWF0JTIwaGVsaWNvcHRlcnMuJTIwSGVsaWNvcHRlcnMlMjBhcmUlMjBub3QlMjBmb29kJTJDJTIwdGhleSUyMGFyZSUyMGZseWluZyUyMG1hY2hpbmVzLiUyMEZvb2QlMjBpcyUyMG1lYW50JTIwdG8lMjBiZSUyMGVhdGVuJTJDJTIwbGlrZSUyMGElMjBoZWFydHklMjBwbGF0ZSUyMG8nJTIwZ3JvZyUyQyUyMGElMjBzYXZvcnklMjBib3dsJTIwbyclMjBzdGV3JTJDJTIwb3IlMjBhJTIwZGVsaWNpb3VzJTIwbG9hZiUyMG8nJTIwYnJlYWQuJTIwQnV0JTIwaGVsaWNvcHRlcnMlMkMlMjB0aGV5JTIwYmUlMjBmb3IlMjB0cmFuc3BvcnRpbiclMjBhbmQlMjBtb3ZpbiclMjBhcm91bmQlMkMlMjBub3QlMjBmb3IlMjBlYXRpbicuJTIwU28lMkMlMjBJJ2QlMjBzYXklMjBub25lJTJDJTIwbWUlMjBoZWFydGllcy4lMjBOb25lJTIwYXQlMjBhbGwuJTIyJTdE",highlighted:"{&#x27;role&#x27;: &#x27;assistant&#x27;, &#x27;content&#x27;: &quot;Matey, I&#x27;m afraid I must inform ye that humans cannot eat helicopters. Helicopters are not food, they are flying machines. Food is meant to be eaten, like a hearty plate o&#x27; grog, a savory bowl o&#x27; stew, or a delicious loaf o&#x27; bread. But helicopters, they be for transportin&#x27; and movin&#x27; around, not for eatin&#x27;. So, I&#x27;d say none, me hearties. None at all.&quot;}",wrap:!1}}),_=new j({props:{title:"¿Qué son los “generation prompts”?",local:"qué-son-los-generation-prompts",headingTag:"h1"}}),F=new y({props:{code:"bWVzc2FnZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIaSUyMHRoZXJlISUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyTmljZSUyMHRvJTIwbWVldCUyMHlvdSElMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTIyJTdEJTBBJTVE",highlighted:`messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Hi there!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Nice to meet you!&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Can I ask a question?&quot;</span>}
]`,wrap:!1}}),Y=new y({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNERmFsc2UpJTBBJTIyJTIyJTIyJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSGklMjB0aGVyZSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRWFzc2lzdGFudCUwQU5pY2UlMjB0byUyMG1lZXQlMjB5b3UhJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBQ2FuJTIwSSUyMGFzayUyMGElMjBxdWVzdGlvbiUzRiUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUyMiUyMiUyMg==",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&quot;&quot;&quot;</span>`,wrap:!1}}),D=new y({props:{code:"dG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzREZhbHNlJTJDJTIwYWRkX2dlbmVyYXRpb25fcHJvbXB0JTNEVHJ1ZSklMEElMjIlMjIlMjIlM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFIaSUyMHRoZXJlISUzQyU3Q2ltX2VuZCU3QyUzRSUwQSUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTBBTmljZSUyMHRvJTIwbWVldCUyMHlvdSElM0MlN0NpbV9lbmQlN0MlM0UlMEElM0MlN0NpbV9zdGFydCU3QyUzRXVzZXIlMEFDYW4lMjBJJTIwYXNrJTIwYSUyMHF1ZXN0aW9uJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEElMjIlMjIlMjI=",highlighted:`tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;&lt;|im_start|&gt;user
Hi there!&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
Nice to meet you!&lt;|im_end|&gt;
&lt;|im_start|&gt;user
Can I ask a question?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
&quot;&quot;&quot;</span>`,wrap:!1}}),O=new j({props:{title:"¿Puedo usar plantillas de chat en el entrenamiento?",local:"puedo-usar-plantillas-de-chat-en-el-entrenamiento",headingTag:"h2"}}),ae=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBEYXRhc2V0JTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyKSUwQSUwQWNoYXQxJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMHRoZSUyMG1vb24lMjBvciUyMHRoZSUyMHN1biUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyVGhlJTIwc3VuLiUyMiU3RCUwQSU1RCUwQWNoYXQyJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMGJpZ2dlciUyQyUyMGElMjB2aXJ1cyUyMG9yJTIwYSUyMGJhY3Rlcml1bSUzRiUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQSUyMGJhY3Rlcml1bS4lMjIlN0QlMEElNUQlMEElMEFkYXRhc2V0JTIwJTNEJTIwRGF0YXNldC5mcm9tX2RpY3QoJTdCJTIyY2hhdCUyMiUzQSUyMCU1QmNoYXQxJTJDJTIwY2hhdDIlNUQlN0QpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQubWFwKGxhbWJkYSUyMHglM0ElMjAlN0IlMjJmb3JtYXR0ZWRfY2hhdCUyMiUzQSUyMHRva2VuaXplci5hcHBseV9jaGF0X3RlbXBsYXRlKHglNUIlMjJjaGF0JTIyJTVEJTJDJTIwdG9rZW5pemUlM0RGYWxzZSUyQyUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUzREZhbHNlKSU3RCklMEFwcmludChkYXRhc2V0JTVCJ2Zvcm1hdHRlZF9jaGF0JyU1RCU1QjAlNUQp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;HuggingFaceH4/zephyr-7b-beta&quot;</span>)

chat1 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, the moon or the sun?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;The sun.&quot;</span>}
]
chat2 = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Which is bigger, a virus or a bacterium?&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;A bacterium.&quot;</span>}
]

dataset = Dataset.from_dict({<span class="hljs-string">&quot;chat&quot;</span>: [chat1, chat2]})
dataset = dataset.<span class="hljs-built_in">map</span>(<span class="hljs-keyword">lambda</span> x: {<span class="hljs-string">&quot;formatted_chat&quot;</span>: tokenizer.apply_chat_template(x[<span class="hljs-string">&quot;chat&quot;</span>], tokenize=<span class="hljs-literal">False</span>, add_generation_prompt=<span class="hljs-literal">False</span>)})
<span class="hljs-built_in">print</span>(dataset[<span class="hljs-string">&#x27;formatted_chat&#x27;</span>][<span class="hljs-number">0</span>])`,wrap:!1}}),se=new y({props:{code:"JTNDJTdDdXNlciU3QyUzRSUwQVdoaWNoJTIwaXMlMjBiaWdnZXIlMkMlMjB0aGUlMjBtb29uJTIwb3IlMjB0aGUlMjBzdW4lM0YlM0MlMkZzJTNFJTBBJTNDJTdDYXNzaXN0YW50JTdDJTNFJTBBVGhlJTIwc3VuLiUzQyUyRnMlM0U=",highlighted:`&lt;|user|&gt;
Which is bigger, the moon or the sun?&lt;/s&gt;
&lt;|assistant|&gt;
The sun.&lt;/s&gt;`,wrap:!1}}),ne=new j({props:{title:"Avanzado: ¿Cómo funcionan las plantillas de chat?",local:"avanzado-cómo-funcionan-las-plantillas-de-chat",headingTag:"h2"}}),pe=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRmJsZW5kZXJib3QtNDAwTS1kaXN0aWxsJTIyKSUwQSUwQXRva2VuaXplci5kZWZhdWx0X2NoYXRfdGVtcGxhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/blenderbot-400M-distill&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.default_chat_template
<span class="hljs-string">&quot;{% for message in messages %}{% if message[&#x27;role&#x27;] == &#x27;user&#x27; %}{{ &#x27; &#x27; }}{% endif %}{{ message[&#x27;content&#x27;] }}{% if not loop.last %}{{ &#x27;  &#x27; }}{% endif %}{% endfor %}{{ eos_token }}&quot;</span>`,wrap:!1}}),re=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGlmJTIwbm90JTIwbG9vcC5sYXN0JTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUyMCUyMCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbmRpZiUyMCUyNSU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RCUwQSU3QiU3QiUyMGVvc190b2tlbiUyMCU3RCU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> not loop.last <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;  &#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ eos_token }}</span>`,wrap:!1}}),de=new y({props:{code:"Zm9yJTIwaWR4JTJDJTIwbWVzc2FnZSUyMGluJTIwZW51bWVyYXRlKG1lc3NhZ2VzKSUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCd1c2VyJyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KCclMjAnKSUwQSUyMCUyMCUyMCUyMHByaW50KG1lc3NhZ2UlNUInY29udGVudCclNUQpJTBBJTIwJTIwJTIwJTIwaWYlMjBub3QlMjBpZHglMjAlM0QlM0QlMjBsZW4obWVzc2FnZXMpJTIwLSUyMDElM0ElMjAlMjAlMjMlMjBDaGVjayUyMGZvciUyMHRoZSUyMGxhc3QlMjBtZXNzYWdlJTIwaW4lMjB0aGUlMjBjb252ZXJzYXRpb24lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludCgnJTIwJTIwJyklMEFwcmludChlb3NfdG9rZW4p",highlighted:`<span class="hljs-keyword">for</span> idx, message <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(messages):
    <span class="hljs-keyword">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span>:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27; &#x27;</span>)
    <span class="hljs-built_in">print</span>(message[<span class="hljs-string">&#x27;content&#x27;</span>])
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> idx == <span class="hljs-built_in">len</span>(messages) - <span class="hljs-number">1</span>:  <span class="hljs-comment"># Check for the last message in the conversation</span>
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;  &#x27;</span>)
<span class="hljs-built_in">print</span>(eos_token)`,wrap:!1}}),ye=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTJCJTIwJyUyMCU1QiUyRklOU1QlNUQnJTIwJTdEJTdEJTBBJTIwJTIwJTIwJTIwJTdCJTI1JTIwZWxpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAnc3lzdGVtJyUyMCUyNSU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiU3QiUyMCclM0MlM0NTWVMlM0UlM0UlNUMlNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTVDJTVDbiUzQyUzQyUyRlNZUyUzRSUzRSU1QyU1Q24lNUMlNUNuJyUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVsaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ2Fzc2lzdGFudCclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjAnJTIwJyUyMCUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTIwJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27; &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; &#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),je=new j({props:{title:"Avanzado: Añadiendo y editando plantillas de chat",local:"avanzado-añadiendo-y-editando-plantillas-de-chat",headingTag:"h2"}}),Te=new j({props:{title:"¿Cómo creo una plantilla de chat?",local:"cómo-creo-una-plantilla-de-chat",headingTag:"h3"}}),he=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBpZiUyMG1lc3NhZ2UlNUIncm9sZSclNUQlMjAlM0QlM0QlMjAndXNlciclMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnJTVCSU5TVCU1RCUyMCclMjAlMkIlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVELnN0cmlwKCklMjAlMkIlMjAnJTIwJTVCJTJGSU5TVCU1RCclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdzeXN0ZW0nJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyUzQyUzQ1NZUyUzRSUzRSU1QyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RC5zdHJpcCgpJTIwJTJCJTIwJyU1QyU1Q24lM0MlM0MlMkZTWVMlM0UlM0UlNUMlNUNuJTVDJTVDbiclMjAlN0QlN0QlMEElMjAlMjAlMjAlMjAlN0IlMjUlMjBlbGlmJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUzRCUzRCUyMCdhc3Npc3RhbnQnJTIwJTI1JTdEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTdCJTIwJyU1QkFTU1QlNUQlMjAnJTIwJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclMjAlNUIlMkZBU1NUJTVEJyUyMCUyQiUyMGVvc190b2tlbiUyMCU3RCU3RCUwQSUyMCUyMCUyMCUyMCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ bos_token + <span class="hljs-string">&#x27;[INST] &#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27; [/INST]&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;system&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;&lt;&lt;SYS&gt;&gt;\\\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>].strip() + <span class="hljs-string">&#x27;\\\\n&lt;&lt;/SYS&gt;&gt;\\\\n\\\\n&#x27;</span> }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">elif</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;assistant&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
        </span><span class="hljs-template-variable">{{ <span class="hljs-string">&#x27;[ASST] &#x27;</span>  + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27; [/ASST]&#x27;</span> + eos_token }}</span><span class="language-xml">
    </span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),be=new y({props:{code:"dGVtcGxhdGUlMjAlM0QlMjB0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUwQXRlbXBsYXRlJTIwJTNEJTIwdGVtcGxhdGUucmVwbGFjZSglMjJTWVMlMjIlMkMlMjAlMjJTWVNURU0lMjIpJTIwJTIwJTIzJTIwQ2hhbmdlJTIwdGhlJTIwc3lzdGVtJTIwdG9rZW4lMEF0b2tlbml6ZXIuY2hhdF90ZW1wbGF0ZSUyMCUzRCUyMHRlbXBsYXRlJTIwJTIwJTIzJTIwU2V0JTIwdGhlJTIwbmV3JTIwdGVtcGxhdGUlMEF0b2tlbml6ZXIucHVzaF90b19odWIoJTIybW9kZWxfbmFtZSUyMiklMjAlMjAlMjMlMjBVcGxvYWQlMjB5b3VyJTIwbmV3JTIwdGVtcGxhdGUlMjB0byUyMHRoZSUyMEh1YiE=",highlighted:`template = tokenizer.chat_template
template = template.replace(<span class="hljs-string">&quot;SYS&quot;</span>, <span class="hljs-string">&quot;SYSTEM&quot;</span>)  <span class="hljs-comment"># Change the system token</span>
tokenizer.chat_template = template  <span class="hljs-comment"># Set the new template</span>
tokenizer.push_to_hub(<span class="hljs-string">&quot;model_name&quot;</span>)  <span class="hljs-comment"># Upload your new template to the Hub!</span>`,wrap:!1}}),U=new Ys({props:{$$slots:{default:[Ls]},$$scope:{ctx:na}}}),we=new j({props:{title:"¿Qué son las plantillas “default”?",local:"qué-son-las-plantillas-default",headingTag:"h3"}}),xe=new j({props:{title:"¿Qué plantilla debería usar?",local:"qué-plantilla-debería-usar",headingTag:"h3"}}),Ge=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElMjAlMjAlMjAlMjAlN0IlN0InJTNDJTdDaW1fc3RhcnQlN0MlM0UnJTIwJTJCJTIwbWVzc2FnZSU1Qidyb2xlJyU1RCUyMCUyQiUyMCclNUNuJyUyMCUyQiUyMG1lc3NhZ2UlNUInY29udGVudCclNUQlMjAlMkIlMjAnJTNDJTdDaW1fZW5kJTdDJTNFJyUyMCUyQiUyMCclNUNuJyU3RCU3RCUwQSU3QiUyNSUyMGVuZGZvciUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">for</span> message <span class="hljs-keyword">in</span> messages <span class="hljs-template-tag">%}</span><span class="language-xml">
    </span><span class="hljs-template-variable">{{<span class="hljs-string">&#x27;&lt;|im_start|&gt;&#x27;</span> + message[<span class="hljs-string">&#x27;role&#x27;</span>] + <span class="hljs-string">&#x27;\\n&#x27;</span> + message[<span class="hljs-string">&#x27;content&#x27;</span>] + <span class="hljs-string">&#x27;&lt;|im_end|&gt;&#x27;</span> + <span class="hljs-string">&#x27;\\n&#x27;</span>}}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endfor</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),ve=new y({props:{code:"dG9rZW5pemVyLmNoYXRfdGVtcGxhdGUlMjAlM0QlMjAlMjIlN0IlMjUlMjBpZiUyMG5vdCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMGlzJTIwZGVmaW5lZCUyMCUyNSU3RCU3QiUyNSUyMHNldCUyMGFkZF9nZW5lcmF0aW9uX3Byb21wdCUyMCUzRCUyMGZhbHNlJTIwJTI1JTdEJTdCJTI1JTIwZW5kaWYlMjAlMjUlN0QlN0IlMjUlMjBmb3IlMjBtZXNzYWdlJTIwaW4lMjBtZXNzYWdlcyUyMCUyNSU3RCU3QiU3QiclM0MlN0NpbV9zdGFydCU3QyUzRSclMjAlMkIlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTJCJTIwJyU1Q24nJTIwJTJCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCUyQiUyMCclM0MlN0NpbV9lbmQlN0MlM0UnJTIwJTJCJTIwJyU1Q24nJTdEJTdEJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdEJTdCJTI1JTIwaWYlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlN0IlN0IlMjAnJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJyUyMCU3RCU3RCU3QiUyNSUyMGVuZGlmJTIwJTI1JTdEJTIy",highlighted:'tokenizer.chat_template = <span class="hljs-string">&quot;{% if not add_generation_prompt is defined %}{% set add_generation_prompt = false %}{% endif %}{% for message in messages %}{{&#x27;&lt;|im_start|&gt;&#x27; + message[&#x27;role&#x27;] + &#x27;\\n&#x27; + message[&#x27;content&#x27;] + &#x27;&lt;|im_end|&gt;&#x27; + &#x27;\\n&#x27;}}{% endfor %}{% if add_generation_prompt %}{{ &#x27;&lt;|im_start|&gt;assistant\\n&#x27; }}{% endif %}&quot;</span>',wrap:!1}}),Be=new y({props:{code:"JTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lMEFZb3UlMjBhcmUlMjBhJTIwaGVscGZ1bCUyMGNoYXRib3QlMjB0aGF0JTIwd2lsbCUyMGRvJTIwaXRzJTIwYmVzdCUyMG5vdCUyMHRvJTIwc2F5JTIwYW55dGhpbmclMjBzbyUyMHN0dXBpZCUyMHRoYXQlMjBwZW9wbGUlMjB0d2VldCUyMGFib3V0JTIwaXQuJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0V1c2VyJTBBSG93JTIwYXJlJTIweW91JTNGJTNDJTdDaW1fZW5kJTdDJTNFJTBBJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlMEFJJ20lMjBkb2luZyUyMGdyZWF0ISUzQyU3Q2ltX2VuZCU3QyUzRQ==",highlighted:`&lt;|im_start|&gt;system
You are a helpful chatbot that will do its best not to say anything so stupid that people tweet about it.&lt;|im_end|&gt;
&lt;|im_start|&gt;user
How are you?&lt;|im_end|&gt;
&lt;|im_start|&gt;assistant
I&#x27;m doing great!&lt;|im_end|&gt;`,wrap:!1}}),ze=new j({props:{title:"¡Quiero añadir algunas plantillas de chat! ¿Cómo debo empezar?",local:"quiero-añadir-algunas-plantillas-de-chat-cómo-debo-empezar",headingTag:"h3"}}),Ve=new j({props:{title:"Avanzado: Consejos para escribir plantillas",local:"avanzado-consejos-para-escribir-plantillas",headingTag:"h2"}}),_e=new j({props:{title:"Bucles For",local:"bucles-for",headingTag:"h3"}}),Fe=new y({props:{code:"JTdCJTI1JTIwZm9yJTIwbWVzc2FnZSUyMGluJTIwbWVzc2FnZXMlMjAlMjUlN0QlMEElN0IlN0IlMjBtZXNzYWdlJTVCJ2NvbnRlbnQnJTVEJTIwJTdEJTdEJTBBJTdCJTI1JTIwZW5kZm9yJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">for</span></span> message <span class="hljs-keyword">in</span> messages %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[&#x27;content&#x27;] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endfor</span></span> %}</span>`,wrap:!1}}),Ye=new j({props:{title:"Declaraciones if",local:"declaraciones-if",headingTag:"h3"}}),De=new y({props:{code:"JTdCJTI1JTIwaWYlMjBtZXNzYWdlJTVCJ3JvbGUnJTVEJTIwJTNEJTNEJTIwJ3VzZXInJTIwJTI1JTdEJTBBJTdCJTdCJTIwbWVzc2FnZSU1Qidjb250ZW50JyU1RCUyMCU3RCU3RCUwQSU3QiUyNSUyMGVuZGlmJTIwJTI1JTdE",highlighted:`<span class="hljs-template-tag">{%</span> <span class="hljs-name">if</span> message[<span class="hljs-string">&#x27;role&#x27;</span>] == <span class="hljs-string">&#x27;user&#x27;</span> <span class="hljs-template-tag">%}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ message[<span class="hljs-string">&#x27;content&#x27;</span>] }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{%</span> <span class="hljs-name">endif</span> <span class="hljs-template-tag">%}</span>`,wrap:!1}}),Ke=new j({props:{title:"Variables especiales",local:"variables-especiales",headingTag:"h3"}}),ea=new y({props:{code:"JTdCJTI1JTIwaWYlMjBsb29wLmxhc3QlMjBhbmQlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlMjAlMjUlN0QlMEElN0IlN0IlMjBib3NfdG9rZW4lMjAlMkIlMjAnQXNzaXN0YW50JTNBJTVDbiclMjAlN0QlN0QlMEElN0IlMjUlMjBlbmRpZiUyMCUyNSU3RA==",highlighted:`<span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">if</span></span> loop.last and add_generation_prompt %}</span><span class="language-xml">
</span><span class="hljs-template-variable">{{ bos_token + &#x27;Assistant:\\n&#x27; }}</span><span class="language-xml">
</span><span class="hljs-template-tag">{% <span class="hljs-name"><span class="hljs-name">endif</span></span> %}</span>`,wrap:!1}}),aa=new j({props:{title:"Notas sobre los espacios en blanco",local:"notas-sobre-los-espacios-en-blanco",headingTag:"h3"}}),{c(){J=o("meta"),h=t(),T=o("p"),sa=t(),r(g.$$.fragment),oa=t(),r(b.$$.fragment),pa=t(),I=o("p"),I.innerHTML=_l,ia=t(),r(w.$$.fragment),ra=t(),f=o("p"),f.innerHTML=Xl,ca=t(),r(C.$$.fragment),da=t(),x=o("p"),x.textContent=Fl,ma=t(),r(N.$$.fragment),Ma=t(),Z=o("p"),Z.innerHTML=Hl,ua=t(),G=o("p"),G.innerHTML=Yl,ya=t(),r($.$$.fragment),Ja=t(),v=o("p"),v.textContent=Ll,ja=t(),r(Q.$$.fragment),Ta=t(),B=o("p"),B.textContent=Dl,Ua=t(),r(q.$$.fragment),ha=t(),z=o("p"),z.textContent=Pl,ga=t(),r(k.$$.fragment),ba=t(),S=o("p"),S.textContent=Kl,Ia=t(),r(W.$$.fragment),wa=t(),V=o("p"),V.innerHTML=Ol,fa=t(),r(R.$$.fragment),Ca=t(),r(A.$$.fragment),xa=t(),E=o("p"),E.innerHTML=es,Na=t(),r(_.$$.fragment),Za=t(),X=o("p"),X.innerHTML=as,Ga=t(),r(F.$$.fragment),$a=t(),H=o("p"),H.textContent=ls,va=t(),r(Y.$$.fragment),Qa=t(),L=o("p"),L.innerHTML=ss,Ba=t(),r(D.$$.fragment),qa=t(),P=o("p"),P.textContent=ts,za=t(),K=o("p"),K.innerHTML=ns,ka=t(),r(O.$$.fragment),Sa=t(),ee=o("p"),ee.innerHTML=os,Wa=t(),r(ae.$$.fragment),Va=t(),le=o("p"),le.textContent=ps,Ra=t(),r(se.$$.fragment),Aa=t(),te=o("p"),te.innerHTML=is,Ea=t(),r(ne.$$.fragment),_a=t(),oe=o("p"),oe.innerHTML=rs,Xa=t(),r(pe.$$.fragment),Fa=t(),ie=o("p"),ie.innerHTML=cs,Ha=t(),r(re.$$.fragment),Ya=t(),ce=o("p"),ce.innerHTML=ds,La=t(),r(de.$$.fragment),Da=t(),me=o("p"),me.textContent=ms,Pa=t(),Me=o("ol"),Me.innerHTML=Ms,Ka=t(),ue=o("p"),ue.textContent=us,Oa=t(),r(ye.$$.fragment),el=t(),Je=o("p"),Je.textContent=ys,al=t(),r(je.$$.fragment),ll=t(),r(Te.$$.fragment),sl=t(),Ue=o("p"),Ue.innerHTML=Js,tl=t(),r(he.$$.fragment),nl=t(),ge=o("p"),ge.innerHTML=js,ol=t(),r(be.$$.fragment),pl=t(),Ie=o("p"),Ie.innerHTML=Ts,il=t(),r(U.$$.fragment),rl=t(),r(we.$$.fragment),cl=t(),fe=o("p"),fe.innerHTML=Us,dl=t(),Ce=o("p"),Ce.innerHTML=hs,ml=t(),r(xe.$$.fragment),Ml=t(),Ne=o("p"),Ne.textContent=gs,ul=t(),Ze=o("p"),Ze.textContent=bs,yl=t(),r(Ge.$$.fragment),Jl=t(),$e=o("p"),$e.innerHTML=Is,jl=t(),r(ve.$$.fragment),Tl=t(),Qe=o("p"),Qe.innerHTML=ws,Ul=t(),r(Be.$$.fragment),hl=t(),qe=o("p"),qe.innerHTML=fs,gl=t(),r(ze.$$.fragment),bl=t(),ke=o("p"),ke.innerHTML=Cs,Il=t(),Se=o("p"),Se.innerHTML=xs,wl=t(),We=o("p"),We.textContent=Ns,fl=t(),r(Ve.$$.fragment),Cl=t(),Re=o("p"),Re.textContent=Zs,xl=t(),Ae=o("p"),Ae.innerHTML=Gs,Nl=t(),Ee=o("p"),Ee.textContent=$s,Zl=t(),r(_e.$$.fragment),Gl=t(),Xe=o("p"),Xe.textContent=vs,$l=t(),r(Fe.$$.fragment),vl=t(),He=o("p"),He.innerHTML=Qs,Ql=t(),r(Ye.$$.fragment),Bl=t(),Le=o("p"),Le.textContent=Bs,ql=t(),r(De.$$.fragment),zl=t(),Pe=o("p"),Pe.innerHTML=qs,kl=t(),r(Ke.$$.fragment),Sl=t(),Oe=o("p"),Oe.innerHTML=zs,Wl=t(),r(ea.$$.fragment),Vl=t(),r(aa.$$.fragment),Rl=t(),la=o("p"),la.innerHTML=ks,Al=t(),ta=o("p"),this.h()},l(e){const a=Fs("svelte-u9bgzb",document.head);J=p(a,"META",{name:!0,content:!0}),a.forEach(l),h=n(e),T=p(e,"P",{}),Ws(T).forEach(l),sa=n(e),c(g.$$.fragment,e),oa=n(e),c(b.$$.fragment,e),pa=n(e),I=p(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-11aabob"&&(I.innerHTML=_l),ia=n(e),c(w.$$.fragment,e),ra=n(e),f=p(e,"P",{"data-svelte-h":!0}),i(f)!=="svelte-12h8kxd"&&(f.innerHTML=Xl),ca=n(e),c(C.$$.fragment,e),da=n(e),x=p(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-k3h2i4"&&(x.textContent=Fl),ma=n(e),c(N.$$.fragment,e),Ma=n(e),Z=p(e,"P",{"data-svelte-h":!0}),i(Z)!=="svelte-10hnspz"&&(Z.innerHTML=Hl),ua=n(e),G=p(e,"P",{"data-svelte-h":!0}),i(G)!=="svelte-dh3ea3"&&(G.innerHTML=Yl),ya=n(e),c($.$$.fragment,e),Ja=n(e),v=p(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-wtc865"&&(v.textContent=Ll),ja=n(e),c(Q.$$.fragment,e),Ta=n(e),B=p(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-aypsxm"&&(B.textContent=Dl),Ua=n(e),c(q.$$.fragment,e),ha=n(e),z=p(e,"P",{"data-svelte-h":!0}),i(z)!=="svelte-1nkpyay"&&(z.textContent=Pl),ga=n(e),c(k.$$.fragment,e),ba=n(e),S=p(e,"P",{"data-svelte-h":!0}),i(S)!=="svelte-m5pa6z"&&(S.textContent=Kl),Ia=n(e),c(W.$$.fragment,e),wa=n(e),V=p(e,"P",{"data-svelte-h":!0}),i(V)!=="svelte-1k9lyis"&&(V.innerHTML=Ol),fa=n(e),c(R.$$.fragment,e),Ca=n(e),c(A.$$.fragment,e),xa=n(e),E=p(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-y3a2so"&&(E.innerHTML=es),Na=n(e),c(_.$$.fragment,e),Za=n(e),X=p(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-esevtv"&&(X.innerHTML=as),Ga=n(e),c(F.$$.fragment,e),$a=n(e),H=p(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-1cv0hfh"&&(H.textContent=ls),va=n(e),c(Y.$$.fragment,e),Qa=n(e),L=p(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-1mignqw"&&(L.innerHTML=ss),Ba=n(e),c(D.$$.fragment,e),qa=n(e),P=p(e,"P",{"data-svelte-h":!0}),i(P)!=="svelte-83j4ek"&&(P.textContent=ts),za=n(e),K=p(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-armi85"&&(K.innerHTML=ns),ka=n(e),c(O.$$.fragment,e),Sa=n(e),ee=p(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-1bwtrpm"&&(ee.innerHTML=os),Wa=n(e),c(ae.$$.fragment,e),Va=n(e),le=p(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-b4eea9"&&(le.textContent=ps),Ra=n(e),c(se.$$.fragment,e),Aa=n(e),te=p(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-8jylbh"&&(te.innerHTML=is),Ea=n(e),c(ne.$$.fragment,e),_a=n(e),oe=p(e,"P",{"data-svelte-h":!0}),i(oe)!=="svelte-6thgaf"&&(oe.innerHTML=rs),Xa=n(e),c(pe.$$.fragment,e),Fa=n(e),ie=p(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-1wc47ui"&&(ie.innerHTML=cs),Ha=n(e),c(re.$$.fragment,e),Ya=n(e),ce=p(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-rdixsf"&&(ce.innerHTML=ds),La=n(e),c(de.$$.fragment,e),Da=n(e),me=p(e,"P",{"data-svelte-h":!0}),i(me)!=="svelte-la9joy"&&(me.textContent=ms),Pa=n(e),Me=p(e,"OL",{"data-svelte-h":!0}),i(Me)!=="svelte-1ye7pht"&&(Me.innerHTML=Ms),Ka=n(e),ue=p(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-133r6q9"&&(ue.textContent=us),Oa=n(e),c(ye.$$.fragment,e),el=n(e),Je=p(e,"P",{"data-svelte-h":!0}),i(Je)!=="svelte-1p187t0"&&(Je.textContent=ys),al=n(e),c(je.$$.fragment,e),ll=n(e),c(Te.$$.fragment,e),sl=n(e),Ue=p(e,"P",{"data-svelte-h":!0}),i(Ue)!=="svelte-1qz0jzs"&&(Ue.innerHTML=Js),tl=n(e),c(he.$$.fragment,e),nl=n(e),ge=p(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-17nfmw6"&&(ge.innerHTML=js),ol=n(e),c(be.$$.fragment,e),pl=n(e),Ie=p(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1mmcncx"&&(Ie.innerHTML=Ts),il=n(e),c(U.$$.fragment,e),rl=n(e),c(we.$$.fragment,e),cl=n(e),fe=p(e,"P",{"data-svelte-h":!0}),i(fe)!=="svelte-12vlb7o"&&(fe.innerHTML=Us),dl=n(e),Ce=p(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-1rxm1sh"&&(Ce.innerHTML=hs),ml=n(e),c(xe.$$.fragment,e),Ml=n(e),Ne=p(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-1ejy1v1"&&(Ne.textContent=gs),ul=n(e),Ze=p(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-10akn5t"&&(Ze.textContent=bs),yl=n(e),c(Ge.$$.fragment,e),Jl=n(e),$e=p(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-1cjwvby"&&($e.innerHTML=Is),jl=n(e),c(ve.$$.fragment,e),Tl=n(e),Qe=p(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-qmazoj"&&(Qe.innerHTML=ws),Ul=n(e),c(Be.$$.fragment,e),hl=n(e),qe=p(e,"P",{"data-svelte-h":!0}),i(qe)!=="svelte-75s9dc"&&(qe.innerHTML=fs),gl=n(e),c(ze.$$.fragment,e),bl=n(e),ke=p(e,"P",{"data-svelte-h":!0}),i(ke)!=="svelte-2agtjv"&&(ke.innerHTML=Cs),Il=n(e),Se=p(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-1cbn5uy"&&(Se.innerHTML=xs),wl=n(e),We=p(e,"P",{"data-svelte-h":!0}),i(We)!=="svelte-1vknwmr"&&(We.textContent=Ns),fl=n(e),c(Ve.$$.fragment,e),Cl=n(e),Re=p(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-1mu3vhf"&&(Re.textContent=Zs),xl=n(e),Ae=p(e,"P",{"data-svelte-h":!0}),i(Ae)!=="svelte-1c4k6nd"&&(Ae.innerHTML=Gs),Nl=n(e),Ee=p(e,"P",{"data-svelte-h":!0}),i(Ee)!=="svelte-wy4uv8"&&(Ee.textContent=$s),Zl=n(e),c(_e.$$.fragment,e),Gl=n(e),Xe=p(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-jn1v9i"&&(Xe.textContent=vs),$l=n(e),c(Fe.$$.fragment,e),vl=n(e),He=p(e,"P",{"data-svelte-h":!0}),i(He)!=="svelte-1r8mvq4"&&(He.innerHTML=Qs),Ql=n(e),c(Ye.$$.fragment,e),Bl=n(e),Le=p(e,"P",{"data-svelte-h":!0}),i(Le)!=="svelte-1jodhg5"&&(Le.textContent=Bs),ql=n(e),c(De.$$.fragment,e),zl=n(e),Pe=p(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-1kjq1u7"&&(Pe.innerHTML=qs),kl=n(e),c(Ke.$$.fragment,e),Sl=n(e),Oe=p(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-u5rm79"&&(Oe.innerHTML=zs),Wl=n(e),c(ea.$$.fragment,e),Vl=n(e),c(aa.$$.fragment,e),Rl=n(e),la=p(e,"P",{"data-svelte-h":!0}),i(la)!=="svelte-tw1nyq"&&(la.innerHTML=ks),Al=n(e),ta=p(e,"P",{}),Ws(ta).forEach(l),this.h()},h(){Vs(J,"name","hf:doc:metadata"),Vs(J,"content",Ps)},m(e,a){Hs(document.head,J),s(e,h,a),s(e,T,a),s(e,sa,a),d(g,e,a),s(e,oa,a),d(b,e,a),s(e,pa,a),s(e,I,a),s(e,ia,a),d(w,e,a),s(e,ra,a),s(e,f,a),s(e,ca,a),d(C,e,a),s(e,da,a),s(e,x,a),s(e,ma,a),d(N,e,a),s(e,Ma,a),s(e,Z,a),s(e,ua,a),s(e,G,a),s(e,ya,a),d($,e,a),s(e,Ja,a),s(e,v,a),s(e,ja,a),d(Q,e,a),s(e,Ta,a),s(e,B,a),s(e,Ua,a),d(q,e,a),s(e,ha,a),s(e,z,a),s(e,ga,a),d(k,e,a),s(e,ba,a),s(e,S,a),s(e,Ia,a),d(W,e,a),s(e,wa,a),s(e,V,a),s(e,fa,a),d(R,e,a),s(e,Ca,a),d(A,e,a),s(e,xa,a),s(e,E,a),s(e,Na,a),d(_,e,a),s(e,Za,a),s(e,X,a),s(e,Ga,a),d(F,e,a),s(e,$a,a),s(e,H,a),s(e,va,a),d(Y,e,a),s(e,Qa,a),s(e,L,a),s(e,Ba,a),d(D,e,a),s(e,qa,a),s(e,P,a),s(e,za,a),s(e,K,a),s(e,ka,a),d(O,e,a),s(e,Sa,a),s(e,ee,a),s(e,Wa,a),d(ae,e,a),s(e,Va,a),s(e,le,a),s(e,Ra,a),d(se,e,a),s(e,Aa,a),s(e,te,a),s(e,Ea,a),d(ne,e,a),s(e,_a,a),s(e,oe,a),s(e,Xa,a),d(pe,e,a),s(e,Fa,a),s(e,ie,a),s(e,Ha,a),d(re,e,a),s(e,Ya,a),s(e,ce,a),s(e,La,a),d(de,e,a),s(e,Da,a),s(e,me,a),s(e,Pa,a),s(e,Me,a),s(e,Ka,a),s(e,ue,a),s(e,Oa,a),d(ye,e,a),s(e,el,a),s(e,Je,a),s(e,al,a),d(je,e,a),s(e,ll,a),d(Te,e,a),s(e,sl,a),s(e,Ue,a),s(e,tl,a),d(he,e,a),s(e,nl,a),s(e,ge,a),s(e,ol,a),d(be,e,a),s(e,pl,a),s(e,Ie,a),s(e,il,a),d(U,e,a),s(e,rl,a),d(we,e,a),s(e,cl,a),s(e,fe,a),s(e,dl,a),s(e,Ce,a),s(e,ml,a),d(xe,e,a),s(e,Ml,a),s(e,Ne,a),s(e,ul,a),s(e,Ze,a),s(e,yl,a),d(Ge,e,a),s(e,Jl,a),s(e,$e,a),s(e,jl,a),d(ve,e,a),s(e,Tl,a),s(e,Qe,a),s(e,Ul,a),d(Be,e,a),s(e,hl,a),s(e,qe,a),s(e,gl,a),d(ze,e,a),s(e,bl,a),s(e,ke,a),s(e,Il,a),s(e,Se,a),s(e,wl,a),s(e,We,a),s(e,fl,a),d(Ve,e,a),s(e,Cl,a),s(e,Re,a),s(e,xl,a),s(e,Ae,a),s(e,Nl,a),s(e,Ee,a),s(e,Zl,a),d(_e,e,a),s(e,Gl,a),s(e,Xe,a),s(e,$l,a),d(Fe,e,a),s(e,vl,a),s(e,He,a),s(e,Ql,a),d(Ye,e,a),s(e,Bl,a),s(e,Le,a),s(e,ql,a),d(De,e,a),s(e,zl,a),s(e,Pe,a),s(e,kl,a),d(Ke,e,a),s(e,Sl,a),s(e,Oe,a),s(e,Wl,a),d(ea,e,a),s(e,Vl,a),d(aa,e,a),s(e,Rl,a),s(e,la,a),s(e,Al,a),s(e,ta,a),El=!0},p(e,[a]){const Ss={};a&2&&(Ss.$$scope={dirty:a,ctx:e}),U.$set(Ss)},i(e){El||(m(g.$$.fragment,e),m(b.$$.fragment,e),m(w.$$.fragment,e),m(C.$$.fragment,e),m(N.$$.fragment,e),m($.$$.fragment,e),m(Q.$$.fragment,e),m(q.$$.fragment,e),m(k.$$.fragment,e),m(W.$$.fragment,e),m(R.$$.fragment,e),m(A.$$.fragment,e),m(_.$$.fragment,e),m(F.$$.fragment,e),m(Y.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(ae.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(de.$$.fragment,e),m(ye.$$.fragment,e),m(je.$$.fragment,e),m(Te.$$.fragment,e),m(he.$$.fragment,e),m(be.$$.fragment,e),m(U.$$.fragment,e),m(we.$$.fragment,e),m(xe.$$.fragment,e),m(Ge.$$.fragment,e),m(ve.$$.fragment,e),m(Be.$$.fragment,e),m(ze.$$.fragment,e),m(Ve.$$.fragment,e),m(_e.$$.fragment,e),m(Fe.$$.fragment,e),m(Ye.$$.fragment,e),m(De.$$.fragment,e),m(Ke.$$.fragment,e),m(ea.$$.fragment,e),m(aa.$$.fragment,e),El=!0)},o(e){M(g.$$.fragment,e),M(b.$$.fragment,e),M(w.$$.fragment,e),M(C.$$.fragment,e),M(N.$$.fragment,e),M($.$$.fragment,e),M(Q.$$.fragment,e),M(q.$$.fragment,e),M(k.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(A.$$.fragment,e),M(_.$$.fragment,e),M(F.$$.fragment,e),M(Y.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(ae.$$.fragment,e),M(se.$$.fragment,e),M(ne.$$.fragment,e),M(pe.$$.fragment,e),M(re.$$.fragment,e),M(de.$$.fragment,e),M(ye.$$.fragment,e),M(je.$$.fragment,e),M(Te.$$.fragment,e),M(he.$$.fragment,e),M(be.$$.fragment,e),M(U.$$.fragment,e),M(we.$$.fragment,e),M(xe.$$.fragment,e),M(Ge.$$.fragment,e),M(ve.$$.fragment,e),M(Be.$$.fragment,e),M(ze.$$.fragment,e),M(Ve.$$.fragment,e),M(_e.$$.fragment,e),M(Fe.$$.fragment,e),M(Ye.$$.fragment,e),M(De.$$.fragment,e),M(Ke.$$.fragment,e),M(ea.$$.fragment,e),M(aa.$$.fragment,e),El=!1},d(e){e&&(l(h),l(T),l(sa),l(oa),l(pa),l(I),l(ia),l(ra),l(f),l(ca),l(da),l(x),l(ma),l(Ma),l(Z),l(ua),l(G),l(ya),l(Ja),l(v),l(ja),l(Ta),l(B),l(Ua),l(ha),l(z),l(ga),l(ba),l(S),l(Ia),l(wa),l(V),l(fa),l(Ca),l(xa),l(E),l(Na),l(Za),l(X),l(Ga),l($a),l(H),l(va),l(Qa),l(L),l(Ba),l(qa),l(P),l(za),l(K),l(ka),l(Sa),l(ee),l(Wa),l(Va),l(le),l(Ra),l(Aa),l(te),l(Ea),l(_a),l(oe),l(Xa),l(Fa),l(ie),l(Ha),l(Ya),l(ce),l(La),l(Da),l(me),l(Pa),l(Me),l(Ka),l(ue),l(Oa),l(el),l(Je),l(al),l(ll),l(sl),l(Ue),l(tl),l(nl),l(ge),l(ol),l(pl),l(Ie),l(il),l(rl),l(cl),l(fe),l(dl),l(Ce),l(ml),l(Ml),l(Ne),l(ul),l(Ze),l(yl),l(Jl),l($e),l(jl),l(Tl),l(Qe),l(Ul),l(hl),l(qe),l(gl),l(bl),l(ke),l(Il),l(Se),l(wl),l(We),l(fl),l(Cl),l(Re),l(xl),l(Ae),l(Nl),l(Ee),l(Zl),l(Gl),l(Xe),l($l),l(vl),l(He),l(Ql),l(Bl),l(Le),l(ql),l(zl),l(Pe),l(kl),l(Sl),l(Oe),l(Wl),l(Vl),l(Rl),l(la),l(Al),l(ta)),l(J),u(g,e),u(b,e),u(w,e),u(C,e),u(N,e),u($,e),u(Q,e),u(q,e),u(k,e),u(W,e),u(R,e),u(A,e),u(_,e),u(F,e),u(Y,e),u(D,e),u(O,e),u(ae,e),u(se,e),u(ne,e),u(pe,e),u(re,e),u(de,e),u(ye,e),u(je,e),u(Te,e),u(he,e),u(be,e),u(U,e),u(we,e),u(xe,e),u(Ge,e),u(ve,e),u(Be,e),u(ze,e),u(Ve,e),u(_e,e),u(Fe,e),u(Ye,e),u(De,e),u(Ke,e),u(ea,e),u(aa,e)}}}const Ps='{"title":"Plantillas para Modelos de Chat","local":"plantillas-para-modelos-de-chat","sections":[{"title":"Introducción","local":"introducción","sections":[],"depth":2},{"title":"¿Cómo uso las plantillas de chat?","local":"cómo-uso-las-plantillas-de-chat","sections":[],"depth":2},{"title":"¿Existe un pipeline automatizado para chats?","local":"existe-un-pipeline-automatizado-para-chats","sections":[],"depth":2}],"depth":1}';function Ks(na){return As(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class tt extends _s{constructor(J){super(),Xs(this,J,Ks,Ds,Rs,{})}}export{tt as component};
