import{s as ls,n as ts,o as ss}from"../chunks/scheduler.00bde567.js";import{S as as,i as ns,g as o,s as a,r as p,A as os,h as i,f as t,c as n,j as es,u as M,x as r,k as u,y as is,a as s,v as c,d,t as m,w as y}from"../chunks/index.752e2ff6.js";import{C as h}from"../chunks/CodeBlock.e62cd1dc.js";import{H as J}from"../chunks/Heading.476d3364.js";function rs(Mt){let T,Ae,Ye,He,G,Ee,X,ct=`<a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">Megatron-LM</a> enables training large transformer language models at scale.
It provides efficient tensor, pipeline and sequence based model parallelism for pre-training transformer based
Language Models such as <a href="https://arxiv.org/abs/2005.14165" rel="nofollow">GPT</a> (Decoder Only), <a href="https://arxiv.org/pdf/1810.04805.pdf" rel="nofollow">BERT</a> (Encoder Only) and <a href="https://arxiv.org/abs/1910.10683" rel="nofollow">T5</a> (Encoder-Decoder).
For detailed information and how things work behind the scene please refer the github <a href="https://github.com/NVIDIA/Megatron-LM" rel="nofollow">repo</a>.`,Le,k,xe,W,dt=`Accelerate integrates following feature of Megatron-LM to enable large scale pre-training/finetuning
of BERT (Encoder), GPT (Decoder) or T5 models (Encoder and Decoder):`,Qe,v,mt=`a. <strong>Tensor Parallelism (TP)</strong>: Reduces memory footprint without much additional communication on intra-node ranks.
Each tensor is split into multiple chunks with each shard residing on separate GPU. At each step, the same mini-batch of data is processed
independently and in parallel by each shard followed by syncing across all GPUs (<code>all-reduce</code> operation).
In a simple transformer layer, this leads to 2 <code>all-reduces</code> in the forward path and 2 in the backward path.
For more details, please refer research paper <a href="https://arxiv.org/pdf/1909.08053.pdf" rel="nofollow">Megatron-LM: Training Multi-Billion Parameter Language Models Using
Model Parallelism</a> and
this section of 🤗 blogpost <a href="https://huggingface.co/blog/bloom-megatron-deepspeed#tensor-parallelism" rel="nofollow">The Technology Behind BLOOM Training</a>.`,Se,R,yt=`b. <strong>Pipeline Parallelism (PP)</strong>: Reduces memory footprint and enables large scale training via inter-node parallelization.
Reduces the bubble of naive PP via PipeDream-Flush schedule/1F1B schedule and Interleaved 1F1B schedule.
Layers are distributed uniformly across PP stages. For example, if a model has <code>24</code> layers and we have <code>4</code> GPUs for
pipeline parallelism, each GPU will have <code>6</code> layers (24/4). For more details on schedules to reduce the idle time of PP,
please refer to the research paper <a href="https://arxiv.org/pdf/2104.04473.pdf" rel="nofollow">Efficient Large-Scale Language Model Training on GPU Clusters
Using Megatron-LM</a> and
this section of 🤗 blogpost <a href="https://huggingface.co/blog/bloom-megatron-deepspeed#pipeline-parallelism" rel="nofollow">The Technology Behind BLOOM Training</a>.`,$e,V,ht=`c. <strong>Sequence Parallelism (SP)</strong>: Reduces memory footprint without any additional communication. Only applicable when using TP.
It reduces activation memory required as it prevents the same copies to be on the tensor parallel ranks
post <code>all-reduce</code> by replacing then with <code>reduce-scatter</code> and <code>no-op</code> operation would be replaced by <code>all-gather</code>.
As <code>all-reduce = reduce-scatter + all-gather</code>, this saves a ton of activation memory at no added communication cost.
To put it simply, it shards the outputs of each transformer layer along sequence dimension, e.g.,
if the sequence length is <code>1024</code> and the TP size is <code>4</code>, each GPU will have <code>256</code> tokens (1024/4) for each sample.
This increases the batch size that can be supported for training. For more details, please refer to the research paper
<a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Reducing Activation Recomputation in Large Transformer Models</a>.`,qe,N,ut=`d. <strong>Data Parallelism (DP)</strong> via Distributed Optimizer: Reduces the memory footprint by sharding optimizer states and gradients across DP ranks
(versus the traditional method of replicating the optimizer state across data parallel ranks).
For example, when using Adam optimizer with mixed-precision training, each parameter accounts for 12 bytes of memory.
This gets distributed equally across the GPUs, i.e., each parameter would account for 3 bytes (12/4) if we have 4 GPUs.
For more details, please refer the research paper <a href="https://arxiv.org/pdf/1910.02054.pdf" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion
Parameter Models</a> and following section of 🤗 blog
<a href="https://huggingface.co/blog/bloom-megatron-deepspeed#zero-data-parallelism" rel="nofollow">The Technology Behind BLOOM Training</a>.`,Pe,z,Tt=`e. <strong>Selective Activation Recomputation</strong>: Reduces the memory footprint of activations significantly via smart activation checkpointing.
It doesn’t store activations occupying large memory while being fast to recompute thereby achieving great tradeoff between memory and recomputation.
For example, for GPT-3, this leads to 70% reduction in required memory for activations at the expense of
only 2.7% FLOPs overhead for recomputation of activations. For more details, please refer to the research paper
<a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Reducing Activation Recomputation in Large Transformer Models</a>.`,De,Y,Jt=`f. <strong>Fused Kernels</strong>: Fused Softmax, Mixed Precision Fused Layer Norm and  Fused gradient accumulation to weight gradient computation of linear layer.
PyTorch JIT compiled Fused GeLU and Fused Bias+Dropout+Residual addition.`,Ke,F,Ut="g. <strong>Support for Indexed datasets</strong>: Efficient binary format of datasets for large scale training. Support for the <code>mmap</code>, <code>cached</code> index file and the <code>lazy</code> loader format.",Oe,A,wt=`h. <strong>Checkpoint reshaping and interoperability</strong>: Utility for reshaping Megatron-LM checkpoints of variable
tensor and pipeline parallel sizes to the beloved 🤗 Transformers sharded checkpoints as it has great support with plethora of tools
such as 🤗 Accelerate Big Model Inference, Megatron-DeepSpeed Inference etc.
Support is also available for converting 🤗 Transformers sharded checkpoints to Megatron-LM checkpoint of variable tensor and pipeline parallel sizes
for large scale training.`,el,H,ll,E,bt=`You will need to install the latest pytorch, cuda, nccl, and NVIDIA <a href="https://github.com/NVIDIA/apex#quick-start" rel="nofollow">APEX</a> releases and the nltk library.
See <a href="https://github.com/NVIDIA/Megatron-LM#setup" rel="nofollow">documentation</a> for more details.
Another way to setup the environment is to pull an NVIDIA PyTorch Container that comes with all the required installations from NGC.`,tl,L,jt="Below is a step-by-step method to set up the conda environment:",sl,x,gt="<li>Create a virtual environment</li>",al,Q,nl,U,ft="<li>Assuming that the machine has CUDA 11.3 installed, installing the corresponding PyTorch GPU Version</li>",ol,S,il,w,_t="<li>Install Nvidia APEX</li>",rl,$,pl,b,It="<li>Installing Megatron-LM</li>",Ml,q,cl,P,dl,D,Ct=`Important features are directly supported via the <code>accelerate config</code> command.
An example of thr corresponding questions for using Megatron-LM features is shown below:`,ml,K,yl,O,Zt="The resulting config is shown below:",hl,ee,ul,le,Bt=`We will take the example of GPT pre-training. The minimal changes required to the official <code>run_clm_no_trainer.py</code>
to use Megatron-LM are as follows:`,Tl,te,Gt=`<li>As Megatron-LM uses its own implementation of Optimizer, the corresponding scheduler compatible with it needs to be used.
As such, support for only the Megatron-LM’s scheduler is present. User will need to create <code>accelerate.utils.MegatronLMDummyScheduler</code>.
Example is given below:</li>`,Jl,se,Ul,j,Xt=`<li>Getting the details of the total batch size now needs to be cognization of tensor and pipeline parallel sizes.
Example of getting the effective total batch size is shown below:</li>`,wl,ae,bl,g,kt="<li>When using Megatron-LM, the losses are already averaged across the data parallel group</li>",jl,ne,gl,f,Wt="<li>For Megatron-LM, we need to save the model using <code>accelerator.save_state</code></li>",fl,oe,_l,ie,vt=`That’s it! We are good to go 🚀. Please find the example script in the examples folder at the path <code>accelerate/examples/by_feature/megatron_lm_gpt_pretraining.py</code>.
Let’s run it for <code>gpt-large</code> model architecture using 4 A100-80GB GPUs.`,Il,re,Cl,pe,Rt="Below are some important excerpts from the output logs:",Zl,Me,Bl,ce,Vt="There are a large number of other options/features that one can set using <code>accelerate.utils.MegatronLMPlugin</code>.",Gl,de,Xl,me,Nt="For leveraging more features, please go through below details.",kl,ye,zt=`<li>Below is an example of changes required to customize the Train Step while using Megatron-LM.
You will implement the <code>accelerate.utils.AbstractTrainStep</code> or inherit from their corresponding children
<code>accelerate.utils.GPTTrainStep</code>, <code>accelerate.utils.BertTrainStep</code> or <code>accelerate.utils.T5TrainStep</code>.</li>`,Wl,he,vl,_,Yt=`<li>For using the Megatron-LM datasets, a few more changes are required. Dataloaders for these datasets
are available only on rank 0 of each tensor parallel group. As such, there are rank where dataloader won’t be
avaiable and this requires tweaks to the training loop. Being able to do all this shows how
felixble and extensible 🤗 Accelerate is. The changes required are as follows.</li>`,Rl,ue,Ft=`a. For Megatron-LM indexed datasets, we need to use <code>MegatronLMDummyDataLoader</code>
and pass the required dataset args to it such as <code>data_path</code>, <code>seq_length</code> etc.
See <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/arguments.py#L804" rel="nofollow">here</a> for the list of available args.`,Vl,Te,Nl,Je,At=`b. <code>megatron_dataloader</code> is repeated 3 times to get training, validation and test dataloaders
as per the <code>args.splits_string</code> proportions`,zl,Ue,Yl,we,Ht=`c. Changes to training and evaluation loops as dataloader is only available on tensor parallel ranks 0
So, we need to iterate only if the dataloader isn’t <code>None</code> else provide empty dict
As such, we loop using <code>while</code> loop and break when <code>completed_steps</code> is equal to <code>args.max_train_steps</code>
This is similar to the Megatron-LM setup wherein user has to provide <code>max_train_steps</code> when using Megaton-LM indexed datasets.
This displays how flexible and extensible 🤗 Accelerate is.`,Fl,be,Al,je,Hl,ge,Et=`<li><p>The scripts for these are present in 🤗 Transformers library under respective models.
Currently, it is available for GPT model <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/megatron_gpt2/checkpoint_reshaping_and_interoperability.py" rel="nofollow">checkpoint_reshaping_and_interoperability.py</a></p></li> <li><p>Below is an example of conversion of checkpoint from Megatron-LM to universal 🤗 Transformers sharded checkpoint.</p></li>`,El,fe,Ll,I,Lt="<li>Conversion of checkpoint from transformers to megatron with <code>tp_size=2</code>, <code>pp_size=2</code> and <code>dp_size=2</code>.</li>",xl,_e,Ql,Ie,Sl,Ce,xt=`<li>Returning logits require setting <code>require_logits=True</code> in MegatronLMPlugin as shown below.
These would be available on the in the last stage of pipeline.</li>`,$l,Ze,ql,C,Qt=`<li><code>megatron_generate</code> method for Megatron-LM GPT model: This will use Tensor and Pipeline Parallelism to complete
generations for a batch of inputs when using greedy with/without top_k/top_p sampling and for individual prompt inputs when using beam search decoding.
Only a subset of features of transformers generate is supported. This will help in using large models via tensor and pipeline parallelism
for generation (already does key-value caching and uses fused kernels by default).
This requires data parallel size to be 1, sequence parallelism and activation checkpointing to be disabled.
It also requires specifying path to tokenizer’s vocab file and merges file.
Below example shows how to configure and use <code>megatron_generate</code> method for Megatron-LM GPT model.</li>`,Pl,Be,Dl,Z,St=`<li>An end-to-end example of using <code>megatron_generate</code> method for Megatron-LM GPT model is available at
<a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/src/inference/megatron_gpt2_generation.py" rel="nofollow">megatron_gpt2_generation.py</a> with
config file <a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/src/Configs/megatron_lm_gpt_generate_config.yaml" rel="nofollow">megatron_lm_gpt_generate_config.yaml</a>.
The bash script with accelerate launch command is available at <a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/megatron_lm_gpt_generate.sh" rel="nofollow">megatron_lm_gpt_generate.sh</a>.
The output logs of the script are available at <a href="https://github.com/pacman100/accelerate-megatron-test/blob/main/output_logs/megatron_lm_gpt_generate.log" rel="nofollow">megatron_lm_gpt_generate.log</a>.</li>`,Kl,Ge,Ol,Xe,$t="<li>For ROPE/ALiBi attention, pass <code>position_embedding_type</code> with <code>(&quot;absolute&quot; | &quot;rotary&quot; | &quot;alibi&quot;)</code> to <code>MegatronLMPlugin</code> as shown below.</li>",et,ke,lt,B,qt="<li>For Multi-Query Attention, pass <code>attention_head_type</code> with <code>(&quot;multihead&quot; | &quot;multiquery&quot;)</code> to <code>MegatronLMPlugin</code> as shown below.</li>",tt,We,st,ve,at,Re,Pt=`<li><p>Supports Transformers GPT2, Megatron-BERT and T5 models.
This covers Decoder only, Encode only and Encoder-Decoder model classes.</p></li> <li><p>Only loss is returned from model forward pass as
there is quite complex interplay of pipeline, tensor and data parallelsim behind the scenes.
The <code>model(**batch_data)</code> call return loss(es) averaged across the data parallel ranks.
This is fine for most cases wherein pre-training jobs are run using Megatron-LM features and
you can easily compute the <code>perplexity</code> using the loss.
For GPT model, returning logits in addition to loss(es) is supported.
These logits aren’t gathered across data prallel ranks. Use <code>accelerator.utils.gather_across_data_parallel_groups</code>
to gather logits across data parallel ranks. These logits along with labels can be used for computing various
performance metrics.</p></li> <li><p>The main process is the last rank as the losses/logits are available in the last stage of pipeline.
<code>accelerator.is_main_process</code> and <code>accelerator.is_local_main_process</code> return <code>True</code> for last rank when using
Megatron-LM integration.</p></li> <li><p>In <code>accelerator.prepare</code> call, a Megatron-LM model corresponding to a given Transformers model is created
with random weights. Please use <code>accelerator.load_state</code> to load the Megatron-LM checkpoint with matching TP, PP and DP partitions.</p></li> <li><p>Currently, checkpoint reshaping and interoperability support is only available for GPT.
Soon it will be extended to BERT and T5.</p></li> <li><p><code>gradient_accumulation_steps</code> needs to be 1. When using Megatron-LM, micro batches in pipeline parallelism
setting is synonymous with gradient accumulation.</p></li> <li><p>When using Megatron-LM, use <code>accelerator.save_state</code> and <code>accelerator.load_state</code> for saving and loading checkpoints.</p></li> <li><p>Below are the mapping from Megatron-LM model architectures to the the equivalent 🤗 transformers model architectures.
Only these 🤗 transformers model architectures are supported.</p></li>`,nt,Ve,Dt=`a. Megatron-LM <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/model/bert_model.py" rel="nofollow">BertModel</a> :
🤗 transformers models with <code>megatron-bert</code> in config’s model type, e.g.,
<a href="https://huggingface.co/docs/transformers/model_doc/megatron-bert" rel="nofollow">MegatronBERT</a>`,ot,Ne,Kt=`b. Megatron-LM <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/model/gpt_model.py" rel="nofollow">GPTModel</a> :
🤗 transformers models with <code>gpt2</code> in config’s model type, e.g.,
<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">OpenAI GPT2</a>`,it,ze,Ot=`c. Megatron-LM <a href="https://github.com/NVIDIA/Megatron-LM/blob/main/megatron/model/t5_model.py" rel="nofollow">T5Model</a> :
🤗 transformers models with <code>t5</code> in  config’s model type, e.g.,
<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a> and
<a href="https://huggingface.co/docs/transformers/model_doc/mt5" rel="nofollow">MT5</a>`,rt,Fe,pt;return G=new J({props:{title:"Megatron-LM",local:"megatron-lm",headingTag:"h1"}}),k=new J({props:{title:"What is integrated?",local:"what-is-integrated",headingTag:"h2"}}),H=new J({props:{title:"Pre-Requisites",local:"pre-requisites",headingTag:"h2"}}),Q=new h({props:{code:"Y29uZGElMjBjcmVhdGUlMjAtLW5hbWUlMjBtbA==",highlighted:'conda <span class="hljs-built_in">create</span> <span class="hljs-comment">--name ml</span>',wrap:!1}}),S=new h({props:{code:"Y29uZGElMjBpbnN0YWxsJTIwcHl0b3JjaCUyMHRvcmNodmlzaW9uJTIwdG9yY2hhdWRpbyUyMGN1ZGF0b29sa2l0JTNEMTEuMyUyMC1jJTIwcHl0b3JjaA==",highlighted:'<span class="hljs-attribute">conda</span> install pytorch torchvision torchaudio cudatoolkit=<span class="hljs-number">11</span>.<span class="hljs-number">3</span> -c pytorch',wrap:!1}}),$=new h({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZOVklESUElMkZhcGV4JTBBY2QlMjBhcGV4JTBBcGlwJTIwaW5zdGFsbCUyMC12JTIwLS1kaXNhYmxlLXBpcC12ZXJzaW9uLWNoZWNrJTIwLS1uby1jYWNoZS1kaXIlMjAtLWdsb2JhbC1vcHRpb24lM0QlMjItLWNwcF9leHQlMjIlMjAtLWdsb2JhbC1vcHRpb24lM0QlMjItLWN1ZGFfZXh0JTIyJTIwLiUyRiUwQWNkJTIwLi4=",highlighted:`git clone https:<span class="hljs-string">//github.com/NVIDIA/apex</span>
<span class="hljs-keyword">cd</span> apex
pip install -v <span class="hljs-params">--disable-pip-version-check</span> <span class="hljs-params">--no-cache-dir</span> <span class="hljs-params">--global-option=</span><span class="hljs-string">&quot;--cpp_ext&quot;</span> <span class="hljs-params">--global-option=</span><span class="hljs-string">&quot;--cuda_ext&quot;</span> <span class="hljs-string">./</span>
<span class="hljs-keyword">cd</span> <span class="hljs-string">..</span>`,wrap:!1}}),q=new h({props:{code:"cGlwJTIwaW5zdGFsbCUyMGdpdCUyQmh0dHBzJTNBJTJGJTJGZ2l0aHViLmNvbSUyRmh1Z2dpbmdmYWNlJTJGTWVnYXRyb24tTE0uZ2l0",highlighted:'pip install git+https:<span class="hljs-regexp">//gi</span>thub.com<span class="hljs-regexp">/huggingface/</span>Megatron-LM.git',wrap:!1}}),P=new J({props:{title:"Accelerate Megatron-LM Plugin",local:"accelerate-megatron-lm-plugin",headingTag:"h2"}}),K=new h({props:{code:"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",highlighted:`:~$ accelerate config --config_file <span class="hljs-string">&quot;megatron_gpt_config.yaml&quot;</span>
In <span class="hljs-built_in">which</span> compute environment are you running? ([0] This machine, [1] AWS (Amazon SageMaker)): 0
Which <span class="hljs-built_in">type</span> of machine are you using? ([0] No distributed training, [1] multi-CPU, [2] multi-GPU, [3] TPU): 2
How many different machines will you use (use more than 1 <span class="hljs-keyword">for</span> multi-node training)? [1]: 
Do you want to use DeepSpeed? [<span class="hljs-built_in">yes</span>/NO]: 
Do you want to use FullyShardedDataParallel? [<span class="hljs-built_in">yes</span>/NO]: 
Do you want to use Megatron-LM ? [<span class="hljs-built_in">yes</span>/NO]: <span class="hljs-built_in">yes</span>
What is the Tensor Parallelism degree/size? [1]:2
Do you want to <span class="hljs-built_in">enable</span> Sequence Parallelism? [YES/no]: 
What is the Pipeline Parallelism degree/size? [1]:2
What is the number of micro-batches? [1]:2
Do you want to <span class="hljs-built_in">enable</span> selective activation recomputation? [YES/no]: 
Do you want to use distributed optimizer <span class="hljs-built_in">which</span> shards optimizer state and gradients across data pralellel ranks? [YES/no]: 
What is the gradient clipping value based on global L2 Norm (0 to <span class="hljs-built_in">disable</span>)? [1.0]: 
How many GPU(s) should be used <span class="hljs-keyword">for</span> distributed training? [1]:4
Do you wish to use FP16 or BF16 (mixed precision)? [NO/fp16/bf16]: bf16`,wrap:!1}}),ee=new h({props:{code:"fiUyNCUyMGNhdCUyMG1lZ2F0cm9uX2dwdF9jb25maWcueWFtbCUyMCUwQWNvbXB1dGVfZW52aXJvbm1lbnQlM0ElMjBMT0NBTF9NQUNISU5FJTBBZGVlcHNwZWVkX2NvbmZpZyUzQSUyMCU3QiU3RCUwQWRpc3RyaWJ1dGVkX3R5cGUlM0ElMjBNRUdBVFJPTl9MTSUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBZnNkcF9jb25maWclM0ElMjAlN0IlN0QlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl9wcm9jZXNzX2lwJTNBJTIwbnVsbCUwQW1haW5fcHJvY2Vzc19wb3J0JTNBJTIwbnVsbCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbWVnYXRyb25fbG1fY29uZmlnJTNBJTBBJTIwJTIwbWVnYXRyb25fbG1fZ3JhZGllbnRfY2xpcHBpbmclM0ElMjAxLjAlMEElMjAlMjBtZWdhdHJvbl9sbV9udW1fbWljcm9fYmF0Y2hlcyUzQSUyMDIlMEElMjAlMjBtZWdhdHJvbl9sbV9wcF9kZWdyZWUlM0ElMjAyJTBBJTIwJTIwbWVnYXRyb25fbG1fcmVjb21wdXRlX2FjdGl2YXRpb25zJTNBJTIwdHJ1ZSUwQSUyMCUyMG1lZ2F0cm9uX2xtX3NlcXVlbmNlX3BhcmFsbGVsaXNtJTNBJTIwdHJ1ZSUwQSUyMCUyMG1lZ2F0cm9uX2xtX3RwX2RlZ3JlZSUzQSUyMDIlMEElMjAlMjBtZWdhdHJvbl9sbV91c2VfZGlzdHJpYnV0ZWRfb3B0aW1pemVyJTNBJTIwdHJ1ZSUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDQlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-string">~$</span> <span class="hljs-string">cat</span> <span class="hljs-string">megatron_gpt_config.yaml</span> 
<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span> {}
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">MEGATRON_LM</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span> {}
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-literal">null</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">megatron_lm_config:</span>
  <span class="hljs-attr">megatron_lm_gradient_clipping:</span> <span class="hljs-number">1.0</span>
  <span class="hljs-attr">megatron_lm_num_micro_batches:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">megatron_lm_pp_degree:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">megatron_lm_recompute_activations:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">megatron_lm_sequence_parallelism:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">megatron_lm_tp_degree:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">megatron_lm_use_distributed_optimizer:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),se=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBNZWdhdHJvbkxNRHVtbXlTY2hlZHVsZXIlMEElMEFpZiUyMGFjY2VsZXJhdG9yLmRpc3RyaWJ1dGVkX3R5cGUlMjAlM0QlM0QlMjBEaXN0cmlidXRlZFR5cGUuTUVHQVRST05fTE0lM0ElMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBNZWdhdHJvbkxNRHVtbXlTY2hlZHVsZXIoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG90YWxfbnVtX3N0ZXBzJTNEYXJncy5tYXhfdHJhaW5fc3RlcHMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3YXJtdXBfbnVtX3N0ZXBzJTNEYXJncy5udW1fd2FybXVwX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBnZXRfc2NoZWR1bGVyKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5hbWUlM0RhcmdzLmxyX3NjaGVkdWxlcl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbnVtX3dhcm11cF9zdGVwcyUzRGFyZ3MubnVtX3dhcm11cF9zdGVwcyUyMColMjBhcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG51bV90cmFpbmluZ19zdGVwcyUzRGFyZ3MubWF4X3RyYWluX3N0ZXBzJTIwKiUyMGFyZ3MuZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTJDJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> MegatronLMDummyScheduler

<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    lr_scheduler = MegatronLMDummyScheduler(
        optimizer=optimizer,
        total_num_steps=args.max_train_steps,
        warmup_num_steps=args.num_warmup_steps,
    )
<span class="hljs-keyword">else</span>:
    lr_scheduler = get_scheduler(
        name=args.lr_scheduler_type,
        optimizer=optimizer,
        num_warmup_steps=args.num_warmup_steps * args.gradient_accumulation_steps,
        num_training_steps=args.max_train_steps * args.gradient_accumulation_steps,
    )`,wrap:!1}}),ae=new h({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwdG90YWxfYmF0Y2hfc2l6ZSUyMCUzRCUyMGFjY2VsZXJhdG9yLnN0YXRlLm1lZ2F0cm9uX2xtX3BsdWdpbi5nbG9iYWxfYmF0Y2hfc2l6ZSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjB0b3RhbF9iYXRjaF9zaXplJTIwJTNEJTIwYXJncy5wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAqJTIwYWNjZWxlcmF0b3IubnVtX3Byb2Nlc3NlcyUyMColMjBhcmdzLmdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcw==",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    total_batch_size = accelerator.state.megatron_lm_plugin.global_batch_size
<span class="hljs-keyword">else</span>:
    total_batch_size = args.per_device_train_batch_size * accelerator.num_processes * args.gradient_accumulation_steps`,wrap:!1}}),ne=new h({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwbG9zc2VzLmFwcGVuZChsb3NzKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBsb3NzZXMuYXBwZW5kKGFjY2VsZXJhdG9yLmdhdGhlcl9mb3JfbWV0cmljcyhsb3NzLnJlcGVhdChhcmdzLnBlcl9kZXZpY2VfZXZhbF9iYXRjaF9zaXplKSkpJTBBJTBBaWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwbG9zc2VzJTIwJTNEJTIwdG9yY2gudGVuc29yKGxvc3NlcyklMEFlbHNlJTNBJTBBJTIwJTIwJTIwJTIwbG9zc2VzJTIwJTNEJTIwdG9yY2guY2F0KGxvc3Nlcyk=",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    losses.append(loss)
<span class="hljs-keyword">else</span>:
    losses.append(accelerator.gather_for_metrics(loss.repeat(args.per_device_eval_batch_size)))

<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    losses = torch.tensor(losses)
<span class="hljs-keyword">else</span>:
    losses = torch.cat(losses)`,wrap:!1}}),oe=new h({props:{code:"aWYlMjBhY2NlbGVyYXRvci5kaXN0cmlidXRlZF90eXBlJTIwJTNEJTNEJTIwRGlzdHJpYnV0ZWRUeXBlLk1FR0FUUk9OX0xNJTNBJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc2F2ZV9zdGF0ZShhcmdzLm91dHB1dF9kaXIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHVud3JhcHBlZF9tb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEElMjAlMjAlMjAlMjB1bndyYXBwZWRfbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFyZ3Mub3V0cHV0X2RpciUyQyUyMGlzX21haW5fcHJvY2VzcyUzRGFjY2VsZXJhdG9yLmlzX21haW5fcHJvY2VzcyUyQyUyMHNhdmVfZnVuY3Rpb24lM0RhY2NlbGVyYXRvci5zYXZlJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> accelerator.distributed_type == DistributedType.MEGATRON_LM:
    accelerator.save_state(args.output_dir)
<span class="hljs-keyword">else</span>:
    unwrapped_model = accelerator.unwrap_model(model)
    unwrapped_model.save_pretrained(
        args.output_dir, is_main_process=accelerator.is_main_process, save_function=accelerator.save
    )`,wrap:!1}}),re=new h({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tY29uZmlnX2ZpbGUlMjBtZWdhdHJvbl9ncHRfY29uZmlnLnlhbWwlMjAlNUMlMEFleGFtcGxlcyUyRmJ5X2ZlYXR1cmUlMkZtZWdhdHJvbl9sbV9ncHRfcHJldHJhaW5pbmcucHklMjAlNUMlMEEtLWNvbmZpZ19uYW1lJTIwJTIyZ3B0Mi1sYXJnZSUyMiUyMCU1QyUwQS0tdG9rZW5pemVyX25hbWUlMjAlMjJncHQyLWxhcmdlJTIyJTIwJTVDJTBBLS1kYXRhc2V0X25hbWUlMjB3aWtpdGV4dCUyMCU1QyUwQS0tZGF0YXNldF9jb25maWdfbmFtZSUyMHdpa2l0ZXh0LTItcmF3LXYxJTIwJTVDJTBBLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQS0tbGVhcm5pbmdfcmF0ZSUyMDVlLTUlMjAlNUMlMEEtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDI0JTIwJTVDJTBBLS1wZXJfZGV2aWNlX2V2YWxfYmF0Y2hfc2l6ZSUyMDI0JTIwJTVDJTBBLS1udW1fdHJhaW5fZXBvY2hzJTIwNSUyMCU1QyUwQS0td2l0aF90cmFja2luZyUyMCU1QyUwQS0tcmVwb3J0X3RvJTIwJTIyd2FuZGIlMjIlMjAlNUMlMEEtLW91dHB1dF9kaXIlMjAlMjJhd2Vzb21lX21vZGVsJTIy",highlighted:`accelerate launch --config_file megatron_gpt_config.yaml \\
examples/by_feature/megatron_lm_gpt_pretraining.py \\
--config_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2-large&quot;</span> \\
--dataset_name wikitext \\
--dataset_config_name wikitext-2-raw-v1 \\
--block_size 1024 \\
--learning_rate 5e-5 \\
--per_device_train_batch_size 24 \\
--per_device_eval_batch_size 24 \\
--num_train_epochs 5 \\
--with_tracking \\
--report_to <span class="hljs-string">&quot;wandb&quot;</span> \\
--output_dir <span class="hljs-string">&quot;awesome_model&quot;</span>`,wrap:!1}}),Me=new h({props:{code:"ZG9uZSUyMHdpdGglMjBjb21waWxpbmclMjBhbmQlMjBsb2FkaW5nJTIwZnVzZWQlMjBrZXJuZWxzLiUyMENvbXBpbGF0aW9uJTIwdGltZSUzQSUyMDMuNTY5JTIwc2Vjb25kcw==",highlighted:`Loading extension module fused_dense_cuda...
&gt;&gt;&gt; <span class="hljs-keyword">done</span> with compiling and loading fused kernels. Compilation time: 3.569 seconds
 &gt; padded vocab (size: 50257) with 175 dummy tokens (new size: 50432)
Building gpt model <span class="hljs-keyword">in</span> the pre-training mode.
The Megatron LM model weights are initialized at random <span class="hljs-keyword">in</span> \`accelerator.prepare\`. Please use \`accelerator.load_checkpoint\` to load a pre-trained checkpoint matching the distributed setup.
Preparing dataloader
Preparing dataloader
Preparing model
 &gt; number of parameters on (tensor, pipeline) model parallel rank (1, 0): 210753280
 &gt; number of parameters on (tensor, pipeline) model parallel rank (1, 1): 209445120
 &gt; number of parameters on (tensor, pipeline) model parallel rank (0, 0): 210753280
 &gt; number of parameters on (tensor, pipeline) model parallel rank (0, 1): 209445120
Preparing optimizer
Preparing scheduler
&gt; learning rate decay style: linear
10/10/2022 22:57:22 - INFO - __main__ - ***** Running training *****
10/10/2022 22:57:22 - INFO - __main__ -   Num examples = 2318
10/10/2022 22:57:22 - INFO - __main__ -   Num Epochs = 5
10/10/2022 22:57:22 - INFO - __main__ -   Instantaneous batch size per device = 24
10/10/2022 22:57:22 - INFO - __main__ -   Total train batch size (w. parallel, distributed &amp; accumulation) = 48
10/10/2022 22:57:22 - INFO - __main__ -   Gradient Accumulation steps = 1
10/10/2022 22:57:22 - INFO - __main__ -   Total optimization steps = 245
 20%|████████████▍                                                 | 49/245 [01:04&lt;04:09,  1.27s/it]
 10/10/2022 22:58:29 - INFO - __main__ - epoch 0: perplexity: 1222.1594275215962 eval_loss: 7.10837459564209
 40%|████████████████████████▊                                     | 98/245 [02:10&lt;03:07,  1.28s/it]
 10/10/2022 22:59:35 - INFO - __main__ - epoch 1: perplexity: 894.5236583794557 eval_loss: 6.796291351318359
 60%|████████████████████████████████████▌                        | 147/245 [03:16&lt;02:05,  1.28s/it]
 10/10/2022 23:00:40 - INFO - __main__ - epoch 2: perplexity: 702.8458788508042 eval_loss: 6.555137634277344
 80%|████████████████████████████████████████████████▊            | 196/245 [04:22&lt;01:02,  1.28s/it]
 10/10/2022 23:01:46 - INFO - __main__ - epoch 3: perplexity: 600.3220028695281 eval_loss: 6.39746618270874
100%|█████████████████████████████████████████████████████████████| 245/245 [05:27&lt;00:00,  1.28s/it]`,wrap:!1}}),de=new J({props:{title:"Advanced features to leverage writing custom train step and Megatron-LM Indexed Datasets",local:"advanced-features-to-leverage-writing-custom-train-step-and-megatron-lm-indexed-datasets",headingTag:"h2"}}),he=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBNZWdhdHJvbkxNRHVtbXlTY2hlZHVsZXIlMkMlMjBHUFRUcmFpblN0ZXAlMkMlMjBhdmdfbG9zc2VzX2Fjcm9zc19kYXRhX3BhcmFsbGVsX2dyb3VwJTBBJTBBJTBBJTIzJTIwQ3VzdG9tJTIwbG9zcyUyMGZ1bmN0aW9uJTIwZm9yJTIwdGhlJTIwTWVnYXRyb24lMjBtb2RlbCUwQWNsYXNzJTIwR1BUVHJhaW5TdGVwV2l0aEN1c3RvbUxvc3MoR1BUVHJhaW5TdGVwKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9faW5pdF9fKHNlbGYlMkMlMjBtZWdhdHJvbl9hcmdzJTJDJTIwKiprd2FyZ3MpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VwZXIoKS5fX2luaXRfXyhtZWdhdHJvbl9hcmdzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYua3dhcmdzJTIwJTNEJTIwa3dhcmdzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2xvc3NfZnVuYyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMGxvc3NfZnVuYyhpbnB1dHMlMkMlMjBsb3NzX21hc2slMkMlMjBvdXRwdXRfdGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGJhdGNoX3NpemUlMkMlMjBzZXFfbGVuZ3RoJTIwJTNEJTIwb3V0cHV0X3RlbnNvci5zaGFwZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NlcyUyMCUzRCUyMG91dHB1dF90ZW5zb3IuZmxvYXQoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfbWFzayUyMCUzRCUyMGxvc3NfbWFzay52aWV3KC0xKS5mbG9hdCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3Nlcy52aWV3KC0xKSUyMColMjBsb3NzX21hc2slMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBSZXNpemUlMjBhbmQlMjBhdmVyYWdlJTIwbG9zcyUyMHBlciUyMHNhbXBsZSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfcGVyX3NhbXBsZSUyMCUzRCUyMGxvc3MudmlldyhiYXRjaF9zaXplJTJDJTIwc2VxX2xlbmd0aCkuc3VtKGF4aXMlM0QxKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfbWFza19wZXJfc2FtcGxlJTIwJTNEJTIwbG9zc19tYXNrLnZpZXcoYmF0Y2hfc2l6ZSUyQyUyMHNlcV9sZW5ndGgpLnN1bShheGlzJTNEMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzX3Blcl9zYW1wbGUlMjAlM0QlMjBsb3NzX3Blcl9zYW1wbGUlMjAlMkYlMjBsb3NzX21hc2tfcGVyX3NhbXBsZSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMENhbGN1bGF0ZSUyMGFuZCUyMHNjYWxlJTIwd2VpZ2h0aW5nJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2VpZ2h0cyUyMCUzRCUyMHRvcmNoLnN0YWNrKCU1QihpbnB1dHMlMjAlM0QlM0QlMjBrdCkuZmxvYXQoKSUyMGZvciUyMGt0JTIwaW4lMjBzZWxmLmt3YXJncyU1QiUyMmtleXRva2VuX2lkcyUyMiU1RCU1RCkuc3VtKGF4aXMlM0QlNUIwJTJDJTIwMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3ZWlnaHRzJTIwJTNEJTIwMS4wJTIwJTJCJTIwc2VsZi5rd2FyZ3MlNUIlMjJhbHBoYSUyMiU1RCUyMColMjB3ZWlnaHRzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQ2FsY3VsYXRlJTIwd2VpZ2h0ZWQlMjBhdmVyYWdlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2VpZ2h0ZWRfbG9zcyUyMCUzRCUyMChsb3NzX3Blcl9zYW1wbGUlMjAqJTIwd2VpZ2h0cykubWVhbigpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUmVkdWNlJTIwbG9zcyUyMGFjcm9zcyUyMGRhdGElMjBwYXJhbGxlbCUyMGdyb3VwcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGF2ZXJhZ2VkX2xvc3MlMjAlM0QlMjBhdmdfbG9zc2VzX2Fjcm9zc19kYXRhX3BhcmFsbGVsX2dyb3VwKCU1QndlaWdodGVkX2xvc3MlNUQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwd2VpZ2h0ZWRfbG9zcyUyQyUyMCU3QiUyMmxtJTIwbG9zcyUyMiUzQSUyMGF2ZXJhZ2VkX2xvc3MlNUIwJTVEJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwbG9zc19mdW5jJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwZ2V0X2ZvcndhcmRfc3RlcF9mdW5jKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwZm9yd2FyZF9zdGVwKGRhdGFfaXRlcmF0b3IlMkMlMjBtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJGb3J3YXJkJTIwc3RlcC4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjB0aGUlMjBiYXRjaC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b2tlbnMlMkMlMjBsYWJlbHMlMkMlMjBsb3NzX21hc2slMkMlMjBhdHRlbnRpb25fbWFzayUyQyUyMHBvc2l0aW9uX2lkcyUyMCUzRCUyMHNlbGYuZ2V0X2JhdGNoKGRhdGFfaXRlcmF0b3IpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0X3RlbnNvciUyMCUzRCUyMG1vZGVsKHRva2VucyUyQyUyMHBvc2l0aW9uX2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwbGFiZWxzJTNEbGFiZWxzKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG91dHB1dF90ZW5zb3IlMkMlMjBwYXJ0aWFsKHNlbGYubG9zc19mdW5jJTJDJTIwdG9rZW5zJTJDJTIwbG9zc19tYXNrKSUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZvcndhcmRfc3RlcCUwQSUwQSUwQWRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEN1c3RvbSUyMGxvc3MlMjBmdW5jdGlvbiUyMGZvciUyMHRoZSUyME1lZ2F0cm9uJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBrZXl0b2tlbl9pZHMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjBrZXl3b3JkcyUyMCUzRCUyMCU1QiUyMnBsdCUyMiUyQyUyMCUyMnBkJTIyJTJDJTIwJTIyc2slMjIlMkMlMjAlMjJmaXQlMjIlMkMlMjAlMjJwcmVkaWN0JTIyJTJDJTIwJTIyJTIwcGx0JTIyJTJDJTIwJTIyJTIwcGQlMjIlMkMlMjAlMjIlMjBzayUyMiUyQyUyMCUyMiUyMGZpdCUyMiUyQyUyMCUyMiUyMHByZWRpY3QlMjIlNUQlMEElMjAlMjAlMjAlMjBmb3IlMjBrZXl3b3JkJTIwaW4lMjBrZXl3b3JkcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlkcyUyMCUzRCUyMHRva2VuaXplciglNUJrZXl3b3JkJTVEKS5pbnB1dF9pZHMlNUIwJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBsZW4oaWRzKSUyMCUzRCUzRCUyMDElM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBrZXl0b2tlbl9pZHMuYXBwZW5kKGlkcyU1QjAlNUQpJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3IucHJpbnQoZiUyMktleXRva2VuJTIwaWRzJTNBJTIwJTdCa2V5dG9rZW5faWRzJTdEJTIyKSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnN0YXRlLm1lZ2F0cm9uX2xtX3BsdWdpbi5jdXN0b21fdHJhaW5fc3RlcF9jbGFzcyUyMCUzRCUyMEdQVFRyYWluU3RlcFdpdGhDdXN0b21Mb3NzJTBBJTIwJTIwJTIwJTIwYWNjZWxlcmF0b3Iuc3RhdGUubWVnYXRyb25fbG1fcGx1Z2luLmN1c3RvbV90cmFpbl9zdGVwX2t3YXJncyUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmtleXRva2VuX2lkcyUyMiUzQSUyMGtleXRva2VuX2lkcyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmFscGhhJTIyJTNBJTIwMC4yNSUyQyUwQSUyMCUyMCUyMCUyMCU3RA==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> MegatronLMDummyScheduler, GPTTrainStep, avg_losses_across_data_parallel_group


<span class="hljs-comment"># Custom loss function for the Megatron model</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">GPTTrainStepWithCustomLoss</span>(<span class="hljs-title class_ inherited__">GPTTrainStep</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, megatron_args, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(megatron_args)
        self.kwargs = kwargs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_loss_func</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">loss_func</span>(<span class="hljs-params">inputs, loss_mask, output_tensor</span>):
            batch_size, seq_length = output_tensor.shape
            losses = output_tensor.<span class="hljs-built_in">float</span>()
            loss_mask = loss_mask.view(-<span class="hljs-number">1</span>).<span class="hljs-built_in">float</span>()
            loss = losses.view(-<span class="hljs-number">1</span>) * loss_mask

            <span class="hljs-comment"># Resize and average loss per sample</span>
            loss_per_sample = loss.view(batch_size, seq_length).<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>)
            loss_mask_per_sample = loss_mask.view(batch_size, seq_length).<span class="hljs-built_in">sum</span>(axis=<span class="hljs-number">1</span>)
            loss_per_sample = loss_per_sample / loss_mask_per_sample

            <span class="hljs-comment"># Calculate and scale weighting</span>
            weights = torch.stack([(inputs == kt).<span class="hljs-built_in">float</span>() <span class="hljs-keyword">for</span> kt <span class="hljs-keyword">in</span> self.kwargs[<span class="hljs-string">&quot;keytoken_ids&quot;</span>]]).<span class="hljs-built_in">sum</span>(axis=[<span class="hljs-number">0</span>, <span class="hljs-number">2</span>])
            weights = <span class="hljs-number">1.0</span> + self.kwargs[<span class="hljs-string">&quot;alpha&quot;</span>] * weights
            <span class="hljs-comment"># Calculate weighted average</span>
            weighted_loss = (loss_per_sample * weights).mean()

            <span class="hljs-comment"># Reduce loss across data parallel groups</span>
            averaged_loss = avg_losses_across_data_parallel_group([weighted_loss])

            <span class="hljs-keyword">return</span> weighted_loss, {<span class="hljs-string">&quot;lm loss&quot;</span>: averaged_loss[<span class="hljs-number">0</span>]}

        <span class="hljs-keyword">return</span> loss_func

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">get_forward_step_func</span>(<span class="hljs-params">self</span>):
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward_step</span>(<span class="hljs-params">data_iterator, model</span>):
            <span class="hljs-string">&quot;&quot;&quot;Forward step.&quot;&quot;&quot;</span>
            <span class="hljs-comment"># Get the batch.</span>
            tokens, labels, loss_mask, attention_mask, position_ids = self.get_batch(data_iterator)
            output_tensor = model(tokens, position_ids, attention_mask, labels=labels)

            <span class="hljs-keyword">return</span> output_tensor, partial(self.loss_func, tokens, loss_mask)

        <span class="hljs-keyword">return</span> forward_step


<span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    <span class="hljs-comment"># Custom loss function for the Megatron model</span>
    keytoken_ids = []
    keywords = [<span class="hljs-string">&quot;plt&quot;</span>, <span class="hljs-string">&quot;pd&quot;</span>, <span class="hljs-string">&quot;sk&quot;</span>, <span class="hljs-string">&quot;fit&quot;</span>, <span class="hljs-string">&quot;predict&quot;</span>, <span class="hljs-string">&quot; plt&quot;</span>, <span class="hljs-string">&quot; pd&quot;</span>, <span class="hljs-string">&quot; sk&quot;</span>, <span class="hljs-string">&quot; fit&quot;</span>, <span class="hljs-string">&quot; predict&quot;</span>]
    <span class="hljs-keyword">for</span> keyword <span class="hljs-keyword">in</span> keywords:
        ids = tokenizer([keyword]).input_ids[<span class="hljs-number">0</span>]
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(ids) == <span class="hljs-number">1</span>:
            keytoken_ids.append(ids[<span class="hljs-number">0</span>])
    accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Keytoken ids: <span class="hljs-subst">{keytoken_ids}</span>&quot;</span>)
    accelerator.state.megatron_lm_plugin.custom_train_step_class = GPTTrainStepWithCustomLoss
    accelerator.state.megatron_lm_plugin.custom_train_step_kwargs = {
        <span class="hljs-string">&quot;keytoken_ids&quot;</span>: keytoken_ids,
        <span class="hljs-string">&quot;alpha&quot;</span>: <span class="hljs-number">0.25</span>,
    }`,wrap:!1}}),Te=new h({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBNZWdhdHJvbkxNRHVtbXlEYXRhTG9hZGVyJTBBJTBBbWVnYXRyb25fZGF0YWxvYWRlcl9jb25maWclMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJkYXRhX3BhdGglMjIlM0ElMjBhcmdzLmRhdGFfcGF0aCUyQyUwQSUyMCUyMCUyMCUyMCUyMnNwbGl0c19zdHJpbmclMjIlM0ElMjBhcmdzLnNwbGl0c19zdHJpbmclMkMlMEElMjAlMjAlMjAlMjAlMjJzZXFfbGVuZ3RoJTIyJTNBJTIwYXJncy5ibG9ja19zaXplJTJDJTBBJTIwJTIwJTIwJTIwJTIybWljcm9fYmF0Y2hfc2l6ZSUyMiUzQSUyMGFyZ3MucGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTJDJTBBJTdEJTBBbWVnYXRyb25fZGF0YWxvYWRlciUyMCUzRCUyME1lZ2F0cm9uTE1EdW1teURhdGFMb2FkZXIoKiptZWdhdHJvbl9kYXRhbG9hZGVyX2NvbmZpZyklMEFhY2NlbGVyYXRvci5zdGF0ZS5tZWdhdHJvbl9sbV9wbHVnaW4ubWVnYXRyb25fZGF0YXNldF9mbGFnJTIwJTNEJTIwVHJ1ZQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> MegatronLMDummyDataLoader

megatron_dataloader_config = {
    <span class="hljs-string">&quot;data_path&quot;</span>: args.data_path,
    <span class="hljs-string">&quot;splits_string&quot;</span>: args.splits_string,
    <span class="hljs-string">&quot;seq_length&quot;</span>: args.block_size,
    <span class="hljs-string">&quot;micro_batch_size&quot;</span>: args.per_device_train_batch_size,
}
megatron_dataloader = MegatronLMDummyDataLoader(**megatron_dataloader_config)
accelerator.state.megatron_lm_plugin.megatron_dataset_flag = <span class="hljs-literal">True</span>`,wrap:!1}}),Ue=new h({props:{code:"bW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlMkMlMjB0cmFpbl9kYXRhbG9hZGVyJTJDJTIwZXZhbF9kYXRhbG9hZGVyJTJDJTIwXyUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlMkMlMjBtZWdhdHJvbl9kYXRhbG9hZGVyJTJDJTIwbWVnYXRyb25fZGF0YWxvYWRlciUyQyUyMG1lZ2F0cm9uX2RhdGFsb2FkZXIlMEEp",highlighted:`model, optimizer, lr_scheduler, train_dataloader, eval_dataloader, _ = accelerator.prepare(
    model, optimizer, lr_scheduler, megatron_dataloader, megatron_dataloader, megatron_dataloader
)`,wrap:!1}}),be=new h({props:{code:"d2hpbGUlMjBjb21wbGV0ZWRfc3RlcHMlMjAlM0MlMjBhcmdzLm1heF90cmFpbl9zdGVwcyUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsLnRyYWluKCklMEElMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMG5leHQodHJhaW5fZGF0YWxvYWRlciklMjBpZiUyMHRyYWluX2RhdGFsb2FkZXIlMjBpcyUyMG5vdCUyME5vbmUlMjBlbHNlJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqYmF0Y2gpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQSUyMCUyMCUyMCUyMC4uLiUwQSUwQSUyMCUyMCUyMCUyMGlmJTIwY29tcGxldGVkX3N0ZXBzJTIwJTI1JTIwZXZhbF9pbnRlcnZhbCUyMCUzRCUzRCUyMDAlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBldmFsX2NvbXBsZXRlZF9zdGVwcyUyMCUzRCUyMDAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzZXMlMjAlM0QlMjAlNUIlNUQlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB3aGlsZSUyMGV2YWxfY29tcGxldGVkX3N0ZXBzJTIwJTNDJTIwZXZhbF9pdGVycyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsLmV2YWwoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBiYXRjaCUyMCUzRCUyMG5leHQoZXZhbF9kYXRhbG9hZGVyKSUyMGlmJTIwZXZhbF9kYXRhbG9hZGVyJTIwaXMlMjBub3QlMjBOb25lJTIwZWxzZSUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKQ==",highlighted:`<span class="hljs-keyword">while</span> completed_steps &lt; args.max_train_steps:
    model.train()
    batch = <span class="hljs-built_in">next</span>(train_dataloader) <span class="hljs-keyword">if</span> train_dataloader <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> {}
    outputs = model(**batch)
    loss = outputs.loss
    ...

    <span class="hljs-keyword">if</span> completed_steps % eval_interval == <span class="hljs-number">0</span>:
        eval_completed_steps = <span class="hljs-number">0</span>
        losses = []
        <span class="hljs-keyword">while</span> eval_completed_steps &lt; eval_iters:
            model.<span class="hljs-built_in">eval</span>()
            <span class="hljs-keyword">with</span> torch.no_grad():
                batch = <span class="hljs-built_in">next</span>(eval_dataloader) <span class="hljs-keyword">if</span> eval_dataloader <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> {}
                outputs = model(**batch)`,wrap:!1}}),je=new J({props:{title:"Utility for Checkpoint reshaping and interoperability",local:"utility-for-checkpoint-reshaping-and-interoperability",headingTag:"h2"}}),fe=new h({props:{code:"cHl0aG9uJTIwY2hlY2twb2ludF9yZXNoYXBpbmdfYW5kX2ludGVyb3BlcmFiaWxpdHkucHklMjAlNUMlMEEtLWNvbnZlcnRfY2hlY2twb2ludF9mcm9tX21lZ2F0cm9uX3RvX3RyYW5zZm9ybWVycyUyMCU1QyUwQS0tbG9hZF9wYXRoJTIwJTIyZ3B0JTJGaXRlcl8wMDA1MDAwJTIyJTIwJTVDJTBBLS1zYXZlX3BhdGglMjAlMjJncHQlMkZ0cmZzX2NoZWNrcG9pbnQlMjIlMjAlNUMlMEEtLW1heF9zaGFyZF9zaXplJTIwJTIyMjAwTUIlMjIlMjAlNUMlMEEtLXRva2VuaXplcl9uYW1lJTIwJTIyZ3B0MiUyMiUyMCU1QyUwQS0tcHJpbnQtY2hlY2twb2ludC1zdHJ1Y3R1cmU=",highlighted:`python checkpoint_reshaping_and_interoperability.py \\
--convert_checkpoint_from_megatron_to_transformers \\
--load_path <span class="hljs-string">&quot;gpt/iter_0005000&quot;</span> \\
--save_path <span class="hljs-string">&quot;gpt/trfs_checkpoint&quot;</span> \\
--max_shard_size <span class="hljs-string">&quot;200MB&quot;</span> \\
--tokenizer_name <span class="hljs-string">&quot;gpt2&quot;</span> \\
--print-checkpoint-structure`,wrap:!1}}),_e=new h({props:{code:"cHl0aG9uJTIwY2hlY2twb2ludF91dGlscyUyRm1lZ2F0Z3Jvbl9ncHQyJTJGY2hlY2twb2ludF9yZXNoYXBpbmdfYW5kX2ludGVyb3BlcmFiaWxpdHkucHklMjAlNUMlMEEtLWxvYWRfcGF0aCUyMCUyMmdwdCUyRnRyZnNfY2hlY2twb2ludCUyMiUyMCU1QyUwQS0tc2F2ZV9wYXRoJTIwJTIyZ3B0JTJGbWVnYXRyb25fbG1fY2hlY2twb2ludCUyMiUyMCU1QyUwQS0tdGFyZ2V0X3RlbnNvcl9tb2RlbF9wYXJhbGxlbF9zaXplJTIwMiUyMCU1QyUwQS0tdGFyZ2V0X3BpcGVsaW5lX21vZGVsX3BhcmFsbGVsX3NpemUlMjAyJTIwJTVDJTBBLS10YXJnZXRfZGF0YV9wYXJhbGxlbF9zaXplJTIwMiUyMCU1QyUwQS0tdGFyZ2V0X3BhcmFtc19kdHlwZSUyMCUyMmJmMTYlMjIlMjAlNUMlMEEtLW1ha2Vfdm9jYWJfc2l6ZV9kaXZpc2libGVfYnklMjAxMjglMjAlNUMlMEEtLXVzZV9kaXN0cmlidXRlZF9vcHRpbWl6ZXIlMjAlNUMlMEEtLXByaW50LWNoZWNrcG9pbnQtc3RydWN0dXJl",highlighted:`python checkpoint_utils/megatgron_gpt2/checkpoint_reshaping_and_interoperability.py \\
--load_path <span class="hljs-string">&quot;gpt/trfs_checkpoint&quot;</span> \\
--save_path <span class="hljs-string">&quot;gpt/megatron_lm_checkpoint&quot;</span> \\
--target_tensor_model_parallel_size 2 \\
--target_pipeline_model_parallel_size 2 \\
--target_data_parallel_size 2 \\
--target_params_dtype <span class="hljs-string">&quot;bf16&quot;</span> \\
--make_vocab_size_divisible_by 128 \\
--use_distributed_optimizer \\
--print-checkpoint-structure`,wrap:!1}}),Ie=new J({props:{title:"Megatron-LM GPT models support returning logits and megatron_generate function for text generation",local:"megatron-lm-gpt-models-support-returning-logits-and-megatrongenerate-function-for-text-generation",headingTag:"h2"}}),Ze=new h({props:{code:"bWVnYXRyb25fbG1fcGx1Z2luJTIwJTNEJTIwTWVnYXRyb25MTVBsdWdpbihyZXR1cm5fbG9naXRzJTNEVHJ1ZSk=",highlighted:'megatron_lm_plugin = MegatronLMPlugin(return_logits=<span class="hljs-literal">True</span>)',wrap:!1}}),Be=new h({props:{code:"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",highlighted:`<span class="hljs-comment"># specifying tokenizer&#x27;s vocab and merges file</span>
vocab_file = os.path.join(args.resume_from_checkpoint, <span class="hljs-string">&quot;vocab.json&quot;</span>)
merge_file = os.path.join(args.resume_from_checkpoint, <span class="hljs-string">&quot;merges.txt&quot;</span>)
other_megatron_args = {<span class="hljs-string">&quot;vocab_file&quot;</span>: vocab_file, <span class="hljs-string">&quot;merge_file&quot;</span>: merge_file}
megatron_lm_plugin = MegatronLMPlugin(other_megatron_args=other_megatron_args)

<span class="hljs-comment"># inference using \`megatron_generate\` functionality</span>
tokenizer.pad_token = tokenizer.eos_token
max_new_tokens = <span class="hljs-number">64</span>
batch_texts = [
    <span class="hljs-string">&quot;Are you human?&quot;</span>,
    <span class="hljs-string">&quot;The purpose of life is&quot;</span>,
    <span class="hljs-string">&quot;The arsenal was constructed at the request of&quot;</span>,
    <span class="hljs-string">&quot;How are you doing these days?&quot;</span>,
]
batch_encodings = tokenizer(batch_texts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># top-p sampling</span>
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>],
    batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>],
    max_new_tokens=max_new_tokens,
    top_p=<span class="hljs-number">0.8</span>,
    top_p_decay=<span class="hljs-number">0.5</span>,
    temperature=<span class="hljs-number">0.9</span>,
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)

<span class="hljs-comment"># top-k sampling</span>
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>],
    batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>],
    max_new_tokens=max_new_tokens,
    top_k=<span class="hljs-number">50</span>,
    temperature=<span class="hljs-number">0.9</span>,
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)

<span class="hljs-comment"># adding \`bos\` token at the start</span>
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>], batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>], max_new_tokens=max_new_tokens, add_BOS=<span class="hljs-literal">True</span>
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)

<span class="hljs-comment"># beam search =&gt; only takes single prompt</span>
batch_texts = [<span class="hljs-string">&quot;The purpose of life is&quot;</span>]
batch_encodings = tokenizer(batch_texts, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>)
generated_tokens = model.megatron_generate(
    batch_encodings[<span class="hljs-string">&quot;input_ids&quot;</span>],
    batch_encodings[<span class="hljs-string">&quot;attention_mask&quot;</span>],
    max_new_tokens=max_new_tokens,
    num_beams=<span class="hljs-number">20</span>,
    length_penalty=<span class="hljs-number">1.5</span>,
)
decoded_preds = tokenizer.batch_decode(generated_tokens.cpu().numpy())
accelerator.<span class="hljs-built_in">print</span>(decoded_preds)`,wrap:!1}}),Ge=new J({props:{title:"Support for ROPE and ALiBi Positional embeddings and Multi-Query Attention",local:"support-for-rope-and-alibi-positional-embeddings-and-multi-query-attention",headingTag:"h2"}}),ke=new h({props:{code:"b3RoZXJfbWVnYXRyb25fYXJncyUyMCUzRCUyMCU3QiUyMnBvc2l0aW9uX2VtYmVkZGluZ190eXBlJTIyJTNBJTIwJTIyYWxpYmklMjIlN0QlMEFtZWdhdHJvbl9sbV9wbHVnaW4lMjAlM0QlMjBNZWdhdHJvbkxNUGx1Z2luKG90aGVyX21lZ2F0cm9uX2FyZ3MlM0RvdGhlcl9tZWdhdHJvbl9hcmdzKQ==",highlighted:`other_megatron_args = {<span class="hljs-string">&quot;position_embedding_type&quot;</span>: <span class="hljs-string">&quot;alibi&quot;</span>}
megatron_lm_plugin = MegatronLMPlugin(other_megatron_args=other_megatron_args)`,wrap:!1}}),We=new h({props:{code:"b3RoZXJfbWVnYXRyb25fYXJncyUyMCUzRCUyMCU3QiUyMmF0dGVudGlvbl9oZWFkX3R5cGUlMjIlM0ElMjAlMjJtdWx0aXF1ZXJ5JTIyJTdEJTBBbWVnYXRyb25fbG1fcGx1Z2luJTIwJTNEJTIwTWVnYXRyb25MTVBsdWdpbihvdGhlcl9tZWdhdHJvbl9hcmdzJTNEb3RoZXJfbWVnYXRyb25fYXJncyk=",highlighted:`other_megatron_args = {<span class="hljs-string">&quot;attention_head_type&quot;</span>: <span class="hljs-string">&quot;multiquery&quot;</span>}
megatron_lm_plugin = MegatronLMPlugin(other_megatron_args=other_megatron_args)`,wrap:!1}}),ve=new J({props:{title:"Caveats",local:"caveats",headingTag:"h2"}}),{c(){T=o("meta"),Ae=a(),Ye=o("p"),He=a(),p(G.$$.fragment),Ee=a(),X=o("p"),X.innerHTML=ct,Le=a(),p(k.$$.fragment),xe=a(),W=o("p"),W.textContent=dt,Qe=a(),v=o("p"),v.innerHTML=mt,Se=a(),R=o("p"),R.innerHTML=yt,$e=a(),V=o("p"),V.innerHTML=ht,qe=a(),N=o("p"),N.innerHTML=ut,Pe=a(),z=o("p"),z.innerHTML=Tt,De=a(),Y=o("p"),Y.innerHTML=Jt,Ke=a(),F=o("p"),F.innerHTML=Ut,Oe=a(),A=o("p"),A.innerHTML=wt,el=a(),p(H.$$.fragment),ll=a(),E=o("p"),E.innerHTML=bt,tl=a(),L=o("p"),L.textContent=jt,sl=a(),x=o("ol"),x.innerHTML=gt,al=a(),p(Q.$$.fragment),nl=a(),U=o("ol"),U.innerHTML=ft,ol=a(),p(S.$$.fragment),il=a(),w=o("ol"),w.innerHTML=_t,rl=a(),p($.$$.fragment),pl=a(),b=o("ol"),b.innerHTML=It,Ml=a(),p(q.$$.fragment),cl=a(),p(P.$$.fragment),dl=a(),D=o("p"),D.innerHTML=Ct,ml=a(),p(K.$$.fragment),yl=a(),O=o("p"),O.textContent=Zt,hl=a(),p(ee.$$.fragment),ul=a(),le=o("p"),le.innerHTML=Bt,Tl=a(),te=o("ol"),te.innerHTML=Gt,Jl=a(),p(se.$$.fragment),Ul=a(),j=o("ol"),j.innerHTML=Xt,wl=a(),p(ae.$$.fragment),bl=a(),g=o("ol"),g.innerHTML=kt,jl=a(),p(ne.$$.fragment),gl=a(),f=o("ol"),f.innerHTML=Wt,fl=a(),p(oe.$$.fragment),_l=a(),ie=o("p"),ie.innerHTML=vt,Il=a(),p(re.$$.fragment),Cl=a(),pe=o("p"),pe.textContent=Rt,Zl=a(),p(Me.$$.fragment),Bl=a(),ce=o("p"),ce.innerHTML=Vt,Gl=a(),p(de.$$.fragment),Xl=a(),me=o("p"),me.textContent=Nt,kl=a(),ye=o("ol"),ye.innerHTML=zt,Wl=a(),p(he.$$.fragment),vl=a(),_=o("ol"),_.innerHTML=Yt,Rl=a(),ue=o("p"),ue.innerHTML=Ft,Vl=a(),p(Te.$$.fragment),Nl=a(),Je=o("p"),Je.innerHTML=At,zl=a(),p(Ue.$$.fragment),Yl=a(),we=o("p"),we.innerHTML=Ht,Fl=a(),p(be.$$.fragment),Al=a(),p(je.$$.fragment),Hl=a(),ge=o("ol"),ge.innerHTML=Et,El=a(),p(fe.$$.fragment),Ll=a(),I=o("ol"),I.innerHTML=Lt,xl=a(),p(_e.$$.fragment),Ql=a(),p(Ie.$$.fragment),Sl=a(),Ce=o("ol"),Ce.innerHTML=xt,$l=a(),p(Ze.$$.fragment),ql=a(),C=o("ol"),C.innerHTML=Qt,Pl=a(),p(Be.$$.fragment),Dl=a(),Z=o("ol"),Z.innerHTML=St,Kl=a(),p(Ge.$$.fragment),Ol=a(),Xe=o("ol"),Xe.innerHTML=$t,et=a(),p(ke.$$.fragment),lt=a(),B=o("ol"),B.innerHTML=qt,tt=a(),p(We.$$.fragment),st=a(),p(ve.$$.fragment),at=a(),Re=o("ol"),Re.innerHTML=Pt,nt=a(),Ve=o("p"),Ve.innerHTML=Dt,ot=a(),Ne=o("p"),Ne.innerHTML=Kt,it=a(),ze=o("p"),ze.innerHTML=Ot,rt=a(),Fe=o("p"),this.h()},l(e){const l=os("svelte-u9bgzb",document.head);T=i(l,"META",{name:!0,content:!0}),l.forEach(t),Ae=n(e),Ye=i(e,"P",{}),es(Ye).forEach(t),He=n(e),M(G.$$.fragment,e),Ee=n(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1tldvfq"&&(X.innerHTML=ct),Le=n(e),M(k.$$.fragment,e),xe=n(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-s7paho"&&(W.textContent=dt),Qe=n(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-b2higl"&&(v.innerHTML=mt),Se=n(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-4d8a67"&&(R.innerHTML=yt),$e=n(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-14ypnfq"&&(V.innerHTML=ht),qe=n(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-11rrllg"&&(N.innerHTML=ut),Pe=n(e),z=i(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1kfsym1"&&(z.innerHTML=Tt),De=n(e),Y=i(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-11yks9s"&&(Y.innerHTML=Jt),Ke=n(e),F=i(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fhtnhq"&&(F.innerHTML=Ut),Oe=n(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-19309zy"&&(A.innerHTML=wt),el=n(e),M(H.$$.fragment,e),ll=n(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-fa7yz2"&&(E.innerHTML=bt),tl=n(e),L=i(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1z0rs1p"&&(L.textContent=jt),sl=n(e),x=i(e,"OL",{"data-svelte-h":!0}),r(x)!=="svelte-t1a84w"&&(x.innerHTML=gt),al=n(e),M(Q.$$.fragment,e),nl=n(e),U=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(U)!=="svelte-sqdvae"&&(U.innerHTML=ft),ol=n(e),M(S.$$.fragment,e),il=n(e),w=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(w)!=="svelte-1gjf9fx"&&(w.innerHTML=_t),rl=n(e),M($.$$.fragment,e),pl=n(e),b=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(b)!=="svelte-1lzju7i"&&(b.innerHTML=It),Ml=n(e),M(q.$$.fragment,e),cl=n(e),M(P.$$.fragment,e),dl=n(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-wk509o"&&(D.innerHTML=Ct),ml=n(e),M(K.$$.fragment,e),yl=n(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-veib80"&&(O.textContent=Zt),hl=n(e),M(ee.$$.fragment,e),ul=n(e),le=i(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1o5yv4m"&&(le.innerHTML=Bt),Tl=n(e),te=i(e,"OL",{"data-svelte-h":!0}),r(te)!=="svelte-17k5y1l"&&(te.innerHTML=Gt),Jl=n(e),M(se.$$.fragment,e),Ul=n(e),j=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(j)!=="svelte-149vks6"&&(j.innerHTML=Xt),wl=n(e),M(ae.$$.fragment,e),bl=n(e),g=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(g)!=="svelte-1eoa7yj"&&(g.innerHTML=kt),jl=n(e),M(ne.$$.fragment,e),gl=n(e),f=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(f)!=="svelte-zyrcln"&&(f.innerHTML=Wt),fl=n(e),M(oe.$$.fragment,e),_l=n(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1q0cekw"&&(ie.innerHTML=vt),Il=n(e),M(re.$$.fragment,e),Cl=n(e),pe=i(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-c0uxew"&&(pe.textContent=Rt),Zl=n(e),M(Me.$$.fragment,e),Bl=n(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-7qf7v1"&&(ce.innerHTML=Vt),Gl=n(e),M(de.$$.fragment,e),Xl=n(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-y1muxn"&&(me.textContent=Nt),kl=n(e),ye=i(e,"OL",{"data-svelte-h":!0}),r(ye)!=="svelte-roprbo"&&(ye.innerHTML=zt),Wl=n(e),M(he.$$.fragment,e),vl=n(e),_=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(_)!=="svelte-hnq1rq"&&(_.innerHTML=Yt),Rl=n(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-qz1g9y"&&(ue.innerHTML=Ft),Vl=n(e),M(Te.$$.fragment,e),Nl=n(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1w56eiu"&&(Je.innerHTML=At),zl=n(e),M(Ue.$$.fragment,e),Yl=n(e),we=i(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-flejr8"&&(we.innerHTML=Ht),Fl=n(e),M(be.$$.fragment,e),Al=n(e),M(je.$$.fragment,e),Hl=n(e),ge=i(e,"OL",{"data-svelte-h":!0}),r(ge)!=="svelte-1j7wslt"&&(ge.innerHTML=Et),El=n(e),M(fe.$$.fragment,e),Ll=n(e),I=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(I)!=="svelte-4ldwdf"&&(I.innerHTML=Lt),xl=n(e),M(_e.$$.fragment,e),Ql=n(e),M(Ie.$$.fragment,e),Sl=n(e),Ce=i(e,"OL",{"data-svelte-h":!0}),r(Ce)!=="svelte-vjbue1"&&(Ce.innerHTML=xt),$l=n(e),M(Ze.$$.fragment,e),ql=n(e),C=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(C)!=="svelte-14kb7w1"&&(C.innerHTML=Qt),Pl=n(e),M(Be.$$.fragment,e),Dl=n(e),Z=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(Z)!=="svelte-6worco"&&(Z.innerHTML=St),Kl=n(e),M(Ge.$$.fragment,e),Ol=n(e),Xe=i(e,"OL",{"data-svelte-h":!0}),r(Xe)!=="svelte-1vfw4du"&&(Xe.innerHTML=$t),et=n(e),M(ke.$$.fragment,e),lt=n(e),B=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(B)!=="svelte-1t8cxp8"&&(B.innerHTML=qt),tt=n(e),M(We.$$.fragment,e),st=n(e),M(ve.$$.fragment,e),at=n(e),Re=i(e,"OL",{"data-svelte-h":!0}),r(Re)!=="svelte-xr1ubh"&&(Re.innerHTML=Pt),nt=n(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-8ijd76"&&(Ve.innerHTML=Dt),ot=n(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-pbg4ga"&&(Ne.innerHTML=Kt),it=n(e),ze=i(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-19jy1uh"&&(ze.innerHTML=Ot),rt=n(e),Fe=i(e,"P",{}),es(Fe).forEach(t),this.h()},h(){u(T,"name","hf:doc:metadata"),u(T,"content",ps),u(U,"start","2"),u(w,"start","3"),u(b,"start","4"),u(j,"start","2"),u(g,"start","3"),u(f,"start","4"),u(_,"start","2"),u(I,"start","3"),u(C,"start","2"),u(Z,"start","3"),u(B,"start","2")},m(e,l){is(document.head,T),s(e,Ae,l),s(e,Ye,l),s(e,He,l),c(G,e,l),s(e,Ee,l),s(e,X,l),s(e,Le,l),c(k,e,l),s(e,xe,l),s(e,W,l),s(e,Qe,l),s(e,v,l),s(e,Se,l),s(e,R,l),s(e,$e,l),s(e,V,l),s(e,qe,l),s(e,N,l),s(e,Pe,l),s(e,z,l),s(e,De,l),s(e,Y,l),s(e,Ke,l),s(e,F,l),s(e,Oe,l),s(e,A,l),s(e,el,l),c(H,e,l),s(e,ll,l),s(e,E,l),s(e,tl,l),s(e,L,l),s(e,sl,l),s(e,x,l),s(e,al,l),c(Q,e,l),s(e,nl,l),s(e,U,l),s(e,ol,l),c(S,e,l),s(e,il,l),s(e,w,l),s(e,rl,l),c($,e,l),s(e,pl,l),s(e,b,l),s(e,Ml,l),c(q,e,l),s(e,cl,l),c(P,e,l),s(e,dl,l),s(e,D,l),s(e,ml,l),c(K,e,l),s(e,yl,l),s(e,O,l),s(e,hl,l),c(ee,e,l),s(e,ul,l),s(e,le,l),s(e,Tl,l),s(e,te,l),s(e,Jl,l),c(se,e,l),s(e,Ul,l),s(e,j,l),s(e,wl,l),c(ae,e,l),s(e,bl,l),s(e,g,l),s(e,jl,l),c(ne,e,l),s(e,gl,l),s(e,f,l),s(e,fl,l),c(oe,e,l),s(e,_l,l),s(e,ie,l),s(e,Il,l),c(re,e,l),s(e,Cl,l),s(e,pe,l),s(e,Zl,l),c(Me,e,l),s(e,Bl,l),s(e,ce,l),s(e,Gl,l),c(de,e,l),s(e,Xl,l),s(e,me,l),s(e,kl,l),s(e,ye,l),s(e,Wl,l),c(he,e,l),s(e,vl,l),s(e,_,l),s(e,Rl,l),s(e,ue,l),s(e,Vl,l),c(Te,e,l),s(e,Nl,l),s(e,Je,l),s(e,zl,l),c(Ue,e,l),s(e,Yl,l),s(e,we,l),s(e,Fl,l),c(be,e,l),s(e,Al,l),c(je,e,l),s(e,Hl,l),s(e,ge,l),s(e,El,l),c(fe,e,l),s(e,Ll,l),s(e,I,l),s(e,xl,l),c(_e,e,l),s(e,Ql,l),c(Ie,e,l),s(e,Sl,l),s(e,Ce,l),s(e,$l,l),c(Ze,e,l),s(e,ql,l),s(e,C,l),s(e,Pl,l),c(Be,e,l),s(e,Dl,l),s(e,Z,l),s(e,Kl,l),c(Ge,e,l),s(e,Ol,l),s(e,Xe,l),s(e,et,l),c(ke,e,l),s(e,lt,l),s(e,B,l),s(e,tt,l),c(We,e,l),s(e,st,l),c(ve,e,l),s(e,at,l),s(e,Re,l),s(e,nt,l),s(e,Ve,l),s(e,ot,l),s(e,Ne,l),s(e,it,l),s(e,ze,l),s(e,rt,l),s(e,Fe,l),pt=!0},p:ts,i(e){pt||(d(G.$$.fragment,e),d(k.$$.fragment,e),d(H.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d($.$$.fragment,e),d(q.$$.fragment,e),d(P.$$.fragment,e),d(K.$$.fragment,e),d(ee.$$.fragment,e),d(se.$$.fragment,e),d(ae.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(re.$$.fragment,e),d(Me.$$.fragment,e),d(de.$$.fragment,e),d(he.$$.fragment,e),d(Te.$$.fragment,e),d(Ue.$$.fragment,e),d(be.$$.fragment,e),d(je.$$.fragment,e),d(fe.$$.fragment,e),d(_e.$$.fragment,e),d(Ie.$$.fragment,e),d(Ze.$$.fragment,e),d(Be.$$.fragment,e),d(Ge.$$.fragment,e),d(ke.$$.fragment,e),d(We.$$.fragment,e),d(ve.$$.fragment,e),pt=!0)},o(e){m(G.$$.fragment,e),m(k.$$.fragment,e),m(H.$$.fragment,e),m(Q.$$.fragment,e),m(S.$$.fragment,e),m($.$$.fragment,e),m(q.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ae.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(re.$$.fragment,e),m(Me.$$.fragment,e),m(de.$$.fragment,e),m(he.$$.fragment,e),m(Te.$$.fragment,e),m(Ue.$$.fragment,e),m(be.$$.fragment,e),m(je.$$.fragment,e),m(fe.$$.fragment,e),m(_e.$$.fragment,e),m(Ie.$$.fragment,e),m(Ze.$$.fragment,e),m(Be.$$.fragment,e),m(Ge.$$.fragment,e),m(ke.$$.fragment,e),m(We.$$.fragment,e),m(ve.$$.fragment,e),pt=!1},d(e){e&&(t(Ae),t(Ye),t(He),t(Ee),t(X),t(Le),t(xe),t(W),t(Qe),t(v),t(Se),t(R),t($e),t(V),t(qe),t(N),t(Pe),t(z),t(De),t(Y),t(Ke),t(F),t(Oe),t(A),t(el),t(ll),t(E),t(tl),t(L),t(sl),t(x),t(al),t(nl),t(U),t(ol),t(il),t(w),t(rl),t(pl),t(b),t(Ml),t(cl),t(dl),t(D),t(ml),t(yl),t(O),t(hl),t(ul),t(le),t(Tl),t(te),t(Jl),t(Ul),t(j),t(wl),t(bl),t(g),t(jl),t(gl),t(f),t(fl),t(_l),t(ie),t(Il),t(Cl),t(pe),t(Zl),t(Bl),t(ce),t(Gl),t(Xl),t(me),t(kl),t(ye),t(Wl),t(vl),t(_),t(Rl),t(ue),t(Vl),t(Nl),t(Je),t(zl),t(Yl),t(we),t(Fl),t(Al),t(Hl),t(ge),t(El),t(Ll),t(I),t(xl),t(Ql),t(Sl),t(Ce),t($l),t(ql),t(C),t(Pl),t(Dl),t(Z),t(Kl),t(Ol),t(Xe),t(et),t(lt),t(B),t(tt),t(st),t(at),t(Re),t(nt),t(Ve),t(ot),t(Ne),t(it),t(ze),t(rt),t(Fe)),t(T),y(G,e),y(k,e),y(H,e),y(Q,e),y(S,e),y($,e),y(q,e),y(P,e),y(K,e),y(ee,e),y(se,e),y(ae,e),y(ne,e),y(oe,e),y(re,e),y(Me,e),y(de,e),y(he,e),y(Te,e),y(Ue,e),y(be,e),y(je,e),y(fe,e),y(_e,e),y(Ie,e),y(Ze,e),y(Be,e),y(Ge,e),y(ke,e),y(We,e),y(ve,e)}}}const ps='{"title":"Megatron-LM","local":"megatron-lm","sections":[{"title":"What is integrated?","local":"what-is-integrated","sections":[],"depth":2},{"title":"Pre-Requisites","local":"pre-requisites","sections":[],"depth":2},{"title":"Accelerate Megatron-LM Plugin","local":"accelerate-megatron-lm-plugin","sections":[],"depth":2},{"title":"Advanced features to leverage writing custom train step and Megatron-LM Indexed Datasets","local":"advanced-features-to-leverage-writing-custom-train-step-and-megatron-lm-indexed-datasets","sections":[],"depth":2},{"title":"Utility for Checkpoint reshaping and interoperability","local":"utility-for-checkpoint-reshaping-and-interoperability","sections":[],"depth":2},{"title":"Megatron-LM GPT models support returning logits and megatron_generate function for text generation","local":"megatron-lm-gpt-models-support-returning-logits-and-megatrongenerate-function-for-text-generation","sections":[],"depth":2},{"title":"Support for ROPE and ALiBi Positional embeddings and Multi-Query Attention","local":"support-for-rope-and-alibi-positional-embeddings-and-multi-query-attention","sections":[],"depth":2},{"title":"Caveats","local":"caveats","sections":[],"depth":2}],"depth":1}';function Ms(Mt){return ss(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends as{constructor(T){super(),ns(this,T,Ms,rs,ls,{})}}export{hs as component};
