import{s as wo,o as Mo,n as Se}from"../chunks/scheduler.18a86fab.js";import{S as Fo,i as ko,g as d,s as n,r as u,A as $o,h as l,f as o,c as s,j as P,u as p,x as m,k as I,y as i,a,v as h,d as f,t as g,w as _}from"../chunks/index.98837b22.js";import{T as Dt}from"../chunks/Tip.77304350.js";import{D as V}from"../chunks/Docstring.6758ea23.js";import{C as Re}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as vo}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as ze}from"../chunks/Heading.7e7e0c5b.js";import{E as xo}from"../chunks/index.499f366c.js";function zo(Z){let r,T=`The <code>Fuyu</code> models were trained using <code>bfloat16</code>, but the original inference uses <code>float16</code> The checkpoints uploaded on the hub use <code>torch_dtype = &#39;float16&#39;</code> which will be
used by the <code>AutoModel</code> API to cast the checkpoints from <code>torch.float32</code> to <code>torch.float16</code>.`,c,y,M="The <code>dtype</code> of the online weights is mostly irrelevant, unless you are using <code>torch_dtype=&quot;auto&quot;</code> when initializing a model using <code>model = AutoModelForCausalLM.from_pretrained(&quot;path&quot;, torch_dtype = &quot;auto&quot;)</code>. The reason is that the model will first be downloaded ( using the <code>dtype</code> of the checkpoints online) then it will be cast to the default <code>dtype</code> of <code>torch</code> (becomes <code>torch.float32</code>). Users should specify the <code>torch_dtype</code> they want, and if they don’t it will be <code>torch.float32</code>.",b,v,Be="Finetuning the model in <code>float16</code> is not recommended and known to produce <code>nan</code>, as such the model should be fine-tuned in <code>bfloat16</code>.";return{c(){r=d("p"),r.innerHTML=T,c=n(),y=d("p"),y.innerHTML=M,b=n(),v=d("p"),v.innerHTML=Be},l(w){r=l(w,"P",{"data-svelte-h":!0}),m(r)!=="svelte-ydwkb0"&&(r.innerHTML=T),c=s(w),y=l(w,"P",{"data-svelte-h":!0}),m(y)!=="svelte-1mgue3n"&&(y.innerHTML=M),b=s(w),v=l(w,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1p3drsu"&&(v.innerHTML=Be)},m(w,k){a(w,r,k),a(w,c,k),a(w,y,k),a(w,b,k),a(w,v,k)},p:Se,d(w){w&&(o(r),o(c),o(y),o(b),o(v))}}}function Co(Z){let r,T;return r=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVDb25maWclMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwRnV5dSUyMGZ1eXUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwRnV5dUNvbmZpZygp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Fuyu fuyu-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = FuyuConfig()`,wrap:!1}}),{c(){u(r.$$.fragment)},l(c){p(r.$$.fragment,c)},m(c,y){h(r,c,y),T=!0},p:Se,i(c){T||(f(r.$$.fragment,c),T=!0)},o(c){g(r.$$.fragment,c),T=!1},d(c){_(r,c)}}}function Lo(Z){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=T},l(c){r=l(c,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,y){a(c,r,y)},p:Se,d(c){c&&o(r)}}}function Io(Z){let r,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=d("p"),r.innerHTML=T},l(c){r=l(c,"P",{"data-svelte-h":!0}),m(r)!=="svelte-fincs2"&&(r.innerHTML=T)},m(c,y){a(c,r,y)},p:Se,d(c){c&&o(r)}}}function Zo(Z){let r,T="Examples:",c,y,M;return y=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVQcm9jZXNzb3IlMkMlMjBGdXl1Rm9yQ2F1c2FsTE0lMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEZ1eXVQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmFkZXB0JTJGZnV5dS04YiUyMiklMEFtb2RlbCUyMCUzRCUyMEZ1eXVGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYWRlcHQlMkZmdXl1LThiJTIyKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmhmLWludGVybmFsLXRlc3RpbmclMkZmaXh0dXJlcy1jYXB0aW9uaW5nJTJGcmVzb2x2ZSUyRm1haW4lMkZidXMucG5nJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyR2VuZXJhdGUlMjBhJTIwY29jby1zdHlsZSUyMGNhcHRpb24uJTVDbiUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHRleHQlM0Rwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFnZW5lcmF0ZWRfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDcpJTBBZ2VuZXJhdGlvbl90ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfaWRzJTVCJTNBJTJDJTIwLTclM0ElNUQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklMEFwcmludChnZW5lcmF0aW9uX3RleHQlNUIwJTVEKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuProcessor, FuyuForCausalLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = FuyuProcessor.from_pretrained(<span class="hljs-string">&quot;adept/fuyu-8b&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = FuyuForCausalLM.from_pretrained(<span class="hljs-string">&quot;adept/fuyu-8b&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures-captioning/resolve/main/bus.png&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;Generate a coco-style caption.\\n&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>generated_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">7</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>generation_text = processor.batch_decode(generated_ids[:, -<span class="hljs-number">7</span>:], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(generation_text[<span class="hljs-number">0</span>])
A blue bus parked on the side of a road.`,wrap:!1}}),{c(){r=d("p"),r.textContent=T,c=n(),u(y.$$.fragment)},l(b){r=l(b,"P",{"data-svelte-h":!0}),m(r)!=="svelte-kvfsh7"&&(r.textContent=T),c=s(b),p(y.$$.fragment,b)},m(b,v){a(b,r,v),a(b,c,v),h(y,b,v),M=!0},p:Se,i(b){M||(f(y.$$.fragment,b),M=!0)},o(b){g(y.$$.fragment,b),M=!1},d(b){b&&(o(r),o(c)),_(y,b)}}}function Jo(Z){let r,T,c,y,M,b,v,Be='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',w,k,De,A,Yt='The Fuyu model was created by <a href="https://www.adept.ai/blog/fuyu-8b" rel="nofollow">ADEPT</a>, and authored by Rohan Bavishi, Erich Elsen, Curtis Hawthorne, Maxwell Nye, Augustus Odena, Arushi Somani, Sağnak Taşırlar.',Ye,O,Qt="The authors introduced Fuyu-8B, a decoder-only multimodal model based on the classic transformers architecture, with query and key normalization. A linear encoder is added to create multimodal embeddings from image inputs.",Qe,K,At="By treating image tokens like text tokens and using a special image-newline character, the model knows when an image line ends. Image positional embeddings are removed. This avoids the need for different training phases for various image resolutions. With 8 billion parameters and licensed under CC-BY-NC, Fuyu-8B is notable for its ability to handle both text and images, its impressive context size of 16K, and its overall performance.",Ae,q,Oe,ee,Ot="Tips:",Ke,te,Kt="<li>To convert the model, you need to clone the original repository using <code>git clone https://github.com/persimmon-ai-labs/adept-inference</code>, then get the checkpoints:</li>",et,oe,tt,ne,eo="For the chat model:",ot,se,nt,ae,to="Then, model can be loaded via:",st,re,at,ie,oo=`Inputs need to be passed through a specific Processor to have the correct formats.
A processor requires an image_processor and a tokenizer. Hence, inputs can be loaded via:`,rt,de,it,le,no=`This model was contributed by <a href="https://huggingface.co/Molbap" rel="nofollow">Molbap</a>.
The original code can be found <a href="https://github.com/persimmon-ai-labs/adept-inference" rel="nofollow">here</a>.`,dt,ce,so=`<li><p>Fuyu uses a <code>sentencepiece</code> based tokenizer, with a <code>Unigram</code> model. It supports bytefallback, which is only available in <code>tokenizers==0.14.0</code> for the fast tokenizer.
The <code>LlamaTokenizer</code> is used as it is a standard wrapper around sentencepiece.</p></li> <li><p>The authors suggest to use the following prompt for image captioning: <code>f&quot;Generate a coco-style caption.\\\\n&quot;</code></p></li>`,lt,me,ct,$,ue,Ft,Ce,ao=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a>. It is used to instantiate an
Fuyu model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the
<a href="https://huggingface.co/adept/fuyu-8b" rel="nofollow">adept/fuyu-8b</a>.`,kt,Le,ro=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,$t,G,mt,pe,ut,F,he,xt,Ie,io=`The Fuyu model which consists of a vision backbone and a language model, without a language modeling head.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,zt,Ze,lo=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ct,W,fe,Lt,Je,co='The <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuModel">FuyuModel</a> forward method, overrides the <code>__call__</code> special method.',It,H,Zt,N,ge,Jt,Pe,mo=`This function places the continuous_embeddings into the word_embeddings at the locations
indicated by image_patch_input_indices. Different batch elements can have different numbers of continuous
embeddings.`,pt,_e,ht,x,ye,Pt,Ue,uo=`Fuyu Model with a language modeling head on top for causal language model conditioned on image patches and text.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ut,je,po=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,jt,J,be,Wt,We,ho='The <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',Vt,R,Xt,B,ft,Te,gt,z,ve,qt,Ve,fo=`This class should handle the image processing part before the main FuyuForCausalLM. In particular, it should
handle:`,Gt,Xe,go=`<li><p>Processing Images:
Taking a batch of images as input. If the images are variable-sized, it resizes them based on the desired patch
dimensions. The image output is always img_h, img_w of (1080, 1920)</p> <p>Then, it patches up these images using the patchify_image function.</p></li> <li><p>Creating Image Input IDs:
For each patch, a placeholder ID is given to identify where these patches belong in a token sequence. For
variable-sized images, each line of patches is terminated with a newline ID.</p></li> <li><p>Image Patch Indices:
For each image patch, the code maintains an index where these patches should be inserted in a token stream.</p></li>`,Ht,E,we,Nt,qe,_o="Preprocess an image or a batch of images.",_t,Me,yt,C,Fe,Rt,Ge,yo="Constructs a Fuyu processor which wraps a Fuyu image processor and a Llama tokenizer into a single processor.",Bt,He,bo=`<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor">FuyuProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuProcessor.__call__"><strong>call</strong>()</a> and <code>decode()</code> for more information.`,Et,S,ke,St,Ne,To=`Main method to prepare for the model one or several sequences(s) and image(s). This method forwards the <code>text</code>
and <code>kwargs</code> arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__"><strong>call</strong>()</a> if <code>text</code> is not <code>None</code> to
encode the text. To prepare the image(s), this method forwards the <code>images</code> and <code>kwargs</code> arguments to
FuyuImageProcessor’s <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__"><strong>call</strong>()</a> if <code>images</code> is not <code>None</code>. Please refer to the docstring
of the above two methods for more information.`,bt,$e,Tt,Ee,vt;return M=new ze({props:{title:"Fuyu",local:"fuyu",headingTag:"h1"}}),k=new ze({props:{title:"Overview",local:"overview",headingTag:"h2"}}),q=new Dt({props:{warning:!0,$$slots:{default:[zo]},$$scope:{ctx:Z}}}),oe=new Re({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZwZXJzaW1tb24tYWktbGFicyUyRmFkZXB0LWluZmVyZW5jZSUwQXdnZXQlMjBwYXRoJTJGdG8lMkZmdXl1LThiLW1vZGVsLXdlaWdodHMudGFyJTBBdGFyJTIwLXh2ZiUyMGZ1eXUtOGItbW9kZWwtd2VpZ2h0cy50YXIlMEFweXRob24lMjBzcmMlMkZ0cmFuc2Zvcm1lcnMlMkZtb2RlbHMlMkZmdXl1JTJGY29udmVydF9mdXl1X3dlaWdodHNfdG9faGYucHklMjAlMjAtLWlucHV0X2RpciUyMCUyRnBhdGglMkZ0byUyRmRvd25sb2FkZWQlMkZmdXl1JTJGd2VpZ2h0cyUyRiUyMC0tb3V0cHV0X2RpciUyMCUyRm91dHB1dCUyRnBhdGglMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB0X21vZGVsX3BhdGglMjAlMkZwYXRoJTJGdG8lMkZmdXl1XzhiX3JlbGVhc2UlMkZpdGVyXzAwMDEyNTElMkZtcF9yYW5rXzAwJTJGbW9kZWxfb3B0aW1fcm5nLnB0JTBBJTIwJTIwJTIwJTIwLS1hZGFfbGliX3BhdGglMjAlMkZwYXRoJTJGdG8lMkZhZGVwdC1pbmZlcmVuY2U=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/persimmon-ai-labs/adept-inference
wget path/to/fuyu-8b-model-weights.tar
tar -xvf fuyu-8b-model-weights.tar
python src/transformers/models/fuyu/convert_fuyu_weights_to_hf.py  --input_dir /path/to/downloaded/fuyu/weights/ --output_dir /output/path \\
    --pt_model_path /path/to/fuyu_8b_release/iter_0001251/mp_rank_00/model_optim_rng.pt
    --ada_lib_path /path/to/adept-inference`,wrap:!1}}),se=new Re({props:{code:"d2dldCUyMGh0dHBzJTNBJTJGJTJGYXh0a240eGw1Y2lwLm9iamVjdHN0b3JhZ2UudXMtcGhvZW5peC0xLm9jaS5jdXN0b21lci1vY2kuY29tJTJGbiUyRmF4dGtuNHhsNWNpcCUyRmIlMkZhZGVwdC1wdWJsaWMtZGF0YSUyRm8lMkY4Yl9jaGF0X21vZGVsX3JlbGVhc2UudGFyJTBBdGFyJTIwLXh2ZiUyMDhiX2Jhc2VfbW9kZWxfcmVsZWFzZS50YXI=",highlighted:`wget https://axtkn4xl5cip.objectstorage.us-phoenix-1.oci.customer-oci.com/n/axtkn4xl5cip/b/adept-public-data/o/8b_chat_model_release.tar
tar -xvf 8b_base_model_release.tar`,wrap:!1}}),re=new Re({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEZ1eXVDb25maWclMkMlMjBGdXl1Rm9yQ2F1c2FsTE0lMEFtb2RlbF9jb25maWclMjAlM0QlMjBGdXl1Q29uZmlnKCklMEFtb2RlbCUyMCUzRCUyMEZ1eXVGb3JDYXVzYWxMTShtb2RlbF9jb25maWcpLmZyb21fcHJldHJhaW5lZCgnJTJGb3V0cHV0JTJGcGF0aCcp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> FuyuConfig, FuyuForCausalLM
model_config = FuyuConfig()
model = FuyuForCausalLM(model_config).from_pretrained(<span class="hljs-string">&#x27;/output/path&#x27;</span>)`,wrap:!1}}),de=new Re({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5mdXl1LnByb2Nlc3NpbmdfZnV5dSUyMGltcG9ydCUyMEZ1eXVQcm9jZXNzb3IlMEFmcm9tJTIwdHJhbnNmb3JtZXJzLm1vZGVscy5mdXl1LmltYWdlX3Byb2Nlc3NpbmdfZnV5dSUyMGltcG9ydCUyMEZ1eXVJbWFnZVByb2Nlc3NvciUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCdhZGVwdC1oZi1jb2xsYWIlMkZmdXl1LThiJyklMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBGdXl1SW1hZ2VQcm9jZXNzb3IoKSUwQSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEZ1eXVQcm9jZXNzb3IoaW1hZ2VfcHJvY2Vzc29yJTNEaW1hZ2VfcHJvY2Vzc29yJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQXRleHRfcHJvbXB0JTIwJTNEJTIwJTIyR2VuZXJhdGUlMjBhJTIwY29jby1zdHlsZSUyMGNhcHRpb24uJTVDJTVDbiUyMiUwQSUwQWJ1c19pbWFnZV91cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZoZi1pbnRlcm5hbC10ZXN0aW5nJTJGZml4dHVyZXMtY2FwdGlvbmluZyUyRnJlc29sdmUlMkZtYWluJTJGYnVzLnBuZyUyMiUwQWJ1c19pbWFnZV9waWwlMjAlM0QlMjBJbWFnZS5vcGVuKGlvLkJ5dGVzSU8ocmVxdWVzdHMuZ2V0KGJ1c19pbWFnZV91cmwpLmNvbnRlbnQpKSUwQWlucHV0c190b19tb2RlbCUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RidXNfaW1hZ2VfcGlsJTJDJTIwdGV4dCUzRHRleHRfcHJvbXB0KSUwQSUwQQ==",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> transformers.models.fuyu.processing_fuyu <span class="hljs-keyword">import</span> FuyuProcessor
<span class="hljs-keyword">from</span> transformers.models.fuyu.image_processing_fuyu <span class="hljs-keyword">import</span> FuyuImageProcessor


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&#x27;adept-hf-collab/fuyu-8b&#x27;</span>)
image_processor = FuyuImageProcessor()


processor = FuyuProcessor(image_processor=image_processor, tokenizer=tokenizer)
text_prompt = <span class="hljs-string">&quot;Generate a coco-style caption.\\\\n&quot;</span>

bus_image_url = <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/fixtures-captioning/resolve/main/bus.png&quot;</span>
bus_image_pil = Image.<span class="hljs-built_in">open</span>(io.BytesIO(requests.get(bus_image_url).content))
inputs_to_model = processor(images=bus_image_pil, text=text_prompt)

`,wrap:!1}}),me=new ze({props:{title:"FuyuConfig",local:"transformers.FuyuConfig",headingTag:"h2"}}),ue=new V({props:{name:"class transformers.FuyuConfig",anchor:"transformers.FuyuConfig",parameters:[{name:"vocab_size",val:" = 262144"},{name:"hidden_size",val:" = 4096"},{name:"intermediate_size",val:" = 16384"},{name:"num_hidden_layers",val:" = 36"},{name:"num_attention_heads",val:" = 64"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 16384"},{name:"image_size",val:" = 300"},{name:"patch_size",val:" = 30"},{name:"num_channels",val:" = 3"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 25000.0"},{name:"rope_scaling",val:" = None"},{name:"qk_layernorm",val:" = True"},{name:"hidden_dropout",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"text_config",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262144) &#x2014;
Vocabulary size of the Fuyu model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuForCausalLM">FuyuForCausalLM</a>`,name:"vocab_size"},{anchor:"transformers.FuyuConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.FuyuConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.FuyuConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 36) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.FuyuConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.FuyuConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.FuyuConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 16384) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.FuyuConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 300) &#x2014;
The input image size.`,name:"image_size"},{anchor:"transformers.FuyuConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
The input vision transformer encoding patch size.`,name:"patch_size"},{anchor:"transformers.FuyuConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The input image number of channels.`,name:"num_channels"},{anchor:"transformers.FuyuConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.FuyuConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.FuyuConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>. Whether to tie weight embeddings`,name:"use_cache"},{anchor:"transformers.FuyuConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie input and output embeddings.`,name:"tie_word_embeddings"},{anchor:"transformers.FuyuConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 25000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.FuyuConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be a float greater than 1. The expected format is
<code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalFuyu/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalFuyu/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This is an
experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.FuyuConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states`,name:"qk_layernorm"},{anchor:"transformers.FuyuConfig.hidden_dropout",description:`<strong>hidden_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after applying the MLP to the hidden states.`,name:"hidden_dropout"},{anchor:"transformers.FuyuConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.FuyuConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.FuyuConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The id of the <em>padding</em> token.`,name:"pad_token_id"},{anchor:"transformers.FuyuConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The id of the <em>beginning-of-sequence</em> token.`,name:"bos_token_id"},{anchor:"transformers.FuyuConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to 2) &#x2014;
The id of the <em>end-of-sequence</em> token. Optionally, use a list to set multiple <em>end-of-sequence</em> tokens.`,name:"eos_token_id"},{anchor:"transformers.FuyuConfig.text_config",description:"<strong>text_config</strong> (<code>dict</code>, <em>optional</em>) &#x2014;\nDictionary of configuration options used to initialize the <code>language```Aut</code>.",name:"text_config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/configuration_fuyu.py#L25"}}),G=new vo({props:{anchor:"transformers.FuyuConfig.example",$$slots:{default:[Co]},$$scope:{ctx:Z}}}),pe=new ze({props:{title:"FuyuModel",local:"transformers.FuyuModel",headingTag:"h2"}}),he=new V({props:{name:"class transformers.FuyuModel",anchor:"transformers.FuyuModel",parameters:[{name:"config",val:": FuyuConfig"}],parametersDescription:[{anchor:"transformers.FuyuModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L145"}}),fe=new V({props:{name:"forward",anchor:"transformers.FuyuModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"image_patches",val:": Tensor = None"},{name:"image_patches_indices",val:": Tensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FuyuModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.FuyuModel.forward.image_patches",description:`<strong>image_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_total_patches, patch_size_ x patch_size x num_channels)</code>, <em>optional</em>) &#x2014;
Image patches to be used as continuous embeddings. The patches are flattened and then projected to the
hidden size of the model.`,name:"image_patches"},{anchor:"transformers.FuyuModel.forward.image_patches_indices",description:`<strong>image_patches_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_total_patches + number_of_newline_tokens + number_of_text_tokens, patch_size_ x patch_size x num_channels )</code>, <em>optional</em>) &#x2014;
Indices indicating at which position the image_patches have to be inserted in input_embeds.`,name:"image_patches_indices"},{anchor:"transformers.FuyuModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FuyuModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.FuyuModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.FuyuModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FuyuModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FuyuModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FuyuModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L213"}}),H=new Dt({props:{$$slots:{default:[Lo]},$$scope:{ctx:Z}}}),ge=new V({props:{name:"gather_continuous_embeddings",anchor:"transformers.FuyuModel.gather_continuous_embeddings",parameters:[{name:"word_embeddings",val:": Tensor"},{name:"continuous_embeddings",val:": typing.List[torch.Tensor]"},{name:"image_patch_input_indices",val:": Tensor"}],parametersDescription:[{anchor:"transformers.FuyuModel.gather_continuous_embeddings.word_embeddings",description:`<strong>word_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Tensor of word embeddings.`,name:"word_embeddings"},{anchor:"transformers.FuyuModel.gather_continuous_embeddings.continuous_embeddings",description:`<strong>continuous_embeddings</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_patches, hidden_size)</code>) &#x2014;
Tensor of continuous embeddings. The length of the list is the batch size. Each entry is shape
[num_image_embeddings, hidden], and num_image_embeddings needs to match the number of non-negative
indices in image_patch_input_indices for that batch element.`,name:"continuous_embeddings"},{anchor:"transformers.FuyuModel.gather_continuous_embeddings.image_patch_input_indices",description:`<strong>image_patch_input_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Tensor of indices of the image patches in the input_ids tensor.`,name:"image_patch_input_indices"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L171"}}),_e=new ze({props:{title:"FuyuForCausalLM",local:"transformers.FuyuForCausalLM",headingTag:"h2"}}),ye=new V({props:{name:"class transformers.FuyuForCausalLM",anchor:"transformers.FuyuForCausalLM",parameters:[{name:"config",val:": FuyuConfig"}],parametersDescription:[{anchor:"transformers.FuyuForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig">FuyuConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L290"}}),be=new V({props:{name:"forward",anchor:"transformers.FuyuForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"image_patches",val:": Tensor = None"},{name:"image_patches_indices",val:": Tensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"logits_to_keep",val:": typing.Optional[int] = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.FuyuForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.FuyuForCausalLM.forward.image_patches",description:`<strong>image_patches</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_total_patches, patch_size_ x patch_size x num_channels)</code>, <em>optional</em>) &#x2014;
Image patches to be used as continuous embeddings. The patches are flattened and then projected to the
hidden size of the model.`,name:"image_patches"},{anchor:"transformers.FuyuForCausalLM.forward.image_patches_indices",description:`<strong>image_patches_indices</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_total_patches + number_of_newline_tokens + number_of_text_tokens, patch_size_ x patch_size x num_channels )</code>, <em>optional</em>) &#x2014;
Indices indicating at which position the image_patches have to be inserted in input_embeds.`,name:"image_patches_indices"},{anchor:"transformers.FuyuForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.FuyuForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.FuyuForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.FuyuForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.FuyuForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.FuyuForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.FuyuForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.FuyuForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.text_config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.text_config.vocab_size]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/modeling_fuyu.py#L326",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuConfig"
>FuyuConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),R=new Dt({props:{$$slots:{default:[Io]},$$scope:{ctx:Z}}}),B=new vo({props:{anchor:"transformers.FuyuForCausalLM.forward.example",$$slots:{default:[Zo]},$$scope:{ctx:Z}}}),Te=new ze({props:{title:"FuyuImageProcessor",local:"transformers.FuyuImageProcessor",headingTag:"h2"}}),ve=new V({props:{name:"class transformers.FuyuImageProcessor",anchor:"transformers.FuyuImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_pad",val:": bool = True"},{name:"padding_value",val:": float = 1.0"},{name:"padding_mode",val:": str = 'constant'"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float]] = 0.5"},{name:"image_std",val:": typing.Union[float, typing.List[float]] = 0.5"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": float = 0.00392156862745098"},{name:"patch_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>size</code>.`,name:"do_resize"},{anchor:"transformers.FuyuImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 1080, &quot;width&quot;: 1920}</code>):
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the output image.`,name:"size"},{anchor:"transformers.FuyuImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
<code>PILImageResampling</code> filter to use when resizing the image e.g. <code>PILImageResampling.BILINEAR</code>.`,name:"resample"},{anchor:"transformers.FuyuImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image to <code>size</code>.`,name:"do_pad"},{anchor:"transformers.FuyuImageProcessor.padding_value",description:`<strong>padding_value</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The value to pad the image with.`,name:"padding_value"},{anchor:"transformers.FuyuImageProcessor.padding_mode",description:`<strong>padding_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;constant&quot;</code>) &#x2014;
The padding mode to use when padding the image.`,name:"padding_mode"},{anchor:"transformers.FuyuImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.FuyuImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.FuyuImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
The standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.FuyuImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.FuyuImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>1 / 255</code>) &#x2014;
The factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.FuyuImageProcessor.patch_size",description:`<strong>patch_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 30, &quot;width&quot;: 30}</code>):
Dictionary in the format <code>{&quot;height&quot;: int, &quot;width&quot;: int}</code> specifying the size of the patches.`,name:"patch_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/image_processing_fuyu.py#L182"}}),we=new V({props:{name:"__call__",anchor:"transformers.FuyuImageProcessor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L42"}}),Me=new ze({props:{title:"FuyuProcessor",local:"transformers.FuyuProcessor",headingTag:"h2"}}),Fe=new V({props:{name:"class transformers.FuyuProcessor",anchor:"transformers.FuyuProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.FuyuProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/fuyu#transformers.FuyuImageProcessor">FuyuImageProcessor</a>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.FuyuProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/processing_fuyu.py#L330"}}),ke=new V({props:{name:"__call__",anchor:"transformers.FuyuProcessor.__call__",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']] = None"},{name:"text",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"audio",val:" = None"},{name:"videos",val:" = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.fuyu.processing_fuyu.FuyuProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.FuyuProcessor.__call__.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>List[PIL.Image.Image]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"},{anchor:"transformers.FuyuProcessor.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/fuyu/processing_fuyu.py#L474",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>FuyuBatchEncoding</code> with the following fields:</p>
<ul>
<li><strong>input_ids</strong> — Tensor of token ids to be fed to a model. Returned when <code>text</code> is not <code>None</code>.</li>
<li><strong>image_patches</strong> — List of Tensor of image patches. Returned when <code>images</code> is not <code>None</code>.</li>
<li><strong>image_patches_indices</strong> — Tensor of indices where patch embeddings have to be inserted by the model.</li>
<li><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model when
<code>return_attention_mask=True</code>.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>FuyuBatchEncoding</code></p>
`}}),$e=new xo({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/fuyu.md"}}),{c(){r=d("meta"),T=n(),c=d("p"),y=n(),u(M.$$.fragment),b=n(),v=d("div"),v.innerHTML=Be,w=n(),u(k.$$.fragment),De=n(),A=d("p"),A.innerHTML=Yt,Ye=n(),O=d("p"),O.textContent=Qt,Qe=n(),K=d("p"),K.textContent=At,Ae=n(),u(q.$$.fragment),Oe=n(),ee=d("p"),ee.textContent=Ot,Ke=n(),te=d("ul"),te.innerHTML=Kt,et=n(),u(oe.$$.fragment),tt=n(),ne=d("p"),ne.textContent=eo,ot=n(),u(se.$$.fragment),nt=n(),ae=d("p"),ae.textContent=to,st=n(),u(re.$$.fragment),at=n(),ie=d("p"),ie.textContent=oo,rt=n(),u(de.$$.fragment),it=n(),le=d("p"),le.innerHTML=no,dt=n(),ce=d("ul"),ce.innerHTML=so,lt=n(),u(me.$$.fragment),ct=n(),$=d("div"),u(ue.$$.fragment),Ft=n(),Ce=d("p"),Ce.innerHTML=ao,kt=n(),Le=d("p"),Le.innerHTML=ro,$t=n(),u(G.$$.fragment),mt=n(),u(pe.$$.fragment),ut=n(),F=d("div"),u(he.$$.fragment),xt=n(),Ie=d("p"),Ie.innerHTML=io,zt=n(),Ze=d("p"),Ze.innerHTML=lo,Ct=n(),W=d("div"),u(fe.$$.fragment),Lt=n(),Je=d("p"),Je.innerHTML=co,It=n(),u(H.$$.fragment),Zt=n(),N=d("div"),u(ge.$$.fragment),Jt=n(),Pe=d("p"),Pe.textContent=mo,pt=n(),u(_e.$$.fragment),ht=n(),x=d("div"),u(ye.$$.fragment),Pt=n(),Ue=d("p"),Ue.innerHTML=uo,Ut=n(),je=d("p"),je.innerHTML=po,jt=n(),J=d("div"),u(be.$$.fragment),Wt=n(),We=d("p"),We.innerHTML=ho,Vt=n(),u(R.$$.fragment),Xt=n(),u(B.$$.fragment),ft=n(),u(Te.$$.fragment),gt=n(),z=d("div"),u(ve.$$.fragment),qt=n(),Ve=d("p"),Ve.textContent=fo,Gt=n(),Xe=d("ul"),Xe.innerHTML=go,Ht=n(),E=d("div"),u(we.$$.fragment),Nt=n(),qe=d("p"),qe.textContent=_o,_t=n(),u(Me.$$.fragment),yt=n(),C=d("div"),u(Fe.$$.fragment),Rt=n(),Ge=d("p"),Ge.textContent=yo,Bt=n(),He=d("p"),He.innerHTML=bo,Et=n(),S=d("div"),u(ke.$$.fragment),St=n(),Ne=d("p"),Ne.innerHTML=To,bt=n(),u($e.$$.fragment),Tt=n(),Ee=d("p"),this.h()},l(e){const t=$o("svelte-u9bgzb",document.head);r=l(t,"META",{name:!0,content:!0}),t.forEach(o),T=s(e),c=l(e,"P",{}),P(c).forEach(o),y=s(e),p(M.$$.fragment,e),b=s(e),v=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(v)!=="svelte-13t8s2t"&&(v.innerHTML=Be),w=s(e),p(k.$$.fragment,e),De=s(e),A=l(e,"P",{"data-svelte-h":!0}),m(A)!=="svelte-1f0fj96"&&(A.innerHTML=Yt),Ye=s(e),O=l(e,"P",{"data-svelte-h":!0}),m(O)!=="svelte-d0qe5n"&&(O.textContent=Qt),Qe=s(e),K=l(e,"P",{"data-svelte-h":!0}),m(K)!=="svelte-1xp7ehr"&&(K.textContent=At),Ae=s(e),p(q.$$.fragment,e),Oe=s(e),ee=l(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-axv494"&&(ee.textContent=Ot),Ke=s(e),te=l(e,"UL",{"data-svelte-h":!0}),m(te)!=="svelte-g9ue9k"&&(te.innerHTML=Kt),et=s(e),p(oe.$$.fragment,e),tt=s(e),ne=l(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-1cs7acv"&&(ne.textContent=eo),ot=s(e),p(se.$$.fragment,e),nt=s(e),ae=l(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1c7gnsu"&&(ae.textContent=to),st=s(e),p(re.$$.fragment,e),at=s(e),ie=l(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-60q0vi"&&(ie.textContent=oo),rt=s(e),p(de.$$.fragment,e),it=s(e),le=l(e,"P",{"data-svelte-h":!0}),m(le)!=="svelte-1ius34j"&&(le.innerHTML=no),dt=s(e),ce=l(e,"UL",{"data-svelte-h":!0}),m(ce)!=="svelte-1pf7ero"&&(ce.innerHTML=so),lt=s(e),p(me.$$.fragment,e),ct=s(e),$=l(e,"DIV",{class:!0});var U=P($);p(ue.$$.fragment,U),Ft=s(U),Ce=l(U,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-14kk906"&&(Ce.innerHTML=ao),kt=s(U),Le=l(U,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-o55m63"&&(Le.innerHTML=ro),$t=s(U),p(G.$$.fragment,U),U.forEach(o),mt=s(e),p(pe.$$.fragment,e),ut=s(e),F=l(e,"DIV",{class:!0});var L=P(F);p(he.$$.fragment,L),xt=s(L),Ie=l(L,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-qvmyom"&&(Ie.innerHTML=io),zt=s(L),Ze=l(L,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-hswkmf"&&(Ze.innerHTML=lo),Ct=s(L),W=l(L,"DIV",{class:!0});var X=P(W);p(fe.$$.fragment,X),Lt=s(X),Je=l(X,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-101v11e"&&(Je.innerHTML=co),It=s(X),p(H.$$.fragment,X),X.forEach(o),Zt=s(L),N=l(L,"DIV",{class:!0});var xe=P(N);p(ge.$$.fragment,xe),Jt=s(xe),Pe=l(xe,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-13frnol"&&(Pe.textContent=mo),xe.forEach(o),L.forEach(o),pt=s(e),p(_e.$$.fragment,e),ht=s(e),x=l(e,"DIV",{class:!0});var j=P(x);p(ye.$$.fragment,j),Pt=s(j),Ue=l(j,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-19j7dmx"&&(Ue.innerHTML=uo),Ut=s(j),je=l(j,"P",{"data-svelte-h":!0}),m(je)!=="svelte-hswkmf"&&(je.innerHTML=po),jt=s(j),J=l(j,"DIV",{class:!0});var D=P(J);p(be.$$.fragment,D),Wt=s(D),We=l(D,"P",{"data-svelte-h":!0}),m(We)!=="svelte-15glyuy"&&(We.innerHTML=ho),Vt=s(D),p(R.$$.fragment,D),Xt=s(D),p(B.$$.fragment,D),D.forEach(o),j.forEach(o),ft=s(e),p(Te.$$.fragment,e),gt=s(e),z=l(e,"DIV",{class:!0});var Y=P(z);p(ve.$$.fragment,Y),qt=s(Y),Ve=l(Y,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-psqr0m"&&(Ve.textContent=fo),Gt=s(Y),Xe=l(Y,"UL",{"data-svelte-h":!0}),m(Xe)!=="svelte-16e0qf2"&&(Xe.innerHTML=go),Ht=s(Y),E=l(Y,"DIV",{class:!0});var wt=P(E);p(we.$$.fragment,wt),Nt=s(wt),qe=l(wt,"P",{"data-svelte-h":!0}),m(qe)!=="svelte-khengj"&&(qe.textContent=_o),wt.forEach(o),Y.forEach(o),_t=s(e),p(Me.$$.fragment,e),yt=s(e),C=l(e,"DIV",{class:!0});var Q=P(C);p(Fe.$$.fragment,Q),Rt=s(Q),Ge=l(Q,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1wc4ris"&&(Ge.textContent=yo),Bt=s(Q),He=l(Q,"P",{"data-svelte-h":!0}),m(He)!=="svelte-l1nxiu"&&(He.innerHTML=bo),Et=s(Q),S=l(Q,"DIV",{class:!0});var Mt=P(S);p(ke.$$.fragment,Mt),St=s(Mt),Ne=l(Mt,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1ub9ks7"&&(Ne.innerHTML=To),Mt.forEach(o),Q.forEach(o),bt=s(e),p($e.$$.fragment,e),Tt=s(e),Ee=l(e,"P",{}),P(Ee).forEach(o),this.h()},h(){I(r,"name","hf:doc:metadata"),I(r,"content",Po),I(v,"class","flex flex-wrap space-x-1"),I($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,r),a(e,T,t),a(e,c,t),a(e,y,t),h(M,e,t),a(e,b,t),a(e,v,t),a(e,w,t),h(k,e,t),a(e,De,t),a(e,A,t),a(e,Ye,t),a(e,O,t),a(e,Qe,t),a(e,K,t),a(e,Ae,t),h(q,e,t),a(e,Oe,t),a(e,ee,t),a(e,Ke,t),a(e,te,t),a(e,et,t),h(oe,e,t),a(e,tt,t),a(e,ne,t),a(e,ot,t),h(se,e,t),a(e,nt,t),a(e,ae,t),a(e,st,t),h(re,e,t),a(e,at,t),a(e,ie,t),a(e,rt,t),h(de,e,t),a(e,it,t),a(e,le,t),a(e,dt,t),a(e,ce,t),a(e,lt,t),h(me,e,t),a(e,ct,t),a(e,$,t),h(ue,$,null),i($,Ft),i($,Ce),i($,kt),i($,Le),i($,$t),h(G,$,null),a(e,mt,t),h(pe,e,t),a(e,ut,t),a(e,F,t),h(he,F,null),i(F,xt),i(F,Ie),i(F,zt),i(F,Ze),i(F,Ct),i(F,W),h(fe,W,null),i(W,Lt),i(W,Je),i(W,It),h(H,W,null),i(F,Zt),i(F,N),h(ge,N,null),i(N,Jt),i(N,Pe),a(e,pt,t),h(_e,e,t),a(e,ht,t),a(e,x,t),h(ye,x,null),i(x,Pt),i(x,Ue),i(x,Ut),i(x,je),i(x,jt),i(x,J),h(be,J,null),i(J,Wt),i(J,We),i(J,Vt),h(R,J,null),i(J,Xt),h(B,J,null),a(e,ft,t),h(Te,e,t),a(e,gt,t),a(e,z,t),h(ve,z,null),i(z,qt),i(z,Ve),i(z,Gt),i(z,Xe),i(z,Ht),i(z,E),h(we,E,null),i(E,Nt),i(E,qe),a(e,_t,t),h(Me,e,t),a(e,yt,t),a(e,C,t),h(Fe,C,null),i(C,Rt),i(C,Ge),i(C,Bt),i(C,He),i(C,Et),i(C,S),h(ke,S,null),i(S,St),i(S,Ne),a(e,bt,t),h($e,e,t),a(e,Tt,t),a(e,Ee,t),vt=!0},p(e,[t]){const U={};t&2&&(U.$$scope={dirty:t,ctx:e}),q.$set(U);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),G.$set(L);const X={};t&2&&(X.$$scope={dirty:t,ctx:e}),H.$set(X);const xe={};t&2&&(xe.$$scope={dirty:t,ctx:e}),R.$set(xe);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),B.$set(j)},i(e){vt||(f(M.$$.fragment,e),f(k.$$.fragment,e),f(q.$$.fragment,e),f(oe.$$.fragment,e),f(se.$$.fragment,e),f(re.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(G.$$.fragment,e),f(pe.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(H.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(R.$$.fragment,e),f(B.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(Me.$$.fragment,e),f(Fe.$$.fragment,e),f(ke.$$.fragment,e),f($e.$$.fragment,e),vt=!0)},o(e){g(M.$$.fragment,e),g(k.$$.fragment,e),g(q.$$.fragment,e),g(oe.$$.fragment,e),g(se.$$.fragment,e),g(re.$$.fragment,e),g(de.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(G.$$.fragment,e),g(pe.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(H.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(R.$$.fragment,e),g(B.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(Me.$$.fragment,e),g(Fe.$$.fragment,e),g(ke.$$.fragment,e),g($e.$$.fragment,e),vt=!1},d(e){e&&(o(T),o(c),o(y),o(b),o(v),o(w),o(De),o(A),o(Ye),o(O),o(Qe),o(K),o(Ae),o(Oe),o(ee),o(Ke),o(te),o(et),o(tt),o(ne),o(ot),o(nt),o(ae),o(st),o(at),o(ie),o(rt),o(it),o(le),o(dt),o(ce),o(lt),o(ct),o($),o(mt),o(ut),o(F),o(pt),o(ht),o(x),o(ft),o(gt),o(z),o(_t),o(yt),o(C),o(bt),o(Tt),o(Ee)),o(r),_(M,e),_(k,e),_(q,e),_(oe,e),_(se,e),_(re,e),_(de,e),_(me,e),_(ue),_(G),_(pe,e),_(he),_(fe),_(H),_(ge),_(_e,e),_(ye),_(be),_(R),_(B),_(Te,e),_(ve),_(we),_(Me,e),_(Fe),_(ke),_($e,e)}}}const Po='{"title":"Fuyu","local":"fuyu","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"FuyuConfig","local":"transformers.FuyuConfig","sections":[],"depth":2},{"title":"FuyuModel","local":"transformers.FuyuModel","sections":[],"depth":2},{"title":"FuyuForCausalLM","local":"transformers.FuyuForCausalLM","sections":[],"depth":2},{"title":"FuyuImageProcessor","local":"transformers.FuyuImageProcessor","sections":[],"depth":2},{"title":"FuyuProcessor","local":"transformers.FuyuProcessor","sections":[],"depth":2}],"depth":1}';function Uo(Z){return Mo(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ro extends Fo{constructor(r){super(),ko(this,r,Uo,Jo,wo,{})}}export{Ro as component};
