import{s as Xt,z as Vt,o as Yt,n as so}from"../chunks/scheduler.18a86fab.js";import{S as Kt,i as en,g as i,s as n,r as g,A as on,h as d,f as t,c as s,j,u as p,x as m,k as w,y as a,a as r,v as h,d as u,t as f,w as _}from"../chunks/index.98837b22.js";import{T as Qt}from"../chunks/Tip.77304350.js";import{D as $}from"../chunks/Docstring.6758ea23.js";import{C as Zo}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ft}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as q}from"../chunks/Heading.7e7e0c5b.js";import{E as tn}from"../chunks/index.499f366c.js";function nn(z){let c,T="Examples:",b,y,v;return y=new Zo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEdyb3VuZGluZ0Rpbm9Db25maWclMkMlMjBHcm91bmRpbmdEaW5vTW9kZWwlMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwR3JvdW5kaW5nJTIwRElOTyUyMElERUEtUmVzZWFyY2glMkZncm91bmRpbmctZGluby10aW55JTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMEdyb3VuZGluZ0Rpbm9Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwSURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEdyb3VuZGluZ0Rpbm9Nb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> GroundingDinoConfig, GroundingDinoModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Grounding DINO IDEA-Research/grounding-dino-tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = GroundingDinoConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the IDEA-Research/grounding-dino-tiny style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = GroundingDinoModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,b=n(),g(y.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=T),b=s(l),p(y.$$.fragment,l)},m(l,x){r(l,c,x),r(l,b,x),h(y,l,x),v=!0},p:so,i(l){v||(u(y.$$.fragment,l),v=!0)},o(l){f(y.$$.fragment,l),v=!1},d(l){l&&(t(c),t(b)),_(y,l)}}}function sn(z){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=T},l(b){c=d(b,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(b,y){r(b,c,y)},p:so,d(b){b&&t(c)}}}function rn(z){let c,T="Examples:",b,y,v;return y=new Zo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBBdXRvTW9kZWwlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjByZXF1ZXN0cyUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEF0ZXh0JTIwJTNEJTIwJTIyYSUyMGNhdC4lMjIlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJJREVBLVJlc2VhcmNoJTJGZ3JvdW5kaW5nLWRpbm8tdGlueSUyMiklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIySURFQS1SZXNlYXJjaCUyRmdyb3VuZGluZy1kaW5vLXRpbnklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwdGV4dCUzRHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMEFsYXN0X2hpZGRlbl9zdGF0ZXMlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZXMuc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;a cat.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModel.from_pretrained(<span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">900</span>, <span class="hljs-number">256</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,b=n(),g(y.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=T),b=s(l),p(y.$$.fragment,l)},m(l,x){r(l,c,x),r(l,b,x),h(y,l,x),v=!0},p:so,i(l){v||(u(y.$$.fragment,l),v=!0)},o(l){f(y.$$.fragment,l),v=!1},d(l){l&&(t(c),t(b)),_(y,l)}}}function an(z){let c,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=i("p"),c.innerHTML=T},l(b){c=d(b,"P",{"data-svelte-h":!0}),m(c)!=="svelte-fincs2"&&(c.innerHTML=T)},m(b,y){r(b,c,y)},p:so,d(b){b&&t(c)}}}function dn(z){let c,T="Examples:",b,y,v;return y=new Zo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(image_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Check for cats and remote controls</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a remote control&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    threshold=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    text_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    target_sizes=[(image.height, image.width)]
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Retrieve the first image result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, text_label <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;text_labels&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(x, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{text_label}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.479</span> at location [<span class="hljs-number">344.7</span>, <span class="hljs-number">23.11</span>, <span class="hljs-number">637.18</span>, <span class="hljs-number">374.28</span>]
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.438</span> at location [<span class="hljs-number">12.27</span>, <span class="hljs-number">51.91</span>, <span class="hljs-number">316.86</span>, <span class="hljs-number">472.44</span>]
Detected a remote control <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.478</span> at location [<span class="hljs-number">38.57</span>, <span class="hljs-number">70.0</span>, <span class="hljs-number">176.78</span>, <span class="hljs-number">118.18</span>]`,wrap:!1}}),{c(){c=i("p"),c.textContent=T,b=n(),g(y.$$.fragment)},l(l){c=d(l,"P",{"data-svelte-h":!0}),m(c)!=="svelte-kvfsh7"&&(c.textContent=T),b=s(l),p(y.$$.fragment,l)},m(l,x){r(l,c,x),r(l,b,x),h(y,l,x),v=!0},p:so,i(l){v||(u(y.$$.fragment,l),v=!0)},o(l){f(y.$$.fragment,l),v=!1},d(l){l&&(t(c),t(b)),_(y,l)}}}function cn(z){let c,T,b,y,v,l,x,_t='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',ro,oe,ao,te,bt='The Grounding DINO model was proposed in <a href="https://arxiv.org/abs/2303.05499" rel="nofollow">Grounding DINO: Marrying DINO with Grounded Pre-Training for Open-Set Object Detection</a> by Shilong Liu, Zhaoyang Zeng, Tianhe Ren, Feng Li, Hao Zhang, Jie Yang, Chunyuan Li, Jianwei Yang, Hang Su, Jun Zhu, Lei Zhang. Grounding DINO extends a closed-set object detection model with a text encoder, enabling open-set object detection. The model achieves remarkable results, such as 52.5 AP on COCO zero-shot.',io,ne,yt="The abstract from the paper is the following:",co,se,vt="<em>In this paper, we present an open-set object detector, called Grounding DINO, by marrying Transformer-based detector DINO with grounded pre-training, which can detect arbitrary objects with human inputs such as category names or referring expressions. The key solution of open-set object detection is introducing language to a closed-set detector for open-set concept generalization. To effectively fuse language and vision modalities, we conceptually divide a closed-set detector into three phases and propose a tight fusion solution, which includes a feature enhancer, a language-guided query selection, and a cross-modality decoder for cross-modality fusion. While previous works mainly evaluate open-set object detection on novel categories, we propose to also perform evaluations on referring expression comprehension for objects specified with attributes. Grounding DINO performs remarkably well on all three settings, including benchmarks on COCO, LVIS, ODinW, and RefCOCO/+/g. Grounding DINO achieves a 52.5 AP on the COCO detection zero-shot transfer benchmark, i.e., without any training data from COCO. It sets a new record on the ODinW zero-shot benchmark with a mean 26.1 AP.</em>",lo,Z,wt,mo,re,xt='Grounding DINO overview. Taken from the <a href="https://arxiv.org/abs/2303.05499">original paper</a>.',go,ae,Tt=`This model was contributed by <a href="https://huggingface.co/EduardoPacheco" rel="nofollow">EduardoPacheco</a> and <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/IDEA-Research/GroundingDINO" rel="nofollow">here</a>.`,po,ie,ho,de,Mt='<li>One can use <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> to prepare image-text pairs for the model.</li> <li>To separate classes in the text use a period e.g. “a cat. a dog.”</li> <li>When using multiple classes (e.g. <code>&quot;a cat. a dog.&quot;</code>), use <code>post_process_grounded_object_detection</code> from <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> to post process outputs. Since, the labels returned from <code>post_process_object_detection</code> represent the indices from the model dimension where prob &gt; threshold.</li>',uo,ce,Dt="Here’s how to use the model for zero-shot object detection:",fo,le,_o,me,bo,ge,jt='One can combine Grounding DINO with the <a href="sam">Segment Anything</a> model for text-based mask generation as introduced in <a href="https://arxiv.org/abs/2401.14159" rel="nofollow">Grounded SAM: Assembling Open-World Models for Diverse Visual Tasks</a>. You can refer to this <a href="https://github.com/NielsRogge/Transformers-Tutorials/blob/master/Grounding%20DINO/GroundingDINO_with_Segment_Anything.ipynb" rel="nofollow">demo notebook</a> 🌍 for details.',yo,E,Ct,vo,pe,Gt='Grounded SAM overview. Taken from the <a href="https://github.com/IDEA-Research/Grounded-Segment-Anything">original repository</a>.',wo,he,xo,ue,It="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with Grounding DINO. If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",To,fe,zt='<li>Demo notebooks regarding inference with Grounding DINO as well as combining it with <a href="sam">SAM</a> can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Grounding%20DINO" rel="nofollow">here</a>. 🌎</li>',Mo,_e,Do,F,be,Eo,Re,kt="Constructs a Grounding DINO image processor.",Wo,W,ye,Lo,Ze,Ut="Preprocess an image or a batch of images so that it can be used by the model.",jo,ve,Co,C,we,Oo,Ee,$t="Constructs a fast GroundingDino image processor.",So,L,xe,Ao,We,Ft="Preprocess an image or batch of images.",Bo,O,Te,Ho,Le,Jt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format.`,Go,Me,Io,G,De,Vo,Oe,qt=`Constructs a Grounding DINO processor which wraps a Deformable DETR image processor and a BERT tokenizer into a
single processor.`,Qo,Se,Pt=`<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor">GroundingDinoProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoImageProcessor">GroundingDinoImageProcessor</a> and
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See the docstring of <code>__call__()</code> and <code>decode()</code>
for more information.`,Xo,S,je,Yo,Ae,Nt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format and get the associated text label.`,zo,Ce,ko,I,Ge,Ko,Be,Rt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a>. It is used to instantiate a
Grounding DINO model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Grounding DINO
<a href="https://huggingface.co/IDEA-Research/grounding-dino-tiny" rel="nofollow">IDEA-Research/grounding-dino-tiny</a> architecture.`,et,He,Zt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ot,A,Uo,Ie,$o,M,ze,tt,Ve,Et=`The bare Grounding DINO Model (consisting of a backbone and encoder-decoder Transformer) outputting raw
hidden-states without any specific head on top.`,nt,Qe,Wt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,st,Xe,Lt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,rt,k,ke,at,Ye,Ot='The <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a> forward method, overrides the <code>__call__</code> special method.',it,B,dt,H,Fo,Ue,Jo,D,$e,ct,Ke,St=`Grounding DINO Model (consisting of a backbone and encoder-decoder Transformer) with object detection heads on top,
for tasks such as COCO detection.`,lt,eo,At=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,mt,oo,Bt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,gt,U,Fe,pt,to,Ht='The <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoForObjectDetection">GroundingDinoForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',ht,V,ut,Q,qo,Je,Po,no,No;return v=new q({props:{title:"Grounding DINO",local:"grounding-dino",headingTag:"h1"}}),oe=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ie=new q({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),le=new Zo({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForZeroShotObjectDetection

<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;IDEA-Research/grounding-dino-tiny&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device = <span class="hljs-string">&quot;cuda&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(model_id)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForZeroShotObjectDetection.from_pretrained(model_id).to(device)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(image_url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Check for cats and remote controls</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_labels = [[<span class="hljs-string">&quot;a cat&quot;</span>, <span class="hljs-string">&quot;a remote control&quot;</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=text_labels, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(device)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>results = processor.post_process_grounded_object_detection(
<span class="hljs-meta">... </span>    outputs,
<span class="hljs-meta">... </span>    inputs.input_ids,
<span class="hljs-meta">... </span>    box_threshold=<span class="hljs-number">0.4</span>,
<span class="hljs-meta">... </span>    text_threshold=<span class="hljs-number">0.3</span>,
<span class="hljs-meta">... </span>    target_sizes=[image.size[::-<span class="hljs-number">1</span>]]
<span class="hljs-meta">... </span>)

<span class="hljs-comment"># Retrieve the first image result</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>result = results[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> box, score, labels <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(result[<span class="hljs-string">&quot;boxes&quot;</span>], result[<span class="hljs-string">&quot;scores&quot;</span>], result[<span class="hljs-string">&quot;labels&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(x, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Detected <span class="hljs-subst">{labels}</span> with confidence <span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>)
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.468</span> at location [<span class="hljs-number">344.78</span>, <span class="hljs-number">22.9</span>, <span class="hljs-number">637.3</span>, <span class="hljs-number">373.62</span>]
Detected a cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.426</span> at location [<span class="hljs-number">11.74</span>, <span class="hljs-number">51.55</span>, <span class="hljs-number">316.51</span>, <span class="hljs-number">473.22</span>]`,wrap:!1}}),me=new q({props:{title:"Grounded SAM",local:"grounded-sam",headingTag:"h2"}}),he=new q({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new q({props:{title:"GroundingDinoImageProcessor",local:"transformers.GroundingDinoImageProcessor",headingTag:"h2"}}),be=new $({props:{name:"class transformers.GroundingDinoImageProcessor",anchor:"transformers.GroundingDinoImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.models.grounding_dino.image_processing_grounding_dino.AnnotationFormat] = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method. Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code>
parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessor.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the DETR model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L841"}}),ye=new $({props:{name:"preprocess",anchor:"transformers.GroundingDinoImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"annotations",val:": typing.Union[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]], typing.List[typing.Dict[str, typing.Union[int, str, typing.List[typing.Dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": typing.Optional[bool] = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.models.grounding_dino.image_processing_grounding_dino.AnnotationFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[transformers.image_utils.ChannelDimension, str, NoneType] = None"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.GroundingDinoImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino.py#L1301"}}),ve=new q({props:{title:"GroundingDinoImageProcessorFast",local:"transformers.GroundingDinoImageProcessorFast",headingTag:"h2"}}),we=new $({props:{name:"class transformers.GroundingDinoImageProcessorFast",anchor:"transformers.GroundingDinoImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.grounding_dino.image_processing_grounding_dino_fast.GroundingDinoFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.GroundingDinoImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.GroundingDinoImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.GroundingDinoImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.GroundingDinoImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.GroundingDinoImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.GroundingDinoImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.GroundingDinoImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.GroundingDinoImageProcessorFast.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessorFast.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the GROUNDING_DINO model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessorFast.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"},{anchor:"transformers.GroundingDinoImageProcessorFast.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino_fast.py#L300"}}),xe=new $({props:{name:"preprocess",anchor:"transformers.GroundingDinoImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"annotations",val:": typing.Union[dict[str, typing.Union[int, str, list[dict]]], typing.List[dict[str, typing.Union[int, str, list[dict]]]], NoneType] = None"},{name:"masks_path",val:": typing.Union[str, pathlib.Path, NoneType] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.grounding_dino.image_processing_grounding_dino_fast.GroundingDinoFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the GROUNDING_DINO model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.GroundingDinoImageProcessorFast.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino_fast.py#L596"}}),Te=new $({props:{name:"post_process_object_detection",anchor:"transformers.GroundingDinoImageProcessorFast.post_process_object_detection",parameters:[{name:"outputs",val:": GroundingDinoObjectDetectionOutput"},{name:"threshold",val:": float = 0.1"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoImageProcessorFast.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>GroundingDinoObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.GroundingDinoImageProcessorFast.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.GroundingDinoImageProcessorFast.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/image_processing_grounding_dino_fast.py#L771",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the following keys:</p>
<ul>
<li>“scores”: The confidence scores for each predicted box on the image.</li>
<li>“labels”: Indexes of the classes predicted by the model on the image.</li>
<li>“boxes”: Image bounding boxes in (top_left_x, top_left_y, bottom_right_x, bottom_right_y) format.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Me=new q({props:{title:"GroundingDinoProcessor",local:"transformers.GroundingDinoProcessor",headingTag:"h2"}}),De=new $({props:{name:"class transformers.GroundingDinoProcessor",anchor:"transformers.GroundingDinoProcessor",parameters:[{name:"image_processor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoProcessor.image_processor",description:`<strong>image_processor</strong> (<code>GroundingDinoImageProcessor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoImageProcessor">GroundingDinoImageProcessor</a>. The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.GroundingDinoProcessor.tokenizer",description:"<strong>tokenizer</strong> (<code>AutoTokenizer</code>) &#x2014;\nAn instance of [&#x2018;PreTrainedTokenizer`]. The tokenizer is a required input.",name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/processing_grounding_dino.py#L129"}}),je=new $({props:{name:"post_process_grounded_object_detection",anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection",parameters:[{name:"outputs",val:": GroundingDinoObjectDetectionOutput"},{name:"input_ids",val:": typing.Optional[transformers.utils.generic.TensorType] = None"},{name:"threshold",val:": float = 0.25"},{name:"text_threshold",val:": float = 0.25"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple], NoneType] = None"},{name:"text_labels",val:": typing.Optional[typing.List[typing.List[str]]] = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.outputs",description:`<strong>outputs</strong> (<code>GroundingDinoObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The token ids of the input text. If not provided will be taken from the model output.`,name:"input_ids"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Threshold to keep object detection predictions based on confidence score.`,name:"threshold"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.text_threshold",description:`<strong>text_threshold</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Score threshold to keep text detection predictions.`,name:"text_threshold"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.GroundingDinoProcessor.post_process_grounded_object_detection.text_labels",description:`<strong>text_labels</strong> (<code>List[List[str]]</code>, <em>optional</em>) &#x2014;
List of candidate labels to be detected on each image. At the moment it&#x2019;s <em>NOT used</em>, but required
to be in signature for the zero-shot object detection pipeline. Text labels are instead extracted
from the <code>input_ids</code> tensor provided in <code>outputs</code>.`,name:"text_labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/processing_grounding_dino.py#L242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the</p>
<ul>
<li><strong>scores</strong>: tensor of confidence scores for detected objects</li>
<li><strong>boxes</strong>: tensor of bounding boxes in [x0, y0, x1, y1] format</li>
<li><strong>labels</strong>: list of text labels for each detected object (will be replaced with integer ids in v4.51.0)</li>
<li><strong>text_labels</strong>: list of text labels for detected objects</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ce=new q({props:{title:"GroundingDinoConfig",local:"transformers.GroundingDinoConfig",headingTag:"h2"}}),Ge=new $({props:{name:"class transformers.GroundingDinoConfig",anchor:"transformers.GroundingDinoConfig",parameters:[{name:"backbone_config",val:" = None"},{name:"backbone",val:" = None"},{name:"use_pretrained_backbone",val:" = False"},{name:"use_timm_backbone",val:" = False"},{name:"backbone_kwargs",val:" = None"},{name:"text_config",val:" = None"},{name:"num_queries",val:" = 900"},{name:"encoder_layers",val:" = 6"},{name:"encoder_ffn_dim",val:" = 2048"},{name:"encoder_attention_heads",val:" = 8"},{name:"decoder_layers",val:" = 6"},{name:"decoder_ffn_dim",val:" = 2048"},{name:"decoder_attention_heads",val:" = 8"},{name:"is_encoder_decoder",val:" = True"},{name:"activation_function",val:" = 'relu'"},{name:"d_model",val:" = 256"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"auxiliary_loss",val:" = False"},{name:"position_embedding_type",val:" = 'sine'"},{name:"num_feature_levels",val:" = 4"},{name:"encoder_n_points",val:" = 4"},{name:"decoder_n_points",val:" = 4"},{name:"two_stage",val:" = True"},{name:"class_cost",val:" = 1.0"},{name:"bbox_cost",val:" = 5.0"},{name:"giou_cost",val:" = 2.0"},{name:"bbox_loss_coefficient",val:" = 5.0"},{name:"giou_loss_coefficient",val:" = 2.0"},{name:"focal_alpha",val:" = 0.25"},{name:"disable_custom_kernels",val:" = False"},{name:"max_text_len",val:" = 256"},{name:"text_enhancer_dropout",val:" = 0.0"},{name:"fusion_droppath",val:" = 0.1"},{name:"fusion_dropout",val:" = 0.0"},{name:"embedding_init_target",val:" = True"},{name:"query_dim",val:" = 4"},{name:"decoder_bbox_embed_share",val:" = True"},{name:"two_stage_bbox_embed_share",val:" = False"},{name:"positional_embedding_temperature",val:" = 20"},{name:"init_std",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.GroundingDinoConfig.backbone_config",description:`<strong>backbone_config</strong> (<code>PretrainedConfig</code> or <code>dict</code>, <em>optional</em>, defaults to <code>ResNetConfig()</code>) &#x2014;
The configuration of the backbone model.`,name:"backbone_config"},{anchor:"transformers.GroundingDinoConfig.backbone",description:`<strong>backbone</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Name of backbone to use when <code>backbone_config</code> is <code>None</code>. If <code>use_pretrained_backbone</code> is <code>True</code>, this
will load the corresponding pretrained weights from the timm or transformers library. If <code>use_pretrained_backbone</code>
is <code>False</code>, this loads the backbone&#x2019;s config and uses that to initialize the backbone with random weights.`,name:"backbone"},{anchor:"transformers.GroundingDinoConfig.use_pretrained_backbone",description:`<strong>use_pretrained_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use pretrained weights for the backbone.`,name:"use_pretrained_backbone"},{anchor:"transformers.GroundingDinoConfig.use_timm_backbone",description:`<strong>use_timm_backbone</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to load <code>backbone</code> from the timm library. If <code>False</code>, the backbone is loaded from the transformers
library.`,name:"use_timm_backbone"},{anchor:"transformers.GroundingDinoConfig.backbone_kwargs",description:`<strong>backbone_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Keyword arguments to be passed to AutoBackbone when loading from a checkpoint
e.g. <code>{&apos;out_indices&apos;: (0, 1, 2, 3)}</code>. Cannot be specified if <code>backbone_config</code> is set.`,name:"backbone_kwargs"},{anchor:"transformers.GroundingDinoConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>BertConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.GroundingDinoConfig.num_queries",description:`<strong>num_queries</strong> (<code>int</code>, <em>optional</em>, defaults to 900) &#x2014;
Number of object queries, i.e. detection slots. This is the maximal number of objects
<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoModel">GroundingDinoModel</a> can detect in a single image.`,name:"num_queries"},{anchor:"transformers.GroundingDinoConfig.encoder_layers",description:`<strong>encoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of encoder layers.`,name:"encoder_layers"},{anchor:"transformers.GroundingDinoConfig.encoder_ffn_dim",description:`<strong>encoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"encoder_ffn_dim"},{anchor:"transformers.GroundingDinoConfig.encoder_attention_heads",description:`<strong>encoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"encoder_attention_heads"},{anchor:"transformers.GroundingDinoConfig.decoder_layers",description:`<strong>decoder_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 6) &#x2014;
Number of decoder layers.`,name:"decoder_layers"},{anchor:"transformers.GroundingDinoConfig.decoder_ffn_dim",description:`<strong>decoder_ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in decoder.`,name:"decoder_ffn_dim"},{anchor:"transformers.GroundingDinoConfig.decoder_attention_heads",description:`<strong>decoder_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"decoder_attention_heads"},{anchor:"transformers.GroundingDinoConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model is used as an encoder/decoder or not.`,name:"is_encoder_decoder"},{anchor:"transformers.GroundingDinoConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.GroundingDinoConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Dimension of the layers.`,name:"d_model"},{anchor:"transformers.GroundingDinoConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"dropout"},{anchor:"transformers.GroundingDinoConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.GroundingDinoConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.GroundingDinoConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.GroundingDinoConfig.position_embedding_type",description:`<strong>position_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;sine&quot;</code>) &#x2014;
Type of position embeddings to be used on top of the image features. One of <code>&quot;sine&quot;</code> or <code>&quot;learned&quot;</code>.`,name:"position_embedding_type"},{anchor:"transformers.GroundingDinoConfig.num_feature_levels",description:`<strong>num_feature_levels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of input feature levels.`,name:"num_feature_levels"},{anchor:"transformers.GroundingDinoConfig.encoder_n_points",description:`<strong>encoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the encoder.`,name:"encoder_n_points"},{anchor:"transformers.GroundingDinoConfig.decoder_n_points",description:`<strong>decoder_n_points</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of sampled keys in each feature level for each attention head in the decoder.`,name:"decoder_n_points"},{anchor:"transformers.GroundingDinoConfig.two_stage",description:`<strong>two_stage</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to apply a two-stage deformable DETR, where the region proposals are also generated by a variant of
Grounding DINO, which are further fed into the decoder for iterative bounding box refinement.`,name:"two_stage"},{anchor:"transformers.GroundingDinoConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.GroundingDinoConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.GroundingDinoConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.GroundingDinoConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.GroundingDinoConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2.0) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.GroundingDinoConfig.focal_alpha",description:`<strong>focal_alpha</strong> (<code>float</code>, <em>optional</em>, defaults to 0.25) &#x2014;
Alpha parameter in the focal loss.`,name:"focal_alpha"},{anchor:"transformers.GroundingDinoConfig.disable_custom_kernels",description:`<strong>disable_custom_kernels</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Disable the use of custom CUDA and CPU kernels. This option is necessary for the ONNX export, as custom
kernels are not supported by PyTorch ONNX export.`,name:"disable_custom_kernels"},{anchor:"transformers.GroundingDinoConfig.max_text_len",description:`<strong>max_text_len</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The maximum length of the text input.`,name:"max_text_len"},{anchor:"transformers.GroundingDinoConfig.text_enhancer_dropout",description:`<strong>text_enhancer_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the text enhancer.`,name:"text_enhancer_dropout"},{anchor:"transformers.GroundingDinoConfig.fusion_droppath",description:`<strong>fusion_droppath</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The droppath ratio for the fusion module.`,name:"fusion_droppath"},{anchor:"transformers.GroundingDinoConfig.fusion_dropout",description:`<strong>fusion_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the fusion module.`,name:"fusion_dropout"},{anchor:"transformers.GroundingDinoConfig.embedding_init_target",description:`<strong>embedding_init_target</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to initialize the target with Embedding weights.`,name:"embedding_init_target"},{anchor:"transformers.GroundingDinoConfig.query_dim",description:`<strong>query_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The dimension of the query vector.`,name:"query_dim"},{anchor:"transformers.GroundingDinoConfig.decoder_bbox_embed_share",description:`<strong>decoder_bbox_embed_share</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to share the bbox regression head for all decoder layers.`,name:"decoder_bbox_embed_share"},{anchor:"transformers.GroundingDinoConfig.two_stage_bbox_embed_share",description:`<strong>two_stage_bbox_embed_share</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to share the bbox embedding between the two-stage bbox generator and the region proposal
generation.`,name:"two_stage_bbox_embed_share"},{anchor:"transformers.GroundingDinoConfig.positional_embedding_temperature",description:`<strong>positional_embedding_temperature</strong> (<code>float</code>, <em>optional</em>, defaults to 20) &#x2014;
The temperature for Sine Positional Embedding that is used together with vision backbone.`,name:"positional_embedding_temperature"},{anchor:"transformers.GroundingDinoConfig.init_std",description:`<strong>init_std</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"init_std"},{anchor:"transformers.GroundingDinoConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/configuration_grounding_dino.py#L26"}}),A=new ft({props:{anchor:"transformers.GroundingDinoConfig.example",$$slots:{default:[nn]},$$scope:{ctx:z}}}),Ie=new q({props:{title:"GroundingDinoModel",local:"transformers.GroundingDinoModel",headingTag:"h2"}}),ze=new $({props:{name:"class transformers.GroundingDinoModel",anchor:"transformers.GroundingDinoModel",parameters:[{name:"config",val:": GroundingDinoConfig"}],parametersDescription:[{anchor:"transformers.GroundingDinoModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig">GroundingDinoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2002"}}),ke=new $({props:{name:"forward",anchor:"transformers.GroundingDinoModel.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"input_ids",val:": Tensor"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"pixel_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_outputs",val:" = None"},{name:"output_attentions",val:" = None"},{name:"output_hidden_states",val:" = None"},{name:"return_dict",val:" = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">GroundingDinoImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.GroundingDinoModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">BertTokenizer.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.GroundingDinoModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: 0 corresponds to a <code>sentence A</code> token, 1 corresponds to a <code>sentence B</code> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GroundingDinoModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for tokens that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GroundingDinoModel.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.GroundingDinoModel.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state_vision</code>, <em>optional</em>: <code>last_hidden_state_text</code>, <em>optional</em>:
<code>vision_hidden_states</code>, <em>optional</em>: <code>text_hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state_vision</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence
of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the
decoder.`,name:"encoder_outputs"},{anchor:"transformers.GroundingDinoModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GroundingDinoModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GroundingDinoModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2157",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoModelOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig"
>GroundingDinoConfig</a>) and inputs.</p>
<ul>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_last_hidden_state_vision</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_last_hidden_state_text</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_vision_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the vision embeddings + one for the output of each
layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the vision encoder at the
output of each layer plus the initial embedding outputs.</li>
<li><strong>encoder_text_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the text embeddings + one for the output of each layer)
of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the text encoder at the output of
each layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the text-vision attention, vision-text attention, text-enhancer (self-attention) and
multi-scale deformable attention heads. attention softmax, used to compute the weighted average in the
bi-attention heads.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.num_queries</code> scoring bounding boxes are picked as
region proposals in the first stage. Output of bounding box binary classification (i.e. foreground and
background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
<li><strong>encoder_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of top <code>config.num_queries</code> scoring bounding boxes in the first stage.</li>
<li><strong>encoder_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Coordinates of top <code>config.num_queries</code> scoring bounding boxes in the first stage.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoModelOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new Qt({props:{$$slots:{default:[sn]},$$scope:{ctx:z}}}),H=new ft({props:{anchor:"transformers.GroundingDinoModel.forward.example",$$slots:{default:[rn]},$$scope:{ctx:z}}}),Ue=new q({props:{title:"GroundingDinoForObjectDetection",local:"transformers.GroundingDinoForObjectDetection",headingTag:"h2"}}),$e=new $({props:{name:"class transformers.GroundingDinoForObjectDetection",anchor:"transformers.GroundingDinoForObjectDetection",parameters:[{name:"config",val:": GroundingDinoConfig"}],parametersDescription:[{anchor:"transformers.GroundingDinoForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig">GroundingDinoConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2506"}}),Fe=new $({props:{name:"forward",anchor:"transformers.GroundingDinoForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"input_ids",val:": LongTensor"},{name:"token_type_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Union[transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoEncoderOutput, typing.Tuple, NoneType] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[typing.List[typing.Dict[str, typing.Union[torch.LongTensor, torch.FloatTensor]]]] = None"}],parametersDescription:[{anchor:"transformers.GroundingDinoForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Padding will be ignored by default should you provide it.</p>
<p>Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">GroundingDinoImageProcessor.<strong>call</strong>()</a> for
details.`,name:"pixel_values"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">BertTokenizer.<strong>call</strong>()</a> for details.`,name:"input_ids"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>: 0 corresponds to a <code>sentence A</code> token, 1 corresponds to a <code>sentence B</code> token</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, text_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for tokens that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.pixel_mask",description:`<strong>pixel_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, height, width)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding pixel values. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for pixels that are real (i.e. <strong>not masked</strong>),</li>
<li>0 for pixels that are padding (i.e. <strong>masked</strong>).</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"pixel_mask"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state_vision</code>, <em>optional</em>: <code>last_hidden_state_text</code>, <em>optional</em>:
<code>vision_hidden_states</code>, <em>optional</em>: <code>text_hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state_vision</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence
of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the
decoder.`,name:"encoder_outputs"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.GroundingDinoForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: &#x2018;class_labels&#x2019; and &#x2018;boxes&#x2019; (the class labels and bounding boxes of an image in the batch
respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/grounding_dino/modeling_grounding_dino.py#L2544",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoConfig"
>GroundingDinoConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <a
  href="/docs/transformers/main/en/model_doc/grounding-dino#transformers.GroundingDinoProcessor.post_process_grounded_object_detection"
>post_process_grounded_object_detection()</a> to retrieve the
unnormalized bounding boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>List[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, num_queries, hidden_size)</code>. Hidden-states of the decoder at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>decoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the self-attention, cross-attention and multi-scale deformable attention heads.</li>
<li><strong>encoder_last_hidden_state_vision</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_last_hidden_state_text</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</li>
<li><strong>encoder_vision_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the vision embeddings + one for the output of each
layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the vision encoder at the
output of each layer plus the initial embedding outputs.</li>
<li><strong>encoder_text_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the text embeddings + one for the output of each layer)
of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the text encoder at the output of
each layer plus the initial embedding outputs.</li>
<li><strong>encoder_attentions</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of tuples of <code>torch.FloatTensor</code> (one for attention for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the
weighted average in the text-vision attention, vision-text attention, text-enhancer (self-attention) and
multi-scale deformable attention heads.</li>
<li><strong>intermediate_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, hidden_size)</code>) — Stacked intermediate hidden states (output of each layer of the decoder).</li>
<li><strong>intermediate_reference_points</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.decoder_layers, num_queries, 4)</code>) — Stacked intermediate reference points (reference points of each layer of the decoder).</li>
<li><strong>init_reference_points</strong> (<code>torch.FloatTensor</code> of shape  <code>(batch_size, num_queries, 4)</code>) — Initial reference points sent through the Transformer decoder.</li>
<li><strong>enc_outputs_class</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Predicted bounding boxes scores where the top <code>config.num_queries</code> scoring bounding boxes are picked as
region proposals in the first stage. Output of bounding box binary classification (i.e. foreground and
background).</li>
<li><strong>enc_outputs_coord_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of predicted bounding boxes coordinates in the first stage.</li>
<li><strong>encoder_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Logits of top <code>config.num_queries</code> scoring bounding boxes in the first stage.</li>
<li><strong>encoder_pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, 4)</code>, <em>optional</em>, returned when <code>config.two_stage=True</code>) — Coordinates of top <code>config.num_queries</code> scoring bounding boxes in the first stage.</li>
<li><strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) — Encoded candidate labels sequence. Used in processor to post process object detection result.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.grounding_dino.modeling_grounding_dino.GroundingDinoObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),V=new Qt({props:{$$slots:{default:[an]},$$scope:{ctx:z}}}),Q=new ft({props:{anchor:"transformers.GroundingDinoForObjectDetection.forward.example",$$slots:{default:[dn]},$$scope:{ctx:z}}}),Je=new tn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/grounding-dino.md"}}),{c(){c=i("meta"),T=n(),b=i("p"),y=n(),g(v.$$.fragment),l=n(),x=i("div"),x.innerHTML=_t,ro=n(),g(oe.$$.fragment),ao=n(),te=i("p"),te.innerHTML=bt,io=n(),ne=i("p"),ne.textContent=yt,co=n(),se=i("p"),se.innerHTML=vt,lo=n(),Z=i("img"),mo=n(),re=i("small"),re.innerHTML=xt,go=n(),ae=i("p"),ae.innerHTML=Tt,po=n(),g(ie.$$.fragment),ho=n(),de=i("ul"),de.innerHTML=Mt,uo=n(),ce=i("p"),ce.textContent=Dt,fo=n(),g(le.$$.fragment),_o=n(),g(me.$$.fragment),bo=n(),ge=i("p"),ge.innerHTML=jt,yo=n(),E=i("img"),vo=n(),pe=i("small"),pe.innerHTML=Gt,wo=n(),g(he.$$.fragment),xo=n(),ue=i("p"),ue.textContent=It,To=n(),fe=i("ul"),fe.innerHTML=zt,Mo=n(),g(_e.$$.fragment),Do=n(),F=i("div"),g(be.$$.fragment),Eo=n(),Re=i("p"),Re.textContent=kt,Wo=n(),W=i("div"),g(ye.$$.fragment),Lo=n(),Ze=i("p"),Ze.textContent=Ut,jo=n(),g(ve.$$.fragment),Co=n(),C=i("div"),g(we.$$.fragment),Oo=n(),Ee=i("p"),Ee.textContent=$t,So=n(),L=i("div"),g(xe.$$.fragment),Ao=n(),We=i("p"),We.textContent=Ft,Bo=n(),O=i("div"),g(Te.$$.fragment),Ho=n(),Le=i("p"),Le.innerHTML=Jt,Go=n(),g(Me.$$.fragment),Io=n(),G=i("div"),g(De.$$.fragment),Vo=n(),Oe=i("p"),Oe.textContent=qt,Qo=n(),Se=i("p"),Se.innerHTML=Pt,Xo=n(),S=i("div"),g(je.$$.fragment),Yo=n(),Ae=i("p"),Ae.innerHTML=Nt,zo=n(),g(Ce.$$.fragment),ko=n(),I=i("div"),g(Ge.$$.fragment),Ko=n(),Be=i("p"),Be.innerHTML=Rt,et=n(),He=i("p"),He.innerHTML=Zt,ot=n(),g(A.$$.fragment),Uo=n(),g(Ie.$$.fragment),$o=n(),M=i("div"),g(ze.$$.fragment),tt=n(),Ve=i("p"),Ve.textContent=Et,nt=n(),Qe=i("p"),Qe.innerHTML=Wt,st=n(),Xe=i("p"),Xe.innerHTML=Lt,rt=n(),k=i("div"),g(ke.$$.fragment),at=n(),Ye=i("p"),Ye.innerHTML=Ot,it=n(),g(B.$$.fragment),dt=n(),g(H.$$.fragment),Fo=n(),g(Ue.$$.fragment),Jo=n(),D=i("div"),g($e.$$.fragment),ct=n(),Ke=i("p"),Ke.textContent=St,lt=n(),eo=i("p"),eo.innerHTML=At,mt=n(),oo=i("p"),oo.innerHTML=Bt,gt=n(),U=i("div"),g(Fe.$$.fragment),pt=n(),to=i("p"),to.innerHTML=Ht,ht=n(),g(V.$$.fragment),ut=n(),g(Q.$$.fragment),qo=n(),g(Je.$$.fragment),Po=n(),no=i("p"),this.h()},l(e){const o=on("svelte-u9bgzb",document.head);c=d(o,"META",{name:!0,content:!0}),o.forEach(t),T=s(e),b=d(e,"P",{}),j(b).forEach(t),y=s(e),p(v.$$.fragment,e),l=s(e),x=d(e,"DIV",{class:!0,"data-svelte-h":!0}),m(x)!=="svelte-13t8s2t"&&(x.innerHTML=_t),ro=s(e),p(oe.$$.fragment,e),ao=s(e),te=d(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-1usvly6"&&(te.innerHTML=bt),io=s(e),ne=d(e,"P",{"data-svelte-h":!0}),m(ne)!=="svelte-vfdo9a"&&(ne.textContent=yt),co=s(e),se=d(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-14ayby0"&&(se.innerHTML=vt),lo=s(e),Z=d(e,"IMG",{src:!0,alt:!0,width:!0}),mo=s(e),re=d(e,"SMALL",{"data-svelte-h":!0}),m(re)!=="svelte-1o9330u"&&(re.innerHTML=xt),go=s(e),ae=d(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1p2elqj"&&(ae.innerHTML=Tt),po=s(e),p(ie.$$.fragment,e),ho=s(e),de=d(e,"UL",{"data-svelte-h":!0}),m(de)!=="svelte-1omd7fu"&&(de.innerHTML=Mt),uo=s(e),ce=d(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-ffyfwo"&&(ce.textContent=Dt),fo=s(e),p(le.$$.fragment,e),_o=s(e),p(me.$$.fragment,e),bo=s(e),ge=d(e,"P",{"data-svelte-h":!0}),m(ge)!=="svelte-1ewje5n"&&(ge.innerHTML=jt),yo=s(e),E=d(e,"IMG",{src:!0,alt:!0,width:!0}),vo=s(e),pe=d(e,"SMALL",{"data-svelte-h":!0}),m(pe)!=="svelte-16zie7b"&&(pe.innerHTML=Gt),wo=s(e),p(he.$$.fragment,e),xo=s(e),ue=d(e,"P",{"data-svelte-h":!0}),m(ue)!=="svelte-h29b2y"&&(ue.textContent=It),To=s(e),fe=d(e,"UL",{"data-svelte-h":!0}),m(fe)!=="svelte-1afawla"&&(fe.innerHTML=zt),Mo=s(e),p(_e.$$.fragment,e),Do=s(e),F=d(e,"DIV",{class:!0});var R=j(F);p(be.$$.fragment,R),Eo=s(R),Re=d(R,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-1k24st3"&&(Re.textContent=kt),Wo=s(R),W=d(R,"DIV",{class:!0});var qe=j(W);p(ye.$$.fragment,qe),Lo=s(qe),Ze=d(qe,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-jgz2ra"&&(Ze.textContent=Ut),qe.forEach(t),R.forEach(t),jo=s(e),p(ve.$$.fragment,e),Co=s(e),C=d(e,"DIV",{class:!0});var J=j(C);p(we.$$.fragment,J),Oo=s(J),Ee=d(J,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-bq7f7v"&&(Ee.textContent=$t),So=s(J),L=d(J,"DIV",{class:!0});var Pe=j(L);p(xe.$$.fragment,Pe),Ao=s(Pe),We=d(Pe,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1x3yxsa"&&(We.textContent=Ft),Pe.forEach(t),Bo=s(J),O=d(J,"DIV",{class:!0});var Ne=j(O);p(Te.$$.fragment,Ne),Ho=s(Ne),Le=d(Ne,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-ca0muk"&&(Le.innerHTML=Jt),Ne.forEach(t),J.forEach(t),Go=s(e),p(Me.$$.fragment,e),Io=s(e),G=d(e,"DIV",{class:!0});var X=j(G);p(De.$$.fragment,X),Vo=s(X),Oe=d(X,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-6v5vrh"&&(Oe.textContent=qt),Qo=s(X),Se=d(X,"P",{"data-svelte-h":!0}),m(Se)!=="svelte-1svcr55"&&(Se.innerHTML=Pt),Xo=s(X),S=d(X,"DIV",{class:!0});var Ro=j(S);p(je.$$.fragment,Ro),Yo=s(Ro),Ae=d(Ro,"P",{"data-svelte-h":!0}),m(Ae)!=="svelte-kxzevl"&&(Ae.innerHTML=Nt),Ro.forEach(t),X.forEach(t),zo=s(e),p(Ce.$$.fragment,e),ko=s(e),I=d(e,"DIV",{class:!0});var Y=j(I);p(Ge.$$.fragment,Y),Ko=s(Y),Be=d(Y,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-14zgym3"&&(Be.innerHTML=Rt),et=s(Y),He=d(Y,"P",{"data-svelte-h":!0}),m(He)!=="svelte-o55m63"&&(He.innerHTML=Zt),ot=s(Y),p(A.$$.fragment,Y),Y.forEach(t),Uo=s(e),p(Ie.$$.fragment,e),$o=s(e),M=d(e,"DIV",{class:!0});var P=j(M);p(ze.$$.fragment,P),tt=s(P),Ve=d(P,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-7hyzcp"&&(Ve.textContent=Et),nt=s(P),Qe=d(P,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-6pahdo"&&(Qe.innerHTML=Wt),st=s(P),Xe=d(P,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-hswkmf"&&(Xe.innerHTML=Lt),rt=s(P),k=d(P,"DIV",{class:!0});var K=j(k);p(ke.$$.fragment,K),at=s(K),Ye=d(K,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-1rg4rqf"&&(Ye.innerHTML=Ot),it=s(K),p(B.$$.fragment,K),dt=s(K),p(H.$$.fragment,K),K.forEach(t),P.forEach(t),Fo=s(e),p(Ue.$$.fragment,e),Jo=s(e),D=d(e,"DIV",{class:!0});var N=j(D);p($e.$$.fragment,N),ct=s(N),Ke=d(N,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-hgz8xq"&&(Ke.textContent=St),lt=s(N),eo=d(N,"P",{"data-svelte-h":!0}),m(eo)!=="svelte-6pahdo"&&(eo.innerHTML=At),mt=s(N),oo=d(N,"P",{"data-svelte-h":!0}),m(oo)!=="svelte-hswkmf"&&(oo.innerHTML=Bt),gt=s(N),U=d(N,"DIV",{class:!0});var ee=j(U);p(Fe.$$.fragment,ee),pt=s(ee),to=d(ee,"P",{"data-svelte-h":!0}),m(to)!=="svelte-z24s13"&&(to.innerHTML=Ht),ht=s(ee),p(V.$$.fragment,ee),ut=s(ee),p(Q.$$.fragment,ee),ee.forEach(t),N.forEach(t),qo=s(e),p(Je.$$.fragment,e),Po=s(e),no=d(e,"P",{}),j(no).forEach(t),this.h()},h(){w(c,"name","hf:doc:metadata"),w(c,"content",ln),w(x,"class","flex flex-wrap space-x-1"),Vt(Z.src,wt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/grouding_dino_architecture.png")||w(Z,"src",wt),w(Z,"alt","drawing"),w(Z,"width","600"),Vt(E.src,Ct="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/grounded_sam.png")||w(E,"src",Ct),w(E,"alt","drawing"),w(E,"width","900"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){a(document.head,c),r(e,T,o),r(e,b,o),r(e,y,o),h(v,e,o),r(e,l,o),r(e,x,o),r(e,ro,o),h(oe,e,o),r(e,ao,o),r(e,te,o),r(e,io,o),r(e,ne,o),r(e,co,o),r(e,se,o),r(e,lo,o),r(e,Z,o),r(e,mo,o),r(e,re,o),r(e,go,o),r(e,ae,o),r(e,po,o),h(ie,e,o),r(e,ho,o),r(e,de,o),r(e,uo,o),r(e,ce,o),r(e,fo,o),h(le,e,o),r(e,_o,o),h(me,e,o),r(e,bo,o),r(e,ge,o),r(e,yo,o),r(e,E,o),r(e,vo,o),r(e,pe,o),r(e,wo,o),h(he,e,o),r(e,xo,o),r(e,ue,o),r(e,To,o),r(e,fe,o),r(e,Mo,o),h(_e,e,o),r(e,Do,o),r(e,F,o),h(be,F,null),a(F,Eo),a(F,Re),a(F,Wo),a(F,W),h(ye,W,null),a(W,Lo),a(W,Ze),r(e,jo,o),h(ve,e,o),r(e,Co,o),r(e,C,o),h(we,C,null),a(C,Oo),a(C,Ee),a(C,So),a(C,L),h(xe,L,null),a(L,Ao),a(L,We),a(C,Bo),a(C,O),h(Te,O,null),a(O,Ho),a(O,Le),r(e,Go,o),h(Me,e,o),r(e,Io,o),r(e,G,o),h(De,G,null),a(G,Vo),a(G,Oe),a(G,Qo),a(G,Se),a(G,Xo),a(G,S),h(je,S,null),a(S,Yo),a(S,Ae),r(e,zo,o),h(Ce,e,o),r(e,ko,o),r(e,I,o),h(Ge,I,null),a(I,Ko),a(I,Be),a(I,et),a(I,He),a(I,ot),h(A,I,null),r(e,Uo,o),h(Ie,e,o),r(e,$o,o),r(e,M,o),h(ze,M,null),a(M,tt),a(M,Ve),a(M,nt),a(M,Qe),a(M,st),a(M,Xe),a(M,rt),a(M,k),h(ke,k,null),a(k,at),a(k,Ye),a(k,it),h(B,k,null),a(k,dt),h(H,k,null),r(e,Fo,o),h(Ue,e,o),r(e,Jo,o),r(e,D,o),h($e,D,null),a(D,ct),a(D,Ke),a(D,lt),a(D,eo),a(D,mt),a(D,oo),a(D,gt),a(D,U),h(Fe,U,null),a(U,pt),a(U,to),a(U,ht),h(V,U,null),a(U,ut),h(Q,U,null),r(e,qo,o),h(Je,e,o),r(e,Po,o),r(e,no,o),No=!0},p(e,[o]){const R={};o&2&&(R.$$scope={dirty:o,ctx:e}),A.$set(R);const qe={};o&2&&(qe.$$scope={dirty:o,ctx:e}),B.$set(qe);const J={};o&2&&(J.$$scope={dirty:o,ctx:e}),H.$set(J);const Pe={};o&2&&(Pe.$$scope={dirty:o,ctx:e}),V.$set(Pe);const Ne={};o&2&&(Ne.$$scope={dirty:o,ctx:e}),Q.$set(Ne)},i(e){No||(u(v.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(le.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(_e.$$.fragment,e),u(be.$$.fragment,e),u(ye.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(xe.$$.fragment,e),u(Te.$$.fragment,e),u(Me.$$.fragment,e),u(De.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Ge.$$.fragment,e),u(A.$$.fragment,e),u(Ie.$$.fragment,e),u(ze.$$.fragment,e),u(ke.$$.fragment,e),u(B.$$.fragment,e),u(H.$$.fragment,e),u(Ue.$$.fragment,e),u($e.$$.fragment,e),u(Fe.$$.fragment,e),u(V.$$.fragment,e),u(Q.$$.fragment,e),u(Je.$$.fragment,e),No=!0)},o(e){f(v.$$.fragment,e),f(oe.$$.fragment,e),f(ie.$$.fragment,e),f(le.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(_e.$$.fragment,e),f(be.$$.fragment,e),f(ye.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(xe.$$.fragment,e),f(Te.$$.fragment,e),f(Me.$$.fragment,e),f(De.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(Ge.$$.fragment,e),f(A.$$.fragment,e),f(Ie.$$.fragment,e),f(ze.$$.fragment,e),f(ke.$$.fragment,e),f(B.$$.fragment,e),f(H.$$.fragment,e),f(Ue.$$.fragment,e),f($e.$$.fragment,e),f(Fe.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),f(Je.$$.fragment,e),No=!1},d(e){e&&(t(T),t(b),t(y),t(l),t(x),t(ro),t(ao),t(te),t(io),t(ne),t(co),t(se),t(lo),t(Z),t(mo),t(re),t(go),t(ae),t(po),t(ho),t(de),t(uo),t(ce),t(fo),t(_o),t(bo),t(ge),t(yo),t(E),t(vo),t(pe),t(wo),t(xo),t(ue),t(To),t(fe),t(Mo),t(Do),t(F),t(jo),t(Co),t(C),t(Go),t(Io),t(G),t(zo),t(ko),t(I),t(Uo),t($o),t(M),t(Fo),t(Jo),t(D),t(qo),t(Po),t(no)),t(c),_(v,e),_(oe,e),_(ie,e),_(le,e),_(me,e),_(he,e),_(_e,e),_(be),_(ye),_(ve,e),_(we),_(xe),_(Te),_(Me,e),_(De),_(je),_(Ce,e),_(Ge),_(A),_(Ie,e),_(ze),_(ke),_(B),_(H),_(Ue,e),_($e),_(Fe),_(V),_(Q),_(Je,e)}}}const ln='{"title":"Grounding DINO","local":"grounding-dino","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Grounded SAM","local":"grounded-sam","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"GroundingDinoImageProcessor","local":"transformers.GroundingDinoImageProcessor","sections":[],"depth":2},{"title":"GroundingDinoImageProcessorFast","local":"transformers.GroundingDinoImageProcessorFast","sections":[],"depth":2},{"title":"GroundingDinoProcessor","local":"transformers.GroundingDinoProcessor","sections":[],"depth":2},{"title":"GroundingDinoConfig","local":"transformers.GroundingDinoConfig","sections":[],"depth":2},{"title":"GroundingDinoModel","local":"transformers.GroundingDinoModel","sections":[],"depth":2},{"title":"GroundingDinoForObjectDetection","local":"transformers.GroundingDinoForObjectDetection","sections":[],"depth":2}],"depth":1}';function mn(z){return Yt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class vn extends Kt{constructor(c){super(),en(this,c,mn,cn,Xt,{})}}export{vn as component};
