import{s as _n,z as Tn,o as vn,n as $t}from"../chunks/scheduler.18a86fab.js";import{S as yn,i as bn,g as r,s as n,r as m,A as Mn,h as i,f as o,c as s,j as x,u as p,x as c,k as w,y as d,a,v as h,d as g,t as f,w as u}from"../chunks/index.98837b22.js";import{T as Yo}from"../chunks/Tip.77304350.js";import{D as L}from"../chunks/Docstring.6758ea23.js";import{C as q}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as un}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as I}from"../chunks/Heading.7e7e0c5b.js";import{E as wn}from"../chunks/index.499f366c.js";function Jn(N){let l,y="<li>Llava-Next uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){l=r("ul"),l.innerHTML=y},l(T){l=i(T,"UL",{"data-svelte-h":!0}),c(l)!=="svelte-17g7vjy"&&(l.innerHTML=y)},m(T,v){a(T,l,v)},p:$t,d(T){T&&o(l)}}}function xn(N){let l,y='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',T,v,b='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){l=r("p"),l.innerHTML=y,T=n(),v=r("p"),v.innerHTML=b},l(_){l=i(_,"P",{"data-svelte-h":!0}),c(l)!=="svelte-nz63kd"&&(l.innerHTML=y),T=s(_),v=i(_,"P",{"data-svelte-h":!0}),c(v)!=="svelte-aze40l"&&(v.innerHTML=b)},m(_,M){a(_,l,M),a(_,T,M),a(_,v,M)},p:$t,d(_){_&&(o(l),o(T),o(v))}}}function In(N){let l,y="Example:",T,v,b;return v=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMExsYXZhTmV4dENvbmZpZyUyQyUyMENMSVBWaXNpb25Db25maWclMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBDTElQVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhbWElMjBjb25maWclMEF0ZXh0X2NvbmZpZyUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhdmEtTmV4dCUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhTmV4dENvbmZpZyh2aXNpb25fY29uZmlnJTJDJTIwdGV4dF9jb25maWcpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU5leHRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextForConditionalGeneration, LlavaNextConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaNextConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=y,T=n(),m(v.$$.fragment)},l(_){l=i(_,"P",{"data-svelte-h":!0}),c(l)!=="svelte-11lpom8"&&(l.textContent=y),T=s(_),p(v.$$.fragment,_)},m(_,M){a(_,l,M),a(_,T,M),h(v,_,M),b=!0},p:$t,i(_){b||(g(v.$$.fragment,_),b=!0)},o(_){f(v.$$.fragment,_),b=!1},d(_){_&&(o(l),o(T)),u(v,_)}}}function Un(N){let l,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=y},l(T){l=i(T,"P",{"data-svelte-h":!0}),c(l)!=="svelte-fincs2"&&(l.innerHTML=y)},m(T,v){a(T,l,v)},p:$t,d(T){T&&o(l)}}}function Nn(N){let l,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=y},l(T){l=i(T,"P",{"data-svelte-h":!0}),c(l)!=="svelte-fincs2"&&(l.innerHTML=y)},m(T,v){a(T,l,v)},p:$t,d(T){T&&o(l)}}}function Ln(N){let l,y="Example:",T,v,b;return v=new q({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhdmFOZXh0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlNUJJTlNUJTVEJTIwJTNDaW1hZ2UlM0UlNUNuV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1QiUyRklOU1QlNUQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaNextForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;[INST]  \\nWhat is shown in this image? [/INST] The image appears to be a radar chart, which is a type of multi-dimensional plot (...)&quot;</span>`,wrap:!1}}),{c(){l=r("p"),l.textContent=y,T=n(),m(v.$$.fragment)},l(_){l=i(_,"P",{"data-svelte-h":!0}),c(l)!=="svelte-11lpom8"&&(l.textContent=y),T=s(_),p(v.$$.fragment,_)},m(_,M){a(_,l,M),a(_,T,M),h(v,_,M),b=!0},p:$t,i(_){b||(g(v.$$.fragment,_),b=!0)},o(_){f(v.$$.fragment,_),b=!1},d(_){_&&(o(l),o(T)),u(v,_)}}}function Cn(N){let l,y,T,v,b,_,M,xa='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Wt,oe,Zt,ae,Ia='The LLaVA-NeXT model was proposed in <a href="https://llava-vl.github.io/blog/2024-01-30-llava-next/" rel="nofollow">LLaVA-NeXT: Improved reasoning, OCR, and world knowledge</a> by Haotian Liu, Chunyuan Li, Yuheng Li, Bo Li, Yuanhan Zhang, Sheng Shen, Yong Jae Lee. LLaVa-NeXT (also called LLaVa-1.6) improves upon <a href="llava">LLaVa</a> by increasing the input image resolution and training on an improved visual instruction tuning dataset to improve OCR and common sense reasoning.',Bt,ne,Ua="The introduction from the blog is the following:",Ft,se,Na="*In October 2023, we released LLaVA-1.5 with a simple and efficient design along with great performance on a benchmark suite of 12 datasets. It has since served as the foundation of many comprehensive studies of data, model, and capabilities of large multimodal models (LMM), and has enabled various new applications.",Gt,re,La="Today, we are thrilled to present LLaVA-NeXT, with improved reasoning, OCR, and world knowledge. LLaVA-NeXT even exceeds Gemini Pro on several benchmarks.",Rt,ie,Ca="Compared with LLaVA-1.5, LLaVA-NeXT has several improvements:",Vt,le,ja=`Increasing the input image resolution to 4x more pixels. This allows it to grasp more visual details. It supports three aspect ratios, up to 672x672, 336x1344, 1344x336 resolution.
Better visual reasoning and OCR capability with an improved visual instruction tuning data mixture.
Better visual conversation for more scenarios, covering different applications. Better world knowledge and logical reasoning.
Efficient deployment and inference with SGLang.
Along with performance improvements, LLaVA-NeXT maintains the minimalist design and data efficiency of LLaVA-1.5. It re-uses the pretrained connector of LLaVA-1.5, and still uses less than 1M visual instruction tuning samples. The largest 34B variant finishes training in ~1 day with 32 A100s.*`,Pt,V,za,Xt,de,$a='LLaVa-NeXT incorporates a higher input resolution by encoding various patches of the input image. Taken from the <a href="https://arxiv.org/abs/2310.03744">original paper.</a>',Ht,ce,ka=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/haotian-liu/LLaVA/tree/main" rel="nofollow">here</a>.`,St,me,Et,pe,qa="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",Qt,P,Yt,he,Wa="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",At,ge,Dt,fe,Za="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",Ot,ue,Ba="<strong>Important:</strong>",Kt,_e,Fa="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",eo,Te,Ga='Here’s an example of how to structure your input. We will use <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> and a conversation history of text and image.',to,ve,oo,ye,Ra=`<li>If you want to construct a chat prompt yourself, below is a list of possible formats
.
<a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> requires the following format:</li>`,ao,be,no,Me,Va='<a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-7b-hf" rel="nofollow">llava-v1.6-vicuna-7b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-13b-hf" rel="nofollow">llava-v1.6-vicuna-13b-hf</a> require the following format:',so,we,ro,Je,Pa='<a href="https://huggingface.co/llava-hf/llava-v1.6-34b-hf" rel="nofollow">llava-v1.6-34b-hf</a> requires the following format:',io,xe,lo,Ie,Xa='<a href="https://huggingface.co/llava-hf/llava-next-8b-hf" rel="nofollow">llama3-llava-next-8b-hf</a> requires the following format:',co,Ue,mo,Ne,Ha='<a href="https://huggingface.co/llava-hf/llava-next-72b-hf" rel="nofollow">llava-next-72b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-next-110b-hf" rel="nofollow">llava-next-110b-hf</a> require the following format:',po,Le,ho,Ce,Sa="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",go,je,fo,ze,uo,$e,Ea="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",_o,ke,To,qe,vo,We,Qa="LLaVa-Next can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",yo,Ze,bo,Be,Mo,Fe,wo,Ge,Ya="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code>, and to have access to a GPU/accelerator that is supported by the library.",Jo,X,xo,Re,Aa="Simply change the snippet above with:",Io,Ve,Uo,Pe,No,Xe,Da='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',Lo,He,Co,Se,jo,C,Ee,Ao,gt,Oa=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-hf/llava-v1.6-mistral-7b-hf</a>
model.`,Do,ft,Ka=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Oo,H,zo,Qe,$o,W,Ye,Ko,ut,en=`Constructs a LLaVa-NeXT image processor. Based on <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> with incorporation of additional techniques
for processing high resolution images as explained in the <a href="https://arxiv.org/abs/2310.03744" rel="nofollow">LLaVa paper</a>.`,ea,_t,Ae,ko,De,qo,Z,Oe,ta,Tt,tn="Constructs a fast ConvNeXT image processor.",oa,S,Ke,aa,vt,on="Preprocess an image or batch of images.",Wo,et,Zo,U,tt,na,yt,an="Constructs a LLaVa-NeXT processor which wraps a LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",sa,bt,nn=`<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,ra,E,ot,ia,Mt,sn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,la,Q,at,da,wt,rn=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Bo,nt,Fo,J,st,ca,Jt,ln=`The Llava-Next model which consists of a vision backbone and a language model without language modeling head.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ma,xt,dn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,pa,F,rt,ha,It,cn='The <a href="/docs/transformers/main/en/model_doc/llava_next#transformers.LlavaNextModel">LlavaNextModel</a> forward method, overrides the <code>__call__</code> special method.',ga,Y,fa,A,it,ua,Ut,mn="Obtains image last hidden states from the vision tower and apply multimodal projection.",_a,D,lt,Ta,Nt,pn="Reshape, unpad and then pack each image_feature into a single image_features tensor containing all visual vectors.",Go,dt,Ro,j,ct,va,Lt,hn=`The LLAVA-NeXT model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ya,Ct,gn=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ba,$,mt,Ma,jt,fn='The <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',wa,O,Ja,K,Vo,pt,Po,kt,Xo;return b=new I({props:{title:"LLaVA-NeXT",local:"llava-next",headingTag:"h1"}}),oe=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),me=new I({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),P=new Yo({props:{warning:!0,$$slots:{default:[Jn]},$$scope:{ctx:N}}}),ge=new I({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),ve=new q({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIwVGhpcyUyMGltYWdlJTIwc2hvd3MlMjBhJTIwcmVkJTIwc3RvcCUyMHNpZ24uJTIwJTVCSU5TVCU1RCUyMERlc2NyaWJlJTIwdGhlJTIwaW1hZ2UlMjBpbiUyMG1vcmUlMjBkZXRhaWxzLiUyMCU1QiUyRklOU1QlNUQlMjI=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat&#x27;s shown in this image? [/INST] This image shows a red stop sign. [INST] Describe the image in more details. [/INST]&quot;</span>`,wrap:!1}}),be=new q({props:{code:"JTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIy",highlighted:'<span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>',wrap:!1}}),we=new q({props:{code:"JTIyQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjBodW1hbiUyMGFuZCUyMGFuJTIwYXJ0aWZpY2lhbCUyMGludGVsbGlnZW5jZSUyMGFzc2lzdGFudC4lMjBUaGUlMjBhc3Npc3RhbnQlMjBnaXZlcyUyMGhlbHBmdWwlMkMlMjBkZXRhaWxlZCUyQyUyMGFuZCUyMHBvbGl0ZSUyMGFuc3dlcnMlMjB0byUyMHRoZSUyMGh1bWFuJ3MlMjBxdWVzdGlvbnMuJTIwVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjBBU1NJU1RBTlQlM0ElMjI=",highlighted:'<span class="hljs-string">&quot;A chat between a curious human and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the human&#x27;s questions. USER: &lt;image&gt;\\nWhat is shown in this image? ASSISTANT:&quot;</span>',wrap:!1}}),xe=new q({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb25zLiUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nAnswer the questions.&lt;|im_end|&gt;&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),Ue=new q({props:{code:"JTIyJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFc3lzdGVtJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBsYW5ndWFnZSUyMGFuZCUyMHZpc2lvbiUyMGFzc2lzdGFudC4lMjBZb3UlMjBhcmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwdGhlJTIwdmlzdWFsJTIwY29udGVudCUyMHRoYXQlMjB0aGUlMjB1c2VyJTIwcHJvdmlkZXMlMkMlMjBhbmQlMjBhc3Npc3QlMjB0aGUlMjB1c2VyJTIwd2l0aCUyMGElMjB2YXJpZXR5JTIwb2YlMjB0YXNrcyUyMHVzaW5nJTIwbmF0dXJhbCUyMGxhbmd1YWdlLiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are a helpful language and vision assistant. You are able to understand the visual content that the user provides, and assist the user with a variety of tasks using natural language.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>',wrap:!1}}),Le=new q({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),je=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),ze=new I({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),ke=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor, LlavaNextForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
model.to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(image, prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),qe=new I({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),Ze=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-comment"># Load the model in half-precision</span>
model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

prompt_1 = processor.apply_chat_template(conversation_1, add_generation_prompt=<span class="hljs-literal">True</span>)
prompt_2 = processor.apply_chat_template(conversation_2, add_generation_prompt=<span class="hljs-literal">True</span>)
prompts = [prompt_1, prompt_2]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),Be=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),Fe=new I({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),X=new Yo({props:{$$slots:{default:[xn]},$$scope:{ctx:N}}}),Ve=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),Pe=new I({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),He=new q({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGxvd19jcHVfbWVtX3VzYWdlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9mbGFzaF9hdHRlbnRpb25fMiUzRFRydWUlMEEpLnRvKDAp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText

model = AutoModelForImageTextToText.from_pretrained(
    model_id,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Se=new I({props:{title:"LlavaNextConfig",local:"transformers.LlavaNextConfig",headingTag:"h2"}}),Ee=new L({props:{name:"class transformers.LlavaNextConfig",anchor:"transformers.LlavaNextConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32000"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"image_seq_length",val:" = 576"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaNextConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaNextConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaNextConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaNextConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[[336, 672], [672, 336], [672, 672], [1008, 336], [336, 1008]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaNextConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.LlavaNextConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/configuration_llava_next.py#L24"}}),H=new un({props:{anchor:"transformers.LlavaNextConfig.example",$$slots:{default:[In]},$$scope:{ctx:N}}}),Qe=new I({props:{title:"LlavaNextImageProcessor",local:"transformers.LlavaNextImageProcessor",headingTag:"h2"}}),Ye=new L({props:{name:"class transformers.LlavaNextImageProcessor",anchor:"transformers.LlavaNextImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next.py#L107"}}),Ae=new L({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next.py#L546"}}),De=new I({props:{title:"LlavaNextImageProcessorFast",local:"transformers.LlavaNextImageProcessorFast",headingTag:"h2"}}),Oe=new L({props:{name:"class transformers.LlavaNextImageProcessorFast",anchor:"transformers.LlavaNextImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next.image_processing_llava_next_fast.LlavaNextFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaNextImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.LlavaNextImageProcessorFast.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next_fast.py#L64"}}),Ke=new L({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next.image_processing_llava_next_fast.LlavaNextFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
image_grid_pinpoints (<code>List</code>, <em>optional</em>):
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.
do_pad (<code>bool</code>, <em>optional</em>):
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next_fast.py#L98"}}),et=new I({props:{title:"LlavaNextProcessor",local:"transformers.LlavaNextProcessor",headingTag:"h2"}}),tt=new L({props:{name:"class transformers.LlavaNextProcessor",anchor:"transformers.LlavaNextProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"num_additional_image_tokens",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaNextProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaNextProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaNextProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Should be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaNextProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaNextProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L43"}}),ot=new L({props:{name:"batch_decode",anchor:"transformers.LlavaNextProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L223"}}),at=new L({props:{name:"decode",anchor:"transformers.LlavaNextProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L231"}}),nt=new I({props:{title:"LlavaNextModel",local:"transformers.LlavaNextModel",headingTag:"h2"}}),st=new L({props:{name:"class transformers.LlavaNextModel",anchor:"transformers.LlavaNextModel",parameters:[{name:"config",val:": LlavaNextConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L376"}}),rt=new L({props:{name:"forward",anchor:"transformers.LlavaNextModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextModel.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaNextModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextModel.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextModel.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L531"}}),Y=new Yo({props:{$$slots:{default:[Un]},$$scope:{ctx:N}}}),it=new L({props:{name:"get_image_features",anchor:"transformers.LlavaNextModel.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"image_sizes",val:": Tensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"}],parametersDescription:[{anchor:"transformers.LlavaNextModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_patches, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextModel.get_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaNextModel.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextModel.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L470",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of image feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_patches, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (List<code>torch.Tensor</code>)</p>
`}}),lt=new L({props:{name:"pack_image_features",anchor:"transformers.LlavaNextModel.pack_image_features",parameters:[{name:"image_features",val:""},{name:"image_sizes",val:""},{name:"vision_feature_select_strategy",val:""},{name:"image_newline",val:" = None"}],parametersDescription:[{anchor:"transformers.LlavaNextModel.pack_image_features.image_features",description:`<strong>image_features</strong> (<code>List[torch.Tensor]</code> of length num_images, each of shape <code>(num_patches, image_length, embed_dim)</code>) &#x2014;
List of image feature tensor, each contains all the visual feature of all patches.`,name:"image_features"},{anchor:"transformers.LlavaNextModel.pack_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaNextModel.pack_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextModel.pack_image_features.image_newline",description:`<strong>image_newline</strong> (<code>torch.Tensor</code> of shape <code>(embed_dim)</code>) &#x2014;
New line embedding vector.`,name:"image_newline"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L402",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code> of shape <code>(all_feat_len, embed_dim)</code>)
feature_lens (<code>List[int]</code>)
token length of each image in image_features</p>
`}}),dt=new I({props:{title:"LlavaNextForConditionalGeneration",local:"transformers.LlavaNextForConditionalGeneration",headingTag:"h2"}}),ct=new L({props:{name:"class transformers.LlavaNextForConditionalGeneration",anchor:"transformers.LlavaNextForConditionalGeneration",parameters:[{name:"config",val:": LlavaNextConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L625"}}),mt=new L({props:{name:"forward",anchor:"transformers.LlavaNextForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L670",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextConfig"
>LlavaNextConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new Yo({props:{$$slots:{default:[Nn]},$$scope:{ctx:N}}}),K=new un({props:{anchor:"transformers.LlavaNextForConditionalGeneration.forward.example",$$slots:{default:[Ln]},$$scope:{ctx:N}}}),pt=new wn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_next.md"}}),{c(){l=r("meta"),y=n(),T=r("p"),v=n(),m(b.$$.fragment),_=n(),M=r("div"),M.innerHTML=xa,Wt=n(),m(oe.$$.fragment),Zt=n(),ae=r("p"),ae.innerHTML=Ia,Bt=n(),ne=r("p"),ne.textContent=Ua,Ft=n(),se=r("p"),se.textContent=Na,Gt=n(),re=r("p"),re.textContent=La,Rt=n(),ie=r("p"),ie.textContent=Ca,Vt=n(),le=r("p"),le.textContent=ja,Pt=n(),V=r("img"),Xt=n(),de=r("small"),de.innerHTML=$a,Ht=n(),ce=r("p"),ce.innerHTML=ka,St=n(),m(me.$$.fragment),Et=n(),pe=r("ul"),pe.innerHTML=qa,Qt=n(),m(P.$$.fragment),Yt=n(),he=r("blockquote"),he.innerHTML=Wa,At=n(),m(ge.$$.fragment),Dt=n(),fe=r("p"),fe.innerHTML=Za,Ot=n(),ue=r("p"),ue.innerHTML=Ba,Kt=n(),_e=r("ul"),_e.innerHTML=Fa,eo=n(),Te=r("p"),Te.innerHTML=Ga,to=n(),m(ve.$$.fragment),oo=n(),ye=r("ul"),ye.innerHTML=Ra,ao=n(),m(be.$$.fragment),no=n(),Me=r("p"),Me.innerHTML=Va,so=n(),m(we.$$.fragment),ro=n(),Je=r("p"),Je.innerHTML=Pa,io=n(),m(xe.$$.fragment),lo=n(),Ie=r("p"),Ie.innerHTML=Xa,co=n(),m(Ue.$$.fragment),mo=n(),Ne=r("p"),Ne.innerHTML=Ha,po=n(),m(Le.$$.fragment),ho=n(),Ce=r("p"),Ce.innerHTML=Sa,go=n(),m(je.$$.fragment),fo=n(),m(ze.$$.fragment),uo=n(),$e=r("p"),$e.innerHTML=Ea,_o=n(),m(ke.$$.fragment),To=n(),m(qe.$$.fragment),vo=n(),We=r("p"),We.textContent=Qa,yo=n(),m(Ze.$$.fragment),bo=n(),m(Be.$$.fragment),Mo=n(),m(Fe.$$.fragment),wo=n(),Ge=r("p"),Ge.innerHTML=Ya,Jo=n(),m(X.$$.fragment),xo=n(),Re=r("p"),Re.textContent=Aa,Io=n(),m(Ve.$$.fragment),Uo=n(),m(Pe.$$.fragment),No=n(),Xe=r("p"),Xe.innerHTML=Da,Lo=n(),m(He.$$.fragment),Co=n(),m(Se.$$.fragment),jo=n(),C=r("div"),m(Ee.$$.fragment),Ao=n(),gt=r("p"),gt.innerHTML=Oa,Do=n(),ft=r("p"),ft.innerHTML=Ka,Oo=n(),m(H.$$.fragment),zo=n(),m(Qe.$$.fragment),$o=n(),W=r("div"),m(Ye.$$.fragment),Ko=n(),ut=r("p"),ut.innerHTML=en,ea=n(),_t=r("div"),m(Ae.$$.fragment),ko=n(),m(De.$$.fragment),qo=n(),Z=r("div"),m(Oe.$$.fragment),ta=n(),Tt=r("p"),Tt.textContent=tn,oa=n(),S=r("div"),m(Ke.$$.fragment),aa=n(),vt=r("p"),vt.textContent=on,Wo=n(),m(et.$$.fragment),Zo=n(),U=r("div"),m(tt.$$.fragment),na=n(),yt=r("p"),yt.textContent=an,sa=n(),bt=r("p"),bt.innerHTML=nn,ra=n(),E=r("div"),m(ot.$$.fragment),ia=n(),Mt=r("p"),Mt.innerHTML=sn,la=n(),Q=r("div"),m(at.$$.fragment),da=n(),wt=r("p"),wt.innerHTML=rn,Bo=n(),m(nt.$$.fragment),Fo=n(),J=r("div"),m(st.$$.fragment),ca=n(),Jt=r("p"),Jt.innerHTML=ln,ma=n(),xt=r("p"),xt.innerHTML=dn,pa=n(),F=r("div"),m(rt.$$.fragment),ha=n(),It=r("p"),It.innerHTML=cn,ga=n(),m(Y.$$.fragment),fa=n(),A=r("div"),m(it.$$.fragment),ua=n(),Ut=r("p"),Ut.textContent=mn,_a=n(),D=r("div"),m(lt.$$.fragment),Ta=n(),Nt=r("p"),Nt.textContent=pn,Go=n(),m(dt.$$.fragment),Ro=n(),j=r("div"),m(ct.$$.fragment),va=n(),Lt=r("p"),Lt.innerHTML=hn,ya=n(),Ct=r("p"),Ct.innerHTML=gn,ba=n(),$=r("div"),m(mt.$$.fragment),Ma=n(),jt=r("p"),jt.innerHTML=fn,wa=n(),m(O.$$.fragment),Ja=n(),m(K.$$.fragment),Vo=n(),m(pt.$$.fragment),Po=n(),kt=r("p"),this.h()},l(e){const t=Mn("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),y=s(e),T=i(e,"P",{}),x(T).forEach(o),v=s(e),p(b.$$.fragment,e),_=s(e),M=i(e,"DIV",{class:!0,"data-svelte-h":!0}),c(M)!=="svelte-b95w5j"&&(M.innerHTML=xa),Wt=s(e),p(oe.$$.fragment,e),Zt=s(e),ae=i(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-5h5la5"&&(ae.innerHTML=Ia),Bt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1fhv1nu"&&(ne.textContent=Ua),Ft=s(e),se=i(e,"P",{"data-svelte-h":!0}),c(se)!=="svelte-1o8aykc"&&(se.textContent=Na),Gt=s(e),re=i(e,"P",{"data-svelte-h":!0}),c(re)!=="svelte-106g2gs"&&(re.textContent=La),Rt=s(e),ie=i(e,"P",{"data-svelte-h":!0}),c(ie)!=="svelte-o65l2n"&&(ie.textContent=Ca),Vt=s(e),le=i(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-qaxeu7"&&(le.textContent=ja),Pt=s(e),V=i(e,"IMG",{src:!0,alt:!0,width:!0}),Xt=s(e),de=i(e,"SMALL",{"data-svelte-h":!0}),c(de)!=="svelte-1ueeg46"&&(de.innerHTML=$a),Ht=s(e),ce=i(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-10gvx7f"&&(ce.innerHTML=ka),St=s(e),p(me.$$.fragment,e),Et=s(e),pe=i(e,"UL",{"data-svelte-h":!0}),c(pe)!=="svelte-b32abk"&&(pe.innerHTML=qa),Qt=s(e),p(P.$$.fragment,e),Yt=s(e),he=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),c(he)!=="svelte-nygwxc"&&(he.innerHTML=Wa),At=s(e),p(ge.$$.fragment,e),Dt=s(e),fe=i(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-pavm2p"&&(fe.innerHTML=Za),Ot=s(e),ue=i(e,"P",{"data-svelte-h":!0}),c(ue)!=="svelte-1uqcr0x"&&(ue.innerHTML=Ba),Kt=s(e),_e=i(e,"UL",{"data-svelte-h":!0}),c(_e)!=="svelte-imbcrg"&&(_e.innerHTML=Fa),eo=s(e),Te=i(e,"P",{"data-svelte-h":!0}),c(Te)!=="svelte-1aakomu"&&(Te.innerHTML=Ga),to=s(e),p(ve.$$.fragment,e),oo=s(e),ye=i(e,"UL",{"data-svelte-h":!0}),c(ye)!=="svelte-uiv36d"&&(ye.innerHTML=Ra),ao=s(e),p(be.$$.fragment,e),no=s(e),Me=i(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-7fncpd"&&(Me.innerHTML=Va),so=s(e),p(we.$$.fragment,e),ro=s(e),Je=i(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-5xtfcu"&&(Je.innerHTML=Pa),io=s(e),p(xe.$$.fragment,e),lo=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-ia69dt"&&(Ie.innerHTML=Xa),co=s(e),p(Ue.$$.fragment,e),mo=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-cihbm7"&&(Ne.innerHTML=Ha),po=s(e),p(Le.$$.fragment,e),ho=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-hqx9qk"&&(Ce.innerHTML=Sa),go=s(e),p(je.$$.fragment,e),fo=s(e),p(ze.$$.fragment,e),uo=s(e),$e=i(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-19yw9ck"&&($e.innerHTML=Ea),_o=s(e),p(ke.$$.fragment,e),To=s(e),p(qe.$$.fragment,e),vo=s(e),We=i(e,"P",{"data-svelte-h":!0}),c(We)!=="svelte-1py9or5"&&(We.textContent=Qa),yo=s(e),p(Ze.$$.fragment,e),bo=s(e),p(Be.$$.fragment,e),Mo=s(e),p(Fe.$$.fragment,e),wo=s(e),Ge=i(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-bd1tou"&&(Ge.innerHTML=Ya),Jo=s(e),p(X.$$.fragment,e),xo=s(e),Re=i(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-gwf9h7"&&(Re.textContent=Aa),Io=s(e),p(Ve.$$.fragment,e),Uo=s(e),p(Pe.$$.fragment,e),No=s(e),Xe=i(e,"P",{"data-svelte-h":!0}),c(Xe)!=="svelte-ujer0t"&&(Xe.innerHTML=Da),Lo=s(e),p(He.$$.fragment,e),Co=s(e),p(Se.$$.fragment,e),jo=s(e),C=i(e,"DIV",{class:!0});var B=x(C);p(Ee.$$.fragment,B),Ao=s(B),gt=i(B,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-br1cgj"&&(gt.innerHTML=Oa),Do=s(B),ft=i(B,"P",{"data-svelte-h":!0}),c(ft)!=="svelte-o55m63"&&(ft.innerHTML=Ka),Oo=s(B),p(H.$$.fragment,B),B.forEach(o),zo=s(e),p(Qe.$$.fragment,e),$o=s(e),W=i(e,"DIV",{class:!0});var G=x(W);p(Ye.$$.fragment,G),Ko=s(G),ut=i(G,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1wlr4kn"&&(ut.innerHTML=en),ea=s(G),_t=i(G,"DIV",{class:!0});var qt=x(_t);p(Ae.$$.fragment,qt),qt.forEach(o),G.forEach(o),ko=s(e),p(De.$$.fragment,e),qo=s(e),Z=i(e,"DIV",{class:!0});var R=x(Z);p(Oe.$$.fragment,R),ta=s(R),Tt=i(R,"P",{"data-svelte-h":!0}),c(Tt)!=="svelte-1bn0s7p"&&(Tt.textContent=tn),oa=s(R),S=i(R,"DIV",{class:!0});var ht=x(S);p(Ke.$$.fragment,ht),aa=s(ht),vt=i(ht,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-1x3yxsa"&&(vt.textContent=on),ht.forEach(o),R.forEach(o),Wo=s(e),p(et.$$.fragment,e),Zo=s(e),U=i(e,"DIV",{class:!0});var z=x(U);p(tt.$$.fragment,z),na=s(z),yt=i(z,"P",{"data-svelte-h":!0}),c(yt)!=="svelte-qcp8uy"&&(yt.textContent=an),sa=s(z),bt=i(z,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-1rxwguc"&&(bt.innerHTML=nn),ra=s(z),E=i(z,"DIV",{class:!0});var Ho=x(E);p(ot.$$.fragment,Ho),ia=s(Ho),Mt=i(Ho,"P",{"data-svelte-h":!0}),c(Mt)!=="svelte-1o9eza"&&(Mt.innerHTML=sn),Ho.forEach(o),la=s(z),Q=i(z,"DIV",{class:!0});var So=x(Q);p(at.$$.fragment,So),da=s(So),wt=i(So,"P",{"data-svelte-h":!0}),c(wt)!=="svelte-kk16qw"&&(wt.innerHTML=rn),So.forEach(o),z.forEach(o),Bo=s(e),p(nt.$$.fragment,e),Fo=s(e),J=i(e,"DIV",{class:!0});var k=x(J);p(st.$$.fragment,k),ca=s(k),Jt=i(k,"P",{"data-svelte-h":!0}),c(Jt)!=="svelte-1c63ajw"&&(Jt.innerHTML=ln),ma=s(k),xt=i(k,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-hswkmf"&&(xt.innerHTML=dn),pa=s(k),F=i(k,"DIV",{class:!0});var zt=x(F);p(rt.$$.fragment,zt),ha=s(zt),It=i(zt,"P",{"data-svelte-h":!0}),c(It)!=="svelte-rv9aqx"&&(It.innerHTML=cn),ga=s(zt),p(Y.$$.fragment,zt),zt.forEach(o),fa=s(k),A=i(k,"DIV",{class:!0});var Eo=x(A);p(it.$$.fragment,Eo),ua=s(Eo),Ut=i(Eo,"P",{"data-svelte-h":!0}),c(Ut)!=="svelte-1vzo9k5"&&(Ut.textContent=mn),Eo.forEach(o),_a=s(k),D=i(k,"DIV",{class:!0});var Qo=x(D);p(lt.$$.fragment,Qo),Ta=s(Qo),Nt=i(Qo,"P",{"data-svelte-h":!0}),c(Nt)!=="svelte-1rwyyz6"&&(Nt.textContent=pn),Qo.forEach(o),k.forEach(o),Go=s(e),p(dt.$$.fragment,e),Ro=s(e),j=i(e,"DIV",{class:!0});var ee=x(j);p(ct.$$.fragment,ee),va=s(ee),Lt=i(ee,"P",{"data-svelte-h":!0}),c(Lt)!=="svelte-1mgcqn3"&&(Lt.innerHTML=hn),ya=s(ee),Ct=i(ee,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-hswkmf"&&(Ct.innerHTML=gn),ba=s(ee),$=i(ee,"DIV",{class:!0});var te=x($);p(mt.$$.fragment,te),Ma=s(te),jt=i(te,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-1m02emh"&&(jt.innerHTML=fn),wa=s(te),p(O.$$.fragment,te),Ja=s(te),p(K.$$.fragment,te),te.forEach(o),ee.forEach(o),Vo=s(e),p(pt.$$.fragment,e),Po=s(e),kt=i(e,"P",{}),x(kt).forEach(o),this.h()},h(){w(l,"name","hf:doc:metadata"),w(l,"content",jn),w(M,"class","flex flex-wrap space-x-1"),Tn(V.src,za="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava_next_overview.png")||w(V,"src",za),w(V,"alt","drawing"),w(V,"width","600"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(_t,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){d(document.head,l),a(e,y,t),a(e,T,t),a(e,v,t),h(b,e,t),a(e,_,t),a(e,M,t),a(e,Wt,t),h(oe,e,t),a(e,Zt,t),a(e,ae,t),a(e,Bt,t),a(e,ne,t),a(e,Ft,t),a(e,se,t),a(e,Gt,t),a(e,re,t),a(e,Rt,t),a(e,ie,t),a(e,Vt,t),a(e,le,t),a(e,Pt,t),a(e,V,t),a(e,Xt,t),a(e,de,t),a(e,Ht,t),a(e,ce,t),a(e,St,t),h(me,e,t),a(e,Et,t),a(e,pe,t),a(e,Qt,t),h(P,e,t),a(e,Yt,t),a(e,he,t),a(e,At,t),h(ge,e,t),a(e,Dt,t),a(e,fe,t),a(e,Ot,t),a(e,ue,t),a(e,Kt,t),a(e,_e,t),a(e,eo,t),a(e,Te,t),a(e,to,t),h(ve,e,t),a(e,oo,t),a(e,ye,t),a(e,ao,t),h(be,e,t),a(e,no,t),a(e,Me,t),a(e,so,t),h(we,e,t),a(e,ro,t),a(e,Je,t),a(e,io,t),h(xe,e,t),a(e,lo,t),a(e,Ie,t),a(e,co,t),h(Ue,e,t),a(e,mo,t),a(e,Ne,t),a(e,po,t),h(Le,e,t),a(e,ho,t),a(e,Ce,t),a(e,go,t),h(je,e,t),a(e,fo,t),h(ze,e,t),a(e,uo,t),a(e,$e,t),a(e,_o,t),h(ke,e,t),a(e,To,t),h(qe,e,t),a(e,vo,t),a(e,We,t),a(e,yo,t),h(Ze,e,t),a(e,bo,t),h(Be,e,t),a(e,Mo,t),h(Fe,e,t),a(e,wo,t),a(e,Ge,t),a(e,Jo,t),h(X,e,t),a(e,xo,t),a(e,Re,t),a(e,Io,t),h(Ve,e,t),a(e,Uo,t),h(Pe,e,t),a(e,No,t),a(e,Xe,t),a(e,Lo,t),h(He,e,t),a(e,Co,t),h(Se,e,t),a(e,jo,t),a(e,C,t),h(Ee,C,null),d(C,Ao),d(C,gt),d(C,Do),d(C,ft),d(C,Oo),h(H,C,null),a(e,zo,t),h(Qe,e,t),a(e,$o,t),a(e,W,t),h(Ye,W,null),d(W,Ko),d(W,ut),d(W,ea),d(W,_t),h(Ae,_t,null),a(e,ko,t),h(De,e,t),a(e,qo,t),a(e,Z,t),h(Oe,Z,null),d(Z,ta),d(Z,Tt),d(Z,oa),d(Z,S),h(Ke,S,null),d(S,aa),d(S,vt),a(e,Wo,t),h(et,e,t),a(e,Zo,t),a(e,U,t),h(tt,U,null),d(U,na),d(U,yt),d(U,sa),d(U,bt),d(U,ra),d(U,E),h(ot,E,null),d(E,ia),d(E,Mt),d(U,la),d(U,Q),h(at,Q,null),d(Q,da),d(Q,wt),a(e,Bo,t),h(nt,e,t),a(e,Fo,t),a(e,J,t),h(st,J,null),d(J,ca),d(J,Jt),d(J,ma),d(J,xt),d(J,pa),d(J,F),h(rt,F,null),d(F,ha),d(F,It),d(F,ga),h(Y,F,null),d(J,fa),d(J,A),h(it,A,null),d(A,ua),d(A,Ut),d(J,_a),d(J,D),h(lt,D,null),d(D,Ta),d(D,Nt),a(e,Go,t),h(dt,e,t),a(e,Ro,t),a(e,j,t),h(ct,j,null),d(j,va),d(j,Lt),d(j,ya),d(j,Ct),d(j,ba),d(j,$),h(mt,$,null),d($,Ma),d($,jt),d($,wa),h(O,$,null),d($,Ja),h(K,$,null),a(e,Vo,t),h(pt,e,t),a(e,Po,t),a(e,kt,t),Xo=!0},p(e,[t]){const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),P.$set(B);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),X.$set(G);const qt={};t&2&&(qt.$$scope={dirty:t,ctx:e}),H.$set(qt);const R={};t&2&&(R.$$scope={dirty:t,ctx:e}),Y.$set(R);const ht={};t&2&&(ht.$$scope={dirty:t,ctx:e}),O.$set(ht);const z={};t&2&&(z.$$scope={dirty:t,ctx:e}),K.$set(z)},i(e){Xo||(g(b.$$.fragment,e),g(oe.$$.fragment,e),g(me.$$.fragment,e),g(P.$$.fragment,e),g(ge.$$.fragment,e),g(ve.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(xe.$$.fragment,e),g(Ue.$$.fragment,e),g(Le.$$.fragment,e),g(je.$$.fragment,e),g(ze.$$.fragment,e),g(ke.$$.fragment,e),g(qe.$$.fragment,e),g(Ze.$$.fragment,e),g(Be.$$.fragment,e),g(Fe.$$.fragment,e),g(X.$$.fragment,e),g(Ve.$$.fragment,e),g(Pe.$$.fragment,e),g(He.$$.fragment,e),g(Se.$$.fragment,e),g(Ee.$$.fragment,e),g(H.$$.fragment,e),g(Qe.$$.fragment,e),g(Ye.$$.fragment,e),g(Ae.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(ot.$$.fragment,e),g(at.$$.fragment,e),g(nt.$$.fragment,e),g(st.$$.fragment,e),g(rt.$$.fragment,e),g(Y.$$.fragment,e),g(it.$$.fragment,e),g(lt.$$.fragment,e),g(dt.$$.fragment,e),g(ct.$$.fragment,e),g(mt.$$.fragment,e),g(O.$$.fragment,e),g(K.$$.fragment,e),g(pt.$$.fragment,e),Xo=!0)},o(e){f(b.$$.fragment,e),f(oe.$$.fragment,e),f(me.$$.fragment,e),f(P.$$.fragment,e),f(ge.$$.fragment,e),f(ve.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),f(xe.$$.fragment,e),f(Ue.$$.fragment,e),f(Le.$$.fragment,e),f(je.$$.fragment,e),f(ze.$$.fragment,e),f(ke.$$.fragment,e),f(qe.$$.fragment,e),f(Ze.$$.fragment,e),f(Be.$$.fragment,e),f(Fe.$$.fragment,e),f(X.$$.fragment,e),f(Ve.$$.fragment,e),f(Pe.$$.fragment,e),f(He.$$.fragment,e),f(Se.$$.fragment,e),f(Ee.$$.fragment,e),f(H.$$.fragment,e),f(Qe.$$.fragment,e),f(Ye.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(at.$$.fragment,e),f(nt.$$.fragment,e),f(st.$$.fragment,e),f(rt.$$.fragment,e),f(Y.$$.fragment,e),f(it.$$.fragment,e),f(lt.$$.fragment,e),f(dt.$$.fragment,e),f(ct.$$.fragment,e),f(mt.$$.fragment,e),f(O.$$.fragment,e),f(K.$$.fragment,e),f(pt.$$.fragment,e),Xo=!1},d(e){e&&(o(y),o(T),o(v),o(_),o(M),o(Wt),o(Zt),o(ae),o(Bt),o(ne),o(Ft),o(se),o(Gt),o(re),o(Rt),o(ie),o(Vt),o(le),o(Pt),o(V),o(Xt),o(de),o(Ht),o(ce),o(St),o(Et),o(pe),o(Qt),o(Yt),o(he),o(At),o(Dt),o(fe),o(Ot),o(ue),o(Kt),o(_e),o(eo),o(Te),o(to),o(oo),o(ye),o(ao),o(no),o(Me),o(so),o(ro),o(Je),o(io),o(lo),o(Ie),o(co),o(mo),o(Ne),o(po),o(ho),o(Ce),o(go),o(fo),o(uo),o($e),o(_o),o(To),o(vo),o(We),o(yo),o(bo),o(Mo),o(wo),o(Ge),o(Jo),o(xo),o(Re),o(Io),o(Uo),o(No),o(Xe),o(Lo),o(Co),o(jo),o(C),o(zo),o($o),o(W),o(ko),o(qo),o(Z),o(Wo),o(Zo),o(U),o(Bo),o(Fo),o(J),o(Go),o(Ro),o(j),o(Vo),o(Po),o(kt)),o(l),u(b,e),u(oe,e),u(me,e),u(P,e),u(ge,e),u(ve,e),u(be,e),u(we,e),u(xe,e),u(Ue,e),u(Le,e),u(je,e),u(ze,e),u(ke,e),u(qe,e),u(Ze,e),u(Be,e),u(Fe,e),u(X,e),u(Ve,e),u(Pe,e),u(He,e),u(Se,e),u(Ee),u(H),u(Qe,e),u(Ye),u(Ae),u(De,e),u(Oe),u(Ke),u(et,e),u(tt),u(ot),u(at),u(nt,e),u(st),u(rt),u(Y),u(it),u(lt),u(dt,e),u(ct),u(mt),u(O),u(K),u(pt,e)}}}const jn='{"title":"LLaVA-NeXT","local":"llava-next","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaNextConfig","local":"transformers.LlavaNextConfig","sections":[],"depth":2},{"title":"LlavaNextImageProcessor","local":"transformers.LlavaNextImageProcessor","sections":[],"depth":2},{"title":"LlavaNextImageProcessorFast","local":"transformers.LlavaNextImageProcessorFast","sections":[],"depth":2},{"title":"LlavaNextProcessor","local":"transformers.LlavaNextProcessor","sections":[],"depth":2},{"title":"LlavaNextModel","local":"transformers.LlavaNextModel","sections":[],"depth":2},{"title":"LlavaNextForConditionalGeneration","local":"transformers.LlavaNextForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function zn(N){return vn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rn extends yn{constructor(l){super(),bn(this,l,zn,Cn,_n,{})}}export{Rn as component};
