import{s as fa,z as ua,o as va,n as Pn}from"../chunks/scheduler.18a86fab.js";import{S as _a,i as ya,g as r,s as a,r as d,A as Ma,h as i,f as n,c as s,j as T,u as c,x as u,k as M,y as l,a as t,v as m,d as p,t as h,w as g}from"../chunks/index.98837b22.js";import{T as ha}from"../chunks/Tip.77304350.js";import{D as U}from"../chunks/Docstring.6758ea23.js";import{C as ee}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as ga}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as I}from"../chunks/Heading.7e7e0c5b.js";import{E as Ta}from"../chunks/index.499f366c.js";function ba(B){let v,j="<li>Llava-OneVision uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){v=r("ul"),v.innerHTML=j},l(y){v=i(y,"UL",{"data-svelte-h":!0}),u(v)!=="svelte-zcrbqx"&&(v.innerHTML=j)},m(y,_){t(y,v,_)},p:Pn,d(y){y&&n(v)}}}function wa(B){let v,j='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',y,_,b='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){v=r("p"),v.innerHTML=j,y=a(),_=r("p"),_.innerHTML=b},l(f){v=i(f,"P",{"data-svelte-h":!0}),u(v)!=="svelte-nz63kd"&&(v.innerHTML=j),y=s(f),_=i(f,"P",{"data-svelte-h":!0}),u(_)!=="svelte-aze40l"&&(_.innerHTML=b)},m(f,w){t(f,v,w),t(f,y,w),t(f,_,w)},p:Pn,d(f){f&&(n(v),n(y),n(_))}}}function Ja(B){let v,j="Example:",y,_,b;return _=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwTGxhdmFPbmV2aXNpb25Db25maWclMkMlMjBTaWdsaXBWaXNpb25Db25maWclMkMlMjBRd2VuMkNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBTaWdsaXBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwUXdlbjJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGF2YS1OZXh0JTIwbGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Db25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBsbGF2YS1oZiUyRmxsYXZhLW9uZXZpc2lvbi1xd2VuMi03Yi1vdi1oZiUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, LlavaOnevisionConfig, SiglipVisionConfig, Qwen2Config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = SiglipVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = Qwen2Config()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaOnevisionConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-onevision-qwen2-7b-ov-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){v=r("p"),v.textContent=j,y=a(),d(_.$$.fragment)},l(f){v=i(f,"P",{"data-svelte-h":!0}),u(v)!=="svelte-11lpom8"&&(v.textContent=j),y=s(f),c(_.$$.fragment,f)},m(f,w){t(f,v,w),t(f,y,w),m(_,f,w),b=!0},p:Pn,i(f){b||(p(_.$$.fragment,f),b=!0)},o(f){h(_.$$.fragment,f),b=!1},d(f){f&&(n(v),n(y)),g(_,f)}}}function Ua(B){let v,j="Example:",y,_,b;return _=new ee({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBMbGF2YU9uZXZpc2lvblByb2Nlc3NvciUyQyUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIybGxhdmEtaGYlMkZsbGF2YS1vbmV2aXNpb24tcXdlbjItN2Itb3YtaGYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRCUyMmZsb2F0MTYlMjIlMkMlMjBkZXZpY2VfbWFwJTNEJTIyY3VkYSUzQTAlMjIpJTBBcHJvY2Vzc29yJTIwJTNEJTIwTGxhdmFPbmV2aXNpb25Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtb25ldmlzaW9uLXF3ZW4yLTdiLW92LWhmJTIyKSUwQSUwQWNvbnZlcnNhdGlvbiUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29udGVudCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTIwJTIydGV4dCUyMiUzQSUyMCUyMldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0IlMjJ0eXBlJTIyJTNBJTIwJTIyaW1hZ2UlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNUQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElNUQlMEFwcm9tcHQlMjAlM0QlMjBwcm9jZXNzb3IuYXBwbHlfY2hhdF90ZW1wbGF0ZShjb252ZXJzYXRpb24lMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlKSUwQSUwQWltYWdlX2ZpbGUlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBcmF3X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1hZ2VfZmlsZSUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IodGV4dCUzRHByb21wdCUyQyUyMGltYWdlcyUzRHJhd19pbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JykudG8oMCUyQyUyMHRvcmNoLmZsb2F0MTYpJTBBJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwJTJDJTIwZG9fc2FtcGxlJTNERmFsc2UpJTBBcHJvY2Vzc29yLmJhdGNoX2RlY29kZShvdXRwdXQlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=<span class="hljs-string">&quot;float16&quot;</span>, device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = LlavaOnevisionProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>conversation = [
<span class="hljs-meta">... </span>    {
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
<span class="hljs-meta">... </span>      <span class="hljs-string">&quot;content&quot;</span>: [
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
<span class="hljs-meta">... </span>          {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
<span class="hljs-meta">... </span>        ],
<span class="hljs-meta">... </span>    },
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_file = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>raw_image = Image.<span class="hljs-built_in">open</span>(requests.get(image_file, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=raw_image, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>).to(<span class="hljs-number">0</span>, torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">20</span>, do_sample=<span class="hljs-literal">False</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(output, skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;user\\n\\nWhat is shown in this image?\\nassistant\\ncat&quot;</span>`,wrap:!1}}),{c(){v=r("p"),v.textContent=j,y=a(),d(_.$$.fragment)},l(f){v=i(f,"P",{"data-svelte-h":!0}),u(v)!=="svelte-11lpom8"&&(v.textContent=j),y=s(f),c(_.$$.fragment,f)},m(f,w){t(f,v,w),t(f,y,w),m(_,f,w),b=!0},p:Pn,i(f){b||(p(_.$$.fragment,f),b=!0)},o(f){h(_.$$.fragment,f),b=!1},d(f){f&&(n(v),n(y)),g(_,f)}}}function Ia(B){let v,j,y,_,b,f,w,Jt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Go,oe,Bo,ne,Ut='The LLaVA-OneVision model was proposed in <a href="https://arxiv.org/abs/2408.03326" rel="nofollow">LLaVA-OneVision: Easy Visual Task Transfer</a> by &lt;Bo Li, Yuanhan Zhang, Dong Guo, Renrui Zhang, Feng Li, Hao Zhang, Kaichen Zhang, Yanwei Li, Ziwei Liu, Chunyuan Li',No,te,It="LLaVA-OneVision is a Vision-Language Model that can generate text conditioned on one or several images/videos. The model consists of SigLIP vision encoder and a Qwen2 language backbone. The images are processed with anyres-9 technique where the image is split into 9 patches to better process high resolution images and capture as much details as possible. However, videos are pooled to a total sequence length of 196 tokens each frame for more memory efficient computation. LLaVA-OneVision is available in three sizes: 0.5B, 7B and 72B and achieves remarkable performance on benchmark evaluations.",Oo,ae,jt="The abstract from the paper is the following:",Wo,se,Ct=`<em>We present LLaVA-OneVision, a family of open large multimodal models (LMMs)
developed by consolidating our insights into data, models, and visual representations in the LLaVA-NeXT blog series. Our experimental results demonstrate that
LLaVA-OneVision is the first single model that can simultaneously push the performance boundaries of open LMMs in three important computer vision scenarios:
single-image, multi-image, and video scenarios. Importantly, the design of LLaVAOneVision allows strong transfer learning across different modalities/scenarios,
yielding new emerging capabilities. In particular, strong video understanding and
cross-scenario capabilities are demonstrated through task transfer from images to
videos.</em>`,Ao,O,Lt,Ro,re,zt='LLaVA-OneVision architecture. Taken from the <a href="https://arxiv.org/abs/2408.03326">original paper.</a>',Fo,ie,xt="Tips:",Po,le,kt="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",Vo,W,Xo,de,Qo,ce,qt="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",Eo,me,Zt="<strong>Important:</strong>",Yo,pe,$t="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",So,he,Gt=`Here’s an example of how to structure your input.
We will use <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-si-hf" rel="nofollow">llava-onevision-qwen2-7b-si-hf</a> and a conversation history of text and image. Each content field has to be a list of dicts, as follows:`,Ho,ge,Do,fe,Bt="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",Ko,ue,Nt=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/LLaVA-VL/LLaVA-NeXT/tree/main" rel="nofollow">here</a>.`,en,ve,on,_e,nn,ye,Ot="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",tn,Me,an,Te,sn,be,Wt="LLaVa-OneVision can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). For that you have to use checkpoints with an “ov” suffix. Here is how you can do it:",rn,we,ln,Je,dn,Ue,At="LLaVa-OneVision also can perform inference with videos as input, where video frames are treated as multiple images. Here is how you can do it:",cn,Ie,mn,je,pn,Ce,hn,Le,Rt="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code> and make sure to have access to a GPU/accelerator that is supported by the library.",gn,A,fn,ze,Ft="Simply change the snippet above with:",un,xe,vn,ke,_n,qe,Pt='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',yn,Ze,Mn,$e,Tn,x,Ge,Vn,mo,Vt=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionForConditionalGeneration">LlavaOnevisionForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-onevision-qwen2-7b-ov-hf" rel="nofollow">llava-hf/llava-onevision-qwen2-7b-ov-hf</a>
model.`,Xn,po,Xt=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qn,R,bn,Be,wn,C,Ne,En,ho,Qt="Constructs a LLaVa-Onevision processor which wraps a LLaVa-Onevision video processor, LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",Yn,go,Et=`<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__"><strong>call</strong>()</a>, <code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,Sn,F,Oe,Hn,fo,Yt=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Dn,P,We,Kn,uo,St=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,Jn,Ae,Un,L,Re,et,vo,Ht='Constructs a LLaVa-Onevision image processor. Based on <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',ot,V,Fe,nt,_o,Dt="Process an image with variable resolutions by dividing it into patches.",tt,X,Pe,at,yo,Kt=`Pads the <code>image</code> with the specified <code>padding</code> and <code>mode</code>. Padding can be in the (<code>height</code>, <code>width</code>)
dimension of in the (<code>num_patches</code>) dimension. In the second case an iterable if tuples is expected
as input.`,st,Mo,Ve,In,Xe,jn,Z,Qe,rt,To,ea='Constructs a fast ConvNeXT image processor. Based on <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',it,Q,Ee,lt,bo,oa="Preprocess an image or batch of images.",Cn,Ye,Ln,$,Se,dt,wo,na='Constructs a LLaVa-Onevisino-Video video processor. Based on <a href="/docs/transformers/main/en/model_doc/siglip#transformers.SiglipImageProcessor">SiglipImageProcessor</a> with incorporation of processing each video frame.',ct,Jo,He,zn,De,xn,J,Ke,mt,Uo,ta=`The Llava-Next model which consists of a vision backbone and a language model without language modeling head.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,pt,Io,aa=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ht,jo,eo,gt,E,oo,ft,Co,sa="Obtains image last hidden states from the vision tower and apply multimodal projection.",ut,Y,no,vt,Lo,ra="Obtains video last hidden states from the vision tower, apply multimodal projection and pooling.",_t,S,to,yt,zo,ia="Reshape, unpad and then pack each image_feature into a single image_features tensor containing all visual vectors.",kn,ao,qn,k,so,Mt,xo,la=`The LLAVA-NeXT model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Tt,ko,da=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,bt,H,ro,wt,D,Zn,io,$n,$o,Gn;return b=new I({props:{title:"LLaVA-OneVision",local:"llava-onevision",headingTag:"h1"}}),oe=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),W=new ha({props:{warning:!0,$$slots:{default:[ba]},$$scope:{ctx:B}}}),de=new I({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),ge=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-si-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-string">&#x27;&lt;|im_start|&gt;user\\n&lt;image&gt;What is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\nPage showing the list of options.&lt;|im_end|&gt;&#x27;</span>`,wrap:!1}}),ve=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),_e=new I({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),Me=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration
<span class="hljs-keyword">import</span> torch

processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>) 
model = LlavaOnevisionForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    device_map=<span class="hljs-string">&quot;cuda:0&quot;</span>
)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: url},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
inputs = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>, tokenize=<span class="hljs-literal">True</span>, return_dict=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = inputs.to(<span class="hljs-string">&quot;cuda:0&quot;</span>, torch.float16)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)
<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))
<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThe image shows a radar chart, also known as a spider chart or a star chart, which is used to compare multiple quantitative variables. Each axis represents a different variable, and the chart is filled with&#x27;</span>`,wrap:!1}}),Te=new I({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),we=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

inputs = processor.apply_chat_template(
    [conversation_1, conversation_2],
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    padding=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, torch.float16)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\nThere is a red stop sign in the image.\\nuser\\n\\nWhat about this image? How many cats do you see?\\nassistant\\ntwo&#x27;</span>, <span class="hljs-string">&#x27;user\\n\\nWhat is shown in this image?\\nassistant\\n&#x27;</span>]`,wrap:!1}}),Je=new I({props:{title:"Video inference",local:"video-inference",headingTag:"h3"}}),Ie=new ee({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaOnevisionForConditionalGeneration

<span class="hljs-comment"># Load the model in half-precision</span>
model = LlavaOnevisionForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-onevision-qwen2-7b-ov-hf&quot;</span>)

video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
conversation = [
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;video&quot;</span>, <span class="hljs-string">&quot;path&quot;</span>: video_path},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Why is this video funny?&quot;</span>},
            ],
    },
]

inputs = processor.apply_chat_template(
    conversation,
    num_frames=<span class="hljs-number">8</span>
    add_generation_prompt=<span class="hljs-literal">True</span>,
    tokenize=<span class="hljs-literal">True</span>,
    return_dict=<span class="hljs-literal">True</span>,
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
).to(model.device, torch.float16)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&quot;user\\n\\nWhy is this video funny?\\nassistant\\nThe video appears to be humorous because it shows a young child, who is wearing glasses and holding a book, seemingly reading with a serious and focused expression. The child&#x27;s glasses are a bit oversized for their face, which adds a comical touch, as it&#x27;s a common trope to see children wearing&quot;</span>]`,wrap:!1}}),je=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),Ce=new I({props:{title:"Quantization using bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),A=new ha({props:{$$slots:{default:[wa]},$$scope:{ctx:B}}}),xe=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBJTIzJTIwc3BlY2lmeSUyMGhvdyUyMHRvJTIwcXVhbnRpemUlMjB0aGUlMjBtb2RlbCUwQXF1YW50aXphdGlvbl9jb25maWclMjAlM0QlMjBCaXRzQW5kQnl0ZXNDb25maWcoJTBBJTIwJTIwJTIwJTIwbG9hZF9pbl80Yml0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X3F1YW50X3R5cGUlM0QlMjJuZjQlMjIlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9jb21wdXRlX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEElMEFtb2RlbCUyMCUzRCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHF1YW50aXphdGlvbl9jb25maWclM0RxdWFudGl6YXRpb25fY29uZmlnJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = LlavaOnevisionForConditionalGeneration.from_pretrained(model_id, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),ke=new I({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),Ze=new ee({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhT25ldmlzaW9uRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU9uZXZpc2lvbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwbW9kZWxfaWQlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjAlMjAlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjB1c2VfZmxhc2hfYXR0ZW50aW9uXzIlM0RUcnVlJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaOnevisionForConditionalGeneration

model = LlavaOnevisionForConditionalGeneration.from_pretrained(
    model_id,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),$e=new I({props:{title:"LlavaOnevisionConfig",local:"transformers.LlavaOnevisionConfig",headingTag:"h2"}}),Ge=new U({props:{name:"class transformers.LlavaOnevisionConfig",anchor:"transformers.LlavaOnevisionConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 151646"},{name:"video_token_index",val:" = 151647"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'full'"},{name:"vision_feature_layer",val:" = -1"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>SiglipVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaOnevisionConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>Qwen2Config</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaOnevisionConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151646) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaOnevisionConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 151647) &#x2014;
The video token index to encode the video prompt.`,name:"video_token_index"},{anchor:"transformers.LlavaOnevisionConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;full&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -1) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionConfig.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"},{anchor:"transformers.LlavaOnevisionConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaOnevisionConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/configuration_llava_onevision.py#L27"}}),R=new ga({props:{anchor:"transformers.LlavaOnevisionConfig.example",$$slots:{default:[Ja]},$$scope:{ctx:B}}}),Be=new I({props:{title:"LlavaOnevisionProcessor",local:"transformers.LlavaOnevisionProcessor",headingTag:"h2"}}),Ne=new U({props:{name:"class transformers.LlavaOnevisionProcessor",anchor:"transformers.LlavaOnevisionProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"video_processor",val:" = None"},{name:"num_image_tokens",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaOnevisionProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaOnevisionProcessor.video_processor",description:`<strong>video_processor</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionVideoProcessor">LlavaOnevisionVideoProcessor</a>, <em>optional</em>) &#x2014;
The video processor is a required input.`,name:"video_processor"},{anchor:"transformers.LlavaOnevisionProcessor.num_image_tokens",description:`<strong>num_image_tokens</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of image tokens for one imagethat will be returned by vision tower.`,name:"num_image_tokens"},{anchor:"transformers.LlavaOnevisionProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Should be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaOnevisionProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaOnevisionProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.LlavaOnevisionProcessor.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;anyres_max_9&quot;</code>) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L48"}}),Oe=new U({props:{name:"batch_decode",anchor:"transformers.LlavaOnevisionProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L281"}}),We=new U({props:{name:"decode",anchor:"transformers.LlavaOnevisionProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/processing_llava_onevision.py#L289"}}),Ae=new I({props:{title:"LlavaOnevisionImageProcessor",local:"transformers.LlavaOnevisionImageProcessor",headingTag:"h2"}}),Re=new U({props:{name:"class transformers.LlavaOnevisionImageProcessor",anchor:"transformers.LlavaOnevisionImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processing videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L107"}}),Fe=new U({props:{name:"get_image_patches",anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches",parameters:[{name:"image",val:": <built-in function array>"},{name:"grid_pinpoints",val:""},{name:"size",val:": tuple"},{name:"patch_size",val:": int"},{name:"resample",val:": Resampling"},{name:"data_format",val:": ChannelDimension"},{name:"input_data_format",val:": ChannelDimension"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.image",description:`<strong>image</strong> (np.array) &#x2014;
The input image to be processed.`,name:"image"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.grid_pinpoints",description:`<strong>grid_pinpoints</strong> (List) &#x2014;
A string representation of a list of possible resolutions.`,name:"grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.size",description:`<strong>size</strong> (<code>tuple</code>) &#x2014;
Size to resize the original image to.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.patch_size",description:`<strong>patch_size</strong> (<code>int</code>) &#x2014;
Size of the patches to divide the image into.`,name:"patch_size"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>) &#x2014;
The channel dimension format for the output image.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.get_image_patches.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>) &#x2014;
The channel dimension format of the input image.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L336",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of NumPy arrays containing the processed image patches.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List[np.array]</p>
`}}),Pe=new U({props:{name:"pad",anchor:"transformers.LlavaOnevisionImageProcessor.pad",parameters:[{name:"image",val:": ndarray"},{name:"padding",val:": typing.Union[int, typing.Tuple[int, int], typing.Iterable[typing.Tuple[int, int]]]"},{name:"mode",val:": PaddingMode = <PaddingMode.CONSTANT: 'constant'>"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0.0"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
The image to pad.`,name:"image"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.padding",description:`<strong>padding</strong> (<code>int</code> or <code>Tuple[int, int]</code> or <code>Iterable[Tuple[int, int]]</code>) &#x2014;
Padding to apply to the edges of the height, width axes. Can be one of three formats:<ul>
<li><code>((before_height, after_height), (before_width, after_width))</code> unique pad widths for each axis.</li>
<li><code>((before, after),)</code> yields same before and after pad for height and width.</li>
<li><code>(pad,)</code> or int is a shortcut for before = after = pad width for all axes.</li>
</ul>`,name:"padding"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.mode",description:`<strong>mode</strong> (<code>PaddingMode</code>) &#x2014;
The padding mode to use. Can be one of:<ul>
<li><code>&quot;constant&quot;</code>: pads with a constant value.</li>
<li><code>&quot;reflect&quot;</code>: pads with the reflection of the vector mirrored on the first and last values of the
vector along each axis.</li>
<li><code>&quot;replicate&quot;</code>: pads with the replication of the last value on the edge of the array along each axis.</li>
<li><code>&quot;symmetric&quot;</code>: pads with the reflection of the vector mirrored along the edge of the array.</li>
</ul>`,name:"mode"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use same as the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.
If unset, will use the inferred format of the input image.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The padded image.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>np.ndarray</code></p>
`}}),Ve=new U({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"image_grid_pinpoints",val:": typing.Optional[typing.List] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of images to be prepared. Each image can be a PIL image, NumPy array or PyTorch
tensor. Both channels-first and channels-last formats are supported.`,name:"images"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision.py#L515"}}),Xe=new I({props:{title:"LlavaOnevisionImageProcessorFast",local:"transformers.LlavaOnevisionImageProcessorFast",headingTag:"h2"}}),Qe=new U({props:{name:"class transformers.LlavaOnevisionImageProcessorFast",anchor:"transformers.LlavaOnevisionImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.image_processing_llava_onevision_fast.LlavaOnevisionFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method. Not used for processing videos.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision_fast.py#L61"}}),Ee=new U({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_onevision.image_processing_llava_onevision_fast.LlavaOnevisionFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaOnevisionImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
image_grid_pinpoints (<code>List</code>, <em>optional</em>):
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.
do_pad (<code>bool</code>, <em>optional</em>):
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/image_processing_llava_onevision_fast.py#L94"}}),Ye=new I({props:{title:"LlavaOnevisionVideoProcessor",local:"transformers.LlavaOnevisionVideoProcessor",headingTag:"h2"}}),Se=new U({props:{name:"class transformers.LlavaOnevisionVideoProcessor",anchor:"transformers.LlavaOnevisionVideoProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionVideoProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaOnevisionVideoProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionVideoProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionVideoProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionVideoProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L48"}}),He=new U({props:{name:"preprocess",anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess",parameters:[{name:"videos",val:": typing.Union[list['PIL.Image.Image'], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), list['np.ndarray'], list['torch.Tensor'], list[list['PIL.Image.Image']], list[list['np.ndarray']], list[list['torch.Tensor']]]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>np.ndarray</code>, <code>torch.Tensor</code>, <code>List[np.ndarray]</code>, <code>List[torch.Tensor]</code>) &#x2014;
The image or batch of videos to be prepared. Each video can be a 4D NumPy array or PyTorch`,name:"videos"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaOnevisionVideoProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/video_processing_llava_onevision.py#L202"}}),De=new I({props:{title:"LlavaOnevisionModel",local:"transformers.LlavaOnevisionModel",headingTag:"h2"}}),Ke=new U({props:{name:"class transformers.LlavaOnevisionModel",anchor:"transformers.LlavaOnevisionModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionConfig">LlavaOnevisionConfig</a> or <code>LlavaOnevisionVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L421"}}),eo=new U({props:{name:"forward",anchor:"transformers.LlavaOnevisionModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes_videos",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"vision_aspect_ratio",val:": typing.Optional[str] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaOnevisionModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">LlavaOnevisionImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionModel.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaOnevisionModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaOnevisionModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaOnevisionModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaOnevisionModel.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionModel.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaOnevisionModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaOnevisionModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaOnevisionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaOnevisionModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L573"}}),oo=new U({props:{name:"get_image_features",anchor:"transformers.LlavaOnevisionModel.get_image_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"image_sizes",val:": Tensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.get_image_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_patches, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionModel.get_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionModel.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionModel.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L513",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of image feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_patches, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (List<code>torch.Tensor</code>)</p>
`}}),no=new U({props:{name:"get_video_features",anchor:"transformers.LlavaOnevisionModel.get_video_features",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.get_video_features.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_frames, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input video.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionModel.get_video_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionModel.get_video_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L698",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of video feature tensor, each contains all the visual feature of all patches
and are of shape <code>(num_videos, video_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>video_features (List<code>torch.Tensor</code>)</p>
`}}),to=new U({props:{name:"pack_image_features",anchor:"transformers.LlavaOnevisionModel.pack_image_features",parameters:[{name:"image_features",val:""},{name:"image_sizes",val:""},{name:"image_newline",val:" = None"},{name:"vision_aspect_ratio",val:" = 'anyres_max_9'"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionModel.pack_image_features.image_features",description:`<strong>image_features</strong> (<code>List[torch.Tensor]</code> of length num_images, each of shape <code>(num_patches, image_length, embed_dim)</code>) &#x2014;
List of image feature tensor, each contains all the visual feature of all patches.`,name:"image_features"},{anchor:"transformers.LlavaOnevisionModel.pack_image_features.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.Tensor</code> of shape <code>(num_images, 2)</code>) &#x2014;
Actual image size of each images (H, W).`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionModel.pack_image_features.image_newline",description:`<strong>image_newline</strong> (<code>torch.Tensor</code> of shape <code>(embed_dim)</code>) &#x2014;
New line embedding vector.`,name:"image_newline"},{anchor:"transformers.LlavaOnevisionModel.pack_image_features.vision_aspect_ratio",description:`<strong>vision_aspect_ratio</strong> (<code>str</code>, <em>optional</em>, &#x201C;anyres_max_9&#x201D;) &#x2014;
Aspect ratio used when processong image features. The default value is &#x201C;anyres_max_9&#x201D;.`,name:"vision_aspect_ratio"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L447",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code> of shape <code>(all_feat_len, embed_dim)</code>)
feature_lens (<code>List[int]</code>)
token length of each image in image_features</p>
`}}),ao=new I({props:{title:"LlavaOnevisionForConditionalGeneration",local:"transformers.LlavaOnevisionForConditionalGeneration",headingTag:"h2"}}),so=new U({props:{name:"class transformers.LlavaOnevisionForConditionalGeneration",anchor:"transformers.LlavaOnevisionForConditionalGeneration",parameters:[{name:"config",val:": LlavaOnevisionConfig"}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionConfig">LlavaOnevisionConfig</a> or <code>LlavaOnevisionVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L759"}}),ro=new U({props:{name:"forward",anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values",val:": FloatTensor = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"image_sizes_videos",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"vision_aspect_ratio",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">LlavaOnevisionImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/llava_onevision#transformers.LlavaOnevisionImageProcessor">LlavaOnevisionImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.</p>
<p>labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.</p>
<p>logits_to_keep (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>):
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_onevision/modeling_llava_onevision.py#L804",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~LlavaOnevisionCausalLMOutputWithPast</code> (if <code>return_dict=True</code>) or a <code>tuple</code>.</p>
`}}),D=new ga({props:{anchor:"transformers.LlavaOnevisionForConditionalGeneration.forward.example",$$slots:{default:[Ua]},$$scope:{ctx:B}}}),io=new Ta({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_onevision.md"}}),{c(){v=r("meta"),j=a(),y=r("p"),_=a(),d(b.$$.fragment),f=a(),w=r("div"),w.innerHTML=Jt,Go=a(),d(oe.$$.fragment),Bo=a(),ne=r("p"),ne.innerHTML=Ut,No=a(),te=r("p"),te.textContent=It,Oo=a(),ae=r("p"),ae.textContent=jt,Wo=a(),se=r("p"),se.innerHTML=Ct,Ao=a(),O=r("img"),Ro=a(),re=r("small"),re.innerHTML=zt,Fo=a(),ie=r("p"),ie.textContent=xt,Po=a(),le=r("ul"),le.innerHTML=kt,Vo=a(),d(W.$$.fragment),Xo=a(),d(de.$$.fragment),Qo=a(),ce=r("p"),ce.innerHTML=qt,Eo=a(),me=r("p"),me.innerHTML=Zt,Yo=a(),pe=r("ul"),pe.innerHTML=$t,So=a(),he=r("p"),he.innerHTML=Gt,Ho=a(),d(ge.$$.fragment),Do=a(),fe=r("p"),fe.innerHTML=Bt,Ko=a(),ue=r("p"),ue.innerHTML=Nt,en=a(),d(ve.$$.fragment),on=a(),d(_e.$$.fragment),nn=a(),ye=r("p"),ye.innerHTML=Ot,tn=a(),d(Me.$$.fragment),an=a(),d(Te.$$.fragment),sn=a(),be=r("p"),be.textContent=Wt,rn=a(),d(we.$$.fragment),ln=a(),d(Je.$$.fragment),dn=a(),Ue=r("p"),Ue.textContent=At,cn=a(),d(Ie.$$.fragment),mn=a(),d(je.$$.fragment),pn=a(),d(Ce.$$.fragment),hn=a(),Le=r("p"),Le.innerHTML=Rt,gn=a(),d(A.$$.fragment),fn=a(),ze=r("p"),ze.textContent=Ft,un=a(),d(xe.$$.fragment),vn=a(),d(ke.$$.fragment),_n=a(),qe=r("p"),qe.innerHTML=Pt,yn=a(),d(Ze.$$.fragment),Mn=a(),d($e.$$.fragment),Tn=a(),x=r("div"),d(Ge.$$.fragment),Vn=a(),mo=r("p"),mo.innerHTML=Vt,Xn=a(),po=r("p"),po.innerHTML=Xt,Qn=a(),d(R.$$.fragment),bn=a(),d(Be.$$.fragment),wn=a(),C=r("div"),d(Ne.$$.fragment),En=a(),ho=r("p"),ho.textContent=Qt,Yn=a(),go=r("p"),go.innerHTML=Et,Sn=a(),F=r("div"),d(Oe.$$.fragment),Hn=a(),fo=r("p"),fo.innerHTML=Yt,Dn=a(),P=r("div"),d(We.$$.fragment),Kn=a(),uo=r("p"),uo.innerHTML=St,Jn=a(),d(Ae.$$.fragment),Un=a(),L=r("div"),d(Re.$$.fragment),et=a(),vo=r("p"),vo.innerHTML=Ht,ot=a(),V=r("div"),d(Fe.$$.fragment),nt=a(),_o=r("p"),_o.textContent=Dt,tt=a(),X=r("div"),d(Pe.$$.fragment),at=a(),yo=r("p"),yo.innerHTML=Kt,st=a(),Mo=r("div"),d(Ve.$$.fragment),In=a(),d(Xe.$$.fragment),jn=a(),Z=r("div"),d(Qe.$$.fragment),rt=a(),To=r("p"),To.innerHTML=ea,it=a(),Q=r("div"),d(Ee.$$.fragment),lt=a(),bo=r("p"),bo.textContent=oa,Cn=a(),d(Ye.$$.fragment),Ln=a(),$=r("div"),d(Se.$$.fragment),dt=a(),wo=r("p"),wo.innerHTML=na,ct=a(),Jo=r("div"),d(He.$$.fragment),zn=a(),d(De.$$.fragment),xn=a(),J=r("div"),d(Ke.$$.fragment),mt=a(),Uo=r("p"),Uo.innerHTML=ta,pt=a(),Io=r("p"),Io.innerHTML=aa,ht=a(),jo=r("div"),d(eo.$$.fragment),gt=a(),E=r("div"),d(oo.$$.fragment),ft=a(),Co=r("p"),Co.textContent=sa,ut=a(),Y=r("div"),d(no.$$.fragment),vt=a(),Lo=r("p"),Lo.textContent=ra,_t=a(),S=r("div"),d(to.$$.fragment),yt=a(),zo=r("p"),zo.textContent=ia,kn=a(),d(ao.$$.fragment),qn=a(),k=r("div"),d(so.$$.fragment),Mt=a(),xo=r("p"),xo.innerHTML=la,Tt=a(),ko=r("p"),ko.innerHTML=da,bt=a(),H=r("div"),d(ro.$$.fragment),wt=a(),d(D.$$.fragment),Zn=a(),d(io.$$.fragment),$n=a(),$o=r("p"),this.h()},l(e){const o=Ma("svelte-u9bgzb",document.head);v=i(o,"META",{name:!0,content:!0}),o.forEach(n),j=s(e),y=i(e,"P",{}),T(y).forEach(n),_=s(e),c(b.$$.fragment,e),f=s(e),w=i(e,"DIV",{class:!0,"data-svelte-h":!0}),u(w)!=="svelte-b95w5j"&&(w.innerHTML=Jt),Go=s(e),c(oe.$$.fragment,e),Bo=s(e),ne=i(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-41eoyp"&&(ne.innerHTML=Ut),No=s(e),te=i(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-zyuhly"&&(te.textContent=It),Oo=s(e),ae=i(e,"P",{"data-svelte-h":!0}),u(ae)!=="svelte-vfdo9a"&&(ae.textContent=jt),Wo=s(e),se=i(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-e9kp7g"&&(se.innerHTML=Ct),Ao=s(e),O=i(e,"IMG",{src:!0,alt:!0,width:!0}),Ro=s(e),re=i(e,"SMALL",{"data-svelte-h":!0}),u(re)!=="svelte-m653qt"&&(re.innerHTML=zt),Fo=s(e),ie=i(e,"P",{"data-svelte-h":!0}),u(ie)!=="svelte-axv494"&&(ie.textContent=xt),Po=s(e),le=i(e,"UL",{"data-svelte-h":!0}),u(le)!=="svelte-b32abk"&&(le.innerHTML=kt),Vo=s(e),c(W.$$.fragment,e),Xo=s(e),c(de.$$.fragment,e),Qo=s(e),ce=i(e,"P",{"data-svelte-h":!0}),u(ce)!=="svelte-pavm2p"&&(ce.innerHTML=qt),Eo=s(e),me=i(e,"P",{"data-svelte-h":!0}),u(me)!=="svelte-1uqcr0x"&&(me.innerHTML=Zt),Yo=s(e),pe=i(e,"UL",{"data-svelte-h":!0}),u(pe)!=="svelte-imbcrg"&&(pe.innerHTML=$t),So=s(e),he=i(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-1aenua7"&&(he.innerHTML=Gt),Ho=s(e),c(ge.$$.fragment,e),Do=s(e),fe=i(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-hqx9qk"&&(fe.innerHTML=Bt),Ko=s(e),ue=i(e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-18dym15"&&(ue.innerHTML=Nt),en=s(e),c(ve.$$.fragment,e),on=s(e),c(_e.$$.fragment,e),nn=s(e),ye=i(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-19yw9ck"&&(ye.innerHTML=Ot),tn=s(e),c(Me.$$.fragment,e),an=s(e),c(Te.$$.fragment,e),sn=s(e),be=i(e,"P",{"data-svelte-h":!0}),u(be)!=="svelte-1f25s48"&&(be.textContent=Wt),rn=s(e),c(we.$$.fragment,e),ln=s(e),c(Je.$$.fragment,e),dn=s(e),Ue=i(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1delota"&&(Ue.textContent=At),cn=s(e),c(Ie.$$.fragment,e),mn=s(e),c(je.$$.fragment,e),pn=s(e),c(Ce.$$.fragment,e),hn=s(e),Le=i(e,"P",{"data-svelte-h":!0}),u(Le)!=="svelte-tychdj"&&(Le.innerHTML=Rt),gn=s(e),c(A.$$.fragment,e),fn=s(e),ze=i(e,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-gwf9h7"&&(ze.textContent=Ft),un=s(e),c(xe.$$.fragment,e),vn=s(e),c(ke.$$.fragment,e),_n=s(e),qe=i(e,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-ujer0t"&&(qe.innerHTML=Pt),yn=s(e),c(Ze.$$.fragment,e),Mn=s(e),c($e.$$.fragment,e),Tn=s(e),x=i(e,"DIV",{class:!0});var G=T(x);c(Ge.$$.fragment,G),Vn=s(G),mo=i(G,"P",{"data-svelte-h":!0}),u(mo)!=="svelte-1ksh786"&&(mo.innerHTML=Vt),Xn=s(G),po=i(G,"P",{"data-svelte-h":!0}),u(po)!=="svelte-o55m63"&&(po.innerHTML=Xt),Qn=s(G),c(R.$$.fragment,G),G.forEach(n),bn=s(e),c(Be.$$.fragment,e),wn=s(e),C=i(e,"DIV",{class:!0});var q=T(C);c(Ne.$$.fragment,q),En=s(q),ho=i(q,"P",{"data-svelte-h":!0}),u(ho)!=="svelte-13282x9"&&(ho.textContent=Qt),Yn=s(q),go=i(q,"P",{"data-svelte-h":!0}),u(go)!=="svelte-1wvbiny"&&(go.innerHTML=Et),Sn=s(q),F=i(q,"DIV",{class:!0});var lo=T(F);c(Oe.$$.fragment,lo),Hn=s(lo),fo=i(lo,"P",{"data-svelte-h":!0}),u(fo)!=="svelte-1o9eza"&&(fo.innerHTML=Yt),lo.forEach(n),Dn=s(q),P=i(q,"DIV",{class:!0});var co=T(P);c(We.$$.fragment,co),Kn=s(co),uo=i(co,"P",{"data-svelte-h":!0}),u(uo)!=="svelte-kk16qw"&&(uo.innerHTML=St),co.forEach(n),q.forEach(n),Jn=s(e),c(Ae.$$.fragment,e),Un=s(e),L=i(e,"DIV",{class:!0});var N=T(L);c(Re.$$.fragment,N),et=s(N),vo=i(N,"P",{"data-svelte-h":!0}),u(vo)!=="svelte-shdmuq"&&(vo.innerHTML=Ht),ot=s(N),V=i(N,"DIV",{class:!0});var Bn=T(V);c(Fe.$$.fragment,Bn),nt=s(Bn),_o=i(Bn,"P",{"data-svelte-h":!0}),u(_o)!=="svelte-1ycjrv2"&&(_o.textContent=Dt),Bn.forEach(n),tt=s(N),X=i(N,"DIV",{class:!0});var Nn=T(X);c(Pe.$$.fragment,Nn),at=s(Nn),yo=i(Nn,"P",{"data-svelte-h":!0}),u(yo)!=="svelte-1wucq2q"&&(yo.innerHTML=Kt),Nn.forEach(n),st=s(N),Mo=i(N,"DIV",{class:!0});var ca=T(Mo);c(Ve.$$.fragment,ca),ca.forEach(n),N.forEach(n),In=s(e),c(Xe.$$.fragment,e),jn=s(e),Z=i(e,"DIV",{class:!0});var qo=T(Z);c(Qe.$$.fragment,qo),rt=s(qo),To=i(qo,"P",{"data-svelte-h":!0}),u(To)!=="svelte-12h4324"&&(To.innerHTML=ea),it=s(qo),Q=i(qo,"DIV",{class:!0});var On=T(Q);c(Ee.$$.fragment,On),lt=s(On),bo=i(On,"P",{"data-svelte-h":!0}),u(bo)!=="svelte-1x3yxsa"&&(bo.textContent=oa),On.forEach(n),qo.forEach(n),Cn=s(e),c(Ye.$$.fragment,e),Ln=s(e),$=i(e,"DIV",{class:!0});var Zo=T($);c(Se.$$.fragment,Zo),dt=s(Zo),wo=i(Zo,"P",{"data-svelte-h":!0}),u(wo)!=="svelte-1api4zg"&&(wo.innerHTML=na),ct=s(Zo),Jo=i(Zo,"DIV",{class:!0});var ma=T(Jo);c(He.$$.fragment,ma),ma.forEach(n),Zo.forEach(n),zn=s(e),c(De.$$.fragment,e),xn=s(e),J=i(e,"DIV",{class:!0});var z=T(J);c(Ke.$$.fragment,z),mt=s(z),Uo=i(z,"P",{"data-svelte-h":!0}),u(Uo)!=="svelte-1c63ajw"&&(Uo.innerHTML=ta),pt=s(z),Io=i(z,"P",{"data-svelte-h":!0}),u(Io)!=="svelte-hswkmf"&&(Io.innerHTML=aa),ht=s(z),jo=i(z,"DIV",{class:!0});var pa=T(jo);c(eo.$$.fragment,pa),pa.forEach(n),gt=s(z),E=i(z,"DIV",{class:!0});var Wn=T(E);c(oo.$$.fragment,Wn),ft=s(Wn),Co=i(Wn,"P",{"data-svelte-h":!0}),u(Co)!=="svelte-1vzo9k5"&&(Co.textContent=sa),Wn.forEach(n),ut=s(z),Y=i(z,"DIV",{class:!0});var An=T(Y);c(no.$$.fragment,An),vt=s(An),Lo=i(An,"P",{"data-svelte-h":!0}),u(Lo)!=="svelte-1ph15fp"&&(Lo.textContent=ra),An.forEach(n),_t=s(z),S=i(z,"DIV",{class:!0});var Rn=T(S);c(to.$$.fragment,Rn),yt=s(Rn),zo=i(Rn,"P",{"data-svelte-h":!0}),u(zo)!=="svelte-1rwyyz6"&&(zo.textContent=ia),Rn.forEach(n),z.forEach(n),kn=s(e),c(ao.$$.fragment,e),qn=s(e),k=i(e,"DIV",{class:!0});var K=T(k);c(so.$$.fragment,K),Mt=s(K),xo=i(K,"P",{"data-svelte-h":!0}),u(xo)!=="svelte-1mgcqn3"&&(xo.innerHTML=la),Tt=s(K),ko=i(K,"P",{"data-svelte-h":!0}),u(ko)!=="svelte-hswkmf"&&(ko.innerHTML=da),bt=s(K),H=i(K,"DIV",{class:!0});var Fn=T(H);c(ro.$$.fragment,Fn),wt=s(Fn),c(D.$$.fragment,Fn),Fn.forEach(n),K.forEach(n),Zn=s(e),c(io.$$.fragment,e),$n=s(e),$o=i(e,"P",{}),T($o).forEach(n),this.h()},h(){M(v,"name","hf:doc:metadata"),M(v,"content",ja),M(w,"class","flex flex-wrap space-x-1"),ua(O.src,Lt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava-ov-acrhitecture.png")||M(O,"src",Lt),M(O,"alt","drawing"),M(O,"width","600"),M(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Mo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Jo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(jo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,v),t(e,j,o),t(e,y,o),t(e,_,o),m(b,e,o),t(e,f,o),t(e,w,o),t(e,Go,o),m(oe,e,o),t(e,Bo,o),t(e,ne,o),t(e,No,o),t(e,te,o),t(e,Oo,o),t(e,ae,o),t(e,Wo,o),t(e,se,o),t(e,Ao,o),t(e,O,o),t(e,Ro,o),t(e,re,o),t(e,Fo,o),t(e,ie,o),t(e,Po,o),t(e,le,o),t(e,Vo,o),m(W,e,o),t(e,Xo,o),m(de,e,o),t(e,Qo,o),t(e,ce,o),t(e,Eo,o),t(e,me,o),t(e,Yo,o),t(e,pe,o),t(e,So,o),t(e,he,o),t(e,Ho,o),m(ge,e,o),t(e,Do,o),t(e,fe,o),t(e,Ko,o),t(e,ue,o),t(e,en,o),m(ve,e,o),t(e,on,o),m(_e,e,o),t(e,nn,o),t(e,ye,o),t(e,tn,o),m(Me,e,o),t(e,an,o),m(Te,e,o),t(e,sn,o),t(e,be,o),t(e,rn,o),m(we,e,o),t(e,ln,o),m(Je,e,o),t(e,dn,o),t(e,Ue,o),t(e,cn,o),m(Ie,e,o),t(e,mn,o),m(je,e,o),t(e,pn,o),m(Ce,e,o),t(e,hn,o),t(e,Le,o),t(e,gn,o),m(A,e,o),t(e,fn,o),t(e,ze,o),t(e,un,o),m(xe,e,o),t(e,vn,o),m(ke,e,o),t(e,_n,o),t(e,qe,o),t(e,yn,o),m(Ze,e,o),t(e,Mn,o),m($e,e,o),t(e,Tn,o),t(e,x,o),m(Ge,x,null),l(x,Vn),l(x,mo),l(x,Xn),l(x,po),l(x,Qn),m(R,x,null),t(e,bn,o),m(Be,e,o),t(e,wn,o),t(e,C,o),m(Ne,C,null),l(C,En),l(C,ho),l(C,Yn),l(C,go),l(C,Sn),l(C,F),m(Oe,F,null),l(F,Hn),l(F,fo),l(C,Dn),l(C,P),m(We,P,null),l(P,Kn),l(P,uo),t(e,Jn,o),m(Ae,e,o),t(e,Un,o),t(e,L,o),m(Re,L,null),l(L,et),l(L,vo),l(L,ot),l(L,V),m(Fe,V,null),l(V,nt),l(V,_o),l(L,tt),l(L,X),m(Pe,X,null),l(X,at),l(X,yo),l(L,st),l(L,Mo),m(Ve,Mo,null),t(e,In,o),m(Xe,e,o),t(e,jn,o),t(e,Z,o),m(Qe,Z,null),l(Z,rt),l(Z,To),l(Z,it),l(Z,Q),m(Ee,Q,null),l(Q,lt),l(Q,bo),t(e,Cn,o),m(Ye,e,o),t(e,Ln,o),t(e,$,o),m(Se,$,null),l($,dt),l($,wo),l($,ct),l($,Jo),m(He,Jo,null),t(e,zn,o),m(De,e,o),t(e,xn,o),t(e,J,o),m(Ke,J,null),l(J,mt),l(J,Uo),l(J,pt),l(J,Io),l(J,ht),l(J,jo),m(eo,jo,null),l(J,gt),l(J,E),m(oo,E,null),l(E,ft),l(E,Co),l(J,ut),l(J,Y),m(no,Y,null),l(Y,vt),l(Y,Lo),l(J,_t),l(J,S),m(to,S,null),l(S,yt),l(S,zo),t(e,kn,o),m(ao,e,o),t(e,qn,o),t(e,k,o),m(so,k,null),l(k,Mt),l(k,xo),l(k,Tt),l(k,ko),l(k,bt),l(k,H),m(ro,H,null),l(H,wt),m(D,H,null),t(e,Zn,o),m(io,e,o),t(e,$n,o),t(e,$o,o),Gn=!0},p(e,[o]){const G={};o&2&&(G.$$scope={dirty:o,ctx:e}),W.$set(G);const q={};o&2&&(q.$$scope={dirty:o,ctx:e}),A.$set(q);const lo={};o&2&&(lo.$$scope={dirty:o,ctx:e}),R.$set(lo);const co={};o&2&&(co.$$scope={dirty:o,ctx:e}),D.$set(co)},i(e){Gn||(p(b.$$.fragment,e),p(oe.$$.fragment,e),p(W.$$.fragment,e),p(de.$$.fragment,e),p(ge.$$.fragment,e),p(ve.$$.fragment,e),p(_e.$$.fragment,e),p(Me.$$.fragment,e),p(Te.$$.fragment,e),p(we.$$.fragment,e),p(Je.$$.fragment,e),p(Ie.$$.fragment,e),p(je.$$.fragment,e),p(Ce.$$.fragment,e),p(A.$$.fragment,e),p(xe.$$.fragment,e),p(ke.$$.fragment,e),p(Ze.$$.fragment,e),p($e.$$.fragment,e),p(Ge.$$.fragment,e),p(R.$$.fragment,e),p(Be.$$.fragment,e),p(Ne.$$.fragment,e),p(Oe.$$.fragment,e),p(We.$$.fragment,e),p(Ae.$$.fragment,e),p(Re.$$.fragment,e),p(Fe.$$.fragment,e),p(Pe.$$.fragment,e),p(Ve.$$.fragment,e),p(Xe.$$.fragment,e),p(Qe.$$.fragment,e),p(Ee.$$.fragment,e),p(Ye.$$.fragment,e),p(Se.$$.fragment,e),p(He.$$.fragment,e),p(De.$$.fragment,e),p(Ke.$$.fragment,e),p(eo.$$.fragment,e),p(oo.$$.fragment,e),p(no.$$.fragment,e),p(to.$$.fragment,e),p(ao.$$.fragment,e),p(so.$$.fragment,e),p(ro.$$.fragment,e),p(D.$$.fragment,e),p(io.$$.fragment,e),Gn=!0)},o(e){h(b.$$.fragment,e),h(oe.$$.fragment,e),h(W.$$.fragment,e),h(de.$$.fragment,e),h(ge.$$.fragment,e),h(ve.$$.fragment,e),h(_e.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(Ie.$$.fragment,e),h(je.$$.fragment,e),h(Ce.$$.fragment,e),h(A.$$.fragment,e),h(xe.$$.fragment,e),h(ke.$$.fragment,e),h(Ze.$$.fragment,e),h($e.$$.fragment,e),h(Ge.$$.fragment,e),h(R.$$.fragment,e),h(Be.$$.fragment,e),h(Ne.$$.fragment,e),h(Oe.$$.fragment,e),h(We.$$.fragment,e),h(Ae.$$.fragment,e),h(Re.$$.fragment,e),h(Fe.$$.fragment,e),h(Pe.$$.fragment,e),h(Ve.$$.fragment,e),h(Xe.$$.fragment,e),h(Qe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(He.$$.fragment,e),h(De.$$.fragment,e),h(Ke.$$.fragment,e),h(eo.$$.fragment,e),h(oo.$$.fragment,e),h(no.$$.fragment,e),h(to.$$.fragment,e),h(ao.$$.fragment,e),h(so.$$.fragment,e),h(ro.$$.fragment,e),h(D.$$.fragment,e),h(io.$$.fragment,e),Gn=!1},d(e){e&&(n(j),n(y),n(_),n(f),n(w),n(Go),n(Bo),n(ne),n(No),n(te),n(Oo),n(ae),n(Wo),n(se),n(Ao),n(O),n(Ro),n(re),n(Fo),n(ie),n(Po),n(le),n(Vo),n(Xo),n(Qo),n(ce),n(Eo),n(me),n(Yo),n(pe),n(So),n(he),n(Ho),n(Do),n(fe),n(Ko),n(ue),n(en),n(on),n(nn),n(ye),n(tn),n(an),n(sn),n(be),n(rn),n(ln),n(dn),n(Ue),n(cn),n(mn),n(pn),n(hn),n(Le),n(gn),n(fn),n(ze),n(un),n(vn),n(_n),n(qe),n(yn),n(Mn),n(Tn),n(x),n(bn),n(wn),n(C),n(Jn),n(Un),n(L),n(In),n(jn),n(Z),n(Cn),n(Ln),n($),n(zn),n(xn),n(J),n(kn),n(qn),n(k),n(Zn),n($n),n($o)),n(v),g(b,e),g(oe,e),g(W,e),g(de,e),g(ge,e),g(ve,e),g(_e,e),g(Me,e),g(Te,e),g(we,e),g(Je,e),g(Ie,e),g(je,e),g(Ce,e),g(A,e),g(xe,e),g(ke,e),g(Ze,e),g($e,e),g(Ge),g(R),g(Be,e),g(Ne),g(Oe),g(We),g(Ae,e),g(Re),g(Fe),g(Pe),g(Ve),g(Xe,e),g(Qe),g(Ee),g(Ye,e),g(Se),g(He),g(De,e),g(Ke),g(eo),g(oo),g(no),g(to),g(ao,e),g(so),g(ro),g(D),g(io,e)}}}const ja='{"title":"LLaVA-OneVision","local":"llava-onevision","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3},{"title":"Video inference","local":"video-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaOnevisionConfig","local":"transformers.LlavaOnevisionConfig","sections":[],"depth":2},{"title":"LlavaOnevisionProcessor","local":"transformers.LlavaOnevisionProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionImageProcessor","local":"transformers.LlavaOnevisionImageProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionImageProcessorFast","local":"transformers.LlavaOnevisionImageProcessorFast","sections":[],"depth":2},{"title":"LlavaOnevisionVideoProcessor","local":"transformers.LlavaOnevisionVideoProcessor","sections":[],"depth":2},{"title":"LlavaOnevisionModel","local":"transformers.LlavaOnevisionModel","sections":[],"depth":2},{"title":"LlavaOnevisionForConditionalGeneration","local":"transformers.LlavaOnevisionForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Ca(B){return va(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ba extends _a{constructor(v){super(),ya(this,v,Ca,Ia,fa,{})}}export{Ba as component};
