import{s as ws,o as ks,n as It}from"../chunks/scheduler.18a86fab.js";import{S as js,i as Cs,g as r,s,r as m,A as Js,h as i,f as n,c as a,j as $,u as p,x as d,k as U,y as l,a as o,v as u,d as h,t as g,w as f}from"../chunks/index.98837b22.js";import{T as jo}from"../chunks/Tip.77304350.js";import{D as X}from"../chunks/Docstring.6758ea23.js";import{C as R}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as vs}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as Z}from"../chunks/Heading.7e7e0c5b.js";import{E as Us}from"../chunks/index.499f366c.js";function Zs(F){let c,y="Example:",M,b,T;return b=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBNdXNpY2dlbkNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRGVjb2RlckNvbmZpZyUyQyUwQSUyMCUyMCUyMCUyMFQ1Q29uZmlnJTJDJTBBJTIwJTIwJTIwJTIwRW5jb2RlY0NvbmZpZyUyQyUwQSUyMCUyMCUyMCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTJDJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMHRleHQlMjBlbmNvZGVyJTJDJTIwYXVkaW8lMjBlbmNvZGVyJTJDJTIwYW5kJTIwZGVjb2RlciUyMG1vZGVsJTIwY29uZmlndXJhdGlvbnMlMEF0ZXh0X2VuY29kZXJfY29uZmlnJTIwJTNEJTIwVDVDb25maWcoKSUwQWF1ZGlvX2VuY29kZXJfY29uZmlnJTIwJTNEJTIwRW5jb2RlY0NvbmZpZygpJTBBZGVjb2Rlcl9jb25maWclMjAlM0QlMjBNdXNpY2dlbkRlY29kZXJDb25maWcoKSUwQSUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBNdXNpY2dlbkNvbmZpZy5mcm9tX3N1Yl9tb2RlbHNfY29uZmlnKCUwQSUyMCUyMCUyMCUyMHRleHRfZW5jb2Rlcl9jb25maWclMkMlMjBhdWRpb19lbmNvZGVyX2NvbmZpZyUyQyUyMGRlY29kZXJfY29uZmlnJTBBKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBY29uZmlnX3RleHRfZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy50ZXh0X2VuY29kZXIlMEFjb25maWdfYXVkaW9fZW5jb2RlciUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyJTBBY29uZmlnX2RlY29kZXIlMjAlM0QlMjBtb2RlbC5jb25maWcuZGVjb2RlciUwQSUwQSUyMyUyMFNhdmluZyUyMHRoZSUyMG1vZGVsJTJDJTIwaW5jbHVkaW5nJTIwaXRzJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEElMEElMjMlMjBsb2FkaW5nJTIwbW9kZWwlMjBhbmQlMjBjb25maWclMjBmcm9tJTIwcHJldHJhaW5lZCUyMGZvbGRlciUwQW11c2ljZ2VuX2NvbmZpZyUyMCUzRCUyME11c2ljZ2VuQ29uZmlnLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJtdXNpY2dlbi1tb2RlbCUyMiUyQyUyMGNvbmZpZyUzRG11c2ljZ2VuX2NvbmZpZyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    MusicgenConfig,
<span class="hljs-meta">... </span>    MusicgenDecoderConfig,
<span class="hljs-meta">... </span>    T5Config,
<span class="hljs-meta">... </span>    EncodecConfig,
<span class="hljs-meta">... </span>    MusicgenForConditionalGeneration,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing text encoder, audio encoder, and decoder model configurations</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_config = T5Config()
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_encoder_config = EncodecConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = MusicgenDecoderConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = MusicgenConfig.from_sub_models_config(
<span class="hljs-meta">... </span>    text_encoder_config, audio_encoder_config, decoder_config
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a MusicgenForConditionalGeneration (with random weights) from the facebook/musicgen-small style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config
<span class="hljs-meta">&gt;&gt;&gt; </span>config_text_encoder = model.config.text_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_audio_encoder = model.config.audio_encoder
<span class="hljs-meta">&gt;&gt;&gt; </span>config_decoder = model.config.decoder

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Saving the model, including its configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># loading model and config from pretrained folder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>musicgen_config = MusicgenConfig.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;musicgen-model&quot;</span>, config=musicgen_config)`,wrap:!1}}),{c(){c=r("p"),c.textContent=y,M=s(),m(b.$$.fragment)},l(_){c=i(_,"P",{"data-svelte-h":!0}),d(c)!=="svelte-11lpom8"&&(c.textContent=y),M=a(_),p(b.$$.fragment,_)},m(_,j){o(_,c,j),o(_,M,j),u(b,_,j),T=!0},p:It,i(_){T||(h(b.$$.fragment,_),T=!0)},o(_){g(b.$$.fragment,_),T=!1},d(_){_&&(n(c),n(M)),f(b,_)}}}function $s(F){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=y},l(M){c=i(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(M,b){o(M,c,b)},p:It,d(M){M&&n(c)}}}function Gs(F){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=y},l(M){c=i(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(M,b){o(M,c,b)},p:It,d(M){M&&n(c)}}}function xs(F){let c,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){c=r("p"),c.innerHTML=y},l(M){c=i(M,"P",{"data-svelte-h":!0}),d(c)!=="svelte-fincs2"&&(c.innerHTML=y)},m(M,b){o(M,c,b)},p:It,d(M){M&&n(c)}}}function Fs(F){let c,y="Examples:",M,b,T;return b=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEFtb2RlbCUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwcG9wJTIwdHJhY2slMjB3aXRoJTIwYmFzc3klMjBkcnVtcyUyMGFuZCUyMHN5bnRoJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQSUwQXBhZF90b2tlbl9pZCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRpb25fY29uZmlnLnBhZF90b2tlbl9pZCUwQWRlY29kZXJfaW5wdXRfaWRzJTIwJTNEJTIwKCUwQSUyMCUyMCUyMCUyMHRvcmNoLm9uZXMoKGlucHV0cy5pbnB1dF9pZHMuc2hhcGUlNUIwJTVEJTIwKiUyMG1vZGVsLmRlY29kZXIubnVtX2NvZGVib29rcyUyQyUyMDEpJTJDJTIwZHR5cGUlM0R0b3JjaC5sb25nKSUwQSUyMCUyMCUyMCUyMColMjBwYWRfdG9rZW5faWQlMEEpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBkZWNvZGVyX2lucHV0X2lkcyUzRGRlY29kZXJfaW5wdXRfaWRzKS5sb2dpdHMlMEFsb2dpdHMuc2hhcGUlMjAlMjAlMjMlMjAoYnN6JTIwKiUyMG51bV9jb2RlYm9va3MlMkMlMjB0Z3RfbGVuJTJDJTIwdm9jYWJfc2l6ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>pad_token_id = model.generation_config.pad_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_input_ids = (
<span class="hljs-meta">... </span>    torch.ones((inputs.input_ids.shape[<span class="hljs-number">0</span>] * model.decoder.num_codebooks, <span class="hljs-number">1</span>), dtype=torch.long)
<span class="hljs-meta">... </span>    * pad_token_id
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs, decoder_input_ids=decoder_input_ids).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape  <span class="hljs-comment"># (bsz * num_codebooks, tgt_len, vocab_size)</span>
torch.Size([<span class="hljs-number">8</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2048</span>])`,wrap:!1}}),{c(){c=r("p"),c.textContent=y,M=s(),m(b.$$.fragment)},l(_){c=i(_,"P",{"data-svelte-h":!0}),d(c)!=="svelte-kvfsh7"&&(c.textContent=y),M=a(_),p(b.$$.fragment,_)},m(_,j){o(_,c,j),o(_,M,j),u(b,_,j),T=!0},p:It,i(_){T||(h(b.$$.fragment,_),T=!0)},o(_){g(b.$$.fragment,_),T=!1},d(_){_&&(n(c),n(M)),f(b,_)}}}function Ws(F){let c,y,M,b,T,_,j,Co='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',Nt,K,Xt,ee,Jo=`The MusicGen model was proposed in the paper <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a>
by Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi and Alexandre Défossez.`,Rt,te,Uo=`MusicGen is a single stage auto-regressive Transformer model capable of generating high-quality music samples conditioned
on text descriptions or audio prompts. The text descriptions are passed through a frozen text encoder model to obtain a
sequence of hidden-state representations. MusicGen is then trained to predict discrete audio tokens, or <em>audio codes</em>,
conditioned on these hidden-states. These audio tokens are then decoded using an audio compression model, such as EnCodec,
to recover the audio waveform.`,Bt,ne,Zo=`Through an efficient token interleaving pattern, MusicGen does not require a self-supervised semantic representation of
the text/audio prompts, thus eliminating the need to cascade multiple models to predict a set of codebooks (e.g.
hierarchically or upsampling). Instead, it is able to generate all the codebooks in a single forward pass.`,qt,oe,$o="The abstract from the paper is the following:",Vt,se,Go=`<em>We tackle the task of conditional music generation. We introduce MusicGen, a single Language Model (LM) that operates
over several streams of compressed discrete music representation, i.e., tokens. Unlike prior work, MusicGen is comprised
of a single-stage transformer LM together with efficient token interleaving patterns, which eliminates the need for
cascading several models, e.g., hierarchically or upsampling. Following this approach, we demonstrate how MusicGen
can generate high-quality samples, while being conditioned on textual description or melodic features, allowing better
controls over the generated output. We conduct extensive empirical evaluation, considering both automatic and human
studies, showing the proposed approach is superior to the evaluated baselines on a standard text-to-music benchmark.
Through ablation studies, we shed light over the importance of each of the components comprising MusicGen.</em>`,Et,ae,xo=`This model was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a>. The original code can be found
<a href="https://github.com/facebookresearch/audiocraft" rel="nofollow">here</a>. The pre-trained checkpoints can be found on the
<a href="https://huggingface.co/models?sort=downloads&amp;search=facebook%2Fmusicgen-" rel="nofollow">Hugging Face Hub</a>.`,Yt,re,Ht,ie,Fo=`<li>After downloading the original checkpoints from <a href="https://github.com/facebookresearch/audiocraft/blob/main/docs/MUSICGEN.md#importing--exporting-models" rel="nofollow">here</a> , you can convert them using the <strong>conversion script</strong> available at
<code>src/transformers/models/musicgen/convert_musicgen_transformers.py</code> with the following command:</li>`,Lt,le,Qt,de,St,ce,Wo=`MusicGen is compatible with two generation modes: greedy and sampling. In practice, sampling leads to significantly
better results than greedy, thus we encourage sampling mode to be used where possible. Sampling is enabled by default,
and can be explicitly specified by setting <code>do_sample=True</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code>,
or by overriding the model’s generation config (see below).`,Pt,me,zo=`Generation is limited by the sinusoidal positional embeddings to 30 second inputs. Meaning, MusicGen cannot generate more
than 30 seconds of audio (1503 tokens), and input audio passed by Audio-Prompted Generation contributes to this limit so,
given an input of 20 seconds of audio, MusicGen cannot generate more than 10 seconds of additional audio.`,Dt,pe,Io=`Transformers supports both mono (1-channel) and stereo (2-channel) variants of MusicGen. The mono channel versions
generate a single set of codebooks. The stereo versions generate 2 sets of codebooks, 1 for each channel (left/right),
and each set of codebooks is decoded independently through the audio compression model. The audio streams for each
channel are combined to give the final stereo output.`,At,ue,Ot,he,No=`The inputs for unconditional (or ‘null’) generation can be obtained through the method
<code>MusicgenForConditionalGeneration.get_unconditional_inputs()</code>:`,Kt,ge,en,fe,Xo=`The audio outputs are a three-dimensional Torch tensor of shape <code>(batch_size, num_channels, sequence_length)</code>. To listen
to the generated audio samples, you can either play them in an ipynb notebook:`,tn,_e,nn,Me,Ro="Or save them as a <code>.wav</code> file using a third-party library, e.g. <code>scipy</code>:",on,be,sn,ye,an,Te,Bo=`The model can generate an audio sample conditioned on a text prompt through use of the <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> to pre-process
the inputs:`,rn,ve,ln,we,qo=`The <code>guidance_scale</code> is used in classifier free guidance (CFG), setting the weighting between the conditional logits
(which are predicted from the text prompts) and the unconditional logits (which are predicted from an unconditional or
‘null’ prompt). Higher guidance scale encourages the model to generate samples that are more closely linked to the input
prompt, usually at the expense of poorer audio quality. CFG is enabled by setting <code>guidance_scale &gt; 1</code>. For best results,
use <code>guidance_scale=3</code> (default).`,dn,ke,cn,je,Vo=`The same <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> can be used to pre-process an audio prompt that is used for audio continuation. In the
following example, we load an audio file using the 🤗 Datasets library, which can be pip installed through the command
below:`,mn,Ce,pn,Je,un,Ue,Eo=`For batched audio-prompted generation, the generated <code>audio_values</code> can be post-processed to remove padding by using the
<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> class:`,hn,Ze,gn,$e,fn,Ge,Yo=`The default parameters that control the generation process, such as sampling, guidance scale and number of generated
tokens, can be found in the model’s generation config, and updated as desired:`,_n,xe,Mn,Fe,Ho=`Note that any arguments passed to the generate method will <strong>supersede</strong> those in the generation config, so setting
<code>do_sample=False</code> in the call to generate will supersede the setting of <code>model.generation_config.do_sample</code> in the
generation config.`,bn,We,yn,ze,Lo="The MusicGen model can be de-composed into three distinct stages:",Tn,Ie,Qo="<li>Text encoder: maps the text inputs to a sequence of hidden-state representations. The pre-trained MusicGen models use a frozen text encoder from either T5 or Flan-T5</li> <li>MusicGen decoder: a language model (LM) that auto-regressively generates audio tokens (or codes) conditional on the encoder hidden-state representations</li> <li>Audio encoder/decoder: used to encode an audio prompt to use as prompt tokens, and recover the audio waveform from the audio tokens predicted by the decoder</li>",vn,Ne,So=`Thus, the MusicGen model can either be used as a standalone decoder model, corresponding to the class <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>,
or as a composite model that includes the text encoder and audio encoder/decoder, corresponding to the class
<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>. If only the decoder needs to be loaded from the pre-trained checkpoint, it can be loaded by first
specifying the correct config, or be accessed through the <code>.decoder</code> attribute of the composite model:`,wn,Xe,kn,Re,Po=`Since the text encoder and audio encoder/decoder models are frozen during training, the MusicGen decoder <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a>
can be trained standalone on a dataset of encoder hidden-states and audio codes. For inference, the trained decoder can
be combined with the frozen text encoder and audio encoder/decoders to recover the composite <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a>
model.`,jn,Be,Do="Tips:",Cn,qe,Ao="<li>MusicGen is trained on the 32kHz checkpoint of Encodec. You should ensure you use a compatible version of the Encodec model.</li> <li>Sampling mode tends to deliver better results than greedy - you can toggle sampling with the variable <code>do_sample</code> in the call to <code>MusicgenForConditionalGeneration.generate()</code></li>",Jn,Ve,Un,B,Ee,En,dt,Oo=`This is the configuration class to store the configuration of an <code>MusicgenDecoder</code>. It is used to instantiate a
MusicGen decoder according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the MusicGen
<a href="https://huggingface.co/facebook/musicgen-small" rel="nofollow">facebook/musicgen-small</a> architecture.`,Yn,ct,Ko=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Zn,Ye,$n,C,He,Hn,mt,es=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a>. It is used to instantiate a
MusicGen model according to the specified arguments, defining the text encoder, audio encoder and MusicGen decoder
configs.`,Ln,pt,ts=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Qn,Y,Sn,H,Le,Pn,ut,ns=`Instantiate a <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a> (or a derived class) from text encoder, audio encoder and decoder
configurations.`,Gn,Qe,xn,J,Se,Dn,ht,os=`Constructs a MusicGen processor which wraps an EnCodec feature extractor and a T5 tokenizer into a single processor
class.`,An,gt,ss=`<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor">MusicgenProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a> and <code>TTokenizer</code>. See
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenProcessor.decode">decode()</a> for more information.`,On,L,Pe,Kn,ft,as=`This method is used to decode either batches of audio outputs from the MusicGen model, or batches of token ids
from the tokenizer. In the case of decoding token ids, this method forwards all its arguments to T5Tokenizer’s
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please refer to the docstring of this method for more information.`,eo,Q,De,to,_t,rs=`This method forwards all its arguments to T5Tokenizer’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to the
docstring of this method for more information.`,Fn,Ae,Wn,v,Oe,no,Mt,is="The bare Musicgen decoder model outputting raw hidden-states without any specific head on top.",oo,bt,ls=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,so,yt,ds=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,ao,Tt,cs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ro,q,Ke,io,vt,ms='The <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenModel">MusicgenModel</a> forward method, overrides the <code>__call__</code> special method.',lo,S,zn,et,In,w,tt,co,wt,ps="The MusicGen decoder model with a language modelling head on top.",mo,kt,us=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,po,jt,hs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,uo,Ct,gs=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ho,V,nt,go,Jt,fs='The <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForCausalLM">MusicgenForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',fo,P,Nn,ot,Xn,k,st,_o,Ut,_s="The composite MusicGen model with a text encoder, audio encoder and Musicgen decoder, for music generation tasks with one or both of text and audio prompts.",Mo,Zt,Ms=`The Musicgen model was proposed in <a href="https://arxiv.org/abs/2306.05284" rel="nofollow">Simple and Controllable Music Generation</a> by
Jade Copet, Felix Kreuk, Itai Gat, Tal Remez, David Kant, Gabriel Synnaeve, Yossi Adi, Alexandre Défossez. It is an
encoder decoder transformer trained on the task of conditional music generation`,bo,$t,bs=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,yo,Gt,ys=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,To,W,at,vo,xt,Ts='The <a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenForConditionalGeneration">MusicgenForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',wo,D,ko,A,Rn,rt,Bn,zt,qn;return T=new Z({props:{title:"MusicGen",local:"musicgen",headingTag:"h1"}}),K=new Z({props:{title:"Overview",local:"overview",headingTag:"h2"}}),re=new Z({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),le=new R({props:{code:"cHl0aG9uJTIwc3JjJTJGdHJhbnNmb3JtZXJzJTJGbW9kZWxzJTJGbXVzaWNnZW4lMkZjb252ZXJ0X211c2ljZ2VuX3RyYW5zZm9ybWVycy5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludCUyMHNtYWxsJTIwLS1weXRvcmNoX2R1bXBfZm9sZGVyJTIwJTJGb3V0cHV0JTJGcGF0aCUyMC0tc2FmZV9zZXJpYWxpemF0aW9uJTIw",highlighted:`python src/transformers/models/musicgen/convert_musicgen_transformers.py \\
    --checkpoint small --pytorch_dump_folder /output/path --safe_serialization `,wrap:!1}}),de=new Z({props:{title:"Generation",local:"generation",headingTag:"h2"}}),ue=new Z({props:{title:"Unconditional Generation",local:"unconditional-generation",headingTag:"h3"}}),ge=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEF1bmNvbmRpdGlvbmFsX2lucHV0cyUyMCUzRCUyMG1vZGVsLmdldF91bmNvbmRpdGlvbmFsX2lucHV0cyhudW1fc2FtcGxlcyUzRDEpJTBBJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKip1bmNvbmRpdGlvbmFsX2lucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>unconditional_inputs = model.get_unconditional_inputs(num_samples=<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**unconditional_inputs, do_sample=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),_e=new R({props:{code:"ZnJvbSUyMElQeXRob24uZGlzcGxheSUyMGltcG9ydCUyMEF1ZGlvJTBBJTBBc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMG1vZGVsLmNvbmZpZy5hdWRpb19lbmNvZGVyLnNhbXBsaW5nX3JhdGUlMEFBdWRpbyhhdWRpb192YWx1ZXMlNUIwJTVELm51bXB5KCklMkMlMjByYXRlJTNEc2FtcGxpbmdfcmF0ZSk=",highlighted:`<span class="hljs-keyword">from</span> IPython.display <span class="hljs-keyword">import</span> Audio

sampling_rate = model.config.audio_encoder.sampling_rate
Audio(audio_values[<span class="hljs-number">0</span>].numpy(), rate=sampling_rate)`,wrap:!1}}),be=new R({props:{code:"aW1wb3J0JTIwc2NpcHklMEElMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwbW9kZWwuY29uZmlnLmF1ZGlvX2VuY29kZXIuc2FtcGxpbmdfcmF0ZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIybXVzaWNnZW5fb3V0LndhdiUyMiUyQyUyMHJhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwZGF0YSUzRGF1ZGlvX3ZhbHVlcyU1QjAlMkMlMjAwJTVELm51bXB5KCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy

<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = model.config.audio_encoder.sampling_rate
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;musicgen_out.wav&quot;</span>, rate=sampling_rate, data=audio_values[<span class="hljs-number">0</span>, <span class="hljs-number">0</span>].numpy())`,wrap:!1}}),ye=new Z({props:{title:"Text-Conditional Generation",local:"text-conditional-generation",headingTag:"h3"}}),ve=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMHBvcCUyMHRyYWNrJTIwd2l0aCUyMGJhc3N5JTIwZHJ1bXMlMjBhbmQlMjBzeW50aCUyMiUyQyUyMCUyMjkwcyUyMHJvY2slMjBzb25nJTIwd2l0aCUyMGxvdWQlMjBndWl0YXJzJTIwYW5kJTIwaGVhdnklMjBkcnVtcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSklMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMGRvX3NhbXBsZSUzRFRydWUlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDI1Nik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s pop track with bassy drums and synth&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),ke=new Z({props:{title:"Audio-Prompted Generation",local:"audio-prompted-generation",headingTag:"h3"}}),Ce=new R({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMHBpcCUwQXBpcCUyMGluc3RhbGwlMjBkYXRhc2V0cyU1QmF1ZGlvJTVE",highlighted:`pip install --upgrade pip
pip install datasets[audio]`,wrap:!1}}),Je=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBoYWxmJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwMiU1RCUwQSUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvciglMEElMjAlMjAlMjAlMjBhdWRpbyUzRHNhbXBsZSU1QiUyMmFycmF5JTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwc2FtcGxpbmdfcmF0ZSUzRHNhbXBsZSU1QiUyMnNhbXBsaW5nX3JhdGUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB0ZXh0JTNEJTVCJTIyODBzJTIwYmx1ZXMlMjB0cmFjayUyMHdpdGglMjBncm9vdnklMjBzYXhvcGhvbmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMEEpJTBBYXVkaW9fdmFsdWVzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample[<span class="hljs-string">&quot;array&quot;</span>] = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=sample[<span class="hljs-string">&quot;array&quot;</span>],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)`,wrap:!1}}),Ze=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMkMlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEFkYXRhc2V0JTIwJTNEJTIwbG9hZF9kYXRhc2V0KCUyMnNhbmNoaXQtZ2FuZGhpJTJGZ3R6YW4lMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyJTJDJTIwc3RyZWFtaW5nJTNEVHJ1ZSklMEFzYW1wbGUlMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YXNldCkpJTVCJTIyYXVkaW8lMjIlNUQlMEElMEElMjMlMjB0YWtlJTIwdGhlJTIwZmlyc3QlMjBxdWFydGVyJTIwb2YlMjB0aGUlMjBhdWRpbyUyMHNhbXBsZSUwQXNhbXBsZV8xJTIwJTNEJTIwc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQlNUIlM0ElMjBsZW4oc2FtcGxlJTVCJTIyYXJyYXklMjIlNUQpJTIwJTJGJTJGJTIwNCU1RCUwQSUwQSUyMyUyMHRha2UlMjB0aGUlMjBmaXJzdCUyMGhhbGYlMjBvZiUyMHRoZSUyMGF1ZGlvJTIwc2FtcGxlJTBBc2FtcGxlXzIlMjAlM0QlMjBzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCU1QiUzQSUyMGxlbihzYW1wbGUlNUIlMjJhcnJheSUyMiU1RCklMjAlMkYlMkYlMjAyJTVEJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKCUwQSUyMCUyMCUyMCUyMGF1ZGlvJTNEJTVCc2FtcGxlXzElMkMlMjBzYW1wbGVfMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGUlNUIlMjJzYW1wbGluZ19yYXRlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMjgwcyUyMGJsdWVzJTIwdHJhY2slMjB3aXRoJTIwZ3Jvb3Z5JTIwc2F4b3Bob25lJTIyJTJDJTIwJTIyOTBzJTIwcm9jayUyMHNvbmclMjB3aXRoJTIwbG91ZCUyMGd1aXRhcnMlMjBhbmQlMjBoZWF2eSUyMGRydW1zJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyJTJDJTBBKSUwQWF1ZGlvX3ZhbHVlcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMyUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMjU2KSUwQSUwQSUyMyUyMHBvc3QtcHJvY2VzcyUyMHRvJTIwcmVtb3ZlJTIwcGFkZGluZyUyMGZyb20lMjB0aGUlMjBiYXRjaGVkJTIwYXVkaW8lMEFhdWRpb192YWx1ZXMlMjAlM0QlMjBwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGF1ZGlvX3ZhbHVlcyUyQyUyMHBhZGRpbmdfbWFzayUzRGlucHV0cy5wYWRkaW5nX21hc2sp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, MusicgenForConditionalGeneration
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;sanchit-gandhi/gtzan&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>, streaming=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sample = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataset))[<span class="hljs-string">&quot;audio&quot;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first quarter of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_1 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">4</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># take the first half of the audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>sample_2 = sample[<span class="hljs-string">&quot;array&quot;</span>][: <span class="hljs-built_in">len</span>(sample[<span class="hljs-string">&quot;array&quot;</span>]) // <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">... </span>    audio=[sample_1, sample_2],
<span class="hljs-meta">... </span>    sampling_rate=sample[<span class="hljs-string">&quot;sampling_rate&quot;</span>],
<span class="hljs-meta">... </span>    text=[<span class="hljs-string">&quot;80s blues track with groovy saxophone&quot;</span>, <span class="hljs-string">&quot;90s rock song with loud guitars and heavy drums&quot;</span>],
<span class="hljs-meta">... </span>    padding=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = model.generate(**inputs, do_sample=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3</span>, max_new_tokens=<span class="hljs-number">256</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># post-process to remove padding from the batched audio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_values = processor.batch_decode(audio_values, padding_mask=inputs.padding_mask)`,wrap:!1}}),$e=new Z({props:{title:"Generation Configuration",local:"generation-configuration",headingTag:"h3"}}),xe=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBNdXNpY2dlbkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiklMEElMEElMjMlMjBpbnNwZWN0JTIwdGhlJTIwZGVmYXVsdCUyMGdlbmVyYXRpb24lMjBjb25maWclMEFtb2RlbC5nZW5lcmF0aW9uX2NvbmZpZyUwQSUwQSUyMyUyMGluY3JlYXNlJTIwdGhlJTIwZ3VpZGFuY2UlMjBzY2FsZSUyMHRvJTIwNC4wJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcuZ3VpZGFuY2Vfc2NhbGUlMjAlM0QlMjA0LjAlMEElMEElMjMlMjBkZWNyZWFzZSUyMHRoZSUyMG1heCUyMGxlbmd0aCUyMHRvJTIwMjU2JTIwdG9rZW5zJTBBbW9kZWwuZ2VuZXJhdGlvbl9jb25maWcubWF4X2xlbmd0aCUyMCUzRCUyMDI1Ng==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inspect the default generation config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># increase the guidance scale to 4.0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.guidance_scale = <span class="hljs-number">4.0</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># decrease the max length to 256 tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.generation_config.max_length = <span class="hljs-number">256</span>`,wrap:!1}}),We=new Z({props:{title:"Model Structure",local:"model-structure",headingTag:"h2"}}),Xe=new R({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Db25maWclMkMlMjBNdXNpY2dlbkZvckNhdXNhbExNJTJDJTIwTXVzaWNnZW5Gb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEElMjMlMjBPcHRpb24lMjAxJTNBJTIwZ2V0JTIwZGVjb2RlciUyMGNvbmZpZyUyMGFuZCUyMHBhc3MlMjB0byUyMCU2MC5mcm9tX3ByZXRyYWluZWQlNjAlMEFkZWNvZGVyX2NvbmZpZyUyMCUzRCUyMEF1dG9Db25maWcuZnJvbV9wcmV0cmFpbmVkKCUyMmZhY2Vib29rJTJGbXVzaWNnZW4tc21hbGwlMjIpLmRlY29kZXIlMEFkZWNvZGVyJTIwJTNEJTIwTXVzaWNnZW5Gb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmFjZWJvb2slMkZtdXNpY2dlbi1zbWFsbCUyMiUyQyUyMCoqZGVjb2Rlcl9jb25maWcpJTBBJTBBJTIzJTIwT3B0aW9uJTIwMiUzQSUyMGxvYWQlMjB0aGUlMjBlbnRpcmUlMjBjb21wb3NpdGUlMjBtb2RlbCUyQyUyMGJ1dCUyMG9ubHklMjByZXR1cm4lMjB0aGUlMjBkZWNvZGVyJTBBZGVjb2RlciUyMCUzRCUyME11c2ljZ2VuRm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm11c2ljZ2VuLXNtYWxsJTIyKS5kZWNvZGVy",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoConfig, MusicgenForCausalLM, MusicgenForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 1: get decoder config and pass to \`.from_pretrained\`</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder_config = AutoConfig.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForCausalLM.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>, **decoder_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Option 2: load the entire composite model, but only return the decoder</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = MusicgenForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;facebook/musicgen-small&quot;</span>).decoder`,wrap:!1}}),Ve=new Z({props:{title:"MusicgenDecoderConfig",local:"transformers.MusicgenDecoderConfig",headingTag:"h2"}}),Ee=new X({props:{name:"class transformers.MusicgenDecoderConfig",anchor:"transformers.MusicgenDecoderConfig",parameters:[{name:"vocab_size",val:" = 2048"},{name:"max_position_embeddings",val:" = 2048"},{name:"num_hidden_layers",val:" = 24"},{name:"ffn_dim",val:" = 4096"},{name:"num_attention_heads",val:" = 16"},{name:"layerdrop",val:" = 0.0"},{name:"use_cache",val:" = True"},{name:"activation_function",val:" = 'gelu'"},{name:"hidden_size",val:" = 1024"},{name:"dropout",val:" = 0.1"},{name:"attention_dropout",val:" = 0.0"},{name:"activation_dropout",val:" = 0.0"},{name:"initializer_factor",val:" = 0.02"},{name:"scale_embedding",val:" = False"},{name:"num_codebooks",val:" = 4"},{name:"audio_channels",val:" = 1"},{name:"pad_token_id",val:" = 2048"},{name:"bos_token_id",val:" = 2048"},{name:"eos_token_id",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenDecoderConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Vocabulary size of the MusicgenDecoder model. Defines the number of different tokens that can be
represented by the <code>inputs_ids</code> passed when calling <code>MusicgenDecoder</code>.`,name:"vocab_size"},{anchor:"transformers.MusicgenDecoderConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 1024) &#x2014;
Dimensionality of the layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.MusicgenDecoderConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of decoder layers.`,name:"num_hidden_layers"},{anchor:"transformers.MusicgenDecoderConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of attention heads for each attention layer in the Transformer block.`,name:"num_attention_heads"},{anchor:"transformers.MusicgenDecoderConfig.ffn_dim",description:`<strong>ffn_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 4096) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (often named feed-forward) layer in the Transformer block.`,name:"ffn_dim"},{anchor:"transformers.MusicgenDecoderConfig.activation_function",description:`<strong>activation_function</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;silu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"activation_function"},{anchor:"transformers.MusicgenDecoderConfig.dropout",description:`<strong>dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, text_encoder, and pooler.`,name:"dropout"},{anchor:"transformers.MusicgenDecoderConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"},{anchor:"transformers.MusicgenDecoderConfig.activation_dropout",description:`<strong>activation_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for activations inside the fully connected layer.`,name:"activation_dropout"},{anchor:"transformers.MusicgenDecoderConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Typically, set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.MusicgenDecoderConfig.initializer_factor",description:`<strong>initializer_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_factor"},{anchor:"transformers.MusicgenDecoderConfig.layerdrop",description:`<strong>layerdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The LayerDrop probability for the decoder. See the [LayerDrop paper](see <a href="https://arxiv.org/abs/1909.11556" rel="nofollow">https://arxiv.org/abs/1909.11556</a>)
for more details.`,name:"layerdrop"},{anchor:"transformers.MusicgenDecoderConfig.scale_embedding",description:`<strong>scale_embedding</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Scale embeddings by diving by sqrt(hidden_size).`,name:"scale_embedding"},{anchor:"transformers.MusicgenDecoderConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the model should return the last key/values attentions (not used by all models)`,name:"use_cache"},{anchor:"transformers.MusicgenDecoderConfig.num_codebooks",description:`<strong>num_codebooks</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
The number of parallel codebooks forwarded to the model.`,name:"num_codebooks"},{anchor:"transformers.MusicgenDecoderConfig.tie_word_embeddings(bool,",description:`<strong>tie_word_embeddings(<code>bool</code>,</strong> <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether input and output word embeddings should be tied.`,name:"tie_word_embeddings(bool,"},{anchor:"transformers.MusicgenDecoderConfig.audio_channels",description:`<strong>audio_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 1 &#x2014;
Number of channels in the audio data. Either 1 for mono or 2 for stereo. Stereo models generate a separate
audio stream for the left/right output channels. Mono models generate a single audio stream output.`,name:"audio_channels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/configuration_musicgen.py#L25"}}),Ye=new Z({props:{title:"MusicgenConfig",local:"transformers.MusicgenConfig",headingTag:"h2"}}),He=new X({props:{name:"class transformers.MusicgenConfig",anchor:"transformers.MusicgenConfig",parameters:[{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenConfig.kwargs",description:`<strong>kwargs</strong> (<em>optional</em>) &#x2014;
Dictionary of keyword arguments. Notably:</p>
<ul>
<li><strong>text_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the text encoder config.</li>
<li><strong>audio_encoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that
defines the audio encoder config.</li>
<li><strong>decoder</strong> (<a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a>, <em>optional</em>) &#x2014; An instance of a configuration object that defines
the decoder config.</li>
</ul>`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/configuration_musicgen.py#L135"}}),Y=new vs({props:{anchor:"transformers.MusicgenConfig.example",$$slots:{default:[Zs]},$$scope:{ctx:F}}}),Le=new X({props:{name:"from_sub_models_config",anchor:"transformers.MusicgenConfig.from_sub_models_config",parameters:[{name:"text_encoder_config",val:": PretrainedConfig"},{name:"audio_encoder_config",val:": PretrainedConfig"},{name:"decoder_config",val:": MusicgenDecoderConfig"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/configuration_musicgen.py#L218",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>An instance of a configuration object</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a></p>
`}}),Qe=new Z({props:{title:"MusicgenProcessor",local:"transformers.MusicgenProcessor",headingTag:"h2"}}),Se=new X({props:{name:"class transformers.MusicgenProcessor",anchor:"transformers.MusicgenProcessor",parameters:[{name:"feature_extractor",val:""},{name:"tokenizer",val:""}],parametersDescription:[{anchor:"transformers.MusicgenProcessor.feature_extractor",description:`<strong>feature_extractor</strong> (<code>EncodecFeatureExtractor</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecFeatureExtractor">EncodecFeatureExtractor</a>. The feature extractor is a required input.`,name:"feature_extractor"},{anchor:"transformers.MusicgenProcessor.tokenizer",description:`<strong>tokenizer</strong> (<code>T5Tokenizer</code>) &#x2014;
An instance of <a href="/docs/transformers/main/en/model_doc/t5#transformers.T5Tokenizer">T5Tokenizer</a>. The tokenizer is a required input.`,name:"tokenizer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/processing_musicgen.py#L27"}}),Pe=new X({props:{name:"batch_decode",anchor:"transformers.MusicgenProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/processing_musicgen.py#L91"}}),De=new X({props:{name:"decode",anchor:"transformers.MusicgenProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/processing_musicgen.py#L109"}}),Ae=new Z({props:{title:"MusicgenModel",local:"transformers.MusicgenModel",headingTag:"h2"}}),Oe=new X({props:{name:"class transformers.MusicgenModel",anchor:"transformers.MusicgenModel",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1135"}}),Ke=new X({props:{name:"forward",anchor:"transformers.MusicgenModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.MusicgenModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenModel.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1155"}}),S=new jo({props:{$$slots:{default:[$s]},$$scope:{ctx:F}}}),et=new Z({props:{title:"MusicgenForCausalLM",local:"transformers.MusicgenForCausalLM",headingTag:"h2"}}),tt=new X({props:{name:"class transformers.MusicgenForCausalLM",anchor:"transformers.MusicgenForCausalLM",parameters:[{name:"config",val:": MusicgenDecoderConfig"}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1206"}}),nt=new X({props:{name:"forward",anchor:"transformers.MusicgenForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.FloatTensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.LongTensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"cross_attn_head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>input_ids</code>.</p>

					</div>`,name:"input_ids"},{anchor:"transformers.MusicgenForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, encoder_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention of
the decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, encoder_sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing cross-attention on padding tokens indices of encoder input_ids. Mask values
selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"encoder_attention_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder to avoid performing
cross-attention on hidden heads. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.MusicgenForCausalLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1242",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),P=new jo({props:{$$slots:{default:[Gs]},$$scope:{ctx:F}}}),ot=new Z({props:{title:"MusicgenForConditionalGeneration",local:"transformers.MusicgenForConditionalGeneration",headingTag:"h2"}}),st=new X({props:{name:"class transformers.MusicgenForConditionalGeneration",anchor:"transformers.MusicgenForConditionalGeneration",parameters:[{name:"config",val:": typing.Optional[transformers.models.musicgen.configuration_musicgen.MusicgenConfig] = None"},{name:"text_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"audio_encoder",val:": typing.Optional[transformers.modeling_utils.PreTrainedModel] = None"},{name:"decoder",val:": typing.Optional[transformers.models.musicgen.modeling_musicgen.MusicgenForCausalLM] = None"}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig">MusicgenConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L1662"}}),at=new X({props:{name:"forward",anchor:"transformers.MusicgenForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"input_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"padding_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"decoder_input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"decoder_attention_mask",val:": typing.Optional[torch.BoolTensor] = None"},{name:"encoder_outputs",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"past_key_values",val:": typing.Optional[typing.Tuple[typing.Tuple[torch.FloatTensor]]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"decoder_inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.MusicgenForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_input_ids",description:`<strong>decoder_input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size * num_codebooks, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of decoder input sequence tokens in the vocabulary, corresponding to the sequence of audio codes.</p>
<p>Indices can be obtained by encoding an audio prompt with an audio encoder model to predict audio codes,
such as with the <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>. See <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel.encode">EncodecModel.encode()</a> for details.</p>
<p><a href="../glossary#decoder-input-ids">What are decoder input IDs?</a></p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>The <code>decoder_input_ids</code> will automatically be converted from shape <code>(batch_size * num_codebooks, target_sequence_length)</code> to <code>(batch_size, num_codebooks, target_sequence_length)</code> in the forward pass. If
you obtain audio codes from an audio encoding model, such as <a href="/docs/transformers/main/en/model_doc/encodec#transformers.EncodecModel">EncodecModel</a>, ensure that the number of
frames is equal to 1, and that you reshape the audio codes from <code>(frames, batch_size, num_codebooks, target_sequence_length)</code> to <code>(batch_size * num_codebooks, target_sequence_length)</code> prior to passing them as
<code>decoder_input_ids</code>.</p>

					</div>`,name:"decoder_input_ids"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_attention_mask",description:`<strong>decoder_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, target_sequence_length)</code>, <em>optional</em>) &#x2014;
Default behavior: generate a tensor that ignores pad tokens in <code>decoder_input_ids</code>. Causal mask will also
be used by default.`,name:"decoder_attention_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.Tensor</code> of shape <code>(encoder_layers, encoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the encoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_head_mask",description:`<strong>decoder_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"decoder_head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.cross_attn_head_mask",description:`<strong>cross_attn_head_mask</strong> (<code>torch.Tensor</code> of shape <code>(decoder_layers, decoder_attention_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the cross-attention modules in the decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"cross_attn_head_mask"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.encoder_outputs",description:`<strong>encoder_outputs</strong> (<code>tuple(tuple(torch.FloatTensor)</code>, <em>optional</em>) &#x2014;
Tuple consists of (<code>last_hidden_state</code>, <em>optional</em>: <code>hidden_states</code>, <em>optional</em>: <code>attentions</code>)
<code>last_hidden_state</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) is a sequence of
hidden-states at the output of the last layer of the encoder. Used in the cross-attention of the decoder.`,name:"encoder_outputs"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation.
This is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors
than the model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.decoder_inputs_embeds",description:`<strong>decoder_inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, target_sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>decoder_input_ids</code> you can choose to directly pass an embedded
representation. If <code>past_key_values</code> is used, optionally only the last <code>decoder_inputs_embeds</code> have to be
input (see <code>past_key_values</code>). This is useful if you want more control over how to convert
<code>decoder_input_ids</code> indices into associated vectors than the model&#x2019;s internal embedding lookup matrix.</p>
<p>If <code>decoder_input_ids</code> and <code>decoder_inputs_embeds</code> are both unset, <code>decoder_inputs_embeds</code> takes the value
of <code>inputs_embeds</code>.`,name:"decoder_inputs_embeds"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length, num_codebooks)</code>, <em>optional</em>) &#x2014;
Labels for language modeling. Note that the labels <strong>are shifted</strong> inside the model, i.e. you can set
<code>labels = input_ids</code> Indices are selected in <code>[-100, 0, ..., config.vocab_size]</code> All labels set to <code>-100</code>
are ignored (masked), the loss is only computed for labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.MusicgenForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/musicgen/modeling_musicgen.py#L2003",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/musicgen#transformers.MusicgenConfig"
>MusicgenConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>decoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the decoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>decoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
<li>
<p><strong>encoder_last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the encoder of the model.</p>
</li>
<li>
<p><strong>encoder_hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the encoder at the output of each layer plus the initial embedding outputs.</p>
</li>
<li>
<p><strong>encoder_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the encoder, after the attention softmax, used to compute the weighted average in the
self-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.Seq2SeqLMOutput"
>transformers.modeling_outputs.Seq2SeqLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new jo({props:{$$slots:{default:[xs]},$$scope:{ctx:F}}}),A=new vs({props:{anchor:"transformers.MusicgenForConditionalGeneration.forward.example",$$slots:{default:[Fs]},$$scope:{ctx:F}}}),rt=new Us({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/musicgen.md"}}),{c(){c=r("meta"),y=s(),M=r("p"),b=s(),m(T.$$.fragment),_=s(),j=r("div"),j.innerHTML=Co,Nt=s(),m(K.$$.fragment),Xt=s(),ee=r("p"),ee.innerHTML=Jo,Rt=s(),te=r("p"),te.innerHTML=Uo,Bt=s(),ne=r("p"),ne.textContent=Zo,qt=s(),oe=r("p"),oe.textContent=$o,Vt=s(),se=r("p"),se.innerHTML=Go,Et=s(),ae=r("p"),ae.innerHTML=xo,Yt=s(),m(re.$$.fragment),Ht=s(),ie=r("ul"),ie.innerHTML=Fo,Lt=s(),m(le.$$.fragment),Qt=s(),m(de.$$.fragment),St=s(),ce=r("p"),ce.innerHTML=Wo,Pt=s(),me=r("p"),me.textContent=zo,Dt=s(),pe=r("p"),pe.textContent=Io,At=s(),m(ue.$$.fragment),Ot=s(),he=r("p"),he.innerHTML=No,Kt=s(),m(ge.$$.fragment),en=s(),fe=r("p"),fe.innerHTML=Xo,tn=s(),m(_e.$$.fragment),nn=s(),Me=r("p"),Me.innerHTML=Ro,on=s(),m(be.$$.fragment),sn=s(),m(ye.$$.fragment),an=s(),Te=r("p"),Te.innerHTML=Bo,rn=s(),m(ve.$$.fragment),ln=s(),we=r("p"),we.innerHTML=qo,dn=s(),m(ke.$$.fragment),cn=s(),je=r("p"),je.innerHTML=Vo,mn=s(),m(Ce.$$.fragment),pn=s(),m(Je.$$.fragment),un=s(),Ue=r("p"),Ue.innerHTML=Eo,hn=s(),m(Ze.$$.fragment),gn=s(),m($e.$$.fragment),fn=s(),Ge=r("p"),Ge.textContent=Yo,_n=s(),m(xe.$$.fragment),Mn=s(),Fe=r("p"),Fe.innerHTML=Ho,bn=s(),m(We.$$.fragment),yn=s(),ze=r("p"),ze.textContent=Lo,Tn=s(),Ie=r("ol"),Ie.innerHTML=Qo,vn=s(),Ne=r("p"),Ne.innerHTML=So,wn=s(),m(Xe.$$.fragment),kn=s(),Re=r("p"),Re.innerHTML=Po,jn=s(),Be=r("p"),Be.textContent=Do,Cn=s(),qe=r("ul"),qe.innerHTML=Ao,Jn=s(),m(Ve.$$.fragment),Un=s(),B=r("div"),m(Ee.$$.fragment),En=s(),dt=r("p"),dt.innerHTML=Oo,Yn=s(),ct=r("p"),ct.innerHTML=Ko,Zn=s(),m(Ye.$$.fragment),$n=s(),C=r("div"),m(He.$$.fragment),Hn=s(),mt=r("p"),mt.innerHTML=es,Ln=s(),pt=r("p"),pt.innerHTML=ts,Qn=s(),m(Y.$$.fragment),Sn=s(),H=r("div"),m(Le.$$.fragment),Pn=s(),ut=r("p"),ut.innerHTML=ns,Gn=s(),m(Qe.$$.fragment),xn=s(),J=r("div"),m(Se.$$.fragment),Dn=s(),ht=r("p"),ht.textContent=os,An=s(),gt=r("p"),gt.innerHTML=ss,On=s(),L=r("div"),m(Pe.$$.fragment),Kn=s(),ft=r("p"),ft.innerHTML=as,eo=s(),Q=r("div"),m(De.$$.fragment),to=s(),_t=r("p"),_t.innerHTML=rs,Fn=s(),m(Ae.$$.fragment),Wn=s(),v=r("div"),m(Oe.$$.fragment),no=s(),Mt=r("p"),Mt.textContent=is,oo=s(),bt=r("p"),bt.innerHTML=ls,so=s(),yt=r("p"),yt.innerHTML=ds,ao=s(),Tt=r("p"),Tt.innerHTML=cs,ro=s(),q=r("div"),m(Ke.$$.fragment),io=s(),vt=r("p"),vt.innerHTML=ms,lo=s(),m(S.$$.fragment),zn=s(),m(et.$$.fragment),In=s(),w=r("div"),m(tt.$$.fragment),co=s(),wt=r("p"),wt.textContent=ps,mo=s(),kt=r("p"),kt.innerHTML=us,po=s(),jt=r("p"),jt.innerHTML=hs,uo=s(),Ct=r("p"),Ct.innerHTML=gs,ho=s(),V=r("div"),m(nt.$$.fragment),go=s(),Jt=r("p"),Jt.innerHTML=fs,fo=s(),m(P.$$.fragment),Nn=s(),m(ot.$$.fragment),Xn=s(),k=r("div"),m(st.$$.fragment),_o=s(),Ut=r("p"),Ut.textContent=_s,Mo=s(),Zt=r("p"),Zt.innerHTML=Ms,bo=s(),$t=r("p"),$t.innerHTML=bs,yo=s(),Gt=r("p"),Gt.innerHTML=ys,To=s(),W=r("div"),m(at.$$.fragment),vo=s(),xt=r("p"),xt.innerHTML=Ts,wo=s(),m(D.$$.fragment),ko=s(),m(A.$$.fragment),Rn=s(),m(rt.$$.fragment),Bn=s(),zt=r("p"),this.h()},l(e){const t=Js("svelte-u9bgzb",document.head);c=i(t,"META",{name:!0,content:!0}),t.forEach(n),y=a(e),M=i(e,"P",{}),$(M).forEach(n),b=a(e),p(T.$$.fragment,e),_=a(e),j=i(e,"DIV",{class:!0,"data-svelte-h":!0}),d(j)!=="svelte-b95w5j"&&(j.innerHTML=Co),Nt=a(e),p(K.$$.fragment,e),Xt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-1glsc0y"&&(ee.innerHTML=Jo),Rt=a(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-8d0j4l"&&(te.innerHTML=Uo),Bt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-cdry7g"&&(ne.textContent=Zo),qt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-vfdo9a"&&(oe.textContent=$o),Vt=a(e),se=i(e,"P",{"data-svelte-h":!0}),d(se)!=="svelte-6qc9b"&&(se.innerHTML=Go),Et=a(e),ae=i(e,"P",{"data-svelte-h":!0}),d(ae)!=="svelte-1o040cl"&&(ae.innerHTML=xo),Yt=a(e),p(re.$$.fragment,e),Ht=a(e),ie=i(e,"UL",{"data-svelte-h":!0}),d(ie)!=="svelte-12e77r4"&&(ie.innerHTML=Fo),Lt=a(e),p(le.$$.fragment,e),Qt=a(e),p(de.$$.fragment,e),St=a(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-1rrub89"&&(ce.innerHTML=Wo),Pt=a(e),me=i(e,"P",{"data-svelte-h":!0}),d(me)!=="svelte-1tppmp9"&&(me.textContent=zo),Dt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1e09glx"&&(pe.textContent=Io),At=a(e),p(ue.$$.fragment,e),Ot=a(e),he=i(e,"P",{"data-svelte-h":!0}),d(he)!=="svelte-hslupw"&&(he.innerHTML=No),Kt=a(e),p(ge.$$.fragment,e),en=a(e),fe=i(e,"P",{"data-svelte-h":!0}),d(fe)!=="svelte-c9ap2j"&&(fe.innerHTML=Xo),tn=a(e),p(_e.$$.fragment,e),nn=a(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-1endcdl"&&(Me.innerHTML=Ro),on=a(e),p(be.$$.fragment,e),sn=a(e),p(ye.$$.fragment,e),an=a(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-1lsquh5"&&(Te.innerHTML=Bo),rn=a(e),p(ve.$$.fragment,e),ln=a(e),we=i(e,"P",{"data-svelte-h":!0}),d(we)!=="svelte-78k595"&&(we.innerHTML=qo),dn=a(e),p(ke.$$.fragment,e),cn=a(e),je=i(e,"P",{"data-svelte-h":!0}),d(je)!=="svelte-6hk8z3"&&(je.innerHTML=Vo),mn=a(e),p(Ce.$$.fragment,e),pn=a(e),p(Je.$$.fragment,e),un=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),d(Ue)!=="svelte-1sawt4q"&&(Ue.innerHTML=Eo),hn=a(e),p(Ze.$$.fragment,e),gn=a(e),p($e.$$.fragment,e),fn=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),d(Ge)!=="svelte-1qo0662"&&(Ge.textContent=Yo),_n=a(e),p(xe.$$.fragment,e),Mn=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),d(Fe)!=="svelte-132s853"&&(Fe.innerHTML=Ho),bn=a(e),p(We.$$.fragment,e),yn=a(e),ze=i(e,"P",{"data-svelte-h":!0}),d(ze)!=="svelte-52mell"&&(ze.textContent=Lo),Tn=a(e),Ie=i(e,"OL",{"data-svelte-h":!0}),d(Ie)!=="svelte-12ipaq0"&&(Ie.innerHTML=Qo),vn=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-153gzk7"&&(Ne.innerHTML=So),wn=a(e),p(Xe.$$.fragment,e),kn=a(e),Re=i(e,"P",{"data-svelte-h":!0}),d(Re)!=="svelte-1sxrkse"&&(Re.innerHTML=Po),jn=a(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-axv494"&&(Be.textContent=Do),Cn=a(e),qe=i(e,"UL",{"data-svelte-h":!0}),d(qe)!=="svelte-1upux1z"&&(qe.innerHTML=Ao),Jn=a(e),p(Ve.$$.fragment,e),Un=a(e),B=i(e,"DIV",{class:!0});var E=$(B);p(Ee.$$.fragment,E),En=a(E),dt=i(E,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-13s74fx"&&(dt.innerHTML=Oo),Yn=a(E),ct=i(E,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-o55m63"&&(ct.innerHTML=Ko),E.forEach(n),Zn=a(e),p(Ye.$$.fragment,e),$n=a(e),C=i(e,"DIV",{class:!0});var G=$(C);p(He.$$.fragment,G),Hn=a(G),mt=i(G,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-wifzd"&&(mt.innerHTML=es),Ln=a(G),pt=i(G,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-o55m63"&&(pt.innerHTML=ts),Qn=a(G),p(Y.$$.fragment,G),Sn=a(G),H=i(G,"DIV",{class:!0});var it=$(H);p(Le.$$.fragment,it),Pn=a(it),ut=i(it,"P",{"data-svelte-h":!0}),d(ut)!=="svelte-1rh3axm"&&(ut.innerHTML=ns),it.forEach(n),G.forEach(n),Gn=a(e),p(Qe.$$.fragment,e),xn=a(e),J=i(e,"DIV",{class:!0});var x=$(J);p(Se.$$.fragment,x),Dn=a(x),ht=i(x,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-12wttjh"&&(ht.textContent=os),An=a(x),gt=i(x,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-11tke2g"&&(gt.innerHTML=ss),On=a(x),L=i(x,"DIV",{class:!0});var lt=$(L);p(Pe.$$.fragment,lt),Kn=a(lt),ft=i(lt,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-b90dsi"&&(ft.innerHTML=as),lt.forEach(n),eo=a(x),Q=i(x,"DIV",{class:!0});var Vn=$(Q);p(De.$$.fragment,Vn),to=a(Vn),_t=i(Vn,"P",{"data-svelte-h":!0}),d(_t)!=="svelte-xtplha"&&(_t.innerHTML=rs),Vn.forEach(n),x.forEach(n),Fn=a(e),p(Ae.$$.fragment,e),Wn=a(e),v=i(e,"DIV",{class:!0});var z=$(v);p(Oe.$$.fragment,z),no=a(z),Mt=i(z,"P",{"data-svelte-h":!0}),d(Mt)!=="svelte-kxc9tj"&&(Mt.textContent=is),oo=a(z),bt=i(z,"P",{"data-svelte-h":!0}),d(bt)!=="svelte-57mglp"&&(bt.innerHTML=ls),so=a(z),yt=i(z,"P",{"data-svelte-h":!0}),d(yt)!=="svelte-6pahdo"&&(yt.innerHTML=ds),ao=a(z),Tt=i(z,"P",{"data-svelte-h":!0}),d(Tt)!=="svelte-hswkmf"&&(Tt.innerHTML=cs),ro=a(z),q=i(z,"DIV",{class:!0});var Ft=$(q);p(Ke.$$.fragment,Ft),io=a(Ft),vt=i(Ft,"P",{"data-svelte-h":!0}),d(vt)!=="svelte-dfxyle"&&(vt.innerHTML=ms),lo=a(Ft),p(S.$$.fragment,Ft),Ft.forEach(n),z.forEach(n),zn=a(e),p(et.$$.fragment,e),In=a(e),w=i(e,"DIV",{class:!0});var I=$(w);p(tt.$$.fragment,I),co=a(I),wt=i(I,"P",{"data-svelte-h":!0}),d(wt)!=="svelte-1l370y5"&&(wt.textContent=ps),mo=a(I),kt=i(I,"P",{"data-svelte-h":!0}),d(kt)!=="svelte-57mglp"&&(kt.innerHTML=us),po=a(I),jt=i(I,"P",{"data-svelte-h":!0}),d(jt)!=="svelte-6pahdo"&&(jt.innerHTML=hs),uo=a(I),Ct=i(I,"P",{"data-svelte-h":!0}),d(Ct)!=="svelte-hswkmf"&&(Ct.innerHTML=gs),ho=a(I),V=i(I,"DIV",{class:!0});var Wt=$(V);p(nt.$$.fragment,Wt),go=a(Wt),Jt=i(Wt,"P",{"data-svelte-h":!0}),d(Jt)!=="svelte-102g1jm"&&(Jt.innerHTML=fs),fo=a(Wt),p(P.$$.fragment,Wt),Wt.forEach(n),I.forEach(n),Nn=a(e),p(ot.$$.fragment,e),Xn=a(e),k=i(e,"DIV",{class:!0});var N=$(k);p(st.$$.fragment,N),_o=a(N),Ut=i(N,"P",{"data-svelte-h":!0}),d(Ut)!=="svelte-r0yen0"&&(Ut.textContent=_s),Mo=a(N),Zt=i(N,"P",{"data-svelte-h":!0}),d(Zt)!=="svelte-57mglp"&&(Zt.innerHTML=Ms),bo=a(N),$t=i(N,"P",{"data-svelte-h":!0}),d($t)!=="svelte-6pahdo"&&($t.innerHTML=bs),yo=a(N),Gt=i(N,"P",{"data-svelte-h":!0}),d(Gt)!=="svelte-hswkmf"&&(Gt.innerHTML=ys),To=a(N),W=i(N,"DIV",{class:!0});var O=$(W);p(at.$$.fragment,O),vo=a(O),xt=i(O,"P",{"data-svelte-h":!0}),d(xt)!=="svelte-wf1hrq"&&(xt.innerHTML=Ts),wo=a(O),p(D.$$.fragment,O),ko=a(O),p(A.$$.fragment,O),O.forEach(n),N.forEach(n),Rn=a(e),p(rt.$$.fragment,e),Bn=a(e),zt=i(e,"P",{}),$(zt).forEach(n),this.h()},h(){U(c,"name","hf:doc:metadata"),U(c,"content",zs),U(j,"class","flex flex-wrap space-x-1"),U(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),U(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){l(document.head,c),o(e,y,t),o(e,M,t),o(e,b,t),u(T,e,t),o(e,_,t),o(e,j,t),o(e,Nt,t),u(K,e,t),o(e,Xt,t),o(e,ee,t),o(e,Rt,t),o(e,te,t),o(e,Bt,t),o(e,ne,t),o(e,qt,t),o(e,oe,t),o(e,Vt,t),o(e,se,t),o(e,Et,t),o(e,ae,t),o(e,Yt,t),u(re,e,t),o(e,Ht,t),o(e,ie,t),o(e,Lt,t),u(le,e,t),o(e,Qt,t),u(de,e,t),o(e,St,t),o(e,ce,t),o(e,Pt,t),o(e,me,t),o(e,Dt,t),o(e,pe,t),o(e,At,t),u(ue,e,t),o(e,Ot,t),o(e,he,t),o(e,Kt,t),u(ge,e,t),o(e,en,t),o(e,fe,t),o(e,tn,t),u(_e,e,t),o(e,nn,t),o(e,Me,t),o(e,on,t),u(be,e,t),o(e,sn,t),u(ye,e,t),o(e,an,t),o(e,Te,t),o(e,rn,t),u(ve,e,t),o(e,ln,t),o(e,we,t),o(e,dn,t),u(ke,e,t),o(e,cn,t),o(e,je,t),o(e,mn,t),u(Ce,e,t),o(e,pn,t),u(Je,e,t),o(e,un,t),o(e,Ue,t),o(e,hn,t),u(Ze,e,t),o(e,gn,t),u($e,e,t),o(e,fn,t),o(e,Ge,t),o(e,_n,t),u(xe,e,t),o(e,Mn,t),o(e,Fe,t),o(e,bn,t),u(We,e,t),o(e,yn,t),o(e,ze,t),o(e,Tn,t),o(e,Ie,t),o(e,vn,t),o(e,Ne,t),o(e,wn,t),u(Xe,e,t),o(e,kn,t),o(e,Re,t),o(e,jn,t),o(e,Be,t),o(e,Cn,t),o(e,qe,t),o(e,Jn,t),u(Ve,e,t),o(e,Un,t),o(e,B,t),u(Ee,B,null),l(B,En),l(B,dt),l(B,Yn),l(B,ct),o(e,Zn,t),u(Ye,e,t),o(e,$n,t),o(e,C,t),u(He,C,null),l(C,Hn),l(C,mt),l(C,Ln),l(C,pt),l(C,Qn),u(Y,C,null),l(C,Sn),l(C,H),u(Le,H,null),l(H,Pn),l(H,ut),o(e,Gn,t),u(Qe,e,t),o(e,xn,t),o(e,J,t),u(Se,J,null),l(J,Dn),l(J,ht),l(J,An),l(J,gt),l(J,On),l(J,L),u(Pe,L,null),l(L,Kn),l(L,ft),l(J,eo),l(J,Q),u(De,Q,null),l(Q,to),l(Q,_t),o(e,Fn,t),u(Ae,e,t),o(e,Wn,t),o(e,v,t),u(Oe,v,null),l(v,no),l(v,Mt),l(v,oo),l(v,bt),l(v,so),l(v,yt),l(v,ao),l(v,Tt),l(v,ro),l(v,q),u(Ke,q,null),l(q,io),l(q,vt),l(q,lo),u(S,q,null),o(e,zn,t),u(et,e,t),o(e,In,t),o(e,w,t),u(tt,w,null),l(w,co),l(w,wt),l(w,mo),l(w,kt),l(w,po),l(w,jt),l(w,uo),l(w,Ct),l(w,ho),l(w,V),u(nt,V,null),l(V,go),l(V,Jt),l(V,fo),u(P,V,null),o(e,Nn,t),u(ot,e,t),o(e,Xn,t),o(e,k,t),u(st,k,null),l(k,_o),l(k,Ut),l(k,Mo),l(k,Zt),l(k,bo),l(k,$t),l(k,yo),l(k,Gt),l(k,To),l(k,W),u(at,W,null),l(W,vo),l(W,xt),l(W,wo),u(D,W,null),l(W,ko),u(A,W,null),o(e,Rn,t),u(rt,e,t),o(e,Bn,t),o(e,zt,t),qn=!0},p(e,[t]){const E={};t&2&&(E.$$scope={dirty:t,ctx:e}),Y.$set(E);const G={};t&2&&(G.$$scope={dirty:t,ctx:e}),S.$set(G);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),P.$set(it);const x={};t&2&&(x.$$scope={dirty:t,ctx:e}),D.$set(x);const lt={};t&2&&(lt.$$scope={dirty:t,ctx:e}),A.$set(lt)},i(e){qn||(h(T.$$.fragment,e),h(K.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),h(ue.$$.fragment,e),h(ge.$$.fragment,e),h(_e.$$.fragment,e),h(be.$$.fragment,e),h(ye.$$.fragment,e),h(ve.$$.fragment,e),h(ke.$$.fragment,e),h(Ce.$$.fragment,e),h(Je.$$.fragment,e),h(Ze.$$.fragment,e),h($e.$$.fragment,e),h(xe.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ve.$$.fragment,e),h(Ee.$$.fragment,e),h(Ye.$$.fragment,e),h(He.$$.fragment,e),h(Y.$$.fragment,e),h(Le.$$.fragment,e),h(Qe.$$.fragment,e),h(Se.$$.fragment,e),h(Pe.$$.fragment,e),h(De.$$.fragment,e),h(Ae.$$.fragment,e),h(Oe.$$.fragment,e),h(Ke.$$.fragment,e),h(S.$$.fragment,e),h(et.$$.fragment,e),h(tt.$$.fragment,e),h(nt.$$.fragment,e),h(P.$$.fragment,e),h(ot.$$.fragment,e),h(st.$$.fragment,e),h(at.$$.fragment,e),h(D.$$.fragment,e),h(A.$$.fragment,e),h(rt.$$.fragment,e),qn=!0)},o(e){g(T.$$.fragment,e),g(K.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(de.$$.fragment,e),g(ue.$$.fragment,e),g(ge.$$.fragment,e),g(_e.$$.fragment,e),g(be.$$.fragment,e),g(ye.$$.fragment,e),g(ve.$$.fragment,e),g(ke.$$.fragment,e),g(Ce.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g($e.$$.fragment,e),g(xe.$$.fragment,e),g(We.$$.fragment,e),g(Xe.$$.fragment,e),g(Ve.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(He.$$.fragment,e),g(Y.$$.fragment,e),g(Le.$$.fragment,e),g(Qe.$$.fragment,e),g(Se.$$.fragment,e),g(Pe.$$.fragment,e),g(De.$$.fragment,e),g(Ae.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(S.$$.fragment,e),g(et.$$.fragment,e),g(tt.$$.fragment,e),g(nt.$$.fragment,e),g(P.$$.fragment,e),g(ot.$$.fragment,e),g(st.$$.fragment,e),g(at.$$.fragment,e),g(D.$$.fragment,e),g(A.$$.fragment,e),g(rt.$$.fragment,e),qn=!1},d(e){e&&(n(y),n(M),n(b),n(_),n(j),n(Nt),n(Xt),n(ee),n(Rt),n(te),n(Bt),n(ne),n(qt),n(oe),n(Vt),n(se),n(Et),n(ae),n(Yt),n(Ht),n(ie),n(Lt),n(Qt),n(St),n(ce),n(Pt),n(me),n(Dt),n(pe),n(At),n(Ot),n(he),n(Kt),n(en),n(fe),n(tn),n(nn),n(Me),n(on),n(sn),n(an),n(Te),n(rn),n(ln),n(we),n(dn),n(cn),n(je),n(mn),n(pn),n(un),n(Ue),n(hn),n(gn),n(fn),n(Ge),n(_n),n(Mn),n(Fe),n(bn),n(yn),n(ze),n(Tn),n(Ie),n(vn),n(Ne),n(wn),n(kn),n(Re),n(jn),n(Be),n(Cn),n(qe),n(Jn),n(Un),n(B),n(Zn),n($n),n(C),n(Gn),n(xn),n(J),n(Fn),n(Wn),n(v),n(zn),n(In),n(w),n(Nn),n(Xn),n(k),n(Rn),n(Bn),n(zt)),n(c),f(T,e),f(K,e),f(re,e),f(le,e),f(de,e),f(ue,e),f(ge,e),f(_e,e),f(be,e),f(ye,e),f(ve,e),f(ke,e),f(Ce,e),f(Je,e),f(Ze,e),f($e,e),f(xe,e),f(We,e),f(Xe,e),f(Ve,e),f(Ee),f(Ye,e),f(He),f(Y),f(Le),f(Qe,e),f(Se),f(Pe),f(De),f(Ae,e),f(Oe),f(Ke),f(S),f(et,e),f(tt),f(nt),f(P),f(ot,e),f(st),f(at),f(D),f(A),f(rt,e)}}}const zs='{"title":"MusicGen","local":"musicgen","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Generation","local":"generation","sections":[{"title":"Unconditional Generation","local":"unconditional-generation","sections":[],"depth":3},{"title":"Text-Conditional Generation","local":"text-conditional-generation","sections":[],"depth":3},{"title":"Audio-Prompted Generation","local":"audio-prompted-generation","sections":[],"depth":3},{"title":"Generation Configuration","local":"generation-configuration","sections":[],"depth":3}],"depth":2},{"title":"Model Structure","local":"model-structure","sections":[],"depth":2},{"title":"MusicgenDecoderConfig","local":"transformers.MusicgenDecoderConfig","sections":[],"depth":2},{"title":"MusicgenConfig","local":"transformers.MusicgenConfig","sections":[],"depth":2},{"title":"MusicgenProcessor","local":"transformers.MusicgenProcessor","sections":[],"depth":2},{"title":"MusicgenModel","local":"transformers.MusicgenModel","sections":[],"depth":2},{"title":"MusicgenForCausalLM","local":"transformers.MusicgenForCausalLM","sections":[],"depth":2},{"title":"MusicgenForConditionalGeneration","local":"transformers.MusicgenForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Is(F){return ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends js{constructor(c){super(),Cs(this,c,Is,Ws,ws,{})}}export{Hs as component};
