import{s as On,o as Dn,n as rt}from"../chunks/scheduler.18a86fab.js";import{S as Rn,i as Xn,g as i,s,r as u,A as Vn,h as l,f as n,c as r,j as x,u as f,x as m,k as M,y as o,a as d,v as g,d as _,t as k,w as b}from"../chunks/index.98837b22.js";import{T as fn}from"../chunks/Tip.77304350.js";import{D as z}from"../chunks/Docstring.6758ea23.js";import{C as _n}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as gn}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H}from"../chunks/Heading.7e7e0c5b.js";import{E as Yn}from"../chunks/index.499f366c.js";function Kn(S){let a,T="Example:",p,h,y;return h=new _n({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFNwbGludGVyTW9kZWwlMkMlMjBTcGxpbnRlckNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBTcGxpbnRlciUyMHRhdSUyRnNwbGludGVyLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwU3BsaW50ZXJDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB0YXUlMkZzcGxpbnRlci1iYXNlJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBTcGxpbnRlck1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> SplinterModel, SplinterConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Splinter tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = SplinterConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the tau/splinter-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=i("p"),a.textContent=T,p=s(),u(h.$$.fragment)},l(c){a=l(c,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=T),p=r(c),f(h.$$.fragment,c)},m(c,w){d(c,a,w),d(c,p,w),g(h,c,w),y=!0},p:rt,i(c){y||(_(h.$$.fragment,c),y=!0)},o(c){k(h.$$.fragment,c),y=!1},d(c){c&&(n(a),n(p)),b(h,c)}}}function eo(S){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=T},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(p,h){d(p,a,h)},p:rt,d(p){p&&n(a)}}}function to(S){let a,T="Example:",p,h,y;return h=new _n({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlck1vZGVsJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIySGVsbG8lMkMlMjBteSUyMGRvZyUyMGlzJTIwY3V0ZSUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGU=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterModel.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state`,wrap:!1}}),{c(){a=i("p"),a.textContent=T,p=s(),u(h.$$.fragment)},l(c){a=l(c,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=T),p=r(c),f(h.$$.fragment,c)},m(c,w){d(c,a,w),d(c,p,w),g(h,c,w),y=!0},p:rt,i(c){y||(_(h.$$.fragment,c),y=!0)},o(c){k(h.$$.fragment,c),y=!1},d(c){c&&(n(a),n(p)),b(h,c)}}}function no(S){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=T},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(p,h){d(p,a,h)},p:rt,d(p){p&&n(a)}}}function oo(S){let a,T="Example:",p,h,y;return h=new _n({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBTcGxpbnRlckZvclF1ZXN0aW9uQW5zd2VyaW5nJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0YXUlMkZzcGxpbnRlci1iYXNlJTIyKSUwQW1vZGVsJTIwJTNEJTIwU3BsaW50ZXJGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIydGF1JTJGc3BsaW50ZXItYmFzZSUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJXaG8lMjB3YXMlMjBKaW0lMjBIZW5zb24lM0YlMjIlMkMlMjAlMjJKaW0lMjBIZW5zb24lMjB3YXMlMjBhJTIwbmljZSUyMHB1cHBldCUyMiUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihxdWVzdGlvbiUyQyUyMHRleHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQXdpdGglMjB0b3JjaC5ub19ncmFkKCklM0ElMEElMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBJTBBYW5zd2VyX3N0YXJ0X2luZGV4JTIwJTNEJTIwb3V0cHV0cy5zdGFydF9sb2dpdHMuYXJnbWF4KCklMEFhbnN3ZXJfZW5kX2luZGV4JTIwJTNEJTIwb3V0cHV0cy5lbmRfbG9naXRzLmFyZ21heCgpJTBBJTBBcHJlZGljdF9hbnN3ZXJfdG9rZW5zJTIwJTNEJTIwaW5wdXRzLmlucHV0X2lkcyU1QjAlMkMlMjBhbnN3ZXJfc3RhcnRfaW5kZXglMjAlM0ElMjBhbnN3ZXJfZW5kX2luZGV4JTIwJTJCJTIwMSU1RCUwQSUwQSUyMyUyMHRhcmdldCUyMGlzJTIwJTIybmljZSUyMHB1cHBldCUyMiUwQXRhcmdldF9zdGFydF9pbmRleCUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUIxNCU1RCklMEF0YXJnZXRfZW5kX2luZGV4JTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjE1JTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHRhcmdldF9zdGFydF9pbmRleCUyQyUyMGVuZF9wb3NpdGlvbnMlM0R0YXJnZXRfZW5kX2luZGV4KSUwQWxvc3MlMjAlM0QlMjBvdXRwdXRzLmxvc3M=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, SplinterForQuestionAnswering
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = SplinterForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;tau/splinter-base&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Who was Jim Henson?&quot;</span>, <span class="hljs-string">&quot;Jim Henson was a nice puppet&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>answer_start_index = outputs.start_logits.argmax()
<span class="hljs-meta">&gt;&gt;&gt; </span>answer_end_index = outputs.end_logits.argmax()

<span class="hljs-meta">&gt;&gt;&gt; </span>predict_answer_tokens = inputs.input_ids[<span class="hljs-number">0</span>, answer_start_index : answer_end_index + <span class="hljs-number">1</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># target is &quot;nice puppet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_start_index = torch.tensor([<span class="hljs-number">14</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>target_end_index = torch.tensor([<span class="hljs-number">15</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=target_start_index, end_positions=target_end_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss`,wrap:!1}}),{c(){a=i("p"),a.textContent=T,p=s(),u(h.$$.fragment)},l(c){a=l(c,"P",{"data-svelte-h":!0}),m(a)!=="svelte-11lpom8"&&(a.textContent=T),p=r(c),f(h.$$.fragment,c)},m(c,w){d(c,a,w),d(c,p,w),g(h,c,w),y=!0},p:rt,i(c){y||(_(h.$$.fragment,c),y=!0)},o(c){k(h.$$.fragment,c),y=!1},d(c){c&&(n(a),n(p)),b(h,c)}}}function so(S){let a,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=i("p"),a.innerHTML=T},l(p){a=l(p,"P",{"data-svelte-h":!0}),m(a)!=="svelte-fincs2"&&(a.innerHTML=T)},m(p,h){d(p,a,h)},p:rt,d(p){p&&n(a)}}}function ro(S){let a,T,p,h,y,c,w,kn='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',lt,oe,dt,se,bn=`The Splinter model was proposed in <a href="https://arxiv.org/abs/2101.00438" rel="nofollow">Few-Shot Question Answering by Pretraining Span Selection</a> by Ori Ram, Yuval Kirstain, Jonathan Berant, Amir Globerson, Omer Levy. Splinter
is an encoder-only transformer (similar to BERT) pretrained using the recurring span selection task on a large corpus
comprising Wikipedia and the Toronto Book Corpus.`,ct,re,Tn="The abstract from the paper is the following:",pt,ae,yn=`In several question answering benchmarks, pretrained models have reached human parity through fine-tuning on an order
of 100,000 annotated questions and answers. We explore the more realistic few-shot setting, where only a few hundred
training examples are available, and observe that standard models perform poorly, highlighting the discrepancy between
current pretraining objectives and question answering. We propose a new pretraining scheme tailored for question
answering: recurring span selection. Given a passage with multiple sets of recurring spans, we mask in each set all
recurring spans but one, and ask the model to select the correct span in the passage for each masked span. Masked spans
are replaced with a special token, viewed as a question representation, that is later used during fine-tuning to select
the answer span. The resulting model obtains surprisingly good results on multiple benchmarks (e.g., 72.7 F1 on SQuAD
with only 128 training examples), while maintaining competitive performance in the high-resource setting.`,mt,ie,wn='This model was contributed by <a href="https://huggingface.co/yuvalkirstain" rel="nofollow">yuvalkirstain</a> and <a href="https://huggingface.co/oriram" rel="nofollow">oriram</a>. The original code can be found <a href="https://github.com/oriram/splinter" rel="nofollow">here</a>.',ht,le,ut,de,vn=`<li>Splinter was trained to predict answers spans conditioned on a special [QUESTION] token. These tokens contextualize
to question representations which are used to predict the answers. This layer is called QASS, and is the default
behaviour in the <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> class. Therefore:</li> <li>Use <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterTokenizer">SplinterTokenizer</a> (rather than <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>), as it already
contains this special token. Also, its default behavior is to use this token when two sequences are given (for
example, in the <em>run_qa.py</em> script).</li> <li>If you plan on using Splinter outside <em>run_qa.py</em>, please keep in mind the question token - it might be important for
the success of your model, especially in a few-shot setting.</li> <li>Please note there are two different checkpoints for each size of Splinter. Both are basically the same, except that
one also has the pretrained weights of the QASS layer (<em>tau/splinter-base-qass</em> and <em>tau/splinter-large-qass</em>) and one
doesn’t (<em>tau/splinter-base</em> and <em>tau/splinter-large</em>). This is done to support randomly initializing this layer at
fine-tuning, as it is shown to yield better results for some cases in the paper.</li>`,ft,ce,gt,pe,$n='<li><a href="../tasks/question-answering">Question answering task guide</a></li>',_t,me,kt,q,he,Lt,Pe,Mn=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>. It is used to instantiate an
Splinter model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the Splinter
<a href="https://huggingface.co/tau/splinter-base" rel="nofollow">tau/splinter-base</a> architecture.`,It,Ue,xn=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Pt,E,bt,ue,Tt,v,fe,Ut,je,Sn="Construct a Splinter tokenizer. Based on WordPiece.",jt,We,zn=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Wt,W,ge,Jt,Je,qn=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,At,Ae,Cn="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",Nt,Q,_e,Ht,Ne,Fn=`Retrieve sequence ids from a token list that has no special tokens added. This method is called when adding
special tokens using the tokenizer <code>prepare_for_model</code> method.`,Bt,J,ke,Zt,He,Ln=`Create the token type IDs corresponding to the sequences passed. <a href="../glossary#token-type-ids">What are token type
IDs?</a>`,Et,Be,In="Should be overridden in a subclass if the model has a special way of building those.",Qt,Ze,be,yt,Te,wt,C,ye,Gt,Ee,Pn="Construct a “fast” Splinter tokenizer (backed by HuggingFace’s <em>tokenizers</em> library). Based on WordPiece.",Ot,Qe,Un=`This tokenizer inherits from <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a> which contains most of the main methods. Users should
refer to this superclass for more information regarding those methods.`,Dt,A,we,Rt,Ge,jn=`Build model inputs from a pair of sequence for question answering tasks by concatenating and adding special
tokens. A Splinter sequence has the following format:`,Xt,Oe,Wn="<li>single sequence: <code>[CLS] X [SEP]</code></li> <li>pair of sequences for question answering: <code>[CLS] question_tokens [QUESTION] . [SEP] context_tokens [SEP]</code></li>",vt,ve,$t,F,$e,Vt,De,Jn=`The bare Splinter Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Yt,Re,An=`The model is an encoder (with only self-attention) following the architecture described in <a href="https://arxiv.org/abs/1706.03762" rel="nofollow">Attention is all you
need</a> by Ashish Vaswani, Noam Shazeer, Niki Parmar, Jakob Uszkoreit, Llion Jones,
Aidan N. Gomez, Lukasz Kaiser and Illia Polosukhin.`,Kt,P,Me,en,Xe,Nn='The <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a> forward method, overrides the <code>__call__</code> special method.',tn,G,nn,O,Mt,xe,xt,L,Se,on,Ve,Hn=`Splinter Model with a span classification head on top for extractive question-answering tasks like SQuAD (a linear
layers on top of the hidden-states output to compute <code>span start logits</code> and <code>span end logits</code>).`,sn,Ye,Bn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,rn,U,ze,an,Ke,Zn='The <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForQuestionAnswering">SplinterForQuestionAnswering</a> forward method, overrides the <code>__call__</code> special method.',ln,D,dn,R,St,qe,zt,I,Ce,cn,et,En=`Splinter Model for the recurring span selection task as done during the pretraining. The difference to the QA task
is that we do not have a question, but multiple question tokens that replace the occurrences of recurring spans
instead.`,pn,tt,Qn=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,mn,N,Fe,hn,nt,Gn='The <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterForPreTraining">SplinterForPreTraining</a> forward method, overrides the <code>__call__</code> special method.',un,X,qt,Le,Ct,at,Ft;return y=new H({props:{title:"Splinter",local:"splinter",headingTag:"h1"}}),oe=new H({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new H({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ce=new H({props:{title:"Resources",local:"resources",headingTag:"h2"}}),me=new H({props:{title:"SplinterConfig",local:"transformers.SplinterConfig",headingTag:"h2"}}),he=new z({props:{name:"class transformers.SplinterConfig",anchor:"transformers.SplinterConfig",parameters:[{name:"vocab_size",val:" = 30522"},{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.1"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"max_position_embeddings",val:" = 512"},{name:"type_vocab_size",val:" = 2"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = 0"},{name:"question_token_id",val:" = 104"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 30522) &#x2014;
Vocabulary size of the Splinter model. Defines the number of different tokens that can be represented by
the <code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"vocab_size"},{anchor:"transformers.SplinterConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.SplinterConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.SplinterConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.SplinterConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimension of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.SplinterConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.SplinterConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.SplinterConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.SplinterConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
The maximum sequence length that this model might ever be used with. Typically set this to something large
just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.SplinterConfig.type_vocab_size",description:`<strong>type_vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The vocabulary size of the <code>token_type_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterModel">SplinterModel</a>.`,name:"type_vocab_size"},{anchor:"transformers.SplinterConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.SplinterConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.SplinterConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.SplinterConfig.question_token_id",description:`<strong>question_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 104) &#x2014;
The id of the <code>[QUESTION]</code> token.`,name:"question_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/configuration_splinter.py#L24"}}),E=new gn({props:{anchor:"transformers.SplinterConfig.example",$$slots:{default:[Kn]},$$scope:{ctx:S}}}),ue=new H({props:{title:"SplinterTokenizer",local:"transformers.SplinterTokenizer",headingTag:"h2"}}),fe=new z({props:{name:"class transformers.SplinterTokenizer",anchor:"transformers.SplinterTokenizer",parameters:[{name:"vocab_file",val:""},{name:"do_lower_case",val:" = True"},{name:"do_basic_tokenize",val:" = True"},{name:"never_split",val:" = None"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizer.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizer.do_basic_tokenize",description:`<strong>do_basic_tokenize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to do basic tokenization before WordPiece.`,name:"do_basic_tokenize"},{anchor:"transformers.SplinterTokenizer.never_split",description:`<strong>never_split</strong> (<code>Iterable</code>, <em>optional</em>) &#x2014;
Collection of tokens which will never be split during tokenization. Only has an effect when
<code>do_basic_tokenize=True</code>`,name:"never_split"},{anchor:"transformers.SplinterTokenizer.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizer.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizer.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters.</p>
<p>This should likely be deactivated for Japanese (see this
<a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizer.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L52"}}),ge=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L191",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),_e=new z({props:{name:"get_special_tokens_mask",anchor:"transformers.SplinterTokenizer.get_special_tokens_mask",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"},{name:"already_has_special_tokens",val:": bool = False"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
List of IDs.`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
Optional second list of IDs for sequence pairs.`,name:"token_ids_1"},{anchor:"transformers.SplinterTokenizer.get_special_tokens_mask.already_has_special_tokens",description:`<strong>already_has_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the token list is already formatted with special tokens for the model.`,name:"already_has_special_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of integers in the range [0, 1]: 1 for a special token, 0 for a sequence token.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ke=new z({props:{name:"create_token_type_ids_from_sequences",anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_0",description:"<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014; The first tokenized sequence.",name:"token_ids_0"},{anchor:"transformers.SplinterTokenizer.create_token_type_ids_from_sequences.token_ids_1",description:"<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014; The second tokenized sequence.",name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L251",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The token type ids.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),be=new z({props:{name:"save_vocabulary",anchor:"transformers.SplinterTokenizer.save_vocabulary",parameters:[{name:"save_directory",val:": str"},{name:"filename_prefix",val:": typing.Optional[str] = None"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter.py#L280"}}),Te=new H({props:{title:"SplinterTokenizerFast",local:"transformers.SplinterTokenizerFast",headingTag:"h2"}}),ye=new z({props:{name:"class transformers.SplinterTokenizerFast",anchor:"transformers.SplinterTokenizerFast",parameters:[{name:"vocab_file",val:" = None"},{name:"tokenizer_file",val:" = None"},{name:"do_lower_case",val:" = True"},{name:"unk_token",val:" = '[UNK]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"pad_token",val:" = '[PAD]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"question_token",val:" = '[QUESTION]'"},{name:"tokenize_chinese_chars",val:" = True"},{name:"strip_accents",val:" = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.vocab_file",description:`<strong>vocab_file</strong> (<code>str</code>) &#x2014;
File containing the vocabulary.`,name:"vocab_file"},{anchor:"transformers.SplinterTokenizerFast.do_lower_case",description:`<strong>do_lower_case</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to lowercase the input when tokenizing.`,name:"do_lower_case"},{anchor:"transformers.SplinterTokenizerFast.unk_token",description:`<strong>unk_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[UNK]&quot;</code>) &#x2014;
The unknown token. A token that is not in the vocabulary cannot be converted to an ID and is set to be this
token instead.`,name:"unk_token"},{anchor:"transformers.SplinterTokenizerFast.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from multiple sequences, e.g. two sequences for
sequence classification or for a text and a question for question answering. It is also used as the last
token of a sequence built with special tokens.`,name:"sep_token"},{anchor:"transformers.SplinterTokenizerFast.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.SplinterTokenizerFast.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The classifier token which is used when doing sequence classification (classification of the whole sequence
instead of per-token classification). It is the first token of the sequence when built with special tokens.`,name:"cls_token"},{anchor:"transformers.SplinterTokenizerFast.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The token used for masking values. This is the token used when training this model with masked language
modeling. This is the token which the model will try to predict.`,name:"mask_token"},{anchor:"transformers.SplinterTokenizerFast.question_token",description:`<strong>question_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[QUESTION]&quot;</code>) &#x2014;
The token used for constructing question representations.`,name:"question_token"},{anchor:"transformers.SplinterTokenizerFast.clean_text",description:`<strong>clean_text</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to clean the text before tokenization by removing any control characters and replacing all
whitespaces by the classic one.`,name:"clean_text"},{anchor:"transformers.SplinterTokenizerFast.tokenize_chinese_chars",description:`<strong>tokenize_chinese_chars</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to tokenize Chinese characters. This should likely be deactivated for Japanese (see <a href="https://github.com/huggingface/transformers/issues/328" rel="nofollow">this
issue</a>).`,name:"tokenize_chinese_chars"},{anchor:"transformers.SplinterTokenizerFast.strip_accents",description:`<strong>strip_accents</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to strip all accents. If this option is not specified, then it will be determined by the
value for <code>lowercase</code> (as in the original BERT).`,name:"strip_accents"},{anchor:"transformers.SplinterTokenizerFast.wordpieces_prefix",description:`<strong>wordpieces_prefix</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;##&quot;</code>) &#x2014;
The prefix for subwords.`,name:"wordpieces_prefix"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter_fast.py#L32"}}),we=new z({props:{name:"build_inputs_with_special_tokens",anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens",parameters:[{name:"token_ids_0",val:": typing.List[int]"},{name:"token_ids_1",val:": typing.Optional[typing.List[int]] = None"}],parametersDescription:[{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_0",description:`<strong>token_ids_0</strong> (<code>List[int]</code>) &#x2014;
The question token IDs if pad_on_right, else context tokens IDs`,name:"token_ids_0"},{anchor:"transformers.SplinterTokenizerFast.build_inputs_with_special_tokens.token_ids_1",description:`<strong>token_ids_1</strong> (<code>List[int]</code>, <em>optional</em>) &#x2014;
The context token IDs if pad_on_right, else question token IDs`,name:"token_ids_1"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/tokenization_splinter_fast.py#L127",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>List of <a href="../glossary#input-ids">input IDs</a> with the appropriate special tokens.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[int]</code></p>
`}}),ve=new H({props:{title:"SplinterModel",local:"transformers.SplinterModel",headingTag:"h2"}}),$e=new z({props:{name:"class transformers.SplinterModel",anchor:"transformers.SplinterModel",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L601"}}),Me=new z({props:{name:"forward",anchor:"transformers.SplinterModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_hidden_states",val:": typing.Optional[torch.Tensor] = None"},{name:"encoder_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.SplinterModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterModel.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong>  (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Sequence of hidden-states at the output of the last layer of the encoder. Used in the cross-attention if
the model is configured as a decoder.`,name:"encoder_hidden_states"},{anchor:"transformers.SplinterModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on the padding token indices of the encoder input. This mask is used in
the cross-attention if the model is configured as a decoder. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>`,name:"encoder_attention_mask"},{anchor:"transformers.SplinterModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code> of length <code>config.n_layers</code> with each tuple having 4 tensors of shape <code>(batch_size, num_heads, sequence_length - 1, embed_size_per_head)</code>) &#x2014;
Contains precomputed key and value hidden states of the attention blocks. Can be used to speed up decoding.
If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.SplinterModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L636",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
<p>If <code>past_key_values</code> is used only the last hidden-state of the sequences of shape <code>(batch_size, 1, hidden_size)</code> is output.</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and optionally if
<code>config.is_encoder_decoder=True</code> 2 additional tensors of shape <code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and optionally if
<code>config.is_encoder_decoder=True</code> in the cross-attention blocks) that can be used (see <code>past_key_values</code>
input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> and <code>config.add_cross_attention=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights of the decoder’s cross-attention layer, after the attention softmax, used to compute the
weighted average in the cross-attention heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions"
>transformers.modeling_outputs.BaseModelOutputWithPastAndCrossAttentions</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),G=new fn({props:{$$slots:{default:[eo]},$$scope:{ctx:S}}}),O=new gn({props:{anchor:"transformers.SplinterModel.forward.example",$$slots:{default:[to]},$$scope:{ctx:S}}}),xe=new H({props:{title:"SplinterForQuestionAnswering",local:"transformers.SplinterForQuestionAnswering",headingTag:"h2"}}),Se=new z({props:{name:"class transformers.SplinterForQuestionAnswering",anchor:"transformers.SplinterForQuestionAnswering",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L820"}}),ze=new z({props:{name:"forward",anchor:"transformers.SplinterForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"question_positions",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SplinterForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForQuestionAnswering.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForQuestionAnswering.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForQuestionAnswering.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForQuestionAnswering.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForQuestionAnswering.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L838",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig"
>SplinterConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Total span extraction loss is the sum of a Cross-Entropy for the start and end positions.</p>
</li>
<li>
<p><strong>start_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-start scores (before SoftMax).</p>
</li>
<li>
<p><strong>end_logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>) — Span-end scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.QuestionAnsweringModelOutput"
>transformers.modeling_outputs.QuestionAnsweringModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),D=new fn({props:{$$slots:{default:[no]},$$scope:{ctx:S}}}),R=new gn({props:{anchor:"transformers.SplinterForQuestionAnswering.forward.example",$$slots:{default:[oo]},$$scope:{ctx:S}}}),qe=new H({props:{title:"SplinterForPreTraining",local:"transformers.SplinterForPreTraining",headingTag:"h2"}}),Ce=new z({props:{name:"class transformers.SplinterForPreTraining",anchor:"transformers.SplinterForPreTraining",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/splinter#transformers.SplinterConfig">SplinterConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L973"}}),Fe=new z({props:{name:"forward",anchor:"transformers.SplinterForPreTraining.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"token_type_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"start_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"end_positions",val:": typing.Optional[torch.LongTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"question_positions",val:": typing.Optional[torch.LongTensor] = None"}],parametersDescription:[{anchor:"transformers.SplinterForPreTraining.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.SplinterForPreTraining.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.SplinterForPreTraining.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:</p>
<ul>
<li>0 corresponds to a <em>sentence A</em> token,</li>
<li>1 corresponds to a <em>sentence B</em> token.</li>
</ul>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"token_type_ids"},{anchor:"transformers.SplinterForPreTraining.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>batch_size, num_questions, sequence_length</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.max_position_embeddings - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.SplinterForPreTraining.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.SplinterForPreTraining.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_questions, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <em>input_ids</em> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.SplinterForPreTraining.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.SplinterForPreTraining.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.SplinterForPreTraining.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.SplinterForPreTraining.forward.start_positions",description:`<strong>start_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the start of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"start_positions"},{anchor:"transformers.SplinterForPreTraining.forward.end_positions",description:`<strong>end_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
Labels for position (index) of the end of the labelled span for computing the token classification loss.
Positions are clamped to the length of the sequence (<code>sequence_length</code>). Position outside of the sequence
are not taken into account for computing the loss.`,name:"end_positions"},{anchor:"transformers.SplinterForPreTraining.forward.question_positions",description:`<strong>question_positions</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, num_questions)</code>, <em>optional</em>) &#x2014;
The positions of all question tokens. If given, start_logits and end_logits will be of shape <code>(batch_size, num_questions, sequence_length)</code>. If None, the first question token in each sequence in the batch will be
the only one for which start_logits and end_logits are calculated and they will be of shape <code>(batch_size, sequence_length)</code>.`,name:"question_positions"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/splinter/modeling_splinter.py#L992"}}),X=new fn({props:{$$slots:{default:[so]},$$scope:{ctx:S}}}),Le=new Yn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/splinter.md"}}),{c(){a=i("meta"),T=s(),p=i("p"),h=s(),u(y.$$.fragment),c=s(),w=i("div"),w.innerHTML=kn,lt=s(),u(oe.$$.fragment),dt=s(),se=i("p"),se.innerHTML=bn,ct=s(),re=i("p"),re.textContent=Tn,pt=s(),ae=i("p"),ae.textContent=yn,mt=s(),ie=i("p"),ie.innerHTML=wn,ht=s(),u(le.$$.fragment),ut=s(),de=i("ul"),de.innerHTML=vn,ft=s(),u(ce.$$.fragment),gt=s(),pe=i("ul"),pe.innerHTML=$n,_t=s(),u(me.$$.fragment),kt=s(),q=i("div"),u(he.$$.fragment),Lt=s(),Pe=i("p"),Pe.innerHTML=Mn,It=s(),Ue=i("p"),Ue.innerHTML=xn,Pt=s(),u(E.$$.fragment),bt=s(),u(ue.$$.fragment),Tt=s(),v=i("div"),u(fe.$$.fragment),Ut=s(),je=i("p"),je.textContent=Sn,jt=s(),We=i("p"),We.innerHTML=zn,Wt=s(),W=i("div"),u(ge.$$.fragment),Jt=s(),Je=i("p"),Je.textContent=qn,At=s(),Ae=i("ul"),Ae.innerHTML=Cn,Nt=s(),Q=i("div"),u(_e.$$.fragment),Ht=s(),Ne=i("p"),Ne.innerHTML=Fn,Bt=s(),J=i("div"),u(ke.$$.fragment),Zt=s(),He=i("p"),He.innerHTML=Ln,Et=s(),Be=i("p"),Be.textContent=In,Qt=s(),Ze=i("div"),u(be.$$.fragment),yt=s(),u(Te.$$.fragment),wt=s(),C=i("div"),u(ye.$$.fragment),Gt=s(),Ee=i("p"),Ee.innerHTML=Pn,Ot=s(),Qe=i("p"),Qe.innerHTML=Un,Dt=s(),A=i("div"),u(we.$$.fragment),Rt=s(),Ge=i("p"),Ge.textContent=jn,Xt=s(),Oe=i("ul"),Oe.innerHTML=Wn,vt=s(),u(ve.$$.fragment),$t=s(),F=i("div"),u($e.$$.fragment),Vt=s(),De=i("p"),De.innerHTML=Jn,Yt=s(),Re=i("p"),Re.innerHTML=An,Kt=s(),P=i("div"),u(Me.$$.fragment),en=s(),Xe=i("p"),Xe.innerHTML=Nn,tn=s(),u(G.$$.fragment),nn=s(),u(O.$$.fragment),Mt=s(),u(xe.$$.fragment),xt=s(),L=i("div"),u(Se.$$.fragment),on=s(),Ve=i("p"),Ve.innerHTML=Hn,sn=s(),Ye=i("p"),Ye.innerHTML=Bn,rn=s(),U=i("div"),u(ze.$$.fragment),an=s(),Ke=i("p"),Ke.innerHTML=Zn,ln=s(),u(D.$$.fragment),dn=s(),u(R.$$.fragment),St=s(),u(qe.$$.fragment),zt=s(),I=i("div"),u(Ce.$$.fragment),cn=s(),et=i("p"),et.textContent=En,pn=s(),tt=i("p"),tt.innerHTML=Qn,mn=s(),N=i("div"),u(Fe.$$.fragment),hn=s(),nt=i("p"),nt.innerHTML=Gn,un=s(),u(X.$$.fragment),qt=s(),u(Le.$$.fragment),Ct=s(),at=i("p"),this.h()},l(e){const t=Vn("svelte-u9bgzb",document.head);a=l(t,"META",{name:!0,content:!0}),t.forEach(n),T=r(e),p=l(e,"P",{}),x(p).forEach(n),h=r(e),f(y.$$.fragment,e),c=r(e),w=l(e,"DIV",{class:!0,"data-svelte-h":!0}),m(w)!=="svelte-13t8s2t"&&(w.innerHTML=kn),lt=r(e),f(oe.$$.fragment,e),dt=r(e),se=l(e,"P",{"data-svelte-h":!0}),m(se)!=="svelte-1nfobji"&&(se.innerHTML=bn),ct=r(e),re=l(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-vfdo9a"&&(re.textContent=Tn),pt=r(e),ae=l(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-m8m8di"&&(ae.textContent=yn),mt=r(e),ie=l(e,"P",{"data-svelte-h":!0}),m(ie)!=="svelte-1hzgtbk"&&(ie.innerHTML=wn),ht=r(e),f(le.$$.fragment,e),ut=r(e),de=l(e,"UL",{"data-svelte-h":!0}),m(de)!=="svelte-1bvknpp"&&(de.innerHTML=vn),ft=r(e),f(ce.$$.fragment,e),gt=r(e),pe=l(e,"UL",{"data-svelte-h":!0}),m(pe)!=="svelte-1orm8os"&&(pe.innerHTML=$n),_t=r(e),f(me.$$.fragment,e),kt=r(e),q=l(e,"DIV",{class:!0});var j=x(q);f(he.$$.fragment,j),Lt=r(j),Pe=l(j,"P",{"data-svelte-h":!0}),m(Pe)!=="svelte-1qexkr4"&&(Pe.innerHTML=Mn),It=r(j),Ue=l(j,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-o55m63"&&(Ue.innerHTML=xn),Pt=r(j),f(E.$$.fragment,j),j.forEach(n),bt=r(e),f(ue.$$.fragment,e),Tt=r(e),v=l(e,"DIV",{class:!0});var $=x(v);f(fe.$$.fragment,$),Ut=r($),je=l($,"P",{"data-svelte-h":!0}),m(je)!=="svelte-1auu3gg"&&(je.textContent=Sn),jt=r($),We=l($,"P",{"data-svelte-h":!0}),m(We)!=="svelte-1c3t5ty"&&(We.innerHTML=zn),Wt=r($),W=l($,"DIV",{class:!0});var B=x(W);f(ge.$$.fragment,B),Jt=r(B),Je=l(B,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-1di5c8i"&&(Je.textContent=qn),At=r(B),Ae=l(B,"UL",{"data-svelte-h":!0}),m(Ae)!=="svelte-18p1y68"&&(Ae.innerHTML=Cn),B.forEach(n),Nt=r($),Q=l($,"DIV",{class:!0});var Ie=x(Q);f(_e.$$.fragment,Ie),Ht=r(Ie),Ne=l(Ie,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-1f4f5kp"&&(Ne.innerHTML=Fn),Ie.forEach(n),Bt=r($),J=l($,"DIV",{class:!0});var Z=x(J);f(ke.$$.fragment,Z),Zt=r(Z),He=l(Z,"P",{"data-svelte-h":!0}),m(He)!=="svelte-zj1vf1"&&(He.innerHTML=Ln),Et=r(Z),Be=l(Z,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-9vptpw"&&(Be.textContent=In),Z.forEach(n),Qt=r($),Ze=l($,"DIV",{class:!0});var it=x(Ze);f(be.$$.fragment,it),it.forEach(n),$.forEach(n),yt=r(e),f(Te.$$.fragment,e),wt=r(e),C=l(e,"DIV",{class:!0});var V=x(C);f(ye.$$.fragment,V),Gt=r(V),Ee=l(V,"P",{"data-svelte-h":!0}),m(Ee)!=="svelte-t7sr0h"&&(Ee.innerHTML=Pn),Ot=r(V),Qe=l(V,"P",{"data-svelte-h":!0}),m(Qe)!=="svelte-fh0aq"&&(Qe.innerHTML=Un),Dt=r(V),A=l(V,"DIV",{class:!0});var ot=x(A);f(we.$$.fragment,ot),Rt=r(ot),Ge=l(ot,"P",{"data-svelte-h":!0}),m(Ge)!=="svelte-1di5c8i"&&(Ge.textContent=jn),Xt=r(ot),Oe=l(ot,"UL",{"data-svelte-h":!0}),m(Oe)!=="svelte-18p1y68"&&(Oe.innerHTML=Wn),ot.forEach(n),V.forEach(n),vt=r(e),f(ve.$$.fragment,e),$t=r(e),F=l(e,"DIV",{class:!0});var Y=x(F);f($e.$$.fragment,Y),Vt=r(Y),De=l(Y,"P",{"data-svelte-h":!0}),m(De)!=="svelte-mflokx"&&(De.innerHTML=Jn),Yt=r(Y),Re=l(Y,"P",{"data-svelte-h":!0}),m(Re)!=="svelte-ocipx3"&&(Re.innerHTML=An),Kt=r(Y),P=l(Y,"DIV",{class:!0});var K=x(P);f(Me.$$.fragment,K),en=r(K),Xe=l(K,"P",{"data-svelte-h":!0}),m(Xe)!=="svelte-pu5pk"&&(Xe.innerHTML=Nn),tn=r(K),f(G.$$.fragment,K),nn=r(K),f(O.$$.fragment,K),K.forEach(n),Y.forEach(n),Mt=r(e),f(xe.$$.fragment,e),xt=r(e),L=l(e,"DIV",{class:!0});var ee=x(L);f(Se.$$.fragment,ee),on=r(ee),Ve=l(ee,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-cet2uw"&&(Ve.innerHTML=Hn),sn=r(ee),Ye=l(ee,"P",{"data-svelte-h":!0}),m(Ye)!=="svelte-68lg8f"&&(Ye.innerHTML=Bn),rn=r(ee),U=l(ee,"DIV",{class:!0});var te=x(U);f(ze.$$.fragment,te),an=r(te),Ke=l(te,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-u5s69c"&&(Ke.innerHTML=Zn),ln=r(te),f(D.$$.fragment,te),dn=r(te),f(R.$$.fragment,te),te.forEach(n),ee.forEach(n),St=r(e),f(qe.$$.fragment,e),zt=r(e),I=l(e,"DIV",{class:!0});var ne=x(I);f(Ce.$$.fragment,ne),cn=r(ne),et=l(ne,"P",{"data-svelte-h":!0}),m(et)!=="svelte-1fwuwic"&&(et.textContent=En),pn=r(ne),tt=l(ne,"P",{"data-svelte-h":!0}),m(tt)!=="svelte-68lg8f"&&(tt.innerHTML=Qn),mn=r(ne),N=l(ne,"DIV",{class:!0});var st=x(N);f(Fe.$$.fragment,st),hn=r(st),nt=l(st,"P",{"data-svelte-h":!0}),m(nt)!=="svelte-iz2fqu"&&(nt.innerHTML=Gn),un=r(st),f(X.$$.fragment,st),st.forEach(n),ne.forEach(n),qt=r(e),f(Le.$$.fragment,e),Ct=r(e),at=l(e,"P",{}),x(at).forEach(n),this.h()},h(){M(a,"name","hf:doc:metadata"),M(a,"content",ao),M(w,"class","flex flex-wrap space-x-1"),M(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),M(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){o(document.head,a),d(e,T,t),d(e,p,t),d(e,h,t),g(y,e,t),d(e,c,t),d(e,w,t),d(e,lt,t),g(oe,e,t),d(e,dt,t),d(e,se,t),d(e,ct,t),d(e,re,t),d(e,pt,t),d(e,ae,t),d(e,mt,t),d(e,ie,t),d(e,ht,t),g(le,e,t),d(e,ut,t),d(e,de,t),d(e,ft,t),g(ce,e,t),d(e,gt,t),d(e,pe,t),d(e,_t,t),g(me,e,t),d(e,kt,t),d(e,q,t),g(he,q,null),o(q,Lt),o(q,Pe),o(q,It),o(q,Ue),o(q,Pt),g(E,q,null),d(e,bt,t),g(ue,e,t),d(e,Tt,t),d(e,v,t),g(fe,v,null),o(v,Ut),o(v,je),o(v,jt),o(v,We),o(v,Wt),o(v,W),g(ge,W,null),o(W,Jt),o(W,Je),o(W,At),o(W,Ae),o(v,Nt),o(v,Q),g(_e,Q,null),o(Q,Ht),o(Q,Ne),o(v,Bt),o(v,J),g(ke,J,null),o(J,Zt),o(J,He),o(J,Et),o(J,Be),o(v,Qt),o(v,Ze),g(be,Ze,null),d(e,yt,t),g(Te,e,t),d(e,wt,t),d(e,C,t),g(ye,C,null),o(C,Gt),o(C,Ee),o(C,Ot),o(C,Qe),o(C,Dt),o(C,A),g(we,A,null),o(A,Rt),o(A,Ge),o(A,Xt),o(A,Oe),d(e,vt,t),g(ve,e,t),d(e,$t,t),d(e,F,t),g($e,F,null),o(F,Vt),o(F,De),o(F,Yt),o(F,Re),o(F,Kt),o(F,P),g(Me,P,null),o(P,en),o(P,Xe),o(P,tn),g(G,P,null),o(P,nn),g(O,P,null),d(e,Mt,t),g(xe,e,t),d(e,xt,t),d(e,L,t),g(Se,L,null),o(L,on),o(L,Ve),o(L,sn),o(L,Ye),o(L,rn),o(L,U),g(ze,U,null),o(U,an),o(U,Ke),o(U,ln),g(D,U,null),o(U,dn),g(R,U,null),d(e,St,t),g(qe,e,t),d(e,zt,t),d(e,I,t),g(Ce,I,null),o(I,cn),o(I,et),o(I,pn),o(I,tt),o(I,mn),o(I,N),g(Fe,N,null),o(N,hn),o(N,nt),o(N,un),g(X,N,null),d(e,qt,t),g(Le,e,t),d(e,Ct,t),d(e,at,t),Ft=!0},p(e,[t]){const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),E.$set(j);const $={};t&2&&($.$$scope={dirty:t,ctx:e}),G.$set($);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),O.$set(B);const Ie={};t&2&&(Ie.$$scope={dirty:t,ctx:e}),D.$set(Ie);const Z={};t&2&&(Z.$$scope={dirty:t,ctx:e}),R.$set(Z);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),X.$set(it)},i(e){Ft||(_(y.$$.fragment,e),_(oe.$$.fragment,e),_(le.$$.fragment,e),_(ce.$$.fragment,e),_(me.$$.fragment,e),_(he.$$.fragment,e),_(E.$$.fragment,e),_(ue.$$.fragment,e),_(fe.$$.fragment,e),_(ge.$$.fragment,e),_(_e.$$.fragment,e),_(ke.$$.fragment,e),_(be.$$.fragment,e),_(Te.$$.fragment,e),_(ye.$$.fragment,e),_(we.$$.fragment,e),_(ve.$$.fragment,e),_($e.$$.fragment,e),_(Me.$$.fragment,e),_(G.$$.fragment,e),_(O.$$.fragment,e),_(xe.$$.fragment,e),_(Se.$$.fragment,e),_(ze.$$.fragment,e),_(D.$$.fragment,e),_(R.$$.fragment,e),_(qe.$$.fragment,e),_(Ce.$$.fragment,e),_(Fe.$$.fragment,e),_(X.$$.fragment,e),_(Le.$$.fragment,e),Ft=!0)},o(e){k(y.$$.fragment,e),k(oe.$$.fragment,e),k(le.$$.fragment,e),k(ce.$$.fragment,e),k(me.$$.fragment,e),k(he.$$.fragment,e),k(E.$$.fragment,e),k(ue.$$.fragment,e),k(fe.$$.fragment,e),k(ge.$$.fragment,e),k(_e.$$.fragment,e),k(ke.$$.fragment,e),k(be.$$.fragment,e),k(Te.$$.fragment,e),k(ye.$$.fragment,e),k(we.$$.fragment,e),k(ve.$$.fragment,e),k($e.$$.fragment,e),k(Me.$$.fragment,e),k(G.$$.fragment,e),k(O.$$.fragment,e),k(xe.$$.fragment,e),k(Se.$$.fragment,e),k(ze.$$.fragment,e),k(D.$$.fragment,e),k(R.$$.fragment,e),k(qe.$$.fragment,e),k(Ce.$$.fragment,e),k(Fe.$$.fragment,e),k(X.$$.fragment,e),k(Le.$$.fragment,e),Ft=!1},d(e){e&&(n(T),n(p),n(h),n(c),n(w),n(lt),n(dt),n(se),n(ct),n(re),n(pt),n(ae),n(mt),n(ie),n(ht),n(ut),n(de),n(ft),n(gt),n(pe),n(_t),n(kt),n(q),n(bt),n(Tt),n(v),n(yt),n(wt),n(C),n(vt),n($t),n(F),n(Mt),n(xt),n(L),n(St),n(zt),n(I),n(qt),n(Ct),n(at)),n(a),b(y,e),b(oe,e),b(le,e),b(ce,e),b(me,e),b(he),b(E),b(ue,e),b(fe),b(ge),b(_e),b(ke),b(be),b(Te,e),b(ye),b(we),b(ve,e),b($e),b(Me),b(G),b(O),b(xe,e),b(Se),b(ze),b(D),b(R),b(qe,e),b(Ce),b(Fe),b(X),b(Le,e)}}}const ao='{"title":"Splinter","local":"splinter","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"SplinterConfig","local":"transformers.SplinterConfig","sections":[],"depth":2},{"title":"SplinterTokenizer","local":"transformers.SplinterTokenizer","sections":[],"depth":2},{"title":"SplinterTokenizerFast","local":"transformers.SplinterTokenizerFast","sections":[],"depth":2},{"title":"SplinterModel","local":"transformers.SplinterModel","sections":[],"depth":2},{"title":"SplinterForQuestionAnswering","local":"transformers.SplinterForQuestionAnswering","sections":[],"depth":2},{"title":"SplinterForPreTraining","local":"transformers.SplinterForPreTraining","sections":[],"depth":2}],"depth":1}';function io(S){return Dn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _o extends Rn{constructor(a){super(),Xn(this,a,io,ro,On,{})}}export{_o as component};
