import{s as Ia,o as ka,n as vo}from"../chunks/scheduler.18a86fab.js";import{S as La,i as Ca,g as r,s as n,r as p,A as xa,h as i,f as t,c as s,j as V,u as h,x as m,k as J,y as l,a,v as g,d as f,t as u,w as _}from"../chunks/index.98837b22.js";import{T as At}from"../chunks/Tip.77304350.js";import{D as z}from"../chunks/Docstring.6758ea23.js";import{C as O}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Va}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as I}from"../chunks/Heading.7e7e0c5b.js";import{E as za}from"../chunks/index.499f366c.js";function Za(Z){let d,T='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',v,y,M='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){d=r("p"),d.innerHTML=T,v=n(),y=r("p"),y.innerHTML=M},l(c){d=i(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-nz63kd"&&(d.innerHTML=T),v=s(c),y=i(c,"P",{"data-svelte-h":!0}),m(y)!=="svelte-aze40l"&&(y.innerHTML=M)},m(c,b){a(c,d,b),a(c,v,b),a(c,y,b)},p:vo,d(c){c&&(t(d),t(v),t(y))}}}function $a(Z){let d,T="Example:",v,y,M;return y=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBWaWRlb0xsYXZhQ29uZmlnJTJDJTIwQ0xJUFZpc2lvbkNvbmZpZyUyQyUyMExsYW1hQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMENMSVAtdmlzaW9uJTIwY29uZmlnJTBBdmlzaW9uX2NvbmZpZyUyMCUzRCUyMENMSVBWaXNpb25Db25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBMbGFtYSUyMGNvbmZpZyUwQXRleHRfY29uZmlnJTIwJTNEJTIwTGxhbWFDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBWaWRlb0xsYXZhJTIwdmlkZW9fbGxhdmEtMS41LTdiJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFZpZGVvTGxhdmFDb25maWcodmlzaW9uX2NvbmZpZyUyQyUyMHRleHRfY29uZmlnKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjB2aWRlb19sbGF2YS0xLjUtN2IlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a VideoLlava video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = VideoLlavaConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the video_llava-1.5-7b style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){d=r("p"),d.textContent=T,v=n(),p(y.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),v=s(c),h(y.$$.fragment,c)},m(c,b){a(c,d,b),a(c,v,b),g(y,c,b),M=!0},p:vo,i(c){M||(f(y.$$.fragment,c),M=!0)},o(c){u(y.$$.fragment,c),M=!1},d(c){c&&(t(d),t(v)),_(y,c)}}}function Ba(Z){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=T},l(v){d=i(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(v,y){a(v,d,y)},p:vo,d(v){v&&t(d)}}}function Wa(Z){let d,T=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){d=r("p"),d.innerHTML=T},l(v){d=i(v,"P",{"data-svelte-h":!0}),m(d)!=="svelte-fincs2"&&(d.innerHTML=T)},m(v,y){a(v,d,y)},p:vo,d(v){v&&t(d)}}}function Ga(Z){let d,T="Example:",v,y,M;return y=new O({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> av
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaProcessor, VideoLlavaForConditionalGeneration


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
<span class="hljs-meta">... </span>    <span class="hljs-string">&#x27;&#x27;&#x27;
<span class="hljs-meta">... </span>    Decode the video with PyAV decoder.
<span class="hljs-meta">... </span>    Args:
<span class="hljs-meta">... </span>        container (\`av.container.input.InputContainer\`): PyAV container.
<span class="hljs-meta">... </span>        indices (\`List[int]\`): List of frame indices to decode.
<span class="hljs-meta">... </span>    Returns:
<span class="hljs-meta">... </span>        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
<span class="hljs-meta">... </span>    &#x27;&#x27;&#x27;</span>
<span class="hljs-meta">... </span>    frames = []
<span class="hljs-meta">... </span>    container.seek(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    start_index = indices[<span class="hljs-number">0</span>]
<span class="hljs-meta">... </span>    end_index = indices[-<span class="hljs-number">1</span>]
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt; end_index:
<span class="hljs-meta">... </span>            <span class="hljs-keyword">break</span>
<span class="hljs-meta">... </span>        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
<span class="hljs-meta">... </span>            frames.append(frame)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-meta">&gt;&gt;&gt; </span>model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>container = av.<span class="hljs-built_in">open</span>(video_path)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># sample uniformly 8 frames from the video</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
<span class="hljs-meta">&gt;&gt;&gt; </span>indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>clip = read_video_pyav(container, indices)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, videos=clip, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">80</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;USER:  Why is this video funny? ASSISTANT: The video is funny because the baby is playing with a Wii remote while sitting on the floor, and the baby is wearing glasses.Ъ. The baby&#x27;s actions are amusing because it is a young child trying to interact with a video game, which is not a typical activity for a&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to generate from image and video mix</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;image&gt;\\nHow many cats do you see? ASSISTANT:&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
[<span class="hljs-string">&#x27;USER:   How many cats do you see? ASSISTANT: There are two cats visible in the image. (or three, if you count the one in the background).&#x27;</span>, <span class="hljs-string">&#x27;USER:  Why is this video funny? ASSISTANT: The video is funny because it shows a baby sitting on a bed and playing with a Wii remote.Ъ. The baby is holding the remote&#x27;</span>]`,wrap:!1}}),{c(){d=r("p"),d.textContent=T,v=n(),p(y.$$.fragment)},l(c){d=i(c,"P",{"data-svelte-h":!0}),m(d)!=="svelte-11lpom8"&&(d.textContent=T),v=s(c),h(y.$$.fragment,c)},m(c,b){a(c,d,b),a(c,v,b),g(y,c,b),M=!0},p:vo,i(c){M||(f(y.$$.fragment,c),M=!0)},o(c){u(y.$$.fragment,c),M=!1},d(c){c&&(t(d),t(v)),_(y,c)}}}function Fa(Z){let d,T,v,y,M,c,b,Pt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',yo,K,Mo,ee,Yt="Video-LLaVa is an open-source multimodal LLM trained by fine-tuning LlamA/Vicuna on multimodal instruction-following data generated by Llava1.5 and VideChat. It is an auto-regressive language model, based on the transformer architecture. Video-LLaVa unifies visual representations to the language feature space, and enables an LLM to perform visual reasoning capabilities on both images and videos simultaneously.",bo,oe,Xt='The Video-LLaVA model was proposed in <a href="https://arxiv.org/abs/2311.10122" rel="nofollow">Video-LLaVA: Learning United Visual Representation by Alignment Before Projection</a> by Bin Lin, Yang Ye, Bin Zhu, Jiaxi Cui, Munang Ning, Peng Jin, Li Yuan.',To,te,Ht="The abstract from the paper is the following:",wo,ae,qt=`<em>The Large Vision-Language Model (LVLM) has enhanced the performance of various downstream tasks in
visual-language understanding. Most existing approaches
encode images and videos into separate feature spaces,
which are then fed as inputs to large language models.
However, due to the lack of unified tokenization for images and videos, namely misalignment before projection, it
becomes challenging for a Large Language Model (LLM)
to learn multi-modal interactions from several poor projection layers. In this work, we unify visual representation into the language feature space to advance the foundational LLM towards a unified LVLM. As a result, we establish a simple but robust LVLM baseline, Video-LLaVA,
which learns from a mixed dataset of images and videos,
mutually enhancing each other. Video-LLaVA achieves superior performances on a broad range of 9 image benchmarks across 5 image question-answering datasets and 4
image benchmark toolkits. Additionally, our Video-LLaVA
also outperforms Video-ChatGPT by 5.8%, 9.9%, 18.6%,
and 10.1% on MSRVTT, MSVD, TGIF, and ActivityNet, respectively. Notably, extensive experiments demonstrate that
Video-LLaVA mutually benefits images and videos within
a unified visual representation, outperforming models designed specifically for images or videos. We aim for this
work to provide modest insights into the multi-modal inputs
for the LLM</em>`,Jo,ne,jo,se,Qt="<li><p>We advise users to use padding_side=“left” when computing batched generation as it leads to more accurate results. Simply make sure to call processor.tokenizer.padding_side = “left” before generating.</p></li> <li><p>Note the model has not been explicitly trained to process multiple images/videos in the same prompt, although this is technically possible, you may experience inaccurate results.</p></li> <li><p>Note that the video inputs should have exactly 8 frames at the input, since the models were trained in that setting.</p></li>",Uo,re,Dt=`This model was contributed by <a href="https://huggingface.co/RaushanTurganbay" rel="nofollow">RaushanTurganbay</a>.
The original code can be found <a href="https://github.com/PKU-YuanGroup/Video-LLaVA" rel="nofollow">here</a>.`,Vo,ie,Ot="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",Io,le,ko,de,Lo,ce,Kt="The model can accept both images and videos as input. Here’s an example code for inference in half-precision (<code>torch.float16</code>):",Co,me,xo,pe,ea="For multiple turns conversation change the prompt format to:",zo,he,Zo,ge,$o,fe,oa="The model can also generate from an interleaved image-video inputs. However note, that it was not trained in interleaved image-video setting which might affect the performance. Below is an example usage for mixed media input, add the following lines to the above code snippet:",Bo,ue,Wo,_e,Go,ve,Fo,ye,ta="The model can be loaded in lower bits, significantly reducing memory burden while maintaining the performance of the original model. his allows for efficient deployment on resource-constrained cases.",Ro,Me,aa="First make sure to install bitsandbytes by running <code>pip install bitsandbytes</code> and to have access to a GPU/accelerator that is supported by the library.",No,F,Eo,be,na='Load the quantized model by simply adding <a href="../main_classes/quantization#transformers.BitsAndBytesConfig"><code>BitsAndBytesConfig</code></a> as shown below:',So,Te,Ao,we,Po,Je,sa='Additionally, we can greatly speed-up model inference by using <a href="../perf_train_gpu_one#flash-attention-2">Flash Attention</a>, which is a faster implementation of the attention mechanism used inside the model.',Yo,je,ra="First, make sure to install the latest version of Flash Attention 2:",Xo,Ue,Ho,Ve,ia='Also, you should have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">flash attention repository</a>. FlashAttention-2 can only be used when a model is loaded in <code>torch.float16</code> or <code>torch.bfloat16</code>.',qo,Ie,la="To load and run a model using Flash Attention-2, simply add <code>attn_implementation=&quot;flash_attention_2&quot;</code> when loading the model as follows:",Qo,ke,Do,Le,Oo,j,Ce,gt,De,da=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a>. It is used to instantiate an
VideoLlava model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the like LanguageBind/Video-LLaVA-7B-hf.`,ft,Oe,ca='e.g. <a href="https://huggingface.co/LanguageBind/Video-LLaVA-7B-hf" rel="nofollow">LanguageBind/Video-LLaVA-7B-hf</a>',ut,Ke,ma=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,_t,R,Ko,xe,et,k,ze,vt,eo,pa="Constructs a CLIP image processor.",yt,N,Ze,Mt,oo,ha="Preprocess an image or batch of images.",bt,E,$e,Tt,to,ga=`Resize an image. The shortest edge of the image is resized to size[“shortest_edge”], with the longest edge
resized to keep the input aspect ratio.`,ot,Be,tt,U,We,wt,ao,fa="Constructs a VideoLlava processor which wraps a VideoLlava image processor and a Llava tokenizer into a single processor.",Jt,no,ua=`<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaProcessor">VideoLlavaProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaProcessor.decode">decode()</a> for more information.`,jt,S,Ge,Ut,so,_a=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Vt,A,Fe,It,ro,va=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,at,Re,nt,w,Ne,kt,io,ya=`The VideoLlava model which consists of a vision backbone and a language model without language modeling head.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Lt,lo,Ma=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ct,G,Ee,xt,co,ba='The <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaModel">VideoLlavaModel</a> forward method, overrides the <code>__call__</code> special method.',zt,P,Zt,Y,Se,$t,mo,Ta="Obtains image last hidden states from the vision tower and apply multimodal projection.",Bt,X,Ae,Wt,po,wa="Obtains video last hidden states from the vision tower and apply multimodal projection.",st,Pe,rt,L,Ye,Gt,ho,Ja=`The VideoLlava model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ft,go,ja=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Rt,$,Xe,Nt,fo,Ua='The <a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaForConditionalGeneration">VideoLlavaForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Et,H,St,q,it,He,lt,_o,dt;return M=new I({props:{title:"Video-LLaVA",local:"video-llava",headingTag:"h1"}}),K=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),ne=new I({props:{title:"Usage tips:",local:"usage-tips",headingTag:"h2"}}),le=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),de=new I({props:{title:"Single Media Mode",local:"single-media-mode",headingTag:"h3"}}),me=new O({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> av
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, VideoLlavaProcessor

<span class="hljs-keyword">def</span> <span class="hljs-title function_">read_video_pyav</span>(<span class="hljs-params">container, indices</span>):
    <span class="hljs-string">&#x27;&#x27;&#x27;
    Decode the video with PyAV decoder.
    Args:
        container (\`av.container.input.InputContainer\`): PyAV container.
        indices (\`List[int]\`): List of frame indices to decode.
    Returns:
        result (np.ndarray): np array of decoded frames of shape (num_frames, height, width, 3).
    &#x27;&#x27;&#x27;</span>
    frames = []
    container.seek(<span class="hljs-number">0</span>)
    start_index = indices[<span class="hljs-number">0</span>]
    end_index = indices[-<span class="hljs-number">1</span>]
    <span class="hljs-keyword">for</span> i, frame <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(container.decode(video=<span class="hljs-number">0</span>)):
        <span class="hljs-keyword">if</span> i &gt; end_index:
            <span class="hljs-keyword">break</span>
        <span class="hljs-keyword">if</span> i &gt;= start_index <span class="hljs-keyword">and</span> i <span class="hljs-keyword">in</span> indices:
            frames.append(frame)
    <span class="hljs-keyword">return</span> np.stack([x.to_ndarray(<span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;rgb24&quot;</span>) <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> frames])

<span class="hljs-comment"># Load the model in half-precision</span>
model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = VideoLlavaProcessor.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>)

<span class="hljs-comment"># Load the video as an np.arrau, sampling uniformly 8 frames</span>
video_path = hf_hub_download(repo_id=<span class="hljs-string">&quot;raushan-testing-hf/videos-test&quot;</span>, filename=<span class="hljs-string">&quot;sample_demo_1.mp4&quot;</span>, repo_type=<span class="hljs-string">&quot;dataset&quot;</span>)
container = av.<span class="hljs-built_in">open</span>(video_path)
total_frames = container.streams.video[<span class="hljs-number">0</span>].frames
indices = np.arange(<span class="hljs-number">0</span>, total_frames, total_frames / <span class="hljs-number">8</span>).astype(<span class="hljs-built_in">int</span>)
video = read_video_pyav(container, indices)

<span class="hljs-comment"># For better results, we recommend to prompt the model in the following format</span>
prompt = <span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhy is this funny? ASSISTANT:&quot;</span>
inputs = processor(text=prompt, videos=video, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

out = model.generate(**inputs, max_new_tokens=<span class="hljs-number">60</span>)
processor.batch_decode(out, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)`,wrap:!1}}),he=new O({props:{code:"JTIyVVNFUiUzQSUyMCUzQ3ZpZGVvJTNFJTVDbldoYXQlMjBkbyUyMHlvdSUyMHNlZSUyMGluJTIwdGhpcyUyMHZpZGVvJTNGJTIwQVNTSVNUQU5UJTNBJTIwQSUyMGJhYnklMjByZWFkaW5nJTIwYSUyMGJvb2suJTIwVVNFUiUzQSUyMFdoeSUyMGlzJTIwdGhlJTIwaXQlMjBmdW5ueSUzRiUyMEFTU0lTVEFOVCUzQSUyMg==",highlighted:'<span class="hljs-string">&quot;USER: &lt;video&gt;\\nWhat do you see in this video? ASSISTANT: A baby reading a book. USER: Why is the it funny? ASSISTANT:&quot;</span>',wrap:!1}}),ge=new I({props:{title:"Mixed Media Mode",local:"mixed-media-mode",headingTag:"h3"}}),ue=new O({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEElMjMlMjBHZW5lcmF0ZSUyMGZyb20lMjBpbWFnZSUyMGFuZCUyMHZpZGVvJTIwbWl4ZWQlMjBpbnB1dHMlMEElMjMlMjBMb2FkJTIwYW5kJTIwaW1hZ2UlMjBhbmQlMjB3cml0ZSUyMGElMjBuZXclMjBwcm9tcHQlMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBcHJvbXB0JTIwJTNEJTIwJTIyVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbkhvdyUyMG1hbnklMjBjYXRzJTIwYXJlJTIwdGhlcmUlMjBpbiUyMHRoZSUyMGltYWdlJTNGJTIwQVNTSVNUQU5UJTNBJTIwVGhlcmUlMjBhcmUlMjB0d28lMjBjYXRzLiUyMFVTRVIlM0ElMjAlM0N2aWRlbyUzRSU1Q25XaHklMjBpcyUyMHRoaXMlMjB2aWRlbyUyMGZ1bm55JTNGJTIwQVNTSVNUQU5UJTNBJTIyJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKHRleHQlM0Rwcm9tcHQlMkMlMjBpbWFnZXMlM0RpbWFnZSUyQyUyMHZpZGVvcyUzRGNsaXAlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBJTIzJTIwR2VuZXJhdGUlMEFnZW5lcmF0ZV9pZHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0Q1MCklMEFwcm9jZXNzb3IuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzRFRydWUpJTBB",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

<span class="hljs-comment"># Generate from image and video mixed inputs</span>
<span class="hljs-comment"># Load and image and write a new prompt</span>
url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
prompt = <span class="hljs-string">&quot;USER: &lt;image&gt;\\nHow many cats are there in the image? ASSISTANT: There are two cats. USER: &lt;video&gt;\\nWhy is this video funny? ASSISTANT:&quot;</span>

inputs = processor(text=prompt, images=image, videos=clip, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">50</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">True</span>)
`,wrap:!1}}),_e=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),ve=new I({props:{title:"Quantization using Bitsandbytes for memory efficiency",local:"quantization-using-bitsandbytes-for-memory-efficiency",headingTag:"h3"}}),F=new At({props:{$$slots:{default:[Za]},$$scope:{ctx:Z}}}),Te=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMkMlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEElMjMlMjBzcGVjaWZ5JTIwaG93JTIwdG8lMjBxdWFudGl6ZSUyMHRoZSUyMG1vZGVsJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfcXVhbnRfdHlwZSUzRCUyMm5mNCUyMiUyQyUwQSUyMCUyMCUyMCUyMGJuYl80Yml0X2NvbXB1dGVfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwVmlkZW9MbGF2YUZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyTGFuZ3VhZ2VCaW5kJTJGVmlkZW8tTExhVkEtN0ItaGYlMjIlMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEcXVhbnRpemF0aW9uX2NvbmZpZyUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = VideoLlavaForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),we=new I({props:{title:"Flash-Attention 2 to speed-up generation",local:"flash-attention-2-to-speed-up-generation",headingTag:"h3"}}),Ue=new O({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),ke=new O({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMFZpZGVvTGxhdmFGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMkxhbmd1YWdlQmluZCUyRlZpZGVvLUxMYVZBLTdCLWhmJTIyJTJDJTIwJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwJTBBJTIwJTIwJTIwJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMmZsYXNoX2F0dGVudGlvbl8yJTIyJTJDJTBBKS50bygwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> VideoLlavaForConditionalGeneration

model = VideoLlavaForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;LanguageBind/Video-LLaVA-7B-hf&quot;</span>, 
    torch_dtype=torch.float16, 
    attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>,
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Le=new I({props:{title:"VideoLlavaConfig",local:"transformers.VideoLlavaConfig",headingTag:"h2"}}),Ce=new z({props:{name:"class transformers.VideoLlavaConfig",anchor:"transformers.VideoLlavaConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32000"},{name:"video_token_index",val:" = 32001"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_seq_length",val:" = 256"},{name:"video_seq_length",val:" = 2056"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaConfig.vision_config",description:`<strong>vision_config</strong> (<code>VideoLlavaVisionConfig</code>, <em>optional</em>) &#x2014;
Custom vision config or dict. Defaults to <code>CLIPVisionConfig</code> if not indicated.`,name:"vision_config"},{anchor:"transformers.VideoLlavaConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>) &#x2014;
The config object of the text backbone. Can be any of <code>LlamaConfig</code> or <code>MistralConfig</code>.
Defaults to <code>LlamaConfig</code> if not indicated.`,name:"text_config"},{anchor:"transformers.VideoLlavaConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.VideoLlavaConfig.video_token_index",description:`<strong>video_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32001) &#x2014;
The video token index to encode the image prompt.`,name:"video_token_index"},{anchor:"transformers.VideoLlavaConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.VideoLlavaConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the CLIP backbone.
Can be either &#x201C;full&#x201D; to select all features or &#x201C;default&#x201D; to select features without <code>CLS</code>.`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.VideoLlavaConfig.video_seq_length",description:`<strong>video_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 2056) &#x2014;
Sequence length of one video embedding.`,name:"video_seq_length"},{anchor:"transformers.VideoLlavaConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/configuration_video_llava.py#L24"}}),R=new Va({props:{anchor:"transformers.VideoLlavaConfig.example",$$slots:{default:[$a]},$$scope:{ctx:Z}}}),xe=new I({props:{title:"VideoLlavaImageProcessor",local:"transformers.VideoLlavaImageProcessor",headingTag:"h2"}}),ze=new z({props:{name:"class transformers.VideoLlavaImageProcessor",anchor:"transformers.VideoLlavaImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L49"}}),Ze=new z({props:{name:"preprocess",anchor:"transformers.VideoLlavaImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Optional[typing.List[typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]]] = None"},{name:"videos",val:": typing.Optional[typing.List[typing.Union[list['PIL.Image.Image'], ForwardRef('np.ndarray'), ForwardRef('torch.Tensor'), list['np.ndarray'], list['torch.Tensor'], list[list['PIL.Image.Image']], list[list['np.ndarray']], list[list['torch.Tensor']]]]] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>, <em>optional</em>) &#x2014;
List of images to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.videos",description:`<strong>videos</strong> (<code>VideoInput</code>, <em>optional</em>) &#x2014;
List of videos to preprocess. Expects a single or batch of videos with pixel values ranging from 0 to 255. If
passing in videos with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"videos"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L172"}}),$e=new z({props:{name:"resize",anchor:"transformers.VideoLlavaImageProcessor.resize",parameters:[{name:"image",val:": ndarray"},{name:"size",val:": typing.Dict[str, int]"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaImageProcessor.resize.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to resize.`,name:"image"},{anchor:"transformers.VideoLlavaImageProcessor.resize.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>) &#x2014;
Size of the output image.`,name:"size"},{anchor:"transformers.VideoLlavaImageProcessor.resize.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Resampling filter to use when resiizing the image.`,name:"resample"},{anchor:"transformers.VideoLlavaImageProcessor.resize.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.VideoLlavaImageProcessor.resize.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/image_processing_video_llava.py#L123"}}),Be=new I({props:{title:"VideoLlavaProcessor",local:"transformers.VideoLlavaProcessor",headingTag:"h2"}}),We=new z({props:{name:"class transformers.VideoLlavaProcessor",anchor:"transformers.VideoLlavaProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = 14"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"image_token",val:" = '<image>'"},{name:"video_token",val:" = '<video>'"},{name:"chat_template",val:" = None"},{name:"num_additional_image_tokens",val:" = 1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.VideoLlavaProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama2#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.VideoLlavaProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 14) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.VideoLlavaProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Should be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.VideoLlavaProcessor.video_token",description:`<strong>video_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;video&gt;&quot;</code>) &#x2014;
Special token used to denote video location.`,name:"video_token"},{anchor:"transformers.VideoLlavaProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.VideoLlavaProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L33"}}),Ge=new z({props:{name:"batch_decode",anchor:"transformers.VideoLlavaProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L207"}}),Fe=new z({props:{name:"decode",anchor:"transformers.VideoLlavaProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/processing_video_llava.py#L215"}}),Re=new I({props:{title:"VideoLlavaModel",local:"transformers.VideoLlavaModel",headingTag:"h2"}}),Ne=new z({props:{name:"class transformers.VideoLlavaModel",anchor:"transformers.VideoLlavaModel",parameters:[{name:"config",val:": VideoLlavaConfig"}],parametersDescription:[{anchor:"transformers.VideoLlavaModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig">VideoLlavaConfig</a> or <code>VideoLlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L286"}}),Ee=new z({props:{name:"forward",anchor:"transformers.VideoLlavaModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values_images",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VideoLlavaModel.forward.pixel_values_images",description:'<strong>pixel_values_images</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing images).',name:"pixel_values_images"},{anchor:"transformers.VideoLlavaModel.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input video. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing videos).',name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.VideoLlavaModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VideoLlavaModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.VideoLlavaModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.VideoLlavaModel.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaModel.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.VideoLlavaModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoLlavaModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoLlavaModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoLlavaModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L390"}}),P=new At({props:{$$slots:{default:[Ba]},$$scope:{ctx:Z}}}),Se=new z({props:{name:"get_image_features",anchor:"transformers.VideoLlavaModel.get_image_features",parameters:[{name:"pixel_values_images",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"},{name:"vision_feature_select_strategy",val:": str"}],parametersDescription:[{anchor:"transformers.VideoLlavaModel.get_image_features.pixel_values_images",description:`<strong>pixel_values_images</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input images.`,name:"pixel_values_images"},{anchor:"transformers.VideoLlavaModel.get_image_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaModel.get_image_features.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L310",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Image feature tensor of shape <code>(num_images, image_length, embed_dim)</code>).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>image_features (<code>torch.Tensor</code>)</p>
`}}),Ae=new z({props:{name:"get_video_features",anchor:"transformers.VideoLlavaModel.get_video_features",parameters:[{name:"pixel_values_videos",val:": FloatTensor"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int]]"}],parametersDescription:[{anchor:"transformers.VideoLlavaModel.get_video_features.pixel_values_videos",description:`<strong>pixel_values_videos</strong> (<code>torch.FloatTensor]</code> of shape <code>(batch_size, num_frames, channels, height, width)</code>) &#x2014;
The tensors corresponding to the input videos.`,name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaModel.get_video_features.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L354",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Video feature tensor of shape <code>(num_videos * num_frames, image_length, embed_dim)</code>).
frames (<code>int</code>): Number of frames the videos have.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>video_features (<code>torch.Tensor</code>)</p>
`}}),Pe=new I({props:{title:"VideoLlavaForConditionalGeneration",local:"transformers.VideoLlavaForConditionalGeneration",headingTag:"h2"}}),Ye=new z({props:{name:"class transformers.VideoLlavaForConditionalGeneration",anchor:"transformers.VideoLlavaForConditionalGeneration",parameters:[{name:"config",val:": VideoLlavaConfig"}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig">VideoLlavaConfig</a> or <code>VideoLlavaVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L492"}}),Xe=new z({props:{name:"forward",anchor:"transformers.VideoLlavaForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"pixel_values_images",val:": FloatTensor = None"},{name:"pixel_values_videos",val:": FloatTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_images",description:'<strong>pixel_values_images</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, image_size, image_size)) -- The tensors corresponding to the input images. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing images).',name:"pixel_values_images"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.pixel_values_videos",description:'<strong>pixel_values_videos</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_frames, num_channels, image_size, image_size)) -- The tensors corresponding to the input video. Pixel values can be obtained using [AutoImageProcessor](/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor). See [VideoLlavaImageProcessor.__call__()](/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__) for details ([]</code>LlavaProcessor`] uses\n<a href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaImageProcessor">VideoLlavaImageProcessor</a> for processing videos).',name:"pixel_values_videos"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>`,name:"vision_feature_select_strategy"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/video_llava/modeling_video_llava.py#L541",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/video_llava#transformers.VideoLlavaConfig"
>VideoLlavaConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
<li>
<p><strong>video_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code>  of size <code>(batch_size * num_frames, num_videos, sequence_length, hidden_size)</code>.
video_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.video_llava.modeling_video_llava.VideoLlavaCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),H=new At({props:{$$slots:{default:[Wa]},$$scope:{ctx:Z}}}),q=new Va({props:{anchor:"transformers.VideoLlavaForConditionalGeneration.forward.example",$$slots:{default:[Ga]},$$scope:{ctx:Z}}}),He=new za({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/video_llava.md"}}),{c(){d=r("meta"),T=n(),v=r("p"),y=n(),p(M.$$.fragment),c=n(),b=r("div"),b.innerHTML=Pt,yo=n(),p(K.$$.fragment),Mo=n(),ee=r("p"),ee.textContent=Yt,bo=n(),oe=r("p"),oe.innerHTML=Xt,To=n(),te=r("p"),te.textContent=Ht,wo=n(),ae=r("p"),ae.innerHTML=qt,Jo=n(),p(ne.$$.fragment),jo=n(),se=r("ul"),se.innerHTML=Qt,Uo=n(),re=r("p"),re.innerHTML=Dt,Vo=n(),ie=r("blockquote"),ie.innerHTML=Ot,Io=n(),p(le.$$.fragment),ko=n(),p(de.$$.fragment),Lo=n(),ce=r("p"),ce.innerHTML=Kt,Co=n(),p(me.$$.fragment),xo=n(),pe=r("p"),pe.textContent=ea,zo=n(),p(he.$$.fragment),Zo=n(),p(ge.$$.fragment),$o=n(),fe=r("p"),fe.textContent=oa,Bo=n(),p(ue.$$.fragment),Wo=n(),p(_e.$$.fragment),Go=n(),p(ve.$$.fragment),Fo=n(),ye=r("p"),ye.textContent=ta,Ro=n(),Me=r("p"),Me.innerHTML=aa,No=n(),p(F.$$.fragment),Eo=n(),be=r("p"),be.innerHTML=na,So=n(),p(Te.$$.fragment),Ao=n(),p(we.$$.fragment),Po=n(),Je=r("p"),Je.innerHTML=sa,Yo=n(),je=r("p"),je.textContent=ra,Xo=n(),p(Ue.$$.fragment),Ho=n(),Ve=r("p"),Ve.innerHTML=ia,qo=n(),Ie=r("p"),Ie.innerHTML=la,Qo=n(),p(ke.$$.fragment),Do=n(),p(Le.$$.fragment),Oo=n(),j=r("div"),p(Ce.$$.fragment),gt=n(),De=r("p"),De.innerHTML=da,ft=n(),Oe=r("p"),Oe.innerHTML=ca,ut=n(),Ke=r("p"),Ke.innerHTML=ma,_t=n(),p(R.$$.fragment),Ko=n(),p(xe.$$.fragment),et=n(),k=r("div"),p(ze.$$.fragment),vt=n(),eo=r("p"),eo.textContent=pa,yt=n(),N=r("div"),p(Ze.$$.fragment),Mt=n(),oo=r("p"),oo.textContent=ha,bt=n(),E=r("div"),p($e.$$.fragment),Tt=n(),to=r("p"),to.textContent=ga,ot=n(),p(Be.$$.fragment),tt=n(),U=r("div"),p(We.$$.fragment),wt=n(),ao=r("p"),ao.textContent=fa,Jt=n(),no=r("p"),no.innerHTML=ua,jt=n(),S=r("div"),p(Ge.$$.fragment),Ut=n(),so=r("p"),so.innerHTML=_a,Vt=n(),A=r("div"),p(Fe.$$.fragment),It=n(),ro=r("p"),ro.innerHTML=va,at=n(),p(Re.$$.fragment),nt=n(),w=r("div"),p(Ne.$$.fragment),kt=n(),io=r("p"),io.innerHTML=ya,Lt=n(),lo=r("p"),lo.innerHTML=Ma,Ct=n(),G=r("div"),p(Ee.$$.fragment),xt=n(),co=r("p"),co.innerHTML=ba,zt=n(),p(P.$$.fragment),Zt=n(),Y=r("div"),p(Se.$$.fragment),$t=n(),mo=r("p"),mo.textContent=Ta,Bt=n(),X=r("div"),p(Ae.$$.fragment),Wt=n(),po=r("p"),po.textContent=wa,st=n(),p(Pe.$$.fragment),rt=n(),L=r("div"),p(Ye.$$.fragment),Gt=n(),ho=r("p"),ho.innerHTML=Ja,Ft=n(),go=r("p"),go.innerHTML=ja,Rt=n(),$=r("div"),p(Xe.$$.fragment),Nt=n(),fo=r("p"),fo.innerHTML=Ua,Et=n(),p(H.$$.fragment),St=n(),p(q.$$.fragment),it=n(),p(He.$$.fragment),lt=n(),_o=r("p"),this.h()},l(e){const o=xa("svelte-u9bgzb",document.head);d=i(o,"META",{name:!0,content:!0}),o.forEach(t),T=s(e),v=i(e,"P",{}),V(v).forEach(t),y=s(e),h(M.$$.fragment,e),c=s(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),m(b)!=="svelte-b95w5j"&&(b.innerHTML=Pt),yo=s(e),h(K.$$.fragment,e),Mo=s(e),ee=i(e,"P",{"data-svelte-h":!0}),m(ee)!=="svelte-81xura"&&(ee.textContent=Yt),bo=s(e),oe=i(e,"P",{"data-svelte-h":!0}),m(oe)!=="svelte-v87k6c"&&(oe.innerHTML=Xt),To=s(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-vfdo9a"&&(te.textContent=Ht),wo=s(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-sk56aa"&&(ae.innerHTML=qt),Jo=s(e),h(ne.$$.fragment,e),jo=s(e),se=i(e,"UL",{"data-svelte-h":!0}),m(se)!=="svelte-s3c9rf"&&(se.innerHTML=Qt),Uo=s(e),re=i(e,"P",{"data-svelte-h":!0}),m(re)!=="svelte-1lvcrum"&&(re.innerHTML=Dt),Vo=s(e),ie=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),m(ie)!=="svelte-nygwxc"&&(ie.innerHTML=Ot),Io=s(e),h(le.$$.fragment,e),ko=s(e),h(de.$$.fragment,e),Lo=s(e),ce=i(e,"P",{"data-svelte-h":!0}),m(ce)!=="svelte-1pauxcy"&&(ce.innerHTML=Kt),Co=s(e),h(me.$$.fragment,e),xo=s(e),pe=i(e,"P",{"data-svelte-h":!0}),m(pe)!=="svelte-1hi3kkd"&&(pe.textContent=ea),zo=s(e),h(he.$$.fragment,e),Zo=s(e),h(ge.$$.fragment,e),$o=s(e),fe=i(e,"P",{"data-svelte-h":!0}),m(fe)!=="svelte-1ngvr6w"&&(fe.textContent=oa),Bo=s(e),h(ue.$$.fragment,e),Wo=s(e),h(_e.$$.fragment,e),Go=s(e),h(ve.$$.fragment,e),Fo=s(e),ye=i(e,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-uomo89"&&(ye.textContent=ta),Ro=s(e),Me=i(e,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-mhaycu"&&(Me.innerHTML=aa),No=s(e),h(F.$$.fragment,e),Eo=s(e),be=i(e,"P",{"data-svelte-h":!0}),m(be)!=="svelte-1niphgd"&&(be.innerHTML=na),So=s(e),h(Te.$$.fragment,e),Ao=s(e),h(we.$$.fragment,e),Po=s(e),Je=i(e,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-m1vtfc"&&(Je.innerHTML=sa),Yo=s(e),je=i(e,"P",{"data-svelte-h":!0}),m(je)!=="svelte-13kjllm"&&(je.textContent=ra),Xo=s(e),h(Ue.$$.fragment,e),Ho=s(e),Ve=i(e,"P",{"data-svelte-h":!0}),m(Ve)!=="svelte-dzzatn"&&(Ve.innerHTML=ia),qo=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),m(Ie)!=="svelte-z3ioid"&&(Ie.innerHTML=la),Qo=s(e),h(ke.$$.fragment,e),Do=s(e),h(Le.$$.fragment,e),Oo=s(e),j=i(e,"DIV",{class:!0});var C=V(j);h(Ce.$$.fragment,C),gt=s(C),De=i(C,"P",{"data-svelte-h":!0}),m(De)!=="svelte-h7bus0"&&(De.innerHTML=da),ft=s(C),Oe=i(C,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-q9hjjl"&&(Oe.innerHTML=ca),ut=s(C),Ke=i(C,"P",{"data-svelte-h":!0}),m(Ke)!=="svelte-o55m63"&&(Ke.innerHTML=ma),_t=s(C),h(R.$$.fragment,C),C.forEach(t),Ko=s(e),h(xe.$$.fragment,e),et=s(e),k=i(e,"DIV",{class:!0});var W=V(k);h(ze.$$.fragment,W),vt=s(W),eo=i(W,"P",{"data-svelte-h":!0}),m(eo)!=="svelte-x48p92"&&(eo.textContent=pa),yt=s(W),N=i(W,"DIV",{class:!0});var qe=V(N);h(Ze.$$.fragment,qe),Mt=s(qe),oo=i(qe,"P",{"data-svelte-h":!0}),m(oo)!=="svelte-1x3yxsa"&&(oo.textContent=ha),qe.forEach(t),bt=s(W),E=i(W,"DIV",{class:!0});var Qe=V(E);h($e.$$.fragment,Qe),Tt=s(Qe),to=i(Qe,"P",{"data-svelte-h":!0}),m(to)!=="svelte-1qmgo6y"&&(to.textContent=ga),Qe.forEach(t),W.forEach(t),ot=s(e),h(Be.$$.fragment,e),tt=s(e),U=i(e,"DIV",{class:!0});var x=V(U);h(We.$$.fragment,x),wt=s(x),ao=i(x,"P",{"data-svelte-h":!0}),m(ao)!=="svelte-15aq8e1"&&(ao.textContent=fa),Jt=s(x),no=i(x,"P",{"data-svelte-h":!0}),m(no)!=="svelte-138492i"&&(no.innerHTML=ua),jt=s(x),S=i(x,"DIV",{class:!0});var ct=V(S);h(Ge.$$.fragment,ct),Ut=s(ct),so=i(ct,"P",{"data-svelte-h":!0}),m(so)!=="svelte-1o9eza"&&(so.innerHTML=_a),ct.forEach(t),Vt=s(x),A=i(x,"DIV",{class:!0});var mt=V(A);h(Fe.$$.fragment,mt),It=s(mt),ro=i(mt,"P",{"data-svelte-h":!0}),m(ro)!=="svelte-kk16qw"&&(ro.innerHTML=va),mt.forEach(t),x.forEach(t),at=s(e),h(Re.$$.fragment,e),nt=s(e),w=i(e,"DIV",{class:!0});var B=V(w);h(Ne.$$.fragment,B),kt=s(B),io=i(B,"P",{"data-svelte-h":!0}),m(io)!=="svelte-1au73ax"&&(io.innerHTML=ya),Lt=s(B),lo=i(B,"P",{"data-svelte-h":!0}),m(lo)!=="svelte-hswkmf"&&(lo.innerHTML=Ma),Ct=s(B),G=i(B,"DIV",{class:!0});var uo=V(G);h(Ee.$$.fragment,uo),xt=s(uo),co=i(uo,"P",{"data-svelte-h":!0}),m(co)!=="svelte-1fin1it"&&(co.innerHTML=ba),zt=s(uo),h(P.$$.fragment,uo),uo.forEach(t),Zt=s(B),Y=i(B,"DIV",{class:!0});var pt=V(Y);h(Se.$$.fragment,pt),$t=s(pt),mo=i(pt,"P",{"data-svelte-h":!0}),m(mo)!=="svelte-1vzo9k5"&&(mo.textContent=Ta),pt.forEach(t),Bt=s(B),X=i(B,"DIV",{class:!0});var ht=V(X);h(Ae.$$.fragment,ht),Wt=s(ht),po=i(ht,"P",{"data-svelte-h":!0}),m(po)!=="svelte-1pusxhn"&&(po.textContent=wa),ht.forEach(t),B.forEach(t),st=s(e),h(Pe.$$.fragment,e),rt=s(e),L=i(e,"DIV",{class:!0});var Q=V(L);h(Ye.$$.fragment,Q),Gt=s(Q),ho=i(Q,"P",{"data-svelte-h":!0}),m(ho)!=="svelte-1qwtcy"&&(ho.innerHTML=Ja),Ft=s(Q),go=i(Q,"P",{"data-svelte-h":!0}),m(go)!=="svelte-hswkmf"&&(go.innerHTML=ja),Rt=s(Q),$=i(Q,"DIV",{class:!0});var D=V($);h(Xe.$$.fragment,D),Nt=s(D),fo=i(D,"P",{"data-svelte-h":!0}),m(fo)!=="svelte-fmp8gd"&&(fo.innerHTML=Ua),Et=s(D),h(H.$$.fragment,D),St=s(D),h(q.$$.fragment,D),D.forEach(t),Q.forEach(t),it=s(e),h(He.$$.fragment,e),lt=s(e),_o=i(e,"P",{}),V(_o).forEach(t),this.h()},h(){J(d,"name","hf:doc:metadata"),J(d,"content",Ra),J(b,"class","flex flex-wrap space-x-1"),J(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),J(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){l(document.head,d),a(e,T,o),a(e,v,o),a(e,y,o),g(M,e,o),a(e,c,o),a(e,b,o),a(e,yo,o),g(K,e,o),a(e,Mo,o),a(e,ee,o),a(e,bo,o),a(e,oe,o),a(e,To,o),a(e,te,o),a(e,wo,o),a(e,ae,o),a(e,Jo,o),g(ne,e,o),a(e,jo,o),a(e,se,o),a(e,Uo,o),a(e,re,o),a(e,Vo,o),a(e,ie,o),a(e,Io,o),g(le,e,o),a(e,ko,o),g(de,e,o),a(e,Lo,o),a(e,ce,o),a(e,Co,o),g(me,e,o),a(e,xo,o),a(e,pe,o),a(e,zo,o),g(he,e,o),a(e,Zo,o),g(ge,e,o),a(e,$o,o),a(e,fe,o),a(e,Bo,o),g(ue,e,o),a(e,Wo,o),g(_e,e,o),a(e,Go,o),g(ve,e,o),a(e,Fo,o),a(e,ye,o),a(e,Ro,o),a(e,Me,o),a(e,No,o),g(F,e,o),a(e,Eo,o),a(e,be,o),a(e,So,o),g(Te,e,o),a(e,Ao,o),g(we,e,o),a(e,Po,o),a(e,Je,o),a(e,Yo,o),a(e,je,o),a(e,Xo,o),g(Ue,e,o),a(e,Ho,o),a(e,Ve,o),a(e,qo,o),a(e,Ie,o),a(e,Qo,o),g(ke,e,o),a(e,Do,o),g(Le,e,o),a(e,Oo,o),a(e,j,o),g(Ce,j,null),l(j,gt),l(j,De),l(j,ft),l(j,Oe),l(j,ut),l(j,Ke),l(j,_t),g(R,j,null),a(e,Ko,o),g(xe,e,o),a(e,et,o),a(e,k,o),g(ze,k,null),l(k,vt),l(k,eo),l(k,yt),l(k,N),g(Ze,N,null),l(N,Mt),l(N,oo),l(k,bt),l(k,E),g($e,E,null),l(E,Tt),l(E,to),a(e,ot,o),g(Be,e,o),a(e,tt,o),a(e,U,o),g(We,U,null),l(U,wt),l(U,ao),l(U,Jt),l(U,no),l(U,jt),l(U,S),g(Ge,S,null),l(S,Ut),l(S,so),l(U,Vt),l(U,A),g(Fe,A,null),l(A,It),l(A,ro),a(e,at,o),g(Re,e,o),a(e,nt,o),a(e,w,o),g(Ne,w,null),l(w,kt),l(w,io),l(w,Lt),l(w,lo),l(w,Ct),l(w,G),g(Ee,G,null),l(G,xt),l(G,co),l(G,zt),g(P,G,null),l(w,Zt),l(w,Y),g(Se,Y,null),l(Y,$t),l(Y,mo),l(w,Bt),l(w,X),g(Ae,X,null),l(X,Wt),l(X,po),a(e,st,o),g(Pe,e,o),a(e,rt,o),a(e,L,o),g(Ye,L,null),l(L,Gt),l(L,ho),l(L,Ft),l(L,go),l(L,Rt),l(L,$),g(Xe,$,null),l($,Nt),l($,fo),l($,Et),g(H,$,null),l($,St),g(q,$,null),a(e,it,o),g(He,e,o),a(e,lt,o),a(e,_o,o),dt=!0},p(e,[o]){const C={};o&2&&(C.$$scope={dirty:o,ctx:e}),F.$set(C);const W={};o&2&&(W.$$scope={dirty:o,ctx:e}),R.$set(W);const qe={};o&2&&(qe.$$scope={dirty:o,ctx:e}),P.$set(qe);const Qe={};o&2&&(Qe.$$scope={dirty:o,ctx:e}),H.$set(Qe);const x={};o&2&&(x.$$scope={dirty:o,ctx:e}),q.$set(x)},i(e){dt||(f(M.$$.fragment,e),f(K.$$.fragment,e),f(ne.$$.fragment,e),f(le.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(he.$$.fragment,e),f(ge.$$.fragment,e),f(ue.$$.fragment,e),f(_e.$$.fragment,e),f(ve.$$.fragment,e),f(F.$$.fragment,e),f(Te.$$.fragment,e),f(we.$$.fragment,e),f(Ue.$$.fragment,e),f(ke.$$.fragment,e),f(Le.$$.fragment,e),f(Ce.$$.fragment,e),f(R.$$.fragment,e),f(xe.$$.fragment,e),f(ze.$$.fragment,e),f(Ze.$$.fragment,e),f($e.$$.fragment,e),f(Be.$$.fragment,e),f(We.$$.fragment,e),f(Ge.$$.fragment,e),f(Fe.$$.fragment,e),f(Re.$$.fragment,e),f(Ne.$$.fragment,e),f(Ee.$$.fragment,e),f(P.$$.fragment,e),f(Se.$$.fragment,e),f(Ae.$$.fragment,e),f(Pe.$$.fragment,e),f(Ye.$$.fragment,e),f(Xe.$$.fragment,e),f(H.$$.fragment,e),f(q.$$.fragment,e),f(He.$$.fragment,e),dt=!0)},o(e){u(M.$$.fragment,e),u(K.$$.fragment,e),u(ne.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(ge.$$.fragment,e),u(ue.$$.fragment,e),u(_e.$$.fragment,e),u(ve.$$.fragment,e),u(F.$$.fragment,e),u(Te.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(Le.$$.fragment,e),u(Ce.$$.fragment,e),u(R.$$.fragment,e),u(xe.$$.fragment,e),u(ze.$$.fragment,e),u(Ze.$$.fragment,e),u($e.$$.fragment,e),u(Be.$$.fragment,e),u(We.$$.fragment,e),u(Ge.$$.fragment,e),u(Fe.$$.fragment,e),u(Re.$$.fragment,e),u(Ne.$$.fragment,e),u(Ee.$$.fragment,e),u(P.$$.fragment,e),u(Se.$$.fragment,e),u(Ae.$$.fragment,e),u(Pe.$$.fragment,e),u(Ye.$$.fragment,e),u(Xe.$$.fragment,e),u(H.$$.fragment,e),u(q.$$.fragment,e),u(He.$$.fragment,e),dt=!1},d(e){e&&(t(T),t(v),t(y),t(c),t(b),t(yo),t(Mo),t(ee),t(bo),t(oe),t(To),t(te),t(wo),t(ae),t(Jo),t(jo),t(se),t(Uo),t(re),t(Vo),t(ie),t(Io),t(ko),t(Lo),t(ce),t(Co),t(xo),t(pe),t(zo),t(Zo),t($o),t(fe),t(Bo),t(Wo),t(Go),t(Fo),t(ye),t(Ro),t(Me),t(No),t(Eo),t(be),t(So),t(Ao),t(Po),t(Je),t(Yo),t(je),t(Xo),t(Ho),t(Ve),t(qo),t(Ie),t(Qo),t(Do),t(Oo),t(j),t(Ko),t(et),t(k),t(ot),t(tt),t(U),t(at),t(nt),t(w),t(st),t(rt),t(L),t(it),t(lt),t(_o)),t(d),_(M,e),_(K,e),_(ne,e),_(le,e),_(de,e),_(me,e),_(he,e),_(ge,e),_(ue,e),_(_e,e),_(ve,e),_(F,e),_(Te,e),_(we,e),_(Ue,e),_(ke,e),_(Le,e),_(Ce),_(R),_(xe,e),_(ze),_(Ze),_($e),_(Be,e),_(We),_(Ge),_(Fe),_(Re,e),_(Ne),_(Ee),_(P),_(Se),_(Ae),_(Pe,e),_(Ye),_(Xe),_(H),_(q),_(He,e)}}}const Ra='{"title":"Video-LLaVA","local":"video-llava","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips:","local":"usage-tips","sections":[],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single Media Mode","local":"single-media-mode","sections":[],"depth":3},{"title":"Mixed Media Mode","local":"mixed-media-mode","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes for memory efficiency","local":"quantization-using-bitsandbytes-for-memory-efficiency","sections":[],"depth":3},{"title":"Flash-Attention 2 to speed-up generation","local":"flash-attention-2-to-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"VideoLlavaConfig","local":"transformers.VideoLlavaConfig","sections":[],"depth":2},{"title":"VideoLlavaImageProcessor","local":"transformers.VideoLlavaImageProcessor","sections":[],"depth":2},{"title":"VideoLlavaProcessor","local":"transformers.VideoLlavaProcessor","sections":[],"depth":2},{"title":"VideoLlavaModel","local":"transformers.VideoLlavaModel","sections":[],"depth":2},{"title":"VideoLlavaForConditionalGeneration","local":"transformers.VideoLlavaForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Na(Z){return ka(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Qa extends La{constructor(d){super(),Ca(this,d,Na,Fa,Ia,{})}}export{Qa as component};
