import{s as ns,z as as,o as rs,n as io}from"../chunks/scheduler.18a86fab.js";import{S as is,i as ls,g as l,s,r as p,A as ds,h as d,f as t,c as n,j as $,u as h,x as b,k as T,y as i,a,v as g,d as f,t as u,w as _}from"../chunks/index.98837b22.js";import{T as Yt}from"../chunks/Tip.77304350.js";import{D as Y}from"../chunks/Docstring.6758ea23.js";import{C as Bo}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as zt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{P as cs}from"../chunks/PipelineTag.7749150e.js";import{H as q}from"../chunks/Heading.7e7e0c5b.js";import{E as ms}from"../chunks/index.499f366c.js";function ps(z){let r,v='Use <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosImageProcessor">YolosImageProcessor</a> for preparing images (and optional targets) for the model. Contrary to <a href="detr">DETR</a>, YOLOS doesn’t require a <code>pixel_mask</code> to be created.';return{c(){r=l("p"),r.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-19j5avc"&&(r.innerHTML=v)},m(m,y){a(m,r,y)},p:io,d(m){m&&t(r)}}}function hs(z){let r,v="Example:",m,y,w;return y=new Bo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFlvbG9zQ29uZmlnJTJDJTIwWW9sb3NNb2RlbCUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBZT0xPUyUyMGh1c3R2bCUyRnlvbG9zLWJhc2UlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwWW9sb3NDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMCh3aXRoJTIwcmFuZG9tJTIwd2VpZ2h0cyklMjBmcm9tJTIwdGhlJTIwaHVzdHZsJTJGeW9sb3MtYmFzZSUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> YolosConfig, YolosModel

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a YOLOS hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = YolosConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model (with random weights) from the hustvl/yolos-base style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){r=l("p"),r.textContent=v,m=s(),p(y.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-11lpom8"&&(r.textContent=v),m=n(c),h(y.$$.fragment,c)},m(c,x){a(c,r,x),a(c,m,x),g(y,c,x),w=!0},p:io,i(c){w||(f(y.$$.fragment,c),w=!0)},o(c){u(y.$$.fragment,c),w=!1},d(c){c&&(t(r),t(m)),_(y,c)}}}function gs(z){let r,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-fincs2"&&(r.innerHTML=v)},m(m,y){a(m,r,y)},p:io,d(m){m&&t(r)}}}function fs(z){let r,v="Example:",m,y,w;return y=new Bo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFlvbG9zTW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaHVnZ2luZ2ZhY2UlMkZjYXRzLWltYWdlJTIyJTJDJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlKSUwQWltYWdlJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRlc3QlMjIlNUQlNUIlMjJpbWFnZSUyMiU1RCU1QjAlNUQlMEElMEFpbWFnZV9wcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXNtYWxsJTIyKSUwQW1vZGVsJTIwJTNEJTIwWW9sb3NNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyaHVzdHZsJTJGeW9sb3Mtc21hbGwlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQWxhc3RfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMG91dHB1dHMubGFzdF9oaWRkZW5fc3RhdGUlMEFsaXN0KGxhc3RfaGlkZGVuX3N0YXRlcy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, YolosModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;huggingface/cats-image&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = dataset[<span class="hljs-string">&quot;test&quot;</span>][<span class="hljs-string">&quot;image&quot;</span>][<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = YolosModel.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-small&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_states = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_states.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">3401</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=v,m=s(),p(y.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-11lpom8"&&(r.textContent=v),m=n(c),h(y.$$.fragment,c)},m(c,x){a(c,r,x),a(c,m,x),g(y,c,x),w=!0},p:io,i(c){w||(f(y.$$.fragment,c),w=!0)},o(c){u(y.$$.fragment,c),w=!1},d(c){c&&(t(r),t(m)),_(y,c)}}}function us(z){let r,v=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){r=l("p"),r.innerHTML=v},l(m){r=d(m,"P",{"data-svelte-h":!0}),b(r)!=="svelte-fincs2"&&(r.innerHTML=v)},m(m,y){a(m,r,y)},p:io,d(m){m&&t(r)}}}function _s(z){let r,v="Examples:",m,y,w;return y=new Bo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjBvdXRwdXRzJTIwKGJvdW5kaW5nJTIwYm94ZXMlMjBhbmQlMjBjbGFzcyUyMGxvZ2l0cyklMjB0byUyMFBhc2NhbCUyMFZPQyUyMGZvcm1hdCUyMCh4bWluJTJDJTIweW1pbiUyQyUyMHhtYXglMkMlMjB5bWF4KSUwQXRhcmdldF9zaXplcyUyMCUzRCUyMHRvcmNoLnRlbnNvciglNUJpbWFnZS5zaXplJTVCJTNBJTNBLTElNUQlNUQpJTBBcmVzdWx0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3Nvci5wb3N0X3Byb2Nlc3Nfb2JqZWN0X2RldGVjdGlvbihvdXRwdXRzJTJDJTIwdGhyZXNob2xkJTNEMC45JTJDJTIwdGFyZ2V0X3NpemVzJTNEdGFyZ2V0X3NpemVzKSU1QiUwQSUyMCUyMCUyMCUyMDAlMEElNUQlMEElMEFmb3IlMjBzY29yZSUyQyUyMGxhYmVsJTJDJTIwYm94JTIwaW4lMjB6aXAocmVzdWx0cyU1QiUyMnNjb3JlcyUyMiU1RCUyQyUyMHJlc3VsdHMlNUIlMjJsYWJlbHMlMjIlNUQlMkMlMjByZXN1bHRzJTVCJTIyYm94ZXMlMjIlNUQpJTNBJTBBJTIwJTIwJTIwJTIwYm94JTIwJTNEJTIwJTVCcm91bmQoaSUyQyUyMDIpJTIwZm9yJTIwaSUyMGluJTIwYm94LnRvbGlzdCgpJTVEJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZiUyMkRldGVjdGVkJTIwJTdCbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCbGFiZWwuaXRlbSgpJTVEJTdEJTIwd2l0aCUyMGNvbmZpZGVuY2UlMjAlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmJTIyJTdCcm91bmQoc2NvcmUuaXRlbSgpJTJDJTIwMyklN0QlMjBhdCUyMGxvY2F0aW9uJTIwJTdCYm94JTdEJTIyJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># convert outputs (bounding boxes and class logits) to Pascal VOC format (xmin, ymin, xmax, ymax)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[
<span class="hljs-meta">... </span>    <span class="hljs-number">0</span>
<span class="hljs-meta">... </span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> score, label, box <span class="hljs-keyword">in</span> <span class="hljs-built_in">zip</span>(results[<span class="hljs-string">&quot;scores&quot;</span>], results[<span class="hljs-string">&quot;labels&quot;</span>], results[<span class="hljs-string">&quot;boxes&quot;</span>]):
<span class="hljs-meta">... </span>    box = [<span class="hljs-built_in">round</span>(i, <span class="hljs-number">2</span>) <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> box.tolist()]
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;Detected <span class="hljs-subst">{model.config.id2label[label.item()]}</span> with confidence &quot;</span>
<span class="hljs-meta">... </span>        <span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">round</span>(score.item(), <span class="hljs-number">3</span>)}</span> at location <span class="hljs-subst">{box}</span>&quot;</span>
<span class="hljs-meta">... </span>    )
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.991</span> at location [<span class="hljs-number">46.48</span>, <span class="hljs-number">72.78</span>, <span class="hljs-number">178.98</span>, <span class="hljs-number">119.3</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.908</span> at location [<span class="hljs-number">336.48</span>, <span class="hljs-number">79.27</span>, <span class="hljs-number">368.23</span>, <span class="hljs-number">192.36</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.934</span> at location [<span class="hljs-number">337.18</span>, <span class="hljs-number">18.06</span>, <span class="hljs-number">638.14</span>, <span class="hljs-number">373.09</span>]
Detected cat <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.979</span> at location [<span class="hljs-number">10.93</span>, <span class="hljs-number">53.74</span>, <span class="hljs-number">313.41</span>, <span class="hljs-number">470.67</span>]
Detected remote <span class="hljs-keyword">with</span> confidence <span class="hljs-number">0.974</span> at location [<span class="hljs-number">41.63</span>, <span class="hljs-number">72.23</span>, <span class="hljs-number">178.09</span>, <span class="hljs-number">119.99</span>]`,wrap:!1}}),{c(){r=l("p"),r.textContent=v,m=s(),p(y.$$.fragment)},l(c){r=d(c,"P",{"data-svelte-h":!0}),b(r)!=="svelte-kvfsh7"&&(r.textContent=v),m=n(c),h(y.$$.fragment,c)},m(c,x){a(c,r,x),a(c,m,x),g(y,c,x),w=!0},p:io,i(c){w||(f(y.$$.fragment,c),w=!0)},o(c){u(y.$$.fragment,c),w=!1},d(c){c&&(t(r),t(m)),_(y,c)}}}function bs(z){let r,v,m,y,w,c,x,Mt='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',mo,te,po,se,jt=`The YOLOS model was proposed in <a href="https://arxiv.org/abs/2106.00666" rel="nofollow">You Only Look at One Sequence: Rethinking Transformer in Vision through Object Detection</a> by Yuxin Fang, Bencheng Liao, Xinggang Wang, Jiemin Fang, Jiyang Qi, Rui Wu, Jianwei Niu, Wenyu Liu.
YOLOS proposes to just leverage the plain <a href="vit">Vision Transformer (ViT)</a> for object detection, inspired by DETR. It turns out that a base-sized encoder-only Transformer can also achieve 42 AP on COCO, similar to DETR and much more complex frameworks such as Faster R-CNN.`,ho,ne,Ct="The abstract from the paper is the following:",go,ae,Ft="<em>Can Transformer perform 2D object- and region-level recognition from a pure sequence-to-sequence perspective with minimal knowledge about the 2D spatial structure? To answer this question, we present You Only Look at One Sequence (YOLOS), a series of object detection models based on the vanilla Vision Transformer with the fewest possible modifications, region priors, as well as inductive biases of the target task. We find that YOLOS pre-trained on the mid-sized ImageNet-1k dataset only can already achieve quite competitive performance on the challenging COCO object detection benchmark, e.g., YOLOS-Base directly adopted from BERT-Base architecture can obtain 42.0 box AP on COCO val. We also discuss the impacts as well as limitations of current pre-train schemes and model scaling strategies for Transformer in vision through YOLOS.</em>",fo,L,Pt,uo,re,Jt='YOLOS architecture. Taken from the <a href="https://arxiv.org/abs/2106.00666">original paper</a>.',_o,ie,Dt='This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found <a href="https://github.com/hustvl/YOLOS" rel="nofollow">here</a>.',bo,le,yo,de,Ut=`PyTorch includes a native scaled dot-product attention (SDPA) operator as part of <code>torch.nn.functional</code>. This function
encompasses several implementations that can be applied depending on the inputs and the hardware in use. See the
<a href="https://pytorch.org/docs/stable/generated/torch.nn.functional.scaled_dot_product_attention.html" rel="nofollow">official documentation</a>
or the <a href="https://huggingface.co/docs/transformers/main/en/perf_infer_gpu_one#pytorch-scaled-dot-product-attention" rel="nofollow">GPU Inference</a>
page for more information.`,vo,ce,kt=`SDPA is used by default for <code>torch&gt;=2.1.1</code> when an implementation is available, but you may also set
<code>attn_implementation=&quot;sdpa&quot;</code> in <code>from_pretrained()</code> to explicitly request SDPA to be used.`,wo,me,To,pe,qt="For the best speedups, we recommend loading the model in half-precision (e.g. <code>torch.float16</code> or <code>torch.bfloat16</code>).",xo,he,Nt="On a local benchmark (A100-40GB, PyTorch 2.3.0, OS Ubuntu 22.04) with <code>float32</code> and <code>hustvl/yolos-base</code> model, we saw the following speedups during inference.",$o,ge,Lt="<thead><tr><th>Batch size</th> <th>Average inference time (ms), eager mode</th> <th>Average inference time (ms), sdpa model</th> <th>Speed up, Sdpa / Eager (x)</th></tr></thead> <tbody><tr><td>1</td> <td>106</td> <td>76</td> <td>1.39</td></tr> <tr><td>2</td> <td>154</td> <td>90</td> <td>1.71</td></tr> <tr><td>4</td> <td>222</td> <td>116</td> <td>1.91</td></tr> <tr><td>8</td> <td>368</td> <td>168</td> <td>2.19</td></tr></tbody>",Io,fe,Yo,ue,Ot="A list of official Hugging Face and community (indicated by 🌎) resources to help you get started with YOLOS.",zo,_e,Mo,be,Rt='<li>All example notebooks illustrating inference + fine-tuning <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> on a custom dataset can be found <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/YOLOS" rel="nofollow">here</a>.</li> <li>Scripts for finetuning <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> with <a href="/docs/transformers/main/en/main_classes/trainer#transformers.Trainer">Trainer</a> or <a href="https://huggingface.co/docs/accelerate/index" rel="nofollow">Accelerate</a> can be found <a href="https://github.com/huggingface/transformers/tree/main/examples/pytorch/object-detection" rel="nofollow">here</a>.</li> <li>See also: <a href="../tasks/object_detection">Object detection task guide</a></li>',jo,ye,Wt="If you’re interested in submitting a resource to be included here, please feel free to open a Pull Request and we’ll review it! The resource should ideally demonstrate something new instead of duplicating an existing resource.",Co,O,Fo,ve,Po,M,we,Xo,Se,Et=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosModel">YolosModel</a>. It is used to instantiate a YOLOS
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the YOLOS
<a href="https://huggingface.co/hustvl/yolos-base" rel="nofollow">hustvl/yolos-base</a> architecture.`,Qo,Ze,St=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ko,R,Jo,Te,Do,D,xe,et,Ve,Zt="Constructs a Detr image processor.",ot,W,$e,tt,Ge,Vt="Preprocess an image or a batch of images so that it can be used by the model.",Uo,Ie,ko,I,Ye,st,Ae,Gt="Constructs a fast Yolos image processor.",nt,E,ze,at,He,At="Preprocess an image or batch of images.",rt,Be,Me,it,S,je,lt,Xe,Ht=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x,
top_left_y, bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,qo,Ce,No,j,Fe,dt,Z,Pe,ct,Qe,Bt="Preprocess an image or a batch of images.",mt,V,Je,pt,Ke,Xt=`Pads a batch of images to the bottom and right of the image with zeros to the size of largest height and width
in the batch and optionally returns their corresponding pixel mask.`,ht,G,De,gt,eo,Qt=`Converts the raw output of <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> into final bounding boxes in (top_left_x, top_left_y,
bottom_right_x, bottom_right_y) format. Only supports PyTorch.`,Lo,Ue,Oo,U,ke,ft,oo,Kt=`The bare YOLOS Model transformer outputting raw hidden-states without any specific head on top.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ut,P,qe,_t,to,es='The <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosModel">YolosModel</a> forward method, overrides the <code>__call__</code> special method.',bt,A,yt,H,Ro,Ne,Wo,C,Le,vt,so,os="YOLOS Model (consisting of a ViT encoder) with object detection heads on top, for tasks such as COCO detection.",wt,no,ts=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass. Use it
as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Tt,J,Oe,xt,ao,ss='The <a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosForObjectDetection">YolosForObjectDetection</a> forward method, overrides the <code>__call__</code> special method.',$t,B,It,X,Eo,Re,So,lo,Zo;return w=new q({props:{title:"YOLOS",local:"yolos",headingTag:"h1"}}),te=new q({props:{title:"Overview",local:"overview",headingTag:"h2"}}),le=new q({props:{title:"Using Scaled Dot Product Attention (SDPA)",local:"using-scaled-dot-product-attention-sdpa",headingTag:"h2"}}),me=new Bo({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yT2JqZWN0RGV0ZWN0aW9uLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy1iYXNlJTIyJTJDJTIwYXR0bl9pbXBsZW1lbnRhdGlvbiUzRCUyMnNkcGElMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBLi4u",highlighted:`from transformers import AutoModelForObjectDetection
model = <span class="hljs-module-access"><span class="hljs-module"><span class="hljs-identifier">AutoModelForObjectDetection</span>.</span></span>from<span class="hljs-constructor">_pretrained(<span class="hljs-string">&quot;hustvl/yolos-base&quot;</span>, <span class="hljs-params">attn_implementation</span>=<span class="hljs-string">&quot;sdpa&quot;</span>, <span class="hljs-params">torch_dtype</span>=<span class="hljs-params">torch</span>.<span class="hljs-params">float16</span>)</span>
...`,wrap:!1}}),fe=new q({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_e=new cs({props:{pipeline:"object-detection"}}),O=new Yt({props:{$$slots:{default:[ps]},$$scope:{ctx:z}}}),ve=new q({props:{title:"YolosConfig",local:"transformers.YolosConfig",headingTag:"h2"}}),we=new Y({props:{name:"class transformers.YolosConfig",anchor:"transformers.YolosConfig",parameters:[{name:"hidden_size",val:" = 768"},{name:"num_hidden_layers",val:" = 12"},{name:"num_attention_heads",val:" = 12"},{name:"intermediate_size",val:" = 3072"},{name:"hidden_act",val:" = 'gelu'"},{name:"hidden_dropout_prob",val:" = 0.0"},{name:"attention_probs_dropout_prob",val:" = 0.0"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"image_size",val:" = [512, 864]"},{name:"patch_size",val:" = 16"},{name:"num_channels",val:" = 3"},{name:"qkv_bias",val:" = True"},{name:"num_detection_tokens",val:" = 100"},{name:"use_mid_position_embeddings",val:" = True"},{name:"auxiliary_loss",val:" = False"},{name:"class_cost",val:" = 1"},{name:"bbox_cost",val:" = 5"},{name:"giou_cost",val:" = 2"},{name:"bbox_loss_coefficient",val:" = 5"},{name:"giou_loss_coefficient",val:" = 2"},{name:"eos_coefficient",val:" = 0.1"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimensionality of the encoder layers and the pooler layer.`,name:"hidden_size"},{anchor:"transformers.YolosConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of hidden layers in the Transformer encoder.`,name:"num_hidden_layers"},{anchor:"transformers.YolosConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 12) &#x2014;
Number of attention heads for each attention layer in the Transformer encoder.`,name:"num_attention_heads"},{anchor:"transformers.YolosConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 3072) &#x2014;
Dimensionality of the &#x201C;intermediate&#x201D; (i.e., feed-forward) layer in the Transformer encoder.`,name:"intermediate_size"},{anchor:"transformers.YolosConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.YolosConfig.hidden_dropout_prob",description:`<strong>hidden_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout probability for all fully connected layers in the embeddings, encoder, and pooler.`,name:"hidden_dropout_prob"},{anchor:"transformers.YolosConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.YolosConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.YolosConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.YolosConfig.image_size",description:`<strong>image_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[512, 864]</code>) &#x2014;
The size (resolution) of each image.`,name:"image_size"},{anchor:"transformers.YolosConfig.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
The size (resolution) of each patch.`,name:"patch_size"},{anchor:"transformers.YolosConfig.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
The number of input channels.`,name:"num_channels"},{anchor:"transformers.YolosConfig.qkv_bias",description:`<strong>qkv_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a bias to the queries, keys and values.`,name:"qkv_bias"},{anchor:"transformers.YolosConfig.num_detection_tokens",description:`<strong>num_detection_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
The number of detection tokens.`,name:"num_detection_tokens"},{anchor:"transformers.YolosConfig.use_mid_position_embeddings",description:`<strong>use_mid_position_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use the mid-layer position encodings.`,name:"use_mid_position_embeddings"},{anchor:"transformers.YolosConfig.auxiliary_loss",description:`<strong>auxiliary_loss</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether auxiliary decoding losses (loss at each decoder layer) are to be used.`,name:"auxiliary_loss"},{anchor:"transformers.YolosConfig.class_cost",description:`<strong>class_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 1) &#x2014;
Relative weight of the classification error in the Hungarian matching cost.`,name:"class_cost"},{anchor:"transformers.YolosConfig.bbox_cost",description:`<strong>bbox_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 error of the bounding box coordinates in the Hungarian matching cost.`,name:"bbox_cost"},{anchor:"transformers.YolosConfig.giou_cost",description:`<strong>giou_cost</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss of the bounding box in the Hungarian matching cost.`,name:"giou_cost"},{anchor:"transformers.YolosConfig.bbox_loss_coefficient",description:`<strong>bbox_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 5) &#x2014;
Relative weight of the L1 bounding box loss in the object detection loss.`,name:"bbox_loss_coefficient"},{anchor:"transformers.YolosConfig.giou_loss_coefficient",description:`<strong>giou_loss_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 2) &#x2014;
Relative weight of the generalized IoU loss in the object detection loss.`,name:"giou_loss_coefficient"},{anchor:"transformers.YolosConfig.eos_coefficient",description:`<strong>eos_coefficient</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
Relative classification weight of the &#x2018;no-object&#x2019; class in the object detection loss.`,name:"eos_coefficient"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/configuration_yolos.py#L30"}}),R=new zt({props:{anchor:"transformers.YolosConfig.example",$$slots:{default:[hs]},$$scope:{ctx:z}}}),Te=new q({props:{title:"YolosImageProcessor",local:"transformers.YolosImageProcessor",headingTag:"h2"}}),xe=new Y({props:{name:"class transformers.YolosImageProcessor",anchor:"transformers.YolosImageProcessor",parameters:[{name:"format",val:": typing.Union[str, transformers.image_utils.AnnotationFormat] = <AnnotationFormat.COCO_DETECTION: 'coco_detection'>"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:": Resampling = <Resampling.BILINEAR: 2>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"do_pad",val:": bool = True"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;coco_detection&quot;</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be
overridden by the <code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 800, &quot;longest_edge&quot;: 1333}</code>):
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Can be overridden by the <code>size</code> parameter
in the <code>preprocess</code> method. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.YolosImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BILINEAR</code>) &#x2014;
Resampling filter to use if resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter in the
<code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.do_normalize",description:`<strong>do_normalize</strong> &#x2014;
Controls whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the
<code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_MEAN</code>) &#x2014;
Mean values to use when normalizing the image. Can be a single value or a list of values, one for each
channel. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_DEFAULT_STD</code>) &#x2014;
Standard deviation values to use when normalizing the image. Can be a single value or a list of values, one
for each channel. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L724"}}),$e=new Y({props:{name:"preprocess",anchor:"transformers.YolosImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"annotations",val:": typing.Union[dict[str, typing.Union[int, str, list[dict]]], typing.List[dict[str, typing.Union[int, str, list[dict]]]], NoneType] = None"},{name:"return_segmentation_masks",val:": typing.Optional[bool] = None"},{name:"masks_path",val:": typing.Union[pathlib.Path, str, NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"resample",val:" = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Union[int, float, NoneType] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_convert_annotations",val:": typing.Optional[bool] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"format",val:": typing.Union[str, transformers.image_utils.AnnotationFormat, NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.YolosImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image or batch of images to preprocess. Expects a single or batch of images with pixel values ranging
from 0 to 255. If passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.YolosImageProcessor.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to self.return_segmentation_masks) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.YolosImageProcessor.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"},{anchor:"transformers.YolosImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_resize) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to self.size) &#x2014;
Size of the image&#x2019;s <code>(height, width)</code> dimensions after resizing. Available options are:<ul>
<li><code>{&quot;height&quot;: int, &quot;width&quot;: int}</code>: The image will be resized to the exact size <code>(height, width)</code>.
Do NOT keep the aspect ratio.</li>
<li><code>{&quot;shortest_edge&quot;: int, &quot;longest_edge&quot;: int}</code>: The image will be resized to a maximum size respecting
the aspect ratio and keeping the shortest edge less or equal to <code>shortest_edge</code> and the longest edge
less or equal to <code>longest_edge</code>.</li>
<li><code>{&quot;max_height&quot;: int, &quot;max_width&quot;: int}</code>: The image will be resized to the maximum size respecting the
aspect ratio and keeping the height less or equal to <code>max_height</code> and the width less or equal to
<code>max_width</code>.</li>
</ul>`,name:"size"},{anchor:"transformers.YolosImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to self.resample) &#x2014;
Resampling filter to use when resizing the image.`,name:"resample"},{anchor:"transformers.YolosImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_rescale) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to self.rescale_factor) &#x2014;
Rescale factor to use when rescaling the image.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_normalize) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_mean) &#x2014;
Mean to use when normalizing the image.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to self.image_std) &#x2014;
Standard deviation to use when normalizing the image.`,name:"image_std"},{anchor:"transformers.YolosImageProcessor.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_convert_annotations) &#x2014;
Whether to convert the annotations to the format expected by the model. Converts the bounding
boxes from the format <code>(top_left_x, top_left_y, width, height)</code> to <code>(center_x, center_y, width, height)</code>
and in relative coordinates.`,name:"do_convert_annotations"},{anchor:"transformers.YolosImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to self.do_pad) &#x2014;
Whether to pad the image. If <code>True</code>, padding will be applied to the bottom and right of
the image with zeros. If <code>pad_size</code> is provided, the image will be padded to the specified
dimensions. Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessor.preprocess.format",description:`<strong>format</strong> (<code>str</code> or <code>AnnotationFormat</code>, <em>optional</em>, defaults to self.format) &#x2014;
Format of the annotations.`,name:"format"},{anchor:"transformers.YolosImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to self.return_tensors) &#x2014;
Type of tensors to return. If <code>None</code>, will return the list of images.`,name:"return_tensors"},{anchor:"transformers.YolosImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>, defaults to self.data_format) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.YolosImageProcessor.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L1178"}}),Ie=new q({props:{title:"YolosImageProcessorFast",local:"transformers.YolosImageProcessorFast",headingTag:"h2"}}),Ye=new Y({props:{name:"class transformers.YolosImageProcessorFast",anchor:"transformers.YolosImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.yolos.image_processing_yolos_fast.YolosFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.YolosImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.YolosImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.YolosImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.YolosImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.YolosImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.YolosImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.YolosImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.YolosImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.YolosImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.YolosImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.YolosImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.YolosImageProcessorFast.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessorFast.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the YOLOS model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.YolosImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessorFast.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"},{anchor:"transformers.YolosImageProcessorFast.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos_fast.py#L317"}}),ze=new Y({props:{name:"preprocess",anchor:"transformers.YolosImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"annotations",val:": typing.Union[dict[str, typing.Union[int, str, list[dict]]], typing.List[dict[str, typing.Union[int, str, list[dict]]]], NoneType] = None"},{name:"masks_path",val:": typing.Union[pathlib.Path, str, NoneType] = None"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.yolos.image_processing_yolos_fast.YolosFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.YolosImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.YolosImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.YolosImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.YolosImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.YolosImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.YolosImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.YolosImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.YolosImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.YolosImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.YolosImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.YolosImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.YolosImageProcessorFast.preprocess.annotations",description:`<strong>annotations</strong> (<code>AnnotationType</code> or <code>List[AnnotationType]</code>, <em>optional</em>) &#x2014;
List of annotations associated with the image or batch of images. If annotation is for object
detection, the annotations should be a dictionary with the following keys:<ul>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;annotations&#x201D; (<code>List[Dict]</code>): List of annotations for an image. Each annotation should be a
dictionary. An image can have no annotations, in which case the list should be empty.
If annotation is for segmentation, the annotations should be a dictionary with the following keys:</li>
<li>&#x201C;image_id&#x201D; (<code>int</code>): The image id.</li>
<li>&#x201C;segments_info&#x201D; (<code>List[Dict]</code>): List of segments for an image. Each segment should be a dictionary.
An image can have no segments, in which case the list should be empty.</li>
<li>&#x201C;file_name&#x201D; (<code>str</code>): The file name of the image.</li>
</ul>`,name:"annotations"},{anchor:"transformers.YolosImageProcessorFast.preprocess.format",description:`<strong>format</strong> (<code>str</code>, <em>optional</em>, defaults to <code>AnnotationFormat.COCO_DETECTION</code>) &#x2014;
Data format of the annotations. One of &#x201C;coco_detection&#x201D; or &#x201C;coco_panoptic&#x201D;.`,name:"format"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_convert_annotations",description:`<strong>do_convert_annotations</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to convert the annotations to the format expected by the YOLOS model. Converts the
bounding boxes to the format <code>(center_x, center_y, width, height)</code> and in the range <code>[0, 1]</code>.
Can be overridden by the <code>do_convert_annotations</code> parameter in the <code>preprocess</code> method.`,name:"do_convert_annotations"},{anchor:"transformers.YolosImageProcessorFast.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Controls whether to pad the image. Can be overridden by the <code>do_pad</code> parameter in the <code>preprocess</code>
method. If <code>True</code>, padding will be applied to the bottom and right of the image with zeros.
If <code>pad_size</code> is provided, the image will be padded to the specified dimensions.
Otherwise, the image will be padded to the maximum height and width of the batch.`,name:"do_pad"},{anchor:"transformers.YolosImageProcessorFast.preprocess.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"},{anchor:"transformers.YolosImageProcessorFast.preprocess.return_segmentation_masks",description:`<strong>return_segmentation_masks</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to return segmentation masks.`,name:"return_segmentation_masks"},{anchor:"transformers.YolosImageProcessorFast.preprocess.masks_path",description:`<strong>masks_path</strong> (<code>str</code> or <code>pathlib.Path</code>, <em>optional</em>) &#x2014;
Path to the directory containing the segmentation masks.`,name:"masks_path"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos_fast.py#L613"}}),Me=new Y({props:{name:"pad",anchor:"transformers.YolosImageProcessorFast.pad",parameters:[{name:"image",val:": Tensor"},{name:"padded_size",val:": typing.Tuple[int, int]"},{name:"annotation",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"update_bboxes",val:": bool = True"},{name:"fill",val:": int = 0"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos_fast.py#L583"}}),je=new Y({props:{name:"post_process_object_detection",anchor:"transformers.YolosImageProcessorFast.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"},{name:"top_k",val:": int = 100"}],parametersDescription:[{anchor:"transformers.YolosImageProcessorFast.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosImageProcessorFast.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosImageProcessorFast.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
(height, width) of each image in the batch. If left to None, predictions will not be resized.`,name:"target_sizes"},{anchor:"transformers.YolosImageProcessorFast.post_process_object_detection.top_k",description:`<strong>top_k</strong> (<code>int</code>, <em>optional</em>, defaults to 100) &#x2014;
Keep only top k bounding boxes before filtering by thresholding.`,name:"top_k"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos_fast.py#L833",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ce=new q({props:{title:"YolosFeatureExtractor",local:"transformers.YolosFeatureExtractor",headingTag:"h2"}}),Fe=new Y({props:{name:"class transformers.YolosFeatureExtractor",anchor:"transformers.YolosFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/feature_extraction_yolos.py#L37"}}),Pe=new Y({props:{name:"__call__",anchor:"transformers.YolosFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/image_processing_utils.py#L42"}}),Je=new Y({props:{name:"pad",anchor:"transformers.YolosFeatureExtractor.pad",parameters:[{name:"images",val:": typing.List[numpy.ndarray]"},{name:"annotations",val:": typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = None"},{name:"constant_values",val:": typing.Union[float, typing.Iterable[float]] = 0"},{name:"return_pixel_mask",val:": bool = False"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = None"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"},{name:"update_bboxes",val:": bool = True"},{name:"pad_size",val:": typing.Optional[typing.Dict[str, int]] = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.pad.image",description:`<strong>image</strong> (<code>np.ndarray</code>) &#x2014;
Image to pad.`,name:"image"},{anchor:"transformers.YolosFeatureExtractor.pad.annotations",description:`<strong>annotations</strong> (<code>List[Dict[str, any]]</code>, <em>optional</em>) &#x2014;
Annotations to pad along with the images. If provided, the bounding boxes will be updated to match the
padded images.`,name:"annotations"},{anchor:"transformers.YolosFeatureExtractor.pad.constant_values",description:`<strong>constant_values</strong> (<code>float</code> or <code>Iterable[float]</code>, <em>optional</em>) &#x2014;
The value to use for the padding if <code>mode</code> is <code>&quot;constant&quot;</code>.`,name:"constant_values"},{anchor:"transformers.YolosFeatureExtractor.pad.return_pixel_mask",description:`<strong>return_pixel_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return a pixel mask.`,name:"return_pixel_mask"},{anchor:"transformers.YolosFeatureExtractor.pad.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.YolosFeatureExtractor.pad.data_format",description:`<strong>data_format</strong> (<code>str</code> or <code>ChannelDimension</code>, <em>optional</em>) &#x2014;
The channel dimension format of the image. If not provided, it will be the same as the input image.`,name:"data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format of the input image. If not provided, it will be inferred.`,name:"input_data_format"},{anchor:"transformers.YolosFeatureExtractor.pad.update_bboxes",description:`<strong>update_bboxes</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to update the bounding boxes in the annotations to match the padded images. If the
bounding boxes have not been converted to relative coordinates and <code>(centre_x, centre_y, width, height)</code>
format, the bounding boxes will not be updated.`,name:"update_bboxes"},{anchor:"transformers.YolosFeatureExtractor.pad.pad_size",description:`<strong>pad_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>) &#x2014;
The size <code>{&quot;height&quot;: int, &quot;width&quot; int}</code> to pad the images to. Must be larger than any image size
provided for preprocessing. If <code>pad_size</code> is not provided, images will be padded to the largest
height and width in the batch.`,name:"pad_size"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L1092"}}),De=new Y({props:{name:"post_process_object_detection",anchor:"transformers.YolosFeatureExtractor.post_process_object_detection",parameters:[{name:"outputs",val:""},{name:"threshold",val:": float = 0.5"},{name:"target_sizes",val:": typing.Union[transformers.utils.generic.TensorType, typing.List[typing.Tuple]] = None"}],parametersDescription:[{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.outputs",description:`<strong>outputs</strong> (<code>YolosObjectDetectionOutput</code>) &#x2014;
Raw outputs of the model.`,name:"outputs"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.threshold",description:`<strong>threshold</strong> (<code>float</code>, <em>optional</em>) &#x2014;
Score threshold to keep object detection predictions.`,name:"threshold"},{anchor:"transformers.YolosFeatureExtractor.post_process_object_detection.target_sizes",description:`<strong>target_sizes</strong> (<code>torch.Tensor</code> or <code>List[Tuple[int, int]]</code>, <em>optional</em>) &#x2014;
Tensor of shape <code>(batch_size, 2)</code> or list of tuples (<code>Tuple[int, int]</code>) containing the target size
<code>(height, width)</code> of each image in the batch. If unset, predictions will not be resized.`,name:"target_sizes"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/image_processing_yolos.py#L1482",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A list of dictionaries, each dictionary containing the scores, labels and boxes for an image
in the batch as predicted by the model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>List[Dict]</code></p>
`}}),Ue=new q({props:{title:"YolosModel",local:"transformers.YolosModel",headingTag:"h2"}}),ke=new Y({props:{name:"class transformers.YolosModel",anchor:"transformers.YolosModel",parameters:[{name:"config",val:": YolosConfig"},{name:"add_pooling_layer",val:": bool = True"}],parametersDescription:[{anchor:"transformers.YolosModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L601"}}),qe=new Y({props:{name:"forward",anchor:"transformers.YolosModel.forward",parameters:[{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.YolosModel.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L634",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</p>
</li>
<li>
<p><strong>pooler_output</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, hidden_size)</code>) — Last layer hidden-state of the first token of the sequence (classification token) after further processing
through the layers used for the auxiliary pretraining task. E.g. for BERT-family of models, this returns
the classification token after processing through a linear layer and a tanh activation function. The linear
layer weights are trained from the next sentence prediction (classification) objective during pretraining.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.BaseModelOutputWithPooling"
>transformers.modeling_outputs.BaseModelOutputWithPooling</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),A=new Yt({props:{$$slots:{default:[gs]},$$scope:{ctx:z}}}),H=new zt({props:{anchor:"transformers.YolosModel.forward.example",$$slots:{default:[fs]},$$scope:{ctx:z}}}),Ne=new q({props:{title:"YolosForObjectDetection",local:"transformers.YolosForObjectDetection",headingTag:"h2"}}),Le=new Y({props:{name:"class transformers.YolosForObjectDetection",anchor:"transformers.YolosForObjectDetection",parameters:[{name:"config",val:": YolosConfig"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig">YolosConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L730"}}),Oe=new Y({props:{name:"forward",anchor:"transformers.YolosForObjectDetection.forward",parameters:[{name:"pixel_values",val:": FloatTensor"},{name:"labels",val:": typing.Optional[typing.List[typing.Dict]] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.YolosForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_channels, height, width)</code>) &#x2014;
Pixel values. Pixel values can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See
<a href="/docs/transformers/main/en/model_doc/vit#transformers.ViTFeatureExtractor.__call__">YolosImageProcessor.<strong>call</strong>()</a> for details.`,name:"pixel_values"},{anchor:"transformers.YolosForObjectDetection.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.YolosForObjectDetection.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.YolosForObjectDetection.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.YolosForObjectDetection.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.YolosForObjectDetection.forward.labels",description:`<strong>labels</strong> (<code>List[Dict]</code> of len <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the bipartite matching loss. List of dicts, each dictionary containing at least the
following 2 keys: <code>&apos;class_labels&apos;</code> and <code>&apos;boxes&apos;</code> (the class labels and bounding boxes of an image in the
batch respectively). The class labels themselves should be a <code>torch.LongTensor</code> of len <code>(number of bounding boxes in the image,)</code> and the boxes a <code>torch.FloatTensor</code> of shape <code>(number of bounding boxes in the image, 4)</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/yolos/modeling_yolos.py#L763",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/yolos#transformers.YolosConfig"
>YolosConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> are provided)) — Total loss as a linear combination of a negative log-likehood (cross-entropy) for class prediction and a
bounding box loss. The latter is defined as a linear combination of the L1 loss and the generalized
scale-invariant IoU loss.</li>
<li><strong>loss_dict</strong> (<code>Dict</code>, <em>optional</em>) — A dictionary containing the individual losses. Useful for logging.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, num_classes + 1)</code>) — Classification logits (including no-object) for all queries.</li>
<li><strong>pred_boxes</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_queries, 4)</code>) — Normalized boxes coordinates for all queries, represented as (center_x, center_y, width, height). These
values are normalized in [0, 1], relative to the size of each individual image in the batch (disregarding
possible padding). You can use <code>post_process()</code> to retrieve the unnormalized bounding
boxes.</li>
<li><strong>auxiliary_outputs</strong> (<code>list[Dict]</code>, <em>optional</em>) — Optional, only returned when auxiliary losses are activated (i.e. <code>config.auxiliary_loss</code> is set to <code>True</code>)
and labels are provided. It is a list of dictionaries containing the two above keys (<code>logits</code> and
<code>pred_boxes</code>) for each decoder layer.</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) — Sequence of hidden-states at the output of the last layer of the decoder of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of
the model at the output of each layer plus the optional initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.yolos.modeling_yolos.YolosObjectDetectionOutput</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),B=new Yt({props:{$$slots:{default:[us]},$$scope:{ctx:z}}}),X=new zt({props:{anchor:"transformers.YolosForObjectDetection.forward.example",$$slots:{default:[_s]},$$scope:{ctx:z}}}),Re=new ms({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/yolos.md"}}),{c(){r=l("meta"),v=s(),m=l("p"),y=s(),p(w.$$.fragment),c=s(),x=l("div"),x.innerHTML=Mt,mo=s(),p(te.$$.fragment),po=s(),se=l("p"),se.innerHTML=jt,ho=s(),ne=l("p"),ne.textContent=Ct,go=s(),ae=l("p"),ae.innerHTML=Ft,fo=s(),L=l("img"),uo=s(),re=l("small"),re.innerHTML=Jt,_o=s(),ie=l("p"),ie.innerHTML=Dt,bo=s(),p(le.$$.fragment),yo=s(),de=l("p"),de.innerHTML=Ut,vo=s(),ce=l("p"),ce.innerHTML=kt,wo=s(),p(me.$$.fragment),To=s(),pe=l("p"),pe.innerHTML=qt,xo=s(),he=l("p"),he.innerHTML=Nt,$o=s(),ge=l("table"),ge.innerHTML=Lt,Io=s(),p(fe.$$.fragment),Yo=s(),ue=l("p"),ue.textContent=Ot,zo=s(),p(_e.$$.fragment),Mo=s(),be=l("ul"),be.innerHTML=Rt,jo=s(),ye=l("p"),ye.textContent=Wt,Co=s(),p(O.$$.fragment),Fo=s(),p(ve.$$.fragment),Po=s(),M=l("div"),p(we.$$.fragment),Xo=s(),Se=l("p"),Se.innerHTML=Et,Qo=s(),Ze=l("p"),Ze.innerHTML=St,Ko=s(),p(R.$$.fragment),Jo=s(),p(Te.$$.fragment),Do=s(),D=l("div"),p(xe.$$.fragment),et=s(),Ve=l("p"),Ve.textContent=Zt,ot=s(),W=l("div"),p($e.$$.fragment),tt=s(),Ge=l("p"),Ge.textContent=Vt,Uo=s(),p(Ie.$$.fragment),ko=s(),I=l("div"),p(Ye.$$.fragment),st=s(),Ae=l("p"),Ae.textContent=Gt,nt=s(),E=l("div"),p(ze.$$.fragment),at=s(),He=l("p"),He.textContent=At,rt=s(),Be=l("div"),p(Me.$$.fragment),it=s(),S=l("div"),p(je.$$.fragment),lt=s(),Xe=l("p"),Xe.innerHTML=Ht,qo=s(),p(Ce.$$.fragment),No=s(),j=l("div"),p(Fe.$$.fragment),dt=s(),Z=l("div"),p(Pe.$$.fragment),ct=s(),Qe=l("p"),Qe.textContent=Bt,mt=s(),V=l("div"),p(Je.$$.fragment),pt=s(),Ke=l("p"),Ke.textContent=Xt,ht=s(),G=l("div"),p(De.$$.fragment),gt=s(),eo=l("p"),eo.innerHTML=Qt,Lo=s(),p(Ue.$$.fragment),Oo=s(),U=l("div"),p(ke.$$.fragment),ft=s(),oo=l("p"),oo.innerHTML=Kt,ut=s(),P=l("div"),p(qe.$$.fragment),_t=s(),to=l("p"),to.innerHTML=es,bt=s(),p(A.$$.fragment),yt=s(),p(H.$$.fragment),Ro=s(),p(Ne.$$.fragment),Wo=s(),C=l("div"),p(Le.$$.fragment),vt=s(),so=l("p"),so.textContent=os,wt=s(),no=l("p"),no.innerHTML=ts,Tt=s(),J=l("div"),p(Oe.$$.fragment),xt=s(),ao=l("p"),ao.innerHTML=ss,$t=s(),p(B.$$.fragment),It=s(),p(X.$$.fragment),Eo=s(),p(Re.$$.fragment),So=s(),lo=l("p"),this.h()},l(e){const o=ds("svelte-u9bgzb",document.head);r=d(o,"META",{name:!0,content:!0}),o.forEach(t),v=n(e),m=d(e,"P",{}),$(m).forEach(t),y=n(e),h(w.$$.fragment,e),c=n(e),x=d(e,"DIV",{class:!0,"data-svelte-h":!0}),b(x)!=="svelte-b95w5j"&&(x.innerHTML=Mt),mo=n(e),h(te.$$.fragment,e),po=n(e),se=d(e,"P",{"data-svelte-h":!0}),b(se)!=="svelte-98a8ak"&&(se.innerHTML=jt),ho=n(e),ne=d(e,"P",{"data-svelte-h":!0}),b(ne)!=="svelte-vfdo9a"&&(ne.textContent=Ct),go=n(e),ae=d(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-ng2z0l"&&(ae.innerHTML=Ft),fo=n(e),L=d(e,"IMG",{src:!0,alt:!0,width:!0}),uo=n(e),re=d(e,"SMALL",{"data-svelte-h":!0}),b(re)!=="svelte-vits75"&&(re.innerHTML=Jt),_o=n(e),ie=d(e,"P",{"data-svelte-h":!0}),b(ie)!=="svelte-zgo631"&&(ie.innerHTML=Dt),bo=n(e),h(le.$$.fragment,e),yo=n(e),de=d(e,"P",{"data-svelte-h":!0}),b(de)!=="svelte-1cid2pe"&&(de.innerHTML=Ut),vo=n(e),ce=d(e,"P",{"data-svelte-h":!0}),b(ce)!=="svelte-1x11lxg"&&(ce.innerHTML=kt),wo=n(e),h(me.$$.fragment,e),To=n(e),pe=d(e,"P",{"data-svelte-h":!0}),b(pe)!=="svelte-djb2w0"&&(pe.innerHTML=qt),xo=n(e),he=d(e,"P",{"data-svelte-h":!0}),b(he)!=="svelte-1h02v1a"&&(he.innerHTML=Nt),$o=n(e),ge=d(e,"TABLE",{"data-svelte-h":!0}),b(ge)!=="svelte-1dnq5yr"&&(ge.innerHTML=Lt),Io=n(e),h(fe.$$.fragment,e),Yo=n(e),ue=d(e,"P",{"data-svelte-h":!0}),b(ue)!=="svelte-93t6s9"&&(ue.textContent=Ot),zo=n(e),h(_e.$$.fragment,e),Mo=n(e),be=d(e,"UL",{"data-svelte-h":!0}),b(be)!=="svelte-1q7ij9o"&&(be.innerHTML=Rt),jo=n(e),ye=d(e,"P",{"data-svelte-h":!0}),b(ye)!=="svelte-1xesile"&&(ye.textContent=Wt),Co=n(e),h(O.$$.fragment,e),Fo=n(e),h(ve.$$.fragment,e),Po=n(e),M=d(e,"DIV",{class:!0});var k=$(M);h(we.$$.fragment,k),Xo=n(k),Se=d(k,"P",{"data-svelte-h":!0}),b(Se)!=="svelte-1kalbwl"&&(Se.innerHTML=Et),Qo=n(k),Ze=d(k,"P",{"data-svelte-h":!0}),b(Ze)!=="svelte-o55m63"&&(Ze.innerHTML=St),Ko=n(k),h(R.$$.fragment,k),k.forEach(t),Jo=n(e),h(Te.$$.fragment,e),Do=n(e),D=d(e,"DIV",{class:!0});var N=$(D);h(xe.$$.fragment,N),et=n(N),Ve=d(N,"P",{"data-svelte-h":!0}),b(Ve)!=="svelte-19j0nu1"&&(Ve.textContent=Zt),ot=n(N),W=d(N,"DIV",{class:!0});var We=$(W);h($e.$$.fragment,We),tt=n(We),Ge=d(We,"P",{"data-svelte-h":!0}),b(Ge)!=="svelte-jgz2ra"&&(Ge.textContent=Vt),We.forEach(t),N.forEach(t),Uo=n(e),h(Ie.$$.fragment,e),ko=n(e),I=d(e,"DIV",{class:!0});var F=$(I);h(Ye.$$.fragment,F),st=n(F),Ae=d(F,"P",{"data-svelte-h":!0}),b(Ae)!=="svelte-1pcotw8"&&(Ae.textContent=Gt),nt=n(F),E=d(F,"DIV",{class:!0});var Ee=$(E);h(ze.$$.fragment,Ee),at=n(Ee),He=d(Ee,"P",{"data-svelte-h":!0}),b(He)!=="svelte-1x3yxsa"&&(He.textContent=At),Ee.forEach(t),rt=n(F),Be=d(F,"DIV",{class:!0});var co=$(Be);h(Me.$$.fragment,co),co.forEach(t),it=n(F),S=d(F,"DIV",{class:!0});var Vo=$(S);h(je.$$.fragment,Vo),lt=n(Vo),Xe=d(Vo,"P",{"data-svelte-h":!0}),b(Xe)!=="svelte-qbjbsr"&&(Xe.innerHTML=Ht),Vo.forEach(t),F.forEach(t),qo=n(e),h(Ce.$$.fragment,e),No=n(e),j=d(e,"DIV",{class:!0});var Q=$(j);h(Fe.$$.fragment,Q),dt=n(Q),Z=d(Q,"DIV",{class:!0});var Go=$(Z);h(Pe.$$.fragment,Go),ct=n(Go),Qe=d(Go,"P",{"data-svelte-h":!0}),b(Qe)!=="svelte-khengj"&&(Qe.textContent=Bt),Go.forEach(t),mt=n(Q),V=d(Q,"DIV",{class:!0});var Ao=$(V);h(Je.$$.fragment,Ao),pt=n(Ao),Ke=d(Ao,"P",{"data-svelte-h":!0}),b(Ke)!=="svelte-1f2f3d6"&&(Ke.textContent=Xt),Ao.forEach(t),ht=n(Q),G=d(Q,"DIV",{class:!0});var Ho=$(G);h(De.$$.fragment,Ho),gt=n(Ho),eo=d(Ho,"P",{"data-svelte-h":!0}),b(eo)!=="svelte-1hjr84f"&&(eo.innerHTML=Qt),Ho.forEach(t),Q.forEach(t),Lo=n(e),h(Ue.$$.fragment,e),Oo=n(e),U=d(e,"DIV",{class:!0});var ro=$(U);h(ke.$$.fragment,ro),ft=n(ro),oo=d(ro,"P",{"data-svelte-h":!0}),b(oo)!=="svelte-19k5mgv"&&(oo.innerHTML=Kt),ut=n(ro),P=d(ro,"DIV",{class:!0});var K=$(P);h(qe.$$.fragment,K),_t=n(K),to=d(K,"P",{"data-svelte-h":!0}),b(to)!=="svelte-k5bn63"&&(to.innerHTML=es),bt=n(K),h(A.$$.fragment,K),yt=n(K),h(H.$$.fragment,K),K.forEach(t),ro.forEach(t),Ro=n(e),h(Ne.$$.fragment,e),Wo=n(e),C=d(e,"DIV",{class:!0});var ee=$(C);h(Le.$$.fragment,ee),vt=n(ee),so=d(ee,"P",{"data-svelte-h":!0}),b(so)!=="svelte-1yg9bo0"&&(so.textContent=os),wt=n(ee),no=d(ee,"P",{"data-svelte-h":!0}),b(no)!=="svelte-1gjh92c"&&(no.innerHTML=ts),Tt=n(ee),J=d(ee,"DIV",{class:!0});var oe=$(J);h(Oe.$$.fragment,oe),xt=n(oe),ao=d(oe,"P",{"data-svelte-h":!0}),b(ao)!=="svelte-1mbhkvx"&&(ao.innerHTML=ss),$t=n(oe),h(B.$$.fragment,oe),It=n(oe),h(X.$$.fragment,oe),oe.forEach(t),ee.forEach(t),Eo=n(e),h(Re.$$.fragment,e),So=n(e),lo=d(e,"P",{}),$(lo).forEach(t),this.h()},h(){T(r,"name","hf:doc:metadata"),T(r,"content",ys),T(x,"class","flex flex-wrap space-x-1"),as(L.src,Pt="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/yolos_architecture.png")||T(L,"src",Pt),T(L,"alt","drawing"),T(L,"width","600"),T(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,o){i(document.head,r),a(e,v,o),a(e,m,o),a(e,y,o),g(w,e,o),a(e,c,o),a(e,x,o),a(e,mo,o),g(te,e,o),a(e,po,o),a(e,se,o),a(e,ho,o),a(e,ne,o),a(e,go,o),a(e,ae,o),a(e,fo,o),a(e,L,o),a(e,uo,o),a(e,re,o),a(e,_o,o),a(e,ie,o),a(e,bo,o),g(le,e,o),a(e,yo,o),a(e,de,o),a(e,vo,o),a(e,ce,o),a(e,wo,o),g(me,e,o),a(e,To,o),a(e,pe,o),a(e,xo,o),a(e,he,o),a(e,$o,o),a(e,ge,o),a(e,Io,o),g(fe,e,o),a(e,Yo,o),a(e,ue,o),a(e,zo,o),g(_e,e,o),a(e,Mo,o),a(e,be,o),a(e,jo,o),a(e,ye,o),a(e,Co,o),g(O,e,o),a(e,Fo,o),g(ve,e,o),a(e,Po,o),a(e,M,o),g(we,M,null),i(M,Xo),i(M,Se),i(M,Qo),i(M,Ze),i(M,Ko),g(R,M,null),a(e,Jo,o),g(Te,e,o),a(e,Do,o),a(e,D,o),g(xe,D,null),i(D,et),i(D,Ve),i(D,ot),i(D,W),g($e,W,null),i(W,tt),i(W,Ge),a(e,Uo,o),g(Ie,e,o),a(e,ko,o),a(e,I,o),g(Ye,I,null),i(I,st),i(I,Ae),i(I,nt),i(I,E),g(ze,E,null),i(E,at),i(E,He),i(I,rt),i(I,Be),g(Me,Be,null),i(I,it),i(I,S),g(je,S,null),i(S,lt),i(S,Xe),a(e,qo,o),g(Ce,e,o),a(e,No,o),a(e,j,o),g(Fe,j,null),i(j,dt),i(j,Z),g(Pe,Z,null),i(Z,ct),i(Z,Qe),i(j,mt),i(j,V),g(Je,V,null),i(V,pt),i(V,Ke),i(j,ht),i(j,G),g(De,G,null),i(G,gt),i(G,eo),a(e,Lo,o),g(Ue,e,o),a(e,Oo,o),a(e,U,o),g(ke,U,null),i(U,ft),i(U,oo),i(U,ut),i(U,P),g(qe,P,null),i(P,_t),i(P,to),i(P,bt),g(A,P,null),i(P,yt),g(H,P,null),a(e,Ro,o),g(Ne,e,o),a(e,Wo,o),a(e,C,o),g(Le,C,null),i(C,vt),i(C,so),i(C,wt),i(C,no),i(C,Tt),i(C,J),g(Oe,J,null),i(J,xt),i(J,ao),i(J,$t),g(B,J,null),i(J,It),g(X,J,null),a(e,Eo,o),g(Re,e,o),a(e,So,o),a(e,lo,o),Zo=!0},p(e,[o]){const k={};o&2&&(k.$$scope={dirty:o,ctx:e}),O.$set(k);const N={};o&2&&(N.$$scope={dirty:o,ctx:e}),R.$set(N);const We={};o&2&&(We.$$scope={dirty:o,ctx:e}),A.$set(We);const F={};o&2&&(F.$$scope={dirty:o,ctx:e}),H.$set(F);const Ee={};o&2&&(Ee.$$scope={dirty:o,ctx:e}),B.$set(Ee);const co={};o&2&&(co.$$scope={dirty:o,ctx:e}),X.$set(co)},i(e){Zo||(f(w.$$.fragment,e),f(te.$$.fragment,e),f(le.$$.fragment,e),f(me.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(O.$$.fragment,e),f(ve.$$.fragment,e),f(we.$$.fragment,e),f(R.$$.fragment,e),f(Te.$$.fragment,e),f(xe.$$.fragment,e),f($e.$$.fragment,e),f(Ie.$$.fragment,e),f(Ye.$$.fragment,e),f(ze.$$.fragment,e),f(Me.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(Fe.$$.fragment,e),f(Pe.$$.fragment,e),f(Je.$$.fragment,e),f(De.$$.fragment,e),f(Ue.$$.fragment,e),f(ke.$$.fragment,e),f(qe.$$.fragment,e),f(A.$$.fragment,e),f(H.$$.fragment,e),f(Ne.$$.fragment,e),f(Le.$$.fragment,e),f(Oe.$$.fragment,e),f(B.$$.fragment,e),f(X.$$.fragment,e),f(Re.$$.fragment,e),Zo=!0)},o(e){u(w.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(me.$$.fragment,e),u(fe.$$.fragment,e),u(_e.$$.fragment,e),u(O.$$.fragment,e),u(ve.$$.fragment,e),u(we.$$.fragment,e),u(R.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u($e.$$.fragment,e),u(Ie.$$.fragment,e),u(Ye.$$.fragment,e),u(ze.$$.fragment,e),u(Me.$$.fragment,e),u(je.$$.fragment,e),u(Ce.$$.fragment,e),u(Fe.$$.fragment,e),u(Pe.$$.fragment,e),u(Je.$$.fragment,e),u(De.$$.fragment,e),u(Ue.$$.fragment,e),u(ke.$$.fragment,e),u(qe.$$.fragment,e),u(A.$$.fragment,e),u(H.$$.fragment,e),u(Ne.$$.fragment,e),u(Le.$$.fragment,e),u(Oe.$$.fragment,e),u(B.$$.fragment,e),u(X.$$.fragment,e),u(Re.$$.fragment,e),Zo=!1},d(e){e&&(t(v),t(m),t(y),t(c),t(x),t(mo),t(po),t(se),t(ho),t(ne),t(go),t(ae),t(fo),t(L),t(uo),t(re),t(_o),t(ie),t(bo),t(yo),t(de),t(vo),t(ce),t(wo),t(To),t(pe),t(xo),t(he),t($o),t(ge),t(Io),t(Yo),t(ue),t(zo),t(Mo),t(be),t(jo),t(ye),t(Co),t(Fo),t(Po),t(M),t(Jo),t(Do),t(D),t(Uo),t(ko),t(I),t(qo),t(No),t(j),t(Lo),t(Oo),t(U),t(Ro),t(Wo),t(C),t(Eo),t(So),t(lo)),t(r),_(w,e),_(te,e),_(le,e),_(me,e),_(fe,e),_(_e,e),_(O,e),_(ve,e),_(we),_(R),_(Te,e),_(xe),_($e),_(Ie,e),_(Ye),_(ze),_(Me),_(je),_(Ce,e),_(Fe),_(Pe),_(Je),_(De),_(Ue,e),_(ke),_(qe),_(A),_(H),_(Ne,e),_(Le),_(Oe),_(B),_(X),_(Re,e)}}}const ys='{"title":"YOLOS","local":"yolos","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Using Scaled Dot Product Attention (SDPA)","local":"using-scaled-dot-product-attention-sdpa","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"YolosConfig","local":"transformers.YolosConfig","sections":[],"depth":2},{"title":"YolosImageProcessor","local":"transformers.YolosImageProcessor","sections":[],"depth":2},{"title":"YolosImageProcessorFast","local":"transformers.YolosImageProcessorFast","sections":[],"depth":2},{"title":"YolosFeatureExtractor","local":"transformers.YolosFeatureExtractor","sections":[],"depth":2},{"title":"YolosModel","local":"transformers.YolosModel","sections":[],"depth":2},{"title":"YolosForObjectDetection","local":"transformers.YolosForObjectDetection","sections":[],"depth":2}],"depth":1}';function vs(z){return rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Cs extends is{constructor(r){super(),ls(this,r,vs,bs,ns,{})}}export{Cs as component};
