import{s as En,o as Qn,n as Fn}from"../chunks/scheduler.18a86fab.js";import{S as Bn,i as Rn,g as m,s as l,r as b,m as r,H as c,A as jn,h as p,f as s,c as i,j as u,u as _,x as g,n as o,B as h,k as Za,y as n,a as e,v as M,d as k,t as z,w as T}from"../chunks/index.98837b22.js";import{T as Gn}from"../chunks/Tip.77304350.js";import{C as Un}from"../chunks/CodeBlock.8d0c2e8a.js";import{H as Z}from"../chunks/Heading.7e7e0c5b.js";import{E as Vn}from"../chunks/index.499f366c.js";function Wn(Ua){let f,D="In symmetric quantization, Z would typically be fixed at 0.";return{c(){f=m("p"),f.textContent=D},l(q){f=p(q,"P",{"data-svelte-h":!0}),g(f)!=="svelte-1uctalb"&&(f.textContent=D)},m(q,Ia){e(q,f,Ia)},p:Fn,d(q){q&&s(f)}}}function Dn(Ua){let f,D,q,Ia,X,Va,N,$e="Quantization reduces the memory footprint and computational cost of large machine learning models like those found in the Transformers library. It achieves this by representing the model’s weights and or activations with lower-precision data types (like 8-bit integers or int8) instead of the standard 32-bit floating-point (float32).",Wa,O,Le="Reducing a model’s precision offers several significant benefits:",Da,Y,Ce="<li>Smaller model size: Lower-precision data types require less storage space. An int8 model, for example, is roughly 4 times smaller than its float32 counterpart.</li> <li>Faster inference: Operations on lower-precision data types, especially integers, can be significantly faster on compatible hardware (CPUs and GPUs often have specialized instructions for int8 operations). This leads to lower latency.</li> <li>Reduced energy consumption: Faster computations and smaller memory transfers often translate to lower power usage.</li>",Xa,K,Pe="The primary trade-off in quantization is <em>efficiency</em> vs. <em>accuracy</em>. Reducing precision saves resources but inevitably introduces small errors (quantization noise). The goal is to minimize this error using appropriate schemes (affine/symmetric), granularity (per-tensor/channel), and techniques (PTQ/QAT) so that the model’s performance on its target task degrades as little as possible.",Na,aa,He="The sections below cover quantization schemes, granularity, and techniques.",Oa,sa,Ya,I,ie,Ka,nn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mo>−</mo><mn>128</mn><mo separator="true">,</mo><mn>127</mn><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[-128, 127]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord">−</span><span class="mord">128</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">127</span><span class="mclose">]</span></span></span></span>',as,ss,ta,Je="This section covers how some quantization techniques work.",ts,E,Se='<img width="606" alt="quant_visual" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/quant_visual.png"/>',es,ea,ns,d,me,Ea,Ae="affine quantization",pe,ls,ln='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub></mrow><annotation encoding="application/x-tex">val_{min}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8444em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',is,ms,mn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>a</mi><mi>x</mi></mrow></msub></mrow><annotation encoding="application/x-tex">val_{max}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8444em;vertical-align:-0.15em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ma</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',ps,rs,pn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub><mo separator="true">,</mo><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>a</mi><mi>x</mi></mrow></msub><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[val_{min}, val_{max}]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ma</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">]</span></span></span></span>',os,cs,rn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><msub><mi>q</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub><mo separator="true">,</mo><msub><mi>q</mi><mrow><mi>m</mi><mi>a</mi><mi>x</mi></mrow></msub><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[q_{min}, q_{max}]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ma</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">]</span></span></span></span>',hs,gs,on='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mo>−</mo><mn>128</mn><mo separator="true">,</mo><mn>127</mn><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[-128, 127]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord">−</span><span class="mord">128</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">127</span><span class="mclose">]</span></span></span></span>',us,ds,na,Ze="There are two main ways to perform this mapping, <em>symmetric</em> and <em>asymmetric</em>. The choice between symmetric and asymmetric quantization determines how the float32 range is mapped to the int8 range.",fs,Q,w,re,ws,cn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mo>−</mo><mi>a</mi><mo separator="true">,</mo><mi>a</mi><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[ -a, a ]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord">−</span><span class="mord mathnormal">a</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">a</span><span class="mclose">]</span></span></span></span>',ys,vs,hn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mo>−</mo><mn>127</mn><mo separator="true">,</mo><mn>127</mn><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[-127, 127]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord">−</span><span class="mord">127</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">127</span><span class="mclose">]</span></span></span></span>',xs,bs,gn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0.0</mn></mrow><annotation encoding="application/x-tex">0.0</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.0</span></span></span></span>',_s,Ms,un='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0</mn></mrow><annotation encoding="application/x-tex">0</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0</span></span></span></span>',ks,la,oe,zs,dn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',Ts,ce,he,v,ge,qs,fn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub><mo separator="true">,</mo><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>a</mi><mi>x</mi></mrow></msub><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[val_{min}, val_{max}]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ma</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">]</span></span></span></span>',$s,Ls,wn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mo>−</mo><mn>128</mn><mo separator="true">,</mo><mn>127</mn><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[-128, 127]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord">−</span><span class="mord">128</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">127</span><span class="mclose">]</span></span></span></span>',Cs,ia,ue,Ps,yn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',Hs,de,ma,fe,Js,vn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Z</mi></mrow><annotation encoding="application/x-tex">Z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span></span></span></span>',Ss,we,As,H,ye,Zs,xn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',Is,Es,bn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>S</mi><mo>=</mo><mfrac><mrow><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>a</mi><mi>x</mi></mrow></msub><mo>−</mo><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub></mrow><mrow><msub><mi>q</mi><mrow><mi>m</mi><mi>a</mi><mi>x</mi></mrow></msub><mo>−</mo><msub><mi>q</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub></mrow></mfrac></mrow><annotation encoding="application/x-tex">
S = \\frac{val_{max} - val_{min}}{q_{max} - q_{min}}
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:2.2519em;vertical-align:-0.8804em;"></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3714em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ma</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">ma</span><span class="mord mathnormal mtight">x</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.8804em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span></span></span></span></span>`,Qs,$,ve,Fs,_n='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Z</mi></mrow><annotation encoding="application/x-tex">Z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span></span></span></span>',Bs,Rs,Mn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0.0</mn></mrow><annotation encoding="application/x-tex">0.0</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">0.0</span></span></span></span>',js,Gs,kn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Z</mi><mo>=</mo><msub><mi>q</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub><mo>−</mo><mi>r</mi><mi>o</mi><mi>u</mi><mi>n</mi><mi>d</mi><mrow><mo fence="true">(</mo><mfrac><mrow><mi>v</mi><mi>a</mi><msub><mi>l</mi><mrow><mi>m</mi><mi>i</mi><mi>n</mi></mrow></msub></mrow><mi>S</mi></mfrac><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">
Z = q_{min} - round\\left(\\frac{val_{min}}{S}\\right)
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0359em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:2.4em;vertical-align:-0.95em;"></span><span class="mord mathnormal">ro</span><span class="mord mathnormal">u</span><span class="mord mathnormal">n</span><span class="mord mathnormal">d</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size3">(</span></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.3714em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.03588em;">v</span><span class="mord mathnormal">a</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.01968em;">l</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.0197em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">min</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size3">)</span></span></span></span></span></span></span>`,Us,F,Vs,L,xe,Ws,zn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>x</mi></mrow><annotation encoding="application/x-tex">x</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4306em;"></span><span class="mord mathnormal">x</span></span></span></span>',Ds,Xs,Tn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>q</mi></mrow><annotation encoding="application/x-tex">q</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span></span></span></span>',Ns,Os,qn=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>q</mi><mo>=</mo><mi>r</mi><mi>o</mi><mi>u</mi><mi>n</mi><mi>d</mi><mrow><mo fence="true">(</mo><mfrac><mi>x</mi><mi>S</mi></mfrac><mo>+</mo><mi>Z</mi><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">
q = round\\left(\\frac{x}{S} + Z\\right)
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.836em;vertical-align:-0.686em;"></span><span class="mord mathnormal">ro</span><span class="mord mathnormal">u</span><span class="mord mathnormal">n</span><span class="mord mathnormal">d</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen delimcenter" style="top:0em;"><span class="delimsizing size2">(</span></span><span class="mord"><span class="mopen nulldelimiter"></span><span class="mfrac"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.1076em;"><span style="top:-2.314em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span><span style="top:-3.23em;"><span class="pstrut" style="height:3em;"></span><span class="frac-line" style="border-bottom-width:0.04em;"></span></span><span style="top:-3.677em;"><span class="pstrut" style="height:3em;"></span><span class="mord"><span class="mord mathnormal">x</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.686em;"><span></span></span></span></span></span><span class="mclose nulldelimiter"></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span><span class="mclose delimcenter" style="top:0em;"><span class="delimsizing size2">)</span></span></span></span></span></span></span>`,Ys,J,be,Ks,$n='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>q</mi></mrow><annotation encoding="application/x-tex">q</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span></span></span></span>',at,st,Ln=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>x</mi><mo>≈</mo><mi>S</mi><mo>⋅</mo><mo stretchy="false">(</mo><mi>q</mi><mo>−</mo><mi>Z</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">
x \\approx S \\cdot (q - Z)
</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.4831em;"></span><span class="mord mathnormal">x</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">≈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">⋅</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span><span class="mclose">)</span></span></span></span></span>`,tt,B,Ie='<img width="606" alt="dequant" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/dequant.png"/>',et,R,_e,nt,Cn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>q</mi></mrow><annotation encoding="application/x-tex">q</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.03588em;">q</span></span></span></span>',lt,it,pa,mt,j,Ee='<img width="606" alt="weight packing" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/weight_packing.png"/>',pt,G,Me,rt,Pn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mo stretchy="false">[</mo><mo>−</mo><mn>8</mn><mo separator="true">,</mo><mn>7</mn><mo stretchy="false">]</mo></mrow><annotation encoding="application/x-tex">[-8, 7]</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">[</span><span class="mord">−</span><span class="mord">8</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">7</span><span class="mclose">]</span></span></span></span>',ot,ct,ra,Qe="A key aspect of int4 quantization is <strong>weight packing</strong>. Since most hardware can’t natively handle 4-bit data types in memory, two int4 values are typically packed together into a single int8 byte for storage and transfer. For example, the first value might occupy the lower 4 bits and the second value the upper 4 bits of the byte (<code>packed_byte = (val1 &amp; 0x0F) | (val2 &lt;&lt; 4)</code>).",ht,oa,Fe="int4 is still beneficial even without native int4 compute because the primary benefit comes from reduced memory bandwidth. Loading packed int4 weights (stored as int8) from memory (RAM or VRAM) to the compute units is twice as fast as loading int8 weights. For large models, memory access is often a significant bottleneck. The speed up from faster data transfer can outweigh the computational overhead of unpacking and dequantizing on the fly, leading to overall faster inference, especially in memory-bound scenarios.",gt,ca,Be='However, int4 quantization typically results in a larger accuracy drop compared to int8. Advanced quantization techniques like <a href="./gptq">GPTQ</a> or <a href="./awq">AWQ</a> are often necessary for good performance with int4.',ut,ha,dt,U,Re='<img width="606" alt="fp8" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/fp8.png"/>',ft,ga,je="There are two common FP8 variants.",wt,ua,Ge="<li>E4M3: 1 sign bit, 4 exponent bits, 3 mantissa bits. Offers higher precision (more mantissa bits) but a smaller dynamic range (fewer exponent bits).</li> <li>E5M2: 1 sign bit, 5 exponent bits, 2 mantissa bits. Offers a wider dynamic range but lower precision.</li>",yt,da,Ue="FP8 is used in the <em>A8W8</em> quantization scheme, which quantizes both activations (A) and weights (W) to 8-bit precision.",vt,fa,Ve="While int8 has broad support, efficient FP8 computation requires specific hardware capabilities found in newer GPUs like NVIDIA H100/H200/B100 and AMD Instinct MI300 series. Without native hardware acceleration, the benefits of FP8 might not be fully realized.",xt,wa,We='Transformers supports FP8 through specific backends like <a href="./fbgemm_fp8">FBGEMM</a>, <a href="./finegrained_fp8">FineGrainedFP8</a>, and <a href="./compressed_tensors">compressed-tensors</a>. These backends handle the underlying FP8 conversion and computation when the appropriate hardware and configurations are used.',bt,ya,_t,C,ke,Mt,Hn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',kt,zt,Jn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Z</mi></mrow><annotation encoding="application/x-tex">Z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span></span></span></span>',Tt,qt,V,S,ze,$t,Sn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',Lt,Ct,An='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Z</mi></mrow><annotation encoding="application/x-tex">Z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span></span></span></span>',Pt,Te,A,qe,Ht,Zn='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi></mrow><annotation encoding="application/x-tex">S</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span></span></span></span>',Jt,St,In='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Z</mi></mrow><annotation encoding="application/x-tex">Z</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07153em;">Z</span></span></span></span>',At,Zt,W,De='<img width="625" alt="Granularities" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/Granularities.png"/>',It,va,Et,xa,Xe="There are two main types of quantization techniques.",Qt,ba,Ne="<li>Post-Training Quantization (PTQ): Quantization is applied  <em>after</em> the model is fully trained.</li> <li>Quantization-Aware Training (QAT): Quantization effects are simulated <em>during</em> training by inserting “fake quantization” ops that simulate the rounding errors of quantization. This lets the model adapt to quantization, and usually results in better accuracy, especially at lower bit-widths.</li>",Ft,_a,Bt,Ma,Oe='Transformers integrates several quantization backends such as bitsandbytes, torchao, compressed-tensors, and more (refer to the quantization <a href="./overview">overview</a> for more backends).',Rt,ka,Ye='All backends are unified under the <code>HfQuantizer</code> API and associated <code>QuantizationConfig</code> classes. You can integrate your own custom quantization backends by implementing a custom <code>HfQuantizer</code> and <code>QuantizationConfig</code>, as shown in the <a href="./contribute">Contribution</a> guide.',jt,za,Ke="The typical workflow for quantization in Transformers is to:",Gt,Ta,an='<li>Choose a quantization method suitable for your hardware and use case (see the <a href="./overview">Overview</a> or <a href="./selecting">Selecting a quantization method</a> guide to help you).</li> <li>Load a pre-quantized model from the Hugging Face Hub or load a float32/float16/bfloat16 model and apply a specific quantization method with <code>QuantizationConfig</code>.</li>',Ut,qa,sn="The example below demonstrates loading a 8B parameter model and quantizing it to 4-bits with bitsandbytes.",Vt,$a,Wt,La,Dt,Ca,tn="To explore quantization and related performance optimization concepts more deeply, check out the following resources.",Xt,Pa,en='<li><a href="https://www.deeplearning.ai/short-courses/quantization-fundamentals-with-hugging-face/" rel="nofollow">Quantization Fundamentals with Hugging Face</a></li> <li><a href="https://www.deeplearning.ai/short-courses/quantization-in-depth" rel="nofollow">Quantization in Depth</a></li> <li><a href="https://huggingface.co/blog/merve/quantization" rel="nofollow">Introduction to Quantization cooked in 🤗 with 💗🧑‍🍳</a></li> <li><a href="https://www.youtube.com/watch?v=RP23-dRVDWM" rel="nofollow">EfficientML.ai Lecture 5 - Quantization Part I</a></li> <li><a href="https://horace.io/brrr_intro.html" rel="nofollow">Making Deep Learning Go Brrrr From First Principles</a></li> <li><a href="https://pytorch.org/blog/accelerating-generative-ai-2/" rel="nofollow">Accelerating Generative AI with PyTorch Part 2: LLM Optimizations</a></li>',Nt,Ha,Ot,Ra,Yt;return X=new Z({props:{title:"Quantization concepts",local:"quantization-concepts",headingTag:"h1"}}),sa=new Z({props:{title:"Quantization schemes",local:"quantization-schemes",headingTag:"h2"}}),ea=new Z({props:{title:"Affine quantization",local:"affine-quantization",headingTag:"h3"}}),F=new Gn({props:{warning:!1,$$slots:{default:[Wn]},$$scope:{ctx:Ua}}}),pa=new Z({props:{title:"int4 and weight packing",local:"int4-and-weight-packing",headingTag:"h3"}}),ha=new Z({props:{title:"FP8 Quantization (A8W8)",local:"fp8-quantization-a8w8",headingTag:"h3"}}),ya=new Z({props:{title:"Granularity",local:"granularity",headingTag:"h2"}}),va=new Z({props:{title:"Quantization techniques",local:"quantization-techniques",headingTag:"h2"}}),_a=new Z({props:{title:"Quantization in Transformers",local:"quantization-in-transformers",headingTag:"h2"}}),$a=new Un({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTJDJTIwQml0c0FuZEJ5dGVzQ29uZmlnJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtZXRhLWxsYW1hJTJGTGxhbWEtMy4xLThCLUluc3RydWN0JTIyJTBBJTBBcXVhbnRpemF0aW9uX2NvbmZpZyUyMCUzRCUyMEJpdHNBbmRCeXRlc0NvbmZpZyglMEElMjAlMjAlMjAlMjBsb2FkX2luXzRiaXQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMG1vZGVsX2lkJTJDJTBBJTIwJTIwJTIwJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmJmbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, BitsAndBytesConfig

model_id = <span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>

quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_compute_dtype=torch.bfloat16
)

model = AutoModelForCausalLM.from_pretrained(
    model_id,
    quantization_config=quantization_config,
    torch_dtype=torch.bfloat16,
    device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),La=new Z({props:{title:"Resources",local:"resources",headingTag:"h2"}}),Ha=new Vn({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/quantization/concept_guide.md"}}),{c(){f=m("meta"),D=l(),q=m("p"),Ia=l(),b(X.$$.fragment),Va=l(),N=m("p"),N.textContent=$e,Wa=l(),O=m("p"),O.textContent=Le,Da=l(),Y=m("ul"),Y.innerHTML=Ce,Xa=l(),K=m("p"),K.innerHTML=Pe,Na=l(),aa=m("p"),aa.textContent=He,Oa=l(),b(sa.$$.fragment),Ya=l(),I=m("p"),ie=r("The core idea is to map the range of values found in the original float32 weights and activations to the much smaller range represented by int8 (typically"),Ka=new c(!1),as=r(")."),ss=l(),ta=m("p"),ta.textContent=Je,ts=l(),E=m("div"),E.innerHTML=Se,es=l(),b(ea.$$.fragment),ns=l(),d=m("p"),me=r("The most common method is "),Ea=m("em"),Ea.textContent=Ae,pe=r(". For a given float32 tensor (like a layer’s weights), it finds the minimum"),ls=new c(!1),is=r(" and maximum"),ms=new c(!1),ps=r(" values. This range"),rs=new c(!1),os=r(" is mapped to the int8 range"),cs=new c(!1),hs=r(", which is typically"),gs=new c(!1),us=r("."),ds=l(),na=m("p"),na.innerHTML=Ze,fs=l(),Q=m("ul"),w=m("li"),re=r("Symmetric: This method assumes the original float32 range is symmetric around zero ("),ws=new c(!1),ys=r(" ). This range is mapped symmetrically to the int8 range, for example,"),vs=new c(!1),xs=r(". A key characteristic is that the float32 value"),bs=new c(!1),_s=r(" maps directly to the int8 value"),Ms=new c(!1),ks=r(". This only requires one parameter, the "),la=m("strong"),oe=r("scale ("),zs=new c(!1),Ts=r(" )"),ce=r(", to define the mapping. It can simplify computations, but it might be less accurate if the original data distribution isn’t naturally centered around zero."),he=l(),v=m("li"),ge=r("Asymmetric (Affine): This method does not assume the data is centered around zero. It maps the exact range"),qs=new c(!1),$s=r(" from float32 to the full int8 range, like"),Ls=new c(!1),Cs=r(". This requires two parameters, a "),ia=m("strong"),ue=r("scale ("),Ps=new c(!1),Hs=r(" )"),de=r(" and a "),ma=m("strong"),fe=r("zero-point ("),Js=new c(!1),Ss=r(" )"),we=r("."),As=l(),H=m("p"),ye=r("scale ("),Zs=new c(!1),Is=r(` ): A positive float32 number representing the ratio between the float32 and the int8 range.
`),Es=new c(!1),Qs=l(),$=m("p"),ve=r("zero-Point ("),Fs=new c(!1),Bs=r(" ): An int8 value that corresponds to the float32 value"),Rs=new c(!1),js=r(`.
`),Gs=new c(!1),Us=l(),b(F.$$.fragment),Vs=l(),L=m("p"),xe=r("With these parameters, a float32 value,"),Ws=new c(!1),Ds=r(". can be quantized to int8 ("),Xs=new c(!1),Ns=r(` ) with the formula below.
`),Os=new c(!1),Ys=l(),J=m("p"),be=r("The int8 value,"),Ks=new c(!1),at=r(`, can be dequantized back to approximate float32 with the formula below.
`),st=new c(!1),tt=l(),B=m("div"),B.innerHTML=Ie,et=l(),R=m("p"),_e=r("During inference, computations like matrix multiplication are performed using the int8 values ("),nt=new c(!1),lt=r(" ), and the result is dequantized back to float32 (often using a higher-precision accumulation type like int32 internally) before it is passed to the next layer."),it=l(),b(pa.$$.fragment),mt=l(),j=m("div"),j.innerHTML=Ee,pt=l(),G=m("p"),Me=r("int4 quantization further reduces the model size and memory usage (halving it compared to int8). The same affine or symmetric quantization principles apply, mapping the float32 range to the 16 possible values representable by int4 ("),rt=new c(!1),ot=r(" for signed int4)."),ct=l(),ra=m("p"),ra.innerHTML=Qe,ht=l(),oa=m("p"),oa.textContent=Fe,gt=l(),ca=m("p"),ca.innerHTML=Be,ut=l(),b(ha.$$.fragment),dt=l(),U=m("div"),U.innerHTML=Re,ft=r(`
A newer datatype, 8-bit floating-point (FP8), offers another way to reduce precision while retaining more accuracy than int8 in certain scenarios. FP8 keeps the floating-point structure (sign, exponent, mantissa) but uses fewer bits.
`),ga=m("p"),ga.textContent=je,wt=l(),ua=m("ul"),ua.innerHTML=Ge,yt=l(),da=m("p"),da.innerHTML=Ue,vt=l(),fa=m("p"),fa.textContent=Ve,xt=l(),wa=m("p"),wa.innerHTML=We,bt=l(),b(ya.$$.fragment),_t=l(),C=m("p"),ke=r("Quantization parameters ("),Mt=new c(!1),kt=r(" and"),zt=new c(!1),Tt=r(") can be calculated in one of two ways."),qt=l(),V=m("ul"),S=m("li"),ze=r("Per-Tensor: One set of"),$t=new c(!1),Lt=r(" and"),Ct=new c(!1),Pt=r(" for the entire tensor. Simpler, but less accurate if data values vary greatly within the tensor."),Te=l(),A=m("li"),qe=r("Per-Channel (or Per-Group/Block): Separate"),Ht=new c(!1),Jt=r(" and"),St=new c(!1),At=r(" for each channel or group. More accurate and better performance at the cost of slightly more complexity and memory."),Zt=l(),W=m("div"),W.innerHTML=De,It=l(),b(va.$$.fragment),Et=l(),xa=m("p"),xa.textContent=Xe,Qt=l(),ba=m("ul"),ba.innerHTML=Ne,Ft=l(),b(_a.$$.fragment),Bt=l(),Ma=m("p"),Ma.innerHTML=Oe,Rt=l(),ka=m("p"),ka.innerHTML=Ye,jt=l(),za=m("p"),za.textContent=Ke,Gt=l(),Ta=m("ol"),Ta.innerHTML=an,Ut=l(),qa=m("p"),qa.textContent=sn,Vt=l(),b($a.$$.fragment),Wt=l(),b(La.$$.fragment),Dt=l(),Ca=m("p"),Ca.textContent=tn,Xt=l(),Pa=m("ul"),Pa.innerHTML=en,Nt=l(),b(Ha.$$.fragment),Ot=l(),Ra=m("p"),this.h()},l(a){const t=jn("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(s),D=i(a),q=p(a,"P",{}),u(q).forEach(s),Ia=i(a),_(X.$$.fragment,a),Va=i(a),N=p(a,"P",{"data-svelte-h":!0}),g(N)!=="svelte-sc6cfq"&&(N.textContent=$e),Wa=i(a),O=p(a,"P",{"data-svelte-h":!0}),g(O)!=="svelte-b2vy83"&&(O.textContent=Le),Da=i(a),Y=p(a,"UL",{"data-svelte-h":!0}),g(Y)!=="svelte-eskghi"&&(Y.innerHTML=Ce),Xa=i(a),K=p(a,"P",{"data-svelte-h":!0}),g(K)!=="svelte-197bk6z"&&(K.innerHTML=Pe),Na=i(a),aa=p(a,"P",{"data-svelte-h":!0}),g(aa)!=="svelte-1h2omvy"&&(aa.textContent=He),Oa=i(a),_(sa.$$.fragment,a),Ya=i(a),I=p(a,"P",{});var Ja=u(I);ie=o(Ja,"The core idea is to map the range of values found in the original float32 weights and activations to the much smaller range represented by int8 (typically"),Ka=h(Ja,!1),as=o(Ja,")."),Ja.forEach(s),ss=i(a),ta=p(a,"P",{"data-svelte-h":!0}),g(ta)!=="svelte-10j5aeo"&&(ta.textContent=Je),ts=i(a),E=p(a,"DIV",{class:!0,"data-svelte-h":!0}),g(E)!=="svelte-ski7r9"&&(E.innerHTML=Se),es=i(a),_(ea.$$.fragment,a),ns=i(a),d=p(a,"P",{});var y=u(d);me=o(y,"The most common method is "),Ea=p(y,"EM",{"data-svelte-h":!0}),g(Ea)!=="svelte-1wev7wi"&&(Ea.textContent=Ae),pe=o(y,". For a given float32 tensor (like a layer’s weights), it finds the minimum"),ls=h(y,!1),is=o(y," and maximum"),ms=h(y,!1),ps=o(y," values. This range"),rs=h(y,!1),os=o(y," is mapped to the int8 range"),cs=h(y,!1),hs=o(y,", which is typically"),gs=h(y,!1),us=o(y,"."),y.forEach(s),ds=i(a),na=p(a,"P",{"data-svelte-h":!0}),g(na)!=="svelte-1rle3a8"&&(na.innerHTML=Ze),fs=i(a),Q=p(a,"UL",{});var Kt=u(Q);w=p(Kt,"LI",{});var x=u(w);re=o(x,"Symmetric: This method assumes the original float32 range is symmetric around zero ("),ws=h(x,!1),ys=o(x," ). This range is mapped symmetrically to the int8 range, for example,"),vs=h(x,!1),xs=o(x,". A key characteristic is that the float32 value"),bs=h(x,!1),_s=o(x," maps directly to the int8 value"),Ms=h(x,!1),ks=o(x,". This only requires one parameter, the "),la=p(x,"STRONG",{});var ae=u(la);oe=o(ae,"scale ("),zs=h(ae,!1),Ts=o(ae," )"),ae.forEach(s),ce=o(x,", to define the mapping. It can simplify computations, but it might be less accurate if the original data distribution isn’t naturally centered around zero."),x.forEach(s),he=i(Kt),v=p(Kt,"LI",{});var P=u(v);ge=o(P,"Asymmetric (Affine): This method does not assume the data is centered around zero. It maps the exact range"),qs=h(P,!1),$s=o(P," from float32 to the full int8 range, like"),Ls=h(P,!1),Cs=o(P,". This requires two parameters, a "),ia=p(P,"STRONG",{});var se=u(ia);ue=o(se,"scale ("),Ps=h(se,!1),Hs=o(se," )"),se.forEach(s),de=o(P," and a "),ma=p(P,"STRONG",{});var te=u(ma);fe=o(te,"zero-point ("),Js=h(te,!1),Ss=o(te," )"),te.forEach(s),we=o(P,"."),P.forEach(s),Kt.forEach(s),As=i(a),H=p(a,"P",{});var ja=u(H);ye=o(ja,"scale ("),Zs=h(ja,!1),Is=o(ja,` ): A positive float32 number representing the ratio between the float32 and the int8 range.
`),Es=h(ja,!1),ja.forEach(s),Qs=i(a),$=p(a,"P",{});var Sa=u($);ve=o(Sa,"zero-Point ("),Fs=h(Sa,!1),Bs=o(Sa," ): An int8 value that corresponds to the float32 value"),Rs=h(Sa,!1),js=o(Sa,`.
`),Gs=h(Sa,!1),Sa.forEach(s),Us=i(a),_(F.$$.fragment,a),Vs=i(a),L=p(a,"P",{});var Aa=u(L);xe=o(Aa,"With these parameters, a float32 value,"),Ws=h(Aa,!1),Ds=o(Aa,". can be quantized to int8 ("),Xs=h(Aa,!1),Ns=o(Aa,` ) with the formula below.
`),Os=h(Aa,!1),Aa.forEach(s),Ys=i(a),J=p(a,"P",{});var Ga=u(J);be=o(Ga,"The int8 value,"),Ks=h(Ga,!1),at=o(Ga,`, can be dequantized back to approximate float32 with the formula below.
`),st=h(Ga,!1),Ga.forEach(s),tt=i(a),B=p(a,"DIV",{class:!0,"data-svelte-h":!0}),g(B)!=="svelte-1fpitf1"&&(B.innerHTML=Ie),et=i(a),R=p(a,"P",{});var ee=u(R);_e=o(ee,"During inference, computations like matrix multiplication are performed using the int8 values ("),nt=h(ee,!1),lt=o(ee," ), and the result is dequantized back to float32 (often using a higher-precision accumulation type like int32 internally) before it is passed to the next layer."),ee.forEach(s),it=i(a),_(pa.$$.fragment,a),mt=i(a),j=p(a,"DIV",{class:!0,"data-svelte-h":!0}),g(j)!=="svelte-9uyrdy"&&(j.innerHTML=Ee),pt=i(a),G=p(a,"P",{});var ne=u(G);Me=o(ne,"int4 quantization further reduces the model size and memory usage (halving it compared to int8). The same affine or symmetric quantization principles apply, mapping the float32 range to the 16 possible values representable by int4 ("),rt=h(ne,!1),ot=o(ne," for signed int4)."),ne.forEach(s),ct=i(a),ra=p(a,"P",{"data-svelte-h":!0}),g(ra)!=="svelte-18ktor2"&&(ra.innerHTML=Qe),ht=i(a),oa=p(a,"P",{"data-svelte-h":!0}),g(oa)!=="svelte-8a9mgu"&&(oa.textContent=Fe),gt=i(a),ca=p(a,"P",{"data-svelte-h":!0}),g(ca)!=="svelte-a8knkv"&&(ca.innerHTML=Be),ut=i(a),_(ha.$$.fragment,a),dt=i(a),U=p(a,"DIV",{class:!0,"data-svelte-h":!0}),g(U)!=="svelte-1729l3m"&&(U.innerHTML=Re),ft=o(a,`
A newer datatype, 8-bit floating-point (FP8), offers another way to reduce precision while retaining more accuracy than int8 in certain scenarios. FP8 keeps the floating-point structure (sign, exponent, mantissa) but uses fewer bits.
`),ga=p(a,"P",{"data-svelte-h":!0}),g(ga)!=="svelte-17rcqjn"&&(ga.textContent=je),wt=i(a),ua=p(a,"UL",{"data-svelte-h":!0}),g(ua)!=="svelte-10mhd7i"&&(ua.innerHTML=Ge),yt=i(a),da=p(a,"P",{"data-svelte-h":!0}),g(da)!=="svelte-u7surw"&&(da.innerHTML=Ue),vt=i(a),fa=p(a,"P",{"data-svelte-h":!0}),g(fa)!=="svelte-ucrayf"&&(fa.textContent=Ve),xt=i(a),wa=p(a,"P",{"data-svelte-h":!0}),g(wa)!=="svelte-r7x8yf"&&(wa.innerHTML=We),bt=i(a),_(ya.$$.fragment,a),_t=i(a),C=p(a,"P",{});var Qa=u(C);ke=o(Qa,"Quantization parameters ("),Mt=h(Qa,!1),kt=o(Qa," and"),zt=h(Qa,!1),Tt=o(Qa,") can be calculated in one of two ways."),Qa.forEach(s),qt=i(a),V=p(a,"UL",{});var le=u(V);S=p(le,"LI",{});var Fa=u(S);ze=o(Fa,"Per-Tensor: One set of"),$t=h(Fa,!1),Lt=o(Fa," and"),Ct=h(Fa,!1),Pt=o(Fa," for the entire tensor. Simpler, but less accurate if data values vary greatly within the tensor."),Fa.forEach(s),Te=i(le),A=p(le,"LI",{});var Ba=u(A);qe=o(Ba,"Per-Channel (or Per-Group/Block): Separate"),Ht=h(Ba,!1),Jt=o(Ba," and"),St=h(Ba,!1),At=o(Ba," for each channel or group. More accurate and better performance at the cost of slightly more complexity and memory."),Ba.forEach(s),le.forEach(s),Zt=i(a),W=p(a,"DIV",{class:!0,"data-svelte-h":!0}),g(W)!=="svelte-1rb2ytg"&&(W.innerHTML=De),It=i(a),_(va.$$.fragment,a),Et=i(a),xa=p(a,"P",{"data-svelte-h":!0}),g(xa)!=="svelte-1ed3kgd"&&(xa.textContent=Xe),Qt=i(a),ba=p(a,"UL",{"data-svelte-h":!0}),g(ba)!=="svelte-1ykkc6w"&&(ba.innerHTML=Ne),Ft=i(a),_(_a.$$.fragment,a),Bt=i(a),Ma=p(a,"P",{"data-svelte-h":!0}),g(Ma)!=="svelte-mxjbo8"&&(Ma.innerHTML=Oe),Rt=i(a),ka=p(a,"P",{"data-svelte-h":!0}),g(ka)!=="svelte-jwrfst"&&(ka.innerHTML=Ye),jt=i(a),za=p(a,"P",{"data-svelte-h":!0}),g(za)!=="svelte-fezu46"&&(za.textContent=Ke),Gt=i(a),Ta=p(a,"OL",{"data-svelte-h":!0}),g(Ta)!=="svelte-vpcmww"&&(Ta.innerHTML=an),Ut=i(a),qa=p(a,"P",{"data-svelte-h":!0}),g(qa)!=="svelte-1i5q76q"&&(qa.textContent=sn),Vt=i(a),_($a.$$.fragment,a),Wt=i(a),_(La.$$.fragment,a),Dt=i(a),Ca=p(a,"P",{"data-svelte-h":!0}),g(Ca)!=="svelte-lqjr7a"&&(Ca.textContent=tn),Xt=i(a),Pa=p(a,"UL",{"data-svelte-h":!0}),g(Pa)!=="svelte-1ktxolx"&&(Pa.innerHTML=en),Nt=i(a),_(Ha.$$.fragment,a),Ot=i(a),Ra=p(a,"P",{}),u(Ra).forEach(s),this.h()},h(){Za(f,"name","hf:doc:metadata"),Za(f,"content",Xn),Ka.a=as,Za(E,"class","flex justify-center"),ls.a=is,ms.a=ps,rs.a=os,cs.a=hs,gs.a=us,ws.a=ys,vs.a=xs,bs.a=_s,Ms.a=ks,zs.a=Ts,qs.a=$s,Ls.a=Cs,Ps.a=Hs,Js.a=Ss,Zs.a=Is,Es.a=null,Fs.a=Bs,Rs.a=js,Gs.a=null,Ws.a=Ds,Xs.a=Ns,Os.a=null,Ks.a=at,st.a=null,Za(B,"class","flex justify-center"),nt.a=lt,Za(j,"class","flex justify-center"),rt.a=ot,Za(U,"class","flex justify-center"),Mt.a=kt,zt.a=Tt,$t.a=Lt,Ct.a=Pt,Ht.a=Jt,St.a=At,Za(W,"class","flex justify-center")},m(a,t){n(document.head,f),e(a,D,t),e(a,q,t),e(a,Ia,t),M(X,a,t),e(a,Va,t),e(a,N,t),e(a,Wa,t),e(a,O,t),e(a,Da,t),e(a,Y,t),e(a,Xa,t),e(a,K,t),e(a,Na,t),e(a,aa,t),e(a,Oa,t),M(sa,a,t),e(a,Ya,t),e(a,I,t),n(I,ie),Ka.m(nn,I),n(I,as),e(a,ss,t),e(a,ta,t),e(a,ts,t),e(a,E,t),e(a,es,t),M(ea,a,t),e(a,ns,t),e(a,d,t),n(d,me),n(d,Ea),n(d,pe),ls.m(ln,d),n(d,is),ms.m(mn,d),n(d,ps),rs.m(pn,d),n(d,os),cs.m(rn,d),n(d,hs),gs.m(on,d),n(d,us),e(a,ds,t),e(a,na,t),e(a,fs,t),e(a,Q,t),n(Q,w),n(w,re),ws.m(cn,w),n(w,ys),vs.m(hn,w),n(w,xs),bs.m(gn,w),n(w,_s),Ms.m(un,w),n(w,ks),n(w,la),n(la,oe),zs.m(dn,la),n(la,Ts),n(w,ce),n(Q,he),n(Q,v),n(v,ge),qs.m(fn,v),n(v,$s),Ls.m(wn,v),n(v,Cs),n(v,ia),n(ia,ue),Ps.m(yn,ia),n(ia,Hs),n(v,de),n(v,ma),n(ma,fe),Js.m(vn,ma),n(ma,Ss),n(v,we),e(a,As,t),e(a,H,t),n(H,ye),Zs.m(xn,H),n(H,Is),Es.m(bn,H),e(a,Qs,t),e(a,$,t),n($,ve),Fs.m(_n,$),n($,Bs),Rs.m(Mn,$),n($,js),Gs.m(kn,$),e(a,Us,t),M(F,a,t),e(a,Vs,t),e(a,L,t),n(L,xe),Ws.m(zn,L),n(L,Ds),Xs.m(Tn,L),n(L,Ns),Os.m(qn,L),e(a,Ys,t),e(a,J,t),n(J,be),Ks.m($n,J),n(J,at),st.m(Ln,J),e(a,tt,t),e(a,B,t),e(a,et,t),e(a,R,t),n(R,_e),nt.m(Cn,R),n(R,lt),e(a,it,t),M(pa,a,t),e(a,mt,t),e(a,j,t),e(a,pt,t),e(a,G,t),n(G,Me),rt.m(Pn,G),n(G,ot),e(a,ct,t),e(a,ra,t),e(a,ht,t),e(a,oa,t),e(a,gt,t),e(a,ca,t),e(a,ut,t),M(ha,a,t),e(a,dt,t),e(a,U,t),e(a,ft,t),e(a,ga,t),e(a,wt,t),e(a,ua,t),e(a,yt,t),e(a,da,t),e(a,vt,t),e(a,fa,t),e(a,xt,t),e(a,wa,t),e(a,bt,t),M(ya,a,t),e(a,_t,t),e(a,C,t),n(C,ke),Mt.m(Hn,C),n(C,kt),zt.m(Jn,C),n(C,Tt),e(a,qt,t),e(a,V,t),n(V,S),n(S,ze),$t.m(Sn,S),n(S,Lt),Ct.m(An,S),n(S,Pt),n(V,Te),n(V,A),n(A,qe),Ht.m(Zn,A),n(A,Jt),St.m(In,A),n(A,At),e(a,Zt,t),e(a,W,t),e(a,It,t),M(va,a,t),e(a,Et,t),e(a,xa,t),e(a,Qt,t),e(a,ba,t),e(a,Ft,t),M(_a,a,t),e(a,Bt,t),e(a,Ma,t),e(a,Rt,t),e(a,ka,t),e(a,jt,t),e(a,za,t),e(a,Gt,t),e(a,Ta,t),e(a,Ut,t),e(a,qa,t),e(a,Vt,t),M($a,a,t),e(a,Wt,t),M(La,a,t),e(a,Dt,t),e(a,Ca,t),e(a,Xt,t),e(a,Pa,t),e(a,Nt,t),M(Ha,a,t),e(a,Ot,t),e(a,Ra,t),Yt=!0},p(a,[t]){const Ja={};t&2&&(Ja.$$scope={dirty:t,ctx:a}),F.$set(Ja)},i(a){Yt||(k(X.$$.fragment,a),k(sa.$$.fragment,a),k(ea.$$.fragment,a),k(F.$$.fragment,a),k(pa.$$.fragment,a),k(ha.$$.fragment,a),k(ya.$$.fragment,a),k(va.$$.fragment,a),k(_a.$$.fragment,a),k($a.$$.fragment,a),k(La.$$.fragment,a),k(Ha.$$.fragment,a),Yt=!0)},o(a){z(X.$$.fragment,a),z(sa.$$.fragment,a),z(ea.$$.fragment,a),z(F.$$.fragment,a),z(pa.$$.fragment,a),z(ha.$$.fragment,a),z(ya.$$.fragment,a),z(va.$$.fragment,a),z(_a.$$.fragment,a),z($a.$$.fragment,a),z(La.$$.fragment,a),z(Ha.$$.fragment,a),Yt=!1},d(a){a&&(s(D),s(q),s(Ia),s(Va),s(N),s(Wa),s(O),s(Da),s(Y),s(Xa),s(K),s(Na),s(aa),s(Oa),s(Ya),s(I),s(ss),s(ta),s(ts),s(E),s(es),s(ns),s(d),s(ds),s(na),s(fs),s(Q),s(As),s(H),s(Qs),s($),s(Us),s(Vs),s(L),s(Ys),s(J),s(tt),s(B),s(et),s(R),s(it),s(mt),s(j),s(pt),s(G),s(ct),s(ra),s(ht),s(oa),s(gt),s(ca),s(ut),s(dt),s(U),s(ft),s(ga),s(wt),s(ua),s(yt),s(da),s(vt),s(fa),s(xt),s(wa),s(bt),s(_t),s(C),s(qt),s(V),s(Zt),s(W),s(It),s(Et),s(xa),s(Qt),s(ba),s(Ft),s(Bt),s(Ma),s(Rt),s(ka),s(jt),s(za),s(Gt),s(Ta),s(Ut),s(qa),s(Vt),s(Wt),s(Dt),s(Ca),s(Xt),s(Pa),s(Nt),s(Ot),s(Ra)),s(f),T(X,a),T(sa,a),T(ea,a),T(F,a),T(pa,a),T(ha,a),T(ya,a),T(va,a),T(_a,a),T($a,a),T(La,a),T(Ha,a)}}}const Xn='{"title":"Quantization concepts","local":"quantization-concepts","sections":[{"title":"Quantization schemes","local":"quantization-schemes","sections":[{"title":"Affine quantization","local":"affine-quantization","sections":[],"depth":3},{"title":"int4 and weight packing","local":"int4-and-weight-packing","sections":[],"depth":3},{"title":"FP8 Quantization (A8W8)","local":"fp8-quantization-a8w8","sections":[],"depth":3}],"depth":2},{"title":"Granularity","local":"granularity","sections":[],"depth":2},{"title":"Quantization techniques","local":"quantization-techniques","sections":[],"depth":2},{"title":"Quantization in Transformers","local":"quantization-in-transformers","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2}],"depth":1}';function Nn(Ua){return Qn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class el extends Bn{constructor(f){super(),Rn(this,f,Nn,Dn,En,{})}}export{el as component};
