import{s as Ye,n as Oe,o as sa}from"../chunks/scheduler.18a86fab.js";import{S as ta,i as ea,g as l,s as n,r,m as ne,H as oe,A as aa,h as i,f as e,c as o,j as $s,u,x as p,n as le,B as ie,k as _s,y as Ls,a,v as c,d as m,t as h,w as d}from"../chunks/index.98837b22.js";import{Y as pe}from"../chunks/Youtube.14fb207c.js";import{C as y}from"../chunks/CodeBlock.8d0c2e8a.js";import{D as na}from"../chunks/DocNotebookDropdown.a04a6b2a.js";import{H as b}from"../chunks/Heading.7e7e0c5b.js";import{E as oa}from"../chunks/index.499f366c.js";function la(ue){let f,Hs,Cs,As,w,Es,M,Ss,j,ce="On this page, we will have a closer look at tokenization.",Bs,v,Ds,T,me=`As we saw in <a href="preprocessing">the preprocessing tutorial</a>, tokenizing a text is splitting it into words or
subwords, which then are converted to ids through a look-up table. Converting words or subwords to ids is
straightforward, so in this summary, we will focus on splitting a text into words or subwords (i.e. tokenizing a text).
More specifically, we will look at the three main types of tokenizers used in 🤗 Transformers: <a href="#byte-pair-encoding">Byte-Pair Encoding
(BPE)</a>, <a href="#wordpiece">WordPiece</a>, and <a href="#sentencepiece">SentencePiece</a>, and show examples
of which tokenizer type is used by which model.`,Ns,J,he=`Note that on each model page, you can look at the documentation of the associated tokenizer to know which tokenizer
type was used by the pretrained model. For instance, if we look at <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a>, we can see
that the model uses <a href="#wordpiece">WordPiece</a>.`,Ws,k,Zs,$,de=`Splitting a text into smaller chunks is a task that is harder than it looks, and there are multiple ways of doing so.
For instance, let’s look at the sentence <code>&quot;Don&#39;t you love 🤗 Transformers? We sure do.&quot;</code>`,Gs,x,Vs,z,ge="A simple way of tokenizing this text is to split it by spaces, which would give:",Qs,I,Xs,U,ye=`This is a sensible first step, but if we look at the tokens <code>&quot;Transformers?&quot;</code> and <code>&quot;do.&quot;</code>, we notice that the
punctuation is attached to the words <code>&quot;Transformer&quot;</code> and <code>&quot;do&quot;</code>, which is suboptimal. We should take the
punctuation into account so that a model does not have to learn a different representation of a word and every possible
punctuation symbol that could follow it, which would explode the number of representations the model has to learn.
Taking punctuation into account, tokenizing our exemplary text would give:`,Ks,_,Rs,C,fe=`Better. However, it is disadvantageous, how the tokenization dealt with the word <code>&quot;Don&#39;t&quot;</code>. <code>&quot;Don&#39;t&quot;</code> stands for
<code>&quot;do not&quot;</code>, so it would be better tokenized as <code>[&quot;Do&quot;, &quot;n&#39;t&quot;]</code>. This is where things start getting complicated, and
part of the reason each model has its own tokenizer type. Depending on the rules we apply for tokenizing a text, a
different tokenized output is generated for the same text. A pretrained model only performs properly if you feed it an
input that was tokenized with the same rules that were used to tokenize its training data.`,Fs,P,qe=`<a href="https://spacy.io/" rel="nofollow">spaCy</a> and <a href="http://www.statmt.org/moses/?n=Development.GetStarted" rel="nofollow">Moses</a> are two popular
rule-based tokenizers. Applying them on our example, <em>spaCy</em> and <em>Moses</em> would output something like:`,Ys,L,Os,H,be=`As can be seen space and punctuation tokenization, as well as rule-based tokenization, is used here. Space and
punctuation tokenization and rule-based tokenization are both examples of word tokenization, which is loosely defined
as splitting sentences into words. While it’s the most intuitive way to split texts into smaller chunks, this
tokenization method can lead to problems for massive text corpora. In this case, space and punctuation tokenization
usually generates a very big vocabulary (the set of all unique words and tokens used). <em>E.g.</em>, <a href="model_doc/transfo-xl">Transformer XL</a> uses space and punctuation tokenization, resulting in a vocabulary size of 267,735!`,st,A,we=`Such a big vocabulary size forces the model to have an enormous embedding matrix as the input and output layer, which
causes both an increased memory and time complexity. In general, transformers models rarely have a vocabulary size
greater than 50,000, especially if they are pretrained only on a single language.`,tt,E,Me="So if simple space and punctuation tokenization is unsatisfactory, why not simply tokenize on characters?",et,S,at,B,je=`While character tokenization is very simple and would greatly reduce memory and time complexity it makes it much harder
for the model to learn meaningful input representations. <em>E.g.</em> learning a meaningful context-independent
representation for the letter <code>&quot;t&quot;</code> is much harder than learning a context-independent representation for the word
<code>&quot;today&quot;</code>. Therefore, character tokenization is often accompanied by a loss of performance. So to get the best of
both worlds, transformers models use a hybrid between word-level and character-level tokenization called <strong>subword</strong>
tokenization.`,nt,D,ot,N,lt,W,ve=`Subword tokenization algorithms rely on the principle that frequently used words should not be split into smaller
subwords, but rare words should be decomposed into meaningful subwords. For instance <code>&quot;annoyingly&quot;</code> might be
considered a rare word and could be decomposed into <code>&quot;annoying&quot;</code> and <code>&quot;ly&quot;</code>. Both <code>&quot;annoying&quot;</code> and <code>&quot;ly&quot;</code> as
stand-alone subwords would appear more frequently while at the same time the meaning of <code>&quot;annoyingly&quot;</code> is kept by the
composite meaning of <code>&quot;annoying&quot;</code> and <code>&quot;ly&quot;</code>. This is especially useful in agglutinative languages such as Turkish,
where you can form (almost) arbitrarily long complex words by stringing together subwords.`,it,Z,Te=`Subword tokenization allows the model to have a reasonable vocabulary size while being able to learn meaningful
context-independent representations. In addition, subword tokenization enables the model to process words it has never
seen before, by decomposing them into known subwords. For instance, the <a href="/docs/transformers/main/en/model_doc/bert#transformers.BertTokenizer">BertTokenizer</a> tokenizes
<code>&quot;I have a new GPU!&quot;</code> as follows:`,pt,G,rt,V,Je=`Because we are considering the uncased model, the sentence was lowercased first. We can see that the words <code>[&quot;i&quot;, &quot;have&quot;, &quot;a&quot;, &quot;new&quot;]</code> are present in the tokenizer’s vocabulary, but the word <code>&quot;gpu&quot;</code> is not. Consequently, the
tokenizer splits <code>&quot;gpu&quot;</code> into known subwords: <code>[&quot;gp&quot; and &quot;##u&quot;]</code>. <code>&quot;##&quot;</code> means that the rest of the token should
be attached to the previous one, without space (for decoding or reversal of the tokenization).`,ut,Q,ke='As another example, <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> tokenizes our previously exemplary text as follows:',ct,X,mt,K,$e=`We’ll get back to the meaning of those <code>&quot;▁&quot;</code> when we look at <a href="#sentencepiece">SentencePiece</a>. As one can see,
the rare word <code>&quot;Transformers&quot;</code> has been split into the more frequent subwords <code>&quot;Transform&quot;</code> and <code>&quot;ers&quot;</code>.`,ht,R,xe=`Let’s now look at how the different subword tokenization algorithms work. Note that all of those tokenization
algorithms rely on some form of training which is usually done on the corpus the corresponding model will be trained
on.`,dt,xs,gt,F,yt,Y,ze=`Byte-Pair Encoding (BPE) was introduced in <a href="https://arxiv.org/abs/1508.07909" rel="nofollow">Neural Machine Translation of Rare Words with Subword Units (Sennrich et
al., 2015)</a>. BPE relies on a pre-tokenizer that splits the training data into
words. Pretokenization can be as simple as space tokenization, e.g. <a href="model_doc/gpt2">GPT-2</a>, <a href="model_doc/roberta">RoBERTa</a>. More advanced pre-tokenization include rule-based tokenization, e.g. <a href="model_doc/xlm">XLM</a>,
<a href="model_doc/flaubert">FlauBERT</a> which uses Moses for most languages, or <a href="model_doc/openai-gpt">GPT</a> which uses
spaCy and ftfy, to count the frequency of each word in the training corpus.`,ft,O,Ie=`After pre-tokenization, a set of unique words has been created and the frequency with which each word occurred in the
training data has been determined. Next, BPE creates a base vocabulary consisting of all symbols that occur in the set
of unique words and learns merge rules to form a new symbol from two symbols of the base vocabulary. It does so until
the vocabulary has attained the desired vocabulary size. Note that the desired vocabulary size is a hyperparameter to
define before training the tokenizer.`,qt,ss,Ue=`As an example, let’s assume that after pre-tokenization, the following set of words including their frequency has been
determined:`,bt,ts,wt,es,_e=`Consequently, the base vocabulary is <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;]</code>. Splitting all words into symbols of the
base vocabulary, we obtain:`,Mt,as,jt,ns,Ce=`BPE then counts the frequency of each possible symbol pair and picks the symbol pair that occurs most frequently. In
the example above <code>&quot;h&quot;</code> followed by <code>&quot;u&quot;</code> is present <em>10 + 5 = 15</em> times (10 times in the 10 occurrences of
<code>&quot;hug&quot;</code>, 5 times in the 5 occurrences of <code>&quot;hugs&quot;</code>). However, the most frequent symbol pair is <code>&quot;u&quot;</code> followed by
<code>&quot;g&quot;</code>, occurring <em>10 + 5 + 5 = 20</em> times in total. Thus, the first merge rule the tokenizer learns is to group all
<code>&quot;u&quot;</code> symbols followed by a <code>&quot;g&quot;</code> symbol together. Next, <code>&quot;ug&quot;</code> is added to the vocabulary. The set of words then
becomes`,vt,os,Tt,ls,Pe=`BPE then identifies the next most common symbol pair. It’s <code>&quot;u&quot;</code> followed by <code>&quot;n&quot;</code>, which occurs 16 times. <code>&quot;u&quot;</code>,
<code>&quot;n&quot;</code> is merged to <code>&quot;un&quot;</code> and added to the vocabulary. The next most frequent symbol pair is <code>&quot;h&quot;</code> followed by
<code>&quot;ug&quot;</code>, occurring 15 times. Again the pair is merged and <code>&quot;hug&quot;</code> can be added to the vocabulary.`,Jt,is,Le=`At this stage, the vocabulary is <code>[&quot;b&quot;, &quot;g&quot;, &quot;h&quot;, &quot;n&quot;, &quot;p&quot;, &quot;s&quot;, &quot;u&quot;, &quot;ug&quot;, &quot;un&quot;, &quot;hug&quot;]</code> and our set of unique words
is represented as`,kt,ps,$t,rs,He=`Assuming, that the Byte-Pair Encoding training would stop at this point, the learned merge rules would then be applied
to new words (as long as those new words do not include symbols that were not in the base vocabulary). For instance,
the word <code>&quot;bug&quot;</code> would be tokenized to <code>[&quot;b&quot;, &quot;ug&quot;]</code> but <code>&quot;mug&quot;</code> would be tokenized as <code>[&quot;&lt;unk&gt;&quot;, &quot;ug&quot;]</code> since
the symbol <code>&quot;m&quot;</code> is not in the base vocabulary. In general, single letters such as <code>&quot;m&quot;</code> are not replaced by the
<code>&quot;&lt;unk&gt;&quot;</code> symbol because the training data usually includes at least one occurrence of each letter, but it is likely
to happen for very special characters like emojis.`,xt,us,Ae=`As mentioned earlier, the vocabulary size, <em>i.e.</em> the base vocabulary size + the number of merges, is a hyperparameter
to choose. For instance <a href="model_doc/openai-gpt">GPT</a> has a vocabulary size of 40,478 since they have 478 base characters
and chose to stop training after 40,000 merges.`,zt,cs,It,ms,Ee=`A base vocabulary that includes all possible base characters can be quite large if <em>e.g.</em> all unicode characters are
considered as base characters. To have a better base vocabulary, <a href="https://cdn.openai.com/better-language-models/language_models_are_unsupervised_multitask_learners.pdf" rel="nofollow">GPT-2</a> uses bytes
as the base vocabulary, which is a clever trick to force the base vocabulary to be of size 256 while ensuring that
every base character is included in the vocabulary. With some additional rules to deal with punctuation, the GPT2’s
tokenizer can tokenize every text without the need for the &lt;unk&gt; symbol. <a href="model_doc/gpt">GPT-2</a> has a vocabulary
size of 50,257, which corresponds to the 256 bytes base tokens, a special end-of-text token and the symbols learned
with 50,000 merges.`,Ut,zs,_t,hs,Ct,ds,Se=`WordPiece is the subword tokenization algorithm used for <a href="model_doc/bert">BERT</a>, <a href="model_doc/distilbert">DistilBERT</a>, and <a href="model_doc/electra">Electra</a>. The algorithm was outlined in <a href="https://static.googleusercontent.com/media/research.google.com/ja//pubs/archive/37842.pdf" rel="nofollow">Japanese and Korean
Voice Search (Schuster et al., 2012)</a> and is very similar to
BPE. WordPiece first initializes the vocabulary to include every character present in the training data and
progressively learns a given number of merge rules. In contrast to BPE, WordPiece does not choose the most frequent
symbol pair, but the one that maximizes the likelihood of the training data once added to the vocabulary.`,Pt,gs,Be=`So what does this mean exactly? Referring to the previous example, maximizing the likelihood of the training data is
equivalent to finding the symbol pair, whose probability divided by the probabilities of its first symbol followed by
its second symbol is the greatest among all symbol pairs. <em>E.g.</em> <code>&quot;u&quot;</code>, followed by <code>&quot;g&quot;</code> would have only been
merged if the probability of <code>&quot;ug&quot;</code> divided by <code>&quot;u&quot;</code>, <code>&quot;g&quot;</code> would have been greater than for any other symbol
pair. Intuitively, WordPiece is slightly different to BPE in that it evaluates what it <em>loses</em> by merging two symbols
to ensure it’s <em>worth it</em>.`,Lt,Is,Ht,ys,At,fs,De=`Unigram is a subword tokenization algorithm introduced in <a href="https://arxiv.org/pdf/1804.10959.pdf" rel="nofollow">Subword Regularization: Improving Neural Network Translation
Models with Multiple Subword Candidates (Kudo, 2018)</a>. In contrast to BPE or
WordPiece, Unigram initializes its base vocabulary to a large number of symbols and progressively trims down each
symbol to obtain a smaller vocabulary. The base vocabulary could for instance correspond to all pre-tokenized words and
the most common substrings. Unigram is not used directly for any of the models in the transformers, but it’s used in
conjunction with <a href="#sentencepiece">SentencePiece</a>.`,Et,qs,Ne=`At each training step, the Unigram algorithm defines a loss (often defined as the log-likelihood) over the training
data given the current vocabulary and a unigram language model. Then, for each symbol in the vocabulary, the algorithm
computes how much the overall loss would increase if the symbol was to be removed from the vocabulary. Unigram then
removes p (with p usually being 10% or 20%) percent of the symbols whose loss increase is the lowest, <em>i.e.</em> those
symbols that least affect the overall loss over the training data. This process is repeated until the vocabulary has
reached the desired size. The Unigram algorithm always keeps the base characters so that any word can be tokenized.`,St,bs,We=`Because Unigram is not based on merge rules (in contrast to BPE and WordPiece), the algorithm has several ways of
tokenizing new text after training. As an example, if a trained Unigram tokenizer exhibits the vocabulary:`,Bt,ws,Dt,Ms,Ze=`<code>&quot;hugs&quot;</code> could be tokenized both as <code>[&quot;hug&quot;, &quot;s&quot;]</code>, <code>[&quot;h&quot;, &quot;ug&quot;, &quot;s&quot;]</code> or <code>[&quot;h&quot;, &quot;u&quot;, &quot;g&quot;, &quot;s&quot;]</code>. So which one
to choose? Unigram saves the probability of each token in the training corpus on top of saving the vocabulary so that
the probability of each possible tokenization can be computed after training. The algorithm simply picks the most
likely tokenization in practice, but also offers the possibility to sample a possible tokenization according to their
probabilities.`,Nt,g,re,Wt,Xe='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi>x</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex">x_{1}, \\dots, x_{N}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.625em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mtight">1</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Zt,Gt,Ke='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>x</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex">x_{i}</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.5806em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Vt,Qt,Re='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>S</mi><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">S(x_{i})</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.05764em;">S</span><span class="mopen">(</span><span class="mord"><span class="mord mathnormal">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',Xt,Kt,Fe=`<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi mathvariant="script">L</mi><mo>=</mo><mo>−</mo><munderover><mo>∑</mo><mrow><mi>i</mi><mo>=</mo><mn>1</mn></mrow><mi>N</mi></munderover><mi>log</mi><mo>⁡</mo><mrow><mo fence="true">(</mo><munder><mo>∑</mo><mrow><mi>x</mi><mo>∈</mo><mi>S</mi><mo stretchy="false">(</mo><msub><mi>x</mi><mi>i</mi></msub><mo stretchy="false">)</mo></mrow></munder><mi>p</mi><mo stretchy="false">(</mo><mi>x</mi><mo stretchy="false">)</mo><mo fence="true">)</mo></mrow></mrow><annotation encoding="application/x-tex">\\mathcal{L} = -\\sum_{i=1}^{N} \\log \\left ( \\sum_{x \\in S(x_{i})} p(x) \\right )</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathcal">L</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:3.6em;vertical-align:-1.55em;"></span><span class="mord">−</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.8283em;"><span style="top:-1.8723em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mrel mtight">=</span><span class="mord mtight">1</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span><span style="top:-4.3em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.2777em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mop">lo<span style="margin-right:0.01389em;">g</span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner"><span class="mopen"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.05em;"><span style="top:-4.05em;"><span class="pstrut" style="height:5.6em;"></span><span style="width:0.875em;height:3.600em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='3.600em' viewBox='0 0 875 3600'><path d='M863,9c0,-2,-2,-5,-6,-9c0,0,-17,0,-17,0c-12.7,0,-19.3,0.3,-20,1
c-5.3,5.3,-10.3,11,-15,17c-242.7,294.7,-395.3,682,-458,1162c-21.3,163.3,-33.3,349,
-36,557 l0,84c0.2,6,0,26,0,60c2,159.3,10,310.7,24,454c53.3,528,210,
949.7,470,1265c4.7,6,9.7,11.7,15,17c0.7,0.7,7,1,19,1c0,0,18,0,18,0c4,-4,6,-7,6,-9
c0,-2.7,-3.3,-8.7,-10,-18c-135.3,-192.7,-235.5,-414.3,-300.5,-665c-65,-250.7,-102.5,
-544.7,-112.5,-882c-2,-104,-3,-167,-3,-189
l0,-92c0,-162.7,5.7,-314,17,-454c20.7,-272,63.7,-513,129,-723c65.3,
-210,155.3,-396.3,270,-559c6.7,-9.3,10,-15.3,10,-18z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.55em;"><span></span></span></span></span></span></span><span class="mop op-limits"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:1.05em;"><span style="top:-1.809em;margin-left:0em;"><span class="pstrut" style="height:3.05em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="mrel mtight">∈</span><span class="mord mathnormal mtight" style="margin-right:0.05764em;">S</span><span class="mopen mtight">(</span><span class="mord mtight"><span class="mord mathnormal mtight">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3281em;"><span style="top:-2.357em;margin-left:0em;margin-right:0.0714em;"><span class="pstrut" style="height:2.5em;"></span><span class="sizing reset-size3 size1 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.143em;"><span></span></span></span></span></span></span><span class="mclose mtight">)</span></span></span></span><span style="top:-3.05em;"><span class="pstrut" style="height:3.05em;"></span><span><span class="mop op-symbol large-op">∑</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.516em;"><span></span></span></span></span></span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">p</span><span class="mopen">(</span><span class="mord mathnormal">x</span><span class="mclose">)</span><span class="mclose"><span class="delimsizing mult"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:2.05em;"><span style="top:-4.05em;"><span class="pstrut" style="height:5.6em;"></span><span style="width:0.875em;height:3.600em;"><svg xmlns="http://www.w3.org/2000/svg" width='0.875em' height='3.600em' viewBox='0 0 875 3600'><path d='M76,0c-16.7,0,-25,3,-25,9c0,2,2,6.3,6,13c21.3,28.7,42.3,60.3,
63,95c96.7,156.7,172.8,332.5,228.5,527.5c55.7,195,92.8,416.5,111.5,664.5
c11.3,139.3,17,290.7,17,454c0,28,1.7,43,3.3,45l0,9
c-3,4,-3.3,16.7,-3.3,38c0,162,-5.7,313.7,-17,455c-18.7,248,-55.8,469.3,-111.5,664
c-55.7,194.7,-131.8,370.3,-228.5,527c-20.7,34.7,-41.7,66.3,-63,95c-2,3.3,-4,7,-6,11
c0,7.3,5.7,11,17,11c0,0,11,0,11,0c9.3,0,14.3,-0.3,15,-1c5.3,-5.3,10.3,-11,15,-17
c242.7,-294.7,395.3,-681.7,458,-1161c21.3,-164.7,33.3,-350.7,36,-558
l0,-144c-2,-159.3,-10,-310.7,-24,-454c-53.3,-528,-210,-949.7,
-470,-1265c-4.7,-6,-9.7,-11.7,-15,-17c-0.7,-0.7,-6.7,-1,-18,-1z'/></svg></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:1.55em;"><span></span></span></span></span></span></span></span></span></span></span></span>`,Rt,Us,Ft,js,Yt,vs,Ge=`All tokenization algorithms described so far have the same problem: It is assumed that the input text uses spaces to
separate words. However, not all languages use spaces to separate words. One possible solution is to use language
specific pre-tokenizers, <em>e.g.</em> <a href="model_doc/xlm">XLM</a> uses a specific Chinese, Japanese, and Thai pre-tokenizer.
To solve this problem more generally, <a href="https://arxiv.org/pdf/1808.06226.pdf" rel="nofollow">SentencePiece: A simple and language independent subword tokenizer and
detokenizer for Neural Text Processing (Kudo et al., 2018)</a> treats the input
as a raw input stream, thus including the space in the set of characters to use. It then uses the BPE or unigram
algorithm to construct the appropriate vocabulary.`,Ot,Ts,Ve=`The <a href="/docs/transformers/main/en/model_doc/xlnet#transformers.XLNetTokenizer">XLNetTokenizer</a> uses SentencePiece for example, which is also why in the example earlier the
<code>&quot;▁&quot;</code> character was included in the vocabulary. Decoding with SentencePiece is very easy since all tokens can just be
concatenated and <code>&quot;▁&quot;</code> is replaced by a space.`,se,Js,Qe=`All transformers models in the library that use SentencePiece use it in combination with unigram. Examples of models
using SentencePiece are <a href="model_doc/albert">ALBERT</a>, <a href="model_doc/xlnet">XLNet</a>, <a href="model_doc/marian">Marian</a>, and <a href="model_doc/t5">T5</a>.`,te,ks,ee,Ps,ae;return w=new b({props:{title:"Summary of the tokenizers",local:"summary-of-the-tokenizers",headingTag:"h1"}}),M=new na({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tokenizer_summary.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tokenizer_summary.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tokenizer_summary.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tokenizer_summary.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/tokenizer_summary.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/tokenizer_summary.ipynb"}]}}),v=new pe({props:{id:"VFp38yj8h3A"}}),k=new b({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),x=new pe({props:{id:"nhJxYji1aho"}}),I=new y({props:{code:"JTVCJTIyRG9uJ3QlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8uJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Don&#x27;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do.&quot;</span>]</span>',wrap:!1}}),_=new y({props:{code:"JTVCJTIyRG9uJTIyJTJDJTIwJTIyJyUyMiUyQyUyMCUyMnQlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8lMjIlMkMlMjAlMjIuJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Don&quot;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]</span>',wrap:!1}}),L=new y({props:{code:"JTVCJTIyRG8lMjIlMkMlMjAlMjJuJ3QlMjIlMkMlMjAlMjJ5b3UlMjIlMkMlMjAlMjJsb3ZlJTIyJTJDJTIwJTIyJUYwJTlGJUE0JTk3JTIyJTJDJTIwJTIyVHJhbnNmb3JtZXJzJTIyJTJDJTIwJTIyJTNGJTIyJTJDJTIwJTIyV2UlMjIlMkMlMjAlMjJzdXJlJTIyJTJDJTIwJTIyZG8lMjIlMkMlMjAlMjIuJTIyJTVE",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;Do&quot;</span>, <span class="hljs-string">&quot;n&#x27;t&quot;</span>, <span class="hljs-string">&quot;you&quot;</span>, <span class="hljs-string">&quot;love&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;Transformers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;We&quot;</span>, <span class="hljs-string">&quot;sure&quot;</span>, <span class="hljs-string">&quot;do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]</span>',wrap:!1}}),S=new pe({props:{id:"ssLq_EK2jLE"}}),D=new b({props:{title:"Subword tokenization",local:"subword-tokenization",headingTag:"h2"}}),N=new pe({props:{id:"zHvTiHr506c"}}),G=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRUb2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJnb29nbGUtYmVydCUyRmJlcnQtYmFzZS11bmNhc2VkJTIyKSUwQXRva2VuaXplci50b2tlbml6ZSglMjJJJTIwaGF2ZSUyMGElMjBuZXclMjBHUFUhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-base-uncased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.tokenize(<span class="hljs-string">&quot;I have a new GPU!&quot;</span>)
[<span class="hljs-string">&quot;i&quot;</span>, <span class="hljs-string">&quot;have&quot;</span>, <span class="hljs-string">&quot;a&quot;</span>, <span class="hljs-string">&quot;new&quot;</span>, <span class="hljs-string">&quot;gp&quot;</span>, <span class="hljs-string">&quot;##u&quot;</span>, <span class="hljs-string">&quot;!&quot;</span>]`,wrap:!1}}),X=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFhMTmV0VG9rZW5pemVyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwWExOZXRUb2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnhsbmV0JTJGeGxuZXQtYmFzZS1jYXNlZCUyMiklMEF0b2tlbml6ZXIudG9rZW5pemUoJTIyRG9uJ3QlMjB5b3UlMjBsb3ZlJTIwJUYwJTlGJUE0JTk3JTIwVHJhbnNmb3JtZXJzJTNGJTIwV2UlMjBzdXJlJTIwZG8uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> XLNetTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = XLNetTokenizer.from_pretrained(<span class="hljs-string">&quot;xlnet/xlnet-base-cased&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.tokenize(<span class="hljs-string">&quot;Don&#x27;t you love 🤗 Transformers? We sure do.&quot;</span>)
[<span class="hljs-string">&quot;▁Don&quot;</span>, <span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&quot;t&quot;</span>, <span class="hljs-string">&quot;▁you&quot;</span>, <span class="hljs-string">&quot;▁love&quot;</span>, <span class="hljs-string">&quot;▁&quot;</span>, <span class="hljs-string">&quot;🤗&quot;</span>, <span class="hljs-string">&quot;▁&quot;</span>, <span class="hljs-string">&quot;Transform&quot;</span>, <span class="hljs-string">&quot;ers&quot;</span>, <span class="hljs-string">&quot;?&quot;</span>, <span class="hljs-string">&quot;▁We&quot;</span>, <span class="hljs-string">&quot;▁sure&quot;</span>, <span class="hljs-string">&quot;▁do&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>]`,wrap:!1}}),F=new b({props:{title:"Byte-Pair Encoding (BPE)",local:"byte-pair-encoding-bpe",headingTag:"h3"}}),ts=new y({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwdWclMjIlMkMlMjA1KSUyQyUyMCglMjJwdW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVncyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;pun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;bun&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hugs&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),as=new y({props:{code:"KCUyMmglMjIlMjAlMjJ1JTIyJTIwJTIyZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMmclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnUlMjIlMjAlMjJnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;g&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),os=new y({props:{code:"KCUyMmglMjIlMjAlMjJ1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydSUyMiUyMCUyMm4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnUlMjIlMjAlMjJuJTIyJTJDJTIwNCklMkMlMjAoJTIyaCUyMiUyMCUyMnVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;u&quot;</span> <span class="hljs-string">&quot;n&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;h&quot;</span> <span class="hljs-string">&quot;ug&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),ps=new y({props:{code:"KCUyMmh1ZyUyMiUyQyUyMDEwKSUyQyUyMCglMjJwJTIyJTIwJTIydWclMjIlMkMlMjA1KSUyQyUyMCglMjJwJTIyJTIwJTIydW4lMjIlMkMlMjAxMiklMkMlMjAoJTIyYiUyMiUyMCUyMnVuJTIyJTJDJTIwNCklMkMlMjAoJTIyaHVnJTIyJTIwJTIycyUyMiUyQyUyMDUp",highlighted:'(<span class="hljs-string">&quot;hug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">10</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;ug&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;p&quot;</span> <span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">12</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;b&quot;</span> <span class="hljs-string">&quot;un&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">4</span>)<span class="hljs-punctuation">,</span> (<span class="hljs-string">&quot;hug&quot;</span> <span class="hljs-string">&quot;s&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-number">5</span>)',wrap:!1}}),cs=new b({props:{title:"Byte-level BPE",local:"byte-level-bpe",headingTag:"h4"}}),hs=new b({props:{title:"WordPiece",local:"wordpiece",headingTag:"h3"}}),ys=new b({props:{title:"Unigram",local:"unigram",headingTag:"h3"}}),ws=new y({props:{code:"JTVCJTIyYiUyMiUyQyUyMCUyMmclMjIlMkMlMjAlMjJoJTIyJTJDJTIwJTIybiUyMiUyQyUyMCUyMnAlMjIlMkMlMjAlMjJzJTIyJTJDJTIwJTIydSUyMiUyQyUyMCUyMnVnJTIyJTJDJTIwJTIydW4lMjIlMkMlMjAlMjJodWclMjIlNUQlMkM=",highlighted:'<span class="hljs-selector-attr">[<span class="hljs-string">&quot;b&quot;</span>, <span class="hljs-string">&quot;g&quot;</span>, <span class="hljs-string">&quot;h&quot;</span>, <span class="hljs-string">&quot;n&quot;</span>, <span class="hljs-string">&quot;p&quot;</span>, <span class="hljs-string">&quot;s&quot;</span>, <span class="hljs-string">&quot;u&quot;</span>, <span class="hljs-string">&quot;ug&quot;</span>, <span class="hljs-string">&quot;un&quot;</span>, <span class="hljs-string">&quot;hug&quot;</span>]</span>,',wrap:!1}}),js=new b({props:{title:"SentencePiece",local:"sentencepiece",headingTag:"h3"}}),ks=new oa({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/tokenizer_summary.md"}}),{c(){f=l("meta"),Hs=n(),Cs=l("p"),As=n(),r(w.$$.fragment),Es=n(),r(M.$$.fragment),Ss=n(),j=l("p"),j.textContent=ce,Bs=n(),r(v.$$.fragment),Ds=n(),T=l("p"),T.innerHTML=me,Ns=n(),J=l("p"),J.innerHTML=he,Ws=n(),r(k.$$.fragment),Zs=n(),$=l("p"),$.innerHTML=de,Gs=n(),r(x.$$.fragment),Vs=n(),z=l("p"),z.textContent=ge,Qs=n(),r(I.$$.fragment),Xs=n(),U=l("p"),U.innerHTML=ye,Ks=n(),r(_.$$.fragment),Rs=n(),C=l("p"),C.innerHTML=fe,Fs=n(),P=l("p"),P.innerHTML=qe,Ys=n(),r(L.$$.fragment),Os=n(),H=l("p"),H.innerHTML=be,st=n(),A=l("p"),A.textContent=we,tt=n(),E=l("p"),E.textContent=Me,et=n(),r(S.$$.fragment),at=n(),B=l("p"),B.innerHTML=je,nt=n(),r(D.$$.fragment),ot=n(),r(N.$$.fragment),lt=n(),W=l("p"),W.innerHTML=ve,it=n(),Z=l("p"),Z.innerHTML=Te,pt=n(),r(G.$$.fragment),rt=n(),V=l("p"),V.innerHTML=Je,ut=n(),Q=l("p"),Q.innerHTML=ke,ct=n(),r(X.$$.fragment),mt=n(),K=l("p"),K.innerHTML=$e,ht=n(),R=l("p"),R.textContent=xe,dt=n(),xs=l("a"),gt=n(),r(F.$$.fragment),yt=n(),Y=l("p"),Y.innerHTML=ze,ft=n(),O=l("p"),O.textContent=Ie,qt=n(),ss=l("p"),ss.textContent=Ue,bt=n(),r(ts.$$.fragment),wt=n(),es=l("p"),es.innerHTML=_e,Mt=n(),r(as.$$.fragment),jt=n(),ns=l("p"),ns.innerHTML=Ce,vt=n(),r(os.$$.fragment),Tt=n(),ls=l("p"),ls.innerHTML=Pe,Jt=n(),is=l("p"),is.innerHTML=Le,kt=n(),r(ps.$$.fragment),$t=n(),rs=l("p"),rs.innerHTML=He,xt=n(),us=l("p"),us.innerHTML=Ae,zt=n(),r(cs.$$.fragment),It=n(),ms=l("p"),ms.innerHTML=Ee,Ut=n(),zs=l("a"),_t=n(),r(hs.$$.fragment),Ct=n(),ds=l("p"),ds.innerHTML=Se,Pt=n(),gs=l("p"),gs.innerHTML=Be,Lt=n(),Is=l("a"),Ht=n(),r(ys.$$.fragment),At=n(),fs=l("p"),fs.innerHTML=De,Et=n(),qs=l("p"),qs.innerHTML=Ne,St=n(),bs=l("p"),bs.textContent=We,Bt=n(),r(ws.$$.fragment),Dt=n(),Ms=l("p"),Ms.innerHTML=Ze,Nt=n(),g=l("p"),re=ne(`Those probabilities are defined by the loss the tokenizer is trained on. Assuming that the training data consists of
the words`),Wt=new oe(!1),Zt=ne(" and that the set of all possible tokenizations for a word"),Gt=new oe(!1),Vt=ne(` is
defined as`),Qt=new oe(!1),Xt=ne(`, then the overall loss is defined as
`),Kt=new oe(!1),Rt=n(),Us=l("a"),Ft=n(),r(js.$$.fragment),Yt=n(),vs=l("p"),vs.innerHTML=Ge,Ot=n(),Ts=l("p"),Ts.innerHTML=Ve,se=n(),Js=l("p"),Js.innerHTML=Qe,te=n(),r(ks.$$.fragment),ee=n(),Ps=l("p"),this.h()},l(s){const t=aa("svelte-u9bgzb",document.head);f=i(t,"META",{name:!0,content:!0}),t.forEach(e),Hs=o(s),Cs=i(s,"P",{}),$s(Cs).forEach(e),As=o(s),u(w.$$.fragment,s),Es=o(s),u(M.$$.fragment,s),Ss=o(s),j=i(s,"P",{"data-svelte-h":!0}),p(j)!=="svelte-1h07nug"&&(j.textContent=ce),Bs=o(s),u(v.$$.fragment,s),Ds=o(s),T=i(s,"P",{"data-svelte-h":!0}),p(T)!=="svelte-ej4gda"&&(T.innerHTML=me),Ns=o(s),J=i(s,"P",{"data-svelte-h":!0}),p(J)!=="svelte-431i6y"&&(J.innerHTML=he),Ws=o(s),u(k.$$.fragment,s),Zs=o(s),$=i(s,"P",{"data-svelte-h":!0}),p($)!=="svelte-67zbo9"&&($.innerHTML=de),Gs=o(s),u(x.$$.fragment,s),Vs=o(s),z=i(s,"P",{"data-svelte-h":!0}),p(z)!=="svelte-s5zdmn"&&(z.textContent=ge),Qs=o(s),u(I.$$.fragment,s),Xs=o(s),U=i(s,"P",{"data-svelte-h":!0}),p(U)!=="svelte-14s15gf"&&(U.innerHTML=ye),Ks=o(s),u(_.$$.fragment,s),Rs=o(s),C=i(s,"P",{"data-svelte-h":!0}),p(C)!=="svelte-j1dyaf"&&(C.innerHTML=fe),Fs=o(s),P=i(s,"P",{"data-svelte-h":!0}),p(P)!=="svelte-11fbadg"&&(P.innerHTML=qe),Ys=o(s),u(L.$$.fragment,s),Os=o(s),H=i(s,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1qdsuer"&&(H.innerHTML=be),st=o(s),A=i(s,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1fz5yn1"&&(A.textContent=we),tt=o(s),E=i(s,"P",{"data-svelte-h":!0}),p(E)!=="svelte-16itca4"&&(E.textContent=Me),et=o(s),u(S.$$.fragment,s),at=o(s),B=i(s,"P",{"data-svelte-h":!0}),p(B)!=="svelte-jqh0qv"&&(B.innerHTML=je),nt=o(s),u(D.$$.fragment,s),ot=o(s),u(N.$$.fragment,s),lt=o(s),W=i(s,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1e53ypn"&&(W.innerHTML=ve),it=o(s),Z=i(s,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-eg01k3"&&(Z.innerHTML=Te),pt=o(s),u(G.$$.fragment,s),rt=o(s),V=i(s,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1mzno7"&&(V.innerHTML=Je),ut=o(s),Q=i(s,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-wh2yjd"&&(Q.innerHTML=ke),ct=o(s),u(X.$$.fragment,s),mt=o(s),K=i(s,"P",{"data-svelte-h":!0}),p(K)!=="svelte-uhdxhc"&&(K.innerHTML=$e),ht=o(s),R=i(s,"P",{"data-svelte-h":!0}),p(R)!=="svelte-129rtng"&&(R.textContent=xe),dt=o(s),xs=i(s,"A",{id:!0}),$s(xs).forEach(e),gt=o(s),u(F.$$.fragment,s),yt=o(s),Y=i(s,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-18ue2i4"&&(Y.innerHTML=ze),ft=o(s),O=i(s,"P",{"data-svelte-h":!0}),p(O)!=="svelte-jfl55u"&&(O.textContent=Ie),qt=o(s),ss=i(s,"P",{"data-svelte-h":!0}),p(ss)!=="svelte-14qop42"&&(ss.textContent=Ue),bt=o(s),u(ts.$$.fragment,s),wt=o(s),es=i(s,"P",{"data-svelte-h":!0}),p(es)!=="svelte-dnl63x"&&(es.innerHTML=_e),Mt=o(s),u(as.$$.fragment,s),jt=o(s),ns=i(s,"P",{"data-svelte-h":!0}),p(ns)!=="svelte-1ldwndq"&&(ns.innerHTML=Ce),vt=o(s),u(os.$$.fragment,s),Tt=o(s),ls=i(s,"P",{"data-svelte-h":!0}),p(ls)!=="svelte-1tbuzqr"&&(ls.innerHTML=Pe),Jt=o(s),is=i(s,"P",{"data-svelte-h":!0}),p(is)!=="svelte-ldb2oy"&&(is.innerHTML=Le),kt=o(s),u(ps.$$.fragment,s),$t=o(s),rs=i(s,"P",{"data-svelte-h":!0}),p(rs)!=="svelte-1y8lhzz"&&(rs.innerHTML=He),xt=o(s),us=i(s,"P",{"data-svelte-h":!0}),p(us)!=="svelte-1jzokj6"&&(us.innerHTML=Ae),zt=o(s),u(cs.$$.fragment,s),It=o(s),ms=i(s,"P",{"data-svelte-h":!0}),p(ms)!=="svelte-1nngf6"&&(ms.innerHTML=Ee),Ut=o(s),zs=i(s,"A",{id:!0}),$s(zs).forEach(e),_t=o(s),u(hs.$$.fragment,s),Ct=o(s),ds=i(s,"P",{"data-svelte-h":!0}),p(ds)!=="svelte-bqacvb"&&(ds.innerHTML=Se),Pt=o(s),gs=i(s,"P",{"data-svelte-h":!0}),p(gs)!=="svelte-q7cyms"&&(gs.innerHTML=Be),Lt=o(s),Is=i(s,"A",{id:!0}),$s(Is).forEach(e),Ht=o(s),u(ys.$$.fragment,s),At=o(s),fs=i(s,"P",{"data-svelte-h":!0}),p(fs)!=="svelte-uuczu6"&&(fs.innerHTML=De),Et=o(s),qs=i(s,"P",{"data-svelte-h":!0}),p(qs)!=="svelte-29pdu2"&&(qs.innerHTML=Ne),St=o(s),bs=i(s,"P",{"data-svelte-h":!0}),p(bs)!=="svelte-8otjbx"&&(bs.textContent=We),Bt=o(s),u(ws.$$.fragment,s),Dt=o(s),Ms=i(s,"P",{"data-svelte-h":!0}),p(Ms)!=="svelte-1rs0qcq"&&(Ms.innerHTML=Ze),Nt=o(s),g=i(s,"P",{});var q=$s(g);re=le(q,`Those probabilities are defined by the loss the tokenizer is trained on. Assuming that the training data consists of
the words`),Wt=ie(q,!1),Zt=le(q," and that the set of all possible tokenizations for a word"),Gt=ie(q,!1),Vt=le(q,` is
defined as`),Qt=ie(q,!1),Xt=le(q,`, then the overall loss is defined as
`),Kt=ie(q,!1),q.forEach(e),Rt=o(s),Us=i(s,"A",{id:!0}),$s(Us).forEach(e),Ft=o(s),u(js.$$.fragment,s),Yt=o(s),vs=i(s,"P",{"data-svelte-h":!0}),p(vs)!=="svelte-1jarhel"&&(vs.innerHTML=Ge),Ot=o(s),Ts=i(s,"P",{"data-svelte-h":!0}),p(Ts)!=="svelte-10lwbfo"&&(Ts.innerHTML=Ve),se=o(s),Js=i(s,"P",{"data-svelte-h":!0}),p(Js)!=="svelte-tl8004"&&(Js.innerHTML=Qe),te=o(s),u(ks.$$.fragment,s),ee=o(s),Ps=i(s,"P",{}),$s(Ps).forEach(e),this.h()},h(){_s(f,"name","hf:doc:metadata"),_s(f,"content",ia),_s(xs,"id","byte-pair-encoding"),_s(zs,"id","wordpiece"),_s(Is,"id","unigram"),Wt.a=Zt,Gt.a=Vt,Qt.a=Xt,Kt.a=null,_s(Us,"id","sentencepiece")},m(s,t){Ls(document.head,f),a(s,Hs,t),a(s,Cs,t),a(s,As,t),c(w,s,t),a(s,Es,t),c(M,s,t),a(s,Ss,t),a(s,j,t),a(s,Bs,t),c(v,s,t),a(s,Ds,t),a(s,T,t),a(s,Ns,t),a(s,J,t),a(s,Ws,t),c(k,s,t),a(s,Zs,t),a(s,$,t),a(s,Gs,t),c(x,s,t),a(s,Vs,t),a(s,z,t),a(s,Qs,t),c(I,s,t),a(s,Xs,t),a(s,U,t),a(s,Ks,t),c(_,s,t),a(s,Rs,t),a(s,C,t),a(s,Fs,t),a(s,P,t),a(s,Ys,t),c(L,s,t),a(s,Os,t),a(s,H,t),a(s,st,t),a(s,A,t),a(s,tt,t),a(s,E,t),a(s,et,t),c(S,s,t),a(s,at,t),a(s,B,t),a(s,nt,t),c(D,s,t),a(s,ot,t),c(N,s,t),a(s,lt,t),a(s,W,t),a(s,it,t),a(s,Z,t),a(s,pt,t),c(G,s,t),a(s,rt,t),a(s,V,t),a(s,ut,t),a(s,Q,t),a(s,ct,t),c(X,s,t),a(s,mt,t),a(s,K,t),a(s,ht,t),a(s,R,t),a(s,dt,t),a(s,xs,t),a(s,gt,t),c(F,s,t),a(s,yt,t),a(s,Y,t),a(s,ft,t),a(s,O,t),a(s,qt,t),a(s,ss,t),a(s,bt,t),c(ts,s,t),a(s,wt,t),a(s,es,t),a(s,Mt,t),c(as,s,t),a(s,jt,t),a(s,ns,t),a(s,vt,t),c(os,s,t),a(s,Tt,t),a(s,ls,t),a(s,Jt,t),a(s,is,t),a(s,kt,t),c(ps,s,t),a(s,$t,t),a(s,rs,t),a(s,xt,t),a(s,us,t),a(s,zt,t),c(cs,s,t),a(s,It,t),a(s,ms,t),a(s,Ut,t),a(s,zs,t),a(s,_t,t),c(hs,s,t),a(s,Ct,t),a(s,ds,t),a(s,Pt,t),a(s,gs,t),a(s,Lt,t),a(s,Is,t),a(s,Ht,t),c(ys,s,t),a(s,At,t),a(s,fs,t),a(s,Et,t),a(s,qs,t),a(s,St,t),a(s,bs,t),a(s,Bt,t),c(ws,s,t),a(s,Dt,t),a(s,Ms,t),a(s,Nt,t),a(s,g,t),Ls(g,re),Wt.m(Xe,g),Ls(g,Zt),Gt.m(Ke,g),Ls(g,Vt),Qt.m(Re,g),Ls(g,Xt),Kt.m(Fe,g),a(s,Rt,t),a(s,Us,t),a(s,Ft,t),c(js,s,t),a(s,Yt,t),a(s,vs,t),a(s,Ot,t),a(s,Ts,t),a(s,se,t),a(s,Js,t),a(s,te,t),c(ks,s,t),a(s,ee,t),a(s,Ps,t),ae=!0},p:Oe,i(s){ae||(m(w.$$.fragment,s),m(M.$$.fragment,s),m(v.$$.fragment,s),m(k.$$.fragment,s),m(x.$$.fragment,s),m(I.$$.fragment,s),m(_.$$.fragment,s),m(L.$$.fragment,s),m(S.$$.fragment,s),m(D.$$.fragment,s),m(N.$$.fragment,s),m(G.$$.fragment,s),m(X.$$.fragment,s),m(F.$$.fragment,s),m(ts.$$.fragment,s),m(as.$$.fragment,s),m(os.$$.fragment,s),m(ps.$$.fragment,s),m(cs.$$.fragment,s),m(hs.$$.fragment,s),m(ys.$$.fragment,s),m(ws.$$.fragment,s),m(js.$$.fragment,s),m(ks.$$.fragment,s),ae=!0)},o(s){h(w.$$.fragment,s),h(M.$$.fragment,s),h(v.$$.fragment,s),h(k.$$.fragment,s),h(x.$$.fragment,s),h(I.$$.fragment,s),h(_.$$.fragment,s),h(L.$$.fragment,s),h(S.$$.fragment,s),h(D.$$.fragment,s),h(N.$$.fragment,s),h(G.$$.fragment,s),h(X.$$.fragment,s),h(F.$$.fragment,s),h(ts.$$.fragment,s),h(as.$$.fragment,s),h(os.$$.fragment,s),h(ps.$$.fragment,s),h(cs.$$.fragment,s),h(hs.$$.fragment,s),h(ys.$$.fragment,s),h(ws.$$.fragment,s),h(js.$$.fragment,s),h(ks.$$.fragment,s),ae=!1},d(s){s&&(e(Hs),e(Cs),e(As),e(Es),e(Ss),e(j),e(Bs),e(Ds),e(T),e(Ns),e(J),e(Ws),e(Zs),e($),e(Gs),e(Vs),e(z),e(Qs),e(Xs),e(U),e(Ks),e(Rs),e(C),e(Fs),e(P),e(Ys),e(Os),e(H),e(st),e(A),e(tt),e(E),e(et),e(at),e(B),e(nt),e(ot),e(lt),e(W),e(it),e(Z),e(pt),e(rt),e(V),e(ut),e(Q),e(ct),e(mt),e(K),e(ht),e(R),e(dt),e(xs),e(gt),e(yt),e(Y),e(ft),e(O),e(qt),e(ss),e(bt),e(wt),e(es),e(Mt),e(jt),e(ns),e(vt),e(Tt),e(ls),e(Jt),e(is),e(kt),e($t),e(rs),e(xt),e(us),e(zt),e(It),e(ms),e(Ut),e(zs),e(_t),e(Ct),e(ds),e(Pt),e(gs),e(Lt),e(Is),e(Ht),e(At),e(fs),e(Et),e(qs),e(St),e(bs),e(Bt),e(Dt),e(Ms),e(Nt),e(g),e(Rt),e(Us),e(Ft),e(Yt),e(vs),e(Ot),e(Ts),e(se),e(Js),e(te),e(ee),e(Ps)),e(f),d(w,s),d(M,s),d(v,s),d(k,s),d(x,s),d(I,s),d(_,s),d(L,s),d(S,s),d(D,s),d(N,s),d(G,s),d(X,s),d(F,s),d(ts,s),d(as,s),d(os,s),d(ps,s),d(cs,s),d(hs,s),d(ys,s),d(ws,s),d(js,s),d(ks,s)}}}const ia='{"title":"Summary of the tokenizers","local":"summary-of-the-tokenizers","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"Subword tokenization","local":"subword-tokenization","sections":[{"title":"Byte-Pair Encoding (BPE)","local":"byte-pair-encoding-bpe","sections":[{"title":"Byte-level BPE","local":"byte-level-bpe","sections":[],"depth":4}],"depth":3},{"title":"WordPiece","local":"wordpiece","sections":[],"depth":3},{"title":"Unigram","local":"unigram","sections":[],"depth":3},{"title":"SentencePiece","local":"sentencepiece","sections":[],"depth":3}],"depth":2}],"depth":1}';function pa(ue){return sa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ya extends ta{constructor(f){super(),ea(this,f,pa,la,Ye,{})}}export{ya as component};
