import{s as vt,o as kt,n as Pe}from"../chunks/scheduler.18a86fab.js";import{S as wt,i as $t,g as l,s as a,r as c,A as Bt,h as d,f as n,c as r,j as de,u as m,x as M,k as ce,y as g,a as o,v as p,d as u,t as h,w as f}from"../chunks/index.98837b22.js";import{T as Mt}from"../chunks/Tip.77304350.js";import{D as ye}from"../chunks/Docstring.6758ea23.js";import{C as He}from"../chunks/CodeBlock.8d0c2e8a.js";import{E as Tt}from"../chunks/ExampleCodeBlock.0c42463f.js";import{H as U}from"../chunks/Heading.7e7e0c5b.js";import{E as Nt}from"../chunks/index.499f366c.js";function Ct(C){let s,b;return s=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJpdE5ldE1vZGVsJTJDJTIwQml0TmV0Q29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMEJpdE5ldCUyMHN0eWxlJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBCaXROZXRDb25maWcoKSUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBtb2RlbCUyMGZyb20lMjB0aGUlMjBCaXROZXQlMjBzdHlsZSUyMGNvbmZpZ3VyYXRpb24lMEFtb2RlbCUyMCUzRCUyMEJpdE5ldE1vZGVsKGNvbmZpZ3VyYXRpb24pJTBBJTBBJTIzJTIwQWNjZXNzaW5nJTIwdGhlJTIwbW9kZWwlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMG1vZGVsLmNvbmZpZw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitNetModel, BitNetConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a BitNet style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = BitNetConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the BitNet style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitNetModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){c(s.$$.fragment)},l(i){m(s.$$.fragment,i)},m(i,y){p(s,i,y),b=!0},p:Pe,i(i){b||(u(s.$$.fragment,i),b=!0)},o(i){h(s.$$.fragment,i),b=!1},d(i){f(s,i)}}}function zt(C){let s,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=b},l(i){s=d(i,"P",{"data-svelte-h":!0}),M(s)!=="svelte-fincs2"&&(s.innerHTML=b)},m(i,y){o(i,s,y)},p:Pe,d(i){i&&n(s)}}}function Ut(C){let s,b=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){s=l("p"),s.innerHTML=b},l(i){s=d(i,"P",{"data-svelte-h":!0}),M(s)!=="svelte-fincs2"&&(s.innerHTML=b)},m(i,y){o(i,s,y)},p:Pe,d(i){i&&n(s)}}}function xt(C){let s,b="Example:",i,y,w;return y=new He({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBCaXROZXRGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQml0TmV0Rm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pY3Jvc29mdCUyRmJpdG5ldC1iMS41OC0yQi00VCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJtaWNyb3NvZnQlMkZiaXRuZXQtYjEuNTgtMkItNFQlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwZiclM0MlN0NiZWdpbl9vZl90ZXh0JTdDJTNFVXNlciUzQSUyMEhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTNDJTdDZW90X2lkJTdDJTNFQXNzaXN0YW50JTNBJTIwJyUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QxMDApJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZV9pZHMlMkMlMjBza2lwX3NwZWNpYWxfdG9rZW5zJTNEVHJ1ZSUyQyUyMGNsZWFuX3VwX3Rva2VuaXphdGlvbl9zcGFjZXMlM0RGYWxzZSklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, BitNetForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = BitNetForCausalLM.from_pretrained(<span class="hljs-string">&quot;microsoft/bitnet-b1.58-2B-4T&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;microsoft/bitnet-b1.58-2B-4T&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">f&#x27;&lt;|begin_of_text|&gt;User: Hey, are you conscious? Can you talk to me?&lt;|eot_id|&gt;Assistant: &#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">100</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;User: Hey, are you conscious? Can you talk to me?Assistant: No, I&#x27;m not conscious. I&#x27;m an artificial intelligence designed to assist with information and tasks. How can I help you today?&quot;</span>`,wrap:!1}}),{c(){s=l("p"),s.textContent=b,i=a(),c(y.$$.fragment)},l(_){s=d(_,"P",{"data-svelte-h":!0}),M(s)!=="svelte-11lpom8"&&(s.textContent=b),i=r(_),m(y.$$.fragment,_)},m(_,B){o(_,s,B),o(_,i,B),p(y,_,B),w=!0},p:Pe,i(_){w||(u(y.$$.fragment,_),w=!0)},o(_){h(y.$$.fragment,_),w=!1},d(_){_&&(n(s),n(i)),f(y,_)}}}function jt(C){let s,b,i,y,w,_,B,Me,W,at="Trained on a corpus of 4 trillion tokens, this model demonstrates that native 1-bit LLMs can achieve performance comparable to leading open-weight, full-precision models of similar size, while offering substantial advantages in computational efficiency (memory, energy, latency).",Te,q,rt='➡️ <strong>Technical Report:</strong> <a href="https://arxiv.org/abs/2504.12285" rel="nofollow">BitNet b1.58 2B4T Technical Report</a>',ve,G,it='➡️ <strong>Official Inference Code:</strong> <a href="https://github.com/microsoft/BitNet" rel="nofollow">microsoft/BitNet (bitnet.cpp)</a>',ke,E,we,R,lt="Several versions of the model weights are available on Hugging Face:",$e,X,dt='<li><p><a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T" rel="nofollow"><strong><code>microsoft/bitnet-b1.58-2B-4T</code></strong></a>: Contains the packed 1.58-bit weights optimized for efficient inference. <strong>Use this for deployment.</strong></p></li> <li><p><a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T-bf16" rel="nofollow"><strong><code>microsoft/bitnet-b1.58-2B-4T-bf16</code></strong></a>: Contains the master weights in BF16 format. <strong>Use this only for training or fine-tuning purposes.</strong></p></li> <li><p><a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T-gguf" rel="nofollow"><strong><code>microsoft/bitnet-b1.58-2B-4T-gguf</code></strong></a>: Contains the model weights in GGUF format, compatible with the <code>bitnet.cpp</code> library for CPU inference.</p></li>',Be,H,Ne,P,ct='<li><strong>Architecture:</strong> Transformer-based, modified with <code>BitLinear</code> layers (BitNet framework).<ul><li>Uses Rotary Position Embeddings (RoPE).</li> <li>Uses squared ReLU (ReLU²) activation in FFN layers.</li> <li>Employs <a href="https://proceedings.mlr.press/v202/wang23u.html" rel="nofollow"><code>subln</code></a> normalization.</li> <li>No bias terms in linear or normalization layers.</li></ul></li> <li><strong>Quantization:</strong> Native 1.58-bit weights and 8-bit activations (W1.58A8).<ul><li>Weights are quantized to ternary values {-1, 0, +1} using absmean quantization during the forward pass.</li> <li>Activations are quantized to 8-bit integers using absmax quantization (per-token).</li> <li><strong>Crucially, the model was <em>trained from scratch</em> with this quantization scheme, not post-training quantized.</strong></li></ul></li> <li><strong>Parameters:</strong> ~2 Billion</li> <li><strong>Training Tokens:</strong> 4 Trillion</li> <li><strong>Context Length:</strong> Maximum sequence length of <strong>4096 tokens</strong>.<ul><li><em>Recommendation:</em> For optimal performance on tasks requiring very long contexts (beyond the pre-training length or for specialized long-reasoning tasks), we recommend performing intermediate long-sequence adaptation/training before the final fine-tuning stage.</li></ul></li> <li><strong>Training Stages:</strong><ol><li><strong>Pre-training:</strong> Large-scale training on public text/code and synthetic math data using a two-stage learning rate and weight decay schedule.</li> <li><strong>Supervised Fine-tuning (SFT):</strong> Fine-tuned on instruction-following and conversational datasets using sum loss aggregation and specific hyperparameter tuning.</li> <li><strong>Direct Preference Optimization (DPO):</strong> Aligned with human preferences using preference pairs.</li></ol></li> <li><strong>Tokenizer:</strong> LLaMA 3 Tokenizer (vocab size: 128,256).</li>',Ce,V,ze,Q,mt="<strong>VERY IMPORTANT NOTE ON EFFICIENCY</strong>",Ue,A,pt='<p>Please do NOT expect performance efficiency gains (in terms of speed, latency, or energy consumption) when using this model with the standard transformers library.</p> <p>The current execution paths within transformers do not contain the specialized, highly optimized computational kernels required to leverage the advantages of the BitNet architecture. Running the model via transformers will likely result in inference speeds and energy usage comparable to, or potentially worse than, standard full-precision models within this framework on both CPU and GPU.</p> <p>While you might observe reduced memory usage due to the quantized weights, the primary computational efficiency benefits are not accessible through this standard transformers usage path.</p> <p>For achieving the efficiency benefits demonstrated in the technical paper, you MUST use the dedicated C++ implementation: <a href="https://github.com/microsoft/BitNet" rel="nofollow">bitnet.cpp</a>.</p>',xe,S,je,O,Je,Y,Ie,D,Fe,K,Le,v,ee,Ve,me,ut=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetModel">BitNetModel</a>. It is used to instantiate an BitNet
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of
BitNet b1.58 2B4T <a href="https://huggingface.co/microsoft/bitnet-b1.58-2B-4T" rel="nofollow">microsoft/bitnet-b1.58-2B-4T</a>.`,Qe,pe,ht=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Ae,J,Ze,te,We,T,ne,Se,ue,ft=`The bare BitNet Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Oe,he,gt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ye,fe,_t="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>BitNetDecoderLayer</code>",De,z,oe,Ke,ge,bt='The <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetModel">BitNetModel</a> forward method, overrides the <code>__call__</code> special method.',et,I,qe,se,Ge,x,ae,tt,$,re,nt,_e,yt='The <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetForCausalLM">BitNetForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ot,F,st,L,Ee,ie,Re,be,Xe;return w=new U({props:{title:"BitNet",local:"bitnet",headingTag:"h1"}}),B=new U({props:{title:"Overview",local:"overview",headingTag:"h2"}}),E=new U({props:{title:"Model Variants",local:"model-variants",headingTag:"h2"}}),H=new U({props:{title:"Model Details",local:"model-details",headingTag:"h3"}}),V=new U({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),S=new U({props:{title:"Requirements",local:"requirements",headingTag:"h3"}}),O=new He({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycw==",highlighted:"pip install transformers",wrap:!1}}),Y=new U({props:{title:"Example",local:"example",headingTag:"h3"}}),D=new He({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJtaWNyb3NvZnQlMkZiaXRuZXQtYjEuNTgtMkItNFQlMjIlMEElMEElMjMlMjBMb2FkJTIwdG9rZW5pemVyJTIwYW5kJTIwbW9kZWwlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBJTBBJTIzJTIwQXBwbHklMjB0aGUlMjBjaGF0JTIwdGVtcGxhdGUlMEFtZXNzYWdlcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBBSSUyMGFzc2lzdGFudC4lMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiUyQyUyMCUyMmNvbnRlbnQlMjIlM0ElMjAlMjJIb3clMjBhcmUlMjB5b3UlM0YlMjIlN0QlMkMlMEElNUQlMEFjaGF0X2lucHV0JTIwJTNEJTIwdG9rZW5pemVyLmFwcGx5X2NoYXRfdGVtcGxhdGUobWVzc2FnZXMlMkMlMjB0b2tlbml6ZSUzRFRydWUlMkMlMjBhZGRfZ2VuZXJhdGlvbl9wcm9tcHQlM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8obW9kZWwuZGV2aWNlKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTIwcmVzcG9uc2UlMEFjaGF0X291dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZShjaGF0X2lucHV0JTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFyZXNwb25zZSUyMCUzRCUyMHRva2VuaXplci5kZWNvZGUoY2hhdF9vdXRwdXRzJTVCMCU1RCU1QmNoYXRfaW5wdXQuc2hhcGUlNUItMSU1RCUzQSU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMCUyMyUyMERlY29kZSUyMG9ubHklMjB0aGUlMjByZXNwb25zZSUyMHBhcnQlMEFwcmludCglMjIlNUNuQXNzaXN0YW50JTIwUmVzcG9uc2UlM0ElMjIlMkMlMjByZXNwb25zZSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

model_id = <span class="hljs-string">&quot;microsoft/bitnet-b1.58-2B-4T&quot;</span>

<span class="hljs-comment"># Load tokenizer and model</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(
    model_id,
    torch_dtype=torch.bfloat16
)

<span class="hljs-comment"># Apply the chat template</span>
messages = [
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You are a helpful AI assistant.&quot;</span>},
    {<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;How are you?&quot;</span>},
]
chat_input = tokenizer.apply_chat_template(messages, tokenize=<span class="hljs-literal">True</span>, add_generation_prompt=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Generate response</span>
chat_outputs = model.generate(chat_input, max_new_tokens=<span class="hljs-number">50</span>)
response = tokenizer.decode(chat_outputs[<span class="hljs-number">0</span>][chat_input.shape[-<span class="hljs-number">1</span>]:], skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-comment"># Decode only the response part</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nAssistant Response:&quot;</span>, response)`,wrap:!1}}),K=new U({props:{title:"BitNetConfig",local:"transformers.BitNetConfig",headingTag:"h2"}}),ee=new ye({props:{name:"class transformers.BitNetConfig",anchor:"transformers.BitNetConfig",parameters:[{name:"vocab_size",val:" = 128256"},{name:"hidden_size",val:" = 2560"},{name:"intermediate_size",val:" = 6912"},{name:"num_hidden_layers",val:" = 30"},{name:"num_attention_heads",val:" = 20"},{name:"num_key_value_heads",val:" = 5"},{name:"hidden_act",val:" = 'relu2'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"rms_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"pad_token_id",val:" = None"},{name:"bos_token_id",val:" = 128000"},{name:"eos_token_id",val:" = 128001"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 500000.0"},{name:"attention_bias",val:" = False"},{name:"attention_dropout",val:" = 0.0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.BitNetConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 128256) &#x2014;
Vocabulary size of the BitNet model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetModel">BitNetModel</a>`,name:"vocab_size"},{anchor:"transformers.BitNetConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2560) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.BitNetConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 6912) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.BitNetConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 30) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.BitNetConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 20) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.BitNetConfig.num_key_value_heads",description:`<strong>num_key_value_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 5) &#x2014;
This is the number of key_value heads that should be used to implement Grouped Query Attention. If
<code>num_key_value_heads=num_attention_heads</code>, the model will use Multi Head Attention (MHA), if
<code>num_key_value_heads=1 the model will use Multi Query Attention (MQA) otherwise GQA is used. When converting a multi-head checkpoint to a GQA checkpoint, each group key and value head should be constructed by meanpooling all the original heads within that group. For more details checkout [this paper](https://arxiv.org/pdf/2305.13245.pdf). If it is not specified, will default to </code>num_attention_heads\`.`,name:"num_key_value_heads"},{anchor:"transformers.BitNetConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;relu2&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.BitNetConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with.`,name:"max_position_embeddings"},{anchor:"transformers.BitNetConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.BitNetConfig.rms_norm_eps",description:`<strong>rms_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"rms_norm_eps"},{anchor:"transformers.BitNetConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>.`,name:"use_cache"},{anchor:"transformers.BitNetConfig.pad_token_id",description:`<strong>pad_token_id</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Padding token id.`,name:"pad_token_id"},{anchor:"transformers.BitNetConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 128000) &#x2014;
Beginning of stream token id.`,name:"bos_token_id"},{anchor:"transformers.BitNetConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 128001) &#x2014;
End of stream token id.`,name:"eos_token_id"},{anchor:"transformers.BitNetConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.BitNetConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 500000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.BitNetConfig.attention_bias",description:`<strong>attention_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a bias in the query, key, value and output projection layers during self-attention.`,name:"attention_bias"},{anchor:"transformers.BitNetConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_dropout"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/configuration_bitnet.py#L23"}}),J=new Tt({props:{anchor:"transformers.BitNetConfig.example",$$slots:{default:[Ct]},$$scope:{ctx:C}}}),te=new U({props:{title:"BitNetModel",local:"transformers.BitNetModel",headingTag:"h2"}}),ne=new ye({props:{name:"class transformers.BitNetModel",anchor:"transformers.BitNetModel",parameters:[{name:"config",val:": BitNetConfig"}],parametersDescription:[{anchor:"transformers.BitNetModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetConfig">BitNetConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.BitNetModel.config",description:"<strong>config</strong> &#x2014; BitNetConfig",name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L454"}}),oe=new ye({props:{name:"forward",anchor:"transformers.BitNetModel.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"**flash_attn_kwargs",val:": typing_extensions.Unpack[transformers.modeling_flash_attention_utils.FlashAttentionKwargs]"}],parametersDescription:[{anchor:"transformers.BitNetModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BitNetModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length) or </code>BlockMask<code>, *optional*) -- Mask to avoid performing attention on padding token indices. Mask values selected in </code>[0, 1]\`:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p>If the model is configured to use flex_attention, it will attempt to convert the mask Tensor into a BlockMask,
but you can also pass a <code>BlockMask</code> object directly here.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.BitNetModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.BitNetModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>It is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance. For more details, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BitNetModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BitNetModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BitNetModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BitNetModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BitNetModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BitNetModel.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L488"}}),I=new Mt({props:{$$slots:{default:[zt]},$$scope:{ctx:C}}}),se=new U({props:{title:"BitNetForCausalLM",local:"transformers.BitNetForCausalLM",headingTag:"h2"}}),ae=new ye({props:{name:"class transformers.BitNetForCausalLM",anchor:"transformers.BitNetForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L711"}}),re=new ye({props:{name:"forward",anchor:"transformers.BitNetForCausalLM.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[transformers.cache_utils.Cache] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.bitnet.modeling_bitnet.KwargsForCausalLM]"}],parametersDescription:[{anchor:"transformers.BitNetForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.BitNetForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length) or </code>BlockMask<code>, *optional*) -- Mask to avoid performing attention on padding token indices. Mask values selected in </code>[0, 1]\`:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p>If the model is configured to use flex_attention, it will attempt to convert the mask Tensor into a BlockMask,
but you can also pass a <code>BlockMask</code> object directly here.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.BitNetForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.BitNetForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>It is a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance. For more details, see our <a href="https://huggingface.co/docs/transformers/en/kv_cache" rel="nofollow">kv cache guide</a>.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.BitNetForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.BitNetForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.BitNetForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.BitNetForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.BitNetForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.BitNetForCausalLM.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.BitNetForCausalLM.forward.Args",description:`<strong>Args</strong> &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, transformers., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, transformers., config.vocab_size]</code>.`,name:"Args"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/bitnet/modeling_bitnet.py#L743",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/bitnet#transformers.BitNetConfig"
>BitNetConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),F=new Mt({props:{$$slots:{default:[Ut]},$$scope:{ctx:C}}}),L=new Tt({props:{anchor:"transformers.BitNetForCausalLM.forward.example",$$slots:{default:[xt]},$$scope:{ctx:C}}}),ie=new Nt({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/bitnet.md"}}),{c(){s=l("meta"),b=a(),i=l("p"),y=a(),c(w.$$.fragment),_=a(),c(B.$$.fragment),Me=a(),W=l("p"),W.textContent=at,Te=a(),q=l("p"),q.innerHTML=rt,ve=a(),G=l("p"),G.innerHTML=it,ke=a(),c(E.$$.fragment),we=a(),R=l("p"),R.textContent=lt,$e=a(),X=l("ul"),X.innerHTML=dt,Be=a(),c(H.$$.fragment),Ne=a(),P=l("ul"),P.innerHTML=ct,Ce=a(),c(V.$$.fragment),ze=a(),Q=l("p"),Q.innerHTML=mt,Ue=a(),A=l("blockquote"),A.innerHTML=pt,xe=a(),c(S.$$.fragment),je=a(),c(O.$$.fragment),Je=a(),c(Y.$$.fragment),Ie=a(),c(D.$$.fragment),Fe=a(),c(K.$$.fragment),Le=a(),v=l("div"),c(ee.$$.fragment),Ve=a(),me=l("p"),me.innerHTML=ut,Qe=a(),pe=l("p"),pe.innerHTML=ht,Ae=a(),c(J.$$.fragment),Ze=a(),c(te.$$.fragment),We=a(),T=l("div"),c(ne.$$.fragment),Se=a(),ue=l("p"),ue.innerHTML=ft,Oe=a(),he=l("p"),he.innerHTML=gt,Ye=a(),fe=l("p"),fe.innerHTML=_t,De=a(),z=l("div"),c(oe.$$.fragment),Ke=a(),ge=l("p"),ge.innerHTML=bt,et=a(),c(I.$$.fragment),qe=a(),c(se.$$.fragment),Ge=a(),x=l("div"),c(ae.$$.fragment),tt=a(),$=l("div"),c(re.$$.fragment),nt=a(),_e=l("p"),_e.innerHTML=yt,ot=a(),c(F.$$.fragment),st=a(),c(L.$$.fragment),Ee=a(),c(ie.$$.fragment),Re=a(),be=l("p"),this.h()},l(e){const t=Bt("svelte-u9bgzb",document.head);s=d(t,"META",{name:!0,content:!0}),t.forEach(n),b=r(e),i=d(e,"P",{}),de(i).forEach(n),y=r(e),m(w.$$.fragment,e),_=r(e),m(B.$$.fragment,e),Me=r(e),W=d(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1pmndzz"&&(W.textContent=at),Te=r(e),q=d(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-15tk2ma"&&(q.innerHTML=rt),ve=r(e),G=d(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-vdffu1"&&(G.innerHTML=it),ke=r(e),m(E.$$.fragment,e),we=r(e),R=d(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-qnf1r5"&&(R.textContent=lt),$e=r(e),X=d(e,"UL",{"data-svelte-h":!0}),M(X)!=="svelte-1nmw3am"&&(X.innerHTML=dt),Be=r(e),m(H.$$.fragment,e),Ne=r(e),P=d(e,"UL",{"data-svelte-h":!0}),M(P)!=="svelte-1lu6ouj"&&(P.innerHTML=ct),Ce=r(e),m(V.$$.fragment,e),ze=r(e),Q=d(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-17x01k1"&&(Q.innerHTML=mt),Ue=r(e),A=d(e,"BLOCKQUOTE",{"data-svelte-h":!0}),M(A)!=="svelte-1xhi4or"&&(A.innerHTML=pt),xe=r(e),m(S.$$.fragment,e),je=r(e),m(O.$$.fragment,e),Je=r(e),m(Y.$$.fragment,e),Ie=r(e),m(D.$$.fragment,e),Fe=r(e),m(K.$$.fragment,e),Le=r(e),v=d(e,"DIV",{class:!0});var N=de(v);m(ee.$$.fragment,N),Ve=r(N),me=d(N,"P",{"data-svelte-h":!0}),M(me)!=="svelte-162cit"&&(me.innerHTML=ut),Qe=r(N),pe=d(N,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-o55m63"&&(pe.innerHTML=ht),Ae=r(N),m(J.$$.fragment,N),N.forEach(n),Ze=r(e),m(te.$$.fragment,e),We=r(e),T=d(e,"DIV",{class:!0});var k=de(T);m(ne.$$.fragment,k),Se=r(k),ue=d(k,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1dxwlo"&&(ue.innerHTML=ft),Oe=r(k),he=d(k,"P",{"data-svelte-h":!0}),M(he)!=="svelte-hswkmf"&&(he.innerHTML=gt),Ye=r(k),fe=d(k,"P",{"data-svelte-h":!0}),M(fe)!=="svelte-10t48f5"&&(fe.innerHTML=_t),De=r(k),z=d(k,"DIV",{class:!0});var j=de(z);m(oe.$$.fragment,j),Ke=r(j),ge=d(j,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-lq298d"&&(ge.innerHTML=bt),et=r(j),m(I.$$.fragment,j),j.forEach(n),k.forEach(n),qe=r(e),m(se.$$.fragment,e),Ge=r(e),x=d(e,"DIV",{class:!0});var le=de(x);m(ae.$$.fragment,le),tt=r(le),$=d(le,"DIV",{class:!0});var Z=de($);m(re.$$.fragment,Z),nt=r(Z),_e=d(Z,"P",{"data-svelte-h":!0}),M(_e)!=="svelte-g8wwbd"&&(_e.innerHTML=yt),ot=r(Z),m(F.$$.fragment,Z),st=r(Z),m(L.$$.fragment,Z),Z.forEach(n),le.forEach(n),Ee=r(e),m(ie.$$.fragment,e),Re=r(e),be=d(e,"P",{}),de(be).forEach(n),this.h()},h(){ce(s,"name","hf:doc:metadata"),ce(s,"content",Jt),ce(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){g(document.head,s),o(e,b,t),o(e,i,t),o(e,y,t),p(w,e,t),o(e,_,t),p(B,e,t),o(e,Me,t),o(e,W,t),o(e,Te,t),o(e,q,t),o(e,ve,t),o(e,G,t),o(e,ke,t),p(E,e,t),o(e,we,t),o(e,R,t),o(e,$e,t),o(e,X,t),o(e,Be,t),p(H,e,t),o(e,Ne,t),o(e,P,t),o(e,Ce,t),p(V,e,t),o(e,ze,t),o(e,Q,t),o(e,Ue,t),o(e,A,t),o(e,xe,t),p(S,e,t),o(e,je,t),p(O,e,t),o(e,Je,t),p(Y,e,t),o(e,Ie,t),p(D,e,t),o(e,Fe,t),p(K,e,t),o(e,Le,t),o(e,v,t),p(ee,v,null),g(v,Ve),g(v,me),g(v,Qe),g(v,pe),g(v,Ae),p(J,v,null),o(e,Ze,t),p(te,e,t),o(e,We,t),o(e,T,t),p(ne,T,null),g(T,Se),g(T,ue),g(T,Oe),g(T,he),g(T,Ye),g(T,fe),g(T,De),g(T,z),p(oe,z,null),g(z,Ke),g(z,ge),g(z,et),p(I,z,null),o(e,qe,t),p(se,e,t),o(e,Ge,t),o(e,x,t),p(ae,x,null),g(x,tt),g(x,$),p(re,$,null),g($,nt),g($,_e),g($,ot),p(F,$,null),g($,st),p(L,$,null),o(e,Ee,t),p(ie,e,t),o(e,Re,t),o(e,be,t),Xe=!0},p(e,[t]){const N={};t&2&&(N.$$scope={dirty:t,ctx:e}),J.$set(N);const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),I.$set(k);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),F.$set(j);const le={};t&2&&(le.$$scope={dirty:t,ctx:e}),L.$set(le)},i(e){Xe||(u(w.$$.fragment,e),u(B.$$.fragment,e),u(E.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(S.$$.fragment,e),u(O.$$.fragment,e),u(Y.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(J.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(I.$$.fragment,e),u(se.$$.fragment,e),u(ae.$$.fragment,e),u(re.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(ie.$$.fragment,e),Xe=!0)},o(e){h(w.$$.fragment,e),h(B.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(V.$$.fragment,e),h(S.$$.fragment,e),h(O.$$.fragment,e),h(Y.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(J.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(I.$$.fragment,e),h(se.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(F.$$.fragment,e),h(L.$$.fragment,e),h(ie.$$.fragment,e),Xe=!1},d(e){e&&(n(b),n(i),n(y),n(_),n(Me),n(W),n(Te),n(q),n(ve),n(G),n(ke),n(we),n(R),n($e),n(X),n(Be),n(Ne),n(P),n(Ce),n(ze),n(Q),n(Ue),n(A),n(xe),n(je),n(Je),n(Ie),n(Fe),n(Le),n(v),n(Ze),n(We),n(T),n(qe),n(Ge),n(x),n(Ee),n(Re),n(be)),n(s),f(w,e),f(B,e),f(E,e),f(H,e),f(V,e),f(S,e),f(O,e),f(Y,e),f(D,e),f(K,e),f(ee),f(J),f(te,e),f(ne),f(oe),f(I),f(se,e),f(ae),f(re),f(F),f(L),f(ie,e)}}}const Jt='{"title":"BitNet","local":"bitnet","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Model Variants","local":"model-variants","sections":[{"title":"Model Details","local":"model-details","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Requirements","local":"requirements","sections":[],"depth":3},{"title":"Example","local":"example","sections":[],"depth":3}],"depth":2},{"title":"BitNetConfig","local":"transformers.BitNetConfig","sections":[],"depth":2},{"title":"BitNetModel","local":"transformers.BitNetModel","sections":[],"depth":2},{"title":"BitNetForCausalLM","local":"transformers.BitNetForCausalLM","sections":[],"depth":2}],"depth":1}';function It(C){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xt extends wt{constructor(s){super(),$t(this,s,It,jt,vt,{})}}export{Xt as component};
