import{s as Ss,f as Vs,o as Xs,n as Ys}from"../chunks/scheduler.36a0863c.js";import{S as Fs,i as Os,g as a,s as n,r as p,A as Ks,h as r,f as i,c as o,j as Gs,u as m,x as s,k as w,y as ep,a as l,v as u,d as c,t as d,w as M}from"../chunks/index.9c13489a.js";import{T as tp}from"../chunks/Tip.3b06990e.js";import{C as f}from"../chunks/CodeBlock.a6a4e7b6.js";import{H as v,E as ip}from"../chunks/index.cc7d508c.js";function lp(qi){let g,$="Nel caso siate su Windows, sostituite <code>RUN_SLOW=1</code> con <code>SET RUN_SLOW=1</code>";return{c(){g=a("p"),g.innerHTML=$},l(T){g=r(T,"P",{"data-svelte-h":!0}),s(g)!=="svelte-1gsy2xt"&&(g.innerHTML=$)},m(T,Wi){l(T,g,Wi)},p:Ys,d(T){T&&i(g)}}}function np(qi){let g,$,T,Wi,I,Ei,L,fa=`Aggiungere un nuovo modello é spesso difficile e richiede una profonda conoscenza della libreria 🤗 Transformers e anche
della repository originale del modello. A Hugging Face cerchiamo di dare alla community sempre piú poteri per aggiungere
modelli independentemente. Quindi, per alcuni nuovi modelli che la community vuole aggiungere a 🤗 Transformers, abbiamo
creato una specifica <em>call-for-model-addition</em> che spiega passo dopo passo come aggiungere il modello richiesto. Con
questo <em>call-for-model-addition</em> vogliamo insegnare a volenterosi e esperti collaboratori della community come implementare
un modello in 🤗 Transformers.`,Gi,z,ga=`Se questo é qualcosa che può interessarvi, siete liberi di controllare l’attuale “calls-for-model-addition” <a href="https://github.com/huggingface/transformers/tree/main/templates/adding_a_new_model/open_model_proposals/README.md" rel="nofollow">qui</a>
e contattarci.`,Si,k,Ta=`Se il modello sarà selezionato, allora potrete lavorare insieme a un membro di Hugging Face per integrare il modello in 🤗
Transformers. Così facendo, ci guadagnerai in una comprensione totale, sia teorica che pratica, del modello proposto. Inoltre,
sarai l’artefice di un importante contributo open-source a 🤗 Transformers. Durante l’implementazione avrai l’opportunità di:`,Vi,x,va="<li>ottenere più comprensione delle best practices in open-source</li> <li>capire i principi di design di una della librerie NLP più popolari</li> <li>capire come efficientemente testare complessi modelli NLP</li> <li>capire come integrare utilit Python come <code>black</code>, <code>ruff</code>, <code>make fix-copies</code> in una libreria per garantire sempre di avere un codice leggibile e pulito</li>",Xi,A,wa=`Siamo anche contenti se vuoi aggiungere un modello che non può essere trovato nella cartella “calls-for-model-addition”.
Le seguenti sezioni spiegano in dettaglio come aggiungere un nuovo modello. Può anche essere molto utile controllare modelli
già aggiunti <a href="https://github.com/huggingface/transformers/pulls?q=is%3Apr+label%3A%22PR+for+Model+Addition%22+is%3Aclosed" rel="nofollow">qui</a>,
per capire se richiamano il modello che vorreste aggiungere.`,Yi,H,ba="Per cominciare, vediamo una panoramica general della libreria Transformers.",Fi,N,Oi,P,ya=`Prima di tutto, vediamo in generale 🤗 Transformers. 🤗 Transformers é una libreria molto strutturata, quindi
puà essere che a volte ci sia un disaccordo con alcune filosofie della libreria o scelte di design. Dalla nostra esperienza,
tuttavia, abbiamo trovato che le scelte fondamentali di design della libreria sono cruciali per usare 🤗 Transformers efficacemente
su larga scala, mantenendo i costi a un livello accettabile.`,Ki,B,ha=`Un buon primo punto di partenza per capire al meglio la libreria é leggere la <a href="filosofia">documentazione sulla nostra filosofia</a>
Da qui, ci sono alcune scelte sul modo di lavorare che cerchiamo di applicare a tutti i modelli:`,el,Z,Ja=`<li>La composizione é generalmente favorita sulla sovra-astrazione</li> <li>Duplicare il codice non é sempre male, soprattutto se migliora notevolmente la leggibilità e accessibilità del modello</li> <li>Tutti i files creati per il nuovo modello devono il piu possibile “compatti”. Questo vuol dire che quando qualcuno leggerá il codice
di uno specifico modello, potrá vedere solo il corrispettivo file <code>modeling_....py</code> senza avere multiple dipendenze.</li>`,tl,Q,Ca=`La cosa piú importante, é che consideriamo la libreria non solo un mezzo per dare un prodotto, <em>per esempio</em> dare la possibilità
di usare BERT per inferenza, ma é anche il prodotto reale che noi vogliamo migliorare sempre più. Quindi, quando aggiungi
un modello, non sei solo la persona che userà il modello, ma rappresenti anche tutti coloro che leggeranno,
cercheranno di capire e modificare il tuo modello.`,il,W,ja="Tenendo questi principi in mente, immergiamoci nel design generale della libreria.",ll,D,nl,R,Ua=`Per aggiungere con successo un modello, é importante capire l’interazione tra il tuo modello e la sua configurazione,
<code>PreTrainedModel</code>, e <code>PretrainedConfig</code>. Per dare un esempio, chiameremo il modello da aggiungere a 🤗 Transformers
<code>BrandNewBert</code>.`,ol,q,_a="Diamo un’occhiata:",al,Di,$a,rl,E,Ia=`Come potete vedere, ci basiamo sull’ereditarietà in 🤗 Transformers, tenendo però il livello di astrazione a un minimo
assoluto.  Non ci sono mai più di due livelli di astrazione per ogni modello nella libreria. <code>BrandNewBertModel</code> eredita
da <code>BrandNewBertPreTrainedModel</code> che, a sua volta, eredita da <code>PreTrainedModel</code> -  semplice no?
Come regola generale, vogliamo essere sicuri che un nuovo modello dipenda solo da <code>PreTrainedModel</code>. Le funzionalità
importanti che sono automaticamente conferite a ogni nuovo modello sono <code>from_pretrained()</code>
e <code>save_pretrained()</code>, che sono usate per serializzazione e deserializzazione. Tutte le altre importanti
funzionalità, come ad esempio <code>BrandNewBertModel.forward</code> devono essere definite completamente nel nuovo script
<code>modeling_brand_new_bert.py</code>. Inoltre, vogliamo essere sicuri che un modello con uno specifico head layer, come
<code>BrandNewBertForMaskedLM</code> non erediti da <code>BrandNewBertModel</code>, ma piuttosto usi <code>BrandNewBertModel</code>
come componente che può essere chiamata nel passaggio forward per mantenere il livello di astrazione basso. Ogni
nuovo modello richieste una classe di configurazione, chiamata <code>BrandNewBertConfig</code>. Questa configurazione é sempre
mantenuta come un attributo in <code>PreTrainedModel</code>, e quindi può essere accessibile tramite l’attributo <code>config</code>
per tutte le classi che ereditano da <code>BrandNewBertPreTrainedModel</code>:`,sl,G,pl,S,La=`Analogamente al modello, la configurazione eredita le funzionalità base di serializzazione e deserializzazione da
<code>PretrainedConfig</code>. É da notare che la configurazione e il modello sono sempre serializzati in due formati differenti -
il modello é serializzato in un file <em>pytorch_model.bin</em> mentre la configurazione con <em>config.json</em>. Chiamando
<code>save_pretrained()</code> automaticamente chiamerà <code>save_pretrained()</code>, cosicché sia il
modello che la configurazione siano salvati.`,ml,V,ul,X,za=`Quando codifichi un nuovo modello, tieni presente che Transformers ha una sua struttura di fondo come libreria, perciò
ci sono alcuni fatti da considerare su come scrivere un codice :-)`,cl,Y,ka=`<li>Il forward pass del tuo modello dev’essere scritto completamente nel file del modello, mentre dev’essere indipendente
da altri modelli nella libreria. Se vuoi riutilizzare un blocco di codice da un altro modello, copia e incolla il codice con un commento <code># Copied from</code> in cima al codice (guarda <a href="https://github.com/huggingface/transformers/blob/v4.17.0/src/transformers/models/roberta/modeling_roberta.py#L160" rel="nofollow">qui</a>
per un ottimo esempio).</li> <li>Il codice dev’essere interamente comprensibile, anche da persone che non parlano in inglese. Questo significa che le
variabili devono avere un nome descrittivo e bisogna evitare abbreviazioni. Per esempio, <code>activation</code> é molto meglio
che <code>act</code>. Le variabili con una lettera sono da evitare fortemente, almeno che non sia per un indce in un for loop.</li> <li>Generamente é meglio avere un codice esplicito e piú lungo che un codice corto e magico.</li> <li>Evita di subclassare <code>nn.Sequential</code> in Pytorch, puoi subclassare <code>nn.Module</code> e scrivere il forward pass, cosicché
chiunque può effettuare debug sul tuo codice, aggiungendo print o breaking points.</li> <li>La tua function-signature dev’essere type-annoted. Per il resto, é meglio preferire variabili con un nome accettabile
piuttosto che annotazioni per aumentare la comprensione e leggibilità del codice.</li>`,dl,F,Ml,O,xa="Questa sezione sarà creata al piu presto :-(",fl,K,gl,ee,Aa="Ci sono differenti modi per aggiungere un modello a Hugging Face. Qui trovi una lista di blog posts da parte della community su come aggiungere un modello:",Tl,te,Ha='<li><a href="https://medium.com/huggingface/from-tensorflow-to-pytorch-265f40ef2a28" rel="nofollow">Aggiungere GPT2</a> scritto da <a href="https://huggingface.co/thomwolf" rel="nofollow">Thomas</a></li> <li><a href="https://huggingface.co/blog/porting-fsmt" rel="nofollow">Aggiungere WMT19 MT</a> scritto da <a href="https://huggingface.co/stas" rel="nofollow">Stas</a></li>',vl,ie,Na="Per esperienza, possiamo dirti che quando si aggiunge un modello é meglio tenere a mente le seguenti considerazioni:",wl,le,Pa=`<li>Non sfondare una porta giá aperta! La maggior parte del codice che aggiungerai per un nuovo modello 🤗 Transformers
esiste già da qualche parte in 🤗 Transformers. Prendi un po’ di tempo per trovare codici simili in modelli e tokenizers esistenti e fare un copia-incolla. Ricorda che <a href="https://www.gnu.org/software/grep/" rel="nofollow">grep</a> e <a href="https://github.com/BurntSushi/ripgrep" rel="nofollow">rg</a> sono tuoi buoni amici. Inoltre, ricorda che puó essere molto probabile che il tokenizer per il tuo modello sia basato sull’implementazione di un altro modello, e il codice del tuo modello stesso su un altro ancora. <em>Per esempio</em> il modello FSMT é basato su BART, mentre il tokenizer di FSMT é basato su XLM.</li> <li>Ricorda che qui é piu una sfida ingegneristica che scientifica. Spendi piú tempo per create un efficiente ambiente di debugging piuttosto che cercare di capire tutti gli aspetti teorici dell’articolo del modello.</li> <li>Chiedi aiuto se sei in panne! I modelli sono la parte principale di 🤗 Transformers, perciò qui a Hugging Face siamo più che contenti di aiutarti in ogni passo per aggiungere il tuo modello. Non esitare a chiedere se vedi che non riesci a progredire.</li>`,bl,ne,Ba="Di seguito, diamo una ricetta generale per aiutare a portare un modello in 🤗 Transformers.",yl,oe,Za="La lista seguente é un sommario di tutto quello che é stato fatto per aggiungere un modello, e può essere usata come To-Do List:",hl,ae,Qa='<li><ol><li>☐ (Opzionale) Capire gli aspetti teorici del modello</li></ol></li> <li><ol start="2"><li>☐ Preparare l’ambiente dev per transformers</li></ol></li> <li><ol start="3"><li>☐ Preparare l’ambiente debugging della repository originale</li></ol></li> <li><ol start="4"><li>☐ Create uno script che gestisca con successo il forward pass usando la repository originale e checkpoint</li></ol></li> <li><ol start="5"><li>☐ Aggiungere con successo lo scheletro del modello a Transformers</li></ol></li> <li><ol start="6"><li>☐ Convertire i checkpoint original a Transformers checkpoint</li></ol></li> <li><ol start="7"><li>☐ Effettuare con successo la forward pass in Transformers, di modo che dia un output identico al checkpoint originale</li></ol></li> <li><ol start="8"><li>☐ Finire i tests per il modello in Transformers</li></ol></li> <li><ol start="9"><li>☐ Aggiungere con successo Tokenizer in Transformers</li></ol></li> <li><ol start="10"><li>☐ Testare e provare gli integration tests da capo a fine</li></ol></li> <li><ol start="11"><li>☐ Completare i docs</li></ol></li> <li><ol start="12"><li>☐ Caricare i moedl weights all’hub</li></ol></li> <li><ol start="13"><li>☐ Sottomettere una pull request</li></ol></li> <li><ol start="14"><li>☐ (Opzionale) Aggiungere un notebook con una demo</li></ol></li>',Jl,re,Wa="Per cominciare di solito consigliamo <code>BrandNewBert</code>, partendo dalla teoria, di modo da avere una buona comprensione della teoria generale. TUttavia, se preferisci imparare l’aspetto teorico del modello mentre <em>lavori</em> sul modello é ok immergersi direttamente nel codice di <code>BrandNewBert</code>. Questa opzione puó essere buona se le tue skills ingegneristiche sono meglio che quelle teoriche, o se il paper <code>BrandNewBert</code> ti dá problemi, o se semplicemente ti piace programmare piú che leggere articoli scientifici.",Cl,se,jl,pe,Da="Allora con calma, prendi un po’ di tempo per leggere l’articolo su <em>BrandNewBert</em> . Sicuramente, alcune sezioni dell’articolo sono molto complesse, ma non preoccuparti! L’obiettivo non é avere una compresione immensa della teoria alla base, ma estrarre le informazioni necessarie per re-implementare con successo il modello in 🤗 Transformers. Quindi, non impazzire sugli aspetti teorici, ma piuttosto focalizzati su quelli pratici, ossia:",Ul,me,Ra='<li>Che tipo di modello é <em>brand_new_bert</em>? É solo un encoder in stile BERT? O tipo decoder come GPT2? O encoder e decoder stile BART? Dai un’occhiata a <a href="model_summary">model_summary</a> se non sei famigliare con le differenze tra questi modelli</li> <li>Quali sono le applicazioni di <em>brand_new_bert</em>? Classificazione di testo? Generazione di testo? O per tasks del genere seq2seq?</li> <li>Quali sono le nuove aggiunte al modello che lo rendono diverso da BERT/GPT-2/BART?</li> <li>Quali modelli estistenti in <a href="https://huggingface.co/transformers/#contents" rel="nofollow">🤗 Transformers models</a> sono molto simili a <em>brand_new_bert</em>?</li> <li>Che tipo di tokenizer si usa in questo caso? Un sentencepiece tokenizer? O un word piece tokenizer? Il tokenizer é lo stesso di BERT o BART?</li>',_l,ue,qa="Una volta che senti che hai avuto una bella overview dell’architettura del modello, puoi scrivere senza problemi al team di Hugging Face per ogni domanda che tu hai. Questo puó includere domande sull’architettura del modello, o sull’attention layer, etc. Saremo molto felici di aiutarti :)",$l,ce,Il,de,Ea='<li><p>Forka la <a href="https://github.com/huggingface/transformers" rel="nofollow">repository</a> cliccando sul tasto ‘Fork’ nella pagina della repository. Questo crea una copia del codice nel tuo account GitHub</p></li> <li><p>Clona il tuo fork <code>transfomers</code> sul tuo dico locale, e aggiungi la repository base come remota:</p></li>',Ll,Me,zl,b,Ga="<li>Crea un ambiente di sviluppo, per esempio tramite questo comando:</li>",kl,fe,xl,ge,Sa="quindi torna alla directory principale:",Al,Te,Hl,y,Va='<li>Attenzione, raccomandiamo di aggiungere la versione di PyTorch di <em>brand_new_bert</em> a Transfomers. Per installare PyTorch, basta seguire queste istruzioni <a href="https://pytorch.org/get-started/locally/" rel="nofollow">https://pytorch.org/get-started/locally/</a>.</li>',Nl,ve,Xa="<strong>Nota bene:</strong> Non c’é bisogno di installare o avere installato CUDA. Il nuovo modello può funzionare senza problemi su una CPU.",Pl,h,Ya="<li>Per trasferire <em>brand_new_bert</em> To port <em>brand_new_bert</em> avrai bisogno anche accesso alla sua repository originale:</li>",Bl,we,Zl,be,Fa="Ok, ora hai un ambiente di sviluppo per portare <em>brand_new_bert</em> in 🤗 Transformers.",Ql,ye,Wl,he,Oa="Per cominciare, comincerai a lavorare sulla repo originale di <em>brand_new_bert</em>. Come spesso accade, l’implementazione originale é molto sullo stile “ricerca”. Questo significa che a volte la documentazione non é al top, magari manca qualche cosa e il codice puó essere difficile da capire. Tuttavia, questa é e dev’essere la motivazione per reimplementare <em>brand_new_bert</em>. In Hugging Face, uno degli obiettivi principali é di <em>mettere le persone sulle spalle dei giganti</em>, il che si traduce, in questo contesto, di prendere un modello funzionante e riscriverlo e renderlo il piú possibile <strong>accessibile, user-friendly, e leggibile</strong>. Questa é la top motivazione per re-implementare modelli in 🤗 Transformers - cercare di creare nuove complesse tecnologie NLP accessibili a <strong>chiunque</strong>.",Dl,Je,Ka="Riuscire a far girare il modello pretrained originale dalla repository ufficiale é spesso il passo <strong>piu arduo</strong>. Dalla nostra esperienza, é molto importante spendere un p’ di tempo per diventare familiari con il codice base originale. Come test, prova a capire i seguenti punti:",Rl,Ce,er="<li>Dove si trovano i pretrained weights?</li> <li>Come caricare i pretrained weights nel modello corrispondente?</li> <li>Come girare un tokenizer independentemente dal modello?</li> <li>Prova a tracciare un singolo forward pass, cosicché potrai sapere che classi e funzioni sono richieste per un semplice forward pass. Di solito, dovrai reimplementare queste funzioni e basta</li> <li>Prova a localizzare i componenti importanti del modello: Dove si trova la classe del modello? Ci sono sotto classi nel modello <em>per esempio</em> EngoderModel, DecoderMOdel? Dove si trova il self-attention layer? Ci sono molteplici differenti layer di attention, <em>per esempio</em> <em>self-attention</em>, <em>cross-attention</em>…?</li> <li>Come puoi fare debug sul modello nell’ambiente originale della repo? Devi aggiungere dei <em>print</em> o puoi usare <em>ipdb</em> come debugger interattivo, o vabene anche un IDE efficiente per debug come PyCharm?</li>",ql,je,tr="É molto importante che prima di cominciare a trasferire il modello nuovo tu spenda tempo a fare debug del codice originale in maniera <strong>efficiente</strong>! Inoltre, ricorda che tutta la library é open-soruce, quindi non temere di aprire issue o fare una pull request nella repo originale. Tutti coloro che mantengono la repository saranno piú che felici di avere qualcuno che guarda e gioca con i loro codici!",El,Ue,ir="A questo punto, sta a te decidere quale ambiente per debug vuoi usare. Noi consilgiamo di evitare setup con GPU, che potrebbero costare assai, lavorare su una CPU puó essere un ottimo punto di partenza per indagare la repository originale e per cominciare a scrivere il codice per 🤗 Transformers. Solo alla fine, quando il modello é stato portato con successo in  🤗 Transformers, allora si potrá verificare il suo funzionamento su GPU.",Gl,_e,lr="In generale ci sono due possibili ambienti di debug per il testare il modello originale:",Sl,$e,nr='<li><a href="https://jupyter.org/" rel="nofollow">Jupyter notebooks</a> / <a href="https://colab.research.google.com/notebooks/intro.ipynb" rel="nofollow">google colab</a></li> <li>Scripts locali in Python</li>',Vl,Ie,or="Il vantaggio dei Jupyter notebooks é la possibilità di eseguire cella per cella, il che può essere utile per decomporre tutte le componenti logiche, cosi da a vere un ciclo di debug più rapido, siccome si possono salvare i risultati da steps intermedi. Inoltre, i notebooks spesso sono molto facili da condividere con altri contributors, il che può essere molto utile se vuoi chiedere aiuto al team di Hugging Face. Se sei famigliare con Jupyter notebooks allora racommandiamo di lavorare in questa maniera.",Xl,Le,ar="Ovviamente se non siete abituati a lavorare con i notebook, questo può essere uno svantaggio nell’usare questa tecnologia, sprecando un sacco di tempo per setup e portare tutto al nuovo ambiente, siccome non potreste neanche usare dei tools di debug come <code>ipdb</code>.",Yl,ze,rr="Per ogni pratica code-base, é sempre meglio come primo step caricare un <strong>piccolo</strong> checkpoint pretrained e cercare di riprodurre un singolo forward pass usando un vettore fittizio di IDs fatti da numeri interi. Un esempio per uno script simile, in pseudocodice é:",Fl,ke,Ol,xe,sr="Per quanto riguarda la strategia di debugging, si può scegliere tra:",Kl,Ae,pr=`<li>Decomporre il modello originario in piccole componenenti e testare ognuna di esse</li> <li>Decomporre il modello originario nel <em>tokenizer</em> originale e nel <em>modello</em> originale, testare un forward pass su questi,
e usare dei print statement o breakpoints intermedi per verificare</li>`,en,He,mr=`Ancora una volta, siete liberi di scegliere quale strategia sia ottimale per voi. Spesso una strategia é piu
avvantaggiosa di un’altra, ma tutto dipende dall’code-base originario.`,tn,Ne,ur=`Se il code-base vi permette di decomporre il modello in piccole sub-componenenti, <em>per esempio</em> se il code-base
originario può essere facilmente testato in eager mode, allora vale la pena effettuare un debugging di questo genere.
Ricordate che ci sono dei vantaggi nel decidere di prendere la strada piu impegnativa sin da subito:`,ln,Pe,cr=`<li>negli stage piu finali, quando bisognerà comparare il modello originario all’implementazione in Hugging Face, potrete verificare
automaticamente ogni componente, individualmente, di modo che ci sia una corrispondenza 1:1</li> <li>avrete l’opportunità di decomporre un problema molto grande in piccoli passi, così da strutturare meglio il vostro lavoro</li> <li>separare il modello in componenti logiche vi aiuterà ad avere un’ottima overview sul design del modello, quindi una migliore
comprensione del modello stesso</li> <li>verso gli stage finali i test fatti componente per componente vi aiuterà ad essere sicuri di non andare avanti e indietro
nell’implementazione, così da continuare la modifica del codice senza interruzione</li>`,nn,Be,dr=`Un ottimo esempio di come questo può essere fatto é dato da <a href="https://gist.github.com/LysandreJik/db4c948f6b4483960de5cbac598ad4ed" rel="nofollow">Lysandre</a>
per il modello ELECTRA`,on,Ze,Mr=`Tuttavia, se il code-base originale é molto complesso o le componenti intermedie possono essere testate solo in tramite
compilazione, potrebbe richiedere parecchio tempo o addirittura essere impossibile separare il modello in piccole sotto-componenti.
Un buon esempio é <a href="https://github.com/tensorflow/mesh/tree/master/mesh_tensorflow" rel="nofollow">MeshTensorFlow di T5</a>. Questa libreria
é molto complessa e non offre un metodo semplice di decomposizione in sotto-componenti. Per simili librerie, potrete fare
affidamento ai print statements.`,an,Qe,fr=`In ogni caso, indipendentemente da quale strategia scegliete, la procedura raccomandata é di cominciare a fare debug dal
primo layer al layer finale.
É consigliato recuperare gli output dai layers, tramite print o sotto-componenti, nel seguente ordine:`,rn,We,gr="<li>Recuperare gli IDs di input dati al modello</li> <li>Recuperare i word embeddings</li> <li>Recuperare l’input del primo Transformer layer</li> <li>Recuperare l’output del primo Transformer layer</li> <li>Recuperare l’output dei seguenti <code>n - 1</code> Transformer layers</li> <li>Recuperare l’output dell’intero BrandNewBert Model</li>",sn,De,Tr="Gli IDs in input dovrebbero essere un arrary di interi, <em>per esempio</em> <code>input_ids = [0, 4, 4, 3, 2, 4, 1, 7, 19]</code>",pn,Re,vr="Gli output dei seguenti layer di solito dovrebbero essere degli array di float multi-dimensionali come questo:",mn,qe,un,Ee,wr=`Ci aspettiamo che ogni modello aggiunto a 🤗 Transformers passi con successo un paio di test d’integrazione. Questo
significa che il modello originale e la sua implementazione in 🤗 Transformers abbiano lo stesso output con una precisione
di 0.001! Siccome é normale che lo stesso esatto modello, scritto in librerie diverse, possa dare output leggermente
diversi, la tolleranza accettata é 1e-3 (0.001). Ricordate che i due modelli devono dare output quasi identici. Dunque,
é molto conveniente comparare gli output intermedi di 🤗 Transformers molteplici volte con gli output intermedi del
modello originale di <em>brand_new_bert</em>. Di seguito vi diamo alcuni consigli per avere un ambiente di debug il piu efficiente
possibile:`,cn,Ge,br=`<li>Trovate la migliore strategia per fare debug dei risultati intermedi. Per esempio, é la repository originale scritta in PyTorch?
Se si, molto probabilmente dovrete dedicare un po’ di tempo per scrivere degli script piu lunghi, così da decomporre il
modello originale in piccole sotto-componenti, in modo da poter recuperare i valori intermedi. Oppure, la repo originale
é scritta in Tensorflow 1? Se é così dovrete fare affidamento ai print di Tensorflow <a href="https://www.tensorflow.org/api_docs/python/tf/print" rel="nofollow">tf.print</a>
per avere i valori intermedi. Altro caso, la repo é scritta in Jax? Allora assicuratevi che il modello non sia in <strong>jit</strong>
quanto testate il foward pass, <em>per esempio</em> controllate <a href="https://github.com/google/jax/issues/196" rel="nofollow">questo link</a>.</li> <li>Usate i più piccoli pretrained checkpoint che potete trovare. Piu piccolo é il checkpoint, piu velocemente sarà il vostro
ciclo di debug. Non é efficiente avere un pretrained model così gigante che per il forward pass impieghi piu di 10 secondi.
Nel caso in cui i checkpoints siano molto grandi, e non si possa trovare di meglio, allora é buona consuetudine ricorrere
a fare un dummy model nel nuovo ambiente, con weights inizializzati random e salvare quei weights per comprare la versione 🤗 Transformers
con il vostro modello</li> <li>Accertatevi di usare la via piu semplice per chiamare il forward pass nella repo originale. Sarebbe opportuno trovare
la funzione originaria che chiami <strong>solo</strong> un singolo forward pass, <em>per esempio</em> questa funzione spesso viene chiamata
<code>predict</code>, <code>evaluate</code>, <code>forward</code> o <code>__call__</code>. Siate sicuri di non fare debug su una funzione che chiami <code>forward</code> molteplici
volte, <em>per esempio</em> per generare testo, come <code>autoregressive_sample</code>, <code>generate</code>.</li> <li>Cercate di separare la tokenization dal forward pass del modello. Se la repo originaria mostra esempio dove potete dare
come input una stringa, provate a cercare dove nella forward call la stringa viene cambiata in input ids e cominciate il
debug da questo punto. Questo vi garantisce un ottimo punto di partenza per scrivere un piccolo script personale dove dare
gli input al modello, anziche delle stringhe in input.</li> <li>Assicuratevi che il debugging <strong>non</strong> sia in training mode. Spesso questo potra il modello a dare degli output random, per
via dei molteplici dropout layers. Assicuratevi che il forward pass nell’ambiente di debug sia <strong>deterministico</strong>, cosicche
i dropout non siano usati. Alternativamente, potete usare <em>transformers.utils.set_seed</em> se la vecchia e nuova implementazione
sono nello stesso framework.</li>`,dn,Se,yr="La seguente sezione vi da ulteriori dettagli e accorgimenti su come potete fare tutto questo per <em>brand_new_bert</em>.",Mn,Ve,fn,Xe,hr="Allora cominciamo ad aggiungere un nuovo codice in 🤗 Transformers. Andate nel vostro fork clone di 🤗 Transformers:",gn,Ye,Tn,Fe,Jr=`Nel caso speciale in cui stiate aggiungendo un modello, la cui architettura sia identica a una di un modello già esistente,
dovrete solo aggiugnere uno script di conversione, come descritto <a href="#write-a-conversion-script">qui</a>.
In questo caso, potete riutilizzare l’intera architettura del modello gia esistente.`,vn,Oe,Cr=`Se questo non é il caso, cominciamo con il generare un nuovo modello. Ti consigliamo di utilizzare il seguente script per aggiungere un modello a partire da
un modello esistente:`,wn,Ke,bn,et,jr="Ti verrà richiesto con un questionario di compilare le informazioni di base del tuo modello.",yn,tt,Ur="<strong>Aprire una Pull Request in main huggingface/transformers repo</strong>",hn,it,_r=`Prime di cominciare ad adattare il codice automaticamente generato, aprite una nuova PR come “Work in progress (WIP)“,
<em>per esempio</em> ”[WIP] Aggiungere <em>brand_new_bert</em>”, cosicché il team di Hugging Face possa lavorare al vostro fianco nell’
integrare il modello in 🤗 Transformers.`,Jn,lt,$r="Questi sarebbero gli step generali da seguire:",Cn,nt,Ir="<li>Creare un branch dal main branch con un nome descrittivo</li>",jn,ot,Un,J,Lr="<li>Commit del codice automaticamente generato</li>",_n,at,$n,C,zr="<li>Fare fetch e rebase del main esistente</li>",In,rt,Ln,j,kr="<li>Push dei cambiamenti al proprio account:</li>",zn,st,kn,U,xr=`<li><p>Una volte che siete soddisfatti dei nuovi cambiamenti, andate sulla webpage del vostro fork su GitHub. Cliccate “Pull request”.
Assiuratevi di aggiungere alcuni membri di Hugging Face come reviewers, nel riguardo alla destra della pagina della PR, cosicche il team
Hugging Face verrà notificato anche per i futuri cambiamenti.</p></li> <li><p>Cambiare la PR a draft, cliccando su “Convert to draft” alla destra della pagina della PR</p></li>`,xn,pt,Ar=`Da quel punto in poi, ricordate di fare commit di ogni progresso e cambiamento, cosicche venga mostrato nella PR. Inoltre,
ricordatevi di tenere aggiornato il vostro lavoro con il main esistente:`,An,mt,Hn,ut,Hr=`In generale, tutte le domande che avrete riguardo al modello o l’implementazione dovranno essere fatte nella vostra PR
e discusse/risolte nella PR stessa. In questa maniera, il team di Hugging Face sarà sempre notificato quando farete commit
di un nuovo codice o se avrete qualche domanda. É molto utile indicare al team di Hugging Face il codice a cui fate riferimento
nella domanda, cosicche il team potra facilmente capire il problema o la domanda.`,Nn,ct,Nr=`Per fare questo andate sulla tab “Files changed”, dove potrete vedere tutti i vostri cambiamenti al codice, andate sulla linea
dove volete chiedere una domanda, e cliccate sul simbolo ”+” per aggiungere un commento. Ogni volta che una domanda o problema
é stato risolto, cliccate sul bottone “Resolve”.`,Pn,dt,Pr=`In questa stessa maniera, Hugging Face aprirà domande o commenti nel rivedere il vostro codice. Mi raccomando, chiedete più
domande possibili nella pagina della vostra PR. Se avete domande molto generali, non molto utili per il pubblico, siete liberi
di chiedere al team Hugging Face direttamente su slack o email.`,Bn,Mt,Br="<strong>5. Adattare i codici per brand_new_bert</strong>",Zn,ft,Zr=`Per prima cosa, ci focalizzeremo sul modello e non sui tokenizer. Tutto il codice relative dovrebbe trovarsi in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> e
<code>src/transformers/models/brand_new_bert/configuration_brand_new_bert.py</code>.`,Qn,gt,Qr=`Ora potete finalmente cominciare il codice :). Il codice generato in
<code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code> avrà sia la stessa architettura di BERT se é un
modello encoder-only o BART se é encoder-decoder. A questo punto, ricordatevi cio che avete imparato all’inizio, riguardo
agli aspetti teorici del modello: <em>In che maniera il modello che sto implmementando é diverso da BERT o BART?</em>. Implementare
questi cambi  spesso vuol dire cambiare il layer <em>self-attention</em>, l’ordine dei layer di normalizzazione e così via…
Ancora una volta ripetiamo, é molto utile vedere architetture simili di modelli gia esistenti in Transformers per avere
un’idea migliore su come implementare il modello.`,Wn,Tt,Wr=`<strong>Notate</strong> che a questo punto non dovete avere subito un codice tutto corretto o pulito. Piuttosto, é consigliato cominciare con un
codice poco pulito, con copia-incolla del codice originale in <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>
fino a che non avrete tutto il codice necessario. In base alla nostra esperienza, é molto meglio aggiungere una prima bozza
del codice richiesto e poi correggere e migliorare iterativamente. L’unica cosa essenziale che deve funzionare qui é la seguente
instanza:`,Dn,vt,Rn,wt,Dr=`Questo comando creerà un modello con i parametri di default definiti in <code>BrandNewBergConfig()</code> e weights random. Questo garantisce
che <code>init()</code> di tutte le componenti funzioni correttamente.`,qn,bt,Rr="<strong>6. Scrivere uno script di conversione</strong>",En,yt,qr=`Il prossimo step é scrivere uno script per convertire il checkpoint che avete usato per fare debug su <em>brand_new_berts</em> nella
repo originale in un checkpoint per la nuova implementazione di <em>brand_new_bert</em> in 🤗 Transformers. Non é consigliato scrivere
lo script di conversione da zero, ma piuttosto cercate e guardate script gia esistenti in 🤗 Transformers, così da trovarne
uno simile al vostro modello. Di solito basta fare una copia di uno script gia esistente e adattarlo al vostro caso.
Non esistate a chiedre al team di Hugging Face a riguardo.`,Gn,ht,Er='<li>Se state convertendo un modello da TensorFlow a PyTorch, un ottimo inizio é vedere <a href="https://github.com/huggingface/transformers/blob/7acfa95afb8194f8f9c1f4d2c6028224dbed35a2/src/transformers/models/bert/modeling_bert.py#L91" rel="nofollow">questo script di conversione per BERT</a></li> <li>Se state convertendo un modello da PyTorch a PyTorch, <a href="https://github.com/huggingface/transformers/blob/main/src/transformers/models/bart/convert_bart_original_pytorch_checkpoint_to_pytorch.py" rel="nofollow">lo script di conversione di BART può esservi utile</a></li>',Sn,Jt,Gr=`Qui di seguito spiegheremo come i modelli PyTorch salvano i weights per ogni layer e come i nomi dei layer sono definiti. In PyTorch,
il nomde del layer é definito dal nome della class attribute che date al layer. Definiamo un modello dummy in PyTorch,
chiamato <code>SimpleModel</code>:`,Vn,Ct,Xn,jt,Sr=`Ora possiamo creare un’instanza di questa definizione di modo da inizializzare a random weights: <code>dense</code>, <code>intermediate</code>, <code>layer_norm</code>.
Possiamo usare print per vedere l’architettura del modello:`,Yn,Ut,Fn,_t,Vr="Da cui si ottiene:",On,$t,Kn,It,Xr=`Si può vedere come i nomi dei layers siano definiti dal nome della class attribute in PyTorch. I valori dei weights di uno
specifico layer possono essere visualizzati:`,eo,Lt,to,zt,Yr="ad esempio:",io,kt,lo,xt,Fr=`Nello script di conversione, dovreste riempire quei valori di inizializzazione random con gli stessi weights del corrispondente
layer nel checkpoint. <em>Per esempio</em>`,no,At,oo,Ht,Or=`Così facendo, dovete verificare che ogni inizializzazione random di un peso del modello PyTorch e il suo corrispondente peso nel pretrained checkpoint
siano esattamente gli stessi e uguali in <strong>dimensione/shape e nome</strong>. Per fare questo, é <strong>necessario</strong> aggiungere un <code>assert</code>
per la dimensione/shape e nome:`,ao,Nt,ro,Pt,Kr="Inoltre, dovrete fare il print sia dei nomi che dei weights per essere sicuri che siano gli stessi:",so,Bt,po,Zt,es=`Se la dimensione o il nome non sono uguali, probabilmente avete sbagliato ad assegnare il peso nel checkpoint o nel layer costrutture di
🤗 Transformers.`,mo,Qt,ts=`Una dimensione sbagliata può essere dovuta ad un errore nei parameteri in <code>BrandNewBertConfig()</code>. Tuttavia, può essere anche
che l’implementazione del layer in PyTorch richieda di fare una transposizione della matrice dei weights.`,uo,Wt,is=`Infine, controllate <strong>tutti</strong> che tutti i weights inizializzati e fate print di tutti i weights del checkpoint che non sono stati
usati per l’inizializzazione, di modo da essere sicuri che il modello sia correttamente convertito. É normale che ci siano
errori nel test di conversione, fai per un errore in <code>BrandNewBertConfig()</code>, o un errore nell’architettura in 🤗 Transformers,
o un bug in <code>init()</code>.`,co,Dt,ls=`Questo step dev’essere fatto tramite iterazioni fino a che non si raggiungano gli stessi valori per i weights. Una volta che
il checkpoint é stato correttamente caricato in 🤗 Transformers, potete salvare il modello in una cartella di vostra scelta
<code>/path/to/converted/checkpoint/folder</code> che contenga sia
<code>pytorch_model.bin</code> che <code>config.json</code>:`,Mo,Rt,fo,qt,ns="<strong>7. Implementare il forward pass</strong>",go,Et,os=`Una volta che i weights pretrained sono stati correttamente caricati in 🤗 Transformers, dovrete assicurarvi che il forward pass
sia correttamente implementato. <a href="#3-4-provare-un-pretrained-checkpoint-usando-la-repo-originale">Qui</a>, avete give creato e provato
uno script che testi il forward pass del modello usando la repo originaria. Ora dovrete fare lo stesso con uno script analogo
usando l’implementazione in 🤗 Transformers anziché l’originale. Piu o meno lo script dovrebbe essere:`,To,Gt,vo,St,as=`Di solito l’output da 🤗 Transformers non é uguale uguale all’output originario, sopratto la prima volta. Non vi abbattete -
é normale! Prima di tutto assicuratevi che non ci siano errori o che non vengano segnalati degli errori nella forward pass.
Spesso capita che ci siano dimensioni sbagliate o data type sbagliati, <em>ad esempio</em> <code>torch.long</code> anziche <code>torch.float32</code>.
Non esistate a chiedere al team Hugging Face!`,wo,Vt,rs=`Nella parte finale assicuratevi che l’implementazione 🤗 Transformers funzioni correttamente cosi da testare che gli output
siano equivalenti a una precisione di <code>1e-3</code>. Controllate che <code>outputs.shape</code> siano le stesse tra 🤗 Transformers e l’implementazione
originaria. Poi, controllate che i valori in output siano identici. Questa é sicuramente la parte più difficile, qui una serie
di errori comuni quando gli output non sono uguali:`,bo,Xt,ss=`<li>Alcuni layers non sono stati aggiunti, <em>ad esempio</em> un <em>activation</em> layer non é stato aggiunto, o ci si é scordati di una connessione</li> <li>La matrice del word embedding non é stata ripareggiata</li> <li>Ci sono degli embeddings posizionali sbagliati perché l’implementazione originaria ha un offset</li> <li>Il dropout é in azione durante il forward pass. Per sistemare questo errore controllate che <em>model.training = False</em> e che
il dropout non sia stato attivato nel forward pass, <em>per esempio</em> passate <em>self.training</em> a <a href="https://pytorch.org/docs/stable/nn.functional.html?highlight=dropout#torch.nn.functional.dropout" rel="nofollow">PyTorch’s functional dropout</a></li>`,yo,Yt,ps=`La miglior maniera per sistemare il problema é di vedere all’implementazione originaria del forward pass e in 🤗 Transformers
fianco a fianco e vedere se ci sono delle differenze. In teoria, con debug e print degli output intermedie di entrambe le
implementazioni nel forward pass nell’esatta posizione del network dovrebbe aiutarvi a vedere dove ci sono differenze tra
i due frameworks. Come prima mossa controllate che <code>input_ids</code> siano identici in entrambi gli scripts. Da lì andate fino
all’ultimo layer. Potrete notare una differenza tra le due implementazioni a quel punto.`,ho,Ft,ms=`Una volta che lo stesso output é stato ragguingi, verificate gli output con <code>torch.allclose(original_output, output, atol=1e-3)</code>.
A questo punto se é tutto a posto: complimenti! Le parti seguenti saranno una passeggiata 😊.`,Jo,Ot,us="<strong>8. Aggiungere i test necessari per il modello</strong>",Co,Kt,cs=`A questo punto avete aggiunto con successo il vostro nuovo modello. Tuttavia, é molto probabile che il modello non sia
del tutto ok con il design richiesto. Per essere sicuri che l’implementazione sia consona e compatibile con 🤗 Transformers é
necessario implementare dei tests. Il Cookiecutter dovrebbe fornire automaticamente dei file per test per il vostro modello,
di solito nella folder <code>tests/test_modeling_brand_new_bert.py</code>. Provate questo per verificare l’ok nei test piu comuni:`,jo,ei,Uo,ti,ds="Una volta sistemati i test comuni, bisogna assicurarsi che il vostro lavoro sia correttamente testato cosicchè:",_o,ii,Ms="<li>a) La community puo capire in maniera semplice il vostro lavoro controllando tests specifici del modello <em>brand_new_bert</em>,</li> <li>b) Implementazioni future del vostro modello non rompano alcune feature importante del modello.</li>",$o,li,fs=`Per prima cosa agguingete dei test d’integrazione. Questi sono essenziali perche fanno la stessa funzione degli scripts di
debug usati precedentemente. Un template per questi tests esiste gia nel Cookiecutter ed é sotto il nome di <code>BrandNewBertModelIntegrationTests</code>,
voi dovrete solo completarlo. Una volta che questi tests sono OK, provate:`,Io,ni,Lo,_,zo,oi,gs=`Di seguito, tutte le features che sono utili e necessarire per <em>brand_new_bert</em> devono essere testate in test separati,
contenuti in <code>BrandNewBertModelTester</code>/ <code>BrandNewBertModelTest</code>. spesso la gente si scorda questi test, ma ricordate che sono utili per:`,ko,ai,Ts="<li>Aiuta gli utenti a capire il vostro codice meglio, richiamando l’attenzione su queste nuove features</li> <li>Developers e contributors futuri potranno velocemente testare nuove implementazioni del modello testanto questi casi speciali.</li>",xo,ri,vs="<strong>9. Implementare il tokenizer</strong>",Ao,si,ws="A questo punto avremo bisogno un tokenizer per <em>brand_new_bert</em>. Di solito il tokenizer é uguale ad altri modelli in 🤗 Transformers.",Ho,pi,bs="É importante che troviate il file con il tokenizer originale e che lo carichiate in 🤗 Transformers.",No,mi,ys=`Per controllare che il tokenizer funzioni in modo corretto, create uno script nella repo originaria che riceva come input
una stringa e ritorni gli <code>input_ids</code>. Piu o meno questo potrebbe essere il codice:`,Po,ui,Bo,ci,hs=`Potrebbe richiedere un po’ di tempo, ma guardate ancora alla repo originaria per trovare la funzione corretta del tokenizer.
A volte capita di dover riscrivere il tokenizer nella repo originaria, di modo da avere come output gli <code>input_ids</code>.
A quel punto uno script analogo é necessario in 🤗 Transformers:`,Zo,di,Qo,Mi,Js="Una volta che <code>input_ids</code> sono uguali, bisogna aggiungere un test per il tokenizer.",Wo,fi,Cs="Il file test per tokenizer di <em>brand_new_brand</em> dovrebbe avere un paio di hard-coded test d’integrazione.",Do,gi,js="<strong>10. Test end-to-end</strong>",Ro,Ti,Us=`Ora che avete il tokenizer, dovrete aggiungere dei test d’integrazione per l’intero workflow in <code>tests/test_modeling_brand_new_bert.py</code> in 🤗 Transformer.
Questi test devono mostrare che un significante campione text-to-text funzioni come ci si aspetta nell’implementazione di  🤗 Transformers.
<em>Per esempio</em> potreste usare dei source-to-target-translation, o un sommario di un articolo, o un domanda-risposta e cosi via.
Se nessuno dei checkpoints é stato ultra parametrizzato per task simili, allora i tests per il modello sono piu che sufficienti.
Nello step finale dovete assicurarvi che il modello sia totalmente funzionale, e consigliamo anche di provare a testare su GPU.
Puo succedere che ci si scordi un <code>.to(self.device)</code> ad esempio. Se non avete accesso a GPU, il team Hugging Face puo provvedere
a testare questo aspetto per voi.`,qo,vi,_s="<strong>11. Aggiungere una Docstring</strong>",Eo,wi,$s=`Siete quasi alla fine! L’ultima cosa rimasta é avere una bella docstring e una pagina doc. Il Cookiecutter dovrebbe provvedere già
un template chiamato <code>docs/source/model_doc/brand_new_bert.rst</code>, che dovrete compilare. La prima cosa che un utente farà
per usare il vostro modello sarà dare una bella lettura al doc. Quindi proponete una documentazione chiara e concisa. É molto
utile per la community avere anche delle <em>Tips</em> per mostrare come il modello puo’ essere usato. Non esitate a chiedere a Hugging Face
riguardo alle docstirng.`,Go,bi,Is=`Quindi, assicuratevi che la docstring sia stata aggiunta a <code>src/transformers/models/brand_new_bert/modeling_brand_new_bert.py</code>.
Assicuratevi che la docstring sia corretta e che includa tutti i necessari input e output. Abbiamo una guida dettagliata per
scrivere la documentazione e docstring.`,So,yi,Ls="<strong>Rifattorizzare il codice</strong>",Vo,hi,zs="Perfetto! Ora che abbiamo tutto per <em>brand_new_bert</em> controllate che lo stile del codice sia ok:",Xo,Ji,Yo,Ci,ks="E che il codice passi i quality check:",Fo,ji,Oo,Ui,xs=`A volte capita che manchino delle informazioninella docstring o alcuni nomi sbagliati, questo farà fallire i tests sopra.
Ripetiamo: chiedete pure a Hugging Face, saremo lieti di aiutarvi.`,Ko,_i,As="Per ultimo, fare del refactoring del codice una volta che é stato creato.",ea,$i,Hs="Avete finito con il codice, congratulazioni! 🎉 Siete fantasticiiiiiii! 😎",ta,Ii,Ns="<strong>12. Caricare il modello sul model hub</strong>",ia,Li,Ps=`In questa ultima parte dovrete convertire e caricare il modello, con tutti i checkpoints, nel model hub e aggiungere una
model card per ogni checkpoint caricato. Leggete la nostra guida <a href="model_sharing">Model sharing and uploading Page</a> per
avere familiarità con l’hub. Di solito in questa parte lavorate a fianco di Hugging face per decidere un nome che sia ok
per ogni checkpoint, per ottenere i permessi necessari per caricare il modello nell’organizzazione dell’autore di <em>brand_new_bert</em>.
Il metodo <code>push_to_hub</code>, presente in tutti i modelli <code>transformers</code>, é una maniera rapida e indolore per caricare il vostro checkpoint sull’hub:`,la,zi,na,ki,Bs=`Vale la pena spendere un po’ di tempo per creare una model card ad-hoc per ogni checkpoint. Le model cards dovrebbero
suggerire le caratteristiche specifiche del checkpoint, <em>per esempio</em> su che dataset il checkpoint é stato pretrained o fine-tuned.
O che su che genere di task il modello lavoro? E anche buona pratica includere del codice su come usare il modello correttamente.`,oa,xi,Zs="<strong>13. (Opzionale) Aggiungere un notebook</strong>",aa,Ai,Qs=`É molto utile aggiungere un notebook, che dimostri in dettaglio come <em>brand_new_bert</em> si utilizzi per fare inferenza e/o
fine-tuned su specifiche task. Non é una cosa obbligatoria da avere nella vostra PR, ma é molto utile per la community.`,ra,Hi,Ws="<strong>14. Sottomettere la PR</strong>",sa,Ni,Ds=`L’ultimissimo step! Ovvero il merge della PR nel main. Di solito il team Hugging face a questo punto vi avrà gia aiutato,
ma é ok prendere un po’ di tempo per pulire la descirzione e commenti nel codice.`,pa,Pi,ma,Bi,Rs=`É ora tempo di prendere un po’ di credito dalla communità per il vostro lavoro! Caricare e implementare un nuovo modello
é un grandissimo contributo per Transformers e l’intera community NLP. Il codice e la conversione dei modelli pre-trained sara
sicuramente utilizzato da centinaia o migliaia di sviluppatori e ricercatori. Siate fieri e orgogliosi di condividere il vostro
traguardo con l’intera community :)`,ua,Zi,qs="<strong>Avete create un altro modello che é super facile da usare per tutti quanti nella community! 🤯</strong>",ca,Qi,da,Ri,Ma;return I=new v({props:{title:"Come aggiungere un modello a 🤗 Transformers?",local:"come-aggiungere-un-modello-a--transformers",headingTag:"h1"}}),N=new v({props:{title:"Panoramica generale su 🤗 Transformers",local:"panoramica-generale-su--transformers",headingTag:"h2"}}),D=new v({props:{title:"Panoramica sui modelli",local:"panoramica-sui-modelli",headingTag:"h3"}}),G=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyYnJhbmR5JTJGYnJhbmRfbmV3X2JlcnQlMjIpJTBBbW9kZWwuY29uZmlnJTIwJTIwJTIzJTIwaWwlMjBtb2RlbGxvJTIwaGElMjBhY2Nlc3NvJTIwYWwlMjBzdW8lMjBjb25maWc=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;brandy/brand_new_bert&quot;</span>)
model.config  <span class="hljs-comment"># il modello ha accesso al suo config</span>`,wrap:!1}}),V=new v({props:{title:"Stile per il codice",local:"stile-per-il-codice",headingTag:"h3"}}),F=new v({props:{title:"Panoramica sui tokenizers",local:"panoramica-sui-tokenizers",headingTag:"h3"}}),K=new v({props:{title:"Aggiungere un modello a 🤗 Transformers passo dopo passo",local:"aggiungere-un-modello-a--transformers-passo-dopo-passo",headingTag:"h2"}}),se=new v({props:{title:"1. (Opzionale) Aspetti teorici di BrandNewBert",local:"1-opzionale-aspetti-teorici-di-brandnewbert",headingTag:"h3"}}),ce=new v({props:{title:"2. Prepare il tuo ambiente",local:"2-prepare-il-tuo-ambiente",headingTag:"h3"}}),Me=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkYlNUJ5b3VyJTIwR2l0aHViJTIwaGFuZGxlJTVEJTJGdHJhbnNmb3JtZXJzLmdpdCUwQWNkJTIwdHJhbnNmb3JtZXJzJTBBZ2l0JTIwcmVtb3RlJTIwYWRkJTIwdXBzdHJlYW0lMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycy5naXQ=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/[your Github handle]/transformers.git
<span class="hljs-built_in">cd</span> transformers
git remote add upstream https://github.com/huggingface/transformers.git`,wrap:!1}}),fe=new f({props:{code:"cHl0aG9uJTIwLW0lMjB2ZW52JTIwLmVudiUwQXNvdXJjZSUyMC5lbnYlMkZiaW4lMkZhY3RpdmF0ZSUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMCUyMi4lNUJkZXYlNUQlMjI=",highlighted:`python -m venv .<span class="hljs-built_in">env</span>
<span class="hljs-built_in">source</span> .<span class="hljs-built_in">env</span>/bin/activate
pip install -e <span class="hljs-string">&quot;.[dev]&quot;</span>`,wrap:!1}}),Te=new f({props:{code:"Y2QlMjAuLg==",highlighted:'<span class="hljs-built_in">cd</span> ..',wrap:!1}}),we=new f({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZvcmdfdGhhdF9jcmVhdGVkX2JyYW5kX25ld19iZXJ0X29yZyUyRmJyYW5kX25ld19iZXJ0LmdpdCUwQWNkJTIwYnJhbmRfbmV3X2JlcnQlMEFwaXAlMjBpbnN0YWxsJTIwLWUlMjAu",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/org_that_created_brand_new_bert_org/brand_new_bert.git
<span class="hljs-built_in">cd</span> brand_new_bert
pip install -e .`,wrap:!1}}),ye=new v({props:{title:"3.-4. Provare un pretrained checkpoint usando la repo originale",local:"3-4-provare-un-pretrained-checkpoint-usando-la-repo-originale",headingTag:"h3"}}),ke=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5sb2FkX3ByZXRyYWluZWRfY2hlY2twb2ludCglMjIlMkZwYXRoJTJGdG8lMkZjaGVja3BvaW50JTJGJTIyKSUwQWlucHV0X2lkcyUyMCUzRCUyMCU1QjAlMkMlMjA0JTJDJTIwNSUyQyUyMDIlMkMlMjAzJTJDJTIwNyUyQyUyMDklNUQlMjAlMjAlMjMlMjB2ZWN0b3IlMjBvZiUyMGlucHV0JTIwaWRzJTBBb3JpZ2luYWxfb3V0cHV0JTIwJTNEJTIwbW9kZWwucHJlZGljdChpbnB1dF9pZHMp",highlighted:`model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">5</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">7</span>, <span class="hljs-number">9</span>]  <span class="hljs-comment"># vector of input ids</span>
original_output = model.predict(input_ids)`,wrap:!1}}),qe=new f({props:{code:"JTVCJTVCJTBBJTIwJTVCLTAuMTQ2NSUyQyUyMC0wLjY1MDElMkMlMjAlMjAwLjE5OTMlMkMlMjAlMjAuLi4lMkMlMjAlMjAwLjE0NTElMkMlMjAlMjAwLjM0MzAlMkMlMjAlMjAwLjYwMjQlNUQlMkMlMEElMjAlNUItMC40NDE3JTJDJTIwLTAuNTkyMCUyQyUyMCUyMDAuMzQ1MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjMwNjIlMkMlMjAlMjAwLjYxODIlMkMlMjAlMjAwLjcxMzIlNUQlMkMlMEElMjAlNUItMC41MDA5JTJDJTIwLTAuNzEyMiUyQyUyMCUyMDAuNDU0OCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM2NjIlMkMlMjAlMjAwLjYwOTElMkMlMjAlMjAwLjc2NDglNUQlMkMlMEElMjAuLi4lMkMlMEElMjAlNUItMC41NjEzJTJDJTIwLTAuNjMzMiUyQyUyMCUyMDAuNDMyNCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM3OTIlMkMlMjAlMjAwLjczNzIlMkMlMjAlMjAwLjkyODglNUQlMkMlMEElMjAlNUItMC41NDE2JTJDJTIwLTAuNjM0NSUyQyUyMCUyMDAuNDE4MCUyQyUyMCUyMC4uLiUyQyUyMC0wLjM1NjQlMkMlMjAlMjAwLjY5OTIlMkMlMjAlMjAwLjkxOTElNUQlMkMlMEElMjAlNUItMC41MzM0JTJDJTIwLTAuNjQwMyUyQyUyMCUyMDAuNDI3MSUyQyUyMCUyMC4uLiUyQyUyMC0wLjMzMzklMkMlMjAlMjAwLjY1MzMlMkMlMjAlMjAwLjg2OTQlNUQlNUQlNUQlMkM=",highlighted:`<span class="hljs-comment">[<span class="hljs-comment">[
 <span class="hljs-comment">[-0.1465, -0.6501,  0.1993,  ...,  0.1451,  0.3430,  0.6024]</span>,
 <span class="hljs-comment">[-0.4417, -0.5920,  0.3450,  ..., -0.3062,  0.6182,  0.7132]</span>,
 <span class="hljs-comment">[-0.5009, -0.7122,  0.4548,  ..., -0.3662,  0.6091,  0.7648]</span>,
 ...,
 <span class="hljs-comment">[-0.5613, -0.6332,  0.4324,  ..., -0.3792,  0.7372,  0.9288]</span>,
 <span class="hljs-comment">[-0.5416, -0.6345,  0.4180,  ..., -0.3564,  0.6992,  0.9191]</span>,
 <span class="hljs-comment">[-0.5334, -0.6403,  0.4271,  ..., -0.3339,  0.6533,  0.8694]</span>]</span>]</span>,`,wrap:!1}}),Ve=new v({props:{title:"5.-14. Trasferire BrandNewBert in 🤗 Transformers",local:"5-14-trasferire-brandnewbert-in--transformers",headingTag:"h3"}}),Ye=new f({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnM=",highlighted:'<span class="hljs-built_in">cd</span> transformers',wrap:!1}}),Ke=new f({props:{code:"dHJhbnNmb3JtZXJzJTIwYWRkLW5ldy1tb2RlbC1saWtl",highlighted:"transformers add-new-model-like",wrap:!1}}),ot=new f({props:{code:"Z2l0JTIwY2hlY2tvdXQlMjAtYiUyMGFkZF9icmFuZF9uZXdfYmVydA==",highlighted:"git checkout -b add_brand_new_bert",wrap:!1}}),at=new f({props:{code:"Z2l0JTIwYWRkJTIwLiUwQWdpdCUyMGNvbW1pdA==",highlighted:`git add .
git commit`,wrap:!1}}),rt=new f({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMHJlYmFzZSUyMHVwc3RyZWFtJTJGbWFpbg==",highlighted:`git fetch upstream
git rebase upstream/main`,wrap:!1}}),st=new f({props:{code:"Z2l0JTIwcHVzaCUyMC11JTIwb3JpZ2luJTIwYS1kZXNjcmlwdGl2ZS1uYW1lLWZvci1teS1jaGFuZ2Vz",highlighted:"git push -u origin a-descriptive-name-for-my-changes",wrap:!1}}),mt=new f({props:{code:"Z2l0JTIwZmV0Y2glMjB1cHN0cmVhbSUwQWdpdCUyMG1lcmdlJTIwdXBzdHJlYW0lMkZtYWlu",highlighted:`git fetch upstream
git merge upstream/main`,wrap:!1}}),vt=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydE1vZGVsJTJDJTIwQnJhbmROZXdCZXJ0Q29uZmlnJTBBJTBBbW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbChCcmFuZE5ld0JlcnRDb25maWcoKSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertModel, BrandNewBertConfig

model = BrandNewBertModel(BrandNewBertConfig())`,wrap:!1}}),Ct=new f({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEElMEElMEFjbGFzcyUyMFNpbXBsZU1vZGVsKG5uLk1vZHVsZSklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuZGVuc2UlMjAlM0QlMjBubi5MaW5lYXIoMTAlMkMlMjAxMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmludGVybWVkaWF0ZSUyMCUzRCUyMG5uLkxpbmVhcigxMCUyQyUyMDEwKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYubGF5ZXJfbm9ybSUyMCUzRCUyMG5uLkxheWVyTm9ybSgxMCk=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SimpleModel</span>(nn.Module):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-built_in">super</span>().__init__()
        self.dense = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.intermediate = nn.Linear(<span class="hljs-number">10</span>, <span class="hljs-number">10</span>)
        self.layer_norm = nn.LayerNorm(<span class="hljs-number">10</span>)`,wrap:!1}}),Ut=new f({props:{code:"bW9kZWwlMjAlM0QlMjBTaW1wbGVNb2RlbCgpJTBBJTBBcHJpbnQobW9kZWwp",highlighted:`model = SimpleModel()

<span class="hljs-built_in">print</span>(model)`,wrap:!1}}),$t=new f({props:{code:"U2ltcGxlTW9kZWwoJTBBJTIwJTIwKGRlbnNlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAoaW50ZXJtZWRpYXRlKSUzQSUyMExpbmVhcihpbl9mZWF0dXJlcyUzRDEwJTJDJTIwb3V0X2ZlYXR1cmVzJTNEMTAlMkMlMjBiaWFzJTNEVHJ1ZSklMEElMjAlMjAobGF5ZXJfbm9ybSklM0ElMjBMYXllck5vcm0oKDEwJTJDKSUyQyUyMGVwcyUzRDFlLTA1JTJDJTIwZWxlbWVudHdpc2VfYWZmaW5lJTNEVHJ1ZSklMEEp",highlighted:`SimpleModel(
  (dense): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (intermediate): Linear(<span class="hljs-attribute">in_features</span>=10, <span class="hljs-attribute">out_features</span>=10, <span class="hljs-attribute">bias</span>=<span class="hljs-literal">True</span>)
  (layer_norm): LayerNorm((10,), <span class="hljs-attribute">eps</span>=1e-05, <span class="hljs-attribute">elementwise_affine</span>=<span class="hljs-literal">True</span>)
)`,wrap:!1}}),Lt=new f({props:{code:"cHJpbnQobW9kZWwuZGVuc2Uud2VpZ2h0LmRhdGEp",highlighted:'<span class="hljs-built_in">print</span>(model.dense.weight.data)',wrap:!1}}),kt=new f({props:{code:"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",highlighted:`tensor([[<span class="hljs-string">-0</span>.0818,  0.2207, <span class="hljs-string">-0</span>.0749, <span class="hljs-string">-0</span>.0030,  0.0045, <span class="hljs-string">-0</span>.1569, <span class="hljs-string">-0</span>.1598,  0.0212,
         <span class="hljs-string">-0</span>.2077,  0.2157],
        [ 0.1044,  0.0201,  0.0990,  0.2482,  0.3116,  0.2509,  0.2866, <span class="hljs-string">-0</span>.2190,
          0.2166, <span class="hljs-string">-0</span>.0212],
        [<span class="hljs-string">-0</span>.2000,  0.1107, <span class="hljs-string">-0</span>.1999, <span class="hljs-string">-0</span>.3119,  0.1559,  0.0993,  0.1776, <span class="hljs-string">-0</span>.1950,
         <span class="hljs-string">-0</span>.1023, <span class="hljs-string">-0</span>.0447],
        [<span class="hljs-string">-0</span>.0888, <span class="hljs-string">-0</span>.1092,  0.2281,  0.0336,  0.1817, <span class="hljs-string">-0</span>.0115,  0.2096,  0.1415,
         <span class="hljs-string">-0</span>.1876, <span class="hljs-string">-0</span>.2467],
        [ 0.2208, <span class="hljs-string">-0</span>.2352, <span class="hljs-string">-0</span>.1426, <span class="hljs-string">-0</span>.2636, <span class="hljs-string">-0</span>.2889, <span class="hljs-string">-0</span>.2061, <span class="hljs-string">-0</span>.2849, <span class="hljs-string">-0</span>.0465,
          0.2577,  0.0402],
        [ 0.1502,  0.2465,  0.2566,  0.0693,  0.2352, <span class="hljs-string">-0</span>.0530,  0.1859, <span class="hljs-string">-0</span>.0604,
          0.2132,  0.1680],
        [ 0.1733, <span class="hljs-string">-0</span>.2407, <span class="hljs-string">-0</span>.1721,  0.1484,  0.0358, <span class="hljs-string">-0</span>.0633, <span class="hljs-string">-0</span>.0721, <span class="hljs-string">-0</span>.0090,
          0.2707, <span class="hljs-string">-0</span>.2509],
        [<span class="hljs-string">-0</span>.1173,  0.1561,  0.2945,  0.0595, <span class="hljs-string">-0</span>.1996,  0.2988, <span class="hljs-string">-0</span>.0802,  0.0407,
          0.1829, <span class="hljs-string">-0</span>.1568],
        [<span class="hljs-string">-0</span>.1164, <span class="hljs-string">-0</span>.2228, <span class="hljs-string">-0</span>.0403,  0.0428,  0.1339,  0.0047,  0.1967,  0.2923,
          0.0333, <span class="hljs-string">-0</span>.0536],
        [<span class="hljs-string">-0</span>.1492, <span class="hljs-string">-0</span>.1616,  0.1057,  0.1950, <span class="hljs-string">-0</span>.2807, <span class="hljs-string">-0</span>.2710, <span class="hljs-string">-0</span>.1586,  0.0739,
          0.2220,  0.2358]]).`,wrap:!1}}),At=new f({props:{code:"JTIzJTIwcmV0cmlldmUlMjBtYXRjaGluZyUyMGxheWVyJTIwd2VpZ2h0cyUyQyUyMGUuZy4lMjBieSUwQSUyMyUyMHJlY3Vyc2l2ZSUyMGFsZ29yaXRobSUwQWxheWVyX25hbWUlMjAlM0QlMjAlMjJkZW5zZSUyMiUwQXByZXRyYWluZWRfd2VpZ2h0JTIwJTNEJTIwYXJyYXlfb2ZfZGVuc2VfbGF5ZXIlMEElMEFtb2RlbF9wb2ludGVyJTIwJTNEJTIwZ2V0YXR0cihtb2RlbCUyQyUyMCUyMmRlbnNlJTIyKSUwQSUwQW1vZGVsX3BvaW50ZXIud2VpZ2h0LmRhdGElMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KHByZXRyYWluZWRfd2VpZ2h0KQ==",highlighted:`<span class="hljs-comment"># retrieve matching layer weights, e.g. by</span>
<span class="hljs-comment"># recursive algorithm</span>
layer_name = <span class="hljs-string">&quot;dense&quot;</span>
pretrained_weight = array_of_dense_layer

model_pointer = <span class="hljs-built_in">getattr</span>(model, <span class="hljs-string">&quot;dense&quot;</span>)

model_pointer.weight.data = torch.from_numpy(pretrained_weight)`,wrap:!1}}),Nt=new f({props:{code:"YXNzZXJ0JTIwKCUwQSUyMCUyMCUyMCUyMG1vZGVsX3BvaW50ZXIud2VpZ2h0LnNoYXBlJTIwJTNEJTNEJTIwcHJldHJhaW5lZF93ZWlnaHQuc2hhcGUlMEEpJTJDJTIwZiUyMlBvaW50ZXIlMjBzaGFwZSUyMG9mJTIwcmFuZG9tJTIwd2VpZ2h0JTIwJTdCbW9kZWxfcG9pbnRlci5zaGFwZSU3RCUyMGFuZCUyMGFycmF5JTIwc2hhcGUlMjBvZiUyMGNoZWNrcG9pbnQlMjB3ZWlnaHQlMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5zaGFwZSU3RCUyMG1pc21hdGNoZWQlMjI=",highlighted:`<span class="hljs-keyword">assert</span> (
    model_pointer.weight.shape == pretrained_weight.shape
), <span class="hljs-string">f&quot;Pointer shape of random weight <span class="hljs-subst">{model_pointer.shape}</span> and array shape of checkpoint weight <span class="hljs-subst">{pretrained_weight.shape}</span> mismatched&quot;</span>`,wrap:!1}}),Bt=new f({props:{code:"bG9nZ2VyLmluZm8oZiUyMkluaXRpYWxpemUlMjBQeVRvcmNoJTIwd2VpZ2h0JTIwJTdCbGF5ZXJfbmFtZSU3RCUyMGZyb20lMjAlN0JwcmV0cmFpbmVkX3dlaWdodC5uYW1lJTdEJTIyKQ==",highlighted:'logger.info(<span class="hljs-string">f&quot;Initialize PyTorch weight <span class="hljs-subst">{layer_name}</span> from <span class="hljs-subst">{pretrained_weight.name}</span>&quot;</span>)',wrap:!1}}),Rt=new f({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMiUyRnBhdGglMkZ0byUyRmNvbnZlcnRlZCUyRmNoZWNrcG9pbnQlMkZmb2xkZXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)',wrap:!1}}),Gt=new f({props:{code:"bW9kZWwlMjAlM0QlMjBCcmFuZE5ld0JlcnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyJTJGcGF0aCUyRnRvJTJGY29udmVydGVkJTJGY2hlY2twb2ludCUyRmZvbGRlciUyMiklMEFpbnB1dF9pZHMlMjAlM0QlMjAlNUIwJTJDJTIwNCUyQyUyMDQlMkMlMjAzJTJDJTIwMiUyQyUyMDQlMkMlMjAxJTJDJTIwNyUyQyUyMDE5JTVEJTBBb3V0cHV0JTIwJTNEJTIwbW9kZWwoaW5wdXRfaWRzKS5sYXN0X2hpZGRlbl9zdGF0ZXM=",highlighted:`model = BrandNewBertModel.from_pretrained(<span class="hljs-string">&quot;/path/to/converted/checkpoint/folder&quot;</span>)
input_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">4</span>, <span class="hljs-number">4</span>, <span class="hljs-number">3</span>, <span class="hljs-number">2</span>, <span class="hljs-number">4</span>, <span class="hljs-number">1</span>, <span class="hljs-number">7</span>, <span class="hljs-number">19</span>]
output = model(input_ids).last_hidden_states`,wrap:!1}}),ei=new f({props:{code:"cHl0ZXN0JTIwdGVzdHMlMkZ0ZXN0X21vZGVsaW5nX2JyYW5kX25ld19iZXJ0LnB5",highlighted:"pytest tests/test_modeling_brand_new_bert.py",wrap:!1}}),ni=new f({props:{code:"UlVOX1NMT1clM0QxJTIwcHl0ZXN0JTIwLXN2JTIwdGVzdHMlMkZ0ZXN0X21vZGVsaW5nX2JyYW5kX25ld19iZXJ0LnB5JTNBJTNBQnJhbmROZXdCZXJ0TW9kZWxJbnRlZ3JhdGlvblRlc3Rz",highlighted:"RUN_SLOW=1 pytest -sv tests/test_modeling_brand_new_bert.py::BrandNewBertModelIntegrationTests",wrap:!1}}),_=new tp({props:{$$slots:{default:[lp]},$$scope:{ctx:qi}}}),ui=new f({props:{code:"aW5wdXRfc3RyJTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYSUyMGxvbmclMjBleGFtcGxlJTIwaW5wdXQlMjBzdHJpbmclMjBjb250YWluaW5nJTIwc3BlY2lhbCUyMGNoYXJhY3RlcnMlMjAuJTI0JTNGLSUyQyUyMG51bWJlcnMlMjAyODcyJTIwMjM0JTIwMTIlMjBhbmQlMjB3b3Jkcy4lMjIlMEFtb2RlbCUyMCUzRCUyMEJyYW5kTmV3QmVydE1vZGVsLmxvYWRfcHJldHJhaW5lZF9jaGVja3BvaW50KCUyMiUyRnBhdGglMkZ0byUyRmNoZWNrcG9pbnQlMkYlMjIpJTBBaW5wdXRfaWRzJTIwJTNEJTIwbW9kZWwudG9rZW5pemUoaW5wdXRfc3RyKQ==",highlighted:`input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>
model = BrandNewBertModel.load_pretrained_checkpoint(<span class="hljs-string">&quot;/path/to/checkpoint/&quot;</span>)
input_ids = model.tokenize(input_str)`,wrap:!1}}),di=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJyYW5kTmV3QmVydFRva2VuaXplciUwQSUwQWlucHV0X3N0ciUyMCUzRCUyMCUyMlRoaXMlMjBpcyUyMGElMjBsb25nJTIwZXhhbXBsZSUyMGlucHV0JTIwc3RyaW5nJTIwY29udGFpbmluZyUyMHNwZWNpYWwlMjBjaGFyYWN0ZXJzJTIwLiUyNCUzRi0lMkMlMjBudW1iZXJzJTIwMjg3MiUyMDIzNCUyMDEyJTIwYW5kJTIwd29yZHMuJTIyJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQnJhbmROZXdCZXJ0VG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjIlMkZwYXRoJTJGdG8lMkZ0b2tlbml6ZXIlMkZmb2xkZXIlMkYlMjIpJTBBJTBBaW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cikuaW5wdXRfaWRz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BrandNewBertTokenizer

input_str = <span class="hljs-string">&quot;This is a long example input string containing special characters .$?-, numbers 2872 234 12 and words.&quot;</span>

tokenizer = BrandNewBertTokenizer.from_pretrained(<span class="hljs-string">&quot;/path/to/tokenizer/folder/&quot;</span>)

input_ids = tokenizer(input_str).input_ids`,wrap:!1}}),Ji=new f({props:{code:"bWFrZSUyMHN0eWxl",highlighted:"make style",wrap:!1}}),ji=new f({props:{code:"bWFrZSUyMHF1YWxpdHk=",highlighted:"make quality",wrap:!1}}),zi=new f({props:{code:"YnJhbmRfbmV3X2JlcnQucHVzaF90b19odWIoJTBBJTIwJTIwJTIwJTIwcmVwb19wYXRoX29yX25hbWUlM0QlMjJicmFuZF9uZXdfYmVydCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMyUyMFVuY29tbWVudCUyMHRoZSUyMGZvbGxvd2luZyUyMGxpbmUlMjB0byUyMHB1c2glMjB0byUyMGFuJTIwb3JnYW5pemF0aW9uJTBBJTIwJTIwJTIwJTIwJTIzJTIwb3JnYW5pemF0aW9uJTNEJTIyJTNDT1JHQU5JWkFUSU9OJTNFJTIyJTJDJTBBJTIwJTIwJTIwJTIwY29tbWl0X21lc3NhZ2UlM0QlMjJBZGQlMjBtb2RlbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHVzZV90ZW1wX2RpciUzRFRydWUlMkMlMEEp",highlighted:`brand_new_bert.push_to_hub(
    repo_path_or_name=<span class="hljs-string">&quot;brand_new_bert&quot;</span>,
    <span class="hljs-comment"># Uncomment the following line to push to an organization</span>
    <span class="hljs-comment"># organization=&quot;&lt;ORGANIZATION&gt;&quot;,</span>
    commit_message=<span class="hljs-string">&quot;Add model&quot;</span>,
    use_temp_dir=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),Pi=new v({props:{title:"Condividete il vostro lavoro!!",local:"condividete-il-vostro-lavoro",headingTag:"h3"}}),Qi=new ip({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/it/add_new_model.md"}}),{c(){g=a("meta"),$=n(),T=a("p"),Wi=n(),p(I.$$.fragment),Ei=n(),L=a("p"),L.innerHTML=fa,Gi=n(),z=a("p"),z.innerHTML=ga,Si=n(),k=a("p"),k.textContent=Ta,Vi=n(),x=a("ul"),x.innerHTML=va,Xi=n(),A=a("p"),A.innerHTML=wa,Yi=n(),H=a("p"),H.textContent=ba,Fi=n(),p(N.$$.fragment),Oi=n(),P=a("p"),P.textContent=ya,Ki=n(),B=a("p"),B.innerHTML=ha,el=n(),Z=a("ul"),Z.innerHTML=Ja,tl=n(),Q=a("p"),Q.innerHTML=Ca,il=n(),W=a("p"),W.textContent=ja,ll=n(),p(D.$$.fragment),nl=n(),R=a("p"),R.innerHTML=Ua,ol=n(),q=a("p"),q.textContent=_a,al=n(),Di=a("img"),rl=n(),E=a("p"),E.innerHTML=Ia,sl=n(),p(G.$$.fragment),pl=n(),S=a("p"),S.innerHTML=La,ml=n(),p(V.$$.fragment),ul=n(),X=a("p"),X.textContent=za,cl=n(),Y=a("ol"),Y.innerHTML=ka,dl=n(),p(F.$$.fragment),Ml=n(),O=a("p"),O.textContent=xa,fl=n(),p(K.$$.fragment),gl=n(),ee=a("p"),ee.textContent=Aa,Tl=n(),te=a("ol"),te.innerHTML=Ha,vl=n(),ie=a("p"),ie.textContent=Na,wl=n(),le=a("ul"),le.innerHTML=Pa,bl=n(),ne=a("p"),ne.textContent=Ba,yl=n(),oe=a("p"),oe.textContent=Za,hl=n(),ae=a("ul"),ae.innerHTML=Qa,Jl=n(),re=a("p"),re.innerHTML=Wa,Cl=n(),p(se.$$.fragment),jl=n(),pe=a("p"),pe.innerHTML=Da,Ul=n(),me=a("ul"),me.innerHTML=Ra,_l=n(),ue=a("p"),ue.textContent=qa,$l=n(),p(ce.$$.fragment),Il=n(),de=a("ol"),de.innerHTML=Ea,Ll=n(),p(Me.$$.fragment),zl=n(),b=a("ol"),b.innerHTML=Ga,kl=n(),p(fe.$$.fragment),xl=n(),ge=a("p"),ge.textContent=Sa,Al=n(),p(Te.$$.fragment),Hl=n(),y=a("ol"),y.innerHTML=Va,Nl=n(),ve=a("p"),ve.innerHTML=Xa,Pl=n(),h=a("ol"),h.innerHTML=Ya,Bl=n(),p(we.$$.fragment),Zl=n(),be=a("p"),be.innerHTML=Fa,Ql=n(),p(ye.$$.fragment),Wl=n(),he=a("p"),he.innerHTML=Oa,Dl=n(),Je=a("p"),Je.innerHTML=Ka,Rl=n(),Ce=a("ul"),Ce.innerHTML=er,ql=n(),je=a("p"),je.innerHTML=tr,El=n(),Ue=a("p"),Ue.textContent=ir,Gl=n(),_e=a("p"),_e.textContent=lr,Sl=n(),$e=a("ul"),$e.innerHTML=nr,Vl=n(),Ie=a("p"),Ie.textContent=or,Xl=n(),Le=a("p"),Le.innerHTML=ar,Yl=n(),ze=a("p"),ze.innerHTML=rr,Fl=n(),p(ke.$$.fragment),Ol=n(),xe=a("p"),xe.textContent=sr,Kl=n(),Ae=a("ul"),Ae.innerHTML=pr,en=n(),He=a("p"),He.textContent=mr,tn=n(),Ne=a("p"),Ne.innerHTML=ur,ln=n(),Pe=a("ul"),Pe.innerHTML=cr,nn=n(),Be=a("p"),Be.innerHTML=dr,on=n(),Ze=a("p"),Ze.innerHTML=Mr,an=n(),Qe=a("p"),Qe.textContent=fr,rn=n(),We=a("ol"),We.innerHTML=gr,sn=n(),De=a("p"),De.innerHTML=Tr,pn=n(),Re=a("p"),Re.textContent=vr,mn=n(),p(qe.$$.fragment),un=n(),Ee=a("p"),Ee.innerHTML=wr,cn=n(),Ge=a("ul"),Ge.innerHTML=br,dn=n(),Se=a("p"),Se.innerHTML=yr,Mn=n(),p(Ve.$$.fragment),fn=n(),Xe=a("p"),Xe.textContent=hr,gn=n(),p(Ye.$$.fragment),Tn=n(),Fe=a("p"),Fe.innerHTML=Jr,vn=n(),Oe=a("p"),Oe.textContent=Cr,wn=n(),p(Ke.$$.fragment),bn=n(),et=a("p"),et.textContent=jr,yn=n(),tt=a("p"),tt.innerHTML=Ur,hn=n(),it=a("p"),it.innerHTML=_r,Jn=n(),lt=a("p"),lt.textContent=$r,Cn=n(),nt=a("ol"),nt.innerHTML=Ir,jn=n(),p(ot.$$.fragment),Un=n(),J=a("ol"),J.innerHTML=Lr,_n=n(),p(at.$$.fragment),$n=n(),C=a("ol"),C.innerHTML=zr,In=n(),p(rt.$$.fragment),Ln=n(),j=a("ol"),j.innerHTML=kr,zn=n(),p(st.$$.fragment),kn=n(),U=a("ol"),U.innerHTML=xr,xn=n(),pt=a("p"),pt.textContent=Ar,An=n(),p(mt.$$.fragment),Hn=n(),ut=a("p"),ut.textContent=Hr,Nn=n(),ct=a("p"),ct.textContent=Nr,Pn=n(),dt=a("p"),dt.textContent=Pr,Bn=n(),Mt=a("p"),Mt.innerHTML=Br,Zn=n(),ft=a("p"),ft.innerHTML=Zr,Qn=n(),gt=a("p"),gt.innerHTML=Qr,Wn=n(),Tt=a("p"),Tt.innerHTML=Wr,Dn=n(),p(vt.$$.fragment),Rn=n(),wt=a("p"),wt.innerHTML=Dr,qn=n(),bt=a("p"),bt.innerHTML=Rr,En=n(),yt=a("p"),yt.innerHTML=qr,Gn=n(),ht=a("ul"),ht.innerHTML=Er,Sn=n(),Jt=a("p"),Jt.innerHTML=Gr,Vn=n(),p(Ct.$$.fragment),Xn=n(),jt=a("p"),jt.innerHTML=Sr,Yn=n(),p(Ut.$$.fragment),Fn=n(),_t=a("p"),_t.textContent=Vr,On=n(),p($t.$$.fragment),Kn=n(),It=a("p"),It.textContent=Xr,eo=n(),p(Lt.$$.fragment),to=n(),zt=a("p"),zt.textContent=Yr,io=n(),p(kt.$$.fragment),lo=n(),xt=a("p"),xt.innerHTML=Fr,no=n(),p(At.$$.fragment),oo=n(),Ht=a("p"),Ht.innerHTML=Or,ao=n(),p(Nt.$$.fragment),ro=n(),Pt=a("p"),Pt.textContent=Kr,so=n(),p(Bt.$$.fragment),po=n(),Zt=a("p"),Zt.textContent=es,mo=n(),Qt=a("p"),Qt.innerHTML=ts,uo=n(),Wt=a("p"),Wt.innerHTML=is,co=n(),Dt=a("p"),Dt.innerHTML=ls,Mo=n(),p(Rt.$$.fragment),fo=n(),qt=a("p"),qt.innerHTML=ns,go=n(),Et=a("p"),Et.innerHTML=os,To=n(),p(Gt.$$.fragment),vo=n(),St=a("p"),St.innerHTML=as,wo=n(),Vt=a("p"),Vt.innerHTML=rs,bo=n(),Xt=a("ul"),Xt.innerHTML=ss,yo=n(),Yt=a("p"),Yt.innerHTML=ps,ho=n(),Ft=a("p"),Ft.innerHTML=ms,Jo=n(),Ot=a("p"),Ot.innerHTML=us,Co=n(),Kt=a("p"),Kt.innerHTML=cs,jo=n(),p(ei.$$.fragment),Uo=n(),ti=a("p"),ti.textContent=ds,_o=n(),ii=a("ul"),ii.innerHTML=Ms,$o=n(),li=a("p"),li.innerHTML=fs,Io=n(),p(ni.$$.fragment),Lo=n(),p(_.$$.fragment),zo=n(),oi=a("p"),oi.innerHTML=gs,ko=n(),ai=a("ul"),ai.innerHTML=Ts,xo=n(),ri=a("p"),ri.innerHTML=vs,Ao=n(),si=a("p"),si.innerHTML=ws,Ho=n(),pi=a("p"),pi.textContent=bs,No=n(),mi=a("p"),mi.innerHTML=ys,Po=n(),p(ui.$$.fragment),Bo=n(),ci=a("p"),ci.innerHTML=hs,Zo=n(),p(di.$$.fragment),Qo=n(),Mi=a("p"),Mi.innerHTML=Js,Wo=n(),fi=a("p"),fi.innerHTML=Cs,Do=n(),gi=a("p"),gi.innerHTML=js,Ro=n(),Ti=a("p"),Ti.innerHTML=Us,qo=n(),vi=a("p"),vi.innerHTML=_s,Eo=n(),wi=a("p"),wi.innerHTML=$s,Go=n(),bi=a("p"),bi.innerHTML=Is,So=n(),yi=a("p"),yi.innerHTML=Ls,Vo=n(),hi=a("p"),hi.innerHTML=zs,Xo=n(),p(Ji.$$.fragment),Yo=n(),Ci=a("p"),Ci.textContent=ks,Fo=n(),p(ji.$$.fragment),Oo=n(),Ui=a("p"),Ui.textContent=xs,Ko=n(),_i=a("p"),_i.textContent=As,ea=n(),$i=a("p"),$i.textContent=Hs,ta=n(),Ii=a("p"),Ii.innerHTML=Ns,ia=n(),Li=a("p"),Li.innerHTML=Ps,la=n(),p(zi.$$.fragment),na=n(),ki=a("p"),ki.innerHTML=Bs,oa=n(),xi=a("p"),xi.innerHTML=Zs,aa=n(),Ai=a("p"),Ai.innerHTML=Qs,ra=n(),Hi=a("p"),Hi.innerHTML=Ws,sa=n(),Ni=a("p"),Ni.textContent=Ds,pa=n(),p(Pi.$$.fragment),ma=n(),Bi=a("p"),Bi.textContent=Rs,ua=n(),Zi=a("p"),Zi.innerHTML=qs,ca=n(),p(Qi.$$.fragment),da=n(),Ri=a("p"),this.h()},l(e){const t=Ks("svelte-u9bgzb",document.head);g=r(t,"META",{name:!0,content:!0}),t.forEach(i),$=o(e),T=r(e,"P",{}),Gs(T).forEach(i),Wi=o(e),m(I.$$.fragment,e),Ei=o(e),L=r(e,"P",{"data-svelte-h":!0}),s(L)!=="svelte-mcybxm"&&(L.innerHTML=fa),Gi=o(e),z=r(e,"P",{"data-svelte-h":!0}),s(z)!=="svelte-9ts9yv"&&(z.innerHTML=ga),Si=o(e),k=r(e,"P",{"data-svelte-h":!0}),s(k)!=="svelte-nuipgt"&&(k.textContent=Ta),Vi=o(e),x=r(e,"UL",{"data-svelte-h":!0}),s(x)!=="svelte-17yu4g1"&&(x.innerHTML=va),Xi=o(e),A=r(e,"P",{"data-svelte-h":!0}),s(A)!=="svelte-1ef71gf"&&(A.innerHTML=wa),Yi=o(e),H=r(e,"P",{"data-svelte-h":!0}),s(H)!=="svelte-1hjdlgn"&&(H.textContent=ba),Fi=o(e),m(N.$$.fragment,e),Oi=o(e),P=r(e,"P",{"data-svelte-h":!0}),s(P)!=="svelte-qfc25e"&&(P.textContent=ya),Ki=o(e),B=r(e,"P",{"data-svelte-h":!0}),s(B)!=="svelte-1uhsu9n"&&(B.innerHTML=ha),el=o(e),Z=r(e,"UL",{"data-svelte-h":!0}),s(Z)!=="svelte-1puf5lg"&&(Z.innerHTML=Ja),tl=o(e),Q=r(e,"P",{"data-svelte-h":!0}),s(Q)!=="svelte-fh5e7z"&&(Q.innerHTML=Ca),il=o(e),W=r(e,"P",{"data-svelte-h":!0}),s(W)!=="svelte-1or0tgf"&&(W.textContent=ja),ll=o(e),m(D.$$.fragment,e),nl=o(e),R=r(e,"P",{"data-svelte-h":!0}),s(R)!=="svelte-1cok100"&&(R.innerHTML=Ua),ol=o(e),q=r(e,"P",{"data-svelte-h":!0}),s(q)!=="svelte-1kc404e"&&(q.textContent=_a),al=o(e),Di=r(e,"IMG",{src:!0}),rl=o(e),E=r(e,"P",{"data-svelte-h":!0}),s(E)!=="svelte-15z3m1e"&&(E.innerHTML=Ia),sl=o(e),m(G.$$.fragment,e),pl=o(e),S=r(e,"P",{"data-svelte-h":!0}),s(S)!=="svelte-19tom7d"&&(S.innerHTML=La),ml=o(e),m(V.$$.fragment,e),ul=o(e),X=r(e,"P",{"data-svelte-h":!0}),s(X)!=="svelte-1e0x1j9"&&(X.textContent=za),cl=o(e),Y=r(e,"OL",{"data-svelte-h":!0}),s(Y)!=="svelte-1ace5kx"&&(Y.innerHTML=ka),dl=o(e),m(F.$$.fragment,e),Ml=o(e),O=r(e,"P",{"data-svelte-h":!0}),s(O)!=="svelte-1h3mdlf"&&(O.textContent=xa),fl=o(e),m(K.$$.fragment,e),gl=o(e),ee=r(e,"P",{"data-svelte-h":!0}),s(ee)!=="svelte-1kdxkf0"&&(ee.textContent=Aa),Tl=o(e),te=r(e,"OL",{"data-svelte-h":!0}),s(te)!=="svelte-kjaxqe"&&(te.innerHTML=Ha),vl=o(e),ie=r(e,"P",{"data-svelte-h":!0}),s(ie)!=="svelte-l6ux6x"&&(ie.textContent=Na),wl=o(e),le=r(e,"UL",{"data-svelte-h":!0}),s(le)!=="svelte-hnqwmd"&&(le.innerHTML=Pa),bl=o(e),ne=r(e,"P",{"data-svelte-h":!0}),s(ne)!=="svelte-6fjf2p"&&(ne.textContent=Ba),yl=o(e),oe=r(e,"P",{"data-svelte-h":!0}),s(oe)!=="svelte-1a0cf88"&&(oe.textContent=Za),hl=o(e),ae=r(e,"UL",{"data-svelte-h":!0}),s(ae)!=="svelte-5m17l4"&&(ae.innerHTML=Qa),Jl=o(e),re=r(e,"P",{"data-svelte-h":!0}),s(re)!=="svelte-zoos1q"&&(re.innerHTML=Wa),Cl=o(e),m(se.$$.fragment,e),jl=o(e),pe=r(e,"P",{"data-svelte-h":!0}),s(pe)!=="svelte-1i01ztv"&&(pe.innerHTML=Da),Ul=o(e),me=r(e,"UL",{"data-svelte-h":!0}),s(me)!=="svelte-90esjr"&&(me.innerHTML=Ra),_l=o(e),ue=r(e,"P",{"data-svelte-h":!0}),s(ue)!=="svelte-18zhrxf"&&(ue.textContent=qa),$l=o(e),m(ce.$$.fragment,e),Il=o(e),de=r(e,"OL",{"data-svelte-h":!0}),s(de)!=="svelte-xvspap"&&(de.innerHTML=Ea),Ll=o(e),m(Me.$$.fragment,e),zl=o(e),b=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(b)!=="svelte-1evkptw"&&(b.innerHTML=Ga),kl=o(e),m(fe.$$.fragment,e),xl=o(e),ge=r(e,"P",{"data-svelte-h":!0}),s(ge)!=="svelte-14ww8ay"&&(ge.textContent=Sa),Al=o(e),m(Te.$$.fragment,e),Hl=o(e),y=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(y)!=="svelte-1flpp1p"&&(y.innerHTML=Va),Nl=o(e),ve=r(e,"P",{"data-svelte-h":!0}),s(ve)!=="svelte-ktjdn9"&&(ve.innerHTML=Xa),Pl=o(e),h=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(h)!=="svelte-1ksg1jw"&&(h.innerHTML=Ya),Bl=o(e),m(we.$$.fragment,e),Zl=o(e),be=r(e,"P",{"data-svelte-h":!0}),s(be)!=="svelte-dbtpxy"&&(be.innerHTML=Fa),Ql=o(e),m(ye.$$.fragment,e),Wl=o(e),he=r(e,"P",{"data-svelte-h":!0}),s(he)!=="svelte-pccy98"&&(he.innerHTML=Oa),Dl=o(e),Je=r(e,"P",{"data-svelte-h":!0}),s(Je)!=="svelte-110j2za"&&(Je.innerHTML=Ka),Rl=o(e),Ce=r(e,"UL",{"data-svelte-h":!0}),s(Ce)!=="svelte-14yin4"&&(Ce.innerHTML=er),ql=o(e),je=r(e,"P",{"data-svelte-h":!0}),s(je)!=="svelte-1i7tk"&&(je.innerHTML=tr),El=o(e),Ue=r(e,"P",{"data-svelte-h":!0}),s(Ue)!=="svelte-1fqyo7q"&&(Ue.textContent=ir),Gl=o(e),_e=r(e,"P",{"data-svelte-h":!0}),s(_e)!=="svelte-krk2b7"&&(_e.textContent=lr),Sl=o(e),$e=r(e,"UL",{"data-svelte-h":!0}),s($e)!=="svelte-2qjq9v"&&($e.innerHTML=nr),Vl=o(e),Ie=r(e,"P",{"data-svelte-h":!0}),s(Ie)!=="svelte-svralj"&&(Ie.textContent=or),Xl=o(e),Le=r(e,"P",{"data-svelte-h":!0}),s(Le)!=="svelte-wadtlg"&&(Le.innerHTML=ar),Yl=o(e),ze=r(e,"P",{"data-svelte-h":!0}),s(ze)!=="svelte-cjwu38"&&(ze.innerHTML=rr),Fl=o(e),m(ke.$$.fragment,e),Ol=o(e),xe=r(e,"P",{"data-svelte-h":!0}),s(xe)!=="svelte-1i7fntd"&&(xe.textContent=sr),Kl=o(e),Ae=r(e,"UL",{"data-svelte-h":!0}),s(Ae)!=="svelte-1wtxllt"&&(Ae.innerHTML=pr),en=o(e),He=r(e,"P",{"data-svelte-h":!0}),s(He)!=="svelte-5ialh3"&&(He.textContent=mr),tn=o(e),Ne=r(e,"P",{"data-svelte-h":!0}),s(Ne)!=="svelte-1biel3r"&&(Ne.innerHTML=ur),ln=o(e),Pe=r(e,"UL",{"data-svelte-h":!0}),s(Pe)!=="svelte-1c4mra6"&&(Pe.innerHTML=cr),nn=o(e),Be=r(e,"P",{"data-svelte-h":!0}),s(Be)!=="svelte-dngyoh"&&(Be.innerHTML=dr),on=o(e),Ze=r(e,"P",{"data-svelte-h":!0}),s(Ze)!=="svelte-kg6we1"&&(Ze.innerHTML=Mr),an=o(e),Qe=r(e,"P",{"data-svelte-h":!0}),s(Qe)!=="svelte-ebp8u2"&&(Qe.textContent=fr),rn=o(e),We=r(e,"OL",{"data-svelte-h":!0}),s(We)!=="svelte-hc2e50"&&(We.innerHTML=gr),sn=o(e),De=r(e,"P",{"data-svelte-h":!0}),s(De)!=="svelte-cnfp5i"&&(De.innerHTML=Tr),pn=o(e),Re=r(e,"P",{"data-svelte-h":!0}),s(Re)!=="svelte-wlz2de"&&(Re.textContent=vr),mn=o(e),m(qe.$$.fragment,e),un=o(e),Ee=r(e,"P",{"data-svelte-h":!0}),s(Ee)!=="svelte-1icu6e6"&&(Ee.innerHTML=wr),cn=o(e),Ge=r(e,"UL",{"data-svelte-h":!0}),s(Ge)!=="svelte-15nnjpb"&&(Ge.innerHTML=br),dn=o(e),Se=r(e,"P",{"data-svelte-h":!0}),s(Se)!=="svelte-q1g4tr"&&(Se.innerHTML=yr),Mn=o(e),m(Ve.$$.fragment,e),fn=o(e),Xe=r(e,"P",{"data-svelte-h":!0}),s(Xe)!=="svelte-y19szg"&&(Xe.textContent=hr),gn=o(e),m(Ye.$$.fragment,e),Tn=o(e),Fe=r(e,"P",{"data-svelte-h":!0}),s(Fe)!=="svelte-1c5tp6d"&&(Fe.innerHTML=Jr),vn=o(e),Oe=r(e,"P",{"data-svelte-h":!0}),s(Oe)!=="svelte-18b7wmt"&&(Oe.textContent=Cr),wn=o(e),m(Ke.$$.fragment,e),bn=o(e),et=r(e,"P",{"data-svelte-h":!0}),s(et)!=="svelte-qx0ep0"&&(et.textContent=jr),yn=o(e),tt=r(e,"P",{"data-svelte-h":!0}),s(tt)!=="svelte-1lp0v27"&&(tt.innerHTML=Ur),hn=o(e),it=r(e,"P",{"data-svelte-h":!0}),s(it)!=="svelte-1l49660"&&(it.innerHTML=_r),Jn=o(e),lt=r(e,"P",{"data-svelte-h":!0}),s(lt)!=="svelte-susl50"&&(lt.textContent=$r),Cn=o(e),nt=r(e,"OL",{"data-svelte-h":!0}),s(nt)!=="svelte-9f7n4c"&&(nt.innerHTML=Ir),jn=o(e),m(ot.$$.fragment,e),Un=o(e),J=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(J)!=="svelte-1ydvjat"&&(J.innerHTML=Lr),_n=o(e),m(at.$$.fragment,e),$n=o(e),C=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(C)!=="svelte-1a8qrdq"&&(C.innerHTML=zr),In=o(e),m(rt.$$.fragment,e),Ln=o(e),j=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(j)!=="svelte-1p0h4w7"&&(j.innerHTML=kr),zn=o(e),m(st.$$.fragment,e),kn=o(e),U=r(e,"OL",{start:!0,"data-svelte-h":!0}),s(U)!=="svelte-1i1yvuz"&&(U.innerHTML=xr),xn=o(e),pt=r(e,"P",{"data-svelte-h":!0}),s(pt)!=="svelte-1j3sibr"&&(pt.textContent=Ar),An=o(e),m(mt.$$.fragment,e),Hn=o(e),ut=r(e,"P",{"data-svelte-h":!0}),s(ut)!=="svelte-18t1ykc"&&(ut.textContent=Hr),Nn=o(e),ct=r(e,"P",{"data-svelte-h":!0}),s(ct)!=="svelte-dewsnv"&&(ct.textContent=Nr),Pn=o(e),dt=r(e,"P",{"data-svelte-h":!0}),s(dt)!=="svelte-iueh1s"&&(dt.textContent=Pr),Bn=o(e),Mt=r(e,"P",{"data-svelte-h":!0}),s(Mt)!=="svelte-13yidk9"&&(Mt.innerHTML=Br),Zn=o(e),ft=r(e,"P",{"data-svelte-h":!0}),s(ft)!=="svelte-tnudua"&&(ft.innerHTML=Zr),Qn=o(e),gt=r(e,"P",{"data-svelte-h":!0}),s(gt)!=="svelte-cfg2q9"&&(gt.innerHTML=Qr),Wn=o(e),Tt=r(e,"P",{"data-svelte-h":!0}),s(Tt)!=="svelte-ssk34n"&&(Tt.innerHTML=Wr),Dn=o(e),m(vt.$$.fragment,e),Rn=o(e),wt=r(e,"P",{"data-svelte-h":!0}),s(wt)!=="svelte-w8emzm"&&(wt.innerHTML=Dr),qn=o(e),bt=r(e,"P",{"data-svelte-h":!0}),s(bt)!=="svelte-cjyudz"&&(bt.innerHTML=Rr),En=o(e),yt=r(e,"P",{"data-svelte-h":!0}),s(yt)!=="svelte-10j71zn"&&(yt.innerHTML=qr),Gn=o(e),ht=r(e,"UL",{"data-svelte-h":!0}),s(ht)!=="svelte-1vpn2ms"&&(ht.innerHTML=Er),Sn=o(e),Jt=r(e,"P",{"data-svelte-h":!0}),s(Jt)!=="svelte-gmncyo"&&(Jt.innerHTML=Gr),Vn=o(e),m(Ct.$$.fragment,e),Xn=o(e),jt=r(e,"P",{"data-svelte-h":!0}),s(jt)!=="svelte-zfbl8p"&&(jt.innerHTML=Sr),Yn=o(e),m(Ut.$$.fragment,e),Fn=o(e),_t=r(e,"P",{"data-svelte-h":!0}),s(_t)!=="svelte-bxzo98"&&(_t.textContent=Vr),On=o(e),m($t.$$.fragment,e),Kn=o(e),It=r(e,"P",{"data-svelte-h":!0}),s(It)!=="svelte-msvb9t"&&(It.textContent=Xr),eo=o(e),m(Lt.$$.fragment,e),to=o(e),zt=r(e,"P",{"data-svelte-h":!0}),s(zt)!=="svelte-1t1y1q3"&&(zt.textContent=Yr),io=o(e),m(kt.$$.fragment,e),lo=o(e),xt=r(e,"P",{"data-svelte-h":!0}),s(xt)!=="svelte-2gi4z2"&&(xt.innerHTML=Fr),no=o(e),m(At.$$.fragment,e),oo=o(e),Ht=r(e,"P",{"data-svelte-h":!0}),s(Ht)!=="svelte-17998hi"&&(Ht.innerHTML=Or),ao=o(e),m(Nt.$$.fragment,e),ro=o(e),Pt=r(e,"P",{"data-svelte-h":!0}),s(Pt)!=="svelte-1lzjagf"&&(Pt.textContent=Kr),so=o(e),m(Bt.$$.fragment,e),po=o(e),Zt=r(e,"P",{"data-svelte-h":!0}),s(Zt)!=="svelte-1e4mgvb"&&(Zt.textContent=es),mo=o(e),Qt=r(e,"P",{"data-svelte-h":!0}),s(Qt)!=="svelte-u8slxf"&&(Qt.innerHTML=ts),uo=o(e),Wt=r(e,"P",{"data-svelte-h":!0}),s(Wt)!=="svelte-16755ai"&&(Wt.innerHTML=is),co=o(e),Dt=r(e,"P",{"data-svelte-h":!0}),s(Dt)!=="svelte-1t5012"&&(Dt.innerHTML=ls),Mo=o(e),m(Rt.$$.fragment,e),fo=o(e),qt=r(e,"P",{"data-svelte-h":!0}),s(qt)!=="svelte-9hyeti"&&(qt.innerHTML=ns),go=o(e),Et=r(e,"P",{"data-svelte-h":!0}),s(Et)!=="svelte-a6i2ni"&&(Et.innerHTML=os),To=o(e),m(Gt.$$.fragment,e),vo=o(e),St=r(e,"P",{"data-svelte-h":!0}),s(St)!=="svelte-6sq3ph"&&(St.innerHTML=as),wo=o(e),Vt=r(e,"P",{"data-svelte-h":!0}),s(Vt)!=="svelte-13khp56"&&(Vt.innerHTML=rs),bo=o(e),Xt=r(e,"UL",{"data-svelte-h":!0}),s(Xt)!=="svelte-1uf5pl4"&&(Xt.innerHTML=ss),yo=o(e),Yt=r(e,"P",{"data-svelte-h":!0}),s(Yt)!=="svelte-rbs4en"&&(Yt.innerHTML=ps),ho=o(e),Ft=r(e,"P",{"data-svelte-h":!0}),s(Ft)!=="svelte-1wms3g3"&&(Ft.innerHTML=ms),Jo=o(e),Ot=r(e,"P",{"data-svelte-h":!0}),s(Ot)!=="svelte-i0maob"&&(Ot.innerHTML=us),Co=o(e),Kt=r(e,"P",{"data-svelte-h":!0}),s(Kt)!=="svelte-1c7vfm0"&&(Kt.innerHTML=cs),jo=o(e),m(ei.$$.fragment,e),Uo=o(e),ti=r(e,"P",{"data-svelte-h":!0}),s(ti)!=="svelte-8sms8k"&&(ti.textContent=ds),_o=o(e),ii=r(e,"UL",{"data-svelte-h":!0}),s(ii)!=="svelte-1utz3yu"&&(ii.innerHTML=Ms),$o=o(e),li=r(e,"P",{"data-svelte-h":!0}),s(li)!=="svelte-1xufcow"&&(li.innerHTML=fs),Io=o(e),m(ni.$$.fragment,e),Lo=o(e),m(_.$$.fragment,e),zo=o(e),oi=r(e,"P",{"data-svelte-h":!0}),s(oi)!=="svelte-1dvwjty"&&(oi.innerHTML=gs),ko=o(e),ai=r(e,"UL",{"data-svelte-h":!0}),s(ai)!=="svelte-vlkyi5"&&(ai.innerHTML=Ts),xo=o(e),ri=r(e,"P",{"data-svelte-h":!0}),s(ri)!=="svelte-ngul8x"&&(ri.innerHTML=vs),Ao=o(e),si=r(e,"P",{"data-svelte-h":!0}),s(si)!=="svelte-ytxoz9"&&(si.innerHTML=ws),Ho=o(e),pi=r(e,"P",{"data-svelte-h":!0}),s(pi)!=="svelte-sdkk44"&&(pi.textContent=bs),No=o(e),mi=r(e,"P",{"data-svelte-h":!0}),s(mi)!=="svelte-ohw0y7"&&(mi.innerHTML=ys),Po=o(e),m(ui.$$.fragment,e),Bo=o(e),ci=r(e,"P",{"data-svelte-h":!0}),s(ci)!=="svelte-1yo29jy"&&(ci.innerHTML=hs),Zo=o(e),m(di.$$.fragment,e),Qo=o(e),Mi=r(e,"P",{"data-svelte-h":!0}),s(Mi)!=="svelte-1cy3z2f"&&(Mi.innerHTML=Js),Wo=o(e),fi=r(e,"P",{"data-svelte-h":!0}),s(fi)!=="svelte-1xqbzg9"&&(fi.innerHTML=Cs),Do=o(e),gi=r(e,"P",{"data-svelte-h":!0}),s(gi)!=="svelte-1yq64p9"&&(gi.innerHTML=js),Ro=o(e),Ti=r(e,"P",{"data-svelte-h":!0}),s(Ti)!=="svelte-5d40ir"&&(Ti.innerHTML=Us),qo=o(e),vi=r(e,"P",{"data-svelte-h":!0}),s(vi)!=="svelte-1eolzno"&&(vi.innerHTML=_s),Eo=o(e),wi=r(e,"P",{"data-svelte-h":!0}),s(wi)!=="svelte-uesgh9"&&(wi.innerHTML=$s),Go=o(e),bi=r(e,"P",{"data-svelte-h":!0}),s(bi)!=="svelte-1nt2o60"&&(bi.innerHTML=Is),So=o(e),yi=r(e,"P",{"data-svelte-h":!0}),s(yi)!=="svelte-17ikozp"&&(yi.innerHTML=Ls),Vo=o(e),hi=r(e,"P",{"data-svelte-h":!0}),s(hi)!=="svelte-17h78jd"&&(hi.innerHTML=zs),Xo=o(e),m(Ji.$$.fragment,e),Yo=o(e),Ci=r(e,"P",{"data-svelte-h":!0}),s(Ci)!=="svelte-168a2an"&&(Ci.textContent=ks),Fo=o(e),m(ji.$$.fragment,e),Oo=o(e),Ui=r(e,"P",{"data-svelte-h":!0}),s(Ui)!=="svelte-14xwwuw"&&(Ui.textContent=xs),Ko=o(e),_i=r(e,"P",{"data-svelte-h":!0}),s(_i)!=="svelte-18k5kow"&&(_i.textContent=As),ea=o(e),$i=r(e,"P",{"data-svelte-h":!0}),s($i)!=="svelte-1ftaoot"&&($i.textContent=Hs),ta=o(e),Ii=r(e,"P",{"data-svelte-h":!0}),s(Ii)!=="svelte-1iv4oh1"&&(Ii.innerHTML=Ns),ia=o(e),Li=r(e,"P",{"data-svelte-h":!0}),s(Li)!=="svelte-bo6tk8"&&(Li.innerHTML=Ps),la=o(e),m(zi.$$.fragment,e),na=o(e),ki=r(e,"P",{"data-svelte-h":!0}),s(ki)!=="svelte-6hjvqd"&&(ki.innerHTML=Bs),oa=o(e),xi=r(e,"P",{"data-svelte-h":!0}),s(xi)!=="svelte-1xvbv99"&&(xi.innerHTML=Zs),aa=o(e),Ai=r(e,"P",{"data-svelte-h":!0}),s(Ai)!=="svelte-wwq3kk"&&(Ai.innerHTML=Qs),ra=o(e),Hi=r(e,"P",{"data-svelte-h":!0}),s(Hi)!=="svelte-1s6evuy"&&(Hi.innerHTML=Ws),sa=o(e),Ni=r(e,"P",{"data-svelte-h":!0}),s(Ni)!=="svelte-1d6fg3c"&&(Ni.textContent=Ds),pa=o(e),m(Pi.$$.fragment,e),ma=o(e),Bi=r(e,"P",{"data-svelte-h":!0}),s(Bi)!=="svelte-1rctjhr"&&(Bi.textContent=Rs),ua=o(e),Zi=r(e,"P",{"data-svelte-h":!0}),s(Zi)!=="svelte-1oczpay"&&(Zi.innerHTML=qs),ca=o(e),m(Qi.$$.fragment,e),da=o(e),Ri=r(e,"P",{}),Gs(Ri).forEach(i),this.h()},h(){w(g,"name","hf:doc:metadata"),w(g,"content",op),Vs(Di.src,$a="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers_overview.png")||w(Di,"src",$a),w(b,"start","3"),w(y,"start","4"),w(h,"start","5"),w(J,"start","2"),w(C,"start","3"),w(j,"start","4"),w(U,"start","5")},m(e,t){ep(document.head,g),l(e,$,t),l(e,T,t),l(e,Wi,t),u(I,e,t),l(e,Ei,t),l(e,L,t),l(e,Gi,t),l(e,z,t),l(e,Si,t),l(e,k,t),l(e,Vi,t),l(e,x,t),l(e,Xi,t),l(e,A,t),l(e,Yi,t),l(e,H,t),l(e,Fi,t),u(N,e,t),l(e,Oi,t),l(e,P,t),l(e,Ki,t),l(e,B,t),l(e,el,t),l(e,Z,t),l(e,tl,t),l(e,Q,t),l(e,il,t),l(e,W,t),l(e,ll,t),u(D,e,t),l(e,nl,t),l(e,R,t),l(e,ol,t),l(e,q,t),l(e,al,t),l(e,Di,t),l(e,rl,t),l(e,E,t),l(e,sl,t),u(G,e,t),l(e,pl,t),l(e,S,t),l(e,ml,t),u(V,e,t),l(e,ul,t),l(e,X,t),l(e,cl,t),l(e,Y,t),l(e,dl,t),u(F,e,t),l(e,Ml,t),l(e,O,t),l(e,fl,t),u(K,e,t),l(e,gl,t),l(e,ee,t),l(e,Tl,t),l(e,te,t),l(e,vl,t),l(e,ie,t),l(e,wl,t),l(e,le,t),l(e,bl,t),l(e,ne,t),l(e,yl,t),l(e,oe,t),l(e,hl,t),l(e,ae,t),l(e,Jl,t),l(e,re,t),l(e,Cl,t),u(se,e,t),l(e,jl,t),l(e,pe,t),l(e,Ul,t),l(e,me,t),l(e,_l,t),l(e,ue,t),l(e,$l,t),u(ce,e,t),l(e,Il,t),l(e,de,t),l(e,Ll,t),u(Me,e,t),l(e,zl,t),l(e,b,t),l(e,kl,t),u(fe,e,t),l(e,xl,t),l(e,ge,t),l(e,Al,t),u(Te,e,t),l(e,Hl,t),l(e,y,t),l(e,Nl,t),l(e,ve,t),l(e,Pl,t),l(e,h,t),l(e,Bl,t),u(we,e,t),l(e,Zl,t),l(e,be,t),l(e,Ql,t),u(ye,e,t),l(e,Wl,t),l(e,he,t),l(e,Dl,t),l(e,Je,t),l(e,Rl,t),l(e,Ce,t),l(e,ql,t),l(e,je,t),l(e,El,t),l(e,Ue,t),l(e,Gl,t),l(e,_e,t),l(e,Sl,t),l(e,$e,t),l(e,Vl,t),l(e,Ie,t),l(e,Xl,t),l(e,Le,t),l(e,Yl,t),l(e,ze,t),l(e,Fl,t),u(ke,e,t),l(e,Ol,t),l(e,xe,t),l(e,Kl,t),l(e,Ae,t),l(e,en,t),l(e,He,t),l(e,tn,t),l(e,Ne,t),l(e,ln,t),l(e,Pe,t),l(e,nn,t),l(e,Be,t),l(e,on,t),l(e,Ze,t),l(e,an,t),l(e,Qe,t),l(e,rn,t),l(e,We,t),l(e,sn,t),l(e,De,t),l(e,pn,t),l(e,Re,t),l(e,mn,t),u(qe,e,t),l(e,un,t),l(e,Ee,t),l(e,cn,t),l(e,Ge,t),l(e,dn,t),l(e,Se,t),l(e,Mn,t),u(Ve,e,t),l(e,fn,t),l(e,Xe,t),l(e,gn,t),u(Ye,e,t),l(e,Tn,t),l(e,Fe,t),l(e,vn,t),l(e,Oe,t),l(e,wn,t),u(Ke,e,t),l(e,bn,t),l(e,et,t),l(e,yn,t),l(e,tt,t),l(e,hn,t),l(e,it,t),l(e,Jn,t),l(e,lt,t),l(e,Cn,t),l(e,nt,t),l(e,jn,t),u(ot,e,t),l(e,Un,t),l(e,J,t),l(e,_n,t),u(at,e,t),l(e,$n,t),l(e,C,t),l(e,In,t),u(rt,e,t),l(e,Ln,t),l(e,j,t),l(e,zn,t),u(st,e,t),l(e,kn,t),l(e,U,t),l(e,xn,t),l(e,pt,t),l(e,An,t),u(mt,e,t),l(e,Hn,t),l(e,ut,t),l(e,Nn,t),l(e,ct,t),l(e,Pn,t),l(e,dt,t),l(e,Bn,t),l(e,Mt,t),l(e,Zn,t),l(e,ft,t),l(e,Qn,t),l(e,gt,t),l(e,Wn,t),l(e,Tt,t),l(e,Dn,t),u(vt,e,t),l(e,Rn,t),l(e,wt,t),l(e,qn,t),l(e,bt,t),l(e,En,t),l(e,yt,t),l(e,Gn,t),l(e,ht,t),l(e,Sn,t),l(e,Jt,t),l(e,Vn,t),u(Ct,e,t),l(e,Xn,t),l(e,jt,t),l(e,Yn,t),u(Ut,e,t),l(e,Fn,t),l(e,_t,t),l(e,On,t),u($t,e,t),l(e,Kn,t),l(e,It,t),l(e,eo,t),u(Lt,e,t),l(e,to,t),l(e,zt,t),l(e,io,t),u(kt,e,t),l(e,lo,t),l(e,xt,t),l(e,no,t),u(At,e,t),l(e,oo,t),l(e,Ht,t),l(e,ao,t),u(Nt,e,t),l(e,ro,t),l(e,Pt,t),l(e,so,t),u(Bt,e,t),l(e,po,t),l(e,Zt,t),l(e,mo,t),l(e,Qt,t),l(e,uo,t),l(e,Wt,t),l(e,co,t),l(e,Dt,t),l(e,Mo,t),u(Rt,e,t),l(e,fo,t),l(e,qt,t),l(e,go,t),l(e,Et,t),l(e,To,t),u(Gt,e,t),l(e,vo,t),l(e,St,t),l(e,wo,t),l(e,Vt,t),l(e,bo,t),l(e,Xt,t),l(e,yo,t),l(e,Yt,t),l(e,ho,t),l(e,Ft,t),l(e,Jo,t),l(e,Ot,t),l(e,Co,t),l(e,Kt,t),l(e,jo,t),u(ei,e,t),l(e,Uo,t),l(e,ti,t),l(e,_o,t),l(e,ii,t),l(e,$o,t),l(e,li,t),l(e,Io,t),u(ni,e,t),l(e,Lo,t),u(_,e,t),l(e,zo,t),l(e,oi,t),l(e,ko,t),l(e,ai,t),l(e,xo,t),l(e,ri,t),l(e,Ao,t),l(e,si,t),l(e,Ho,t),l(e,pi,t),l(e,No,t),l(e,mi,t),l(e,Po,t),u(ui,e,t),l(e,Bo,t),l(e,ci,t),l(e,Zo,t),u(di,e,t),l(e,Qo,t),l(e,Mi,t),l(e,Wo,t),l(e,fi,t),l(e,Do,t),l(e,gi,t),l(e,Ro,t),l(e,Ti,t),l(e,qo,t),l(e,vi,t),l(e,Eo,t),l(e,wi,t),l(e,Go,t),l(e,bi,t),l(e,So,t),l(e,yi,t),l(e,Vo,t),l(e,hi,t),l(e,Xo,t),u(Ji,e,t),l(e,Yo,t),l(e,Ci,t),l(e,Fo,t),u(ji,e,t),l(e,Oo,t),l(e,Ui,t),l(e,Ko,t),l(e,_i,t),l(e,ea,t),l(e,$i,t),l(e,ta,t),l(e,Ii,t),l(e,ia,t),l(e,Li,t),l(e,la,t),u(zi,e,t),l(e,na,t),l(e,ki,t),l(e,oa,t),l(e,xi,t),l(e,aa,t),l(e,Ai,t),l(e,ra,t),l(e,Hi,t),l(e,sa,t),l(e,Ni,t),l(e,pa,t),u(Pi,e,t),l(e,ma,t),l(e,Bi,t),l(e,ua,t),l(e,Zi,t),l(e,ca,t),u(Qi,e,t),l(e,da,t),l(e,Ri,t),Ma=!0},p(e,[t]){const Es={};t&2&&(Es.$$scope={dirty:t,ctx:e}),_.$set(Es)},i(e){Ma||(c(I.$$.fragment,e),c(N.$$.fragment,e),c(D.$$.fragment,e),c(G.$$.fragment,e),c(V.$$.fragment,e),c(F.$$.fragment,e),c(K.$$.fragment,e),c(se.$$.fragment,e),c(ce.$$.fragment,e),c(Me.$$.fragment,e),c(fe.$$.fragment,e),c(Te.$$.fragment,e),c(we.$$.fragment,e),c(ye.$$.fragment,e),c(ke.$$.fragment,e),c(qe.$$.fragment,e),c(Ve.$$.fragment,e),c(Ye.$$.fragment,e),c(Ke.$$.fragment,e),c(ot.$$.fragment,e),c(at.$$.fragment,e),c(rt.$$.fragment,e),c(st.$$.fragment,e),c(mt.$$.fragment,e),c(vt.$$.fragment,e),c(Ct.$$.fragment,e),c(Ut.$$.fragment,e),c($t.$$.fragment,e),c(Lt.$$.fragment,e),c(kt.$$.fragment,e),c(At.$$.fragment,e),c(Nt.$$.fragment,e),c(Bt.$$.fragment,e),c(Rt.$$.fragment,e),c(Gt.$$.fragment,e),c(ei.$$.fragment,e),c(ni.$$.fragment,e),c(_.$$.fragment,e),c(ui.$$.fragment,e),c(di.$$.fragment,e),c(Ji.$$.fragment,e),c(ji.$$.fragment,e),c(zi.$$.fragment,e),c(Pi.$$.fragment,e),c(Qi.$$.fragment,e),Ma=!0)},o(e){d(I.$$.fragment,e),d(N.$$.fragment,e),d(D.$$.fragment,e),d(G.$$.fragment,e),d(V.$$.fragment,e),d(F.$$.fragment,e),d(K.$$.fragment,e),d(se.$$.fragment,e),d(ce.$$.fragment,e),d(Me.$$.fragment,e),d(fe.$$.fragment,e),d(Te.$$.fragment,e),d(we.$$.fragment,e),d(ye.$$.fragment,e),d(ke.$$.fragment,e),d(qe.$$.fragment,e),d(Ve.$$.fragment,e),d(Ye.$$.fragment,e),d(Ke.$$.fragment,e),d(ot.$$.fragment,e),d(at.$$.fragment,e),d(rt.$$.fragment,e),d(st.$$.fragment,e),d(mt.$$.fragment,e),d(vt.$$.fragment,e),d(Ct.$$.fragment,e),d(Ut.$$.fragment,e),d($t.$$.fragment,e),d(Lt.$$.fragment,e),d(kt.$$.fragment,e),d(At.$$.fragment,e),d(Nt.$$.fragment,e),d(Bt.$$.fragment,e),d(Rt.$$.fragment,e),d(Gt.$$.fragment,e),d(ei.$$.fragment,e),d(ni.$$.fragment,e),d(_.$$.fragment,e),d(ui.$$.fragment,e),d(di.$$.fragment,e),d(Ji.$$.fragment,e),d(ji.$$.fragment,e),d(zi.$$.fragment,e),d(Pi.$$.fragment,e),d(Qi.$$.fragment,e),Ma=!1},d(e){e&&(i($),i(T),i(Wi),i(Ei),i(L),i(Gi),i(z),i(Si),i(k),i(Vi),i(x),i(Xi),i(A),i(Yi),i(H),i(Fi),i(Oi),i(P),i(Ki),i(B),i(el),i(Z),i(tl),i(Q),i(il),i(W),i(ll),i(nl),i(R),i(ol),i(q),i(al),i(Di),i(rl),i(E),i(sl),i(pl),i(S),i(ml),i(ul),i(X),i(cl),i(Y),i(dl),i(Ml),i(O),i(fl),i(gl),i(ee),i(Tl),i(te),i(vl),i(ie),i(wl),i(le),i(bl),i(ne),i(yl),i(oe),i(hl),i(ae),i(Jl),i(re),i(Cl),i(jl),i(pe),i(Ul),i(me),i(_l),i(ue),i($l),i(Il),i(de),i(Ll),i(zl),i(b),i(kl),i(xl),i(ge),i(Al),i(Hl),i(y),i(Nl),i(ve),i(Pl),i(h),i(Bl),i(Zl),i(be),i(Ql),i(Wl),i(he),i(Dl),i(Je),i(Rl),i(Ce),i(ql),i(je),i(El),i(Ue),i(Gl),i(_e),i(Sl),i($e),i(Vl),i(Ie),i(Xl),i(Le),i(Yl),i(ze),i(Fl),i(Ol),i(xe),i(Kl),i(Ae),i(en),i(He),i(tn),i(Ne),i(ln),i(Pe),i(nn),i(Be),i(on),i(Ze),i(an),i(Qe),i(rn),i(We),i(sn),i(De),i(pn),i(Re),i(mn),i(un),i(Ee),i(cn),i(Ge),i(dn),i(Se),i(Mn),i(fn),i(Xe),i(gn),i(Tn),i(Fe),i(vn),i(Oe),i(wn),i(bn),i(et),i(yn),i(tt),i(hn),i(it),i(Jn),i(lt),i(Cn),i(nt),i(jn),i(Un),i(J),i(_n),i($n),i(C),i(In),i(Ln),i(j),i(zn),i(kn),i(U),i(xn),i(pt),i(An),i(Hn),i(ut),i(Nn),i(ct),i(Pn),i(dt),i(Bn),i(Mt),i(Zn),i(ft),i(Qn),i(gt),i(Wn),i(Tt),i(Dn),i(Rn),i(wt),i(qn),i(bt),i(En),i(yt),i(Gn),i(ht),i(Sn),i(Jt),i(Vn),i(Xn),i(jt),i(Yn),i(Fn),i(_t),i(On),i(Kn),i(It),i(eo),i(to),i(zt),i(io),i(lo),i(xt),i(no),i(oo),i(Ht),i(ao),i(ro),i(Pt),i(so),i(po),i(Zt),i(mo),i(Qt),i(uo),i(Wt),i(co),i(Dt),i(Mo),i(fo),i(qt),i(go),i(Et),i(To),i(vo),i(St),i(wo),i(Vt),i(bo),i(Xt),i(yo),i(Yt),i(ho),i(Ft),i(Jo),i(Ot),i(Co),i(Kt),i(jo),i(Uo),i(ti),i(_o),i(ii),i($o),i(li),i(Io),i(Lo),i(zo),i(oi),i(ko),i(ai),i(xo),i(ri),i(Ao),i(si),i(Ho),i(pi),i(No),i(mi),i(Po),i(Bo),i(ci),i(Zo),i(Qo),i(Mi),i(Wo),i(fi),i(Do),i(gi),i(Ro),i(Ti),i(qo),i(vi),i(Eo),i(wi),i(Go),i(bi),i(So),i(yi),i(Vo),i(hi),i(Xo),i(Yo),i(Ci),i(Fo),i(Oo),i(Ui),i(Ko),i(_i),i(ea),i($i),i(ta),i(Ii),i(ia),i(Li),i(la),i(na),i(ki),i(oa),i(xi),i(aa),i(Ai),i(ra),i(Hi),i(sa),i(Ni),i(pa),i(ma),i(Bi),i(ua),i(Zi),i(ca),i(da),i(Ri)),i(g),M(I,e),M(N,e),M(D,e),M(G,e),M(V,e),M(F,e),M(K,e),M(se,e),M(ce,e),M(Me,e),M(fe,e),M(Te,e),M(we,e),M(ye,e),M(ke,e),M(qe,e),M(Ve,e),M(Ye,e),M(Ke,e),M(ot,e),M(at,e),M(rt,e),M(st,e),M(mt,e),M(vt,e),M(Ct,e),M(Ut,e),M($t,e),M(Lt,e),M(kt,e),M(At,e),M(Nt,e),M(Bt,e),M(Rt,e),M(Gt,e),M(ei,e),M(ni,e),M(_,e),M(ui,e),M(di,e),M(Ji,e),M(ji,e),M(zi,e),M(Pi,e),M(Qi,e)}}}const op='{"title":"Come aggiungere un modello a 🤗 Transformers?","local":"come-aggiungere-un-modello-a--transformers","sections":[{"title":"Panoramica generale su 🤗 Transformers","local":"panoramica-generale-su--transformers","sections":[{"title":"Panoramica sui modelli","local":"panoramica-sui-modelli","sections":[],"depth":3},{"title":"Stile per il codice","local":"stile-per-il-codice","sections":[],"depth":3},{"title":"Panoramica sui tokenizers","local":"panoramica-sui-tokenizers","sections":[],"depth":3}],"depth":2},{"title":"Aggiungere un modello a 🤗 Transformers passo dopo passo","local":"aggiungere-un-modello-a--transformers-passo-dopo-passo","sections":[{"title":"1. (Opzionale) Aspetti teorici di BrandNewBert","local":"1-opzionale-aspetti-teorici-di-brandnewbert","sections":[],"depth":3},{"title":"2. Prepare il tuo ambiente","local":"2-prepare-il-tuo-ambiente","sections":[],"depth":3},{"title":"3.-4. Provare un pretrained checkpoint usando la repo originale","local":"3-4-provare-un-pretrained-checkpoint-usando-la-repo-originale","sections":[],"depth":3},{"title":"5.-14. Trasferire BrandNewBert in 🤗 Transformers","local":"5-14-trasferire-brandnewbert-in--transformers","sections":[],"depth":3},{"title":"Condividete il vostro lavoro!!","local":"condividete-il-vostro-lavoro","sections":[],"depth":3}],"depth":2}],"depth":1}';function ap(qi){return Xs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cp extends Fs{constructor(g){super(),Os(this,g,ap,np,Ss,{})}}export{cp as component};
