import{s as Pe,n as He,o as We}from"../chunks/scheduler.c57aa7ef.js";import{S as Ge,i as Se,g as a,s as l,r as c,A as Ne,h as s,f as o,c as n,j as Le,u as d,x as r,k as we,y as Qe,a as i,v as u,d as h,t as b,w as g}from"../chunks/index.394f8801.js";import{C as Ae}from"../chunks/CodeBlock.b5488637.js";import{H,E as Ve}from"../chunks/index.af4fbae1.js";function De(_e){let f,S,W,N,y,Q,T,ve='This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2306.07280" rel="nofollow">OFT</a> and <a href="https://arxiv.org/abs/2311.06243" rel="nofollow">BOFT</a>, a parameter-efficient fine-tuning technique that utilizes orthogonal matrix to multiplicatively transform the pretrained weight matrices.',A,w,Me="To achieve efficient fine-tuning, OFT represents the weight updates with an orthogonal transformation. The orthogonal transformation is parameterized by an orthogonal matrix multiplied to the pretrained weight matrix. These new matrices can be trained to adapt to the new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive any further adjustments. To produce the final results, both the original and the adapted weights are multiplied togethor.",V,_,Fe="Orthogonal Butterfly (BOFT) generalizes OFT with Butterfly factorization and further improves its parameter efficiency and finetuning flexibility. In short, OFT can be viewed as a special case of BOFT. Different from LoRA that uses additive low-rank weight updates, BOFT uses multiplicative orthogonal weight updates. The comparison is shown below.",D,m,Ce='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/BOFT_comparison.png"/>',X,v,xe="BOFT has some advantages compared to LoRA:",Y,M,Be='<li>BOFT proposes a simple yet generic way to finetune pretrained models to downstream tasks, yielding a better preservation of pretraining knowledge and a better parameter efficiency.</li> <li>Through the orthogonality, BOFT introduces a structural constraint, i.e., keeping the <a href="https://arxiv.org/abs/1805.09298" rel="nofollow">hyperspherical energy</a> unchanged during finetuning. This can effectively reduce the forgetting of pretraining knowledge.</li> <li>BOFT uses the butterfly factorization to efficiently parameterize the orthogonal matrix, which yields a compact yet expressive learning space (i.e., hypothesis class).</li> <li>The sparse matrix decomposition in BOFT brings in additional inductive biases that are beneficial to generalization.</li>',K,F,Oe="In principle, BOFT can be applied to any subset of weight matrices in a neural network to reduce the number of trainable parameters. Given the target layers for injecting BOFT parameters, the number of trainable parameters can be determined based on the size of the weight matrices.",ee,C,te,x,$e="Similar to LoRA, the weights learned by OFT/BOFT can be integrated into the pretrained weight matrices using the merge_and_unload() function. This function merges the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.",oe,p,Ue='<img src="https://raw.githubusercontent.com/wy1iu/butterfly-oft/main/assets/boft_merge.png"/>',ie,B,ke="This works because during training, the orthogonal weight matrix (R in the diagram above) and the pretrained weight matrices are separate. But once training is complete, these weights can actually be merged (multiplied) into a new weight matrix that is equivalent.",le,O,ne,$,ae,U,Je="As with other methods supported by PEFT, to fine-tune a model using OFT or BOFT, you need to:",se,k,je="<li>Instantiate a base model.</li> <li>Create a configuration (<code>OFTConfig</code> or <code>BOFTConfig</code>) where you define OFT/BOFT-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",re,J,fe,j,qe="<code>BOFTConfig</code> allows you to control how OFT/BOFT is applied to the base model through the following parameters:",me,q,Ze=`<li><code>boft_block_size</code>: the BOFT matrix block size across different layers, expressed in <code>int</code>. Smaller block size results in sparser update matrices with fewer trainable parameters. <strong>Note</strong>, please choose <code>boft_block_size</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_block_num</code>: the number of BOFT matrix blocks across different layers, expressed in <code>int</code>. Fewer blocks result in sparser update matrices with fewer trainable parameters. <strong>Note</strong>, please choose <code>boft_block_num</code> to be divisible by most layer’s input dimension (<code>in_features</code>), e.g., 4, 8, 16. Also, please only
specify either <code>boft_block_size</code> or <code>boft_block_num</code>, but not both simultaneously or leaving both to 0, because <code>boft_block_size</code> x <code>boft_block_num</code> must equal the layer’s input dimension.</li> <li><code>boft_n_butterfly_factor</code>: the number of butterfly factors. <strong>Note</strong>, for <code>boft_n_butterfly_factor=1</code>, BOFT is the same as vanilla OFT, for <code>boft_n_butterfly_factor=2</code>, the effective block size of OFT becomes twice as big and the number of blocks become half.</li> <li><code>bias</code>: specify if the <code>bias</code> parameters should be trained. Can be <code>&quot;none&quot;</code>, <code>&quot;all&quot;</code> or <code>&quot;boft_only&quot;</code>.</li> <li><code>boft_dropout</code>: specify the probability of multiplicative dropout.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to inject the OFT/BOFT matrices.</li> <li><code>modules_to_save</code>: List of modules apart from OFT/BOFT matrices to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li>`,pe,Z,ce,z,ze="For an example of the BOFT method application to various downstream tasks, please refer to the following guides:",de,I,Ie="Take a look at the following step-by-step guides on how to finetune a model with BOFT:",ue,R,Re='<li><a href="https://github.com/huggingface/peft/blob/main/examples/boft_dreambooth/boft_dreambooth.md" rel="nofollow">Dreambooth finetuning with BOFT</a></li> <li><a href="https://github.com/huggingface/peft/blob/main/examples/boft_controlnet/boft_controlnet.md" rel="nofollow">Controllable generation finetuning with BOFT (ControlNet)</a></li>',he,E,Ee="For the task of image classification, one can initialize the BOFT config for a DinoV2 model as follows:",be,L,ge,P,ye,G,Te;return y=new H({props:{title:"Orthogonal Finetuning (OFT and BOFT)",local:"orthogonal-finetuning-oft-and-boft",headingTag:"h1"}}),C=new H({props:{title:"Merge OFT/BOFT weights into the base model",local:"merge-oftboft-weights-into-the-base-model",headingTag:"h2"}}),O=new H({props:{title:"Utils for OFT / BOFT",local:"utils-for-oft--boft",headingTag:"h2"}}),$=new H({props:{title:"Common OFT / BOFT parameters in PEFT",local:"common-oft--boft-parameters-in-peft",headingTag:"h3"}}),J=new H({props:{title:"BOFT-specific parameters",local:"boft-specific-parameters",headingTag:"h3"}}),Z=new H({props:{title:"BOFT Example Usage",local:"boft-example-usage",headingTag:"h2"}}),L=new Ae({props:{code:"aW1wb3J0JTIwdHJhbnNmb3JtZXJzJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUyQyUyMEJPRlRDb25maWclMEFmcm9tJTIwcGVmdCUyMGltcG9ydCUyMEJPRlRDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWNvbmZpZyUyMCUzRCUyMEJPRlRDb25maWcoJTBBJTIwJTIwJTIwJTIwYm9mdF9ibG9ja19zaXplJTNENCUyQyUwQSUyMCUyMCUyMCUyMGJvZnRfbl9idXR0ZXJmbHlfZmFjdG9yJTNEMiUyQyUwQSUyMCUyMCUyMCUyMHRhcmdldF9tb2R1bGVzJTNEJTVCJTIycXVlcnklMjIlMkMlMjAlMjJ2YWx1ZSUyMiUyQyUyMCUyMmtleSUyMiUyQyUyMCUyMm91dHB1dC5kZW5zZSUyMiUyQyUyMCUyMm1scC5mYzElMjIlMkMlMjAlMjJtbHAuZmMyJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwYm9mdF9kcm9wb3V0JTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwYmlhcyUzRCUyMmJvZnRfb25seSUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZHVsZXNfdG9fc2F2ZSUzRCU1QiUyMmNsYXNzaWZpZXIlMjIlNUQlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjB0cmFuc2Zvcm1lcnMuRGlub3YyRm9ySW1hZ2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZmFjZWJvb2slMkZkaW5vdjItbGFyZ2UlMjIlMkMlMEElMjAlMjAlMjAlMjBudW1fbGFiZWxzJTNEMTAwJTJDJTBBKSUwQSUwQWJvZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChtb2RlbCUyQyUyMGNvbmZpZyk=",highlighted:`<span class="hljs-keyword">import</span> transformers
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM, BOFTConfig
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> BOFTConfig, get_peft_model

config = BOFTConfig(
    boft_block_size=<span class="hljs-number">4</span>,
    boft_n_butterfly_factor=<span class="hljs-number">2</span>,
    target_modules=[<span class="hljs-string">&quot;query&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>, <span class="hljs-string">&quot;key&quot;</span>, <span class="hljs-string">&quot;output.dense&quot;</span>, <span class="hljs-string">&quot;mlp.fc1&quot;</span>, <span class="hljs-string">&quot;mlp.fc2&quot;</span>],
    boft_dropout=<span class="hljs-number">0.1</span>,
    bias=<span class="hljs-string">&quot;boft_only&quot;</span>,
    modules_to_save=[<span class="hljs-string">&quot;classifier&quot;</span>],
)

model = transformers.Dinov2ForImageClassification.from_pretrained(
    <span class="hljs-string">&quot;facebook/dinov2-large&quot;</span>,
    num_labels=<span class="hljs-number">100</span>,
)

boft_model = get_peft_model(model, config)`,wrap:!1}}),P=new Ve({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/conceptual_guides/oft.md"}}),{c(){f=a("meta"),S=l(),W=a("p"),N=l(),c(y.$$.fragment),Q=l(),T=a("p"),T.innerHTML=ve,A=l(),w=a("p"),w.textContent=Me,V=l(),_=a("p"),_.textContent=Fe,D=l(),m=a("div"),m.innerHTML=Ce,X=l(),v=a("p"),v.textContent=xe,Y=l(),M=a("ul"),M.innerHTML=Be,K=l(),F=a("p"),F.textContent=Oe,ee=l(),c(C.$$.fragment),te=l(),x=a("p"),x.textContent=$e,oe=l(),p=a("div"),p.innerHTML=Ue,ie=l(),B=a("p"),B.textContent=ke,le=l(),c(O.$$.fragment),ne=l(),c($.$$.fragment),ae=l(),U=a("p"),U.textContent=Je,se=l(),k=a("ol"),k.innerHTML=je,re=l(),c(J.$$.fragment),fe=l(),j=a("p"),j.innerHTML=qe,me=l(),q=a("ul"),q.innerHTML=Ze,pe=l(),c(Z.$$.fragment),ce=l(),z=a("p"),z.textContent=ze,de=l(),I=a("p"),I.textContent=Ie,ue=l(),R=a("ul"),R.innerHTML=Re,he=l(),E=a("p"),E.textContent=Ee,be=l(),c(L.$$.fragment),ge=l(),c(P.$$.fragment),ye=l(),G=a("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);f=s(t,"META",{name:!0,content:!0}),t.forEach(o),S=n(e),W=s(e,"P",{}),Le(W).forEach(o),N=n(e),d(y.$$.fragment,e),Q=n(e),T=s(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-1nfmmal"&&(T.innerHTML=ve),A=n(e),w=s(e,"P",{"data-svelte-h":!0}),r(w)!=="svelte-91fr84"&&(w.textContent=Me),V=n(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-lal94n"&&(_.textContent=Fe),D=n(e),m=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-1veppqu"&&(m.innerHTML=Ce),X=n(e),v=s(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1dyux9"&&(v.textContent=xe),Y=n(e),M=s(e,"UL",{"data-svelte-h":!0}),r(M)!=="svelte-1cbqvv5"&&(M.innerHTML=Be),K=n(e),F=s(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-18dbsba"&&(F.textContent=Oe),ee=n(e),d(C.$$.fragment,e),te=n(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-10xuh5x"&&(x.textContent=$e),oe=n(e),p=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(p)!=="svelte-1a4qpj5"&&(p.innerHTML=Ue),ie=n(e),B=s(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-6kbdta"&&(B.textContent=ke),le=n(e),d(O.$$.fragment,e),ne=n(e),d($.$$.fragment,e),ae=n(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-qq3gtj"&&(U.textContent=Je),se=n(e),k=s(e,"OL",{"data-svelte-h":!0}),r(k)!=="svelte-psegni"&&(k.innerHTML=je),re=n(e),d(J.$$.fragment,e),fe=n(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-r0gnmm"&&(j.innerHTML=qe),me=n(e),q=s(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-b97dro"&&(q.innerHTML=Ze),pe=n(e),d(Z.$$.fragment,e),ce=n(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1py8k9k"&&(z.textContent=ze),de=n(e),I=s(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-5zw2dt"&&(I.textContent=Ie),ue=n(e),R=s(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-yv73mp"&&(R.innerHTML=Re),he=n(e),E=s(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-9y5ksw"&&(E.textContent=Ee),be=n(e),d(L.$$.fragment,e),ge=n(e),d(P.$$.fragment,e),ye=n(e),G=s(e,"P",{}),Le(G).forEach(o),this.h()},h(){we(f,"name","hf:doc:metadata"),we(f,"content",Xe),we(m,"class","flex justify-center"),we(p,"class","flex justify-center")},m(e,t){Qe(document.head,f),i(e,S,t),i(e,W,t),i(e,N,t),u(y,e,t),i(e,Q,t),i(e,T,t),i(e,A,t),i(e,w,t),i(e,V,t),i(e,_,t),i(e,D,t),i(e,m,t),i(e,X,t),i(e,v,t),i(e,Y,t),i(e,M,t),i(e,K,t),i(e,F,t),i(e,ee,t),u(C,e,t),i(e,te,t),i(e,x,t),i(e,oe,t),i(e,p,t),i(e,ie,t),i(e,B,t),i(e,le,t),u(O,e,t),i(e,ne,t),u($,e,t),i(e,ae,t),i(e,U,t),i(e,se,t),i(e,k,t),i(e,re,t),u(J,e,t),i(e,fe,t),i(e,j,t),i(e,me,t),i(e,q,t),i(e,pe,t),u(Z,e,t),i(e,ce,t),i(e,z,t),i(e,de,t),i(e,I,t),i(e,ue,t),i(e,R,t),i(e,he,t),i(e,E,t),i(e,be,t),u(L,e,t),i(e,ge,t),u(P,e,t),i(e,ye,t),i(e,G,t),Te=!0},p:He,i(e){Te||(h(y.$$.fragment,e),h(C.$$.fragment,e),h(O.$$.fragment,e),h($.$$.fragment,e),h(J.$$.fragment,e),h(Z.$$.fragment,e),h(L.$$.fragment,e),h(P.$$.fragment,e),Te=!0)},o(e){b(y.$$.fragment,e),b(C.$$.fragment,e),b(O.$$.fragment,e),b($.$$.fragment,e),b(J.$$.fragment,e),b(Z.$$.fragment,e),b(L.$$.fragment,e),b(P.$$.fragment,e),Te=!1},d(e){e&&(o(S),o(W),o(N),o(Q),o(T),o(A),o(w),o(V),o(_),o(D),o(m),o(X),o(v),o(Y),o(M),o(K),o(F),o(ee),o(te),o(x),o(oe),o(p),o(ie),o(B),o(le),o(ne),o(ae),o(U),o(se),o(k),o(re),o(fe),o(j),o(me),o(q),o(pe),o(ce),o(z),o(de),o(I),o(ue),o(R),o(he),o(E),o(be),o(ge),o(ye),o(G)),o(f),g(y,e),g(C,e),g(O,e),g($,e),g(J,e),g(Z,e),g(L,e),g(P,e)}}}const Xe='{"title":"Orthogonal Finetuning (OFT and BOFT)","local":"orthogonal-finetuning-oft-and-boft","sections":[{"title":"Merge OFT/BOFT weights into the base model","local":"merge-oftboft-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for OFT / BOFT","local":"utils-for-oft--boft","sections":[{"title":"Common OFT / BOFT parameters in PEFT","local":"common-oft--boft-parameters-in-peft","sections":[],"depth":3},{"title":"BOFT-specific parameters","local":"boft-specific-parameters","sections":[],"depth":3}],"depth":2},{"title":"BOFT Example Usage","local":"boft-example-usage","sections":[],"depth":2}],"depth":1}';function Ye(_e){return We(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Ge{constructor(f){super(),Se(this,f,Ye,De,Pe,{})}}export{it as component};
