import{s as xs,n as As,o as _s}from"../chunks/scheduler.7b8d42e8.js";import{S as Cs,i as Zs,g as i,s as e,r as p,A as Bs,h as r,f as t,c as n,j as Ct,u as M,x as o,k as Zt,y as Bt,a as s,v as c,d as m,t as d,w as j}from"../chunks/index.0671836c.js";import{D as ks}from"../chunks/Docstring.8421363b.js";import{C as u}from"../chunks/CodeBlock.c4671c67.js";import{H as h,E as vs}from"../chunks/EditOnGithub.15b2d305.js";function Gs(kt){let T,Pl,zl,ql,J,Ol,w,vt="AutoTrain Advanced makes it easy to fine-tune large language models (LLMs) for your specific use cases. This guide covers everything you need to know about LLM fine-tuning.",Kl,U,la,g,Gt="<li>Simple data preparation with CSV and JSONL formats</li> <li>Support for multiple training approaches (SFT, DPO, ORPO)</li> <li>Built-in chat templates</li> <li>Local and cloud training options</li> <li>Optimized training parameters</li>",aa,I,ta,f,Wt="AutoTrain supports multiple specialized trainers:",sa,b,Nt="<li><code>llm</code>: Generic LLM trainer</li> <li><code>llm-sft</code>: Supervised Fine-Tuning trainer</li> <li><code>llm-reward</code>: Reward modeling trainer</li> <li><code>llm-dpo</code>: Direct Preference Optimization trainer</li> <li><code>llm-orpo</code>: ORPO (Optimal Reward Policy Optimization) trainer</li>",ea,x,na,A,Rt=`LLM finetuning accepts data in CSV and JSONL formats. JSONL is the preferred format.
How data is formatted depends on the task you are training the LLM for.`,ia,_,ra,C,Lt="For text generation, the data should be in the following format:",oa,Z,St="<thead><tr><th>text</th></tr></thead> <tbody><tr><td>wikipedia is a free online encyclopedia</td></tr> <tr><td>it is a collaborative project</td></tr> <tr><td>that anyone can edit</td></tr> <tr><td>wikipedia is the largest and most popular general reference work on the internet</td></tr></tbody>",pa,B,Xt='An example dataset for this format can be found here: <a href="https://huggingface.co/datasets/stas/openwebtext-10k" rel="nofollow">stas/openwebtext-10k</a>',Ma,k,Et="Example tasks:",ca,v,Vt="<li>Text generation</li> <li>Code completion</li>",ma,G,$t="Compatible trainers:",da,W,Yt="<li>SFT Trainer</li> <li>Generic Trainer</li>",ja,N,ha,R,Qt=`For this task, you can use CSV or JSONL data. If you are formatting the data yourself (adding start, end tokens, etc.), you can use CSV or JSONL format.
If you do not want to format the data yourself and want <code>--chat-template</code> parameter to format the data for you, you must use JSONL format.
In both cases, CSV and JSONL can be used interchangeably but JSONL is the most preferred format.`,ua,L,Ht="To train a chatbot, your data will have <code>content</code> and <code>role</code>. Some models support <code>system</code> role as well.",Ta,S,Ft="Here is an example of a chatbot dataset (single sample):",ya,X,Ja,E,zt=`As you can see, the data has <code>content</code> and <code>role</code> columns. The <code>role</code> column can be <code>user</code> or <code>assistant</code> or <code>system</code>.
This data is, however, not formatted for training. You can use the <code>--chat-template</code> parameter to format the data during training.`,wa,V,Dt="<code>--chat-template</code> supports the following kinds of templates:",Ua,$,Pt="<li><code>none</code> (default)</li> <li><code>zephyr</code></li> <li><code>chatml</code></li> <li><code>tokenizer</code>: use chat template mentioned in tokenizer config</li>",ga,Y,qt="A multi-line sample is also shown below:",Ia,Q,fa,H,Ot='An example dataset for this format can be found here: <a href="https://huggingface.co/datasets/HuggingFaceH4/no_robots" rel="nofollow">HuggingFaceH4/no_robots</a>',ba,F,Kt="If you dont want to format the data using <code>--chat-template</code>, you can format the data yourself and use the following format:",xa,z,Aa,D,ls="A sample multi-line dataset is shown below:",_a,P,Ca,q,as='An example dataset for this format can be found here: <a href="https://huggingface.co/datasets/timdettmers/openassistant-guanaco" rel="nofollow">timdettmers/openassistant-guanaco</a>',Za,O,ts="In the examples above, we have seen only two turns: one from the user and one from the assistant. However, you can have multiple turns from the user and assistant in a single sample.",Ba,K,ss="Chat models can be trained using the following trainers:",ka,ll,es='<li><p>SFT Trainer:</p> <ul><li>requires only <code>text</code> column</li> <li>example dataset: <a href="https://huggingface.co/datasets/HuggingFaceH4/no_robots" rel="nofollow">HuggingFaceH4/no_robots</a></li></ul></li> <li><p>Generic Trainer:</p> <ul><li>requires only <code>text</code> column</li> <li>example dataset: <a href="https://huggingface.co/datasets/HuggingFaceH4/no_robots" rel="nofollow">HuggingFaceH4/no_robots</a></li></ul></li> <li><p>Reward Trainer:</p> <ul><li>requires <code>text</code> and <code>rejected_text</code> columns</li> <li>example dataset: <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">trl-lib/ultrafeedback_binarized</a></li></ul></li> <li><p>DPO Trainer:</p> <ul><li>requires <code>prompt</code>, <code>text</code>, and <code>rejected_text</code> columns</li> <li>example dataset: <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">trl-lib/ultrafeedback_binarized</a></li></ul></li> <li><p>ORPO Trainer:</p> <ul><li>requires <code>prompt</code>, <code>text</code>, and <code>rejected_text</code> columns</li> <li>example dataset: <a href="https://huggingface.co/datasets/trl-lib/ultrafeedback_binarized" rel="nofollow">trl-lib/ultrafeedback_binarized</a></li></ul></li>',va,al,ns="The only difference between the data format for reward trainer and DPO/ORPO trainer is that the reward trainer requires only <code>text</code> and <code>rejected_text</code> columns, while the DPO/ORPO trainer requires an additional <code>prompt</code> column.",Ga,tl,Wa,sl,Na,el,is="<li>Use appropriate <code>block_size</code> and <code>model_max_length</code> for your hardware</li> <li>Enable mixed precision training when possible</li> <li>Utilize PEFT techniques for large models</li>",Ra,nl,La,il,rs="<li>Clean and validate your training data</li> <li>Ensure balanced conversation samples</li> <li>Use appropriate chat templates</li>",Sa,rl,Xa,ol,os="<li>Start with small learning rates</li> <li>Monitor training metrics using tensorboard</li> <li>Validate model outputs during training</li>",Ea,pl,Va,Ml,ps='<li><a href="https://huggingface.co/docs/autotrain" rel="nofollow">AutoTrain Documentation</a></li> <li><a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;sort=downloads" rel="nofollow">Example Fine-tuned Models</a></li> <li><a href="https://huggingface.co/datasets?task_categories=task_categories:text-generation" rel="nofollow">Training Datasets</a></li>',$a,cl,Ya,ml,Qa,dl,Ms="Locally the training can be performed by using <code>autotrain --config config.yaml</code> command. The <code>config.yaml</code> file should contain the following parameters:",Ha,jl,Fa,hl,cs=`In the above config file, we are training a model using the ORPO trainer.
The model is trained on the <code>meta-llama/Meta-Llama-3-8B-Instruct</code> model.
The data is <code>argilla/distilabel-capybara-dpo-7k-binarized</code> dataset. The <code>chat_template</code> parameter is set to <code>chatml</code>.
The <code>column_mapping</code> parameter is used to map the columns in the dataset to the required columns for the ORPO trainer.
The <code>params</code> section contains the training parameters such as <code>block_size</code>, <code>model_max_length</code>, <code>epochs</code>, <code>batch_size</code>, <code>lr</code>, <code>peft</code>, <code>quantization</code>, <code>target_modules</code>, <code>padding</code>, <code>optimizer</code>, <code>scheduler</code>, <code>gradient_accumulation</code>, and <code>mixed_precision</code>.
The <code>hub</code> section contains the username and token for the Hugging Face account and the <code>push_to_hub</code> parameter is set to <code>true</code> to push the trained model to the Hugging Face Hub.`,za,ul,ms="If you have training file locally, you can change data part to:",Da,Tl,Pa,yl,ds="The above assumes you have <code>train.csv</code> or <code>train.jsonl</code> in the <code>path/to/training/file</code> directory and you will be applying <code>chatml</code> template to the data.",qa,Jl,js="You can run the training using the following command:",Oa,wl,Ka,Ul,hs='More example config files for finetuning different types of lllm and different tasks can be found in the <a href="https://github.com/huggingface/autotrain-advanced/tree/main/configs/llm_finetuning" rel="nofollow">here</a>.',lt,gl,at,Il,us="If you are training in Hugging Face Spaces, everything is the same as local training:",tt,fl,Ts='<img src="https://raw.githubusercontent.com/huggingface/autotrain-advanced/main/static/llm_orpo_example.png" alt="llm-finetuning"/>',st,bl,ys="In the UI, you need to make sure you select the right model, the dataset and the splits. Special care should be taken for <code>column_mapping</code>.",et,xl,Js="Once you are happy with the parameters, you can click on the <code>Start Training</code> button to start the training process.",nt,Al,it,_l,rt,y,Cl,_t,Fl,ws="LLMTrainingParams: Parameters for training a language model using the autotrain library.",ot,Zl,pt,Bl,Us="The length parameters used for different trainers can be different. Some require more context than others.",Mt,kl,gs="<li>block_size: This is the maximum sequence length or length of one block of text. Setting to -1 determines block size automatically. Default is -1.</li> <li>model_max_length: Set the maximum length for the model to process in a single batch, which can affect both performance and memory usage. Default is 1024</li> <li>max_prompt_length: Specify the maximum length for prompts used in training, particularly relevant for tasks requiring initial contextual input. Used only for <code>orpo</code> and <code>dpo</code> trainer.</li> <li>max_completion_length: Completion length to use, for orpo: encoder-decoder models only. For dpo, it is the length of the completion text.</li>",ct,vl,Is="<strong>NOTE</strong>:",mt,Gl,fs="<li>block size cannot be greater than model_max_length!</li> <li>max_prompt_length cannot be greater than model_max_length!</li> <li>max_prompt_length cannot be greater than block_size!</li> <li>max_completion_length cannot be greater than model_max_length!</li> <li>max_completion_length cannot be greater than block_size!</li>",dt,Wl,bs="<strong>NOTE</strong>: Not following these constraints will result in an error / nan losses.",jt,Nl,ht,Rl,ut,Ll,Tt,Sl,yt,Xl,Jt,El,wt,Vl,Ut,$l,gt,Yl,It,Ql,ft,Hl,bt,Dl,xt;return J=new h({props:{title:"LLM Finetuning with AutoTrain Advanced",local:"llm-finetuning-with-autotrain-advanced",headingTag:"h1"}}),U=new h({props:{title:"Key Features",local:"key-features",headingTag:"h2"}}),I=new h({props:{title:"Supported Training Methods",local:"supported-training-methods",headingTag:"h2"}}),x=new h({props:{title:"Data Preparation",local:"data-preparation",headingTag:"h2"}}),_=new h({props:{title:"Classic Text Generation",local:"classic-text-generation",headingTag:"h3"}}),N=new h({props:{title:"Chatbot / question-answering / code generation / function calling",local:"chatbot--question-answering--code-generation--function-calling",headingTag:"h3"}}),X=new u({props:{code:"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",highlighted:`[{<span class="hljs-symbol">&#x27;content</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Help</span> write a letter of <span class="hljs-number">100</span> <span class="hljs-number">-200</span> words to my future self for &#x27;
             <span class="hljs-symbol">&#x27;Kyra</span>, reflecting on her goals and aspirations.&#x27;,
  <span class="hljs-symbol">&#x27;role</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;user</span>&#x27;},
 {<span class="hljs-symbol">&#x27;content</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;Dear</span> Future Self,\\n&#x27;
             &#x27;\\n&#x27;
             <span class="hljs-string">&quot;I hope you&#x27;re happy and proud of what you&#x27;ve achieved. As I &quot;</span>
             <span class="hljs-string">&quot;write this, I&#x27;m excited to think about our goals and how far &quot;</span>
             <span class="hljs-string">&quot;you&#x27;ve come. One goal was to be a machine learning engineer. I &quot;</span>
             <span class="hljs-string">&quot;hope you&#x27;ve worked hard and become skilled in this field. Keep &quot;</span>
             <span class="hljs-symbol">&#x27;learning</span> and innovating. Traveling was important to us. I hope &#x27;
             <span class="hljs-string">&quot;you&#x27;ve seen different places and enjoyed the beauty of our &quot;</span>
             <span class="hljs-symbol">&#x27;world.</span> Remember the memories and lessons. Starting a family &#x27;
             <span class="hljs-symbol">&#x27;mattered</span> to us. If you have kids, treasure every moment. Be &#x27;
             <span class="hljs-symbol">&#x27;patient</span>, loving, and grateful for your family.\\n&#x27;
             &#x27;\\n&#x27;
             <span class="hljs-symbol">&#x27;Take</span> care of yourself. Rest, reflect, and cherish the time you &#x27;
             <span class="hljs-symbol">&#x27;spend</span> with loved ones. Remember your dreams and celebrate what &#x27;
             <span class="hljs-string">&quot;you&#x27;ve achieved. Your determination brought you here. I&#x27;m &quot;</span>
             <span class="hljs-string">&quot;excited to see the person you&#x27;ve become, the impact you&#x27;ve made, &quot;</span>
             <span class="hljs-symbol">&#x27;and</span> the love and joy in your life. Embrace opportunities and &#x27;
             <span class="hljs-symbol">&#x27;keep</span> dreaming big.\\n&#x27;
             &#x27;\\n&#x27;
             <span class="hljs-symbol">&#x27;With</span> love,\\n&#x27;
             <span class="hljs-symbol">&#x27;Kyra</span>&#x27;,
  <span class="hljs-symbol">&#x27;role</span><span class="hljs-symbol">&#x27;:</span> <span class="hljs-symbol">&#x27;assistant</span>&#x27;}]`,wrap:!1}}),Q=new u({props:{code:"JTVCJTdCJTIyY29udGVudCUyMiUzQSUyMCUyMmhlbGxvJTIyJTJDJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlN0QlMkMlMjAlN0IlMjJjb250ZW50JTIyJTNBJTIwJTIyaGklMjBuaWNlJTIwdG8lMjBtZWV0JTIweW91JTIyJTJDJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiU3RCU1RCUwQSU1QiU3QiUyMmNvbnRlbnQlMjIlM0ElMjAlMjJob3clMjBhcmUlMjB5b3UlMjIlMkMlMjAlMjJyb2xlJTIyJTNBJTIwJTIydXNlciUyMiU3RCUyQyUyMCU3QiUyMmNvbnRlbnQlMjIlM0ElMjAlMjJJJTIwYW0lMjBmaW5lJTIyJTJDJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiU3RCU1RCUwQSU1QiU3QiUyMmNvbnRlbnQlMjIlM0ElMjAlMjJXaGF0JTIwaXMlMjB5b3VyJTIwbmFtZSUzRiUyMiUyQyUyMCUyMnJvbGUlMjIlM0ElMjAlMjJ1c2VyJTIyJTdEJTJDJTIwJTdCJTIyY29udGVudCUyMiUzQSUyMCUyMk15JTIwbmFtZSUyMGlzJTIwTWFyeSUyMiUyQyUyMCUyMnJvbGUlMjIlM0ElMjAlMjJhc3Npc3RhbnQlMjIlN0QlNUQlMEElNUIlN0IlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hpY2glMjBpcyUyMHRoZSUyMGJlc3QlMjBwcm9ncmFtbWluZyUyMGxhbmd1YWdlJTNGJTIyJTJDJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlN0QlMkMlMjAlN0IlMjJjb250ZW50JTIyJTNBJTIwJTIyUHl0aG9uJTIyJTJDJTIwJTIycm9sZSUyMiUzQSUyMCUyMmFzc2lzdGFudCUyMiU3RCU1RCUwQS4lMEEuJTBBLg==",highlighted:`<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hello&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;hi nice to meet you&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;how are you&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I am fine&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is your name?&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;My name is Mary&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Which is the best programming language?&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span> <span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Python&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;assistant&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
.
.
.`,wrap:!1}}),z=new u({props:{code:"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",highlighted:'&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nCutting Knowledge Date: December <span class="hljs-number">2023</span>\\nToday Date: 03 Oct <span class="hljs-number">2024</span>\\n\\n&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nHelp write a letter of <span class="hljs-number">100</span> -<span class="hljs-number">200</span> words to my future self <span class="hljs-keyword">for</span> Kyra, reflecting on her goals <span class="hljs-keyword">and</span> aspirations.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\nDear Future Self,\\n\\nI hope yo<span class="hljs-string">u&#x27;re happy and proud of what you&#x27;</span>ve achieved. As I write this, I<span class="hljs-string">&#x27;m excited to think about our goals and how far you&#x27;</span>ve come. One goal was to be a machine learning engineer. I hope yo<span class="hljs-string">u&#x27;ve worked hard and become skilled in this field. Keep learning and innovating. Traveling was important to us. I hope you&#x27;</span>ve seen different places <span class="hljs-keyword">and</span> enjoyed the beauty of our world. Remember the memories <span class="hljs-keyword">and</span> lessons. Starting a family mattered to us. If you have kids, treasure every moment. Be patient, loving, <span class="hljs-keyword">and</span> grateful <span class="hljs-keyword">for</span> your family.\\n\\nTake care of yourself. Rest, reflect, <span class="hljs-keyword">and</span> cherish the time you spend <span class="hljs-keyword">with</span> loved ones. Remember your dreams <span class="hljs-keyword">and</span> celebrate what yo<span class="hljs-string">u&#x27;ve achieved. Your determination brought you here. I&#x27;</span>m excited to see the person yo<span class="hljs-string">u&#x27;ve become, the impact you&#x27;</span>ve made, <span class="hljs-keyword">and</span> the love <span class="hljs-keyword">and</span> joy <span class="hljs-keyword">in</span> your life. Embrace opportunities <span class="hljs-keyword">and</span> keep dreaming big.\\n\\nWith love,\\nKyra&lt;|eot_id|&gt;',wrap:!1}}),P=new u({props:{code:"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",highlighted:`<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nCutting Knowledge Date: December 2023\\nToday Date: 03 Oct 2024\\n\\n&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nhello&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\nhi nice to meet you&lt;|eot_id|&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nCutting Knowledge Date: December 2023\\nToday Date: 03 Oct 2024\\n\\n&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nhow are you&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\nI am fine&lt;|eot_id|&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nCutting Knowledge Date: December 2023\\nToday Date: 03 Oct 2024\\n\\n&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhat is your name?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\nMy name is Mary&lt;|eot_id|&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">[</span><span class="hljs-punctuation">{</span><span class="hljs-attr">&quot;text&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;&lt;|begin_of_text|&gt;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nCutting Knowledge Date: December 2023\\nToday Date: 03 Oct 2024\\n\\n&lt;|eot_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\nWhich is the best programming language?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\nPython&lt;|eot_id|&gt;&quot;</span><span class="hljs-punctuation">}</span><span class="hljs-punctuation">]</span>
.
.
.`,wrap:!1}}),tl=new h({props:{title:"Best Practices for LLM Fine-tuning",local:"best-practices-for-llm-fine-tuning",headingTag:"h2"}}),sl=new h({props:{title:"Memory Optimization",local:"memory-optimization",headingTag:"h3"}}),nl=new h({props:{title:"Data Quality",local:"data-quality",headingTag:"h3"}}),rl=new h({props:{title:"Training Tips",local:"training-tips",headingTag:"h3"}}),pl=new h({props:{title:"Related Resources",local:"related-resources",headingTag:"h3"}}),cl=new h({props:{title:"Training",local:"training",headingTag:"h2"}}),ml=new h({props:{title:"Local Training",local:"local-training",headingTag:"h3"}}),jl=new u({props:{code:"dGFzayUzQSUyMGxsbS1vcnBvJTBBYmFzZV9tb2RlbCUzQSUyMG1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMEFwcm9qZWN0X25hbWUlM0ElMjBhdXRvdHJhaW4tbGxhbWEzLThiLW9ycG8lMEFsb2clM0ElMjB0ZW5zb3Jib2FyZCUwQWJhY2tlbmQlM0ElMjBsb2NhbCUwQSUwQWRhdGElM0ElMEElMjAlMjBwYXRoJTNBJTIwYXJnaWxsYSUyRmRpc3RpbGFiZWwtY2FweWJhcmEtZHBvLTdrLWJpbmFyaXplZCUwQSUyMCUyMHRyYWluX3NwbGl0JTNBJTIwdHJhaW4lMEElMjAlMjB2YWxpZF9zcGxpdCUzQSUyMG51bGwlMEElMjAlMjBjaGF0X3RlbXBsYXRlJTNBJTIwY2hhdG1sJTBBJTIwJTIwY29sdW1uX21hcHBpbmclM0ElMEElMjAlMjAlMjAlMjB0ZXh0X2NvbHVtbiUzQSUyMGNob3NlbiUwQSUyMCUyMCUyMCUyMHJlamVjdGVkX3RleHRfY29sdW1uJTNBJTIwcmVqZWN0ZWQlMEElMjAlMjAlMjAlMjBwcm9tcHRfdGV4dF9jb2x1bW4lM0ElMjBwcm9tcHQlMEElMEFwYXJhbXMlM0ElMEElMjAlMjBibG9ja19zaXplJTNBJTIwMTAyNCUwQSUyMCUyMG1vZGVsX21heF9sZW5ndGglM0ElMjA4MTkyJTBBJTIwJTIwbWF4X3Byb21wdF9sZW5ndGglM0ElMjA1MTIlMEElMjAlMjBlcG9jaHMlM0ElMjAzJTBBJTIwJTIwYmF0Y2hfc2l6ZSUzQSUyMDIlMEElMjAlMjBsciUzQSUyMDNlLTUlMEElMjAlMjBwZWZ0JTNBJTIwdHJ1ZSUwQSUyMCUyMHF1YW50aXphdGlvbiUzQSUyMGludDQlMEElMjAlMjB0YXJnZXRfbW9kdWxlcyUzQSUyMGFsbC1saW5lYXIlMEElMjAlMjBwYWRkaW5nJTNBJTIwcmlnaHQlMEElMjAlMjBvcHRpbWl6ZXIlM0ElMjBhZGFtd190b3JjaCUwQSUyMCUyMHNjaGVkdWxlciUzQSUyMGxpbmVhciUwQSUyMCUyMGdyYWRpZW50X2FjY3VtdWxhdGlvbiUzQSUyMDQlMEElMjAlMjBtaXhlZF9wcmVjaXNpb24lM0ElMjBmcDE2JTBBJTBBaHViJTNBJTBBJTIwJTIwdXNlcm5hbWUlM0ElMjAlMjQlN0JIRl9VU0VSTkFNRSU3RCUwQSUyMCUyMHRva2VuJTNBJTIwJTI0JTdCSEZfVE9LRU4lN0QlMEElMjAlMjBwdXNoX3RvX2h1YiUzQSUyMHRydWU=",highlighted:`<span class="hljs-attr">task:</span> <span class="hljs-string">llm-orpo</span>
<span class="hljs-attr">base_model:</span> <span class="hljs-string">meta-llama/Meta-Llama-3-8B-Instruct</span>
<span class="hljs-attr">project_name:</span> <span class="hljs-string">autotrain-llama3-8b-orpo</span>
<span class="hljs-attr">log:</span> <span class="hljs-string">tensorboard</span>
<span class="hljs-attr">backend:</span> <span class="hljs-string">local</span>

<span class="hljs-attr">data:</span>
  <span class="hljs-attr">path:</span> <span class="hljs-string">argilla/distilabel-capybara-dpo-7k-binarized</span>
  <span class="hljs-attr">train_split:</span> <span class="hljs-string">train</span>
  <span class="hljs-attr">valid_split:</span> <span class="hljs-literal">null</span>
  <span class="hljs-attr">chat_template:</span> <span class="hljs-string">chatml</span>
  <span class="hljs-attr">column_mapping:</span>
    <span class="hljs-attr">text_column:</span> <span class="hljs-string">chosen</span>
    <span class="hljs-attr">rejected_text_column:</span> <span class="hljs-string">rejected</span>
    <span class="hljs-attr">prompt_text_column:</span> <span class="hljs-string">prompt</span>

<span class="hljs-attr">params:</span>
  <span class="hljs-attr">block_size:</span> <span class="hljs-number">1024</span>
  <span class="hljs-attr">model_max_length:</span> <span class="hljs-number">8192</span>
  <span class="hljs-attr">max_prompt_length:</span> <span class="hljs-number">512</span>
  <span class="hljs-attr">epochs:</span> <span class="hljs-number">3</span>
  <span class="hljs-attr">batch_size:</span> <span class="hljs-number">2</span>
  <span class="hljs-attr">lr:</span> <span class="hljs-number">3e-5</span>
  <span class="hljs-attr">peft:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">quantization:</span> <span class="hljs-string">int4</span>
  <span class="hljs-attr">target_modules:</span> <span class="hljs-string">all-linear</span>
  <span class="hljs-attr">padding:</span> <span class="hljs-string">right</span>
  <span class="hljs-attr">optimizer:</span> <span class="hljs-string">adamw_torch</span>
  <span class="hljs-attr">scheduler:</span> <span class="hljs-string">linear</span>
  <span class="hljs-attr">gradient_accumulation:</span> <span class="hljs-number">4</span>
  <span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp16</span>

<span class="hljs-attr">hub:</span>
  <span class="hljs-attr">username:</span> <span class="hljs-string">\${HF_USERNAME}</span>
  <span class="hljs-attr">token:</span> <span class="hljs-string">\${HF_TOKEN}</span>
  <span class="hljs-attr">push_to_hub:</span> <span class="hljs-literal">true</span>`,wrap:!1}}),Tl=new u({props:{code:"ZGF0YSUzQSUwQSUyMCUyMHBhdGglM0ElMjBwYXRoJTJGdG8lMkZ0cmFpbmluZyUyRmZpbGUlMEElMjAlMjB0cmFpbl9zcGxpdCUzQSUyMHRyYWluJTIwJTIzJTIwbmFtZSUyMG9mJTIwdGhlJTIwdHJhaW5pbmclMjBmaWxlJTBBJTIwJTIwdmFsaWRfc3BsaXQlM0ElMjBudWxsJTBBJTIwJTIwY2hhdF90ZW1wbGF0ZSUzQSUyMGNoYXRtbCUwQSUyMCUyMGNvbHVtbl9tYXBwaW5nJTNBJTBBJTIwJTIwJTIwJTIwdGV4dF9jb2x1bW4lM0ElMjBjaG9zZW4lMEElMjAlMjAlMjAlMjByZWplY3RlZF90ZXh0X2NvbHVtbiUzQSUyMHJlamVjdGVkJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3RleHRfY29sdW1uJTNBJTIwcHJvbXB0",highlighted:`<span class="hljs-attr">data:</span>
  <span class="hljs-attr">path:</span> <span class="hljs-string">path/to/training/file</span>
  <span class="hljs-attr">train_split:</span> <span class="hljs-string">train</span> <span class="hljs-comment"># name of the training file</span>
  <span class="hljs-attr">valid_split:</span> <span class="hljs-literal">null</span>
  <span class="hljs-attr">chat_template:</span> <span class="hljs-string">chatml</span>
  <span class="hljs-attr">column_mapping:</span>
    <span class="hljs-attr">text_column:</span> <span class="hljs-string">chosen</span>
    <span class="hljs-attr">rejected_text_column:</span> <span class="hljs-string">rejected</span>
    <span class="hljs-attr">prompt_text_column:</span> <span class="hljs-string">prompt</span>`,wrap:!1}}),wl=new u({props:{code:"JTI0JTIwYXV0b3RyYWluJTIwLS1jb25maWclMjBjb25maWcueWFtbA==",highlighted:"$ autotrain --config config.yaml",wrap:!1}}),gl=new h({props:{title:"Training in Hugging Face Spaces",local:"training-in-hugging-face-spaces",headingTag:"h3"}}),Al=new h({props:{title:"Parameters",local:"parameters",headingTag:"h2"}}),_l=new h({props:{title:"LLM Fine Tuning Parameters",local:"autotrain.trainers.clm.params.LLMTrainingParams",headingTag:"h3"}}),Cl=new ks({props:{name:"class autotrain.trainers.clm.params.LLMTrainingParams",anchor:"autotrain.trainers.clm.params.LLMTrainingParams",parameters:[{name:"model",val:": str = 'gpt2'"},{name:"project_name",val:": str = 'project-name'"},{name:"data_path",val:": str = 'data'"},{name:"train_split",val:": str = 'train'"},{name:"valid_split",val:": typing.Optional[str] = None"},{name:"add_eos_token",val:": bool = True"},{name:"block_size",val:": typing.Union[int, typing.List[int]] = -1"},{name:"model_max_length",val:": int = 2048"},{name:"padding",val:": typing.Optional[str] = 'right'"},{name:"trainer",val:": str = 'default'"},{name:"use_flash_attention_2",val:": bool = False"},{name:"log",val:": str = 'none'"},{name:"disable_gradient_checkpointing",val:": bool = False"},{name:"logging_steps",val:": int = -1"},{name:"eval_strategy",val:": str = 'epoch'"},{name:"save_total_limit",val:": int = 1"},{name:"auto_find_batch_size",val:": bool = False"},{name:"mixed_precision",val:": typing.Optional[str] = None"},{name:"lr",val:": float = 3e-05"},{name:"epochs",val:": int = 1"},{name:"batch_size",val:": int = 2"},{name:"warmup_ratio",val:": float = 0.1"},{name:"gradient_accumulation",val:": int = 4"},{name:"optimizer",val:": str = 'adamw_torch'"},{name:"scheduler",val:": str = 'linear'"},{name:"weight_decay",val:": float = 0.0"},{name:"max_grad_norm",val:": float = 1.0"},{name:"seed",val:": int = 42"},{name:"chat_template",val:": typing.Optional[str] = None"},{name:"quantization",val:": typing.Optional[str] = 'int4'"},{name:"target_modules",val:": typing.Optional[str] = 'all-linear'"},{name:"merge_adapter",val:": bool = False"},{name:"peft",val:": bool = False"},{name:"lora_r",val:": int = 16"},{name:"lora_alpha",val:": int = 32"},{name:"lora_dropout",val:": float = 0.05"},{name:"model_ref",val:": typing.Optional[str] = None"},{name:"dpo_beta",val:": float = 0.1"},{name:"max_prompt_length",val:": int = 128"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"prompt_text_column",val:": typing.Optional[str] = None"},{name:"text_column",val:": str = 'text'"},{name:"rejected_text_column",val:": typing.Optional[str] = None"},{name:"push_to_hub",val:": bool = False"},{name:"username",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Optional[str] = None"},{name:"unsloth",val:": bool = False"},{name:"distributed_backend",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.model",description:"<strong>model</strong> (str) &#x2014; Model name to be used for training. Default is &#x201C;gpt2&#x201D;.",name:"model"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.project_name",description:"<strong>project_name</strong> (str) &#x2014; Name of the project and output directory. Default is &#x201C;project-name&#x201D;.",name:"project_name"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.data_path",description:"<strong>data_path</strong> (str) &#x2014; Path to the dataset. Default is &#x201C;data&#x201D;.",name:"data_path"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.train_split",description:"<strong>train_split</strong> (str) &#x2014; Configuration for the training data split. Default is &#x201C;train&#x201D;.",name:"train_split"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.valid_split",description:"<strong>valid_split</strong> (Optional[str]) &#x2014; Configuration for the validation data split. Default is None.",name:"valid_split"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.add_eos_token",description:"<strong>add_eos_token</strong> (bool) &#x2014; Whether to add an EOS token at the end of sequences. Default is True.",name:"add_eos_token"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.block_size",description:"<strong>block_size</strong> (Union[int, List[int]]) &#x2014; Size of the blocks for training, can be a single integer or a list of integers. Default is -1.",name:"block_size"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.model_max_length",description:"<strong>model_max_length</strong> (int) &#x2014; Maximum length of the model input. Default is 2048.",name:"model_max_length"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.padding",description:"<strong>padding</strong> (Optional[str]) &#x2014; Side on which to pad sequences (left or right). Default is &#x201C;right&#x201D;.",name:"padding"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.trainer",description:"<strong>trainer</strong> (str) &#x2014; Type of trainer to use. Default is &#x201C;default&#x201D;.",name:"trainer"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.use_flash_attention_2",description:"<strong>use_flash_attention_2</strong> (bool) &#x2014; Whether to use flash attention version 2. Default is False.",name:"use_flash_attention_2"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.log",description:"<strong>log</strong> (str) &#x2014; Logging method for experiment tracking. Default is &#x201C;none&#x201D;.",name:"log"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.disable_gradient_checkpointing",description:"<strong>disable_gradient_checkpointing</strong> (bool) &#x2014; Whether to disable gradient checkpointing. Default is False.",name:"disable_gradient_checkpointing"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.logging_steps",description:"<strong>logging_steps</strong> (int) &#x2014; Number of steps between logging events. Default is -1.",name:"logging_steps"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.eval_strategy",description:"<strong>eval_strategy</strong> (str) &#x2014; Strategy for evaluation (e.g., &#x2018;epoch&#x2019;). Default is &#x201C;epoch&#x201D;.",name:"eval_strategy"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.save_total_limit",description:"<strong>save_total_limit</strong> (int) &#x2014; Maximum number of checkpoints to keep. Default is 1.",name:"save_total_limit"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.auto_find_batch_size",description:"<strong>auto_find_batch_size</strong> (bool) &#x2014; Whether to automatically find the optimal batch size. Default is False.",name:"auto_find_batch_size"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.mixed_precision",description:"<strong>mixed_precision</strong> (Optional[str]) &#x2014; Type of mixed precision to use (e.g., &#x2018;fp16&#x2019;, &#x2018;bf16&#x2019;, or None). Default is None.",name:"mixed_precision"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lr",description:"<strong>lr</strong> (float) &#x2014; Learning rate for training. Default is 3e-5.",name:"lr"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.epochs",description:"<strong>epochs</strong> (int) &#x2014; Number of training epochs. Default is 1.",name:"epochs"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.batch_size",description:"<strong>batch_size</strong> (int) &#x2014; Batch size for training. Default is 2.",name:"batch_size"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.warmup_ratio",description:"<strong>warmup_ratio</strong> (float) &#x2014; Proportion of training to perform learning rate warmup. Default is 0.1.",name:"warmup_ratio"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.gradient_accumulation",description:"<strong>gradient_accumulation</strong> (int) &#x2014; Number of steps to accumulate gradients before updating. Default is 4.",name:"gradient_accumulation"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.optimizer",description:"<strong>optimizer</strong> (str) &#x2014; Optimizer to use for training. Default is &#x201C;adamw_torch&#x201D;.",name:"optimizer"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.scheduler",description:"<strong>scheduler</strong> (str) &#x2014; Learning rate scheduler to use. Default is &#x201C;linear&#x201D;.",name:"scheduler"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.weight_decay",description:"<strong>weight_decay</strong> (float) &#x2014; Weight decay to apply to the optimizer. Default is 0.0.",name:"weight_decay"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.max_grad_norm",description:"<strong>max_grad_norm</strong> (float) &#x2014; Maximum norm for gradient clipping. Default is 1.0.",name:"max_grad_norm"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.seed",description:"<strong>seed</strong> (int) &#x2014; Random seed for reproducibility. Default is 42.",name:"seed"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.chat_template",description:"<strong>chat_template</strong> (Optional[str]) &#x2014; Template for chat-based models, options include: None, zephyr, chatml, or tokenizer. Default is None.",name:"chat_template"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.quantization",description:"<strong>quantization</strong> (Optional[str]) &#x2014; Quantization method to use (e.g., &#x2018;int4&#x2019;, &#x2018;int8&#x2019;, or None). Default is &#x201C;int4&#x201D;.",name:"quantization"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.target_modules",description:"<strong>target_modules</strong> (Optional[str]) &#x2014; Target modules for quantization or fine-tuning. Default is &#x201C;all-linear&#x201D;.",name:"target_modules"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.merge_adapter",description:"<strong>merge_adapter</strong> (bool) &#x2014; Whether to merge the adapter layers. Default is False.",name:"merge_adapter"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.peft",description:"<strong>peft</strong> (bool) &#x2014; Whether to use Parameter-Efficient Fine-Tuning (PEFT). Default is False.",name:"peft"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lora_r",description:"<strong>lora_r</strong> (int) &#x2014; Rank of the LoRA matrices. Default is 16.",name:"lora_r"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lora_alpha",description:"<strong>lora_alpha</strong> (int) &#x2014; Alpha parameter for LoRA. Default is 32.",name:"lora_alpha"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.lora_dropout",description:"<strong>lora_dropout</strong> (float) &#x2014; Dropout rate for LoRA. Default is 0.05.",name:"lora_dropout"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.model_ref",description:"<strong>model_ref</strong> (Optional[str]) &#x2014; Reference model for DPO trainer. Default is None.",name:"model_ref"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.dpo_beta",description:"<strong>dpo_beta</strong> (float) &#x2014; Beta parameter for DPO trainer. Default is 0.1.",name:"dpo_beta"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.max_prompt_length",description:"<strong>max_prompt_length</strong> (int) &#x2014; Maximum length of the prompt. Default is 128.",name:"max_prompt_length"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.max_completion_length",description:"<strong>max_completion_length</strong> (Optional[int]) &#x2014; Maximum length of the completion. Default is None.",name:"max_completion_length"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.prompt_text_column",description:"<strong>prompt_text_column</strong> (Optional[str]) &#x2014; Column name for the prompt text. Default is None.",name:"prompt_text_column"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.text_column",description:"<strong>text_column</strong> (str) &#x2014; Column name for the text data. Default is &#x201C;text&#x201D;.",name:"text_column"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.rejected_text_column",description:"<strong>rejected_text_column</strong> (Optional[str]) &#x2014; Column name for the rejected text data. Default is None.",name:"rejected_text_column"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.push_to_hub",description:"<strong>push_to_hub</strong> (bool) &#x2014; Whether to push the model to the Hugging Face Hub. Default is False.",name:"push_to_hub"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.username",description:"<strong>username</strong> (Optional[str]) &#x2014; Hugging Face username for authentication. Default is None.",name:"username"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.token",description:"<strong>token</strong> (Optional[str]) &#x2014; Hugging Face token for authentication. Default is None.",name:"token"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.unsloth",description:"<strong>unsloth</strong> (bool) &#x2014; Whether to use the unsloth library. Default is False.",name:"unsloth"},{anchor:"autotrain.trainers.clm.params.LLMTrainingParams.distributed_backend",description:"<strong>distributed_backend</strong> (Optional[str]) &#x2014; Backend to use for distributed training. Default is None.",name:"distributed_backend"}],source:"https://github.com/huggingface/autotrain-advanced/blob/main/src/autotrain/trainers/clm/params.py#L8"}}),Zl=new h({props:{title:"Task specific parameters",local:"task-specific-parameters",headingTag:"h3"}}),Nl=new h({props:{title:"Generic Trainer",local:"generic-trainer",headingTag:"h4"}}),Rl=new u({props:{code:"LS1hZGRfZW9zX3Rva2VuJTJDJTIwLS1hZGQtZW9zLXRva2VuJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwVG9nZ2xlJTIwd2hldGhlciUyMHRvJTIwYXV0b21hdGljYWxseSUyMGFkZCUyMGFuJTIwRW5kJTIwT2YlMjBTZW50ZW5jZSUyMChFT1MpJTIwdG9rZW4lMjBhdCUyMHRoZSUyMGVuZCUyMG9mJTIwdGV4dHMlMkMlMjB3aGljaCUyMGNhbiUyMGJlJTIwY3JpdGljYWwlMjBmb3IlMjBjZXJ0YWluJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZXMlMjBvZiUyMG1vZGVscyUyMGxpa2UlMjBsYW5ndWFnZSUyMG1vZGVscy4lMjBPbmx5JTIwdXNlZCUyMGZvciUyMCU2MGRlZmF1bHQlNjAlMjB0cmFpbmVyJTBBLS1ibG9ja19zaXplJTIwQkxPQ0tfU0laRSUyQyUyMC0tYmxvY2stc2l6ZSUyMEJMT0NLX1NJWkUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcGVjaWZ5JTIwdGhlJTIwYmxvY2slMjBzaXplJTIwZm9yJTIwcHJvY2Vzc2luZyUyMHNlcXVlbmNlcy4lMjBUaGlzJTIwaXMlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBvciUyMGxlbmd0aCUyMG9mJTIwb25lJTIwYmxvY2slMjBvZiUyMHRleHQuJTIwU2V0dGluZyUyMHRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTElMjBkZXRlcm1pbmVzJTIwYmxvY2slMjBzaXplJTIwYXV0b21hdGljYWxseS4lMjBEZWZhdWx0JTIwaXMlMjAtMS4lMEEtLW1vZGVsX21heF9sZW5ndGglMjBNT0RFTF9NQVhfTEVOR1RIJTJDJTIwLS1tb2RlbC1tYXgtbGVuZ3RoJTIwTU9ERUxfTUFYX0xFTkdUSCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNldCUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjB0aGUlMjBtb2RlbCUyMHRvJTIwcHJvY2VzcyUyMGluJTIwYSUyMHNpbmdsZSUyMGJhdGNoJTJDJTIwd2hpY2glMjBjYW4lMjBhZmZlY3QlMjBib3RoJTIwcGVyZm9ybWFuY2UlMjBhbmQlMjBtZW1vcnklMjB1c2FnZS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZWZhdWx0JTIwaXMlMjAxMDI0",highlighted:`<span class="hljs-comment">--add_eos_token, --add-eos-token</span>
                    Toggle whether <span class="hljs-keyword">to</span> automatically <span class="hljs-keyword">add</span> an <span class="hljs-keyword">End</span> <span class="hljs-keyword">Of</span> Sentence (EOS) token at the <span class="hljs-keyword">end</span> <span class="hljs-keyword">of</span> texts, which can be critical <span class="hljs-keyword">for</span> certain
                    <span class="hljs-keyword">types</span> <span class="hljs-keyword">of</span> models <span class="hljs-keyword">like</span> <span class="hljs-keyword">language</span> models. <span class="hljs-keyword">Only</span> used <span class="hljs-keyword">for</span> \`<span class="hljs-keyword">default</span>\` trainer
<span class="hljs-comment">--block_size BLOCK_SIZE, --block-size BLOCK_SIZE</span>
                    Specify the block size <span class="hljs-keyword">for</span> processing <span class="hljs-keyword">sequences</span>. This <span class="hljs-keyword">is</span> maximum <span class="hljs-keyword">sequence</span> length <span class="hljs-keyword">or</span> length <span class="hljs-keyword">of</span> one block <span class="hljs-keyword">of</span> <span class="hljs-type">text</span>. Setting <span class="hljs-keyword">to</span>
                    <span class="hljs-number">-1</span> determines block size automatically. <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">-1.</span>
<span class="hljs-comment">--model_max_length MODEL_MAX_LENGTH, --model-max-length MODEL_MAX_LENGTH</span>
                    <span class="hljs-keyword">Set</span> the maximum length <span class="hljs-keyword">for</span> the model <span class="hljs-keyword">to</span> process <span class="hljs-keyword">in</span> a single batch, which can affect <span class="hljs-keyword">both</span> performance <span class="hljs-keyword">and</span> memory <span class="hljs-keyword">usage</span>.
                    <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">1024</span>`,wrap:!1}}),Ll=new h({props:{title:"SFT Trainer",local:"sft-trainer",headingTag:"h4"}}),Sl=new u({props:{code:"LS1ibG9ja19zaXplJTIwQkxPQ0tfU0laRSUyQyUyMC0tYmxvY2stc2l6ZSUyMEJMT0NLX1NJWkUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcGVjaWZ5JTIwdGhlJTIwYmxvY2slMjBzaXplJTIwZm9yJTIwcHJvY2Vzc2luZyUyMHNlcXVlbmNlcy4lMjBUaGlzJTIwaXMlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBvciUyMGxlbmd0aCUyMG9mJTIwb25lJTIwYmxvY2slMjBvZiUyMHRleHQuJTIwU2V0dGluZyUyMHRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTElMjBkZXRlcm1pbmVzJTIwYmxvY2slMjBzaXplJTIwYXV0b21hdGljYWxseS4lMjBEZWZhdWx0JTIwaXMlMjAtMS4lMEEtLW1vZGVsX21heF9sZW5ndGglMjBNT0RFTF9NQVhfTEVOR1RIJTJDJTIwLS1tb2RlbC1tYXgtbGVuZ3RoJTIwTU9ERUxfTUFYX0xFTkdUSCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNldCUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjB0aGUlMjBtb2RlbCUyMHRvJTIwcHJvY2VzcyUyMGluJTIwYSUyMHNpbmdsZSUyMGJhdGNoJTJDJTIwd2hpY2glMjBjYW4lMjBhZmZlY3QlMjBib3RoJTIwcGVyZm9ybWFuY2UlMjBhbmQlMjBtZW1vcnklMjB1c2FnZS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZWZhdWx0JTIwaXMlMjAxMDI0",highlighted:`<span class="hljs-comment">--block_size BLOCK_SIZE, --block-size BLOCK_SIZE</span>
                    Specify the block size <span class="hljs-keyword">for</span> processing <span class="hljs-keyword">sequences</span>. This <span class="hljs-keyword">is</span> maximum <span class="hljs-keyword">sequence</span> length <span class="hljs-keyword">or</span> length <span class="hljs-keyword">of</span> one block <span class="hljs-keyword">of</span> <span class="hljs-type">text</span>. Setting <span class="hljs-keyword">to</span>
                    <span class="hljs-number">-1</span> determines block size automatically. <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">-1.</span>
<span class="hljs-comment">--model_max_length MODEL_MAX_LENGTH, --model-max-length MODEL_MAX_LENGTH</span>
                    <span class="hljs-keyword">Set</span> the maximum length <span class="hljs-keyword">for</span> the model <span class="hljs-keyword">to</span> process <span class="hljs-keyword">in</span> a single batch, which can affect <span class="hljs-keyword">both</span> performance <span class="hljs-keyword">and</span> memory <span class="hljs-keyword">usage</span>.
                    <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">1024</span>`,wrap:!1}}),Xl=new h({props:{title:"Reward Trainer",local:"reward-trainer",headingTag:"h4"}}),El=new u({props:{code:"LS1ibG9ja19zaXplJTIwQkxPQ0tfU0laRSUyQyUyMC0tYmxvY2stc2l6ZSUyMEJMT0NLX1NJWkUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcGVjaWZ5JTIwdGhlJTIwYmxvY2slMjBzaXplJTIwZm9yJTIwcHJvY2Vzc2luZyUyMHNlcXVlbmNlcy4lMjBUaGlzJTIwaXMlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBvciUyMGxlbmd0aCUyMG9mJTIwb25lJTIwYmxvY2slMjBvZiUyMHRleHQuJTIwU2V0dGluZyUyMHRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTElMjBkZXRlcm1pbmVzJTIwYmxvY2slMjBzaXplJTIwYXV0b21hdGljYWxseS4lMjBEZWZhdWx0JTIwaXMlMjAtMS4lMEEtLW1vZGVsX21heF9sZW5ndGglMjBNT0RFTF9NQVhfTEVOR1RIJTJDJTIwLS1tb2RlbC1tYXgtbGVuZ3RoJTIwTU9ERUxfTUFYX0xFTkdUSCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNldCUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjB0aGUlMjBtb2RlbCUyMHRvJTIwcHJvY2VzcyUyMGluJTIwYSUyMHNpbmdsZSUyMGJhdGNoJTJDJTIwd2hpY2glMjBjYW4lMjBhZmZlY3QlMjBib3RoJTIwcGVyZm9ybWFuY2UlMjBhbmQlMjBtZW1vcnklMjB1c2FnZS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZWZhdWx0JTIwaXMlMjAxMDI0",highlighted:`<span class="hljs-comment">--block_size BLOCK_SIZE, --block-size BLOCK_SIZE</span>
                    Specify the block size <span class="hljs-keyword">for</span> processing <span class="hljs-keyword">sequences</span>. This <span class="hljs-keyword">is</span> maximum <span class="hljs-keyword">sequence</span> length <span class="hljs-keyword">or</span> length <span class="hljs-keyword">of</span> one block <span class="hljs-keyword">of</span> <span class="hljs-type">text</span>. Setting <span class="hljs-keyword">to</span>
                    <span class="hljs-number">-1</span> determines block size automatically. <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">-1.</span>
<span class="hljs-comment">--model_max_length MODEL_MAX_LENGTH, --model-max-length MODEL_MAX_LENGTH</span>
                    <span class="hljs-keyword">Set</span> the maximum length <span class="hljs-keyword">for</span> the model <span class="hljs-keyword">to</span> process <span class="hljs-keyword">in</span> a single batch, which can affect <span class="hljs-keyword">both</span> performance <span class="hljs-keyword">and</span> memory <span class="hljs-keyword">usage</span>.
                    <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">1024</span>`,wrap:!1}}),Vl=new h({props:{title:"DPO Trainer",local:"dpo-trainer",headingTag:"h4"}}),$l=new u({props:{code:"LS1kcG8tYmV0YSUyMERQT19CRVRBJTJDJTIwLS1kcG8tYmV0YSUyMERQT19CRVRBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQmV0YSUyMGZvciUyMERQTyUyMHRyYWluZXIlMEElMEEtLW1vZGVsLXJlZiUyME1PREVMX1JFRiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFJlZmVyZW5jZSUyMG1vZGVsJTIwdG8lMjB1c2UlMjBmb3IlMjBEUE8lMjB3aGVuJTIwbm90JTIwdXNpbmclMjBQRUZUJTBBLS1ibG9ja19zaXplJTIwQkxPQ0tfU0laRSUyQyUyMC0tYmxvY2stc2l6ZSUyMEJMT0NLX1NJWkUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcGVjaWZ5JTIwdGhlJTIwYmxvY2slMjBzaXplJTIwZm9yJTIwcHJvY2Vzc2luZyUyMHNlcXVlbmNlcy4lMjBUaGlzJTIwaXMlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBvciUyMGxlbmd0aCUyMG9mJTIwb25lJTIwYmxvY2slMjBvZiUyMHRleHQuJTIwU2V0dGluZyUyMHRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTElMjBkZXRlcm1pbmVzJTIwYmxvY2slMjBzaXplJTIwYXV0b21hdGljYWxseS4lMjBEZWZhdWx0JTIwaXMlMjAtMS4lMEEtLW1vZGVsX21heF9sZW5ndGglMjBNT0RFTF9NQVhfTEVOR1RIJTJDJTIwLS1tb2RlbC1tYXgtbGVuZ3RoJTIwTU9ERUxfTUFYX0xFTkdUSCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNldCUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjB0aGUlMjBtb2RlbCUyMHRvJTIwcHJvY2VzcyUyMGluJTIwYSUyMHNpbmdsZSUyMGJhdGNoJTJDJTIwd2hpY2glMjBjYW4lMjBhZmZlY3QlMjBib3RoJTIwcGVyZm9ybWFuY2UlMjBhbmQlMjBtZW1vcnklMjB1c2FnZS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZWZhdWx0JTIwaXMlMjAxMDI0JTBBLS1tYXhfcHJvbXB0X2xlbmd0aCUyME1BWF9QUk9NUFRfTEVOR1RIJTJDJTIwLS1tYXgtcHJvbXB0LWxlbmd0aCUyME1BWF9QUk9NUFRfTEVOR1RIJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU3BlY2lmeSUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjBwcm9tcHRzJTIwdXNlZCUyMGluJTIwdHJhaW5pbmclMkMlMjBwYXJ0aWN1bGFybHklMjByZWxldmFudCUyMGZvciUyMHRhc2tzJTIwcmVxdWlyaW5nJTIwaW5pdGlhbCUyMGNvbnRleHR1YWwlMjBpbnB1dC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVc2VkJTIwb25seSUyMGZvciUyMCU2MG9ycG8lNjAlMjB0cmFpbmVyLiUwQS0tbWF4X2NvbXBsZXRpb25fbGVuZ3RoJTIwTUFYX0NPTVBMRVRJT05fTEVOR1RIJTJDJTIwLS1tYXgtY29tcGxldGlvbi1sZW5ndGglMjBNQVhfQ09NUExFVElPTl9MRU5HVEglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb21wbGV0aW9uJTIwbGVuZ3RoJTIwdG8lMjB1c2UlMkMlMjBmb3IlMjBvcnBvJTNBJTIwZW5jb2Rlci1kZWNvZGVyJTIwbW9kZWxzJTIwb25seQ==",highlighted:`<span class="hljs-comment">--dpo-beta DPO_BETA, --dpo-beta DPO_BETA</span>
                    Beta <span class="hljs-keyword">for</span> DPO trainer

<span class="hljs-comment">--model-ref MODEL_REF</span>
                    Reference model <span class="hljs-keyword">to</span> use <span class="hljs-keyword">for</span> DPO <span class="hljs-keyword">when</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">using</span> PEFT
<span class="hljs-comment">--block_size BLOCK_SIZE, --block-size BLOCK_SIZE</span>
                    Specify the block size <span class="hljs-keyword">for</span> processing <span class="hljs-keyword">sequences</span>. This <span class="hljs-keyword">is</span> maximum <span class="hljs-keyword">sequence</span> length <span class="hljs-keyword">or</span> length <span class="hljs-keyword">of</span> one block <span class="hljs-keyword">of</span> <span class="hljs-type">text</span>. Setting <span class="hljs-keyword">to</span>
                    <span class="hljs-number">-1</span> determines block size automatically. <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">-1.</span>
<span class="hljs-comment">--model_max_length MODEL_MAX_LENGTH, --model-max-length MODEL_MAX_LENGTH</span>
                    <span class="hljs-keyword">Set</span> the maximum length <span class="hljs-keyword">for</span> the model <span class="hljs-keyword">to</span> process <span class="hljs-keyword">in</span> a single batch, which can affect <span class="hljs-keyword">both</span> performance <span class="hljs-keyword">and</span> memory <span class="hljs-keyword">usage</span>.
                    <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">1024</span>
<span class="hljs-comment">--max_prompt_length MAX_PROMPT_LENGTH, --max-prompt-length MAX_PROMPT_LENGTH</span>
                    Specify the maximum length <span class="hljs-keyword">for</span> prompts used <span class="hljs-keyword">in</span> training, particularly relevant <span class="hljs-keyword">for</span> tasks requiring initial contextual <span class="hljs-keyword">input</span>.
                    Used <span class="hljs-keyword">only</span> <span class="hljs-keyword">for</span> \`orpo\` trainer.
<span class="hljs-comment">--max_completion_length MAX_COMPLETION_LENGTH, --max-completion-length MAX_COMPLETION_LENGTH</span>
                    Completion length <span class="hljs-keyword">to</span> use, <span class="hljs-keyword">for</span> orpo: encoder-decoder models <span class="hljs-keyword">only</span>`,wrap:!1}}),Yl=new h({props:{title:"ORPO Trainer",local:"orpo-trainer",headingTag:"h4"}}),Ql=new u({props:{code:"LS1ibG9ja19zaXplJTIwQkxPQ0tfU0laRSUyQyUyMC0tYmxvY2stc2l6ZSUyMEJMT0NLX1NJWkUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBTcGVjaWZ5JTIwdGhlJTIwYmxvY2slMjBzaXplJTIwZm9yJTIwcHJvY2Vzc2luZyUyMHNlcXVlbmNlcy4lMjBUaGlzJTIwaXMlMjBtYXhpbXVtJTIwc2VxdWVuY2UlMjBsZW5ndGglMjBvciUyMGxlbmd0aCUyMG9mJTIwb25lJTIwYmxvY2slMjBvZiUyMHRleHQuJTIwU2V0dGluZyUyMHRvJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwLTElMjBkZXRlcm1pbmVzJTIwYmxvY2slMjBzaXplJTIwYXV0b21hdGljYWxseS4lMjBEZWZhdWx0JTIwaXMlMjAtMS4lMEEtLW1vZGVsX21heF9sZW5ndGglMjBNT0RFTF9NQVhfTEVOR1RIJTJDJTIwLS1tb2RlbC1tYXgtbGVuZ3RoJTIwTU9ERUxfTUFYX0xFTkdUSCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFNldCUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjB0aGUlMjBtb2RlbCUyMHRvJTIwcHJvY2VzcyUyMGluJTIwYSUyMHNpbmdsZSUyMGJhdGNoJTJDJTIwd2hpY2glMjBjYW4lMjBhZmZlY3QlMjBib3RoJTIwcGVyZm9ybWFuY2UlMjBhbmQlMjBtZW1vcnklMjB1c2FnZS4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZWZhdWx0JTIwaXMlMjAxMDI0JTBBLS1tYXhfcHJvbXB0X2xlbmd0aCUyME1BWF9QUk9NUFRfTEVOR1RIJTJDJTIwLS1tYXgtcHJvbXB0LWxlbmd0aCUyME1BWF9QUk9NUFRfTEVOR1RIJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwU3BlY2lmeSUyMHRoZSUyMG1heGltdW0lMjBsZW5ndGglMjBmb3IlMjBwcm9tcHRzJTIwdXNlZCUyMGluJTIwdHJhaW5pbmclMkMlMjBwYXJ0aWN1bGFybHklMjByZWxldmFudCUyMGZvciUyMHRhc2tzJTIwcmVxdWlyaW5nJTIwaW5pdGlhbCUyMGNvbnRleHR1YWwlMjBpbnB1dC4lMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVc2VkJTIwb25seSUyMGZvciUyMCU2MG9ycG8lNjAlMjB0cmFpbmVyLiUwQS0tbWF4X2NvbXBsZXRpb25fbGVuZ3RoJTIwTUFYX0NPTVBMRVRJT05fTEVOR1RIJTJDJTIwLS1tYXgtY29tcGxldGlvbi1sZW5ndGglMjBNQVhfQ09NUExFVElPTl9MRU5HVEglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBDb21wbGV0aW9uJTIwbGVuZ3RoJTIwdG8lMjB1c2UlMkMlMjBmb3IlMjBvcnBvJTNBJTIwZW5jb2Rlci1kZWNvZGVyJTIwbW9kZWxzJTIwb25seQ==",highlighted:`<span class="hljs-comment">--block_size BLOCK_SIZE, --block-size BLOCK_SIZE</span>
                    Specify the block size <span class="hljs-keyword">for</span> processing <span class="hljs-keyword">sequences</span>. This <span class="hljs-keyword">is</span> maximum <span class="hljs-keyword">sequence</span> length <span class="hljs-keyword">or</span> length <span class="hljs-keyword">of</span> one block <span class="hljs-keyword">of</span> <span class="hljs-type">text</span>. Setting <span class="hljs-keyword">to</span>
                    <span class="hljs-number">-1</span> determines block size automatically. <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">-1.</span>
<span class="hljs-comment">--model_max_length MODEL_MAX_LENGTH, --model-max-length MODEL_MAX_LENGTH</span>
                    <span class="hljs-keyword">Set</span> the maximum length <span class="hljs-keyword">for</span> the model <span class="hljs-keyword">to</span> process <span class="hljs-keyword">in</span> a single batch, which can affect <span class="hljs-keyword">both</span> performance <span class="hljs-keyword">and</span> memory <span class="hljs-keyword">usage</span>.
                    <span class="hljs-keyword">Default</span> <span class="hljs-keyword">is</span> <span class="hljs-number">1024</span>
<span class="hljs-comment">--max_prompt_length MAX_PROMPT_LENGTH, --max-prompt-length MAX_PROMPT_LENGTH</span>
                    Specify the maximum length <span class="hljs-keyword">for</span> prompts used <span class="hljs-keyword">in</span> training, particularly relevant <span class="hljs-keyword">for</span> tasks requiring initial contextual <span class="hljs-keyword">input</span>.
                    Used <span class="hljs-keyword">only</span> <span class="hljs-keyword">for</span> \`orpo\` trainer.
<span class="hljs-comment">--max_completion_length MAX_COMPLETION_LENGTH, --max-completion-length MAX_COMPLETION_LENGTH</span>
                    Completion length <span class="hljs-keyword">to</span> use, <span class="hljs-keyword">for</span> orpo: encoder-decoder models <span class="hljs-keyword">only</span>`,wrap:!1}}),Hl=new vs({props:{source:"https://github.com/huggingface/autotrain-advanced/blob/main/docs/source/tasks/llm_finetuning.mdx"}}),{c(){T=i("meta"),Pl=e(),zl=i("p"),ql=e(),p(J.$$.fragment),Ol=e(),w=i("p"),w.textContent=vt,Kl=e(),p(U.$$.fragment),la=e(),g=i("ul"),g.innerHTML=Gt,aa=e(),p(I.$$.fragment),ta=e(),f=i("p"),f.textContent=Wt,sa=e(),b=i("ul"),b.innerHTML=Nt,ea=e(),p(x.$$.fragment),na=e(),A=i("p"),A.textContent=Rt,ia=e(),p(_.$$.fragment),ra=e(),C=i("p"),C.textContent=Lt,oa=e(),Z=i("table"),Z.innerHTML=St,pa=e(),B=i("p"),B.innerHTML=Xt,Ma=e(),k=i("p"),k.textContent=Et,ca=e(),v=i("ul"),v.innerHTML=Vt,ma=e(),G=i("p"),G.textContent=$t,da=e(),W=i("ul"),W.innerHTML=Yt,ja=e(),p(N.$$.fragment),ha=e(),R=i("p"),R.innerHTML=Qt,ua=e(),L=i("p"),L.innerHTML=Ht,Ta=e(),S=i("p"),S.textContent=Ft,ya=e(),p(X.$$.fragment),Ja=e(),E=i("p"),E.innerHTML=zt,wa=e(),V=i("p"),V.innerHTML=Dt,Ua=e(),$=i("ul"),$.innerHTML=Pt,ga=e(),Y=i("p"),Y.textContent=qt,Ia=e(),p(Q.$$.fragment),fa=e(),H=i("p"),H.innerHTML=Ot,ba=e(),F=i("p"),F.innerHTML=Kt,xa=e(),p(z.$$.fragment),Aa=e(),D=i("p"),D.textContent=ls,_a=e(),p(P.$$.fragment),Ca=e(),q=i("p"),q.innerHTML=as,Za=e(),O=i("p"),O.textContent=ts,Ba=e(),K=i("p"),K.textContent=ss,ka=e(),ll=i("ul"),ll.innerHTML=es,va=e(),al=i("p"),al.innerHTML=ns,Ga=e(),p(tl.$$.fragment),Wa=e(),p(sl.$$.fragment),Na=e(),el=i("ul"),el.innerHTML=is,Ra=e(),p(nl.$$.fragment),La=e(),il=i("ul"),il.innerHTML=rs,Sa=e(),p(rl.$$.fragment),Xa=e(),ol=i("ul"),ol.innerHTML=os,Ea=e(),p(pl.$$.fragment),Va=e(),Ml=i("ul"),Ml.innerHTML=ps,$a=e(),p(cl.$$.fragment),Ya=e(),p(ml.$$.fragment),Qa=e(),dl=i("p"),dl.innerHTML=Ms,Ha=e(),p(jl.$$.fragment),Fa=e(),hl=i("p"),hl.innerHTML=cs,za=e(),ul=i("p"),ul.textContent=ms,Da=e(),p(Tl.$$.fragment),Pa=e(),yl=i("p"),yl.innerHTML=ds,qa=e(),Jl=i("p"),Jl.textContent=js,Oa=e(),p(wl.$$.fragment),Ka=e(),Ul=i("p"),Ul.innerHTML=hs,lt=e(),p(gl.$$.fragment),at=e(),Il=i("p"),Il.textContent=us,tt=e(),fl=i("p"),fl.innerHTML=Ts,st=e(),bl=i("p"),bl.innerHTML=ys,et=e(),xl=i("p"),xl.innerHTML=Js,nt=e(),p(Al.$$.fragment),it=e(),p(_l.$$.fragment),rt=e(),y=i("div"),p(Cl.$$.fragment),_t=e(),Fl=i("p"),Fl.textContent=ws,ot=e(),p(Zl.$$.fragment),pt=e(),Bl=i("p"),Bl.textContent=Us,Mt=e(),kl=i("ul"),kl.innerHTML=gs,ct=e(),vl=i("p"),vl.innerHTML=Is,mt=e(),Gl=i("ul"),Gl.innerHTML=fs,dt=e(),Wl=i("p"),Wl.innerHTML=bs,jt=e(),p(Nl.$$.fragment),ht=e(),p(Rl.$$.fragment),ut=e(),p(Ll.$$.fragment),Tt=e(),p(Sl.$$.fragment),yt=e(),p(Xl.$$.fragment),Jt=e(),p(El.$$.fragment),wt=e(),p(Vl.$$.fragment),Ut=e(),p($l.$$.fragment),gt=e(),p(Yl.$$.fragment),It=e(),p(Ql.$$.fragment),ft=e(),p(Hl.$$.fragment),bt=e(),Dl=i("p"),this.h()},l(l){const a=Bs("svelte-u9bgzb",document.head);T=r(a,"META",{name:!0,content:!0}),a.forEach(t),Pl=n(l),zl=r(l,"P",{}),Ct(zl).forEach(t),ql=n(l),M(J.$$.fragment,l),Ol=n(l),w=r(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-127w7gb"&&(w.textContent=vt),Kl=n(l),M(U.$$.fragment,l),la=n(l),g=r(l,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-1j8jqmn"&&(g.innerHTML=Gt),aa=n(l),M(I.$$.fragment,l),ta=n(l),f=r(l,"P",{"data-svelte-h":!0}),o(f)!=="svelte-wcxv3a"&&(f.textContent=Wt),sa=n(l),b=r(l,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-lqn01j"&&(b.innerHTML=Nt),ea=n(l),M(x.$$.fragment,l),na=n(l),A=r(l,"P",{"data-svelte-h":!0}),o(A)!=="svelte-48oka0"&&(A.textContent=Rt),ia=n(l),M(_.$$.fragment,l),ra=n(l),C=r(l,"P",{"data-svelte-h":!0}),o(C)!=="svelte-i8en6l"&&(C.textContent=Lt),oa=n(l),Z=r(l,"TABLE",{"data-svelte-h":!0}),o(Z)!=="svelte-1l541th"&&(Z.innerHTML=St),pa=n(l),B=r(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-1drksen"&&(B.innerHTML=Xt),Ma=n(l),k=r(l,"P",{"data-svelte-h":!0}),o(k)!=="svelte-n1nfxi"&&(k.textContent=Et),ca=n(l),v=r(l,"UL",{"data-svelte-h":!0}),o(v)!=="svelte-184xl32"&&(v.innerHTML=Vt),ma=n(l),G=r(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-15cpn12"&&(G.textContent=$t),da=n(l),W=r(l,"UL",{"data-svelte-h":!0}),o(W)!=="svelte-tafea8"&&(W.innerHTML=Yt),ja=n(l),M(N.$$.fragment,l),ha=n(l),R=r(l,"P",{"data-svelte-h":!0}),o(R)!=="svelte-133fvrx"&&(R.innerHTML=Qt),ua=n(l),L=r(l,"P",{"data-svelte-h":!0}),o(L)!=="svelte-11obs5x"&&(L.innerHTML=Ht),Ta=n(l),S=r(l,"P",{"data-svelte-h":!0}),o(S)!=="svelte-18td9in"&&(S.textContent=Ft),ya=n(l),M(X.$$.fragment,l),Ja=n(l),E=r(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-vu4jqg"&&(E.innerHTML=zt),wa=n(l),V=r(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-lk6p2b"&&(V.innerHTML=Dt),Ua=n(l),$=r(l,"UL",{"data-svelte-h":!0}),o($)!=="svelte-13w1ul0"&&($.innerHTML=Pt),ga=n(l),Y=r(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1uul3pu"&&(Y.textContent=qt),Ia=n(l),M(Q.$$.fragment,l),fa=n(l),H=r(l,"P",{"data-svelte-h":!0}),o(H)!=="svelte-yp62pj"&&(H.innerHTML=Ot),ba=n(l),F=r(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-mvmzld"&&(F.innerHTML=Kt),xa=n(l),M(z.$$.fragment,l),Aa=n(l),D=r(l,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1dy61ct"&&(D.textContent=ls),_a=n(l),M(P.$$.fragment,l),Ca=n(l),q=r(l,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1nxkgn3"&&(q.innerHTML=as),Za=n(l),O=r(l,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1p2hzi3"&&(O.textContent=ts),Ba=n(l),K=r(l,"P",{"data-svelte-h":!0}),o(K)!=="svelte-ddfu18"&&(K.textContent=ss),ka=n(l),ll=r(l,"UL",{"data-svelte-h":!0}),o(ll)!=="svelte-33oy38"&&(ll.innerHTML=es),va=n(l),al=r(l,"P",{"data-svelte-h":!0}),o(al)!=="svelte-1e4ceru"&&(al.innerHTML=ns),Ga=n(l),M(tl.$$.fragment,l),Wa=n(l),M(sl.$$.fragment,l),Na=n(l),el=r(l,"UL",{"data-svelte-h":!0}),o(el)!=="svelte-rrm2jf"&&(el.innerHTML=is),Ra=n(l),M(nl.$$.fragment,l),La=n(l),il=r(l,"UL",{"data-svelte-h":!0}),o(il)!=="svelte-15q2x65"&&(il.innerHTML=rs),Sa=n(l),M(rl.$$.fragment,l),Xa=n(l),ol=r(l,"UL",{"data-svelte-h":!0}),o(ol)!=="svelte-1mjr57j"&&(ol.innerHTML=os),Ea=n(l),M(pl.$$.fragment,l),Va=n(l),Ml=r(l,"UL",{"data-svelte-h":!0}),o(Ml)!=="svelte-l0nn26"&&(Ml.innerHTML=ps),$a=n(l),M(cl.$$.fragment,l),Ya=n(l),M(ml.$$.fragment,l),Qa=n(l),dl=r(l,"P",{"data-svelte-h":!0}),o(dl)!=="svelte-w93wft"&&(dl.innerHTML=Ms),Ha=n(l),M(jl.$$.fragment,l),Fa=n(l),hl=r(l,"P",{"data-svelte-h":!0}),o(hl)!=="svelte-1bgjcjp"&&(hl.innerHTML=cs),za=n(l),ul=r(l,"P",{"data-svelte-h":!0}),o(ul)!=="svelte-f33m01"&&(ul.textContent=ms),Da=n(l),M(Tl.$$.fragment,l),Pa=n(l),yl=r(l,"P",{"data-svelte-h":!0}),o(yl)!=="svelte-16o65sp"&&(yl.innerHTML=ds),qa=n(l),Jl=r(l,"P",{"data-svelte-h":!0}),o(Jl)!=="svelte-1llakb4"&&(Jl.textContent=js),Oa=n(l),M(wl.$$.fragment,l),Ka=n(l),Ul=r(l,"P",{"data-svelte-h":!0}),o(Ul)!=="svelte-1wjzbog"&&(Ul.innerHTML=hs),lt=n(l),M(gl.$$.fragment,l),at=n(l),Il=r(l,"P",{"data-svelte-h":!0}),o(Il)!=="svelte-162edsd"&&(Il.textContent=us),tt=n(l),fl=r(l,"P",{"data-svelte-h":!0}),o(fl)!=="svelte-1j1shdy"&&(fl.innerHTML=Ts),st=n(l),bl=r(l,"P",{"data-svelte-h":!0}),o(bl)!=="svelte-1kfnl8a"&&(bl.innerHTML=ys),et=n(l),xl=r(l,"P",{"data-svelte-h":!0}),o(xl)!=="svelte-58ln7g"&&(xl.innerHTML=Js),nt=n(l),M(Al.$$.fragment,l),it=n(l),M(_l.$$.fragment,l),rt=n(l),y=r(l,"DIV",{class:!0});var At=Ct(y);M(Cl.$$.fragment,At),_t=n(At),Fl=r(At,"P",{"data-svelte-h":!0}),o(Fl)!=="svelte-1ij51xj"&&(Fl.textContent=ws),At.forEach(t),ot=n(l),M(Zl.$$.fragment,l),pt=n(l),Bl=r(l,"P",{"data-svelte-h":!0}),o(Bl)!=="svelte-e4s8t7"&&(Bl.textContent=Us),Mt=n(l),kl=r(l,"UL",{"data-svelte-h":!0}),o(kl)!=="svelte-fndsqh"&&(kl.innerHTML=gs),ct=n(l),vl=r(l,"P",{"data-svelte-h":!0}),o(vl)!=="svelte-tqxemj"&&(vl.innerHTML=Is),mt=n(l),Gl=r(l,"UL",{"data-svelte-h":!0}),o(Gl)!=="svelte-12l6tzi"&&(Gl.innerHTML=fs),dt=n(l),Wl=r(l,"P",{"data-svelte-h":!0}),o(Wl)!=="svelte-4yc3zu"&&(Wl.innerHTML=bs),jt=n(l),M(Nl.$$.fragment,l),ht=n(l),M(Rl.$$.fragment,l),ut=n(l),M(Ll.$$.fragment,l),Tt=n(l),M(Sl.$$.fragment,l),yt=n(l),M(Xl.$$.fragment,l),Jt=n(l),M(El.$$.fragment,l),wt=n(l),M(Vl.$$.fragment,l),Ut=n(l),M($l.$$.fragment,l),gt=n(l),M(Yl.$$.fragment,l),It=n(l),M(Ql.$$.fragment,l),ft=n(l),M(Hl.$$.fragment,l),bt=n(l),Dl=r(l,"P",{}),Ct(Dl).forEach(t),this.h()},h(){Zt(T,"name","hf:doc:metadata"),Zt(T,"content",Ws),Zt(y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(l,a){Bt(document.head,T),s(l,Pl,a),s(l,zl,a),s(l,ql,a),c(J,l,a),s(l,Ol,a),s(l,w,a),s(l,Kl,a),c(U,l,a),s(l,la,a),s(l,g,a),s(l,aa,a),c(I,l,a),s(l,ta,a),s(l,f,a),s(l,sa,a),s(l,b,a),s(l,ea,a),c(x,l,a),s(l,na,a),s(l,A,a),s(l,ia,a),c(_,l,a),s(l,ra,a),s(l,C,a),s(l,oa,a),s(l,Z,a),s(l,pa,a),s(l,B,a),s(l,Ma,a),s(l,k,a),s(l,ca,a),s(l,v,a),s(l,ma,a),s(l,G,a),s(l,da,a),s(l,W,a),s(l,ja,a),c(N,l,a),s(l,ha,a),s(l,R,a),s(l,ua,a),s(l,L,a),s(l,Ta,a),s(l,S,a),s(l,ya,a),c(X,l,a),s(l,Ja,a),s(l,E,a),s(l,wa,a),s(l,V,a),s(l,Ua,a),s(l,$,a),s(l,ga,a),s(l,Y,a),s(l,Ia,a),c(Q,l,a),s(l,fa,a),s(l,H,a),s(l,ba,a),s(l,F,a),s(l,xa,a),c(z,l,a),s(l,Aa,a),s(l,D,a),s(l,_a,a),c(P,l,a),s(l,Ca,a),s(l,q,a),s(l,Za,a),s(l,O,a),s(l,Ba,a),s(l,K,a),s(l,ka,a),s(l,ll,a),s(l,va,a),s(l,al,a),s(l,Ga,a),c(tl,l,a),s(l,Wa,a),c(sl,l,a),s(l,Na,a),s(l,el,a),s(l,Ra,a),c(nl,l,a),s(l,La,a),s(l,il,a),s(l,Sa,a),c(rl,l,a),s(l,Xa,a),s(l,ol,a),s(l,Ea,a),c(pl,l,a),s(l,Va,a),s(l,Ml,a),s(l,$a,a),c(cl,l,a),s(l,Ya,a),c(ml,l,a),s(l,Qa,a),s(l,dl,a),s(l,Ha,a),c(jl,l,a),s(l,Fa,a),s(l,hl,a),s(l,za,a),s(l,ul,a),s(l,Da,a),c(Tl,l,a),s(l,Pa,a),s(l,yl,a),s(l,qa,a),s(l,Jl,a),s(l,Oa,a),c(wl,l,a),s(l,Ka,a),s(l,Ul,a),s(l,lt,a),c(gl,l,a),s(l,at,a),s(l,Il,a),s(l,tt,a),s(l,fl,a),s(l,st,a),s(l,bl,a),s(l,et,a),s(l,xl,a),s(l,nt,a),c(Al,l,a),s(l,it,a),c(_l,l,a),s(l,rt,a),s(l,y,a),c(Cl,y,null),Bt(y,_t),Bt(y,Fl),s(l,ot,a),c(Zl,l,a),s(l,pt,a),s(l,Bl,a),s(l,Mt,a),s(l,kl,a),s(l,ct,a),s(l,vl,a),s(l,mt,a),s(l,Gl,a),s(l,dt,a),s(l,Wl,a),s(l,jt,a),c(Nl,l,a),s(l,ht,a),c(Rl,l,a),s(l,ut,a),c(Ll,l,a),s(l,Tt,a),c(Sl,l,a),s(l,yt,a),c(Xl,l,a),s(l,Jt,a),c(El,l,a),s(l,wt,a),c(Vl,l,a),s(l,Ut,a),c($l,l,a),s(l,gt,a),c(Yl,l,a),s(l,It,a),c(Ql,l,a),s(l,ft,a),c(Hl,l,a),s(l,bt,a),s(l,Dl,a),xt=!0},p:As,i(l){xt||(m(J.$$.fragment,l),m(U.$$.fragment,l),m(I.$$.fragment,l),m(x.$$.fragment,l),m(_.$$.fragment,l),m(N.$$.fragment,l),m(X.$$.fragment,l),m(Q.$$.fragment,l),m(z.$$.fragment,l),m(P.$$.fragment,l),m(tl.$$.fragment,l),m(sl.$$.fragment,l),m(nl.$$.fragment,l),m(rl.$$.fragment,l),m(pl.$$.fragment,l),m(cl.$$.fragment,l),m(ml.$$.fragment,l),m(jl.$$.fragment,l),m(Tl.$$.fragment,l),m(wl.$$.fragment,l),m(gl.$$.fragment,l),m(Al.$$.fragment,l),m(_l.$$.fragment,l),m(Cl.$$.fragment,l),m(Zl.$$.fragment,l),m(Nl.$$.fragment,l),m(Rl.$$.fragment,l),m(Ll.$$.fragment,l),m(Sl.$$.fragment,l),m(Xl.$$.fragment,l),m(El.$$.fragment,l),m(Vl.$$.fragment,l),m($l.$$.fragment,l),m(Yl.$$.fragment,l),m(Ql.$$.fragment,l),m(Hl.$$.fragment,l),xt=!0)},o(l){d(J.$$.fragment,l),d(U.$$.fragment,l),d(I.$$.fragment,l),d(x.$$.fragment,l),d(_.$$.fragment,l),d(N.$$.fragment,l),d(X.$$.fragment,l),d(Q.$$.fragment,l),d(z.$$.fragment,l),d(P.$$.fragment,l),d(tl.$$.fragment,l),d(sl.$$.fragment,l),d(nl.$$.fragment,l),d(rl.$$.fragment,l),d(pl.$$.fragment,l),d(cl.$$.fragment,l),d(ml.$$.fragment,l),d(jl.$$.fragment,l),d(Tl.$$.fragment,l),d(wl.$$.fragment,l),d(gl.$$.fragment,l),d(Al.$$.fragment,l),d(_l.$$.fragment,l),d(Cl.$$.fragment,l),d(Zl.$$.fragment,l),d(Nl.$$.fragment,l),d(Rl.$$.fragment,l),d(Ll.$$.fragment,l),d(Sl.$$.fragment,l),d(Xl.$$.fragment,l),d(El.$$.fragment,l),d(Vl.$$.fragment,l),d($l.$$.fragment,l),d(Yl.$$.fragment,l),d(Ql.$$.fragment,l),d(Hl.$$.fragment,l),xt=!1},d(l){l&&(t(Pl),t(zl),t(ql),t(Ol),t(w),t(Kl),t(la),t(g),t(aa),t(ta),t(f),t(sa),t(b),t(ea),t(na),t(A),t(ia),t(ra),t(C),t(oa),t(Z),t(pa),t(B),t(Ma),t(k),t(ca),t(v),t(ma),t(G),t(da),t(W),t(ja),t(ha),t(R),t(ua),t(L),t(Ta),t(S),t(ya),t(Ja),t(E),t(wa),t(V),t(Ua),t($),t(ga),t(Y),t(Ia),t(fa),t(H),t(ba),t(F),t(xa),t(Aa),t(D),t(_a),t(Ca),t(q),t(Za),t(O),t(Ba),t(K),t(ka),t(ll),t(va),t(al),t(Ga),t(Wa),t(Na),t(el),t(Ra),t(La),t(il),t(Sa),t(Xa),t(ol),t(Ea),t(Va),t(Ml),t($a),t(Ya),t(Qa),t(dl),t(Ha),t(Fa),t(hl),t(za),t(ul),t(Da),t(Pa),t(yl),t(qa),t(Jl),t(Oa),t(Ka),t(Ul),t(lt),t(at),t(Il),t(tt),t(fl),t(st),t(bl),t(et),t(xl),t(nt),t(it),t(rt),t(y),t(ot),t(pt),t(Bl),t(Mt),t(kl),t(ct),t(vl),t(mt),t(Gl),t(dt),t(Wl),t(jt),t(ht),t(ut),t(Tt),t(yt),t(Jt),t(wt),t(Ut),t(gt),t(It),t(ft),t(bt),t(Dl)),t(T),j(J,l),j(U,l),j(I,l),j(x,l),j(_,l),j(N,l),j(X,l),j(Q,l),j(z,l),j(P,l),j(tl,l),j(sl,l),j(nl,l),j(rl,l),j(pl,l),j(cl,l),j(ml,l),j(jl,l),j(Tl,l),j(wl,l),j(gl,l),j(Al,l),j(_l,l),j(Cl),j(Zl,l),j(Nl,l),j(Rl,l),j(Ll,l),j(Sl,l),j(Xl,l),j(El,l),j(Vl,l),j($l,l),j(Yl,l),j(Ql,l),j(Hl,l)}}}const Ws='{"title":"LLM Finetuning with AutoTrain Advanced","local":"llm-finetuning-with-autotrain-advanced","sections":[{"title":"Key Features","local":"key-features","sections":[],"depth":2},{"title":"Supported Training Methods","local":"supported-training-methods","sections":[],"depth":2},{"title":"Data Preparation","local":"data-preparation","sections":[{"title":"Classic Text Generation","local":"classic-text-generation","sections":[],"depth":3},{"title":"Chatbot / question-answering / code generation / function calling","local":"chatbot--question-answering--code-generation--function-calling","sections":[],"depth":3}],"depth":2},{"title":"Best Practices for LLM Fine-tuning","local":"best-practices-for-llm-fine-tuning","sections":[{"title":"Memory Optimization","local":"memory-optimization","sections":[],"depth":3},{"title":"Data Quality","local":"data-quality","sections":[],"depth":3},{"title":"Training Tips","local":"training-tips","sections":[],"depth":3},{"title":"Related Resources","local":"related-resources","sections":[],"depth":3}],"depth":2},{"title":"Training","local":"training","sections":[{"title":"Local Training","local":"local-training","sections":[],"depth":3},{"title":"Training in Hugging Face Spaces","local":"training-in-hugging-face-spaces","sections":[],"depth":3}],"depth":2},{"title":"Parameters","local":"parameters","sections":[{"title":"LLM Fine Tuning Parameters","local":"autotrain.trainers.clm.params.LLMTrainingParams","sections":[],"depth":3},{"title":"Task specific parameters","local":"task-specific-parameters","sections":[{"title":"Generic Trainer","local":"generic-trainer","sections":[],"depth":4},{"title":"SFT Trainer","local":"sft-trainer","sections":[],"depth":4},{"title":"Reward Trainer","local":"reward-trainer","sections":[],"depth":4},{"title":"DPO Trainer","local":"dpo-trainer","sections":[],"depth":4},{"title":"ORPO Trainer","local":"orpo-trainer","sections":[],"depth":4}],"depth":3}],"depth":2}],"depth":1}';function Ns(kt){return _s(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends Cs{constructor(T){super(),Zs(this,T,Ns,Gs,xs,{})}}export{Vs as component};
