import{s as Zn,o as jn,n as ns}from"../chunks/scheduler.182ea377.js";import{S as Wn,i as vn,g as i,s as n,p as d,A as Cn,h as o,f as t,c as a,j as b,q as M,m as p,k as r,v as g,a as s,r as h,d as u,t as y,u as f}from"../chunks/index.008d68e4.js";import{T as ss}from"../chunks/Tip.4f096367.js";import{I as cl}from"../chunks/IconCopyLink.96bbb92b.js";import{C as w}from"../chunks/CodeBlock.5ed6eb7b.js";function Gn(Z){let m,U='Check out Section 3.5 of the <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">ControlNet</a> paper v1 for a list of ControlNet implementations on various conditioning inputs. You can find the official Stable Diffusion ControlNet conditioned models on <a href="https://huggingface.co/lllyasviel" rel="nofollow">lllyasviel</a>’s Hub profile, and more <a href="https://huggingface.co/models?other=stable-diffusion&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.',c,J,k='For Stable Diffusion XL (SDXL) ControlNet models, you can find them on the 🤗 <a href="https://huggingface.co/diffusers" rel="nofollow">Diffusers</a> Hub organization, or you can browse <a href="https://huggingface.co/models?other=stable-diffusion-xl&amp;other=controlnet" rel="nofollow">community-trained</a> ones on the Hub.';return{c(){m=i("p"),m.innerHTML=U,c=n(),J=i("p"),J.innerHTML=k},l(T){m=o(T,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1scaly9"&&(m.innerHTML=U),c=a(T),J=o(T,"P",{"data-svelte-h":!0}),p(J)!=="svelte-2pe81s"&&(J.innerHTML=k)},m(T,O){s(T,m,O),s(T,c,O),s(T,J,O)},p:ns,d(T){T&&(t(m),t(c),t(J))}}}function In(Z){let m,U="Guess mode does not have any impact on prompt conditioning and you can still provide a prompt if you want.";return{c(){m=i("p"),m.textContent=U},l(c){m=o(c,"P",{"data-svelte-h":!0}),p(m)!=="svelte-14ez4w"&&(m.textContent=U)},m(c,J){s(c,m,J)},p:ns,d(c){c&&t(m)}}}function kn(Z){let m,U='The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter determines how much weight to assign to the conditioning inputs. A value of 0.5 is recommended for good generalization, but feel free to experiment with this number!';return{c(){m=i("p"),m.innerHTML=U},l(c){m=o(c,"P",{"data-svelte-h":!0}),p(m)!=="svelte-52h992"&&(m.innerHTML=U)},m(c,J){s(c,m,J)},p:ns,d(c){c&&t(m)}}}function _n(Z){let m,U='Replace the SDXL model with a model like <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow">runwayml/stable-diffusion-v1-5</a> to use multiple conditioning inputs with Stable Diffusion models.';return{c(){m=i("p"),m.innerHTML=U},l(c){m=o(c,"P",{"data-svelte-h":!0}),p(m)!=="svelte-lnumtz"&&(m.innerHTML=U)},m(c,J){s(c,m,J)},p:ns,d(c){c&&t(m)}}}function Nn(Z){let m,U,c,J,k,T,O,dl,cs="ControlNet",vl,ee,ds="ControlNet is a type of model for controlling image diffusion models by conditioning the model with an additional input image. There are many types of conditioning inputs (canny edge, user sketching, human pose, depth, and more) you can use to control a diffusion model. This is hugely useful because it affords you greater control over image generation, making it easier to generate specific images without experimenting with different text prompts or denoising values as much.",Cl,_,Gl,le,Ms="A ControlNet model has two sets of weights (or blocks) connected by a zero-convolution layer:",Il,te,hs="<li>a <em>locked copy</em> keeps everything a large pretrained diffusion model has learned</li> <li>a <em>trainable copy</em> is trained on the additional conditioning input</li>",kl,se,us="Since the locked copy preserves the pretrained model, training and implementing a ControlNet on a new conditioning input is as fast as finetuning any other model because you aren’t training the model from scratch.",_l,ne,ys="This guide will show you how to use ControlNet for text-to-image, image-to-image, inpainting, and more! There are many types of ControlNet conditioning inputs to choose from, but in this guide we’ll only focus on several of them. Feel free to experiment with other conditioning inputs!",Nl,ae,fs="Before you begin, make sure you have the following libraries installed:",Bl,ie,xl,j,N,Jl,oe,as,Ml,gs="Text-to-image",Xl,pe,Js="For text-to-image, you normally pass a text prompt to the model. But with ControlNet, you can specify an additional conditioning input. Let’s condition the model with a canny image, a white outline of an image on a black background. This way, the ControlNet can use the canny image as a control to guide the model to generate an image with the same outline.",Yl,me,bs='Load an image and use the <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a> library to extract the canny image:',El,re,Rl,B,ws='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/vermeer_canny_edged.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',Vl,ce,Ts='Next, load a ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/v0.25.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',Fl,de,Ql,Me,Us="Now pass your prompt and canny image to the pipeline:",Sl,he,$l,x,Zs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-text2img.png"/>',Hl,W,X,bl,ue,is,hl,js="Image-to-image",zl,ye,Ws="For image-to-image, you’d typically pass an initial image and a prompt to the pipeline to generate a new image. With ControlNet, you can pass an additional conditioning input to guide the model. Let’s condition the model with a depth map, an image which contains spatial information. This way, the ControlNet can use the depth map as a control to guide the model to generate an image that preserves spatial information.",Al,fe,vs='You’ll use the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a> for this task, which is different from the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline">StableDiffusionControlNetPipeline</a> because it allows you to pass an initial image as the starting point for the image generation process.',Ll,ge,Cs='Load an image and use the <code>depth-estimation</code> <a href="https://huggingface.co/docs/transformers/v4.36.2/en/main_classes/pipelines#transformers.Pipeline" rel="nofollow">Pipeline</a> from 🤗 Transformers to extract the depth map of an image:',Dl,Je,ql,be,Gs='Next, load a ControlNet model conditioned on depth maps and pass it to the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetImg2ImgPipeline">StableDiffusionControlNetImg2ImgPipeline</a>. Use the faster <a href="/docs/diffusers/v0.25.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',Pl,we,Kl,Te,Is="Now pass your prompt, initial image, and depth map to the pipeline:",Ol,Ue,et,Y,ks='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img-2.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">generated image</figcaption></div>',lt,v,E,wl,Ze,os,ul,_s="Inpainting",tt,je,Ns="For inpainting, you need an initial image, a mask image, and a prompt describing what to replace the mask with. ControlNet models allow you to add another control image to condition a model with. Let’s condition the model with an inpainting mask. This way, the ControlNet can use the inpainting mask as a control to guide the model to generate an image within the mask area.",st,We,Bs="Load an initial image and a mask image:",nt,ve,at,Ce,xs="Create a function to prepare the control image from the initial and mask images. This’ll create a tensor to mark the pixels in <code>init_image</code> as masked if the corresponding pixel in <code>mask_image</code> is over a certain threshold.",it,Ge,ot,R,Xs='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg"/> <figcaption class="mt-2 text-center text-sm text-gray-500">mask image</figcaption></div>',pt,Ie,Ys='Load a ControlNet model conditioned on inpainting and pass it to the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetInpaintPipeline">StableDiffusionControlNetInpaintPipeline</a>. Use the faster <a href="/docs/diffusers/v0.25.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to speed up inference and reduce memory usage.',mt,ke,rt,_e,Es="Now pass your prompt, initial image, mask image, and control image to the pipeline:",ct,Ne,dt,V,Rs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-result.png"/>',Mt,C,F,Tl,Be,ps,yl,Vs="Guess mode",ht,xe,Fs='<a href="https://github.com/lllyasviel/ControlNet/discussions/188" rel="nofollow">Guess mode</a> does not require supplying a prompt to a ControlNet at all! This forces the ControlNet encoder to do it’s best to “guess” the contents of the input control map (depth map, pose estimation, canny edge, etc.).',ut,Xe,Qs="Guess mode adjusts the scale of the output residuals from a ControlNet by a fixed ratio depending on the block depth. The shallowest <code>DownBlock</code> corresponds to 0.1, and as the blocks get deeper, the scale increases exponentially such that the scale of the <code>MidBlock</code> output becomes 1.0.",yt,Q,ft,Ye,Ss='Set <code>guess_mode=True</code> in the pipeline, and it is <a href="https://github.com/lllyasviel/ControlNet#guess-mode--non-prompt-mode" rel="nofollow">recommended</a> to set the <code>guidance_scale</code> value between 3.0 and 5.0.',gt,Ee,Jt,S,$s='<div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">regular mode with prompt</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/takuma104/controlnet_dev/resolve/main/gen_compare_guess_mode/output_images/diffusers/output_bird_canny_0_gm.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">guess mode without prompt</figcaption></div>',bt,G,$,Ul,Re,ms,fl,Hs="ControlNet with Stable Diffusion XL",wt,Ve,zs='There aren’t too many ControlNet models compatible with Stable Diffusion XL (SDXL) at the moment, but we’ve trained two full-sized ControlNet models for SDXL conditioned on canny edge detection and depth maps. We’re also experimenting with creating smaller versions of these SDXL-compatible ControlNet models so it is easier to run on resource-constrained hardware. You can find these checkpoints on the <a href="https://huggingface.co/diffusers" rel="nofollow">🤗 Diffusers Hub organization</a>!',Tt,Fe,As="Let’s use a SDXL ControlNet conditioned on canny images to generate an image. Start by loading an image and prepare the canny image:",Ut,Qe,Zt,H,Ls='<div><img class="rounded-xl" src="https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/hf-logo-canny.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',jt,Se,Ds='Load a SDXL ControlNet model conditioned on canny edge detection and pass it to the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. You can also enable model offloading to reduce memory usage.',Wt,$e,vt,He,qs="Now pass your prompt (and optionally a negative prompt if you’re using one) and canny image to the pipeline:",Ct,z,Gt,ze,It,A,Ps='<img class="rounded-xl" src="https://huggingface.co/diffusers/controlnet-canny-sdxl-1.0/resolve/main/out_hug_lab_7.png"/>',kt,Ae,Ks='You can use <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a> in guess mode as well by setting the parameter to <code>True</code>:',_t,Le,Nt,I,L,Zl,De,rs,gl,Os="MultiControlNet",Bt,D,xt,qe,en="You can compose multiple ControlNet conditionings from different image inputs to create a <em>MultiControlNet</em>. To get better results, it is often helpful to:",Xt,Pe,ln='<li>mask conditionings such that they don’t overlap (for example, mask the area of a canny image where the pose conditioning is located)</li> <li>experiment with the <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/controlnet#diffusers.StableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale" rel="nofollow"><code>controlnet_conditioning_scale</code></a> parameter to determine how much weight to assign to each conditioning input</li>',Yt,Ke,tn="In this example, you’ll combine a canny image and a human pose estimation image to generate a new image.",Et,Oe,sn="Prepare the canny image conditioning:",Rt,el,Vt,q,nn='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/landscape_canny_masked.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">canny image</figcaption></div>',Ft,ll,an='For human pose estimation, install <a href="https://github.com/patrickvonplaten/controlnet_aux" rel="nofollow">controlnet_aux</a>:',Qt,tl,St,sl,on="Prepare the human pose estimation conditioning:",$t,nl,Ht,P,pn='<div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">original image</figcaption></div> <div><img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/blog/controlnet/person_pose.png"/> <figcaption class="mt-2 text-center text-sm text-gray-500">human pose image</figcaption></div>',zt,al,mn='Load a list of ControlNet models that correspond to each conditioning, and pass them to the <a href="/docs/diffusers/v0.25.0/en/api/pipelines/controlnet_sdxl#diffusers.StableDiffusionXLControlNetPipeline">StableDiffusionXLControlNetPipeline</a>. Use the faster <a href="/docs/diffusers/v0.25.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a> and enable model offloading to reduce memory usage.',At,il,Lt,ol,rn="Now you can pass your prompt (an optional negative prompt if you’re using one), canny image, and pose image to the pipeline:",Dt,pl,qt,K,cn='<img class="rounded-xl" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/multicontrolnet.png"/>',Pt;return T=new cl({}),_=new ss({props:{$$slots:{default:[Gn]},$$scope:{ctx:Z}}}),ie=new w({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwb3BlbmN2LXB5dGhvbg==",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate opencv-python</span>`}}),oe=new cl({}),re=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBjdjIlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZoZi5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGaW5wdXRfaW1hZ2VfdmVybWVlci5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShvcmlnaW5hbF9pbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/huggingface/documentation-images/resolve/main/diffusers/input_image_vermeer.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`}}),de=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`}}),he=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJ0aGUlMjBtb25hJTIwbGlzYSUyMiUyQyUyMGltYWdlJTNEY2FubnlfaW1hZ2UlMEEpLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;the mona lisa&quot;</span>, image=canny_image
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),ue=new cl({}),Je=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUyQyUyMG1ha2VfaW1hZ2VfZ3JpZCUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWltZzJpbWcuanBnJTIyJTBBKSUwQSUwQWRlZiUyMGdldF9kZXB0aF9tYXAoaW1hZ2UlMkMlMjBkZXB0aF9lc3RpbWF0b3IpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBkZXB0aF9lc3RpbWF0b3IoaW1hZ2UpJTVCJTIyZGVwdGglMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEElMjAlMjAlMjAlMjBkZXRlY3RlZF9tYXAlMjAlM0QlMjB0b3JjaC5mcm9tX251bXB5KGltYWdlKS5mbG9hdCgpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBkZXB0aF9tYXAlMjAlM0QlMjBkZXRlY3RlZF9tYXAucGVybXV0ZSgyJTJDJTIwMCUyQyUyMDEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGVwdGhfbWFwJTBBJTBBZGVwdGhfZXN0aW1hdG9yJTIwJTNEJTIwcGlwZWxpbmUoJTIyZGVwdGgtZXN0aW1hdGlvbiUyMiklMEFkZXB0aF9tYXAlMjAlM0QlMjBnZXRfZGVwdGhfbWFwKGltYWdlJTJDJTIwZGVwdGhfZXN0aW1hdG9yKS51bnNxdWVlemUoMCkuaGFsZigpLnRvKCUyMmN1ZGElMjIp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-img2img.jpg&quot;</span>
)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image, depth_estimator</span>):
    image = depth_estimator(image)[<span class="hljs-string">&quot;depth&quot;</span>]
    image = np.array(image)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    detected_map = torch.from_numpy(image).<span class="hljs-built_in">float</span>() / <span class="hljs-number">255.0</span>
    depth_map = detected_map.permute(<span class="hljs-number">2</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>)
    <span class="hljs-keyword">return</span> depth_map

depth_estimator = pipeline(<span class="hljs-string">&quot;depth-estimation&quot;</span>)
depth_map = get_depth_map(image, depth_estimator).unsqueeze(<span class="hljs-number">0</span>).half().to(<span class="hljs-string">&quot;cuda&quot;</span>)`}}),we=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbWcySW1nUGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBY29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRmNvbnRyb2xfdjExZjFwX3NkMTVfZGVwdGglMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25Db250cm9sTmV0SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0JTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSklMEElMEFwaXBlLnNjaGVkdWxlciUyMCUzRCUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGUuc2NoZWR1bGVyLmNvbmZpZyklMEFwaXBlLmVuYWJsZV9tb2RlbF9jcHVfb2ZmbG9hZCgp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetImg2ImgPipeline, ControlNetModel, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11f1p_sd15_depth&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`}}),Ue=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJsZWdvJTIwYmF0bWFuJTIwYW5kJTIwcm9iaW4lMjIlMkMlMjBpbWFnZSUzRGltYWdlJTJDJTIwY29udHJvbF9pbWFnZSUzRGRlcHRoX21hcCUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;lego batman and robin&quot;</span>, image=image, control_image=depth_map,
).images[<span class="hljs-number">0</span>]
make_image_grid([image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),Ze=new cl({}),ve=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQuanBnJTIyJTBBKSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBpbml0X2ltYWdlLnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMEElMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZjb250cm9sbmV0LWlucGFpbnQtbWFzay5qcGclMjIlMEEpJTBBbWFza19pbWFnZSUyMCUzRCUyMG1hc2tfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint.jpg&quot;</span>
)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

mask_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/controlnet-inpaint-mask.jpg&quot;</span>
)
mask_image = mask_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))
make_image_grid([init_image, mask_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),Ge=new w({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFkZWYlMjBtYWtlX2lucGFpbnRfY29uZGl0aW9uKGltYWdlJTJDJTIwaW1hZ2VfbWFzayklM0ElMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlLmNvbnZlcnQoJTIyUkdCJTIyKSkuYXN0eXBlKG5wLmZsb2F0MzIpJTIwJTJGJTIwMjU1LjAlMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2VfbWFzay5jb252ZXJ0KCUyMkwlMjIpKS5hc3R5cGUobnAuZmxvYXQzMiklMjAlMkYlMjAyNTUuMCUwQSUwQSUyMCUyMCUyMCUyMGFzc2VydCUyMGltYWdlLnNoYXBlJTVCMCUzQTElNUQlMjAlM0QlM0QlMjBpbWFnZV9tYXNrLnNoYXBlJTVCMCUzQTElNUQlMEElMjAlMjAlMjAlMjBpbWFnZSU1QmltYWdlX21hc2slMjAlM0UlMjAwLjUlNUQlMjAlM0QlMjAtMS4wJTIwJTIwJTIzJTIwc2V0JTIwYXMlMjBtYXNrZWQlMjBwaXhlbCUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuZXhwYW5kX2RpbXMoaW1hZ2UlMkMlMjAwKS50cmFuc3Bvc2UoMCUyQyUyMDMlMkMlMjAxJTJDJTIwMiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMHRvcmNoLmZyb21fbnVtcHkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW1hZ2UlMEElMEFjb250cm9sX2ltYWdlJTIwJTNEJTIwbWFrZV9pbnBhaW50X2NvbmRpdGlvbihpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_inpaint_condition</span>(<span class="hljs-params">image, image_mask</span>):
    image = np.array(image.convert(<span class="hljs-string">&quot;RGB&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>
    image_mask = np.array(image_mask.convert(<span class="hljs-string">&quot;L&quot;</span>)).astype(np.float32) / <span class="hljs-number">255.0</span>

    <span class="hljs-keyword">assert</span> image.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>] == image_mask.shape[<span class="hljs-number">0</span>:<span class="hljs-number">1</span>]
    image[image_mask &gt; <span class="hljs-number">0.5</span>] = -<span class="hljs-number">1.0</span>  <span class="hljs-comment"># set as masked pixel</span>
    image = np.expand_dims(image, <span class="hljs-number">0</span>).transpose(<span class="hljs-number">0</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>)
    image = torch.from_numpy(image)
    <span class="hljs-keyword">return</span> image

control_image = make_inpaint_condition(init_image, mask_image)`}}),ke=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMkMlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlciUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmxsbHlhc3ZpZWwlMkZjb250cm9sX3YxMXBfc2QxNV9pbnBhaW50JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uQ29udHJvbE5ldElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetInpaintPipeline, ControlNetModel, UniPCMultistepScheduler

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/control_v11p_sd15_inpaint&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)

pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`}}),Ne=new w({props:{code:"b3V0cHV0JTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjAlMjJjb3JnaSUyMGZhY2UlMjB3aXRoJTIwbGFyZ2UlMjBlYXJzJTJDJTIwZGV0YWlsZWQlMkMlMjBwaXhhciUyQyUyMGFuaW1hdGVkJTJDJTIwZGlzbmV5JTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwJTJDJTBBJTIwJTIwJTIwJTIwZXRhJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwbWFza19pbWFnZSUzRG1hc2tfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEY29udHJvbF9pbWFnZSUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwbWFza19pbWFnZSUyQyUyMG91dHB1dCU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`output = pipe(
    <span class="hljs-string">&quot;corgi face with large ears, detailed, pixar, animated, disney&quot;</span>,
    num_inference_steps=<span class="hljs-number">20</span>,
    eta=<span class="hljs-number">1.0</span>,
    image=init_image,
    mask_image=mask_image,
    control_image=control_image,
).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, mask_image, output], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Be=new cl({}),Q=new ss({props:{$$slots:{default:[In]},$$scope:{ctx:Z}}}),Ee=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBjdjIlMEElMEFjb250cm9sbmV0JTIwJTNEJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJsbGx5YXN2aWVsJTJGc2QtY29udHJvbG5ldC1jYW5ueSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbkNvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpLnRvKCUyMmN1ZGElMjIpJTBBJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZ0YWt1bWExMDQlMkZjb250cm9sbmV0X2RldiUyRnJlc29sdmUlMkZtYWluJTJGYmlyZF81MTJ4NTEyLnBuZyUyMiklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTIyJTIyJTJDJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUyMGd1ZXNzX21vZGUlM0RUcnVlJTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjApLmltYWdlcyU1QjAlNUQlMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionControlNetPipeline, ControlNetModel
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2

controlnet = ControlNetModel.from_pretrained(<span class="hljs-string">&quot;lllyasviel/sd-controlnet-canny&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionControlNetPipeline.from_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, controlnet=controlnet, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

original_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/takuma104/controlnet_dev/resolve/main/bird_512x512.png&quot;</span>)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(<span class="hljs-string">&quot;&quot;</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>, guidance_scale=<span class="hljs-number">3.0</span>).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Re=new cl({}),Qe=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTJDJTIwbWFrZV9pbWFnZV9ncmlkJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwdG9yY2glMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkX2NvbnRyb2xuZXQlMkZoZi1sb2dvLnBuZyUyMiUwQSklMEElMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQWltYWdlJTIwJTNEJTIwaW1hZ2UlNUIlM0ElMkMlMjAlM0ElMkMlMjBOb25lJTVEJTBBaW1hZ2UlMjAlM0QlMjBucC5jb25jYXRlbmF0ZSglNUJpbWFnZSUyQyUyMGltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjBheGlzJTNEMiklMEFjYW5ueV9pbWFnZSUyMCUzRCUyMEltYWdlLmZyb21hcnJheShpbWFnZSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBjYW5ueV9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
make_image_grid([original_image, canny_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),$e=new w({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBdmFlJTIwJTNEJTIwQXV0b2VuY29kZXJLTC5mcm9tX3ByZXRyYWluZWQoJTIybWFkZWJ5b2xsaW4lMkZzZHhsLXZhZS1mcDE2LWZpeCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRHZhZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    vae=vae,
    torch_dtype=torch.float16,
    use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()`}}),z=new ss({props:{$$slots:{default:[kn]},$$scope:{ctx:Z}}}),ze=new w({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYWVyaWFsJTIwdmlldyUyQyUyMGElMjBmdXR1cmlzdGljJTIwcmVzZWFyY2glMjBjb21wbGV4JTIwaW4lMjBhJTIwYnJpZ2h0JTIwZm9nZ3klMjBqdW5nbGUlMkMlMjBoYXJkJTIwbGlnaHRpbmclMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAnbG93JTIwcXVhbGl0eSUyQyUyMGJhZCUyMHF1YWxpdHklMkMlMjBza2V0Y2hlcyclMEElMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwbmVnYXRpdmVfcHJvbXB0JTNEbmVnYXRpdmVfcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEMC41JTJDJTBBKS5pbWFnZXMlNUIwJTVEJTBBbWFrZV9pbWFnZV9ncmlkKCU1Qm9yaWdpbmFsX2ltYWdlJTJDJTIwY2FubnlfaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDMp",highlighted:`prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&#x27;low quality, bad quality, sketches&#x27;</span>

image = pipe(
    prompt,
    negative_prompt=negative_prompt,
    image=canny_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),Le=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

prompt = <span class="hljs-string">&quot;aerial view, a futuristic research complex in a bright foggy jungle, hard lighting&quot;</span>
negative_prompt = <span class="hljs-string">&quot;low quality, bad quality, sketches&quot;</span>

original_image = load_image(
    <span class="hljs-string">&quot;https://hf.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/hf-logo.png&quot;</span>
)

controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.enable_model_cpu_offload()

image = np.array(original_image)
image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)

image = pipe(
    prompt, negative_prompt=negative_prompt, controlnet_conditioning_scale=<span class="hljs-number">0.5</span>, image=canny_image, guess_mode=<span class="hljs-literal">True</span>,
).images[<span class="hljs-number">0</span>]
make_image_grid([original_image, canny_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">3</span>)`}}),De=new cl({}),D=new ss({props:{$$slots:{default:[_n]},$$scope:{ctx:Z}}}),el=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBjdjIlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbGFuZHNjYXBlLnBuZyUyMiUwQSklMEFpbWFnZSUyMCUzRCUyMG5wLmFycmF5KG9yaWdpbmFsX2ltYWdlKSUwQSUwQWxvd190aHJlc2hvbGQlMjAlM0QlMjAxMDAlMEFoaWdoX3RocmVzaG9sZCUyMCUzRCUyMDIwMCUwQSUwQWltYWdlJTIwJTNEJTIwY3YyLkNhbm55KGltYWdlJTJDJTIwbG93X3RocmVzaG9sZCUyQyUyMGhpZ2hfdGhyZXNob2xkKSUwQSUwQSUyMyUyMHplcm8lMjBvdXQlMjBtaWRkbGUlMjBjb2x1bW5zJTIwb2YlMjBpbWFnZSUyMHdoZXJlJTIwcG9zZSUyMHdpbGwlMjBiZSUyMG92ZXJsYWlkJTBBemVyb19zdGFydCUyMCUzRCUyMGltYWdlLnNoYXBlJTVCMSU1RCUyMCUyRiUyRiUyMDQlMEF6ZXJvX2VuZCUyMCUzRCUyMHplcm9fc3RhcnQlMjAlMkIlMjBpbWFnZS5zaGFwZSU1QjElNUQlMjAlMkYlMkYlMjAyJTBBaW1hZ2UlNUIlM0ElMkMlMjB6ZXJvX3N0YXJ0JTNBemVyb19lbmQlNUQlMjAlM0QlMjAwJTBBJTBBaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEFpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQWNhbm55X2ltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMGNhbm55X2ltYWdlJTVEJTJDJTIwcm93cyUzRDElMkMlMjBjb2xzJTNEMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> cv2

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/landscape.png&quot;</span>
)
image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)

<span class="hljs-comment"># zero out middle columns of image where pose will be overlaid</span>
zero_start = image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">4</span>
zero_end = zero_start + image.shape[<span class="hljs-number">1</span>] // <span class="hljs-number">2</span>
image[:, zero_start:zero_end] = <span class="hljs-number">0</span>

image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)
make_image_grid([original_image, canny_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),tl=new w({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyeSUyMGluJTIwQ29sYWIlMEElMjMhcGlwJTIwaW5zdGFsbCUyMC1xJTIwY29udHJvbG5ldC1hdXg=",highlighted:`<span class="hljs-comment"># uncomment to install the necessary library in Colab</span>
<span class="hljs-comment">#!pip install -q controlnet-aux</span>`}}),nl=new w({props:{code:"ZnJvbSUyMGNvbnRyb2xuZXRfYXV4JTIwaW1wb3J0JTIwT3BlbnBvc2VEZXRlY3RvciUwQSUwQW9wZW5wb3NlJTIwJTNEJTIwT3BlbnBvc2VEZXRlY3Rvci5mcm9tX3ByZXRyYWluZWQoJTIybGxseWFzdmllbCUyRkNvbnRyb2xOZXQlMjIpJTBBb3JpZ2luYWxfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRnBlcnNvbi5wbmclMjIlMEEpJTBBb3BlbnBvc2VfaW1hZ2UlMjAlM0QlMjBvcGVucG9zZShvcmlnaW5hbF9pbWFnZSklMEFtYWtlX2ltYWdlX2dyaWQoJTVCb3JpZ2luYWxfaW1hZ2UlMkMlMjBvcGVucG9zZV9pbWFnZSU1RCUyQyUyMHJvd3MlM0QxJTJDJTIwY29scyUzRDIp",highlighted:`<span class="hljs-keyword">from</span> controlnet_aux <span class="hljs-keyword">import</span> OpenposeDetector

openpose = OpenposeDetector.from_pretrained(<span class="hljs-string">&quot;lllyasviel/ControlNet&quot;</span>)
original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/person.png&quot;</span>
)
openpose_image = openpose(original_image)
make_image_grid([original_image, openpose_image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`}}),il=new w({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldFBpcGVsaW5lJTJDJTIwQ29udHJvbE5ldE1vZGVsJTJDJTIwQXV0b2VuY29kZXJLTCUyQyUyMFVuaVBDTXVsdGlzdGVwU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFjb250cm9sbmV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGhpYmF1ZCUyRmNvbnRyb2xuZXQtb3BlbnBvc2Utc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEElMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwQ29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMkZjb250cm9sbmV0LWNhbm55LXNkeGwtMS4wJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSUwQSUyMCUyMCUyMCUyMCklMkMlMEElNUQlMEElMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFwaXBlJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMGNvbnRyb2xuZXQlM0Rjb250cm9sbmV0cyUyQyUyMHZhZSUzRHZhZSUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBcGlwZS5zY2hlZHVsZXIlMjAlM0QlMjBVbmlQQ011bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZS5lbmFibGVfbW9kZWxfY3B1X29mZmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL, UniPCMultistepScheduler
<span class="hljs-keyword">import</span> torch

controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;thibaud/controlnet-openpose-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
    ),
]

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)
pipe = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnets, vae=vae, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
pipe.scheduler = UniPCMultistepScheduler.from_config(pipe.scheduler.config)
pipe.enable_model_cpu_offload()`}}),pl=new w({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyYSUyMGdpYW50JTIwc3RhbmRpbmclMjBpbiUyMGElMjBmYW50YXN5JTIwbGFuZHNjYXBlJTJDJTIwYmVzdCUyMHF1YWxpdHklMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJtb25vY2hyb21lJTJDJTIwbG93cmVzJTJDJTIwYmFkJTIwYW5hdG9teSUyQyUyMHdvcnN0JTIwcXVhbGl0eSUyQyUyMGxvdyUyMHF1YWxpdHklMjIlMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgxKSUwQSUwQWltYWdlcyUyMCUzRCUyMCU1Qm9wZW5wb3NlX2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUyQyUyMGNhbm55X2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSU1RCUwQSUwQWltYWdlcyUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0RpbWFnZXMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjUlMkMlMEElMjAlMjAlMjAlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMEElMjAlMjAlMjAlMjBuZWdhdGl2ZV9wcm9tcHQlM0RuZWdhdGl2ZV9wcm9tcHQlMkMlMEElMjAlMjAlMjAlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbG5ldF9jb25kaXRpb25pbmdfc2NhbGUlM0QlNUIxLjAlMkMlMjAwLjglNUQlMkMlMEEpLmltYWdlcyUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJvcmlnaW5hbF9pbWFnZSUyQyUyMGNhbm55X2ltYWdlJTJDJTIwb3BlbnBvc2VfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbWFnZXMlNUIwJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMkMlMjBpbWFnZXMlNUIxJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklMkMlMjBpbWFnZXMlNUIyJTVELnJlc2l6ZSgoNTEyJTJDJTIwNTEyKSklNUQlMkMlMjByb3dzJTNEMiUyQyUyMGNvbHMlM0QzKQ==",highlighted:`prompt = <span class="hljs-string">&quot;a giant standing in a fantasy landscape, best quality&quot;</span>
negative_prompt = <span class="hljs-string">&quot;monochrome, lowres, bad anatomy, worst quality, low quality&quot;</span>

generator = torch.manual_seed(<span class="hljs-number">1</span>)

images = [openpose_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>)), canny_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))]

images = pipe(
    prompt,
    image=images,
    num_inference_steps=<span class="hljs-number">25</span>,
    generator=generator,
    negative_prompt=negative_prompt,
    num_images_per_prompt=<span class="hljs-number">3</span>,
    controlnet_conditioning_scale=[<span class="hljs-number">1.0</span>, <span class="hljs-number">0.8</span>],
).images
make_image_grid([original_image, canny_image, openpose_image,
                images[<span class="hljs-number">0</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), images[<span class="hljs-number">1</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>)), images[<span class="hljs-number">2</span>].resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))], rows=<span class="hljs-number">2</span>, cols=<span class="hljs-number">3</span>)`}}),{c(){m=i("meta"),U=n(),c=i("h1"),J=i("a"),k=i("span"),d(T.$$.fragment),O=n(),dl=i("span"),dl.textContent=cs,vl=n(),ee=i("p"),ee.textContent=ds,Cl=n(),d(_.$$.fragment),Gl=n(),le=i("p"),le.textContent=Ms,Il=n(),te=i("ul"),te.innerHTML=hs,kl=n(),se=i("p"),se.textContent=us,_l=n(),ne=i("p"),ne.textContent=ys,Nl=n(),ae=i("p"),ae.textContent=fs,Bl=n(),d(ie.$$.fragment),xl=n(),j=i("h2"),N=i("a"),Jl=i("span"),d(oe.$$.fragment),as=n(),Ml=i("span"),Ml.textContent=gs,Xl=n(),pe=i("p"),pe.textContent=Js,Yl=n(),me=i("p"),me.innerHTML=bs,El=n(),d(re.$$.fragment),Rl=n(),B=i("div"),B.innerHTML=ws,Vl=n(),ce=i("p"),ce.innerHTML=Ts,Fl=n(),d(de.$$.fragment),Ql=n(),Me=i("p"),Me.textContent=Us,Sl=n(),d(he.$$.fragment),$l=n(),x=i("div"),x.innerHTML=Zs,Hl=n(),W=i("h2"),X=i("a"),bl=i("span"),d(ue.$$.fragment),is=n(),hl=i("span"),hl.textContent=js,zl=n(),ye=i("p"),ye.textContent=Ws,Al=n(),fe=i("p"),fe.innerHTML=vs,Ll=n(),ge=i("p"),ge.innerHTML=Cs,Dl=n(),d(Je.$$.fragment),ql=n(),be=i("p"),be.innerHTML=Gs,Pl=n(),d(we.$$.fragment),Kl=n(),Te=i("p"),Te.textContent=Is,Ol=n(),d(Ue.$$.fragment),et=n(),Y=i("div"),Y.innerHTML=ks,lt=n(),v=i("h2"),E=i("a"),wl=i("span"),d(Ze.$$.fragment),os=n(),ul=i("span"),ul.textContent=_s,tt=n(),je=i("p"),je.textContent=Ns,st=n(),We=i("p"),We.textContent=Bs,nt=n(),d(ve.$$.fragment),at=n(),Ce=i("p"),Ce.innerHTML=xs,it=n(),d(Ge.$$.fragment),ot=n(),R=i("div"),R.innerHTML=Xs,pt=n(),Ie=i("p"),Ie.innerHTML=Ys,mt=n(),d(ke.$$.fragment),rt=n(),_e=i("p"),_e.textContent=Es,ct=n(),d(Ne.$$.fragment),dt=n(),V=i("div"),V.innerHTML=Rs,Mt=n(),C=i("h2"),F=i("a"),Tl=i("span"),d(Be.$$.fragment),ps=n(),yl=i("span"),yl.textContent=Vs,ht=n(),xe=i("p"),xe.innerHTML=Fs,ut=n(),Xe=i("p"),Xe.innerHTML=Qs,yt=n(),d(Q.$$.fragment),ft=n(),Ye=i("p"),Ye.innerHTML=Ss,gt=n(),d(Ee.$$.fragment),Jt=n(),S=i("div"),S.innerHTML=$s,bt=n(),G=i("h2"),$=i("a"),Ul=i("span"),d(Re.$$.fragment),ms=n(),fl=i("span"),fl.textContent=Hs,wt=n(),Ve=i("p"),Ve.innerHTML=zs,Tt=n(),Fe=i("p"),Fe.textContent=As,Ut=n(),d(Qe.$$.fragment),Zt=n(),H=i("div"),H.innerHTML=Ls,jt=n(),Se=i("p"),Se.innerHTML=Ds,Wt=n(),d($e.$$.fragment),vt=n(),He=i("p"),He.textContent=qs,Ct=n(),d(z.$$.fragment),Gt=n(),d(ze.$$.fragment),It=n(),A=i("div"),A.innerHTML=Ps,kt=n(),Ae=i("p"),Ae.innerHTML=Ks,_t=n(),d(Le.$$.fragment),Nt=n(),I=i("h3"),L=i("a"),Zl=i("span"),d(De.$$.fragment),rs=n(),gl=i("span"),gl.textContent=Os,Bt=n(),d(D.$$.fragment),xt=n(),qe=i("p"),qe.innerHTML=en,Xt=n(),Pe=i("ol"),Pe.innerHTML=ln,Yt=n(),Ke=i("p"),Ke.textContent=tn,Et=n(),Oe=i("p"),Oe.textContent=sn,Rt=n(),d(el.$$.fragment),Vt=n(),q=i("div"),q.innerHTML=nn,Ft=n(),ll=i("p"),ll.innerHTML=an,Qt=n(),d(tl.$$.fragment),St=n(),sl=i("p"),sl.textContent=on,$t=n(),d(nl.$$.fragment),Ht=n(),P=i("div"),P.innerHTML=pn,zt=n(),al=i("p"),al.innerHTML=mn,At=n(),d(il.$$.fragment),Lt=n(),ol=i("p"),ol.textContent=rn,Dt=n(),d(pl.$$.fragment),qt=n(),K=i("div"),K.innerHTML=cn,this.h()},l(e){const l=Cn("svelte-1phssyn",document.head);m=o(l,"META",{name:!0,content:!0}),l.forEach(t),U=a(e),c=o(e,"H1",{class:!0});var ml=b(c);J=o(ml,"A",{id:!0,class:!0,href:!0});var jl=b(J);k=o(jl,"SPAN",{});var Wl=b(k);M(T.$$.fragment,Wl),Wl.forEach(t),jl.forEach(t),O=a(ml),dl=o(ml,"SPAN",{"data-svelte-h":!0}),p(dl)!=="svelte-1147sj1"&&(dl.textContent=cs),ml.forEach(t),vl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-1ersfq7"&&(ee.textContent=ds),Cl=a(e),M(_.$$.fragment,e),Gl=a(e),le=o(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-r7ehkq"&&(le.textContent=Ms),Il=a(e),te=o(e,"UL",{"data-svelte-h":!0}),p(te)!=="svelte-1jzb95l"&&(te.innerHTML=hs),kl=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-10jstxp"&&(se.textContent=us),_l=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1rkzg2g"&&(ne.textContent=ys),Nl=a(e),ae=o(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-cwruts"&&(ae.textContent=fs),Bl=a(e),M(ie.$$.fragment,e),xl=a(e),j=o(e,"H2",{class:!0});var rl=b(j);N=o(rl,"A",{id:!0,class:!0,href:!0});var dn=b(N);Jl=o(dn,"SPAN",{});var Mn=b(Jl);M(oe.$$.fragment,Mn),Mn.forEach(t),dn.forEach(t),as=a(rl),Ml=o(rl,"SPAN",{"data-svelte-h":!0}),p(Ml)!=="svelte-ws6p24"&&(Ml.textContent=gs),rl.forEach(t),Xl=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-1cb54q2"&&(pe.textContent=Js),Yl=a(e),me=o(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-9znxu8"&&(me.innerHTML=bs),El=a(e),M(re.$$.fragment,e),Rl=a(e),B=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(B)!=="svelte-1jr9xr4"&&(B.innerHTML=ws),Vl=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-6sqohe"&&(ce.innerHTML=Ts),Fl=a(e),M(de.$$.fragment,e),Ql=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-17x9oax"&&(Me.textContent=Us),Sl=a(e),M(he.$$.fragment,e),$l=a(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(x)!=="svelte-3r1z1k"&&(x.innerHTML=Zs),Hl=a(e),W=o(e,"H2",{class:!0});var Kt=b(W);X=o(Kt,"A",{id:!0,class:!0,href:!0});var hn=b(X);bl=o(hn,"SPAN",{});var un=b(bl);M(ue.$$.fragment,un),un.forEach(t),hn.forEach(t),is=a(Kt),hl=o(Kt,"SPAN",{"data-svelte-h":!0}),p(hl)!=="svelte-1r5u1a2"&&(hl.textContent=js),Kt.forEach(t),zl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-g01jh2"&&(ye.textContent=Ws),Al=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-3lpv8y"&&(fe.innerHTML=vs),Ll=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1qdxwd4"&&(ge.innerHTML=Cs),Dl=a(e),M(Je.$$.fragment,e),ql=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-4dshu1"&&(be.innerHTML=Gs),Pl=a(e),M(we.$$.fragment,e),Kl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-wyr53z"&&(Te.textContent=Is),Ol=a(e),M(Ue.$$.fragment,e),et=a(e),Y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(Y)!=="svelte-8qhhvs"&&(Y.innerHTML=ks),lt=a(e),v=o(e,"H2",{class:!0});var Ot=b(v);E=o(Ot,"A",{id:!0,class:!0,href:!0});var yn=b(E);wl=o(yn,"SPAN",{});var fn=b(wl);M(Ze.$$.fragment,fn),fn.forEach(t),yn.forEach(t),os=a(Ot),ul=o(Ot,"SPAN",{"data-svelte-h":!0}),p(ul)!=="svelte-1870h70"&&(ul.textContent=_s),Ot.forEach(t),tt=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1i60bwf"&&(je.textContent=Ns),st=a(e),We=o(e,"P",{"data-svelte-h":!0}),p(We)!=="svelte-175mm0t"&&(We.textContent=Bs),nt=a(e),M(ve.$$.fragment,e),at=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-4efl8b"&&(Ce.innerHTML=xs),it=a(e),M(Ge.$$.fragment,e),ot=a(e),R=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(R)!=="svelte-grxw51"&&(R.innerHTML=Xs),pt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-8oirf"&&(Ie.innerHTML=Ys),mt=a(e),M(ke.$$.fragment,e),rt=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-118t2qr"&&(_e.textContent=Es),ct=a(e),M(Ne.$$.fragment,e),dt=a(e),V=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(V)!=="svelte-1qk6bz9"&&(V.innerHTML=Rs),Mt=a(e),C=o(e,"H2",{class:!0});var es=b(C);F=o(es,"A",{id:!0,class:!0,href:!0});var gn=b(F);Tl=o(gn,"SPAN",{});var Jn=b(Tl);M(Be.$$.fragment,Jn),Jn.forEach(t),gn.forEach(t),ps=a(es),yl=o(es,"SPAN",{"data-svelte-h":!0}),p(yl)!=="svelte-1422vw9"&&(yl.textContent=Vs),es.forEach(t),ht=a(e),xe=o(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-w08m5a"&&(xe.innerHTML=Fs),ut=a(e),Xe=o(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-vnjl1j"&&(Xe.innerHTML=Qs),yt=a(e),M(Q.$$.fragment,e),ft=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-vqtz65"&&(Ye.innerHTML=Ss),gt=a(e),M(Ee.$$.fragment,e),Jt=a(e),S=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(S)!=="svelte-1hf21gv"&&(S.innerHTML=$s),bt=a(e),G=o(e,"H2",{class:!0});var ls=b(G);$=o(ls,"A",{id:!0,class:!0,href:!0});var bn=b($);Ul=o(bn,"SPAN",{});var wn=b(Ul);M(Re.$$.fragment,wn),wn.forEach(t),bn.forEach(t),ms=a(ls),fl=o(ls,"SPAN",{"data-svelte-h":!0}),p(fl)!=="svelte-14isvjv"&&(fl.textContent=Hs),ls.forEach(t),wt=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1jgtfzx"&&(Ve.innerHTML=zs),Tt=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-7i5g8g"&&(Fe.textContent=As),Ut=a(e),M(Qe.$$.fragment,e),Zt=a(e),H=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(H)!=="svelte-j8n5na"&&(H.innerHTML=Ls),jt=a(e),Se=o(e,"P",{"data-svelte-h":!0}),p(Se)!=="svelte-1cnoosf"&&(Se.innerHTML=Ds),Wt=a(e),M($e.$$.fragment,e),vt=a(e),He=o(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-172pcgi"&&(He.textContent=qs),Ct=a(e),M(z.$$.fragment,e),Gt=a(e),M(ze.$$.fragment,e),It=a(e),A=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(A)!=="svelte-8vwtkd"&&(A.innerHTML=Ps),kt=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-1vdptfv"&&(Ae.innerHTML=Ks),_t=a(e),M(Le.$$.fragment,e),Nt=a(e),I=o(e,"H3",{class:!0});var ts=b(I);L=o(ts,"A",{id:!0,class:!0,href:!0});var Tn=b(L);Zl=o(Tn,"SPAN",{});var Un=b(Zl);M(De.$$.fragment,Un),Un.forEach(t),Tn.forEach(t),rs=a(ts),gl=o(ts,"SPAN",{"data-svelte-h":!0}),p(gl)!=="svelte-1oslwlq"&&(gl.textContent=Os),ts.forEach(t),Bt=a(e),M(D.$$.fragment,e),xt=a(e),qe=o(e,"P",{"data-svelte-h":!0}),p(qe)!=="svelte-1engdvd"&&(qe.innerHTML=en),Xt=a(e),Pe=o(e,"OL",{"data-svelte-h":!0}),p(Pe)!=="svelte-18sf1v5"&&(Pe.innerHTML=ln),Yt=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),p(Ke)!=="svelte-1gpdoop"&&(Ke.textContent=tn),Et=a(e),Oe=o(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-1k4sivd"&&(Oe.textContent=sn),Rt=a(e),M(el.$$.fragment,e),Vt=a(e),q=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(q)!=="svelte-1cl87j5"&&(q.innerHTML=nn),Ft=a(e),ll=o(e,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-2v63o"&&(ll.innerHTML=an),Qt=a(e),M(tl.$$.fragment,e),St=a(e),sl=o(e,"P",{"data-svelte-h":!0}),p(sl)!=="svelte-bab8ey"&&(sl.textContent=on),$t=a(e),M(nl.$$.fragment,e),Ht=a(e),P=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(P)!=="svelte-1og8gmm"&&(P.innerHTML=pn),zt=a(e),al=o(e,"P",{"data-svelte-h":!0}),p(al)!=="svelte-qv4qer"&&(al.innerHTML=mn),At=a(e),M(il.$$.fragment,e),Lt=a(e),ol=o(e,"P",{"data-svelte-h":!0}),p(ol)!=="svelte-d5aph9"&&(ol.textContent=rn),Dt=a(e),M(pl.$$.fragment,e),qt=a(e),K=o(e,"DIV",{class:!0,"data-svelte-h":!0}),p(K)!=="svelte-1qlyggw"&&(K.innerHTML=cn),this.h()},h(){r(m,"name","hf:doc:metadata"),r(m,"content",JSON.stringify(Bn)),r(J,"id","controlnet"),r(J,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(J,"href","#controlnet"),r(c,"class","relative group"),r(N,"id","texttoimage"),r(N,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(N,"href","#texttoimage"),r(j,"class","relative group"),r(B,"class","flex gap-4"),r(x,"class","flex justify-center"),r(X,"id","imagetoimage"),r(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(X,"href","#imagetoimage"),r(W,"class","relative group"),r(Y,"class","flex gap-4"),r(E,"id","inpainting"),r(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(E,"href","#inpainting"),r(v,"class","relative group"),r(R,"class","flex gap-4"),r(V,"class","flex justify-center"),r(F,"id","guess-mode"),r(F,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(F,"href","#guess-mode"),r(C,"class","relative group"),r(S,"class","flex gap-4"),r($,"id","controlnet-with-stable-diffusion-xl"),r($,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r($,"href","#controlnet-with-stable-diffusion-xl"),r(G,"class","relative group"),r(H,"class","flex gap-4"),r(A,"class","flex justify-center"),r(L,"id","multicontrolnet"),r(L,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),r(L,"href","#multicontrolnet"),r(I,"class","relative group"),r(q,"class","flex gap-4"),r(P,"class","flex gap-4"),r(K,"class","flex justify-center")},m(e,l){g(document.head,m),s(e,U,l),s(e,c,l),g(c,J),g(J,k),h(T,k,null),g(c,O),g(c,dl),s(e,vl,l),s(e,ee,l),s(e,Cl,l),h(_,e,l),s(e,Gl,l),s(e,le,l),s(e,Il,l),s(e,te,l),s(e,kl,l),s(e,se,l),s(e,_l,l),s(e,ne,l),s(e,Nl,l),s(e,ae,l),s(e,Bl,l),h(ie,e,l),s(e,xl,l),s(e,j,l),g(j,N),g(N,Jl),h(oe,Jl,null),g(j,as),g(j,Ml),s(e,Xl,l),s(e,pe,l),s(e,Yl,l),s(e,me,l),s(e,El,l),h(re,e,l),s(e,Rl,l),s(e,B,l),s(e,Vl,l),s(e,ce,l),s(e,Fl,l),h(de,e,l),s(e,Ql,l),s(e,Me,l),s(e,Sl,l),h(he,e,l),s(e,$l,l),s(e,x,l),s(e,Hl,l),s(e,W,l),g(W,X),g(X,bl),h(ue,bl,null),g(W,is),g(W,hl),s(e,zl,l),s(e,ye,l),s(e,Al,l),s(e,fe,l),s(e,Ll,l),s(e,ge,l),s(e,Dl,l),h(Je,e,l),s(e,ql,l),s(e,be,l),s(e,Pl,l),h(we,e,l),s(e,Kl,l),s(e,Te,l),s(e,Ol,l),h(Ue,e,l),s(e,et,l),s(e,Y,l),s(e,lt,l),s(e,v,l),g(v,E),g(E,wl),h(Ze,wl,null),g(v,os),g(v,ul),s(e,tt,l),s(e,je,l),s(e,st,l),s(e,We,l),s(e,nt,l),h(ve,e,l),s(e,at,l),s(e,Ce,l),s(e,it,l),h(Ge,e,l),s(e,ot,l),s(e,R,l),s(e,pt,l),s(e,Ie,l),s(e,mt,l),h(ke,e,l),s(e,rt,l),s(e,_e,l),s(e,ct,l),h(Ne,e,l),s(e,dt,l),s(e,V,l),s(e,Mt,l),s(e,C,l),g(C,F),g(F,Tl),h(Be,Tl,null),g(C,ps),g(C,yl),s(e,ht,l),s(e,xe,l),s(e,ut,l),s(e,Xe,l),s(e,yt,l),h(Q,e,l),s(e,ft,l),s(e,Ye,l),s(e,gt,l),h(Ee,e,l),s(e,Jt,l),s(e,S,l),s(e,bt,l),s(e,G,l),g(G,$),g($,Ul),h(Re,Ul,null),g(G,ms),g(G,fl),s(e,wt,l),s(e,Ve,l),s(e,Tt,l),s(e,Fe,l),s(e,Ut,l),h(Qe,e,l),s(e,Zt,l),s(e,H,l),s(e,jt,l),s(e,Se,l),s(e,Wt,l),h($e,e,l),s(e,vt,l),s(e,He,l),s(e,Ct,l),h(z,e,l),s(e,Gt,l),h(ze,e,l),s(e,It,l),s(e,A,l),s(e,kt,l),s(e,Ae,l),s(e,_t,l),h(Le,e,l),s(e,Nt,l),s(e,I,l),g(I,L),g(L,Zl),h(De,Zl,null),g(I,rs),g(I,gl),s(e,Bt,l),h(D,e,l),s(e,xt,l),s(e,qe,l),s(e,Xt,l),s(e,Pe,l),s(e,Yt,l),s(e,Ke,l),s(e,Et,l),s(e,Oe,l),s(e,Rt,l),h(el,e,l),s(e,Vt,l),s(e,q,l),s(e,Ft,l),s(e,ll,l),s(e,Qt,l),h(tl,e,l),s(e,St,l),s(e,sl,l),s(e,$t,l),h(nl,e,l),s(e,Ht,l),s(e,P,l),s(e,zt,l),s(e,al,l),s(e,At,l),h(il,e,l),s(e,Lt,l),s(e,ol,l),s(e,Dt,l),h(pl,e,l),s(e,qt,l),s(e,K,l),Pt=!0},p(e,[l]){const ml={};l&2&&(ml.$$scope={dirty:l,ctx:e}),_.$set(ml);const jl={};l&2&&(jl.$$scope={dirty:l,ctx:e}),Q.$set(jl);const Wl={};l&2&&(Wl.$$scope={dirty:l,ctx:e}),z.$set(Wl);const rl={};l&2&&(rl.$$scope={dirty:l,ctx:e}),D.$set(rl)},i(e){Pt||(u(T.$$.fragment,e),u(_.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(de.$$.fragment,e),u(he.$$.fragment,e),u(ue.$$.fragment,e),u(Je.$$.fragment,e),u(we.$$.fragment,e),u(Ue.$$.fragment,e),u(Ze.$$.fragment,e),u(ve.$$.fragment,e),u(Ge.$$.fragment,e),u(ke.$$.fragment,e),u(Ne.$$.fragment,e),u(Be.$$.fragment,e),u(Q.$$.fragment,e),u(Ee.$$.fragment,e),u(Re.$$.fragment,e),u(Qe.$$.fragment,e),u($e.$$.fragment,e),u(z.$$.fragment,e),u(ze.$$.fragment,e),u(Le.$$.fragment,e),u(De.$$.fragment,e),u(D.$$.fragment,e),u(el.$$.fragment,e),u(tl.$$.fragment,e),u(nl.$$.fragment,e),u(il.$$.fragment,e),u(pl.$$.fragment,e),Pt=!0)},o(e){y(T.$$.fragment,e),y(_.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(de.$$.fragment,e),y(he.$$.fragment,e),y(ue.$$.fragment,e),y(Je.$$.fragment,e),y(we.$$.fragment,e),y(Ue.$$.fragment,e),y(Ze.$$.fragment,e),y(ve.$$.fragment,e),y(Ge.$$.fragment,e),y(ke.$$.fragment,e),y(Ne.$$.fragment,e),y(Be.$$.fragment,e),y(Q.$$.fragment,e),y(Ee.$$.fragment,e),y(Re.$$.fragment,e),y(Qe.$$.fragment,e),y($e.$$.fragment,e),y(z.$$.fragment,e),y(ze.$$.fragment,e),y(Le.$$.fragment,e),y(De.$$.fragment,e),y(D.$$.fragment,e),y(el.$$.fragment,e),y(tl.$$.fragment,e),y(nl.$$.fragment,e),y(il.$$.fragment,e),y(pl.$$.fragment,e),Pt=!1},d(e){e&&(t(U),t(c),t(vl),t(ee),t(Cl),t(Gl),t(le),t(Il),t(te),t(kl),t(se),t(_l),t(ne),t(Nl),t(ae),t(Bl),t(xl),t(j),t(Xl),t(pe),t(Yl),t(me),t(El),t(Rl),t(B),t(Vl),t(ce),t(Fl),t(Ql),t(Me),t(Sl),t($l),t(x),t(Hl),t(W),t(zl),t(ye),t(Al),t(fe),t(Ll),t(ge),t(Dl),t(ql),t(be),t(Pl),t(Kl),t(Te),t(Ol),t(et),t(Y),t(lt),t(v),t(tt),t(je),t(st),t(We),t(nt),t(at),t(Ce),t(it),t(ot),t(R),t(pt),t(Ie),t(mt),t(rt),t(_e),t(ct),t(dt),t(V),t(Mt),t(C),t(ht),t(xe),t(ut),t(Xe),t(yt),t(ft),t(Ye),t(gt),t(Jt),t(S),t(bt),t(G),t(wt),t(Ve),t(Tt),t(Fe),t(Ut),t(Zt),t(H),t(jt),t(Se),t(Wt),t(vt),t(He),t(Ct),t(Gt),t(It),t(A),t(kt),t(Ae),t(_t),t(Nt),t(I),t(Bt),t(xt),t(qe),t(Xt),t(Pe),t(Yt),t(Ke),t(Et),t(Oe),t(Rt),t(Vt),t(q),t(Ft),t(ll),t(Qt),t(St),t(sl),t($t),t(Ht),t(P),t(zt),t(al),t(At),t(Lt),t(ol),t(Dt),t(qt),t(K)),t(m),f(T),f(_,e),f(ie,e),f(oe),f(re,e),f(de,e),f(he,e),f(ue),f(Je,e),f(we,e),f(Ue,e),f(Ze),f(ve,e),f(Ge,e),f(ke,e),f(Ne,e),f(Be),f(Q,e),f(Ee,e),f(Re),f(Qe,e),f($e,e),f(z,e),f(ze,e),f(Le,e),f(De),f(D,e),f(el,e),f(tl,e),f(nl,e),f(il,e),f(pl,e)}}}const Bn={local:"controlnet",sections:[{local:"texttoimage",title:"Text-to-image"},{local:"imagetoimage",title:"Image-to-image"},{local:"inpainting",title:"Inpainting"},{local:"guess-mode",title:"Guess mode"},{local:"controlnet-with-stable-diffusion-xl",sections:[{local:"multicontrolnet",title:"MultiControlNet"}],title:"ControlNet with Stable Diffusion XL"}],title:"ControlNet"};function xn(Z){return jn(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fn extends Wn{constructor(m){super(),vn(this,m,xn,Nn,Zn,{})}}export{Fn as component};
