import{s as ue,n as ce,o as Me}from"../chunks/scheduler.6062bdaf.js";import{S as fe,i as be,g as c,s as o,r as a,A as he,h as M,f as l,c as s,j as re,u as m,x as R,k as de,y as we,a as n,v as i,d as p,t as r,w as d}from"../chunks/index.4bca734e.js";import{C as le}from"../chunks/CodeBlock.fa01571c.js";import{H as V,E as ye}from"../chunks/EditOnGithub.74ab2baa.js";function ge(ne){let u,G,k,_,f,N,b,oe=`Optimum is a utility package for building and running inference with accelerated runtime like ONNX Runtime.
Optimum can be used to load optimized models from the <a href="hf.co/models">Hugging Face Hub</a> and create pipelines
to run accelerated inference without rewriting your APIs.`,E,h,Q,w,C,y,se='Once your model was <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">exported to the ONNX format</a>, you can load it by replacing the <code>AutoModelForXxx</code> class with the corresponding <code>ORTModelForXxx</code>.',H,g,F,T,ae='More information for all the supported <code>ORTModelForXxx</code> in our <a href="https://huggingface.co/docs/optimum/onnxruntime/package_reference/modeling_ort" rel="nofollow">documentation</a>',S,J,O,j,me='Once your model was <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">exported to the ONNX format</a>, you can load it by replacing the <code>DiffusionPipeline</code> class with the corresponding <code>ORTDiffusionPipeline</code>.',q,Z,L,$,Y,U,ie=`In case your model wasn’t already <a href="https://huggingface.co/docs/optimum/exporters/onnx/usage_guides/export_a_model" rel="nofollow">converted to ONNX</a>, <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel">ORTModel</a> includes a method to convert your model to ONNX on-the-fly.
Simply pass <code>export=True</code> to the <a href="/docs/optimum/main/en/onnxruntime/package_reference/modeling_ort#optimum.onnxruntime.ORTModel.from_pretrained">from_pretrained()</a> method, and your model will be loaded and converted to ONNX on-the-fly:`,z,B,P,X,A,I,pe='You can also call <code>push_to_hub</code> directly on your model to upload it to the <a href="https://hf.co/models" rel="nofollow">Hub</a>.',D,W,K,x,ee,v,te;return f=new V({props:{title:"Optimum Inference with ONNX Runtime",local:"optimum-inference-with-onnx-runtime",headingTag:"h1"}}),h=new V({props:{title:"Loading",local:"loading",headingTag:"h2"}}),w=new V({props:{title:"Transformers models",local:"transformers-models",headingTag:"h3"}}),g=new le({props:{code:"JTIwJTIwZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBwaXBlbGluZSUwQS0lMjBmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMkIlMjBmcm9tJTIwb3B0aW11bS5vbm54cnVudGltZSUyMGltcG9ydCUyME9SVE1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEEtJTIwbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xQiklMjAlMjMlMjBQeVRvcmNoJTIwY2hlY2twb2ludCUwQSUyQiUyMG1vZGVsJTIwJTNEJTIwT1JUTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb25ueC1jb21tdW5pdHklMkZMbGFtYS0zLjItMUIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJvbm54JTIyKSUyMCUyMyUyME9OTlglMjBjaGVja3BvaW50JTBBJTIwJTIwdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWV0YS1sbGFtYSUyRkxsYW1hLTMuMi0xQiUyMiklMEElMEElMjAlMjBwaXBlJTIwJTNEJTIwcGlwZWxpbmUoJTIydGV4dC1nZW5lcmF0aW9uJTIyJTJDJTIwbW9kZWwlM0Rtb2RlbCUyQyUyMHRva2VuaXplciUzRHRva2VuaXplciklMEElMjAlMjByZXN1bHQlMjAlM0QlMjBwaXBlKCUyMkhlJTIwbmV2ZXIlMjB3ZW50JTIwb3V0JTIwd2l0aG91dCUyMGElMjBib29rJTIwdW5kZXIlMjBoaXMlMjBhcm0lMjIp",highlighted:`  from transformers import AutoTokenizer, pipeline
<span class="hljs-deletion">- from transformers import AutoModelForQuestionAnswering</span>
<span class="hljs-addition">+ from optimum.onnxruntime import ORTModelForQuestionAnswering</span>

<span class="hljs-deletion">- model = AutoModelForQuestionAnswering.from_pretrained(&quot;meta-llama/Llama-3.2-1B) # PyTorch checkpoint</span>
<span class="hljs-addition">+ model = ORTModelForQuestionAnswering.from_pretrained(&quot;onnx-community/Llama-3.2-1B&quot;, subfolder=&quot;onnx&quot;) # ONNX checkpoint</span>
  tokenizer = AutoTokenizer.from_pretrained(&quot;meta-llama/Llama-3.2-1B&quot;)

  pipe = pipeline(&quot;text-generation&quot;, model=model, tokenizer=tokenizer)
  result = pipe(&quot;He never went out without a book under his arm&quot;)`,wrap:!1}}),J=new V({props:{title:"Diffusers models",local:"diffusers-models",headingTag:"h3"}}),Z=new le({props:{code:"LSUyMGZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBEaWZmdXNpb25QaXBlbGluZSUwQSUyQiUyMGZyb20lMjBvcHRpbXVtLm9ubnhydW50aW1lJTIwaW1wb3J0JTIwT1JURGlmZnVzaW9uUGlwZWxpbmUlMEElMEElMjAlMjBtb2RlbF9pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBLSUyMHBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQSUyQiUyMHBpcGVsaW5lJTIwJTNEJTIwT1JURGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwcmV2aXNpb24lM0QlMjJvbm54JTIyKSUwQSUyMCUyMHByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwTGVvbmFyZG8lMjBkYSUyMFZpbmNpJTIyJTBBJTIwJTIwaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-deletion">- from diffusers import DiffusionPipeline</span>
<span class="hljs-addition">+ from optimum.onnxruntime import ORTDiffusionPipeline</span>

  model_id = &quot;runwayml/stable-diffusion-v1-5&quot;
<span class="hljs-deletion">- pipeline = DiffusionPipeline.from_pretrained(model_id)</span>
<span class="hljs-addition">+ pipeline = ORTDiffusionPipeline.from_pretrained(model_id, revision=&quot;onnx&quot;)</span>
  prompt = &quot;sailing ship in storm by Leonardo da Vinci&quot;
  image = pipeline(prompt).images[0]`,wrap:!1}}),$=new V({props:{title:"Converting your model to ONNX on-the-fly",local:"converting-your-model-to-onnx-on-the-fly",headingTag:"h2"}}),B=new le({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new V({props:{title:"Pushing your model to the Hub",local:"pushing-your-model-to-the-hub",headingTag:"h2"}}),W=new le({props:{code:"ZnJvbSUyMG9wdGltdW0ub25ueHJ1bnRpbWUlMjBpbXBvcnQlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMjMlMjBMb2FkJTIwdGhlJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwaHViJTIwYW5kJTIwZXhwb3J0JTIwaXQlMjB0byUyMHRoZSUyME9OTlglMjBmb3JtYXQlMEFtb2RlbF9pZCUyMCUzRCUyMCUyMmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoJTIyJTBBbW9kZWwlMjAlM0QlMjBPUlRNb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEElMjMlMjBTYXZlJTIwdGhlJTIwY29udmVydGVkJTIwbW9kZWwlMjBsb2NhbGx5JTBBb3V0cHV0X2RpciUyMCUzRCUyMCUyMmFfbG9jYWxfcGF0aF9mb3JfY29udmVydF9vbm54X21vZGVsJTIyJTBBbW9kZWwuc2F2ZV9wcmV0cmFpbmVkKG91dHB1dF9kaXIpJTBBJTBBbW9kZWwucHVzaF90b19odWIob3V0cHV0X2RpciUyQyUyMHJlcG9zaXRvcnlfaWQlM0QlMjJteS1vbm54LXJlcG8lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.onnxruntime <span class="hljs-keyword">import</span> ORTModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Load the model from the hub and export it to the ONNX format</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model_id = <span class="hljs-string">&quot;distilbert-base-uncased-finetuned-sst-2-english&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ORTModelForSequenceClassification.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Save the converted model locally</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>output_dir = <span class="hljs-string">&quot;a_local_path_for_convert_onnx_model&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.save_pretrained(output_dir)

<span class="hljs-comment"># Push the onnx model to HF Hub</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model.push_to_hub(output_dir, repository_id=<span class="hljs-string">&quot;my-onnx-repo&quot;</span>)`,wrap:!1}}),x=new ye({props:{source:"https://github.com/huggingface/optimum/blob/main/docs/source/onnxruntime/usage_guides/models.mdx"}}),{c(){u=c("meta"),G=o(),k=c("p"),_=o(),a(f.$$.fragment),N=o(),b=c("p"),b.innerHTML=oe,E=o(),a(h.$$.fragment),Q=o(),a(w.$$.fragment),C=o(),y=c("p"),y.innerHTML=se,H=o(),a(g.$$.fragment),F=o(),T=c("p"),T.innerHTML=ae,S=o(),a(J.$$.fragment),O=o(),j=c("p"),j.innerHTML=me,q=o(),a(Z.$$.fragment),L=o(),a($.$$.fragment),Y=o(),U=c("p"),U.innerHTML=ie,z=o(),a(B.$$.fragment),P=o(),a(X.$$.fragment),A=o(),I=c("p"),I.innerHTML=pe,D=o(),a(W.$$.fragment),K=o(),a(x.$$.fragment),ee=o(),v=c("p"),this.h()},l(e){const t=he("svelte-u9bgzb",document.head);u=M(t,"META",{name:!0,content:!0}),t.forEach(l),G=s(e),k=M(e,"P",{}),re(k).forEach(l),_=s(e),m(f.$$.fragment,e),N=s(e),b=M(e,"P",{"data-svelte-h":!0}),R(b)!=="svelte-4xrbw1"&&(b.innerHTML=oe),E=s(e),m(h.$$.fragment,e),Q=s(e),m(w.$$.fragment,e),C=s(e),y=M(e,"P",{"data-svelte-h":!0}),R(y)!=="svelte-1rhi3qq"&&(y.innerHTML=se),H=s(e),m(g.$$.fragment,e),F=s(e),T=M(e,"P",{"data-svelte-h":!0}),R(T)!=="svelte-ygi0aa"&&(T.innerHTML=ae),S=s(e),m(J.$$.fragment,e),O=s(e),j=M(e,"P",{"data-svelte-h":!0}),R(j)!=="svelte-1n0g2a3"&&(j.innerHTML=me),q=s(e),m(Z.$$.fragment,e),L=s(e),m($.$$.fragment,e),Y=s(e),U=M(e,"P",{"data-svelte-h":!0}),R(U)!=="svelte-1ks5vnt"&&(U.innerHTML=ie),z=s(e),m(B.$$.fragment,e),P=s(e),m(X.$$.fragment,e),A=s(e),I=M(e,"P",{"data-svelte-h":!0}),R(I)!=="svelte-x3771f"&&(I.innerHTML=pe),D=s(e),m(W.$$.fragment,e),K=s(e),m(x.$$.fragment,e),ee=s(e),v=M(e,"P",{}),re(v).forEach(l),this.h()},h(){de(u,"name","hf:doc:metadata"),de(u,"content",Te)},m(e,t){we(document.head,u),n(e,G,t),n(e,k,t),n(e,_,t),i(f,e,t),n(e,N,t),n(e,b,t),n(e,E,t),i(h,e,t),n(e,Q,t),i(w,e,t),n(e,C,t),n(e,y,t),n(e,H,t),i(g,e,t),n(e,F,t),n(e,T,t),n(e,S,t),i(J,e,t),n(e,O,t),n(e,j,t),n(e,q,t),i(Z,e,t),n(e,L,t),i($,e,t),n(e,Y,t),n(e,U,t),n(e,z,t),i(B,e,t),n(e,P,t),i(X,e,t),n(e,A,t),n(e,I,t),n(e,D,t),i(W,e,t),n(e,K,t),i(x,e,t),n(e,ee,t),n(e,v,t),te=!0},p:ce,i(e){te||(p(f.$$.fragment,e),p(h.$$.fragment,e),p(w.$$.fragment,e),p(g.$$.fragment,e),p(J.$$.fragment,e),p(Z.$$.fragment,e),p($.$$.fragment,e),p(B.$$.fragment,e),p(X.$$.fragment,e),p(W.$$.fragment,e),p(x.$$.fragment,e),te=!0)},o(e){r(f.$$.fragment,e),r(h.$$.fragment,e),r(w.$$.fragment,e),r(g.$$.fragment,e),r(J.$$.fragment,e),r(Z.$$.fragment,e),r($.$$.fragment,e),r(B.$$.fragment,e),r(X.$$.fragment,e),r(W.$$.fragment,e),r(x.$$.fragment,e),te=!1},d(e){e&&(l(G),l(k),l(_),l(N),l(b),l(E),l(Q),l(C),l(y),l(H),l(F),l(T),l(S),l(O),l(j),l(q),l(L),l(Y),l(U),l(z),l(P),l(A),l(I),l(D),l(K),l(ee),l(v)),l(u),d(f,e),d(h,e),d(w,e),d(g,e),d(J,e),d(Z,e),d($,e),d(B,e),d(X,e),d(W,e),d(x,e)}}}const Te='{"title":"Optimum Inference with ONNX Runtime","local":"optimum-inference-with-onnx-runtime","sections":[{"title":"Loading","local":"loading","sections":[{"title":"Transformers models","local":"transformers-models","sections":[],"depth":3},{"title":"Diffusers models","local":"diffusers-models","sections":[],"depth":3}],"depth":2},{"title":"Converting your model to ONNX on-the-fly","local":"converting-your-model-to-onnx-on-the-fly","sections":[],"depth":2},{"title":"Pushing your model to the Hub","local":"pushing-your-model-to-the-hub","sections":[],"depth":2}],"depth":1}';function Je(ne){return Me(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Be extends fe{constructor(u){super(),be(this,u,Je,ge,ue,{})}}export{Be as component};
