import{s as ts,o as as,n as es}from"../chunks/scheduler.c57aa7ef.js";import{S as ls,i as ss,g as i,s,r as p,A as ns,h as o,f as a,c as n,j as Kl,u as d,x as r,k as Ka,y as is,a as l,v as m,d as f,t as h,w as u}from"../chunks/index.c50cb18e.js";import{T as Ol}from"../chunks/Tip.9268b0ca.js";import{C as M}from"../chunks/CodeBlock.34f0a53d.js";import{H as w,E as os}from"../chunks/EditOnGithub.958a8a49.js";function rs(rt){let c,g='Learn more about how PEFT works with quantization in the <a href="quantization">Quantization</a> guide.';return{c(){c=i("p"),c.innerHTML=g},l(y){c=o(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1nbpolx"&&(c.innerHTML=g)},m(y,b){l(y,c,b)},p:es,d(y){y&&a(c)}}}function ps(rt){let c,g='There are several supported methods for <code>combination_type</code>. Refer to the <a href="../package_reference/lora#peft.LoraModel.add_weighted_adapter">documentation</a> for more details. Note that “svd” as the <code>combination_type</code> is not supported when using <code>torch.float16</code> or <code>torch.bfloat16</code> as the datatype.';return{c(){c=i("p"),c.innerHTML=g},l(y){c=o(y,"P",{"data-svelte-h":!0}),r(c)!=="svelte-19y7vpj"&&(c.innerHTML=g)},m(y,b){l(y,c,b)},p:es,d(y){y&&a(c)}}}function ds(rt){let c,g,y,b,$,dt,Z,Oa='LoRA is low-rank decomposition method to reduce the number of trainable parameters which speeds up finetuning large models and uses less memory. In PEFT, using LoRA is as easy as setting up a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> and wrapping it with <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> to create a trainable <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>.',mt,j,el="This guide explores in more detail other options and features for using LoRA.",ft,v,ht,k,tl='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> in <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a>. By default, PEFT initializes LoRA weights with Kaiming-uniform for weight A and zeros for weight B resulting in an identity transform (same as the reference <a href="https://github.com/microsoft/LoRA" rel="nofollow">implementation</a>).',ut,U,al='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this initializes weight A with a Gaussian distribution and zeros for weight B (this is how <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">Diffusers</a> initializes LoRA weights).',ct,L,Mt,R,ll="There is also an option to set <code>init_lora_weights=False</code> which is useful for debugging and testing. This should be the only time you use this option. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform.",wt,C,yt,B,gt,W,sl='<a href="https://arxiv.org/abs/2404.02948" rel="nofollow">PiSSA</a> initializes the LoRA adapter using the principal singular values and singular vectors. This straightforward modification allows PiSSA to converge more rapidly than LoRA and ultimately attain superior performance. Moreover, PiSSA reduces the quantization error compared to QLoRA, leading to further enhancements.',bt,I,nl="Configure the initialization method to “pissa”, which may take several minutes to execute SVD on the pre-trained model:",Tt,A,Jt,G,il="Alternatively, execute fast SVD, which takes only a few seconds. The number of iterations determines the trade-off between the error and computation time:",_t,Q,$t,V,ol='For detailed instruction on using PiSSA, please follow <a href="https://github.com/fxmeng/peft/tree/main/examples/pissa_finetuning" rel="nofollow">these instructions</a>.',Zt,x,jt,X,rl='<a href="https://arxiv.org/abs/2406.01775" rel="nofollow">OLoRA</a> utilizes QR decomposition to initialize the LoRA adapters. OLoRA translates the base weights of the model by a factor of their QR decompositions, i.e., it mutates the weights before performing any training on them. This approach significantly improves stability, accelerates convergence speed, and ultimately achieves superior performance.',vt,H,pl="You just need to pass a single additional option to use OLoRA:",kt,z,Ut,q,dl='For more advanced usage, please refer to our <a href="https://github.com/huggingface/peft/tree/main/examples/olora_finetuning" rel="nofollow">documentation</a>.',Lt,F,Rt,E,Ct,Y,ml='When quantizing the base model for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve performance when training quantized models. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use LoftQ, follow <a href="https://github.com/huggingface/peft/tree/main/examples/loftq_finetuning" rel="nofollow">these instructions</a>.',Bt,N,fl="In general, for LoftQ to work best, it is recommended to target as many layers with LoRA as possible, since those not targeted cannot have LoftQ applied. This means that passing <code>LoraConfig(..., target_modules=&quot;all-linear&quot;)</code> will most likely give the best results. Also, you should use <code>nf4</code> as quant type in your quantization config when using 4bit quantization, i.e. <code>BitsAndBytesConfig(load_in_4bit=True, bnb_4bit_quant_type=&quot;nf4&quot;)</code>.",Wt,S,It,P,hl="An easier but more limited way to apply LoftQ initialization is to use the convenience function <code>replace_lora_weights_loftq</code>. This takes the quantized PEFT model as input and replaces the LoRA weights in-place with their LoftQ-initialized counterparts.",At,D,Gt,K,ul='<code>replace_lora_weights_loftq</code> also allows you to pass a <code>callback</code> argument to give you more control over which layers should be modified or not, which empirically can improve the results quite a lot. To see a more elaborate example of this, check out <a href="https://github.com/huggingface/peft/blob/main/examples/loftq_finetuning/LoftQ_weight_replacement.ipynb" rel="nofollow">this notebook</a>.',Qt,O,cl="<code>replace_lora_weights_loftq</code> implements only one iteration step of LoftQ. This means that only the LoRA weights are updated, instead of iteratevily updating LoRA weights and quantized base model weights. This may lead to lower performance but has the advantage that we can use the original quantized weights derived from the base model, instead of having to keep an extra copy of modified quantized weights. Whether this tradeoff is worthwhile depends on the use case.",Vt,ee,Ml="At the moment, <code>replace_lora_weights_loftq</code> has these additional limitations:",xt,te,wl="<li>Model files must be stored as a <code>safetensors</code> file.</li> <li>Only bitsandbytes 4bit quantization is supported.</li>",Xt,T,Ht,ae,zt,le,yl='Another way to initialize <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is with the <a href="https://huggingface.co/papers/2312.03732" rel="nofollow">rank-stabilized LoRA (rsLoRA)</a> method. The LoRA architecture scales each adapter during every forward pass by a fixed scalar which is set at initialization and depends on the rank <code>r</code>. The scalar is given by <code>lora_alpha/r</code> in the original implementation, but rsLoRA uses <code>lora_alpha/math.sqrt(r)</code> which stabilizes the adapters and increases the performance potential from using a higher <code>r</code>.',qt,se,Ft,ne,Et,ie,gl='This technique decomposes the updates of the weights into two parts, magnitude and direction. Direction is handled by normal LoRA, whereas the magnitude is handled by a separate learnable parameter. This can improve the performance of LoRA, especially at low ranks. For more information on DoRA, see  <a href="https://arxiv.org/abs/2402.09353" rel="nofollow">https://arxiv.org/abs/2402.09353</a>.',Yt,oe,Nt,re,bl="If parts of the model or the DoRA adapter are offloaded to CPU you can get a significant speedup at the cost of some temporary (ephemeral) VRAM overhead by using <code>ephemeral_gpu_offload=True</code> in <code>config.runtime_config</code>.",St,pe,Pt,de,Tl="A <code>PeftModel</code> with a DoRA adapter can also be loaded with <code>ephemeral_gpu_offload=True</code> flag using the <code>from_pretrained</code> method as well as the <code>load_adapter</code> method.",Dt,me,Kt,fe,Jl=`DoRA is optimized (computes faster and takes less memory) for models in the evaluation mode, or when dropout is set to 0. We reuse the
base result at those times to get the speedup.
Running <a href="https://github.com/huggingface/peft/blob/main/examples/dora_finetuning/dora_finetuning.py" rel="nofollow">dora finetuning</a>
with <code>CUDA_VISIBLE_DEVICES=0 time python examples/dora_finetuning/dora_finetuning.py --quantize --lora_dropout 0 --batch_size 16 --eval_step 2 --use_dora</code>
on a 4090 with gradient accumulation set to 2 and max step to 20 resulted with the following observations:`,Ot,he,_l='<thead><tr><th align="center"></th> <th align="center">Without Optimization</th> <th align="center">With Optimization</th></tr></thead> <tbody><tr><td align="center">train_runtime</td> <td align="center">359.7298</td> <td align="center"><strong>279.2676</strong></td></tr> <tr><td align="center">train_samples_per_second</td> <td align="center">1.779</td> <td align="center"><strong>2.292</strong></td></tr> <tr><td align="center">train_steps_per_second</td> <td align="center">0.056</td> <td align="center"><strong>0.072</strong></td></tr></tbody>',ea,ue,ta,ce,$l='<li>DoRA only supports embedding, linear, and Conv2d layers at the moment.</li> <li>DoRA introduces a bigger overhead than pure LoRA, so it is recommended to merge weights for inference, see <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">LoraModel.merge_and_unload()</a>.</li> <li>DoRA should work with weights quantized with bitsandbytes (“QDoRA”). However, issues have been reported when using QDoRA with DeepSpeed Zero2.</li>',aa,Me,la,we,Zl='The default LoRA settings in PEFT add trainable weights to the query and value layers of each attention block. But <a href="https://hf.co/papers/2305.14314" rel="nofollow">QLoRA</a>, which adds trainable weights to all the linear layers of a transformer model, can provide performance equal to a fully finetuned model. To apply LoRA to all the linear layers, like in QLoRA, set <code>target_modules=&quot;all-linear&quot;</code> (easier than specifying individual modules by name which can vary depending on the architecture).',sa,ye,na,ge,ia,be,jl='An approach used to improve the performance of models is to expand a model by duplicating layers in the model to build a larger model from a pretrained model of a given size. For example increasing a 7B model to a 10B model as described in the <a href="https://arxiv.org/abs/2312.15166" rel="nofollow">SOLAR</a> paper. PEFT LoRA supports this kind of expansion in a memory efficient manner that supports further fine-tuning using LoRA adapters attached to the layers post replication of the layers. The replicated layers do not take additional memory as they share the underlying weights so the only additional memory required is the memory for the adapter weights. To use this feature you would create a config with the <code>layer_replication</code> argument.',oa,Te,ra,Je,vl='Assuming the original model had 5 layers <code>[0, 1, 2 ,3, 4]</code>, this would create a model with 7 layers arranged as <code>[0, 1, 2, 3, 2, 3, 4]</code>. This follows the <a href="https://github.com/arcee-ai/mergekit" rel="nofollow">mergekit</a> pass through merge convention where sequences of layers specified as start inclusive and end exclusive tuples are stacked to build the final model. Each layer in the final model gets its own distinct set of LoRA adapters.',pa,_e,kl=`<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B" rel="nofollow">Fewshot-Metamath-OrcaVicuna-Mistral-10B</a> is an example of a model trained using this method on Mistral-7B expanded to 10B. The
<a href="https://huggingface.co/abacusai/Fewshot-Metamath-OrcaVicuna-Mistral-10B/blob/main/adapter_config.json" rel="nofollow">adapter_config.json</a> shows a sample LoRA adapter config applying this method for fine-tuning.`,da,$e,ma,Ze,Ul="LoRA training can optionally include special purpose optimizers. Currently the only such optimizer is LoRA+.",fa,je,ha,ve,Ll='LoRA training can be optimized using <a href="https://arxiv.org/abs/2402.12354" rel="nofollow">LoRA+</a>, which uses different learning rates for the adapter matrices A and B, shown to increase finetuning speed by up to 2x and performance by 1-2%.',ua,ke,ca,Ue,Ma,Le,Rl='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA adapter. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model. This allows you to use the newly merged model as a standalone model. The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function doesn’t keep the adapter weights in memory.',wa,Re,Cl="Below is a diagram that explains the intuition of LoRA adapter merging:",ya,J,Bl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',ga,Ce,Wl="We show in the snippets below how to run that using PEFT.",ba,Be,Ta,We,Il='If you need to keep a copy of the weights so you can unmerge the adapter later or delete and load different ones, you should use the <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> function instead. Now you have the option to use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to return the base model.',Ja,Ie,_a,Ae,Al='The <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> function is useful for merging multiple LoRAs into a new adapter based on a user provided weighting scheme in the <code>weights</code> parameter. Below is an end-to-end example.',$a,Ge,Gl="First load the base model:",Za,Qe,ja,Ve,Ql="Then we load the first adapter:",va,xe,ka,Xe,Vl="Then load a different adapter and merge it with the first one:",Ua,He,La,_,Ra,ze,xl="Now, perform inference:",Ca,qe,Ba,Fe,Wa,Ee,Xl='Adapters can be loaded onto a pretrained model with <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel.load_adapter">load_adapter()</a>, which is useful for trying out different adapters whose weights aren’t merged. Set the active adapter weights with the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.set_adapter">set_adapter()</a> function.',Ia,Ye,Aa,Ne,Hl='To return the base model, you could use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to unload all of the LoRA modules or <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete the adapter entirely.',Ga,Se,Qa,Pe,Va,De,zl="Normally, each inference batch has to use the same adapter(s) in PEFT. This can sometimes be annoying, because we may have batches that contain samples intended to be used with different LoRA adapters. For example, we could have a base model that works well in English and two more LoRA adapters, one for French and one for German. Usually, we would have to split our batches such that each batch only contains samples of one of the languages, we cannot combine different languages in the same batch.",xa,Ke,ql="Thankfully, it is possible to mix different LoRA adapters in the same batch using the <code>adapter_name</code> argument. Below, we show an example of how this works in practice. First, let’s load the base model, English, and the two adapters, French and German, like this:",Xa,Oe,Ha,et,Fl="Now, we want to generate text on a sample that contains all three languages: The first three samples are in English, the next three are in French, and the last three are in German. We can use the <code>adapter_names</code> argument to specify which adapter to use for each sample. Since our base model is used for English, we use the special string <code>&quot;__base__&quot;</code> for these samples. For the next three samples, we indicate the adapter name of the French LoRA fine-tune, in this case <code>&quot;adapter_fr&quot;</code>. For the last three samples, we indicate the adapter name of the German LoRA fine-tune, in this case <code>&quot;adapter_de&quot;</code>. This way, we can use the base model and the two adapters in a single batch.",za,tt,qa,at,El="Note that the order does not matter here, i.e. the samples in the batch don’t need to be grouped by adapter as in the example above. We just need to ensure that the <code>adapter_names</code> argument is aligned correctly with the samples.",Fa,lt,Yl="Additionally, the same approach also works with the <code>modules_to_save</code> feature, which allows for saving and reusing specific neural network layers, such as custom heads for classification tasks, across different LoRA adapters.",Ea,st,Ya,nt,Nl="Using this features has some drawbacks, namely:",Na,it,Sl='<li>It only works for inference, not for training.</li> <li>Disabling adapters using the <code>with model.disable_adapter()</code> context takes precedence over <code>adapter_names</code>.</li> <li>You cannot pass <code>adapter_names</code> when some adapter weights where merged with base weight using the <code>merge_adapter</code> method. Please unmerge all adapters first by calling <code>model.unmerge_adapter()</code>.</li> <li>For obvious reasons, this cannot be used after calling <code>merge_and_unload()</code>, since all the LoRA adapters will be merged into the base weights in this case.</li> <li>This feature does not currently work with DoRA, so set <code>use_dora=False</code> in your <code>LoraConfig</code> if you want to use it.</li> <li>The <code>modules_to_save</code> feature is currently only supported for the layers of types <code>Linear</code>, <code>Embedding</code>, <code>Conv2d</code> and <code>Conv1d</code>.</li> <li>There is an expected overhead for inference with <code>adapter_names</code>, especially if the amount of different adapters in the batch is high. This is because the batch size is effectively reduced to the number of samples per adapter. If runtime performance is your top priority, try the following:<ul><li>Increase the batch size.</li> <li>Try to avoid having a large number of different adapters in the same batch, prefer homogeneous batches. This can be achieved by buffering samples with the same adapter and only perform inference with a small handfull of different adapters.</li> <li>Take a look at alternative implementations such as <a href="https://github.com/predibase/lorax" rel="nofollow">LoRAX</a>, <a href="https://github.com/punica-ai/punica" rel="nofollow">punica</a>, or <a href="https://github.com/S-LoRA/S-LoRA" rel="nofollow">S-LoRA</a>, which are specialized to work with a large number of different adapters.</li></ul></li>',Sa,ot,Pa,pt,Da;return $=new w({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),v=new w({props:{title:"Initialization",local:"initialization",headingTag:"h2"}}),L=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmdhdXNzaWFuJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;gaussian&quot;</span>, ...)`,wrap:!1}}),C=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzREZhbHNlJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(init_lora_weights=<span class="hljs-literal">False</span>, ...)`,wrap:!1}}),B=new w({props:{title:"PiSSA",local:"pissa",headingTag:"h3"}}),A=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMnBpc3NhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa&quot;</span>, ...)`,wrap:!1}}),Q=new M({props:{code:"bG9yYV9jb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKGluaXRfbG9yYV93ZWlnaHRzJTNEJTIycGlzc2Ffbml0ZXJfJTVCbnVtYmVyJTIwb2YlMjBpdGVycyU1RCUyMiUyQyUyMC4uLiklMjA=",highlighted:'lora_config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;pissa_niter_[number of iters]&quot;</span>, ...) ',wrap:!1}}),x=new w({props:{title:"OLoRA",local:"olora",headingTag:"h3"}}),z=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMm9sb3JhJTIyJTJDJTIwLi4uKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig
config = LoraConfig(init_lora_weights=<span class="hljs-string">&quot;olora&quot;</span>, ...)`,wrap:!1}}),F=new w({props:{title:"LoftQ",local:"loftq",headingTag:"h3"}}),E=new w({props:{title:"Standard approach",local:"standard-approach",headingTag:"h4"}}),S=new w({props:{title:"A more convenient way",local:"a-more-convenient-way",headingTag:"h4"}}),D=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjByZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBCaXRzQW5kQnl0ZXNDb25maWclMEElMEFibmJfY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjAuLi4pJTBBYmFzZV9tb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCguLi4lMkMlMjBxdWFudGl6YXRpb25fY29uZmlnJTNEYm5iX2NvbmZpZyklMEElMjMlMjBub3RlJTNBJTIwZG9uJ3QlMjBwYXNzJTIwaW5pdF9sb3JhX3dlaWdodHMlM0QlMjJsb2Z0cSUyMiUyMG9yJTIwbG9mdHFfY29uZmlnISUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXNrX3R5cGUlM0QlMjJDQVVTQUxfTE0lMjIpJTBBcGVmdF9tb2RlbCUyMCUzRCUyMGdldF9wZWZ0X21vZGVsKGJhc2VfbW9kZWwlMkMlMjBsb3JhX2NvbmZpZyklMEFyZXBsYWNlX2xvcmFfd2VpZ2h0c19sb2Z0cShwZWZ0X21vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> replace_lora_weights_loftq
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BitsAndBytesConfig

bnb_config = BitsAndBytesConfig(load_in_4bit=<span class="hljs-literal">True</span>, ...)
base_model = AutoModelForCausalLM.from_pretrained(..., quantization_config=bnb_config)
<span class="hljs-comment"># note: don&#x27;t pass init_lora_weights=&quot;loftq&quot; or loftq_config!</span>
lora_config = LoraConfig(task_type=<span class="hljs-string">&quot;CAUSAL_LM&quot;</span>)
peft_model = get_peft_model(base_model, lora_config)
replace_lora_weights_loftq(peft_model)`,wrap:!1}}),T=new Ol({props:{$$slots:{default:[rs]},$$scope:{ctx:rt}}}),ae=new w({props:{title:"Rank-stabilized LoRA",local:"rank-stabilized-lora",headingTag:"h3"}}),se=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfcnNsb3JhJTNEVHJ1ZSUyQyUyMC4uLik=",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_rslora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),ne=new w({props:{title:"Weight-Decomposed Low-Rank Adaptation (DoRA)",local:"weight-decomposed-low-rank-adaptation-dora",headingTag:"h3"}}),oe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTBBJTBBY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh1c2VfZG9yYSUzRFRydWUlMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, ...)`,wrap:!1}}),pe=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwTG9yYVJ1bnRpbWVDb25maWclMEElMEFjb25maWclMjAlM0QlMjBMb3JhQ29uZmlnKHVzZV9kb3JhJTNEVHJ1ZSUyQyUyMHJ1bnRpbWVfY29uZmlnJTNETG9yYVJ1bnRpbWVDb25maWcoZXBoZW1lcmFsX2dwdV9vZmZsb2FkJTNEVHJ1ZSklMkMlMjAuLi4p",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, LoraRuntimeConfig

config = LoraConfig(use_dora=<span class="hljs-literal">True</span>, runtime_config=LoraRuntimeConfig(ephemeral_gpu_offload=<span class="hljs-literal">True</span>), ...)`,wrap:!1}}),me=new M({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFtb2RlbCUyMCUzRCUyMFBlZnRNb2RlbC5mcm9tX3ByZXRyYWluZWQoYmFzZV9tb2RlbCUyQyUyMHBlZnRfbW9kZWxfaWQlMkMlMjBlcGhlbWVyYWxfZ3B1X29mZmxvYWQlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model = PeftModel.from_pretrained(base_model, peft_model_id, ephemeral_gpu_offload=<span class="hljs-literal">True</span>)`,wrap:!1}}),ue=new w({props:{title:"Caveats",local:"caveats",headingTag:"h4"}}),Me=new w({props:{title:"QLoRA-style training",local:"qlora-style-training",headingTag:"h3"}}),ye=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyh0YXJnZXRfbW9kdWxlcyUzRCUyMmFsbC1saW5lYXIlMjIlMkMlMjAuLi4p",highlighted:'config = LoraConfig(target_modules=<span class="hljs-string">&quot;all-linear&quot;</span>, ...)',wrap:!1}}),ge=new w({props:{title:"Memory efficient Layer Replication with LoRA",local:"memory-efficient-layer-replication-with-lora",headingTag:"h3"}}),Te=new M({props:{code:"Y29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyhsYXllcl9yZXBsaWNhdGlvbiUzRCU1QiU1QjAlMkM0JTVEJTJDJTIwJTVCMiUyQzUlNUQlNUQlMkMlMjAuLi4p",highlighted:'config = LoraConfig(layer_replication=[[<span class="hljs-number">0</span>,<span class="hljs-number">4</span>], [<span class="hljs-number">2</span>,<span class="hljs-number">5</span>]], ...)',wrap:!1}}),$e=new w({props:{title:"Optimizers",local:"optimizers",headingTag:"h2"}}),je=new w({props:{title:"LoRA+ optimized LoRA",local:"lora-optimized-lora",headingTag:"h3"}}),ke=new M({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, get_peft_model
<span class="hljs-keyword">from</span> peft.optimizers <span class="hljs-keyword">import</span> create_loraplus_optimizer
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer
<span class="hljs-keyword">import</span> bitsandbytes <span class="hljs-keyword">as</span> bnb

base_model = ...
config = LoraConfig(...)
model = get_peft_model(base_model, config)

optimizer = create_loraplus_optimizer(
    model=model,
    optimizer_cls=bnb.optim.Adam8bit,
    lr=<span class="hljs-number">5e-5</span>,
    loraplus_lr_ratio=<span class="hljs-number">16</span>,
)
scheduler = <span class="hljs-literal">None</span>

...
trainer = Trainer(
    ...,
    optimizers=(optimizer, scheduler),
)`,wrap:!1}}),Ue=new w({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),Be=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FuZF91bmxvYWQoKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_and_unload()`,wrap:!1}}),Ie=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQW1vZGVsLm1lcmdlX2FkYXB0ZXIoKSUwQSUwQSUyMyUyMHVubWVyZ2UlMjB0aGUlMjBMb1JBJTIwbGF5ZXJzJTIwZnJvbSUyMHRoZSUyMGJhc2UlMjBtb2RlbCUwQW1vZGVsLnVubWVyZ2VfYWRhcHRlcigp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)
model.merge_adapter()

<span class="hljs-comment"># unmerge the LoRA layers from the base model</span>
model.unmerge_adapter()`,wrap:!1}}),Qe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel
<span class="hljs-keyword">import</span> torch

base_model = AutoModelForCausalLM.from_pretrained(
    <span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>
)`,wrap:!1}}),xe=new M({props:{code:"cGVmdF9tb2RlbF9pZCUyMCUzRCUyMCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1zZnQtbG9yYSUyMiUwQW1vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChiYXNlX21vZGVsJTJDJTIwcGVmdF9tb2RlbF9pZCUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnNmdCUyMik=",highlighted:`peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id, adapter_name=<span class="hljs-string">&quot;sft&quot;</span>)`,wrap:!1}}),He=new M({props:{code:"d2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTIwJTNEJTIwJTIyc2Z0LWRwbyUyMiUwQW1vZGVsLmxvYWRfYWRhcHRlciglMjJhbGlnbm1lbnQtaGFuZGJvb2slMkZ6ZXBoeXItN2ItZHBvLWxvcmElMjIlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJkcG8lMjIpJTBBbW9kZWwuYWRkX3dlaWdodGVkX2FkYXB0ZXIoJTBBJTIwJTIwJTIwJTIwYWRhcHRlcnMlM0QlNUIlMjJzZnQlMjIlMkMlMjAlMjJkcG8lMjIlNUQlMkMlMEElMjAlMjAlMjAlMjB3ZWlnaHRzJTNEJTVCMC43JTJDJTIwMC4zJTVEJTJDJTBBJTIwJTIwJTIwJTIwYWRhcHRlcl9uYW1lJTNEd2VpZ2h0ZWRfYWRhcHRlcl9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwY29tYmluYXRpb25fdHlwZSUzRCUyMmxpbmVhciUyMiUwQSklMEFtb2RlbC5zZXRfYWRhcHRlcih3ZWlnaHRlZF9hZGFwdGVyX25hbWUp",highlighted:`weighted_adapter_name = <span class="hljs-string">&quot;sft-dpo&quot;</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)
model.add_weighted_adapter(
    adapters=[<span class="hljs-string">&quot;sft&quot;</span>, <span class="hljs-string">&quot;dpo&quot;</span>],
    weights=[<span class="hljs-number">0.7</span>, <span class="hljs-number">0.3</span>],
    adapter_name=weighted_adapter_name,
    combination_type=<span class="hljs-string">&quot;linear&quot;</span>
)
model.set_adapter(weighted_adapter_name)`,wrap:!1}}),_=new Ol({props:{$$slots:{default:[ps]},$$scope:{ctx:rt}}}),qe=new M({props:{code:"dG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIybWlzdHJhbGFpJTJGTWlzdHJhbC03Qi12MC4xJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkhleSUyQyUyMGFyZSUyMHlvdSUyMGNvbnNjaW91cyUzRiUyMENhbiUyMHlvdSUyMHRhbGslMjB0byUyMG1lJTNGJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBaW5wdXRzJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oJTIyY3VkYSUyMiklMjBmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklN0QlMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoKippbnB1dHMlMkMlMjBtYXhfbGVuZ3RoJTNEMzApJTBBb3V0cHV0cyUyMCUzRCUyMHRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RCUwQXByaW50KG91dHB1dHMp",highlighted:`tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)

prompt = <span class="hljs-string">&quot;Hey, are you conscious? Can you talk to me?&quot;</span>
inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
inputs = {k: v.to(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items()}

<span class="hljs-keyword">with</span> torch.no_grad():
    generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
outputs = tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-built_in">print</span>(outputs)`,wrap:!1}}),Fe=new w({props:{title:"Load adapters",local:"load-adapters",headingTag:"h2"}}),Ye=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBQZWZ0TW9kZWwlMEElMEFiYXNlX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMm1pc3RyYWxhaSUyRk1pc3RyYWwtN0ItdjAuMSUyMiklMEFwZWZ0X21vZGVsX2lkJTIwJTNEJTIwJTIyYWxpZ25tZW50LWhhbmRib29rJTJGemVwaHlyLTdiLXNmdC1sb3JhJTIyJTBBbW9kZWwlMjAlM0QlMjBQZWZ0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKGJhc2VfbW9kZWwlMkMlMjBwZWZ0X21vZGVsX2lkKSUwQSUwQSUyMyUyMGxvYWQlMjBkaWZmZXJlbnQlMjBhZGFwdGVyJTBBbW9kZWwubG9hZF9hZGFwdGVyKCUyMmFsaWdubWVudC1oYW5kYm9vayUyRnplcGh5ci03Yi1kcG8tbG9yYSUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMmRwbyUyMiklMEElMEElMjMlMjBzZXQlMjBhZGFwdGVyJTIwYXMlMjBhY3RpdmUlMEFtb2RlbC5zZXRfYWRhcHRlciglMjJkcG8lMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

base_model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;mistralai/Mistral-7B-v0.1&quot;</span>)
peft_model_id = <span class="hljs-string">&quot;alignment-handbook/zephyr-7b-sft-lora&quot;</span>
model = PeftModel.from_pretrained(base_model, peft_model_id)

<span class="hljs-comment"># load different adapter</span>
model.load_adapter(<span class="hljs-string">&quot;alignment-handbook/zephyr-7b-dpo-lora&quot;</span>, adapter_name=<span class="hljs-string">&quot;dpo&quot;</span>)

<span class="hljs-comment"># set adapter as active</span>
model.set_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Se=new M({props:{code:"JTIzJTIwdW5sb2FkJTIwYWRhcHRlciUwQW1vZGVsLnVubG9hZCgpJTBBJTBBJTIzJTIwZGVsZXRlJTIwYWRhcHRlciUwQW1vZGVsLmRlbGV0ZV9hZGFwdGVyKCUyMmRwbyUyMik=",highlighted:`<span class="hljs-comment"># unload adapter</span>
model.unload()

<span class="hljs-comment"># delete adapter</span>
model.delete_adapter(<span class="hljs-string">&quot;dpo&quot;</span>)`,wrap:!1}}),Pe=new w({props:{title:"Inference with different LoRA adapters in the same batch",local:"inference-with-different-lora-adapters-in-the-same-batch",headingTag:"h2"}}),Oe=new M({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQWZyb20lMjBwZWZ0JTIwaW1wb3J0JTIwUGVmdE1vZGVsJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAuLi4lMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEElMjMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBGcmVuY2glMEFwZWZ0X21vZGVsJTIwJTNEJTIwUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZChtb2RlbCUyQyUyMCUzQ3BhdGglM0UlMkMlMjBhZGFwdGVyX25hbWUlM0QlMjJhZGFwdGVyX2ZyJTIyKSUwQSUyMyUyMG5leHQlMkMlMjBsb2FkJTIwdGhlJTIwTG9SQSUyMGFkYXB0ZXIlMjBmb3IlMjBHZXJtYW4lMEFwZWZ0X21vZGVsLmxvYWRfYWRhcHRlciglM0NwYXRoJTNFJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIyYWRhcHRlcl9kZSUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM
<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> PeftModel

model_id = ...
tokenizer = AutoTokenizer.from_pretrained(model_id)

model = AutoModelForCausalLM.from_pretrained(model_id)
<span class="hljs-comment"># load the LoRA adapter for French</span>
peft_model = PeftModel.from_pretrained(model, &lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_fr&quot;</span>)
<span class="hljs-comment"># next, load the LoRA adapter for German</span>
peft_model.load_adapter(&lt;path&gt;, adapter_name=<span class="hljs-string">&quot;adapter_de&quot;</span>)`,wrap:!1}}),tt=new M({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUwQSUyMCUyMCUyMCUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhlbGxvJTJDJTIwbXklMjBkb2clMjBpcyUyMGN1dGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIZWxsbyUyQyUyMG15JTIwY2F0JTIwaXMlMjBhd2Vzb21lJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIySGVsbG8lMkMlMjBteSUyMGZpc2glMjBpcyUyMGdyZWF0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBjaGllbiUyMGVzdCUyMG1pZ25vbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMlNhbHV0JTJDJTIwbW9uJTIwY2hhdCUyMGVzdCUyMGclQzMlQTluaWFsJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyU2FsdXQlMkMlMjBtb24lMjBwb2lzc29uJTIwZXN0JTIwc3VwZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBIdW5kJTIwaXN0JTIwcyVDMyVCQyVDMyU5RiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMkhhbGxvJTJDJTIwbWVpbmUlMjBLYXR6ZSUyMGlzdCUyMHRvbGwlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJIYWxsbyUyQyUyMG1laW4lMjBGaXNjaCUyMGlzdCUyMGdybyVDMyU5RmFydGlnJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUwQSUyMCUyMCUyMCUyMHBhZGRpbmclM0RUcnVlJTJDJTBBKSUwQSUwQWFkYXB0ZXJfbmFtZXMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJfX2Jhc2VfXyUyMiUyQyUyMCUyMl9fYmFzZV9fJTIyJTJDJTIwJTIyX19iYXNlX18lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2ZyJTIyJTJDJTIwJTIyYWRhcHRlcl9mciUyMiUyQyUyMCUyMmFkYXB0ZXJfZnIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJhZGFwdGVyX2RlJTIyJTJDJTIwJTIyYWRhcHRlcl9kZSUyMiUyQyUyMCUyMmFkYXB0ZXJfZGUlMjIlMkMlMEElNUQlMEFvdXRwdXQlMjAlM0QlMjBwZWZ0X21vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwYWRhcHRlcl9uYW1lcyUzRGFkYXB0ZXJfbmFtZXMlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDIwKQ==",highlighted:`inputs = tokenizer(
    [
        <span class="hljs-string">&quot;Hello, my dog is cute&quot;</span>,
        <span class="hljs-string">&quot;Hello, my cat is awesome&quot;</span>,
        <span class="hljs-string">&quot;Hello, my fish is great&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chien est mignon&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon chat est génial&quot;</span>,
        <span class="hljs-string">&quot;Salut, mon poisson est super&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Hund ist süß&quot;</span>,
        <span class="hljs-string">&quot;Hallo, meine Katze ist toll&quot;</span>,
        <span class="hljs-string">&quot;Hallo, mein Fisch ist großartig&quot;</span>,
    ],
    return_tensors=<span class="hljs-string">&quot;pt&quot;</span>,
    padding=<span class="hljs-literal">True</span>,
)

adapter_names = [
    <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>, <span class="hljs-string">&quot;__base__&quot;</span>,
    <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>, <span class="hljs-string">&quot;adapter_fr&quot;</span>,
    <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>, <span class="hljs-string">&quot;adapter_de&quot;</span>,
]
output = peft_model.generate(**inputs, adapter_names=adapter_names, max_new_tokens=<span class="hljs-number">20</span>)`,wrap:!1}}),st=new w({props:{title:"Caveats",local:"caveats",headingTag:"h3"}}),ot=new os({props:{source:"https://github.com/huggingface/peft/blob/main/docs/source/developer_guides/lora.md"}}),{c(){c=i("meta"),g=s(),y=i("p"),b=s(),p($.$$.fragment),dt=s(),Z=i("p"),Z.innerHTML=Oa,mt=s(),j=i("p"),j.textContent=el,ft=s(),p(v.$$.fragment),ht=s(),k=i("p"),k.innerHTML=tl,ut=s(),U=i("p"),U.innerHTML=al,ct=s(),p(L.$$.fragment),Mt=s(),R=i("p"),R.innerHTML=ll,wt=s(),p(C.$$.fragment),yt=s(),p(B.$$.fragment),gt=s(),W=i("p"),W.innerHTML=sl,bt=s(),I=i("p"),I.textContent=nl,Tt=s(),p(A.$$.fragment),Jt=s(),G=i("p"),G.textContent=il,_t=s(),p(Q.$$.fragment),$t=s(),V=i("p"),V.innerHTML=ol,Zt=s(),p(x.$$.fragment),jt=s(),X=i("p"),X.innerHTML=rl,vt=s(),H=i("p"),H.textContent=pl,kt=s(),p(z.$$.fragment),Ut=s(),q=i("p"),q.innerHTML=dl,Lt=s(),p(F.$$.fragment),Rt=s(),p(E.$$.fragment),Ct=s(),Y=i("p"),Y.innerHTML=ml,Bt=s(),N=i("p"),N.innerHTML=fl,Wt=s(),p(S.$$.fragment),It=s(),P=i("p"),P.innerHTML=hl,At=s(),p(D.$$.fragment),Gt=s(),K=i("p"),K.innerHTML=ul,Qt=s(),O=i("p"),O.innerHTML=cl,Vt=s(),ee=i("p"),ee.innerHTML=Ml,xt=s(),te=i("ul"),te.innerHTML=wl,Xt=s(),p(T.$$.fragment),Ht=s(),p(ae.$$.fragment),zt=s(),le=i("p"),le.innerHTML=yl,qt=s(),p(se.$$.fragment),Ft=s(),p(ne.$$.fragment),Et=s(),ie=i("p"),ie.innerHTML=gl,Yt=s(),p(oe.$$.fragment),Nt=s(),re=i("p"),re.innerHTML=bl,St=s(),p(pe.$$.fragment),Pt=s(),de=i("p"),de.innerHTML=Tl,Dt=s(),p(me.$$.fragment),Kt=s(),fe=i("p"),fe.innerHTML=Jl,Ot=s(),he=i("table"),he.innerHTML=_l,ea=s(),p(ue.$$.fragment),ta=s(),ce=i("ul"),ce.innerHTML=$l,aa=s(),p(Me.$$.fragment),la=s(),we=i("p"),we.innerHTML=Zl,sa=s(),p(ye.$$.fragment),na=s(),p(ge.$$.fragment),ia=s(),be=i("p"),be.innerHTML=jl,oa=s(),p(Te.$$.fragment),ra=s(),Je=i("p"),Je.innerHTML=vl,pa=s(),_e=i("p"),_e.innerHTML=kl,da=s(),p($e.$$.fragment),ma=s(),Ze=i("p"),Ze.textContent=Ul,fa=s(),p(je.$$.fragment),ha=s(),ve=i("p"),ve.innerHTML=Ll,ua=s(),p(ke.$$.fragment),ca=s(),p(Ue.$$.fragment),Ma=s(),Le=i("p"),Le.innerHTML=Rl,wa=s(),Re=i("p"),Re.textContent=Cl,ya=s(),J=i("div"),J.innerHTML=Bl,ga=s(),Ce=i("p"),Ce.textContent=Wl,ba=s(),p(Be.$$.fragment),Ta=s(),We=i("p"),We.innerHTML=Il,Ja=s(),p(Ie.$$.fragment),_a=s(),Ae=i("p"),Ae.innerHTML=Al,$a=s(),Ge=i("p"),Ge.textContent=Gl,Za=s(),p(Qe.$$.fragment),ja=s(),Ve=i("p"),Ve.textContent=Ql,va=s(),p(xe.$$.fragment),ka=s(),Xe=i("p"),Xe.textContent=Vl,Ua=s(),p(He.$$.fragment),La=s(),p(_.$$.fragment),Ra=s(),ze=i("p"),ze.textContent=xl,Ca=s(),p(qe.$$.fragment),Ba=s(),p(Fe.$$.fragment),Wa=s(),Ee=i("p"),Ee.innerHTML=Xl,Ia=s(),p(Ye.$$.fragment),Aa=s(),Ne=i("p"),Ne.innerHTML=Hl,Ga=s(),p(Se.$$.fragment),Qa=s(),p(Pe.$$.fragment),Va=s(),De=i("p"),De.textContent=zl,xa=s(),Ke=i("p"),Ke.innerHTML=ql,Xa=s(),p(Oe.$$.fragment),Ha=s(),et=i("p"),et.innerHTML=Fl,za=s(),p(tt.$$.fragment),qa=s(),at=i("p"),at.innerHTML=El,Fa=s(),lt=i("p"),lt.innerHTML=Yl,Ea=s(),p(st.$$.fragment),Ya=s(),nt=i("p"),nt.textContent=Nl,Na=s(),it=i("ul"),it.innerHTML=Sl,Sa=s(),p(ot.$$.fragment),Pa=s(),pt=i("p"),this.h()},l(e){const t=ns("svelte-u9bgzb",document.head);c=o(t,"META",{name:!0,content:!0}),t.forEach(a),g=n(e),y=o(e,"P",{}),Kl(y).forEach(a),b=n(e),d($.$$.fragment,e),dt=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-38uxl6"&&(Z.innerHTML=Oa),mt=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ovsn32"&&(j.textContent=el),ft=n(e),d(v.$$.fragment,e),ht=n(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-j883mf"&&(k.innerHTML=tl),ut=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1fujb7a"&&(U.innerHTML=al),ct=n(e),d(L.$$.fragment,e),Mt=n(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-mwvui1"&&(R.innerHTML=ll),wt=n(e),d(C.$$.fragment,e),yt=n(e),d(B.$$.fragment,e),gt=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1skluc"&&(W.innerHTML=sl),bt=n(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1hy0lgx"&&(I.textContent=nl),Tt=n(e),d(A.$$.fragment,e),Jt=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-auzrbb"&&(G.textContent=il),_t=n(e),d(Q.$$.fragment,e),$t=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-u5znzv"&&(V.innerHTML=ol),Zt=n(e),d(x.$$.fragment,e),jt=n(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-17kc0j8"&&(X.innerHTML=rl),vt=n(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1j9g8qn"&&(H.textContent=pl),kt=n(e),d(z.$$.fragment,e),Ut=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-sulxp4"&&(q.innerHTML=dl),Lt=n(e),d(F.$$.fragment,e),Rt=n(e),d(E.$$.fragment,e),Ct=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1ts8vpq"&&(Y.innerHTML=ml),Bt=n(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-7f0aai"&&(N.innerHTML=fl),Wt=n(e),d(S.$$.fragment,e),It=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-14vtcq9"&&(P.innerHTML=hl),At=n(e),d(D.$$.fragment,e),Gt=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1nywyxh"&&(K.innerHTML=ul),Qt=n(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1d2jix1"&&(O.innerHTML=cl),Vt=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-yl8kok"&&(ee.innerHTML=Ml),xt=n(e),te=o(e,"UL",{"data-svelte-h":!0}),r(te)!=="svelte-12tl4fy"&&(te.innerHTML=wl),Xt=n(e),d(T.$$.fragment,e),Ht=n(e),d(ae.$$.fragment,e),zt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-omuw13"&&(le.innerHTML=yl),qt=n(e),d(se.$$.fragment,e),Ft=n(e),d(ne.$$.fragment,e),Et=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1ukfkwt"&&(ie.innerHTML=gl),Yt=n(e),d(oe.$$.fragment,e),Nt=n(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-8wzhde"&&(re.innerHTML=bl),St=n(e),d(pe.$$.fragment,e),Pt=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-16lyt50"&&(de.innerHTML=Tl),Dt=n(e),d(me.$$.fragment,e),Kt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-zr3cxq"&&(fe.innerHTML=Jl),Ot=n(e),he=o(e,"TABLE",{"data-svelte-h":!0}),r(he)!=="svelte-1iyfgt7"&&(he.innerHTML=_l),ea=n(e),d(ue.$$.fragment,e),ta=n(e),ce=o(e,"UL",{"data-svelte-h":!0}),r(ce)!=="svelte-j4nx09"&&(ce.innerHTML=$l),aa=n(e),d(Me.$$.fragment,e),la=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-15vxux2"&&(we.innerHTML=Zl),sa=n(e),d(ye.$$.fragment,e),na=n(e),d(ge.$$.fragment,e),ia=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1mosto0"&&(be.innerHTML=jl),oa=n(e),d(Te.$$.fragment,e),ra=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1ttqqw0"&&(Je.innerHTML=vl),pa=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-foj0wd"&&(_e.innerHTML=kl),da=n(e),d($e.$$.fragment,e),ma=n(e),Ze=o(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-rkzqzi"&&(Ze.textContent=Ul),fa=n(e),d(je.$$.fragment,e),ha=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-9dmo2s"&&(ve.innerHTML=Ll),ua=n(e),d(ke.$$.fragment,e),ca=n(e),d(Ue.$$.fragment,e),Ma=n(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1c3h9aa"&&(Le.innerHTML=Rl),wa=n(e),Re=o(e,"P",{"data-svelte-h":!0}),r(Re)!=="svelte-1wwmf5r"&&(Re.textContent=Cl),ya=n(e),J=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(J)!=="svelte-1f6iuw5"&&(J.innerHTML=Bl),ga=n(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-hlzwis"&&(Ce.textContent=Wl),ba=n(e),d(Be.$$.fragment,e),Ta=n(e),We=o(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-m3cr6r"&&(We.innerHTML=Il),Ja=n(e),d(Ie.$$.fragment,e),_a=n(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-kbqhpl"&&(Ae.innerHTML=Al),$a=n(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-1mwdwt1"&&(Ge.textContent=Gl),Za=n(e),d(Qe.$$.fragment,e),ja=n(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-nuhu05"&&(Ve.textContent=Ql),va=n(e),d(xe.$$.fragment,e),ka=n(e),Xe=o(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1n53hd9"&&(Xe.textContent=Vl),Ua=n(e),d(He.$$.fragment,e),La=n(e),d(_.$$.fragment,e),Ra=n(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-qwbdkg"&&(ze.textContent=xl),Ca=n(e),d(qe.$$.fragment,e),Ba=n(e),d(Fe.$$.fragment,e),Wa=n(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-ke62q2"&&(Ee.innerHTML=Xl),Ia=n(e),d(Ye.$$.fragment,e),Aa=n(e),Ne=o(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-cvmoj6"&&(Ne.innerHTML=Hl),Ga=n(e),d(Se.$$.fragment,e),Qa=n(e),d(Pe.$$.fragment,e),Va=n(e),De=o(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1fq5tpu"&&(De.textContent=zl),xa=n(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-lcywla"&&(Ke.innerHTML=ql),Xa=n(e),d(Oe.$$.fragment,e),Ha=n(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-6wkyom"&&(et.innerHTML=Fl),za=n(e),d(tt.$$.fragment,e),qa=n(e),at=o(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1o40ch6"&&(at.innerHTML=El),Fa=n(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-13py9hk"&&(lt.innerHTML=Yl),Ea=n(e),d(st.$$.fragment,e),Ya=n(e),nt=o(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-fpz5mj"&&(nt.textContent=Nl),Na=n(e),it=o(e,"UL",{"data-svelte-h":!0}),r(it)!=="svelte-150o10n"&&(it.innerHTML=Sl),Sa=n(e),d(ot.$$.fragment,e),Pa=n(e),pt=o(e,"P",{}),Kl(pt).forEach(a),this.h()},h(){Ka(c,"name","hf:doc:metadata"),Ka(c,"content",ms),Ka(J,"class","flex justify-center")},m(e,t){is(document.head,c),l(e,g,t),l(e,y,t),l(e,b,t),m($,e,t),l(e,dt,t),l(e,Z,t),l(e,mt,t),l(e,j,t),l(e,ft,t),m(v,e,t),l(e,ht,t),l(e,k,t),l(e,ut,t),l(e,U,t),l(e,ct,t),m(L,e,t),l(e,Mt,t),l(e,R,t),l(e,wt,t),m(C,e,t),l(e,yt,t),m(B,e,t),l(e,gt,t),l(e,W,t),l(e,bt,t),l(e,I,t),l(e,Tt,t),m(A,e,t),l(e,Jt,t),l(e,G,t),l(e,_t,t),m(Q,e,t),l(e,$t,t),l(e,V,t),l(e,Zt,t),m(x,e,t),l(e,jt,t),l(e,X,t),l(e,vt,t),l(e,H,t),l(e,kt,t),m(z,e,t),l(e,Ut,t),l(e,q,t),l(e,Lt,t),m(F,e,t),l(e,Rt,t),m(E,e,t),l(e,Ct,t),l(e,Y,t),l(e,Bt,t),l(e,N,t),l(e,Wt,t),m(S,e,t),l(e,It,t),l(e,P,t),l(e,At,t),m(D,e,t),l(e,Gt,t),l(e,K,t),l(e,Qt,t),l(e,O,t),l(e,Vt,t),l(e,ee,t),l(e,xt,t),l(e,te,t),l(e,Xt,t),m(T,e,t),l(e,Ht,t),m(ae,e,t),l(e,zt,t),l(e,le,t),l(e,qt,t),m(se,e,t),l(e,Ft,t),m(ne,e,t),l(e,Et,t),l(e,ie,t),l(e,Yt,t),m(oe,e,t),l(e,Nt,t),l(e,re,t),l(e,St,t),m(pe,e,t),l(e,Pt,t),l(e,de,t),l(e,Dt,t),m(me,e,t),l(e,Kt,t),l(e,fe,t),l(e,Ot,t),l(e,he,t),l(e,ea,t),m(ue,e,t),l(e,ta,t),l(e,ce,t),l(e,aa,t),m(Me,e,t),l(e,la,t),l(e,we,t),l(e,sa,t),m(ye,e,t),l(e,na,t),m(ge,e,t),l(e,ia,t),l(e,be,t),l(e,oa,t),m(Te,e,t),l(e,ra,t),l(e,Je,t),l(e,pa,t),l(e,_e,t),l(e,da,t),m($e,e,t),l(e,ma,t),l(e,Ze,t),l(e,fa,t),m(je,e,t),l(e,ha,t),l(e,ve,t),l(e,ua,t),m(ke,e,t),l(e,ca,t),m(Ue,e,t),l(e,Ma,t),l(e,Le,t),l(e,wa,t),l(e,Re,t),l(e,ya,t),l(e,J,t),l(e,ga,t),l(e,Ce,t),l(e,ba,t),m(Be,e,t),l(e,Ta,t),l(e,We,t),l(e,Ja,t),m(Ie,e,t),l(e,_a,t),l(e,Ae,t),l(e,$a,t),l(e,Ge,t),l(e,Za,t),m(Qe,e,t),l(e,ja,t),l(e,Ve,t),l(e,va,t),m(xe,e,t),l(e,ka,t),l(e,Xe,t),l(e,Ua,t),m(He,e,t),l(e,La,t),m(_,e,t),l(e,Ra,t),l(e,ze,t),l(e,Ca,t),m(qe,e,t),l(e,Ba,t),m(Fe,e,t),l(e,Wa,t),l(e,Ee,t),l(e,Ia,t),m(Ye,e,t),l(e,Aa,t),l(e,Ne,t),l(e,Ga,t),m(Se,e,t),l(e,Qa,t),m(Pe,e,t),l(e,Va,t),l(e,De,t),l(e,xa,t),l(e,Ke,t),l(e,Xa,t),m(Oe,e,t),l(e,Ha,t),l(e,et,t),l(e,za,t),m(tt,e,t),l(e,qa,t),l(e,at,t),l(e,Fa,t),l(e,lt,t),l(e,Ea,t),m(st,e,t),l(e,Ya,t),l(e,nt,t),l(e,Na,t),l(e,it,t),l(e,Sa,t),m(ot,e,t),l(e,Pa,t),l(e,pt,t),Da=!0},p(e,[t]){const Pl={};t&2&&(Pl.$$scope={dirty:t,ctx:e}),T.$set(Pl);const Dl={};t&2&&(Dl.$$scope={dirty:t,ctx:e}),_.$set(Dl)},i(e){Da||(f($.$$.fragment,e),f(v.$$.fragment,e),f(L.$$.fragment,e),f(C.$$.fragment,e),f(B.$$.fragment,e),f(A.$$.fragment,e),f(Q.$$.fragment,e),f(x.$$.fragment,e),f(z.$$.fragment,e),f(F.$$.fragment,e),f(E.$$.fragment,e),f(S.$$.fragment,e),f(D.$$.fragment,e),f(T.$$.fragment,e),f(ae.$$.fragment,e),f(se.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),f(me.$$.fragment,e),f(ue.$$.fragment,e),f(Me.$$.fragment,e),f(ye.$$.fragment,e),f(ge.$$.fragment,e),f(Te.$$.fragment,e),f($e.$$.fragment,e),f(je.$$.fragment,e),f(ke.$$.fragment,e),f(Ue.$$.fragment,e),f(Be.$$.fragment,e),f(Ie.$$.fragment,e),f(Qe.$$.fragment,e),f(xe.$$.fragment,e),f(He.$$.fragment,e),f(_.$$.fragment,e),f(qe.$$.fragment,e),f(Fe.$$.fragment,e),f(Ye.$$.fragment,e),f(Se.$$.fragment,e),f(Pe.$$.fragment,e),f(Oe.$$.fragment,e),f(tt.$$.fragment,e),f(st.$$.fragment,e),f(ot.$$.fragment,e),Da=!0)},o(e){h($.$$.fragment,e),h(v.$$.fragment,e),h(L.$$.fragment,e),h(C.$$.fragment,e),h(B.$$.fragment,e),h(A.$$.fragment,e),h(Q.$$.fragment,e),h(x.$$.fragment,e),h(z.$$.fragment,e),h(F.$$.fragment,e),h(E.$$.fragment,e),h(S.$$.fragment,e),h(D.$$.fragment,e),h(T.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(Me.$$.fragment,e),h(ye.$$.fragment,e),h(ge.$$.fragment,e),h(Te.$$.fragment,e),h($e.$$.fragment,e),h(je.$$.fragment,e),h(ke.$$.fragment,e),h(Ue.$$.fragment,e),h(Be.$$.fragment,e),h(Ie.$$.fragment,e),h(Qe.$$.fragment,e),h(xe.$$.fragment,e),h(He.$$.fragment,e),h(_.$$.fragment,e),h(qe.$$.fragment,e),h(Fe.$$.fragment,e),h(Ye.$$.fragment,e),h(Se.$$.fragment,e),h(Pe.$$.fragment,e),h(Oe.$$.fragment,e),h(tt.$$.fragment,e),h(st.$$.fragment,e),h(ot.$$.fragment,e),Da=!1},d(e){e&&(a(g),a(y),a(b),a(dt),a(Z),a(mt),a(j),a(ft),a(ht),a(k),a(ut),a(U),a(ct),a(Mt),a(R),a(wt),a(yt),a(gt),a(W),a(bt),a(I),a(Tt),a(Jt),a(G),a(_t),a($t),a(V),a(Zt),a(jt),a(X),a(vt),a(H),a(kt),a(Ut),a(q),a(Lt),a(Rt),a(Ct),a(Y),a(Bt),a(N),a(Wt),a(It),a(P),a(At),a(Gt),a(K),a(Qt),a(O),a(Vt),a(ee),a(xt),a(te),a(Xt),a(Ht),a(zt),a(le),a(qt),a(Ft),a(Et),a(ie),a(Yt),a(Nt),a(re),a(St),a(Pt),a(de),a(Dt),a(Kt),a(fe),a(Ot),a(he),a(ea),a(ta),a(ce),a(aa),a(la),a(we),a(sa),a(na),a(ia),a(be),a(oa),a(ra),a(Je),a(pa),a(_e),a(da),a(ma),a(Ze),a(fa),a(ha),a(ve),a(ua),a(ca),a(Ma),a(Le),a(wa),a(Re),a(ya),a(J),a(ga),a(Ce),a(ba),a(Ta),a(We),a(Ja),a(_a),a(Ae),a($a),a(Ge),a(Za),a(ja),a(Ve),a(va),a(ka),a(Xe),a(Ua),a(La),a(Ra),a(ze),a(Ca),a(Ba),a(Wa),a(Ee),a(Ia),a(Aa),a(Ne),a(Ga),a(Qa),a(Va),a(De),a(xa),a(Ke),a(Xa),a(Ha),a(et),a(za),a(qa),a(at),a(Fa),a(lt),a(Ea),a(Ya),a(nt),a(Na),a(it),a(Sa),a(Pa),a(pt)),a(c),u($,e),u(v,e),u(L,e),u(C,e),u(B,e),u(A,e),u(Q,e),u(x,e),u(z,e),u(F,e),u(E,e),u(S,e),u(D,e),u(T,e),u(ae,e),u(se,e),u(ne,e),u(oe,e),u(pe,e),u(me,e),u(ue,e),u(Me,e),u(ye,e),u(ge,e),u(Te,e),u($e,e),u(je,e),u(ke,e),u(Ue,e),u(Be,e),u(Ie,e),u(Qe,e),u(xe,e),u(He,e),u(_,e),u(qe,e),u(Fe,e),u(Ye,e),u(Se,e),u(Pe,e),u(Oe,e),u(tt,e),u(st,e),u(ot,e)}}}const ms='{"title":"LoRA","local":"lora","sections":[{"title":"Initialization","local":"initialization","sections":[{"title":"PiSSA","local":"pissa","sections":[],"depth":3},{"title":"OLoRA","local":"olora","sections":[],"depth":3},{"title":"LoftQ","local":"loftq","sections":[{"title":"Standard approach","local":"standard-approach","sections":[],"depth":4},{"title":"A more convenient way","local":"a-more-convenient-way","sections":[],"depth":4}],"depth":3},{"title":"Rank-stabilized LoRA","local":"rank-stabilized-lora","sections":[],"depth":3},{"title":"Weight-Decomposed Low-Rank Adaptation (DoRA)","local":"weight-decomposed-low-rank-adaptation-dora","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":4}],"depth":3},{"title":"QLoRA-style training","local":"qlora-style-training","sections":[],"depth":3},{"title":"Memory efficient Layer Replication with LoRA","local":"memory-efficient-layer-replication-with-lora","sections":[],"depth":3}],"depth":2},{"title":"Optimizers","local":"optimizers","sections":[{"title":"LoRA+ optimized LoRA","local":"lora-optimized-lora","sections":[],"depth":3}],"depth":2},{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Load adapters","local":"load-adapters","sections":[],"depth":2},{"title":"Inference with different LoRA adapters in the same batch","local":"inference-with-different-lora-adapters-in-the-same-batch","sections":[{"title":"Caveats","local":"caveats","sections":[],"depth":3}],"depth":2}],"depth":1}';function fs(rt){return as(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ys extends ls{constructor(c){super(),ss(this,c,fs,ds,ts,{})}}export{ys as component};
