import{s as ue,f as he,n as fe,o as ge}from"../chunks/scheduler.7bc62968.js";import{S as be,i as ye,g as r,s as i,r as J,A as we,h as o,f as a,c as s,j as de,u as x,x as c,k,y as Me,a as n,v as C,d as $,t as L,w as j}from"../chunks/index.66556066.js";import{C as ve}from"../chunks/CodeBlock.a759539a.js";import{H as P}from"../chunks/Heading.3f0870db.js";function Te(te){let p,Z,H,F,m,E,d,G,u,ae='After the release of CLIP, the AI community recognized the immense potential of larger datasets and contrastive learning in deep learning. One significant development in this area is <a href="https://arxiv.org/abs/2201.12086" rel="nofollow">BLIP (Bootstrapping Language-Image Pre-training)</a>, which extends the capabilities of multimodal models to include text generation.',R,h,S,f,ne='As multimodal models require large datasets, they often have to be scraped from the internet using image and alternative-text (alt-text) pairs. However, the alt-texts often do not accurately describe the visual content of the images, making them a noisy signal that is suboptimal for learning vision-language alignment. Hence, the BLIP paper introduced a caption and filtering mechanism (CapFilt). This is made up of a deep learning model which filters out noisy pairs and another model which creates captions for images. Both of these models are first fine-tuned using a human annotated dataset. They found that cleaning the dataset using CapFit produced superior performance to just using the web dataset. Further details on this process can be found in the <a href="https://arxiv.org/abs/2201.12086" rel="nofollow">BLIP paper</a>.',X,g,N,b,ie="The BLIP architecture combines a vision encoder and a Multimodal Mixture of Encoder-Decoder (MED), enabling versatile processing of both visual and textual data. Its structure is shown in the figure below which features (blocks with the same color share parameters):",q,y,se="<li><strong>Vision Transformer (ViT):</strong> This is a plain vision transformer featuring self-attention, feed-forward blocks, and a [CLS] token for embedding representation.</li> <li><strong>Unimodal Text Encoder:</strong> Resembling BERT’s architecture, it uses a [CLS] token for embedding and employs contrastive loss like CLIP, for aligning image and text representations.</li> <li><strong>Image-Grounded Text Encoder:</strong> This substitutes the [CLS] token with an [Encode] token. Cross-attention layers enable the integration of image and text embeddings, creating a multimodal representation. It employs a linear layer to assess the congruence of image-text pairs.</li> <li><strong>Image-Grounded Text Decoder:</strong> Replacing the bidirectional self-attention with causal self-attention, this decoder is trained via cross-entropy loss in an autoregressive manner for tasks like caption generation or answering visual questions.</li>",Q,w,le="BLIP’s architecture integrates a vision encoder with a multimodal mixture of encoder-decoder components, enabling advanced text and image processing. This design allows it to adeptly handle diverse tasks, from aligning image-text pairs to generating captions and answering visual questions.",W,M,V,v,re='Following BLIP’s success, it’s creator Salesforce introduced BLIP-2, an enhanced iteration. BLIP-2’s advancements and capabilities are detailed in the <a href="https://arxiv.org/abs/2301.12597" rel="nofollow">BLIP-2 paper</a> and the <a href="https://huggingface.co/docs/transformers/model_doc/blip-2" rel="nofollow">Hugging Face documentation</a>. Here, we utilize BLIP-2 for visual questioning answering.',Y,T,A,I,oe="This code snippet illustrates the application of BLIP-2 for visual question answering. Experiment with more complex queries or explore this functionality further using the provided Gradio app:",z,l,pe="",ce,D,U,K,B,me='BLIP marks a significant milestone in multimodal text generation, leveraging CLIP’s strengths to create a robust model. It underscores the importance of dataset quality over quantity, contributing to the advancement of multimodal learning. For more details, refer to the <a href="https://arxiv.org/abs/2201.12086" rel="nofollow">BLIP paper</a>, <a href="https://arxiv.org/abs/2301.12597" rel="nofollow">BLIP-2 paper</a>, and the Hugging Face documentation for <a href="https://huggingface.co/docs/transformers/model_doc/blip" rel="nofollow">BLIP</a> and <a href="https://huggingface.co/docs/transformers/model_doc/blip-2" rel="nofollow">BLIP-2</a>.',O,_,ee;return m=new P({props:{title:"Multimodal Text Generation (BLIP)",local:"multimodal-text-generation-blip",headingTag:"h1"}}),d=new P({props:{title:"Introduction",local:"introduction",headingTag:"h2"}}),h=new P({props:{title:"CapFilt: Caption and Filtering",local:"capfilt-caption-and-filtering",headingTag:"h2"}}),g=new P({props:{title:"BLIP Architecture and Training",local:"blip-architecture-and-training",headingTag:"h2"}}),M=new P({props:{title:"Example Use Case: BLIP-2",local:"example-use-case-blip-2",headingTag:"h2"}}),T=new ve({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQmxpcDJQcm9jZXNzb3IlMkMlMjBCbGlwMkZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGV2aWNlJTIwJTNEJTIwJTIyY3VkYSUyMiUyMGlmJTIwdG9yY2guY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjIlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBCbGlwMlByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyU2FsZXNmb3JjZSUyRmJsaXAyLW9wdC0yLjdiJTIyKSUwQW1vZGVsJTIwJTNEJTIwQmxpcDJGb3JDb25kaXRpb25hbEdlbmVyYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMlNhbGVzZm9yY2UlMkZibGlwMi1vcHQtMi43YiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFtb2RlbC50byhkZXZpY2UpJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMlF1ZXN0aW9uJTNBJTIwSG93JTIwbWFueSUyMHJlbW90ZXMlMjBhcmUlMjB0aGVyZSUzRiUyMEFuc3dlciUzQSUyMiUwQWlucHV0cyUyMCUzRCUyMHByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHRleHQlM0Rwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS50byglMEElMjAlMjAlMjAlMjBkZXZpY2UlMkMlMjB0b3JjaC5mbG9hdDE2JTBBKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyklMEF0ZXh0JTIwJTNEJTIwcHJvY2Vzc29yLnRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KHRleHQp",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Blip2Processor, Blip2ForConditionalGeneration
<span class="hljs-keyword">import</span> torch

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>

processor = Blip2Processor.from_pretrained(<span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>)
model = Blip2ForConditionalGeneration.from_pretrained(
    <span class="hljs-string">&quot;Salesforce/blip2-opt-2.7b&quot;</span>, torch_dtype=torch.float16
)
model.to(device)
url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

prompt = <span class="hljs-string">&quot;Question: How many remotes are there? Answer:&quot;</span>
inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(
    device, torch.float16
)
outputs = model.generate(**inputs)
text = processor.tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(text)`,wrap:!1}}),U=new P({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),{c(){p=r("meta"),Z=i(),H=r("p"),F=i(),J(m.$$.fragment),E=i(),J(d.$$.fragment),G=i(),u=r("p"),u.innerHTML=ae,R=i(),J(h.$$.fragment),S=i(),f=r("p"),f.innerHTML=ne,X=i(),J(g.$$.fragment),N=i(),b=r("p"),b.textContent=ie,q=i(),y=r("ul"),y.innerHTML=se,Q=i(),w=r("p"),w.textContent=le,W=i(),J(M.$$.fragment),V=i(),v=r("p"),v.innerHTML=re,Y=i(),J(T.$$.fragment),A=i(),I=r("p"),I.textContent=oe,z=i(),l=r("iframe"),l.innerHTML=pe,D=i(),J(U.$$.fragment),K=i(),B=r("p"),B.innerHTML=me,O=i(),_=r("p"),this.h()},l(e){const t=we("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(a),Z=s(e),H=o(e,"P",{}),de(H).forEach(a),F=s(e),x(m.$$.fragment,e),E=s(e),x(d.$$.fragment,e),G=s(e),u=o(e,"P",{"data-svelte-h":!0}),c(u)!=="svelte-a3poqr"&&(u.innerHTML=ae),R=s(e),x(h.$$.fragment,e),S=s(e),f=o(e,"P",{"data-svelte-h":!0}),c(f)!=="svelte-14g5det"&&(f.innerHTML=ne),X=s(e),x(g.$$.fragment,e),N=s(e),b=o(e,"P",{"data-svelte-h":!0}),c(b)!=="svelte-t7bumc"&&(b.textContent=ie),q=s(e),y=o(e,"UL",{"data-svelte-h":!0}),c(y)!=="svelte-1c6ul4a"&&(y.innerHTML=se),Q=s(e),w=o(e,"P",{"data-svelte-h":!0}),c(w)!=="svelte-apgebe"&&(w.textContent=le),W=s(e),x(M.$$.fragment,e),V=s(e),v=o(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1bs9swu"&&(v.innerHTML=re),Y=s(e),x(T.$$.fragment,e),A=s(e),I=o(e,"P",{"data-svelte-h":!0}),c(I)!=="svelte-1fgep0j"&&(I.textContent=oe),z=s(e),l=o(e,"IFRAME",{src:!0,frameborder:!0,width:!0,height:!0,"data-svelte-h":!0}),c(l)!=="svelte-1u2nnh6"&&(l.innerHTML=pe),D=s(e),x(U.$$.fragment,e),K=s(e),B=o(e,"P",{"data-svelte-h":!0}),c(B)!=="svelte-147gjbf"&&(B.innerHTML=me),O=s(e),_=o(e,"P",{}),de(_).forEach(a),this.h()},h(){k(p,"name","hf:doc:metadata"),k(p,"content",Ie),he(l.src,ce="https://hysts-BLIP2-with-transformers.hf.space")||k(l,"src",ce),k(l,"frameborder","0"),k(l,"width","850"),k(l,"height","450")},m(e,t){Me(document.head,p),n(e,Z,t),n(e,H,t),n(e,F,t),C(m,e,t),n(e,E,t),C(d,e,t),n(e,G,t),n(e,u,t),n(e,R,t),C(h,e,t),n(e,S,t),n(e,f,t),n(e,X,t),C(g,e,t),n(e,N,t),n(e,b,t),n(e,q,t),n(e,y,t),n(e,Q,t),n(e,w,t),n(e,W,t),C(M,e,t),n(e,V,t),n(e,v,t),n(e,Y,t),C(T,e,t),n(e,A,t),n(e,I,t),n(e,z,t),n(e,l,t),n(e,D,t),C(U,e,t),n(e,K,t),n(e,B,t),n(e,O,t),n(e,_,t),ee=!0},p:fe,i(e){ee||($(m.$$.fragment,e),$(d.$$.fragment,e),$(h.$$.fragment,e),$(g.$$.fragment,e),$(M.$$.fragment,e),$(T.$$.fragment,e),$(U.$$.fragment,e),ee=!0)},o(e){L(m.$$.fragment,e),L(d.$$.fragment,e),L(h.$$.fragment,e),L(g.$$.fragment,e),L(M.$$.fragment,e),L(T.$$.fragment,e),L(U.$$.fragment,e),ee=!1},d(e){e&&(a(Z),a(H),a(F),a(E),a(G),a(u),a(R),a(S),a(f),a(X),a(N),a(b),a(q),a(y),a(Q),a(w),a(W),a(V),a(v),a(Y),a(A),a(I),a(z),a(l),a(D),a(K),a(B),a(O),a(_)),a(p),j(m,e),j(d,e),j(h,e),j(g,e),j(M,e),j(T,e),j(U,e)}}}const Ie='{"title":"Multimodal Text Generation (BLIP)","local":"multimodal-text-generation-blip","sections":[{"title":"Introduction","local":"introduction","sections":[],"depth":2},{"title":"CapFilt: Caption and Filtering","local":"capfilt-caption-and-filtering","sections":[],"depth":2},{"title":"BLIP Architecture and Training","local":"blip-architecture-and-training","sections":[],"depth":2},{"title":"Example Use Case: BLIP-2","local":"example-use-case-blip-2","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function Ue(te){return ge(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $e extends be{constructor(p){super(),ye(this,p,Ue,Te,ue,{})}}export{$e as component};
