import{s as yt,o as Tt,n as Mt}from"../chunks/scheduler.d627b047.js";import{S as gt,i as wt,g as o,s as n,r as m,A as bt,h as r,f as a,c as s,j as ut,u as c,x as p,k as Ee,y as Jt,a as l,v as d,d as u,t as h,w as M}from"../chunks/index.d48c4817.js";import{T as ht}from"../chunks/Tip.9bd3babf.js";import{C as T}from"../chunks/CodeBlock.5da89496.js";import{H as se}from"../chunks/Heading.47e562a9.js";function _t(le){let i,y='See the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> reference for more details about other parameters you can adjust, such as the modules to target or the bias type.';return{c(){i=o("p"),i.innerHTML=y},l(f){i=r(f,"P",{"data-svelte-h":!0}),p(i)!=="svelte-1rt5mvj"&&(i.innerHTML=y)},m(f,g){l(f,i,g)},p:Mt,d(f){f&&a(i)}}}function Ut(le){let i,y='Take a look at the <a href="package_reference/auto_class">AutoPeftModel</a> API reference for a complete list of available <code>AutoPeftModel</code> classes.';return{c(){i=o("p"),i.innerHTML=y},l(f){i=r(f,"P",{"data-svelte-h":!0}),p(i)!=="svelte-bec5ju"&&(i.innerHTML=y)},m(f,g){l(f,i,g)},p:Mt,d(f){f&&a(i)}}}function $t(le){let i,y,f,g,_,oe,U,Se="PEFT offers parameter-efficient methods for finetuning large pretrained models. The traditional paradigm is to finetune all of a model’s parameters for each downstream task, but this is becoming exceedingly costly and impractical because of the enormous number of parameters in models today. Instead, it is more efficient to train a smaller number of prompt parameters or use a reparametrization method like low-rank adaptation (LoRA) to reduce the number of trainable parameters.",re,$,ze="This quicktour will show you PEFT’s main features and how you can train or run inference on large models that would typically be inaccessible on consumer devices.",ie,k,pe,v,Ye='Each PEFT method is defined by a <a href="/docs/peft/main/en/package_reference/config#peft.PeftConfig">PeftConfig</a> class that stores all the important parameters for building a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. For example, to train with LoRA, load and create a <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> class and specify the following parameters:',fe,Z,Ne="<li><code>task_type</code>: the task to train for (sequence-to-sequence language modeling in this case)</li> <li><code>inference_mode</code>: whether you’re using the model for inference or not</li> <li><code>r</code>: the dimension of the low-rank matrices</li> <li><code>lora_alpha</code>: the scaling factor for the low-rank matrices</li> <li><code>lora_dropout</code>: the dropout probability of the LoRA layers</li>",me,j,ce,w,de,C,qe='Once the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> is setup, create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> with the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function. It takes a base model - which you can load from the Transformers library - and the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraConfig">LoraConfig</a> containing the parameters for how to configure a model for training with LoRA.',ue,B,Ae="Load the base model you want to finetune.",he,G,Me,W,De='Wrap the base model and <code>peft_config</code> with the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> function to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a>. To get a sense of the number of trainable parameters in your model, use the <code>print_trainable_parameters</code> method.',ye,I,Te,R,Ke='Out of <a href="https://huggingface.co/bigscience/mt0-large" rel="nofollow">bigscience/mt0-large’s</a> 1.2B parameters, you’re only training 0.19% of them!',ge,H,Oe='That is it 🎉! Now you can train the model with the Transformers <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a>, Accelerate, or any custom PyTorch training loop.',we,F,et='For example, to train with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a> class, setup a <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">TrainingArguments</a> class with some training hyperparameters.',be,V,Je,Q,tt='Pass the model, training arguments, dataset, tokenizer, and any other necessary component to the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer" rel="nofollow">Trainer</a>, and call <a href="https://huggingface.co/docs/transformers/main/en/main_classes/trainer#transformers.Trainer.train" rel="nofollow">train</a> to start training.',_e,L,Ue,X,$e,x,at='After your model is finished training, you can save your model to a directory using the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.save_pretrained" rel="nofollow">save_pretrained</a> function.',ke,P,ve,E,lt='You can also save your model to the Hub (make sure you’re logged in to your Hugging Face account first) with the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.push_to_hub" rel="nofollow">push_to_hub</a> function.',Ze,S,je,z,nt='Both methods only save the extra PEFT weights that were trained, meaning it is super efficient to store, transfer, and load. For example, this <a href="https://huggingface.co/ybelkada/opt-350m-lora" rel="nofollow">facebook/opt-350m</a> model trained with LoRA only contains two files: <code>adapter_config.json</code> and <code>adapter_model.safetensors</code>. The <code>adapter_model.safetensors</code> file is just 6.3MB!',Ce,b,st='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/PEFT-hub-screenshot.png"/> <figcaption class="text-center">The adapter weights for a opt-350m model stored on the Hub are only ~6MB compared to the full size of the model weights, which can be ~700MB.</figcaption>',Be,Y,Ge,J,We,N,ot='Easily load any PEFT-trained model for inference with the <a href="/docs/peft/main/en/package_reference/auto_class#peft.AutoPeftModel">AutoPeftModel</a> class and the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained" rel="nofollow">from_pretrained</a> method:',Ie,q,Re,A,rt='For other tasks that aren’t explicitly supported with an <code>AutoPeftModelFor</code> class - such as automatic speech recognition - you can still use the base <a href="/docs/peft/main/en/package_reference/auto_class#peft.AutoPeftModel">AutoPeftModel</a> class to load a model for the task.',He,D,Fe,K,Ve,O,it="Now that you’ve seen how to train a model with one of the PEFT methods, we encourage you to try out some of the other methods like prompt tuning. The steps are very similar to the ones shown in the quicktour:",Qe,ee,pt='<li>prepare a <a href="/docs/peft/main/en/package_reference/config#peft.PeftConfig">PeftConfig</a> for a PEFT method</li> <li>use the <a href="/docs/peft/main/en/package_reference/peft_model#peft.get_peft_model">get_peft_model()</a> method to create a <a href="/docs/peft/main/en/package_reference/peft_model#peft.PeftModel">PeftModel</a> from the configuration and base model</li>',Le,te,ft='Then you can train it however you like! To load a PEFT model for inference, you can use the <a href="/docs/peft/main/en/package_reference/auto_class#peft.AutoPeftModel">AutoPeftModel</a> class.',Xe,ae,mt="Feel free to also take a look at the task guides if you’re interested in training a model with another PEFT method for a specific task such as semantic segmentation, multilingual automatic speech recognition, DreamBooth, token classification, and more.",xe,ne,Pe;return _=new se({props:{title:"Quicktour",local:"quicktour",headingTag:"h1"}}),k=new se({props:{title:"Train",local:"train",headingTag:"h2"}}),j=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb3JhQ29uZmlnJTJDJTIwVGFza1R5cGUlMEElMEFwZWZ0X2NvbmZpZyUyMCUzRCUyMExvcmFDb25maWcodGFza190eXBlJTNEVGFza1R5cGUuU0VRXzJfU0VRX0xNJTJDJTIwaW5mZXJlbmNlX21vZGUlM0RGYWxzZSUyQyUyMHIlM0Q4JTJDJTIwbG9yYV9hbHBoYSUzRDMyJTJDJTIwbG9yYV9kcm9wb3V0JTNEMC4xKQ==",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoraConfig, TaskType

peft_config = LoraConfig(task_type=TaskType.SEQ_2_SEQ_LM, inference_mode=<span class="hljs-literal">False</span>, r=<span class="hljs-number">8</span>, lora_alpha=<span class="hljs-number">32</span>, lora_dropout=<span class="hljs-number">0.1</span>)`,wrap:!1}}),w=new ht({props:{$$slots:{default:[_t]},$$scope:{ctx:le}}}),G=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcTJTZXFMTSUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMjJiaWdzY2llbmNlJTJGbXQwLWxhcmdlJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSeq2SeqLM

model = AutoModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;bigscience/mt0-large&quot;</span>)`,wrap:!1}}),I=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwZ2V0X3BlZnRfbW9kZWwobW9kZWwlMkMlMjBwZWZ0X2NvbmZpZyklMEFtb2RlbC5wcmludF90cmFpbmFibGVfcGFyYW1ldGVycygpJTBBJTIyb3V0cHV0JTNBJTIwdHJhaW5hYmxlJTIwcGFyYW1zJTNBJTIwMjM1OTI5NiUyMCU3QyU3QyUyMGFsbCUyMHBhcmFtcyUzQSUyMDEyMzE5NDA2MDglMjAlN0MlN0MlMjB0cmFpbmFibGUlMjUlM0ElMjAwLjE5MTUxMDUzMTAwMTE4MjgyJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> get_peft_model

model = get_peft_model(model, peft_config)
model.print_trainable_parameters()
<span class="hljs-string">&quot;output: trainable params: 2359296 || all params: 1231940608 || trainable%: 0.19151053100118282&quot;</span>`,wrap:!1}}),V=new T({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMG91dHB1dF9kaXIlM0QlMjJ5b3VyLW5hbWUlMkZiaWdzY2llbmNlJTJGbXQwLWxhcmdlLWxvcmElMjIlMkMlMEElMjAlMjAlMjAlMjBsZWFybmluZ19yYXRlJTNEMWUtMyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUzRDMyJTJDJTBBJTIwJTIwJTIwJTIwcGVyX2RldmljZV9ldmFsX2JhdGNoX3NpemUlM0QzMiUyQyUwQSUyMCUyMCUyMCUyMG51bV90cmFpbl9lcG9jaHMlM0QyJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEMC4wMSUyQyUwQSUyMCUyMCUyMCUyMGV2YWx1YXRpb25fc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNhdmVfc3RyYXRlZ3klM0QlMjJlcG9jaCUyMiUyQyUwQSUyMCUyMCUyMCUyMGxvYWRfYmVzdF9tb2RlbF9hdF9lbmQlM0RUcnVlJTJDJTBBKQ==",highlighted:`training_args = TrainingArguments(
    output_dir=<span class="hljs-string">&quot;your-name/bigscience/mt0-large-lora&quot;</span>,
    learning_rate=<span class="hljs-number">1e-3</span>,
    per_device_train_batch_size=<span class="hljs-number">32</span>,
    per_device_eval_batch_size=<span class="hljs-number">32</span>,
    num_train_epochs=<span class="hljs-number">2</span>,
    weight_decay=<span class="hljs-number">0.01</span>,
    evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    save_strategy=<span class="hljs-string">&quot;epoch&quot;</span>,
    load_best_model_at_end=<span class="hljs-literal">True</span>,
)`,wrap:!1}}),L=new T({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMHRva2VuaXplciUzRHRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMGRhdGFfY29sbGF0b3IlM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwY29tcHV0ZV9tZXRyaWNzJTNEY29tcHV0ZV9tZXRyaWNzJTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`trainer = Trainer(
    model=model,
    args=training_args,
    train_dataset=tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>],
    eval_dataset=tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>],
    tokenizer=tokenizer,
    data_collator=data_collator,
    compute_metrics=compute_metrics,
)

trainer.train()`,wrap:!1}}),X=new se({props:{title:"Save model",local:"save-model",headingTag:"h3"}}),P=new T({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMm91dHB1dF9kaXIlMjIp",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;output_dir&quot;</span>)',wrap:!1}}),S=new T({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMnlvdXItbmFtZSUyRmJpZ3NjaWVuY2UlMkZtdDAtbGFyZ2UtbG9yYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()
model.push_to_hub(<span class="hljs-string">&quot;your-name/bigscience/mt0-large-lora&quot;</span>)`,wrap:!1}}),Y=new se({props:{title:"Inference",local:"inference",headingTag:"h2"}}),J=new ht({props:{$$slots:{default:[Ut]},$$scope:{ctx:le}}}),q=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsRm9yQ2F1c2FsTE0lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvUGVmdE1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnliZWxrYWRhJTJGb3B0LTM1MG0tbG9yYSUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmYWNlYm9vayUyRm9wdC0zNTBtJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwbW9kZWwudG8oJTIyY3VkYSUyMiklMEFtb2RlbC5ldmFsKCklMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyUHJlaGVhdCUyMHRoZSUyMG92ZW4lMjB0byUyMDM1MCUyMGRlZ3JlZXMlMjBhbmQlMjBwbGFjZSUyMHRoZSUyMGNvb2tpZSUyMGRvdWdoJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRfaWRzJTNEaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVELnRvKCUyMmN1ZGElMjIpJTJDJTIwbWF4X25ld190b2tlbnMlM0Q1MCklMEFwcmludCh0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKG91dHB1dHMuZGV0YWNoKCkuY3B1KCkubnVtcHkoKSUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSU1QjAlNUQpJTBBJTBBJTIyUHJlaGVhdCUyMHRoZSUyMG92ZW4lMjB0byUyMDM1MCUyMGRlZ3JlZXMlMjBhbmQlMjBwbGFjZSUyMHRoZSUyMGNvb2tpZSUyMGRvdWdoJTIwaW4lMjB0aGUlMjBjZW50ZXIlMjBvZiUyMHRoZSUyMG92ZW4uJTIwSW4lMjBhJTIwbGFyZ2UlMjBib3dsJTJDJTIwY29tYmluZSUyMHRoZSUyMGZsb3VyJTJDJTIwYmFraW5nJTIwcG93ZGVyJTJDJTIwYmFraW5nJTIwc29kYSUyQyUyMHNhbHQlMkMlMjBhbmQlMjBjaW5uYW1vbi4lMjBJbiUyMGElMjBzZXBhcmF0ZSUyMGJvd2wlMkMlMjBjb21iaW5lJTIwdGhlJTIwZWdnJTIweW9sa3MlMkMlMjBzdWdhciUyQyUyMGFuZCUyMHZhbmlsbGEuJTIy",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModelForCausalLM
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">import</span> torch

model = AutoPeftModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;ybelkada/opt-350m-lora&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;facebook/opt-350m&quot;</span>)

model = model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
model.<span class="hljs-built_in">eval</span>()
inputs = tokenizer(<span class="hljs-string">&quot;Preheat the oven to 350 degrees and place the cookie dough&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

outputs = model.generate(input_ids=inputs[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>), max_new_tokens=<span class="hljs-number">50</span>)
<span class="hljs-built_in">print</span>(tokenizer.batch_decode(outputs.detach().cpu().numpy(), skip_special_tokens=<span class="hljs-literal">True</span>)[<span class="hljs-number">0</span>])

<span class="hljs-string">&quot;Preheat the oven to 350 degrees and place the cookie dough in the center of the oven. In a large bowl, combine the flour, baking powder, baking soda, salt, and cinnamon. In a separate bowl, combine the egg yolks, sugar, and vanilla.&quot;</span>`,wrap:!1}}),D=new T({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBBdXRvUGVmdE1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvUGVmdE1vZGVsLmZyb21fcHJldHJhaW5lZCglMjJzbWFuZ3J1bCUyRm9wZW5haS13aGlzcGVyLWxhcmdlLXYyLUxPUkEtY29sYWIlMjIp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> AutoPeftModel

model = AutoPeftModel.from_pretrained(<span class="hljs-string">&quot;smangrul/openai-whisper-large-v2-LORA-colab&quot;</span>)`,wrap:!1}}),K=new se({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){i=o("meta"),y=n(),f=o("p"),g=n(),m(_.$$.fragment),oe=n(),U=o("p"),U.textContent=Se,re=n(),$=o("p"),$.textContent=ze,ie=n(),m(k.$$.fragment),pe=n(),v=o("p"),v.innerHTML=Ye,fe=n(),Z=o("ul"),Z.innerHTML=Ne,me=n(),m(j.$$.fragment),ce=n(),m(w.$$.fragment),de=n(),C=o("p"),C.innerHTML=qe,ue=n(),B=o("p"),B.textContent=Ae,he=n(),m(G.$$.fragment),Me=n(),W=o("p"),W.innerHTML=De,ye=n(),m(I.$$.fragment),Te=n(),R=o("p"),R.innerHTML=Ke,ge=n(),H=o("p"),H.innerHTML=Oe,we=n(),F=o("p"),F.innerHTML=et,be=n(),m(V.$$.fragment),Je=n(),Q=o("p"),Q.innerHTML=tt,_e=n(),m(L.$$.fragment),Ue=n(),m(X.$$.fragment),$e=n(),x=o("p"),x.innerHTML=at,ke=n(),m(P.$$.fragment),ve=n(),E=o("p"),E.innerHTML=lt,Ze=n(),m(S.$$.fragment),je=n(),z=o("p"),z.innerHTML=nt,Ce=n(),b=o("div"),b.innerHTML=st,Be=n(),m(Y.$$.fragment),Ge=n(),m(J.$$.fragment),We=n(),N=o("p"),N.innerHTML=ot,Ie=n(),m(q.$$.fragment),Re=n(),A=o("p"),A.innerHTML=rt,He=n(),m(D.$$.fragment),Fe=n(),m(K.$$.fragment),Ve=n(),O=o("p"),O.textContent=it,Qe=n(),ee=o("ol"),ee.innerHTML=pt,Le=n(),te=o("p"),te.innerHTML=ft,Xe=n(),ae=o("p"),ae.textContent=mt,xe=n(),ne=o("p"),this.h()},l(e){const t=bt("svelte-u9bgzb",document.head);i=r(t,"META",{name:!0,content:!0}),t.forEach(a),y=s(e),f=r(e,"P",{}),ut(f).forEach(a),g=s(e),c(_.$$.fragment,e),oe=s(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-hgsptz"&&(U.textContent=Se),re=s(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-1t6b3ei"&&($.textContent=ze),ie=s(e),c(k.$$.fragment,e),pe=s(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1a2sgkx"&&(v.innerHTML=Ye),fe=s(e),Z=r(e,"UL",{"data-svelte-h":!0}),p(Z)!=="svelte-kw75sh"&&(Z.innerHTML=Ne),me=s(e),c(j.$$.fragment,e),ce=s(e),c(w.$$.fragment,e),de=s(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-apn61w"&&(C.innerHTML=qe),ue=s(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-toa5ud"&&(B.textContent=Ae),he=s(e),c(G.$$.fragment,e),Me=s(e),W=r(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1kgb05"&&(W.innerHTML=De),ye=s(e),c(I.$$.fragment,e),Te=s(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-y8cetx"&&(R.innerHTML=Ke),ge=s(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-14m052t"&&(H.innerHTML=Oe),we=s(e),F=r(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1kytgnd"&&(F.innerHTML=et),be=s(e),c(V.$$.fragment,e),Je=s(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-15wg15i"&&(Q.innerHTML=tt),_e=s(e),c(L.$$.fragment,e),Ue=s(e),c(X.$$.fragment,e),$e=s(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-mp6fzk"&&(x.innerHTML=at),ke=s(e),c(P.$$.fragment,e),ve=s(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-xdfp0a"&&(E.innerHTML=lt),Ze=s(e),c(S.$$.fragment,e),je=s(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-lvoeik"&&(z.innerHTML=nt),Ce=s(e),b=r(e,"DIV",{class:!0,"data-svelte-h":!0}),p(b)!=="svelte-1nqpszv"&&(b.innerHTML=st),Be=s(e),c(Y.$$.fragment,e),Ge=s(e),c(J.$$.fragment,e),We=s(e),N=r(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-w0ndvy"&&(N.innerHTML=ot),Ie=s(e),c(q.$$.fragment,e),Re=s(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1sps5go"&&(A.innerHTML=rt),He=s(e),c(D.$$.fragment,e),Fe=s(e),c(K.$$.fragment,e),Ve=s(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-zexwzv"&&(O.textContent=it),Qe=s(e),ee=r(e,"OL",{"data-svelte-h":!0}),p(ee)!=="svelte-1t4phcf"&&(ee.innerHTML=pt),Le=s(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-1tjn9wo"&&(te.innerHTML=ft),Xe=s(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-eanbvx"&&(ae.textContent=mt),xe=s(e),ne=r(e,"P",{}),ut(ne).forEach(a),this.h()},h(){Ee(i,"name","hf:doc:metadata"),Ee(i,"content",kt),Ee(b,"class","flex flex-col justify-center")},m(e,t){Jt(document.head,i),l(e,y,t),l(e,f,t),l(e,g,t),d(_,e,t),l(e,oe,t),l(e,U,t),l(e,re,t),l(e,$,t),l(e,ie,t),d(k,e,t),l(e,pe,t),l(e,v,t),l(e,fe,t),l(e,Z,t),l(e,me,t),d(j,e,t),l(e,ce,t),d(w,e,t),l(e,de,t),l(e,C,t),l(e,ue,t),l(e,B,t),l(e,he,t),d(G,e,t),l(e,Me,t),l(e,W,t),l(e,ye,t),d(I,e,t),l(e,Te,t),l(e,R,t),l(e,ge,t),l(e,H,t),l(e,we,t),l(e,F,t),l(e,be,t),d(V,e,t),l(e,Je,t),l(e,Q,t),l(e,_e,t),d(L,e,t),l(e,Ue,t),d(X,e,t),l(e,$e,t),l(e,x,t),l(e,ke,t),d(P,e,t),l(e,ve,t),l(e,E,t),l(e,Ze,t),d(S,e,t),l(e,je,t),l(e,z,t),l(e,Ce,t),l(e,b,t),l(e,Be,t),d(Y,e,t),l(e,Ge,t),d(J,e,t),l(e,We,t),l(e,N,t),l(e,Ie,t),d(q,e,t),l(e,Re,t),l(e,A,t),l(e,He,t),d(D,e,t),l(e,Fe,t),d(K,e,t),l(e,Ve,t),l(e,O,t),l(e,Qe,t),l(e,ee,t),l(e,Le,t),l(e,te,t),l(e,Xe,t),l(e,ae,t),l(e,xe,t),l(e,ne,t),Pe=!0},p(e,[t]){const ct={};t&2&&(ct.$$scope={dirty:t,ctx:e}),w.$set(ct);const dt={};t&2&&(dt.$$scope={dirty:t,ctx:e}),J.$set(dt)},i(e){Pe||(u(_.$$.fragment,e),u(k.$$.fragment,e),u(j.$$.fragment,e),u(w.$$.fragment,e),u(G.$$.fragment,e),u(I.$$.fragment,e),u(V.$$.fragment,e),u(L.$$.fragment,e),u(X.$$.fragment,e),u(P.$$.fragment,e),u(S.$$.fragment,e),u(Y.$$.fragment,e),u(J.$$.fragment,e),u(q.$$.fragment,e),u(D.$$.fragment,e),u(K.$$.fragment,e),Pe=!0)},o(e){h(_.$$.fragment,e),h(k.$$.fragment,e),h(j.$$.fragment,e),h(w.$$.fragment,e),h(G.$$.fragment,e),h(I.$$.fragment,e),h(V.$$.fragment,e),h(L.$$.fragment,e),h(X.$$.fragment,e),h(P.$$.fragment,e),h(S.$$.fragment,e),h(Y.$$.fragment,e),h(J.$$.fragment,e),h(q.$$.fragment,e),h(D.$$.fragment,e),h(K.$$.fragment,e),Pe=!1},d(e){e&&(a(y),a(f),a(g),a(oe),a(U),a(re),a($),a(ie),a(pe),a(v),a(fe),a(Z),a(me),a(ce),a(de),a(C),a(ue),a(B),a(he),a(Me),a(W),a(ye),a(Te),a(R),a(ge),a(H),a(we),a(F),a(be),a(Je),a(Q),a(_e),a(Ue),a($e),a(x),a(ke),a(ve),a(E),a(Ze),a(je),a(z),a(Ce),a(b),a(Be),a(Ge),a(We),a(N),a(Ie),a(Re),a(A),a(He),a(Fe),a(Ve),a(O),a(Qe),a(ee),a(Le),a(te),a(Xe),a(ae),a(xe),a(ne)),a(i),M(_,e),M(k,e),M(j,e),M(w,e),M(G,e),M(I,e),M(V,e),M(L,e),M(X,e),M(P,e),M(S,e),M(Y,e),M(J,e),M(q,e),M(D,e),M(K,e)}}}const kt='{"title":"Quicktour","local":"quicktour","sections":[{"title":"Train","local":"train","sections":[{"title":"Save model","local":"save-model","sections":[],"depth":3}],"depth":2},{"title":"Inference","local":"inference","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function vt(le){return Tt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends gt{constructor(i){super(),wt(this,i,vt,$t,yt,{})}}export{Wt as component};
