import{s as cd,o as od,n as U}from"../chunks/scheduler.69131cc3.js";import{S as pd,i as id,g as d,s as n,r as u,A as dd,h as m,f as o,c,j as G,u as f,x as j,k as x,y as r,a as g,v as b,d as $,t as y,w as M}from"../chunks/index.e1f30d73.js";import{T as Fe}from"../chunks/Tip.22e79575.js";import{D as k}from"../chunks/Docstring.ae1a1e2d.js";import{C as T}from"../chunks/CodeBlock.30cef355.js";import{E as C}from"../chunks/ExampleCodeBlock.e7a3d5fe.js";import{H as V}from"../chunks/Heading.0aab6758.js";function md(_){let a,w="Step three is optional, but considered a best practice.";return{c(){a=d("p"),a.textContent=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-q05n85"&&(a.textContent=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function hd(_){let a,w="Step five is mandatory when using distributed evaluation";return{c(){a=d("p"),a.textContent=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-2wygw4"&&(a.textContent=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function gd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSklMEFkYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKGRhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHNjaGVkdWxlciklMEElMEFmb3IlMjBpbnB1dCUyQyUyMG91dHB1dCUyMGluJTIwZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMHdpdGglMjBhY2NlbGVyYXRvci5hY2N1bXVsYXRlKG1vZGVsKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jKG91dHB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader, model, optimizer, scheduler = accelerator.prepare(dataloader, model, optimizer, scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, output <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> accelerator.accumulate(model):
<span class="hljs-meta">... </span>        outputs = model(<span class="hljs-built_in">input</span>)
<span class="hljs-meta">... </span>        loss = loss_func(outputs)
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function ud(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiklMEF3aXRoJTIwYWNjZWxlcmF0b3IuYXV0b2Nhc3QoKSUzQSUwQSUyMCUyMCUyMCUyMHRyYWluKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.autocast():
<span class="hljs-meta">... </span>    train()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function fd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQWxvc3MlMjAlM0QlMjBsb3NzX2ZuKG91dHB1dHMlMkMlMjBsYWJlbHMpJTBBYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = loss_fn(outputs, labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.backward(loss)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function bd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMyUyMEFzc3VtZSUyMGxhdGVyJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMHNjcmlwdCUwQSUyMyUyMCU2MHNob3VsZF9kb19icmVha3BvaW50JTYwJTIwaXMlMjBhJTIwY3VzdG9tJTIwZnVuY3Rpb24lMjB0byUyMG1vbml0b3IlMjB3aGVuJTIwdG8lMjBicmVhayUyQyUwQSUyMyUyMGUuZy4lMjB3aGVuJTIwdGhlJTIwbG9zcyUyMGlzJTIwTmFOJTBBaWYlMjBzaG91bGRfZG9fYnJlYWtwb2ludChsb3NzKSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnNldF90cmlnZ2VyKCklMEElMjMlMjBBc3N1bWUlMjBsYXRlciUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBzY3JpcHQlMEFpZiUyMGFjY2VsZXJhdG9yLmNoZWNrX3RyaWdnZXIoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume later in the training script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`should_do_breakpoint\` is a custom function to monitor when to break,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># e.g. when the loss is NaN</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> should_do_breakpoint(loss):
<span class="hljs-meta">... </span>    accelerator.set_trigger()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume later in the training script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> accelerator.check_trigger():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function $d(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwLi4uJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwc2NoZWR1bGVyKSUwQWFjY2VsZXJhdG9yLmZyZWVfbWVtb3J5KCklMEFkZWwlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, scheduler = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, scheduler = accelerator.prepare(model, optimizer, scheduler)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.free_memory()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">del</span> model, optimizer, scheduler`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function yd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFkYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKGRhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHNjaGVkdWxlciklMEElMEFmb3IlMjBpbnB1dCUyQyUyMHRhcmdldCUyMGluJTIwZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0JTJDJTIwdGFyZ2V0KSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5zeW5jX2dyYWRpZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmNsaXBfZ3JhZF9ub3JtXyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBtYXhfZ3JhZF9ub3JtKSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci5zdGVwKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader, model, optimizer, scheduler = accelerator.prepare(dataloader, model, optimizer, scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, target <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    optimizer.zero_grad()
<span class="hljs-meta">... </span>    output = model(<span class="hljs-built_in">input</span>)
<span class="hljs-meta">... </span>    loss = loss_func(output, target)
<span class="hljs-meta">... </span>    accelerator.backward(loss)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.sync_gradients:
<span class="hljs-meta">... </span>        accelerator.clip_grad_norm_(model.parameters(), max_grad_norm)
<span class="hljs-meta">... </span>    optimizer.step()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Md(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEFkYXRhbG9hZGVyJTJDJTIwbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKGRhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHNjaGVkdWxlciklMEElMEFmb3IlMjBpbnB1dCUyQyUyMHRhcmdldCUyMGluJTIwZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0JTJDJTIwdGFyZ2V0KSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwaWYlMjBhY2NlbGVyYXRvci5zeW5jX2dyYWRpZW50cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmNsaXBfZ3JhZF92YWx1ZV8obW9kZWwucGFyYW1ldGVycygpJTJDJTIwY2xpcF92YWx1ZSklMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIuc3RlcCgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(gradient_accumulation_steps=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader, model, optimizer, scheduler = accelerator.prepare(dataloader, model, optimizer, scheduler)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, target <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    optimizer.zero_grad()
<span class="hljs-meta">... </span>    output = model(<span class="hljs-built_in">input</span>)
<span class="hljs-meta">... </span>    loss = loss_func(output, target)
<span class="hljs-meta">... </span>    accelerator.backward(loss)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> accelerator.sync_gradients:
<span class="hljs-meta">... </span>        accelerator.clip_grad_value_(model.parameters(), clip_value)
<span class="hljs-meta">... </span>    optimizer.step()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function wd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwLi4uJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwc2NoZWR1bGVyKSUwQWFjY2VsZXJhdG9yLmZyZWVfbWVtb3J5KCklMEFkZWwlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHNjaGVkdWxlcg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, scheduler = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, scheduler = accelerator.prepare(model, optimizer, scheduler)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.free_memory()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">del</span> model, optimizer, scheduler`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function jd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1pbmclMjBmb3VyJTIwcHJvY2Vzc2VzJTBBaW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBcHJvY2Vzc190ZW5zb3IlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCYWNjZWxlcmF0b3IucHJvY2Vzc19pbmRleCU1RCklMEFnYXRoZXJlZF90ZW5zb3IlMjAlM0QlMjBhY2NlbGVyYXRvci5nYXRoZXIocHJvY2Vzc190ZW5zb3IpJTBBZ2F0aGVyZWRfdGVuc29y",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming four processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>process_tensor = torch.tensor([accelerator.process_index])
<span class="hljs-meta">&gt;&gt;&gt; </span>gathered_tensor = accelerator.gather(process_tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>gathered_tensor
tensor([<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>])`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function _d(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBwcm9jZXNzZXMlMkMlMjB3aXRoJTIwYSUyMGJhdGNoJTIwc2l6ZSUyMG9mJTIwNSUyMG9uJTIwYSUyMGRhdGFzZXQlMjB3aXRoJTIwOSUyMHNhbXBsZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEFkYXRhbG9hZGVyJTIwJTNEJTIwdG9yY2gudXRpbHMuZGF0YS5EYXRhTG9hZGVyKHJhbmdlKDkpJTJDJTIwYmF0Y2hfc2l6ZSUzRDUpJTBBZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoZGF0YWxvYWRlciklMEFiYXRjaCUyMCUzRCUyMG5leHQoaXRlcihkYXRhbG9hZGVyKSklMEFnYXRoZXJlZF9pdGVtcyUyMCUzRCUyMGFjY2VsZXJhdG9yLmdhdGhlcl9mb3JfbWV0cmljcyhiYXRjaCklMEFsZW4oZ2F0aGVyZWRfaXRlbXMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two processes, with a batch size of 5 on a dataset with 9 samples</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = torch.utils.data.DataLoader(<span class="hljs-built_in">range</span>(<span class="hljs-number">9</span>), batch_size=<span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader = accelerator.prepare(dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>batch = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span>gathered_items = accelerator.gather_for_metrics(batch)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">len</span>(gathered_items)
<span class="hljs-number">9</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function vd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBbmV0JTIwJTNEJTIwdG9yY2gubm4uTGluZWFyKDIlMkMlMjAyKSUwQW5ldCUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobmV0KSUwQXN0YXRlX2RpY3QlMjAlM0QlMjBhY2NlbGVyYXRvci5nZXRfc3RhdGVfZGljdChuZXQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>net = torch.nn.Linear(<span class="hljs-number">2</span>, <span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>net = accelerator.prepare(net)
<span class="hljs-meta">&gt;&gt;&gt; </span>state_dict = accelerator.get_state_dict(net)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Jd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IobG9nX3dpdGglM0QlMjJ0ZW5zb3Jib2FyZCUyMiklMEFhY2NlbGVyYXRvci5pbml0X3RyYWNrZXJzKCUyMm15X3Byb2plY3QlMjIpJTBBdGVuc29yYm9hcmRfdHJhY2tlciUyMCUzRCUyMGFjY2VsZXJhdG9yLmdldF90cmFja2VyKCUyMnRlbnNvcmJvYXJkJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(log_with=<span class="hljs-string">&quot;tensorboard&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.init_trackers(<span class="hljs-string">&quot;my_project&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensorboard_tracker = accelerator.get_tracker(<span class="hljs-string">&quot;tensorboard&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Td(_){let a,w=`<code>join_uneven_inputs</code> is only supported for Distributed Data Parallel training on multiple GPUs. For any other
configuration, this method will have no effect.`;return{c(){a=d("p"),a.innerHTML=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-rvhzx4"&&(a.innerHTML=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function Ud(_){let a,w="Overidding <code>even_batches</code> will not affect iterable-style data loaders.";return{c(){a=d("p"),a.innerHTML=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1kjj3tv"&&(a.innerHTML=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function xd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZXZlbl9iYXRjaGVzJTNEVHJ1ZSklMEFkZHBfbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBkYXRhbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMGRhdGFsb2FkZXIpJTBBJTBBd2l0aCUyMGFjY2VsZXJhdG9yLmpvaW5fdW5ldmVuX2lucHV0cyglNUJkZHBfbW9kZWwlNUQlMkMlMjBldmVuX2JhdGNoZXMlM0RGYWxzZSklM0ElMEElMjAlMjAlMjAlMjBmb3IlMjBpbnB1dCUyQyUyMG91dHB1dCUyMGluJTIwZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mdW5jKG91dHB1dHMpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator(even_batches=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>ddp_model, optimizer, dataloader = accelerator.prepare(model, optimizer, dataloader)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.join_uneven_inputs([ddp_model], even_batches=<span class="hljs-literal">False</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, output <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>        outputs = model(<span class="hljs-built_in">input</span>)
<span class="hljs-meta">... </span>        loss = loss_func(outputs)
<span class="hljs-meta">... </span>        loss.backward()
<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Gd(_){let a,w=`Should only be used in conjunction with <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">Accelerator.save_state()</a>. If a file is not registered for
checkpointing, it will not be loaded if stored in the directory.`;return{c(){a=d("p"),a.innerHTML=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1w06apw"&&(a.innerHTML=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function kd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwLi4uJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQWFjY2VsZXJhdG9yLmxvYWRfc3RhdGUoJTIybXlfY2hlY2twb2ludCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, lr_scheduler = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, lr_scheduler = accelerator.prepare(model, optimizer, lr_scheduler)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.load_state(<span class="hljs-string">&quot;my_checkpoint&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Cd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQXdpdGglMjBhY2NlbGVyYXRvci5sb2NhbF9tYWluX3Byb2Nlc3NfZmlyc3QoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwZmlyc3QlMjBieSUyMGxvY2FsJTIwcHJvY2VzcyUyMDAlMjB0aGVuJTIwaW4lMjBhJTIwc2VlbWluZ2x5JTBBJTIwJTIwJTIwJTIwJTIzJTIwcmFuZG9tJTIwb3JkZXIlMjBieSUyMHRoZSUyMG90aGVyJTIwcHJvY2Vzc2VzLiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMCU3QmFjY2VsZXJhdG9yLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.local_main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by local process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{accelerator.local_process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Id(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQXdpdGglMjBhY2NlbGVyYXRvci5tYWluX3Byb2Nlc3NfZmlyc3QoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFRoaXMlMjB3aWxsJTIwYmUlMjBwcmludGVkJTIwZmlyc3QlMjBieSUyMHByb2Nlc3MlMjAwJTIwdGhlbiUyMGluJTIwYSUyMHNlZW1pbmdseSUwQSUyMCUyMCUyMCUyMCUyMyUyMHJhbmRvbSUyMG9yZGVyJTIwYnklMjB0aGUlMjBvdGhlciUyMHByb2Nlc3Nlcy4lMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAlN0JhY2NlbGVyYXRvci5wcm9jZXNzX2luZGV4JTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.main_process_first():
<span class="hljs-meta">... </span>    <span class="hljs-comment"># This will be printed first by process 0 then in a seemingly</span>
<span class="hljs-meta">... </span>    <span class="hljs-comment"># random order by the other processes.</span>
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;This will be printed by process <span class="hljs-subst">{accelerator.process_index}</span>&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Zd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWRhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyKSUwQWlucHV0X2ElMjAlM0QlMjBuZXh0KGl0ZXIoZGF0YWxvYWRlcikpJTBBaW5wdXRfYiUyMCUzRCUyMG5leHQoaXRlcihkYXRhbG9hZGVyKSklMEElMEF3aXRoJTIwYWNjZWxlcmF0b3Iubm9fc3luYygpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2EpJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMGxvc3NfZnVuYyhvdXRwdXRzKSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIzJTIwTm8lMjBzeW5jaHJvbml6YXRpb24lMjBhY3Jvc3MlMjBwcm9jZXNzZXMlMkMlMjBvbmx5JTIwYWNjdW11bGF0ZSUyMGdyYWRpZW50cyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dF9iKSUwQWFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIzJTIwU3luY2hyb25pemF0aW9uJTIwYWNyb3NzJTIwYWxsJTIwcHJvY2Vzc2VzJTBBb3B0aW1pemVyLnN0ZXAoKSUwQW9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader, model, optimizer = accelerator.prepare(dataloader, model, optimizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>input_a = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataloader))
<span class="hljs-meta">&gt;&gt;&gt; </span>input_b = <span class="hljs-built_in">next</span>(<span class="hljs-built_in">iter</span>(dataloader))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.no_sync():
<span class="hljs-meta">... </span>    outputs = model(input_a)
<span class="hljs-meta">... </span>    loss = loss_func(outputs)
<span class="hljs-meta">... </span>    accelerator.backward(loss)
<span class="hljs-meta">... </span>    <span class="hljs-comment"># No synchronization across processes, only accumulate gradients</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(input_b)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.backward(loss)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Synchronization across all processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.step()
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.zero_grad()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Bd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBJTBBJTQwYWNjZWxlcmF0b3Iub25fbGFzdF9wcm9jZXNzJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMCU3QmFjY2VsZXJhdG9yLnByb2Nlc3NfaW5kZXglN0QlMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCklMEElMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwMyUyMg==",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_last_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{accelerator.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 3&quot;</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Wd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUwQSU0MGFjY2VsZXJhdG9yLm9uX2xvY2FsX21haW5fcHJvY2VzcyUwQWRlZiUyMHByaW50X3NvbWV0aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAwJTIwb25seSUyMG9uJTIwZWFjaCUyMHNlcnZlci4lMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCklMEElMjMlMjBPbiUyMHNlcnZlciUyMDElM0ElMEElMjJUaGlzJTIwd2lsbCUyMGJlJTIwcHJpbnRlZCUyMGJ5JTIwcHJvY2VzcyUyMDAlMjBvbmx5JTIyJTBBJTIzJTIwT24lMjBzZXJ2ZXIlMjAyJTNBJTBBJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAwJTIwb25seSUyMg==",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_local_main_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only on each server.&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Xd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwMiUyMHNlcnZlcnMlMjB3aXRoJTIwNCUyMHByb2Nlc3NlcyUyMGVhY2guJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUwQSU0MGFjY2VsZXJhdG9yLm9uX2xvY2FsX3Byb2Nlc3MobG9jYWxfcHJvY2Vzc19pbmRleCUzRDIpJTBBZGVmJTIwcHJpbnRfc29tZXRoaW5nKCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyUHJpbnRlZCUyMG9uJTIwcHJvY2VzcyUyMCU3QmFjY2VsZXJhdG9yLmxvY2FsX3Byb2Nlc3NfaW5kZXglN0QlMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCklMEElMjMlMjBPbiUyMHNlcnZlciUyMDElM0ElMEElMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwMiUyMiUwQSUyMyUyME9uJTIwc2VydmVyJTIwMiUzQSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAyJTIy",highlighted:`<span class="hljs-comment"># Assume we have 2 servers with 4 processes each.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_local_process(<span class="hljs-params">local_process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{accelerator.local_process_index}</span>&quot;</span>)


print_something()
<span class="hljs-comment"># On server 1:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>
<span class="hljs-comment"># On server 2:</span>
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Yd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUwQSUwQSU0MGFjY2VsZXJhdG9yLm9uX21haW5fcHJvY2VzcyUwQWRlZiUyMHByaW50X3NvbWV0aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTIyVGhpcyUyMHdpbGwlMjBiZSUyMHByaW50ZWQlMjBieSUyMHByb2Nlc3MlMjAwJTIwb25seS4lMjIpJTBBJTBBJTBBcHJpbnRfc29tZXRoaW5nKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()


<span class="hljs-meta">&gt;&gt;&gt; </span>@accelerator.on_main_process
<span class="hljs-meta">... </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;This will be printed by process 0 only.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>print_something()
<span class="hljs-string">&quot;This will be printed by process 0 only&quot;</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Vd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1lJTIwd2UlMjBoYXZlJTIwNCUyMHByb2Nlc3Nlcy4lMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBJTBBJTBBJTQwYWNjZWxlcmF0b3Iub25fcHJvY2Vzcyhwcm9jZXNzX2luZGV4JTNEMiklMEFkZWYlMjBwcmludF9zb21ldGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJQcmludGVkJTIwb24lMjBwcm9jZXNzJTIwJTdCYWNjZWxlcmF0b3IucHJvY2Vzc19pbmRleCU3RCUyMiklMEElMEElMEFwcmludF9zb21ldGhpbmcoKSUwQSUyMlByaW50ZWQlMjBvbiUyMHByb2Nlc3MlMjAyJTIy",highlighted:`<span class="hljs-comment"># Assume we have 4 processes.</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()


<span class="hljs-meta">@accelerator.on_process(<span class="hljs-params">process_index=<span class="hljs-number">2</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">print_something</span>():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Printed on process <span class="hljs-subst">{accelerator.process_index}</span>&quot;</span>)


print_something()
<span class="hljs-string">&quot;Printed on process 2&quot;</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Ad(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBwcm9jZXNzZXMlMkMlMjB3aXRoJTIwdGhlJTIwZmlyc3QlMjBwcm9jZXNzZXMlMjBoYXZpbmclMjBhJTIwdGVuc29yJTIwb2YlMjBzaXplJTIwMSUyMGFuZCUyMHRoZSUyMHNlY29uZCUyMG9mJTIwc2l6ZSUyMDIlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEFwcm9jZXNzX3RlbnNvciUyMCUzRCUyMHRvcmNoLmFyYW5nZShhY2NlbGVyYXRvci5wcm9jZXNzX2luZGV4JTIwJTJCJTIwMSkudG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQXBhZGRlZF90ZW5zb3IlMjAlM0QlMjBhY2NlbGVyYXRvci5wYWRfYWNyb3NzX3Byb2Nlc3Nlcyhwcm9jZXNzX3RlbnNvciklMEFwYWRkZWRfdGVuc29yLnNoYXBl",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two processes, with the first processes having a tensor of size 1 and the second of size 2</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>process_tensor = torch.arange(accelerator.process_index + <span class="hljs-number">1</span>).to(accelerator.device)
<span class="hljs-meta">&gt;&gt;&gt; </span>padded_tensor = accelerator.pad_across_processes(process_tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>padded_tensor.shape
torch.Size([<span class="hljs-number">2</span>])`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Nd(_){let a,w="You don’t need to prepare a model if you only use it for inference without any kind of mixed precision";return{c(){a=d("p"),a.textContent=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1k839yf"&&(a.textContent=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function Qd(_){let a,w="Examples:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMyUyMEFzc3VtZSUyMGElMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMGRhdGFfbG9hZGVyJTIwYW5kJTIwc2NoZWR1bGVyJTIwYXJlJTIwZGVmaW5lZCUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YV9sb2FkZXIlMkMlMjBzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwZGF0YV9sb2FkZXIlMkMlMjBzY2hlZHVsZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume a model, optimizer, data_loader and scheduler are defined</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, data_loader, scheduler = accelerator.prepare(model, optimizer, data_loader, scheduler)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-kvfsh7"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Fd(_){let a,w;return a=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMyUyMEFzc3VtZSUyMGElMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMGRhdGFfbG9hZGVyJTIwYW5kJTIwc2NoZWR1bGVyJTIwYXJlJTIwZGVmaW5lZCUwQWRldmljZV9wbGFjZW1lbnQlMjAlM0QlMjAlNUJUcnVlJTJDJTIwVHJ1ZSUyQyUyMEZhbHNlJTJDJTIwRmFsc2UlNUQlMEElMjMlMjBXaWxsJTIwcGxhY2UlMjB0aGUlMjBmaXJzdCUyMHRvJTIwaXRlbXMlMjBwYXNzZWQlMjBpbiUyMGF1dG9tYXRpY2FsbHklMjB0byUyMHRoZSUyMHJpZ2h0JTIwZGV2aWNlJTIwYnV0JTIwbm90JTIwdGhlJTIwbGFzdCUyMHR3by4lMEFtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMGRhdGFfbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZSglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMGRhdGFfbG9hZGVyJTJDJTIwc2NoZWR1bGVyJTJDJTIwZGV2aWNlX3BsYWNlbWVudCUzRGRldmljZV9wbGFjZW1lbnQlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume a model, optimizer, data_loader and scheduler are defined</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>device_placement = [<span class="hljs-literal">True</span>, <span class="hljs-literal">True</span>, <span class="hljs-literal">False</span>, <span class="hljs-literal">False</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Will place the first to items passed in automatically to the right device but not the last two.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, data_loader, scheduler = accelerator.prepare(
<span class="hljs-meta">... </span>    model, optimizer, data_loader, scheduler, device_placement=device_placement
<span class="hljs-meta">... </span>)`,wrap:!1}}),{c(){u(a.$$.fragment)},l(l){f(a.$$.fragment,l)},m(l,s){b(a,l,s),w=!0},p:U,i(l){w||($(a.$$.fragment,l),w=!0)},o(l){y(a.$$.fragment,l),w=!1},d(l){M(a,l)}}}function zd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBZGF0YV9sb2FkZXIlMjAlM0QlMjB0b3JjaC51dGlscy5kYXRhLkRhdGFMb2FkZXIoLi4uKSUwQWRhdGFfbG9hZGVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZV9kYXRhX2xvYWRlcihkYXRhX2xvYWRlciUyQyUyMGRldmljZV9wbGFjZW1lbnQlM0RUcnVlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>data_loader = torch.utils.data.DataLoader(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>data_loader = accelerator.prepare_data_loader(data_loader, device_placement=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Rd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMyUyMEFzc3VtZSUyMGElMjBtb2RlbCUyMGlzJTIwZGVmaW5lZCUwQW1vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZV9tb2RlbChtb2RlbCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume a model is defined</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = accelerator.prepare_model(model)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Sd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbSguLi4pJTBBb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZV9vcHRpbWl6ZXIob3B0aW1pemVyJTJDJTIwZGV2aWNlX3BsYWNlbWVudCUzRFRydWUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.Adam(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = accelerator.prepare_optimizer(optimizer, device_placement=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Ed(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBb3B0aW1pemVyJTIwJTNEJTIwdG9yY2gub3B0aW0uQWRhbSguLi4pJTBBc2NoZWR1bGVyJTIwJTNEJTIwdG9yY2gub3B0aW0ubHJfc2NoZWR1bGVyLkxhbWJkYUxSKG9wdGltaXplciUyQyUyMC4uLiklMEFzY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlX3NjaGVkdWxlcihzY2hlZHVsZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = torch.optim.Adam(...)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = torch.optim.lr_scheduler.LambdaLR(optimizer, ...)
<span class="hljs-meta">&gt;&gt;&gt; </span>scheduler = accelerator.prepare_scheduler(scheduler)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Hd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWFjY2VsZXJhdG9yLnByaW50KCUyMkhlbGxvJTIwd29ybGQhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Hello world!&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Ld(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBwcm9jZXNzZXMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEFwcm9jZXNzX3RlbnNvciUyMCUzRCUyMHRvcmNoLmFyYW5nZShhY2NlbGVyYXRvci5udW1fcHJvY2Vzc2VzKSUyMCUyQiUyMDElMjAlMkIlMjAoMiUyMColMjBhY2NlbGVyYXRvci5wcm9jZXNzX2luZGV4KSUwQXByb2Nlc3NfdGVuc29yJTIwJTNEJTIwcHJvY2Vzc190ZW5zb3IudG8oYWNjZWxlcmF0b3IuZGV2aWNlKSUwQXJlZHVjZWRfdGVuc29yJTIwJTNEJTIwYWNjZWxlcmF0b3IucmVkdWNlKHByb2Nlc3NfdGVuc29yJTJDJTIwcmVkdWN0aW9uJTNEJTIyc3VtJTIyKSUwQXJlZHVjZWRfdGVuc29y",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>process_tensor = torch.arange(accelerator.num_processes) + <span class="hljs-number">1</span> + (<span class="hljs-number">2</span> * accelerator.process_index)
<span class="hljs-meta">&gt;&gt;&gt; </span>process_tensor = process_tensor.to(accelerator.device)
<span class="hljs-meta">&gt;&gt;&gt; </span>reduced_tensor = accelerator.reduce(process_tensor, reduction=<span class="hljs-string">&quot;sum&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>reduced_tensor
tensor([<span class="hljs-number">4</span>, <span class="hljs-number">6</span>])`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Pd(_){let a,w="Every <code>object</code> must have a <code>load_state_dict</code> and <code>state_dict</code> function to be stored.";return{c(){a=d("p"),a.innerHTML=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1kglckk"&&(a.innerHTML=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function Dd(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMyUyMEFzc3VtZSUyMCU2MEN1c3RvbU9iamVjdCU2MCUyMGhhcyUyMGElMjAlNjBzdGF0ZV9kaWN0JTYwJTIwYW5kJTIwJTYwbG9hZF9zdGF0ZV9kaWN0JTYwJTIwZnVuY3Rpb24uJTBBb2JqJTIwJTNEJTIwQ3VzdG9tT2JqZWN0KCklMEFhY2NlbGVyYXRvci5yZWdpc3Rlcl9mb3JfY2hlY2twb2ludGluZyhvYmopJTBBYWNjZWxlcmF0b3Iuc2F2ZV9zdGF0ZSglMjJjaGVja3BvaW50LnB0JTIyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator\n\n<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()\n<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume `CustomObject` has a `state_dict` and `load_state_dict` function.</span>\n<span class="hljs-meta">&gt;&gt;&gt; </span>obj = CustomObject()\n<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.register_for_checkpointing(obj)\n<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.save_state(<span class="hljs-string">&quot;checkpoint.pt&quot;</span>)',wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function Kd(_){let a,w=`Should only be used in conjunction with <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.register_save_state_pre_hook">Accelerator.register_save_state_pre_hook()</a>. Can be useful to load
configurations in addition to model weights. Can also be used to overwrite model loading with a customized
method. In this case, make sure to remove already loaded models from the models list.`;return{c(){a=d("p"),a.innerHTML=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1qnymkw"&&(a.innerHTML=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function qd(_){let a,w=`Should only be used in conjunction with <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.register_load_state_pre_hook">Accelerator.register_load_state_pre_hook()</a>. Can be useful to save
configurations in addition to model weights. Can also be used to overwrite model saving with a customized
method. In this case, make sure to remove already loaded weights from the weights list.`;return{c(){a=d("p"),a.innerHTML=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-cks0xt"&&(a.innerHTML=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function Od(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWFyciUyMCUzRCUyMCU1QjAlMkMlMjAxJTJDJTIwMiUyQyUyMDMlNUQlMEFhY2NlbGVyYXRvci5zYXZlKGFyciUyQyUyMCUyMmFycmF5LnBrbCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>arr = [<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.save(arr, <span class="hljs-string">&quot;array.pkl&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function em(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQW1vZGVsJTIwJTNEJTIwLi4uJTBBYWNjZWxlcmF0b3Iuc2F2ZV9tb2RlbChtb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.save_model(model, save_directory)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function tm(_){let a,w=`Should only be used when wanting to save a checkpoint during training and restoring the state in the same
environment.`;return{c(){a=d("p"),a.textContent=w},l(l){a=m(l,"P",{"data-svelte-h":!0}),j(a)!=="svelte-1ljq3ee"&&(a.textContent=w)},m(l,s){g(l,a,s)},p:U,d(l){l&&o(a)}}}function am(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGVyJTIwJTNEJTIwLi4uJTBBbW9kZWwlMkMlMjBvcHRpbWl6ZXIlMkMlMjBscl9zY2hlZHVsZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwbHJfc2NoZWR1bGVyKSUwQWFjY2VsZXJhdG9yLnNhdmVfc3RhdGUob3V0cHV0X2RpciUzRCUyMm15X2NoZWNrcG9pbnQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, lr_scheduler = ...
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer, lr_scheduler = accelerator.prepare(model, optimizer, lr_scheduler)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.save_state(output_dir=<span class="hljs-string">&quot;my_checkpoint&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function sm(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyMyUyMEFzc3VtZSUyMGxhdGVyJTIwaW4lMjB0aGUlMjB0cmFpbmluZyUyMHNjcmlwdCUwQSUyMyUyMCU2MHNob3VsZF9kb19icmVha3BvaW50JTYwJTIwaXMlMjBhJTIwY3VzdG9tJTIwZnVuY3Rpb24lMjB0byUyMG1vbml0b3IlMjB3aGVuJTIwdG8lMjBicmVhayUyQyUwQSUyMyUyMGUuZy4lMjB3aGVuJTIwdGhlJTIwbG9zcyUyMGlzJTIwTmFOJTBBaWYlMjBzaG91bGRfZG9fYnJlYWtwb2ludChsb3NzKSUzQSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLnNldF90cmlnZ2VyKCklMEElMjMlMjBBc3N1bWUlMjBsYXRlciUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBzY3JpcHQlMEFpZiUyMGFjY2VsZXJhdG9yLmNoZWNrX2JyZWFrcG9pbnQoKSUzQSUwQSUyMCUyMCUyMCUyMGJyZWFr",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume later in the training script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># \`should_do_breakpoint\` is a custom function to monitor when to break,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># e.g. when the loss is NaN</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> should_do_breakpoint(loss):
<span class="hljs-meta">... </span>    accelerator.set_trigger()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assume later in the training script</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> accelerator.check_breakpoint():
<span class="hljs-meta">... </span>    <span class="hljs-keyword">break</span>`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function lm(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWRhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyQyUyMHNjaGVkdWxlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyJTJDJTIwc2NoZWR1bGVyKSUwQXNraXBwZWRfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnNraXBfZmlyc3RfYmF0Y2hlcyhkYXRhbG9hZGVyJTJDJTIwbnVtX2JhdGNoZXMlM0QyKSUwQSUyMyUyMGZvciUyMHRoZSUyMGZpcnN0JTIwZXBvY2glMjBvbmx5JTBBZm9yJTIwaW5wdXQlMkMlMjB0YXJnZXQlMjBpbiUyMHNraXBwZWRfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMG91dHB1dCUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmMob3V0cHV0JTJDJTIwdGFyZ2V0KSUwQSUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUwQSUyMyUyMHN1YnNlcXVlbnQlMjBlcG9jaHMlMEFmb3IlMjBpbnB1dCUyQyUyMHRhcmdldCUyMGluJTIwZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMG9wdGltaXplci56ZXJvX2dyYWQoKSUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader, model, optimizer, scheduler = accelerator.prepare(dataloader, model, optimizer, scheduler)
<span class="hljs-meta">&gt;&gt;&gt; </span>skipped_dataloader = accelerator.skip_first_batches(dataloader, num_batches=<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># for the first epoch only</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, target <span class="hljs-keyword">in</span> skipped_dataloader:
<span class="hljs-meta">... </span>    optimizer.zero_grad()
<span class="hljs-meta">... </span>    output = model(<span class="hljs-built_in">input</span>)
<span class="hljs-meta">... </span>    loss = loss_func(output, target)
<span class="hljs-meta">... </span>    accelerator.backward(loss)
<span class="hljs-meta">... </span>    optimizer.step()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># subsequent epochs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> <span class="hljs-built_in">input</span>, target <span class="hljs-keyword">in</span> dataloader:
<span class="hljs-meta">... </span>    optimizer.zero_grad()
<span class="hljs-meta">... </span>    ...`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function rm(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1lJTIwdGhlcmUlMjBhcmUlMjB0d28lMjBwcm9jZXNzZXMlMEFmcm9tJTIwYWNjZWxlcmF0ZSUyMGltcG9ydCUyMEFjY2VsZXJhdG9yJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcigpJTBBd2l0aCUyMGFjY2VsZXJhdG9yLnNwbGl0X2JldHdlZW5fcHJvY2Vzc2VzKCU1QiUyMkElMjIlMkMlMjAlMjJCJTIyJTJDJTIwJTIyQyUyMiU1RCklMjBhcyUyMGlucHV0cyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGlucHV0cyklMEElMjMlMjBQcm9jZXNzJTIwMCUwQSU1QiUyMkElMjIlMkMlMjAlMjJCJTIyJTVEJTBBJTIzJTIwUHJvY2VzcyUyMDElMEElNUIlMjJDJTIyJTVEJTBBJTBBd2l0aCUyMGFjY2VsZXJhdG9yLnNwbGl0X2JldHdlZW5fcHJvY2Vzc2VzKCU1QiUyMkElMjIlMkMlMjAlMjJCJTIyJTJDJTIwJTIyQyUyMiU1RCUyQyUyMGFwcGx5X3BhZGRpbmclM0RUcnVlKSUyMGFzJTIwaW5wdXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoaW5wdXRzKSUwQSUyMyUyMFByb2Nlc3MlMjAwJTBBJTVCJTIyQSUyMiUyQyUyMCUyMkIlMjIlNUQlMEElMjMlMjBQcm9jZXNzJTIwMSUwQSU1QiUyMkMlMjIlMkMlMjAlMjJDJTIyJTVE",highlighted:`<span class="hljs-comment"># Assume there are two processes</span>
<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator()
<span class="hljs-keyword">with</span> accelerator.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>]

<span class="hljs-keyword">with</span> accelerator.split_between_processes([<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>], apply_padding=<span class="hljs-literal">True</span>) <span class="hljs-keyword">as</span> inputs:
    <span class="hljs-built_in">print</span>(inputs)
<span class="hljs-comment"># Process 0</span>
[<span class="hljs-string">&quot;A&quot;</span>, <span class="hljs-string">&quot;B&quot;</span>]
<span class="hljs-comment"># Process 1</span>
[<span class="hljs-string">&quot;C&quot;</span>, <span class="hljs-string">&quot;C&quot;</span>]`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function nm(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWRhdGFsb2FkZXIlMkMlMjBtb2RlbCUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoZGF0YWxvYWRlciUyQyUyMG1vZGVsJTJDJTIwb3B0aW1pemVyKSUwQSUwQXdpdGglMjBhY2NlbGVyYXRvci5ub19zeW5jKCklM0ElMEElMjAlMjAlMjAlMjBsb3NzX2ElMjAlM0QlMjBsb3NzX2Z1bmMobW9kZWwoaW5wdXRfYSkpJTIwJTIwJTIzJTIwZmlyc3QlMjBmb3J3YXJkJTIwcGFzcyUwQSUyMCUyMCUyMCUyMGxvc3NfYiUyMCUzRCUyMGxvc3NfZnVuYyhtb2RlbChpbnB1dF9iKSklMjAlMjAlMjMlMjBzZWNvbmQlMjBmb3J3YXJkJTIwcGFzcyUwQWFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3NfYSklMjAlMjAlMjMlMjBObyUyMHN5bmNocm9uaXphdGlvbiUyMGFjcm9zcyUyMHByb2Nlc3NlcyUyQyUyMG9ubHklMjBhY2N1bXVsYXRlJTIwZ3JhZGllbnRzJTBBd2l0aCUyMGFjY2VsZXJhdG9yLnRyaWdnZXJfc3luY19pbl9iYWNrd2FyZChtb2RlbCklM0ElMEElMjAlMjAlMjAlMjBhY2NlbGVyYXRvci5iYWNrd2FyZChsb3NzX2IpJTIwJTIwJTIzJTIwU3luY2hyb25pemF0aW9uJTIwYWNyb3NzJTIwYWxsJTIwcHJvY2Vzc2VzJTBBb3B0aW1pemVyLnN0ZXAoKSUwQW9wdGltaXplci56ZXJvX2dyYWQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>dataloader, model, optimizer = accelerator.prepare(dataloader, model, optimizer)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.no_sync():
<span class="hljs-meta">... </span>    loss_a = loss_func(model(input_a))  <span class="hljs-comment"># first forward pass</span>
<span class="hljs-meta">... </span>    loss_b = loss_func(model(input_b))  <span class="hljs-comment"># second forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.backward(loss_a)  <span class="hljs-comment"># No synchronization across processes, only accumulate gradients</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> accelerator.trigger_sync_in_backward(model):
<span class="hljs-meta">... </span>    accelerator.backward(loss_b)  <span class="hljs-comment"># Synchronization across all processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.step()
<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer.zero_grad()`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function cm(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShtb2RlbCUyQyUyMG9wdGltaXplciklMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzKSUwQWxvc3MlMjAlM0QlMjBsb3NzX2ZuKG91dHB1dHMlMkMlMjBsYWJlbHMpJTBBYWNjZWxlcmF0b3IuYmFja3dhcmQobG9zcyklMEFhY2NlbGVyYXRvci51bnNjYWxlX2dyYWRpZW50cyhvcHRpbWl6ZXIlM0RvcHRpbWl6ZXIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model, optimizer = accelerator.prepare(model, optimizer)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = loss_fn(outputs, labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.backward(loss)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.unscale_gradients(optimizer=optimizer)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function om(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBHUFUlMjBwcm9jZXNzZXMlMEFmcm9tJTIwdG9yY2gubm4ucGFyYWxsZWwlMjBpbXBvcnQlMjBEaXN0cmlidXRlZERhdGFQYXJhbGxlbCUwQWZyb20lMjBhY2NlbGVyYXRlJTIwaW1wb3J0JTIwQWNjZWxlcmF0b3IlMEElMEFhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEFtb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUoTXlNb2RlbCgpKSUwQXByaW50KG1vZGVsLl9fY2xhc3NfXy5fX25hbWVfXyklMEElMEFtb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnVud3JhcF9tb2RlbChtb2RlbCklMEFwcmludChtb2RlbC5fX2NsYXNzX18uX19uYW1lX18p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two GPU processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.nn.parallel <span class="hljs-keyword">import</span> DistributedDataParallel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span>model = accelerator.prepare(MyModel())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.__class__.__name__)
DistributedDataParallel

<span class="hljs-meta">&gt;&gt;&gt; </span>model = accelerator.unwrap_model(model)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(model.__class__.__name__)
MyModel`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function pm(_){let a,w="Example:",l,s,i;return s=new T({props:{code:"JTIzJTIwQXNzdW1pbmclMjB0d28lMjBHUFUlMjBwcm9jZXNzZXMlMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQWlmJTIwYWNjZWxlcmF0b3IuaXNfbWFpbl9wcm9jZXNzJTNBJTBBJTIwJTIwJTIwJTIwdGltZS5zbGVlcCgyKSUwQWVsc2UlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJJJ20lMjB3YWl0aW5nJTIwZm9yJTIwdGhlJTIwbWFpbiUyMHByb2Nlc3MlMjB0byUyMGZpbmlzaCUyMGl0cyUyMHNsZWVwLi4uJTIyKSUwQWFjY2VsZXJhdG9yLndhaXRfZm9yX2V2ZXJ5b25lKCklMEElMjMlMjBTaG91bGQlMjBwcmludCUyMG9uJTIwZXZlcnklMjBwcm9jZXNzJTIwYXQlMjB0aGUlMjBzYW1lJTIwdGltZSUwQXByaW50KCUyMkV2ZXJ5b25lJTIwaXMlMjBoZXJlJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Assuming two GPU processes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> time
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator = Accelerator()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> accelerator.is_main_process:
<span class="hljs-meta">... </span>    time.sleep(<span class="hljs-number">2</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;I&#x27;m waiting for the main process to finish its sleep...&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>accelerator.wait_for_everyone()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Should print on every process at the same time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Everyone is here&quot;</span>)`,wrap:!1}}),{c(){a=d("p"),a.textContent=w,l=n(),u(s.$$.fragment)},l(e){a=m(e,"P",{"data-svelte-h":!0}),j(a)!=="svelte-11lpom8"&&(a.textContent=w),l=c(e),f(s.$$.fragment,e)},m(e,h){g(e,a,h),g(e,l,h),b(s,e,h),i=!0},p:U,i(e){i||($(s.$$.fragment,e),i=!0)},o(e){y(s.$$.fragment,e),i=!1},d(e){e&&(o(a),o(l)),M(s,e)}}}function im(_){let a,w,l,s,i,e,h,yp=`The <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> is the main class provided by 🤗 Accelerate.
It serves at the main entry point for the API.`,fr,ha,br,ga,Mp="To quickly adapt your script to work on any kind of setup with 🤗 Accelerate just:",$r,ua,wp='<li>Initialize an <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a> object (that we will call <code>accelerator</code> throughout this page) as early as possible in your script.</li> <li>Pass your dataloader(s), model(s), optimizer(s), and scheduler(s) to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a> method.</li> <li>Remove all the <code>.cuda()</code> or <code>.to(device)</code> from your code and let the <code>accelerator</code> handle the device placement for you.</li>',yr,ht,Mr,gt,jp='<li>Replace <code>loss.backward()</code> in your code with <code>accelerator.backward(loss)</code></li> <li>Gather your predictions and labels before storing them or using them for metric computation using <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.gather">gather()</a></li>',wr,ut,jr,fa,_p=`In most cases this is all that is needed. The next section lists a few more advanced use cases and nice features
you should search for and replace by the corresponding methods of your <code>accelerator</code>:`,_r,ba,vr,$a,Jr,ya,vp='<code>print</code> statements should be replaced by <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.print">print()</a> to be printed once per process:',Tr,Ma,Ur,wa,xr,ja,Gr,_a,Jp="For statements that should be executed once per server, use <code>is_local_main_process</code>:",kr,va,Cr,Ja,Tp=`A function can be wrapped using the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.on_local_main_process">on_local_main_process()</a> function to achieve the same
behavior on a function’s execution:`,Ir,Ta,Zr,Ua,Br,xa,Up="For statements that should only ever be executed once, use <code>is_main_process</code>:",Wr,Ga,Xr,ka,xp=`A function can be wrapped using the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.on_main_process">on_main_process()</a> function to achieve the same
behavior on a function’s execution:`,Yr,Ca,Vr,Ia,Ar,Za,Gp=`If a function should be ran on a specific overall or local process index, there are similar decorators
to achieve this:`,Nr,Ba,Qr,Wa,Fr,Xa,zr,Ya,kp='Use <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.wait_for_everyone">wait_for_everyone()</a> to make sure all processes join that point before continuing. (Useful before a model save for instance).',Rr,Va,Sr,Aa,Er,Na,Cp='Use <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> instead of <code>torch.save</code> to save a model. It will remove all model wrappers added during the distributed process, get the state_dict of the model and save it. The state_dict will be in the same precision as the model being trained.',Hr,Qa,Lr,Fa,Ip=`<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_model">save_model()</a> can also save a model into sharded checkpoints or with safetensors format.
Here is an example:`,Pr,za,Dr,Ra,Kr,Sa,Zp='If you are using models from the <a href="https://huggingface.co/docs/transformers/" rel="nofollow">🤗 Transformers</a> library, you can use the <code>.save_pretrained()</code> method.',qr,Ea,Or,Ha,Bp="This will ensure your model stays compatible with other 🤗 Transformers functionality like the <code>.from_pretrained()</code> method.",en,La,tn,Pa,an,Da,Wp='Use <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">clip<em>grad_norm</em>()</a> instead of <code>torch.nn.utils.clip_grad_norm_</code> and <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">clip<em>grad_value</em>()</a> instead of <code>torch.nn.utils.clip_grad_value</code>',sn,Ka,ln,qa,Xp=`To perform gradient accumulation use <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.accumulate">accumulate()</a> and specify a gradient_accumulation_steps.
This will also automatically ensure the gradients are synced or unsynced when on
multi-device training, check if the step should actually be performed, and auto-scale the loss:`,rn,Oa,nn,es,cn,ze,ts,fn,Os,Yp="A plugin to configure gradient accumulation behavior.",on,as,Vp=`Instead of passing <code>gradient_accumulation_steps</code> you can instantiate a GradientAccumulationPlugin and pass it to the <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator">Accelerator</a>’s <code>__init__</code>
as <code>gradient_accumulation_plugin</code>. You can only pass either one of <code>gradient_accumulation_plugin</code> or <code>gradient_accumulation_steps</code> passing both will raise an error.`,pn,ss,dn,ls,Ap="In addition to the number of steps, this also lets you configure whether or not you adjust your learning rate scheduler to account for the change in steps due to accumulation.",mn,rs,hn,v,ns,bn,el,Np="Creates an instance of an accelerator for distributed training (on multi-GPU, TPU) or mixed precision training.",$n,tl,Qp="<strong>Available attributes:</strong>",yn,al,Fp=`<li><strong>device</strong> (<code>torch.device</code>) — The device to use.</li> <li><strong>distributed_type</strong> (<a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.DistributedType">DistributedType</a>) — The distributed training configuration.</li> <li><strong>local_process_index</strong> (<code>int</code>) — The process index on the current machine.</li> <li><strong>mixed_precision</strong> (<code>str</code>) — The configured mixed precision mode.</li> <li><strong>num_processes</strong> (<code>int</code>) — The total number of processes used for training.</li> <li><strong>optimizer_step_was_skipped</strong> (<code>bool</code>) — Whether or not the optimizer update was skipped (because of
gradient overflow in mixed precision), in which
case the learning rate should not be changed.</li> <li><strong>process_index</strong> (<code>int</code>) — The overall index of the current process among all processes.</li> <li><strong>state</strong> (<a href="/docs/accelerate/main/en/package_reference/state#accelerate.state.AcceleratorState">AcceleratorState</a>) — The distributed setup state.</li> <li><strong>sync_gradients</strong> (<code>bool</code>) — Whether the gradients are currently being synced across all processes.</li> <li><strong>use_distributed</strong> (<code>bool</code>) — Whether the current configuration is for distributed training.</li>`,Mn,ye,cs,wn,sl,zp="A context manager that will lightly wrap around and perform gradient accumulation automatically",jn,ft,_n,S,os,vn,ll,Rp=`Will apply automatic mixed-precision inside the block inside this context manager, if it is enabled. Nothing
different will happen otherwise.`,Jn,rl,Sp=`A different <code>autocast_handler</code> can be passed in to override the one set in the <code>Accelerator</code> object. This is
useful in blocks under <code>autocast</code> where you want to revert to fp32.`,Tn,bt,Un,E,ps,xn,nl,Ep=`Scales the gradients in accordance to the <code>GradientAccumulationPlugin</code> and calls the correct <code>backward()</code> based
on the configuration.`,Gn,cl,Hp="Should be used in lieu of <code>loss.backward()</code>.",kn,$t,Cn,H,is,In,ol,Lp=`Checks if the internal trigger tensor has been set to 1 in any of the processes. If so, will return <code>True</code> and
reset the trigger tensor to 0.`,Zn,pl,Pp=`Note:
Does not require <code>wait_for_everyone()</code>`,Bn,yt,Wn,Me,ds,Xn,il,Dp=`Alias for <code>Accelerate.free_memory</code>, releases all references to the internal objects stored and call the
garbage collector. You should call this method between two trainings with different models/optimizers.`,Yn,Mt,Vn,we,ms,An,dl,Kp="Should be used in place of <code>torch.nn.utils.clip_grad_norm_</code>.",Nn,wt,Qn,je,hs,Fn,ml,qp="Should be used in place of <code>torch.nn.utils.clip_grad_value_</code>.",zn,jt,Rn,_e,gs,Sn,hl,Op=`Will release all references to the internal objects stored and call the garbage collector. You should call this
method between two trainings with different models/optimizers. Also will reset <code>Accelerator.step</code> to 0.`,En,_t,Hn,L,us,Ln,gl,ei=`Gather the values in <em>tensor</em> across all processes and concatenate them on the first dimension. Useful to
regroup the predictions from all processes when doing evaluation.`,Pn,ul,ti=`Note:
This gather happens in all processes.`,Dn,vt,Kn,ve,fs,qn,fl,ai=`Gathers <code>input_data</code> and potentially drops duplicates in the last batch if on a distributed system. Should be
used for gathering the inputs and targets for metric calculation.`,On,Jt,ec,Je,bs,tc,bl,si=`Returns the state dictionary of a model sent through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">Accelerator.prepare()</a> potentially without full
precision.`,ac,Tt,sc,Te,$s,lc,$l,li="Returns a <code>tracker</code> from <code>self.trackers</code> based on <code>name</code> on the main process only.",rc,Ut,nc,A,ys,cc,yl,ri=`A context manager that facilitates distributed training or evaluation on uneven inputs, which acts as a wrapper
around <code>torch.distributed.algorithms.join</code>. This is useful when the total batch size does not evenly divide the
length of the dataset.`,oc,xt,pc,Gt,ic,kt,dc,P,Ms,mc,Ml,ni="Loads the current states of the model, optimizer, scaler, RNG generators, and registered objects.",hc,Ct,gc,It,uc,D,ws,fc,wl,ci="Lets the local main process go inside a with block.",bc,jl,oi="The other processes will enter the with block after the main process exits.",$c,Zt,yc,K,js,Mc,_l,pi="Lets the main process go first inside a with block.",wc,vl,ii="The other processes will enter the with block after the main process exits.",jc,Bt,_c,q,_s,vc,Jl,di=`A context manager to disable gradient synchronizations across DDP processes by calling
<code>torch.nn.parallel.DistributedDataParallel.no_sync</code>.`,Jc,Tl,mi="If <code>model</code> is not in DDP, this context manager does nothing",Tc,Wt,Uc,Ue,vs,xc,Ul,hi=`A decorator that will run the decorated function on the last process only. Can also be called using the
<code>PartialState</code> class.`,Gc,Xt,kc,xe,Js,Cc,xl,gi=`A decorator that will run the decorated function on the local main process only. Can also be called using the
<code>PartialState</code> class.`,Ic,Yt,Zc,Ge,Ts,Bc,Gl,ui=`A decorator that will run the decorated function on a given local process index only. Can also be called using
the <code>PartialState</code> class.`,Wc,Vt,Xc,ke,Us,Yc,kl,fi=`A decorator that will run the decorated function on the main process only. Can also be called using the
<code>PartialState</code> class.`,Vc,At,Ac,Ce,xs,Nc,Cl,bi=`A decorator that will run the decorated function on a given process index only. Can also be called using the
<code>PartialState</code> class.`,Qc,Nt,Fc,Ie,Gs,zc,Il,$i=`Recursively pad the tensors in a nested list/tuple/dictionary of tensors from all devices to the same size so
they can safely be gathered.`,Rc,Qt,Sc,N,ks,Ec,Zl,yi=`Prepare all objects passed in <code>args</code> for distributed training and mixed precision, then return them in the same
order.`,Hc,Ft,Lc,zt,Pc,Rt,Dc,Ze,Cs,Kc,Bl,Mi=`Prepares a PyTorch DataLoader for training in any distributed setup. It is recommended to use
<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">Accelerator.prepare()</a> instead.`,qc,St,Oc,Be,Is,eo,Wl,wi=`Prepares a PyTorch model for training in any distributed setup. It is recommended to use
<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">Accelerator.prepare()</a> instead.`,to,Et,ao,We,Zs,so,Xl,ji=`Prepares a PyTorch Optimizer for training in any distributed setup. It is recommended to use
<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">Accelerator.prepare()</a> instead.`,lo,Ht,ro,Xe,Bs,no,Yl,_i=`Prepares a PyTorch Scheduler for training in any distributed setup. It is recommended to use
<a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">Accelerator.prepare()</a> instead.`,co,Lt,oo,Ye,Ws,po,Vl,vi="Drop in replacement of <code>print()</code> to only print once per server.",io,Pt,mo,O,Xs,ho,Al,Ji="Reduce the values in <em>tensor</em> across all processes based on <em>reduction</em>.",go,Nl,Ti=`Note:
All processes get the reduced value.`,uo,Dt,fo,Q,Ys,bo,Ql,Ui="Makes note of <code>objects</code> and will save or load them in during <code>save_state</code> or <code>load_state</code>.",$o,Fl,xi=`These should be utilized when the state is being loaded or saved in the same script. It is not designed to be
used in different scripts.`,yo,Kt,Mo,qt,wo,I,Vs,jo,zl,Gi='Registers a pre hook to be run before <code>load_checkpoint</code> is called in <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">Accelerator.load_state()</a>.',_o,Rl,ki="The hook should have the following signature:",vo,Sl,Ci="<code>hook(models: list[torch.nn.Module], input_dir: str) -&gt; None</code>",Jo,El,Ii=`The <code>models</code> argument are the models as saved in the accelerator state under <code>accelerator._models</code>, and the
<code>input_dir</code> argument is the <code>input_dir</code> argument passed to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">Accelerator.load_state()</a>.`,To,Ot,Uo,Z,As,xo,Hl,Zi='Registers a pre hook to be run before <code>save_checkpoint</code> is called in <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">Accelerator.save_state()</a>.',Go,Ll,Bi="The hook should have the following signature:",ko,Pl,Wi="<code>hook(models: list[torch.nn.Module], weights: list[dict[str, torch.Tensor]], input_dir: str) -&gt; None</code>",Co,Dl,Xi=`The <code>models</code> argument are the models as saved in the accelerator state under <code>accelerator._models</code>, <code>weigths</code>
argument are the state dicts of the <code>models</code>, and the <code>input_dir</code> argument is the <code>input_dir</code> argument passed
to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">Accelerator.load_state()</a>.`,Io,ea,Zo,ee,Ns,Bo,Kl,Yi="Save the object passed to disk once per machine. Use in place of <code>torch.save</code>.",Wo,ql,Vi=`Note:
If <code>save_on_each_node</code> was passed in as a <code>ProjectConfiguration</code>, will save the object once per node,
rather than only once on the main node.`,Xo,ta,Yo,Ve,Qs,Vo,Ol,Ai="Save a model so that it can be re-loaded using load_checkpoint_in_model",Ao,aa,No,B,Fs,Qo,er,Ni="Saves the current states of the model, optimizer, scaler, RNG generators, and registered objects to a folder.",Fo,tr,Qi=`If a <code>ProjectConfiguration</code> was passed to the <code>Accelerator</code> object with <code>automatic_checkpoint_naming</code> enabled
then checkpoints will be saved to <code>self.project_dir/checkpoints</code>. If the number of current saves is greater
than <code>total_limit</code> then the oldest save is deleted. Each checkpoint is saved in seperate folders named
<code>checkpoint_&lt;iteration&gt;</code>.`,zo,ar,Fi="Otherwise they are just saved to <code>output_dir</code>.",Ro,sa,So,la,Eo,te,zs,Ho,sr,zi=`Sets the internal trigger tensor to 1 on the current process. A latter check should follow using this which
will check across all processes.`,Lo,lr,Ri=`Note:
Does not require <code>wait_for_everyone()</code>`,Po,ra,Do,Ae,Rs,Ko,rr,Si="Creates a new <code>torch.utils.data.DataLoader</code> that will efficiently skip the first <code>num_batches</code>.",qo,na,Oo,ae,Ss,ep,nr,Ei=`Splits <code>input</code> between <code>self.num_processes</code> quickly and can be then used on that process. Useful when doing
distributed inference, such as with different prompts.`,tp,cr,Hi="Note that when using a <code>dict</code>, all keys need to have the same number of elements.",ap,ca,sp,se,Es,lp,or,Li=`Trigger the sync of the gradients in the next backward pass of the model after multiple forward passes under
<code>Accelerator.no_sync</code> (only applicable in multi-GPU scenarios).`,rp,pr,Pi="If the script is not launched in distributed mode, this context manager does nothing.",np,oa,cp,le,Hs,op,ir,Di="Unscale the gradients in mixed precision training with AMP. This is a noop in all other settings.",pp,dr,Ki='Likely should be called through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_norm_">Accelerator.clip<em>grad_norm</em>()</a> or <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.clip_grad_value_">Accelerator.clip<em>grad_value</em>()</a>',ip,pa,dp,Ne,Ls,mp,mr,qi=`Unwraps the <code>model</code> from the additional layer possible added by <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>. Useful before saving
the model.`,hp,ia,gp,da,Ps,up,hr,Oi="Verifies that <code>model</code> has not been prepared with big model inference with a device-map resembling <code>auto</code>.",fp,Qe,Ds,bp,gr,ed=`Will stop the execution of the current process until every other process has reached that point (so this does
nothing when the script is only run in one process). Useful to do before saving a model.`,$p,ma,gn,ur,un;return i=new V({props:{title:"Accelerator",local:"accelerator",headingTag:"h1"}}),ha=new V({props:{title:"Quick adaptation of your code",local:"quick-adaptation-of-your-code",headingTag:"h2"}}),ht=new Fe({props:{$$slots:{default:[md]},$$scope:{ctx:_}}}),ut=new Fe({props:{warning:!0,$$slots:{default:[hd]},$$scope:{ctx:_}}}),ba=new V({props:{title:"Advanced recommendations",local:"advanced-recommendations",headingTag:"h2"}}),$a=new V({props:{title:"Printing",local:"printing",headingTag:"h3"}}),Ma=new T({props:{code:"LSUyMHByaW50KCUyMk15JTIwdGhpbmclMjBJJTIwd2FudCUyMHRvJTIwcHJpbnQhJTIyKSUwQSUyQiUyMGFjY2VsZXJhdG9yLnByaW50KCUyMk15JTIwdGhpbmclMjBJJTIwd2FudCUyMHRvJTIwcHJpbnQhJTIyKQ==",highlighted:`<span class="hljs-deletion">- print(&quot;My thing I want to print!&quot;)</span>
<span class="hljs-addition">+ accelerator.print(&quot;My thing I want to print!&quot;)</span>`,wrap:!1}}),wa=new V({props:{title:"Executing processes",local:"executing-processes",headingTag:"h3"}}),ja=new V({props:{title:"Once on a single server",local:"once-on-a-single-server",headingTag:"h4"}}),va=new T({props:{code:"aWYlMjBhY2NlbGVyYXRvci5pc19sb2NhbF9tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjBkb190aGluZ19vbmNlX3Blcl9zZXJ2ZXIoKQ==",highlighted:`<span class="hljs-keyword">if</span> accelerator.is_local_main_process:
    do_thing_once_per_server()`,wrap:!1}}),Ta=new T({props:{code:"JTQwYWNjZWxlcmF0b3Iub25fbG9jYWxfbWFpbl9wcm9jZXNzJTBBZGVmJTIwZG9fbXlfdGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMlNvbWV0aGluZyUyMGRvbmUlMjBvbmNlJTIwcGVyJTIwc2VydmVyJTIyJTBBJTIwJTIwJTIwJTIwZG9fdGhpbmdfb25jZV9wZXJfc2VydmVyKCk=",highlighted:`<span class="hljs-meta">@accelerator.on_local_main_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">do_my_thing</span>():
    <span class="hljs-string">&quot;Something done once per server&quot;</span>
    do_thing_once_per_server()`,wrap:!1}}),Ua=new V({props:{title:"Only ever once across all servers",local:"only-ever-once-across-all-servers",headingTag:"h4"}}),Ga=new T({props:{code:"aWYlMjBhY2NlbGVyYXRvci5pc19tYWluX3Byb2Nlc3MlM0ElMEElMjAlMjAlMjAlMjBkb190aGluZ19vbmNlKCk=",highlighted:`<span class="hljs-keyword">if</span> accelerator.is_main_process:
    do_thing_once()`,wrap:!1}}),Ca=new T({props:{code:"JTQwYWNjZWxlcmF0b3Iub25fbWFpbl9wcm9jZXNzJTBBZGVmJTIwZG9fbXlfdGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMlNvbWV0aGluZyUyMGRvbmUlMjBvbmNlJTIwcGVyJTIwc2VydmVyJTIyJTBBJTIwJTIwJTIwJTIwZG9fdGhpbmdfb25jZSgp",highlighted:`<span class="hljs-meta">@accelerator.on_main_process</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">do_my_thing</span>():
    <span class="hljs-string">&quot;Something done once per server&quot;</span>
    do_thing_once()`,wrap:!1}}),Ia=new V({props:{title:"On specific processes",local:"on-specific-processes",headingTag:"h4"}}),Ba=new T({props:{code:"JTQwYWNjZWxlcmF0b3Iub25fbG9jYWxfcHJvY2Vzcyhsb2NhbF9wcm9jZXNzX2lkeCUzRDApJTBBZGVmJTIwZG9fbXlfdGhpbmcoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMlNvbWV0aGluZyUyMGRvbmUlMjBvbiUyMHByb2Nlc3MlMjBpbmRleCUyMDAlMjBvbiUyMGVhY2glMjBzZXJ2ZXIlMjIlMEElMjAlMjAlMjAlMjBkb190aGluZ19vbl9pbmRleF96ZXJvX29uX2VhY2hfc2VydmVyKCk=",highlighted:`<span class="hljs-meta">@accelerator.on_local_process(<span class="hljs-params">local_process_idx=<span class="hljs-number">0</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">do_my_thing</span>():
    <span class="hljs-string">&quot;Something done on process index 0 on each server&quot;</span>
    do_thing_on_index_zero_on_each_server()`,wrap:!1}}),Wa=new T({props:{code:"JTQwYWNjZWxlcmF0b3Iub25fcHJvY2Vzcyhwcm9jZXNzX2luZGV4JTNEMCklMEFkZWYlMjBkb19teV90aGluZygpJTNBJTBBJTIwJTIwJTIwJTIwJTIyU29tZXRoaW5nJTIwZG9uZSUyMG9uJTIwcHJvY2VzcyUyMGluZGV4JTIwMCUyMiUwQSUyMCUyMCUyMCUyMGRvX3RoaW5nX29uX2luZGV4X3plcm8oKQ==",highlighted:`<span class="hljs-meta">@accelerator.on_process(<span class="hljs-params">process_index=<span class="hljs-number">0</span></span>)</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">do_my_thing</span>():
    <span class="hljs-string">&quot;Something done on process index 0&quot;</span>
    do_thing_on_index_zero()`,wrap:!1}}),Xa=new V({props:{title:"Synchronicity control",local:"synchronicity-control",headingTag:"h3"}}),Va=new V({props:{title:"Saving and loading",local:"saving-and-loading",headingTag:"h3"}}),Aa=new T({props:{code:"bW9kZWwlMjAlM0QlMjBNeU1vZGVsKCklMEFtb2RlbCUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwp",highlighted:`model = MyModel()
model = accelerator.prepare(model)`,wrap:!1}}),Qa=new T({props:{code:"LSUyMHRvcmNoLnNhdmUoc3RhdGVfZGljdCUyQyUyMCUyMm15X3N0YXRlLnBrbCUyMiklMEElMkIlMjBhY2NlbGVyYXRvci5zYXZlX21vZGVsKG1vZGVsJTJDJTIwc2F2ZV9kaXJlY3Rvcnkp",highlighted:`<span class="hljs-deletion">- torch.save(state_dict, &quot;my_state.pkl&quot;)</span>
<span class="hljs-addition">+ accelerator.save_model(model, save_directory)</span>`,wrap:!1}}),za=new T({props:{code:"YWNjZWxlcmF0b3Iuc2F2ZV9tb2RlbChtb2RlbCUyQyUyMHNhdmVfZGlyZWN0b3J5JTJDJTIwbWF4X3NoYXJkX3NpemUlM0QlMjIxR0IlMjIlMkMlMjBzYWZlX3NlcmlhbGl6YXRpb24lM0RUcnVlKQ==",highlighted:'accelerator.save_model(model, save_directory, max_shard_size=<span class="hljs-string">&quot;1GB&quot;</span>, safe_serialization=<span class="hljs-literal">True</span>)',wrap:!1}}),Ra=new V({props:{title:"🤗 Transformers models",local:"-transformers-models",headingTag:"h4"}}),Ea=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBbW9kZWwlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKG1vZGVsKSUwQSUwQSUyMyUyMC4uLmZpbmUtdHVuZSUyMHdpdGglMjBQeVRvcmNoLi4uJTBBJTBBdW53cmFwcGVkX21vZGVsJTIwJTNEJTIwYWNjZWxlcmF0b3IudW53cmFwX21vZGVsKG1vZGVsKSUwQXVud3JhcHBlZF9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycGF0aCUyRnRvJTJGbXlfbW9kZWxfZGlyZWN0b3J5JTIyJTJDJTBBJTIwJTIwJTIwJTIwaXNfbWFpbl9wcm9jZXNzJTNEYWNjZWxlcmF0b3IuaXNfbWFpbl9wcm9jZXNzJTJDJTBBJTIwJTIwJTIwJTIwc2F2ZV9mdW5jdGlvbiUzRGFjY2VsZXJhdG9yLnNhdmUlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)
model = accelerator.prepare(model)

<span class="hljs-comment"># ...fine-tune with PyTorch...</span>

unwrapped_model = accelerator.unwrap_model(model)
unwrapped_model.save_pretrained(
    <span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>,
    is_main_process=accelerator.is_main_process,
    save_function=accelerator.save,
)`,wrap:!1}}),La=new T({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCglMjJwYXRoJTJGdG8lMkZteV9tb2RlbF9kaXJlY3RvcnklMjIp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModel

model = AutoModel.from_pretrained(<span class="hljs-string">&quot;path/to/my_model_directory&quot;</span>)`,wrap:!1}}),Pa=new V({props:{title:"Operations",local:"operations",headingTag:"h3"}}),Ka=new V({props:{title:"Gradient Accumulation",local:"gradient-accumulation",headingTag:"h3"}}),Oa=new T({props:{code:"LSUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoKSUwQSUyQiUyMGFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IoZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMiklMEElMEElMjAlMjBmb3IlMjAoaW5wdXQlMkMlMjBsYWJlbCklMjBpbiUyMHRyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMkIlMjAlMjAlMjAlMjAlMjB3aXRoJTIwYWNjZWxlcmF0b3IuYWNjdW11bGF0ZShtb2RlbCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG1vZGVsKGlucHV0KSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBsb3NzX2Z1bmN0aW9uKHByZWRpY3Rpb25zJTJDJTIwbGFiZWxzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCk=",highlighted:`<span class="hljs-deletion">- accelerator = Accelerator()</span>
<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_steps=2)</span>

  for (input, label) in training_dataloader:
<span class="hljs-addition">+     with accelerator.accumulate(model):</span>
          predictions = model(input)
          loss = loss_function(predictions, labels)
          accelerator.backward(loss)
          optimizer.step()
          scheduler.step()
          optimizer.zero_grad()`,wrap:!1}}),es=new V({props:{title:"GradientAccumulationPlugin",local:"accelerate.utils.GradientAccumulationPlugin",headingTag:"h4"}}),ts=new k({props:{name:"class accelerate.utils.GradientAccumulationPlugin",anchor:"accelerate.utils.GradientAccumulationPlugin",parameters:[{name:"num_steps",val:": int = None"},{name:"adjust_scheduler",val:": bool = True"},{name:"sync_with_dataloader",val:": bool = True"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/utils/dataclasses.py#L505"}}),ss=new T({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjBHcmFkaWVudEFjY3VtdWxhdGlvblBsdWdpbiUwQSUwQWdyYWRpZW50X2FjY3VtdWxhdGlvbl9wbHVnaW4lMjAlM0QlMjBHcmFkaWVudEFjY3VtdWxhdGlvblBsdWdpbihudW1fc3RlcHMlM0QyKSUwQS0lMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKCklMEElMkIlMjBhY2NlbGVyYXRvciUyMCUzRCUyMEFjY2VsZXJhdG9yKGdyYWRpZW50X2FjY3VtdWxhdGlvbl9wbHVnaW4lM0RncmFkaWVudF9hY2N1bXVsYXRpb25fcGx1Z2luKQ==",highlighted:`from accelerate.utils import GradientAccumulationPlugin

gradient_accumulation_plugin = GradientAccumulationPlugin(num_steps=2)
<span class="hljs-deletion">- accelerator = Accelerator()</span>
<span class="hljs-addition">+ accelerator = Accelerator(gradient_accumulation_plugin=gradient_accumulation_plugin)</span>`,wrap:!1}}),rs=new V({props:{title:"Overall API documentation:",local:"accelerate.Accelerator",headingTag:"h2"}}),ns=new k({props:{name:"class accelerate.Accelerator",anchor:"accelerate.Accelerator",parameters:[{name:"device_placement",val:": bool = True"},{name:"split_batches",val:": bool = False"},{name:"mixed_precision",val:": PrecisionType | str | None = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"cpu",val:": bool = False"},{name:"deepspeed_plugin",val:": DeepSpeedPlugin | None = None"},{name:"fsdp_plugin",val:": FullyShardedDataParallelPlugin | None = None"},{name:"megatron_lm_plugin",val:": MegatronLMPlugin | None = None"},{name:"rng_types",val:": list[str | RNGType] | None = None"},{name:"log_with",val:": str | LoggerType | GeneralTracker | list[str | LoggerType | GeneralTracker] | None = None"},{name:"project_dir",val:": str | os.PathLike | None = None"},{name:"project_config",val:": ProjectConfiguration | None = None"},{name:"gradient_accumulation_plugin",val:": GradientAccumulationPlugin | None = None"},{name:"dispatch_batches",val:": bool | None = None"},{name:"even_batches",val:": bool = True"},{name:"use_seedable_sampler",val:": bool = False"},{name:"step_scheduler_with_optimizer",val:": bool = True"},{name:"kwargs_handlers",val:": list[KwargsHandler] | None = None"},{name:"dynamo_backend",val:": DynamoBackend | str | None = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.device_placement",description:`<strong>device_placement</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the accelerator should put objects on device (tensors yielded by the dataloader, model,
etc&#x2026;).`,name:"device_placement"},{anchor:"accelerate.Accelerator.split_batches",description:`<strong>split_batches</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the accelerator should split the batches yielded by the dataloaders across the devices. If
<code>True</code> the actual batch size used will be the same on any kind of distributed processes, but it must be a
round multiple of the <code>num_processes</code> you are using. If <code>False</code>, actual batch size used will be the one set
in your script multiplied by the number of processes.`,name:"split_batches"},{anchor:"accelerate.Accelerator.mixed_precision",description:`<strong>mixed_precision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Whether or not to use mixed precision training. Choose from &#x2018;no&#x2019;,&#x2018;fp16&#x2019;,&#x2018;bf16 or &#x2018;fp8&#x2019;. Will default to the
value in the environment variable <code>ACCELERATE_MIXED_PRECISION</code>, which will use the default value in the
accelerate config of the current system or the flag passed with the <code>accelerate.launch</code> command. &#x2018;fp8&#x2019;
requires the installation of transformers-engine.`,name:"mixed_precision"},{anchor:"accelerate.Accelerator.gradient_accumulation_steps",description:`<strong>gradient_accumulation_steps</strong> (<code>int</code>, <em>optional</em>, default to 1) &#x2014;
The number of steps that should pass before gradients are accumulated. A number &gt; 1 should be combined with
<code>Accelerator.accumulate</code>. If not passed, will default to the value in the environment variable
<code>ACCELERATE_GRADIENT_ACCUMULATION_STEPS</code>. Can also be configured through a <code>GradientAccumulationPlugin</code>.`,name:"gradient_accumulation_steps"},{anchor:"accelerate.Accelerator.cpu",description:`<strong>cpu</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to force the script to execute on CPU. Will ignore GPU available if set to <code>True</code> and force
the execution on one process only.`,name:"cpu"},{anchor:"accelerate.Accelerator.deepspeed_plugin",description:`<strong>deepspeed_plugin</strong> (<code>DeepSpeedPlugin</code>, <em>optional</em>) &#x2014;
Tweak your DeepSpeed related args using this argument. This argument is optional and can be configured
directly using <em>accelerate config</em>`,name:"deepspeed_plugin"},{anchor:"accelerate.Accelerator.fsdp_plugin",description:`<strong>fsdp_plugin</strong> (<code>FullyShardedDataParallelPlugin</code>, <em>optional</em>) &#x2014;
Tweak your FSDP related args using this argument. This argument is optional and can be configured directly
using <em>accelerate config</em>`,name:"fsdp_plugin"},{anchor:"accelerate.Accelerator.megatron_lm_plugin",description:`<strong>megatron_lm_plugin</strong> (<code>MegatronLMPlugin</code>, <em>optional</em>) &#x2014;
Tweak your MegatronLM related args using this argument. This argument is optional and can be configured
directly using <em>accelerate config</em>`,name:"megatron_lm_plugin"},{anchor:"accelerate.Accelerator.rng_types",description:`<strong>rng_types</strong> (list of <code>str</code> or <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.RNGType">RNGType</a>) &#x2014;
The list of random number generators to synchronize at the beginning of each iteration in your prepared
dataloaders. Should be one or several of:</p>
<ul>
<li><code>&quot;torch&quot;</code>: the base torch random number generator</li>
<li><code>&quot;cuda&quot;</code>: the CUDA random number generator (GPU only)</li>
<li><code>&quot;xla&quot;</code>: the XLA random number generator (TPU only)</li>
<li><code>&quot;generator&quot;</code>: the <code>torch.Generator</code> of the sampler (or batch sampler if there is no sampler in your
dataloader) or of the iterable dataset (if it exists) if the underlying dataset is of that type.</li>
</ul>
<p>Will default to <code>[&quot;torch&quot;]</code> for PyTorch versions &lt;=1.5.1 and <code>[&quot;generator&quot;]</code> for PyTorch versions &gt;= 1.6.`,name:"rng_types"},{anchor:"accelerate.Accelerator.log_with",description:`<strong>log_with</strong> (list of <code>str</code>, <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.LoggerType">LoggerType</a> or <a href="/docs/accelerate/main/en/package_reference/tracking#accelerate.tracking.GeneralTracker">GeneralTracker</a>, <em>optional</em>) &#x2014;
A list of loggers to be setup for experiment tracking. Should be one or several of:</p>
<ul>
<li><code>&quot;all&quot;</code></li>
<li><code>&quot;tensorboard&quot;</code></li>
<li><code>&quot;wandb&quot;</code></li>
<li><code>&quot;comet_ml&quot;</code>
If <code>&quot;all&quot;</code> is selected, will pick up all available trackers in the environment and initialize them. Can
also accept implementations of <code>GeneralTracker</code> for custom trackers, and can be combined with <code>&quot;all&quot;</code>.</li>
</ul>`,name:"log_with"},{anchor:"accelerate.Accelerator.project_config",description:`<strong>project_config</strong> (<code>ProjectConfiguration</code>, <em>optional</em>) &#x2014;
A configuration for how saving the state can be handled.`,name:"project_config"},{anchor:"accelerate.Accelerator.project_dir",description:`<strong>project_dir</strong> (<code>str</code>, <code>os.PathLike</code>, <em>optional</em>) &#x2014;
A path to a directory for storing data such as logs of locally-compatible loggers and potentially saved
checkpoints.`,name:"project_dir"},{anchor:"accelerate.Accelerator.dispatch_batches",description:`<strong>dispatch_batches</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, the dataloader prepared by the Accelerator is only iterated through on the main process
and then the batches are split and broadcast to each process. Will default to <code>True</code> for <code>DataLoader</code> whose
underlying dataset is an <code>IterableDataset</code>, <code>False</code> otherwise.`,name:"dispatch_batches"},{anchor:"accelerate.Accelerator.even_batches",description:`<strong>even_batches</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If set to <code>True</code>, in cases where the total batch size across all processes does not exactly divide the
dataset, samples at the start of the dataset will be duplicated so the batch can be divided equally among
all workers.`,name:"even_batches"},{anchor:"accelerate.Accelerator.use_seedable_sampler",description:`<strong>use_seedable_sampler</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not use a fully seedable random sampler (<code>SeedableRandomSampler</code>). Ensures
training results are fully reproducable using a different sampling technique. While seed-to-seed results
may differ, on average the differences are neglible when using multiple different seeds to compare. Should
also be ran with <a href="/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.set_seed">set_seed()</a> for the best results.`,name:"use_seedable_sampler"},{anchor:"accelerate.Accelerator.step_scheduler_with_optimizer",description:"<strong>step_scheduler_with_optimizer</strong> (<code>bool</code>, *optional<code>, defaults to </code>True<code>) -- Set </code>True<code>if the learning rate scheduler is stepped at the same time as the optimizer,</code>False` if only\ndone under certain circumstances (at the end of each epoch, for instance).",name:"step_scheduler_with_optimizer"},{anchor:"accelerate.Accelerator.kwargs_handlers",description:`<strong>kwargs_handlers</strong> (<code>list[KwargHandler]</code>, <em>optional</em>) &#x2014;
A list of <code>KwargHandler</code> to customize how the objects related to distributed training or mixed precision
are created. See <a href="kwargs">kwargs</a> for more information.`,name:"kwargs_handlers"},{anchor:"accelerate.Accelerator.dynamo_backend",description:`<strong>dynamo_backend</strong> (<code>str</code> or <code>DynamoBackend</code>, <em>optional</em>, defaults to <code>&quot;no&quot;</code>) &#x2014;
Set to one of the possible dynamo backends to optimize your training with torch dynamo.`,name:"dynamo_backend"},{anchor:"accelerate.Accelerator.gradient_accumulation_plugin",description:`<strong>gradient_accumulation_plugin</strong> (<code>GradientAccumulationPlugin</code>, <em>optional</em>) &#x2014;
A configuration for how gradient accumulation should be handled, if more tweaking than just the
<code>gradient_accumulation_steps</code> is needed.`,name:"gradient_accumulation_plugin"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L153"}}),cs=new k({props:{name:"accumulate",anchor:"accelerate.Accelerator.accumulate",parameters:[{name:"*models",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.accumulate.*models",description:`<strong>*models</strong> (list of <code>torch.nn.Module</code>) &#x2014;
PyTorch Modules that were prepared with <code>Accelerator.prepare</code>. Models passed to <code>accumulate()</code> will
skip gradient syncing during backward pass in distributed training`,name:"*models"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L966"}}),ft=new C({props:{anchor:"accelerate.Accelerator.accumulate.example",$$slots:{default:[gd]},$$scope:{ctx:_}}}),os=new k({props:{name:"autocast",anchor:"accelerate.Accelerator.autocast",parameters:[{name:"cache_enabled",val:": bool = False"},{name:"autocast_handler",val:": AutocastKwargs = None"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L3107"}}),bt=new C({props:{anchor:"accelerate.Accelerator.autocast.example",$$slots:{default:[ud]},$$scope:{ctx:_}}}),ps=new k({props:{name:"backward",anchor:"accelerate.Accelerator.backward",parameters:[{name:"loss",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1936"}}),$t=new C({props:{anchor:"accelerate.Accelerator.backward.example",$$slots:{default:[fd]},$$scope:{ctx:_}}}),is=new k({props:{name:"check_trigger",anchor:"accelerate.Accelerator.check_trigger",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1992"}}),yt=new C({props:{anchor:"accelerate.Accelerator.check_trigger.example",$$slots:{default:[bd]},$$scope:{ctx:_}}}),ds=new k({props:{name:"clear",anchor:"accelerate.Accelerator.clear",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2971"}}),Mt=new C({props:{anchor:"accelerate.Accelerator.clear.example",$$slots:{default:[$d]},$$scope:{ctx:_}}}),ms=new k({props:{name:"clip_grad_norm_",anchor:"accelerate.Accelerator.clip_grad_norm_",parameters:[{name:"parameters",val:""},{name:"max_norm",val:""},{name:"norm_type",val:" = 2"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2064",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Total norm of the parameter gradients (viewed as a single vector).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),wt=new C({props:{anchor:"accelerate.Accelerator.clip_grad_norm_.example",$$slots:{default:[yd]},$$scope:{ctx:_}}}),hs=new k({props:{name:"clip_grad_value_",anchor:"accelerate.Accelerator.clip_grad_value_",parameters:[{name:"parameters",val:""},{name:"clip_value",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2102"}}),jt=new C({props:{anchor:"accelerate.Accelerator.clip_grad_value_.example",$$slots:{default:[Md]},$$scope:{ctx:_}}}),gs=new k({props:{name:"free_memory",anchor:"accelerate.Accelerator.free_memory",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2946"}}),_t=new C({props:{anchor:"accelerate.Accelerator.free_memory.example",$$slots:{default:[wd]},$$scope:{ctx:_}}}),us=new k({props:{name:"gather",anchor:"accelerate.Accelerator.gather",parameters:[{name:"tensor",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.gather.tensor",description:`<strong>tensor</strong> (<code>torch.Tensor</code>, or a nested tuple/list/dictionary of <code>torch.Tensor</code>) &#x2014;
The tensors to gather across all processes.`,name:"tensor"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2129",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The gathered tensor(s). Note that the
first dimension of the result is <em>num_processes</em> multiplied by the first dimension of the input tensors.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code>, or a nested tuple/list/dictionary of <code>torch.Tensor</code></p>
`}}),vt=new C({props:{anchor:"accelerate.Accelerator.gather.example",$$slots:{default:[jd]},$$scope:{ctx:_}}}),fs=new k({props:{name:"gather_for_metrics",anchor:"accelerate.Accelerator.gather_for_metrics",parameters:[{name:"input_data",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.gather_for_metrics.input",description:`<strong>input</strong> (<code>torch.Tensor</code>, <code>object</code>, a nested tuple/list/dictionary of <code>torch.Tensor</code>, or a nested tuple/list/dictionary of <code>object</code>) &#x2014;
The tensors or objects for calculating metrics across all processes`,name:"input"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2161"}}),Jt=new C({props:{anchor:"accelerate.Accelerator.gather_for_metrics.example",$$slots:{default:[_d]},$$scope:{ctx:_}}}),bs=new k({props:{name:"get_state_dict",anchor:"accelerate.Accelerator.get_state_dict",parameters:[{name:"model",val:""},{name:"unwrap",val:" = True"}],parametersDescription:[{anchor:"accelerate.Accelerator.get_state_dict.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
A PyTorch model sent through <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">Accelerator.prepare()</a>`,name:"model"},{anchor:"accelerate.Accelerator.get_state_dict.unwrap",description:`<strong>unwrap</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to return the original underlying state_dict of <code>model</code> or to return the wrapped state_dict`,name:"unwrap"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L3015",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The state dictionary of the model potentially without full precision.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>dict</code></p>
`}}),Tt=new C({props:{anchor:"accelerate.Accelerator.get_state_dict.example",$$slots:{default:[vd]},$$scope:{ctx:_}}}),$s=new k({props:{name:"get_tracker",anchor:"accelerate.Accelerator.get_tracker",parameters:[{name:"name",val:": str"},{name:"unwrap",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.Accelerator.get_tracker.name",description:`<strong>name</strong> (<code>str</code>) &#x2014;
The name of a tracker, corresponding to the <code>.name</code> property.`,name:"name"},{anchor:"accelerate.Accelerator.get_tracker.unwrap",description:`<strong>unwrap</strong> (<code>bool</code>) &#x2014;
Whether to return the internal tracking mechanism or to return the wrapped tracker instead
(recommended).`,name:"unwrap"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2398",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The tracker corresponding to <code>name</code> if it exists.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>GeneralTracker</code></p>
`}}),Ut=new C({props:{anchor:"accelerate.Accelerator.get_tracker.example",$$slots:{default:[Jd]},$$scope:{ctx:_}}}),ys=new k({props:{name:"join_uneven_inputs",anchor:"accelerate.Accelerator.join_uneven_inputs",parameters:[{name:"joinables",val:""},{name:"even_batches",val:" = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.join_uneven_inputs.joinables",description:`<strong>joinables</strong> (<code>list[torch.distributed.algorithms.Joinable]</code>) &#x2014;
A list of models or optimizers that subclass <code>torch.distributed.algorithms.Joinable</code>. Most commonly, a
PyTorch Module that was prepared with <code>Accelerator.prepare</code> for DistributedDataParallel training.`,name:"joinables"},{anchor:"accelerate.Accelerator.join_uneven_inputs.even_batches",description:`<strong>even_batches</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set, this will override the value of <code>even_batches</code> set in the <code>Accelerator</code>. If it is not provided,
the default <code>Accelerator</code> value wil be used.`,name:"even_batches"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1000"}}),xt=new Fe({props:{warning:!0,$$slots:{default:[Td]},$$scope:{ctx:_}}}),Gt=new Fe({props:{warning:!0,$$slots:{default:[Ud]},$$scope:{ctx:_}}}),kt=new C({props:{anchor:"accelerate.Accelerator.join_uneven_inputs.example",$$slots:{default:[xd]},$$scope:{ctx:_}}}),Ms=new k({props:{name:"load_state",anchor:"accelerate.Accelerator.load_state",parameters:[{name:"input_dir",val:": str = None"},{name:"**load_model_func_kwargs",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.load_state.input_dir",description:`<strong>input_dir</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The name of the folder all relevant weights and states were saved in. Can be <code>None</code> if
<code>automatic_checkpoint_naming</code> is used, and will pick up from the latest checkpoint.`,name:"input_dir"},{anchor:"accelerate.Accelerator.load_state.load_model_func_kwargs",description:`<strong>load_model_func_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments for loading model which can be passed to the underlying load function,
such as optional arguments for DeepSpeed&#x2019;s <code>load_checkpoint</code> function or a <code>map_location</code> to load the
model and optimizer on.`,name:"load_model_func_kwargs"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2814"}}),Ct=new Fe({props:{$$slots:{default:[Gd]},$$scope:{ctx:_}}}),It=new C({props:{anchor:"accelerate.Accelerator.load_state.example",$$slots:{default:[kd]},$$scope:{ctx:_}}}),ws=new k({props:{name:"local_main_process_first",anchor:"accelerate.Accelerator.local_main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L829"}}),Zt=new C({props:{anchor:"accelerate.Accelerator.local_main_process_first.example",$$slots:{default:[Cd]},$$scope:{ctx:_}}}),js=new k({props:{name:"main_process_first",anchor:"accelerate.Accelerator.main_process_first",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L807"}}),Bt=new C({props:{anchor:"accelerate.Accelerator.main_process_first.example",$$slots:{default:[Id]},$$scope:{ctx:_}}}),_s=new k({props:{name:"no_sync",anchor:"accelerate.Accelerator.no_sync",parameters:[{name:"model",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.no_sync.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
PyTorch Module that was prepared with <code>Accelerator.prepare</code>`,name:"model"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L851"}}),Wt=new C({props:{anchor:"accelerate.Accelerator.no_sync.example",$$slots:{default:[Zd]},$$scope:{ctx:_}}}),vs=new k({props:{name:"on_last_process",anchor:"accelerate.Accelerator.on_last_process",parameters:[{name:"function",val:": Callable[..., Any]"}],parametersDescription:[{anchor:"accelerate.Accelerator.on_last_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L675"}}),Xt=new C({props:{anchor:"accelerate.Accelerator.on_last_process.example",$$slots:{default:[Bd]},$$scope:{ctx:_}}}),Js=new k({props:{name:"on_local_main_process",anchor:"accelerate.Accelerator.on_local_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.on_local_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L633"}}),Yt=new C({props:{anchor:"accelerate.Accelerator.on_local_main_process.example",$$slots:{default:[Wd]},$$scope:{ctx:_}}}),Ts=new k({props:{name:"on_local_process",anchor:"accelerate.Accelerator.on_local_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"local_process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.on_local_process.function",description:`<strong>function</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.Accelerator.on_local_process.local_process_index",description:`<strong>local_process_index</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The index of the local process on which to run the function.`,name:"local_process_index"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L759"}}),Vt=new C({props:{anchor:"accelerate.Accelerator.on_local_process.example",$$slots:{default:[Xd]},$$scope:{ctx:_}}}),Us=new k({props:{name:"on_main_process",anchor:"accelerate.Accelerator.on_main_process",parameters:[{name:"function",val:": Callable[..., Any] = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.on_main_process.function",description:"<strong>function</strong> (<code>Callable</code>) &#x2014; The function to decorate.",name:"function"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L594"}}),At=new C({props:{anchor:"accelerate.Accelerator.on_main_process.example",$$slots:{default:[Yd]},$$scope:{ctx:_}}}),xs=new k({props:{name:"on_process",anchor:"accelerate.Accelerator.on_process",parameters:[{name:"function",val:": Callable[..., Any] = None"},{name:"process_index",val:": int = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.on_process.function",description:`<strong>function</strong> (<code>Callable</code>, <code>optional</code>) &#x2014;
The function to decorate.`,name:"function"},{anchor:"accelerate.Accelerator.on_process.process_index",description:`<strong>process_index</strong> (<code>int</code>, <code>optional</code>) &#x2014;
The index of the process on which to run the function.`,name:"process_index"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L714"}}),Nt=new C({props:{anchor:"accelerate.Accelerator.on_process.example",$$slots:{default:[Vd]},$$scope:{ctx:_}}}),Gs=new k({props:{name:"pad_across_processes",anchor:"accelerate.Accelerator.pad_across_processes",parameters:[{name:"tensor",val:""},{name:"dim",val:" = 0"},{name:"pad_index",val:" = 0"},{name:"pad_first",val:" = False"}],parametersDescription:[{anchor:"accelerate.Accelerator.pad_across_processes.tensor",description:`<strong>tensor</strong> (nested list/tuple/dictionary of <code>torch.Tensor</code>) &#x2014;
The data to gather.`,name:"tensor"},{anchor:"accelerate.Accelerator.pad_across_processes.dim",description:`<strong>dim</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The dimension on which to pad.`,name:"dim"},{anchor:"accelerate.Accelerator.pad_across_processes.pad_index",description:`<strong>pad_index</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
The value with which to pad.`,name:"pad_index"},{anchor:"accelerate.Accelerator.pad_across_processes.pad_first",description:`<strong>pad_first</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to pad at the beginning or the end.`,name:"pad_first"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2259",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The padded tensor(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code>, or a nested tuple/list/dictionary of <code>torch.Tensor</code></p>
`}}),Qt=new C({props:{anchor:"accelerate.Accelerator.pad_across_processes.example",$$slots:{default:[Ad]},$$scope:{ctx:_}}}),ks=new k({props:{name:"prepare",anchor:"accelerate.Accelerator.prepare",parameters:[{name:"*args",val:""},{name:"device_placement",val:" = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.prepare.*args",description:`<strong>*args</strong> (list of objects) &#x2014;
Any of the following type of objects:</p>
<ul>
<li><code>torch.utils.data.DataLoader</code>: PyTorch Dataloader</li>
<li><code>torch.nn.Module</code>: PyTorch Module</li>
<li><code>torch.optim.Optimizer</code>: PyTorch Optimizer</li>
<li><code>torch.optim.lr_scheduler.LRScheduler</code>: PyTorch LR Scheduler</li>
</ul>`,name:"*args"},{anchor:"accelerate.Accelerator.prepare.device_placement",description:`<strong>device_placement</strong> (<code>list[bool]</code>, <em>optional</em>) &#x2014;
Used to customize whether automatic device placement should be performed for each object passed. Needs
to be a list of the same length as <code>args</code>. Not compatible with DeepSpeed or FSDP.`,name:"device_placement"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1115"}}),Ft=new Fe({props:{$$slots:{default:[Nd]},$$scope:{ctx:_}}}),zt=new C({props:{anchor:"accelerate.Accelerator.prepare.example",$$slots:{default:[Qd]},$$scope:{ctx:_}}}),Rt=new C({props:{anchor:"accelerate.Accelerator.prepare.example-2",$$slots:{default:[Fd]},$$scope:{ctx:_}}}),Cs=new k({props:{name:"prepare_data_loader",anchor:"accelerate.Accelerator.prepare_data_loader",parameters:[{name:"data_loader",val:": torch.utils.data.DataLoader"},{name:"device_placement",val:" = None"},{name:"slice_fn_for_dispatch",val:" = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.prepare_data_loader.data_loader",description:`<strong>data_loader</strong> (<code>torch.utils.data.DataLoader</code>) &#x2014;
A vanilla PyTorch DataLoader to prepare`,name:"data_loader"},{anchor:"accelerate.Accelerator.prepare_data_loader.device_placement",description:`<strong>device_placement</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to place the batches on the proper device in the prepared dataloader. Will default to
<code>self.device_placement</code>.`,name:"device_placement"},{anchor:"accelerate.Accelerator.prepare_data_loader.slice_fn_for_dispatch",description:"<strong>slice_fn_for_dispatch</strong> (<code>Callable</code>, <em>optional</em><code>) -- If passed, this function will be used to slice tensors across </code>num_processes<code>. Will default to [slice_tensors()](/docs/accelerate/main/en/package_reference/utilities#accelerate.utils.slice_tensors). This argument is used only when </code>dispatch_batches<code>is set to</code>True` and will\nbe ignored otherwise.",name:"slice_fn_for_dispatch"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1810"}}),St=new C({props:{anchor:"accelerate.Accelerator.prepare_data_loader.example",$$slots:{default:[zd]},$$scope:{ctx:_}}}),Is=new k({props:{name:"prepare_model",anchor:"accelerate.Accelerator.prepare_model",parameters:[{name:"model",val:": torch.nn.Module"},{name:"device_placement",val:": bool = None"},{name:"evaluation_mode",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.Accelerator.prepare_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
A PyTorch model to prepare. You don&#x2019;t need to prepare a model if it is used only for inference without
any kind of mixed precision`,name:"model"},{anchor:"accelerate.Accelerator.prepare_model.device_placement",description:`<strong>device_placement</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to place the model on the proper device. Will default to <code>self.device_placement</code>.`,name:"device_placement"},{anchor:"accelerate.Accelerator.prepare_model.evaluation_mode",description:`<strong>evaluation_mode</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to set the model for evaluation only, by just applying mixed precision and
<code>torch.compile</code> (if configured in the <code>Accelerator</code> object).`,name:"evaluation_mode"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1251"}}),Et=new C({props:{anchor:"accelerate.Accelerator.prepare_model.example",$$slots:{default:[Rd]},$$scope:{ctx:_}}}),Zs=new k({props:{name:"prepare_optimizer",anchor:"accelerate.Accelerator.prepare_optimizer",parameters:[{name:"optimizer",val:": torch.optim.Optimizer"},{name:"device_placement",val:" = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.prepare_optimizer.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code>) &#x2014;
A vanilla PyTorch optimizer to prepare`,name:"optimizer"},{anchor:"accelerate.Accelerator.prepare_optimizer.device_placement",description:`<strong>device_placement</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to place the optimizer on the proper device. Will default to <code>self.device_placement</code>.`,name:"device_placement"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1862"}}),Ht=new C({props:{anchor:"accelerate.Accelerator.prepare_optimizer.example",$$slots:{default:[Sd]},$$scope:{ctx:_}}}),Bs=new k({props:{name:"prepare_scheduler",anchor:"accelerate.Accelerator.prepare_scheduler",parameters:[{name:"scheduler",val:": LRScheduler"}],parametersDescription:[{anchor:"accelerate.Accelerator.prepare_scheduler.scheduler",description:`<strong>scheduler</strong> (<code>torch.optim.lr_scheduler.LRScheduler</code>) &#x2014;
A vanilla PyTorch scheduler to prepare`,name:"scheduler"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1895"}}),Lt=new C({props:{anchor:"accelerate.Accelerator.prepare_scheduler.example",$$slots:{default:[Ed]},$$scope:{ctx:_}}}),Ws=new k({props:{name:"print",anchor:"accelerate.Accelerator.print",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1083"}}),Pt=new C({props:{anchor:"accelerate.Accelerator.print.example",$$slots:{default:[Hd]},$$scope:{ctx:_}}}),Xs=new k({props:{name:"reduce",anchor:"accelerate.Accelerator.reduce",parameters:[{name:"tensor",val:""},{name:"reduction",val:" = 'sum'"},{name:"scale",val:" = 1.0"}],parametersDescription:[{anchor:"accelerate.Accelerator.reduce.tensor",description:`<strong>tensor</strong> (<code>torch.Tensor</code>, or a nested tuple/list/dictionary of <code>torch.Tensor</code>) &#x2014;
The tensors to reduce across all processes.`,name:"tensor"},{anchor:"accelerate.Accelerator.reduce.reduction",description:`<strong>reduction</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;sum&#x201D;) &#x2014;
A reduction type, can be one of &#x2018;sum&#x2019;, &#x2018;mean&#x2019;, or &#x2018;none&#x2019;. If &#x2018;none&#x2019;, will not perform any operation.`,name:"reduction"},{anchor:"accelerate.Accelerator.reduce.scale",description:`<strong>scale</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014;
A default scaling value to be applied after the reduce, only valied on XLA.`,name:"scale"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2223",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The reduced tensor(s).</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code>, or a nested tuple/list/dictionary of <code>torch.Tensor</code></p>
`}}),Dt=new C({props:{anchor:"accelerate.Accelerator.reduce.example",$$slots:{default:[Ld]},$$scope:{ctx:_}}}),Ys=new k({props:{name:"register_for_checkpointing",anchor:"accelerate.Accelerator.register_for_checkpointing",parameters:[{name:"*objects",val:""}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L3071"}}),Kt=new Fe({props:{$$slots:{default:[Pd]},$$scope:{ctx:_}}}),qt=new C({props:{anchor:"accelerate.Accelerator.register_for_checkpointing.example",$$slots:{default:[Dd]},$$scope:{ctx:_}}}),Vs=new k({props:{name:"register_load_state_pre_hook",anchor:"accelerate.Accelerator.register_load_state_pre_hook",parameters:[{name:"hook",val:": Callable[(Ellipsis, None)]"}],parametersDescription:[{anchor:"accelerate.Accelerator.register_load_state_pre_hook.hook",description:`<strong>hook</strong> (<code>Callable</code>) &#x2014;
A function to be called in <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.load_state">Accelerator.load_state()</a> before <code>load_checkpoint</code>.`,name:"hook"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2783",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a handle that can be used to remove the added hook by calling
<code>handle.remove()</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.hooks.RemovableHandle</code></p>
`}}),Ot=new Fe({props:{$$slots:{default:[Kd]},$$scope:{ctx:_}}}),As=new k({props:{name:"register_save_state_pre_hook",anchor:"accelerate.Accelerator.register_save_state_pre_hook",parameters:[{name:"hook",val:": Callable[(Ellipsis, None)]"}],parametersDescription:[{anchor:"accelerate.Accelerator.register_save_state_pre_hook.hook",description:`<strong>hook</strong> (<code>Callable</code>) &#x2014;
A function to be called in <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.save_state">Accelerator.save_state()</a> before <code>save_checkpoint</code>.`,name:"hook"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2617",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>a handle that can be used to remove the added hook by calling
<code>handle.remove()</code></p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.utils.hooks.RemovableHandle</code></p>
`}}),ea=new Fe({props:{$$slots:{default:[qd]},$$scope:{ctx:_}}}),Ns=new k({props:{name:"save",anchor:"accelerate.Accelerator.save",parameters:[{name:"obj",val:""},{name:"f",val:""},{name:"safe_serialization",val:" = False"}],parametersDescription:[{anchor:"accelerate.Accelerator.save.obj",description:"<strong>obj</strong> (<code>object</code>) &#x2014; The object to save.",name:"obj"},{anchor:"accelerate.Accelerator.save.f",description:"<strong>f</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014; Where to save the content of <code>obj</code>.",name:"f"},{anchor:"accelerate.Accelerator.save.safe_serialization",description:"<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to save <code>obj</code> using <code>safetensors</code>",name:"safe_serialization"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2480"}}),ta=new C({props:{anchor:"accelerate.Accelerator.save.example",$$slots:{default:[Od]},$$scope:{ctx:_}}}),Qs=new k({props:{name:"save_model",anchor:"accelerate.Accelerator.save_model",parameters:[{name:"model",val:": torch.nn.Module"},{name:"save_directory",val:": Union[str, os.PathLike]"},{name:"max_shard_size",val:": Union[int, str] = '10GB'"},{name:"safe_serialization",val:": bool = True"}],parametersDescription:[{anchor:"accelerate.Accelerator.save_model.save_directory",description:`<strong>save_directory</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
Directory to which to save. Will be created if it doesn&#x2019;t exist.`,name:"save_directory"},{anchor:"accelerate.Accelerator.save_model.max_shard_size",description:`<strong>max_shard_size</strong> (<code>int</code> or <code>str</code>, <em>optional</em>, defaults to <code>&quot;10GB&quot;</code>) &#x2014;
The maximum size for a checkpoint before being sharded. Checkpoints shard will then be each of size
lower than this size. If expressed as a string, needs to be digits followed by a unit (like <code>&quot;5MB&quot;</code>).</p>
<div class="course-tip course-tip-orange bg-gradient-to-br dark:bg-gradient-to-r before:border-orange-500 dark:before:border-orange-800 from-orange-50 dark:from-gray-900 to-white dark:to-gray-950 border border-orange-50 text-orange-700 dark:text-gray-400">
						
<p>If a single weight of the model is bigger than <code>max_shard_size</code>, it will be in its own checkpoint shard
which will be bigger than <code>max_shard_size</code>.</p>

					</div>`,name:"max_shard_size"},{anchor:"accelerate.Accelerator.save_model.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way (that uses <code>pickle</code>).`,name:"safe_serialization"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2510"}}),aa=new C({props:{anchor:"accelerate.Accelerator.save_model.example",$$slots:{default:[em]},$$scope:{ctx:_}}}),Fs=new k({props:{name:"save_state",anchor:"accelerate.Accelerator.save_state",parameters:[{name:"output_dir",val:": str = None"},{name:"safe_serialization",val:": bool = True"},{name:"**save_model_func_kwargs",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.save_state.output_dir",description:`<strong>output_dir</strong> (<code>str</code> or <code>os.PathLike</code>) &#x2014;
The name of the folder to save all relevant weights and states.`,name:"output_dir"},{anchor:"accelerate.Accelerator.save_state.safe_serialization",description:`<strong>safe_serialization</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to save the model using <code>safetensors</code> or the traditional PyTorch way (that uses <code>pickle</code>).`,name:"safe_serialization"},{anchor:"accelerate.Accelerator.save_state.save_model_func_kwargs",description:`<strong>save_model_func_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
Additional keyword arguments for saving model which can be passed to the underlying save function, such
as optional arguments for DeepSpeed&#x2019;s <code>save_checkpoint</code> function.`,name:"save_model_func_kwargs"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2649"}}),sa=new Fe({props:{$$slots:{default:[tm]},$$scope:{ctx:_}}}),la=new C({props:{anchor:"accelerate.Accelerator.save_state.example",$$slots:{default:[am]},$$scope:{ctx:_}}}),zs=new k({props:{name:"set_trigger",anchor:"accelerate.Accelerator.set_trigger",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L1966"}}),ra=new C({props:{anchor:"accelerate.Accelerator.set_trigger.example",$$slots:{default:[sm]},$$scope:{ctx:_}}}),Rs=new k({props:{name:"skip_first_batches",anchor:"accelerate.Accelerator.skip_first_batches",parameters:[{name:"dataloader",val:""},{name:"num_batches",val:": int = 0"}],parametersDescription:[{anchor:"accelerate.Accelerator.skip_first_batches.dataloader",description:"<strong>dataloader</strong> (<code>torch.utils.data.DataLoader</code>) &#x2014; The data loader in which to skip batches.",name:"dataloader"},{anchor:"accelerate.Accelerator.skip_first_batches.num_batches",description:"<strong>num_batches</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The number of batches to skip",name:"num_batches"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L3154"}}),na=new C({props:{anchor:"accelerate.Accelerator.skip_first_batches.example",$$slots:{default:[lm]},$$scope:{ctx:_}}}),Ss=new k({props:{name:"split_between_processes",anchor:"accelerate.Accelerator.split_between_processes",parameters:[{name:"inputs",val:": list | tuple | dict | torch.Tensor"},{name:"apply_padding",val:": bool = False"}],parametersDescription:[{anchor:"accelerate.Accelerator.split_between_processes.inputs",description:`<strong>inputs</strong> (<code>list</code>, <code>tuple</code>, <code>torch.Tensor</code>, or <code>dict</code> of <code>list</code>/<code>tuple</code>/<code>torch.Tensor</code>) &#x2014;
The input to split between processes.`,name:"inputs"},{anchor:"accelerate.Accelerator.split_between_processes.apply_padding",description:`<strong>apply_padding</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>False</code>) &#x2014;
Whether to apply padding by repeating the last element of the input so that all processes have the same
number of elements. Useful when trying to perform actions such as <code>Accelerator.gather()</code> on the outputs
or passing in less inputs than there are processes. If so, just remember to drop the padded elements
afterwards.`,name:"apply_padding"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L552"}}),ca=new C({props:{anchor:"accelerate.Accelerator.split_between_processes.example",$$slots:{default:[rm]},$$scope:{ctx:_}}}),Es=new k({props:{name:"trigger_sync_in_backward",anchor:"accelerate.Accelerator.trigger_sync_in_backward",parameters:[{name:"model",val:""}],parametersDescription:[{anchor:"accelerate.Accelerator.trigger_sync_in_backward.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model for which to trigger the gradient synchronization.`,name:"model"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L892"}}),oa=new C({props:{anchor:"accelerate.Accelerator.trigger_sync_in_backward.example",$$slots:{default:[nm]},$$scope:{ctx:_}}}),Hs=new k({props:{name:"unscale_gradients",anchor:"accelerate.Accelerator.unscale_gradients",parameters:[{name:"optimizer",val:" = None"}],parametersDescription:[{anchor:"accelerate.Accelerator.unscale_gradients.optimizer",description:`<strong>optimizer</strong> (<code>torch.optim.Optimizer</code> or <code>list[torch.optim.Optimizer]</code>, <em>optional</em>) &#x2014;
The optimizer(s) for which to unscale gradients. If not set, will unscale gradients on all optimizers
that were passed to <a href="/docs/accelerate/main/en/package_reference/accelerator#accelerate.Accelerator.prepare">prepare()</a>.`,name:"optimizer"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2025"}}),pa=new C({props:{anchor:"accelerate.Accelerator.unscale_gradients.example",$$slots:{default:[cm]},$$scope:{ctx:_}}}),Ls=new k({props:{name:"unwrap_model",anchor:"accelerate.Accelerator.unwrap_model",parameters:[{name:"model",val:""},{name:"keep_fp32_wrapper",val:": bool = True"}],parametersDescription:[{anchor:"accelerate.Accelerator.unwrap_model.model",description:`<strong>model</strong> (<code>torch.nn.Module</code>) &#x2014;
The model to unwrap.`,name:"model"},{anchor:"accelerate.Accelerator.unwrap_model.keep_fp32_wrapper",description:`<strong>keep_fp32_wrapper</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to not remove the mixed precision hook if it was added.`,name:"keep_fp32_wrapper"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2294",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The unwrapped model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.nn.Module</code></p>
`}}),ia=new C({props:{anchor:"accelerate.Accelerator.unwrap_model.example",$$slots:{default:[om]},$$scope:{ctx:_}}}),Ps=new k({props:{name:"verify_device_map",anchor:"accelerate.Accelerator.verify_device_map",parameters:[{name:"model",val:": torch.nn.Module"}],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L3190"}}),Ds=new k({props:{name:"wait_for_everyone",anchor:"accelerate.Accelerator.wait_for_everyone",parameters:[],source:"https://github.com/huggingface/accelerate/blob/main/src/accelerate/accelerator.py#L2327"}}),ma=new C({props:{anchor:"accelerate.Accelerator.wait_for_everyone.example",$$slots:{default:[pm]},$$scope:{ctx:_}}}),{c(){a=d("meta"),w=n(),l=d("p"),s=n(),u(i.$$.fragment),e=n(),h=d("p"),h.innerHTML=yp,fr=n(),u(ha.$$.fragment),br=n(),ga=d("p"),ga.textContent=Mp,$r=n(),ua=d("ol"),ua.innerHTML=wp,yr=n(),u(ht.$$.fragment),Mr=n(),gt=d("ol"),gt.innerHTML=jp,wr=n(),u(ut.$$.fragment),jr=n(),fa=d("p"),fa.innerHTML=_p,_r=n(),u(ba.$$.fragment),vr=n(),u($a.$$.fragment),Jr=n(),ya=d("p"),ya.innerHTML=vp,Tr=n(),u(Ma.$$.fragment),Ur=n(),u(wa.$$.fragment),xr=n(),u(ja.$$.fragment),Gr=n(),_a=d("p"),_a.innerHTML=Jp,kr=n(),u(va.$$.fragment),Cr=n(),Ja=d("p"),Ja.innerHTML=Tp,Ir=n(),u(Ta.$$.fragment),Zr=n(),u(Ua.$$.fragment),Br=n(),xa=d("p"),xa.innerHTML=Up,Wr=n(),u(Ga.$$.fragment),Xr=n(),ka=d("p"),ka.innerHTML=xp,Yr=n(),u(Ca.$$.fragment),Vr=n(),u(Ia.$$.fragment),Ar=n(),Za=d("p"),Za.textContent=Gp,Nr=n(),u(Ba.$$.fragment),Qr=n(),u(Wa.$$.fragment),Fr=n(),u(Xa.$$.fragment),zr=n(),Ya=d("p"),Ya.innerHTML=kp,Rr=n(),u(Va.$$.fragment),Sr=n(),u(Aa.$$.fragment),Er=n(),Na=d("p"),Na.innerHTML=Cp,Hr=n(),u(Qa.$$.fragment),Lr=n(),Fa=d("p"),Fa.innerHTML=Ip,Pr=n(),u(za.$$.fragment),Dr=n(),u(Ra.$$.fragment),Kr=n(),Sa=d("p"),Sa.innerHTML=Zp,qr=n(),u(Ea.$$.fragment),Or=n(),Ha=d("p"),Ha.innerHTML=Bp,en=n(),u(La.$$.fragment),tn=n(),u(Pa.$$.fragment),an=n(),Da=d("p"),Da.innerHTML=Wp,sn=n(),u(Ka.$$.fragment),ln=n(),qa=d("p"),qa.innerHTML=Xp,rn=n(),u(Oa.$$.fragment),nn=n(),u(es.$$.fragment),cn=n(),ze=d("div"),u(ts.$$.fragment),fn=n(),Os=d("p"),Os.textContent=Yp,on=n(),as=d("p"),as.innerHTML=Vp,pn=n(),u(ss.$$.fragment),dn=n(),ls=d("p"),ls.textContent=Ap,mn=n(),u(rs.$$.fragment),hn=n(),v=d("div"),u(ns.$$.fragment),bn=n(),el=d("p"),el.textContent=Np,$n=n(),tl=d("p"),tl.innerHTML=Qp,yn=n(),al=d("ul"),al.innerHTML=Fp,Mn=n(),ye=d("div"),u(cs.$$.fragment),wn=n(),sl=d("p"),sl.textContent=zp,jn=n(),u(ft.$$.fragment),_n=n(),S=d("div"),u(os.$$.fragment),vn=n(),ll=d("p"),ll.textContent=Rp,Jn=n(),rl=d("p"),rl.innerHTML=Sp,Tn=n(),u(bt.$$.fragment),Un=n(),E=d("div"),u(ps.$$.fragment),xn=n(),nl=d("p"),nl.innerHTML=Ep,Gn=n(),cl=d("p"),cl.innerHTML=Hp,kn=n(),u($t.$$.fragment),Cn=n(),H=d("div"),u(is.$$.fragment),In=n(),ol=d("p"),ol.innerHTML=Lp,Zn=n(),pl=d("p"),pl.innerHTML=Pp,Bn=n(),u(yt.$$.fragment),Wn=n(),Me=d("div"),u(ds.$$.fragment),Xn=n(),il=d("p"),il.innerHTML=Dp,Yn=n(),u(Mt.$$.fragment),Vn=n(),we=d("div"),u(ms.$$.fragment),An=n(),dl=d("p"),dl.innerHTML=Kp,Nn=n(),u(wt.$$.fragment),Qn=n(),je=d("div"),u(hs.$$.fragment),Fn=n(),ml=d("p"),ml.innerHTML=qp,zn=n(),u(jt.$$.fragment),Rn=n(),_e=d("div"),u(gs.$$.fragment),Sn=n(),hl=d("p"),hl.innerHTML=Op,En=n(),u(_t.$$.fragment),Hn=n(),L=d("div"),u(us.$$.fragment),Ln=n(),gl=d("p"),gl.innerHTML=ei,Pn=n(),ul=d("p"),ul.textContent=ti,Dn=n(),u(vt.$$.fragment),Kn=n(),ve=d("div"),u(fs.$$.fragment),qn=n(),fl=d("p"),fl.innerHTML=ai,On=n(),u(Jt.$$.fragment),ec=n(),Je=d("div"),u(bs.$$.fragment),tc=n(),bl=d("p"),bl.innerHTML=si,ac=n(),u(Tt.$$.fragment),sc=n(),Te=d("div"),u($s.$$.fragment),lc=n(),$l=d("p"),$l.innerHTML=li,rc=n(),u(Ut.$$.fragment),nc=n(),A=d("div"),u(ys.$$.fragment),cc=n(),yl=d("p"),yl.innerHTML=ri,oc=n(),u(xt.$$.fragment),pc=n(),u(Gt.$$.fragment),ic=n(),u(kt.$$.fragment),dc=n(),P=d("div"),u(Ms.$$.fragment),mc=n(),Ml=d("p"),Ml.textContent=ni,hc=n(),u(Ct.$$.fragment),gc=n(),u(It.$$.fragment),uc=n(),D=d("div"),u(ws.$$.fragment),fc=n(),wl=d("p"),wl.textContent=ci,bc=n(),jl=d("p"),jl.textContent=oi,$c=n(),u(Zt.$$.fragment),yc=n(),K=d("div"),u(js.$$.fragment),Mc=n(),_l=d("p"),_l.textContent=pi,wc=n(),vl=d("p"),vl.textContent=ii,jc=n(),u(Bt.$$.fragment),_c=n(),q=d("div"),u(_s.$$.fragment),vc=n(),Jl=d("p"),Jl.innerHTML=di,Jc=n(),Tl=d("p"),Tl.innerHTML=mi,Tc=n(),u(Wt.$$.fragment),Uc=n(),Ue=d("div"),u(vs.$$.fragment),xc=n(),Ul=d("p"),Ul.innerHTML=hi,Gc=n(),u(Xt.$$.fragment),kc=n(),xe=d("div"),u(Js.$$.fragment),Cc=n(),xl=d("p"),xl.innerHTML=gi,Ic=n(),u(Yt.$$.fragment),Zc=n(),Ge=d("div"),u(Ts.$$.fragment),Bc=n(),Gl=d("p"),Gl.innerHTML=ui,Wc=n(),u(Vt.$$.fragment),Xc=n(),ke=d("div"),u(Us.$$.fragment),Yc=n(),kl=d("p"),kl.innerHTML=fi,Vc=n(),u(At.$$.fragment),Ac=n(),Ce=d("div"),u(xs.$$.fragment),Nc=n(),Cl=d("p"),Cl.innerHTML=bi,Qc=n(),u(Nt.$$.fragment),Fc=n(),Ie=d("div"),u(Gs.$$.fragment),zc=n(),Il=d("p"),Il.textContent=$i,Rc=n(),u(Qt.$$.fragment),Sc=n(),N=d("div"),u(ks.$$.fragment),Ec=n(),Zl=d("p"),Zl.innerHTML=yi,Hc=n(),u(Ft.$$.fragment),Lc=n(),u(zt.$$.fragment),Pc=n(),u(Rt.$$.fragment),Dc=n(),Ze=d("div"),u(Cs.$$.fragment),Kc=n(),Bl=d("p"),Bl.innerHTML=Mi,qc=n(),u(St.$$.fragment),Oc=n(),Be=d("div"),u(Is.$$.fragment),eo=n(),Wl=d("p"),Wl.innerHTML=wi,to=n(),u(Et.$$.fragment),ao=n(),We=d("div"),u(Zs.$$.fragment),so=n(),Xl=d("p"),Xl.innerHTML=ji,lo=n(),u(Ht.$$.fragment),ro=n(),Xe=d("div"),u(Bs.$$.fragment),no=n(),Yl=d("p"),Yl.innerHTML=_i,co=n(),u(Lt.$$.fragment),oo=n(),Ye=d("div"),u(Ws.$$.fragment),po=n(),Vl=d("p"),Vl.innerHTML=vi,io=n(),u(Pt.$$.fragment),mo=n(),O=d("div"),u(Xs.$$.fragment),ho=n(),Al=d("p"),Al.innerHTML=Ji,go=n(),Nl=d("p"),Nl.textContent=Ti,uo=n(),u(Dt.$$.fragment),fo=n(),Q=d("div"),u(Ys.$$.fragment),bo=n(),Ql=d("p"),Ql.innerHTML=Ui,$o=n(),Fl=d("p"),Fl.textContent=xi,yo=n(),u(Kt.$$.fragment),Mo=n(),u(qt.$$.fragment),wo=n(),I=d("div"),u(Vs.$$.fragment),jo=n(),zl=d("p"),zl.innerHTML=Gi,_o=n(),Rl=d("p"),Rl.textContent=ki,vo=n(),Sl=d("p"),Sl.innerHTML=Ci,Jo=n(),El=d("p"),El.innerHTML=Ii,To=n(),u(Ot.$$.fragment),Uo=n(),Z=d("div"),u(As.$$.fragment),xo=n(),Hl=d("p"),Hl.innerHTML=Zi,Go=n(),Ll=d("p"),Ll.textContent=Bi,ko=n(),Pl=d("p"),Pl.innerHTML=Wi,Co=n(),Dl=d("p"),Dl.innerHTML=Xi,Io=n(),u(ea.$$.fragment),Zo=n(),ee=d("div"),u(Ns.$$.fragment),Bo=n(),Kl=d("p"),Kl.innerHTML=Yi,Wo=n(),ql=d("p"),ql.innerHTML=Vi,Xo=n(),u(ta.$$.fragment),Yo=n(),Ve=d("div"),u(Qs.$$.fragment),Vo=n(),Ol=d("p"),Ol.textContent=Ai,Ao=n(),u(aa.$$.fragment),No=n(),B=d("div"),u(Fs.$$.fragment),Qo=n(),er=d("p"),er.textContent=Ni,Fo=n(),tr=d("p"),tr.innerHTML=Qi,zo=n(),ar=d("p"),ar.innerHTML=Fi,Ro=n(),u(sa.$$.fragment),So=n(),u(la.$$.fragment),Eo=n(),te=d("div"),u(zs.$$.fragment),Ho=n(),sr=d("p"),sr.textContent=zi,Lo=n(),lr=d("p"),lr.innerHTML=Ri,Po=n(),u(ra.$$.fragment),Do=n(),Ae=d("div"),u(Rs.$$.fragment),Ko=n(),rr=d("p"),rr.innerHTML=Si,qo=n(),u(na.$$.fragment),Oo=n(),ae=d("div"),u(Ss.$$.fragment),ep=n(),nr=d("p"),nr.innerHTML=Ei,tp=n(),cr=d("p"),cr.innerHTML=Hi,ap=n(),u(ca.$$.fragment),sp=n(),se=d("div"),u(Es.$$.fragment),lp=n(),or=d("p"),or.innerHTML=Li,rp=n(),pr=d("p"),pr.textContent=Pi,np=n(),u(oa.$$.fragment),cp=n(),le=d("div"),u(Hs.$$.fragment),op=n(),ir=d("p"),ir.textContent=Di,pp=n(),dr=d("p"),dr.innerHTML=Ki,ip=n(),u(pa.$$.fragment),dp=n(),Ne=d("div"),u(Ls.$$.fragment),mp=n(),mr=d("p"),mr.innerHTML=qi,hp=n(),u(ia.$$.fragment),gp=n(),da=d("div"),u(Ps.$$.fragment),up=n(),hr=d("p"),hr.innerHTML=Oi,fp=n(),Qe=d("div"),u(Ds.$$.fragment),bp=n(),gr=d("p"),gr.textContent=ed,$p=n(),u(ma.$$.fragment),gn=n(),ur=d("p"),this.h()},l(t){const p=dd("svelte-u9bgzb",document.head);a=m(p,"META",{name:!0,content:!0}),p.forEach(o),w=c(t),l=m(t,"P",{}),G(l).forEach(o),s=c(t),f(i.$$.fragment,t),e=c(t),h=m(t,"P",{"data-svelte-h":!0}),j(h)!=="svelte-cemb9d"&&(h.innerHTML=yp),fr=c(t),f(ha.$$.fragment,t),br=c(t),ga=m(t,"P",{"data-svelte-h":!0}),j(ga)!=="svelte-zyh6k2"&&(ga.textContent=Mp),$r=c(t),ua=m(t,"OL",{"data-svelte-h":!0}),j(ua)!=="svelte-su1fxe"&&(ua.innerHTML=wp),yr=c(t),f(ht.$$.fragment,t),Mr=c(t),gt=m(t,"OL",{start:!0,"data-svelte-h":!0}),j(gt)!=="svelte-kv3hn3"&&(gt.innerHTML=jp),wr=c(t),f(ut.$$.fragment,t),jr=c(t),fa=m(t,"P",{"data-svelte-h":!0}),j(fa)!=="svelte-1cnnfm8"&&(fa.innerHTML=_p),_r=c(t),f(ba.$$.fragment,t),vr=c(t),f($a.$$.fragment,t),Jr=c(t),ya=m(t,"P",{"data-svelte-h":!0}),j(ya)!=="svelte-1s1nm2c"&&(ya.innerHTML=vp),Tr=c(t),f(Ma.$$.fragment,t),Ur=c(t),f(wa.$$.fragment,t),xr=c(t),f(ja.$$.fragment,t),Gr=c(t),_a=m(t,"P",{"data-svelte-h":!0}),j(_a)!=="svelte-vu3b82"&&(_a.innerHTML=Jp),kr=c(t),f(va.$$.fragment,t),Cr=c(t),Ja=m(t,"P",{"data-svelte-h":!0}),j(Ja)!=="svelte-ghe6e9"&&(Ja.innerHTML=Tp),Ir=c(t),f(Ta.$$.fragment,t),Zr=c(t),f(Ua.$$.fragment,t),Br=c(t),xa=m(t,"P",{"data-svelte-h":!0}),j(xa)!=="svelte-wtfac6"&&(xa.innerHTML=Up),Wr=c(t),f(Ga.$$.fragment,t),Xr=c(t),ka=m(t,"P",{"data-svelte-h":!0}),j(ka)!=="svelte-1ptrxb5"&&(ka.innerHTML=xp),Yr=c(t),f(Ca.$$.fragment,t),Vr=c(t),f(Ia.$$.fragment,t),Ar=c(t),Za=m(t,"P",{"data-svelte-h":!0}),j(Za)!=="svelte-15y70nu"&&(Za.textContent=Gp),Nr=c(t),f(Ba.$$.fragment,t),Qr=c(t),f(Wa.$$.fragment,t),Fr=c(t),f(Xa.$$.fragment,t),zr=c(t),Ya=m(t,"P",{"data-svelte-h":!0}),j(Ya)!=="svelte-1ujrwzw"&&(Ya.innerHTML=kp),Rr=c(t),f(Va.$$.fragment,t),Sr=c(t),f(Aa.$$.fragment,t),Er=c(t),Na=m(t,"P",{"data-svelte-h":!0}),j(Na)!=="svelte-c3zfi4"&&(Na.innerHTML=Cp),Hr=c(t),f(Qa.$$.fragment,t),Lr=c(t),Fa=m(t,"P",{"data-svelte-h":!0}),j(Fa)!=="svelte-1qa15ze"&&(Fa.innerHTML=Ip),Pr=c(t),f(za.$$.fragment,t),Dr=c(t),f(Ra.$$.fragment,t),Kr=c(t),Sa=m(t,"P",{"data-svelte-h":!0}),j(Sa)!=="svelte-knfull"&&(Sa.innerHTML=Zp),qr=c(t),f(Ea.$$.fragment,t),Or=c(t),Ha=m(t,"P",{"data-svelte-h":!0}),j(Ha)!=="svelte-1vm8s4w"&&(Ha.innerHTML=Bp),en=c(t),f(La.$$.fragment,t),tn=c(t),f(Pa.$$.fragment,t),an=c(t),Da=m(t,"P",{"data-svelte-h":!0}),j(Da)!=="svelte-pl0os"&&(Da.innerHTML=Wp),sn=c(t),f(Ka.$$.fragment,t),ln=c(t),qa=m(t,"P",{"data-svelte-h":!0}),j(qa)!=="svelte-15w2bno"&&(qa.innerHTML=Xp),rn=c(t),f(Oa.$$.fragment,t),nn=c(t),f(es.$$.fragment,t),cn=c(t),ze=m(t,"DIV",{class:!0});var Ks=G(ze);f(ts.$$.fragment,Ks),fn=c(Ks),Os=m(Ks,"P",{"data-svelte-h":!0}),j(Os)!=="svelte-24nung"&&(Os.textContent=Yp),Ks.forEach(o),on=c(t),as=m(t,"P",{"data-svelte-h":!0}),j(as)!=="svelte-tg3dha"&&(as.innerHTML=Vp),pn=c(t),f(ss.$$.fragment,t),dn=c(t),ls=m(t,"P",{"data-svelte-h":!0}),j(ls)!=="svelte-1rjishh"&&(ls.textContent=Ap),mn=c(t),f(rs.$$.fragment,t),hn=c(t),v=m(t,"DIV",{class:!0});var J=G(v);f(ns.$$.fragment,J),bn=c(J),el=m(J,"P",{"data-svelte-h":!0}),j(el)!=="svelte-1j60yg5"&&(el.textContent=Np),$n=c(J),tl=m(J,"P",{"data-svelte-h":!0}),j(tl)!=="svelte-17v1xbv"&&(tl.innerHTML=Qp),yn=c(J),al=m(J,"UL",{"data-svelte-h":!0}),j(al)!=="svelte-1830bw3"&&(al.innerHTML=Fp),Mn=c(J),ye=m(J,"DIV",{class:!0});var Re=G(ye);f(cs.$$.fragment,Re),wn=c(Re),sl=m(Re,"P",{"data-svelte-h":!0}),j(sl)!=="svelte-hhq3cw"&&(sl.textContent=zp),jn=c(Re),f(ft.$$.fragment,Re),Re.forEach(o),_n=c(J),S=m(J,"DIV",{class:!0});var re=G(S);f(os.$$.fragment,re),vn=c(re),ll=m(re,"P",{"data-svelte-h":!0}),j(ll)!=="svelte-1to22fk"&&(ll.textContent=Rp),Jn=c(re),rl=m(re,"P",{"data-svelte-h":!0}),j(rl)!=="svelte-2z45q2"&&(rl.innerHTML=Sp),Tn=c(re),f(bt.$$.fragment,re),re.forEach(o),Un=c(J),E=m(J,"DIV",{class:!0});var ne=G(E);f(ps.$$.fragment,ne),xn=c(ne),nl=m(ne,"P",{"data-svelte-h":!0}),j(nl)!=="svelte-1k83amz"&&(nl.innerHTML=Ep),Gn=c(ne),cl=m(ne,"P",{"data-svelte-h":!0}),j(cl)!=="svelte-3qeaqc"&&(cl.innerHTML=Hp),kn=c(ne),f($t.$$.fragment,ne),ne.forEach(o),Cn=c(J),H=m(J,"DIV",{class:!0});var ce=G(H);f(is.$$.fragment,ce),In=c(ce),ol=m(ce,"P",{"data-svelte-h":!0}),j(ol)!=="svelte-m17ioq"&&(ol.innerHTML=Lp),Zn=c(ce),pl=m(ce,"P",{"data-svelte-h":!0}),j(pl)!=="svelte-h6tcr2"&&(pl.innerHTML=Pp),Bn=c(ce),f(yt.$$.fragment,ce),ce.forEach(o),Wn=c(J),Me=m(J,"DIV",{class:!0});var Se=G(Me);f(ds.$$.fragment,Se),Xn=c(Se),il=m(Se,"P",{"data-svelte-h":!0}),j(il)!=="svelte-bl1ihw"&&(il.innerHTML=Dp),Yn=c(Se),f(Mt.$$.fragment,Se),Se.forEach(o),Vn=c(J),we=m(J,"DIV",{class:!0});var Ee=G(we);f(ms.$$.fragment,Ee),An=c(Ee),dl=m(Ee,"P",{"data-svelte-h":!0}),j(dl)!=="svelte-1w1177v"&&(dl.innerHTML=Kp),Nn=c(Ee),f(wt.$$.fragment,Ee),Ee.forEach(o),Qn=c(J),je=m(J,"DIV",{class:!0});var He=G(je);f(hs.$$.fragment,He),Fn=c(He),ml=m(He,"P",{"data-svelte-h":!0}),j(ml)!=="svelte-1rffb4m"&&(ml.innerHTML=qp),zn=c(He),f(jt.$$.fragment,He),He.forEach(o),Rn=c(J),_e=m(J,"DIV",{class:!0});var Le=G(_e);f(gs.$$.fragment,Le),Sn=c(Le),hl=m(Le,"P",{"data-svelte-h":!0}),j(hl)!=="svelte-iw017b"&&(hl.innerHTML=Op),En=c(Le),f(_t.$$.fragment,Le),Le.forEach(o),Hn=c(J),L=m(J,"DIV",{class:!0});var oe=G(L);f(us.$$.fragment,oe),Ln=c(oe),gl=m(oe,"P",{"data-svelte-h":!0}),j(gl)!=="svelte-c0v2dv"&&(gl.innerHTML=ei),Pn=c(oe),ul=m(oe,"P",{"data-svelte-h":!0}),j(ul)!=="svelte-1ap3exf"&&(ul.textContent=ti),Dn=c(oe),f(vt.$$.fragment,oe),oe.forEach(o),Kn=c(J),ve=m(J,"DIV",{class:!0});var Pe=G(ve);f(fs.$$.fragment,Pe),qn=c(Pe),fl=m(Pe,"P",{"data-svelte-h":!0}),j(fl)!=="svelte-19l0og1"&&(fl.innerHTML=ai),On=c(Pe),f(Jt.$$.fragment,Pe),Pe.forEach(o),ec=c(J),Je=m(J,"DIV",{class:!0});var De=G(Je);f(bs.$$.fragment,De),tc=c(De),bl=m(De,"P",{"data-svelte-h":!0}),j(bl)!=="svelte-4sbmnk"&&(bl.innerHTML=si),ac=c(De),f(Tt.$$.fragment,De),De.forEach(o),sc=c(J),Te=m(J,"DIV",{class:!0});var Ke=G(Te);f($s.$$.fragment,Ke),lc=c(Ke),$l=m(Ke,"P",{"data-svelte-h":!0}),j($l)!=="svelte-vacsyv"&&($l.innerHTML=li),rc=c(Ke),f(Ut.$$.fragment,Ke),Ke.forEach(o),nc=c(J),A=m(J,"DIV",{class:!0});var F=G(A);f(ys.$$.fragment,F),cc=c(F),yl=m(F,"P",{"data-svelte-h":!0}),j(yl)!=="svelte-hlem7e"&&(yl.innerHTML=ri),oc=c(F),f(xt.$$.fragment,F),pc=c(F),f(Gt.$$.fragment,F),ic=c(F),f(kt.$$.fragment,F),F.forEach(o),dc=c(J),P=m(J,"DIV",{class:!0});var pe=G(P);f(Ms.$$.fragment,pe),mc=c(pe),Ml=m(pe,"P",{"data-svelte-h":!0}),j(Ml)!=="svelte-1kjfoov"&&(Ml.textContent=ni),hc=c(pe),f(Ct.$$.fragment,pe),gc=c(pe),f(It.$$.fragment,pe),pe.forEach(o),uc=c(J),D=m(J,"DIV",{class:!0});var ie=G(D);f(ws.$$.fragment,ie),fc=c(ie),wl=m(ie,"P",{"data-svelte-h":!0}),j(wl)!=="svelte-1xrqyx2"&&(wl.textContent=ci),bc=c(ie),jl=m(ie,"P",{"data-svelte-h":!0}),j(jl)!=="svelte-144ycie"&&(jl.textContent=oi),$c=c(ie),f(Zt.$$.fragment,ie),ie.forEach(o),yc=c(J),K=m(J,"DIV",{class:!0});var de=G(K);f(js.$$.fragment,de),Mc=c(de),_l=m(de,"P",{"data-svelte-h":!0}),j(_l)!=="svelte-f40x3x"&&(_l.textContent=pi),wc=c(de),vl=m(de,"P",{"data-svelte-h":!0}),j(vl)!=="svelte-144ycie"&&(vl.textContent=ii),jc=c(de),f(Bt.$$.fragment,de),de.forEach(o),_c=c(J),q=m(J,"DIV",{class:!0});var me=G(q);f(_s.$$.fragment,me),vc=c(me),Jl=m(me,"P",{"data-svelte-h":!0}),j(Jl)!=="svelte-1g6bbp3"&&(Jl.innerHTML=di),Jc=c(me),Tl=m(me,"P",{"data-svelte-h":!0}),j(Tl)!=="svelte-g65bbp"&&(Tl.innerHTML=mi),Tc=c(me),f(Wt.$$.fragment,me),me.forEach(o),Uc=c(J),Ue=m(J,"DIV",{class:!0});var qe=G(Ue);f(vs.$$.fragment,qe),xc=c(qe),Ul=m(qe,"P",{"data-svelte-h":!0}),j(Ul)!=="svelte-dzayl0"&&(Ul.innerHTML=hi),Gc=c(qe),f(Xt.$$.fragment,qe),qe.forEach(o),kc=c(J),xe=m(J,"DIV",{class:!0});var Oe=G(xe);f(Js.$$.fragment,Oe),Cc=c(Oe),xl=m(Oe,"P",{"data-svelte-h":!0}),j(xl)!=="svelte-56q7i0"&&(xl.innerHTML=gi),Ic=c(Oe),f(Yt.$$.fragment,Oe),Oe.forEach(o),Zc=c(J),Ge=m(J,"DIV",{class:!0});var et=G(Ge);f(Ts.$$.fragment,et),Bc=c(et),Gl=m(et,"P",{"data-svelte-h":!0}),j(Gl)!=="svelte-1c2pa3e"&&(Gl.innerHTML=ui),Wc=c(et),f(Vt.$$.fragment,et),et.forEach(o),Xc=c(J),ke=m(J,"DIV",{class:!0});var tt=G(ke);f(Us.$$.fragment,tt),Yc=c(tt),kl=m(tt,"P",{"data-svelte-h":!0}),j(kl)!=="svelte-1bxst4n"&&(kl.innerHTML=fi),Vc=c(tt),f(At.$$.fragment,tt),tt.forEach(o),Ac=c(J),Ce=m(J,"DIV",{class:!0});var at=G(Ce);f(xs.$$.fragment,at),Nc=c(at),Cl=m(at,"P",{"data-svelte-h":!0}),j(Cl)!=="svelte-gt9ih5"&&(Cl.innerHTML=bi),Qc=c(at),f(Nt.$$.fragment,at),at.forEach(o),Fc=c(J),Ie=m(J,"DIV",{class:!0});var st=G(Ie);f(Gs.$$.fragment,st),zc=c(st),Il=m(st,"P",{"data-svelte-h":!0}),j(Il)!=="svelte-1mfhnhh"&&(Il.textContent=$i),Rc=c(st),f(Qt.$$.fragment,st),st.forEach(o),Sc=c(J),N=m(J,"DIV",{class:!0});var z=G(N);f(ks.$$.fragment,z),Ec=c(z),Zl=m(z,"P",{"data-svelte-h":!0}),j(Zl)!=="svelte-90g1bo"&&(Zl.innerHTML=yi),Hc=c(z),f(Ft.$$.fragment,z),Lc=c(z),f(zt.$$.fragment,z),Pc=c(z),f(Rt.$$.fragment,z),z.forEach(o),Dc=c(J),Ze=m(J,"DIV",{class:!0});var lt=G(Ze);f(Cs.$$.fragment,lt),Kc=c(lt),Bl=m(lt,"P",{"data-svelte-h":!0}),j(Bl)!=="svelte-jtaqq6"&&(Bl.innerHTML=Mi),qc=c(lt),f(St.$$.fragment,lt),lt.forEach(o),Oc=c(J),Be=m(J,"DIV",{class:!0});var rt=G(Be);f(Is.$$.fragment,rt),eo=c(rt),Wl=m(rt,"P",{"data-svelte-h":!0}),j(Wl)!=="svelte-1ipttjs"&&(Wl.innerHTML=wi),to=c(rt),f(Et.$$.fragment,rt),rt.forEach(o),ao=c(J),We=m(J,"DIV",{class:!0});var nt=G(We);f(Zs.$$.fragment,nt),so=c(nt),Xl=m(nt,"P",{"data-svelte-h":!0}),j(Xl)!=="svelte-1ilbfbi"&&(Xl.innerHTML=ji),lo=c(nt),f(Ht.$$.fragment,nt),nt.forEach(o),ro=c(J),Xe=m(J,"DIV",{class:!0});var ct=G(Xe);f(Bs.$$.fragment,ct),no=c(ct),Yl=m(ct,"P",{"data-svelte-h":!0}),j(Yl)!=="svelte-lcda6w"&&(Yl.innerHTML=_i),co=c(ct),f(Lt.$$.fragment,ct),ct.forEach(o),oo=c(J),Ye=m(J,"DIV",{class:!0});var ot=G(Ye);f(Ws.$$.fragment,ot),po=c(ot),Vl=m(ot,"P",{"data-svelte-h":!0}),j(Vl)!=="svelte-1fwzii1"&&(Vl.innerHTML=vi),io=c(ot),f(Pt.$$.fragment,ot),ot.forEach(o),mo=c(J),O=m(J,"DIV",{class:!0});var he=G(O);f(Xs.$$.fragment,he),ho=c(he),Al=m(he,"P",{"data-svelte-h":!0}),j(Al)!=="svelte-1lyv8gx"&&(Al.innerHTML=Ji),go=c(he),Nl=m(he,"P",{"data-svelte-h":!0}),j(Nl)!=="svelte-12bh3zw"&&(Nl.textContent=Ti),uo=c(he),f(Dt.$$.fragment,he),he.forEach(o),fo=c(J),Q=m(J,"DIV",{class:!0});var R=G(Q);f(Ys.$$.fragment,R),bo=c(R),Ql=m(R,"P",{"data-svelte-h":!0}),j(Ql)!=="svelte-1yy42cg"&&(Ql.innerHTML=Ui),$o=c(R),Fl=m(R,"P",{"data-svelte-h":!0}),j(Fl)!=="svelte-x6uu8"&&(Fl.textContent=xi),yo=c(R),f(Kt.$$.fragment,R),Mo=c(R),f(qt.$$.fragment,R),R.forEach(o),wo=c(J),I=m(J,"DIV",{class:!0});var W=G(I);f(Vs.$$.fragment,W),jo=c(W),zl=m(W,"P",{"data-svelte-h":!0}),j(zl)!=="svelte-r9fsru"&&(zl.innerHTML=Gi),_o=c(W),Rl=m(W,"P",{"data-svelte-h":!0}),j(Rl)!=="svelte-14qme5z"&&(Rl.textContent=ki),vo=c(W),Sl=m(W,"P",{"data-svelte-h":!0}),j(Sl)!=="svelte-ljm1ur"&&(Sl.innerHTML=Ci),Jo=c(W),El=m(W,"P",{"data-svelte-h":!0}),j(El)!=="svelte-80yz6h"&&(El.innerHTML=Ii),To=c(W),f(Ot.$$.fragment,W),W.forEach(o),Uo=c(J),Z=m(J,"DIV",{class:!0});var X=G(Z);f(As.$$.fragment,X),xo=c(X),Hl=m(X,"P",{"data-svelte-h":!0}),j(Hl)!=="svelte-1pt2ddf"&&(Hl.innerHTML=Zi),Go=c(X),Ll=m(X,"P",{"data-svelte-h":!0}),j(Ll)!=="svelte-14qme5z"&&(Ll.textContent=Bi),ko=c(X),Pl=m(X,"P",{"data-svelte-h":!0}),j(Pl)!=="svelte-ze4wea"&&(Pl.innerHTML=Wi),Co=c(X),Dl=m(X,"P",{"data-svelte-h":!0}),j(Dl)!=="svelte-hsjn5i"&&(Dl.innerHTML=Xi),Io=c(X),f(ea.$$.fragment,X),X.forEach(o),Zo=c(J),ee=m(J,"DIV",{class:!0});var ge=G(ee);f(Ns.$$.fragment,ge),Bo=c(ge),Kl=m(ge,"P",{"data-svelte-h":!0}),j(Kl)!=="svelte-16eiqks"&&(Kl.innerHTML=Yi),Wo=c(ge),ql=m(ge,"P",{"data-svelte-h":!0}),j(ql)!=="svelte-4i4kmd"&&(ql.innerHTML=Vi),Xo=c(ge),f(ta.$$.fragment,ge),ge.forEach(o),Yo=c(J),Ve=m(J,"DIV",{class:!0});var pt=G(Ve);f(Qs.$$.fragment,pt),Vo=c(pt),Ol=m(pt,"P",{"data-svelte-h":!0}),j(Ol)!=="svelte-onu98y"&&(Ol.textContent=Ai),Ao=c(pt),f(aa.$$.fragment,pt),pt.forEach(o),No=c(J),B=m(J,"DIV",{class:!0});var Y=G(B);f(Fs.$$.fragment,Y),Qo=c(Y),er=m(Y,"P",{"data-svelte-h":!0}),j(er)!=="svelte-1v72nnm"&&(er.textContent=Ni),Fo=c(Y),tr=m(Y,"P",{"data-svelte-h":!0}),j(tr)!=="svelte-1i5ld38"&&(tr.innerHTML=Qi),zo=c(Y),ar=m(Y,"P",{"data-svelte-h":!0}),j(ar)!=="svelte-13o3ok4"&&(ar.innerHTML=Fi),Ro=c(Y),f(sa.$$.fragment,Y),So=c(Y),f(la.$$.fragment,Y),Y.forEach(o),Eo=c(J),te=m(J,"DIV",{class:!0});var ue=G(te);f(zs.$$.fragment,ue),Ho=c(ue),sr=m(ue,"P",{"data-svelte-h":!0}),j(sr)!=="svelte-1bgx6cf"&&(sr.textContent=zi),Lo=c(ue),lr=m(ue,"P",{"data-svelte-h":!0}),j(lr)!=="svelte-h6tcr2"&&(lr.innerHTML=Ri),Po=c(ue),f(ra.$$.fragment,ue),ue.forEach(o),Do=c(J),Ae=m(J,"DIV",{class:!0});var it=G(Ae);f(Rs.$$.fragment,it),Ko=c(it),rr=m(it,"P",{"data-svelte-h":!0}),j(rr)!=="svelte-9m10k"&&(rr.innerHTML=Si),qo=c(it),f(na.$$.fragment,it),it.forEach(o),Oo=c(J),ae=m(J,"DIV",{class:!0});var fe=G(ae);f(Ss.$$.fragment,fe),ep=c(fe),nr=m(fe,"P",{"data-svelte-h":!0}),j(nr)!=="svelte-xr05jy"&&(nr.innerHTML=Ei),tp=c(fe),cr=m(fe,"P",{"data-svelte-h":!0}),j(cr)!=="svelte-hvuw2l"&&(cr.innerHTML=Hi),ap=c(fe),f(ca.$$.fragment,fe),fe.forEach(o),sp=c(J),se=m(J,"DIV",{class:!0});var be=G(se);f(Es.$$.fragment,be),lp=c(be),or=m(be,"P",{"data-svelte-h":!0}),j(or)!=="svelte-111j6q2"&&(or.innerHTML=Li),rp=c(be),pr=m(be,"P",{"data-svelte-h":!0}),j(pr)!=="svelte-obux0l"&&(pr.textContent=Pi),np=c(be),f(oa.$$.fragment,be),be.forEach(o),cp=c(J),le=m(J,"DIV",{class:!0});var $e=G(le);f(Hs.$$.fragment,$e),op=c($e),ir=m($e,"P",{"data-svelte-h":!0}),j(ir)!=="svelte-1w117kr"&&(ir.textContent=Di),pp=c($e),dr=m($e,"P",{"data-svelte-h":!0}),j(dr)!=="svelte-1l7ede9"&&(dr.innerHTML=Ki),ip=c($e),f(pa.$$.fragment,$e),$e.forEach(o),dp=c(J),Ne=m(J,"DIV",{class:!0});var dt=G(Ne);f(Ls.$$.fragment,dt),mp=c(dt),mr=m(dt,"P",{"data-svelte-h":!0}),j(mr)!=="svelte-180l03j"&&(mr.innerHTML=qi),hp=c(dt),f(ia.$$.fragment,dt),dt.forEach(o),gp=c(J),da=m(J,"DIV",{class:!0});var qs=G(da);f(Ps.$$.fragment,qs),up=c(qs),hr=m(qs,"P",{"data-svelte-h":!0}),j(hr)!=="svelte-1ml1a9c"&&(hr.innerHTML=Oi),qs.forEach(o),fp=c(J),Qe=m(J,"DIV",{class:!0});var mt=G(Qe);f(Ds.$$.fragment,mt),bp=c(mt),gr=m(mt,"P",{"data-svelte-h":!0}),j(gr)!=="svelte-tmafbn"&&(gr.textContent=ed),$p=c(mt),f(ma.$$.fragment,mt),mt.forEach(o),J.forEach(o),gn=c(t),ur=m(t,"P",{}),G(ur).forEach(o),this.h()},h(){x(a,"name","hf:doc:metadata"),x(a,"content",dm),x(gt,"start","4"),x(ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(we,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(We,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(da,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),x(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,p){r(document.head,a),g(t,w,p),g(t,l,p),g(t,s,p),b(i,t,p),g(t,e,p),g(t,h,p),g(t,fr,p),b(ha,t,p),g(t,br,p),g(t,ga,p),g(t,$r,p),g(t,ua,p),g(t,yr,p),b(ht,t,p),g(t,Mr,p),g(t,gt,p),g(t,wr,p),b(ut,t,p),g(t,jr,p),g(t,fa,p),g(t,_r,p),b(ba,t,p),g(t,vr,p),b($a,t,p),g(t,Jr,p),g(t,ya,p),g(t,Tr,p),b(Ma,t,p),g(t,Ur,p),b(wa,t,p),g(t,xr,p),b(ja,t,p),g(t,Gr,p),g(t,_a,p),g(t,kr,p),b(va,t,p),g(t,Cr,p),g(t,Ja,p),g(t,Ir,p),b(Ta,t,p),g(t,Zr,p),b(Ua,t,p),g(t,Br,p),g(t,xa,p),g(t,Wr,p),b(Ga,t,p),g(t,Xr,p),g(t,ka,p),g(t,Yr,p),b(Ca,t,p),g(t,Vr,p),b(Ia,t,p),g(t,Ar,p),g(t,Za,p),g(t,Nr,p),b(Ba,t,p),g(t,Qr,p),b(Wa,t,p),g(t,Fr,p),b(Xa,t,p),g(t,zr,p),g(t,Ya,p),g(t,Rr,p),b(Va,t,p),g(t,Sr,p),b(Aa,t,p),g(t,Er,p),g(t,Na,p),g(t,Hr,p),b(Qa,t,p),g(t,Lr,p),g(t,Fa,p),g(t,Pr,p),b(za,t,p),g(t,Dr,p),b(Ra,t,p),g(t,Kr,p),g(t,Sa,p),g(t,qr,p),b(Ea,t,p),g(t,Or,p),g(t,Ha,p),g(t,en,p),b(La,t,p),g(t,tn,p),b(Pa,t,p),g(t,an,p),g(t,Da,p),g(t,sn,p),b(Ka,t,p),g(t,ln,p),g(t,qa,p),g(t,rn,p),b(Oa,t,p),g(t,nn,p),b(es,t,p),g(t,cn,p),g(t,ze,p),b(ts,ze,null),r(ze,fn),r(ze,Os),g(t,on,p),g(t,as,p),g(t,pn,p),b(ss,t,p),g(t,dn,p),g(t,ls,p),g(t,mn,p),b(rs,t,p),g(t,hn,p),g(t,v,p),b(ns,v,null),r(v,bn),r(v,el),r(v,$n),r(v,tl),r(v,yn),r(v,al),r(v,Mn),r(v,ye),b(cs,ye,null),r(ye,wn),r(ye,sl),r(ye,jn),b(ft,ye,null),r(v,_n),r(v,S),b(os,S,null),r(S,vn),r(S,ll),r(S,Jn),r(S,rl),r(S,Tn),b(bt,S,null),r(v,Un),r(v,E),b(ps,E,null),r(E,xn),r(E,nl),r(E,Gn),r(E,cl),r(E,kn),b($t,E,null),r(v,Cn),r(v,H),b(is,H,null),r(H,In),r(H,ol),r(H,Zn),r(H,pl),r(H,Bn),b(yt,H,null),r(v,Wn),r(v,Me),b(ds,Me,null),r(Me,Xn),r(Me,il),r(Me,Yn),b(Mt,Me,null),r(v,Vn),r(v,we),b(ms,we,null),r(we,An),r(we,dl),r(we,Nn),b(wt,we,null),r(v,Qn),r(v,je),b(hs,je,null),r(je,Fn),r(je,ml),r(je,zn),b(jt,je,null),r(v,Rn),r(v,_e),b(gs,_e,null),r(_e,Sn),r(_e,hl),r(_e,En),b(_t,_e,null),r(v,Hn),r(v,L),b(us,L,null),r(L,Ln),r(L,gl),r(L,Pn),r(L,ul),r(L,Dn),b(vt,L,null),r(v,Kn),r(v,ve),b(fs,ve,null),r(ve,qn),r(ve,fl),r(ve,On),b(Jt,ve,null),r(v,ec),r(v,Je),b(bs,Je,null),r(Je,tc),r(Je,bl),r(Je,ac),b(Tt,Je,null),r(v,sc),r(v,Te),b($s,Te,null),r(Te,lc),r(Te,$l),r(Te,rc),b(Ut,Te,null),r(v,nc),r(v,A),b(ys,A,null),r(A,cc),r(A,yl),r(A,oc),b(xt,A,null),r(A,pc),b(Gt,A,null),r(A,ic),b(kt,A,null),r(v,dc),r(v,P),b(Ms,P,null),r(P,mc),r(P,Ml),r(P,hc),b(Ct,P,null),r(P,gc),b(It,P,null),r(v,uc),r(v,D),b(ws,D,null),r(D,fc),r(D,wl),r(D,bc),r(D,jl),r(D,$c),b(Zt,D,null),r(v,yc),r(v,K),b(js,K,null),r(K,Mc),r(K,_l),r(K,wc),r(K,vl),r(K,jc),b(Bt,K,null),r(v,_c),r(v,q),b(_s,q,null),r(q,vc),r(q,Jl),r(q,Jc),r(q,Tl),r(q,Tc),b(Wt,q,null),r(v,Uc),r(v,Ue),b(vs,Ue,null),r(Ue,xc),r(Ue,Ul),r(Ue,Gc),b(Xt,Ue,null),r(v,kc),r(v,xe),b(Js,xe,null),r(xe,Cc),r(xe,xl),r(xe,Ic),b(Yt,xe,null),r(v,Zc),r(v,Ge),b(Ts,Ge,null),r(Ge,Bc),r(Ge,Gl),r(Ge,Wc),b(Vt,Ge,null),r(v,Xc),r(v,ke),b(Us,ke,null),r(ke,Yc),r(ke,kl),r(ke,Vc),b(At,ke,null),r(v,Ac),r(v,Ce),b(xs,Ce,null),r(Ce,Nc),r(Ce,Cl),r(Ce,Qc),b(Nt,Ce,null),r(v,Fc),r(v,Ie),b(Gs,Ie,null),r(Ie,zc),r(Ie,Il),r(Ie,Rc),b(Qt,Ie,null),r(v,Sc),r(v,N),b(ks,N,null),r(N,Ec),r(N,Zl),r(N,Hc),b(Ft,N,null),r(N,Lc),b(zt,N,null),r(N,Pc),b(Rt,N,null),r(v,Dc),r(v,Ze),b(Cs,Ze,null),r(Ze,Kc),r(Ze,Bl),r(Ze,qc),b(St,Ze,null),r(v,Oc),r(v,Be),b(Is,Be,null),r(Be,eo),r(Be,Wl),r(Be,to),b(Et,Be,null),r(v,ao),r(v,We),b(Zs,We,null),r(We,so),r(We,Xl),r(We,lo),b(Ht,We,null),r(v,ro),r(v,Xe),b(Bs,Xe,null),r(Xe,no),r(Xe,Yl),r(Xe,co),b(Lt,Xe,null),r(v,oo),r(v,Ye),b(Ws,Ye,null),r(Ye,po),r(Ye,Vl),r(Ye,io),b(Pt,Ye,null),r(v,mo),r(v,O),b(Xs,O,null),r(O,ho),r(O,Al),r(O,go),r(O,Nl),r(O,uo),b(Dt,O,null),r(v,fo),r(v,Q),b(Ys,Q,null),r(Q,bo),r(Q,Ql),r(Q,$o),r(Q,Fl),r(Q,yo),b(Kt,Q,null),r(Q,Mo),b(qt,Q,null),r(v,wo),r(v,I),b(Vs,I,null),r(I,jo),r(I,zl),r(I,_o),r(I,Rl),r(I,vo),r(I,Sl),r(I,Jo),r(I,El),r(I,To),b(Ot,I,null),r(v,Uo),r(v,Z),b(As,Z,null),r(Z,xo),r(Z,Hl),r(Z,Go),r(Z,Ll),r(Z,ko),r(Z,Pl),r(Z,Co),r(Z,Dl),r(Z,Io),b(ea,Z,null),r(v,Zo),r(v,ee),b(Ns,ee,null),r(ee,Bo),r(ee,Kl),r(ee,Wo),r(ee,ql),r(ee,Xo),b(ta,ee,null),r(v,Yo),r(v,Ve),b(Qs,Ve,null),r(Ve,Vo),r(Ve,Ol),r(Ve,Ao),b(aa,Ve,null),r(v,No),r(v,B),b(Fs,B,null),r(B,Qo),r(B,er),r(B,Fo),r(B,tr),r(B,zo),r(B,ar),r(B,Ro),b(sa,B,null),r(B,So),b(la,B,null),r(v,Eo),r(v,te),b(zs,te,null),r(te,Ho),r(te,sr),r(te,Lo),r(te,lr),r(te,Po),b(ra,te,null),r(v,Do),r(v,Ae),b(Rs,Ae,null),r(Ae,Ko),r(Ae,rr),r(Ae,qo),b(na,Ae,null),r(v,Oo),r(v,ae),b(Ss,ae,null),r(ae,ep),r(ae,nr),r(ae,tp),r(ae,cr),r(ae,ap),b(ca,ae,null),r(v,sp),r(v,se),b(Es,se,null),r(se,lp),r(se,or),r(se,rp),r(se,pr),r(se,np),b(oa,se,null),r(v,cp),r(v,le),b(Hs,le,null),r(le,op),r(le,ir),r(le,pp),r(le,dr),r(le,ip),b(pa,le,null),r(v,dp),r(v,Ne),b(Ls,Ne,null),r(Ne,mp),r(Ne,mr),r(Ne,hp),b(ia,Ne,null),r(v,gp),r(v,da),b(Ps,da,null),r(da,up),r(da,hr),r(v,fp),r(v,Qe),b(Ds,Qe,null),r(Qe,bp),r(Qe,gr),r(Qe,$p),b(ma,Qe,null),g(t,gn,p),g(t,ur,p),un=!0},p(t,[p]){const Ks={};p&2&&(Ks.$$scope={dirty:p,ctx:t}),ht.$set(Ks);const J={};p&2&&(J.$$scope={dirty:p,ctx:t}),ut.$set(J);const Re={};p&2&&(Re.$$scope={dirty:p,ctx:t}),ft.$set(Re);const re={};p&2&&(re.$$scope={dirty:p,ctx:t}),bt.$set(re);const ne={};p&2&&(ne.$$scope={dirty:p,ctx:t}),$t.$set(ne);const ce={};p&2&&(ce.$$scope={dirty:p,ctx:t}),yt.$set(ce);const Se={};p&2&&(Se.$$scope={dirty:p,ctx:t}),Mt.$set(Se);const Ee={};p&2&&(Ee.$$scope={dirty:p,ctx:t}),wt.$set(Ee);const He={};p&2&&(He.$$scope={dirty:p,ctx:t}),jt.$set(He);const Le={};p&2&&(Le.$$scope={dirty:p,ctx:t}),_t.$set(Le);const oe={};p&2&&(oe.$$scope={dirty:p,ctx:t}),vt.$set(oe);const Pe={};p&2&&(Pe.$$scope={dirty:p,ctx:t}),Jt.$set(Pe);const De={};p&2&&(De.$$scope={dirty:p,ctx:t}),Tt.$set(De);const Ke={};p&2&&(Ke.$$scope={dirty:p,ctx:t}),Ut.$set(Ke);const F={};p&2&&(F.$$scope={dirty:p,ctx:t}),xt.$set(F);const pe={};p&2&&(pe.$$scope={dirty:p,ctx:t}),Gt.$set(pe);const ie={};p&2&&(ie.$$scope={dirty:p,ctx:t}),kt.$set(ie);const de={};p&2&&(de.$$scope={dirty:p,ctx:t}),Ct.$set(de);const me={};p&2&&(me.$$scope={dirty:p,ctx:t}),It.$set(me);const qe={};p&2&&(qe.$$scope={dirty:p,ctx:t}),Zt.$set(qe);const Oe={};p&2&&(Oe.$$scope={dirty:p,ctx:t}),Bt.$set(Oe);const et={};p&2&&(et.$$scope={dirty:p,ctx:t}),Wt.$set(et);const tt={};p&2&&(tt.$$scope={dirty:p,ctx:t}),Xt.$set(tt);const at={};p&2&&(at.$$scope={dirty:p,ctx:t}),Yt.$set(at);const st={};p&2&&(st.$$scope={dirty:p,ctx:t}),Vt.$set(st);const z={};p&2&&(z.$$scope={dirty:p,ctx:t}),At.$set(z);const lt={};p&2&&(lt.$$scope={dirty:p,ctx:t}),Nt.$set(lt);const rt={};p&2&&(rt.$$scope={dirty:p,ctx:t}),Qt.$set(rt);const nt={};p&2&&(nt.$$scope={dirty:p,ctx:t}),Ft.$set(nt);const ct={};p&2&&(ct.$$scope={dirty:p,ctx:t}),zt.$set(ct);const ot={};p&2&&(ot.$$scope={dirty:p,ctx:t}),Rt.$set(ot);const he={};p&2&&(he.$$scope={dirty:p,ctx:t}),St.$set(he);const R={};p&2&&(R.$$scope={dirty:p,ctx:t}),Et.$set(R);const W={};p&2&&(W.$$scope={dirty:p,ctx:t}),Ht.$set(W);const X={};p&2&&(X.$$scope={dirty:p,ctx:t}),Lt.$set(X);const ge={};p&2&&(ge.$$scope={dirty:p,ctx:t}),Pt.$set(ge);const pt={};p&2&&(pt.$$scope={dirty:p,ctx:t}),Dt.$set(pt);const Y={};p&2&&(Y.$$scope={dirty:p,ctx:t}),Kt.$set(Y);const ue={};p&2&&(ue.$$scope={dirty:p,ctx:t}),qt.$set(ue);const it={};p&2&&(it.$$scope={dirty:p,ctx:t}),Ot.$set(it);const fe={};p&2&&(fe.$$scope={dirty:p,ctx:t}),ea.$set(fe);const be={};p&2&&(be.$$scope={dirty:p,ctx:t}),ta.$set(be);const $e={};p&2&&($e.$$scope={dirty:p,ctx:t}),aa.$set($e);const dt={};p&2&&(dt.$$scope={dirty:p,ctx:t}),sa.$set(dt);const qs={};p&2&&(qs.$$scope={dirty:p,ctx:t}),la.$set(qs);const mt={};p&2&&(mt.$$scope={dirty:p,ctx:t}),ra.$set(mt);const td={};p&2&&(td.$$scope={dirty:p,ctx:t}),na.$set(td);const ad={};p&2&&(ad.$$scope={dirty:p,ctx:t}),ca.$set(ad);const sd={};p&2&&(sd.$$scope={dirty:p,ctx:t}),oa.$set(sd);const ld={};p&2&&(ld.$$scope={dirty:p,ctx:t}),pa.$set(ld);const rd={};p&2&&(rd.$$scope={dirty:p,ctx:t}),ia.$set(rd);const nd={};p&2&&(nd.$$scope={dirty:p,ctx:t}),ma.$set(nd)},i(t){un||($(i.$$.fragment,t),$(ha.$$.fragment,t),$(ht.$$.fragment,t),$(ut.$$.fragment,t),$(ba.$$.fragment,t),$($a.$$.fragment,t),$(Ma.$$.fragment,t),$(wa.$$.fragment,t),$(ja.$$.fragment,t),$(va.$$.fragment,t),$(Ta.$$.fragment,t),$(Ua.$$.fragment,t),$(Ga.$$.fragment,t),$(Ca.$$.fragment,t),$(Ia.$$.fragment,t),$(Ba.$$.fragment,t),$(Wa.$$.fragment,t),$(Xa.$$.fragment,t),$(Va.$$.fragment,t),$(Aa.$$.fragment,t),$(Qa.$$.fragment,t),$(za.$$.fragment,t),$(Ra.$$.fragment,t),$(Ea.$$.fragment,t),$(La.$$.fragment,t),$(Pa.$$.fragment,t),$(Ka.$$.fragment,t),$(Oa.$$.fragment,t),$(es.$$.fragment,t),$(ts.$$.fragment,t),$(ss.$$.fragment,t),$(rs.$$.fragment,t),$(ns.$$.fragment,t),$(cs.$$.fragment,t),$(ft.$$.fragment,t),$(os.$$.fragment,t),$(bt.$$.fragment,t),$(ps.$$.fragment,t),$($t.$$.fragment,t),$(is.$$.fragment,t),$(yt.$$.fragment,t),$(ds.$$.fragment,t),$(Mt.$$.fragment,t),$(ms.$$.fragment,t),$(wt.$$.fragment,t),$(hs.$$.fragment,t),$(jt.$$.fragment,t),$(gs.$$.fragment,t),$(_t.$$.fragment,t),$(us.$$.fragment,t),$(vt.$$.fragment,t),$(fs.$$.fragment,t),$(Jt.$$.fragment,t),$(bs.$$.fragment,t),$(Tt.$$.fragment,t),$($s.$$.fragment,t),$(Ut.$$.fragment,t),$(ys.$$.fragment,t),$(xt.$$.fragment,t),$(Gt.$$.fragment,t),$(kt.$$.fragment,t),$(Ms.$$.fragment,t),$(Ct.$$.fragment,t),$(It.$$.fragment,t),$(ws.$$.fragment,t),$(Zt.$$.fragment,t),$(js.$$.fragment,t),$(Bt.$$.fragment,t),$(_s.$$.fragment,t),$(Wt.$$.fragment,t),$(vs.$$.fragment,t),$(Xt.$$.fragment,t),$(Js.$$.fragment,t),$(Yt.$$.fragment,t),$(Ts.$$.fragment,t),$(Vt.$$.fragment,t),$(Us.$$.fragment,t),$(At.$$.fragment,t),$(xs.$$.fragment,t),$(Nt.$$.fragment,t),$(Gs.$$.fragment,t),$(Qt.$$.fragment,t),$(ks.$$.fragment,t),$(Ft.$$.fragment,t),$(zt.$$.fragment,t),$(Rt.$$.fragment,t),$(Cs.$$.fragment,t),$(St.$$.fragment,t),$(Is.$$.fragment,t),$(Et.$$.fragment,t),$(Zs.$$.fragment,t),$(Ht.$$.fragment,t),$(Bs.$$.fragment,t),$(Lt.$$.fragment,t),$(Ws.$$.fragment,t),$(Pt.$$.fragment,t),$(Xs.$$.fragment,t),$(Dt.$$.fragment,t),$(Ys.$$.fragment,t),$(Kt.$$.fragment,t),$(qt.$$.fragment,t),$(Vs.$$.fragment,t),$(Ot.$$.fragment,t),$(As.$$.fragment,t),$(ea.$$.fragment,t),$(Ns.$$.fragment,t),$(ta.$$.fragment,t),$(Qs.$$.fragment,t),$(aa.$$.fragment,t),$(Fs.$$.fragment,t),$(sa.$$.fragment,t),$(la.$$.fragment,t),$(zs.$$.fragment,t),$(ra.$$.fragment,t),$(Rs.$$.fragment,t),$(na.$$.fragment,t),$(Ss.$$.fragment,t),$(ca.$$.fragment,t),$(Es.$$.fragment,t),$(oa.$$.fragment,t),$(Hs.$$.fragment,t),$(pa.$$.fragment,t),$(Ls.$$.fragment,t),$(ia.$$.fragment,t),$(Ps.$$.fragment,t),$(Ds.$$.fragment,t),$(ma.$$.fragment,t),un=!0)},o(t){y(i.$$.fragment,t),y(ha.$$.fragment,t),y(ht.$$.fragment,t),y(ut.$$.fragment,t),y(ba.$$.fragment,t),y($a.$$.fragment,t),y(Ma.$$.fragment,t),y(wa.$$.fragment,t),y(ja.$$.fragment,t),y(va.$$.fragment,t),y(Ta.$$.fragment,t),y(Ua.$$.fragment,t),y(Ga.$$.fragment,t),y(Ca.$$.fragment,t),y(Ia.$$.fragment,t),y(Ba.$$.fragment,t),y(Wa.$$.fragment,t),y(Xa.$$.fragment,t),y(Va.$$.fragment,t),y(Aa.$$.fragment,t),y(Qa.$$.fragment,t),y(za.$$.fragment,t),y(Ra.$$.fragment,t),y(Ea.$$.fragment,t),y(La.$$.fragment,t),y(Pa.$$.fragment,t),y(Ka.$$.fragment,t),y(Oa.$$.fragment,t),y(es.$$.fragment,t),y(ts.$$.fragment,t),y(ss.$$.fragment,t),y(rs.$$.fragment,t),y(ns.$$.fragment,t),y(cs.$$.fragment,t),y(ft.$$.fragment,t),y(os.$$.fragment,t),y(bt.$$.fragment,t),y(ps.$$.fragment,t),y($t.$$.fragment,t),y(is.$$.fragment,t),y(yt.$$.fragment,t),y(ds.$$.fragment,t),y(Mt.$$.fragment,t),y(ms.$$.fragment,t),y(wt.$$.fragment,t),y(hs.$$.fragment,t),y(jt.$$.fragment,t),y(gs.$$.fragment,t),y(_t.$$.fragment,t),y(us.$$.fragment,t),y(vt.$$.fragment,t),y(fs.$$.fragment,t),y(Jt.$$.fragment,t),y(bs.$$.fragment,t),y(Tt.$$.fragment,t),y($s.$$.fragment,t),y(Ut.$$.fragment,t),y(ys.$$.fragment,t),y(xt.$$.fragment,t),y(Gt.$$.fragment,t),y(kt.$$.fragment,t),y(Ms.$$.fragment,t),y(Ct.$$.fragment,t),y(It.$$.fragment,t),y(ws.$$.fragment,t),y(Zt.$$.fragment,t),y(js.$$.fragment,t),y(Bt.$$.fragment,t),y(_s.$$.fragment,t),y(Wt.$$.fragment,t),y(vs.$$.fragment,t),y(Xt.$$.fragment,t),y(Js.$$.fragment,t),y(Yt.$$.fragment,t),y(Ts.$$.fragment,t),y(Vt.$$.fragment,t),y(Us.$$.fragment,t),y(At.$$.fragment,t),y(xs.$$.fragment,t),y(Nt.$$.fragment,t),y(Gs.$$.fragment,t),y(Qt.$$.fragment,t),y(ks.$$.fragment,t),y(Ft.$$.fragment,t),y(zt.$$.fragment,t),y(Rt.$$.fragment,t),y(Cs.$$.fragment,t),y(St.$$.fragment,t),y(Is.$$.fragment,t),y(Et.$$.fragment,t),y(Zs.$$.fragment,t),y(Ht.$$.fragment,t),y(Bs.$$.fragment,t),y(Lt.$$.fragment,t),y(Ws.$$.fragment,t),y(Pt.$$.fragment,t),y(Xs.$$.fragment,t),y(Dt.$$.fragment,t),y(Ys.$$.fragment,t),y(Kt.$$.fragment,t),y(qt.$$.fragment,t),y(Vs.$$.fragment,t),y(Ot.$$.fragment,t),y(As.$$.fragment,t),y(ea.$$.fragment,t),y(Ns.$$.fragment,t),y(ta.$$.fragment,t),y(Qs.$$.fragment,t),y(aa.$$.fragment,t),y(Fs.$$.fragment,t),y(sa.$$.fragment,t),y(la.$$.fragment,t),y(zs.$$.fragment,t),y(ra.$$.fragment,t),y(Rs.$$.fragment,t),y(na.$$.fragment,t),y(Ss.$$.fragment,t),y(ca.$$.fragment,t),y(Es.$$.fragment,t),y(oa.$$.fragment,t),y(Hs.$$.fragment,t),y(pa.$$.fragment,t),y(Ls.$$.fragment,t),y(ia.$$.fragment,t),y(Ps.$$.fragment,t),y(Ds.$$.fragment,t),y(ma.$$.fragment,t),un=!1},d(t){t&&(o(w),o(l),o(s),o(e),o(h),o(fr),o(br),o(ga),o($r),o(ua),o(yr),o(Mr),o(gt),o(wr),o(jr),o(fa),o(_r),o(vr),o(Jr),o(ya),o(Tr),o(Ur),o(xr),o(Gr),o(_a),o(kr),o(Cr),o(Ja),o(Ir),o(Zr),o(Br),o(xa),o(Wr),o(Xr),o(ka),o(Yr),o(Vr),o(Ar),o(Za),o(Nr),o(Qr),o(Fr),o(zr),o(Ya),o(Rr),o(Sr),o(Er),o(Na),o(Hr),o(Lr),o(Fa),o(Pr),o(Dr),o(Kr),o(Sa),o(qr),o(Or),o(Ha),o(en),o(tn),o(an),o(Da),o(sn),o(ln),o(qa),o(rn),o(nn),o(cn),o(ze),o(on),o(as),o(pn),o(dn),o(ls),o(mn),o(hn),o(v),o(gn),o(ur)),o(a),M(i,t),M(ha,t),M(ht,t),M(ut,t),M(ba,t),M($a,t),M(Ma,t),M(wa,t),M(ja,t),M(va,t),M(Ta,t),M(Ua,t),M(Ga,t),M(Ca,t),M(Ia,t),M(Ba,t),M(Wa,t),M(Xa,t),M(Va,t),M(Aa,t),M(Qa,t),M(za,t),M(Ra,t),M(Ea,t),M(La,t),M(Pa,t),M(Ka,t),M(Oa,t),M(es,t),M(ts),M(ss,t),M(rs,t),M(ns),M(cs),M(ft),M(os),M(bt),M(ps),M($t),M(is),M(yt),M(ds),M(Mt),M(ms),M(wt),M(hs),M(jt),M(gs),M(_t),M(us),M(vt),M(fs),M(Jt),M(bs),M(Tt),M($s),M(Ut),M(ys),M(xt),M(Gt),M(kt),M(Ms),M(Ct),M(It),M(ws),M(Zt),M(js),M(Bt),M(_s),M(Wt),M(vs),M(Xt),M(Js),M(Yt),M(Ts),M(Vt),M(Us),M(At),M(xs),M(Nt),M(Gs),M(Qt),M(ks),M(Ft),M(zt),M(Rt),M(Cs),M(St),M(Is),M(Et),M(Zs),M(Ht),M(Bs),M(Lt),M(Ws),M(Pt),M(Xs),M(Dt),M(Ys),M(Kt),M(qt),M(Vs),M(Ot),M(As),M(ea),M(Ns),M(ta),M(Qs),M(aa),M(Fs),M(sa),M(la),M(zs),M(ra),M(Rs),M(na),M(Ss),M(ca),M(Es),M(oa),M(Hs),M(pa),M(Ls),M(ia),M(Ps),M(Ds),M(ma)}}}const dm='{"title":"Accelerator","local":"accelerator","sections":[{"title":"Quick adaptation of your code","local":"quick-adaptation-of-your-code","sections":[],"depth":2},{"title":"Advanced recommendations","local":"advanced-recommendations","sections":[{"title":"Printing","local":"printing","sections":[],"depth":3},{"title":"Executing processes","local":"executing-processes","sections":[{"title":"Once on a single server","local":"once-on-a-single-server","sections":[],"depth":4},{"title":"Only ever once across all servers","local":"only-ever-once-across-all-servers","sections":[],"depth":4},{"title":"On specific processes","local":"on-specific-processes","sections":[],"depth":4}],"depth":3},{"title":"Synchronicity control","local":"synchronicity-control","sections":[],"depth":3},{"title":"Saving and loading","local":"saving-and-loading","sections":[{"title":"🤗 Transformers models","local":"-transformers-models","sections":[],"depth":4}],"depth":3},{"title":"Operations","local":"operations","sections":[],"depth":3},{"title":"Gradient Accumulation","local":"gradient-accumulation","sections":[{"title":"GradientAccumulationPlugin","local":"accelerate.utils.GradientAccumulationPlugin","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Overall API documentation:","local":"accelerate.Accelerator","sections":[],"depth":2}],"depth":1}';function mm(_){return od(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Mm extends pd{constructor(a){super(),id(this,a,mm,im,cd,{})}}export{Mm as component};
