import{s as vt,o as Mt,n as Ve}from"../chunks/scheduler.9bc65507.js";import{S as kt,i as $t,g as p,s as i,r as _,A as Ct,h,f as n,c as l,j as de,u as y,x as u,k as ce,l as Pt,y as m,a as r,v as b,d as T,t as w,w as v}from"../chunks/index.707bf1b6.js";import{T as gt}from"../chunks/Tip.c2ecdbf4.js";import{D as Ie}from"../chunks/Docstring.17db21ae.js";import{C as it}from"../chunks/CodeBlock.54a9f38d.js";import{F as xt,M as jt}from"../chunks/Markdown.fef84341.js";import{E as wt}from"../chunks/ExampleCodeBlock.4f515aa9.js";import{H as ee}from"../chunks/Heading.342b1fa6.js";function Jt($){let t,f='The current weights at <a href="https://huggingface.co/microsoft/phi-2" rel="nofollow">microsoft/phi-2</a> are not in proper order to be used with the library model. Until that is resolved, please use <a href="https://huggingface.co/susnato/phi-2" rel="nofollow">susnato/phi-2</a> to load using the library <code>phi</code> model.';return{c(){t=p("p"),t.innerHTML=f},l(a){t=h(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-12m5b1y"&&(t.innerHTML=f)},m(a,c){r(a,t,c)},p:Ve,d(a){a&&n(t)}}}function zt($){let t,f="Example:",a,c,M;return c=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaU1vZGVsJTJDJTIwUGhpQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBoaS0xJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBoaUNvbmZpZy5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRnBoaS0xX2RldiUyMiklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwbW9kZWwlMjBmcm9tJTIwdGhlJTIwY29uZmlndXJhdGlvbiUwQW1vZGVsJTIwJTNEJTIwUGhpTW9kZWwoY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhiModel, PhiConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Phi-1 style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PhiConfig.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){t=p("p"),t.textContent=f,a=i(),_(c.$$.fragment)},l(d){t=h(d,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),a=l(d),y(c.$$.fragment,d)},m(d,k){r(d,t,k),r(d,a,k),b(c,d,k),M=!0},p:Ve,i(d){M||(T(c.$$.fragment,d),M=!0)},o(d){w(c.$$.fragment,d),M=!1},d(d){d&&(n(t),n(a)),v(c,d)}}}function Ft($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=f},l(a){t=h(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,c){r(a,t,c)},p:Ve,d(a){a&&n(t)}}}function It($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=f},l(a){t=h(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,c){r(a,t,c)},p:Ve,d(a){a&&n(t)}}}function Ut($){let t,f="Example:",a,c,M;return c=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGlGb3JDYXVzYWxMTSUwQSUwQW1vZGVsJTIwJTNEJTIwUGhpRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZwaGktMV81X2RldiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGcGhpLTFfNV9kZXYlMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYW4lMjBleGFtcGxlJTIwc2NyaXB0JTIwLiUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMEdlbmVyYXRlJTBBZ2VuZXJhdGVfaWRzJTIwJTNEJTIwbW9kZWwuZ2VuZXJhdGUoaW5wdXRzLmlucHV0X2lkcyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRlX2lkcyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlJTJDJTIwY2xlYW5fdXBfdG9rZW5pemF0aW9uX3NwYWNlcyUzREZhbHNlKSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhiForCausalLM

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForCausalLM.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_5_dev&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_5_dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;This is an example script .&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(inputs.input_ids, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;This is an example script .py file that uses the \`os\` module to create a new directory and write some text to it.\\n\\n\`\`&#x27;</span>`,wrap:!1}}),{c(){t=p("p"),t.textContent=f,a=i(),_(c.$$.fragment)},l(d){t=h(d,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),a=l(d),y(c.$$.fragment,d)},m(d,k){r(d,t,k),r(d,a,k),b(c,d,k),M=!0},p:Ve,i(d){M||(T(c.$$.fragment,d),M=!0)},o(d){w(c.$$.fragment,d),M=!1},d(d){d&&(n(t),n(a)),v(c,d)}}}function Lt($){let t,f=`Most generation-controlling parameters are set in <code>generation_config</code> which, if not passed, will be set to the
model’s default generation configuration. You can override any <code>generation_config</code> by passing the corresponding
parameters to generate(), e.g. <code>.generate(inputs, num_beams=4, do_sample=True)</code>.`,a,c,M=`For an overview of generation strategies and code examples, check out the <a href="../generation_strategies">following
guide</a>.`;return{c(){t=p("p"),t.innerHTML=f,a=i(),c=p("p"),c.innerHTML=M},l(d){t=h(d,"P",{"data-svelte-h":!0}),u(t)!=="svelte-1c5u34l"&&(t.innerHTML=f),a=l(d),c=h(d,"P",{"data-svelte-h":!0}),u(c)!=="svelte-fvlq1g"&&(c.innerHTML=M)},m(d,k){r(d,t,k),r(d,a,k),r(d,c,k)},p:Ve,d(d){d&&(n(t),n(a),n(c))}}}function Zt($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=f},l(a){t=h(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,c){r(a,t,c)},p:Ve,d(a){a&&n(t)}}}function Bt($){let t,f=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){t=p("p"),t.innerHTML=f},l(a){t=h(a,"P",{"data-svelte-h":!0}),u(t)!=="svelte-fincs2"&&(t.innerHTML=f)},m(a,c){r(a,t,c)},p:Ve,d(a){a&&n(t)}}}function Gt($){let t,f="Example:",a,c,M;return c=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQaGlGb3JUb2tlbkNsYXNzaWZpY2F0aW9uJTBBaW1wb3J0JTIwdG9yY2glMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGcGhpLTFfZGV2JTIyKSUwQW1vZGVsJTIwJTNEJTIwUGhpRm9yVG9rZW5DbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRnBoaS0xX2RldiUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTBBJTIwJTIwJTIwJTIwJTIySHVnZ2luZ0ZhY2UlMjBpcyUyMGElMjBjb21wYW55JTIwYmFzZWQlMjBpbiUyMFBhcmlzJTIwYW5kJTIwTmV3JTIwWW9yayUyMiUyQyUyMGFkZF9zcGVjaWFsX3Rva2VucyUzREZhbHNlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUwQSklMEElMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQSUwQXByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKSUwQSUwQSUyMyUyME5vdGUlMjB0aGF0JTIwdG9rZW5zJTIwYXJlJTIwY2xhc3NpZmllZCUyMHJhdGhlciUyMHRoZW4lMjBpbnB1dCUyMHdvcmRzJTIwd2hpY2glMjBtZWFucyUyMHRoYXQlMEElMjMlMjB0aGVyZSUyMG1pZ2h0JTIwYmUlMjBtb3JlJTIwcHJlZGljdGVkJTIwdG9rZW4lMjBjbGFzc2VzJTIwdGhhbiUyMHdvcmRzLiUwQSUyMyUyME11bHRpcGxlJTIwdG9rZW4lMjBjbGFzc2VzJTIwbWlnaHQlMjBhY2NvdW50JTIwZm9yJTIwdGhlJTIwc2FtZSUyMHdvcmQlMEFwcmVkaWN0ZWRfdG9rZW5zX2NsYXNzZXMlMjAlM0QlMjAlNUJtb2RlbC5jb25maWcuaWQybGFiZWwlNUJ0Lml0ZW0oKSU1RCUyMGZvciUyMHQlMjBpbiUyMHByZWRpY3RlZF90b2tlbl9jbGFzc19pZHMlNUIwJTVEJTVEJTBBJTBBbGFiZWxzJTIwJTNEJTIwcHJlZGljdGVkX3Rva2VuX2NsYXNzX2lkcyUwQWxvc3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMGxhYmVscyUzRGxhYmVscykubG9zcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PhiForTokenClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_dev&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForTokenClassification.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;HuggingFace is a company based in Paris and New York&quot;</span>, add_special_tokens=<span class="hljs-literal">False</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_token_class_ids = logits.argmax(-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Note that tokens are classified rather then input words which means that</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># there might be more predicted token classes than words.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Multiple token classes might account for the same word</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_tokens_classes = [model.config.id2label[t.item()] <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> predicted_token_class_ids[<span class="hljs-number">0</span>]]

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = predicted_token_class_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = model(**inputs, labels=labels).loss`,wrap:!1}}),{c(){t=p("p"),t.textContent=f,a=i(),_(c.$$.fragment)},l(d){t=h(d,"P",{"data-svelte-h":!0}),u(t)!=="svelte-11lpom8"&&(t.textContent=f),a=l(d),y(c.$$.fragment,d)},m(d,k){r(d,t,k),r(d,a,k),b(c,d,k),M=!0},p:Ve,i(d){M||(T(c.$$.fragment,d),M=!0)},o(d){w(c.$$.fragment,d),M=!1},d(d){d&&(n(t),n(a)),v(c,d)}}}function Wt($){let t,f,a,c,M,d,k=`The bare Phi Model outputting raw hidden-states without any specific head on top.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xe,H,_t=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Ee,N,yt="Transformer decoder consisting of <em>config.num_hidden_layers</em> layers. Each layer is a <code>PhiDecoderLayer</code>",Re,x,te,pe,Ue,tt='The <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiModel">PhiModel</a> forward method, overrides the <code>__call__</code> special method.',he,me,Le,B,nt,L,G,lt,z,W,dt,ue,Ce='The <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForCausalLM">PhiForCausalLM</a> forward method, overrides the <code>__call__</code> special method.',ct,O,fe,ge,Oe,j,ne,_e,Ze,ot="Generates sequences of token ids for models with a language modeling head.",ye,Q,A,oe,se,C,S,Qe,V,st="The PhiModel with a sequence classification head on top (linear layer).",be,Te,Pe=`<a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> uses the last token in order to do the classification, as other causal models
(e.g. GPT-2) do.`,pt,we,xe=`Since it does classification on the last token, it requires to know the position of the last token. If a
<code>pad_token_id</code> is defined in the configuration, it finds the last token that is not a padding token in each row. If
no <code>pad_token_id</code> is defined, it simply takes the last value in each row of the batch. Since it cannot guess the
padding tokens when <code>inputs_embeds</code> are passed instead of <code>input_ids</code>, it does the same (take the last value in
each row of the batch).`,Ae,X,bt=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Ye,E,Tt=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,De,J,ae,ve,Me,je='The <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForSequenceClassification">PhiForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',ht,Y,D,Je,Be,P,re,F,R,mt=`PhiModel with a token classification head on top (a linear layer on top of the hidden-states output) e.g. for
Named-Entity-Recognition (NER) tasks.`,ze,Ge,ut=`This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Fe,We,ft=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,ie,I,Z,Ke,le,at='The <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiForTokenClassification">PhiForTokenClassification</a> forward method, overrides the <code>__call__</code> special method.',e,s,q,ke,rt;return t=new ee({props:{title:"PhiModel",local:"transformers.PhiModel",headingTag:"h2"}}),c=new Ie({props:{name:"class transformers.PhiModel",anchor:"transformers.PhiModel",parameters:[{name:"config",val:": PhiConfig"}],parametersDescription:[{anchor:"transformers.PhiModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.
config &#x2014; PhiConfig`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L801"}}),te=new Ie({props:{name:"forward",anchor:"transformers.PhiModel.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PhiModel.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiModel.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiModel.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiModel.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiModel.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L832"}}),me=new gt({props:{$$slots:{default:[Ft]},$$scope:{ctx:$}}}),B=new ee({props:{title:"PhiForCausalLM",local:"transformers.PhiForCausalLM",headingTag:"h2"}}),G=new Ie({props:{name:"class transformers.PhiForCausalLM",anchor:"transformers.PhiForCausalLM",parameters:[{name:"config",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L957"}}),W=new Ie({props:{name:"forward",anchor:"transformers.PhiForCausalLM.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PhiForCausalLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiForCausalLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiForCausalLM.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiForCausalLM.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiForCausalLM.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiForCausalLM.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiForCausalLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiForCausalLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiForCausalLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.</p>
<p>Args &#x2014;
labels (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>):
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L994",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig"
>PhiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.CausalLMOutputWithPast"
>transformers.modeling_outputs.CausalLMOutputWithPast</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),O=new gt({props:{$$slots:{default:[It]},$$scope:{ctx:$}}}),ge=new wt({props:{anchor:"transformers.PhiForCausalLM.forward.example",$$slots:{default:[Ut]},$$scope:{ctx:$}}}),ne=new Ie({props:{name:"generate",anchor:"transformers.PhiForCausalLM.generate",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"generation_config",val:": typing.Optional[transformers.generation.configuration_utils.GenerationConfig] = None"},{name:"logits_processor",val:": typing.Optional[transformers.generation.logits_process.LogitsProcessorList] = None"},{name:"stopping_criteria",val:": typing.Optional[transformers.generation.stopping_criteria.StoppingCriteriaList] = None"},{name:"prefix_allowed_tokens_fn",val:": typing.Union[typing.Callable[[int, torch.Tensor], typing.List[int]], NoneType] = None"},{name:"synced_gpus",val:": typing.Optional[bool] = None"},{name:"assistant_model",val:": typing.Optional[ForwardRef('PreTrainedModel')] = None"},{name:"streamer",val:": typing.Optional[ForwardRef('BaseStreamer')] = None"},{name:"negative_prompt_ids",val:": typing.Optional[torch.Tensor] = None"},{name:"negative_prompt_attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhiForCausalLM.generate.inputs",description:`<strong>inputs</strong> (<code>torch.Tensor</code> of varying shape depending on the modality, <em>optional</em>) &#x2014;
The sequence used as a prompt for the generation or as model inputs to the encoder. If <code>None</code> the
method initializes it with <code>bos_token_id</code> and a batch size of 1. For decoder-only models <code>inputs</code>
should of in the format of <code>input_ids</code>. For encoder-decoder models <em>inputs</em> can represent any of
<code>input_ids</code>, <code>input_values</code>, <code>input_features</code>, or <code>pixel_values</code>.`,name:"inputs"},{anchor:"transformers.PhiForCausalLM.generate.generation_config",description:`<strong>generation_config</strong> (<code>~generation.GenerationConfig</code>, <em>optional</em>) &#x2014;
The generation configuration to be used as base parametrization for the generation call. <code>**kwargs</code>
passed to generate matching the attributes of <code>generation_config</code> will override them. If
<code>generation_config</code> is not provided, the default will be used, which had the following loading
priority: 1) from the <code>generation_config.json</code> model file, if it exists; 2) from the model
configuration. Please note that unspecified parameters will inherit <a href="/docs/transformers/main/en/main_classes/text_generation#transformers.GenerationConfig">GenerationConfig</a>&#x2019;s
default values, whose documentation should be checked to parameterize generation.`,name:"generation_config"},{anchor:"transformers.PhiForCausalLM.generate.logits_processor",description:`<strong>logits_processor</strong> (<code>LogitsProcessorList</code>, <em>optional</em>) &#x2014;
Custom logits processors that complement the default logits processors built from arguments and
generation config. If a logit processor is passed that is already created with the arguments or a
generation config an error is thrown. This feature is intended for advanced users.`,name:"logits_processor"},{anchor:"transformers.PhiForCausalLM.generate.stopping_criteria",description:`<strong>stopping_criteria</strong> (<code>StoppingCriteriaList</code>, <em>optional</em>) &#x2014;
Custom stopping criteria that complement the default stopping criteria built from arguments and a
generation config. If a stopping criteria is passed that is already created with the arguments or a
generation config an error is thrown. If your stopping criteria depends on the <code>scores</code> input, make
sure you pass <code>return_dict_in_generate=True, output_scores=True</code> to <code>generate</code>. This feature is
intended for advanced users.`,name:"stopping_criteria"},{anchor:"transformers.PhiForCausalLM.generate.prefix_allowed_tokens_fn",description:`<strong>prefix_allowed_tokens_fn</strong> (<code>Callable[[int, torch.Tensor], List[int]]</code>, <em>optional</em>) &#x2014;
If provided, this function constraints the beam search to allowed tokens only at each step. If not
provided no constraint is applied. This function takes 2 arguments: the batch ID <code>batch_id</code> and
<code>input_ids</code>. It has to return a list with the allowed tokens for the next generation step conditioned
on the batch ID <code>batch_id</code> and the previously generated tokens <code>inputs_ids</code>. This argument is useful
for constrained generation conditioned on the prefix, as described in <a href="https://arxiv.org/abs/2010.00904" rel="nofollow">Autoregressive Entity
Retrieval</a>.`,name:"prefix_allowed_tokens_fn"},{anchor:"transformers.PhiForCausalLM.generate.synced_gpus",description:`<strong>synced_gpus</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to continue running the while loop until max_length. Unless overridden this flag will be set to
<code>True</code> under DeepSpeed ZeRO Stage 3 multiple GPUs environment to avoid hanging if one GPU finished
generating before other GPUs. Otherwise it&#x2019;ll be set to <code>False</code>.`,name:"synced_gpus"},{anchor:"transformers.PhiForCausalLM.generate.assistant_model",description:`<strong>assistant_model</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
An assistant model that can be used to accelerate generation. The assistant model must have the exact
same tokenizer. The acceleration is achieved when forecasting candidate tokens with the assistent model
is much faster than running generation with the model you&#x2019;re calling generate from. As such, the
assistant model should be much smaller.`,name:"assistant_model"},{anchor:"transformers.PhiForCausalLM.generate.streamer",description:`<strong>streamer</strong> (<code>BaseStreamer</code>, <em>optional</em>) &#x2014;
Streamer object that will be used to stream the generated sequences. Generated tokens are passed
through <code>streamer.put(token_ids)</code> and the streamer is responsible for any further processing.`,name:"streamer"},{anchor:"transformers.PhiForCausalLM.generate.negative_prompt_ids",description:`<strong>negative_prompt_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
The negative prompt needed for some processors such as CFG. The batch size must match the input batch
size. This is an experimental feature, subject to breaking API changes in future versions.`,name:"negative_prompt_ids"},{anchor:"transformers.PhiForCausalLM.generate.negative_prompt_attention_mask",description:`<strong>negative_prompt_attention_mask</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Attention_mask for <code>negative_prompt_ids</code>.`,name:"negative_prompt_attention_mask"},{anchor:"transformers.PhiForCausalLM.generate.kwargs",description:`<strong>kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of <code>generate_config</code> and/or additional model-specific kwargs that will be
forwarded to the <code>forward</code> function of the model. If the model is an encoder-decoder model, encoder
specific kwargs should not be prefixed and decoder specific kwargs should be prefixed with <em>decoder_</em>.`,name:"kwargs"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/generation/utils.py#L1424",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> (if <code>return_dict_in_generate=True</code>
or when <code>config.return_dict_in_generate=True</code>) or a <code>torch.FloatTensor</code>.</p>
<p>If the model is <em>not</em> an encoder-decoder model (<code>model.config.is_encoder_decoder=False</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GreedySearchDecoderOnlyOutput"
>GreedySearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.SampleDecoderOnlyOutput"
>SampleDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.BeamSearchDecoderOnlyOutput"
>BeamSearchDecoderOnlyOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.BeamSampleDecoderOnlyOutput"
>BeamSampleDecoderOnlyOutput</a></li>
</ul>
<p>If the model is an encoder-decoder model (<code>model.config.is_encoder_decoder=True</code>), the possible
<a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> types are:</p>
<ul>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.GreedySearchEncoderDecoderOutput"
>GreedySearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.SampleEncoderDecoderOutput"
>SampleEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.BeamSearchEncoderDecoderOutput"
>BeamSearchEncoderDecoderOutput</a>,</li>
<li><a
  href="/docs/transformers/main/en/internal/generation_utils#transformers.generation.BeamSampleEncoderDecoderOutput"
>BeamSampleEncoderDecoderOutput</a></li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput"
>ModelOutput</a> or <code>torch.LongTensor</code></p>
`}}),Q=new gt({props:{warning:!0,$$slots:{default:[Lt]},$$scope:{ctx:$}}}),oe=new ee({props:{title:"PhiForSequenceClassification",local:"transformers.PhiForSequenceClassification",headingTag:"h2"}}),S=new Ie({props:{name:"class transformers.PhiForSequenceClassification",anchor:"transformers.PhiForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PhiForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L1167"}}),ae=new Ie({props:{name:"forward",anchor:"transformers.PhiForSequenceClassification.forward",parameters:[{name:"input_ids",val:": LongTensor = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PhiForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiForSequenceClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiForSequenceClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiForSequenceClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiForSequenceClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhiForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L1183"}}),Y=new gt({props:{$$slots:{default:[Zt]},$$scope:{ctx:$}}}),Je=new ee({props:{title:"PhiForTokenClassification",local:"transformers.PhiForTokenClassification",headingTag:"h2"}}),re=new Ie({props:{name:"class transformers.PhiForTokenClassification",anchor:"transformers.PhiForTokenClassification",parameters:[{name:"config",val:": PhiConfig"}],parametersDescription:[{anchor:"transformers.PhiForTokenClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig">PhiConfig</a>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L1283"}}),Z=new Ie({props:{name:"forward",anchor:"transformers.PhiForTokenClassification.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Union[typing.Tuple[typing.Tuple[torch.Tensor, torch.Tensor], ...], NoneType] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"**deprecated_arguments",val:""}],parametersDescription:[{anchor:"transformers.PhiForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.PhiForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/model_doc/fastspeech2_conformer#transformers.FastSpeech2ConformerTokenizer.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.PhiForTokenClassification.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>.</p>
<p><a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.PhiForTokenClassification.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>Cache</code> or <code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>) &#x2014;
Pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used to speed up sequential decoding. This typically consists in the <code>past_key_values</code>
returned by the model at a previous stage of decoding, when <code>use_cache=True</code> or <code>config.use_cache=True</code>.</p>
<p>Two formats are allowed:</p>
<ul>
<li>a <a href="/docs/transformers/main/en/internal/generation_utils#transformers.Cache">Cache</a> instance;</li>
<li>Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of
shape <code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>). This is also known as the legacy
cache format.</li>
</ul>
<p>The model will output the same cache format that is fed as input. If no <code>past_key_values</code> are passed, the
legacy cache format will be returned.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>input_ids</code> (those that don&#x2019;t
have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all <code>input_ids</code>
of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.PhiForTokenClassification.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.PhiForTokenClassification.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.PhiForTokenClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PhiForTokenClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PhiForTokenClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PhiForTokenClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the sequence classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/modeling_phi.py#L1301",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/phi#transformers.PhiConfig"
>PhiConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided)  — Classification loss.</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.num_labels)</code>) — Classification scores (before SoftMax).</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/main/en/main_classes/output#transformers.modeling_outputs.TokenClassifierOutput"
>transformers.modeling_outputs.TokenClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),s=new gt({props:{$$slots:{default:[Bt]},$$scope:{ctx:$}}}),ke=new wt({props:{anchor:"transformers.PhiForTokenClassification.forward.example",$$slots:{default:[Gt]},$$scope:{ctx:$}}}),{c(){_(t.$$.fragment),f=i(),a=p("div"),_(c.$$.fragment),M=i(),d=p("p"),d.innerHTML=k,Xe=i(),H=p("p"),H.innerHTML=_t,Ee=i(),N=p("p"),N.innerHTML=yt,Re=i(),x=p("div"),_(te.$$.fragment),pe=i(),Ue=p("p"),Ue.innerHTML=tt,he=i(),_(me.$$.fragment),Le=i(),_(B.$$.fragment),nt=i(),L=p("div"),_(G.$$.fragment),lt=i(),z=p("div"),_(W.$$.fragment),dt=i(),ue=p("p"),ue.innerHTML=Ce,ct=i(),_(O.$$.fragment),fe=i(),_(ge.$$.fragment),Oe=i(),j=p("div"),_(ne.$$.fragment),_e=i(),Ze=p("p"),Ze.textContent=ot,ye=i(),_(Q.$$.fragment),A=i(),_(oe.$$.fragment),se=i(),C=p("div"),_(S.$$.fragment),Qe=i(),V=p("p"),V.textContent=st,be=i(),Te=p("p"),Te.innerHTML=Pe,pt=i(),we=p("p"),we.innerHTML=xe,Ae=i(),X=p("p"),X.innerHTML=bt,Ye=i(),E=p("p"),E.innerHTML=Tt,De=i(),J=p("div"),_(ae.$$.fragment),ve=i(),Me=p("p"),Me.innerHTML=je,ht=i(),_(Y.$$.fragment),D=i(),_(Je.$$.fragment),Be=i(),P=p("div"),_(re.$$.fragment),F=i(),R=p("p"),R.textContent=mt,ze=i(),Ge=p("p"),Ge.innerHTML=ut,Fe=i(),We=p("p"),We.innerHTML=ft,ie=i(),I=p("div"),_(Z.$$.fragment),Ke=i(),le=p("p"),le.innerHTML=at,e=i(),_(s.$$.fragment),q=i(),_(ke.$$.fragment),this.h()},l(o){y(t.$$.fragment,o),f=l(o),a=h(o,"DIV",{class:!0});var g=de(a);y(c.$$.fragment,g),M=l(g),d=h(g,"P",{"data-svelte-h":!0}),u(d)!=="svelte-1g9ll2t"&&(d.innerHTML=k),Xe=l(g),H=h(g,"P",{"data-svelte-h":!0}),u(H)!=="svelte-hswkmf"&&(H.innerHTML=_t),Ee=l(g),N=h(g,"P",{"data-svelte-h":!0}),u(N)!=="svelte-9ccchq"&&(N.innerHTML=yt),Re=l(g),x=h(g,"DIV",{class:!0});var Se=de(x);y(te.$$.fragment,Se),pe=l(Se),Ue=h(Se,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-nn35ak"&&(Ue.innerHTML=tt),he=l(Se),y(me.$$.fragment,Se),Se.forEach(n),g.forEach(n),Le=l(o),y(B.$$.fragment,o),nt=l(o),L=h(o,"DIV",{class:!0});var qe=de(L);y(G.$$.fragment,qe),lt=l(qe),z=h(qe,"DIV",{class:!0});var $e=de(z);y(W.$$.fragment,$e),dt=l($e),ue=h($e,"P",{"data-svelte-h":!0}),u(ue)!=="svelte-n3wos4"&&(ue.innerHTML=Ce),ct=l($e),y(O.$$.fragment,$e),fe=l($e),y(ge.$$.fragment,$e),$e.forEach(n),Oe=l(qe),j=h(qe,"DIV",{class:!0});var He=de(j);y(ne.$$.fragment,He),_e=l(He),Ze=h(He,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-s5ko3x"&&(Ze.textContent=ot),ye=l(He),y(Q.$$.fragment,He),He.forEach(n),qe.forEach(n),A=l(o),y(oe.$$.fragment,o),se=l(o),C=h(o,"DIV",{class:!0});var U=de(C);y(S.$$.fragment,U),Qe=l(U),V=h(U,"P",{"data-svelte-h":!0}),u(V)!=="svelte-1ei5ef0"&&(V.textContent=st),be=l(U),Te=h(U,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1vadz63"&&(Te.innerHTML=Pe),pt=l(U),we=h(U,"P",{"data-svelte-h":!0}),u(we)!=="svelte-10ugs3m"&&(we.innerHTML=xe),Ae=l(U),X=h(U,"P",{"data-svelte-h":!0}),u(X)!=="svelte-6pahdo"&&(X.innerHTML=bt),Ye=l(U),E=h(U,"P",{"data-svelte-h":!0}),u(E)!=="svelte-hswkmf"&&(E.innerHTML=Tt),De=l(U),J=h(U,"DIV",{class:!0});var Ne=de(J);y(ae.$$.fragment,Ne),ve=l(Ne),Me=h(Ne,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-h9u1c6"&&(Me.innerHTML=je),ht=l(Ne),y(Y.$$.fragment,Ne),Ne.forEach(n),U.forEach(n),D=l(o),y(Je.$$.fragment,o),Be=l(o),P=h(o,"DIV",{class:!0});var K=de(P);y(re.$$.fragment,K),F=l(K),R=h(K,"P",{"data-svelte-h":!0}),u(R)!=="svelte-mycuhq"&&(R.textContent=mt),ze=l(K),Ge=h(K,"P",{"data-svelte-h":!0}),u(Ge)!=="svelte-6pahdo"&&(Ge.innerHTML=ut),Fe=l(K),We=h(K,"P",{"data-svelte-h":!0}),u(We)!=="svelte-hswkmf"&&(We.innerHTML=ft),ie=l(K),I=h(K,"DIV",{class:!0});var et=de(I);y(Z.$$.fragment,et),Ke=l(et),le=h(et,"P",{"data-svelte-h":!0}),u(le)!=="svelte-1etzxpw"&&(le.innerHTML=at),e=l(et),y(s.$$.fragment,et),q=l(et),y(ke.$$.fragment,et),et.forEach(n),K.forEach(n),this.h()},h(){ce(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(a,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),ce(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,g){b(t,o,g),r(o,f,g),r(o,a,g),b(c,a,null),m(a,M),m(a,d),m(a,Xe),m(a,H),m(a,Ee),m(a,N),m(a,Re),m(a,x),b(te,x,null),m(x,pe),m(x,Ue),m(x,he),b(me,x,null),r(o,Le,g),b(B,o,g),r(o,nt,g),r(o,L,g),b(G,L,null),m(L,lt),m(L,z),b(W,z,null),m(z,dt),m(z,ue),m(z,ct),b(O,z,null),m(z,fe),b(ge,z,null),m(L,Oe),m(L,j),b(ne,j,null),m(j,_e),m(j,Ze),m(j,ye),b(Q,j,null),r(o,A,g),b(oe,o,g),r(o,se,g),r(o,C,g),b(S,C,null),m(C,Qe),m(C,V),m(C,be),m(C,Te),m(C,pt),m(C,we),m(C,Ae),m(C,X),m(C,Ye),m(C,E),m(C,De),m(C,J),b(ae,J,null),m(J,ve),m(J,Me),m(J,ht),b(Y,J,null),r(o,D,g),b(Je,o,g),r(o,Be,g),r(o,P,g),b(re,P,null),m(P,F),m(P,R),m(P,ze),m(P,Ge),m(P,Fe),m(P,We),m(P,ie),m(P,I),b(Z,I,null),m(I,Ke),m(I,le),m(I,e),b(s,I,null),m(I,q),b(ke,I,null),rt=!0},p(o,g){const Se={};g&2&&(Se.$$scope={dirty:g,ctx:o}),me.$set(Se);const qe={};g&2&&(qe.$$scope={dirty:g,ctx:o}),O.$set(qe);const $e={};g&2&&($e.$$scope={dirty:g,ctx:o}),ge.$set($e);const He={};g&2&&(He.$$scope={dirty:g,ctx:o}),Q.$set(He);const U={};g&2&&(U.$$scope={dirty:g,ctx:o}),Y.$set(U);const Ne={};g&2&&(Ne.$$scope={dirty:g,ctx:o}),s.$set(Ne);const K={};g&2&&(K.$$scope={dirty:g,ctx:o}),ke.$set(K)},i(o){rt||(T(t.$$.fragment,o),T(c.$$.fragment,o),T(te.$$.fragment,o),T(me.$$.fragment,o),T(B.$$.fragment,o),T(G.$$.fragment,o),T(W.$$.fragment,o),T(O.$$.fragment,o),T(ge.$$.fragment,o),T(ne.$$.fragment,o),T(Q.$$.fragment,o),T(oe.$$.fragment,o),T(S.$$.fragment,o),T(ae.$$.fragment,o),T(Y.$$.fragment,o),T(Je.$$.fragment,o),T(re.$$.fragment,o),T(Z.$$.fragment,o),T(s.$$.fragment,o),T(ke.$$.fragment,o),rt=!0)},o(o){w(t.$$.fragment,o),w(c.$$.fragment,o),w(te.$$.fragment,o),w(me.$$.fragment,o),w(B.$$.fragment,o),w(G.$$.fragment,o),w(W.$$.fragment,o),w(O.$$.fragment,o),w(ge.$$.fragment,o),w(ne.$$.fragment,o),w(Q.$$.fragment,o),w(oe.$$.fragment,o),w(S.$$.fragment,o),w(ae.$$.fragment,o),w(Y.$$.fragment,o),w(Je.$$.fragment,o),w(re.$$.fragment,o),w(Z.$$.fragment,o),w(s.$$.fragment,o),w(ke.$$.fragment,o),rt=!1},d(o){o&&(n(f),n(a),n(Le),n(nt),n(L),n(A),n(se),n(C),n(D),n(Be),n(P)),v(t,o),v(c),v(te),v(me),v(B,o),v(G),v(W),v(O),v(ge),v(ne),v(Q),v(oe,o),v(S),v(ae),v(Y),v(Je,o),v(re),v(Z),v(s),v(ke)}}}function St($){let t,f;return t=new jt({props:{$$slots:{default:[Wt]},$$scope:{ctx:$}}}),{c(){_(t.$$.fragment)},l(a){y(t.$$.fragment,a)},m(a,c){b(t,a,c),f=!0},p(a,c){const M={};c&2&&(M.$$scope={dirty:c,ctx:a}),t.$set(M)},i(a){f||(T(t.$$.fragment,a),f=!0)},o(a){w(t.$$.fragment,a),f=!1},d(a){v(t,a)}}}function qt($){let t,f,a,c,M,d,k,Xe,H,_t='The Phi-1 model was proposed in <a href="https://arxiv.org/abs/2306.11644" rel="nofollow">Textbooks Are All You Need</a> by Suriya Gunasekar, Yi Zhang, Jyoti Aneja, Caio César Teodoro Mendes, Allie Del Giorno, Sivakanth Gopi, Mojan Javaheripi, Piero Kauffmann, Gustavo de Rosa, Olli Saarikivi, Adil Salim, Shital Shah, Harkirat Singh Behl, Xin Wang, Sébastien Bubeck, Ronen Eldan, Adam Tauman Kalai, Yin Tat Lee and Yuanzhi Li.',Ee,N,yt='The Phi-1.5 model was proposed in <a href="https://arxiv.org/abs/2309.05463" rel="nofollow">Textbooks Are All You Need II: phi-1.5 technical report</a> by Yuanzhi Li, Sébastien Bubeck, Ronen Eldan, Allie Del Giorno, Suriya Gunasekar and Yin Tat Lee.',Re,x,te,pe,Ue=`In Phi-1 and Phi-1.5 papers, the authors showed how important the quality of the data is in training relative to the model size.
They selected high quality “textbook” data alongside with synthetically generated data for training their small sized Transformer
based model Phi-1 with 1.3B parameters. Despite this small scale, phi-1 attains pass@1 accuracy 50.6% on HumanEval and 55.5% on MBPP.
They follow the same strategy for Phi-1.5 and created another 1.3B parameter model with performance on natural language tasks comparable
to models 5x larger, and surpassing most non-frontier LLMs. Phi-1.5 exhibits many of the traits of much larger LLMs such as the ability
to “think step by step” or perform some rudimentary in-context learning.
With these two experiments the authors successfully showed the huge impact of quality of training data when training machine learning models.`,tt,he,me="The abstract from the Phi-1 paper is the following:",Le,B,nt=`<em>We introduce phi-1, a new large language model for code, with significantly smaller size than
competing models: phi-1 is a Transformer-based model with 1.3B parameters, trained for 4 days on
8 A100s, using a selection of “textbook quality” data from the web (6B tokens) and synthetically
generated textbooks and exercises with GPT-3.5 (1B tokens). Despite this small scale, phi-1 attains
pass@1 accuracy 50.6% on HumanEval and 55.5% on MBPP. It also displays surprising emergent
properties compared to phi-1-base, our model before our finetuning stage on a dataset of coding
exercises, and phi-1-small, a smaller model with 350M parameters trained with the same pipeline as
phi-1 that still achieves 45% on HumanEval.</em>`,L,G,lt="The abstract from the Phi-1.5 paper is the following:",z,W,dt=`<em>We continue the investigation into the power of smaller Transformer-based language models as
initiated by TinyStories – a 10 million parameter model that can produce coherent English – and
the follow-up work on phi-1, a 1.3 billion parameter model with Python coding performance close
to the state-of-the-art. The latter work proposed to use existing Large Language Models (LLMs) to
generate “textbook quality” data as a way to enhance the learning process compared to traditional
web data. We follow the “Textbooks Are All You Need” approach, focusing this time on common
sense reasoning in natural language, and create a new 1.3 billion parameter model named phi-1.5,
with performance on natural language tasks comparable to models 5x larger, and surpassing most
non-frontier LLMs on more complex reasoning tasks such as grade-school mathematics and basic
coding. More generally, phi-1.5 exhibits many of the traits of much larger LLMs, both good –such
as the ability to “think step by step” or perform some rudimentary in-context learning– and bad,
including hallucinations and the potential for toxic and biased generations –encouragingly though, we
are seeing improvement on that front thanks to the absence of web data. We open-source phi-1.5 to
promote further research on these urgent topics.</em>`,ue,Ce,ct=`This model was contributed by <a href="https://huggingface.co/susnato" rel="nofollow">Susnato Dhar</a>.
The original code for Phi-1 and Phi-1.5 can be found <a href="https://huggingface.co/microsoft/phi-1/blob/main/modeling_mixformer_sequential.py" rel="nofollow">here</a> and <a href="https://huggingface.co/microsoft/phi-1_5/blob/main/modeling_mixformer_sequential.py" rel="nofollow">here</a> respectively.`,O,fe,ge='The original code for Phi-2 can be found <a href="https://huggingface.co/microsoft/phi-2" rel="nofollow">here</a>.',Oe,j,ne,_e,Ze='<li>This model is quite similar to <code>Llama</code> with the main difference in <code>PhiDecoderLayer</code>, where they used <code>PhiAttention</code> and <code>PhiMLP</code> layers in parallel configuration.</li> <li>The tokenizer used for this model is identical to the <a href="/docs/transformers/main/en/model_doc/codegen#transformers.CodeGenTokenizer">CodeGenTokenizer</a>.</li>',ot,ye,Q,A,oe,se,C,S,Qe,V,st,be,Te,Pe,pt="First, make sure to install the latest version of Flash Attention 2 to include the sliding window attention feature.",we,xe,Ae,X,bt="Make also sure that you have a hardware that is compatible with Flash-Attention 2. Read more about it in the official documentation of flash-attn repository. Make also sure to load your model in half-precision (e.g. `torch.float16“)",Ye,E,Tt="To load and run a model using Flash Attention 2, refer to the snippet below:",De,J,ae,ve,Me,je,ht="Below is an expected speedup diagram that compares pure inference time between the native implementation in transformers using <code>susnato/phi-1_dev</code> checkpoint and the Flash Attention 2 version of the model using a sequence length of 2048.",Y,D,Je='<img src="https://huggingface.co/datasets/ybelkada/documentation-images/resolve/main/phi_1_speedup_plot.jpg"/>',Be,P,re,F,R,mt,ze,Ge=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiModel">PhiModel</a>. It is used to instantiate an Phi
model according to the specified arguments, defining the model architecture. Instantiating a configuration with the
defaults will yield a similar configuration to that of the Phi
<a href="https://huggingface.co/susnato/phi-1_dev" rel="nofollow">susnato/phi-1_dev</a>.`,ut,Fe,We=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,ft,ie,I,Z,Ke,le,at;return M=new ee({props:{title:"Phi",local:"phi",headingTag:"h1"}}),k=new ee({props:{title:"Overview",local:"overview",headingTag:"h2"}}),x=new ee({props:{title:"Summary",local:"summary",headingTag:"h3"}}),j=new ee({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),ye=new ee({props:{title:"How to use Phi-2",local:"how-to-use-phi-2",headingTag:"h2"}}),A=new gt({props:{warning:!0,$$slots:{default:[Jt]},$$scope:{ctx:$}}}),se=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZwaGktMiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGcGhpLTIlMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCdDYW4lMjB5b3UlMjBoZWxwJTIwbWUlMjB3cml0ZSUyMGElMjBmb3JtYWwlMjBlbWFpbCUyMHRvJTIwYSUyMHBvdGVudGlhbCUyMGJ1c2luZXNzJTIwcGFydG5lciUyMHByb3Bvc2luZyUyMGElMjBqb2ludCUyMHZlbnR1cmUlM0YnJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHJldHVybl9hdHRlbnRpb25fbWFzayUzREZhbHNlKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUyMG1heF9sZW5ndGglM0QzMCklMEF0ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShvdXRwdXRzKSU1QjAlNUQlMEFwcmludCh0ZXh0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;susnato/phi-2&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/phi-2&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&#x27;Can you help me write a formal email to a potential business partner proposing a joint venture?&#x27;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, return_attention_mask=<span class="hljs-literal">False</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>text = tokenizer.batch_decode(outputs)[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(text)
<span class="hljs-string">&#x27;Can you help me write a formal email to a potential business partner proposing a joint venture?\\nInput: Company A: ABC Inc.\\nCompany B: XYZ Ltd.\\nJoint Venture: A new online platform for e-commerce&#x27;</span>`,wrap:!1}}),S=new ee({props:{title:"Example :",local:"example-",headingTag:"h3"}}),V=new it({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBoaUZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwdG9rZW5pemVyLiUwQW1vZGVsJTIwJTNEJTIwUGhpRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMnN1c25hdG8lMkZwaGktMV81X2RldiUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGcGhpLTFfNV9kZXYlMjIpJTBBJTBBJTIzJTIwZmVlbCUyMGZyZWUlMjB0byUyMGNoYW5nZSUyMHRoZSUyMHByb21wdCUyMHRvJTIweW91ciUyMGxpa2luZy4lMEFwcm9tcHQlMjAlM0QlMjAlMjJJZiUyMEklMjB3ZXJlJTIwYW4lMjBBSSUyMHRoYXQlMjBoYWQlMjBqdXN0JTIwYWNoaWV2ZWQlMjIlMEElMEElMjMlMjBhcHBseSUyMHRoZSUyMHRva2VuaXplci4lMEF0b2tlbnMlMjAlM0QlMjB0b2tlbml6ZXIocHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjB1c2UlMjB0aGUlMjBtb2RlbCUyMHRvJTIwZ2VuZXJhdGUlMjBuZXclMjB0b2tlbnMuJTBBZ2VuZXJhdGVkX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqdG9rZW5zJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTApJTBBJTBBdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfb3V0cHV0KSU1QjAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhiForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the model and tokenizer.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForCausalLM.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_5_dev&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_5_dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the prompt to your liking.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;If I were an AI that had just achieved&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the tokenizer.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use the model to generate new tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_output = model.generate(**tokens, use_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_output)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;If I were an AI that had just achieved a breakthrough in machine learning, I would be thrilled&#x27;</span>`,wrap:!1}}),be=new ee({props:{title:"Combining Phi and Flash Attention 2",local:"combining-phi-and-flash-attention-2",headingTag:"h2"}}),xe=new it({props:{code:"cGlwJTIwaW5zdGFsbCUyMC1VJTIwZmxhc2gtYXR0biUyMC0tbm8tYnVpbGQtaXNvbGF0aW9u",highlighted:"pip install -U flash-attn --no-build-isolation",wrap:!1}}),J=new it({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwUGhpRm9yQ2F1c2FsTE0lMkMlMjBBdXRvVG9rZW5pemVyJTBBJTBBJTIzJTIwZGVmaW5lJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbml6ZXIlMjBhbmQlMjBwdXNoJTIwdGhlJTIwbW9kZWwlMjBhbmQlMjB0b2tlbnMlMjB0byUyMHRoZSUyMEdQVS4lMEFtb2RlbCUyMCUzRCUyMFBoaUZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJzdXNuYXRvJTJGcGhpLTFfNV9kZXYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjBhdHRuX2ltcGxlbWVudGF0aW9uJTNEJTIyZmxhc2hfYXR0ZW50aW9uXzIlMjIpLnRvKCUyMmN1ZGElMjIpJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyc3VzbmF0byUyRnBoaS0xXzVfZGV2JTIyKSUwQSUwQSUyMyUyMGZlZWwlMjBmcmVlJTIwdG8lMjBjaGFuZ2UlMjB0aGUlMjBwcm9tcHQlMjB0byUyMHlvdXIlMjBsaWtpbmcuJTBBcHJvbXB0JTIwJTNEJTIwJTIySWYlMjBJJTIwd2VyZSUyMGFuJTIwQUklMjB0aGF0JTIwaGFkJTIwanVzdCUyMGFjaGlldmVkJTIyJTBBJTBBJTIzJTIwYXBwbHklMjB0aGUlMjB0b2tlbml6ZXIuJTBBdG9rZW5zJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIpJTBBJTBBJTIzJTIwdXNlJTIwdGhlJTIwbW9kZWwlMjB0byUyMGdlbmVyYXRlJTIwbmV3JTIwdG9rZW5zLiUwQWdlbmVyYXRlZF9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKnRva2VucyUyQyUyMHVzZV9jYWNoZSUzRFRydWUlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDEwKSUwQSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVkX291dHB1dCklNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PhiForCausalLM, AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the model and tokenizer and push the model and tokens to the GPU.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PhiForCausalLM.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_5_dev&quot;</span>, torch_dtype=torch.float16, attn_implementation=<span class="hljs-string">&quot;flash_attention_2&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;susnato/phi-1_5_dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># feel free to change the prompt to your liking.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;If I were an AI that had just achieved&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># apply the tokenizer.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokens = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># use the model to generate new tokens.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generated_output = model.generate(**tokens, use_cache=<span class="hljs-literal">True</span>, max_new_tokens=<span class="hljs-number">10</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.batch_decode(generated_output)[<span class="hljs-number">0</span>]
<span class="hljs-string">&#x27;If I were an AI that had just achieved a breakthrough in machine learning, I would be thrilled&#x27;</span>`,wrap:!1}}),ve=new ee({props:{title:"Expected speedups",local:"expected-speedups",headingTag:"h3"}}),P=new ee({props:{title:"PhiConfig",local:"transformers.PhiConfig",headingTag:"h2"}}),R=new Ie({props:{name:"class transformers.PhiConfig",anchor:"transformers.PhiConfig",parameters:[{name:"vocab_size",val:" = 51200"},{name:"hidden_size",val:" = 2048"},{name:"intermediate_size",val:" = 8192"},{name:"num_hidden_layers",val:" = 24"},{name:"num_attention_heads",val:" = 32"},{name:"resid_pdrop",val:" = 0.0"},{name:"embd_pdrop",val:" = 0.0"},{name:"attention_dropout",val:" = 0.0"},{name:"hidden_act",val:" = 'gelu_new'"},{name:"max_position_embeddings",val:" = 2048"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-05"},{name:"use_cache",val:" = True"},{name:"tie_word_embeddings",val:" = False"},{name:"rope_theta",val:" = 10000.0"},{name:"rope_scaling",val:" = None"},{name:"partial_rotary_factor",val:" = 0.5"},{name:"qk_layernorm",val:" = False"},{name:"bos_token_id",val:" = 1"},{name:"eos_token_id",val:" = 2"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PhiConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 51200) &#x2014;
Vocabulary size of the Phi model. Defines the number of different tokens that can be represented by the
<code>inputs_ids</code> passed when calling <a href="/docs/transformers/main/en/model_doc/phi#transformers.PhiModel">PhiModel</a>.`,name:"vocab_size"},{anchor:"transformers.PhiConfig.hidden_size",description:`<strong>hidden_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
Dimension of the hidden representations.`,name:"hidden_size"},{anchor:"transformers.PhiConfig.intermediate_size",description:`<strong>intermediate_size</strong> (<code>int</code>, <em>optional</em>, defaults to 8192) &#x2014;
Dimension of the MLP representations.`,name:"intermediate_size"},{anchor:"transformers.PhiConfig.num_hidden_layers",description:`<strong>num_hidden_layers</strong> (<code>int</code>, <em>optional</em>, defaults to 24) &#x2014;
Number of hidden layers in the Transformer decoder.`,name:"num_hidden_layers"},{anchor:"transformers.PhiConfig.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014;
Number of attention heads for each attention layer in the Transformer decoder.`,name:"num_attention_heads"},{anchor:"transformers.PhiConfig.resid_pdrop",description:`<strong>resid_pdrop</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Dropout probability for mlp outputs.`,name:"resid_pdrop"},{anchor:"transformers.PhiConfig.embd_pdrop",description:`<strong>embd_pdrop</strong> (<code>int</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio for the embeddings.`,name:"embd_pdrop"},{anchor:"transformers.PhiConfig.attention_dropout",description:`<strong>attention_dropout</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The dropout ratio after computing the attention scores.`,name:"attention_dropout"},{anchor:"transformers.PhiConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu_new&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the decoder.`,name:"hidden_act"},{anchor:"transformers.PhiConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that this model might ever be used with. Phi-1 and Phi-1.5 supports up to 2048
tokens.`,name:"max_position_embeddings"},{anchor:"transformers.PhiConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PhiConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-05) &#x2014;
The epsilon used by the rms normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PhiConfig.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not the model should return the last key/values attentions (not used by all models). Only
relevant if <code>config.is_decoder=True</code>. Whether to tie weight embeddings or not.`,name:"use_cache"},{anchor:"transformers.PhiConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to tie weight embeddings`,name:"tie_word_embeddings"},{anchor:"transformers.PhiConfig.rope_theta",description:`<strong>rope_theta</strong> (<code>float</code>, <em>optional</em>, defaults to 10000.0) &#x2014;
The base period of the RoPE embeddings.`,name:"rope_theta"},{anchor:"transformers.PhiConfig.rope_scaling",description:`<strong>rope_scaling</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Dictionary containing the scaling configuration for the RoPE embeddings. Currently supports two scaling
strategies: linear and dynamic. Their scaling factor must be an float greater than 1. The expected format
is <code>{&quot;type&quot;: strategy name, &quot;factor&quot;: scaling factor}</code>. When using this flag, don&#x2019;t update
<code>max_position_embeddings</code> to the expected new maximum. See the following thread for more information on how
these scaling strategies behave:
<a href="https://www.reddit.com/r/LocalPersimmon/comments/14mrgpr/dynamically_scaled_rope_further_increases/" rel="nofollow">https://www.reddit.com/r/LocalPersimmon/comments/14mrgpr/dynamically_scaled_rope_further_increases/</a>. This
is an experimental feature, subject to breaking API changes in future versions.`,name:"rope_scaling"},{anchor:"transformers.PhiConfig.partial_rotary_factor",description:`<strong>partial_rotary_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 0.5) &#x2014;
Percentage of the query and keys which will have rotary embedding.`,name:"partial_rotary_factor"},{anchor:"transformers.PhiConfig.qk_layernorm",description:`<strong>qk_layernorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to normalize the Queries and Keys after projecting the hidden states`,name:"qk_layernorm"},{anchor:"transformers.PhiConfig.bos_token_id",description:`<strong>bos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Denotes beginning of sequences token id.`,name:"bos_token_id"},{anchor:"transformers.PhiConfig.eos_token_id",description:`<strong>eos_token_id</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
Denotes end of sequences token id.`,name:"eos_token_id"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/phi/configuration_phi.py#L31"}}),ie=new wt({props:{anchor:"transformers.PhiConfig.example",$$slots:{default:[zt]},$$scope:{ctx:$}}}),Z=new xt({props:{pytorch:!0,tensorflow:!1,jax:!1,$$slots:{pytorch:[St]},$$scope:{ctx:$}}}),{c(){t=p("meta"),f=i(),a=p("p"),c=i(),_(M.$$.fragment),d=i(),_(k.$$.fragment),Xe=i(),H=p("p"),H.innerHTML=_t,Ee=i(),N=p("p"),N.innerHTML=yt,Re=i(),_(x.$$.fragment),te=i(),pe=p("p"),pe.textContent=Ue,tt=i(),he=p("p"),he.textContent=me,Le=i(),B=p("p"),B.innerHTML=nt,L=i(),G=p("p"),G.textContent=lt,z=i(),W=p("p"),W.innerHTML=dt,ue=i(),Ce=p("p"),Ce.innerHTML=ct,O=i(),fe=p("p"),fe.innerHTML=ge,Oe=i(),_(j.$$.fragment),ne=i(),_e=p("ul"),_e.innerHTML=Ze,ot=i(),_(ye.$$.fragment),Q=i(),_(A.$$.fragment),oe=i(),_(se.$$.fragment),C=i(),_(S.$$.fragment),Qe=i(),_(V.$$.fragment),st=i(),_(be.$$.fragment),Te=i(),Pe=p("p"),Pe.textContent=pt,we=i(),_(xe.$$.fragment),Ae=i(),X=p("p"),X.textContent=bt,Ye=i(),E=p("p"),E.textContent=Tt,De=i(),_(J.$$.fragment),ae=i(),_(ve.$$.fragment),Me=i(),je=p("p"),je.innerHTML=ht,Y=i(),D=p("div"),D.innerHTML=Je,Be=i(),_(P.$$.fragment),re=i(),F=p("div"),_(R.$$.fragment),mt=i(),ze=p("p"),ze.innerHTML=Ge,ut=i(),Fe=p("p"),Fe.innerHTML=We,ft=i(),_(ie.$$.fragment),I=i(),_(Z.$$.fragment),Ke=i(),le=p("p"),this.h()},l(e){const s=Ct("svelte-u9bgzb",document.head);t=h(s,"META",{name:!0,content:!0}),s.forEach(n),f=l(e),a=h(e,"P",{}),de(a).forEach(n),c=l(e),y(M.$$.fragment,e),d=l(e),y(k.$$.fragment,e),Xe=l(e),H=h(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-1yhjn85"&&(H.innerHTML=_t),Ee=l(e),N=h(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-1fvv6h4"&&(N.innerHTML=yt),Re=l(e),y(x.$$.fragment,e),te=l(e),pe=h(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-x3eyc9"&&(pe.textContent=Ue),tt=l(e),he=h(e,"P",{"data-svelte-h":!0}),u(he)!=="svelte-tgcdxr"&&(he.textContent=me),Le=l(e),B=h(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-187tpcl"&&(B.innerHTML=nt),L=l(e),G=h(e,"P",{"data-svelte-h":!0}),u(G)!=="svelte-10n16wm"&&(G.textContent=lt),z=l(e),W=h(e,"P",{"data-svelte-h":!0}),u(W)!=="svelte-1wjkxlu"&&(W.innerHTML=dt),ue=l(e),Ce=h(e,"P",{"data-svelte-h":!0}),u(Ce)!=="svelte-19ubsrh"&&(Ce.innerHTML=ct),O=l(e),fe=h(e,"P",{"data-svelte-h":!0}),u(fe)!=="svelte-1sbak3"&&(fe.innerHTML=ge),Oe=l(e),y(j.$$.fragment,e),ne=l(e),_e=h(e,"UL",{"data-svelte-h":!0}),u(_e)!=="svelte-kasjqy"&&(_e.innerHTML=Ze),ot=l(e),y(ye.$$.fragment,e),Q=l(e),y(A.$$.fragment,e),oe=l(e),y(se.$$.fragment,e),C=l(e),y(S.$$.fragment,e),Qe=l(e),y(V.$$.fragment,e),st=l(e),y(be.$$.fragment,e),Te=l(e),Pe=h(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-o3pzzu"&&(Pe.textContent=pt),we=l(e),y(xe.$$.fragment,e),Ae=l(e),X=h(e,"P",{"data-svelte-h":!0}),u(X)!=="svelte-enej3y"&&(X.textContent=bt),Ye=l(e),E=h(e,"P",{"data-svelte-h":!0}),u(E)!=="svelte-14hchid"&&(E.textContent=Tt),De=l(e),y(J.$$.fragment,e),ae=l(e),y(ve.$$.fragment,e),Me=l(e),je=h(e,"P",{"data-svelte-h":!0}),u(je)!=="svelte-ea3kx7"&&(je.innerHTML=ht),Y=l(e),D=h(e,"DIV",{style:!0,"data-svelte-h":!0}),u(D)!=="svelte-1kvqy0w"&&(D.innerHTML=Je),Be=l(e),y(P.$$.fragment,e),re=l(e),F=h(e,"DIV",{class:!0});var q=de(F);y(R.$$.fragment,q),mt=l(q),ze=h(q,"P",{"data-svelte-h":!0}),u(ze)!=="svelte-b227o5"&&(ze.innerHTML=Ge),ut=l(q),Fe=h(q,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-o55m63"&&(Fe.innerHTML=We),ft=l(q),y(ie.$$.fragment,q),q.forEach(n),I=l(e),y(Z.$$.fragment,e),Ke=l(e),le=h(e,"P",{}),de(le).forEach(n),this.h()},h(){ce(t,"name","hf:doc:metadata"),ce(t,"content",Ht),Pt(D,"text-align","center"),ce(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){m(document.head,t),r(e,f,s),r(e,a,s),r(e,c,s),b(M,e,s),r(e,d,s),b(k,e,s),r(e,Xe,s),r(e,H,s),r(e,Ee,s),r(e,N,s),r(e,Re,s),b(x,e,s),r(e,te,s),r(e,pe,s),r(e,tt,s),r(e,he,s),r(e,Le,s),r(e,B,s),r(e,L,s),r(e,G,s),r(e,z,s),r(e,W,s),r(e,ue,s),r(e,Ce,s),r(e,O,s),r(e,fe,s),r(e,Oe,s),b(j,e,s),r(e,ne,s),r(e,_e,s),r(e,ot,s),b(ye,e,s),r(e,Q,s),b(A,e,s),r(e,oe,s),b(se,e,s),r(e,C,s),b(S,e,s),r(e,Qe,s),b(V,e,s),r(e,st,s),b(be,e,s),r(e,Te,s),r(e,Pe,s),r(e,we,s),b(xe,e,s),r(e,Ae,s),r(e,X,s),r(e,Ye,s),r(e,E,s),r(e,De,s),b(J,e,s),r(e,ae,s),b(ve,e,s),r(e,Me,s),r(e,je,s),r(e,Y,s),r(e,D,s),r(e,Be,s),b(P,e,s),r(e,re,s),r(e,F,s),b(R,F,null),m(F,mt),m(F,ze),m(F,ut),m(F,Fe),m(F,ft),b(ie,F,null),r(e,I,s),b(Z,e,s),r(e,Ke,s),r(e,le,s),at=!0},p(e,[s]){const q={};s&2&&(q.$$scope={dirty:s,ctx:e}),A.$set(q);const ke={};s&2&&(ke.$$scope={dirty:s,ctx:e}),ie.$set(ke);const rt={};s&2&&(rt.$$scope={dirty:s,ctx:e}),Z.$set(rt)},i(e){at||(T(M.$$.fragment,e),T(k.$$.fragment,e),T(x.$$.fragment,e),T(j.$$.fragment,e),T(ye.$$.fragment,e),T(A.$$.fragment,e),T(se.$$.fragment,e),T(S.$$.fragment,e),T(V.$$.fragment,e),T(be.$$.fragment,e),T(xe.$$.fragment,e),T(J.$$.fragment,e),T(ve.$$.fragment,e),T(P.$$.fragment,e),T(R.$$.fragment,e),T(ie.$$.fragment,e),T(Z.$$.fragment,e),at=!0)},o(e){w(M.$$.fragment,e),w(k.$$.fragment,e),w(x.$$.fragment,e),w(j.$$.fragment,e),w(ye.$$.fragment,e),w(A.$$.fragment,e),w(se.$$.fragment,e),w(S.$$.fragment,e),w(V.$$.fragment,e),w(be.$$.fragment,e),w(xe.$$.fragment,e),w(J.$$.fragment,e),w(ve.$$.fragment,e),w(P.$$.fragment,e),w(R.$$.fragment,e),w(ie.$$.fragment,e),w(Z.$$.fragment,e),at=!1},d(e){e&&(n(f),n(a),n(c),n(d),n(Xe),n(H),n(Ee),n(N),n(Re),n(te),n(pe),n(tt),n(he),n(Le),n(B),n(L),n(G),n(z),n(W),n(ue),n(Ce),n(O),n(fe),n(Oe),n(ne),n(_e),n(ot),n(Q),n(oe),n(C),n(Qe),n(st),n(Te),n(Pe),n(we),n(Ae),n(X),n(Ye),n(E),n(De),n(ae),n(Me),n(je),n(Y),n(D),n(Be),n(re),n(F),n(I),n(Ke),n(le)),n(t),v(M,e),v(k,e),v(x,e),v(j,e),v(ye,e),v(A,e),v(se,e),v(S,e),v(V,e),v(be,e),v(xe,e),v(J,e),v(ve,e),v(P,e),v(R),v(ie),v(Z,e)}}}const Ht='{"title":"Phi","local":"phi","sections":[{"title":"Overview","local":"overview","sections":[{"title":"Summary","local":"summary","sections":[],"depth":3}],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[],"depth":2},{"title":"How to use Phi-2","local":"how-to-use-phi-2","sections":[{"title":"Example :","local":"example-","sections":[],"depth":3}],"depth":2},{"title":"Combining Phi and Flash Attention 2","local":"combining-phi-and-flash-attention-2","sections":[{"title":"Expected speedups","local":"expected-speedups","sections":[],"depth":3}],"depth":2},{"title":"PhiConfig","local":"transformers.PhiConfig","sections":[],"depth":2},{"title":"PhiModel","local":"transformers.PhiModel","sections":[],"depth":2},{"title":"PhiForCausalLM","local":"transformers.PhiForCausalLM","sections":[],"depth":2},{"title":"PhiForSequenceClassification","local":"transformers.PhiForSequenceClassification","sections":[],"depth":2},{"title":"PhiForTokenClassification","local":"transformers.PhiForTokenClassification","sections":[],"depth":2}],"depth":1}';function Nt($){return Mt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Dt extends kt{constructor(t){super(),$t(this,t,Nt,qt,vt,{})}}export{Dt as component};
